<?php
// This file was auto-generated from sdk-root/src/data/appconfigdata/2021-11-11/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>AppConfig Data provides the data plane APIs your application uses to retrieve configuration data. Here\'s how it works:</p> <p>Your application retrieves configuration data by first establishing a configuration session using the AppConfig Data <a>StartConfigurationSession</a> API action. Your session\'s client then makes periodic calls to <a>GetLatestConfiguration</a> to check for and retrieve the latest data available.</p> <p>When calling <code>StartConfigurationSession</code>, your code sends the following information:</p> <ul> <li> <p>Identifiers (ID or name) of an AppConfig application, environment, and configuration profile that the session tracks.</p> </li> <li> <p>(Optional) The minimum amount of time the session\'s client must wait between calls to <code>GetLatestConfiguration</code>.</p> </li> </ul> <p>In response, AppConfig provides an <code>InitialConfigurationToken</code> to be given to the session\'s client and used the first time it calls <code>GetLatestConfiguration</code> for that session.</p> <important> <p>This token should only be used once in your first call to <code>GetLatestConfiguration</code>. You <i>must</i> use the new token in the <code>GetLatestConfiguration</code> response (<code>NextPollConfigurationToken</code>) in each subsequent call to <code>GetLatestConfiguration</code>.</p> </important> <p>When calling <code>GetLatestConfiguration</code>, your client code sends the most recent <code>ConfigurationToken</code> value it has and receives in response:</p> <ul> <li> <p> <code>NextPollConfigurationToken</code>: the <code>ConfigurationToken</code> value to use on the next call to <code>GetLatestConfiguration</code>.</p> </li> <li> <p> <code>NextPollIntervalInSeconds</code>: the duration the client should wait before making its next call to <code>GetLatestConfiguration</code>. This duration may vary over the course of the session, so it should be used instead of the value sent on the <code>StartConfigurationSession</code> call.</p> </li> <li> <p>The configuration: the latest data intended for the session. This may be empty if the client already has the latest version of the configuration.</p> </li> </ul> <important> <p>The <code>InitialConfigurationToken</code> and <code>NextPollConfigurationToken</code> should only be used once. To support long poll use cases, the tokens are valid for up to 24 hours. If a <code>GetLatestConfiguration</code> call uses an expired token, the system returns <code>BadRequestException</code>.</p> </important> <p>For more information and to view example CLI commands that show how to retrieve a configuration using the AppConfig Data <code>StartConfigurationSession</code> and <code>GetLatestConfiguration</code> API actions, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration">Retrieving the configuration</a> in the <i>AppConfig User Guide</i>.</p>', 'operations' => [ 'GetLatestConfiguration' => '<p>Retrieves the latest deployed configuration. This API may return empty configuration data if the client already has the latest version. For more information about this API action and to view example CLI commands that show how to use it with the <a>StartConfigurationSession</a> API action, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration">Retrieving the configuration</a> in the <i>AppConfig User Guide</i>. </p> <important> <p>Note the following important information.</p> <ul> <li> <p>Each configuration token is only valid for one call to <code>GetLatestConfiguration</code>. The <code>GetLatestConfiguration</code> response includes a <code>NextPollConfigurationToken</code> that should always replace the token used for the just-completed call in preparation for the next one. </p> </li> <li> <p> <code>GetLatestConfiguration</code> is a priced call. For more information, see <a href="https://aws.amazon.com/systems-manager/pricing/">Pricing</a>.</p> </li> </ul> </important>', 'StartConfigurationSession' => '<p>Starts a configuration session used to retrieve a deployed configuration. For more information about this API action and to view example CLI commands that show how to use it with the <a>GetLatestConfiguration</a> API action, see <a href="http://docs.aws.amazon.com/appconfig/latest/userguide/appconfig-retrieving-the-configuration">Retrieving the configuration</a> in the <i>AppConfig User Guide</i>. </p>', ], 'shapes' => [ 'BadRequestDetails' => [ 'base' => '<p>Detailed information about the input that failed to satisfy the constraints specified by a call.</p>', 'refs' => [ 'BadRequestException$Details' => '<p>Details describing why the request was invalid.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by the service.</p>', 'refs' => [], ], 'BadRequestReason' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Reason' => '<p>Code indicating the reason the request was invalid.</p>', ], ], 'GetLatestConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLatestConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'StartConfigurationSessionRequest$ApplicationIdentifier' => '<p>The application ID or the application name.</p>', 'StartConfigurationSessionRequest$EnvironmentIdentifier' => '<p>The environment ID or the environment name.</p>', 'StartConfigurationSessionRequest$ConfigurationProfileIdentifier' => '<p>The configuration profile ID or the configuration profile name.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'GetLatestConfigurationResponse$NextPollIntervalInSeconds' => '<p>The amount of time the client should wait before polling for configuration updates again. Use <code>RequiredMinimumPollIntervalInSeconds</code> to set the desired poll interval.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>There was an internal failure in the service.</p>', 'refs' => [], ], 'InvalidParameterDetail' => [ 'base' => '<p>Information about an invalid parameter.</p>', 'refs' => [ 'InvalidParameterMap$value' => NULL, ], ], 'InvalidParameterMap' => [ 'base' => NULL, 'refs' => [ 'BadRequestDetails$InvalidParameters' => '<p>One or more specified parameters are not valid for the call.</p>', ], ], 'InvalidParameterProblem' => [ 'base' => NULL, 'refs' => [ 'InvalidParameterDetail$Problem' => '<p>The reason the parameter is invalid.</p>', ], ], 'OptionalPollSeconds' => [ 'base' => NULL, 'refs' => [ 'StartConfigurationSessionRequest$RequiredMinimumPollIntervalInSeconds' => '<p>Sets a constraint on a session. If you specify a value of, for example, 60 seconds, then the client that established the session can\'t call <a>GetLatestConfiguration</a> more frequently than every 60 seconds.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The requested resource could not be found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$ResourceType' => '<p>The type of resource that was not found.</p>', ], ], 'SensitiveBlob' => [ 'base' => NULL, 'refs' => [ 'GetLatestConfigurationResponse$Configuration' => '<p>The data of the configuration. This may be empty if the client already has the latest version of configuration.</p>', ], ], 'StartConfigurationSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartConfigurationSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Message' => NULL, 'GetLatestConfigurationResponse$ContentType' => '<p>A standard MIME type describing the format of the configuration content.</p>', 'GetLatestConfigurationResponse$VersionLabel' => '<p>The user-defined label for the AppConfig hosted configuration version. This attribute doesn\'t apply if the configuration is not from an AppConfig hosted configuration version. If the client already has the latest version of the configuration data, this value is empty.</p>', 'InternalServerException$Message' => NULL, 'InvalidParameterMap$key' => NULL, 'ResourceNotFoundException$Message' => NULL, 'StringMap$key' => NULL, 'StringMap$value' => NULL, 'ThrottlingException$Message' => NULL, ], ], 'StringMap' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$ReferencedBy' => '<p>A map indicating which parameters in the request reference the resource that was not found.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'GetLatestConfigurationRequest$ConfigurationToken' => '<p>Token describing the current state of the configuration session. To obtain a token, first call the <a>StartConfigurationSession</a> API. Note that every call to <code>GetLatestConfiguration</code> will return a new <code>ConfigurationToken</code> (<code>NextPollConfigurationToken</code> in the response) and <i>must</i> be provided to subsequent <code>GetLatestConfiguration</code> API calls.</p> <important> <p>This token should only be used once. To support long poll use cases, the token is valid for up to 24 hours. If a <code>GetLatestConfiguration</code> call uses an expired token, the system returns <code>BadRequestException</code>.</p> </important>', 'GetLatestConfigurationResponse$NextPollConfigurationToken' => '<p>The latest token describing the current state of the configuration session. This <i>must</i> be provided to the next call to <code>GetLatestConfiguration.</code> </p> <important> <p>This token should only be used once. To support long poll use cases, the token is valid for up to 24 hours. If a <code>GetLatestConfiguration</code> call uses an expired token, the system returns <code>BadRequestException</code>.</p> </important>', 'StartConfigurationSessionResponse$InitialConfigurationToken' => '<p>Token encapsulating state about the configuration session. Provide this token to the <code>GetLatestConfiguration</code> API to retrieve configuration data.</p> <important> <p>This token should only be used once in your first call to <code>GetLatestConfiguration</code>. You <i>must</i> use the new token in the <code>GetLatestConfiguration</code> response (<code>NextPollConfigurationToken</code>) in each subsequent call to <code>GetLatestConfiguration</code>.</p> <p>The <code>InitialConfigurationToken</code> and <code>NextPollConfigurationToken</code> should only be used once. To support long poll use cases, the tokens are valid for up to 24 hours. If a <code>GetLatestConfiguration</code> call uses an expired token, the system returns <code>BadRequestException</code>.</p> </important>', ], ], ],];
