<?php
// This file was auto-generated from sdk-root/src/data/b2bi/2022-06-23/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is the <i>Amazon Web Services B2B Data Interchange API Reference</i>. It provides descriptions, API request parameters, and the XML response for each of the B2BI API actions.</p> <p>B2BI enables automated exchange of EDI (electronic data interchange) based business-critical transactions at cloud scale, with elasticity and pay-as-you-go pricing. Businesses use EDI documents to exchange transactional data with trading partners, such as suppliers and end customers, using standardized formats such as X12.</p> <note> <p>Rather than actually running a command, you can use the <code>--generate-cli-skeleton</code> parameter with any API call to generate and display a parameter template. You can then use the generated template to customize and use as input on a later command. For details, see <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-skeleton.html#cli-usage-skeleton-generate">Generate and use a parameter skeleton file</a>.</p> </note>', 'operations' => [ 'CreateCapability' => '<p>Instantiates a capability based on the specified parameters. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.</p>', 'CreatePartnership' => '<p>Creates a partnership between a customer and a trading partner, based on the supplied parameters. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.</p>', 'CreateProfile' => '<p>Creates a customer profile. You can have up to five customer profiles, each representing a distinct private network. A profile is the mechanism used to create the concept of a private network.</p>', 'CreateTransformer' => '<p>Creates a transformer. A transformer describes how to process the incoming EDI documents and extract the necessary information to the output file.</p>', 'DeleteCapability' => '<p>Deletes the specified capability. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.</p>', 'DeletePartnership' => '<p>Deletes the specified partnership. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.</p>', 'DeleteProfile' => '<p>Deletes the specified profile. A profile is the mechanism used to create the concept of a private network.</p>', 'DeleteTransformer' => '<p>Deletes the specified transformer. A transformer describes how to process the incoming EDI documents and extract the necessary information to the output file.</p>', 'GetCapability' => '<p>Retrieves the details for the specified capability. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.</p>', 'GetPartnership' => '<p>Retrieves the details for a partnership, based on the partner and profile IDs specified. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.</p>', 'GetProfile' => '<p>Retrieves the details for the profile specified by the profile ID. A profile is the mechanism used to create the concept of a private network.</p>', 'GetTransformer' => '<p>Retrieves the details for the transformer specified by the transformer ID. A transformer describes how to process the incoming EDI documents and extract the necessary information to the output file.</p>', 'GetTransformerJob' => '<p>Returns the details of the transformer run, based on the Transformer job ID.</p>', 'ListCapabilities' => '<p>Lists the capabilities associated with your Amazon Web Services account for your current or specified region. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.</p>', 'ListPartnerships' => '<p>Lists the partnerships associated with your Amazon Web Services account for your current or specified region. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.</p>', 'ListProfiles' => '<p>Lists the profiles associated with your Amazon Web Services account for your current or specified region. A profile is the mechanism used to create the concept of a private network.</p>', 'ListTagsForResource' => '<p>Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a capability, partnership, profile, or transformer.</p>', 'ListTransformers' => '<p>Lists the available transformers. A transformer describes how to process the incoming EDI documents and extract the necessary information to the output file.</p>', 'StartTransformerJob' => '<p>Runs a job, using a transformer, to parse input EDI (electronic data interchange) file into the output structures used by Amazon Web Services B2BI Data Interchange.</p> <p>If you only want to transform EDI (electronic data interchange) documents, you don\'t need to create profiles, partnerships or capabilities. Just create and configure a transformer, and then run the <code>StartTransformerJob</code> API to process your files.</p>', 'TagResource' => '<p>Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are capability, partnership, profile, transformers and other entities.</p> <p>There is no response returned from this call.</p>', 'TestMapping' => '<p>Maps the input file according to the provided template file. The API call downloads the file contents from the Amazon S3 location, and passes the contents in as a string, to the <code>inputFileContent</code> parameter.</p>', 'TestParsing' => '<p>Parses the input EDI (electronic data interchange) file. The input file has a file size limit of 250 KB.</p>', 'UntagResource' => '<p>Detaches a key-value pair from the specified resource, as identified by its Amazon Resource Name (ARN). Resources are capability, partnership, profile, transformers and other entities.</p>', 'UpdateCapability' => '<p>Updates some of the parameters for a capability, based on the specified parameters. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.</p>', 'UpdatePartnership' => '<p>Updates some of the parameters for a partnership between a customer and trading partner. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.</p>', 'UpdateProfile' => '<p>Updates the specified parameters for a profile. A profile is the mechanism used to create the concept of a private network.</p>', 'UpdateTransformer' => '<p>Updates the specified parameters for a transformer. A transformer describes how to process the incoming EDI documents and extract the necessary information to the output file.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p>Requests the tags associated with a particular Amazon Resource Name (ARN). An ARN is an identifier for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', 'TagResourceRequest$ResourceARN' => '<p>Specifies an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', 'UntagResourceRequest$ResourceARN' => '<p>Specifies an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'S3Location$bucketName' => '<p>Specifies the name of the Amazon S3 bucket.</p>', ], ], 'BusinessName' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$businessName' => '<p>Specifies the name for the business associated with this profile.</p>', 'CreateProfileResponse$businessName' => '<p>Returns the name for the business associated with this profile.</p>', 'GetProfileResponse$businessName' => '<p>Returns the name for the business associated with this profile.</p>', 'ProfileSummary$businessName' => '<p>Returns the name for the business associated with this profile.</p>', 'UpdateProfileRequest$businessName' => '<p>Specifies the name for the business associated with this profile.</p>', 'UpdateProfileResponse$businessName' => '<p>Returns the name for the business associated with this profile.</p>', ], ], 'CapabilityConfiguration' => [ 'base' => '<p>A capability object. Currently, only EDI (electronic data interchange) capabilities are supported. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.</p>', 'refs' => [ 'CreateCapabilityRequest$configuration' => '<p>Specifies a structure that contains the details for a capability.</p>', 'CreateCapabilityResponse$configuration' => '<p>Returns a structure that contains the details for a capability.</p>', 'GetCapabilityResponse$configuration' => '<p>Returns a structure that contains the details for a capability.</p>', 'UpdateCapabilityRequest$configuration' => '<p>Specifies a structure that contains the details for a capability.</p>', 'UpdateCapabilityResponse$configuration' => '<p>Returns a structure that contains the details for a capability.</p>', ], ], 'CapabilityId' => [ 'base' => NULL, 'refs' => [ 'CapabilitySummary$capabilityId' => '<p>Returns a system-assigned unique identifier for the capability.</p>', 'CreateCapabilityResponse$capabilityId' => '<p>Returns a system-assigned unique identifier for the capability.</p>', 'DeleteCapabilityRequest$capabilityId' => '<p>Specifies a system-assigned unique identifier for the capability.</p>', 'GetCapabilityRequest$capabilityId' => '<p>Specifies a system-assigned unique identifier for the capability.</p>', 'GetCapabilityResponse$capabilityId' => '<p>Returns a system-assigned unique identifier for the capability.</p>', 'PartnershipCapabilities$member' => NULL, 'UpdateCapabilityRequest$capabilityId' => '<p>Specifies a system-assigned unique identifier for the capability.</p>', 'UpdateCapabilityResponse$capabilityId' => '<p>Returns a system-assigned unique identifier for the capability.</p>', ], ], 'CapabilityList' => [ 'base' => NULL, 'refs' => [ 'ListCapabilitiesResponse$capabilities' => '<p>Returns one or more capabilities associated with this partnership.</p>', ], ], 'CapabilityName' => [ 'base' => NULL, 'refs' => [ 'CapabilitySummary$name' => '<p>The display name of the capability.</p>', 'CreateCapabilityRequest$name' => '<p>Specifies the name of the capability, used to identify it.</p>', 'CreateCapabilityResponse$name' => '<p>Returns the name of the capability used to identify it.</p>', 'GetCapabilityResponse$name' => '<p>Returns the name of the capability, used to identify it.</p>', 'UpdateCapabilityRequest$name' => '<p>Specifies a new name for the capability, to replace the existing name.</p>', 'UpdateCapabilityResponse$name' => '<p>Returns the name of the capability, used to identify it.</p>', ], ], 'CapabilitySummary' => [ 'base' => '<p>Returns the capability summary details. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.</p>', 'refs' => [ 'CapabilityList$member' => NULL, ], ], 'CapabilityType' => [ 'base' => NULL, 'refs' => [ 'CapabilitySummary$type' => '<p>Returns the type of the capability. Currently, only <code>edi</code> is supported.</p>', 'CreateCapabilityRequest$type' => '<p>Specifies the type of the capability. Currently, only <code>edi</code> is supported.</p>', 'CreateCapabilityResponse$type' => '<p>Returns the type of the capability. Currently, only <code>edi</code> is supported.</p>', 'GetCapabilityResponse$type' => '<p>Returns the type of the capability. Currently, only <code>edi</code> is supported.</p>', 'UpdateCapabilityResponse$type' => '<p>Returns the type of the capability. Currently, only <code>edi</code> is supported.</p>', ], ], 'ConflictException' => [ 'base' => '<p>A conflict exception is thrown when you attempt to delete a resource (such as a profile or a capability) that is being used by other resources.</p>', 'refs' => [], ], 'CreateCapabilityRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCapabilityResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePartnershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePartnershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransformerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTransformerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatedDate' => [ 'base' => NULL, 'refs' => [ 'CapabilitySummary$createdAt' => '<p>Returns a timestamp for creation date and time of the capability.</p>', 'CreateCapabilityResponse$createdAt' => '<p>Returns a timestamp for creation date and time of the capability.</p>', 'CreatePartnershipResponse$createdAt' => '<p>Returns a timestamp for creation date and time of the partnership.</p>', 'CreateProfileResponse$createdAt' => '<p>Returns a timestamp representing the time the profile was created.</p>', 'CreateTransformerResponse$createdAt' => '<p>Returns a timestamp for creation date and time of the transformer.</p>', 'GetCapabilityResponse$createdAt' => '<p>Returns a timestamp for creation date and time of the capability.</p>', 'GetPartnershipResponse$createdAt' => '<p>Returns a timestamp for creation date and time of the partnership.</p>', 'GetProfileResponse$createdAt' => '<p>Returns a timestamp for creation date and time of the transformer.</p>', 'GetTransformerResponse$createdAt' => '<p>Returns a timestamp for creation date and time of the transformer.</p>', 'PartnershipSummary$createdAt' => '<p>Returns a timestamp for creation date and time of the partnership.</p>', 'ProfileSummary$createdAt' => '<p>Returns the timestamp for creation date and time of the profile.</p>', 'TransformerSummary$createdAt' => '<p>Returns a timestamp indicating when the transformer was created. For example, <code>2023-07-20T19:58:44.624Z</code>.</p>', 'UpdateCapabilityResponse$createdAt' => '<p>Returns a timestamp for creation date and time of the capability.</p>', 'UpdatePartnershipResponse$createdAt' => '<p>Returns a timestamp that identifies the most recent date and time that the partnership was modified.</p>', 'UpdateProfileResponse$createdAt' => '<p>Returns a timestamp for creation date and time of the profile.</p>', 'UpdateTransformerResponse$createdAt' => '<p>Returns a timestamp for creation date and time of the transformer.</p>', ], ], 'DeleteCapabilityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePartnershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTransformerRequest' => [ 'base' => NULL, 'refs' => [], ], 'EdiConfiguration' => [ 'base' => '<p>Specifies the details for the EDI (electronic data interchange) transformation.</p>', 'refs' => [ 'CapabilityConfiguration$edi' => '<p>An EDI (electronic data interchange) configuration object.</p>', ], ], 'EdiType' => [ 'base' => '<p>Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.</p>', 'refs' => [ 'CreateTransformerRequest$ediType' => '<p>Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.</p>', 'CreateTransformerResponse$ediType' => '<p>Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.</p>', 'EdiConfiguration$type' => '<p>Returns the type of the capability. Currently, only <code>edi</code> is supported.</p>', 'GetTransformerResponse$ediType' => '<p>Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.</p>', 'TestParsingRequest$ediType' => '<p>Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.</p>', 'TransformerSummary$ediType' => '<p>Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.</p>', 'UpdateTransformerRequest$ediType' => '<p>Specifies the details for the EDI standard that is being used for the transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.</p>', 'UpdateTransformerResponse$ediType' => '<p>Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.</p>', ], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'CreatePartnershipRequest$email' => '<p>Specifies the email address associated with this trading partner.</p>', 'CreatePartnershipResponse$email' => '<p>Returns the email address associated with this trading partner.</p>', 'CreateProfileRequest$email' => '<p>Specifies the email address associated with this customer profile.</p>', 'CreateProfileResponse$email' => '<p>Returns the email address associated with this customer profile.</p>', 'GetPartnershipResponse$email' => '<p>Returns the email address associated with this trading partner.</p>', 'GetProfileResponse$email' => '<p>Returns the email address associated with this customer profile.</p>', 'UpdatePartnershipResponse$email' => '<p>Returns the email address associated with this trading partner.</p>', 'UpdateProfileRequest$email' => '<p>Specifies the email address associated with this customer profile.</p>', 'UpdateProfileResponse$email' => '<p>Returns the email address associated with this customer profile.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$Message' => NULL, ], ], 'FileFormat' => [ 'base' => NULL, 'refs' => [ 'CreateTransformerRequest$fileFormat' => '<p>Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and <code>XML</code>.</p>', 'CreateTransformerResponse$fileFormat' => '<p>Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and <code>XML</code>.</p>', 'GetTransformerResponse$fileFormat' => '<p>Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and <code>XML</code>.</p>', 'TestMappingRequest$fileFormat' => '<p>Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and <code>XML</code>.</p>', 'TestParsingRequest$fileFormat' => '<p>Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and <code>XML</code>.</p>', 'TransformerSummary$fileFormat' => '<p>Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and <code>XML</code>.</p>', 'UpdateTransformerRequest$fileFormat' => '<p>Specifies that the currently supported file formats for EDI transformations are <code>JSON</code> and <code>XML</code>.</p>', 'UpdateTransformerResponse$fileFormat' => '<p>Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and <code>XML</code>.</p>', ], ], 'FileLocation' => [ 'base' => NULL, 'refs' => [ 'CreateTransformerRequest$sampleDocument' => '<p>Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.</p>', 'CreateTransformerResponse$sampleDocument' => '<p>Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.</p>', 'GetTransformerResponse$sampleDocument' => '<p>Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.</p>', 'TransformerSummary$sampleDocument' => '<p>Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.</p>', 'UpdateTransformerRequest$sampleDocument' => '<p>Specifies a sample EDI document that is used by a transformer as a guide for processing the EDI data.</p>', 'UpdateTransformerResponse$sampleDocument' => '<p>Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.</p>', ], ], 'GetCapabilityRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCapabilityResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPartnershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPartnershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTransformerJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTransformerJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTransformerRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTransformerResponse' => [ 'base' => NULL, 'refs' => [], ], 'InstructionsDocuments' => [ 'base' => NULL, 'refs' => [ 'CreateCapabilityRequest$instructionsDocuments' => '<p>Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with this capability. Each item contains the name of the bucket and the key, to identify the document\'s location.</p>', 'CreateCapabilityResponse$instructionsDocuments' => '<p>Returns one or more locations in Amazon S3, each specifying an EDI document that can be used with this capability. Each item contains the name of the bucket and the key, to identify the document\'s location.</p>', 'GetCapabilityResponse$instructionsDocuments' => '<p>Returns one or more locations in Amazon S3, each specifying an EDI document that can be used with this capability. Each item contains the name of the bucket and the key, to identify the document\'s location.</p>', 'UpdateCapabilityRequest$instructionsDocuments' => '<p>Specifies one or more locations in Amazon S3, each specifying an EDI document that can be used with this capability. Each item contains the name of the bucket and the key, to identify the document\'s location.</p>', 'UpdateCapabilityResponse$instructionsDocuments' => '<p>Returns one or more locations in Amazon S3, each specifying an EDI document that can be used with this capability. Each item contains the name of the bucket and the key, to identify the document\'s location.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$retryAfterSeconds' => '<p>The server attempts to retry a failed command.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The server attempts to retry a command that was throttled.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>This exception is thrown when an error occurs in the Amazon Web Services B2B Data Interchange service.</p>', 'refs' => [], ], 'ListCapabilitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCapabilitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPartnershipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPartnershipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTransformersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTransformersResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateProfileResponse$logGroupName' => '<p>Returns the name of the logging group.</p>', 'GetProfileResponse$logGroupName' => '<p>Returns the name of the logging group.</p>', 'ProfileSummary$logGroupName' => '<p>Returns the name of the logging group.</p>', 'UpdateProfileResponse$logGroupName' => '<p>Returns the name of the logging group.</p>', ], ], 'Logging' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$logging' => '<p>Specifies whether or not logging is enabled for this profile.</p>', 'CreateProfileResponse$logging' => '<p>Returns whether or not logging is turned on for this profile.</p>', 'GetProfileResponse$logging' => '<p>Returns whether or not logging is enabled for this profile.</p>', 'ProfileSummary$logging' => '<p>Specifies whether or not logging is enabled for this profile.</p>', 'UpdateProfileResponse$logging' => '<p>Specifies whether or not logging is enabled for this profile.</p>', ], ], 'MappingTemplate' => [ 'base' => NULL, 'refs' => [ 'CreateTransformerRequest$mappingTemplate' => '<p>Specifies the mapping template for the transformer. This template is used to map the parsed EDI file using JSONata or XSLT.</p>', 'CreateTransformerResponse$mappingTemplate' => '<p>Returns the mapping template for the transformer. This template is used to map the parsed EDI file using JSONata or XSLT.</p>', 'GetTransformerResponse$mappingTemplate' => '<p>Returns the mapping template for the transformer. This template is used to map the parsed EDI file using JSONata or XSLT.</p>', 'TestMappingRequest$mappingTemplate' => '<p>Specifies the mapping template for the transformer. This template is used to map the parsed EDI file using JSONata or XSLT.</p>', 'TransformerSummary$mappingTemplate' => '<p>Returns the mapping template for the transformer. This template is used to map the parsed EDI file using JSONata or XSLT.</p>', 'UpdateTransformerRequest$mappingTemplate' => '<p>Specifies the mapping template for the transformer. This template is used to map the parsed EDI file using JSONata or XSLT.</p>', 'UpdateTransformerResponse$mappingTemplate' => '<p>Returns the mapping template for the transformer. This template is used to map the parsed EDI file using JSONata or XSLT.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCapabilitiesRequest$maxResults' => '<p>Specifies the maximum number of capabilities to return.</p>', 'ListPartnershipsRequest$maxResults' => '<p>Specifies the maximum number of capabilities to return.</p>', 'ListProfilesRequest$maxResults' => '<p>Specifies the maximum number of profiles to return.</p>', 'ListTransformersRequest$maxResults' => '<p>Specifies the number of items to return for the API response.</p>', ], ], 'ModifiedDate' => [ 'base' => NULL, 'refs' => [ 'CapabilitySummary$modifiedAt' => '<p>Returns a timestamp that identifies the most recent date and time that the capability was modified.</p>', 'GetCapabilityResponse$modifiedAt' => '<p>Returns a timestamp for last time the capability was modified.</p>', 'GetPartnershipResponse$modifiedAt' => '<p>Returns a timestamp that identifies the most recent date and time that the partnership was modified.</p>', 'GetProfileResponse$modifiedAt' => '<p>Returns a timestamp for last time the profile was modified.</p>', 'GetTransformerResponse$modifiedAt' => '<p>Returns a timestamp for last time the transformer was modified.</p>', 'PartnershipSummary$modifiedAt' => '<p>Returns a timestamp that identifies the most recent date and time that the partnership was modified.</p>', 'ProfileSummary$modifiedAt' => '<p>Returns the timestamp that identifies the most recent date and time that the profile was modified.</p>', 'TransformerSummary$modifiedAt' => '<p>Returns a timestamp representing the date and time for the most recent change for the transformer object.</p>', 'UpdateCapabilityResponse$modifiedAt' => '<p>Returns a timestamp for last time the capability was modified.</p>', 'UpdatePartnershipResponse$modifiedAt' => '<p>Returns a timestamp that identifies the most recent date and time that the partnership was modified.</p>', 'UpdateProfileResponse$modifiedAt' => '<p>Returns a timestamp for last time the profile was modified.</p>', 'UpdateTransformerResponse$modifiedAt' => '<p>Returns a timestamp for last time the transformer was modified.</p>', ], ], 'PageToken' => [ 'base' => NULL, 'refs' => [ 'ListCapabilitiesRequest$nextToken' => '<p>When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional resources.</p>', 'ListCapabilitiesResponse$nextToken' => '<p>When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional resources.</p>', 'ListPartnershipsRequest$nextToken' => '<p>When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional resources.</p>', 'ListPartnershipsResponse$nextToken' => '<p>When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional resources.</p>', 'ListProfilesRequest$nextToken' => '<p>When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional resources.</p>', 'ListProfilesResponse$nextToken' => '<p>When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional resources.</p>', 'ListTransformersRequest$nextToken' => '<p>When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional resources.</p>', 'ListTransformersResponse$nextToken' => '<p>When additional results are obtained from the command, a <code>NextToken</code> parameter is returned in the output. You can then pass the <code>NextToken</code> parameter in a subsequent command to continue listing additional resources.</p>', ], ], 'PartnerName' => [ 'base' => NULL, 'refs' => [ 'CreatePartnershipRequest$name' => '<p>Specifies a descriptive name for the partnership.</p>', 'CreatePartnershipResponse$name' => '<p>Returns a descriptive name for the partnership.</p>', 'GetPartnershipResponse$name' => '<p>Returns the display name of the partnership</p>', 'PartnershipSummary$name' => '<p>Returns the name of the partnership.</p>', 'UpdatePartnershipRequest$name' => '<p>The name of the partnership, used to identify it.</p>', 'UpdatePartnershipResponse$name' => '<p>The name of the partnership, used to identify it.</p>', ], ], 'PartnershipCapabilities' => [ 'base' => NULL, 'refs' => [ 'CreatePartnershipRequest$capabilities' => '<p>Specifies a list of the capabilities associated with this partnership.</p>', 'CreatePartnershipResponse$capabilities' => '<p>Returns one or more capabilities associated with this partnership.</p>', 'GetPartnershipResponse$capabilities' => '<p>Returns one or more capabilities associated with this partnership.</p>', 'PartnershipSummary$capabilities' => '<p>Returns one or more capabilities associated with this partnership.</p>', 'UpdatePartnershipRequest$capabilities' => '<p>List of the capabilities associated with this partnership.</p>', 'UpdatePartnershipResponse$capabilities' => '<p>Returns one or more capabilities associated with this partnership.</p>', ], ], 'PartnershipId' => [ 'base' => NULL, 'refs' => [ 'CreatePartnershipResponse$partnershipId' => '<p>Returns the unique, system-generated identifier for a partnership.</p>', 'DeletePartnershipRequest$partnershipId' => '<p>Specifies the unique, system-generated identifier for a partnership.</p>', 'GetPartnershipRequest$partnershipId' => '<p>Specifies the unique, system-generated identifier for a partnership.</p>', 'GetPartnershipResponse$partnershipId' => '<p>Returns the unique, system-generated identifier for a partnership.</p>', 'PartnershipSummary$partnershipId' => '<p>Returns the unique, system-generated identifier for a partnership.</p>', 'UpdatePartnershipRequest$partnershipId' => '<p>Specifies the unique, system-generated identifier for a partnership.</p>', 'UpdatePartnershipResponse$partnershipId' => '<p>Returns the unique, system-generated identifier for a partnership.</p>', ], ], 'PartnershipList' => [ 'base' => NULL, 'refs' => [ 'ListPartnershipsResponse$partnerships' => '<p>Specifies a list of your partnerships.</p>', ], ], 'PartnershipSummary' => [ 'base' => '<p>A structure that contains the details for a partnership. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.</p>', 'refs' => [ 'PartnershipList$member' => NULL, ], ], 'Phone' => [ 'base' => NULL, 'refs' => [ 'CreatePartnershipRequest$phone' => '<p>Specifies the phone number associated with the partnership.</p>', 'CreatePartnershipResponse$phone' => '<p>Returns the phone number associated with the partnership.</p>', 'CreateProfileRequest$phone' => '<p>Specifies the phone number associated with the profile.</p>', 'CreateProfileResponse$phone' => '<p>Returns the phone number associated with the profile.</p>', 'GetPartnershipResponse$phone' => '<p>Returns the phone number associated with the partnership.</p>', 'GetProfileResponse$phone' => '<p>Returns the phone number associated with the profile.</p>', 'UpdatePartnershipResponse$phone' => '<p>Returns the phone number associated with the partnership.</p>', 'UpdateProfileRequest$phone' => '<p>Specifies the phone number associated with the profile.</p>', 'UpdateProfileResponse$phone' => '<p>Returns the phone number associated with the profile.</p>', ], ], 'ProfileId' => [ 'base' => NULL, 'refs' => [ 'CreatePartnershipRequest$profileId' => '<p>Specifies the unique, system-generated identifier for the profile connected to this partnership.</p>', 'CreatePartnershipResponse$profileId' => '<p>Returns the unique, system-generated identifier for the profile connected to this partnership.</p>', 'CreateProfileResponse$profileId' => '<p>Returns the unique, system-generated identifier for the profile.</p>', 'DeleteProfileRequest$profileId' => '<p>Specifies the unique, system-generated identifier for the profile.</p>', 'GetPartnershipResponse$profileId' => '<p>Returns the unique, system-generated identifier for the profile connected to this partnership.</p>', 'GetProfileRequest$profileId' => '<p>Specifies the unique, system-generated identifier for the profile.</p>', 'GetProfileResponse$profileId' => '<p>Returns the unique, system-generated identifier for the profile.</p>', 'ListPartnershipsRequest$profileId' => '<p>Specifies the unique, system-generated identifier for the profile connected to this partnership.</p>', 'PartnershipSummary$profileId' => '<p>Returns the unique, system-generated identifier for the profile connected to this partnership.</p>', 'ProfileSummary$profileId' => '<p>Returns the unique, system-generated identifier for the profile.</p>', 'UpdatePartnershipResponse$profileId' => '<p>Returns the unique, system-generated identifier for the profile connected to this partnership.</p>', 'UpdateProfileRequest$profileId' => '<p>Specifies the unique, system-generated identifier for the profile.</p>', 'UpdateProfileResponse$profileId' => '<p>Returns the unique, system-generated identifier for the profile.</p>', ], ], 'ProfileList' => [ 'base' => NULL, 'refs' => [ 'ListProfilesResponse$profiles' => '<p>Returns an array of <code>ProfileSummary</code> objects.</p>', ], ], 'ProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$name' => '<p>Specifies the name of the profile.</p>', 'CreateProfileResponse$name' => '<p>Returns the name of the profile, used to identify it.</p>', 'GetProfileResponse$name' => '<p>Returns the name of the profile, used to identify it.</p>', 'ProfileSummary$name' => '<p>Returns the display name for profile.</p>', 'UpdateProfileRequest$name' => '<p>The name of the profile, used to identify it.</p>', 'UpdateProfileResponse$name' => '<p>Returns the name of the profile.</p>', ], ], 'ProfileSummary' => [ 'base' => '<p>Contains the details for a profile. A profile is the mechanism used to create the concept of a private network.</p>', 'refs' => [ 'ProfileList$member' => NULL, ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'CreateCapabilityResponse$capabilityArn' => '<p>Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', 'CreatePartnershipResponse$partnershipArn' => '<p>Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', 'CreateProfileResponse$profileArn' => '<p>Returns an Amazon Resource Name (ARN) for the profile.</p>', 'CreateTransformerResponse$transformerArn' => '<p>Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', 'GetCapabilityResponse$capabilityArn' => '<p>Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', 'GetPartnershipResponse$partnershipArn' => '<p>Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', 'GetProfileResponse$profileArn' => '<p>Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', 'GetTransformerResponse$transformerArn' => '<p>Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', 'UpdateCapabilityResponse$capabilityArn' => '<p>Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', 'UpdatePartnershipResponse$partnershipArn' => '<p>Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', 'UpdateProfileResponse$profileArn' => '<p>Returns an Amazon Resource Name (ARN) for the profile.</p>', 'UpdateTransformerResponse$transformerArn' => '<p>Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Occurs when the requested resource does not exist, or cannot be found. In some cases, the resource exists in a region other than the region specified in the API call.</p>', 'refs' => [], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'S3Location$key' => '<p>Specifies the Amazon S3 key for the file location.</p>', ], ], 'S3Location' => [ 'base' => '<p>Specifies the details for the Amazon S3 file location that is being used with Amazon Web Services B2BI Data Interchange. File locations in Amazon S3 are identified using a combination of the bucket and key.</p>', 'refs' => [ 'EdiConfiguration$inputLocation' => '<p>Contains the Amazon S3 bucket and prefix for the location of the input file, which is contained in an <code>S3Location</code> object.</p>', 'EdiConfiguration$outputLocation' => '<p>Contains the Amazon S3 bucket and prefix for the location of the output file, which is contained in an <code>S3Location</code> object.</p>', 'InstructionsDocuments$member' => NULL, 'S3LocationList$member' => NULL, 'StartTransformerJobRequest$inputFile' => '<p>Specifies the location of the input file for the transformation. The location consists of an Amazon S3 bucket and prefix.</p>', 'StartTransformerJobRequest$outputLocation' => '<p>Specifies the location of the output file for the transformation. The location consists of an Amazon S3 bucket and prefix.</p>', 'TestParsingRequest$inputFile' => '<p>Specifies an <code>S3Location</code> object, which contains the Amazon S3 bucket and prefix for the location of the input file.</p>', ], ], 'S3LocationList' => [ 'base' => NULL, 'refs' => [ 'GetTransformerJobResponse$outputFiles' => '<p>Returns the location for the output files. If the caller specified a directory for the output, then this contains the full path to the output file, including the file name generated by the service.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Occurs when the calling command attempts to exceed one of the service quotas, for example trying to create a capability when you already have the maximum number of capabilities allowed.</p>', 'refs' => [], ], 'StartTransformerJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTransformerJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'CreateCapabilityRequest$clientToken' => '<p>Reserved for future use.</p>', 'CreatePartnershipRequest$clientToken' => '<p>Reserved for future use.</p>', 'CreateProfileRequest$clientToken' => '<p>Reserved for future use.</p>', 'CreateTransformerRequest$clientToken' => '<p>Reserved for future use.</p>', 'GetTransformerJobResponse$message' => '<p>Returns an optional error message, which gets populated when the job is not run successfully.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>The ID for the resource that exceeded the quota, which caused the exception.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The resource type (profile, partnership, transformer, or capability) that exceeded the quota, which caused the exception.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>The code responsible for exceeding the quota, which caused the exception.</p>', 'ServiceQuotaExceededException$quotaCode' => '<p>The quota that was exceeded, which caused the exception.</p>', 'StartTransformerJobRequest$clientToken' => '<p>Reserved for future use.</p>', 'TestMappingResponse$mappedFileContent' => '<p>Returns a string for the mapping that can be used to identify the mapping. Similar to a fingerprint</p>', 'TestParsingResponse$parsedFileContent' => '<p>Returns the contents of the input file being tested, parsed according to the specified EDI (electronic data interchange) type.</p>', ], ], 'Tag' => [ 'base' => '<p>Creates a key-value pair for a specific resource. Tags are metadata that you can use to search for and group a resource for various purposes. You can apply tags to capabilities, partnerships, profiles and transformers. A tag key can take more than one value. For example, to group capabilities for accounting purposes, you might create a tag called <code>Group</code> and assign the values <code>Research</code> and <code>Accounting</code> to that group.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>Specifies the name assigned to the tag that you create.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateCapabilityRequest$tags' => '<p>Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.</p>', 'CreatePartnershipRequest$tags' => '<p>Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.</p>', 'CreateProfileRequest$tags' => '<p>Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.</p>', 'CreateTransformerRequest$tags' => '<p>Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Returns the key-value pairs assigned to ARNs that you can use to group and search for resources by type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.</p>', 'TagResourceRequest$Tags' => '<p>Specifies the key-value pairs assigned to ARNs that you can use to group and search for resources by type. You can attach this metadata to resources (capabilities, partnerships, and so on) for any purpose.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>Contains one or more values that you assigned to the key name that you create.</p>', ], ], 'TestMappingInputFileContent' => [ 'base' => NULL, 'refs' => [ 'TestMappingRequest$inputFileContent' => '<p>Specify the contents of the EDI (electronic data interchange) XML or JSON file that is used as input for the transform.</p>', ], ], 'TestMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'TestMappingResponse' => [ 'base' => NULL, 'refs' => [], ], 'TestParsingRequest' => [ 'base' => NULL, 'refs' => [], ], 'TestParsingResponse' => [ 'base' => NULL, 'refs' => [], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to throttling: the data speed and rendering may be limited depending on various parameters and conditions.</p>', 'refs' => [], ], 'TradingPartnerId' => [ 'base' => NULL, 'refs' => [ 'CreatePartnershipResponse$tradingPartnerId' => '<p>Returns the unique, system-generated identifier for a trading partner.</p>', 'GetPartnershipResponse$tradingPartnerId' => '<p>Returns the unique identifier for the partner for this partnership.</p>', 'PartnershipSummary$tradingPartnerId' => '<p>Returns the unique, system-generated identifier for a trading partner.</p>', 'UpdatePartnershipResponse$tradingPartnerId' => '<p>Returns the unique, system-generated identifier for a trading partner.</p>', ], ], 'TransformerId' => [ 'base' => NULL, 'refs' => [ 'CreateTransformerResponse$transformerId' => '<p>Returns the system-assigned unique identifier for the transformer.</p>', 'DeleteTransformerRequest$transformerId' => '<p>Specifies the system-assigned unique identifier for the transformer.</p>', 'EdiConfiguration$transformerId' => '<p>Returns the system-assigned unique identifier for the transformer.</p>', 'GetTransformerJobRequest$transformerId' => '<p>Specifies the system-assigned unique identifier for the transformer.</p>', 'GetTransformerRequest$transformerId' => '<p>Specifies the system-assigned unique identifier for the transformer.</p>', 'GetTransformerResponse$transformerId' => '<p>Returns the system-assigned unique identifier for the transformer.</p>', 'StartTransformerJobRequest$transformerId' => '<p>Specifies the system-assigned unique identifier for the transformer.</p>', 'TransformerSummary$transformerId' => '<p>Returns the system-assigned unique identifier for the transformer.</p>', 'UpdateTransformerRequest$transformerId' => '<p>Specifies the system-assigned unique identifier for the transformer.</p>', 'UpdateTransformerResponse$transformerId' => '<p>Returns the system-assigned unique identifier for the transformer.</p>', ], ], 'TransformerJobId' => [ 'base' => NULL, 'refs' => [ 'GetTransformerJobRequest$transformerJobId' => '<p>Specifies the unique, system-generated identifier for a transformer run.</p>', 'StartTransformerJobResponse$transformerJobId' => '<p>Returns the unique, system-generated identifier for a transformer run.</p>', ], ], 'TransformerJobStatus' => [ 'base' => NULL, 'refs' => [ 'GetTransformerJobResponse$status' => '<p>Returns the current state of the transformer job, either <code>running</code>, <code>succeeded</code>, or <code>failed</code>.</p>', ], ], 'TransformerList' => [ 'base' => NULL, 'refs' => [ 'ListTransformersResponse$transformers' => '<p>Returns an array of one or more transformer objects.</p> <p>For each transformer, a <code>TransformerSummary</code> object is returned. The <code>TransformerSummary</code> contains all the details for a specific transformer.</p>', ], ], 'TransformerName' => [ 'base' => NULL, 'refs' => [ 'CreateTransformerRequest$name' => '<p>Specifies the name of the transformer, used to identify it.</p>', 'CreateTransformerResponse$name' => '<p>Returns the name of the transformer, used to identify it.</p>', 'GetTransformerResponse$name' => '<p>Returns the name of the transformer, used to identify it.</p>', 'TransformerSummary$name' => '<p>Returns the descriptive name for the transformer.</p>', 'UpdateTransformerRequest$name' => '<p>Specify a new name for the transformer, if you want to update it.</p>', 'UpdateTransformerResponse$name' => '<p>Returns the name of the transformer.</p>', ], ], 'TransformerStatus' => [ 'base' => NULL, 'refs' => [ 'CreateTransformerResponse$status' => '<p>Returns the state of the newly created transformer. The transformer can be either <code>active</code> or <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.</p>', 'GetTransformerResponse$status' => '<p>Returns the state of the newly created transformer. The transformer can be either <code>active</code> or <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.</p>', 'TransformerSummary$status' => '<p>Returns the state of the newly created transformer. The transformer can be either <code>active</code> or <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.</p>', 'UpdateTransformerRequest$status' => '<p>Specifies the transformer\'s status. You can update the state of the transformer, from <code>active</code> to <code>inactive</code>, or <code>inactive</code> to <code>active</code>.</p>', 'UpdateTransformerResponse$status' => '<p>Returns the state of the newly created transformer. The transformer can be either <code>active</code> or <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.</p>', ], ], 'TransformerSummary' => [ 'base' => '<p>Contains the details for a transformer object. A transformer describes how to process the incoming EDI documents and extract the necessary information to the output file.</p>', 'refs' => [ 'TransformerList$member' => NULL, ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCapabilityRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCapabilityResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePartnershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePartnershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTransformerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTransformerResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>Occurs when a B2BI object cannot be validated against a request from another object.</p>', 'refs' => [], ], 'X12Details' => [ 'base' => '<p>A structure that contains the X12 transaction set and version. The X12 structure is used when the system transforms an EDI (electronic data interchange) file.</p> <note> <p>If an EDI input file contains more than one transaction, each transaction must have the same transaction set and version, for example 214/4010. If not, the transformer cannot parse the file.</p> </note>', 'refs' => [ 'EdiType$x12Details' => '<p>Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.</p>', ], ], 'X12TransactionSet' => [ 'base' => NULL, 'refs' => [ 'X12Details$transactionSet' => '<p>Returns an enumerated type where each value identifies an X12 transaction set. Transaction sets are maintained by the X12 Accredited Standards Committee.</p>', ], ], 'X12Version' => [ 'base' => NULL, 'refs' => [ 'X12Details$version' => '<p>Returns the version to use for the specified X12 transaction set. <pre><code> &lt;/p&gt; </code></pre>', ], ], ],];
