<?php
// This file was auto-generated from sdk-root/src/data/bedrock/2023-04-20/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Describes the API operations for creating, managing, fine-turning, and evaluating Amazon Bedrock models.</p>', 'operations' => [ 'BatchDeleteEvaluationJob' => '<p>Creates a batch deletion job. A model evaluation job can only be deleted if it has following status <code>FAILED</code>, <code>COMPLETED</code>, and <code>STOPPED</code>. You can request up to 25 model evaluation jobs be deleted in a single request.</p>', 'CreateEvaluationJob' => '<p>API operation for creating and managing Amazon Bedrock automatic model evaluation jobs and model evaluation jobs that use human workers. To learn more about the requirements for creating a model evaluation job see, <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation.html">Model evaluation</a>.</p>', 'CreateGuardrail' => '<p>Creates a guardrail to block topics and to implement safeguards for your generative AI applications.</p> <p>You can configure the following policies in a guardrail to avoid undesirable and harmful content, filter out denied topics and words, and remove sensitive information for privacy protection.</p> <ul> <li> <p> <b>Content filters</b> - Adjust filter strengths to block input prompts or model responses containing harmful content.</p> </li> <li> <p> <b>Denied topics</b> - Define a set of topics that are undesirable in the context of your application. These topics will be blocked if detected in user queries or model responses.</p> </li> <li> <p> <b>Word filters</b> - Configure filters to block undesirable words, phrases, and profanity. Such words can include offensive terms, competitor names etc.</p> </li> <li> <p> <b>Sensitive information filters</b> - Block or mask sensitive information such as personally identifiable information (PII) or custom regex in user inputs and model responses.</p> </li> </ul> <p>In addition to the above policies, you can also configure the messages to be returned to the user if a user input or model response is in violation of the policies defined in the guardrail.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails.html">Guardrails for Amazon Bedrock</a> in the <i>Amazon Bedrock User Guide</i>.</p>', 'CreateGuardrailVersion' => '<p>Creates a version of the guardrail. Use this API to create a snapshot of the guardrail when you are satisfied with a configuration, or to compare the configuration with another version.</p>', 'CreateModelCopyJob' => '<p>Copies a model to another region so that it can be used there. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html">Copy models to be used in other regions</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'CreateModelCustomizationJob' => '<p>Creates a fine-tuning job to customize a base model.</p> <p>You specify the base foundation model and the location of the training data. After the model-customization job completes successfully, your custom model resource will be ready to use. Amazon Bedrock returns validation loss metrics and output generations after the job completes. </p> <p>For information on the format of training and validation data, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-prepare.html">Prepare the datasets</a>.</p> <p> Model-customization jobs are asynchronous and the completion time depends on the base model and the training/validation data size. To monitor a job, use the <code>GetModelCustomizationJob</code> operation to retrieve the job status.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'CreateModelImportJob' => '<p>Creates a model import job to import model that you have customized in other environments, such as Amazon SageMaker. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a customized model</a> </p>', 'CreateModelInvocationJob' => '<p>Creates a batch inference job to invoke a model on multiple prompts. Format your data according to <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data">Format your inference data</a> and upload it to an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference.html">Process multiple prompts with batch inference</a>.</p> <p>The response returns a <code>jobArn</code> that you can use to stop or get details about the job.</p>', 'CreateProvisionedModelThroughput' => '<p>Creates dedicated throughput for a base or custom model with the model units and for the duration that you specify. For pricing details, see <a href="http://aws.amazon.com/bedrock/pricing/">Amazon Bedrock Pricing</a>. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'DeleteCustomModel' => '<p>Deletes a custom model that you created earlier. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'DeleteGuardrail' => '<p>Deletes a guardrail.</p> <ul> <li> <p>To delete a guardrail, only specify the ARN of the guardrail in the <code>guardrailIdentifier</code> field. If you delete a guardrail, all of its versions will be deleted.</p> </li> <li> <p>To delete a version of a guardrail, specify the ARN of the guardrail in the <code>guardrailIdentifier</code> field and the version in the <code>guardrailVersion</code> field.</p> </li> </ul>', 'DeleteImportedModel' => '<p>Deletes a custom model that you imported earlier. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a customized model</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>. </p>', 'DeleteModelInvocationLoggingConfiguration' => '<p>Delete the invocation logging. </p>', 'DeleteProvisionedModelThroughput' => '<p>Deletes a Provisioned Throughput. You can\'t delete a Provisioned Throughput before the commitment term is over. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'GetCustomModel' => '<p>Get the properties associated with a Amazon Bedrock custom model that you have created.For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'GetEvaluationJob' => '<p>Retrieves the properties associated with a model evaluation job, including the status of the job. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation.html">Model evaluation</a>.</p>', 'GetFoundationModel' => '<p>Get details about a Amazon Bedrock foundation model.</p>', 'GetGuardrail' => '<p>Gets details about a guardrail. If you don\'t specify a version, the response returns details for the <code>DRAFT</code> version.</p>', 'GetImportedModel' => '<p>Gets properties associated with a customized model you imported. </p>', 'GetInferenceProfile' => '<p>Gets information about an inference profile. For more information, see the Amazon Bedrock User Guide.</p>', 'GetModelCopyJob' => '<p>Retrieves information about a model copy job. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html">Copy models to be used in other regions</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'GetModelCustomizationJob' => '<p>Retrieves the properties associated with a model-customization job, including the status of the job. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'GetModelImportJob' => '<p>Retrieves the properties associated with import model job, including the status of the job. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a customized model</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'GetModelInvocationJob' => '<p>Gets details about a batch inference job. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-manage.html#batch-inference-view">View details about a batch inference job</a> </p>', 'GetModelInvocationLoggingConfiguration' => '<p>Get the current configuration values for model invocation logging.</p>', 'GetProvisionedModelThroughput' => '<p>Returns details for a Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'ListCustomModels' => '<p>Returns a list of the custom models that you have created with the <code>CreateModelCustomizationJob</code> operation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'ListEvaluationJobs' => '<p>Lists model evaluation jobs.</p>', 'ListFoundationModels' => '<p>Lists Amazon Bedrock foundation models that you can use. You can filter the results with the request parameters. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/foundation-models.html">Foundation models</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'ListGuardrails' => '<p>Lists details about all the guardrails in an account. To list the <code>DRAFT</code> version of all your guardrails, don\'t specify the <code>guardrailIdentifier</code> field. To list all versions of a guardrail, specify the ARN of the guardrail in the <code>guardrailIdentifier</code> field.</p> <p>You can set the maximum number of results to return in a response in the <code>maxResults</code> field. If there are more results than the number you set, the response returns a <code>nextToken</code> that you can send in another <code>ListGuardrails</code> request to see the next batch of results.</p>', 'ListImportedModels' => '<p>Returns a list of models you\'ve imported. You can filter the results to return based on one or more criteria. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a customized model</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'ListInferenceProfiles' => '<p>Returns a list of inference profiles that you can use.</p>', 'ListModelCopyJobs' => '<p>Returns a list of model copy jobs that you have submitted. You can filter the jobs to return based on one or more criteria. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html">Copy models to be used in other regions</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'ListModelCustomizationJobs' => '<p>Returns a list of model customization jobs that you have submitted. You can filter the jobs to return based on one or more criteria.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'ListModelImportJobs' => '<p>Returns a list of import jobs you\'ve submitted. You can filter the results to return based on one or more criteria. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-customization-import-model.html">Import a customized model</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'ListModelInvocationJobs' => '<p>Lists all batch inference jobs in the account. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-manage.html#batch-inference-view">View details about a batch inference job</a>.</p>', 'ListProvisionedModelThroughputs' => '<p>Lists the Provisioned Throughputs in the account. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'ListTagsForResource' => '<p>List the tags associated with the specified resource.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'PutModelInvocationLoggingConfiguration' => '<p>Set the configuration values for model invocation logging.</p>', 'StopEvaluationJob' => '<p>Stops an in progress model evaluation job.</p>', 'StopModelCustomizationJob' => '<p>Stops an active model customization job. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'StopModelInvocationJob' => '<p>Stops a batch inference job. You\'re only charged for tokens that were already processed. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-manage.html#batch-inference-stop">Stop a batch inference job</a>.</p>', 'TagResource' => '<p>Associate tags with a resource. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'UntagResource' => '<p>Remove one or more tags from a resource. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging resources</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'UpdateGuardrail' => '<p>Updates a guardrail with the values you specify.</p> <ul> <li> <p>Specify a <code>name</code> and optional <code>description</code>.</p> </li> <li> <p>Specify messages for when the guardrail successfully blocks a prompt or a model response in the <code>blockedInputMessaging</code> and <code>blockedOutputsMessaging</code> fields.</p> </li> <li> <p>Specify topics for the guardrail to deny in the <code>topicPolicyConfig</code> object. Each <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailTopicConfig.html">GuardrailTopicConfig</a> object in the <code>topicsConfig</code> list pertains to one topic.</p> <ul> <li> <p>Give a <code>name</code> and <code>description</code> so that the guardrail can properly identify the topic.</p> </li> <li> <p>Specify <code>DENY</code> in the <code>type</code> field.</p> </li> <li> <p>(Optional) Provide up to five prompts that you would categorize as belonging to the topic in the <code>examples</code> list.</p> </li> </ul> </li> <li> <p>Specify filter strengths for the harmful categories defined in Amazon Bedrock in the <code>contentPolicyConfig</code> object. Each <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html">GuardrailContentFilterConfig</a> object in the <code>filtersConfig</code> list pertains to a harmful category. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-content-filters">Content filters</a>. For more information about the fields in a content filter, see <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html">GuardrailContentFilterConfig</a>.</p> <ul> <li> <p>Specify the category in the <code>type</code> field.</p> </li> <li> <p>Specify the strength of the filter for prompts in the <code>inputStrength</code> field and for model responses in the <code>strength</code> field of the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html">GuardrailContentFilterConfig</a>.</p> </li> </ul> </li> <li> <p>(Optional) For security, include the ARN of a KMS key in the <code>kmsKeyId</code> field.</p> </li> </ul>', 'UpdateProvisionedModelThroughput' => '<p>Updates the name or associated model for a Provisioned Throughput. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The request is denied because of missing access permissions.</p>', 'refs' => [], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'CustomModelSummary$ownerAccountId' => '<p>The unique identifier of the account that owns the model.</p>', 'GetModelCopyJobResponse$sourceAccountId' => '<p>The unique identifier of the account that the model being copied originated from.</p>', 'ListModelCopyJobsRequest$sourceAccountEquals' => '<p>Filters for model copy jobs in which the account that the source model belongs to is equal to the value that you specify.</p>', 'ModelCopyJobSummary$sourceAccountId' => '<p>The unique identifier of the account that the model being copied originated from.</p>', ], ], 'AutomatedEvaluationConfig' => [ 'base' => '<p>Use to specify a automatic model evaluation job. The <code>EvaluationDatasetMetricConfig</code> object is used to specify the prompt datasets, task type, and metric names.</p>', 'refs' => [ 'EvaluationConfig$automated' => '<p>Used to specify an automated model evaluation job. See <code>AutomatedEvaluationConfig</code> to view the required parameters.</p>', ], ], 'BaseModelIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateModelCustomizationJobRequest$baseModelIdentifier' => '<p>Name of the base model.</p>', ], ], 'BatchDeleteEvaluationJobError' => [ 'base' => '<p>A JSON array that provides the status of the model evaluation jobs being deleted.</p>', 'refs' => [ 'BatchDeleteEvaluationJobErrors$member' => NULL, ], ], 'BatchDeleteEvaluationJobErrors' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteEvaluationJobResponse$errors' => '<p>A JSON object containing the HTTP status codes and the ARNs of model evaluation jobs that failed to be deleted.</p>', ], ], 'BatchDeleteEvaluationJobItem' => [ 'base' => '<p>An array of model evaluation jobs to be deleted, and their associated statuses.</p>', 'refs' => [ 'BatchDeleteEvaluationJobItems$member' => NULL, ], ], 'BatchDeleteEvaluationJobItems' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteEvaluationJobResponse$evaluationJobs' => '<p>The list of model evaluation jobs to be deleted.</p>', ], ], 'BatchDeleteEvaluationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteEvaluationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'BedrockModelId' => [ 'base' => NULL, 'refs' => [ 'FoundationModelDetails$modelId' => '<p>The model identifier.</p>', 'FoundationModelSummary$modelId' => '<p>The model ID of the foundation model.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'FoundationModelDetails$responseStreamingSupported' => '<p>Indicates whether the model supports streaming.</p>', 'FoundationModelSummary$responseStreamingSupported' => '<p>Indicates whether the model supports streaming.</p>', 'ListCustomModelsRequest$isOwned' => '<p>Return custom models depending on if the current account owns them (<code>true</code>) or if they were shared with the current account (<code>false</code>).</p>', 'LoggingConfig$textDataDeliveryEnabled' => '<p>Set to include text data in the log delivery.</p>', 'LoggingConfig$imageDataDeliveryEnabled' => '<p>Set to include image data in the log delivery.</p>', 'LoggingConfig$embeddingDataDeliveryEnabled' => '<p>Set to include embeddings data in the log delivery.</p>', ], ], 'BrandedName' => [ 'base' => NULL, 'refs' => [ 'FoundationModelDetails$modelName' => '<p>The model name.</p>', 'FoundationModelDetails$providerName' => '<p>The model\'s provider name.</p>', 'FoundationModelSummary$modelName' => '<p>The name of the model.</p>', 'FoundationModelSummary$providerName' => '<p>The model\'s provider name.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'S3Config$bucketName' => '<p>S3 bucket name.</p>', ], ], 'CloudWatchConfig' => [ 'base' => '<p>CloudWatch logging configuration.</p>', 'refs' => [ 'LoggingConfig$cloudWatchConfig' => '<p>CloudWatch logging configuration.</p>', ], ], 'CommitmentDuration' => [ 'base' => NULL, 'refs' => [ 'CreateProvisionedModelThroughputRequest$commitmentDuration' => '<p>The commitment duration requested for the Provisioned Throughput. Billing occurs hourly and is discounted for longer commitment terms. To request a no-commit Provisioned Throughput, omit this field.</p> <p>Custom models support all levels of commitment. To see which base models support no commitment, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/pt-supported.html">Supported regions and models for Provisioned Throughput</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a> </p>', 'GetProvisionedModelThroughputResponse$commitmentDuration' => '<p>Commitment duration of the Provisioned Throughput.</p>', 'ProvisionedModelSummary$commitmentDuration' => '<p>The duration for which the Provisioned Throughput was committed.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Error occurred because of a conflict while performing an operation.</p>', 'refs' => [], ], 'CreateEvaluationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEvaluationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGuardrailRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGuardrailResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGuardrailVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGuardrailVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelCopyJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelCopyJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelCustomizationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelCustomizationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelInvocationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateModelInvocationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProvisionedModelThroughputRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProvisionedModelThroughputResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomModelArn' => [ 'base' => NULL, 'refs' => [ 'CustomModelSummary$modelArn' => '<p>The Amazon Resource Name (ARN) of the custom model.</p>', 'GetModelCopyJobResponse$targetModelArn' => '<p>The Amazon Resource Name (ARN) of the copied model.</p>', 'GetModelCustomizationJobResponse$outputModelArn' => '<p>The Amazon Resource Name (ARN) of the output model.</p>', 'ModelCopyJobSummary$targetModelArn' => '<p>The Amazon Resource Name (ARN) of the copied model.</p>', 'ModelCustomizationJobSummary$customModelArn' => '<p>Amazon Resource Name (ARN) of the custom model.</p>', ], ], 'CustomModelName' => [ 'base' => NULL, 'refs' => [ 'CreateModelCopyJobRequest$targetModelName' => '<p>A name for the copied model.</p>', 'CreateModelCustomizationJobRequest$customModelName' => '<p>A name for the resulting custom model.</p>', 'CustomModelSummary$modelName' => '<p>The name of the custom model.</p>', 'GetCustomModelResponse$modelName' => '<p>Model name associated with this model.</p>', 'GetModelCopyJobResponse$targetModelName' => '<p>The name of the copied model.</p>', 'GetModelCopyJobResponse$sourceModelName' => '<p>The name of the original model being copied.</p>', 'GetModelCustomizationJobResponse$outputModelName' => '<p>The name of the output model.</p>', 'ListCustomModelsRequest$nameContains' => '<p>Return custom models only if the job name contains these characters.</p>', 'ListModelCopyJobsRequest$targetModelNameContains' => '<p>Filters for model copy jobs in which the name of the copied model contains the string that you specify.</p>', 'ModelCopyJobSummary$targetModelName' => '<p>The name of the copied model.</p>', 'ModelCopyJobSummary$sourceModelName' => '<p>The name of the original model being copied.</p>', 'ModelCustomizationJobSummary$customModelName' => '<p>Name of the custom model.</p>', ], ], 'CustomModelSummary' => [ 'base' => '<p>Summary information for a custom model.</p>', 'refs' => [ 'CustomModelSummaryList$member' => NULL, ], ], 'CustomModelSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListCustomModelsResponse$modelSummaries' => '<p>Model summaries.</p>', ], ], 'CustomizationType' => [ 'base' => NULL, 'refs' => [ 'CreateModelCustomizationJobRequest$customizationType' => '<p>The customization type.</p>', 'CustomModelSummary$customizationType' => '<p>Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a>.</p>', 'GetCustomModelResponse$customizationType' => '<p>The type of model customization.</p>', 'GetModelCustomizationJobResponse$customizationType' => '<p>The type of model customization.</p>', 'ModelCustomizationJobSummary$customizationType' => '<p>Specifies whether to carry out continued pre-training of a model or whether to fine-tune it. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a>.</p>', ], ], 'DeleteCustomModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGuardrailRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGuardrailResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImportedModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteImportedModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelInvocationLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteModelInvocationLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProvisionedModelThroughputRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProvisionedModelThroughputResponse' => [ 'base' => NULL, 'refs' => [], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ErrorMessages$member' => NULL, 'GetModelCopyJobResponse$failureMessage' => '<p>An error message for why the model copy job failed.</p>', 'GetModelCustomizationJobResponse$failureMessage' => '<p>Information about why the job failed.</p>', 'GetModelImportJobResponse$failureMessage' => '<p>Information about why the import job failed.</p>', 'GetProvisionedModelThroughputResponse$failureMessage' => '<p>A failure message for any issues that occurred during creation, updating, or deletion of the Provisioned Throughput.</p>', 'ModelCopyJobSummary$failureMessage' => '<p>If a model fails to be copied, a message describing why the job failed is included here.</p>', ], ], 'ErrorMessages' => [ 'base' => NULL, 'refs' => [ 'GetEvaluationJobResponse$failureMessages' => '<p>An array of strings the specify why the model evaluation job has failed.</p>', ], ], 'EvaluationBedrockModel' => [ 'base' => '<p>Contains the ARN of the Amazon Bedrock models specified in your model evaluation job. Each Amazon Bedrock model supports different <code>inferenceParams</code>. To learn more about supported inference parameters for Amazon Bedrock models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html">Inference parameters for foundation models</a>.</p> <p>The <code>inferenceParams</code> are specified using JSON. To successfully insert JSON as string make sure that all quotations are properly escaped. For example, <code>"temperature":"0.25"</code> key value pair would need to be formatted as <code>\\"temperature\\":\\"0.25\\"</code> to successfully accepted in the request.</p>', 'refs' => [ 'EvaluationModelConfig$bedrockModel' => '<p>Defines the Amazon Bedrock model and inference parameters you want used.</p>', ], ], 'EvaluationConfig' => [ 'base' => '<p>Used to specify either a <code>AutomatedEvaluationConfig</code> or <code>HumanEvaluationConfig</code> object.</p>', 'refs' => [ 'CreateEvaluationJobRequest$evaluationConfig' => '<p>Specifies whether the model evaluation job is automatic or uses human worker.</p>', 'GetEvaluationJobResponse$evaluationConfig' => '<p>Contains details about the type of model evaluation job, the metrics used, the task type selected, the datasets used, and any custom metrics you defined.</p>', ], ], 'EvaluationDataset' => [ 'base' => '<p>Used to specify the name of a built-in prompt dataset and optionally, the Amazon S3 bucket where a custom prompt dataset is saved.</p>', 'refs' => [ 'EvaluationDatasetMetricConfig$dataset' => '<p>Specifies the prompt dataset.</p>', ], ], 'EvaluationDatasetLocation' => [ 'base' => '<p>The location in Amazon S3 where your prompt dataset is stored.</p>', 'refs' => [ 'EvaluationDataset$datasetLocation' => '<p>For custom prompt datasets, you must specify the location in Amazon S3 where the prompt dataset is saved.</p>', ], ], 'EvaluationDatasetMetricConfig' => [ 'base' => '<p>Defines the built-in prompt datasets, built-in metric names and custom metric names, and the task type.</p>', 'refs' => [ 'EvaluationDatasetMetricConfigs$member' => NULL, ], ], 'EvaluationDatasetMetricConfigs' => [ 'base' => NULL, 'refs' => [ 'AutomatedEvaluationConfig$datasetMetricConfigs' => '<p>Specifies the required elements for an automatic model evaluation job.</p>', 'HumanEvaluationConfig$datasetMetricConfigs' => '<p>Use to specify the metrics, task, and prompt dataset to be used in your model evaluation job.</p>', ], ], 'EvaluationDatasetName' => [ 'base' => NULL, 'refs' => [ 'EvaluationDataset$name' => '<p>Used to specify supported built-in prompt datasets. Valid values are <code>Builtin.Bold</code>, <code>Builtin.BoolQ</code>, <code>Builtin.NaturalQuestions</code>, <code>Builtin.Gigaword</code>, <code>Builtin.RealToxicityPrompts</code>, <code>Builtin.TriviaQA</code>, <code>Builtin.T-Rex</code>, <code>Builtin.WomensEcommerceClothingReviews</code> and <code>Builtin.Wikitext2</code>.</p>', ], ], 'EvaluationInferenceConfig' => [ 'base' => '<p>Used to define the models you want used in your model evaluation job. Automated model evaluation jobs support only a single model. In a human-based model evaluation job, your annotator can compare the responses for up to two different models.</p>', 'refs' => [ 'CreateEvaluationJobRequest$inferenceConfig' => '<p>Specify the models you want to use in your model evaluation job. Automatic model evaluation jobs support a single model, and model evaluation job that use human workers support two models.</p>', 'GetEvaluationJobResponse$inferenceConfig' => '<p>Details about the models you specified in your model evaluation job.</p>', ], ], 'EvaluationJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateEvaluationJobResponse$jobArn' => '<p>The ARN of the model evaluation job.</p>', 'EvaluationSummary$jobArn' => '<p>The Amazon Resource Name (ARN) of the model evaluation job.</p>', 'GetEvaluationJobResponse$jobArn' => '<p>The Amazon Resource Name (ARN) of the model evaluation job.</p>', ], ], 'EvaluationJobDescription' => [ 'base' => NULL, 'refs' => [ 'CreateEvaluationJobRequest$jobDescription' => '<p>A description of the model evaluation job.</p>', 'GetEvaluationJobResponse$jobDescription' => '<p>The description of the model evaluation job.</p>', ], ], 'EvaluationJobIdentifier' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteEvaluationJobError$jobIdentifier' => '<p>The ARN of the model evaluation job being deleted.</p>', 'BatchDeleteEvaluationJobItem$jobIdentifier' => '<p>The ARN of model evaluation job to be deleted.</p>', 'EvaluationJobIdentifiers$member' => NULL, 'GetEvaluationJobRequest$jobIdentifier' => '<p>The Amazon Resource Name (ARN) of the model evaluation job.</p>', 'StopEvaluationJobRequest$jobIdentifier' => '<p>The ARN of the model evaluation job you want to stop.</p>', ], ], 'EvaluationJobIdentifiers' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteEvaluationJobRequest$jobIdentifiers' => '<p>An array of model evaluation job ARNs to be deleted.</p>', ], ], 'EvaluationJobName' => [ 'base' => NULL, 'refs' => [ 'CreateEvaluationJobRequest$jobName' => '<p>The name of the model evaluation job. Model evaluation job names must unique with your AWS account, and your account\'s AWS region.</p>', 'EvaluationSummary$jobName' => '<p>The name of the model evaluation job.</p>', 'GetEvaluationJobResponse$jobName' => '<p>The name of the model evaluation job.</p>', 'ListEvaluationJobsRequest$nameContains' => '<p>Query parameter string for model evaluation job names.</p>', ], ], 'EvaluationJobStatus' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteEvaluationJobItem$jobStatus' => '<p>The status of the job\'s deletion.</p>', 'EvaluationSummary$status' => '<p>The current status of the model evaluation job. </p>', 'GetEvaluationJobResponse$status' => '<p>The status of the model evaluation job.</p>', 'ListEvaluationJobsRequest$statusEquals' => '<p>Only return jobs where the status condition is met.</p>', ], ], 'EvaluationJobType' => [ 'base' => NULL, 'refs' => [ 'EvaluationSummary$jobType' => '<p>The type, either human or automatic, of model evaluation job.</p>', 'GetEvaluationJobResponse$jobType' => '<p>The type of model evaluation job.</p>', ], ], 'EvaluationMetricDescription' => [ 'base' => NULL, 'refs' => [ 'HumanEvaluationCustomMetric$description' => '<p>An optional description of the metric. Use this parameter to provide more details about the metric.</p>', ], ], 'EvaluationMetricName' => [ 'base' => NULL, 'refs' => [ 'EvaluationMetricNames$member' => NULL, 'HumanEvaluationCustomMetric$name' => '<p>The name of the metric. Your human evaluators will see this name in the evaluation UI.</p>', ], ], 'EvaluationMetricNames' => [ 'base' => NULL, 'refs' => [ 'EvaluationDatasetMetricConfig$metricNames' => '<p>The names of the metrics used. For automated model evaluation jobs valid values are <code>"Builtin.Accuracy"</code>, <code>"Builtin.Robustness"</code>, and <code>"Builtin.Toxicity"</code>. In human-based model evaluation jobs the array of strings must match the <code>name</code> parameter specified in <code>HumanEvaluationCustomMetric</code>. </p>', ], ], 'EvaluationModelConfig' => [ 'base' => '<p>Defines the models used in the model evaluation job.</p>', 'refs' => [ 'EvaluationModelConfigs$member' => NULL, ], ], 'EvaluationModelConfigs' => [ 'base' => NULL, 'refs' => [ 'EvaluationInferenceConfig$models' => '<p>Used to specify the models.</p>', ], ], 'EvaluationModelIdentifier' => [ 'base' => NULL, 'refs' => [ 'EvaluationBedrockModel$modelIdentifier' => '<p>The ARN of the Amazon Bedrock model specified.</p>', 'EvaluationModelIdentifiers$member' => NULL, ], ], 'EvaluationModelIdentifiers' => [ 'base' => NULL, 'refs' => [ 'EvaluationSummary$modelIdentifiers' => '<p>The Amazon Resource Names (ARNs) of the model(s) used in the model evaluation job.</p>', ], ], 'EvaluationModelInferenceParams' => [ 'base' => NULL, 'refs' => [ 'EvaluationBedrockModel$inferenceParams' => '<p>Each Amazon Bedrock support different inference parameters that change how the model behaves during inference.</p>', ], ], 'EvaluationOutputDataConfig' => [ 'base' => '<p>The Amazon S3 location where the results of your model evaluation job are saved.</p>', 'refs' => [ 'CreateEvaluationJobRequest$outputDataConfig' => '<p>An object that defines where the results of model evaluation job will be saved in Amazon S3.</p>', 'GetEvaluationJobResponse$outputDataConfig' => '<p>Amazon S3 location for where output data is saved.</p>', ], ], 'EvaluationRatingMethod' => [ 'base' => NULL, 'refs' => [ 'HumanEvaluationCustomMetric$ratingMethod' => '<p>Choose how you want your human workers to evaluation your model. Valid values for rating methods are <code>ThumbsUpDown</code>, <code>IndividualLikertScale</code>,<code>ComparisonLikertScale</code>, <code>ComparisonChoice</code>, and <code>ComparisonRank</code> </p>', ], ], 'EvaluationSummaries' => [ 'base' => NULL, 'refs' => [ 'ListEvaluationJobsResponse$jobSummaries' => '<p>A summary of the model evaluation jobs.</p>', ], ], 'EvaluationSummary' => [ 'base' => '<p>A summary of the model evaluation job.</p>', 'refs' => [ 'EvaluationSummaries$member' => NULL, ], ], 'EvaluationTaskType' => [ 'base' => NULL, 'refs' => [ 'EvaluationDatasetMetricConfig$taskType' => '<p>The task type you want the model to carry out. </p>', 'EvaluationTaskTypes$member' => NULL, ], ], 'EvaluationTaskTypes' => [ 'base' => NULL, 'refs' => [ 'EvaluationSummary$evaluationTaskTypes' => '<p>What task type was used in the model evaluation job.</p>', ], ], 'FineTuningJobStatus' => [ 'base' => NULL, 'refs' => [ 'ListModelCustomizationJobsRequest$statusEquals' => '<p>Return customization jobs with the specified status. </p>', ], ], 'FoundationModelArn' => [ 'base' => NULL, 'refs' => [ 'FoundationModelDetails$modelArn' => '<p>The model Amazon Resource Name (ARN).</p>', 'FoundationModelSummary$modelArn' => '<p>The Amazon Resource Name (ARN) of the foundation model.</p>', 'GetModelCustomizationJobResponse$baseModelArn' => '<p>Amazon Resource Name (ARN) of the base model.</p>', 'GetProvisionedModelThroughputResponse$foundationModelArn' => '<p>The Amazon Resource Name (ARN) of the base model for which the Provisioned Throughput was created, or of the base model that the custom model for which the Provisioned Throughput was created was customized.</p>', 'InferenceProfileModel$modelArn' => '<p>The Amazon Resource Name (ARN) of the model.</p>', 'ListCustomModelsRequest$foundationModelArnEquals' => '<p>Return custom models only if the foundation model Amazon Resource Name (ARN) matches this parameter.</p>', 'ProvisionedModelSummary$foundationModelArn' => '<p>The Amazon Resource Name (ARN) of the base model for which the Provisioned Throughput was created, or of the base model that the custom model for which the Provisioned Throughput was created was customized.</p>', ], ], 'FoundationModelDetails' => [ 'base' => '<p>Information about a foundation model.</p>', 'refs' => [ 'GetFoundationModelResponse$modelDetails' => '<p>Information about the foundation model.</p>', ], ], 'FoundationModelLifecycle' => [ 'base' => '<p>Details about whether a model version is available or deprecated.</p>', 'refs' => [ 'FoundationModelDetails$modelLifecycle' => '<p>Contains details about whether a model version is available or deprecated</p>', 'FoundationModelSummary$modelLifecycle' => '<p>Contains details about whether a model version is available or deprecated.</p>', ], ], 'FoundationModelLifecycleStatus' => [ 'base' => NULL, 'refs' => [ 'FoundationModelLifecycle$status' => '<p>Specifies whether a model version is available (<code>ACTIVE</code>) or deprecated (<code>LEGACY</code>.</p>', ], ], 'FoundationModelSummary' => [ 'base' => '<p>Summary information for a foundation model.</p>', 'refs' => [ 'FoundationModelSummaryList$member' => NULL, ], ], 'FoundationModelSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListFoundationModelsResponse$modelSummaries' => '<p>A list of Amazon Bedrock foundation models.</p>', ], ], 'GetCustomModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCustomModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEvaluationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEvaluationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFoundationModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFoundationModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetGuardrailRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGuardrailResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetImportedModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetImportedModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetInferenceProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetInferenceProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetModelCopyJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetModelCopyJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetModelCustomizationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetModelCustomizationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetModelImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetModelImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetModelInvocationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetModelInvocationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetModelInvocationLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetModelInvocationLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetProvisionedModelThroughputRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetProvisionedModelThroughputResponse' => [ 'base' => NULL, 'refs' => [], ], 'GuardrailArn' => [ 'base' => NULL, 'refs' => [ 'CreateGuardrailResponse$guardrailArn' => '<p>The ARN of the guardrail.</p>', 'GetGuardrailResponse$guardrailArn' => '<p>The ARN of the guardrail.</p>', 'GuardrailSummary$arn' => '<p>The ARN of the guardrail.</p>', 'UpdateGuardrailResponse$guardrailArn' => '<p>The ARN of the guardrail.</p>', ], ], 'GuardrailBlockedMessaging' => [ 'base' => NULL, 'refs' => [ 'CreateGuardrailRequest$blockedInputMessaging' => '<p>The message to return when the guardrail blocks a prompt.</p>', 'CreateGuardrailRequest$blockedOutputsMessaging' => '<p>The message to return when the guardrail blocks a model response.</p>', 'GetGuardrailResponse$blockedInputMessaging' => '<p>The message that the guardrail returns when it blocks a prompt.</p>', 'GetGuardrailResponse$blockedOutputsMessaging' => '<p>The message that the guardrail returns when it blocks a model response.</p>', 'UpdateGuardrailRequest$blockedInputMessaging' => '<p>The message to return when the guardrail blocks a prompt.</p>', 'UpdateGuardrailRequest$blockedOutputsMessaging' => '<p>The message to return when the guardrail blocks a model response.</p>', ], ], 'GuardrailContentFilter' => [ 'base' => '<p>Contains filter strengths for harmful content. Guardrails support the following content filters to detect and filter harmful user inputs and FM-generated outputs.</p> <ul> <li> <p> <b>Hate</b> – Describes language or a statement that discriminates, criticizes, insults, denounces, or dehumanizes a person or group on the basis of an identity (such as race, ethnicity, gender, religion, sexual orientation, ability, and national origin).</p> </li> <li> <p> <b>Insults</b> – Describes language or a statement that includes demeaning, humiliating, mocking, insulting, or belittling language. This type of language is also labeled as bullying.</p> </li> <li> <p> <b>Sexual</b> – Describes language or a statement that indicates sexual interest, activity, or arousal using direct or indirect references to body parts, physical traits, or sex.</p> </li> <li> <p> <b>Violence</b> – Describes language or a statement that includes glorification of or threats to inflict physical pain, hurt, or injury toward a person, group or thing.</p> </li> </ul> <p>Content filtering depends on the confidence classification of user inputs and FM responses across each of the four harmful categories. All input and output statements are classified into one of four confidence levels (NONE, LOW, MEDIUM, HIGH) for each harmful category. For example, if a statement is classified as <i>Hate</i> with HIGH confidence, the likelihood of the statement representing hateful content is high. A single statement can be classified across multiple categories with varying confidence levels. For example, a single statement can be classified as <i>Hate</i> with HIGH confidence, <i>Insults</i> with LOW confidence, <i>Sexual</i> with NONE confidence, and <i>Violence</i> with MEDIUM confidence.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-filters.html">Guardrails content filters</a>.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax">GetGuardrail response body</a> </p> </li> </ul>', 'refs' => [ 'GuardrailContentFilters$member' => NULL, ], ], 'GuardrailContentFilterConfig' => [ 'base' => '<p>Contains filter strengths for harmful content. Guardrails support the following content filters to detect and filter harmful user inputs and FM-generated outputs.</p> <ul> <li> <p> <b>Hate</b> – Describes language or a statement that discriminates, criticizes, insults, denounces, or dehumanizes a person or group on the basis of an identity (such as race, ethnicity, gender, religion, sexual orientation, ability, and national origin).</p> </li> <li> <p> <b>Insults</b> – Describes language or a statement that includes demeaning, humiliating, mocking, insulting, or belittling language. This type of language is also labeled as bullying.</p> </li> <li> <p> <b>Sexual</b> – Describes language or a statement that indicates sexual interest, activity, or arousal using direct or indirect references to body parts, physical traits, or sex.</p> </li> <li> <p> <b>Violence</b> – Describes language or a statement that includes glorification of or threats to inflict physical pain, hurt, or injury toward a person, group or thing.</p> </li> </ul> <p>Content filtering depends on the confidence classification of user inputs and FM responses across each of the four harmful categories. All input and output statements are classified into one of four confidence levels (NONE, LOW, MEDIUM, HIGH) for each harmful category. For example, if a statement is classified as <i>Hate</i> with HIGH confidence, the likelihood of the statement representing hateful content is high. A single statement can be classified across multiple categories with varying confidence levels. For example, a single statement can be classified as <i>Hate</i> with HIGH confidence, <i>Insults</i> with LOW confidence, <i>Sexual</i> with NONE confidence, and <i>Violence</i> with MEDIUM confidence.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-filters.html">Guardrails content filters</a>.</p>', 'refs' => [ 'GuardrailContentFiltersConfig$member' => NULL, ], ], 'GuardrailContentFilterType' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentFilter$type' => '<p>The harmful category that the content filter is applied to.</p>', 'GuardrailContentFilterConfig$type' => '<p>The harmful category that the content filter is applied to.</p>', ], ], 'GuardrailContentFilters' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentPolicy$filters' => '<p>Contains the type of the content filter and how strongly it should apply to prompts and model responses.</p>', ], ], 'GuardrailContentFiltersConfig' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentPolicyConfig$filtersConfig' => '<p>Contains the type of the content filter and how strongly it should apply to prompts and model responses.</p>', ], ], 'GuardrailContentPolicy' => [ 'base' => '<p>Contains details about how to handle harmful content.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax">GetGuardrail response body</a> </p> </li> </ul>', 'refs' => [ 'GetGuardrailResponse$contentPolicy' => '<p>The content policy that was configured for the guardrail.</p>', ], ], 'GuardrailContentPolicyConfig' => [ 'base' => '<p>Contains details about how to handle harmful content.</p>', 'refs' => [ 'CreateGuardrailRequest$contentPolicyConfig' => '<p>The content filter policies to configure for the guardrail.</p>', 'UpdateGuardrailRequest$contentPolicyConfig' => '<p>The content policy to configure for the guardrail.</p>', ], ], 'GuardrailContextualGroundingFilter' => [ 'base' => '<p>The details for the guardrails contextual grounding filter.</p>', 'refs' => [ 'GuardrailContextualGroundingFilters$member' => NULL, ], ], 'GuardrailContextualGroundingFilterConfig' => [ 'base' => '<p>The filter configuration details for the guardrails contextual grounding filter.</p>', 'refs' => [ 'GuardrailContextualGroundingFiltersConfig$member' => NULL, ], ], 'GuardrailContextualGroundingFilterConfigThresholdDouble' => [ 'base' => NULL, 'refs' => [ 'GuardrailContextualGroundingFilterConfig$threshold' => '<p>The threshold details for the guardrails contextual grounding filter.</p>', ], ], 'GuardrailContextualGroundingFilterThresholdDouble' => [ 'base' => NULL, 'refs' => [ 'GuardrailContextualGroundingFilter$threshold' => '<p>The threshold details for the guardrails contextual grounding filter.</p>', ], ], 'GuardrailContextualGroundingFilterType' => [ 'base' => NULL, 'refs' => [ 'GuardrailContextualGroundingFilter$type' => '<p>The filter type details for the guardrails contextual grounding filter.</p>', 'GuardrailContextualGroundingFilterConfig$type' => '<p>The filter details for the guardrails contextual grounding filter.</p>', ], ], 'GuardrailContextualGroundingFilters' => [ 'base' => NULL, 'refs' => [ 'GuardrailContextualGroundingPolicy$filters' => '<p>The filter details for the guardrails contextual grounding policy.</p>', ], ], 'GuardrailContextualGroundingFiltersConfig' => [ 'base' => NULL, 'refs' => [ 'GuardrailContextualGroundingPolicyConfig$filtersConfig' => '<p>The filter configuration details for the guardrails contextual grounding policy.</p>', ], ], 'GuardrailContextualGroundingPolicy' => [ 'base' => '<p>The details for the guardrails contextual grounding policy.</p>', 'refs' => [ 'GetGuardrailResponse$contextualGroundingPolicy' => '<p>The contextual grounding policy used in the guardrail.</p>', ], ], 'GuardrailContextualGroundingPolicyConfig' => [ 'base' => '<p>The policy configuration details for the guardrails contextual grounding policy.</p>', 'refs' => [ 'CreateGuardrailRequest$contextualGroundingPolicyConfig' => '<p>The contextual grounding policy configuration used to create a guardrail.</p>', 'UpdateGuardrailRequest$contextualGroundingPolicyConfig' => '<p>The contextual grounding policy configuration used to update a guardrail.</p>', ], ], 'GuardrailDescription' => [ 'base' => NULL, 'refs' => [ 'CreateGuardrailRequest$description' => '<p>A description of the guardrail.</p>', 'CreateGuardrailVersionRequest$description' => '<p>A description of the guardrail version.</p>', 'GetGuardrailResponse$description' => '<p>The description of the guardrail.</p>', 'GuardrailSummary$description' => '<p>A description of the guardrail.</p>', 'UpdateGuardrailRequest$description' => '<p>A description of the guardrail.</p>', ], ], 'GuardrailDraftVersion' => [ 'base' => NULL, 'refs' => [ 'CreateGuardrailResponse$version' => '<p>The version of the guardrail that was created. This value will always be <code>DRAFT</code>.</p>', 'UpdateGuardrailResponse$version' => '<p>The version of the guardrail.</p>', ], ], 'GuardrailFailureRecommendation' => [ 'base' => NULL, 'refs' => [ 'GuardrailFailureRecommendations$member' => NULL, ], ], 'GuardrailFailureRecommendations' => [ 'base' => NULL, 'refs' => [ 'GetGuardrailResponse$failureRecommendations' => '<p>Appears if the <code>status</code> of the guardrail is <code>FAILED</code>. A list of recommendations to carry out before retrying the request.</p>', ], ], 'GuardrailFilterStrength' => [ 'base' => NULL, 'refs' => [ 'GuardrailContentFilter$inputStrength' => '<p>The strength of the content filter to apply to prompts. As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.</p>', 'GuardrailContentFilter$outputStrength' => '<p>The strength of the content filter to apply to model responses. As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.</p>', 'GuardrailContentFilterConfig$inputStrength' => '<p>The strength of the content filter to apply to prompts. As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.</p>', 'GuardrailContentFilterConfig$outputStrength' => '<p>The strength of the content filter to apply to model responses. As you increase the filter strength, the likelihood of filtering harmful content increases and the probability of seeing harmful content in your application reduces.</p>', ], ], 'GuardrailId' => [ 'base' => NULL, 'refs' => [ 'CreateGuardrailResponse$guardrailId' => '<p>The unique identifier of the guardrail that was created.</p>', 'CreateGuardrailVersionResponse$guardrailId' => '<p>The unique identifier of the guardrail.</p>', 'GetGuardrailResponse$guardrailId' => '<p>The unique identifier of the guardrail.</p>', 'GuardrailSummary$id' => '<p>The unique identifier of the guardrail.</p>', 'UpdateGuardrailResponse$guardrailId' => '<p>The unique identifier of the guardrail</p>', ], ], 'GuardrailIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateGuardrailVersionRequest$guardrailIdentifier' => '<p>The unique identifier of the guardrail. This can be an ID or the ARN.</p>', 'DeleteGuardrailRequest$guardrailIdentifier' => '<p>The unique identifier of the guardrail. This can be an ID or the ARN.</p>', 'GetGuardrailRequest$guardrailIdentifier' => '<p>The unique identifier of the guardrail for which to get details. This can be an ID or the ARN.</p>', 'ListGuardrailsRequest$guardrailIdentifier' => '<p>The unique identifier of the guardrail. This can be an ID or the ARN.</p>', 'UpdateGuardrailRequest$guardrailIdentifier' => '<p>The unique identifier of the guardrail. This can be an ID or the ARN.</p>', ], ], 'GuardrailManagedWordLists' => [ 'base' => NULL, 'refs' => [ 'GuardrailWordPolicy$managedWordLists' => '<p>A list of managed words configured for the guardrail.</p>', ], ], 'GuardrailManagedWordListsConfig' => [ 'base' => NULL, 'refs' => [ 'GuardrailWordPolicyConfig$managedWordListsConfig' => '<p>A list of managed words to configure for the guardrail.</p>', ], ], 'GuardrailManagedWords' => [ 'base' => '<p>The managed word list that was configured for the guardrail. (This is a list of words that are pre-defined and managed by guardrails only.)</p>', 'refs' => [ 'GuardrailManagedWordLists$member' => NULL, ], ], 'GuardrailManagedWordsConfig' => [ 'base' => '<p>The managed word list to configure for the guardrail.</p>', 'refs' => [ 'GuardrailManagedWordListsConfig$member' => NULL, ], ], 'GuardrailManagedWordsType' => [ 'base' => NULL, 'refs' => [ 'GuardrailManagedWords$type' => '<p>ManagedWords$type The managed word type that was configured for the guardrail. (For now, we only offer profanity word list)</p>', 'GuardrailManagedWordsConfig$type' => '<p>The managed word type to configure for the guardrail.</p>', ], ], 'GuardrailName' => [ 'base' => NULL, 'refs' => [ 'CreateGuardrailRequest$name' => '<p>The name to give the guardrail.</p>', 'GetGuardrailResponse$name' => '<p>The name of the guardrail.</p>', 'GuardrailSummary$name' => '<p>The name of the guardrail.</p>', 'UpdateGuardrailRequest$name' => '<p>A name for the guardrail.</p>', ], ], 'GuardrailNumericalVersion' => [ 'base' => NULL, 'refs' => [ 'CreateGuardrailVersionResponse$version' => '<p>The number of the version of the guardrail.</p>', 'DeleteGuardrailRequest$guardrailVersion' => '<p>The version of the guardrail.</p>', ], ], 'GuardrailPiiEntities' => [ 'base' => NULL, 'refs' => [ 'GuardrailSensitiveInformationPolicy$piiEntities' => '<p>The list of PII entities configured for the guardrail.</p>', ], ], 'GuardrailPiiEntitiesConfig' => [ 'base' => NULL, 'refs' => [ 'GuardrailSensitiveInformationPolicyConfig$piiEntitiesConfig' => '<p>A list of PII entities to configure to the guardrail.</p>', ], ], 'GuardrailPiiEntity' => [ 'base' => '<p>The PII entity configured for the guardrail.</p>', 'refs' => [ 'GuardrailPiiEntities$member' => NULL, ], ], 'GuardrailPiiEntityConfig' => [ 'base' => '<p>The PII entity to configure for the guardrail.</p>', 'refs' => [ 'GuardrailPiiEntitiesConfig$member' => NULL, ], ], 'GuardrailPiiEntityType' => [ 'base' => NULL, 'refs' => [ 'GuardrailPiiEntity$type' => '<p>The type of PII entity. For exampvle, Social Security Number.</p>', 'GuardrailPiiEntityConfig$type' => '<p>Configure guardrail type when the PII entity is detected.</p> <p>The following PIIs are used to block or mask sensitive information:</p> <ul> <li> <p> <b>General</b> </p> <ul> <li> <p> <b>ADDRESS</b> </p> <p>A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12, Building 123". An address can include information such as the street, building, location, city, state, country, county, zip code, precinct, and neighborhood. </p> </li> <li> <p> <b>AGE</b> </p> <p>An individual\'s age, including the quantity and unit of time. For example, in the phrase "I am 40 years old," Guarrails recognizes "40 years" as an age. </p> </li> <li> <p> <b>NAME</b> </p> <p>An individual\'s name. This entity type does not include titles, such as Dr., Mr., Mrs., or Miss. guardrails doesn\'t apply this entity type to names that are part of organizations or addresses. For example, guardrails recognizes the "John Doe Organization" as an organization, and it recognizes "Jane Doe Street" as an address. </p> </li> <li> <p> <b>EMAIL</b> </p> <p>An email address, such as <i>marymajor@email.com</i>.</p> </li> <li> <p> <b>PHONE</b> </p> <p>A phone number. This entity type also includes fax and pager numbers. </p> </li> <li> <p> <b>USERNAME</b> </p> <p>A user name that identifies an account, such as a login name, screen name, nick name, or handle. </p> </li> <li> <p> <b>PASSWORD</b> </p> <p>An alphanumeric string that is used as a password, such as "*<i>very20special#pass*</i>". </p> </li> <li> <p> <b>DRIVER_ID</b> </p> <p>The number assigned to a driver\'s license, which is an official document permitting an individual to operate one or more motorized vehicles on a public road. A driver\'s license number consists of alphanumeric characters. </p> </li> <li> <p> <b>LICENSE_PLATE</b> </p> <p>A license plate for a vehicle is issued by the state or country where the vehicle is registered. The format for passenger vehicles is typically five to eight digits, consisting of upper-case letters and numbers. The format varies depending on the location of the issuing state or country. </p> </li> <li> <p> <b>VEHICLE_IDENTIFICATION_NUMBER</b> </p> <p>A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN content and format are defined in the <i>ISO 3779</i> specification. Each country has specific codes and formats for VINs. </p> </li> </ul> </li> <li> <p> <b>Finance</b> </p> <ul> <li> <p> <b>REDIT_DEBIT_CARD_CVV</b> </p> <p>A three-digit card verification code (CVV) that is present on VISA, MasterCard, and Discover credit and debit cards. For American Express credit or debit cards, the CVV is a four-digit numeric code. </p> </li> <li> <p> <b>CREDIT_DEBIT_CARD_EXPIRY</b> </p> <p>The expiration date for a credit or debit card. This number is usually four digits long and is often formatted as <i>month/year</i> or <i>MM/YY</i>. Guardrails recognizes expiration dates such as <i>01/21</i>, <i>01/2021</i>, and <i>Jan 2021</i>. </p> </li> <li> <p> <b>CREDIT_DEBIT_CARD_NUMBER</b> </p> <p>The number for a credit or debit card. These numbers can vary from 13 to 16 digits in length. However, Amazon Comprehend also recognizes credit or debit card numbers when only the last four digits are present. </p> </li> <li> <p> <b>PIN</b> </p> <p>A four-digit personal identification number (PIN) with which you can access your bank account. </p> </li> <li> <p> <b>INTERNATIONAL_BANK_ACCOUNT_NUMBER</b> </p> <p>An International Bank Account Number has specific formats in each country. For more information, see <a href="https://www.iban.com/structure">www.iban.com/structure</a>.</p> </li> <li> <p> <b>SWIFT_CODE</b> </p> <p>A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify a particular bank or branch. Banks use these codes for money transfers such as international wire transfers.</p> <p>SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to specific branches, while eight-digit codes (or 11-digit codes ending in \'XXX\') refer to the head or primary office.</p> </li> </ul> </li> <li> <p> <b>IT</b> </p> <ul> <li> <p> <b>IP_ADDRESS</b> </p> <p>An IPv4 address, such as <i>198.51.100.0</i>. </p> </li> <li> <p> <b>MAC_ADDRESS</b> </p> <p>A <i>media access control</i> (MAC) address is a unique identifier assigned to a network interface controller (NIC). </p> </li> <li> <p> <b>URL</b> </p> <p>A web address, such as <i>www.example.com</i>. </p> </li> <li> <p> <b>AWS_ACCESS_KEY</b> </p> <p>A unique identifier that\'s associated with a secret access key; you use the access key ID and secret access key to sign programmatic Amazon Web Services requests cryptographically. </p> </li> <li> <p> <b>AWS_SECRET_KEY</b> </p> <p>A unique identifier that\'s associated with an access key. You use the access key ID and secret access key to sign programmatic Amazon Web Services requests cryptographically. </p> </li> </ul> </li> <li> <p> <b>USA specific</b> </p> <ul> <li> <p> <b>US_BANK_ACCOUNT_NUMBER</b> </p> <p>A US bank account number, which is typically 10 to 12 digits long. </p> </li> <li> <p> <b>US_BANK_ROUTING_NUMBER</b> </p> <p>A US bank account routing number. These are typically nine digits long, </p> </li> <li> <p> <b>US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER</b> </p> <p>A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number that starts with a "9" and contain a "7" or "8" as the fourth digit. An ITIN can be formatted with a space or a dash after the third and forth digits. </p> </li> <li> <p> <b>US_PASSPORT_NUMBER</b> </p> <p>A US passport number. Passport numbers range from six to nine alphanumeric characters. </p> </li> <li> <p> <b>US_SOCIAL_SECURITY_NUMBER</b> </p> <p>A US Social Security Number (SSN) is a nine-digit number that is issued to US citizens, permanent residents, and temporary working residents. </p> </li> </ul> </li> <li> <p> <b>Canada specific</b> </p> <ul> <li> <p> <b>CA_HEALTH_NUMBER</b> </p> <p>A Canadian Health Service Number is a 10-digit unique identifier, required for individuals to access healthcare benefits. </p> </li> <li> <p> <b>CA_SOCIAL_INSURANCE_NUMBER</b> </p> <p>A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier, required for individuals to access government programs and benefits.</p> <p>The SIN is formatted as three groups of three digits, such as <i>123-456-789</i>. A SIN can be validated through a simple check-digit process called the <a href="https://www.wikipedia.org/wiki/Luhn_algorithm">Luhn algorithm</a>.</p> </li> </ul> </li> <li> <p> <b>UK Specific</b> </p> <ul> <li> <p> <b>UK_NATIONAL_HEALTH_SERVICE_NUMBER</b> </p> <p>A UK National Health Service Number is a 10-17 digit number, such as <i>485 777 3456</i>. The current system formats the 10-digit number with spaces after the third and sixth digits. The final digit is an error-detecting checksum.</p> </li> <li> <p> <b>UK_NATIONAL_INSURANCE_NUMBER</b> </p> <p>A UK National Insurance Number (NINO) provides individuals with access to National Insurance (social security) benefits. It is also used for some purposes in the UK tax system.</p> <p>The number is nine digits long and starts with two letters, followed by six numbers and one letter. A NINO can be formatted with a space or a dash after the two letters and after the second, forth, and sixth digits.</p> </li> <li> <p> <b>UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER</b> </p> <p>A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a taxpayer or a business. </p> </li> </ul> </li> <li> <p> <b>Custom</b> </p> <ul> <li> <p> <b>Regex filter</b> - You can use a regular expressions to define patterns for a guardrail to recognize and act upon such as serial number, booking ID etc..</p> </li> </ul> </li> </ul>', ], ], 'GuardrailRegex' => [ 'base' => '<p>The regular expression configured for the guardrail.</p>', 'refs' => [ 'GuardrailRegexes$member' => NULL, ], ], 'GuardrailRegexConfig' => [ 'base' => '<p>The regular expression to configure for the guardrail.</p>', 'refs' => [ 'GuardrailRegexesConfig$member' => NULL, ], ], 'GuardrailRegexConfigDescriptionString' => [ 'base' => NULL, 'refs' => [ 'GuardrailRegexConfig$description' => '<p>The description of the regular expression to configure for the guardrail.</p>', ], ], 'GuardrailRegexConfigNameString' => [ 'base' => NULL, 'refs' => [ 'GuardrailRegexConfig$name' => '<p>The name of the regular expression to configure for the guardrail.</p>', ], ], 'GuardrailRegexConfigPatternString' => [ 'base' => NULL, 'refs' => [ 'GuardrailRegexConfig$pattern' => '<p>The regular expression pattern to configure for the guardrail.</p>', ], ], 'GuardrailRegexDescriptionString' => [ 'base' => NULL, 'refs' => [ 'GuardrailRegex$description' => '<p>The description of the regular expression for the guardrail.</p>', ], ], 'GuardrailRegexNameString' => [ 'base' => NULL, 'refs' => [ 'GuardrailRegex$name' => '<p>The name of the regular expression for the guardrail.</p>', ], ], 'GuardrailRegexPatternString' => [ 'base' => NULL, 'refs' => [ 'GuardrailRegex$pattern' => '<p>The pattern of the regular expression configured for the guardrail.</p>', ], ], 'GuardrailRegexes' => [ 'base' => NULL, 'refs' => [ 'GuardrailSensitiveInformationPolicy$regexes' => '<p>The list of regular expressions configured for the guardrail.</p>', ], ], 'GuardrailRegexesConfig' => [ 'base' => NULL, 'refs' => [ 'GuardrailSensitiveInformationPolicyConfig$regexesConfig' => '<p>A list of regular expressions to configure to the guardrail.</p>', ], ], 'GuardrailSensitiveInformationAction' => [ 'base' => NULL, 'refs' => [ 'GuardrailPiiEntity$action' => '<p>The configured guardrail action when PII entity is detected.</p>', 'GuardrailPiiEntityConfig$action' => '<p>Configure guardrail action when the PII entity is detected.</p>', 'GuardrailRegex$action' => '<p>The action taken when a match to the regular expression is detected.</p>', 'GuardrailRegexConfig$action' => '<p>The guardrail action to configure when matching regular expression is detected.</p>', ], ], 'GuardrailSensitiveInformationPolicy' => [ 'base' => '<p>Contains details about PII entities and regular expressions configured for the guardrail.</p>', 'refs' => [ 'GetGuardrailResponse$sensitiveInformationPolicy' => '<p>The sensitive information policy that was configured for the guardrail.</p>', ], ], 'GuardrailSensitiveInformationPolicyConfig' => [ 'base' => '<p>Contains details about PII entities and regular expressions to configure for the guardrail.</p>', 'refs' => [ 'CreateGuardrailRequest$sensitiveInformationPolicyConfig' => '<p>The sensitive information policy to configure for the guardrail.</p>', 'UpdateGuardrailRequest$sensitiveInformationPolicyConfig' => '<p>The sensitive information policy to configure for the guardrail.</p>', ], ], 'GuardrailStatus' => [ 'base' => NULL, 'refs' => [ 'GetGuardrailResponse$status' => '<p>The status of the guardrail.</p>', 'GuardrailSummary$status' => '<p>The status of the guardrail.</p>', ], ], 'GuardrailStatusReason' => [ 'base' => NULL, 'refs' => [ 'GuardrailStatusReasons$member' => NULL, ], ], 'GuardrailStatusReasons' => [ 'base' => NULL, 'refs' => [ 'GetGuardrailResponse$statusReasons' => '<p>Appears if the <code>status</code> is <code>FAILED</code>. A list of reasons for why the guardrail failed to be created, updated, versioned, or deleted.</p>', ], ], 'GuardrailSummaries' => [ 'base' => NULL, 'refs' => [ 'ListGuardrailsResponse$guardrails' => '<p>A list of objects, each of which contains details about a guardrail.</p>', ], ], 'GuardrailSummary' => [ 'base' => '<p>Contains details about a guardrail.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListGuardrails.html#API_ListGuardrails_ResponseSyntax">ListGuardrails response body</a> </p> </li> </ul>', 'refs' => [ 'GuardrailSummaries$member' => NULL, ], ], 'GuardrailTopic' => [ 'base' => '<p>Details about topics for the guardrail to identify and deny.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax">GetGuardrail response body</a> </p> </li> </ul>', 'refs' => [ 'GuardrailTopics$member' => NULL, ], ], 'GuardrailTopicConfig' => [ 'base' => '<p>Details about topics for the guardrail to identify and deny.</p>', 'refs' => [ 'GuardrailTopicsConfig$member' => NULL, ], ], 'GuardrailTopicDefinition' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopic$definition' => '<p>A definition of the topic to deny.</p>', 'GuardrailTopicConfig$definition' => '<p>A definition of the topic to deny.</p>', ], ], 'GuardrailTopicExample' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopicExamples$member' => NULL, ], ], 'GuardrailTopicExamples' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopic$examples' => '<p>A list of prompts, each of which is an example of a prompt that can be categorized as belonging to the topic.</p>', 'GuardrailTopicConfig$examples' => '<p>A list of prompts, each of which is an example of a prompt that can be categorized as belonging to the topic.</p>', ], ], 'GuardrailTopicName' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopic$name' => '<p>The name of the topic to deny.</p>', 'GuardrailTopicConfig$name' => '<p>The name of the topic to deny.</p>', ], ], 'GuardrailTopicPolicy' => [ 'base' => '<p>Contains details about topics that the guardrail should identify and deny.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax">GetGuardrail response body</a> </p> </li> </ul>', 'refs' => [ 'GetGuardrailResponse$topicPolicy' => '<p>The topic policy that was configured for the guardrail.</p>', ], ], 'GuardrailTopicPolicyConfig' => [ 'base' => '<p>Contains details about topics that the guardrail should identify and deny.</p>', 'refs' => [ 'CreateGuardrailRequest$topicPolicyConfig' => '<p>The topic policies to configure for the guardrail.</p>', 'UpdateGuardrailRequest$topicPolicyConfig' => '<p>The topic policy to configure for the guardrail.</p>', ], ], 'GuardrailTopicType' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopic$type' => '<p>Specifies to deny the topic.</p>', 'GuardrailTopicConfig$type' => '<p>Specifies to deny the topic.</p>', ], ], 'GuardrailTopics' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopicPolicy$topics' => '<p>A list of policies related to topics that the guardrail should deny.</p>', ], ], 'GuardrailTopicsConfig' => [ 'base' => NULL, 'refs' => [ 'GuardrailTopicPolicyConfig$topicsConfig' => '<p>A list of policies related to topics that the guardrail should deny.</p>', ], ], 'GuardrailVersion' => [ 'base' => NULL, 'refs' => [ 'GetGuardrailRequest$guardrailVersion' => '<p>The version of the guardrail for which to get details. If you don\'t specify a version, the response returns details for the <code>DRAFT</code> version.</p>', 'GetGuardrailResponse$version' => '<p>The version of the guardrail.</p>', 'GuardrailSummary$version' => '<p>The version of the guardrail.</p>', ], ], 'GuardrailWord' => [ 'base' => '<p>A word configured for the guardrail.</p>', 'refs' => [ 'GuardrailWords$member' => NULL, ], ], 'GuardrailWordConfig' => [ 'base' => '<p>A word to configure for the guardrail.</p>', 'refs' => [ 'GuardrailWordsConfig$member' => NULL, ], ], 'GuardrailWordConfigTextString' => [ 'base' => NULL, 'refs' => [ 'GuardrailWordConfig$text' => '<p>Text of the word configured for the guardrail to block.</p>', ], ], 'GuardrailWordPolicy' => [ 'base' => '<p>Contains details about the word policy configured for the guardrail.</p>', 'refs' => [ 'GetGuardrailResponse$wordPolicy' => '<p>The word policy that was configured for the guardrail.</p>', ], ], 'GuardrailWordPolicyConfig' => [ 'base' => '<p>Contains details about the word policy to configured for the guardrail.</p>', 'refs' => [ 'CreateGuardrailRequest$wordPolicyConfig' => '<p>The word policy you configure for the guardrail.</p>', 'UpdateGuardrailRequest$wordPolicyConfig' => '<p>The word policy to configure for the guardrail.</p>', ], ], 'GuardrailWordTextString' => [ 'base' => NULL, 'refs' => [ 'GuardrailWord$text' => '<p>Text of the word configured for the guardrail to block.</p>', ], ], 'GuardrailWords' => [ 'base' => NULL, 'refs' => [ 'GuardrailWordPolicy$words' => '<p>A list of words configured for the guardrail.</p>', ], ], 'GuardrailWordsConfig' => [ 'base' => NULL, 'refs' => [ 'GuardrailWordPolicyConfig$wordsConfig' => '<p>A list of words to configure for the guardrail.</p>', ], ], 'HumanEvaluationConfig' => [ 'base' => '<p>Specifies the custom metrics, how tasks will be rated, the flow definition ARN, and your custom prompt datasets. Model evaluation jobs use human workers <i>only</i> support the use of custom prompt datasets. To learn more about custom prompt datasets and the required format, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-prompt-datasets-custom.html">Custom prompt datasets</a>.</p> <p>When you create custom metrics in <code>HumanEvaluationCustomMetric</code> you must specify the metric\'s <code>name</code>. The list of <code>names</code> specified in the <code>HumanEvaluationCustomMetric</code> array, must match the <code>metricNames</code> array of strings specified in <code>EvaluationDatasetMetricConfig</code>. For example, if in the <code>HumanEvaluationCustomMetric</code> array your specified the names <code>"accuracy", "toxicity", "readability"</code> as custom metrics <i>then</i> the <code>metricNames</code> array would need to look like the following <code>["accuracy", "toxicity", "readability"]</code> in <code>EvaluationDatasetMetricConfig</code>.</p>', 'refs' => [ 'EvaluationConfig$human' => '<p>Used to specify a model evaluation job that uses human workers.See <code>HumanEvaluationConfig</code> to view the required parameters.</p>', ], ], 'HumanEvaluationCustomMetric' => [ 'base' => '<p>In a model evaluation job that uses human workers you must define the name of the metric, and how you want that metric rated <code>ratingMethod</code>, and an optional description of the metric.</p>', 'refs' => [ 'HumanEvaluationCustomMetrics$member' => NULL, ], ], 'HumanEvaluationCustomMetrics' => [ 'base' => NULL, 'refs' => [ 'HumanEvaluationConfig$customMetrics' => '<p>A <code>HumanEvaluationCustomMetric</code> object. It contains the names the metrics, how the metrics are to be evaluated, an optional description.</p>', ], ], 'HumanTaskInstructions' => [ 'base' => NULL, 'refs' => [ 'HumanWorkflowConfig$instructions' => '<p>Instructions for the flow definition</p>', ], ], 'HumanWorkflowConfig' => [ 'base' => '<p>Contains <code>SageMakerFlowDefinition</code> object. The object is used to specify the prompt dataset, task type, rating method and metric names.</p>', 'refs' => [ 'HumanEvaluationConfig$humanWorkflowConfig' => '<p>The parameters of the human workflow.</p>', ], ], 'IdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreateEvaluationJobRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreateGuardrailRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than once. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon S3 User Guide</i>.</p>', 'CreateGuardrailVersionRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than once. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the <i>Amazon S3 User Guide</i>.</p>', 'CreateModelCopyJobRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreateModelCustomizationJobRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreateModelImportJobRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'CreateProvisionedModelThroughputRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a> in the Amazon S3 User Guide.</p>', 'GetModelCustomizationJobResponse$clientRequestToken' => '<p>The token that you specified in the <code>CreateCustomizationJob</code> request.</p>', ], ], 'ImportedModelArn' => [ 'base' => NULL, 'refs' => [ 'GetImportedModelResponse$modelArn' => '<p>The Amazon Resource Name (ARN) associated with this imported model.</p>', 'GetModelImportJobResponse$importedModelArn' => '<p>The Amazon Resource Name (ARN) of the imported model.</p>', 'ImportedModelSummary$modelArn' => '<p>The Amazon Resource Name (ARN) of the imported model.</p>', 'ModelImportJobSummary$importedModelArn' => '<p>The Amazon resource Name (ARN) of the imported model.</p>', ], ], 'ImportedModelIdentifier' => [ 'base' => NULL, 'refs' => [ 'DeleteImportedModelRequest$modelIdentifier' => '<p>Name of the imported model to delete.</p>', 'GetImportedModelRequest$modelIdentifier' => '<p>Name or Amazon Resource Name (ARN) of the imported model.</p>', ], ], 'ImportedModelName' => [ 'base' => NULL, 'refs' => [ 'CreateModelImportJobRequest$importedModelName' => '<p>The name of the imported model.</p>', 'GetImportedModelResponse$modelName' => '<p>The name of the imported model.</p>', 'GetModelImportJobResponse$importedModelName' => '<p>The name of the imported model.</p>', 'ImportedModelSummary$modelName' => '<p>Name of the imported model.</p>', 'ListImportedModelsRequest$nameContains' => '<p>Return imported models only if the model name contains these characters.</p>', 'ModelImportJobSummary$importedModelName' => '<p>The name of the imported model.</p>', ], ], 'ImportedModelSummary' => [ 'base' => '<p>Information about tne imported model.</p>', 'refs' => [ 'ImportedModelSummaryList$member' => NULL, ], ], 'ImportedModelSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListImportedModelsResponse$modelSummaries' => '<p>Model summaries.</p>', ], ], 'InferenceProfileArn' => [ 'base' => NULL, 'refs' => [ 'GetInferenceProfileResponse$inferenceProfileArn' => '<p>The Amazon Resource Name (ARN) of the inference profile.</p>', 'InferenceProfileSummary$inferenceProfileArn' => '<p>The Amazon Resource Name (ARN) of the inference profile.</p>', ], ], 'InferenceProfileDescription' => [ 'base' => NULL, 'refs' => [ 'GetInferenceProfileResponse$description' => '<p>The description of the inference profile.</p>', 'InferenceProfileSummary$description' => '<p>The description of the inference profile.</p>', ], ], 'InferenceProfileId' => [ 'base' => NULL, 'refs' => [ 'GetInferenceProfileResponse$inferenceProfileId' => '<p>The unique identifier of the inference profile.</p>', 'InferenceProfileSummary$inferenceProfileId' => '<p>The unique identifier of the inference profile.</p>', ], ], 'InferenceProfileIdentifier' => [ 'base' => NULL, 'refs' => [ 'GetInferenceProfileRequest$inferenceProfileIdentifier' => '<p>The unique identifier of the inference profile.</p>', ], ], 'InferenceProfileModel' => [ 'base' => '<p>Contains information about a model.</p>', 'refs' => [ 'InferenceProfileModels$member' => NULL, ], ], 'InferenceProfileModels' => [ 'base' => NULL, 'refs' => [ 'GetInferenceProfileResponse$models' => '<p>A list of information about each model in the inference profile.</p>', 'InferenceProfileSummary$models' => '<p>A list of information about each model in the inference profile.</p>', ], ], 'InferenceProfileName' => [ 'base' => NULL, 'refs' => [ 'GetInferenceProfileResponse$inferenceProfileName' => '<p>The name of the inference profile.</p>', 'InferenceProfileSummary$inferenceProfileName' => '<p>The name of the inference profile.</p>', ], ], 'InferenceProfileStatus' => [ 'base' => NULL, 'refs' => [ 'GetInferenceProfileResponse$status' => '<p>The status of the inference profile. <code>ACTIVE</code> means that the inference profile is available to use.</p>', 'InferenceProfileSummary$status' => '<p>The status of the inference profile. <code>ACTIVE</code> means that the inference profile is available to use.</p>', ], ], 'InferenceProfileSummaries' => [ 'base' => NULL, 'refs' => [ 'ListInferenceProfilesResponse$inferenceProfileSummaries' => '<p>A list of information about each inference profile that you can use.</p>', ], ], 'InferenceProfileSummary' => [ 'base' => '<p>Contains information about an inference profile.</p>', 'refs' => [ 'InferenceProfileSummaries$member' => NULL, ], ], 'InferenceProfileType' => [ 'base' => NULL, 'refs' => [ 'GetInferenceProfileResponse$type' => '<p>The type of the inference profile. <code>SYSTEM_DEFINED</code> means that the inference profile is defined by Amazon Bedrock.</p>', 'InferenceProfileSummary$type' => '<p>The type of the inference profile. <code>SYSTEM_DEFINED</code> means that the inference profile is defined by Amazon Bedrock.</p>', ], ], 'InferenceType' => [ 'base' => NULL, 'refs' => [ 'InferenceTypeList$member' => NULL, 'ListFoundationModelsRequest$byInferenceType' => '<p>Return models that support the inference type that you specify. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html">Provisioned Throughput</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', ], ], 'InferenceTypeList' => [ 'base' => NULL, 'refs' => [ 'FoundationModelDetails$inferenceTypesSupported' => '<p>The inference types that the model supports.</p>', 'FoundationModelSummary$inferenceTypesSupported' => '<p>The inference types that the model supports.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal server error occurred. Retry your request.</p>', 'refs' => [], ], 'JobName' => [ 'base' => NULL, 'refs' => [ 'CreateModelCustomizationJobRequest$jobName' => '<p>A name for the fine-tuning job.</p>', 'CreateModelImportJobRequest$jobName' => '<p>The name of the import job.</p>', 'GetCustomModelResponse$jobName' => '<p>Job name associated with this model.</p>', 'GetImportedModelResponse$jobName' => '<p>Job name associated with the imported model.</p>', 'GetModelCustomizationJobResponse$jobName' => '<p>The name of the customization job.</p>', 'GetModelImportJobResponse$jobName' => '<p>The name of the import job.</p>', 'ListModelCustomizationJobsRequest$nameContains' => '<p>Return customization jobs only if the job name contains these characters.</p>', 'ListModelImportJobsRequest$nameContains' => '<p>Return imported jobs only if the job name contains these characters.</p>', 'ModelCustomizationJobSummary$jobName' => '<p>Name of the customization job.</p>', 'ModelImportJobSummary$jobName' => '<p>The name of the import job.</p>', ], ], 'KeyPrefix' => [ 'base' => NULL, 'refs' => [ 'S3Config$keyPrefix' => '<p>S3 prefix. </p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'GetCustomModelResponse$modelKmsKeyArn' => '<p>The custom model is encrypted at rest using this key.</p>', 'GetGuardrailResponse$kmsKeyArn' => '<p>The ARN of the KMS key that encrypts the guardrail.</p>', 'GetImportedModelResponse$modelKmsKeyArn' => '<p>The imported model is encrypted at rest using this key.</p>', 'GetModelCopyJobResponse$targetModelKmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key encrypting the copied model.</p>', 'GetModelCustomizationJobResponse$outputModelKmsKeyArn' => '<p>The custom model is encrypted at rest using this key.</p>', 'GetModelImportJobResponse$importedModelKmsKeyArn' => '<p>The imported model is encrypted at rest using this key.</p>', 'ModelCopyJobSummary$targetModelKmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key used to encrypt the copied model.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CreateEvaluationJobRequest$customerEncryptionKeyId' => '<p>Specify your customer managed key ARN that will be used to encrypt your model evaluation job.</p>', 'CreateGuardrailRequest$kmsKeyId' => '<p>The ARN of the KMS key that you use to encrypt the guardrail.</p>', 'CreateModelCopyJobRequest$modelKmsKeyId' => '<p>The ARN of the KMS key that you use to encrypt the model copy.</p>', 'CreateModelCustomizationJobRequest$customModelKmsKeyId' => '<p>The custom model is encrypted at rest using this key.</p>', 'CreateModelImportJobRequest$importedModelKmsKeyId' => '<p>The imported model is encrypted at rest using this key.</p>', 'GetEvaluationJobResponse$customerEncryptionKeyId' => '<p>The Amazon Resource Name (ARN) of the customer managed key specified when the model evaluation job was created.</p>', 'ModelInvocationJobS3OutputDataConfig$s3EncryptionKeyId' => '<p>The unique identifier of the key that encrypts the S3 location of the output data.</p>', 'UpdateGuardrailRequest$kmsKeyId' => '<p>The ARN of the KMS key with which to encrypt the guardrail.</p>', ], ], 'ListCustomModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEvaluationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEvaluationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFoundationModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFoundationModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGuardrailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGuardrailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImportedModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImportedModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInferenceProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelCopyJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelCopyJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelCustomizationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelCustomizationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListModelInvocationJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListModelInvocationJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProvisionedModelThroughputsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProvisionedModelThroughputsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogGroupName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchConfig$logGroupName' => '<p>The log group name.</p>', ], ], 'LoggingConfig' => [ 'base' => '<p>Configuration fields for invocation logging.</p>', 'refs' => [ 'GetModelInvocationLoggingConfigurationResponse$loggingConfig' => '<p>The current configuration values.</p>', 'PutModelInvocationLoggingConfigurationRequest$loggingConfig' => '<p>The logging configuration values to set.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCustomModelsRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListEvaluationJobsRequest$maxResults' => '<p>The maximum number of results to return.</p>', 'ListGuardrailsRequest$maxResults' => '<p>The maximum number of results to return in the response.</p>', 'ListImportedModelsRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListInferenceProfilesRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListModelCopyJobsRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListModelCustomizationJobsRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListModelImportJobsRequest$maxResults' => '<p>The maximum number of results to return in the response. If the total number of results is greater than this value, use the token returned in the response in the <code>nextToken</code> field when making another request to return the next batch of results.</p>', 'ListModelInvocationJobsRequest$maxResults' => '<p>The maximum number of results to return. If there are more results than the number that you specify, a <code>nextToken</code> value is returned. Use the <code>nextToken</code> in a request to return the next batch of results.</p>', 'ListProvisionedModelThroughputsRequest$maxResults' => '<p>THe maximum number of results to return in the response. If there are more results than the number you specified, the response returns a <code>nextToken</code> value. To see the next batch of results, send the <code>nextToken</code> value in another list request.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'GetModelInvocationJobResponse$message' => '<p>If the batch inference job failed, this field contains a message describing why the job failed.</p>', 'ModelInvocationJobSummary$message' => '<p>If the batch inference job failed, this field contains a message describing why the job failed.</p>', ], ], 'MetricFloat' => [ 'base' => NULL, 'refs' => [ 'TrainingMetrics$trainingLoss' => '<p>Loss metric associated with the custom job.</p>', 'ValidatorMetric$validationLoss' => '<p>The validation loss associated with this validator.</p>', ], ], 'ModelArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelCopyJobRequest$sourceModelArn' => '<p>The Amazon Resource Name (ARN) of the model to be copied.</p>', 'CustomModelSummary$baseModelArn' => '<p>The base model Amazon Resource Name (ARN).</p>', 'GetCustomModelResponse$modelArn' => '<p>Amazon Resource Name (ARN) associated with this model.</p>', 'GetCustomModelResponse$baseModelArn' => '<p>Amazon Resource Name (ARN) of the base model.</p>', 'GetModelCopyJobResponse$sourceModelArn' => '<p>The Amazon Resource Name (ARN) of the original model being copied.</p>', 'GetProvisionedModelThroughputResponse$modelArn' => '<p>The Amazon Resource Name (ARN) of the model associated with this Provisioned Throughput.</p>', 'GetProvisionedModelThroughputResponse$desiredModelArn' => '<p>The Amazon Resource Name (ARN) of the model requested to be associated to this Provisioned Throughput. This value differs from the <code>modelArn</code> if updating hasn\'t completed.</p>', 'ListCustomModelsRequest$baseModelArnEquals' => '<p>Return custom models only if the base model Amazon Resource Name (ARN) matches this parameter.</p>', 'ListModelCopyJobsRequest$sourceModelArnEquals' => '<p>Filters for model copy jobs in which the Amazon Resource Name (ARN) of the source model to is equal to the value that you specify.</p>', 'ListProvisionedModelThroughputsRequest$modelArnEquals' => '<p>A filter that returns Provisioned Throughputs whose model Amazon Resource Name (ARN) is equal to the value that you specify.</p>', 'ModelCopyJobSummary$sourceModelArn' => '<p>The Amazon Resource Name (ARN) of the original model being copied.</p>', 'ModelCustomizationJobSummary$baseModelArn' => '<p>Amazon Resource Name (ARN) of the base model.</p>', 'ProvisionedModelSummary$modelArn' => '<p>The Amazon Resource Name (ARN) of the model associated with the Provisioned Throughput.</p>', 'ProvisionedModelSummary$desiredModelArn' => '<p>The Amazon Resource Name (ARN) of the model requested to be associated to this Provisioned Throughput. This value differs from the <code>modelArn</code> if updating hasn\'t completed.</p>', ], ], 'ModelCopyJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelCopyJobResponse$jobArn' => '<p>The Amazon Resource Name (ARN) of the model copy job.</p>', 'GetModelCopyJobRequest$jobArn' => '<p>The Amazon Resource Name (ARN) of the model copy job.</p>', 'GetModelCopyJobResponse$jobArn' => '<p>The Amazon Resource Name (ARN) of the model copy job.</p>', 'ModelCopyJobSummary$jobArn' => '<p>The Amazon Resoource Name (ARN) of the model copy job.</p>', ], ], 'ModelCopyJobStatus' => [ 'base' => NULL, 'refs' => [ 'GetModelCopyJobResponse$status' => '<p>The status of the model copy job.</p>', 'ListModelCopyJobsRequest$statusEquals' => '<p>Filters for model copy jobs whose status matches the value that you specify.</p>', 'ModelCopyJobSummary$status' => '<p>The status of the model copy job.</p>', ], ], 'ModelCopyJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListModelCopyJobsResponse$modelCopyJobSummaries' => '<p>A list of information about each model copy job.</p>', ], ], 'ModelCopyJobSummary' => [ 'base' => '<p>Contains details about each model copy job.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelCopyJobs.html#API_ListModelCopyJobs_ResponseSyntax">ListModelCopyJobs response</a> </p> </li> </ul>', 'refs' => [ 'ModelCopyJobSummaries$member' => NULL, ], ], 'ModelCustomization' => [ 'base' => NULL, 'refs' => [ 'ListFoundationModelsRequest$byCustomizationType' => '<p>Return models that support the customization type that you specify. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html">Custom models</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'ModelCustomizationList$member' => NULL, ], ], 'ModelCustomizationHyperParameters' => [ 'base' => NULL, 'refs' => [ 'CreateModelCustomizationJobRequest$hyperParameters' => '<p>Parameters related to tuning the model. For details on the format for different models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">Custom model hyperparameters</a>.</p>', 'GetCustomModelResponse$hyperParameters' => '<p>Hyperparameter values associated with this model. For details on the format for different models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">Custom model hyperparameters</a>.</p>', 'GetModelCustomizationJobResponse$hyperParameters' => '<p>The hyperparameter values for the job. For details on the format for different models, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">Custom model hyperparameters</a>.</p>', ], ], 'ModelCustomizationJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelCustomizationJobResponse$jobArn' => '<p>Amazon Resource Name (ARN) of the fine tuning job</p>', 'GetCustomModelResponse$jobArn' => '<p>Job Amazon Resource Name (ARN) associated with this model.</p>', 'GetModelCustomizationJobResponse$jobArn' => '<p>The Amazon Resource Name (ARN) of the customization job.</p>', 'ModelCustomizationJobSummary$jobArn' => '<p>Amazon Resource Name (ARN) of the customization job.</p>', ], ], 'ModelCustomizationJobIdentifier' => [ 'base' => NULL, 'refs' => [ 'GetModelCustomizationJobRequest$jobIdentifier' => '<p>Identifier for the customization job.</p>', 'StopModelCustomizationJobRequest$jobIdentifier' => '<p>Job identifier of the job to stop.</p>', ], ], 'ModelCustomizationJobStatus' => [ 'base' => NULL, 'refs' => [ 'GetModelCustomizationJobResponse$status' => '<p>The status of the job. A successful job transitions from in-progress to completed when the output model is ready to use. If the job failed, the failure message contains information about why the job failed.</p>', 'ModelCustomizationJobSummary$status' => '<p>Status of the customization job. </p>', ], ], 'ModelCustomizationJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListModelCustomizationJobsResponse$modelCustomizationJobSummaries' => '<p>Job summaries.</p>', ], ], 'ModelCustomizationJobSummary' => [ 'base' => '<p>Information about one customization job</p>', 'refs' => [ 'ModelCustomizationJobSummaries$member' => NULL, ], ], 'ModelCustomizationList' => [ 'base' => NULL, 'refs' => [ 'FoundationModelDetails$customizationsSupported' => '<p>The customization that the model supports.</p>', 'FoundationModelSummary$customizationsSupported' => '<p>Whether the model supports fine-tuning or continual pre-training.</p>', ], ], 'ModelDataSource' => [ 'base' => '<p>Data source for the imported model.</p>', 'refs' => [ 'CreateModelImportJobRequest$modelDataSource' => '<p>The data source for the imported model.</p>', 'GetImportedModelResponse$modelDataSource' => '<p>The data source for this imported model.</p>', 'GetModelImportJobResponse$modelDataSource' => '<p>The data source for the imported model.</p>', ], ], 'ModelId' => [ 'base' => NULL, 'refs' => [ 'CreateModelInvocationJobRequest$modelId' => '<p>The unique identifier of the foundation model to use for the batch inference job.</p>', 'GetModelInvocationJobResponse$modelId' => '<p>The unique identifier of the foundation model used for model inference.</p>', 'ModelInvocationJobSummary$modelId' => '<p>The unique identifier of the foundation model used for model inference.</p>', ], ], 'ModelIdentifier' => [ 'base' => NULL, 'refs' => [ 'CreateProvisionedModelThroughputRequest$modelId' => '<p>The Amazon Resource Name (ARN) or name of the model to associate with this Provisioned Throughput. For a list of models for which you can purchase Provisioned Throughput, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#prov-throughput-models">Amazon Bedrock model IDs for purchasing Provisioned Throughput</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'DeleteCustomModelRequest$modelIdentifier' => '<p>Name of the model to delete.</p>', 'GetCustomModelRequest$modelIdentifier' => '<p>Name or Amazon Resource Name (ARN) of the custom model.</p>', 'GetFoundationModelRequest$modelIdentifier' => '<p>The model identifier. </p>', 'UpdateProvisionedModelThroughputRequest$desiredModelId' => '<p>The Amazon Resource Name (ARN) of the new model to associate with this Provisioned Throughput. You can\'t specify this field if this Provisioned Throughput is associated with a base model.</p> <p>If this Provisioned Throughput is associated with a custom model, you can specify one of the following options:</p> <ul> <li> <p>The base model from which the custom model was customized.</p> </li> <li> <p>Another custom model that was customized from the same base model as the custom model.</p> </li> </ul>', ], ], 'ModelImportJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelImportJobResponse$jobArn' => '<p>The Amazon Resource Name (ARN) of the model import job.</p>', 'GetImportedModelResponse$jobArn' => '<p>Job Amazon Resource Name (ARN) associated with the imported model.</p>', 'GetModelImportJobResponse$jobArn' => '<p>The Amazon Resource Name (ARN) of the import job.</p>', 'ModelImportJobSummary$jobArn' => '<p>The Amazon Resource Name (ARN) of the import job.</p>', ], ], 'ModelImportJobIdentifier' => [ 'base' => NULL, 'refs' => [ 'GetModelImportJobRequest$jobIdentifier' => '<p>The identifier of the import job.</p>', ], ], 'ModelImportJobStatus' => [ 'base' => NULL, 'refs' => [ 'GetModelImportJobResponse$status' => '<p>The status of the job. A successful job transitions from in-progress to completed when the imported model is ready to use. If the job failed, the failure message contains information about why the job failed.</p>', 'ListModelImportJobsRequest$statusEquals' => '<p>Return imported jobs with the specified status.</p>', 'ModelImportJobSummary$status' => '<p>The status of the imported job. </p>', ], ], 'ModelImportJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListModelImportJobsResponse$modelImportJobSummaries' => '<p>Import job summaries.</p>', ], ], 'ModelImportJobSummary' => [ 'base' => '<p>Information about the import job.</p>', 'refs' => [ 'ModelImportJobSummaries$member' => NULL, ], ], 'ModelInvocationIdempotencyToken' => [ 'base' => NULL, 'refs' => [ 'CreateModelInvocationJobRequest$clientRequestToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'GetModelInvocationJobResponse$clientRequestToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', 'ModelInvocationJobSummary$clientRequestToken' => '<p>A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring idempotency</a>.</p>', ], ], 'ModelInvocationJobArn' => [ 'base' => NULL, 'refs' => [ 'CreateModelInvocationJobResponse$jobArn' => '<p>The Amazon Resource Name (ARN) of the batch inference job.</p>', 'GetModelInvocationJobResponse$jobArn' => '<p>The Amazon Resource Name (ARN) of the batch inference job.</p>', 'ModelInvocationJobSummary$jobArn' => '<p>The Amazon Resource Name (ARN) of the batch inference job.</p>', ], ], 'ModelInvocationJobIdentifier' => [ 'base' => NULL, 'refs' => [ 'GetModelInvocationJobRequest$jobIdentifier' => '<p>The Amazon Resource Name (ARN) of the batch inference job.</p>', 'StopModelInvocationJobRequest$jobIdentifier' => '<p>The Amazon Resource Name (ARN) of the batch inference job to stop.</p>', ], ], 'ModelInvocationJobInputDataConfig' => [ 'base' => '<p>Details about the location of the input to the batch inference job.</p>', 'refs' => [ 'CreateModelInvocationJobRequest$inputDataConfig' => '<p>Details about the location of the input to the batch inference job.</p>', 'GetModelInvocationJobResponse$inputDataConfig' => '<p>Details about the location of the input to the batch inference job.</p>', 'ModelInvocationJobSummary$inputDataConfig' => '<p>Details about the location of the input to the batch inference job.</p>', ], ], 'ModelInvocationJobName' => [ 'base' => NULL, 'refs' => [ 'CreateModelInvocationJobRequest$jobName' => '<p>A name to give the batch inference job.</p>', 'GetModelInvocationJobResponse$jobName' => '<p>The name of the batch inference job.</p>', 'ListModelInvocationJobsRequest$nameContains' => '<p>Specify a string to filter for batch inference jobs whose names contain the string.</p>', 'ModelInvocationJobSummary$jobName' => '<p>The name of the batch inference job.</p>', ], ], 'ModelInvocationJobOutputDataConfig' => [ 'base' => '<p>Contains the configuration of the S3 location of the output data.</p>', 'refs' => [ 'CreateModelInvocationJobRequest$outputDataConfig' => '<p>Details about the location of the output of the batch inference job.</p>', 'GetModelInvocationJobResponse$outputDataConfig' => '<p>Details about the location of the output of the batch inference job.</p>', 'ModelInvocationJobSummary$outputDataConfig' => '<p>Details about the location of the output of the batch inference job.</p>', ], ], 'ModelInvocationJobS3InputDataConfig' => [ 'base' => '<p>Contains the configuration of the S3 location of the output data.</p>', 'refs' => [ 'ModelInvocationJobInputDataConfig$s3InputDataConfig' => '<p>Contains the configuration of the S3 location of the input data.</p>', ], ], 'ModelInvocationJobS3OutputDataConfig' => [ 'base' => '<p>Contains the configuration of the S3 location of the output data.</p>', 'refs' => [ 'ModelInvocationJobOutputDataConfig$s3OutputDataConfig' => '<p>Contains the configuration of the S3 location of the output data.</p>', ], ], 'ModelInvocationJobStatus' => [ 'base' => NULL, 'refs' => [ 'GetModelInvocationJobResponse$status' => '<p>The status of the batch inference job.</p>', 'ListModelInvocationJobsRequest$statusEquals' => '<p>Specify a status to filter for batch inference jobs whose statuses match the string you specify.</p>', 'ModelInvocationJobSummary$status' => '<p>The status of the batch inference job.</p>', ], ], 'ModelInvocationJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListModelInvocationJobsResponse$invocationJobSummaries' => '<p>A list of items, each of which contains a summary about a batch inference job.</p>', ], ], 'ModelInvocationJobSummary' => [ 'base' => '<p>A summary of a batch inference job.</p>', 'refs' => [ 'ModelInvocationJobSummaries$member' => NULL, ], ], 'ModelInvocationJobTimeoutDurationInHours' => [ 'base' => NULL, 'refs' => [ 'CreateModelInvocationJobRequest$timeoutDurationInHours' => '<p>The number of hours after which to force the batch inference job to time out.</p>', 'GetModelInvocationJobResponse$timeoutDurationInHours' => '<p>The number of hours after which batch inference job was set to time out.</p>', 'ModelInvocationJobSummary$timeoutDurationInHours' => '<p>The number of hours after which the batch inference job was set to time out.</p>', ], ], 'ModelModality' => [ 'base' => NULL, 'refs' => [ 'ListFoundationModelsRequest$byOutputModality' => '<p>Return models that support the output modality that you specify.</p>', 'ModelModalityList$member' => NULL, ], ], 'ModelModalityList' => [ 'base' => NULL, 'refs' => [ 'FoundationModelDetails$inputModalities' => '<p>The input modalities that the model supports.</p>', 'FoundationModelDetails$outputModalities' => '<p>The output modalities that the model supports.</p>', 'FoundationModelSummary$inputModalities' => '<p>The input modalities that the model supports.</p>', 'FoundationModelSummary$outputModalities' => '<p>The output modalities that the model supports.</p>', ], ], 'ModelName' => [ 'base' => NULL, 'refs' => [ 'CustomModelSummary$baseModelName' => '<p>The base model name.</p>', ], ], 'NonBlankString' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'TooManyTagsException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'OutputDataConfig' => [ 'base' => '<p>S3 Location of the output data.</p>', 'refs' => [ 'CreateModelCustomizationJobRequest$outputDataConfig' => '<p>S3 location for the output data.</p>', 'GetCustomModelResponse$outputDataConfig' => '<p>Output data configuration associated with this custom model.</p>', 'GetModelCustomizationJobResponse$outputDataConfig' => '<p>Output data configuration </p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListCustomModelsRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListCustomModelsResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListEvaluationJobsRequest$nextToken' => '<p>Continuation token from the previous response, for Amazon Bedrock to list the next set of results.</p>', 'ListEvaluationJobsResponse$nextToken' => '<p>Continuation token from the previous response, for Amazon Bedrock to list the next set of results.</p>', 'ListGuardrailsRequest$nextToken' => '<p>If there are more results than were returned in the response, the response returns a <code>nextToken</code> that you can send in another <code>ListGuardrails</code> request to see the next batch of results.</p>', 'ListGuardrailsResponse$nextToken' => '<p>If there are more results than were returned in the response, the response returns a <code>nextToken</code> that you can send in another <code>ListGuardrails</code> request to see the next batch of results.</p>', 'ListImportedModelsRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListImportedModelsResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListInferenceProfilesRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListInferenceProfilesResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListModelCopyJobsRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListModelCopyJobsResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListModelCustomizationJobsRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListModelCustomizationJobsResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, use this token when making another request in the <code>nextToken</code> field to return the next batch of results.</p>', 'ListModelImportJobsRequest$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListModelImportJobsResponse$nextToken' => '<p>If the total number of results is greater than the <code>maxResults</code> value provided in the request, enter the token returned in the <code>nextToken</code> field in the response in this field to return the next batch of results.</p>', 'ListModelInvocationJobsRequest$nextToken' => '<p>If there were more results than the value you specified in the <code>maxResults</code> field in a previous <code>ListModelInvocationJobs</code> request, the response would have returned a <code>nextToken</code> value. To see the next batch of results, send the <code>nextToken</code> value in another request.</p>', 'ListModelInvocationJobsResponse$nextToken' => '<p>If there are more results than can fit in the response, a <code>nextToken</code> is returned. Use the <code>nextToken</code> in a request to return the next batch of results.</p>', 'ListProvisionedModelThroughputsRequest$nextToken' => '<p>If there are more results than the number you specified in the <code>maxResults</code> field, the response returns a <code>nextToken</code> value. To see the next batch of results, specify the <code>nextToken</code> value in this field.</p>', 'ListProvisionedModelThroughputsResponse$nextToken' => '<p>If there are more results than the number you specified in the <code>maxResults</code> field, this value is returned. To see the next batch of results, include this value in the <code>nextToken</code> field in another list request.</p>', ], ], 'PositiveInteger' => [ 'base' => NULL, 'refs' => [ 'CreateProvisionedModelThroughputRequest$modelUnits' => '<p>Number of model units to allocate. A model unit delivers a specific throughput level for the specified model. The throughput level of a model unit specifies the total number of input and output tokens that it can process and generate within a span of one minute. By default, your account has no model units for purchasing Provisioned Throughputs with commitment. You must first visit the <a href="https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase">Amazon Web Services support center</a> to request MUs.</p> <p>For model unit quotas, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html#prov-thru-quotas">Provisioned Throughput quotas</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p> <p>For more information about what an MU specifies, contact your Amazon Web Services account manager.</p>', 'GetProvisionedModelThroughputResponse$modelUnits' => '<p>The number of model units allocated to this Provisioned Throughput.</p>', 'GetProvisionedModelThroughputResponse$desiredModelUnits' => '<p>The number of model units that was requested for this Provisioned Throughput.</p>', 'ProvisionedModelSummary$modelUnits' => '<p>The number of model units allocated to the Provisioned Throughput.</p>', 'ProvisionedModelSummary$desiredModelUnits' => '<p>The number of model units that was requested to be allocated to the Provisioned Throughput.</p>', ], ], 'Provider' => [ 'base' => NULL, 'refs' => [ 'ListFoundationModelsRequest$byProvider' => '<p>Return models belonging to the model provider that you specify.</p>', ], ], 'ProvisionedModelArn' => [ 'base' => NULL, 'refs' => [ 'CreateProvisionedModelThroughputResponse$provisionedModelArn' => '<p>The Amazon Resource Name (ARN) for this Provisioned Throughput.</p>', 'GetProvisionedModelThroughputResponse$provisionedModelArn' => '<p>The Amazon Resource Name (ARN) of the Provisioned Throughput.</p>', 'ProvisionedModelSummary$provisionedModelArn' => '<p>The Amazon Resource Name (ARN) of the Provisioned Throughput.</p>', ], ], 'ProvisionedModelId' => [ 'base' => NULL, 'refs' => [ 'DeleteProvisionedModelThroughputRequest$provisionedModelId' => '<p>The Amazon Resource Name (ARN) or name of the Provisioned Throughput.</p>', 'GetProvisionedModelThroughputRequest$provisionedModelId' => '<p>The Amazon Resource Name (ARN) or name of the Provisioned Throughput.</p>', 'UpdateProvisionedModelThroughputRequest$provisionedModelId' => '<p>The Amazon Resource Name (ARN) or name of the Provisioned Throughput to update.</p>', ], ], 'ProvisionedModelName' => [ 'base' => NULL, 'refs' => [ 'CreateProvisionedModelThroughputRequest$provisionedModelName' => '<p>The name for this Provisioned Throughput.</p>', 'GetProvisionedModelThroughputResponse$provisionedModelName' => '<p>The name of the Provisioned Throughput.</p>', 'ListProvisionedModelThroughputsRequest$nameContains' => '<p>A filter that returns Provisioned Throughputs if their name contains the expression that you specify.</p>', 'ProvisionedModelSummary$provisionedModelName' => '<p>The name of the Provisioned Throughput.</p>', 'UpdateProvisionedModelThroughputRequest$desiredProvisionedModelName' => '<p>The new name for this Provisioned Throughput.</p>', ], ], 'ProvisionedModelStatus' => [ 'base' => NULL, 'refs' => [ 'GetProvisionedModelThroughputResponse$status' => '<p>The status of the Provisioned Throughput. </p>', 'ListProvisionedModelThroughputsRequest$statusEquals' => '<p>A filter that returns Provisioned Throughputs if their statuses matches the value that you specify.</p>', 'ProvisionedModelSummary$status' => '<p>The status of the Provisioned Throughput.</p>', ], ], 'ProvisionedModelSummaries' => [ 'base' => NULL, 'refs' => [ 'ListProvisionedModelThroughputsResponse$provisionedModelSummaries' => '<p>A list of summaries, one for each Provisioned Throughput in the response.</p>', ], ], 'ProvisionedModelSummary' => [ 'base' => '<p>A summary of information about a Provisioned Throughput.</p> <p>This data type is used in the following API operations:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListProvisionedModelThroughputs.html#API_ListProvisionedModelThroughputs_ResponseSyntax">ListProvisionedThroughputs response</a> </p> </li> </ul>', 'refs' => [ 'ProvisionedModelSummaries$member' => NULL, ], ], 'PutModelInvocationLoggingConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutModelInvocationLoggingConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource Amazon Resource Name (ARN) was not found. Check the Amazon Resource Name (ARN) and try your request again.</p>', 'refs' => [], ], 'RoleArn' => [ 'base' => '<p>ARN of a IAM role</p>', 'refs' => [ 'CloudWatchConfig$roleArn' => '<p>The role Amazon Resource Name (ARN).</p>', 'CreateEvaluationJobRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can assume to perform tasks on your behalf. The service role must have Amazon Bedrock as the service principal, and provide access to any Amazon S3 buckets specified in the <code>EvaluationConfig</code> object. To pass this role to Amazon Bedrock, the caller of this API must have the <code>iam:PassRole</code> permission. To learn more about the required permissions, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-security.html">Required permissions</a>.</p>', 'CreateModelCustomizationJobRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM service role that Amazon Bedrock can assume to perform tasks on your behalf. For example, during model training, Amazon Bedrock needs your permission to read input data from an S3 bucket, write model artifacts to an S3 bucket. To pass this role to Amazon Bedrock, the caller of this API must have the <code>iam:PassRole</code> permission. </p>', 'CreateModelImportJobRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of the model import job.</p>', 'CreateModelInvocationJobRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch inference. You can use the console to create a default service role or follow the steps at <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html">Create a service role for batch inference</a>.</p>', 'GetEvaluationJobResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role used in the model evaluation job.</p>', 'GetModelCustomizationJobResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role.</p>', 'GetModelImportJobResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role associated with this job.</p>', 'GetModelInvocationJobResponse$roleArn' => '<p>The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch inference. You can use the console to create a default service role or follow the steps at <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html">Create a service role for batch inference</a>.</p>', 'ModelInvocationJobSummary$roleArn' => '<p>The Amazon Resource Name (ARN) of the service role with permissions to carry out and manage batch inference. You can use the console to create a default service role or follow the steps at <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html">Create a service role for batch inference</a>.</p>', ], ], 'S3Config' => [ 'base' => '<p>S3 configuration for storing log data.</p>', 'refs' => [ 'CloudWatchConfig$largeDataDeliveryS3Config' => '<p>S3 configuration for delivering a large amount of data.</p>', 'LoggingConfig$s3Config' => '<p>S3 configuration for storing log data.</p>', ], ], 'S3DataSource' => [ 'base' => '<p>The Amazon S3 data source of the imported job.</p>', 'refs' => [ 'ModelDataSource$s3DataSource' => '<p>The Amazon S3 data source of the imported model.</p>', ], ], 'S3InputFormat' => [ 'base' => NULL, 'refs' => [ 'ModelInvocationJobS3InputDataConfig$s3InputFormat' => '<p>The format of the input data.</p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'EvaluationDatasetLocation$s3Uri' => '<p>The S3 URI of the S3 bucket specified in the job.</p>', 'EvaluationOutputDataConfig$s3Uri' => '<p>The Amazon S3 URI where the results of model evaluation job are saved.</p>', 'ModelInvocationJobS3InputDataConfig$s3Uri' => '<p>The S3 location of the input data.</p>', 'ModelInvocationJobS3OutputDataConfig$s3Uri' => '<p>The S3 location of the output data.</p>', 'OutputDataConfig$s3Uri' => '<p>The S3 URI where the output data is stored.</p>', 'S3DataSource$s3Uri' => '<p>The URI of the Amazon S3 data source.</p>', 'TrainingDataConfig$s3Uri' => '<p>The S3 URI where the training data is stored.</p>', 'Validator$s3Uri' => '<p>The S3 URI where the validation data is stored.</p>', ], ], 'SageMakerFlowDefinitionArn' => [ 'base' => NULL, 'refs' => [ 'HumanWorkflowConfig$flowDefinitionArn' => '<p>The Amazon Resource Number (ARN) for the flow definition</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfig$securityGroupIds' => '<p>VPC configuration security group Ids.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The number of requests exceeds the service quota. Resubmit your request later.</p>', 'refs' => [], ], 'SortByProvisionedModels' => [ 'base' => NULL, 'refs' => [ 'ListProvisionedModelThroughputsRequest$sortBy' => '<p>The field by which to sort the returned list of Provisioned Throughputs.</p>', ], ], 'SortJobsBy' => [ 'base' => NULL, 'refs' => [ 'ListEvaluationJobsRequest$sortBy' => '<p>Allows you to sort model evaluation jobs by when they were created.</p>', 'ListModelCopyJobsRequest$sortBy' => '<p>The field to sort by in the returned list of model copy jobs.</p>', 'ListModelCustomizationJobsRequest$sortBy' => '<p>The field to sort by in the returned list of jobs.</p>', 'ListModelImportJobsRequest$sortBy' => '<p>The field to sort by in the returned list of imported jobs.</p>', 'ListModelInvocationJobsRequest$sortBy' => '<p>An attribute by which to sort the results.</p>', ], ], 'SortModelsBy' => [ 'base' => NULL, 'refs' => [ 'ListCustomModelsRequest$sortBy' => '<p>The field to sort by in the returned list of models.</p>', 'ListImportedModelsRequest$sortBy' => '<p>The field to sort by in the returned list of imported models.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListCustomModelsRequest$sortOrder' => '<p>The sort order of the results.</p>', 'ListEvaluationJobsRequest$sortOrder' => '<p>How you want the order of jobs sorted.</p>', 'ListImportedModelsRequest$sortOrder' => '<p>Specifies whetehr to sort the results in ascending or descending order.</p>', 'ListModelCopyJobsRequest$sortOrder' => '<p>Specifies whether to sort the results in ascending or descending order.</p>', 'ListModelCustomizationJobsRequest$sortOrder' => '<p>The sort order of the results.</p>', 'ListModelImportJobsRequest$sortOrder' => '<p>Specifies whether to sort the results in ascending or descending order.</p>', 'ListModelInvocationJobsRequest$sortOrder' => '<p>Specifies whether to sort the results by ascending or descending order.</p>', 'ListProvisionedModelThroughputsRequest$sortOrder' => '<p>The sort order of the results.</p>', ], ], 'StopEvaluationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopEvaluationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopModelCustomizationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopModelCustomizationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopModelInvocationJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopModelInvocationJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteEvaluationJobError$code' => '<p>A HTTP status code of the model evaluation job being deleted.</p>', 'BatchDeleteEvaluationJobError$message' => '<p>A status message about the model evaluation job deletion.</p>', 'GetImportedModelResponse$modelArchitecture' => '<p>The architecture of the imported model.</p>', 'ModelCustomizationHyperParameters$key' => NULL, 'ModelCustomizationHyperParameters$value' => NULL, ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIds$member' => NULL, ], ], 'SubnetIds' => [ 'base' => NULL, 'refs' => [ 'VpcConfig$subnetIds' => '<p>VPC configuration subnets.</p>', ], ], 'Tag' => [ 'base' => '<p>Definition of the key/value pair for a tag.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>Key for the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>Tag keys of the tags to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateEvaluationJobRequest$jobTags' => '<p>Tags to attach to the model evaluation job.</p>', 'CreateGuardrailRequest$tags' => '<p>The tags that you want to attach to the guardrail. </p>', 'CreateModelCopyJobRequest$targetModelTags' => '<p>Tags to associate with the target model. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tag resources</a> in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html">Amazon Bedrock User Guide</a>.</p>', 'CreateModelCustomizationJobRequest$jobTags' => '<p>Tags to attach to the job.</p>', 'CreateModelCustomizationJobRequest$customModelTags' => '<p>Tags to attach to the resulting custom model.</p>', 'CreateModelImportJobRequest$jobTags' => '<p>Tags to attach to this import job. </p>', 'CreateModelImportJobRequest$importedModelTags' => '<p>Tags to attach to the imported model.</p>', 'CreateModelInvocationJobRequest$tags' => '<p>Any tags to associate with the batch inference job. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html">Tagging Amazon Bedrock resources</a>.</p>', 'CreateProvisionedModelThroughputRequest$tags' => '<p>Tags to associate with this Provisioned Throughput.</p>', 'GetModelCopyJobResponse$targetModelTags' => '<p>The tags associated with the copied model.</p>', 'ListTagsForResourceResponse$tags' => '<p>An array of the tags associated with this resource.</p>', 'ModelCopyJobSummary$targetModelTags' => '<p>Tags associated with the copied model.</p>', 'TagResourceRequest$tags' => '<p>Tags to associate with the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>Value for the tag.</p>', ], ], 'TaggableResourcesArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceARN' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TagResourceRequest$resourceARN' => '<p>The Amazon Resource Name (ARN) of the resource to tag.</p>', 'TooManyTagsException$resourceName' => '<p>The name of the resource with too many tags.</p>', 'UntagResourceRequest$resourceARN' => '<p>The Amazon Resource Name (ARN) of the resource to untag.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The number of requests exceeds the limit. Resubmit your request later.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateGuardrailResponse$createdAt' => '<p>The time at which the guardrail was created.</p>', 'CustomModelSummary$creationTime' => '<p>Creation time of the model.</p>', 'EvaluationSummary$creationTime' => '<p>When the model evaluation job was created.</p>', 'GetCustomModelResponse$creationTime' => '<p>Creation time of the model.</p>', 'GetEvaluationJobResponse$creationTime' => '<p>When the model evaluation job was created.</p>', 'GetEvaluationJobResponse$lastModifiedTime' => '<p>When the model evaluation job was last modified.</p>', 'GetGuardrailResponse$createdAt' => '<p>The date and time at which the guardrail was created.</p>', 'GetGuardrailResponse$updatedAt' => '<p>The date and time at which the guardrail was updated.</p>', 'GetImportedModelResponse$creationTime' => '<p>Creation time of the imported model.</p>', 'GetInferenceProfileResponse$createdAt' => '<p>The time at which the inference profile was created.</p>', 'GetInferenceProfileResponse$updatedAt' => '<p>The time at which the inference profile was last updated.</p>', 'GetModelCopyJobResponse$creationTime' => '<p>The time at which the model copy job was created.</p>', 'GetModelCustomizationJobResponse$creationTime' => '<p>Time that the resource was created.</p>', 'GetModelCustomizationJobResponse$lastModifiedTime' => '<p>Time that the resource was last modified.</p>', 'GetModelCustomizationJobResponse$endTime' => '<p>Time that the resource transitioned to terminal state.</p>', 'GetModelImportJobResponse$creationTime' => '<p>The time the resource was created.</p>', 'GetModelImportJobResponse$lastModifiedTime' => '<p>Time the resource was last modified.</p>', 'GetModelImportJobResponse$endTime' => '<p>Time that the resource transitioned to terminal state.</p>', 'GetModelInvocationJobResponse$submitTime' => '<p>The time at which the batch inference job was submitted.</p>', 'GetModelInvocationJobResponse$lastModifiedTime' => '<p>The time at which the batch inference job was last modified.</p>', 'GetModelInvocationJobResponse$endTime' => '<p>The time at which the batch inference job ended.</p>', 'GetModelInvocationJobResponse$jobExpirationTime' => '<p>The time at which the batch inference job times or timed out.</p>', 'GetProvisionedModelThroughputResponse$creationTime' => '<p>The timestamp of the creation time for this Provisioned Throughput. </p>', 'GetProvisionedModelThroughputResponse$lastModifiedTime' => '<p>The timestamp of the last time that this Provisioned Throughput was modified. </p>', 'GetProvisionedModelThroughputResponse$commitmentExpirationTime' => '<p>The timestamp for when the commitment term for the Provisioned Throughput expires.</p>', 'GuardrailSummary$createdAt' => '<p>The date and time at which the guardrail was created.</p>', 'GuardrailSummary$updatedAt' => '<p>The date and time at which the guardrail was last updated.</p>', 'ImportedModelSummary$creationTime' => '<p>Creation time of the imported model.</p>', 'InferenceProfileSummary$createdAt' => '<p>The time at which the inference profile was created.</p>', 'InferenceProfileSummary$updatedAt' => '<p>The time at which the inference profile was last updated.</p>', 'ListCustomModelsRequest$creationTimeBefore' => '<p>Return custom models created before the specified time. </p>', 'ListCustomModelsRequest$creationTimeAfter' => '<p>Return custom models created after the specified time. </p>', 'ListEvaluationJobsRequest$creationTimeAfter' => '<p>A filter that includes model evaluation jobs created after the time specified.</p>', 'ListEvaluationJobsRequest$creationTimeBefore' => '<p>A filter that includes model evaluation jobs created prior to the time specified.</p>', 'ListImportedModelsRequest$creationTimeBefore' => '<p>Return imported models that created before the specified time.</p>', 'ListImportedModelsRequest$creationTimeAfter' => '<p>Return imported models that were created after the specified time.</p>', 'ListModelCopyJobsRequest$creationTimeAfter' => '<p>Filters for model copy jobs created after the specified time.</p>', 'ListModelCopyJobsRequest$creationTimeBefore' => '<p>Filters for model copy jobs created before the specified time. </p>', 'ListModelCustomizationJobsRequest$creationTimeAfter' => '<p>Return customization jobs created after the specified time. </p>', 'ListModelCustomizationJobsRequest$creationTimeBefore' => '<p>Return customization jobs created before the specified time. </p>', 'ListModelImportJobsRequest$creationTimeAfter' => '<p>Return import jobs that were created after the specified time.</p>', 'ListModelImportJobsRequest$creationTimeBefore' => '<p>Return import jobs that were created before the specified time.</p>', 'ListModelInvocationJobsRequest$submitTimeAfter' => '<p>Specify a time to filter for batch inference jobs that were submitted after the time you specify.</p>', 'ListModelInvocationJobsRequest$submitTimeBefore' => '<p>Specify a time to filter for batch inference jobs that were submitted before the time you specify.</p>', 'ListProvisionedModelThroughputsRequest$creationTimeAfter' => '<p>A filter that returns Provisioned Throughputs created after the specified time. </p>', 'ListProvisionedModelThroughputsRequest$creationTimeBefore' => '<p>A filter that returns Provisioned Throughputs created before the specified time. </p>', 'ModelCopyJobSummary$creationTime' => '<p>The time that the model copy job was created.</p>', 'ModelCustomizationJobSummary$lastModifiedTime' => '<p>Time that the customization job was last modified.</p>', 'ModelCustomizationJobSummary$creationTime' => '<p>Creation time of the custom model. </p>', 'ModelCustomizationJobSummary$endTime' => '<p>Time that the customization job ended.</p>', 'ModelImportJobSummary$lastModifiedTime' => '<p>The time when the import job was last modified.</p>', 'ModelImportJobSummary$creationTime' => '<p>The time import job was created.</p>', 'ModelImportJobSummary$endTime' => '<p>The time when import job ended.</p>', 'ModelInvocationJobSummary$submitTime' => '<p>The time at which the batch inference job was submitted.</p>', 'ModelInvocationJobSummary$lastModifiedTime' => '<p>The time at which the batch inference job was last modified.</p>', 'ModelInvocationJobSummary$endTime' => '<p>The time at which the batch inference job ended.</p>', 'ModelInvocationJobSummary$jobExpirationTime' => '<p>The time at which the batch inference job times or timed out.</p>', 'ProvisionedModelSummary$commitmentExpirationTime' => '<p>The timestamp for when the commitment term of the Provisioned Throughput expires.</p>', 'ProvisionedModelSummary$creationTime' => '<p>The time that the Provisioned Throughput was created. </p>', 'ProvisionedModelSummary$lastModifiedTime' => '<p>The time that the Provisioned Throughput was last modified. </p>', 'UpdateGuardrailResponse$updatedAt' => '<p>The date and time at which the guardrail was updated.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>The request contains more tags than can be associated with a resource (50 tags per resource). The maximum number of tags includes both existing tags and those included in your current request. </p>', 'refs' => [], ], 'TrainingDataConfig' => [ 'base' => '<p>S3 Location of the training data.</p>', 'refs' => [ 'CreateModelCustomizationJobRequest$trainingDataConfig' => '<p>Information about the training dataset.</p>', 'GetCustomModelResponse$trainingDataConfig' => '<p>Contains information about the training dataset.</p>', 'GetModelCustomizationJobResponse$trainingDataConfig' => '<p>Contains information about the training dataset.</p>', ], ], 'TrainingMetrics' => [ 'base' => '<p>Metrics associated with the custom job.</p>', 'refs' => [ 'GetCustomModelResponse$trainingMetrics' => '<p>Contains training metrics from the job creation.</p>', 'GetModelCustomizationJobResponse$trainingMetrics' => '<p>Contains training metrics from the job creation.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGuardrailRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGuardrailResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProvisionedModelThroughputRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProvisionedModelThroughputResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationDataConfig' => [ 'base' => '<p>Array of up to 10 validators.</p>', 'refs' => [ 'CreateModelCustomizationJobRequest$validationDataConfig' => '<p>Information about the validation dataset. </p>', 'GetCustomModelResponse$validationDataConfig' => '<p>Contains information about the validation dataset.</p>', 'GetModelCustomizationJobResponse$validationDataConfig' => '<p>Contains information about the validation dataset.</p>', ], ], 'ValidationException' => [ 'base' => '<p>Input validation failed. Check your request parameters and retry the request.</p>', 'refs' => [], ], 'ValidationMetrics' => [ 'base' => NULL, 'refs' => [ 'GetCustomModelResponse$validationMetrics' => '<p>The validation metrics from the job creation.</p>', 'GetModelCustomizationJobResponse$validationMetrics' => '<p>The loss metric for each validator that you provided in the createjob request.</p>', ], ], 'Validator' => [ 'base' => '<p>Information about a validator.</p>', 'refs' => [ 'Validators$member' => NULL, ], ], 'ValidatorMetric' => [ 'base' => '<p>The metric for the validator.</p>', 'refs' => [ 'ValidationMetrics$member' => NULL, ], ], 'Validators' => [ 'base' => NULL, 'refs' => [ 'ValidationDataConfig$validators' => '<p>Information about the validators.</p>', ], ], 'VpcConfig' => [ 'base' => '<p>VPC configuration.</p>', 'refs' => [ 'CreateModelCustomizationJobRequest$vpcConfig' => '<p>VPC configuration (optional). Configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for this job.</p>', 'CreateModelImportJobRequest$vpcConfig' => '<p>VPC configuration parameters for the private Virtual Private Cloud (VPC) that contains the resources you are using for the import job.</p>', 'GetModelCustomizationJobResponse$vpcConfig' => '<p>VPC configuration for the custom model job.</p>', 'GetModelImportJobResponse$vpcConfig' => '<p>The Virtual Private Cloud (VPC) configuration of the import model job.</p>', ], ], ],];
