<?php
// This file was auto-generated from sdk-root/src/data/chime-sdk-messaging/2021-05-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Amazon Chime SDK messaging APIs in this section allow software developers to send and receive messages in custom messaging applications. These APIs depend on the frameworks provided by the Amazon Chime SDK identity APIs. For more information about the messaging APIs, see <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_Operations_Amazon_Chime_SDK_Messaging.html">Amazon Chime SDK messaging</a>.</p>', 'operations' => [ 'AssociateChannelFlow' => '<p>Associates a channel flow with a channel. Once associated, all messages to that channel go through channel flow processors. To stop processing, use the <code>DisassociateChannelFlow</code> API.</p> <note> <p>Only administrators or channel moderators can associate a channel flow. The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'BatchCreateChannelMembership' => '<p>Adds a specified number of users and bots to a channel. </p>', 'ChannelFlowCallback' => '<p>Calls back Amazon Chime SDK messaging with a processing response message. This should be invoked from the processor Lambda. This is a developer API.</p> <p>You can return one of the following processing responses:</p> <ul> <li> <p>Update message content or metadata</p> </li> <li> <p>Deny a message</p> </li> <li> <p>Make no changes to the message</p> </li> </ul>', 'CreateChannel' => '<p>Creates a channel to which you can add users and send messages.</p> <p> <b>Restriction</b>: You can\'t change a channel\'s privacy.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'CreateChannelBan' => '<p>Permanently bans a member from a channel. Moderators can\'t add banned members to a channel. To undo a ban, you first have to <code>DeleteChannelBan</code>, and then <code>CreateChannelMembership</code>. Bans are cleaned up when you delete users or channels.</p> <p>If you ban a user who is already part of a channel, that user is automatically kicked from the channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'CreateChannelFlow' => '<p>Creates a channel flow, a container for processors. Processors are AWS Lambda functions that perform actions on chat messages, such as stripping out profanity. You can associate channel flows with channels, and the processors in the channel flow then take action on all messages sent to that channel. This is a developer API.</p> <p>Channel flows process the following items:</p> <ol> <li> <p>New and updated messages</p> </li> <li> <p>Persistent and non-persistent messages</p> </li> <li> <p>The Standard message type</p> </li> </ol> <note> <p>Channel flows don\'t process Control or System messages. For more information about the message types provided by Chime SDK messaging, refer to <a href="https://docs.aws.amazon.com/chime/latest/dg/using-the-messaging-sdk.html#msg-types">Message types</a> in the <i>Amazon Chime developer guide</i>.</p> </note>', 'CreateChannelMembership' => '<p>Adds a member to a channel. The <code>InvitedBy</code> field in <code>ChannelMembership</code> is derived from the request header. A channel member can:</p> <ul> <li> <p>List messages</p> </li> <li> <p>Send messages</p> </li> <li> <p>Receive messages</p> </li> <li> <p>Edit their own messages</p> </li> <li> <p>Leave the channel</p> </li> </ul> <p>Privacy settings impact this action as follows:</p> <ul> <li> <p>Public Channels: You do not need to be a member to list messages, but you must be a member to send messages.</p> </li> <li> <p>Private Channels: You must be a member to list or send messages.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUserArn</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'CreateChannelModerator' => '<p>Creates a new <code>ChannelModerator</code>. A channel moderator can:</p> <ul> <li> <p>Add and remove other members of the channel.</p> </li> <li> <p>Add and remove other moderators of the channel.</p> </li> <li> <p>Add and remove user bans for the channel.</p> </li> <li> <p>Redact messages in the channel.</p> </li> <li> <p>List messages in the channel.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code>of the user that makes the API call as the value in the header.</p> </note>', 'DeleteChannel' => '<p>Immediately makes a channel and its memberships inaccessible and marks them for deletion. This is an irreversible process.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUserArn</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'DeleteChannelBan' => '<p>Removes a member from a channel\'s ban list.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'DeleteChannelFlow' => '<p>Deletes a channel flow, an irreversible process. This is a developer API.</p> <note> <p> This API works only when the channel flow is not associated with any channel. To get a list of all channels that a channel flow is associated with, use the <code>ListChannelsAssociatedWithChannelFlow</code> API. Use the <code>DisassociateChannelFlow</code> API to disassociate a channel flow from all channels. </p> </note>', 'DeleteChannelMembership' => '<p>Removes a member from a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DeleteChannelMessage' => '<p>Deletes a channel message. Only admins can perform this action. Deletion makes messages inaccessible immediately. A background process deletes any revisions created by <code>UpdateChannelMessage</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'DeleteChannelModerator' => '<p>Deletes a channel moderator.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'DeleteMessagingStreamingConfigurations' => '<p>Deletes the streaming configurations for an <code>AppInstance</code>. For more information, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html">Streaming messaging data</a> in the <i>Amazon Chime SDK Developer Guide</i>.</p>', 'DescribeChannel' => '<p>Returns the full details of a channel in an Amazon Chime <code>AppInstance</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'DescribeChannelBan' => '<p>Returns the full details of a channel ban.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'DescribeChannelFlow' => '<p>Returns the full details of a channel flow in an Amazon Chime <code>AppInstance</code>. This is a developer API.</p>', 'DescribeChannelMembership' => '<p>Returns the full details of a user\'s channel membership.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'DescribeChannelMembershipForAppInstanceUser' => '<p> Returns the details of a channel based on the membership of the specified <code>AppInstanceUser</code> or <code>AppInstanceBot</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'DescribeChannelModeratedByAppInstanceUser' => '<p>Returns the full details of a channel moderated by the specified <code>AppInstanceUser</code> or <code>AppInstanceBot</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'DescribeChannelModerator' => '<p>Returns the full details of a single ChannelModerator.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the <code>AppInstanceUserArn</code> of the user that makes the API call as the value in the header.</p> </note>', 'DisassociateChannelFlow' => '<p>Disassociates a channel flow from all its channels. Once disassociated, all messages to that channel stop going through the channel flow processor.</p> <note> <p>Only administrators or channel moderators can disassociate a channel flow.</p> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'GetChannelMembershipPreferences' => '<p>Gets the membership preferences of an <code>AppInstanceUser</code> or <code>AppInstanceBot</code> for the specified channel. A user or a bot must be a member of the channel and own the membership in order to retrieve membership preferences. Users or bots in the <code>AppInstanceAdmin</code> and channel moderator roles can\'t retrieve preferences for other users or bots. Banned users or bots can\'t retrieve membership preferences for the channel from which they are banned.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'GetChannelMessage' => '<p>Gets the full details of a channel message.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'GetChannelMessageStatus' => '<p>Gets message status for a specified <code>messageId</code>. Use this API to determine the intermediate status of messages going through channel flow processing. The API provides an alternative to retrieving message status if the event was not received because a client wasn\'t connected to a websocket. </p> <p>Messages can have any one of these statuses.</p> <dl> <dt>SENT</dt> <dd> <p>Message processed successfully</p> </dd> <dt>PENDING</dt> <dd> <p>Ongoing processing</p> </dd> <dt>FAILED</dt> <dd> <p>Processing failed</p> </dd> <dt>DENIED</dt> <dd> <p>Message denied by the processor</p> </dd> </dl> <note> <ul> <li> <p>This API does not return statuses for denied messages, because we don\'t store them once the processor denies them. </p> </li> <li> <p>Only the message sender can invoke this API.</p> </li> <li> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </li> </ul> </note>', 'GetMessagingSessionEndpoint' => '<p>The details of the endpoint for the messaging session.</p>', 'GetMessagingStreamingConfigurations' => '<p>Retrieves the data streaming configuration for an <code>AppInstance</code>. For more information, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html">Streaming messaging data</a> in the <i>Amazon Chime SDK Developer Guide</i>.</p>', 'ListChannelBans' => '<p>Lists all the users and bots banned from a particular channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'ListChannelFlows' => '<p>Returns a paginated lists of all the channel flows created under a single Chime. This is a developer API.</p>', 'ListChannelMemberships' => '<p>Lists all channel memberships in a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note> <p>If you want to list the channels to which a specific app instance user belongs, see the <a href="https://docs.aws.amazon.com/chime/latest/APIReference/API_messaging-chime_ListChannelMembershipsForAppInstanceUser.html">ListChannelMembershipsForAppInstanceUser</a> API.</p>', 'ListChannelMembershipsForAppInstanceUser' => '<p> Lists all channels that an <code>AppInstanceUser</code> or <code>AppInstanceBot</code> is a part of. Only an <code>AppInstanceAdmin</code> can call the API with a user ARN that is not their own. </p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'ListChannelMessages' => '<p>List all the messages in a channel. Returns a paginated list of <code>ChannelMessages</code>. By default, sorted by creation timestamp in descending order.</p> <note> <p>Redacted messages appear in the results as empty, since they are only redacted, not deleted. Deleted messages do not appear in the results. This action always returns the latest version of an edited message.</p> <p>Also, the <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'ListChannelModerators' => '<p>Lists all the moderators for a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'ListChannels' => '<p>Lists all Channels created under a single Chime App as a paginated list. You can specify filters to narrow results.</p> <p class="title"> <b>Functionality &amp; restrictions</b> </p> <ul> <li> <p>Use privacy = <code>PUBLIC</code> to retrieve all public channels in the account.</p> </li> <li> <p>Only an <code>AppInstanceAdmin</code> can set privacy = <code>PRIVATE</code> to list the private channels in an account.</p> </li> </ul> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'ListChannelsAssociatedWithChannelFlow' => '<p>Lists all channels associated with a specified channel flow. You can associate a channel flow with multiple channels, but you can only associate a channel with one channel flow. This is a developer API.</p>', 'ListChannelsModeratedByAppInstanceUser' => '<p>A list of the channels moderated by an <code>AppInstanceUser</code>.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'ListSubChannels' => '<p>Lists all the SubChannels in an elastic channel when given a channel ID. Available only to the app instance admins and channel moderators of elastic channels.</p>', 'ListTagsForResource' => '<p>Lists the tags applied to an Amazon Chime SDK messaging resource.</p>', 'PutChannelExpirationSettings' => '<p>Sets the number of days before the channel is automatically deleted.</p> <note> <ul> <li> <p>A background process deletes expired channels within 6 hours of expiration. Actual deletion times may vary.</p> </li> <li> <p>Expired channels that have not yet been deleted appear as active, and you can update their expiration settings. The system honors the new settings.</p> </li> <li> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </li> </ul> </note>', 'PutChannelMembershipPreferences' => '<p>Sets the membership preferences of an <code>AppInstanceUser</code> or <code>AppInstanceBot</code> for the specified channel. The user or bot must be a member of the channel. Only the user or bot who owns the membership can set preferences. Users or bots in the <code>AppInstanceAdmin</code> and channel moderator roles can\'t set preferences for other users. Banned users or bots can\'t set membership preferences for the channel from which they are banned.</p> <note> <p>The x-amz-chime-bearer request header is mandatory. Use the ARN of an <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'PutMessagingStreamingConfigurations' => '<p>Sets the data streaming configuration for an <code>AppInstance</code>. For more information, see <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/streaming-export.html">Streaming messaging data</a> in the <i>Amazon Chime SDK Developer Guide</i>.</p>', 'RedactChannelMessage' => '<p>Redacts message content, but not metadata. The message exists in the back end, but the action returns null content, and the state shows as redacted.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'SearchChannels' => '<p>Allows the <code>ChimeBearer</code> to search channels by channel members. Users or bots can search across the channels that they belong to. Users in the <code>AppInstanceAdmin</code> role can search across all channels.</p> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p>', 'SendChannelMessage' => '<p>Sends a message to a particular channel that the member is a part of.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> <p>Also, <code>STANDARD</code> messages can be up to 4KB in size and contain metadata. Metadata is arbitrary, and you can use it in a variety of ways, such as containing a link to an attachment.</p> <p> <code>CONTROL</code> messages are limited to 30 bytes and do not contain metadata.</p> </note>', 'TagResource' => '<p>Applies the specified tags to the specified Amazon Chime SDK messaging resource.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified Amazon Chime SDK messaging resource.</p>', 'UpdateChannel' => '<p>Update a channel\'s attributes.</p> <p> <b>Restriction</b>: You can\'t change a channel\'s privacy. </p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'UpdateChannelFlow' => '<p>Updates channel flow attributes. This is a developer API.</p>', 'UpdateChannelMessage' => '<p>Updates the content of a message.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', 'UpdateChannelReadMarker' => '<p>The details of the time when a user last read messages in a channel.</p> <note> <p>The <code>x-amz-chime-bearer</code> request header is mandatory. Use the ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call as the value in the header.</p> </note>', ], 'shapes' => [ 'AllowNotifications' => [ 'base' => NULL, 'refs' => [ 'PushNotificationPreferences$AllowNotifications' => '<p>Enum value that indicates which push notifications to send to the requested member of a channel. <code>ALL</code> sends all push notifications, <code>NONE</code> sends no push notifications, <code>FILTERED</code> sends only filtered push notifications. </p>', ], ], 'AppInstanceUserMembershipSummary' => [ 'base' => '<p>Summary of the membership details of an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'ChannelMembershipForAppInstanceUserSummary$AppInstanceUserMembershipSummary' => '<p>Returns the channel membership data for an <code>AppInstance</code>.</p>', ], ], 'AssociateChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'BadRequestException' => [ 'base' => '<p>The input parameters don\'t match the service\'s restrictions.</p>', 'refs' => [], ], 'BatchChannelMemberships' => [ 'base' => '<p>The membership information, including member ARNs, the channel ARN, and membership types.</p>', 'refs' => [ 'BatchCreateChannelMembershipResponse$BatchChannelMemberships' => '<p>The list of channel memberships in the response.</p>', ], ], 'BatchCreateChannelMembershipError' => [ 'base' => '<p>A list of failed member ARNs, error codes, and error messages.</p>', 'refs' => [ 'BatchCreateChannelMembershipErrors$member' => NULL, ], ], 'BatchCreateChannelMembershipErrors' => [ 'base' => NULL, 'refs' => [ 'BatchCreateChannelMembershipResponse$Errors' => '<p>If the action fails for one or more of the memberships in the request, a list of the memberships is returned, along with error codes and error messages.</p>', ], ], 'BatchCreateChannelMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchCreateChannelMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CallbackIdType' => [ 'base' => NULL, 'refs' => [ 'ChannelFlowCallbackRequest$CallbackId' => '<p>The identifier passed to the processor by the service when invoked. Use the identifier to call back the service.</p>', 'ChannelFlowCallbackResponse$CallbackId' => '<p>The call back ID passed in the request.</p>', ], ], 'Channel' => [ 'base' => '<p>The details of a channel.</p>', 'refs' => [ 'DescribeChannelResponse$Channel' => '<p>The channel details.</p>', ], ], 'ChannelAssociatedWithFlowSummary' => [ 'base' => '<p>Summary of details of a channel associated with channel flow.</p>', 'refs' => [ 'ChannelAssociatedWithFlowSummaryList$member' => NULL, ], ], 'ChannelAssociatedWithFlowSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelsAssociatedWithChannelFlowResponse$Channels' => '<p>The information about each channel.</p>', ], ], 'ChannelBan' => [ 'base' => '<p>The details of a channel ban.</p>', 'refs' => [ 'DescribeChannelBanResponse$ChannelBan' => '<p>The details of the ban.</p>', ], ], 'ChannelBanSummary' => [ 'base' => '<p>Summary of the details of a <code>ChannelBan</code>.</p>', 'refs' => [ 'ChannelBanSummaryList$member' => NULL, ], ], 'ChannelBanSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelBansResponse$ChannelBans' => '<p>The information for each requested ban.</p>', ], ], 'ChannelFlow' => [ 'base' => '<p>The details of a channel flow.</p>', 'refs' => [ 'DescribeChannelFlowResponse$ChannelFlow' => '<p>The channel flow details.</p>', ], ], 'ChannelFlowCallbackRequest' => [ 'base' => NULL, 'refs' => [], ], 'ChannelFlowCallbackResponse' => [ 'base' => NULL, 'refs' => [], ], 'ChannelFlowExecutionOrder' => [ 'base' => NULL, 'refs' => [ 'Processor$ExecutionOrder' => '<p>The sequence in which processors run. If you have multiple processors in a channel flow, message processing goes through each processor in the sequence. The value determines the sequence. At this point, we support only 1 processor within a flow.</p>', ], ], 'ChannelFlowSummary' => [ 'base' => '<p>Summary of details of a channel flow.</p>', 'refs' => [ 'ChannelFlowSummaryList$member' => NULL, ], ], 'ChannelFlowSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelFlowsResponse$ChannelFlows' => '<p>The information about each channel flow.</p>', ], ], 'ChannelId' => [ 'base' => NULL, 'refs' => [ 'CreateChannelRequest$ChannelId' => '<p>The ID of the channel in the request.</p>', ], ], 'ChannelMemberArns' => [ 'base' => NULL, 'refs' => [ 'CreateChannelRequest$MemberArns' => '<p>The ARNs of the channel members in the request.</p>', ], ], 'ChannelMembership' => [ 'base' => '<p>The details of a channel member.</p>', 'refs' => [ 'DescribeChannelMembershipResponse$ChannelMembership' => '<p>The details of the membership.</p>', ], ], 'ChannelMembershipForAppInstanceUserSummary' => [ 'base' => '<p>Summary of the channel membership details of an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'ChannelMembershipForAppInstanceUserSummaryList$member' => NULL, 'DescribeChannelMembershipForAppInstanceUserResponse$ChannelMembership' => '<p>The channel to which a user belongs.</p>', ], ], 'ChannelMembershipForAppInstanceUserSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelMembershipsForAppInstanceUserResponse$ChannelMemberships' => '<p>The information for the requested channel memberships.</p>', ], ], 'ChannelMembershipPreferences' => [ 'base' => '<p>The channel membership preferences for an <code>AppInstanceUser</code>.</p>', 'refs' => [ 'GetChannelMembershipPreferencesResponse$Preferences' => '<p>The channel membership preferences for an <code>AppInstanceUser</code> .</p>', 'PutChannelMembershipPreferencesRequest$Preferences' => '<p>The channel membership preferences of an <code>AppInstanceUser</code> .</p>', 'PutChannelMembershipPreferencesResponse$Preferences' => '<p>The ARN and metadata of the member being added.</p>', ], ], 'ChannelMembershipSummary' => [ 'base' => '<p>Summary of the details of a <code>ChannelMembership</code>.</p>', 'refs' => [ 'ChannelMembershipSummaryList$member' => NULL, ], ], 'ChannelMembershipSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelMembershipsResponse$ChannelMemberships' => '<p>The information for the requested channel memberships.</p>', ], ], 'ChannelMembershipType' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUserMembershipSummary$Type' => '<p>The type of <code>ChannelMembership</code>.</p>', 'BatchChannelMemberships$Type' => '<p>The membership types set for the channel members.</p>', 'BatchCreateChannelMembershipRequest$Type' => '<p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>', 'ChannelMembership$Type' => '<p>The membership type set for the channel member.</p>', 'CreateChannelMembershipRequest$Type' => '<p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are always returned as part of <code>ListChannelMemberships</code>. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>. Otherwise hidden members are not returned. This is only supported by moderators.</p>', 'ListChannelMembershipsRequest$Type' => '<p>The membership type of a user, <code>DEFAULT</code> or <code>HIDDEN</code>. Default members are returned as part of <code>ListChannelMemberships</code> if no type is specified. Hidden members are only returned if the type filter in <code>ListChannelMemberships</code> equals <code>HIDDEN</code>.</p>', ], ], 'ChannelMessage' => [ 'base' => '<p>The details of a message in a channel.</p>', 'refs' => [ 'GetChannelMessageResponse$ChannelMessage' => '<p>The details of and content in the message.</p>', ], ], 'ChannelMessageCallback' => [ 'base' => '<p>Stores information about a callback.</p>', 'refs' => [ 'ChannelFlowCallbackRequest$ChannelMessage' => '<p>Stores information about the processed message.</p>', ], ], 'ChannelMessagePersistenceType' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$Persistence' => '<p>The persistence setting for a channel message.</p>', 'SendChannelMessageRequest$Persistence' => '<p>Boolean that controls whether the message is persisted on the back end. Required.</p>', ], ], 'ChannelMessageStatus' => [ 'base' => NULL, 'refs' => [ 'ChannelMessageStatusStructure$Value' => '<p>The message status value.</p>', ], ], 'ChannelMessageStatusStructure' => [ 'base' => '<p>Stores information about a message status.</p>', 'refs' => [ 'ChannelMessage$Status' => '<p>The status of the channel message.</p>', 'ChannelMessageSummary$Status' => '<p>The message status. The status value is <code>SENT</code> for messages sent to a channel without a channel flow. For channels associated with channel flow, the value determines the processing stage.</p>', 'GetChannelMessageStatusResponse$Status' => '<p>The message status and details.</p>', 'SendChannelMessageResponse$Status' => '<p>The status of the channel message.</p>', 'UpdateChannelMessageResponse$Status' => '<p>The status of the message update.</p>', ], ], 'ChannelMessageSummary' => [ 'base' => '<p>Summary of the messages in a <code>Channel</code>.</p>', 'refs' => [ 'ChannelMessageSummaryList$member' => NULL, ], ], 'ChannelMessageSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelMessagesResponse$ChannelMessages' => '<p>The information about, and content of, each requested message.</p>', ], ], 'ChannelMessageType' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$Type' => '<p>The message type.</p>', 'ChannelMessageSummary$Type' => '<p>The type of message.</p>', 'SendChannelMessageRequest$Type' => '<p>The type of message, <code>STANDARD</code> or <code>CONTROL</code>.</p> <p> <code>STANDARD</code> messages can be up to 4KB in size and contain metadata. Metadata is arbitrary, and you can use it in a variety of ways, such as containing a link to an attachment.</p> <p> <code>CONTROL</code> messages are limited to 30 bytes and do not contain metadata.</p>', ], ], 'ChannelMode' => [ 'base' => NULL, 'refs' => [ 'Channel$Mode' => '<p>The mode of the channel.</p>', 'ChannelAssociatedWithFlowSummary$Mode' => '<p>The mode of the channel.</p>', 'ChannelSummary$Mode' => '<p>The mode of the channel.</p>', 'CreateChannelRequest$Mode' => '<p>The channel mode: <code>UNRESTRICTED</code> or <code>RESTRICTED</code>. Administrators, moderators, and channel members can add themselves and other members to unrestricted channels. Only administrators and moderators can add members to restricted channels.</p>', 'UpdateChannelRequest$Mode' => '<p>The mode of the update request.</p>', ], ], 'ChannelModeratedByAppInstanceUserSummary' => [ 'base' => '<p>Summary of the details of a moderated channel.</p>', 'refs' => [ 'ChannelModeratedByAppInstanceUserSummaryList$member' => NULL, 'DescribeChannelModeratedByAppInstanceUserResponse$Channel' => '<p>The moderated channel.</p>', ], ], 'ChannelModeratedByAppInstanceUserSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelsModeratedByAppInstanceUserResponse$Channels' => '<p>The moderated channels in the request.</p>', ], ], 'ChannelModerator' => [ 'base' => '<p>The details of a channel moderator.</p>', 'refs' => [ 'DescribeChannelModeratorResponse$ChannelModerator' => '<p>The details of the channel moderator.</p>', ], ], 'ChannelModeratorArns' => [ 'base' => NULL, 'refs' => [ 'CreateChannelRequest$ModeratorArns' => '<p>The ARNs of the channel moderators in the request.</p>', ], ], 'ChannelModeratorSummary' => [ 'base' => '<p>Summary of the details of a <code>ChannelModerator</code>.</p>', 'refs' => [ 'ChannelModeratorSummaryList$member' => NULL, ], ], 'ChannelModeratorSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelModeratorsResponse$ChannelModerators' => '<p>The information about and names of each moderator.</p>', ], ], 'ChannelPrivacy' => [ 'base' => NULL, 'refs' => [ 'Channel$Privacy' => '<p>The channel\'s privacy setting.</p>', 'ChannelAssociatedWithFlowSummary$Privacy' => '<p>The channel\'s privacy setting.</p>', 'ChannelSummary$Privacy' => '<p>The privacy setting of the channel.</p>', 'CreateChannelRequest$Privacy' => '<p>The channel\'s privacy level: <code>PUBLIC</code> or <code>PRIVATE</code>. Private channels aren\'t discoverable by users outside the channel. Public channels are discoverable by anyone in the <code>AppInstance</code>.</p>', 'ListChannelsRequest$Privacy' => '<p>The privacy setting. <code>PUBLIC</code> retrieves all the public channels. <code>PRIVATE</code> retrieves private channels. Only an <code>AppInstanceAdmin</code> can retrieve private channels. </p>', ], ], 'ChannelSummary' => [ 'base' => '<p>Summary of the details of a <code>Channel</code>.</p>', 'refs' => [ 'ChannelMembershipForAppInstanceUserSummary$ChannelSummary' => '<p>Returns the channel data for an <code>AppInstance</code>.</p>', 'ChannelModeratedByAppInstanceUserSummary$ChannelSummary' => '<p>Summary of the details of a <code>Channel</code>.</p>', 'ChannelSummaryList$member' => NULL, ], ], 'ChannelSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListChannelsResponse$Channels' => '<p>The information about each channel.</p>', 'SearchChannelsResponse$Channels' => '<p>A list of the channels in the request.</p>', ], ], 'ChimeArn' => [ 'base' => NULL, 'refs' => [ 'AssociateChannelFlowRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'AssociateChannelFlowRequest$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'AssociateChannelFlowRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>', 'BatchChannelMemberships$ChannelArn' => '<p>The ARN of the channel to which you\'re adding members.</p>', 'BatchCreateChannelMembershipError$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member that the service couldn\'t add.</p>', 'BatchCreateChannelMembershipRequest$ChannelArn' => '<p>The ARN of the channel to which you\'re adding users or bots.</p>', 'BatchCreateChannelMembershipRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'Channel$ChannelArn' => '<p>The ARN of a channel.</p>', 'Channel$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'ChannelAssociatedWithFlowSummary$ChannelArn' => '<p>The ARN of the channel.</p>', 'ChannelBan$ChannelArn' => '<p>The ARN of the channel from which a member is being banned.</p>', 'ChannelFlow$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'ChannelFlowCallbackRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'ChannelFlowCallbackResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'ChannelFlowSummary$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'ChannelMemberArns$member' => NULL, 'ChannelMembership$ChannelArn' => '<p>The ARN of the member\'s channel.</p>', 'ChannelMessage$ChannelArn' => '<p>The ARN of the channel.</p>', 'ChannelModerator$ChannelArn' => '<p>The ARN of the moderator\'s channel.</p>', 'ChannelModeratorArns$member' => NULL, 'ChannelSummary$ChannelArn' => '<p>The ARN of the channel.</p>', 'CreateChannelBanRequest$ChannelArn' => '<p>The ARN of the ban request.</p>', 'CreateChannelBanRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member being banned.</p>', 'CreateChannelBanRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'CreateChannelBanResponse$ChannelArn' => '<p>The ARN of the response to the ban request.</p>', 'CreateChannelFlowRequest$AppInstanceArn' => '<p>The ARN of the channel flow request.</p>', 'CreateChannelFlowResponse$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'CreateChannelMembershipRequest$ChannelArn' => '<p>The ARN of the channel to which you\'re adding users.</p>', 'CreateChannelMembershipRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member you want to add to the channel.</p>', 'CreateChannelMembershipRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'CreateChannelMembershipResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'CreateChannelModeratorRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'CreateChannelModeratorRequest$ChannelModeratorArn' => '<p>The <code>AppInstanceUserArn</code> of the moderator.</p>', 'CreateChannelModeratorRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'CreateChannelModeratorResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'CreateChannelRequest$AppInstanceArn' => '<p>The ARN of the channel request.</p>', 'CreateChannelRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'CreateChannelResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'DeleteChannelBanRequest$ChannelArn' => '<p>The ARN of the channel from which the <code>AppInstanceUser</code> was banned.</p>', 'DeleteChannelBanRequest$MemberArn' => '<p>The ARN of the <code>AppInstanceUser</code> that you want to reinstate.</p>', 'DeleteChannelBanRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'DeleteChannelFlowRequest$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'DeleteChannelMembershipRequest$ChannelArn' => '<p>The ARN of the channel from which you want to remove the user.</p>', 'DeleteChannelMembershipRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member that you\'re removing from the channel.</p>', 'DeleteChannelMembershipRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'DeleteChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DeleteChannelMessageRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'DeleteChannelModeratorRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DeleteChannelModeratorRequest$ChannelModeratorArn' => '<p>The <code>AppInstanceUserArn</code> of the moderator being deleted.</p>', 'DeleteChannelModeratorRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'DeleteChannelRequest$ChannelArn' => '<p>The ARN of the channel being deleted.</p>', 'DeleteChannelRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'DeleteMessagingStreamingConfigurationsRequest$AppInstanceArn' => '<p>The ARN of the streaming configurations being deleted.</p>', 'DescribeChannelBanRequest$ChannelArn' => '<p>The ARN of the channel from which the user is banned.</p>', 'DescribeChannelBanRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member being banned.</p>', 'DescribeChannelBanRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'DescribeChannelFlowRequest$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'DescribeChannelMembershipForAppInstanceUserRequest$ChannelArn' => '<p>The ARN of the channel to which the user belongs.</p>', 'DescribeChannelMembershipForAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the user or bot in a channel.</p>', 'DescribeChannelMembershipForAppInstanceUserRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'DescribeChannelMembershipRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DescribeChannelMembershipRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member.</p>', 'DescribeChannelMembershipRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'DescribeChannelModeratedByAppInstanceUserRequest$ChannelArn' => '<p>The ARN of the moderated channel.</p>', 'DescribeChannelModeratedByAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the user or bot in the moderated channel.</p>', 'DescribeChannelModeratedByAppInstanceUserRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'DescribeChannelModeratorRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DescribeChannelModeratorRequest$ChannelModeratorArn' => '<p>The <code>AppInstanceUserArn</code> of the channel moderator.</p>', 'DescribeChannelModeratorRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'DescribeChannelRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DescribeChannelRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'DisassociateChannelFlowRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'DisassociateChannelFlowRequest$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'DisassociateChannelFlowRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>', 'GetChannelMembershipPreferencesRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'GetChannelMembershipPreferencesRequest$MemberArn' => '<p>The <code>AppInstanceUserArn</code> of the member retrieving the preferences.</p>', 'GetChannelMembershipPreferencesRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'GetChannelMembershipPreferencesResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'GetChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'GetChannelMessageRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'GetChannelMessageStatusRequest$ChannelArn' => '<p>The ARN of the channel</p>', 'GetChannelMessageStatusRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>', 'GetMessagingStreamingConfigurationsRequest$AppInstanceArn' => '<p>The ARN of the streaming configurations.</p>', 'Identity$Arn' => '<p>The ARN in an Identity.</p>', 'ListChannelBansRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelBansRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'ListChannelBansResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelFlowsRequest$AppInstanceArn' => '<p>The ARN of the app instance.</p>', 'ListChannelMembershipsForAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the user or bot.</p>', 'ListChannelMembershipsForAppInstanceUserRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'ListChannelMembershipsRequest$ChannelArn' => '<p>The maximum number of channel memberships that you want returned.</p>', 'ListChannelMembershipsRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'ListChannelMembershipsResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelMessagesRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelMessagesRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'ListChannelMessagesResponse$ChannelArn' => '<p>The ARN of the channel containing the requested messages.</p>', 'ListChannelModeratorsRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelModeratorsRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'ListChannelModeratorsResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'ListChannelsAssociatedWithChannelFlowRequest$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'ListChannelsModeratedByAppInstanceUserRequest$AppInstanceUserArn' => '<p>The ARN of the user or bot in the moderated channel.</p>', 'ListChannelsModeratedByAppInstanceUserRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'ListChannelsRequest$AppInstanceArn' => '<p>The ARN of the <code>AppInstance</code>.</p>', 'ListChannelsRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'ListSubChannelsRequest$ChannelArn' => '<p>The ARN of elastic channel.</p>', 'ListSubChannelsRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>', 'ListSubChannelsResponse$ChannelArn' => '<p>The ARN of elastic channel.</p>', 'ListTagsForResourceRequest$ResourceARN' => '<p>The ARN of the resource.</p>', 'MemberArns$member' => NULL, 'PutChannelExpirationSettingsRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'PutChannelExpirationSettingsRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'PutChannelExpirationSettingsResponse$ChannelArn' => '<p>The channel ARN.</p>', 'PutChannelMembershipPreferencesRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'PutChannelMembershipPreferencesRequest$MemberArn' => '<p>The ARN of the member setting the preferences.</p>', 'PutChannelMembershipPreferencesRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'PutChannelMembershipPreferencesResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'PutMessagingStreamingConfigurationsRequest$AppInstanceArn' => '<p>The ARN of the streaming configuration.</p>', 'RedactChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel containing the messages that you want to redact.</p>', 'RedactChannelMessageRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'RedactChannelMessageResponse$ChannelArn' => '<p>The ARN of the channel containing the messages that you want to redact.</p>', 'SearchChannelsRequest$ChimeBearer' => '<p>The <code>AppInstanceUserArn</code> of the user making the API call.</p>', 'SendChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'SendChannelMessageRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'SendChannelMessageResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'StreamingConfiguration$ResourceArn' => '<p>The ARN of the resource in the configuration. </p>', 'TagResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'Target$MemberArn' => '<p>The ARN of the target channel member.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The resource ARN.</p>', 'UpdateChannelFlowRequest$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'UpdateChannelFlowResponse$ChannelFlowArn' => '<p>The ARN of the channel flow.</p>', 'UpdateChannelMessageRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelMessageRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'UpdateChannelMessageResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelReadMarkerRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelReadMarkerRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'UpdateChannelReadMarkerResponse$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelRequest$ChannelArn' => '<p>The ARN of the channel.</p>', 'UpdateChannelRequest$ChimeBearer' => '<p>The ARN of the <code>AppInstanceUser</code> or <code>AppInstanceBot</code> that makes the API call.</p>', 'UpdateChannelResponse$ChannelArn' => '<p>The ARN of the channel.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'CreateChannelFlowRequest$ClientRequestToken' => '<p>The client token for the request. An Idempotency token.</p>', 'CreateChannelRequest$ClientRequestToken' => '<p>The client token for the request. An <code>Idempotency</code> token.</p>', 'SendChannelMessageRequest$ClientRequestToken' => '<p>The <code>Idempotency</code> token for each client request.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request could not be processed because of conflict in the current state of the resource.</p>', 'refs' => [], ], 'Content' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$Content' => '<p>The content of the channel message. For Amazon Lex V2 bot responses, this field holds a list of messages originating from the bot. For more information, refer to <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html">Processing responses from an AppInstanceBot</a> in the <i>Amazon Chime SDK Messaging Developer Guide</i>.</p>', 'ChannelMessageSummary$Content' => '<p>The content of the channel message. For Amazon Lex V2 bot responses, this field holds a list of messages originating from the bot. For more information, refer to <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html">Processing responses from an AppInstanceBot</a> in the <i>Amazon Chime SDK Messaging Developer Guide</i>.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$ContentType' => '<p>The content type of the channel message. For Amazon Lex V2 bot responses, the content type is <code>application/amz-chime-lex-msgs</code> for success responses and <code>application/amz-chime-lex-error</code> for failure responses. For more information, refer to <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html">Processing responses from an AppInstanceBot</a> in the <i>Amazon Chime SDK Messaging Developer Guide</i>.</p>', 'ChannelMessageCallback$ContentType' => '<p>The content type of the call-back message. For Amazon Lex V2 bot responses, the content type is <code>application/amz-chime-lex-msgs</code> for success responses and <code>application/amz-chime-lex-error</code> for failure responses. For more information, refer to <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html">Processing responses from an AppInstanceBot</a> in the <i>Amazon Chime SDK Messaging Developer Guide</i>.</p>', 'ChannelMessageSummary$ContentType' => '<p>The content type of the channel message listed in the summary. For Amazon Lex V2 bot responses, the content type is <code>application/amz-chime-lex-msgs</code> for success responses and <code>application/amz-chime-lex-error</code> for failure responses. For more information, refer to <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html">Processing responses from an AppInstanceBot</a> in the <i>Amazon Chime SDK Messaging Developer Guide</i>.</p>', 'SendChannelMessageRequest$ContentType' => '<p>The content type of the channel message.</p>', 'UpdateChannelMessageRequest$ContentType' => '<p>The content type of the channel message.</p>', ], ], 'CreateChannelBanRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelBanResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelModeratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelModeratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelBanRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelModeratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMessagingStreamingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelBanRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelBanResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelMembershipForAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelMembershipForAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelModeratedByAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelModeratedByAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelModeratorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelModeratorResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'ElasticChannelConfiguration' => [ 'base' => '<p>The attributes required to configure and create an elastic channel. An elastic channel can support a maximum of 1-million members.</p>', 'refs' => [ 'Channel$ElasticChannelConfiguration' => '<p>The attributes required to configure and create an elastic channel. An elastic channel can support a maximum of 1-million members.</p>', 'CreateChannelRequest$ElasticChannelConfiguration' => '<p>The attributes required to configure and create an elastic channel. An elastic channel can support a maximum of 1-million users, excluding moderators.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Code' => NULL, 'BatchCreateChannelMembershipError$ErrorCode' => '<p>The error code.</p>', 'ConflictException$Code' => NULL, 'ForbiddenException$Code' => NULL, 'NotFoundException$Code' => NULL, 'ResourceLimitExceededException$Code' => NULL, 'ServiceFailureException$Code' => NULL, 'ServiceUnavailableException$Code' => NULL, 'ThrottledClientException$Code' => NULL, 'UnauthorizedClientException$Code' => NULL, ], ], 'ExpirationCriterion' => [ 'base' => NULL, 'refs' => [ 'ExpirationSettings$ExpirationCriterion' => '<p>The conditions that must be met for a channel to expire.</p>', ], ], 'ExpirationDays' => [ 'base' => NULL, 'refs' => [ 'ExpirationSettings$ExpirationDays' => '<p>The period in days after which the system automatically deletes a channel.</p>', ], ], 'ExpirationSettings' => [ 'base' => '<p>Settings that control the interval after which a channel is deleted.</p>', 'refs' => [ 'Channel$ExpirationSettings' => '<p>Settings that control when a channel expires.</p>', 'CreateChannelRequest$ExpirationSettings' => '<p>Settings that control the interval after which the channel is automatically deleted.</p>', 'PutChannelExpirationSettingsRequest$ExpirationSettings' => '<p>Settings that control the interval after which a channel is deleted.</p>', 'PutChannelExpirationSettingsResponse$ExpirationSettings' => '<p>Settings that control the interval after which a channel is deleted.</p>', ], ], 'FallbackAction' => [ 'base' => NULL, 'refs' => [ 'Processor$FallbackAction' => '<p>Determines whether to continue with message processing or stop it in cases where communication with a processor fails. If a processor has a fallback action of <code>ABORT</code> and communication with it fails, the processor sets the message status to <code>FAILED</code> and does not send the message to any recipients. Note that if the last processor in the channel flow sequence has a fallback action of <code>CONTINUE</code> and communication with the processor fails, then the message is considered processed and sent to recipients of the channel.</p>', ], ], 'FilterRule' => [ 'base' => NULL, 'refs' => [ 'PushNotificationPreferences$FilterRule' => '<p>The simple JSON object used to send a subset of a push notification to the requested member.</p>', ], ], 'ForbiddenException' => [ 'base' => '<p>The client is permanently forbidden from making the request.</p>', 'refs' => [], ], 'GetChannelMembershipPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelMembershipPreferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelMessageStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetChannelMessageStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMessagingSessionEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMessagingSessionEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMessagingStreamingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMessagingStreamingConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Identity' => [ 'base' => '<p>The details of a user or bot.</p>', 'refs' => [ 'BatchChannelMemberships$InvitedBy' => '<p>The identifier of the member who invited another member.</p>', 'Channel$CreatedBy' => '<p>The <code>AppInstanceUser</code> who created the channel.</p>', 'ChannelBan$Member' => '<p>The member being banned from the channel.</p>', 'ChannelBan$CreatedBy' => '<p>The <code>AppInstanceUser</code> who created the ban.</p>', 'ChannelBanSummary$Member' => '<p>The member being banned from a channel.</p>', 'ChannelMembership$InvitedBy' => '<p>The identifier of the member who invited another member.</p>', 'ChannelMembership$Member' => '<p>The data of the channel member.</p>', 'ChannelMembershipSummary$Member' => '<p>A member\'s summary data.</p>', 'ChannelMessage$Sender' => '<p>The message sender.</p>', 'ChannelMessageSummary$Sender' => '<p>The message sender.</p>', 'ChannelModerator$Moderator' => '<p>The moderator\'s data.</p>', 'ChannelModerator$CreatedBy' => '<p>The <code>AppInstanceUser</code> who created the moderator.</p>', 'ChannelModeratorSummary$Moderator' => '<p>The data for a moderator.</p>', 'CreateChannelBanResponse$Member' => '<p>The <code>ChannelArn</code> and <code>BannedIdentity</code> of the member in the ban response.</p>', 'CreateChannelMembershipResponse$Member' => '<p>The ARN and metadata of the member being added.</p>', 'CreateChannelModeratorResponse$ChannelModerator' => '<p>The ARNs of the channel and the moderator.</p>', 'GetChannelMembershipPreferencesResponse$Member' => '<p>The details of a user.</p>', 'Members$member' => NULL, 'PutChannelMembershipPreferencesResponse$Member' => '<p>The details of a user.</p>', ], ], 'InvocationType' => [ 'base' => NULL, 'refs' => [ 'LambdaConfiguration$InvocationType' => '<p>Controls how the Lambda function is invoked.</p>', ], ], 'LambdaConfiguration' => [ 'base' => '<p>Stores metadata about a Lambda processor.</p>', 'refs' => [ 'ProcessorConfiguration$Lambda' => '<p>Indicates that the processor is of type Lambda.</p>', ], ], 'LambdaFunctionArn' => [ 'base' => NULL, 'refs' => [ 'LambdaConfiguration$ResourceArn' => '<p>The ARN of the Lambda message processing function.</p>', ], ], 'ListChannelBansRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelBansResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelFlowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelFlowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMembershipsForAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMembershipsForAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMembershipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMembershipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMessagesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelMessagesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelModeratorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelModeratorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsAssociatedWithChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsAssociatedWithChannelFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsModeratedByAppInstanceUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsModeratedByAppInstanceUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSubChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSubChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListChannelBansRequest$MaxResults' => '<p>The maximum number of bans that you want returned.</p>', 'ListChannelFlowsRequest$MaxResults' => '<p>The maximum number of channel flows that you want to return.</p>', 'ListChannelMembershipsForAppInstanceUserRequest$MaxResults' => '<p>The maximum number of users that you want returned.</p>', 'ListChannelMembershipsRequest$MaxResults' => '<p>The maximum number of channel memberships that you want returned.</p>', 'ListChannelMessagesRequest$MaxResults' => '<p>The maximum number of messages that you want returned.</p>', 'ListChannelModeratorsRequest$MaxResults' => '<p>The maximum number of moderators that you want returned.</p>', 'ListChannelsAssociatedWithChannelFlowRequest$MaxResults' => '<p>The maximum number of channels that you want to return.</p>', 'ListChannelsModeratedByAppInstanceUserRequest$MaxResults' => '<p>The maximum number of channels in the request.</p>', 'ListChannelsRequest$MaxResults' => '<p>The maximum number of channels that you want to return.</p>', 'ListSubChannelsRequest$MaxResults' => '<p>The maximum number of sub-channels that you want to return.</p>', 'SearchChannelsRequest$MaxResults' => '<p>The maximum number of channels that you want returned.</p>', ], ], 'MaximumSubChannels' => [ 'base' => NULL, 'refs' => [ 'ElasticChannelConfiguration$MaximumSubChannels' => '<p>The maximum number of SubChannels that you want to allow in the elastic channel.</p>', ], ], 'MemberArns' => [ 'base' => NULL, 'refs' => [ 'BatchCreateChannelMembershipRequest$MemberArns' => '<p>The ARNs of the members you want to add to the channel. Only <code>AppInstanceUsers</code> and <code>AppInstanceBots</code> can be added as a channel member.</p>', ], ], 'Members' => [ 'base' => NULL, 'refs' => [ 'BatchChannelMemberships$Members' => '<p>The users successfully added to the request.</p>', ], ], 'MembershipCount' => [ 'base' => NULL, 'refs' => [ 'SubChannelSummary$MembershipCount' => '<p>The number of members in a SubChannel.</p>', ], ], 'MessageAttributeMap' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$MessageAttributes' => '<p>The attributes for the channel message. For Amazon Lex V2 bot responses, the attributes are mapped to specific fields from the bot. For more information, refer to <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html">Processing responses from an AppInstanceBot</a> in the <i>Amazon Chime SDK Messaging Developer Guide</i>.</p>', 'ChannelMessageCallback$MessageAttributes' => '<p>The attributes for the channel message. For Amazon Lex V2 bot responses, the attributes are mapped to specific fields from the bot. For more information, refer to <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html">Processing responses from an AppInstanceBot</a> in the <i>Amazon Chime SDK Messaging Developer Guide</i>.</p>', 'ChannelMessageSummary$MessageAttributes' => '<p>The attributes for the channel message. For Amazon Lex V2 bot responses, the attributes are mapped to specific fields from the bot. For more information, refer to <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html">Processing responses from an AppInstanceBot</a> in the <i>Amazon Chime SDK Messaging Developer Guide</i>.</p>', 'SendChannelMessageRequest$MessageAttributes' => '<p>The attributes for the message, used for message filtering along with a <code>FilterRule</code> defined in the <code>PushNotificationPreferences</code>.</p>', ], ], 'MessageAttributeName' => [ 'base' => NULL, 'refs' => [ 'MessageAttributeMap$key' => NULL, ], ], 'MessageAttributeStringValue' => [ 'base' => NULL, 'refs' => [ 'MessageAttributeStringValues$member' => NULL, ], ], 'MessageAttributeStringValues' => [ 'base' => NULL, 'refs' => [ 'MessageAttributeValue$StringValues' => '<p>The strings in a message attribute value.</p>', ], ], 'MessageAttributeValue' => [ 'base' => '<p>A list of message attribute values.</p>', 'refs' => [ 'MessageAttributeMap$value' => NULL, ], ], 'MessageId' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$MessageId' => '<p>The ID of a message.</p>', 'ChannelMessageCallback$MessageId' => '<p>The message ID.</p>', 'ChannelMessageSummary$MessageId' => '<p>The ID of the message.</p>', 'DeleteChannelMessageRequest$MessageId' => '<p>The ID of the message being deleted.</p>', 'GetChannelMessageRequest$MessageId' => '<p>The ID of the message.</p>', 'GetChannelMessageStatusRequest$MessageId' => '<p>The ID of the message.</p>', 'RedactChannelMessageRequest$MessageId' => '<p>The ID of the message being redacted.</p>', 'RedactChannelMessageResponse$MessageId' => '<p>The ID of the message being redacted.</p>', 'SendChannelMessageResponse$MessageId' => '<p>The ID string assigned to each message.</p>', 'UpdateChannelMessageRequest$MessageId' => '<p>The ID string of the message being updated.</p>', 'UpdateChannelMessageResponse$MessageId' => '<p>The ID string of the message being updated.</p>', ], ], 'MessagingDataType' => [ 'base' => NULL, 'refs' => [ 'StreamingConfiguration$DataType' => '<p>The data type of the configuration.</p>', ], ], 'MessagingSessionEndpoint' => [ 'base' => '<p>The websocket endpoint used to connect to Amazon Chime SDK messaging.</p>', 'refs' => [ 'GetMessagingSessionEndpointResponse$Endpoint' => '<p>The endpoint returned in the response.</p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'Channel$Metadata' => '<p>The channel\'s metadata.</p>', 'ChannelAssociatedWithFlowSummary$Metadata' => '<p>The channel\'s metadata.</p>', 'ChannelMessage$Metadata' => '<p>The message metadata.</p>', 'ChannelMessageCallback$Metadata' => '<p>The message metadata.</p>', 'ChannelMessageSummary$Metadata' => '<p>The metadata of the message.</p>', 'ChannelSummary$Metadata' => '<p>The metadata of the channel.</p>', 'CreateChannelRequest$Metadata' => '<p>The metadata of the creation request. Limited to 1KB and UTF-8.</p>', 'SendChannelMessageRequest$Metadata' => '<p>The optional metadata for each message.</p>', 'UpdateChannelMessageRequest$Metadata' => '<p>The metadata of the message being updated.</p>', 'UpdateChannelRequest$Metadata' => '<p>The metadata for the update request.</p>', ], ], 'MinimumMembershipPercentage' => [ 'base' => NULL, 'refs' => [ 'ElasticChannelConfiguration$MinimumMembershipPercentage' => '<p>The minimum allowed percentage of TargetMembershipsPerSubChannel users. Ceil of the calculated value is used in balancing members among SubChannels of the elastic channel.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListChannelBansRequest$NextToken' => '<p>The token passed by previous API calls until all requested bans are returned.</p>', 'ListChannelBansResponse$NextToken' => '<p>The token passed by previous API calls until all requested bans are returned.</p>', 'ListChannelFlowsRequest$NextToken' => '<p>The token passed by previous API calls until all requested channel flows are returned.</p>', 'ListChannelFlowsResponse$NextToken' => '<p>The token passed by previous API calls until all requested channels are returned.</p>', 'ListChannelMembershipsForAppInstanceUserRequest$NextToken' => '<p>The token returned from previous API requests until the number of channel memberships is reached.</p>', 'ListChannelMembershipsForAppInstanceUserResponse$NextToken' => '<p>The token passed by previous API calls until all requested users are returned.</p>', 'ListChannelMembershipsRequest$NextToken' => '<p>The token passed by previous API calls until all requested channel memberships are returned.</p>', 'ListChannelMembershipsResponse$NextToken' => '<p>The token passed by previous API calls until all requested channel memberships are returned.</p>', 'ListChannelMessagesRequest$NextToken' => '<p>The token passed by previous API calls until all requested messages are returned.</p>', 'ListChannelMessagesResponse$NextToken' => '<p>The token passed by previous API calls until all requested messages are returned.</p>', 'ListChannelModeratorsRequest$NextToken' => '<p>The token passed by previous API calls until all requested moderators are returned.</p>', 'ListChannelModeratorsResponse$NextToken' => '<p>The token passed by previous API calls until all requested moderators are returned.</p>', 'ListChannelsAssociatedWithChannelFlowRequest$NextToken' => '<p>The token passed by previous API calls until all requested channels are returned.</p>', 'ListChannelsAssociatedWithChannelFlowResponse$NextToken' => '<p>The token passed by previous API calls until all requested channels are returned.</p>', 'ListChannelsModeratedByAppInstanceUserRequest$NextToken' => '<p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>', 'ListChannelsModeratedByAppInstanceUserResponse$NextToken' => '<p>The token returned from previous API requests until the number of channels moderated by the user is reached.</p>', 'ListChannelsRequest$NextToken' => '<p>The token passed by previous API calls until all requested channels are returned.</p>', 'ListChannelsResponse$NextToken' => '<p>The token returned from previous API requests until the number of channels is reached.</p>', 'ListSubChannelsRequest$NextToken' => '<p>The token passed by previous API calls until all requested sub-channels are returned.</p>', 'ListSubChannelsResponse$NextToken' => '<p>The token passed by previous API calls until all requested sub-channels are returned.</p>', 'SearchChannelsRequest$NextToken' => '<p>The token returned from previous API requests until the number of channels is reached.</p>', 'SearchChannelsResponse$NextToken' => '<p>The token returned from previous API responses until the number of channels is reached.</p>', ], ], 'NonEmptyContent' => [ 'base' => NULL, 'refs' => [ 'ChannelMessageCallback$Content' => '<p>The message content. For Amazon Lex V2 bot responses, this field holds a list of messages originating from the bot. For more information, refer to <a href="https://docs.aws.amazon.com/chime-sdk/latest/dg/appinstance-bots#process-response.html">Processing responses from an AppInstanceBot</a> in the <i>Amazon Chime SDK Messaging Developer Guide</i>.</p>', 'SendChannelMessageRequest$Content' => '<p>The content of the channel message.</p>', 'UpdateChannelMessageRequest$Content' => '<p>The content of the channel message. </p>', ], ], 'NonEmptyResourceName' => [ 'base' => NULL, 'refs' => [ 'Channel$Name' => '<p>The name of a channel.</p>', 'ChannelAssociatedWithFlowSummary$Name' => '<p>The name of the channel flow.</p>', 'ChannelFlow$Name' => '<p>The name of the channel flow.</p>', 'ChannelFlowSummary$Name' => '<p>The name of the channel flow.</p>', 'ChannelSummary$Name' => '<p>The name of the channel.</p>', 'CreateChannelFlowRequest$Name' => '<p>The name of the channel flow.</p>', 'CreateChannelRequest$Name' => '<p>The name of the channel.</p>', 'Processor$Name' => '<p>The name of the channel flow.</p>', 'UpdateChannelFlowRequest$Name' => '<p>The name of the channel flow.</p>', 'UpdateChannelRequest$Name' => '<p>The name of the channel.</p>', ], ], 'NonNullableBoolean' => [ 'base' => NULL, 'refs' => [ 'ChannelFlowCallbackRequest$DeleteResource' => '<p>When a processor determines that a message needs to be <code>DENIED</code>, pass this parameter with a value of true.</p>', 'ChannelMessage$Redacted' => '<p>Hides the content of a message.</p>', 'ChannelMessageSummary$Redacted' => '<p>Indicates whether a message was redacted.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>One or more of the resources in the request does not exist in the system.</p>', 'refs' => [], ], 'Processor' => [ 'base' => '<p>The information about a processor in a channel flow.</p>', 'refs' => [ 'ProcessorList$member' => NULL, ], ], 'ProcessorConfiguration' => [ 'base' => '<p>A processor\'s metadata.</p>', 'refs' => [ 'Processor$Configuration' => '<p>The information about the type of processor and its identifier.</p>', ], ], 'ProcessorList' => [ 'base' => NULL, 'refs' => [ 'ChannelFlow$Processors' => '<p>Information about the processor Lambda functions.</p>', 'ChannelFlowSummary$Processors' => '<p>Information about the processor Lambda functions.</p>', 'CreateChannelFlowRequest$Processors' => '<p>Information about the processor Lambda functions.</p>', 'UpdateChannelFlowRequest$Processors' => '<p>Information about the processor Lambda functions </p>', ], ], 'PushNotificationBody' => [ 'base' => NULL, 'refs' => [ 'PushNotificationConfiguration$Body' => '<p>The body of the push notification.</p>', ], ], 'PushNotificationConfiguration' => [ 'base' => '<p>The push notification configuration of the message.</p>', 'refs' => [ 'ChannelMessageCallback$PushNotification' => '<p>The push notification configuration of the message.</p>', 'SendChannelMessageRequest$PushNotification' => '<p>The push notification configuration of the message.</p>', ], ], 'PushNotificationPreferences' => [ 'base' => '<p>The channel membership preferences for push notification.</p>', 'refs' => [ 'ChannelMembershipPreferences$PushNotifications' => '<p>The push notification configuration of a message.</p>', ], ], 'PushNotificationTitle' => [ 'base' => NULL, 'refs' => [ 'PushNotificationConfiguration$Title' => '<p>The title of the push notification.</p>', ], ], 'PushNotificationType' => [ 'base' => NULL, 'refs' => [ 'PushNotificationConfiguration$Type' => '<p>Enum value that indicates the type of the push notification for a message. <code>DEFAULT</code>: Normal mobile push notification. <code>VOIP</code>: VOIP mobile push notification.</p>', ], ], 'PutChannelExpirationSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutChannelExpirationSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutChannelMembershipPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutChannelMembershipPreferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutMessagingStreamingConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutMessagingStreamingConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'RedactChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'RedactChannelMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceLimitExceededException' => [ 'base' => '<p>The request exceeds the resource limit.</p>', 'refs' => [], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'Identity$Name' => '<p>The name in an Identity.</p>', ], ], 'SearchChannelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchChannelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchField' => [ 'base' => '<p>A <code>Field</code> of the channel that you want to search.</p>', 'refs' => [ 'SearchFields$member' => NULL, ], ], 'SearchFieldKey' => [ 'base' => NULL, 'refs' => [ 'SearchField$Key' => '<p>An <code>enum</code> value that indicates the key to search the channel on. <code>MEMBERS</code> allows you to search channels based on memberships. You can use it with the <code>EQUALS</code> operator to get channels whose memberships are equal to the specified values, and with the <code>INCLUDES</code> operator to get channels whose memberships include the specified values.</p>', ], ], 'SearchFieldOperator' => [ 'base' => NULL, 'refs' => [ 'SearchField$Operator' => '<p>The operator used to compare field values, currently <code>EQUALS</code> or <code>INCLUDES</code>. Use the <code>EQUALS</code> operator to find channels whose memberships equal the specified values. Use the <code>INCLUDES</code> operator to find channels whose memberships include the specified values.</p>', ], ], 'SearchFieldValue' => [ 'base' => NULL, 'refs' => [ 'SearchFieldValues$member' => NULL, ], ], 'SearchFieldValues' => [ 'base' => NULL, 'refs' => [ 'SearchField$Values' => '<p>The values that you want to search for, a list of strings. The values must be <code>AppInstanceUserArns</code> specified as a list of strings.</p> <note> <p>This operation isn\'t supported for <code>AppInstanceUsers</code> with large number of memberships.</p> </note>', ], ], 'SearchFields' => [ 'base' => NULL, 'refs' => [ 'SearchChannelsRequest$Fields' => '<p>A list of the <code>Field</code> objects in the channel being searched.</p>', ], ], 'SendChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendChannelMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'ServiceFailureException' => [ 'base' => '<p>The service encountered an unexpected error.</p>', 'refs' => [], ], 'ServiceUnavailableException' => [ 'base' => '<p>The service is currently unavailable.</p>', 'refs' => [], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListChannelMessagesRequest$SortOrder' => '<p>The order in which you want messages sorted. Default is Descending, based on time created.</p>', ], ], 'StatusDetail' => [ 'base' => NULL, 'refs' => [ 'ChannelMessageStatusStructure$Detail' => '<p>Contains more details about the message status.</p>', ], ], 'StreamingConfiguration' => [ 'base' => '<p>The configuration for connecting a messaging stream to Amazon Kinesis.</p>', 'refs' => [ 'StreamingConfigurationList$member' => NULL, ], ], 'StreamingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'GetMessagingStreamingConfigurationsResponse$StreamingConfigurations' => '<p>The streaming settings.</p>', 'PutMessagingStreamingConfigurationsRequest$StreamingConfigurations' => '<p>The streaming configurations.</p>', 'PutMessagingStreamingConfigurationsResponse$StreamingConfigurations' => '<p>The requested streaming configurations.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Message' => NULL, 'BatchCreateChannelMembershipError$ErrorMessage' => '<p>The error message.</p>', 'ConflictException$Message' => NULL, 'ForbiddenException$Message' => NULL, 'NotFoundException$Message' => NULL, 'ResourceLimitExceededException$Message' => NULL, 'ServiceFailureException$Message' => NULL, 'ServiceUnavailableException$Message' => NULL, 'ThrottledClientException$Message' => NULL, 'UnauthorizedClientException$Message' => NULL, ], ], 'SubChannelId' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUserMembershipSummary$SubChannelId' => '<p>The ID of the SubChannel that the <code>AppInstanceUser</code> is a member of.</p>', 'BatchChannelMemberships$SubChannelId' => '<p>The ID of the SubChannel.</p>', 'BatchCreateChannelMembershipRequest$SubChannelId' => '<p>The ID of the SubChannel in the request. </p> <note> <p>Only required when creating membership in a SubChannel for a moderator in an elastic channel.</p> </note>', 'ChannelMembership$SubChannelId' => '<p>The ID of the SubChannel that a user belongs to.</p>', 'ChannelMessage$SubChannelId' => '<p>The ID of the SubChannel.</p>', 'ChannelMessageCallback$SubChannelId' => '<p>The ID of the SubChannel.</p>', 'CreateChannelMembershipRequest$SubChannelId' => '<p>The ID of the SubChannel in the request.</p> <note> <p>Only required when creating membership in a SubChannel for a moderator in an elastic channel.</p> </note>', 'CreateChannelMembershipResponse$SubChannelId' => '<p>The ID of the SubChannel in the response.</p>', 'DeleteChannelMembershipRequest$SubChannelId' => '<p>The ID of the SubChannel in the request.</p> <note> <p>Only for use by moderators.</p> </note>', 'DeleteChannelMessageRequest$SubChannelId' => '<p>The ID of the SubChannel in the request.</p> <note> <p>Only required when deleting messages in a SubChannel that the user belongs to.</p> </note>', 'DescribeChannelMembershipRequest$SubChannelId' => '<p>The ID of the SubChannel in the request. The response contains an <code>ElasticChannelConfiguration</code> object.</p> <note> <p>Only required to get a user’s SubChannel membership details.</p> </note>', 'GetChannelMessageRequest$SubChannelId' => '<p>The ID of the SubChannel in the request.</p> <note> <p>Only required when getting messages in a SubChannel that the user belongs to.</p> </note>', 'GetChannelMessageStatusRequest$SubChannelId' => '<p>The ID of the SubChannel in the request.</p> <note> <p>Only required when getting message status in a SubChannel that the user belongs to.</p> </note>', 'ListChannelMembershipsRequest$SubChannelId' => '<p>The ID of the SubChannel in the request.</p> <note> <p>Only required when listing a user\'s memberships in a particular sub-channel of an elastic channel.</p> </note>', 'ListChannelMessagesRequest$SubChannelId' => '<p>The ID of the SubChannel in the request.</p> <note> <p>Only required when listing the messages in a SubChannel that the user belongs to.</p> </note>', 'ListChannelMessagesResponse$SubChannelId' => '<p>The ID of the SubChannel in the response.</p>', 'RedactChannelMessageRequest$SubChannelId' => '<p>The ID of the SubChannel in the request.</p>', 'RedactChannelMessageResponse$SubChannelId' => '<p>The ID of the SubChannel in the response.</p> <note> <p>Only required when redacting messages in a SubChannel that the user belongs to.</p> </note>', 'SendChannelMessageRequest$SubChannelId' => '<p>The ID of the SubChannel in the request.</p>', 'SendChannelMessageResponse$SubChannelId' => '<p>The ID of the SubChannel in the response.</p>', 'SubChannelSummary$SubChannelId' => '<p>The unique ID of a SubChannel.</p>', 'UpdateChannelMessageRequest$SubChannelId' => '<p>The ID of the SubChannel in the request.</p> <note> <p>Only required when updating messages in a SubChannel that the user belongs to.</p> </note>', 'UpdateChannelMessageResponse$SubChannelId' => '<p>The ID of the SubChannel in the response.</p>', ], ], 'SubChannelSummary' => [ 'base' => '<p>Summary of the sub-channels associated with the elastic channel.</p>', 'refs' => [ 'SubChannelSummaryList$member' => NULL, ], ], 'SubChannelSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListSubChannelsResponse$SubChannels' => '<p>The information about each sub-channel.</p>', ], ], 'Tag' => [ 'base' => '<p>A tag object containing a key-value pair.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The key in a tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateChannelFlowRequest$Tags' => '<p>The tags for the creation request.</p>', 'CreateChannelRequest$Tags' => '<p>The tags for the creation request.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tag key-value pairs.</p>', 'TagResourceRequest$Tags' => '<p>The tag key-value pairs.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value in a tag.</p>', ], ], 'Target' => [ 'base' => '<p>The target of a message, a sender, a user, or a bot. Only the target and the sender can view targeted messages. Only users who can see targeted messages can take actions on them. However, administrators can delete targeted messages that they can’t see.</p>', 'refs' => [ 'TargetList$member' => NULL, ], ], 'TargetList' => [ 'base' => NULL, 'refs' => [ 'ChannelMessage$Target' => '<p>The target of a message, a sender, a user, or a bot. Only the target and the sender can view targeted messages. Only users who can see targeted messages can take actions on them. However, administrators can delete targeted messages that they can’t see.</p>', 'ChannelMessageSummary$Target' => '<p>The target of a message, a sender, a user, or a bot. Only the target and the sender can view targeted messages. Only users who can see targeted messages can take actions on them. However, administrators can delete targeted messages that they can’t see.</p>', 'SendChannelMessageRequest$Target' => '<p>The target of a message. Must be a member of the channel, such as another user, a bot, or the sender. Only the target and the sender can view targeted messages. Only users who can see targeted messages can take actions on them. However, administrators can delete targeted messages that they can’t see. </p>', ], ], 'TargetMembershipsPerSubChannel' => [ 'base' => NULL, 'refs' => [ 'ElasticChannelConfiguration$TargetMembershipsPerSubChannel' => '<p>The maximum number of members allowed in a SubChannel.</p>', ], ], 'ThrottledClientException' => [ 'base' => '<p>The client exceeded its request rate limit.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AppInstanceUserMembershipSummary$ReadMarkerTimestamp' => '<p>The time at which an <code>AppInstanceUser</code> last marked a channel as read.</p>', 'Channel$CreatedTimestamp' => '<p>The time at which the <code>AppInstanceUser</code> created the channel.</p>', 'Channel$LastMessageTimestamp' => '<p>The time at which a member sent the last message in the channel.</p>', 'Channel$LastUpdatedTimestamp' => '<p>The time at which a channel was last updated.</p>', 'ChannelBan$CreatedTimestamp' => '<p>The time at which the ban was created.</p>', 'ChannelFlow$CreatedTimestamp' => '<p>The time at which the channel flow was created.</p>', 'ChannelFlow$LastUpdatedTimestamp' => '<p>The time at which a channel flow was updated.</p>', 'ChannelMembership$CreatedTimestamp' => '<p>The time at which the channel membership was created.</p>', 'ChannelMembership$LastUpdatedTimestamp' => '<p>The time at which a channel membership was last updated.</p>', 'ChannelMessage$CreatedTimestamp' => '<p>The time at which the message was created.</p>', 'ChannelMessage$LastEditedTimestamp' => '<p>The time at which a message was edited.</p>', 'ChannelMessage$LastUpdatedTimestamp' => '<p>The time at which a message was updated.</p>', 'ChannelMessageSummary$CreatedTimestamp' => '<p>The time at which the message summary was created.</p>', 'ChannelMessageSummary$LastUpdatedTimestamp' => '<p>The time at which a message was last updated.</p>', 'ChannelMessageSummary$LastEditedTimestamp' => '<p>The time at which a message was last edited.</p>', 'ChannelModerator$CreatedTimestamp' => '<p>The time at which the moderator was created.</p>', 'ChannelSummary$LastMessageTimestamp' => '<p>The time at which the last persistent message visible to the caller in a channel was sent.</p>', 'ListChannelMessagesRequest$NotBefore' => '<p>The initial or starting time stamp for your requested messages.</p>', 'ListChannelMessagesRequest$NotAfter' => '<p>The final or ending time stamp for your requested messages.</p>', ], ], 'UnauthorizedClientException' => [ 'base' => '<p>The client is not currently authorized to make the request.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelMessageRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelMessageResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelReadMarkerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelReadMarkerResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateChannelResponse' => [ 'base' => NULL, 'refs' => [], ], 'UrlType' => [ 'base' => NULL, 'refs' => [ 'MessagingSessionEndpoint$Url' => '<p>The endpoint to which you establish a websocket connection.</p>', ], ], ],];
