<?php
// This file was auto-generated from sdk-root/src/data/codecatalyst/2022-09-28/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the Amazon CodeCatalyst API reference. This reference provides descriptions of operations and data types for Amazon CodeCatalyst. You can use the Amazon CodeCatalyst API to work with the following objects. </p> <p>Spaces, by calling the following:</p> <ul> <li> <p> <a>DeleteSpace</a>, which deletes a space.</p> </li> <li> <p> <a>GetSpace</a>, which returns information about a space.</p> </li> <li> <p> <a>GetSubscription</a>, which returns information about the Amazon Web Services account used for billing purposes and the billing plan for the space.</p> </li> <li> <p> <a>ListSpaces</a>, which retrieves a list of spaces.</p> </li> <li> <p> <a>UpdateSpace</a>, which changes one or more values for a space.</p> </li> </ul> <p>Projects, by calling the following:</p> <ul> <li> <p> <a>CreateProject</a> which creates a project in a specified space.</p> </li> <li> <p> <a>GetProject</a>, which returns information about a project.</p> </li> <li> <p> <a>ListProjects</a>, which retrieves a list of projects in a space.</p> </li> </ul> <p>Users, by calling the following:</p> <ul> <li> <p> <a>GetUserDetails</a>, which returns information about a user in Amazon CodeCatalyst.</p> </li> </ul> <p>Source repositories, by calling the following:</p> <ul> <li> <p> <a>CreateSourceRepository</a>, which creates an empty Git-based source repository in a specified project.</p> </li> <li> <p> <a>CreateSourceRepositoryBranch</a>, which creates a branch in a specified repository where you can work on code.</p> </li> <li> <p> <a>DeleteSourceRepository</a>, which deletes a source repository.</p> </li> <li> <p> <a>GetSourceRepository</a>, which returns information about a source repository.</p> </li> <li> <p> <a>GetSourceRepositoryCloneUrls</a>, which returns information about the URLs that can be used with a Git client to clone a source repository.</p> </li> <li> <p> <a>ListSourceRepositories</a>, which retrieves a list of source repositories in a project.</p> </li> <li> <p> <a>ListSourceRepositoryBranches</a>, which retrieves a list of branches in a source repository.</p> </li> </ul> <p>Dev Environments and the Amazon Web Services Toolkits, by calling the following:</p> <ul> <li> <p> <a>CreateDevEnvironment</a>, which creates a Dev Environment, where you can quickly work on the code stored in the source repositories of your project.</p> </li> <li> <p> <a>DeleteDevEnvironment</a>, which deletes a Dev Environment.</p> </li> <li> <p> <a>GetDevEnvironment</a>, which returns information about a Dev Environment.</p> </li> <li> <p> <a>ListDevEnvironments</a>, which retrieves a list of Dev Environments in a project.</p> </li> <li> <p> <a>ListDevEnvironmentSessions</a>, which retrieves a list of active Dev Environment sessions in a project.</p> </li> <li> <p> <a>StartDevEnvironment</a>, which starts a specified Dev Environment and puts it into an active state.</p> </li> <li> <p> <a>StartDevEnvironmentSession</a>, which starts a session to a specified Dev Environment.</p> </li> <li> <p> <a>StopDevEnvironment</a>, which stops a specified Dev Environment and puts it into an stopped state.</p> </li> <li> <p> <a>StopDevEnvironmentSession</a>, which stops a session for a specified Dev Environment.</p> </li> <li> <p> <a>UpdateDevEnvironment</a>, which changes one or more values for a Dev Environment.</p> </li> </ul> <p>Workflows, by calling the following:</p> <ul> <li> <p> <a>GetWorkflow</a>, which returns information about a workflow.</p> </li> <li> <p> <a>GetWorkflowRun</a>, which returns information about a specified run of a workflow.</p> </li> <li> <p> <a>ListWorkflowRuns</a>, which retrieves a list of runs of a specified workflow.</p> </li> <li> <p> <a>ListWorkflows</a>, which retrieves a list of workflows in a specified project.</p> </li> <li> <p> <a>StartWorkflowRun</a>, which starts a run of a specified workflow.</p> </li> </ul> <p>Security, activity, and resource management in Amazon CodeCatalyst, by calling the following:</p> <ul> <li> <p> <a>CreateAccessToken</a>, which creates a personal access token (PAT) for the current user.</p> </li> <li> <p> <a>DeleteAccessToken</a>, which deletes a specified personal access token (PAT).</p> </li> <li> <p> <a>ListAccessTokens</a>, which lists all personal access tokens (PATs) associated with a user.</p> </li> <li> <p> <a>ListEventLogs</a>, which retrieves a list of events that occurred during a specified time period in a space.</p> </li> <li> <p> <a>VerifySession</a>, which verifies whether the calling user has a valid Amazon CodeCatalyst login and session.</p> </li> </ul> <note> <p>If you are using the Amazon CodeCatalyst APIs with an SDK or the CLI, you must configure your computer to work with Amazon CodeCatalyst and single sign-on (SSO). For more information, see <a href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/set-up-cli.html">Setting up to use the CLI with Amazon CodeCatalyst</a> and the SSO documentation for your SDK.</p> </note>', 'operations' => [ 'CreateAccessToken' => '<p>Creates a personal access token (PAT) for the current user. A personal access token (PAT) is similar to a password. It is associated with your user identity for use across all spaces and projects in Amazon CodeCatalyst. You use PATs to access CodeCatalyst from resources that include integrated development environments (IDEs) and Git-based source repositories. PATs represent you in Amazon CodeCatalyst and you can manage them in your user settings.For more information, see <a href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/ipa-tokens-keys.html">Managing personal access tokens in Amazon CodeCatalyst</a>.</p>', 'CreateDevEnvironment' => '<p>Creates a Dev Environment in Amazon CodeCatalyst, a cloud-based development environment that you can use to quickly work on the code stored in the source repositories of your project. </p> <note> <p>When created in the Amazon CodeCatalyst console, by default a Dev Environment is configured to have a 2 core processor, 4GB of RAM, and 16GB of persistent storage. None of these defaults apply to a Dev Environment created programmatically.</p> </note>', 'CreateProject' => '<p>Creates a project in a specified space.</p>', 'CreateSourceRepository' => '<p>Creates an empty Git-based source repository in a specified project. The repository is created with an initial empty commit with a default branch named <code>main</code>.</p>', 'CreateSourceRepositoryBranch' => '<p>Creates a branch in a specified source repository in Amazon CodeCatalyst. </p> <note> <p>This API only creates a branch in a source repository hosted in Amazon CodeCatalyst. You cannot use this API to create a branch in a linked repository.</p> </note>', 'DeleteAccessToken' => '<p>Deletes a specified personal access token (PAT). A personal access token can only be deleted by the user who created it.</p>', 'DeleteDevEnvironment' => '<p>Deletes a Dev Environment. </p>', 'DeleteProject' => '<p>Deletes a project in a space.</p>', 'DeleteSourceRepository' => '<p>Deletes a source repository in Amazon CodeCatalyst. You cannot use this API to delete a linked repository. It can only be used to delete a Amazon CodeCatalyst source repository.</p>', 'DeleteSpace' => '<p>Deletes a space.</p> <important> <p>Deleting a space cannot be undone. Additionally, since space names must be unique across Amazon CodeCatalyst, you cannot reuse names of deleted spaces.</p> </important>', 'GetDevEnvironment' => '<p>Returns information about a Dev Environment for a source repository in a project. Dev Environments are specific to the user who creates them.</p>', 'GetProject' => '<p>Returns information about a project.</p>', 'GetSourceRepository' => '<p>Returns information about a source repository.</p>', 'GetSourceRepositoryCloneUrls' => '<p>Returns information about the URLs that can be used with a Git client to clone a source repository.</p>', 'GetSpace' => '<p>Returns information about an space.</p>', 'GetSubscription' => '<p>Returns information about the Amazon Web Services account used for billing purposes and the billing plan for the space.</p>', 'GetUserDetails' => '<p>Returns information about a user. </p>', 'GetWorkflow' => '<p>Returns information about a workflow.</p>', 'GetWorkflowRun' => '<p>Returns information about a specified run of a workflow.</p>', 'ListAccessTokens' => '<p>Lists all personal access tokens (PATs) associated with the user who calls the API. You can only list PATs associated with your Amazon Web Services Builder ID.</p>', 'ListDevEnvironmentSessions' => '<p>Retrieves a list of active sessions for a Dev Environment in a project.</p>', 'ListDevEnvironments' => '<p>Retrieves a list of Dev Environments in a project.</p>', 'ListEventLogs' => '<p>Retrieves a list of events that occurred during a specific time in a space. You can use these events to audit user and system activity in a space. For more information, see <a href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/ipa-monitoring.html">Monitoring</a> in the <i>Amazon CodeCatalyst User Guide</i>.</p> <note> <p>ListEventLogs guarantees events for the last 30 days in a given space. You can also view and retrieve a list of management events over the last 90 days for Amazon CodeCatalyst in the CloudTrail console by viewing Event history, or by creating a trail to create and maintain a record of events that extends past 90 days. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/view-cloudtrail-events.html">Working with CloudTrail Event History</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-getting-started.html">Working with CloudTrail trails</a>.</p> </note>', 'ListProjects' => '<p>Retrieves a list of projects.</p>', 'ListSourceRepositories' => '<p>Retrieves a list of source repositories in a project.</p>', 'ListSourceRepositoryBranches' => '<p>Retrieves a list of branches in a specified source repository.</p>', 'ListSpaces' => '<p>Retrieves a list of spaces.</p>', 'ListWorkflowRuns' => '<p>Retrieves a list of workflow runs of a specified workflow.</p>', 'ListWorkflows' => '<p>Retrieves a list of workflows in a specified project.</p>', 'StartDevEnvironment' => '<p>Starts a specified Dev Environment and puts it into an active state. </p>', 'StartDevEnvironmentSession' => '<p>Starts a session for a specified Dev Environment.</p>', 'StartWorkflowRun' => '<p>Begins a run of a specified workflow.</p>', 'StopDevEnvironment' => '<p>Pauses a specified Dev Environment and places it in a non-running state. Stopped Dev Environments do not consume compute minutes.</p>', 'StopDevEnvironmentSession' => '<p>Stops a session for a specified Dev Environment.</p>', 'UpdateDevEnvironment' => '<p>Changes one or more values for a Dev Environment. Updating certain values of the Dev Environment will cause a restart.</p>', 'UpdateProject' => '<p>Changes one or more values for a project.</p>', 'UpdateSpace' => '<p>Changes one or more values for a space.</p>', 'VerifySession' => '<p>Verifies whether the calling user has a valid Amazon CodeCatalyst login and session. If successful, this returns the ID of the user in Amazon CodeCatalyst.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The request was denied because you don\'t have sufficient access to perform this action. Verify that you are a member of a role that allows this action.</p>', 'refs' => [], ], 'AccessTokenId' => [ 'base' => NULL, 'refs' => [ 'AccessTokenSummary$id' => '<p>The system-generated ID of the personal access token.</p>', 'CreateAccessTokenResponse$accessTokenId' => '<p>The system-generated unique ID of the access token.</p>', 'DeleteAccessTokenRequest$id' => '<p>The ID of the personal access token to delete. You can find the IDs of all PATs associated with your Amazon Web Services Builder ID in a space by calling <a>ListAccessTokens</a>.</p>', ], ], 'AccessTokenName' => [ 'base' => NULL, 'refs' => [ 'AccessTokenSummary$name' => '<p>The friendly name of the personal access token.</p>', 'CreateAccessTokenRequest$name' => '<p>The friendly name of the personal access token.</p>', 'CreateAccessTokenResponse$name' => '<p>The friendly name of the personal access token.</p>', ], ], 'AccessTokenSecret' => [ 'base' => NULL, 'refs' => [ 'CreateAccessTokenResponse$secret' => '<p>The secret value of the personal access token.</p>', ], ], 'AccessTokenSummaries' => [ 'base' => NULL, 'refs' => [ 'ListAccessTokensResponse$items' => '<p>A list of personal access tokens (PATs) associated with the calling user identity.</p>', ], ], 'AccessTokenSummary' => [ 'base' => '<p>Information about a specified personal access token (PAT).</p>', 'refs' => [ 'AccessTokenSummaries$member' => NULL, ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'EmailAddress$verified' => '<p>Whether the email address has been verified.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateDevEnvironmentRequest$clientToken' => '<p>A user-specified idempotency token. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries return the result from the original successful request and have no additional effect.</p>', 'UpdateDevEnvironmentRequest$clientToken' => '<p>A user-specified idempotency token. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries return the result from the original successful request and have no additional effect.</p>', 'UpdateDevEnvironmentResponse$clientToken' => '<p>A user-specified idempotency token. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries return the result from the original successful request and have no additional effect.</p>', ], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'ProjectListFilter$comparisonOperator' => '<p>The operator used to compare the fields.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request was denied because the requested operation would cause a conflict with the current state of a service resource associated with the request. Another user might have updated the resource. Reload, make sure you have the latest data, and then try again.</p>', 'refs' => [], ], 'CreateAccessTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDevEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDevEnvironmentRequestAliasString' => [ 'base' => NULL, 'refs' => [ 'CreateDevEnvironmentRequest$alias' => '<p>The user-defined alias for a Dev Environment.</p>', ], ], 'CreateDevEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSourceRepositoryBranchRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSourceRepositoryBranchResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSourceRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSourceRepositoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDevEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDevEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSourceRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSourceRepositoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSpaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSpaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DevEnvironmentAccessDetails' => [ 'base' => '<p>Information about connection details for a Dev Environment.</p>', 'refs' => [ 'StartDevEnvironmentSessionResponse$accessDetails' => NULL, ], ], 'DevEnvironmentRepositorySummaries' => [ 'base' => NULL, 'refs' => [ 'DevEnvironmentSummary$repositories' => '<p>Information about the repositories that will be cloned into the Dev Environment. If no rvalue is specified, no repository is cloned.</p>', 'GetDevEnvironmentResponse$repositories' => '<p>The source repository that contains the branch cloned into the Dev Environment. </p>', ], ], 'DevEnvironmentRepositorySummary' => [ 'base' => '<p>Information about the source repsitory for a Dev Environment. </p>', 'refs' => [ 'DevEnvironmentRepositorySummaries$member' => NULL, ], ], 'DevEnvironmentSessionConfiguration' => [ 'base' => '<p>Information about the configuration of a Dev Environment session.</p>', 'refs' => [ 'StartDevEnvironmentSessionRequest$sessionConfiguration' => NULL, ], ], 'DevEnvironmentSessionSummary' => [ 'base' => '<p>Information about active sessions for a Dev Environment.</p>', 'refs' => [ 'DevEnvironmentSessionsSummaryList$member' => NULL, ], ], 'DevEnvironmentSessionSummaryIdString' => [ 'base' => NULL, 'refs' => [ 'DevEnvironmentSessionSummary$id' => '<p>The system-generated unique ID of the Dev Environment session.</p>', ], ], 'DevEnvironmentSessionType' => [ 'base' => NULL, 'refs' => [ 'DevEnvironmentSessionConfiguration$sessionType' => '<p>The type of the session.</p>', ], ], 'DevEnvironmentSessionsSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDevEnvironmentSessionsResponse$items' => '<p>Information about each session retrieved in the list.</p>', ], ], 'DevEnvironmentStatus' => [ 'base' => NULL, 'refs' => [ 'DevEnvironmentSummary$status' => '<p>The status of the Dev Environment. </p>', 'GetDevEnvironmentResponse$status' => '<p>The current status of the Dev Environment.</p>', 'StartDevEnvironmentResponse$status' => '<p>The status of the Dev Environment. </p>', 'StopDevEnvironmentResponse$status' => '<p>The status of the Dev Environment. </p>', ], ], 'DevEnvironmentSummary' => [ 'base' => '<p>Information about a Dev Environment. </p>', 'refs' => [ 'DevEnvironmentSummaryList$member' => NULL, ], ], 'DevEnvironmentSummaryAliasString' => [ 'base' => NULL, 'refs' => [ 'DevEnvironmentSummary$alias' => '<p>The user-specified alias for the Dev Environment.</p>', ], ], 'DevEnvironmentSummaryCreatorIdString' => [ 'base' => NULL, 'refs' => [ 'DevEnvironmentSummary$creatorId' => '<p>The system-generated unique ID of the user who created the Dev Environment. </p>', ], ], 'DevEnvironmentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListDevEnvironmentsResponse$items' => '<p>Information about the Dev Environments in a project.</p>', ], ], 'EmailAddress' => [ 'base' => '<p>Information about an email address.</p>', 'refs' => [ 'GetUserDetailsResponse$primaryEmail' => '<p>The email address provided by the user when they signed up.</p>', ], ], 'EventLogEntries' => [ 'base' => NULL, 'refs' => [ 'ListEventLogsResponse$items' => '<p>Information about each event retrieved in the list.</p>', ], ], 'EventLogEntry' => [ 'base' => '<p>Information about an entry in an event log of Amazon CodeCatalyst activity.</p>', 'refs' => [ 'EventLogEntries$member' => NULL, ], ], 'EventPayload' => [ 'base' => '<p>Information about the payload of an event recording Amazon CodeCatalyst activity.</p>', 'refs' => [ 'EventLogEntry$requestPayload' => '<p>Information about the payload of the request.</p>', 'EventLogEntry$responsePayload' => '<p>Information about the payload of the response, if any.</p>', ], ], 'ExecuteCommandSessionConfiguration' => [ 'base' => '<p>Information about the commands that will be run on a Dev Environment when an SSH session begins.</p>', 'refs' => [ 'DevEnvironmentSessionConfiguration$executeCommandSessionConfiguration' => '<p>Information about optional commands that will be run on the Dev Environment when the SSH session begins.</p>', ], ], 'ExecuteCommandSessionConfigurationArguments' => [ 'base' => NULL, 'refs' => [ 'ExecuteCommandSessionConfiguration$arguments' => '<p>An array of arguments containing arguments and members.</p>', ], ], 'ExecuteCommandSessionConfigurationArgumentsMemberString' => [ 'base' => NULL, 'refs' => [ 'ExecuteCommandSessionConfigurationArguments$member' => NULL, ], ], 'ExecuteCommandSessionConfigurationCommandString' => [ 'base' => NULL, 'refs' => [ 'ExecuteCommandSessionConfiguration$command' => '<p>The command used at the beginning of the SSH session to a Dev Environment.</p>', ], ], 'Filter' => [ 'base' => '<p>Information about a filter used to limit results of a query.</p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'FilterKey' => [ 'base' => NULL, 'refs' => [ 'ProjectListFilter$key' => '<p>A key that can be used to sort results.</p>', ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'ListDevEnvironmentsRequest$filters' => '<p>Information about filters to apply to narrow the results returned in the list.</p>', ], ], 'GetDevEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDevEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDevEnvironmentResponseAliasString' => [ 'base' => NULL, 'refs' => [ 'GetDevEnvironmentResponse$alias' => '<p>The user-specified alias for the Dev Environment. </p>', ], ], 'GetDevEnvironmentResponseCreatorIdString' => [ 'base' => NULL, 'refs' => [ 'GetDevEnvironmentResponse$creatorId' => '<p>The system-generated unique ID of the user who created the Dev Environment. </p>', ], ], 'GetProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSourceRepositoryCloneUrlsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSourceRepositoryCloneUrlsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSourceRepositoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSourceRepositoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSpaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSpaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSubscriptionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserDetailsRequestIdString' => [ 'base' => NULL, 'refs' => [ 'GetUserDetailsRequest$id' => '<p>The system-generated unique ID of the user. </p>', ], ], 'GetUserDetailsRequestUserNameString' => [ 'base' => NULL, 'refs' => [ 'GetUserDetailsRequest$userName' => '<p>The name of the user as displayed in Amazon CodeCatalyst.</p>', ], ], 'GetUserDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRequestProjectNameString' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowRequest$projectName' => '<p>The name of the project in the space.</p>', ], ], 'GetWorkflowResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkflowRunRequestProjectNameString' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowRunRequest$projectName' => '<p>The name of the project in the space.</p>', ], ], 'GetWorkflowRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'Ide' => [ 'base' => '<p>Information about an integrated development environment (IDE) used in a Dev Environment.</p>', 'refs' => [ 'Ides$member' => NULL, ], ], 'IdeConfiguration' => [ 'base' => '<p>Information about the configuration of an integrated development environment (IDE) for a Dev Environment.</p>', 'refs' => [ 'IdeConfigurationList$member' => NULL, ], ], 'IdeConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateDevEnvironmentRequest$ides' => '<p>Information about the integrated development environment (IDE) configured for a Dev Environment.</p> <note> <p>An IDE is required to create a Dev Environment. For Dev Environment creation, this field contains configuration information and must be provided. </p> </note>', 'StartDevEnvironmentRequest$ides' => '<p>Information about the integrated development environment (IDE) configured for a Dev Environment. </p>', 'UpdateDevEnvironmentRequest$ides' => '<p>Information about the integrated development environment (IDE) configured for a Dev Environment.</p>', 'UpdateDevEnvironmentResponse$ides' => '<p>Information about the integrated development environment (IDE) configured for the Dev Environment.</p>', ], ], 'IdeConfigurationNameString' => [ 'base' => NULL, 'refs' => [ 'IdeConfiguration$name' => '<p>The name of the IDE. Valid values include <code>Cloud9</code>, <code>IntelliJ</code>, <code>PyCharm</code>, <code>GoLand</code>, and <code>VSCode</code>.</p>', ], ], 'IdeConfigurationRuntimeString' => [ 'base' => NULL, 'refs' => [ 'IdeConfiguration$runtime' => '<p>A link to the IDE runtime image. </p> <note> <p>This parameter is not required for <code>VSCode</code>.</p> </note>', ], ], 'IdeNameString' => [ 'base' => NULL, 'refs' => [ 'Ide$name' => '<p>The name of the IDE.</p>', ], ], 'IdeRuntimeString' => [ 'base' => NULL, 'refs' => [ 'Ide$runtime' => '<p>A link to the IDE runtime image.</p>', ], ], 'Ides' => [ 'base' => NULL, 'refs' => [ 'DevEnvironmentSummary$ides' => '<p>Information about the integrated development environment (IDE) configured for a Dev Environment.</p>', 'GetDevEnvironmentResponse$ides' => '<p>Information about the integrated development environment (IDE) configured for the Dev Environment. </p>', ], ], 'InactivityTimeoutMinutes' => [ 'base' => NULL, 'refs' => [ 'CreateDevEnvironmentRequest$inactivityTimeoutMinutes' => '<p>The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.</p>', 'DevEnvironmentSummary$inactivityTimeoutMinutes' => '<p>The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Dev Environments consume compute minutes when running.</p>', 'GetDevEnvironmentResponse$inactivityTimeoutMinutes' => '<p>The amount of time the Dev Environment will run without any activity detected before stopping, in minutes.</p>', 'StartDevEnvironmentRequest$inactivityTimeoutMinutes' => '<p>The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.</p>', 'UpdateDevEnvironmentRequest$inactivityTimeoutMinutes' => '<p>The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. Only whole integers are allowed. Dev Environments consume compute minutes when running.</p> <note> <p>Changing this value will cause a restart of the Dev Environment if it is running.</p> </note>', 'UpdateDevEnvironmentResponse$inactivityTimeoutMinutes' => '<p>The amount of time the Dev Environment will run without any activity detected before stopping, in minutes. </p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'CreateDevEnvironmentRequest$instanceType' => '<p>The Amazon EC2 instace type to use for the Dev Environment. </p>', 'DevEnvironmentSummary$instanceType' => '<p>The Amazon EC2 instace type used for the Dev Environment. </p>', 'GetDevEnvironmentResponse$instanceType' => '<p>The Amazon EC2 instace type to use for the Dev Environment. </p>', 'StartDevEnvironmentRequest$instanceType' => '<p>The Amazon EC2 instace type to use for the Dev Environment. </p>', 'UpdateDevEnvironmentRequest$instanceType' => '<p>The Amazon EC2 instace type to use for the Dev Environment. </p> <note> <p>Changing this value will cause a restart of the Dev Environment if it is running.</p> </note>', 'UpdateDevEnvironmentResponse$instanceType' => '<p>The Amazon EC2 instace type to use for the Dev Environment. </p>', ], ], 'ListAccessTokensRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessTokensRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListAccessTokensRequest$maxResults' => '<p>The maximum number of results to show in a single call to this API. If the number of results is larger than the number you specified, the response will include a <code>NextToken</code> element, which you can use to obtain additional results.</p>', ], ], 'ListAccessTokensRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListAccessTokensRequest$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', ], ], 'ListAccessTokensResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDevEnvironmentSessionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDevEnvironmentSessionsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListDevEnvironmentSessionsRequest$maxResults' => '<p>The maximum number of results to show in a single call to this API. If the number of results is larger than the number you specified, the response will include a <code>NextToken</code> element, which you can use to obtain additional results.</p>', ], ], 'ListDevEnvironmentSessionsRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListDevEnvironmentSessionsRequest$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', ], ], 'ListDevEnvironmentSessionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDevEnvironmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDevEnvironmentsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListDevEnvironmentsRequest$maxResults' => '<p>The maximum number of results to show in a single call to this API. If the number of results is larger than the number you specified, the response will include a <code>NextToken</code> element, which you can use to obtain additional results.</p>', ], ], 'ListDevEnvironmentsRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListDevEnvironmentsRequest$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', ], ], 'ListDevEnvironmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventLogsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventLogsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListEventLogsRequest$maxResults' => '<p>The maximum number of results to show in a single call to this API. If the number of results is larger than the number you specified, the response will include a <code>NextToken</code> element, which you can use to obtain additional results.</p>', ], ], 'ListEventLogsRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListEventLogsRequest$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', ], ], 'ListEventLogsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListProjectsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListProjectsRequest$maxResults' => '<p>The maximum number of results to show in a single call to this API. If the number of results is larger than the number you specified, the response will include a <code>NextToken</code> element, which you can use to obtain additional results.</p>', ], ], 'ListProjectsRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListProjectsRequest$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', ], ], 'ListProjectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSourceRepositoriesItem' => [ 'base' => '<p>Information about a source repository returned in a list of source repositories.</p>', 'refs' => [ 'ListSourceRepositoriesItems$member' => NULL, ], ], 'ListSourceRepositoriesItems' => [ 'base' => NULL, 'refs' => [ 'ListSourceRepositoriesResponse$items' => '<p>Information about the source repositories.</p>', ], ], 'ListSourceRepositoriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSourceRepositoriesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSourceRepositoriesRequest$maxResults' => '<p>The maximum number of results to show in a single call to this API. If the number of results is larger than the number you specified, the response will include a <code>NextToken</code> element, which you can use to obtain additional results.</p>', ], ], 'ListSourceRepositoriesRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListSourceRepositoriesRequest$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', ], ], 'ListSourceRepositoriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSourceRepositoryBranchesItem' => [ 'base' => '<p>Information about a branch of a source repository returned in a list of branches.</p>', 'refs' => [ 'ListSourceRepositoryBranchesItems$member' => NULL, ], ], 'ListSourceRepositoryBranchesItems' => [ 'base' => NULL, 'refs' => [ 'ListSourceRepositoryBranchesResponse$items' => '<p>Information about the source branches.</p>', ], ], 'ListSourceRepositoryBranchesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSourceRepositoryBranchesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSourceRepositoryBranchesRequest$maxResults' => '<p>The maximum number of results to show in a single call to this API. If the number of results is larger than the number you specified, the response will include a <code>NextToken</code> element, which you can use to obtain additional results.</p>', ], ], 'ListSourceRepositoryBranchesRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListSourceRepositoryBranchesRequest$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', ], ], 'ListSourceRepositoryBranchesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSpacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSpacesRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListSpacesRequest$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', ], ], 'ListSpacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowRunsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowRunsRequest$maxResults' => '<p>The maximum number of results to show in a single call to this API. If the number of results is larger than the number you specified, the response will include a <code>NextToken</code> element, which you can use to obtain additional results.</p>', ], ], 'ListWorkflowRunsRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowRunsRequest$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', ], ], 'ListWorkflowRunsRequestProjectNameString' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowRunsRequest$projectName' => '<p>The name of the project in the space.</p>', ], ], 'ListWorkflowRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkflowsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowsRequest$maxResults' => '<p>The maximum number of results to show in a single call to this API. If the number of results is larger than the number you specified, the response will include a <code>NextToken</code> element, which you can use to obtain additional results.</p>', ], ], 'ListWorkflowsRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowsRequest$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', ], ], 'ListWorkflowsRequestSpaceNameString' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowsRequest$spaceName' => '<p>The name of the space.</p>', ], ], 'ListWorkflowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'NameString' => [ 'base' => NULL, 'refs' => [ 'CreateDevEnvironmentRequest$spaceName' => '<p>The name of the space.</p>', 'CreateDevEnvironmentRequest$projectName' => '<p>The name of the project in the space.</p>', 'CreateDevEnvironmentRequest$vpcConnectionName' => '<p>The name of the connection that will be used to connect to Amazon VPC, if any.</p>', 'CreateDevEnvironmentResponse$spaceName' => '<p>The name of the space.</p>', 'CreateDevEnvironmentResponse$projectName' => '<p>The name of the project in the space.</p>', 'CreateDevEnvironmentResponse$vpcConnectionName' => '<p>The name of the connection used to connect to Amazon VPC used when the Dev Environment was created, if any.</p>', 'CreateProjectRequest$spaceName' => '<p>The name of the space.</p>', 'CreateProjectResponse$spaceName' => '<p>The name of the space.</p>', 'CreateProjectResponse$name' => '<p>The name of the project in the space.</p>', 'CreateSourceRepositoryBranchRequest$spaceName' => '<p>The name of the space.</p>', 'CreateSourceRepositoryBranchRequest$projectName' => '<p>The name of the project in the space.</p>', 'CreateSourceRepositoryRequest$spaceName' => '<p>The name of the space.</p>', 'CreateSourceRepositoryRequest$projectName' => '<p>The name of the project in the space.</p>', 'CreateSourceRepositoryResponse$spaceName' => '<p>The name of the space.</p>', 'CreateSourceRepositoryResponse$projectName' => '<p>The name of the project in the space.</p>', 'DeleteDevEnvironmentRequest$spaceName' => '<p>The name of the space.</p>', 'DeleteDevEnvironmentRequest$projectName' => '<p>The name of the project in the space.</p>', 'DeleteDevEnvironmentResponse$spaceName' => '<p>The name of the space.</p>', 'DeleteDevEnvironmentResponse$projectName' => '<p>The name of the project in the space.</p>', 'DeleteProjectRequest$spaceName' => '<p>The name of the space.</p>', 'DeleteProjectRequest$name' => '<p>The name of the project in the space. To retrieve a list of project names, use <a>ListProjects</a>.</p>', 'DeleteProjectResponse$spaceName' => '<p>The name of the space.</p>', 'DeleteProjectResponse$name' => '<p>The name of the project in the space.</p>', 'DeleteSourceRepositoryRequest$spaceName' => '<p>The name of the space.</p>', 'DeleteSourceRepositoryRequest$projectName' => '<p>The name of the project in the space.</p>', 'DeleteSourceRepositoryResponse$spaceName' => '<p>The name of the space.</p>', 'DeleteSourceRepositoryResponse$projectName' => '<p>The name of the project in the space.</p>', 'DeleteSpaceRequest$name' => '<p>The name of the space. To retrieve a list of space names, use <a>ListSpaces</a>.</p>', 'DeleteSpaceResponse$name' => '<p>The name of the space.</p>', 'DevEnvironmentSessionSummary$spaceName' => '<p>The name of the space.</p>', 'DevEnvironmentSessionSummary$projectName' => '<p>The name of the project in the space.</p>', 'DevEnvironmentSummary$spaceName' => '<p>The name of the space.</p>', 'DevEnvironmentSummary$projectName' => '<p>The name of the project in the space.</p>', 'DevEnvironmentSummary$vpcConnectionName' => '<p>The name of the connection used to connect to Amazon VPC used when the Dev Environment was created, if any.</p>', 'GetDevEnvironmentRequest$spaceName' => '<p>The name of the space.</p>', 'GetDevEnvironmentRequest$projectName' => '<p>The name of the project in the space.</p>', 'GetDevEnvironmentResponse$spaceName' => '<p>The name of the space.</p>', 'GetDevEnvironmentResponse$projectName' => '<p>The name of the project in the space.</p>', 'GetDevEnvironmentResponse$vpcConnectionName' => '<p>The name of the connection used to connect to Amazon VPC used when the Dev Environment was created, if any.</p>', 'GetProjectRequest$spaceName' => '<p>The name of the space.</p>', 'GetProjectRequest$name' => '<p>The name of the project in the space.</p>', 'GetProjectResponse$spaceName' => '<p>The name of the space.</p>', 'GetSourceRepositoryCloneUrlsRequest$spaceName' => '<p>The name of the space.</p>', 'GetSourceRepositoryCloneUrlsRequest$projectName' => '<p>The name of the project in the space.</p>', 'GetSourceRepositoryRequest$spaceName' => '<p>The name of the space.</p>', 'GetSourceRepositoryRequest$projectName' => '<p>The name of the project in the space.</p>', 'GetSourceRepositoryResponse$spaceName' => '<p>The name of the space.</p>', 'GetSourceRepositoryResponse$projectName' => '<p>The name of the project in the space.</p>', 'GetSpaceRequest$name' => '<p>The name of the space.</p>', 'GetSpaceResponse$name' => '<p>The name of the space.</p>', 'GetSubscriptionRequest$spaceName' => '<p>The name of the space.</p>', 'GetSubscriptionResponse$awsAccountName' => '<p>The display name of the Amazon Web Services account used for billing for the space.</p>', 'GetWorkflowRequest$spaceName' => '<p>The name of the space.</p>', 'GetWorkflowResponse$spaceName' => '<p>The name of the space.</p>', 'GetWorkflowResponse$projectName' => '<p>The name of the project in the space.</p>', 'GetWorkflowRunRequest$spaceName' => '<p>The name of the space.</p>', 'GetWorkflowRunResponse$spaceName' => '<p>The name of the space.</p>', 'GetWorkflowRunResponse$projectName' => '<p>The name of the project in the space.</p>', 'ListDevEnvironmentSessionsRequest$spaceName' => '<p>The name of the space.</p>', 'ListDevEnvironmentSessionsRequest$projectName' => '<p>The name of the project in the space.</p>', 'ListDevEnvironmentsRequest$spaceName' => '<p>The name of the space.</p>', 'ListDevEnvironmentsRequest$projectName' => '<p>The name of the project in the space.</p>', 'ListEventLogsRequest$spaceName' => '<p>The name of the space.</p>', 'ListProjectsRequest$spaceName' => '<p>The name of the space.</p>', 'ListSourceRepositoriesRequest$spaceName' => '<p>The name of the space.</p>', 'ListSourceRepositoriesRequest$projectName' => '<p>The name of the project in the space.</p>', 'ListSourceRepositoryBranchesRequest$spaceName' => '<p>The name of the space.</p>', 'ListSourceRepositoryBranchesRequest$projectName' => '<p>The name of the project in the space.</p>', 'ListWorkflowRunsRequest$spaceName' => '<p>The name of the space.</p>', 'ListWorkflowsRequest$projectName' => '<p>The name of the project in the space.</p>', 'SpaceSummary$name' => '<p>The name of the space.</p>', 'StartDevEnvironmentRequest$spaceName' => '<p>The name of the space.</p>', 'StartDevEnvironmentRequest$projectName' => '<p>The name of the project in the space.</p>', 'StartDevEnvironmentResponse$spaceName' => '<p>The name of the space.</p>', 'StartDevEnvironmentResponse$projectName' => '<p>The name of the project in the space.</p>', 'StartDevEnvironmentSessionRequest$spaceName' => '<p>The name of the space.</p>', 'StartDevEnvironmentSessionRequest$projectName' => '<p>The name of the project in the space.</p>', 'StartDevEnvironmentSessionResponse$spaceName' => '<p>The name of the space.</p>', 'StartDevEnvironmentSessionResponse$projectName' => '<p>The name of the project in the space.</p>', 'StartWorkflowRunResponse$spaceName' => '<p>The name of the space.</p>', 'StartWorkflowRunResponse$projectName' => '<p>The name of the project in the space.</p>', 'StopDevEnvironmentRequest$spaceName' => '<p>The name of the space.</p>', 'StopDevEnvironmentRequest$projectName' => '<p>The name of the project in the space.</p>', 'StopDevEnvironmentResponse$spaceName' => '<p>The name of the space.</p>', 'StopDevEnvironmentResponse$projectName' => '<p>The name of the project in the space.</p>', 'StopDevEnvironmentSessionRequest$spaceName' => '<p>The name of the space.</p>', 'StopDevEnvironmentSessionRequest$projectName' => '<p>The name of the project in the space.</p>', 'StopDevEnvironmentSessionResponse$spaceName' => '<p>The name of the space.</p>', 'StopDevEnvironmentSessionResponse$projectName' => '<p>The name of the project in the space.</p>', 'UpdateDevEnvironmentRequest$spaceName' => '<p>The name of the space.</p>', 'UpdateDevEnvironmentRequest$projectName' => '<p>The name of the project in the space.</p>', 'UpdateDevEnvironmentResponse$spaceName' => '<p>The name of the space.</p>', 'UpdateDevEnvironmentResponse$projectName' => '<p>The name of the project in the space.</p>', 'UpdateProjectRequest$spaceName' => '<p>The name of the space.</p>', 'UpdateProjectRequest$name' => '<p>The name of the project.</p>', 'UpdateProjectResponse$spaceName' => '<p>The name of the space.</p>', 'UpdateProjectResponse$name' => '<p>The name of the project.</p>', 'UpdateSpaceRequest$name' => '<p>The name of the space.</p>', 'UpdateSpaceResponse$name' => '<p>The name of the space.</p>', ], ], 'OperationType' => [ 'base' => NULL, 'refs' => [ 'EventLogEntry$operationType' => '<p>The type of the event.</p>', ], ], 'PersistentStorage' => [ 'base' => '<p>Information about the persistent storage for a Dev Environment.</p>', 'refs' => [ 'DevEnvironmentSummary$persistentStorage' => '<p>Information about the configuration of persistent storage for the Dev Environment.</p>', 'GetDevEnvironmentResponse$persistentStorage' => '<p>Information about the amount of storage allocated to the Dev Environment. By default, a Dev Environment is configured to have 16GB of persistent storage.</p>', ], ], 'PersistentStorageConfiguration' => [ 'base' => '<p>Information about the configuration of persistent storage for a Dev Environment. </p>', 'refs' => [ 'CreateDevEnvironmentRequest$persistentStorage' => '<p>Information about the amount of storage allocated to the Dev Environment. </p> <note> <p>By default, a Dev Environment is configured to have 16GB of persistent storage when created from the Amazon CodeCatalyst console, but there is no default when programmatically creating a Dev Environment. Valid values for persistent storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.</p> </note>', ], ], 'PersistentStorageConfigurationSizeInGiBInteger' => [ 'base' => NULL, 'refs' => [ 'PersistentStorageConfiguration$sizeInGiB' => '<p>The size of the persistent storage in gigabytes (specifically GiB).</p> <note> <p>Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.</p> </note>', ], ], 'PersistentStorageSizeInGiBInteger' => [ 'base' => NULL, 'refs' => [ 'PersistentStorage$sizeInGiB' => '<p>The size of the persistent storage in gigabytes (specifically GiB).</p> <note> <p>Valid values for storage are based on memory sizes in 16GB increments. Valid values are 16, 32, and 64.</p> </note>', ], ], 'ProjectDescription' => [ 'base' => NULL, 'refs' => [ 'CreateProjectRequest$description' => '<p>The description of the project. This description will be displayed to all users of the project. We recommend providing a brief description of the project and its intended purpose.</p>', 'UpdateProjectRequest$description' => '<p>The description of the project.</p>', ], ], 'ProjectDisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateProjectRequest$displayName' => '<p>The friendly name of the project that will be displayed to users.</p>', ], ], 'ProjectInformation' => [ 'base' => '<p>Information about a project in a space.</p>', 'refs' => [ 'EventLogEntry$projectInformation' => '<p>Information about the project where the event occurred.</p>', ], ], 'ProjectListFilter' => [ 'base' => '<p>nformation about the filter used to narrow the results returned in a list of projects.</p>', 'refs' => [ 'ProjectListFilters$member' => NULL, ], ], 'ProjectListFilters' => [ 'base' => NULL, 'refs' => [ 'ListProjectsRequest$filters' => '<p>Information about filters to apply to narrow the results returned in the list.</p>', ], ], 'ProjectSummaries' => [ 'base' => NULL, 'refs' => [ 'ListProjectsResponse$items' => '<p>Information about the projects.</p>', ], ], 'ProjectSummary' => [ 'base' => '<p>Information about a project.</p>', 'refs' => [ 'ProjectSummaries$member' => NULL, ], ], 'RegionString' => [ 'base' => NULL, 'refs' => [ 'GetSpaceResponse$regionName' => '<p>The Amazon Web Services Region where the space exists.</p>', 'SpaceSummary$regionName' => '<p>The Amazon Web Services Region where the space exists.</p>', ], ], 'RepositoriesInput' => [ 'base' => NULL, 'refs' => [ 'CreateDevEnvironmentRequest$repositories' => '<p>The source repository that contains the branch to clone into the Dev Environment. </p>', ], ], 'RepositoryInput' => [ 'base' => '<p>Information about a repository that will be cloned to a Dev Environment.</p>', 'refs' => [ 'RepositoriesInput$member' => NULL, ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request was denied because the specified resource was not found. Verify that the spelling is correct and that you have access to the resource.</p>', 'refs' => [], ], 'SensitiveString' => [ 'base' => NULL, 'refs' => [ 'DevEnvironmentAccessDetails$streamUrl' => '<p>The URL used to send commands to and from the Dev Environment.</p>', 'DevEnvironmentAccessDetails$tokenValue' => '<p>An encrypted token value that contains session and caller information used to authenticate the connection.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request was denied because one or more resources has reached its limits for the tier the space belongs to. Either reduce the number of resources, or change the tier if applicable.</p>', 'refs' => [], ], 'SourceRepositoryBranchRefString' => [ 'base' => NULL, 'refs' => [ 'CreateSourceRepositoryBranchResponse$ref' => '<p>The Git reference name of the branch.</p>', 'ListSourceRepositoryBranchesItem$ref' => '<p>The Git reference name of the branch.</p>', ], ], 'SourceRepositoryBranchString' => [ 'base' => NULL, 'refs' => [ 'CreateSourceRepositoryBranchRequest$name' => '<p>The name for the branch you\'re creating.</p>', 'CreateSourceRepositoryBranchResponse$name' => '<p>The name of the newly created branch.</p>', 'DevEnvironmentRepositorySummary$branchName' => '<p>The name of the branch in a source repository cloned into the Dev Environment. </p>', 'GetWorkflowResponse$sourceBranchName' => '<p>The name of the branch that contains the workflow YAML.</p>', 'ListSourceRepositoryBranchesItem$name' => '<p>The name of the branch.</p>', 'RepositoryInput$branchName' => '<p>The name of the branch in a source repository.</p>', 'WorkflowSummary$sourceBranchName' => '<p>The name of the branch of the source repository where the workflow definition file is stored.</p>', ], ], 'SourceRepositoryDescriptionString' => [ 'base' => NULL, 'refs' => [ 'CreateSourceRepositoryRequest$description' => '<p>The description of the source repository.</p>', 'CreateSourceRepositoryResponse$description' => '<p>The description of the source repository.</p>', 'GetSourceRepositoryResponse$description' => '<p>The description of the source repository.</p>', 'ListSourceRepositoriesItem$description' => '<p>The description of the repository, if any.</p>', ], ], 'SourceRepositoryIdString' => [ 'base' => NULL, 'refs' => [ 'ListSourceRepositoriesItem$id' => '<p>The system-generated unique ID of the source repository.</p>', ], ], 'SourceRepositoryNameString' => [ 'base' => NULL, 'refs' => [ 'CreateSourceRepositoryBranchRequest$sourceRepositoryName' => '<p>The name of the repository where you want to create a branch.</p>', 'CreateSourceRepositoryRequest$name' => '<p>The name of the source repository. For more information about name requirements, see <a href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/source-quotas.html">Quotas for source repositories</a>.</p>', 'CreateSourceRepositoryResponse$name' => '<p>The name of the source repository.</p>', 'DeleteSourceRepositoryRequest$name' => '<p>The name of the source repository.</p>', 'DeleteSourceRepositoryResponse$name' => '<p>The name of the repository.</p>', 'DevEnvironmentRepositorySummary$repositoryName' => '<p>The name of the source repository.</p>', 'GetSourceRepositoryCloneUrlsRequest$sourceRepositoryName' => '<p>The name of the source repository.</p>', 'GetSourceRepositoryRequest$name' => '<p>The name of the source repository.</p>', 'GetSourceRepositoryResponse$name' => '<p>The name of the source repository.</p>', 'GetWorkflowResponse$sourceRepositoryName' => '<p>The name of the source repository where the workflow YAML is stored.</p>', 'ListSourceRepositoriesItem$name' => '<p>The name of the source repository.</p>', 'ListSourceRepositoryBranchesRequest$sourceRepositoryName' => '<p>The name of the source repository.</p>', 'RepositoryInput$repositoryName' => '<p>The name of the source repository.</p>', 'WorkflowSummary$sourceRepositoryName' => '<p>The name of the source repository where the workflow definition file is stored.</p>', ], ], 'SpaceDescription' => [ 'base' => NULL, 'refs' => [ 'UpdateSpaceRequest$description' => '<p>The description of the space.</p>', ], ], 'SpaceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSpacesResponse$items' => '<p>Information about the spaces. </p>', ], ], 'SpaceSummary' => [ 'base' => '<p>Information about an space.</p>', 'refs' => [ 'SpaceSummaries$member' => NULL, ], ], 'StartDevEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDevEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartDevEnvironmentSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDevEnvironmentSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartDevEnvironmentSessionResponseSessionIdString' => [ 'base' => NULL, 'refs' => [ 'StartDevEnvironmentSessionResponse$sessionId' => '<p>The system-generated unique ID of the Dev Environment session.</p>', ], ], 'StartWorkflowRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartWorkflowRunRequestClientTokenString' => [ 'base' => NULL, 'refs' => [ 'StartWorkflowRunRequest$clientToken' => '<p>A user-specified idempotency token. Idempotency ensures that an API request completes only once. With an idempotent request, if the original request completes successfully, the subsequent retries return the result from the original successful request and have no additional effect.</p>', ], ], 'StartWorkflowRunRequestProjectNameString' => [ 'base' => NULL, 'refs' => [ 'StartWorkflowRunRequest$projectName' => '<p>The name of the project in the space.</p>', ], ], 'StartWorkflowRunRequestSpaceNameString' => [ 'base' => NULL, 'refs' => [ 'StartWorkflowRunRequest$spaceName' => '<p>The name of the space.</p>', ], ], 'StartWorkflowRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatusReason' => [ 'base' => NULL, 'refs' => [ 'DevEnvironmentSummary$statusReason' => '<p>The reason for the status.</p>', 'GetDevEnvironmentResponse$statusReason' => '<p>The reason for the status.</p>', ], ], 'StopDevEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopDevEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopDevEnvironmentSessionRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopDevEnvironmentSessionRequestSessionIdString' => [ 'base' => NULL, 'refs' => [ 'StopDevEnvironmentSessionRequest$sessionId' => '<p>The system-generated unique ID of the Dev Environment session. This ID is returned by <a>StartDevEnvironmentSession</a>.</p>', ], ], 'StopDevEnvironmentSessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopDevEnvironmentSessionResponseSessionIdString' => [ 'base' => NULL, 'refs' => [ 'StopDevEnvironmentSessionResponse$sessionId' => '<p>The system-generated unique ID of the Dev Environment session.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'CreateProjectResponse$displayName' => '<p>The friendly name of the project.</p>', 'CreateProjectResponse$description' => '<p>The description of the project.</p>', 'CreateSourceRepositoryBranchRequest$headCommitId' => '<p>The commit ID in an existing branch from which you want to create the new branch.</p>', 'CreateSourceRepositoryBranchResponse$headCommitId' => '<p>The commit ID of the tip of the newly created branch.</p>', 'DeleteProjectResponse$displayName' => '<p>The friendly name displayed to users of the project in Amazon CodeCatalyst.</p>', 'DeleteSpaceResponse$displayName' => '<p>The friendly name of the space displayed to users of the space in Amazon CodeCatalyst.</p>', 'EmailAddress$email' => '<p>The email address.</p>', 'EventLogEntry$id' => '<p>The system-generated unique ID of the event.</p>', 'EventLogEntry$eventName' => '<p>The name of the event.</p>', 'EventLogEntry$eventType' => '<p>The type of the event.</p>', 'EventLogEntry$eventCategory' => '<p>The category for the event.</p>', 'EventLogEntry$eventSource' => '<p>The source of the event.</p>', 'EventLogEntry$requestId' => '<p>The system-generated unique ID of the request.</p>', 'EventLogEntry$errorCode' => '<p>The code of the error, if any.</p>', 'EventLogEntry$sourceIpAddress' => '<p>The IP address of the user whose actions are recorded in the event.</p>', 'EventLogEntry$userAgent' => '<p>The user agent whose actions are recorded in the event.</p>', 'EventPayload$contentType' => '<p>The type of content in the event payload.</p>', 'EventPayload$data' => '<p>The data included in the event payload.</p>', 'Filter$key' => '<p>A key that can be used to sort results.</p>', 'Filter$comparisonOperator' => '<p>The operator used to compare the fields.</p>', 'GetProjectResponse$name' => '<p>The name of the project in the space.</p>', 'GetProjectResponse$displayName' => '<p>The friendly name of the project displayed to users in Amazon CodeCatalyst.</p>', 'GetProjectResponse$description' => '<p>The description of the project.</p>', 'GetSourceRepositoryCloneUrlsResponse$https' => '<p>The HTTPS URL to use when cloning the source repository.</p>', 'GetSpaceResponse$displayName' => '<p>The friendly name of the space displayed to users.</p>', 'GetSpaceResponse$description' => '<p>The description of the space.</p>', 'GetSubscriptionResponse$subscriptionType' => '<p>The type of the billing plan for the space.</p>', 'GetSubscriptionResponse$pendingSubscriptionType' => '<p>The type of the billing plan that the space will be changed to at the start of the next billing cycle. This applies only to changes that reduce the functionality available for the space. Billing plan changes that increase functionality are applied immediately. For more information, see <a href="https://codecatalyst.aws/explore/pricing">Pricing</a>.</p>', 'GetUserDetailsResponse$userId' => '<p>The system-generated unique ID of the user.</p>', 'GetUserDetailsResponse$userName' => '<p>The name of the user as displayed in Amazon CodeCatalyst.</p>', 'GetUserDetailsResponse$displayName' => '<p>The friendly name displayed for the user in Amazon CodeCatalyst.</p>', 'GetUserDetailsResponse$version' => '<p/>', 'GetWorkflowResponse$name' => '<p>The name of the workflow.</p>', 'ListAccessTokensResponse$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', 'ListDevEnvironmentSessionsResponse$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', 'ListDevEnvironmentsResponse$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', 'ListEventLogsRequest$eventName' => '<p>The name of the event.</p>', 'ListEventLogsResponse$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', 'ListProjectsResponse$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', 'ListSourceRepositoriesResponse$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', 'ListSourceRepositoryBranchesItem$headCommitId' => '<p>The commit ID of the tip of the branch at the time of the request, also known as the head commit.</p>', 'ListSourceRepositoryBranchesResponse$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', 'ListSpacesResponse$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', 'ListWorkflowRunsResponse$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', 'ListWorkflowsResponse$nextToken' => '<p>A token returned from a call to this API to indicate the next batch of results to return, if any.</p>', 'ProjectInformation$name' => '<p>The name of the project in the space.</p>', 'ProjectInformation$projectId' => '<p>The system-generated unique ID of the project.</p>', 'ProjectSummary$name' => '<p>The name of the project in the space.</p>', 'ProjectSummary$displayName' => '<p>The friendly name displayed to users of the project in Amazon CodeCatalyst.</p>', 'ProjectSummary$description' => '<p>The description of the project.</p>', 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'SpaceSummary$displayName' => '<p>The friendly name of the space displayed to users.</p>', 'SpaceSummary$description' => '<p>The description of the space.</p>', 'StringList$member' => NULL, 'ThrottlingException$message' => NULL, 'UpdateProjectResponse$displayName' => '<p>The friendly name of the project displayed to users in Amazon CodeCatalyst.</p>', 'UpdateProjectResponse$description' => '<p>The description of the project.</p>', 'UpdateSpaceResponse$displayName' => '<p>The friendly name of the space displayed to users in Amazon CodeCatalyst.</p>', 'UpdateSpaceResponse$description' => '<p>The description of the space.</p>', 'UserIdentity$principalId' => '<p>The ID of the Amazon CodeCatalyst service principal.</p>', 'UserIdentity$userName' => '<p>The display name of the user in Amazon CodeCatalyst.</p>', 'UserIdentity$awsAccountId' => '<p>The Amazon Web Services account number of the user in Amazon Web Services, if any.</p>', 'ValidationException$message' => NULL, 'WorkflowDefinition$path' => '<p>The path to the workflow definition file stored in the source repository for the project, including the file name.</p>', 'WorkflowDefinitionSummary$path' => '<p>The path to the workflow definition file stored in the source repository for the project, including the file name.</p>', 'WorkflowRunSummary$workflowName' => '<p>The name of the workflow.</p>', 'WorkflowSummary$name' => '<p>The name of the workflow.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'Filter$values' => '<p>The values of the key.</p>', 'ProjectListFilter$values' => '<p>The values of the key.</p>', ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'AccessTokenSummary$expiresTime' => '<p>The date and time when the personal access token will expire, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'CreateAccessTokenRequest$expiresTime' => '<p>The date and time the personal access token expires, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'CreateAccessTokenResponse$expiresTime' => '<p>The date and time the personal access token expires, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>. If not specified, the default is one year from creation.</p>', 'CreateSourceRepositoryBranchResponse$lastUpdatedTime' => '<p>The time the branch was last updated, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'DevEnvironmentSessionSummary$startedTime' => '<p>The date and time the session started, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a> </p>', 'DevEnvironmentSummary$lastUpdatedTime' => '<p>The time when the Dev Environment was last updated, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'EventLogEntry$eventTime' => '<p>The time the event took place, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'GetDevEnvironmentResponse$lastUpdatedTime' => '<p>The time when the Dev Environment was last updated, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'GetSubscriptionResponse$pendingSubscriptionStartTime' => '<p>The day and time the pending change will be applied to the space, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'GetWorkflowResponse$createdTime' => '<p>The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a> </p>', 'GetWorkflowResponse$lastUpdatedTime' => '<p>The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a> </p>', 'GetWorkflowRunResponse$startTime' => '<p>The date and time the workflow run began, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a> </p>', 'GetWorkflowRunResponse$endTime' => '<p>The date and time the workflow run ended, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'GetWorkflowRunResponse$lastUpdatedTime' => '<p>The date and time the workflow run status was last updated, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a> </p>', 'ListEventLogsRequest$startTime' => '<p>The date and time when you want to start retrieving events, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'ListEventLogsRequest$endTime' => '<p>The time after which you do not want any events retrieved, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'ListSourceRepositoryBranchesItem$lastUpdatedTime' => '<p>The time the branch was last updated, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'WorkflowRunSummary$startTime' => '<p>The date and time the workflow run began, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'WorkflowRunSummary$endTime' => '<p>The date and time the workflow run ended, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a> </p>', 'WorkflowRunSummary$lastUpdatedTime' => '<p>The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a> </p>', 'WorkflowSummary$createdTime' => '<p>The date and time the workflow was created, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a> </p>', 'WorkflowSummary$lastUpdatedTime' => '<p>The date and time the workflow was last updated, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a> </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'GetSourceRepositoryResponse$lastUpdatedTime' => '<p>The time the source repository was last updated, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'GetSourceRepositoryResponse$createdTime' => '<p>The time the source repository was created, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'ListSourceRepositoriesItem$lastUpdatedTime' => '<p>The time the source repository was last updated, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', 'ListSourceRepositoriesItem$createdTime' => '<p>The time the source repository was created, in coordinated universal time (UTC) timestamp format as specified in <a href="https://www.rfc-editor.org/rfc/rfc3339#section-5.6">RFC 3339</a>.</p>', ], ], 'UpdateDevEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDevEnvironmentRequestAliasString' => [ 'base' => NULL, 'refs' => [ 'UpdateDevEnvironmentRequest$alias' => '<p>The user-specified alias for the Dev Environment. Changing this value will not cause a restart.</p>', ], ], 'UpdateDevEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDevEnvironmentResponseAliasString' => [ 'base' => NULL, 'refs' => [ 'UpdateDevEnvironmentResponse$alias' => '<p>The user-specified alias for the Dev Environment.</p>', ], ], 'UpdateProjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProjectResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSpaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSpaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UserIdentity' => [ 'base' => '<p>Information about a user whose activity is recorded in an event for a space.</p>', 'refs' => [ 'EventLogEntry$userIdentity' => '<p>The system-generated unique ID of the user whose actions are recorded in the event.</p>', ], ], 'UserType' => [ 'base' => NULL, 'refs' => [ 'UserIdentity$userType' => '<p>The role assigned to the user in a Amazon CodeCatalyst space or project when the event occurred.</p>', ], ], 'Uuid' => [ 'base' => NULL, 'refs' => [ 'CreateDevEnvironmentResponse$id' => '<p>The system-generated unique ID of the Dev Environment. </p>', 'DeleteDevEnvironmentRequest$id' => '<p>The system-generated unique ID of the Dev Environment you want to delete. To retrieve a list of Dev Environment IDs, use <a>ListDevEnvironments</a>.</p>', 'DeleteDevEnvironmentResponse$id' => '<p>The system-generated unique ID of the deleted Dev Environment. </p>', 'DevEnvironmentSessionSummary$devEnvironmentId' => '<p>The system-generated unique ID of the Dev Environment.</p>', 'DevEnvironmentSummary$id' => '<p>The system-generated unique ID for the Dev Environment. </p>', 'GetDevEnvironmentRequest$id' => '<p>The system-generated unique ID of the Dev Environment for which you want to view information. To retrieve a list of Dev Environment IDs, use <a>ListDevEnvironments</a>.</p>', 'GetDevEnvironmentResponse$id' => '<p>The system-generated unique ID of the Dev Environment. </p>', 'GetWorkflowRequest$id' => '<p>The ID of the workflow. To rerieve a list of workflow IDs, use <a>ListWorkflows</a>.</p>', 'GetWorkflowResponse$id' => '<p>The ID of the workflow.</p>', 'GetWorkflowRunRequest$id' => '<p>The ID of the workflow run. To retrieve a list of workflow run IDs, use <a>ListWorkflowRuns</a>.</p>', 'GetWorkflowRunResponse$id' => '<p>The ID of the workflow run.</p>', 'GetWorkflowRunResponse$workflowId' => '<p>The ID of the workflow.</p>', 'ListDevEnvironmentSessionsRequest$devEnvironmentId' => '<p>The system-generated unique ID of the Dev Environment.</p>', 'ListWorkflowRunsRequest$workflowId' => '<p>The ID of the workflow. To retrieve a list of workflow IDs, use <a>ListWorkflows</a>.</p>', 'StartDevEnvironmentRequest$id' => '<p>The system-generated unique ID of the Dev Environment. </p>', 'StartDevEnvironmentResponse$id' => '<p>The system-generated unique ID of the Dev Environment. </p>', 'StartDevEnvironmentSessionRequest$id' => '<p>The system-generated unique ID of the Dev Environment.</p>', 'StartDevEnvironmentSessionResponse$id' => '<p>The system-generated unique ID of the Dev Environment.</p>', 'StartWorkflowRunRequest$workflowId' => '<p>The system-generated unique ID of the workflow. To retrieve a list of workflow IDs, use <a>ListWorkflows</a>.</p>', 'StartWorkflowRunResponse$id' => '<p>The system-generated unique ID of the workflow run.</p>', 'StartWorkflowRunResponse$workflowId' => '<p>The system-generated unique ID of the workflow.</p>', 'StopDevEnvironmentRequest$id' => '<p>The system-generated unique ID of the Dev Environment. </p>', 'StopDevEnvironmentResponse$id' => '<p>The system-generated unique ID of the Dev Environment. </p>', 'StopDevEnvironmentSessionRequest$id' => '<p>The system-generated unique ID of the Dev Environment. To obtain this ID, use <a>ListDevEnvironments</a>.</p>', 'StopDevEnvironmentSessionResponse$id' => '<p>The system-generated unique ID of the Dev Environment.</p>', 'UpdateDevEnvironmentRequest$id' => '<p>The system-generated unique ID of the Dev Environment. </p>', 'UpdateDevEnvironmentResponse$id' => '<p>The system-generated unique ID of the Dev Environment. </p>', 'WorkflowRunSummary$id' => '<p>The system-generated unique ID of the workflow run.</p>', 'WorkflowRunSummary$workflowId' => '<p>The system-generated unique ID of the workflow.</p>', 'WorkflowSummary$id' => '<p>The system-generated unique ID of a workflow.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The request was denied because an input failed to satisfy the constraints specified by the service. Check the spelling and input requirements, and then try again.</p>', 'refs' => [], ], 'VerifySessionResponse' => [ 'base' => NULL, 'refs' => [], ], 'VerifySessionResponseIdentityString' => [ 'base' => NULL, 'refs' => [ 'VerifySessionResponse$identity' => '<p>The system-generated unique ID of the user in Amazon CodeCatalyst.</p>', ], ], 'WorkflowDefinition' => [ 'base' => '<p>Information about a workflow definition file.</p>', 'refs' => [ 'GetWorkflowResponse$definition' => '<p>Information about the workflow definition file for the workflow.</p>', ], ], 'WorkflowDefinitionSummary' => [ 'base' => '<p>Information about a workflow definition.</p>', 'refs' => [ 'WorkflowSummary$definition' => '<p>Information about the workflow definition file.</p>', ], ], 'WorkflowRunMode' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowResponse$runMode' => '<p>The behavior to use when multiple workflows occur at the same time. For more information, see <a href="https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html">https://docs.aws.amazon.com/codecatalyst/latest/userguide/workflows-configure-runs.html</a> in the Amazon CodeCatalyst User Guide.</p>', 'WorkflowSummary$runMode' => '<p>The run mode of the workflow.</p>', ], ], 'WorkflowRunSortCriteria' => [ 'base' => '<p>Information used to sort workflow runs in the returned list.</p>', 'refs' => [ 'WorkflowRunSortCriteriaList$member' => NULL, ], ], 'WorkflowRunSortCriteriaList' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowRunsRequest$sortBy' => '<p>Information used to sort the items in the returned list.</p>', ], ], 'WorkflowRunStatus' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowRunResponse$status' => '<p>The status of the workflow run.</p>', 'WorkflowRunSummary$status' => '<p>The status of the workflow run.</p>', ], ], 'WorkflowRunStatusReason' => [ 'base' => '<p>Information about the status of a workflow run.</p>', 'refs' => [ 'WorkflowRunStatusReasons$member' => NULL, ], ], 'WorkflowRunStatusReasons' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowRunResponse$statusReasons' => '<p>Information about the reasons for the status of the workflow run.</p>', 'WorkflowRunSummary$statusReasons' => '<p>The reasons for the workflow run status.</p>', ], ], 'WorkflowRunSummaries' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowRunsResponse$items' => '<p>Information about the runs of a workflow.</p>', ], ], 'WorkflowRunSummary' => [ 'base' => '<p>Information about a workflow run.</p>', 'refs' => [ 'WorkflowRunSummaries$member' => NULL, ], ], 'WorkflowSortCriteria' => [ 'base' => '<p>Information used to sort workflows in the returned list.</p>', 'refs' => [ 'WorkflowSortCriteriaList$member' => NULL, ], ], 'WorkflowSortCriteriaList' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowsRequest$sortBy' => '<p>Information used to sort the items in the returned list.</p>', ], ], 'WorkflowStatus' => [ 'base' => NULL, 'refs' => [ 'GetWorkflowResponse$status' => '<p>The status of the workflow.</p>', 'WorkflowSummary$status' => '<p>The status of the workflow.</p>', ], ], 'WorkflowSummaries' => [ 'base' => NULL, 'refs' => [ 'ListWorkflowsResponse$items' => '<p>Information about the workflows in a project.</p>', ], ], 'WorkflowSummary' => [ 'base' => '<p>Information about a workflow.</p>', 'refs' => [ 'WorkflowSummaries$member' => NULL, ], ], ],];
