<?php
// This file was auto-generated from sdk-root/src/data/codeguru-security/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<note> <p>Amazon CodeGuru Security is in preview release and is subject to change.</p> </note> <p>This section provides documentation for the Amazon CodeGuru Security API operations. CodeGuru Security is a service that uses program analysis and machine learning to detect security policy violations and vulnerabilities, and recommends ways to address these security risks.</p> <p>By proactively detecting and providing recommendations for addressing security risks, CodeGuru Security improves the overall security of your application code. For more information about CodeGuru Security, see the <a href="https://docs.aws.amazon.com/codeguru/latest/security-ug/what-is-codeguru-security.html">Amazon CodeGuru Security User Guide</a>. </p>', 'operations' => [ 'BatchGetFindings' => '<p>Returns a list of requested findings from standard scans.</p>', 'CreateScan' => '<p>Use to create a scan using code uploaded to an Amazon S3 bucket.</p>', 'CreateUploadUrl' => '<p>Generates a pre-signed URL, request headers used to upload a code resource, and code artifact identifier for the uploaded resource.</p> <p>You can upload your code resource to the URL with the request headers using any HTTP client.</p>', 'GetAccountConfiguration' => '<p>Use to get the encryption configuration for an account.</p>', 'GetFindings' => '<p>Returns a list of all findings generated by a particular scan.</p>', 'GetMetricsSummary' => '<p>Returns a summary of metrics for an account from a specified date, including number of open findings, the categories with most findings, the scans with most open findings, and scans with most open critical findings. </p>', 'GetScan' => '<p>Returns details about a scan, including whether or not a scan has completed.</p>', 'ListFindingsMetrics' => '<p>Returns metrics about all findings in an account within a specified time range.</p>', 'ListScans' => '<p>Returns a list of all scans in an account. Does not return <code>EXPRESS</code> scans.</p>', 'ListTagsForResource' => '<p>Returns a list of all tags associated with a scan.</p>', 'TagResource' => '<p>Use to add one or more tags to an existing scan.</p>', 'UntagResource' => '<p>Use to remove one or more tags from an existing scan.</p>', 'UpdateAccountConfiguration' => '<p>Use to update the encryption configuration for an account.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccountFindingsMetric' => [ 'base' => '<p>A summary of findings metrics for an account on a specified date.</p>', 'refs' => [ 'FindingsMetricList$member' => NULL, ], ], 'AnalysisType' => [ 'base' => NULL, 'refs' => [ 'CreateScanRequest$analysisType' => '<p>The type of analysis you want CodeGuru Security to perform in the scan, either <code>Security</code> or <code>All</code>. The <code>Security</code> type only generates findings related to security. The <code>All</code> type generates both security findings and quality findings. Defaults to <code>Security</code> type if missing.</p>', 'GetScanResponse$analysisType' => '<p>The type of analysis CodeGuru Security performed in the scan, either <code>Security</code> or <code>All</code>. The <code>Security</code> type only generates findings related to security. The <code>All</code> type generates both security findings and quality findings.</p>', ], ], 'BatchGetFindingsError' => [ 'base' => '<p>Contains information about the error that caused a finding to fail to be retrieved.</p>', 'refs' => [ 'BatchGetFindingsErrors$member' => NULL, ], ], 'BatchGetFindingsErrors' => [ 'base' => NULL, 'refs' => [ 'BatchGetFindingsResponse$failedFindings' => '<p>A list of errors for individual findings which were not fetched. Each BatchGetFindingsError contains the <code>scanName</code>, <code>findingId</code>, <code>errorCode</code> and error <code>message</code>.</p>', ], ], 'BatchGetFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'CategoriesWithMostFindings' => [ 'base' => NULL, 'refs' => [ 'MetricsSummary$categoriesWithMostFindings' => '<p>A list of <code>CategoryWithFindingNum</code> objects for the top 5 finding categories with the most findings.</p>', ], ], 'CategoryWithFindingNum' => [ 'base' => '<p>Information about a finding category with open findings.</p>', 'refs' => [ 'CategoriesWithMostFindings$member' => NULL, ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateScanRequest$clientToken' => '<p>The idempotency token for the request. Amazon CodeGuru Security uses this value to prevent the accidental creation of duplicate scans if there are failures and retries.</p>', ], ], 'CodeLine' => [ 'base' => '<p>The line of code where a finding was detected.</p>', 'refs' => [ 'CodeSnippet$member' => NULL, ], ], 'CodeSnippet' => [ 'base' => NULL, 'refs' => [ 'FilePath$codeSnippet' => '<p>A list of <code>CodeLine</code> objects that describe where the security vulnerability appears in your code.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request.</p>', 'refs' => [], ], 'CreateScanRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateScanResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUploadUrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUploadUrlResponse' => [ 'base' => NULL, 'refs' => [], ], 'DetectorTags' => [ 'base' => NULL, 'refs' => [ 'Finding$detectorTags' => '<p>One or more tags or categorizations that are associated with a detector. These tags are defined by type, programming language, or other classification such as maintainability or consistency.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'FindingMetricsValuePerSeverity$critical' => '<p>A numeric value corresponding to a critical finding.</p>', 'FindingMetricsValuePerSeverity$high' => '<p>A numeric value corresponding to a high severity finding.</p>', 'FindingMetricsValuePerSeverity$info' => '<p>A numeric value corresponding to an informational finding.</p>', 'FindingMetricsValuePerSeverity$low' => '<p>A numeric value corresponding to a low severity finding.</p>', 'FindingMetricsValuePerSeverity$medium' => '<p>A numeric value corresponding to a medium severity finding.</p>', ], ], 'EncryptionConfig' => [ 'base' => '<p>Information about the encryption configuration for an account. Required to call <code>UpdateAccountConfiguration</code>.</p>', 'refs' => [ 'GetAccountConfigurationResponse$encryptionConfig' => '<p>An <code>EncryptionConfig</code> object that contains the KMS key ARN that is used for encryption. By default, CodeGuru Security uses an AWS-managed key for encryption. To specify your own key, call <code>UpdateAccountConfiguration</code>. If you do not specify a customer-managed key, returns empty.</p>', 'UpdateAccountConfigurationRequest$encryptionConfig' => '<p>The customer-managed KMS key ARN you want to use for encryption. If not specified, CodeGuru Security will use an AWS-managed key for encryption. If you previously specified a customer-managed KMS key and want CodeGuru Security to use an AWS-managed key for encryption instead, pass nothing.</p>', 'UpdateAccountConfigurationResponse$encryptionConfig' => '<p>An <code>EncryptionConfig</code> object that contains the KMS key ARN that is used for encryption. If you did not specify a customer-managed KMS key in the request, returns empty. </p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchGetFindingsError$errorCode' => '<p>A code associated with the type of error.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'GetScanResponse$errorMessage' => '<p>Details about the error that causes a scan to fail to be retrieved.</p>', ], ], 'FilePath' => [ 'base' => '<p>Information about the location of security vulnerabilities that Amazon CodeGuru Security detected in your code.</p>', 'refs' => [ 'Vulnerability$filePath' => '<p> An object that describes the location of the detected security vulnerability in your code.</p>', ], ], 'Finding' => [ 'base' => '<p>Information about a finding that was detected in your code.</p>', 'refs' => [ 'Findings$member' => NULL, ], ], 'FindingIdentifier' => [ 'base' => '<p>An object that contains information about a finding and the scan that generated it. </p>', 'refs' => [ 'FindingIdentifiers$member' => NULL, ], ], 'FindingIdentifiers' => [ 'base' => NULL, 'refs' => [ 'BatchGetFindingsRequest$findingIdentifiers' => '<p>A list of finding identifiers. Each identifier consists of a <code>scanName</code> and a <code>findingId</code>. You retrieve the <code>findingId</code> when you call <code>GetFindings</code>.</p>', ], ], 'FindingMetricsValuePerSeverity' => [ 'base' => '<p>A numeric value corresponding to the severity of a finding, such as the number of open findings or the average time it takes to close findings of a given severity.</p>', 'refs' => [ 'AccountFindingsMetric$closedFindings' => '<p>The number of closed findings of each severity on the specified date.</p>', 'AccountFindingsMetric$meanTimeToClose' => '<p>The average time in days it takes to close findings of each severity as of a specified date.</p>', 'AccountFindingsMetric$newFindings' => '<p>The number of new findings of each severity on the specified date.</p>', 'AccountFindingsMetric$openFindings' => '<p>The number of open findings of each severity as of the specified date.</p>', 'MetricsSummary$openFindings' => '<p>The number of open findings of each severity.</p>', ], ], 'Findings' => [ 'base' => NULL, 'refs' => [ 'BatchGetFindingsResponse$findings' => '<p> A list of all findings which were successfully fetched.</p>', 'GetFindingsResponse$findings' => '<p>A list of findings generated by the specified scan.</p>', ], ], 'FindingsMetricList' => [ 'base' => NULL, 'refs' => [ 'ListFindingsMetricsResponse$findingsMetrics' => '<p>A list of <code>AccountFindingsMetric</code> objects retrieved from the specified time interval.</p>', ], ], 'GetAccountConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccountConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFindingsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'GetFindingsRequest$maxResults' => '<p>The maximum number of results to return in the response. Use this parameter when paginating results. If additional results exist beyond the number you specify, the <code>nextToken</code> element is returned in the response. Use <code>nextToken</code> in a subsequent request to retrieve additional results. If not specified, returns 1000 results.</p>', ], ], 'GetFindingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricsSummaryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricsSummaryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetScanRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetScanResponse' => [ 'base' => NULL, 'refs' => [], ], 'HeaderKey' => [ 'base' => NULL, 'refs' => [ 'RequestHeaderMap$key' => NULL, ], ], 'HeaderValue' => [ 'base' => NULL, 'refs' => [ 'RequestHeaderMap$value' => NULL, ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'CategoryWithFindingNum$findingNumber' => '<p>The number of open findings in the category.</p>', 'CodeLine$number' => '<p>The code line number.</p>', 'FilePath$endLine' => '<p>The last line number of the code snippet where the security vulnerability appears in your code.</p>', 'FilePath$startLine' => '<p>The first line number of the code snippet where the security vulnerability appears in your code.</p>', 'ScanNameWithFindingNum$findingNumber' => '<p>The number of findings generated by a scan.</p>', 'Vulnerability$itemCount' => '<p>The number of times the vulnerability appears in your code.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The server encountered an internal error and is unable to complete the request.</p>', 'refs' => [], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfig$kmsKeyArn' => '<p>The KMS key ARN that is used for encryption. If an AWS-managed key is used for encryption, returns empty.</p>', ], ], 'ListFindingsMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFindingsMetricsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListFindingsMetricsRequest$maxResults' => '<p>The maximum number of results to return in the response. Use this parameter when paginating results. If additional results exist beyond the number you specify, the <code>nextToken</code> element is returned in the response. Use <code>nextToken</code> in a subsequent request to retrieve additional results. If not specified, returns 1000 results.</p>', ], ], 'ListFindingsMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListScansRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListScansRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListScansRequest$maxResults' => '<p>The maximum number of results to return in the response. Use this parameter when paginating results. If additional results exist beyond the number you specify, the <code>nextToken</code> element is returned in the response. Use <code>nextToken</code> in a subsequent request to retrieve additional results. If not specified, returns 100 results.</p>', ], ], 'ListScansResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'GetScanResponse$numberOfRevisions' => '<p>The number of times a scan has been re-run on a revised resource.</p>', ], ], 'MetricsSummary' => [ 'base' => '<p>A summary of metrics for an account as of a specified date.</p>', 'refs' => [ 'GetMetricsSummaryResponse$metricsSummary' => '<p>The summary metrics from the specified date.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetFindingsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request. For subsequent calls, use the <code>nextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'GetFindingsResponse$nextToken' => '<p>A pagination token. You can use this in future calls to <code>GetFindings</code> to continue listing results after the current page. </p>', 'ListFindingsMetricsRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request. For subsequent calls, use the <code>nextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListFindingsMetricsResponse$nextToken' => '<p>A pagination token. You can use this in future calls to <code>ListFindingMetrics</code> to continue listing results after the current page. </p>', 'ListScansRequest$nextToken' => '<p>A token to use for paginating results that are returned in the response. Set the value of this parameter to null for the first request. For subsequent calls, use the <code>nextToken</code> value returned from the previous request to continue listing results after the first page.</p>', 'ListScansResponse$nextToken' => '<p>A pagination token. You can use this in future calls to <code>ListScans</code> to continue listing results after the current page.</p>', ], ], 'Recommendation' => [ 'base' => '<p>Information about the recommended course of action to remediate a finding.</p>', 'refs' => [ 'Remediation$recommendation' => '<p>An object that contains information about the recommended course of action to remediate a finding.</p>', ], ], 'ReferenceUrls' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$referenceUrls' => '<p>One or more URL addresses that contain details about a vulnerability.</p>', ], ], 'RelatedVulnerabilities' => [ 'base' => NULL, 'refs' => [ 'Vulnerability$relatedVulnerabilities' => '<p>One or more vulnerabilities that are related to the vulnerability being described.</p>', ], ], 'Remediation' => [ 'base' => '<p>Information about how to remediate a finding.</p>', 'refs' => [ 'Finding$remediation' => '<p>An object that contains the details about how to remediate a finding.</p>', ], ], 'RequestHeaderMap' => [ 'base' => NULL, 'refs' => [ 'CreateUploadUrlResponse$requestHeaders' => '<p>A set of key-value pairs that contain the required headers when uploading your resource.</p>', ], ], 'Resource' => [ 'base' => '<p>Information about a resource that contains a finding.</p>', 'refs' => [ 'Finding$resource' => '<p>The resource where Amazon CodeGuru Security detected a finding.</p>', ], ], 'ResourceId' => [ 'base' => '<p>The identifier for a resource object that contains resources to scan. Specifying a codeArtifactId is required to create a scan.</p>', 'refs' => [ 'CreateScanRequest$resourceId' => '<p>The identifier for the resource object to be scanned.</p>', 'CreateScanResponse$resourceId' => '<p>The identifier for the resource object that contains resources that were scanned.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource specified in the request was not found.</p>', 'refs' => [], ], 'S3Url' => [ 'base' => NULL, 'refs' => [ 'CreateUploadUrlResponse$s3Url' => '<p>A pre-signed S3 URL. You can upload the code file you want to scan with the required <code>requestHeaders</code> using any HTTP client.</p>', ], ], 'ScanName' => [ 'base' => NULL, 'refs' => [ 'BatchGetFindingsError$scanName' => '<p>The name of the scan that generated the finding.</p>', 'CreateScanRequest$scanName' => '<p>The unique name that CodeGuru Security uses to track revisions across multiple scans of the same resource. Only allowed for a <code>STANDARD</code> scan type. </p>', 'CreateScanResponse$scanName' => '<p>The name of the scan.</p>', 'CreateUploadUrlRequest$scanName' => '<p>The name of the scan that will use the uploaded resource. CodeGuru Security uses the unique scan name to track revisions across multiple scans of the same resource. Use this <code>scanName</code> when you call <code>CreateScan</code> on the code resource you upload to this URL.</p>', 'GetFindingsRequest$scanName' => '<p>The name of the scan you want to retrieve findings from.</p>', 'GetScanRequest$scanName' => '<p>The name of the scan you want to view details about.</p>', 'GetScanResponse$scanName' => '<p>The name of the scan.</p>', 'ScanSummary$scanName' => '<p>The name of the scan. </p>', ], ], 'ScanNameArn' => [ 'base' => NULL, 'refs' => [ 'CreateScanResponse$scanNameArn' => '<p>The ARN for the scan name.</p>', 'GetScanResponse$scanNameArn' => '<p>The ARN for the scan name.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the <code>ScanName</code> object. You can retrieve this ARN by calling <code>CreateScan</code>, <code>ListScans</code>, or <code>GetScan</code>.</p>', 'ScanSummary$scanNameArn' => '<p>The ARN for the scan name.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the <code>ScanName</code> object. You can retrieve this ARN by calling <code>CreateScan</code>, <code>ListScans</code>, or <code>GetScan</code>.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the <code>ScanName</code> object. You can retrieve this ARN by calling <code>CreateScan</code>, <code>ListScans</code>, or <code>GetScan</code>.</p>', ], ], 'ScanNameWithFindingNum' => [ 'base' => '<p>Information about the number of findings generated by a scan.</p>', 'refs' => [ 'ScansWithMostOpenCriticalFindings$member' => NULL, 'ScansWithMostOpenFindings$member' => NULL, ], ], 'ScanState' => [ 'base' => NULL, 'refs' => [ 'CreateScanResponse$scanState' => '<p>The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or <code>Failed</code>.</p>', 'GetScanResponse$scanState' => '<p>The current state of the scan. Returns either <code>InProgress</code>, <code>Successful</code>, or <code>Failed</code>.</p>', 'ScanSummary$scanState' => '<p>The state of the scan. A scan can be <code>In Progress</code>, <code>Complete</code>, or <code>Failed</code>. </p>', ], ], 'ScanSummaries' => [ 'base' => NULL, 'refs' => [ 'ListScansResponse$summaries' => '<p>A list of <code>ScanSummary</code> objects with information about all scans in an account.</p>', ], ], 'ScanSummary' => [ 'base' => '<p>Information about a scan. </p>', 'refs' => [ 'ScanSummaries$member' => NULL, ], ], 'ScanType' => [ 'base' => NULL, 'refs' => [ 'CreateScanRequest$scanType' => '<p>The type of scan, either <code>Standard</code> or <code>Express</code>. Defaults to <code>Standard</code> type if missing.</p> <p> <code>Express</code> scans run on limited resources and use a limited set of detectors to analyze your code in near-real time. <code>Standard</code> scans have standard resource limits and use the full set of detectors to analyze your code.</p>', ], ], 'ScansWithMostOpenCriticalFindings' => [ 'base' => NULL, 'refs' => [ 'MetricsSummary$scansWithMostOpenCriticalFindings' => '<p>A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open critical findings.</p>', ], ], 'ScansWithMostOpenFindings' => [ 'base' => NULL, 'refs' => [ 'MetricsSummary$scansWithMostOpenFindings' => '<p>A list of <code>ScanNameWithFindingNum</code> objects for the top 3 scans with the most number of open findings.</p>', ], ], 'Severity' => [ 'base' => NULL, 'refs' => [ 'Finding$severity' => '<p>The severity of the finding. Severity can be critical, high, medium, low, or informational. For information on severity levels, see <a href="https://docs.aws.amazon.com/codeguru/latest/security-ug/findings-overview.html#severity-distribution">Finding severity</a> in the <i>Amazon CodeGuru Security User Guide</i>.</p>', ], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'Finding$status' => '<p>The status of the finding. A finding status can be open or closed. </p>', 'GetFindingsRequest$status' => '<p>The status of the findings you want to get. Pass either <code>Open</code>, <code>Closed</code>, or <code>All</code>.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$errorCode' => '<p>The identifier for the error.</p>', 'AccessDeniedException$message' => '<p>Description of the error.</p>', 'AccessDeniedException$resourceId' => '<p>The identifier for the resource you don\'t have access to.</p>', 'AccessDeniedException$resourceType' => '<p>The type of resource you don\'t have access to.</p>', 'BatchGetFindingsError$findingId' => '<p>The finding ID of the finding that was not fetched.</p>', 'BatchGetFindingsError$message' => '<p>Describes the error.</p>', 'CategoryWithFindingNum$categoryName' => '<p>The name of the finding category. A finding category is determined by the detector that detected the finding.</p>', 'CodeLine$content' => '<p>The code that contains a vulnerability.</p>', 'ConflictException$errorCode' => '<p>The identifier for the error.</p>', 'ConflictException$message' => '<p>Description of the error.</p>', 'ConflictException$resourceId' => '<p>The identifier for the service resource associated with the request.</p>', 'ConflictException$resourceType' => '<p>The type of resource associated with the request.</p>', 'DetectorTags$member' => NULL, 'FilePath$name' => '<p>The name of the file.</p>', 'FilePath$path' => '<p>The path to the resource with the security vulnerability.</p>', 'Finding$description' => '<p>A description of the finding.</p>', 'Finding$detectorId' => '<p>The identifier for the detector that detected the finding in your code. A detector is a defined rule based on industry standards and AWS best practices. </p>', 'Finding$detectorName' => '<p>The name of the detector that identified the security vulnerability in your code. </p>', 'Finding$generatorId' => '<p>The identifier for the component that generated a finding such as AmazonCodeGuruSecurity.</p>', 'Finding$id' => '<p>The identifier for a finding.</p>', 'Finding$ruleId' => '<p>The identifier for the rule that generated the finding.</p>', 'Finding$title' => '<p>The title of the finding.</p>', 'Finding$type' => '<p>The type of finding. </p>', 'FindingIdentifier$findingId' => '<p>The identifier for a finding.</p>', 'FindingIdentifier$scanName' => '<p>The name of the scan that generated the finding. </p>', 'InternalServerException$error' => '<p>The internal error encountered by the server.</p>', 'InternalServerException$message' => '<p>Description of the error.</p>', 'Recommendation$text' => '<p>The recommended course of action to remediate the finding.</p>', 'Recommendation$url' => '<p>The URL address to the recommendation for remediating the finding. </p>', 'ReferenceUrls$member' => NULL, 'RelatedVulnerabilities$member' => NULL, 'Resource$id' => '<p>The <code>scanName</code> of the scan that was run on the resource.</p>', 'Resource$subResourceId' => '<p>The identifier for a section of the resource.</p>', 'ResourceNotFoundException$errorCode' => '<p>The identifier for the error.</p>', 'ResourceNotFoundException$message' => '<p>Description of the error.</p>', 'ResourceNotFoundException$resourceId' => '<p>The identifier for the resource that was not found.</p>', 'ResourceNotFoundException$resourceType' => '<p>The type of resource that was not found.</p>', 'ScanNameWithFindingNum$scanName' => '<p>The name of the scan.</p>', 'SuggestedFix$code' => '<p>The suggested code fix. If applicable, includes code patch to replace your source code. </p>', 'SuggestedFix$description' => '<p>A description of the suggested code fix and why it is being suggested. </p>', 'ThrottlingException$errorCode' => '<p>The identifier for the error.</p>', 'ThrottlingException$message' => '<p>Description of the error.</p>', 'ThrottlingException$quotaCode' => '<p>The identifier for the originating quota.</p>', 'ThrottlingException$serviceCode' => '<p>The identifier for the originating service.</p>', 'ValidationException$errorCode' => '<p>The identifier for the error.</p>', 'ValidationException$message' => '<p>Description of the error.</p>', 'ValidationExceptionField$message' => '<p>Describes the exception.</p>', 'ValidationExceptionField$name' => '<p>The name of the exception.</p>', 'Vulnerability$id' => '<p>The identifier for the vulnerability.</p>', ], ], 'SuggestedFix' => [ 'base' => '<p>Information about the suggested code fix to remediate a finding.</p>', 'refs' => [ 'SuggestedFixes$member' => NULL, ], ], 'SuggestedFixes' => [ 'base' => NULL, 'refs' => [ 'Remediation$suggestedFixes' => '<p>A list of <code>SuggestedFix</code> objects. Each object contains information about a suggested code fix to remediate the finding.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of keys for each tag you want to remove from a scan.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateScanRequest$tags' => '<p>An array of key-value pairs used to tag a scan. A tag is a custom attribute label with two parts:</p> <ul> <li> <p>A tag key. For example, <code>CostCenter</code>, <code>Environment</code>, or <code>Secret</code>. Tag keys are case sensitive.</p> </li> <li> <p>An optional tag value field. For example, <code>111122223333</code>, <code>Production</code>, or a team name. Omitting the tag value is the same as using an empty string. Tag values are case sensitive.</p> </li> </ul>', 'ListTagsForResourceResponse$tags' => '<p>An array of key-value pairs used to tag an existing scan. A tag is a custom attribute label with two parts:</p> <ul> <li> <p>A tag key. For example, <code>CostCenter</code>, <code>Environment</code>, or <code>Secret</code>. Tag keys are case sensitive.</p> </li> <li> <p>An optional tag value field. For example, <code>111122223333</code>, <code>Production</code>, or a team name. Omitting the tag value is the same as using an empty string. Tag values are case sensitive.</p> </li> </ul>', 'TagResourceRequest$tags' => '<p>An array of key-value pairs used to tag an existing scan. A tag is a custom attribute label with two parts:</p> <ul> <li> <p>A tag key. For example, <code>CostCenter</code>, <code>Environment</code>, or <code>Secret</code>. Tag keys are case sensitive.</p> </li> <li> <p>An optional tag value field. For example, <code>111122223333</code>, <code>Production</code>, or a team name. Omitting the tag value is the same as using an empty string. Tag values are case sensitive.</p> </li> </ul>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AccountFindingsMetric$date' => '<p>The date from which the findings metrics were retrieved.</p>', 'Finding$createdAt' => '<p>The time when the finding was created.</p>', 'Finding$updatedAt' => '<p>The time when the finding was last updated. Findings are updated when you remediate them or when the finding code location changes. </p>', 'GetMetricsSummaryRequest$date' => '<p>The date you want to retrieve summary metrics from, rounded to the nearest day. The date must be within the past two years.</p>', 'GetScanResponse$createdAt' => '<p>The time the scan was created.</p>', 'GetScanResponse$updatedAt' => '<p>The time when the scan was last updated. Only available for <code>STANDARD</code> scan types.</p>', 'ListFindingsMetricsRequest$endDate' => '<p>The end date of the interval which you want to retrieve metrics from. Round to the nearest day.</p>', 'ListFindingsMetricsRequest$startDate' => '<p>The start date of the interval which you want to retrieve metrics from. Rounds to the nearest day.</p>', 'MetricsSummary$date' => '<p>The date from which the metrics summary information was retrieved.</p>', 'ScanSummary$createdAt' => '<p> The time when the scan was created. </p>', 'ScanSummary$updatedAt' => '<p>The time the scan was last updated. A scan is updated when it is re-run.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Uuid' => [ 'base' => NULL, 'refs' => [ 'CreateScanResponse$runId' => '<p>UUID that identifies the individual scan run.</p>', 'CreateUploadUrlResponse$codeArtifactId' => '<p>The identifier for the uploaded code resource. Pass this to <code>CreateScan</code> to use the uploaded resources.</p>', 'GetScanRequest$runId' => '<p>UUID that identifies the individual scan run you want to view details about. You retrieve this when you call the <code>CreateScan</code> operation. Defaults to the latest scan run if missing.</p>', 'GetScanResponse$runId' => '<p>UUID that identifies the individual scan run.</p>', 'ResourceId$codeArtifactId' => '<p>The identifier for the code file uploaded to the resource object. Returned by <code>CreateUploadUrl</code> when you upload resources to be scanned.</p>', 'ScanSummary$runId' => '<p>The identifier for the scan run. </p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the specified constraints.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Information about a validation exception.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The field that caused the error, if applicable.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The reason the request failed validation.</p>', ], ], 'Vulnerability' => [ 'base' => '<p>Information about a security vulnerability that Amazon CodeGuru Security detected.</p>', 'refs' => [ 'Finding$vulnerability' => '<p>An object that describes the detected security vulnerability.</p>', ], ], ],];
