<?php
// This file was auto-generated from sdk-root/src/data/codeguruprofiler/2019-07-18/docs-2.json
return [ 'version' => '2.0', 'service' => '<p> This section provides documentation for the Amazon CodeGuru Profiler API operations. </p> <p> Amazon CodeGuru Profiler collects runtime performance data from your live applications, and provides recommendations that can help you fine-tune your application performance. Using machine learning algorithms, CodeGuru Profiler can help you find your most expensive lines of code and suggest ways you can improve efficiency and remove CPU bottlenecks. </p> <p> Amazon CodeGuru Profiler provides different visualizations of profiling data to help you identify what code is running on the CPU, see how much time is consumed, and suggest ways to reduce CPU utilization. </p> <note> <p>Amazon CodeGuru Profiler currently supports applications written in all Java virtual machine (JVM) languages and Python. While CodeGuru Profiler supports both visualizations and recommendations for applications written in Java, it can also generate visualizations and a subset of recommendations for applications written in other JVM languages and Python.</p> </note> <p> For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/what-is-codeguru-profiler.html">What is Amazon CodeGuru Profiler</a> in the <i>Amazon CodeGuru Profiler User Guide</i>. </p>', 'operations' => [ 'AddNotificationChannels' => '<p>Add up to 2 anomaly notifications channels for a profiling group.</p>', 'BatchGetFrameMetricData' => '<p> Returns the time series of values for a requested list of frame metrics from a time period.</p>', 'ConfigureAgent' => '<p> Used by profiler agents to report their current state and to receive remote configuration updates. For example, <code>ConfigureAgent</code> can be used to tell an agent whether to profile or not and for how long to return profiling data. </p>', 'CreateProfilingGroup' => '<p>Creates a profiling group.</p>', 'DeleteProfilingGroup' => '<p>Deletes a profiling group.</p>', 'DescribeProfilingGroup' => '<p> Returns a <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> object that contains information about the requested profiling group. </p>', 'GetFindingsReportAccountSummary' => '<p> Returns a list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html"> <code>FindingsReportSummary</code> </a> objects that contain analysis results for all profiling groups in your AWS account. </p>', 'GetNotificationConfiguration' => '<p>Get the current configuration for anomaly notifications for a profiling group.</p>', 'GetPolicy' => '<p> Returns the JSON-formatted resource-based policy on a profiling group. </p>', 'GetProfile' => '<p> Gets the aggregated profile of a profiling group for a specified time range. Amazon CodeGuru Profiler collects posted agent profiles for a profiling group into aggregated profiles. </p> <pre><code> &lt;note&gt; &lt;p&gt; Because aggregated profiles expire over time &lt;code&gt;GetProfile&lt;/code&gt; is not idempotent. &lt;/p&gt; &lt;/note&gt; &lt;p&gt; Specify the time range for the requested aggregated profile using 1 or 2 of the following parameters: &lt;code&gt;startTime&lt;/code&gt;, &lt;code&gt;endTime&lt;/code&gt;, &lt;code&gt;period&lt;/code&gt;. The maximum time range allowed is 7 days. If you specify all 3 parameters, an exception is thrown. If you specify only &lt;code&gt;period&lt;/code&gt;, the latest aggregated profile is returned. &lt;/p&gt; &lt;p&gt; Aggregated profiles are available with aggregation periods of 5 minutes, 1 hour, and 1 day, aligned to UTC. The aggregation period of an aggregated profile determines how long it is retained. For more information, see &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html&quot;&gt; &lt;code&gt;AggregatedProfileTime&lt;/code&gt; &lt;/a&gt;. The aggregated profile\'s aggregation period determines how long it is retained by CodeGuru Profiler. &lt;/p&gt; &lt;ul&gt; &lt;li&gt; &lt;p&gt; If the aggregation period is 5 minutes, the aggregated profile is retained for 15 days. &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; If the aggregation period is 1 hour, the aggregated profile is retained for 60 days. &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; If the aggregation period is 1 day, the aggregated profile is retained for 3 years. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; &lt;p&gt;There are two use cases for calling &lt;code&gt;GetProfile&lt;/code&gt;.&lt;/p&gt; &lt;ol&gt; &lt;li&gt; &lt;p&gt; If you want to return an aggregated profile that already exists, use &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ListProfileTimes.html&quot;&gt; &lt;code&gt;ListProfileTimes&lt;/code&gt; &lt;/a&gt; to view the time ranges of existing aggregated profiles. Use them in a &lt;code&gt;GetProfile&lt;/code&gt; request to return a specific, existing aggregated profile. &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; If you want to return an aggregated profile for a time range that doesn\'t align with an existing aggregated profile, then CodeGuru Profiler makes a best effort to combine existing aggregated profiles from the requested time range and return them as one aggregated profile. &lt;/p&gt; &lt;p&gt; If aggregated profiles do not exist for the full time range requested, then aggregated profiles for a smaller time range are returned. For example, if the requested time range is from 00:00 to 00:20, and the existing aggregated profiles are from 00:15 and 00:25, then the aggregated profiles from 00:15 to 00:20 are returned. &lt;/p&gt; &lt;/li&gt; &lt;/ol&gt; </code></pre>', 'GetRecommendations' => '<p> Returns a list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Recommendation.html"> <code>Recommendation</code> </a> objects that contain recommendations for a profiling group for a given time period. A list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_Anomaly.html"> <code>Anomaly</code> </a> objects that contains details about anomalies detected in the profiling group for the same time period is also returned. </p>', 'ListFindingsReports' => '<p>List the available reports for a given profiling group and time range.</p>', 'ListProfileTimes' => '<p>Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within the specified time range.</p>', 'ListProfilingGroups' => '<p> Returns a list of profiling groups. The profiling groups are returned as <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> objects. </p>', 'ListTagsForResource' => '<p> Returns a list of the tags that are assigned to a specified resource. </p>', 'PostAgentProfile' => '<p> Submits profiling data to an aggregated profile of a profiling group. To get an aggregated profile that is created with this profiling data, use <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_GetProfile.html"> <code>GetProfile</code> </a>. </p>', 'PutPermission' => '<p> Adds permissions to a profiling group\'s resource-based policy that are provided using an action group. If a profiling group doesn\'t have a resource-based policy, one is created for it using the permissions in the action group and the roles and users in the <code>principals</code> parameter. </p> <pre><code> &lt;p&gt; The one supported action group that can be added is &lt;code&gt;agentPermission&lt;/code&gt; which grants &lt;code&gt;ConfigureAgent&lt;/code&gt; and &lt;code&gt;PostAgent&lt;/code&gt; permissions. For more information, see &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html&quot;&gt;Resource-based policies in CodeGuru Profiler&lt;/a&gt; in the &lt;i&gt;Amazon CodeGuru Profiler User Guide&lt;/i&gt;, &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html&quot;&gt; &lt;code&gt;ConfigureAgent&lt;/code&gt; &lt;/a&gt;, and &lt;a href=&quot;https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html&quot;&gt; &lt;code&gt;PostAgentProfile&lt;/code&gt; &lt;/a&gt;. &lt;/p&gt; &lt;p&gt; The first time you call &lt;code&gt;PutPermission&lt;/code&gt; on a profiling group, do not specify a &lt;code&gt;revisionId&lt;/code&gt; because it doesn\'t have a resource-based policy. Subsequent calls must provide a &lt;code&gt;revisionId&lt;/code&gt; to specify which revision of the resource-based policy to add the permissions to. &lt;/p&gt; &lt;p&gt; The response contains the profiling group\'s JSON-formatted resource policy. &lt;/p&gt; </code></pre>', 'RemoveNotificationChannel' => '<p>Remove one anomaly notifications channel for a profiling group.</p>', 'RemovePermission' => '<p> Removes permissions from a profiling group\'s resource-based policy that are provided using an action group. The one supported action group that can be removed is <code>agentPermission</code> which grants <code>ConfigureAgent</code> and <code>PostAgent</code> permissions. For more information, see <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-ug/resource-based-policies.html">Resource-based policies in CodeGuru Profiler</a> in the <i>Amazon CodeGuru Profiler User Guide</i>, <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html"> <code>ConfigureAgent</code> </a>, and <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_PostAgentProfile.html"> <code>PostAgentProfile</code> </a>. </p>', 'SubmitFeedback' => '<p>Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is useful or not.</p>', 'TagResource' => '<p> Use to assign one or more tags to a resource. </p>', 'UntagResource' => '<p> Use to remove one or more tags from a resource. </p>', 'UpdateProfilingGroup' => '<p>Updates a profiling group.</p>', ], 'shapes' => [ 'ActionGroup' => [ 'base' => NULL, 'refs' => [ 'PutPermissionRequest$actionGroup' => '<p> Specifies an action group that contains permissions to add to a profiling group resource. One action group is supported, <code>agentPermissions</code>, which grants permission to perform actions required by the profiling agent, <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions. </p>', 'RemovePermissionRequest$actionGroup' => '<p> Specifies an action group that contains the permissions to remove from a profiling group\'s resource-based policy. One action group is supported, <code>agentPermissions</code>, which grants <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions. </p>', ], ], 'AddNotificationChannelsRequest' => [ 'base' => '<p>The structure representing the AddNotificationChannelsRequest.</p>', 'refs' => [], ], 'AddNotificationChannelsResponse' => [ 'base' => '<p>The structure representing the AddNotificationChannelsResponse.</p>', 'refs' => [], ], 'AgentConfiguration' => [ 'base' => '<p> The response of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html"> <code>ConfigureAgent</code> </a> that specifies if an agent profiles or not and for how long to return profiling data. </p>', 'refs' => [ 'ConfigureAgentResponse$configuration' => '<p> An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentConfiguration.html"> <code>AgentConfiguration</code> </a> object that specifies if an agent profiles or not and for how long to return profiling data. </p>', ], ], 'AgentOrchestrationConfig' => [ 'base' => '<p> Specifies whether profiling is enabled or disabled for a profiling group. It is used by <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html"> <code>ConfigureAgent</code> </a> to enable or disable profiling for a profiling group. </p>', 'refs' => [ 'CreateProfilingGroupRequest$agentOrchestrationConfig' => '<p> Specifies whether profiling is enabled or disabled for the created profiling group. </p>', 'ProfilingGroupDescription$agentOrchestrationConfig' => '<p> An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentOrchestrationConfig.html"> <code>AgentOrchestrationConfig</code> </a> object that indicates if the profiling group is enabled for profiled or not. </p>', 'UpdateProfilingGroupRequest$agentOrchestrationConfig' => '<p> Specifies whether profiling is enabled or disabled for a profiling group. </p>', ], ], 'AgentParameterField' => [ 'base' => NULL, 'refs' => [ 'AgentParameters$key' => NULL, ], ], 'AgentParameters' => [ 'base' => NULL, 'refs' => [ 'AgentConfiguration$agentParameters' => '<p> Parameters used by the profiler. The valid parameters are: </p> <ul> <li> <p> <code>MaxStackDepth</code> - The maximum depth of the stacks in the code that is represented in the profile. For example, if CodeGuru Profiler finds a method <code>A</code>, which calls method <code>B</code>, which calls method <code>C</code>, which calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is set to 2, then the profiler evaluates <code>A</code> and <code>B</code>. </p> </li> <li> <p> <code>MemoryUsageLimitPercent</code> - The percentage of memory that is used by the profiler.</p> </li> <li> <p> <code>MinimumTimeForReportingInMilliseconds</code> - The minimum time in milliseconds between sending reports. </p> </li> <li> <p> <code>ReportingIntervalInMilliseconds</code> - The reporting interval in milliseconds used to report profiles. </p> </li> <li> <p> <code>SamplingIntervalInMilliseconds</code> - The sampling interval in milliseconds that is used to profile samples. </p> </li> </ul>', ], ], 'AgentProfile' => [ 'base' => NULL, 'refs' => [ 'PostAgentProfileRequest$agentProfile' => '<p> The submitted profiling data. </p>', ], ], 'AggregatedProfile' => [ 'base' => NULL, 'refs' => [ 'GetProfileResponse$profile' => '<p>Information about the profile.</p>', ], ], 'AggregatedProfileTime' => [ 'base' => '<p> Specifies the aggregation period and aggregation start time for an aggregated profile. An aggregated profile is used to collect posted agent profiles during an aggregation period. There are three possible aggregation periods (1 day, 1 hour, or 5 minutes). </p>', 'refs' => [ 'ProfilingStatus$latestAggregatedProfile' => '<p> An <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AggregatedProfileTime.html"> <code>AggregatedProfileTime</code> </a> object that contains the aggregation period and start time for an aggregated profile. </p>', ], ], 'AggregationPeriod' => [ 'base' => NULL, 'refs' => [ 'AggregatedProfileTime$period' => '<p> The aggregation period. This indicates the period during which an aggregation profile collects posted agent profiles for a profiling group. Use one of three valid durations that are specified using the ISO 8601 format. </p> <ul> <li> <p> <code>P1D</code> — 1 day </p> </li> <li> <p> <code>PT1H</code> — 1 hour </p> </li> <li> <p> <code>PT5M</code> — 5 minutes </p> </li> </ul>', 'BatchGetFrameMetricDataRequest$targetResolution' => '<p>The requested resolution of time steps for the returned time series of values. If the requested target resolution is not available due to data not being retained we provide a best effort result by falling back to the most granular available resolution after the target resolution. There are 3 valid values. </p> <ul> <li> <p> <code>P1D</code> — 1 day </p> </li> <li> <p> <code>PT1H</code> — 1 hour </p> </li> <li> <p> <code>PT5M</code> — 5 minutes </p> </li> </ul>', 'BatchGetFrameMetricDataResponse$resolution' => '<p>Resolution or granularity of the profile data used to generate the time series. This is the value used to jump through time steps in a time series. There are 3 valid values. </p> <ul> <li> <p> <code>P1D</code> — 1 day </p> </li> <li> <p> <code>PT1H</code> — 1 hour </p> </li> <li> <p> <code>PT5M</code> — 5 minutes </p> </li> </ul>', 'ListProfileTimesRequest$period' => '<p> The aggregation period. This specifies the period during which an aggregation profile collects posted agent profiles for a profiling group. There are 3 valid values. </p> <ul> <li> <p> <code>P1D</code> — 1 day </p> </li> <li> <p> <code>PT1H</code> — 1 hour </p> </li> <li> <p> <code>PT5M</code> — 5 minutes </p> </li> </ul>', ], ], 'Anomalies' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationsResponse$anomalies' => '<p> The list of anomalies that the analysis has found for this profile. </p>', ], ], 'Anomaly' => [ 'base' => '<p> Details about an anomaly in a specific metric of application profile. The anomaly is detected using analysis of the metric data over a period of time. </p>', 'refs' => [ 'Anomalies$member' => NULL, ], ], 'AnomalyInstance' => [ 'base' => '<p>The specific duration in which the metric is flagged as anomalous.</p>', 'refs' => [ 'AnomalyInstances$member' => NULL, ], ], 'AnomalyInstanceId' => [ 'base' => NULL, 'refs' => [ 'SubmitFeedbackRequest$anomalyInstanceId' => '<p>The universally unique identifier (UUID) of the <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AnomalyInstance.html"> <code>AnomalyInstance</code> </a> object that is included in the analysis data.</p>', ], ], 'AnomalyInstances' => [ 'base' => NULL, 'refs' => [ 'Anomaly$instances' => '<p> A list of the instances of the detected anomalies during the requested period. </p>', ], ], 'BatchGetFrameMetricDataRequest' => [ 'base' => '<p>The structure representing the BatchGetFrameMetricDataRequest.</p>', 'refs' => [], ], 'BatchGetFrameMetricDataResponse' => [ 'base' => '<p>The structure representing the BatchGetFrameMetricDataResponse.</p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AgentConfiguration$shouldProfile' => '<p> A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to <code>true</code> to enable profiling. </p>', 'AgentOrchestrationConfig$profilingEnabled' => '<p> A <code>Boolean</code> that specifies whether the profiling agent collects profiling data or not. Set to <code>true</code> to enable profiling. </p>', 'GetFindingsReportAccountSummaryRequest$dailyReportsOnly' => '<p>A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set to <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>, analysis data is returned from smaller time windows (for example, one hour).</p>', 'ListFindingsReportsRequest$dailyReportsOnly' => '<p>A <code>Boolean</code> value indicating whether to only return reports from daily profiles. If set to <code>True</code>, only analysis data from daily profiles is returned. If set to <code>False</code>, analysis data is returned from smaller time windows (for example, one hour).</p>', 'ListProfilingGroupsRequest$includeDescription' => '<p>A <code>Boolean</code> value indicating whether to include a description. If <code>true</code>, then a list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> objects that contain detailed information about profiling groups is returned. If <code>false</code>, then a list of profiling group names is returned.</p>', ], ], 'Channel' => [ 'base' => '<p>Notification medium for users to get alerted for events that occur in application profile. We support SNS topic as a notification channel.</p>', 'refs' => [ 'Channels$member' => NULL, ], ], 'ChannelId' => [ 'base' => NULL, 'refs' => [ 'Channel$id' => '<p>Unique identifier for each <code>Channel</code> in the notification configuration of a Profiling Group. A random UUID for channelId is used when adding a channel to the notification configuration if not specified in the request.</p>', 'RemoveNotificationChannelRequest$channelId' => '<p>The id of the channel that we want to stop receiving notifications.</p>', ], ], 'ChannelUri' => [ 'base' => '<p>Channel URI uniquely identifies a Notification Channel. TopicArn is the uri for an SNS channel, emailId is uri for an email channel etc. Currently we only support SNS channels and thus required to be an ARN</p>', 'refs' => [ 'Channel$uri' => '<p>Unique arn of the resource to be used for notifications. We support a valid SNS topic arn as a channel uri.</p>', ], ], 'Channels' => [ 'base' => NULL, 'refs' => [ 'AddNotificationChannelsRequest$channels' => '<p>One or 2 channels to report to when anomalies are detected.</p>', 'NotificationConfiguration$channels' => '<p>List of up to two channels to be used for sending notifications for events detected from the application profile.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateProfilingGroupRequest$clientToken' => '<p> Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental creation of duplicate profiling groups if there are failures and retries. </p>', 'PostAgentProfileRequest$profileToken' => '<p> Amazon CodeGuru Profiler uses this universally unique identifier (UUID) to prevent the accidental submission of duplicate profiling data if there are failures and retries. </p>', ], ], 'ComputePlatform' => [ 'base' => NULL, 'refs' => [ 'CreateProfilingGroupRequest$computePlatform' => '<p> The compute platform of the profiling group. Use <code>AWSLambda</code> if your application runs on AWS Lambda. Use <code>Default</code> if your application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform. If not specified, <code>Default</code> is used. </p>', 'ProfilingGroupDescription$computePlatform' => '<p> The compute platform of the profiling group. If it is set to <code>AWSLambda</code>, then the profiled application runs on AWS Lambda. If it is set to <code>Default</code>, then the profiled application runs on a compute platform that is not AWS Lambda, such an Amazon EC2 instance, an on-premises server, or a different platform. The default is <code>Default</code>. </p>', ], ], 'ConfigureAgentRequest' => [ 'base' => '<p>The structure representing the configureAgentRequest.</p>', 'refs' => [], ], 'ConfigureAgentResponse' => [ 'base' => '<p>The structure representing the configureAgentResponse.</p>', 'refs' => [], ], 'ConflictException' => [ 'base' => '<p>The requested operation would cause a conflict with the current state of a service resource associated with the request. Resolve the conflict before retrying this request. </p>', 'refs' => [], ], 'CreateProfilingGroupRequest' => [ 'base' => '<p>The structure representing the createProfiliingGroupRequest.</p>', 'refs' => [], ], 'CreateProfilingGroupResponse' => [ 'base' => '<p>The structure representing the createProfilingGroupResponse.</p>', 'refs' => [], ], 'DeleteProfilingGroupRequest' => [ 'base' => '<p>The structure representing the deleteProfilingGroupRequest.</p>', 'refs' => [], ], 'DeleteProfilingGroupResponse' => [ 'base' => '<p>The structure representing the deleteProfilingGroupResponse.</p>', 'refs' => [], ], 'DescribeProfilingGroupRequest' => [ 'base' => '<p>The structure representing the describeProfilingGroupRequest.</p>', 'refs' => [], ], 'DescribeProfilingGroupResponse' => [ 'base' => '<p>The structure representing the describeProfilingGroupResponse.</p>', 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'Match$thresholdBreachValue' => '<p>The value in the profile data that exceeded the recommendation threshold.</p>', 'Recommendation$allMatchesSum' => '<p>How much of the total sample count is potentially affected.</p>', ], ], 'EventPublisher' => [ 'base' => NULL, 'refs' => [ 'EventPublishers$member' => NULL, ], ], 'EventPublishers' => [ 'base' => NULL, 'refs' => [ 'Channel$eventPublishers' => '<p>List of publishers for different type of events that may be detected in an application from the profile. Anomaly detection is the only event publisher in Profiler.</p>', ], ], 'FeedbackType' => [ 'base' => NULL, 'refs' => [ 'SubmitFeedbackRequest$type' => '<p> The feedback tpye. Thee are two valid values, <code>Positive</code> and <code>Negative</code>. </p>', 'UserFeedback$type' => '<p>Optional <code>Positive</code> or <code>Negative</code> feedback submitted by the user about whether the recommendation is useful or not.</p>', ], ], 'FindingsReportId' => [ 'base' => NULL, 'refs' => [ 'FindingsReportSummary$id' => '<p>The universally unique identifier (UUID) of the recommendation report.</p>', ], ], 'FindingsReportSummaries' => [ 'base' => NULL, 'refs' => [ 'GetFindingsReportAccountSummaryResponse$reportSummaries' => '<p>The return list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_FindingsReportSummary.html"> <code>FindingsReportSummary</code> </a> objects taht contain summaries of analysis results for all profiling groups in your AWS account.</p>', 'ListFindingsReportsResponse$findingsReportSummaries' => '<p>The list of analysis results summaries.</p>', ], ], 'FindingsReportSummary' => [ 'base' => '<p> Information about potential recommendations that might be created from the analysis of profiling data. </p>', 'refs' => [ 'FindingsReportSummaries$member' => NULL, ], ], 'FleetInstanceId' => [ 'base' => NULL, 'refs' => [ 'ConfigureAgentRequest$fleetInstanceId' => '<p> A universally unique identifier (UUID) for a profiling instance. For example, if the profiling instance is an Amazon EC2 instance, it is the instance ID. If it is an AWS Fargate container, it is the container\'s task ID. </p>', ], ], 'FrameMetric' => [ 'base' => '<p> The frame name, metric type, and thread states. These are used to derive the value of the metric for the frame.</p>', 'refs' => [ 'FrameMetricDatum$frameMetric' => NULL, 'FrameMetrics$member' => NULL, ], ], 'FrameMetricData' => [ 'base' => NULL, 'refs' => [ 'BatchGetFrameMetricDataResponse$frameMetricData' => '<p>Details of the metrics to request a time series of values. The metric includes the name of the frame, the aggregation type to calculate the metric value for the frame, and the thread states to use to get the count for the metric value of the frame.</p>', ], ], 'FrameMetricDatum' => [ 'base' => '<p> Information about a frame metric and its values. </p>', 'refs' => [ 'FrameMetricData$member' => NULL, ], ], 'FrameMetricValue' => [ 'base' => NULL, 'refs' => [ 'FrameMetricValues$member' => NULL, ], ], 'FrameMetricValues' => [ 'base' => NULL, 'refs' => [ 'FrameMetricDatum$values' => '<p> A list of values that are associated with a frame metric. </p>', ], ], 'FrameMetrics' => [ 'base' => NULL, 'refs' => [ 'BatchGetFrameMetricDataRequest$frameMetrics' => '<p> The details of the metrics that are used to request a time series of values. The metric includes the name of the frame, the aggregation type to calculate the metric value for the frame, and the thread states to use to get the count for the metric value of the frame.</p>', ], ], 'GetFindingsReportAccountSummaryRequest' => [ 'base' => '<p>The structure representing the GetFindingsReportAccountSummaryRequest.</p>', 'refs' => [], ], 'GetFindingsReportAccountSummaryResponse' => [ 'base' => '<p>The structure representing the GetFindingsReportAccountSummaryResponse.</p>', 'refs' => [], ], 'GetNotificationConfigurationRequest' => [ 'base' => '<p>The structure representing the GetNotificationConfigurationRequest.</p>', 'refs' => [], ], 'GetNotificationConfigurationResponse' => [ 'base' => '<p>The structure representing the GetNotificationConfigurationResponse.</p>', 'refs' => [], ], 'GetPolicyRequest' => [ 'base' => '<p> The structure representing the <code>getPolicyRequest</code>. </p>', 'refs' => [], ], 'GetPolicyResponse' => [ 'base' => '<p>The structure representing the <code>getPolicyResponse</code>.</p>', 'refs' => [], ], 'GetProfileRequest' => [ 'base' => '<p>The structure representing the getProfileRequest.</p>', 'refs' => [], ], 'GetProfileResponse' => [ 'base' => '<p>The structure representing the getProfileResponse.</p>', 'refs' => [], ], 'GetRecommendationsRequest' => [ 'base' => '<p>The structure representing the GetRecommendationsRequest.</p>', 'refs' => [], ], 'GetRecommendationsResponse' => [ 'base' => '<p>The structure representing the GetRecommendationsResponse.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AgentConfiguration$periodInSeconds' => '<p> How long a profiling agent should send profiling data using <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html"> <code>ConfigureAgent</code> </a>. For example, if this is set to 300, the profiling agent calls <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ConfigureAgent.html"> <code>ConfigureAgent</code> </a> every 5 minutes to submit the profiled data collected during that period. </p>', 'FindingsReportSummary$totalNumberOfFindings' => '<p>The total number of different recommendations that were found by the analysis.</p>', 'Match$targetFramesIndex' => '<p>The target frame that triggered a match.</p>', 'Recommendation$allMatchesCount' => '<p>How many different places in the profile graph triggered a match.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The server encountered an internal error and is unable to complete the request.</p>', 'refs' => [], ], 'ListFindingsReportsRequest' => [ 'base' => '<p>The structure representing the ListFindingsReportsRequest.</p>', 'refs' => [], ], 'ListFindingsReportsResponse' => [ 'base' => '<p>The structure representing the ListFindingsReportsResponse.</p>', 'refs' => [], ], 'ListOfTimestamps' => [ 'base' => NULL, 'refs' => [ 'BatchGetFrameMetricDataResponse$endTimes' => '<p> List of instances, or time steps, in the time series. For example, if the <code>period</code> is one day (<code>PT24H)</code>), and the <code>resolution</code> is five minutes (<code>PT5M</code>), then there are 288 <code>endTimes</code> in the list that are each five minutes appart. </p>', 'UnprocessedEndTimeMap$value' => NULL, ], ], 'ListProfileTimesRequest' => [ 'base' => '<p>The structure representing the listProfileTimesRequest.</p>', 'refs' => [], ], 'ListProfileTimesResponse' => [ 'base' => '<p>The structure representing the listProfileTimesResponse.</p>', 'refs' => [], ], 'ListProfilingGroupsRequest' => [ 'base' => '<p>The structure representing the listProfilingGroupsRequest.</p>', 'refs' => [], ], 'ListProfilingGroupsResponse' => [ 'base' => '<p>The structure representing the listProfilingGroupsResponse.</p>', 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Locale' => [ 'base' => '<p>BCP47 language code. Supported locales: de-DE, en-GB, en-US, es-ES, fr-FR, it-IT, ja-JP, ko-KR, pt-BR, zh-CN, zh-TW</p>', 'refs' => [ 'GetRecommendationsRequest$locale' => '<p> The language used to provide analysis. Specify using a string that is one of the following <code>BCP 47</code> language codes. </p> <ul> <li> <p> <code>de-DE</code> - German, Germany </p> </li> <li> <p> <code>en-GB</code> - English, United Kingdom </p> </li> <li> <p> <code>en-US</code> - English, United States </p> </li> <li> <p> <code>es-ES</code> - Spanish, Spain </p> </li> <li> <p> <code>fr-FR</code> - French, France </p> </li> <li> <p> <code>it-IT</code> - Italian, Italy </p> </li> <li> <p> <code>ja-JP</code> - Japanese, Japan </p> </li> <li> <p> <code>ko-KR</code> - Korean, Republic of Korea </p> </li> <li> <p> <code>pt-BR</code> - Portugese, Brazil </p> </li> <li> <p> <code>zh-CN</code> - Chinese, China </p> </li> <li> <p> <code>zh-TW</code> - Chinese, Taiwan </p> </li> </ul>', ], ], 'Match' => [ 'base' => '<p>The part of a profile that contains a recommendation found during analysis.</p>', 'refs' => [ 'Matches$member' => NULL, ], ], 'Matches' => [ 'base' => NULL, 'refs' => [ 'Recommendation$topMatches' => '<p>List of the matches with most impact. </p>', ], ], 'MaxDepth' => [ 'base' => NULL, 'refs' => [ 'GetProfileRequest$maxDepth' => '<p> The maximum depth of the stacks in the code that is represented in the aggregated profile. For example, if CodeGuru Profiler finds a method <code>A</code>, which calls method <code>B</code>, which calls method <code>C</code>, which calls method <code>D</code>, then the depth is 4. If the <code>maxDepth</code> is set to 2, then the aggregated profile contains representations of methods <code>A</code> and <code>B</code>. </p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetFindingsReportAccountSummaryRequest$maxResults' => '<p>The maximum number of results returned by <code> GetFindingsReportAccountSummary</code> in paginated output. When this parameter is used, <code>GetFindingsReportAccountSummary</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>GetFindingsReportAccountSummary</code> request with the returned <code>nextToken</code> value.</p>', 'ListFindingsReportsRequest$maxResults' => '<p>The maximum number of report results returned by <code>ListFindingsReports</code> in paginated output. When this parameter is used, <code>ListFindingsReports</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListFindingsReports</code> request with the returned <code>nextToken</code> value.</p>', 'ListProfileTimesRequest$maxResults' => '<p>The maximum number of profile time results returned by <code>ListProfileTimes</code> in paginated output. When this parameter is used, <code>ListProfileTimes</code> only returns <code>maxResults</code> results in a single page with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListProfileTimes</code> request with the returned <code>nextToken</code> value. </p>', 'ListProfilingGroupsRequest$maxResults' => '<p>The maximum number of profiling groups results returned by <code>ListProfilingGroups</code> in paginated output. When this parameter is used, <code>ListProfilingGroups</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element. The remaining results of the initial request can be seen by sending another <code>ListProfilingGroups</code> request with the returned <code>nextToken</code> value. </p>', ], ], 'Metadata' => [ 'base' => NULL, 'refs' => [ 'ConfigureAgentRequest$metadata' => '<p> Metadata captured about the compute platform the agent is running on. It includes information about sampling and reporting. The valid fields are:</p> <ul> <li> <p> <code>COMPUTE_PLATFORM</code> - The compute platform on which the agent is running </p> </li> <li> <p> <code>AGENT_ID</code> - The ID for an agent instance. </p> </li> <li> <p> <code>AWS_REQUEST_ID</code> - The AWS request ID of a Lambda invocation. </p> </li> <li> <p> <code>EXECUTION_ENVIRONMENT</code> - The execution environment a Lambda function is running on. </p> </li> <li> <p> <code>LAMBDA_FUNCTION_ARN</code> - The Amazon Resource Name (ARN) that is used to invoke a Lambda function. </p> </li> <li> <p> <code>LAMBDA_MEMORY_LIMIT_IN_MB</code> - The memory allocated to a Lambda function. </p> </li> <li> <p> <code>LAMBDA_REMAINING_TIME_IN_MILLISECONDS</code> - The time in milliseconds before execution of a Lambda function times out. </p> </li> <li> <p> <code>LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS</code> - The time in milliseconds between two invocations of a Lambda function. </p> </li> <li> <p> <code>LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS</code> - The time in milliseconds for the previous Lambda invocation. </p> </li> </ul>', ], ], 'MetadataField' => [ 'base' => NULL, 'refs' => [ 'Metadata$key' => NULL, ], ], 'Metric' => [ 'base' => '<p> Details about the metric that the analysis used when it detected the anomaly. The metric what is analyzed to create recommendations. It includes the name of the frame that was analyzed and the type and thread states used to derive the metric value for that frame. </p>', 'refs' => [ 'Anomaly$metric' => '<p> Details about the metric that the analysis used when it detected the anomaly. The metric includes the name of the frame that was analyzed with the type and thread states used to derive the metric value for that frame. </p>', ], ], 'MetricType' => [ 'base' => NULL, 'refs' => [ 'FrameMetric$type' => '<p> A type of aggregation that specifies how a metric for a frame is analyzed. The supported value <code>AggregatedRelativeTotalTime</code> is an aggregation of the metric value for one frame that is calculated across the occurrences of all frames in a profile. </p>', 'Metric$type' => '<p> A type that specifies how a metric for a frame is analyzed. The supported value <code>AggregatedRelativeTotalTime</code> is an aggregation of the metric value for one frame that is calculated across the occurences of all frames in a profile.</p>', ], ], 'NotificationConfiguration' => [ 'base' => '<p>The configuration for notifications stored for each profiling group. This includes up to to two channels and a list of event publishers associated with each channel.</p>', 'refs' => [ 'AddNotificationChannelsResponse$notificationConfiguration' => '<p>The new notification configuration for this profiling group.</p>', 'GetNotificationConfigurationResponse$notificationConfiguration' => '<p>The current notification configuration for this profiling group.</p>', 'RemoveNotificationChannelResponse$notificationConfiguration' => '<p>The new notification configuration for this profiling group.</p>', ], ], 'OrderBy' => [ 'base' => NULL, 'refs' => [ 'ListProfileTimesRequest$orderBy' => '<p>The order (ascending or descending by start time of the profile) to use when listing profiles. Defaults to <code>TIMESTAMP_DESCENDING</code>. </p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'GetFindingsReportAccountSummaryRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>GetFindingsReportAccountSummary</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'GetFindingsReportAccountSummaryResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>GetFindingsReportAccountSummary</code> request. When the results of a <code>GetFindingsReportAccountSummary</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListFindingsReportsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListFindingsReportsRequest</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListFindingsReportsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListFindingsReports</code> request. When the results of a <code>ListFindingsReports</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListProfileTimesRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListProfileTimes</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListProfileTimesResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListProfileTimes</code> request. When the results of a <code>ListProfileTimes</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', 'ListProfilingGroupsRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>ListProfilingGroups</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. </p> <note> <p>This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and not for other programmatic purposes.</p> </note>', 'ListProfilingGroupsResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>ListProfilingGroups</code> request. When the results of a <code>ListProfilingGroups</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to return. </p>', ], ], 'Pattern' => [ 'base' => '<p> A set of rules used to make a recommendation during an analysis. </p>', 'refs' => [ 'Recommendation$pattern' => '<p>The pattern that analysis recognized in the profile to make this recommendation.</p>', ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'Pattern$thresholdPercent' => '<p> The percentage of time an application spends in one method that triggers a recommendation. The percentage of time is the same as the percentage of the total gathered sample counts during analysis. </p>', ], ], 'Period' => [ 'base' => NULL, 'refs' => [ 'BatchGetFrameMetricDataRequest$period' => '<p> The duration of the frame metrics used to return the time series values. Specify using the ISO 8601 format. The maximum period duration is one day (<code>PT24H</code> or <code>P1D</code>). </p>', 'GetProfileRequest$period' => '<p> Used with <code>startTime</code> or <code>endTime</code> to specify the time range for the returned aggregated profile. Specify using the ISO 8601 format. For example, <code>P1DT1H1M1S</code>. </p> <pre><code> &lt;p&gt; To get the latest aggregated profile, specify only &lt;code&gt;period&lt;/code&gt;. &lt;/p&gt; </code></pre>', ], ], 'PostAgentProfileRequest' => [ 'base' => '<p>The structure representing the postAgentProfileRequest.</p>', 'refs' => [], ], 'PostAgentProfileResponse' => [ 'base' => '<p>The structure representing the postAgentProfileResponse.</p>', 'refs' => [], ], 'Principal' => [ 'base' => NULL, 'refs' => [ 'Principals$member' => NULL, ], ], 'Principals' => [ 'base' => NULL, 'refs' => [ 'PutPermissionRequest$principals' => '<p> A list ARNs for the roles and users you want to grant access to the profiling group. Wildcards are not are supported in the ARNs. </p>', ], ], 'ProfileTime' => [ 'base' => '<p> Contains the start time of a profile. </p>', 'refs' => [ 'ProfileTimes$member' => NULL, ], ], 'ProfileTimes' => [ 'base' => NULL, 'refs' => [ 'ListProfileTimesResponse$profileTimes' => '<p>The list of start times of the available profiles for the aggregation period in the specified time range. </p>', ], ], 'ProfilingGroupArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p> The Amazon Resource Name (ARN) of the resource that contains the tags to return. </p>', 'ProfilingGroupDescription$arn' => '<p>The Amazon Resource Name (ARN) identifying the profiling group resource.</p>', 'TagResourceRequest$resourceArn' => '<p> The Amazon Resource Name (ARN) of the resource that the tags are added to. </p>', 'UntagResourceRequest$resourceArn' => '<p> The Amazon Resource Name (ARN) of the resource that contains the tags to remove. </p>', ], ], 'ProfilingGroupDescription' => [ 'base' => '<p> Contains information about a profiling group. </p>', 'refs' => [ 'CreateProfilingGroupResponse$profilingGroup' => '<p> The returned <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> object that contains information about the created profiling group. </p>', 'DescribeProfilingGroupResponse$profilingGroup' => '<p> The returned <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> object that contains information about the requested profiling group. </p>', 'ProfilingGroupDescriptions$member' => NULL, 'UpdateProfilingGroupResponse$profilingGroup' => '<p> A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> that contains information about the returned updated profiling group. </p>', ], ], 'ProfilingGroupDescriptions' => [ 'base' => NULL, 'refs' => [ 'ListProfilingGroupsResponse$profilingGroups' => '<p> A returned list <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> objects. A list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> objects is returned only if <code>includeDescription</code> is <code>true</code>, otherwise a list of profiling group names is returned. </p>', ], ], 'ProfilingGroupName' => [ 'base' => NULL, 'refs' => [ 'AddNotificationChannelsRequest$profilingGroupName' => '<p>The name of the profiling group that we are setting up notifications for.</p>', 'BatchGetFrameMetricDataRequest$profilingGroupName' => '<p> The name of the profiling group associated with the the frame metrics used to return the time series values. </p>', 'ConfigureAgentRequest$profilingGroupName' => '<p> The name of the profiling group for which the configured agent is collecting profiling data. </p>', 'CreateProfilingGroupRequest$profilingGroupName' => '<p>The name of the profiling group to create.</p>', 'DeleteProfilingGroupRequest$profilingGroupName' => '<p>The name of the profiling group to delete.</p>', 'DescribeProfilingGroupRequest$profilingGroupName' => '<p> The name of the profiling group to get information about. </p>', 'GetNotificationConfigurationRequest$profilingGroupName' => '<p>The name of the profiling group we want to get the notification configuration for.</p>', 'GetPolicyRequest$profilingGroupName' => '<p>The name of the profiling group.</p>', 'GetProfileRequest$profilingGroupName' => '<p>The name of the profiling group to get.</p>', 'GetRecommendationsRequest$profilingGroupName' => '<p> The name of the profiling group to get analysis data about. </p>', 'GetRecommendationsResponse$profilingGroupName' => '<p>The name of the profiling group the analysis data is about.</p>', 'ListFindingsReportsRequest$profilingGroupName' => '<p>The name of the profiling group from which to search for analysis data.</p>', 'ListProfileTimesRequest$profilingGroupName' => '<p>The name of the profiling group.</p>', 'PostAgentProfileRequest$profilingGroupName' => '<p> The name of the profiling group with the aggregated profile that receives the submitted profiling data. </p>', 'ProfilingGroupDescription$name' => '<p>The name of the profiling group.</p>', 'ProfilingGroupNames$member' => NULL, 'PutPermissionRequest$profilingGroupName' => '<p>The name of the profiling group to grant access to.</p>', 'RemoveNotificationChannelRequest$profilingGroupName' => '<p>The name of the profiling group we want to change notification configuration for.</p>', 'RemovePermissionRequest$profilingGroupName' => '<p>The name of the profiling group.</p>', 'SubmitFeedbackRequest$profilingGroupName' => '<p>The name of the profiling group that is associated with the analysis data.</p>', 'UpdateProfilingGroupRequest$profilingGroupName' => '<p>The name of the profiling group to update.</p>', ], ], 'ProfilingGroupNames' => [ 'base' => NULL, 'refs' => [ 'ListProfilingGroupsResponse$profilingGroupNames' => '<p> A returned list of profiling group names. A list of the names is returned only if <code>includeDescription</code> is <code>false</code>, otherwise a list of <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingGroupDescription.html"> <code>ProfilingGroupDescription</code> </a> objects is returned. </p>', ], ], 'ProfilingStatus' => [ 'base' => '<p> Profiling status includes information about the last time a profile agent pinged back, the last time a profile was received, and the aggregation period and start time for the most recent aggregated profile. </p>', 'refs' => [ 'ProfilingGroupDescription$profilingStatus' => '<p> A <a href="https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_ProfilingStatus.html"> <code>ProfilingStatus</code> </a> object that includes information about the last time a profile agent pinged back, the last time a profile was received, and the aggregation period and start time for the most recent aggregated profile. </p>', ], ], 'PutPermissionRequest' => [ 'base' => '<p>The structure representing the <code>putPermissionRequest</code>.</p>', 'refs' => [], ], 'PutPermissionResponse' => [ 'base' => '<p>The structure representing the <code>putPermissionResponse</code>.</p>', 'refs' => [], ], 'Recommendation' => [ 'base' => '<p>A potential improvement that was found from analyzing the profiling data.</p>', 'refs' => [ 'Recommendations$member' => NULL, ], ], 'Recommendations' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationsResponse$recommendations' => '<p>The list of recommendations that the analysis found for this profile.</p>', ], ], 'RemoveNotificationChannelRequest' => [ 'base' => '<p>The structure representing the RemoveNotificationChannelRequest.</p>', 'refs' => [], ], 'RemoveNotificationChannelResponse' => [ 'base' => '<p>The structure representing the RemoveNotificationChannelResponse.</p>', 'refs' => [], ], 'RemovePermissionRequest' => [ 'base' => '<p> <pre><code> The structure representing the &lt;code&gt;removePermissionRequest&lt;/code&gt;.&lt;/p&gt; </code></pre>', 'refs' => [], ], 'RemovePermissionResponse' => [ 'base' => '<p>The structure representing the <code>removePermissionResponse</code>.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource specified in the request does not exist.</p>', 'refs' => [], ], 'RevisionId' => [ 'base' => NULL, 'refs' => [ 'GetPolicyResponse$revisionId' => '<p>A unique identifier for the current revision of the returned policy.</p>', 'PutPermissionRequest$revisionId' => '<p> A universally unique identifier (UUID) for the revision of the policy you are adding to the profiling group. Do not specify this when you add permissions to a profiling group for the first time. If a policy already exists on the profiling group, you must specify the <code>revisionId</code>. </p>', 'PutPermissionResponse$revisionId' => '<p> A universally unique identifier (UUID) for the revision of the resource-based policy that includes the added permissions. The JSON-formatted policy is in the <code>policy</code> element of the response. </p>', 'RemovePermissionRequest$revisionId' => '<p> A universally unique identifier (UUID) for the revision of the resource-based policy from which you want to remove permissions. </p>', 'RemovePermissionResponse$revisionId' => '<p> A universally unique identifier (UUID) for the revision of the resource-based policy after the specified permissions were removed. The updated JSON-formatted policy is in the <code>policy</code> element of the response. </p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/intro.html">Service Quotas</a> to request a service quota increase. </p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AgentParameters$value' => NULL, 'Anomaly$reason' => '<p>The reason for which metric was flagged as anomalous.</p>', 'AnomalyInstance$id' => '<p> The universally unique identifier (UUID) of an instance of an anomaly in a metric. </p>', 'ConflictException$message' => NULL, 'FindingsReportSummary$profilingGroupName' => '<p>The name of the profiling group that is associated with the analysis data.</p>', 'FrameMetric$frameName' => '<p> Name of the method common across the multiple occurrences of a frame in an application profile.</p>', 'GetPolicyResponse$policy' => '<p>The JSON-formatted resource-based policy attached to the <code>ProfilingGroup</code>.</p>', 'GetProfileRequest$accept' => '<p> The format of the returned profiling data. The format maps to the <code>Accept</code> and <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the default . </p> <pre><code> &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/json&lt;/code&gt; — standard JSON format &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/x-amzn-ion&lt;/code&gt; — the Amazon Ion data format. For more information, see &lt;a href=&quot;http://amzn.github.io/ion-docs/&quot;&gt;Amazon Ion&lt;/a&gt;. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code></pre>', 'GetProfileResponse$contentEncoding' => '<p>The content encoding of the profile.</p>', 'GetProfileResponse$contentType' => '<p>The content type of the profile in the payload. It is either <code>application/json</code> or the default <code>application/x-amzn-ion</code>.</p>', 'InternalServerException$message' => NULL, 'Match$frameAddress' => '<p>The location in the profiling graph that contains a recommendation found during analysis.</p>', 'Metadata$value' => NULL, 'Metric$frameName' => '<p> The name of the method that appears as a frame in any stack in a profile. </p>', 'Pattern$description' => '<p>The description of the recommendation. This explains a potential inefficiency in a profiled application.</p>', 'Pattern$id' => '<p>The universally unique identifier (UUID) of this pattern.</p>', 'Pattern$name' => '<p>The name for this pattern.</p>', 'Pattern$resolutionSteps' => '<p> A string that contains the steps recommended to address the potential inefficiency. </p>', 'PostAgentProfileRequest$contentType' => '<p> The format of the submitted profiling data. The format maps to the <code>Accept</code> and <code>Content-Type</code> headers of the HTTP request. You can specify one of the following: or the default . </p> <pre><code> &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/json&lt;/code&gt; — standard JSON format &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;application/x-amzn-ion&lt;/code&gt; — the Amazon Ion data format. For more information, see &lt;a href=&quot;http://amzn.github.io/ion-docs/&quot;&gt;Amazon Ion&lt;/a&gt;. &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; </code></pre>', 'PutPermissionResponse$policy' => '<p> The JSON-formatted resource-based policy on the profiling group that includes the added permissions. </p>', 'RemovePermissionResponse$policy' => '<p> The JSON-formatted resource-based policy on the profiling group after the specified permissions were removed. </p>', 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'Strings$member' => NULL, 'SubmitFeedbackRequest$comment' => '<p>Optional feedback about this anomaly.</p>', 'TagKeys$member' => NULL, 'TagsMap$key' => NULL, 'TagsMap$value' => NULL, 'TargetFrame$member' => NULL, 'ThreadStates$member' => NULL, 'ThrottlingException$message' => NULL, 'UnprocessedEndTimeMap$key' => NULL, 'ValidationException$message' => NULL, ], ], 'Strings' => [ 'base' => NULL, 'refs' => [ 'Metric$threadStates' => '<p> The list of application runtime thread states that is used to calculate the metric value for the frame. </p>', 'Pattern$countersToAggregate' => '<p> A list of the different counters used to determine if there is a match. </p>', ], ], 'SubmitFeedbackRequest' => [ 'base' => '<p>The structure representing the SubmitFeedbackRequest.</p>', 'refs' => [], ], 'SubmitFeedbackResponse' => [ 'base' => '<p>The structure representing the SubmitFeedbackResponse.</p>', 'refs' => [], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p> A list of tag keys. Existing tags of resources with keys in this list are removed from the specified resource. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagsMap' => [ 'base' => NULL, 'refs' => [ 'CreateProfilingGroupRequest$tags' => '<p> A list of tags to add to the created profiling group. </p>', 'ListTagsForResourceResponse$tags' => '<p> The list of tags assigned to the specified resource. This is the list of tags returned in the response. </p>', 'ProfilingGroupDescription$tags' => '<p> A list of the tags that belong to this profiling group. </p>', 'TagResourceRequest$tags' => '<p> The list of tags that are added to the specified resource. </p>', ], ], 'TargetFrame' => [ 'base' => NULL, 'refs' => [ 'TargetFrames$member' => NULL, ], ], 'TargetFrames' => [ 'base' => NULL, 'refs' => [ 'Pattern$targetFrames' => '<p>A list of frame names that were searched during the analysis that generated a recommendation.</p>', ], ], 'ThreadStates' => [ 'base' => NULL, 'refs' => [ 'FrameMetric$threadStates' => '<p>List of application runtime thread states used to get the counts for a frame a derive a metric value.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AggregatedProfileTime$start' => '<p> The time that aggregation of posted agent profiles for a profiling group starts. The aggregation profile contains profiles posted by the agent starting at this time for an aggregation period specified by the <code>period</code> property of the <code>AggregatedProfileTime</code> object. </p> <p> Specify <code>start</code> using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'AnomalyInstance$endTime' => '<p> The end time of the period during which the metric is flagged as anomalous. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'AnomalyInstance$startTime' => '<p> The start time of the period during which the metric is flagged as anomalous. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'BatchGetFrameMetricDataRequest$endTime' => '<p> The end time of the time period for the returned time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'BatchGetFrameMetricDataRequest$startTime' => '<p> The start time of the time period for the frame metrics used to return the time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'BatchGetFrameMetricDataResponse$endTime' => '<p> The end time of the time period for the returned time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'BatchGetFrameMetricDataResponse$startTime' => '<p> The start time of the time period for the returned time series values. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'FindingsReportSummary$profileEndTime' => '<p> The end time of the period during which the metric is flagged as anomalous. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'FindingsReportSummary$profileStartTime' => '<p>The start time of the profile the analysis data is about. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>', 'GetProfileRequest$endTime' => '<p> The end time of the requested profile. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p> <p> If you specify <code>endTime</code>, then you must also specify <code>period</code> or <code>startTime</code>, but not both. </p>', 'GetProfileRequest$startTime' => '<p>The start time of the profile to get. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p> <pre><code> &lt;p&gt; If you specify &lt;code&gt;startTime&lt;/code&gt;, then you must also specify &lt;code&gt;period&lt;/code&gt; or &lt;code&gt;endTime&lt;/code&gt;, but not both. &lt;/p&gt; </code></pre>', 'GetRecommendationsRequest$endTime' => '<p> The start time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'GetRecommendationsRequest$startTime' => '<p> The end time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'GetRecommendationsResponse$profileEndTime' => '<p> The end time of the profile the analysis data is about. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'GetRecommendationsResponse$profileStartTime' => '<p> The start time of the profile the analysis data is about. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'ListFindingsReportsRequest$endTime' => '<p> The end time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'ListFindingsReportsRequest$startTime' => '<p> The start time of the profile to get analysis data about. You must specify <code>startTime</code> and <code>endTime</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'ListProfileTimesRequest$endTime' => '<p>The end time of the time range from which to list the profiles.</p>', 'ListProfileTimesRequest$startTime' => '<p>The start time of the time range from which to list the profiles.</p>', 'ProfileTime$start' => '<p>The start time of a profile. It is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>', 'ProfilingGroupDescription$createdAt' => '<p>The time when the profiling group was created. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'ProfilingGroupDescription$updatedAt' => '<p> The date and time when the profiling group was last updated. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'ProfilingStatus$latestAgentOrchestratedAt' => '<p>The date and time when the profiling agent most recently pinged back. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>', 'ProfilingStatus$latestAgentProfileReportedAt' => '<p>The date and time when the most recent profile was received. Specify using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>', 'Recommendation$endTime' => '<p>End time of the profile that was used by this analysis. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>', 'Recommendation$startTime' => '<p>The start time of the profile that was used by this analysis. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC.</p>', 'TimestampStructure$value' => '<p> A <code>Timestamp</code>. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', ], ], 'TimestampStructure' => [ 'base' => '<p> A data type that contains a <code>Timestamp</code> object. This is specified using the ISO 8601 format. For example, 2020-06-01T13:15:02.001Z represents 1 millisecond past June 1, 2020 1:15:02 PM UTC. </p>', 'refs' => [ 'ListOfTimestamps$member' => NULL, ], ], 'UnprocessedEndTimeMap' => [ 'base' => NULL, 'refs' => [ 'BatchGetFrameMetricDataResponse$unprocessedEndTimes' => '<p>List of instances which remained unprocessed. This will create a missing time step in the list of end times.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProfilingGroupRequest' => [ 'base' => '<p>The structure representing the updateProfilingGroupRequest.</p>', 'refs' => [], ], 'UpdateProfilingGroupResponse' => [ 'base' => '<p>The structure representing the updateProfilingGroupResponse.</p>', 'refs' => [], ], 'UserFeedback' => [ 'base' => '<p>Feedback that can be submitted for each instance of an anomaly by the user. Feedback is be used for improvements in generating recommendations for the application.</p>', 'refs' => [ 'AnomalyInstance$userFeedback' => '<p>Feedback type on a specific instance of anomaly submitted by the user.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The parameter is not valid.</p>', 'refs' => [], ], ],];
