<?php
// This file was auto-generated from sdk-root/src/data/compute-optimizer/2019-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Compute Optimizer is a service that analyzes the configuration and utilization metrics of your Amazon Web Services compute resources, such as Amazon EC2 instances, Amazon EC2 Auto Scaling groups, Lambda functions, Amazon EBS volumes, and Amazon ECS services on Fargate. It reports whether your resources are optimal, and generates optimization recommendations to reduce the cost and improve the performance of your workloads. Compute Optimizer also provides recent utilization metric data, in addition to projected utilization metric data for the recommendations, which you can use to evaluate which recommendation provides the best price-performance trade-off. The analysis of your usage patterns can help you decide when to move or resize your running resources, and still meet your performance and capacity requirements. For more information about Compute Optimizer, including the required permissions to use the service, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/">Compute Optimizer User Guide</a>.</p>', 'operations' => [ 'DeleteRecommendationPreferences' => '<p>Deletes a recommendation preference, such as enhanced infrastructure metrics.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'DescribeRecommendationExportJobs' => '<p>Describes recommendation export jobs created in the last seven days.</p> <p>Use the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions to request an export of your recommendations. Then use the <a>DescribeRecommendationExportJobs</a> action to view your export jobs.</p>', 'ExportAutoScalingGroupRecommendations' => '<p>Exports optimization recommendations for Auto Scaling groups.</p> <p>Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting Recommendations</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>You can have only one Auto Scaling group export job in progress per Amazon Web Services Region.</p>', 'ExportEBSVolumeRecommendations' => '<p>Exports optimization recommendations for Amazon EBS volumes.</p> <p>Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting Recommendations</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>You can have only one Amazon EBS volume export job in progress per Amazon Web Services Region.</p>', 'ExportEC2InstanceRecommendations' => '<p>Exports optimization recommendations for Amazon EC2 instances.</p> <p>Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting Recommendations</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>You can have only one Amazon EC2 instance export job in progress per Amazon Web Services Region.</p>', 'ExportECSServiceRecommendations' => '<p> Exports optimization recommendations for Amazon ECS services on Fargate. </p> <p>Recommendations are exported in a CSV file, and its metadata in a JSON file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting Recommendations</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>You can only have one Amazon ECS service export job in progress per Amazon Web Services Region.</p>', 'ExportLambdaFunctionRecommendations' => '<p>Exports optimization recommendations for Lambda functions.</p> <p>Recommendations are exported in a comma-separated values (.csv) file, and its metadata in a JavaScript Object Notation (JSON) (.json) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting Recommendations</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>You can have only one Lambda function export job in progress per Amazon Web Services Region.</p>', 'ExportLicenseRecommendations' => '<p> Export optimization recommendations for your licenses. </p> <p>Recommendations are exported in a comma-separated values (CSV) file, and its metadata in a JavaScript Object Notation (JSON) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting Recommendations</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>You can have only one license export job in progress per Amazon Web Services Region.</p>', 'ExportRDSDatabaseRecommendations' => '<p> Export optimization recommendations for your Amazon Relational Database Service (Amazon RDS). </p> <p>Recommendations are exported in a comma-separated values (CSV) file, and its metadata in a JavaScript Object Notation (JSON) file, to an existing Amazon Simple Storage Service (Amazon S3) bucket that you specify. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html">Exporting Recommendations</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>You can have only one Amazon RDS export job in progress per Amazon Web Services Region.</p>', 'GetAutoScalingGroupRecommendations' => '<p>Returns Auto Scaling group recommendations.</p> <p>Compute Optimizer generates recommendations for Amazon EC2 Auto Scaling groups that meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetEBSVolumeRecommendations' => '<p>Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.</p> <p>Compute Optimizer generates recommendations for Amazon EBS volumes that meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetEC2InstanceRecommendations' => '<p>Returns Amazon EC2 instance recommendations.</p> <p>Compute Optimizer generates recommendations for Amazon Elastic Compute Cloud (Amazon EC2) instances that meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetEC2RecommendationProjectedMetrics' => '<p>Returns the projected utilization metrics of Amazon EC2 instance recommendations.</p> <note> <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected utilization metrics returned when you run this action. Additionally, the <code>Memory</code> metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note>', 'GetECSServiceRecommendationProjectedMetrics' => '<p> Returns the projected metrics of Amazon ECS service recommendations. </p>', 'GetECSServiceRecommendations' => '<p> Returns Amazon ECS service recommendations. </p> <p> Compute Optimizer generates recommendations for Amazon ECS services on Fargate that meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>. </p>', 'GetEffectiveRecommendationPreferences' => '<p>Returns the recommendation preferences that are in effect for a given resource, such as enhanced infrastructure metrics. Considers all applicable preferences that you might have set at the resource, account, and organization level.</p> <p>When you create a recommendation preference, you can set its status to <code>Active</code> or <code>Inactive</code>. Use this action to view the recommendation preferences that are in effect, or <code>Active</code>.</p>', 'GetEnrollmentStatus' => '<p>Returns the enrollment (opt in) status of an account to the Compute Optimizer service.</p> <p>If the account is the management account of an organization, this action also confirms the enrollment status of member accounts of the organization. Use the <a>GetEnrollmentStatusesForOrganization</a> action to get detailed information about the enrollment status of member accounts of an organization.</p>', 'GetEnrollmentStatusesForOrganization' => '<p>Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an organization management account.</p> <p>To get the enrollment status of standalone accounts, use the <a>GetEnrollmentStatus</a> action.</p>', 'GetLambdaFunctionRecommendations' => '<p>Returns Lambda function recommendations.</p> <p>Compute Optimizer generates recommendations for functions that meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetLicenseRecommendations' => '<p>Returns license recommendations for Amazon EC2 instances that run on a specific license.</p> <p>Compute Optimizer generates recommendations for licenses that meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetRDSDatabaseRecommendationProjectedMetrics' => '<p> Returns the projected metrics of Amazon RDS recommendations. </p>', 'GetRDSDatabaseRecommendations' => '<p> Returns Amazon RDS recommendations. </p> <p>Compute Optimizer generates recommendations for Amazon RDS that meet a specific set of requirements. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetRecommendationPreferences' => '<p>Returns existing recommendation preferences, such as enhanced infrastructure metrics.</p> <p>Use the <code>scope</code> parameter to specify which preferences to return. You can specify to return preferences for an organization, a specific account ID, or a specific EC2 instance or Auto Scaling group Amazon Resource Name (ARN).</p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetRecommendationSummaries' => '<p>Returns the optimization findings for an account.</p> <p>It returns the number of:</p> <ul> <li> <p>Amazon EC2 instances in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or <code>Optimized</code>.</p> </li> <li> <p>Auto Scaling groups in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.</p> </li> <li> <p>Amazon EBS volumes in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.</p> </li> <li> <p>Lambda functions in an account that are <code>NotOptimized</code>, or <code>Optimized</code>.</p> </li> <li> <p>Amazon ECS services in an account that are <code>Underprovisioned</code>, <code>Overprovisioned</code>, or <code>Optimized</code>.</p> </li> </ul>', 'PutRecommendationPreferences' => '<p>Creates a new recommendation preference or updates an existing recommendation preference, such as enhanced infrastructure metrics.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'UpdateEnrollmentStatus' => '<p>Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.</p> <p>If the account is a management account of an organization, this action can also be used to enroll member accounts of the organization.</p> <p>You must have the appropriate permissions to opt in to Compute Optimizer, to view its recommendations, and to opt out. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html">Controlling access with Amazon Web Services Identity and Access Management</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>When you opt in, Compute Optimizer automatically creates a service-linked role in your account to access its data. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/using-service-linked-roles.html">Using Service-Linked Roles for Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccountEnrollmentStatus' => [ 'base' => '<p>Describes the enrollment status of an organization\'s member accounts in Compute Optimizer.</p>', 'refs' => [ 'AccountEnrollmentStatuses$member' => NULL, ], ], 'AccountEnrollmentStatuses' => [ 'base' => NULL, 'refs' => [ 'GetEnrollmentStatusesForOrganizationResponse$accountEnrollmentStatuses' => '<p>An array of objects that describe the enrollment statuses of organization member accounts.</p>', ], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'AccountEnrollmentStatus$accountId' => '<p>The Amazon Web Services account ID.</p>', 'AccountIds$member' => NULL, 'AutoScalingGroupRecommendation$accountId' => '<p>The Amazon Web Services account ID of the Auto Scaling group.</p>', 'ECSServiceRecommendation$accountId' => '<p> The Amazon Web Services account ID of the Amazon ECS service. </p>', 'InstanceRecommendation$accountId' => '<p>The Amazon Web Services account ID of the instance.</p>', 'LambdaFunctionRecommendation$accountId' => '<p>The Amazon Web Services account ID of the function.</p>', 'LicenseRecommendation$accountId' => '<p> The Amazon Web Services account ID of the license. </p>', 'RDSDBRecommendation$accountId' => '<p> The Amazon Web Services account ID of the Amazon RDS. </p>', 'RecommendationSummary$accountId' => '<p>The Amazon Web Services account ID of the recommendation summary.</p>', 'VolumeRecommendation$accountId' => '<p>The Amazon Web Services account ID of the volume.</p>', ], ], 'AccountIds' => [ 'base' => NULL, 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$accountIds' => '<p>The IDs of the Amazon Web Services accounts for which to export Auto Scaling group recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to export recommendations.</p> <p>This parameter cannot be specified together with the include member accounts parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the include member accounts parameter, is omitted.</p> <p>You can specify multiple account IDs per request.</p>', 'ExportEBSVolumeRecommendationsRequest$accountIds' => '<p>The IDs of the Amazon Web Services accounts for which to export Amazon EBS volume recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to export recommendations.</p> <p>This parameter cannot be specified together with the include member accounts parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the include member accounts parameter, is omitted.</p> <p>You can specify multiple account IDs per request.</p>', 'ExportEC2InstanceRecommendationsRequest$accountIds' => '<p>The IDs of the Amazon Web Services accounts for which to export instance recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to export recommendations.</p> <p>This parameter cannot be specified together with the include member accounts parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the include member accounts parameter, is omitted.</p> <p>You can specify multiple account IDs per request.</p>', 'ExportECSServiceRecommendationsRequest$accountIds' => '<p> The Amazon Web Services account IDs for the export Amazon ECS service recommendations. </p> <p>If your account is the management account or the delegated administrator of an organization, use this parameter to specify the member account you want to export recommendations to.</p> <p>This parameter can\'t be specified together with the include member accounts parameter. The parameters are mutually exclusive.</p> <p>If this parameter or the include member accounts parameter is omitted, the recommendations for member accounts aren\'t included in the export.</p> <p>You can specify multiple account IDs per request.</p>', 'ExportLambdaFunctionRecommendationsRequest$accountIds' => '<p>The IDs of the Amazon Web Services accounts for which to export Lambda function recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to export recommendations.</p> <p>This parameter cannot be specified together with the include member accounts parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the include member accounts parameter, is omitted.</p> <p>You can specify multiple account IDs per request.</p>', 'ExportLicenseRecommendationsRequest$accountIds' => '<p>The IDs of the Amazon Web Services accounts for which to export license recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to export recommendations.</p> <p>This parameter can\'t be specified together with the include member accounts parameter. The parameters are mutually exclusive.</p> <p>If this parameter is omitted, recommendations for member accounts aren\'t included in the export.</p> <p>You can specify multiple account IDs per request.</p>', 'ExportRDSDatabaseRecommendationsRequest$accountIds' => '<p> The Amazon Web Services account IDs for the export Amazon RDS recommendations. </p> <p>If your account is the management account or the delegated administrator of an organization, use this parameter to specify the member account you want to export recommendations to.</p> <p>This parameter can\'t be specified together with the include member accounts parameter. The parameters are mutually exclusive.</p> <p>If this parameter or the include member accounts parameter is omitted, the recommendations for member accounts aren\'t included in the export.</p> <p>You can specify multiple account IDs per request.</p>', 'GetAutoScalingGroupRecommendationsRequest$accountIds' => '<p>The ID of the Amazon Web Services account for which to return Auto Scaling group recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to return Auto Scaling group recommendations.</p> <p>Only one account ID can be specified per request.</p>', 'GetEBSVolumeRecommendationsRequest$accountIds' => '<p>The ID of the Amazon Web Services account for which to return volume recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to return volume recommendations.</p> <p>Only one account ID can be specified per request.</p>', 'GetEC2InstanceRecommendationsRequest$accountIds' => '<p>The ID of the Amazon Web Services account for which to return instance recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to return instance recommendations.</p> <p>Only one account ID can be specified per request.</p>', 'GetECSServiceRecommendationsRequest$accountIds' => '<p> Return the Amazon ECS service recommendations to the specified Amazon Web Services account IDs. </p> <p>If your account is the management account or the delegated administrator of an organization, use this parameter to return the Amazon ECS service recommendations to specific member accounts.</p> <p>You can only specify one account ID per request.</p>', 'GetLambdaFunctionRecommendationsRequest$accountIds' => '<p>The ID of the Amazon Web Services account for which to return function recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to return function recommendations.</p> <p>Only one account ID can be specified per request.</p>', 'GetLicenseRecommendationsRequest$accountIds' => '<p>The ID of the Amazon Web Services account for which to return license recommendations.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to return license recommendations.</p> <p>Only one account ID can be specified per request.</p>', 'GetRDSDatabaseRecommendationsRequest$accountIds' => '<p> Return the Amazon RDS recommendations to the specified Amazon Web Services account IDs. </p> <p>If your account is the management account or the delegated administrator of an organization, use this parameter to return the Amazon RDS recommendations to specific member accounts.</p> <p>You can only specify one account ID per request.</p>', 'GetRecommendationSummariesRequest$accountIds' => '<p>The ID of the Amazon Web Services account for which to return recommendation summaries.</p> <p>If your account is the management account of an organization, use this parameter to specify the member account for which you want to return recommendation summaries.</p> <p>Only one account ID can be specified per request.</p>', ], ], 'AllocatedStorage' => [ 'base' => NULL, 'refs' => [ 'DBStorageConfiguration$allocatedStorage' => '<p> The size of the RDS storage in gigabytes (GB). </p>', ], ], 'AutoScalingConfiguration' => [ 'base' => NULL, 'refs' => [ 'ServiceConfiguration$autoScalingConfiguration' => '<p> Describes the Auto Scaling configuration methods for an Amazon ECS service. This affects the generated recommendations. For example, if Auto Scaling is configured on a service’s CPU, then Compute Optimizer doesn’t generate CPU size recommendations. </p> <p>The Auto Scaling configuration methods include:</p> <ul> <li> <p> <code>TARGET_TRACKING_SCALING_CPU</code> — If the Amazon ECS service is configured to use target scaling on CPU, Compute Optimizer doesn\'t generate CPU recommendations.</p> </li> <li> <p> <code>TARGET_TRACKING_SCALING_MEMORY</code> — If the Amazon ECS service is configured to use target scaling on memory, Compute Optimizer doesn\'t generate memory recommendations.</p> </li> </ul> <p>For more information about step scaling and target scaling, see <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html"> Step scaling policies for Application Auto Scaling</a> and <a href="https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html"> Target tracking scaling policies for Application Auto Scaling</a> in the <i>Application Auto Scaling User Guide</i>.</p>', ], ], 'AutoScalingGroupArn' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupArns$member' => NULL, 'AutoScalingGroupRecommendation$autoScalingGroupArn' => '<p>The Amazon Resource Name (ARN) of the Auto Scaling group.</p>', ], ], 'AutoScalingGroupArns' => [ 'base' => NULL, 'refs' => [ 'GetAutoScalingGroupRecommendationsRequest$autoScalingGroupArns' => '<p>The Amazon Resource Name (ARN) of the Auto Scaling groups for which to return recommendations.</p>', ], ], 'AutoScalingGroupConfiguration' => [ 'base' => '<p>Describes the configuration of an Auto Scaling group.</p>', 'refs' => [ 'AutoScalingGroupRecommendation$currentConfiguration' => '<p>An array of objects that describe the current configuration of the Auto Scaling group.</p>', 'AutoScalingGroupRecommendationOption$configuration' => '<p>An array of objects that describe an Auto Scaling group configuration.</p>', ], ], 'AutoScalingGroupEstimatedMonthlySavings' => [ 'base' => '<p> An object that describes the estimated monthly savings possible by adopting Compute Optimizer’s Auto Scaling group recommendations. This is based on the Savings Plans and Reserved Instances discounts. </p>', 'refs' => [ 'AutoScalingGroupSavingsOpportunityAfterDiscounts$estimatedMonthlySavings' => '<p> An object that describes the estimated monthly savings possible by adopting Compute Optimizer’s Auto Scaling group recommendations. This is based on the Savings Plans and Reserved Instances pricing discounts. </p>', ], ], 'AutoScalingGroupName' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$autoScalingGroupName' => '<p>The name of the Auto Scaling group.</p>', ], ], 'AutoScalingGroupRecommendation' => [ 'base' => '<p>Describes an Auto Scaling group recommendation.</p>', 'refs' => [ 'AutoScalingGroupRecommendations$member' => NULL, ], ], 'AutoScalingGroupRecommendationOption' => [ 'base' => '<p>Describes a recommendation option for an Auto Scaling group.</p>', 'refs' => [ 'AutoScalingGroupRecommendationOptions$member' => NULL, ], ], 'AutoScalingGroupRecommendationOptions' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$recommendationOptions' => '<p>An array of objects that describe the recommendation options for the Auto Scaling group.</p>', ], ], 'AutoScalingGroupRecommendations' => [ 'base' => NULL, 'refs' => [ 'GetAutoScalingGroupRecommendationsResponse$autoScalingGroupRecommendations' => '<p>An array of objects that describe Auto Scaling group recommendations.</p>', ], ], 'AutoScalingGroupSavingsOpportunityAfterDiscounts' => [ 'base' => '<p> Describes the savings opportunity for Auto Scaling group recommendations after applying the Savings Plans and Reserved Instances discounts. </p> <p>Savings opportunity represents the estimated monthly savings you can achieve by implementing Compute Optimizer recommendations.</p>', 'refs' => [ 'AutoScalingGroupRecommendationOption$savingsOpportunityAfterDiscounts' => '<p> An object that describes the savings opportunity for the Auto Scaling group recommendation option that includes Savings Plans and Reserved Instances discounts. Savings opportunity includes the estimated monthly savings and percentage. </p>', ], ], 'Code' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationError$code' => '<p>The error code.</p>', ], ], 'ContainerConfiguration' => [ 'base' => '<p> Describes the container configurations within the tasks of your Amazon ECS service. </p>', 'refs' => [ 'ContainerConfigurations$member' => NULL, ], ], 'ContainerConfigurations' => [ 'base' => NULL, 'refs' => [ 'ServiceConfiguration$containerConfigurations' => '<p> The container configurations within a task of an Amazon ECS service. </p>', ], ], 'ContainerName' => [ 'base' => NULL, 'refs' => [ 'ContainerConfiguration$containerName' => '<p> The name of the container. </p>', 'ContainerRecommendation$containerName' => '<p> The name of the container. </p>', ], ], 'ContainerRecommendation' => [ 'base' => '<p> The CPU and memory recommendations for a container within the tasks of your Amazon ECS service. </p>', 'refs' => [ 'ContainerRecommendations$member' => NULL, ], ], 'ContainerRecommendations' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendationOption$containerRecommendations' => '<p> The CPU and memory size recommendations for the containers within the task of your Amazon ECS service. </p>', ], ], 'CpuSize' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendedOptionProjectedMetric$recommendedCpuUnits' => '<p> The recommended CPU size for the Amazon ECS service. </p>', ], ], 'CpuVendorArchitecture' => [ 'base' => NULL, 'refs' => [ 'CpuVendorArchitectures$member' => NULL, ], ], 'CpuVendorArchitectures' => [ 'base' => NULL, 'refs' => [ 'EffectiveRecommendationPreferences$cpuVendorArchitectures' => '<p>Describes the CPU vendor and architecture for an instance or Auto Scaling group recommendations.</p> <p>For example, when you specify <code>AWS_ARM64</code> with:</p> <ul> <li> <p>A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute Optimizer returns recommendations that consist of Graviton instance types only.</p> </li> <li> <p>A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization metrics for Graviton instance type recommendations only.</p> </li> <li> <p>A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute Optimizer exports recommendations that consist of Graviton instance types only.</p> </li> </ul>', 'RDSEffectiveRecommendationPreferences$cpuVendorArchitectures' => '<p> Describes the CPU vendor and architecture for Amazon RDS recommendations. </p>', 'RecommendationPreferences$cpuVendorArchitectures' => '<p>Specifies the CPU vendor and architecture for Amazon EC2 instance and Auto Scaling group recommendations.</p> <p>For example, when you specify <code>AWS_ARM64</code> with:</p> <ul> <li> <p>A <a>GetEC2InstanceRecommendations</a> or <a>GetAutoScalingGroupRecommendations</a> request, Compute Optimizer returns recommendations that consist of Graviton instance types only.</p> </li> <li> <p>A <a>GetEC2RecommendationProjectedMetrics</a> request, Compute Optimizer returns projected utilization metrics for Graviton instance type recommendations only.</p> </li> <li> <p>A <a>ExportEC2InstanceRecommendations</a> or <a>ExportAutoScalingGroupRecommendations</a> request, Compute Optimizer exports recommendations that consist of Graviton instance types only.</p> </li> </ul>', ], ], 'CreationTimestamp' => [ 'base' => NULL, 'refs' => [ 'RecommendationExportJob$creationTimestamp' => '<p>The timestamp of when the export job was created.</p>', ], ], 'Currency' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupEstimatedMonthlySavings$currency' => '<p> The currency of the estimated monthly savings. </p>', 'EBSEstimatedMonthlySavings$currency' => '<p> The currency of the estimated monthly savings. </p>', 'ECSEstimatedMonthlySavings$currency' => '<p> The currency of the estimated monthly savings. </p>', 'EstimatedMonthlySavings$currency' => '<p>The currency of the estimated monthly savings.</p>', 'InstanceEstimatedMonthlySavings$currency' => '<p> The currency of the estimated monthly savings. </p>', 'LambdaEstimatedMonthlySavings$currency' => '<p> The currency of the estimated monthly savings. </p>', 'RDSInstanceEstimatedMonthlySavings$currency' => '<p> The currency of the estimated monthly savings. </p>', 'RDSStorageEstimatedMonthlySavings$currency' => '<p> The currency of the estimated monthly savings. </p>', ], ], 'CurrentDBInstanceClass' => [ 'base' => NULL, 'refs' => [ 'RDSDBRecommendation$currentDBInstanceClass' => '<p> The DB instance class of the current RDS instance. </p>', ], ], 'CurrentInstanceType' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendation$currentInstanceType' => '<p>The instance type of the current instance.</p>', ], ], 'CurrentPerformanceRisk' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$currentPerformanceRisk' => '<p>The risk of the current Auto Scaling group not meeting the performance needs of its workloads. The higher the risk, the more likely the current Auto Scaling group configuration has insufficient capacity and cannot meet workload requirements.</p>', 'ECSServiceRecommendation$currentPerformanceRisk' => '<p> The risk of the current Amazon ECS service not meeting the performance needs of its workloads. The higher the risk, the more likely the current service can\'t meet the performance requirements of its workload. </p>', 'InstanceRecommendation$currentPerformanceRisk' => '<p>The risk of the current instance not meeting the performance needs of its workloads. The higher the risk, the more likely the current instance cannot meet the performance requirements of its workload.</p>', 'LambdaFunctionRecommendation$currentPerformanceRisk' => '<p>The risk of the current Lambda function not meeting the performance needs of its workloads. The higher the risk, the more likely the current Lambda function requires more memory.</p>', 'VolumeRecommendation$currentPerformanceRisk' => '<p>The risk of the current EBS volume not meeting the performance needs of its workloads. The higher the risk, the more likely the current EBS volume doesn\'t have sufficient capacity.</p>', ], ], 'CurrentPerformanceRiskRatings' => [ 'base' => '<p>Describes the performance risk ratings for a given resource type.</p> <p>Resources with a <code>high</code> or <code>medium</code> rating are at risk of not meeting the performance needs of their workloads, while resources with a <code>low</code> rating are performing well in their workloads.</p>', 'refs' => [ 'RecommendationSummary$currentPerformanceRiskRatings' => '<p>An object that describes the performance risk ratings for a given resource type.</p>', ], ], 'CustomizableMetricHeadroom' => [ 'base' => NULL, 'refs' => [ 'CustomizableMetricParameters$headroom' => '<p> The headroom value in percentage used for the specified metric parameter. </p> <p>The following lists the valid values for CPU and memory utilization.</p> <ul> <li> <p>CPU utilization: <code>PERCENT_30 | PERCENT_20 | PERCENT_0</code> </p> </li> <li> <p>Memory utilization: <code>PERCENT_30 | PERCENT_20 | PERCENT_10</code> </p> </li> </ul>', ], ], 'CustomizableMetricName' => [ 'base' => NULL, 'refs' => [ 'UtilizationPreference$metricName' => '<p> The name of the resource utilization metric name to customize. </p>', ], ], 'CustomizableMetricParameters' => [ 'base' => '<p> Defines the various metric parameters that can be customized, such as threshold and headroom. </p>', 'refs' => [ 'UtilizationPreference$metricParameters' => '<p> The parameters to set when customizing the resource utilization thresholds. </p>', ], ], 'CustomizableMetricThreshold' => [ 'base' => NULL, 'refs' => [ 'CustomizableMetricParameters$threshold' => '<p> The threshold value used for the specified metric parameter. </p> <note> <p>You can only specify the threshold value for CPU utilization.</p> </note>', ], ], 'DBInstanceClass' => [ 'base' => NULL, 'refs' => [ 'RDSDBInstanceRecommendationOption$dbInstanceClass' => '<p> Describes the DB instance class recommendation option for your Amazon RDS instance. </p>', ], ], 'DBStorageConfiguration' => [ 'base' => '<p> The configuration of the recommended RDS storage. </p>', 'refs' => [ 'RDSDBRecommendation$currentStorageConfiguration' => '<p> The configuration of the current RDS storage. </p>', 'RDSDBStorageRecommendationOption$storageConfiguration' => '<p> The recommended storage configuration. </p>', ], ], 'DeleteRecommendationPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRecommendationPreferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecommendationExportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecommendationExportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DesiredCapacity' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupConfiguration$desiredCapacity' => '<p>The desired capacity, or number of instances, for the Auto Scaling group.</p>', ], ], 'DestinationBucket' => [ 'base' => NULL, 'refs' => [ 'S3Destination$bucket' => '<p>The name of the Amazon S3 bucket used as the destination of an export file.</p>', 'S3DestinationConfig$bucket' => '<p>The name of the Amazon S3 bucket to use as the destination for an export job.</p>', ], ], 'DestinationKey' => [ 'base' => NULL, 'refs' => [ 'S3Destination$key' => '<p>The Amazon S3 bucket key of an export file.</p> <p>The key uniquely identifies the object, or export file, in the S3 bucket.</p>', ], ], 'DestinationKeyPrefix' => [ 'base' => NULL, 'refs' => [ 'S3DestinationConfig$keyPrefix' => '<p>The Amazon S3 bucket prefix for an export job.</p>', ], ], 'EBSEffectiveRecommendationPreferences' => [ 'base' => '<p> Describes the effective recommendation preferences for Amazon EBS volumes. </p>', 'refs' => [ 'VolumeRecommendation$effectiveRecommendationPreferences' => '<p> Describes the effective recommendation preferences for Amazon EBS volume. </p>', ], ], 'EBSEstimatedMonthlySavings' => [ 'base' => '<p> An object that describes the estimated monthly savings possible by adopting Compute Optimizer’s Amazon EBS volume recommendations. This includes any applicable discounts. </p>', 'refs' => [ 'EBSSavingsOpportunityAfterDiscounts$estimatedMonthlySavings' => '<p> The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s Amazon EBS volume recommendations. This saving includes any applicable discounts. </p>', ], ], 'EBSFilter' => [ 'base' => '<p>Describes a filter that returns a more specific list of Amazon Elastic Block Store (Amazon EBS) volume recommendations. Use this filter with the <a>GetEBSVolumeRecommendations</a> action.</p> <p>You can use <code>LambdaFunctionRecommendationFilter</code> with the <a>GetLambdaFunctionRecommendations</a> action, <code>JobFilter</code> with the <a>DescribeRecommendationExportJobs</a> action, and <code>Filter</code> with the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p>', 'refs' => [ 'EBSFilters$member' => NULL, ], ], 'EBSFilterName' => [ 'base' => NULL, 'refs' => [ 'EBSFilter$name' => '<p>The name of the filter.</p> <p>Specify <code>Finding</code> to return recommendations with a specific finding classification (for example, <code>NotOptimized</code>).</p> <p>You can filter your Amazon EBS volume recommendations by <code>tag:key</code> and <code>tag-key</code> tags.</p> <p>A <code>tag:key</code> is a key and value combination of a tag assigned to your Amazon EBS volume recommendations. Use the tag key in the filter name and the tag value as the filter value. For example, to find all Amazon EBS volume recommendations that have a tag with the key of <code>Owner</code> and the value of <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> <p>A <code>tag-key</code> is the key of a tag assigned to your Amazon EBS volume recommendations. Use this filter to find all of your Amazon EBS volume recommendations that have a tag with a specific key. This doesn’t consider the tag value. For example, you can find your Amazon EBS volume recommendations with a tag key value of <code>Owner</code> or without any tag keys assigned.</p>', ], ], 'EBSFilters' => [ 'base' => NULL, 'refs' => [ 'ExportEBSVolumeRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that exports a more specific set of Amazon EBS volume recommendations.</p>', 'GetEBSVolumeRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that returns a more specific list of volume recommendations.</p>', ], ], 'EBSFinding' => [ 'base' => NULL, 'refs' => [ 'VolumeRecommendation$finding' => '<p>The finding classification of the volume.</p> <p>Findings for volumes include:</p> <ul> <li> <p> <b> <code>NotOptimized</code> </b>—A volume is considered not optimized when Compute Optimizer identifies a recommendation that can provide better performance for your workload.</p> </li> <li> <p> <b> <code>Optimized</code> </b>—An volume is considered optimized when Compute Optimizer determines that the volume is correctly provisioned to run your workload based on the chosen volume type. For optimized resources, Compute Optimizer might recommend a new generation volume type.</p> </li> </ul>', ], ], 'EBSMetricName' => [ 'base' => NULL, 'refs' => [ 'EBSUtilizationMetric$name' => '<p>The name of the utilization metric.</p> <p>The following utilization metrics are available:</p> <ul> <li> <p> <code>VolumeReadOpsPerSecond</code> - The completed read operations per second from the volume in a specified period of time.</p> <p>Unit: Count</p> </li> <li> <p> <code>VolumeWriteOpsPerSecond</code> - The completed write operations per second to the volume in a specified period of time.</p> <p>Unit: Count</p> </li> <li> <p> <code>VolumeReadBytesPerSecond</code> - The bytes read per second from the volume in a specified period of time.</p> <p>Unit: Bytes</p> </li> <li> <p> <code>VolumeWriteBytesPerSecond</code> - The bytes written to the volume in a specified period of time.</p> <p>Unit: Bytes</p> </li> </ul>', ], ], 'EBSSavingsEstimationMode' => [ 'base' => '<p> Describes the savings estimation mode used for calculating savings opportunity for Amazon EBS volumes. </p>', 'refs' => [ 'EBSEffectiveRecommendationPreferences$savingsEstimationMode' => '<p> Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon EBS volumes. </p>', ], ], 'EBSSavingsEstimationModeSource' => [ 'base' => NULL, 'refs' => [ 'EBSSavingsEstimationMode$source' => '<p> Describes the source for calculating the savings opportunity for Amazon EBS volumes. </p>', ], ], 'EBSSavingsOpportunityAfterDiscounts' => [ 'base' => '<p> Describes the savings opportunity for Amazon EBS volume recommendations after applying specific discounts. </p>', 'refs' => [ 'VolumeRecommendationOption$savingsOpportunityAfterDiscounts' => '<p> An object that describes the savings opportunity for the Amazon EBS volume recommendation option with specific discounts. Savings opportunity includes the estimated monthly savings and percentage. </p>', ], ], 'EBSUtilizationMetric' => [ 'base' => '<p>Describes a utilization metric of an Amazon Elastic Block Store (Amazon EBS) volume.</p> <p>Compare the utilization metric data of your resource against its projected utilization metric data to determine the performance difference between your current resource and the recommended option.</p>', 'refs' => [ 'EBSUtilizationMetrics$member' => NULL, ], ], 'EBSUtilizationMetrics' => [ 'base' => NULL, 'refs' => [ 'VolumeRecommendation$utilizationMetrics' => '<p>An array of objects that describe the utilization metrics of the volume.</p>', ], ], 'ECSEffectiveRecommendationPreferences' => [ 'base' => '<p> Describes the effective recommendation preferences for Amazon ECS services. </p>', 'refs' => [ 'ECSServiceRecommendation$effectiveRecommendationPreferences' => '<p> Describes the effective recommendation preferences for Amazon ECS services. </p>', ], ], 'ECSEstimatedMonthlySavings' => [ 'base' => '<p> Describes the estimated monthly savings possible for Amazon ECS services by adopting Compute Optimizer recommendations. This is based on Amazon ECS service pricing after applying Savings Plans discounts. </p>', 'refs' => [ 'ECSSavingsOpportunityAfterDiscounts$estimatedMonthlySavings' => '<p> The estimated monthly savings possible by adopting Compute Optimizer’s Amazon ECS service recommendations. This includes any applicable Savings Plans discounts. </p>', ], ], 'ECSSavingsEstimationMode' => [ 'base' => '<p> Describes the savings estimation mode used for calculating savings opportunity for Amazon ECS services. </p>', 'refs' => [ 'ECSEffectiveRecommendationPreferences$savingsEstimationMode' => '<p> Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon ECS services. </p>', ], ], 'ECSSavingsEstimationModeSource' => [ 'base' => NULL, 'refs' => [ 'ECSSavingsEstimationMode$source' => '<p> Describes the source for calculating the savings opportunity for Amazon ECS services. </p>', ], ], 'ECSSavingsOpportunityAfterDiscounts' => [ 'base' => '<p> Describes the savings opportunity for Amazon ECS service recommendations after applying Savings Plans discounts. </p> <p>Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation.</p>', 'refs' => [ 'ECSServiceRecommendationOption$savingsOpportunityAfterDiscounts' => '<p> Describes the savings opportunity for Amazon ECS service recommendations or for the recommendation option. </p> <p>Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation.</p>', ], ], 'ECSServiceLaunchType' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendation$launchType' => '<p> The launch type the Amazon ECS service is using. </p> <note> <p>Compute Optimizer only supports the Fargate launch type.</p> </note>', ], ], 'ECSServiceMetricName' => [ 'base' => NULL, 'refs' => [ 'ECSServiceProjectedMetric$name' => '<p> The name of the projected metric. </p> <p>The following metrics are available:</p> <ul> <li> <p> <code>Cpu</code> — The percentage of allocated compute units that are currently in use on the service tasks.</p> </li> <li> <p> <code>Memory</code> — The percentage of memory that\'s currently in use on the service tasks.</p> </li> </ul>', 'ECSServiceProjectedUtilizationMetric$name' => '<p> The name of the projected utilization metric. </p> <p>The following utilization metrics are available:</p> <ul> <li> <p> <code>Cpu</code> — The percentage of allocated compute units that are currently in use on the service tasks.</p> </li> <li> <p> <code>Memory</code> — The percentage of memory that\'s currently in use on the service tasks.</p> </li> </ul>', 'ECSServiceUtilizationMetric$name' => '<p> The name of the utilization metric. </p> <p>The following utilization metrics are available:</p> <ul> <li> <p> <code>Cpu</code> — The amount of CPU capacity that\'s used in the service.</p> </li> <li> <p> <code>Memory</code> — The amount of memory that\'s used in the service.</p> </li> </ul>', ], ], 'ECSServiceMetricStatistic' => [ 'base' => NULL, 'refs' => [ 'ECSServiceProjectedUtilizationMetric$statistic' => '<p>The statistic of the projected utilization metric.</p> <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the <code>Maximum</code> statistic, which is the highest value observed during the specified period.</p> <p>The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code> statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p>', 'ECSServiceUtilizationMetric$statistic' => '<p>The statistic of the utilization metric.</p> <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the <code>Maximum</code> statistic, which is the highest value observed during the specified period.</p> <p>The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code> statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p>', ], ], 'ECSServiceProjectedMetric' => [ 'base' => '<p> Describes the projected metrics of an Amazon ECS service recommendation option. </p> <p>To determine the performance difference between your current Amazon ECS service and the recommended option, compare the metric data of your service against its projected metric data.</p>', 'refs' => [ 'ECSServiceProjectedMetrics$member' => NULL, ], ], 'ECSServiceProjectedMetrics' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendedOptionProjectedMetric$projectedMetrics' => '<p> An array of objects that describe the projected metric. </p>', ], ], 'ECSServiceProjectedUtilizationMetric' => [ 'base' => '<p> Describes the projected utilization metrics of an Amazon ECS service recommendation option. </p> <p>To determine the performance difference between your current Amazon ECS service and the recommended option, compare the utilization metric data of your service against its projected utilization metric data.</p>', 'refs' => [ 'ECSServiceProjectedUtilizationMetrics$member' => NULL, ], ], 'ECSServiceProjectedUtilizationMetrics' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendationOption$projectedUtilizationMetrics' => '<p> An array of objects that describe the projected utilization metrics of the Amazon ECS service recommendation option. </p>', ], ], 'ECSServiceRecommendation' => [ 'base' => '<p> Describes an Amazon ECS service recommendation. </p>', 'refs' => [ 'ECSServiceRecommendations$member' => NULL, ], ], 'ECSServiceRecommendationFilter' => [ 'base' => '<p> Describes a filter that returns a more specific list of Amazon ECS service recommendations. Use this filter with the <a>GetECSServiceRecommendations</a> action. </p>', 'refs' => [ 'ECSServiceRecommendationFilters$member' => NULL, ], ], 'ECSServiceRecommendationFilterName' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendationFilter$name' => '<p> The name of the filter. </p> <p> Specify <code>Finding</code> to return recommendations with a specific finding classification. </p> <p> Specify <code>FindingReasonCode</code> to return recommendations with a specific finding reason code. </p> <p>You can filter your Amazon ECS service recommendations by <code>tag:key</code> and <code>tag-key</code> tags.</p> <p>A <code>tag:key</code> is a key and value combination of a tag assigned to your Amazon ECS service recommendations. Use the tag key in the filter name and the tag value as the filter value. For example, to find all Amazon ECS service recommendations that have a tag with the key of <code>Owner</code> and the value of <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> <p>A <code>tag-key</code> is the key of a tag assigned to your Amazon ECS service recommendations. Use this filter to find all of your Amazon ECS service recommendations that have a tag with a specific key. This doesn’t consider the tag value. For example, you can find your Amazon ECS service recommendations with a tag key value of <code>Owner</code> or without any tag keys assigned.</p>', ], ], 'ECSServiceRecommendationFilters' => [ 'base' => NULL, 'refs' => [ 'ExportECSServiceRecommendationsRequest$filters' => '<p> An array of objects to specify a filter that exports a more specific set of Amazon ECS service recommendations. </p>', 'GetECSServiceRecommendationsRequest$filters' => '<p> An array of objects to specify a filter that returns a more specific list of Amazon ECS service recommendations. </p>', ], ], 'ECSServiceRecommendationFinding' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendation$finding' => '<p> The finding classification of an Amazon ECS service. </p> <p>Findings for Amazon ECS services include:</p> <ul> <li> <p> <b> <code>Underprovisioned</code> </b> — When Compute Optimizer detects that there’s not enough memory or CPU, an Amazon ECS service is considered under-provisioned. An under-provisioned service might result in poor application performance.</p> </li> <li> <p> <b> <code>Overprovisioned</code> </b> — When Compute Optimizer detects that there’s excessive memory or CPU, an Amazon ECS service is considered over-provisioned. An over-provisioned service might result in additional infrastructure costs. </p> </li> <li> <p> <b> <code>Optimized</code> </b> — When both the CPU and memory of your Amazon ECS service meet the performance requirements of your workload, the service is considered optimized.</p> </li> </ul>', ], ], 'ECSServiceRecommendationFindingReasonCode' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendationFindingReasonCodes$member' => NULL, ], ], 'ECSServiceRecommendationFindingReasonCodes' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendation$findingReasonCodes' => '<p> The reason for the finding classification of an Amazon ECS service. </p> <p>Finding reason codes for Amazon ECS services include:</p> <ul> <li> <p> <b> <code>CPUUnderprovisioned</code> </b> — The service CPU configuration can be sized up to enhance the performance of your workload. This is identified by analyzing the <code>CPUUtilization</code> metric of the current service during the look-back period.</p> </li> <li> <p> <b> <code>CPUOverprovisioned</code> </b> — The service CPU configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>CPUUtilization</code> metric of the current service during the look-back period. </p> </li> <li> <p> <b> <code>MemoryUnderprovisioned</code> </b> — The service memory configuration can be sized up to enhance the performance of your workload. This is identified by analyzing the <code>MemoryUtilization</code> metric of the current service during the look-back period.</p> </li> <li> <p> <b> <code>MemoryOverprovisioned</code> </b> — The service memory configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>MemoryUtilization</code> metric of the current service during the look-back period.</p> </li> </ul>', ], ], 'ECSServiceRecommendationOption' => [ 'base' => '<p> Describes the recommendation options for an Amazon ECS service. </p>', 'refs' => [ 'ECSServiceRecommendationOptions$member' => NULL, ], ], 'ECSServiceRecommendationOptions' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendation$serviceRecommendationOptions' => '<p> An array of objects that describe the recommendation options for the Amazon ECS service. </p>', ], ], 'ECSServiceRecommendations' => [ 'base' => NULL, 'refs' => [ 'GetECSServiceRecommendationsResponse$ecsServiceRecommendations' => '<p> An array of objects that describe the Amazon ECS service recommendations. </p>', ], ], 'ECSServiceRecommendedOptionProjectedMetric' => [ 'base' => '<p> Describes the projected metrics of an Amazon ECS service recommendation option. </p> <p>To determine the performance difference between your current Amazon ECS service and the recommended option, compare the metric data of your service against its projected metric data.</p>', 'refs' => [ 'ECSServiceRecommendedOptionProjectedMetrics$member' => NULL, ], ], 'ECSServiceRecommendedOptionProjectedMetrics' => [ 'base' => NULL, 'refs' => [ 'GetECSServiceRecommendationProjectedMetricsResponse$recommendedOptionProjectedMetrics' => '<p> An array of objects that describes the projected metrics. </p>', ], ], 'ECSServiceUtilizationMetric' => [ 'base' => '<p> Describes the utilization metric of an Amazon ECS service. </p> <p>To determine the performance difference between your current Amazon ECS service and the recommended option, compare the utilization metric data of your service against its projected utilization metric data.</p>', 'refs' => [ 'ECSServiceUtilizationMetrics$member' => NULL, ], ], 'ECSServiceUtilizationMetrics' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendation$utilizationMetrics' => '<p> An array of objects that describe the utilization metrics of the Amazon ECS service. </p>', ], ], 'EffectivePreferredResource' => [ 'base' => '<p> Describes the effective preferred resources that Compute Optimizer considers as rightsizing recommendation candidates. </p> <note> <p>Compute Optimizer only supports Amazon EC2 instance types.</p> </note>', 'refs' => [ 'EffectivePreferredResources$member' => NULL, ], ], 'EffectivePreferredResources' => [ 'base' => NULL, 'refs' => [ 'EffectiveRecommendationPreferences$preferredResources' => '<p> The resource type values that are considered as candidates when generating rightsizing recommendations. </p>', 'GetEffectiveRecommendationPreferencesResponse$preferredResources' => '<p> The resource type values that are considered as candidates when generating rightsizing recommendations. This object resolves any wildcard expressions and returns the effective list of candidate resource type values. It also considers all applicable preferences that you set at the resource, account, and organization level. </p> <p>To validate that the preference is applied to your last generated set of recommendations, review the <code>effectiveRecommendationPreferences</code> value in the response of the GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.</p>', 'RecommendationPreferencesDetail$preferredResources' => '<p> The preference to control which resource type values are considered when generating rightsizing recommendations. This object resolves any wildcard expressions and returns the effective list of candidate resource type values. If the preference isn’t set, this object is null. </p>', ], ], 'EffectiveRecommendationPreferences' => [ 'base' => '<p>Describes the effective recommendation preferences for a resource.</p>', 'refs' => [ 'AutoScalingGroupRecommendation$effectiveRecommendationPreferences' => '<p>An object that describes the effective recommendation preferences for the Auto Scaling group.</p>', 'InstanceRecommendation$effectiveRecommendationPreferences' => '<p>An object that describes the effective recommendation preferences for the instance.</p>', ], ], 'Engine' => [ 'base' => NULL, 'refs' => [ 'RDSDBRecommendation$engine' => '<p> The engine of the RDS instance. </p>', ], ], 'EngineVersion' => [ 'base' => NULL, 'refs' => [ 'RDSDBRecommendation$engineVersion' => '<p> The database engine version. </p>', ], ], 'EnhancedInfrastructureMetrics' => [ 'base' => NULL, 'refs' => [ 'EffectiveRecommendationPreferences$enhancedInfrastructureMetrics' => '<p>Describes the activation status of the enhanced infrastructure metrics preference.</p> <p>A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh, and a status of <code>Inactive</code> confirms that it\'s not yet applied to recommendations.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetEffectiveRecommendationPreferencesResponse$enhancedInfrastructureMetrics' => '<p>The status of the enhanced infrastructure metrics recommendation preference. Considers all applicable preferences that you might have set at the resource, account, and organization level.</p> <p>A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh, and a status of <code>Inactive</code> confirms that it\'s not yet applied to recommendations.</p> <p>To validate whether the preference is applied to your last generated set of recommendations, review the <code>effectiveRecommendationPreferences</code> value in the response of the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'PutRecommendationPreferencesRequest$enhancedInfrastructureMetrics' => '<p>The status of the enhanced infrastructure metrics recommendation preference to create or update.</p> <p>Specify the <code>Active</code> status to activate the preference, or specify <code>Inactive</code> to deactivate the preference.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'RDSEffectiveRecommendationPreferences$enhancedInfrastructureMetrics' => '<p>Describes the activation status of the enhanced infrastructure metrics preference. </p> <p>A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh, and a status of <code>Inactive</code> confirms that it\'s not yet applied to recommendations. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>. </p>', 'RecommendationPreferencesDetail$enhancedInfrastructureMetrics' => '<p>The status of the enhanced infrastructure metrics recommendation preference.</p> <p>When the recommendations page is refreshed, a status of <code>Active</code> confirms that the preference is applied to the recommendations, and a status of <code>Inactive</code> confirms that the preference isn\'t yet applied to recommendations.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'EnrollmentFilter' => [ 'base' => '<p>Describes a filter that returns a more specific list of account enrollment statuses. Use this filter with the <a>GetEnrollmentStatusesForOrganization</a> action.</p>', 'refs' => [ 'EnrollmentFilters$member' => NULL, ], ], 'EnrollmentFilterName' => [ 'base' => NULL, 'refs' => [ 'EnrollmentFilter$name' => '<p>The name of the filter.</p> <p>Specify <code>Status</code> to return accounts with a specific enrollment status (for example, <code>Active</code>).</p>', ], ], 'EnrollmentFilters' => [ 'base' => NULL, 'refs' => [ 'GetEnrollmentStatusesForOrganizationRequest$filters' => '<p>An array of objects to specify a filter that returns a more specific list of account enrollment statuses.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'InternalServerException$message' => NULL, 'InvalidParameterValueException$message' => NULL, 'LimitExceededException$message' => NULL, 'MissingAuthenticationToken$message' => NULL, 'OptInRequiredException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceUnavailableException$message' => NULL, 'ThrottlingException$message' => NULL, ], ], 'EstimatedMonthlySavings' => [ 'base' => '<p>Describes the estimated monthly savings amount possible, based on On-Demand instance pricing, by adopting Compute Optimizer recommendations for a given resource.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/view-ec2-recommendations.html#ec2-savings-calculation">Estimated monthly savings and savings opportunities</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'refs' => [ 'InferredWorkloadSaving$estimatedMonthlySavings' => '<p>An object that describes the estimated monthly savings amount possible by adopting Compute Optimizer recommendations for a given resource. This is based on the On-Demand instance pricing.</p>', 'SavingsOpportunity$estimatedMonthlySavings' => '<p>An object that describes the estimated monthly savings amount possible by adopting Compute Optimizer recommendations for a given resource. This is based on the On-Demand instance pricing..</p>', ], ], 'ExportAutoScalingGroupRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportAutoScalingGroupRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportDestination' => [ 'base' => '<p>Describes the destination of the recommendations export and metadata files.</p>', 'refs' => [ 'RecommendationExportJob$destination' => '<p>An object that describes the destination of the export file.</p>', ], ], 'ExportEBSVolumeRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportEBSVolumeRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportEC2InstanceRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportEC2InstanceRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportECSServiceRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportECSServiceRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportLambdaFunctionRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportLambdaFunctionRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportLicenseRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportLicenseRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportRDSDatabaseRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportRDSDatabaseRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportableAutoScalingGroupField' => [ 'base' => NULL, 'refs' => [ 'ExportableAutoScalingGroupFields$member' => NULL, ], ], 'ExportableAutoScalingGroupFields' => [ 'base' => NULL, 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$fieldsToExport' => '<p>The recommendations data to include in the export file. For more information about the fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'ExportableECSServiceField' => [ 'base' => NULL, 'refs' => [ 'ExportableECSServiceFields$member' => NULL, ], ], 'ExportableECSServiceFields' => [ 'base' => NULL, 'refs' => [ 'ExportECSServiceRecommendationsRequest$fieldsToExport' => '<p>The recommendations data to include in the export file. For more information about the fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'ExportableInstanceField' => [ 'base' => NULL, 'refs' => [ 'ExportableInstanceFields$member' => NULL, ], ], 'ExportableInstanceFields' => [ 'base' => NULL, 'refs' => [ 'ExportEC2InstanceRecommendationsRequest$fieldsToExport' => '<p>The recommendations data to include in the export file. For more information about the fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'ExportableLambdaFunctionField' => [ 'base' => NULL, 'refs' => [ 'ExportableLambdaFunctionFields$member' => NULL, ], ], 'ExportableLambdaFunctionFields' => [ 'base' => NULL, 'refs' => [ 'ExportLambdaFunctionRecommendationsRequest$fieldsToExport' => '<p>The recommendations data to include in the export file. For more information about the fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'ExportableLicenseField' => [ 'base' => NULL, 'refs' => [ 'ExportableLicenseFields$member' => NULL, ], ], 'ExportableLicenseFields' => [ 'base' => NULL, 'refs' => [ 'ExportLicenseRecommendationsRequest$fieldsToExport' => '<p>The recommendations data to include in the export file. For more information about the fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'ExportableRDSDBField' => [ 'base' => NULL, 'refs' => [ 'ExportableRDSDBFields$member' => NULL, ], ], 'ExportableRDSDBFields' => [ 'base' => NULL, 'refs' => [ 'ExportRDSDatabaseRecommendationsRequest$fieldsToExport' => '<p>The recommendations data to include in the export file. For more information about the fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'ExportableVolumeField' => [ 'base' => NULL, 'refs' => [ 'ExportableVolumeFields$member' => NULL, ], ], 'ExportableVolumeFields' => [ 'base' => NULL, 'refs' => [ 'ExportEBSVolumeRecommendationsRequest$fieldsToExport' => '<p>The recommendations data to include in the export file. For more information about the fields that can be exported, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files">Exported files</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'ExternalMetricStatus' => [ 'base' => '<p> Describes Compute Optimizer\'s integration status with your chosen external metric provider. For example, Datadog. </p>', 'refs' => [ 'InstanceRecommendation$externalMetricStatus' => '<p> An object that describes Compute Optimizer\'s integration status with your external metrics provider. </p>', ], ], 'ExternalMetricStatusCode' => [ 'base' => NULL, 'refs' => [ 'ExternalMetricStatus$statusCode' => '<p> The status code for Compute Optimizer\'s integration with an external metrics provider. </p>', ], ], 'ExternalMetricStatusReason' => [ 'base' => NULL, 'refs' => [ 'ExternalMetricStatus$statusReason' => '<p> The reason for Compute Optimizer\'s integration status with your external metric provider. </p>', ], ], 'ExternalMetricsPreference' => [ 'base' => '<p> Describes the external metrics preferences for EC2 rightsizing recommendations. </p>', 'refs' => [ 'EffectiveRecommendationPreferences$externalMetricsPreference' => '<p> An object that describes the external metrics recommendation preference. </p> <p> If the preference is applied in the latest recommendation refresh, an object with a valid <code>source</code> value appears in the response. If the preference isn\'t applied to the recommendations already, then this object doesn\'t appear in the response. </p>', 'GetEffectiveRecommendationPreferencesResponse$externalMetricsPreference' => '<p>The provider of the external metrics recommendation preference. Considers all applicable preferences that you might have set at the account and organization level.</p> <p>If the preference is applied in the latest recommendation refresh, an object with a valid <code>source</code> value appears in the response. If the preference isn\'t applied to the recommendations already, then this object doesn\'t appear in the response.</p> <p>To validate whether the preference is applied to your last generated set of recommendations, review the <code>effectiveRecommendationPreferences</code> value in the response of the <a>GetEC2InstanceRecommendations</a> actions.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html">Enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'PutRecommendationPreferencesRequest$externalMetricsPreference' => '<p>The provider of the external metrics recommendation preference to create or update.</p> <p>Specify a valid provider in the <code>source</code> field to activate the preference. To delete this preference, see the <a>DeleteRecommendationPreferences</a> action.</p> <p>This preference can only be set for the <code>Ec2Instance</code> resource type.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/external-metrics-ingestion.html">External metrics ingestion</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'RecommendationPreferencesDetail$externalMetricsPreference' => '<p> An object that describes the external metrics recommendation preference. </p> <p> If the preference is applied in the latest recommendation refresh, an object with a valid <code>source</code> value appears in the response. If the preference isn\'t applied to the recommendations already, then this object doesn\'t appear in the response. </p>', ], ], 'ExternalMetricsSource' => [ 'base' => NULL, 'refs' => [ 'ExternalMetricsPreference$source' => '<p> Contains the source options for external metrics preferences. </p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'RecommendationExportJob$failureReason' => '<p>The reason for an export job failure.</p>', ], ], 'FileFormat' => [ 'base' => NULL, 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$fileFormat' => '<p>The format of the export file.</p> <p>The only export file format currently supported is <code>Csv</code>.</p>', 'ExportEBSVolumeRecommendationsRequest$fileFormat' => '<p>The format of the export file.</p> <p>The only export file format currently supported is <code>Csv</code>.</p>', 'ExportEC2InstanceRecommendationsRequest$fileFormat' => '<p>The format of the export file.</p> <p>The only export file format currently supported is <code>Csv</code>.</p>', 'ExportECSServiceRecommendationsRequest$fileFormat' => '<p> The format of the export file. </p> <p>The CSV file is the only export file format currently supported.</p>', 'ExportLambdaFunctionRecommendationsRequest$fileFormat' => '<p>The format of the export file.</p> <p>The only export file format currently supported is <code>Csv</code>.</p>', 'ExportLicenseRecommendationsRequest$fileFormat' => '<p>The format of the export file.</p> <p>A CSV file is the only export format currently supported.</p>', 'ExportRDSDatabaseRecommendationsRequest$fileFormat' => '<p> The format of the export file. </p> <p>The CSV file is the only export file format currently supported.</p>', ], ], 'Filter' => [ 'base' => '<p>Describes a filter that returns a more specific list of recommendations. Use this filter with the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p> <p>You can use <code>EBSFilter</code> with the <a>GetEBSVolumeRecommendations</a> action, <code>LambdaFunctionRecommendationFilter</code> with the <a>GetLambdaFunctionRecommendations</a> action, and <code>JobFilter</code> with the <a>DescribeRecommendationExportJobs</a> action.</p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'Filter$name' => '<p>The name of the filter.</p> <p>Specify <code>Finding</code> to return recommendations with a specific finding classification. For example, <code>Underprovisioned</code>.</p> <p>Specify <code>RecommendationSourceType</code> to return recommendations of a specific resource type. For example, <code>Ec2Instance</code>.</p> <p>Specify <code>FindingReasonCodes</code> to return recommendations with a specific finding reason code. For example, <code>CPUUnderprovisioned</code>.</p> <p>Specify <code>InferredWorkloadTypes</code> to return recommendations of a specific inferred workload. For example, <code>Redis</code>.</p> <p>You can filter your EC2 instance recommendations by <code>tag:key</code> and <code>tag-key</code> tags.</p> <p>A <code>tag:key</code> is a key and value combination of a tag assigned to your recommendations. Use the tag key in the filter name and the tag value as the filter value. For example, to find all recommendations that have a tag with the key of <code>Owner</code> and the value of <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> <p>A <code>tag-key</code> is the key of a tag assigned to your recommendations. Use this filter to find all of your recommendations that have a tag with a specific key. This doesn’t consider the tag value. For example, you can find your recommendations with a tag key value of <code>Owner</code> or without any tag keys assigned.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValues$member' => NULL, ], ], 'FilterValues' => [ 'base' => NULL, 'refs' => [ 'EBSFilter$values' => '<p>The value of the filter.</p> <p>The valid values are <code>Optimized</code>, or <code>NotOptimized</code>.</p>', 'ECSServiceRecommendationFilter$values' => '<p> The value of the filter. </p> <p>The valid values for this parameter are as follows:</p> <ul> <li> <p>If you specify the <code>name</code> parameter as <code>Finding</code>, specify <code>Optimized</code>, <code>Underprovisioned</code>, or <code>Overprovisioned</code>.</p> </li> <li> <p>If you specify the <code>name</code> parameter as <code>FindingReasonCode</code>, specify <code>CPUUnderprovisioned</code>, <code>CPUOverprovisioned</code>, <code>MemoryUnderprovisioned</code>, or <code>MemoryOverprovisioned</code>.</p> </li> </ul>', 'EnrollmentFilter$values' => '<p>The value of the filter.</p> <p>The valid values are <code>Active</code>, <code>Inactive</code>, <code>Pending</code>, and <code>Failed</code>.</p>', 'Filter$values' => '<p>The value of the filter.</p> <p>The valid values for this parameter are as follows, depending on what you specify for the <code>name</code> parameter and the resource type that you wish to filter results for:</p> <ul> <li> <p>Specify <code>Optimized</code> or <code>NotOptimized</code> if you specify the <code>name</code> parameter as <code>Finding</code> and you want to filter results for Auto Scaling groups.</p> </li> <li> <p>Specify <code>Underprovisioned</code>, <code>Overprovisioned</code>, or <code>Optimized</code> if you specify the <code>name</code> parameter as <code>Finding</code> and you want to filter results for EC2 instances.</p> </li> <li> <p>Specify <code>Ec2Instance</code> or <code>AutoScalingGroup</code> if you specify the <code>name</code> parameter as <code>RecommendationSourceType</code>.</p> </li> <li> <p>Specify one of the following options if you specify the <code>name</code> parameter as <code>FindingReasonCodes</code>:</p> <ul> <li> <p> <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better CPU performance.</p> </li> <li> <p> <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better memory performance.</p> </li> <li> <p> <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better EBS throughput performance.</p> </li> <li> <p> <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better EBS IOPS performance.</p> </li> <li> <p> <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better network bandwidth performance. This finding reason happens when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is impacted.</p> </li> <li> <p> <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better network PPS performance.</p> </li> <li> <p> <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better disk IOPS performance.</p> </li> <li> <p> <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be sized down while still meeting the performance requirements of your workload.</p> </li> <li> <p> <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better disk throughput performance.</p> </li> </ul> </li> </ul>', 'JobFilter$values' => '<p>The value of the filter.</p> <p>The valid values for this parameter are as follows, depending on what you specify for the <code>name</code> parameter:</p> <ul> <li> <p>Specify <code>Ec2Instance</code> or <code>AutoScalingGroup</code> if you specify the <code>name</code> parameter as <code>ResourceType</code>. There is no filter for EBS volumes because volume recommendations cannot be exported at this time.</p> </li> <li> <p>Specify <code>Queued</code>, <code>InProgress</code>, <code>Complete</code>, or <code>Failed</code> if you specify the <code>name</code> parameter as <code>JobStatus</code>.</p> </li> </ul>', 'LambdaFunctionRecommendationFilter$values' => '<p>The value of the filter.</p> <p>The valid values for this parameter are as follows, depending on what you specify for the <code>name</code> parameter:</p> <ul> <li> <p>Specify <code>Optimized</code>, <code>NotOptimized</code>, or <code>Unavailable</code> if you specify the <code>name</code> parameter as <code>Finding</code>.</p> </li> <li> <p>Specify <code>MemoryOverprovisioned</code>, <code>MemoryUnderprovisioned</code>, <code>InsufficientData</code>, or <code>Inconclusive</code> if you specify the <code>name</code> parameter as <code>FindingReasonCode</code>.</p> </li> </ul>', 'LicenseRecommendationFilter$values' => '<p>The value of the filter.</p> <p>The valid values for this parameter are as follows, depending on what you specify for the <code>name</code> parameter:</p> <ul> <li> <p>If you specify the <code>name</code> parameter as <code>Finding</code>, then specify <code>Optimized</code>, <code>NotOptimized</code>, or <code>InsufficentMetrics</code>.</p> </li> <li> <p>If you specify the <code>name</code> parameter as <code>FindingReasonCode</code>, then specify <code>Optimized</code>, <code>LicenseOverprovisioned</code>, <code>InvalidCloudwatchApplicationInsights</code>, or <code>CloudwatchApplicationInsightsError</code>.</p> </li> </ul>', 'RDSDBRecommendationFilter$values' => '<p> The value of the filter. </p>', ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that exports a more specific set of Auto Scaling group recommendations.</p>', 'ExportEC2InstanceRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that exports a more specific set of instance recommendations.</p>', 'GetAutoScalingGroupRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that returns a more specific list of Auto Scaling group recommendations.</p>', 'GetEC2InstanceRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that returns a more specific list of instance recommendations.</p>', ], ], 'Finding' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$finding' => '<p>The finding classification of the Auto Scaling group.</p> <p>Findings for Auto Scaling groups include:</p> <ul> <li> <p> <b> <code>NotOptimized</code> </b>—An Auto Scaling group is considered not optimized when Compute Optimizer identifies a recommendation that can provide better performance for your workload.</p> </li> <li> <p> <b> <code>Optimized</code> </b>—An Auto Scaling group is considered optimized when Compute Optimizer determines that the group is correctly provisioned to run your workload based on the chosen instance type. For optimized resources, Compute Optimizer might recommend a new generation instance type.</p> </li> </ul>', 'InstanceRecommendation$finding' => '<p>The finding classification of the instance.</p> <p>Findings for instances include:</p> <ul> <li> <p> <b> <code>Underprovisioned</code> </b>—An instance is considered under-provisioned when at least one specification of your instance, such as CPU, memory, or network, does not meet the performance requirements of your workload. Under-provisioned instances may lead to poor application performance.</p> </li> <li> <p> <b> <code>Overprovisioned</code> </b>—An instance is considered over-provisioned when at least one specification of your instance, such as CPU, memory, or network, can be sized down while still meeting the performance requirements of your workload, and no specification is under-provisioned. Over-provisioned instances may lead to unnecessary infrastructure cost.</p> </li> <li> <p> <b> <code>Optimized</code> </b>—An instance is considered optimized when all specifications of your instance, such as CPU, memory, and network, meet the performance requirements of your workload and is not over provisioned. For optimized resources, Compute Optimizer might recommend a new generation instance type.</p> </li> </ul> <note> <p>The valid values in your API responses appear as OVER_PROVISIONED, UNDER_PROVISIONED, or OPTIMIZED.</p> </note>', 'Summary$name' => '<p>The finding classification of the recommendation.</p>', ], ], 'FindingReasonCode' => [ 'base' => NULL, 'refs' => [ 'ReasonCodeSummary$name' => '<p>The name of the finding reason code.</p>', ], ], 'FunctionArn' => [ 'base' => NULL, 'refs' => [ 'FunctionArns$member' => NULL, 'LambdaFunctionRecommendation$functionArn' => '<p>The Amazon Resource Name (ARN) of the current function.</p>', ], ], 'FunctionArns' => [ 'base' => NULL, 'refs' => [ 'GetLambdaFunctionRecommendationsRequest$functionArns' => '<p>The Amazon Resource Name (ARN) of the functions for which to return recommendations.</p> <p>You can specify a qualified or unqualified ARN. If you specify an unqualified ARN without a function version suffix, Compute Optimizer will return recommendations for the latest (<code>$LATEST</code>) version of the function. If you specify a qualified ARN with a version suffix, Compute Optimizer will return recommendations for the specified function version. For more information about using function versions, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using">Using versions</a> in the <i>Lambda Developer Guide</i>.</p>', ], ], 'FunctionVersion' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendation$functionVersion' => '<p>The version number of the current function.</p>', ], ], 'GetAutoScalingGroupRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAutoScalingGroupRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEBSVolumeRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEBSVolumeRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEC2InstanceRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEC2InstanceRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEC2RecommendationProjectedMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEC2RecommendationProjectedMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetECSServiceRecommendationProjectedMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetECSServiceRecommendationProjectedMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetECSServiceRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetECSServiceRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEffectiveRecommendationPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEffectiveRecommendationPreferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEnrollmentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEnrollmentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEnrollmentStatusesForOrganizationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEnrollmentStatusesForOrganizationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLambdaFunctionRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLambdaFunctionRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLicenseRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRDSDatabaseRecommendationProjectedMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRDSDatabaseRecommendationProjectedMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRDSDatabaseRecommendationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRDSDatabaseRecommendationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationError' => [ 'base' => '<p>Describes an error experienced when getting recommendations.</p> <p>For example, an error is returned if you request recommendations for an unsupported Auto Scaling group, or if you request recommendations for an instance of an unsupported instance family.</p>', 'refs' => [ 'GetRecommendationErrors$member' => NULL, ], ], 'GetRecommendationErrors' => [ 'base' => NULL, 'refs' => [ 'GetAutoScalingGroupRecommendationsResponse$errors' => '<p>An array of objects that describe errors of the request.</p> <p>For example, an error is returned if you request recommendations for an unsupported Auto Scaling group.</p>', 'GetEBSVolumeRecommendationsResponse$errors' => '<p>An array of objects that describe errors of the request.</p> <p>For example, an error is returned if you request recommendations for an unsupported volume.</p>', 'GetEC2InstanceRecommendationsResponse$errors' => '<p>An array of objects that describe errors of the request.</p> <p>For example, an error is returned if you request recommendations for an instance of an unsupported instance family.</p>', 'GetECSServiceRecommendationsResponse$errors' => '<p> An array of objects that describe errors of the request. </p>', 'GetLicenseRecommendationsResponse$errors' => '<p> An array of objects that describe errors of the request. </p>', 'GetRDSDatabaseRecommendationsResponse$errors' => '<p> An array of objects that describe errors of the request. </p>', ], ], 'GetRecommendationPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationPreferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationSummariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationSummariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Gpu' => [ 'base' => '<p> Describes the GPU accelerators for the instance type. </p>', 'refs' => [ 'Gpus$member' => NULL, ], ], 'GpuCount' => [ 'base' => NULL, 'refs' => [ 'Gpu$gpuCount' => '<p> The number of GPUs for the instance type. </p>', ], ], 'GpuInfo' => [ 'base' => '<p> Describes the GPU accelerator settings for the instance type. </p>', 'refs' => [ 'AutoScalingGroupRecommendation$currentInstanceGpuInfo' => '<p> Describes the GPU accelerator settings for the current instance type of the Auto Scaling group. </p>', 'AutoScalingGroupRecommendationOption$instanceGpuInfo' => '<p> Describes the GPU accelerator settings for the recommended instance type of the Auto Scaling group. </p>', 'InstanceRecommendation$currentInstanceGpuInfo' => '<p> Describes the GPU accelerator settings for the current instance type. </p>', 'InstanceRecommendationOption$instanceGpuInfo' => '<p> Describes the GPU accelerator settings for the recommended instance type. </p>', ], ], 'GpuMemorySizeInMiB' => [ 'base' => NULL, 'refs' => [ 'Gpu$gpuMemorySizeInMiB' => '<p> The total size of the memory for the GPU accelerators for the instance type, in MiB. </p>', ], ], 'Gpus' => [ 'base' => NULL, 'refs' => [ 'GpuInfo$gpus' => '<p> Describes the GPU accelerators for the instance type. </p>', ], ], 'High' => [ 'base' => NULL, 'refs' => [ 'CurrentPerformanceRiskRatings$high' => '<p>A count of the applicable resource types with a high performance risk rating.</p>', ], ], 'Identifier' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationError$identifier' => '<p>The ID of the error.</p>', ], ], 'Idle' => [ 'base' => NULL, 'refs' => [ 'RDSDBRecommendation$idle' => '<p> This indicates if the RDS instance is idle or not. </p>', ], ], 'IncludeMemberAccounts' => [ 'base' => NULL, 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$includeMemberAccounts' => '<p>Indicates whether to include recommendations for resources in all member accounts of the organization if your account is the management account of an organization.</p> <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>Recommendations for member accounts of the organization are not included in the export file if this parameter is omitted.</p> <p>This parameter cannot be specified together with the account IDs parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the account IDs parameter, is omitted.</p>', 'ExportEBSVolumeRecommendationsRequest$includeMemberAccounts' => '<p>Indicates whether to include recommendations for resources in all member accounts of the organization if your account is the management account of an organization.</p> <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>Recommendations for member accounts of the organization are not included in the export file if this parameter is omitted.</p> <p>This parameter cannot be specified together with the account IDs parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the account IDs parameter, is omitted.</p>', 'ExportEC2InstanceRecommendationsRequest$includeMemberAccounts' => '<p>Indicates whether to include recommendations for resources in all member accounts of the organization if your account is the management account of an organization.</p> <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>Recommendations for member accounts of the organization are not included in the export file if this parameter is omitted.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the account IDs parameter, is omitted.</p>', 'ExportECSServiceRecommendationsRequest$includeMemberAccounts' => '<p>If your account is the management account or the delegated administrator of an organization, this parameter indicates whether to include recommendations for resources in all member accounts of the organization.</p> <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>If this parameter is omitted, recommendations for member accounts of the organization aren\'t included in the export file.</p> <p>If this parameter or the account ID parameter is omitted, recommendations for member accounts aren\'t included in the export.</p>', 'ExportLambdaFunctionRecommendationsRequest$includeMemberAccounts' => '<p>Indicates whether to include recommendations for resources in all member accounts of the organization if your account is the management account of an organization.</p> <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>Recommendations for member accounts of the organization are not included in the export file if this parameter is omitted.</p> <p>This parameter cannot be specified together with the account IDs parameter. The parameters are mutually exclusive.</p> <p>Recommendations for member accounts are not included in the export if this parameter, or the account IDs parameter, is omitted.</p>', 'ExportLicenseRecommendationsRequest$includeMemberAccounts' => '<p>Indicates whether to include recommendations for resources in all member accounts of the organization if your account is the management account of an organization.</p> <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>If this parameter is omitted, recommendations for member accounts of the organization aren\'t included in the export file .</p> <p>This parameter cannot be specified together with the account IDs parameter. The parameters are mutually exclusive.</p>', 'ExportRDSDatabaseRecommendationsRequest$includeMemberAccounts' => '<p>If your account is the management account or the delegated administrator of an organization, this parameter indicates whether to include recommendations for resources in all member accounts of the organization.</p> <p>The member accounts must also be opted in to Compute Optimizer, and trusted access for Compute Optimizer must be enabled in the organization account. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access">Compute Optimizer and Amazon Web Services Organizations trusted access</a> in the <i>Compute Optimizer User Guide</i>.</p> <p>If this parameter is omitted, recommendations for member accounts of the organization aren\'t included in the export file.</p> <p>If this parameter or the account ID parameter is omitted, recommendations for member accounts aren\'t included in the export.</p>', 'UpdateEnrollmentStatusRequest$includeMemberAccounts' => '<p>Indicates whether to enroll member accounts of the organization if the account is the management account of an organization.</p>', ], ], 'InferredWorkloadSaving' => [ 'base' => '<p> The estimated monthly savings after you adjust the configurations of your instances running on the inferred workload types to the recommended configurations. If the <code>inferredWorkloadTypes</code> list contains multiple entries, then the savings are the sum of the monthly savings from instances that run the exact combination of the inferred workload types. </p>', 'refs' => [ 'InferredWorkloadSavings$member' => NULL, ], ], 'InferredWorkloadSavings' => [ 'base' => NULL, 'refs' => [ 'RecommendationSummary$inferredWorkloadSavings' => '<p> An array of objects that describes the estimated monthly saving amounts for the instances running on the specified <code>inferredWorkloadTypes</code>. The array contains the top five savings opportunites for the instances that run inferred workload types. </p>', ], ], 'InferredWorkloadType' => [ 'base' => NULL, 'refs' => [ 'InferredWorkloadTypes$member' => NULL, ], ], 'InferredWorkloadTypes' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$inferredWorkloadTypes' => '<p>The applications that might be running on the instances in the Auto Scaling group as inferred by Compute Optimizer.</p> <p>Compute Optimizer can infer if one of the following applications might be running on the instances:</p> <ul> <li> <p> <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instances.</p> </li> <li> <p> <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instances.</p> </li> <li> <p> <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instances.</p> </li> <li> <p> <code>Memcached</code> - Infers that Memcached might be running on the instances.</p> </li> <li> <p> <code>NGINX</code> - Infers that NGINX might be running on the instances.</p> </li> <li> <p> <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instances.</p> </li> <li> <p> <code>Redis</code> - Infers that Redis might be running on the instances.</p> </li> <li> <p> <code>Kafka</code> - Infers that Kafka might be running on the instance.</p> </li> <li> <p> <code>SQLServer</code> - Infers that SQLServer might be running on the instance.</p> </li> </ul>', 'InferredWorkloadSaving$inferredWorkloadTypes' => '<p>The applications that might be running on the instance as inferred by Compute Optimizer.</p> <p>Compute Optimizer can infer if one of the following applications might be running on the instance:</p> <ul> <li> <p> <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.</p> </li> <li> <p> <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.</p> </li> <li> <p> <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.</p> </li> <li> <p> <code>Memcached</code> - Infers that Memcached might be running on the instance.</p> </li> <li> <p> <code>NGINX</code> - Infers that NGINX might be running on the instance.</p> </li> <li> <p> <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.</p> </li> <li> <p> <code>Redis</code> - Infers that Redis might be running on the instance.</p> </li> <li> <p> <code>Kafka</code> - Infers that Kafka might be running on the instance.</p> </li> <li> <p> <code>SQLServer</code> - Infers that SQLServer might be running on the instance.</p> </li> </ul>', 'InstanceRecommendation$inferredWorkloadTypes' => '<p>The applications that might be running on the instance as inferred by Compute Optimizer.</p> <p>Compute Optimizer can infer if one of the following applications might be running on the instance:</p> <ul> <li> <p> <code>AmazonEmr</code> - Infers that Amazon EMR might be running on the instance.</p> </li> <li> <p> <code>ApacheCassandra</code> - Infers that Apache Cassandra might be running on the instance.</p> </li> <li> <p> <code>ApacheHadoop</code> - Infers that Apache Hadoop might be running on the instance.</p> </li> <li> <p> <code>Memcached</code> - Infers that Memcached might be running on the instance.</p> </li> <li> <p> <code>NGINX</code> - Infers that NGINX might be running on the instance.</p> </li> <li> <p> <code>PostgreSql</code> - Infers that PostgreSQL might be running on the instance.</p> </li> <li> <p> <code>Redis</code> - Infers that Redis might be running on the instance.</p> </li> <li> <p> <code>Kafka</code> - Infers that Kafka might be running on the instance.</p> </li> <li> <p> <code>SQLServer</code> - Infers that SQLServer might be running on the instance.</p> </li> </ul>', ], ], 'InferredWorkloadTypesPreference' => [ 'base' => NULL, 'refs' => [ 'EffectiveRecommendationPreferences$inferredWorkloadTypes' => '<p>Describes the activation status of the inferred workload types preference.</p> <p>A status of <code>Active</code> confirms that the preference is applied in the latest recommendation refresh. A status of <code>Inactive</code> confirms that it\'s not yet applied to recommendations.</p>', 'PutRecommendationPreferencesRequest$inferredWorkloadTypes' => '<p>The status of the inferred workload types recommendation preference to create or update.</p> <note> <p>The inferred workload type feature is active by default. To deactivate it, create a recommendation preference.</p> </note> <p>Specify the <code>Inactive</code> status to deactivate the feature, or specify <code>Active</code> to activate it.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/inferred-workload-types.html">Inferred workload types</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'RecommendationPreferencesDetail$inferredWorkloadTypes' => '<p>The status of the inferred workload types recommendation preference.</p> <p>When the recommendations page is refreshed, a status of <code>Active</code> confirms that the preference is applied to the recommendations, and a status of <code>Inactive</code> confirms that the preference isn\'t yet applied to recommendations.</p>', ], ], 'InstanceArn' => [ 'base' => NULL, 'refs' => [ 'GetEC2RecommendationProjectedMetricsRequest$instanceArn' => '<p>The Amazon Resource Name (ARN) of the instances for which to return recommendation projected metrics.</p>', 'InstanceArns$member' => NULL, 'InstanceRecommendation$instanceArn' => '<p>The Amazon Resource Name (ARN) of the current instance.</p>', ], ], 'InstanceArns' => [ 'base' => NULL, 'refs' => [ 'GetEC2InstanceRecommendationsRequest$instanceArns' => '<p>The Amazon Resource Name (ARN) of the instances for which to return recommendations.</p>', ], ], 'InstanceEstimatedMonthlySavings' => [ 'base' => '<p> An object that describes the estimated monthly savings possible by adopting Compute Optimizer’s Amazon EC2 instance recommendations. This is based on the Savings Plans and Reserved Instances pricing discounts. </p>', 'refs' => [ 'InstanceSavingsOpportunityAfterDiscounts$estimatedMonthlySavings' => '<p> An object that describes the estimated monthly savings possible by adopting Compute Optimizer’s Amazon EC2 instance recommendations. This is based on pricing after applying the Savings Plans and Reserved Instances discounts. </p>', ], ], 'InstanceIdle' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendation$idle' => '<p> Describes if an Amazon EC2 instance is idle. </p>', ], ], 'InstanceName' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendation$instanceName' => '<p>The name of the current instance.</p>', ], ], 'InstanceRecommendation' => [ 'base' => '<p>Describes an Amazon EC2 instance recommendation.</p>', 'refs' => [ 'InstanceRecommendations$member' => NULL, ], ], 'InstanceRecommendationFindingReasonCode' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendationFindingReasonCodes$member' => NULL, ], ], 'InstanceRecommendationFindingReasonCodes' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendation$findingReasonCodes' => '<p>The reason for the finding classification of the instance.</p> <p>Finding reason codes for instances include:</p> <ul> <li> <p> <b> <code>CPUOverprovisioned</code> </b> — The instance’s CPU configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>CPUUtilization</code> metric of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>CPUUnderprovisioned</code> </b> — The instance’s CPU configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better CPU performance. This is identified by analyzing the <code>CPUUtilization</code> metric of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>MemoryOverprovisioned</code> </b> — The instance’s memory configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the memory utilization metric of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>MemoryUnderprovisioned</code> </b> — The instance’s memory configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better memory performance. This is identified by analyzing the memory utilization metric of the current instance during the look-back period.</p> <note> <p>Memory utilization is analyzed only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling memory utilization with the Amazon CloudWatch Agent</a> in the <i>Compute Optimizer User Guide</i>. On Linux instances, Compute Optimizer analyses the <code>mem_used_percent</code> metric in the <code>CWAgent</code> namespace, or the legacy <code>MemoryUtilization</code> metric in the <code>System/Linux</code> namespace. On Windows instances, Compute Optimizer analyses the <code>Memory % Committed Bytes In Use</code> metric in the <code>CWAgent</code> namespace.</p> </note> </li> <li> <p> <b> <code>EBSThroughputOverprovisioned</code> </b> — The instance’s EBS throughput configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current instance during the look-back period.</p> </li> <li> <p> <b> <code>EBSThroughputUnderprovisioned</code> </b> — The instance’s EBS throughput configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better EBS throughput performance. This is identified by analyzing the <code>VolumeReadBytes</code> and <code>VolumeWriteBytes</code> metrics of EBS volumes attached to the current instance during the look-back period.</p> </li> <li> <p> <b> <code>EBSIOPSOverprovisioned</code> </b> — The instance’s EBS IOPS configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance during the look-back period.</p> </li> <li> <p> <b> <code>EBSIOPSUnderprovisioned</code> </b> — The instance’s EBS IOPS configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better EBS IOPS performance. This is identified by analyzing the <code>VolumeReadOps</code> and <code>VolumeWriteOps</code> metric of EBS volumes attached to the current instance during the look-back period.</p> </li> <li> <p> <b> <code>NetworkBandwidthOverprovisioned</code> </b> — The instance’s network bandwidth configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>NetworkBandwidthUnderprovisioned</code> </b> — The instance’s network bandwidth configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better network bandwidth performance. This is identified by analyzing the <code>NetworkIn</code> and <code>NetworkOut</code> metrics of the current instance during the look-back period. This finding reason happens when the <code>NetworkIn</code> or <code>NetworkOut</code> performance of an instance is impacted.</p> </li> <li> <p> <b> <code>NetworkPPSOverprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>NetworkPPSUnderprovisioned</code> </b> — The instance’s network PPS (packets per second) configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better network PPS performance. This is identified by analyzing the <code>NetworkPacketsIn</code> and <code>NetworkPacketsIn</code> metrics of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>DiskIOPSOverprovisioned</code> </b> — The instance’s disk IOPS configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>DiskIOPSUnderprovisioned</code> </b> — The instance’s disk IOPS configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better disk IOPS performance. This is identified by analyzing the <code>DiskReadOps</code> and <code>DiskWriteOps</code> metrics of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>DiskThroughputOverprovisioned</code> </b> — The instance’s disk throughput configuration can be sized down while still meeting the performance requirements of your workload. This is identified by analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the look-back period.</p> </li> <li> <p> <b> <code>DiskThroughputUnderprovisioned</code> </b> — The instance’s disk throughput configuration doesn\'t meet the performance requirements of your workload and there is an alternative instance type that provides better disk throughput performance. This is identified by analyzing the <code>DiskReadBytes</code> and <code>DiskWriteBytes</code> metrics of the current instance during the look-back period.</p> </li> </ul> <note> <p>For more information about instance metrics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/viewing_metrics_with_cloudwatch.html">List the available CloudWatch metrics for your instances</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>. For more information about EBS volume metrics, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using_cloudwatch_ebs.html">Amazon CloudWatch metrics for Amazon EBS</a> in the <i>Amazon Elastic Compute Cloud User Guide</i>.</p> </note>', ], ], 'InstanceRecommendationOption' => [ 'base' => '<p>Describes a recommendation option for an Amazon EC2 instance.</p>', 'refs' => [ 'RecommendationOptions$member' => NULL, ], ], 'InstanceRecommendations' => [ 'base' => NULL, 'refs' => [ 'GetEC2InstanceRecommendationsResponse$instanceRecommendations' => '<p>An array of objects that describe instance recommendations.</p>', ], ], 'InstanceSavingsEstimationMode' => [ 'base' => '<p> Describes the savings estimation mode used for calculating savings opportunity for Amazon EC2 instances. </p>', 'refs' => [ 'EffectiveRecommendationPreferences$savingsEstimationMode' => '<p> Describes the savings estimation mode applied for calculating savings opportunity for a resource. </p>', ], ], 'InstanceSavingsEstimationModeSource' => [ 'base' => NULL, 'refs' => [ 'InstanceSavingsEstimationMode$source' => '<p> Describes the source for calculating the savings opportunity for Amazon EC2 instances. </p>', ], ], 'InstanceSavingsOpportunityAfterDiscounts' => [ 'base' => '<p> Describes the savings opportunity for instance recommendations after applying the Savings Plans and Reserved Instances discounts. </p> <p>Savings opportunity after discounts represents the estimated monthly savings you can achieve by implementing Compute Optimizer recommendations.</p>', 'refs' => [ 'InstanceRecommendationOption$savingsOpportunityAfterDiscounts' => '<p> An object that describes the savings opportunity for the instance recommendation option that includes Savings Plans and Reserved Instances discounts. Savings opportunity includes the estimated monthly savings and percentage. </p>', ], ], 'InstanceState' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendation$instanceState' => '<p> The state of the instance when the recommendation was generated. </p>', ], ], 'InstanceType' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupConfiguration$instanceType' => '<p>The instance type for the Auto Scaling group.</p>', 'InstanceRecommendationOption$instanceType' => '<p>The instance type of the instance recommendation.</p>', 'LicenseConfiguration$instanceType' => '<p> The instance type used in the license. </p>', ], ], 'InternalServerException' => [ 'base' => '<p>An internal error has occurred. Try your call again.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>The value supplied for the input parameter is out of range or not valid.</p>', 'refs' => [], ], 'JobFilter' => [ 'base' => '<p>Describes a filter that returns a more specific list of recommendation export jobs. Use this filter with the <a>DescribeRecommendationExportJobs</a> action.</p> <p>You can use <code>EBSFilter</code> with the <a>GetEBSVolumeRecommendations</a> action, <code>LambdaFunctionRecommendationFilter</code> with the <a>GetLambdaFunctionRecommendations</a> action, and <code>Filter</code> with the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p>', 'refs' => [ 'JobFilters$member' => NULL, ], ], 'JobFilterName' => [ 'base' => NULL, 'refs' => [ 'JobFilter$name' => '<p>The name of the filter.</p> <p>Specify <code>ResourceType</code> to return export jobs of a specific resource type (for example, <code>Ec2Instance</code>).</p> <p>Specify <code>JobStatus</code> to return export jobs with a specific status (e.g, <code>Complete</code>).</p>', ], ], 'JobFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeRecommendationExportJobsRequest$filters' => '<p>An array of objects to specify a filter that returns a more specific list of export jobs.</p>', ], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'ExportAutoScalingGroupRecommendationsResponse$jobId' => '<p>The identification number of the export job.</p> <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job ID to view the status of an export job.</p>', 'ExportEBSVolumeRecommendationsResponse$jobId' => '<p>The identification number of the export job.</p> <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job ID to view the status of an export job.</p>', 'ExportEC2InstanceRecommendationsResponse$jobId' => '<p>The identification number of the export job.</p> <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job ID to view the status of an export job.</p>', 'ExportECSServiceRecommendationsResponse$jobId' => '<p> The identification number of the export job. </p> <p>To view the status of an export job, use the <a>DescribeRecommendationExportJobs</a> action and specify the job ID. </p>', 'ExportLambdaFunctionRecommendationsResponse$jobId' => '<p>The identification number of the export job.</p> <p>Use the <a>DescribeRecommendationExportJobs</a> action, and specify the job ID to view the status of an export job.</p>', 'ExportLicenseRecommendationsResponse$jobId' => '<p> The identification number of the export job. </p> <p>To view the status of an export job, use the <a>DescribeRecommendationExportJobs</a> action and specify the job ID.</p>', 'ExportRDSDatabaseRecommendationsResponse$jobId' => '<p> The identification number of the export job. </p> <p>To view the status of an export job, use the <a>DescribeRecommendationExportJobs</a> action and specify the job ID. </p>', 'JobIds$member' => NULL, 'RecommendationExportJob$jobId' => '<p>The identification number of the export job.</p>', ], ], 'JobIds' => [ 'base' => NULL, 'refs' => [ 'DescribeRecommendationExportJobsRequest$jobIds' => '<p>The identification numbers of the export jobs to return.</p> <p>An export job ID is returned when you create an export using the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions.</p> <p>All export jobs created in the last seven days are returned if this parameter is omitted.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'RecommendationExportJob$status' => '<p>The status of the export job.</p>', ], ], 'LambdaEffectiveRecommendationPreferences' => [ 'base' => '<p> Describes the effective recommendation preferences for Lambda functions. </p>', 'refs' => [ 'LambdaFunctionRecommendation$effectiveRecommendationPreferences' => '<p> Describes the effective recommendation preferences for Lambda functions. </p>', ], ], 'LambdaEstimatedMonthlySavings' => [ 'base' => '<p> Describes the estimated monthly savings possible for Lambda functions by adopting Compute Optimizer recommendations. This is based on Lambda functions pricing after applying Savings Plans discounts. </p>', 'refs' => [ 'LambdaSavingsOpportunityAfterDiscounts$estimatedMonthlySavings' => '<p> The estimated monthly savings possible by adopting Compute Optimizer’s Lambda function recommendations. This includes any applicable Savings Plans discounts. </p>', ], ], 'LambdaFunctionMemoryMetricName' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionMemoryProjectedMetric$name' => '<p>The name of the projected utilization metric.</p>', ], ], 'LambdaFunctionMemoryMetricStatistic' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionMemoryProjectedMetric$statistic' => '<p>The statistic of the projected utilization metric.</p>', ], ], 'LambdaFunctionMemoryProjectedMetric' => [ 'base' => '<p>Describes a projected utilization metric of an Lambda function recommendation option.</p>', 'refs' => [ 'LambdaFunctionMemoryProjectedMetrics$member' => NULL, ], ], 'LambdaFunctionMemoryProjectedMetrics' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionMemoryRecommendationOption$projectedUtilizationMetrics' => '<p>An array of objects that describe the projected utilization metrics of the function recommendation option.</p>', ], ], 'LambdaFunctionMemoryRecommendationOption' => [ 'base' => '<p>Describes a recommendation option for an Lambda function.</p>', 'refs' => [ 'LambdaFunctionMemoryRecommendationOptions$member' => NULL, ], ], 'LambdaFunctionMemoryRecommendationOptions' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendation$memorySizeRecommendationOptions' => '<p>An array of objects that describe the memory configuration recommendation options for the function.</p>', ], ], 'LambdaFunctionMetricName' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionUtilizationMetric$name' => '<p>The name of the utilization metric.</p> <p>The following utilization metrics are available:</p> <ul> <li> <p> <code>Duration</code> - The amount of time that your function code spends processing an event.</p> </li> <li> <p> <code>Memory</code> - The amount of memory used per invocation.</p> </li> </ul>', ], ], 'LambdaFunctionMetricStatistic' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionUtilizationMetric$statistic' => '<p>The statistic of the utilization metric.</p> <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the <code>Maximum</code> statistic, which is the highest value observed during the specified period.</p> <p>The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code> statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p>', ], ], 'LambdaFunctionRecommendation' => [ 'base' => '<p>Describes an Lambda function recommendation.</p>', 'refs' => [ 'LambdaFunctionRecommendations$member' => NULL, ], ], 'LambdaFunctionRecommendationFilter' => [ 'base' => '<p>Describes a filter that returns a more specific list of Lambda function recommendations. Use this filter with the <a>GetLambdaFunctionRecommendations</a> action.</p> <p>You can use <code>EBSFilter</code> with the <a>GetEBSVolumeRecommendations</a> action, <code>JobFilter</code> with the <a>DescribeRecommendationExportJobs</a> action, and <code>Filter</code> with the <a>GetAutoScalingGroupRecommendations</a> and <a>GetEC2InstanceRecommendations</a> actions.</p>', 'refs' => [ 'LambdaFunctionRecommendationFilters$member' => NULL, ], ], 'LambdaFunctionRecommendationFilterName' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendationFilter$name' => '<p>The name of the filter.</p> <p>Specify <code>Finding</code> to return recommendations with a specific finding classification (for example, <code>NotOptimized</code>).</p> <p>Specify <code>FindingReasonCode</code> to return recommendations with a specific finding reason code (for example, <code>MemoryUnderprovisioned</code>).</p> <p>You can filter your Lambda function recommendations by <code>tag:key</code> and <code>tag-key</code> tags.</p> <p>A <code>tag:key</code> is a key and value combination of a tag assigned to your Lambda function recommendations. Use the tag key in the filter name and the tag value as the filter value. For example, to find all Lambda function recommendations that have a tag with the key of <code>Owner</code> and the value of <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> <p>A <code>tag-key</code> is the key of a tag assigned to your Lambda function recommendations. Use this filter to find all of your Lambda function recommendations that have a tag with a specific key. This doesn’t consider the tag value. For example, you can find your Lambda function recommendations with a tag key value of <code>Owner</code> or without any tag keys assigned.</p>', ], ], 'LambdaFunctionRecommendationFilters' => [ 'base' => NULL, 'refs' => [ 'ExportLambdaFunctionRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that exports a more specific set of Lambda function recommendations.</p>', 'GetLambdaFunctionRecommendationsRequest$filters' => '<p>An array of objects to specify a filter that returns a more specific list of function recommendations.</p>', ], ], 'LambdaFunctionRecommendationFinding' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendation$finding' => '<p>The finding classification of the function.</p> <p>Findings for functions include:</p> <ul> <li> <p> <b> <code>Optimized</code> </b> — The function is correctly provisioned to run your workload based on its current configuration and its utilization history. This finding classification does not include finding reason codes.</p> </li> <li> <p> <b> <code>NotOptimized</code> </b> — The function is performing at a higher level (over-provisioned) or at a lower level (under-provisioned) than required for your workload because its current configuration is not optimal. Over-provisioned resources might lead to unnecessary infrastructure cost, and under-provisioned resources might lead to poor application performance. This finding classification can include the <code>MemoryUnderprovisioned</code> and <code>MemoryUnderprovisioned</code> finding reason codes.</p> </li> <li> <p> <b> <code>Unavailable</code> </b> — Compute Optimizer was unable to generate a recommendation for the function. This could be because the function has not accumulated sufficient metric data, or the function does not qualify for a recommendation. This finding classification can include the <code>InsufficientData</code> and <code>Inconclusive</code> finding reason codes.</p> <note> <p>Functions with a finding of unavailable are not returned unless you specify the <code>filter</code> parameter with a value of <code>Unavailable</code> in your <code>GetLambdaFunctionRecommendations</code> request.</p> </note> </li> </ul>', ], ], 'LambdaFunctionRecommendationFindingReasonCode' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendationFindingReasonCodes$member' => NULL, ], ], 'LambdaFunctionRecommendationFindingReasonCodes' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendation$findingReasonCodes' => '<p>The reason for the finding classification of the function.</p> <note> <p>Functions that have a finding classification of <code>Optimized</code> don\'t have a finding reason code.</p> </note> <p>Finding reason codes for functions include:</p> <ul> <li> <p> <b> <code>MemoryOverprovisioned</code> </b> — The function is over-provisioned when its memory configuration can be sized down while still meeting the performance requirements of your workload. An over-provisioned function might lead to unnecessary infrastructure cost. This finding reason code is part of the <code>NotOptimized</code> finding classification.</p> </li> <li> <p> <b> <code>MemoryUnderprovisioned</code> </b> — The function is under-provisioned when its memory configuration doesn\'t meet the performance requirements of the workload. An under-provisioned function might lead to poor application performance. This finding reason code is part of the <code>NotOptimized</code> finding classification.</p> </li> <li> <p> <b> <code>InsufficientData</code> </b> — The function does not have sufficient metric data for Compute Optimizer to generate a recommendation. For more information, see the <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html">Supported resources and requirements</a> in the <i>Compute Optimizer User Guide</i>. This finding reason code is part of the <code>Unavailable</code> finding classification.</p> </li> <li> <p> <b> <code>Inconclusive</code> </b> — The function does not qualify for a recommendation because Compute Optimizer cannot generate a recommendation with a high degree of confidence. This finding reason code is part of the <code>Unavailable</code> finding classification.</p> </li> </ul>', ], ], 'LambdaFunctionRecommendations' => [ 'base' => NULL, 'refs' => [ 'GetLambdaFunctionRecommendationsResponse$lambdaFunctionRecommendations' => '<p>An array of objects that describe function recommendations.</p>', ], ], 'LambdaFunctionUtilizationMetric' => [ 'base' => '<p>Describes a utilization metric of an Lambda function.</p>', 'refs' => [ 'LambdaFunctionUtilizationMetrics$member' => NULL, ], ], 'LambdaFunctionUtilizationMetrics' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendation$utilizationMetrics' => '<p>An array of objects that describe the utilization metrics of the function.</p>', ], ], 'LambdaSavingsEstimationMode' => [ 'base' => '<p> Describes the savings estimation used for calculating savings opportunity for Lambda functions. </p>', 'refs' => [ 'LambdaEffectiveRecommendationPreferences$savingsEstimationMode' => '<p> Describes the savings estimation mode applied for calculating savings opportunity for Lambda functions. </p>', ], ], 'LambdaSavingsEstimationModeSource' => [ 'base' => NULL, 'refs' => [ 'LambdaSavingsEstimationMode$source' => '<p> Describes the source for calculation of savings opportunity for Lambda functions. </p>', ], ], 'LambdaSavingsOpportunityAfterDiscounts' => [ 'base' => '<p> Describes the savings opportunity for Lambda functions recommendations after applying Savings Plans discounts. </p> <p>Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation.</p>', 'refs' => [ 'LambdaFunctionMemoryRecommendationOption$savingsOpportunityAfterDiscounts' => '<p> An object that describes the savings opportunity for the Lambda recommendation option which includes Saving Plans discounts. Savings opportunity includes the estimated monthly savings and percentage. </p>', ], ], 'LastRefreshTimestamp' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$lastRefreshTimestamp' => '<p>The timestamp of when the Auto Scaling group recommendation was last generated.</p>', 'ECSServiceRecommendation$lastRefreshTimestamp' => '<p> The timestamp of when the Amazon ECS service recommendation was last generated. </p>', 'InstanceRecommendation$lastRefreshTimestamp' => '<p>The timestamp of when the instance recommendation was last generated.</p>', 'LambdaFunctionRecommendation$lastRefreshTimestamp' => '<p>The timestamp of when the function recommendation was last generated.</p>', 'LicenseRecommendation$lastRefreshTimestamp' => '<p> The timestamp of when the license recommendation was last generated. </p>', 'RDSDBRecommendation$lastRefreshTimestamp' => '<p> The timestamp of when the Amazon RDS recommendation was last generated. </p>', 'VolumeRecommendation$lastRefreshTimestamp' => '<p>The timestamp of when the volume recommendation was last generated.</p>', ], ], 'LastUpdatedTimestamp' => [ 'base' => NULL, 'refs' => [ 'AccountEnrollmentStatus$lastUpdatedTimestamp' => '<p>The Unix epoch timestamp, in seconds, of when the account enrollment status was last updated.</p>', 'GetEnrollmentStatusResponse$lastUpdatedTimestamp' => '<p>The Unix epoch timestamp, in seconds, of when the account enrollment status was last updated.</p>', 'RecommendationExportJob$lastUpdatedTimestamp' => '<p>The timestamp of when the export job was last updated.</p>', ], ], 'LicenseConfiguration' => [ 'base' => '<p> Describes the configuration of a license for an Amazon EC2 instance. </p>', 'refs' => [ 'LicenseRecommendation$currentLicenseConfiguration' => '<p> An object that describes the current configuration of an instance that runs on a license. </p>', ], ], 'LicenseEdition' => [ 'base' => NULL, 'refs' => [ 'LicenseConfiguration$licenseEdition' => '<p> The edition of the license for the application that runs on the instance. </p>', 'LicenseRecommendationOption$licenseEdition' => '<p> The recommended edition of the license for the application that runs on the instance. </p>', ], ], 'LicenseFinding' => [ 'base' => NULL, 'refs' => [ 'LicenseRecommendation$finding' => '<p> The finding classification for an instance that runs on a license. </p> <p>Findings include:</p> <ul> <li> <p> <code>InsufficentMetrics</code> — When Compute Optimizer detects that your CloudWatch Application Insights isn\'t enabled or is enabled with insufficient permissions. </p> </li> <li> <p> <code>NotOptimized</code> — When Compute Optimizer detects that your EC2 infrastructure isn\'t using any of the SQL server license features you\'re paying for, a license is considered not optimized.</p> </li> <li> <p> <code>Optimized</code> — When Compute Optimizer detects that all specifications of your license meet the performance requirements of your workload. </p> </li> </ul>', ], ], 'LicenseFindingReasonCode' => [ 'base' => NULL, 'refs' => [ 'LicenseFindingReasonCodes$member' => NULL, ], ], 'LicenseFindingReasonCodes' => [ 'base' => NULL, 'refs' => [ 'LicenseRecommendation$findingReasonCodes' => '<p> The reason for the finding classification for an instance that runs on a license. </p> <p>Finding reason codes include:</p> <ul> <li> <p> <code>Optimized</code> — All specifications of your license meet the performance requirements of your workload. </p> </li> <li> <p> <code>LicenseOverprovisioned</code> — A license is considered over-provisioned when your license can be downgraded while still meeting the performance requirements of your workload.</p> </li> <li> <p> <code>InvalidCloudwatchApplicationInsights</code> — CloudWatch Application Insights isn\'t configured properly.</p> </li> <li> <p> <code>CloudwatchApplicationInsightsError</code> — There is a CloudWatch Application Insights error. </p> </li> </ul>', ], ], 'LicenseModel' => [ 'base' => NULL, 'refs' => [ 'LicenseConfiguration$licenseModel' => '<p> The license type associated with the instance. </p>', 'LicenseRecommendationOption$licenseModel' => '<p> The recommended license type associated with the instance. </p>', ], ], 'LicenseName' => [ 'base' => NULL, 'refs' => [ 'LicenseConfiguration$licenseName' => '<p> The name of the license for the application that runs on the instance. </p>', ], ], 'LicenseRecommendation' => [ 'base' => '<p> Describes a license recommendation for an EC2 instance. </p>', 'refs' => [ 'LicenseRecommendations$member' => NULL, ], ], 'LicenseRecommendationFilter' => [ 'base' => '<p> Describes a filter that returns a more specific list of license recommendations. Use this filter with the <code>GetLicenseRecommendation</code> action. </p>', 'refs' => [ 'LicenseRecommendationFilters$member' => NULL, ], ], 'LicenseRecommendationFilterName' => [ 'base' => NULL, 'refs' => [ 'LicenseRecommendationFilter$name' => '<p>The name of the filter.</p> <p>Specify <code>Finding</code> to return recommendations with a specific finding classification.</p> <p>Specify <code>FindingReasonCode</code> to return recommendations with a specific finding reason code.</p> <p>You can filter your license recommendations by <code>tag:key</code> and <code>tag-key</code> tags.</p> <p>A <code>tag:key</code> is a key and value combination of a tag assigned to your license recommendations. Use the tag key in the filter name and the tag value as the filter value. For example, to find all license recommendations that have a tag with the key of <code>Owner</code> and the value of <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> <p>A <code>tag-key</code> is the key of a tag assigned to your license recommendations. Use this filter to find all of your license recommendations that have a tag with a specific key. This doesn’t consider the tag value. For example, you can find your license recommendations with a tag key value of <code>Owner</code> or without any tag keys assigned.</p>', ], ], 'LicenseRecommendationFilters' => [ 'base' => NULL, 'refs' => [ 'ExportLicenseRecommendationsRequest$filters' => '<p> An array of objects to specify a filter that exports a more specific set of license recommendations. </p>', 'GetLicenseRecommendationsRequest$filters' => '<p> An array of objects to specify a filter that returns a more specific list of license recommendations. </p>', ], ], 'LicenseRecommendationOption' => [ 'base' => '<p> Describes the recommendation options for licenses. </p>', 'refs' => [ 'LicenseRecommendationOptions$member' => NULL, ], ], 'LicenseRecommendationOptions' => [ 'base' => NULL, 'refs' => [ 'LicenseRecommendation$licenseRecommendationOptions' => '<p> An array of objects that describe the license recommendation options. </p>', ], ], 'LicenseRecommendations' => [ 'base' => NULL, 'refs' => [ 'GetLicenseRecommendationsResponse$licenseRecommendations' => '<p> An array of objects that describe license recommendations. </p>', ], ], 'LicenseVersion' => [ 'base' => NULL, 'refs' => [ 'LicenseConfiguration$licenseVersion' => '<p> The version of the license for the application that runs on the instance. </p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request exceeds a limit of the service.</p>', 'refs' => [], ], 'LookBackPeriodInDays' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$lookBackPeriodInDays' => '<p>The number of days for which utilization metrics were analyzed for the Auto Scaling group.</p>', 'ECSServiceRecommendation$lookbackPeriodInDays' => '<p> The number of days the Amazon ECS service utilization metrics were analyzed. </p>', 'InstanceRecommendation$lookBackPeriodInDays' => '<p>The number of days for which utilization metrics were analyzed for the instance.</p>', 'LambdaFunctionRecommendation$lookbackPeriodInDays' => '<p>The number of days for which utilization metrics were analyzed for the function.</p>', 'LicenseRecommendation$lookbackPeriodInDays' => '<p> The number of days for which utilization metrics were analyzed for an instance that runs on a license. </p>', 'RDSDBRecommendation$lookbackPeriodInDays' => '<p> The number of days the Amazon RDS utilization metrics were analyzed. </p>', 'VolumeRecommendation$lookBackPeriodInDays' => '<p>The number of days for which utilization metrics were analyzed for the volume.</p>', ], ], 'LookBackPeriodPreference' => [ 'base' => NULL, 'refs' => [ 'EffectiveRecommendationPreferences$lookBackPeriod' => '<p> The number of days the utilization metrics of the Amazon Web Services resource are analyzed. </p>', 'GetEffectiveRecommendationPreferencesResponse$lookBackPeriod' => '<p> The number of days the utilization metrics of the Amazon Web Services resource are analyzed. </p> <p>To validate that the preference is applied to your last generated set of recommendations, review the <code>effectiveRecommendationPreferences</code> value in the response of the GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.</p>', 'PutRecommendationPreferencesRequest$lookBackPeriod' => '<p> The preference to control the number of days the utilization metrics of the Amazon Web Services resource are analyzed. When this preference isn\'t specified, we use the default value <code>DAYS_14</code>. </p> <p>You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types. </p> <note> <ul> <li> <p>Amazon EC2 instance lookback preferences can be set at the organization, account, and resource levels.</p> </li> <li> <p>Auto Scaling group lookback preferences can only be set at the resource level.</p> </li> </ul> </note>', 'RDSEffectiveRecommendationPreferences$lookBackPeriod' => '<p> The number of days the utilization metrics of the Amazon RDS are analyzed. </p>', 'RecommendationPreferencesDetail$lookBackPeriod' => '<p> The preference to control the number of days the utilization metrics of the Amazon Web Services resource are analyzed. If the preference isn’t set, this object is null. </p>', ], ], 'Low' => [ 'base' => NULL, 'refs' => [ 'CurrentPerformanceRiskRatings$low' => '<p>A count of the applicable resource types with a low performance risk rating.</p>', ], ], 'LowerBoundValue' => [ 'base' => NULL, 'refs' => [ 'ECSServiceProjectedUtilizationMetric$lowerBoundValue' => '<p> The lower bound values for the projected utilization metrics. </p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeRecommendationExportJobsRequest$maxResults' => '<p>The maximum number of export jobs to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetAutoScalingGroupRecommendationsRequest$maxResults' => '<p>The maximum number of Auto Scaling group recommendations to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetEBSVolumeRecommendationsRequest$maxResults' => '<p>The maximum number of volume recommendations to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetEC2InstanceRecommendationsRequest$maxResults' => '<p>The maximum number of instance recommendations to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetECSServiceRecommendationsRequest$maxResults' => '<p> The maximum number of Amazon ECS service recommendations to return with a single request. </p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetEnrollmentStatusesForOrganizationRequest$maxResults' => '<p>The maximum number of account enrollment statuses to return with a single request. You can specify up to 100 statuses to return with each request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetLambdaFunctionRecommendationsRequest$maxResults' => '<p>The maximum number of function recommendations to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetLicenseRecommendationsRequest$maxResults' => '<p> The maximum number of license recommendations to return with a single request. </p> <p> To retrieve the remaining results, make another request with the returned <code>nextToken</code> value. </p>', 'GetRDSDatabaseRecommendationsRequest$maxResults' => '<p>The maximum number of Amazon RDS recommendations to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetRecommendationPreferencesRequest$maxResults' => '<p>The maximum number of recommendation preferences to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', 'GetRecommendationSummariesRequest$maxResults' => '<p>The maximum number of recommendation summaries to return with a single request.</p> <p>To retrieve the remaining results, make another request with the returned <code>nextToken</code> value.</p>', ], ], 'MaxSize' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupConfiguration$maxSize' => '<p>The maximum size, or maximum number of instances, for the Auto Scaling group.</p>', ], ], 'Medium' => [ 'base' => NULL, 'refs' => [ 'CurrentPerformanceRiskRatings$medium' => '<p>A count of the applicable resource types with a medium performance risk rating.</p>', ], ], 'MemberAccountsEnrolled' => [ 'base' => NULL, 'refs' => [ 'GetEnrollmentStatusResponse$memberAccountsEnrolled' => '<p>Confirms the enrollment status of member accounts of the organization, if the account is a management account of an organization.</p>', ], ], 'MemorySize' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendedOptionProjectedMetric$recommendedMemorySize' => '<p> The recommended memory size for the Amazon ECS service. </p>', 'LambdaFunctionMemoryRecommendationOption$memorySize' => '<p>The memory size, in MB, of the function recommendation option.</p>', 'LambdaFunctionRecommendation$currentMemorySize' => '<p>The amount of memory, in MB, that\'s allocated to the current function.</p>', ], ], 'MemorySizeConfiguration' => [ 'base' => '<p> The memory size configurations of a container. </p>', 'refs' => [ 'ContainerConfiguration$memorySizeConfiguration' => '<p> The memory size configurations for the container. </p>', 'ContainerRecommendation$memorySizeConfiguration' => '<p> The recommended memory size configurations for the container. </p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationError$message' => '<p>The message, or reason, for the error.</p>', ], ], 'MetadataKey' => [ 'base' => NULL, 'refs' => [ 'S3Destination$metadataKey' => '<p>The Amazon S3 bucket key of a metadata file.</p> <p>The key uniquely identifies the object, or metadata file, in the S3 bucket.</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'ProjectedMetric$name' => '<p>The name of the projected utilization metric.</p> <p>The following projected utilization metrics are returned:</p> <ul> <li> <p> <code>Cpu</code> - The projected percentage of allocated EC2 compute units that would be in use on the recommendation option had you used that resource during the analyzed period. This metric identifies the processing power required to run an application on the recommendation option.</p> <p>Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when the instance is not allocated a full processor core.</p> </li> <li> <p> <code>Memory</code> - The percentage of memory that would be in use on the recommendation option had you used that resource during the analyzed period. This metric identifies the amount of memory required to run an application on the recommendation option.</p> <p>Units: Percent</p> <note> <p>The <code>Memory</code> metric is only returned for resources with the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note> </li> <li> <p> <code>GPU</code> - The projected percentage of allocated GPUs if you adjust your configurations to Compute Optimizer\'s recommendation option.</p> </li> <li> <p> <code>GPU_MEMORY</code> - The projected percentage of total GPU memory if you adjust your configurations to Compute Optimizer\'s recommendation option.</p> <note> <p>The <code>GPU</code> and <code>GPU_MEMORY</code> metrics are only returned for resources with the unified CloudWatch Agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling NVIDIA GPU utilization with the CloudWatch Agent</a>.</p> </note> </li> </ul>', 'UtilizationMetric$name' => '<p>The name of the utilization metric.</p> <p>The following utilization metrics are available:</p> <ul> <li> <p> <code>Cpu</code> - The percentage of allocated EC2 compute units that are currently in use on the instance. This metric identifies the processing power required to run an application on the instance.</p> <p>Depending on the instance type, tools in your operating system can show a lower percentage than CloudWatch when the instance is not allocated a full processor core.</p> <p>Units: Percent</p> </li> <li> <p> <code>Memory</code> - The percentage of memory that is currently in use on the instance. This metric identifies the amount of memory required to run an application on the instance.</p> <p>Units: Percent</p> <note> <p>The <code>Memory</code> metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note> </li> <li> <p> <code>GPU</code> - The percentage of allocated GPUs that currently run on the instance.</p> </li> <li> <p> <code>GPU_MEMORY</code> - The percentage of total GPU memory that currently runs on the instance.</p> <note> <p>The <code>GPU</code> and <code>GPU_MEMORY</code> metrics are only returned for resources with the unified CloudWatch Agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling NVIDIA GPU utilization with the CloudWatch Agent</a>.</p> </note> </li> <li> <p> <code>EBS_READ_OPS_PER_SECOND</code> - The completed read operations from all EBS volumes attached to the instance in a specified period of time.</p> <p>Unit: Count</p> </li> <li> <p> <code>EBS_WRITE_OPS_PER_SECOND</code> - The completed write operations to all EBS volumes attached to the instance in a specified period of time.</p> <p>Unit: Count</p> </li> <li> <p> <code>EBS_READ_BYTES_PER_SECOND</code> - The bytes read from all EBS volumes attached to the instance in a specified period of time.</p> <p>Unit: Bytes</p> </li> <li> <p> <code>EBS_WRITE_BYTES_PER_SECOND</code> - The bytes written to all EBS volumes attached to the instance in a specified period of time.</p> <p>Unit: Bytes</p> </li> <li> <p> <code>DISK_READ_OPS_PER_SECOND</code> - The completed read operations from all instance store volumes available to the instance in a specified period of time.</p> <p>If there are no instance store volumes, either the value is <code>0</code> or the metric is not reported.</p> </li> <li> <p> <code>DISK_WRITE_OPS_PER_SECOND</code> - The completed write operations from all instance store volumes available to the instance in a specified period of time.</p> <p>If there are no instance store volumes, either the value is <code>0</code> or the metric is not reported.</p> </li> <li> <p> <code>DISK_READ_BYTES_PER_SECOND</code> - The bytes read from all instance store volumes available to the instance. This metric is used to determine the volume of the data the application reads from the disk of the instance. This can be used to determine the speed of the application.</p> <p>If there are no instance store volumes, either the value is <code>0</code> or the metric is not reported.</p> </li> <li> <p> <code>DISK_WRITE_BYTES_PER_SECOND</code> - The bytes written to all instance store volumes available to the instance. This metric is used to determine the volume of the data the application writes onto the disk of the instance. This can be used to determine the speed of the application.</p> <p>If there are no instance store volumes, either the value is <code>0</code> or the metric is not reported.</p> </li> <li> <p> <code>NETWORK_IN_BYTES_PER_SECOND</code> - The number of bytes received by the instance on all network interfaces. This metric identifies the volume of incoming network traffic to a single instance.</p> </li> <li> <p> <code>NETWORK_OUT_BYTES_PER_SECOND</code> - The number of bytes sent out by the instance on all network interfaces. This metric identifies the volume of outgoing network traffic from a single instance.</p> </li> <li> <p> <code>NETWORK_PACKETS_IN_PER_SECOND</code> - The number of packets received by the instance on all network interfaces. This metric identifies the volume of incoming traffic in terms of the number of packets on a single instance.</p> </li> <li> <p> <code>NETWORK_PACKETS_OUT_PER_SECOND</code> - The number of packets sent out by the instance on all network interfaces. This metric identifies the volume of outgoing traffic in terms of the number of packets on a single instance.</p> </li> </ul>', ], ], 'MetricProviderArn' => [ 'base' => NULL, 'refs' => [ 'MetricSource$providerArn' => '<p> The ARN of the metric source provider. </p>', ], ], 'MetricSource' => [ 'base' => '<p> The list of metric sources required to generate recommendations for commercial software licenses. </p>', 'refs' => [ 'MetricsSource$member' => NULL, ], ], 'MetricSourceProvider' => [ 'base' => NULL, 'refs' => [ 'MetricSource$provider' => '<p> The name of the metric source provider. </p>', ], ], 'MetricStatistic' => [ 'base' => NULL, 'refs' => [ 'EBSUtilizationMetric$statistic' => '<p>The statistic of the utilization metric.</p> <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the <code>Maximum</code> statistic, which is the highest value observed during the specified period.</p> <p>The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code> statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p>', 'GetEC2RecommendationProjectedMetricsRequest$stat' => '<p>The statistic of the projected metrics.</p>', 'GetECSServiceRecommendationProjectedMetricsRequest$stat' => '<p> The statistic of the projected metrics. </p>', 'GetRDSDatabaseRecommendationProjectedMetricsRequest$stat' => '<p> The statistic of the projected metrics. </p>', 'UtilizationMetric$statistic' => '<p>The statistic of the utilization metric.</p> <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the <code>Maximum</code> statistic, which is the highest value observed during the specified period.</p> <p>The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code> statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p>', ], ], 'MetricValue' => [ 'base' => NULL, 'refs' => [ 'EBSUtilizationMetric$value' => '<p>The value of the utilization metric.</p>', 'ECSServiceUtilizationMetric$value' => '<p> The value of the utilization metric. </p>', 'LambdaFunctionMemoryProjectedMetric$value' => '<p>The values of the projected utilization metrics.</p>', 'LambdaFunctionUtilizationMetric$value' => '<p>The value of the utilization metric.</p>', 'MetricValues$member' => NULL, 'RDSDBUtilizationMetric$value' => '<p> The value of the utilization metric. </p>', 'UtilizationMetric$value' => '<p>The value of the utilization metric.</p>', ], ], 'MetricValues' => [ 'base' => NULL, 'refs' => [ 'ECSServiceProjectedMetric$upperBoundValues' => '<p> The upper bound values for the projected metric. </p>', 'ECSServiceProjectedMetric$lowerBoundValues' => '<p> The lower bound values for the projected metric. </p>', 'ProjectedMetric$values' => '<p>The values of the projected utilization metrics.</p>', 'RDSDatabaseProjectedMetric$values' => '<p> The values for the projected metric. </p>', ], ], 'MetricsSource' => [ 'base' => NULL, 'refs' => [ 'LicenseConfiguration$metricsSource' => '<p> The list of metric sources required to generate recommendations for commercial software licenses. </p>', ], ], 'MigrationEffort' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendationOption$migrationEffort' => '<p>The level of effort required to migrate from the current instance type to the recommended instance type.</p> <p>For example, the migration effort is <code>Low</code> if Amazon EMR is the inferred workload type and an Amazon Web Services Graviton instance type is recommended. The migration effort is <code>Medium</code> if a workload type couldn\'t be inferred but an Amazon Web Services Graviton instance type is recommended. The migration effort is <code>VeryLow</code> if both the current and recommended instance types are of the same CPU architecture.</p>', 'InstanceRecommendationOption$migrationEffort' => '<p>The level of effort required to migrate from the current instance type to the recommended instance type.</p> <p>For example, the migration effort is <code>Low</code> if Amazon EMR is the inferred workload type and an Amazon Web Services Graviton instance type is recommended. The migration effort is <code>Medium</code> if a workload type couldn\'t be inferred but an Amazon Web Services Graviton instance type is recommended. The migration effort is <code>VeryLow</code> if both the current and recommended instance types are of the same CPU architecture.</p>', ], ], 'MinSize' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupConfiguration$minSize' => '<p>The minimum size, or minimum number of instances, for the Auto Scaling group.</p>', ], ], 'MissingAuthenticationToken' => [ 'base' => '<p>The request must contain either a valid (registered) Amazon Web Services access key ID or X.509 certificate.</p>', 'refs' => [], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeRecommendationExportJobsRequest$nextToken' => '<p>The token to advance to the next page of export jobs.</p>', 'DescribeRecommendationExportJobsResponse$nextToken' => '<p>The token to use to advance to the next page of export jobs.</p> <p>This value is null when there are no more pages of export jobs to return.</p>', 'GetAutoScalingGroupRecommendationsRequest$nextToken' => '<p>The token to advance to the next page of Auto Scaling group recommendations.</p>', 'GetAutoScalingGroupRecommendationsResponse$nextToken' => '<p>The token to use to advance to the next page of Auto Scaling group recommendations.</p> <p>This value is null when there are no more pages of Auto Scaling group recommendations to return.</p>', 'GetEBSVolumeRecommendationsRequest$nextToken' => '<p>The token to advance to the next page of volume recommendations.</p>', 'GetEBSVolumeRecommendationsResponse$nextToken' => '<p>The token to use to advance to the next page of volume recommendations.</p> <p>This value is null when there are no more pages of volume recommendations to return.</p>', 'GetEC2InstanceRecommendationsRequest$nextToken' => '<p>The token to advance to the next page of instance recommendations.</p>', 'GetEC2InstanceRecommendationsResponse$nextToken' => '<p>The token to use to advance to the next page of instance recommendations.</p> <p>This value is null when there are no more pages of instance recommendations to return.</p>', 'GetECSServiceRecommendationsRequest$nextToken' => '<p> The token to advance to the next page of Amazon ECS service recommendations. </p>', 'GetECSServiceRecommendationsResponse$nextToken' => '<p> The token to advance to the next page of Amazon ECS service recommendations. </p>', 'GetEnrollmentStatusesForOrganizationRequest$nextToken' => '<p>The token to advance to the next page of account enrollment statuses.</p>', 'GetEnrollmentStatusesForOrganizationResponse$nextToken' => '<p>The token to use to advance to the next page of account enrollment statuses.</p> <p>This value is null when there are no more pages of account enrollment statuses to return.</p>', 'GetLambdaFunctionRecommendationsRequest$nextToken' => '<p>The token to advance to the next page of function recommendations.</p>', 'GetLambdaFunctionRecommendationsResponse$nextToken' => '<p>The token to use to advance to the next page of function recommendations.</p> <p>This value is null when there are no more pages of function recommendations to return.</p>', 'GetLicenseRecommendationsRequest$nextToken' => '<p> The token to advance to the next page of license recommendations. </p>', 'GetLicenseRecommendationsResponse$nextToken' => '<p> The token to use to advance to the next page of license recommendations. </p>', 'GetRDSDatabaseRecommendationsRequest$nextToken' => '<p> The token to advance to the next page of Amazon RDS recommendations. </p>', 'GetRDSDatabaseRecommendationsResponse$nextToken' => '<p> The token to advance to the next page of Amazon RDS recommendations. </p>', 'GetRecommendationPreferencesRequest$nextToken' => '<p>The token to advance to the next page of recommendation preferences.</p>', 'GetRecommendationPreferencesResponse$nextToken' => '<p>The token to use to advance to the next page of recommendation preferences.</p> <p>This value is null when there are no more pages of recommendation preferences to return.</p>', 'GetRecommendationSummariesRequest$nextToken' => '<p>The token to advance to the next page of recommendation summaries.</p>', 'GetRecommendationSummariesResponse$nextToken' => '<p>The token to use to advance to the next page of recommendation summaries.</p> <p>This value is null when there are no more pages of recommendation summaries to return.</p>', ], ], 'NullableCpu' => [ 'base' => NULL, 'refs' => [ 'ContainerConfiguration$cpu' => '<p> The number of CPU units reserved for the container. </p>', 'ContainerRecommendation$cpu' => '<p> The recommended number of CPU units reserved for the container. </p>', 'ECSServiceRecommendationOption$cpu' => '<p> The CPU size of the Amazon ECS service recommendation option. </p>', 'ServiceConfiguration$cpu' => '<p> The number of CPU units used by the tasks in the Amazon ECS service. </p>', ], ], 'NullableIOPS' => [ 'base' => NULL, 'refs' => [ 'DBStorageConfiguration$iops' => '<p> The provisioned IOPs of the RDS storage. </p>', ], ], 'NullableMaxAllocatedStorage' => [ 'base' => NULL, 'refs' => [ 'DBStorageConfiguration$maxAllocatedStorage' => '<p> The maximum limit in gibibytes (GiB) to which Amazon RDS can automatically scale the storage of the RDS instance. </p>', ], ], 'NullableMemory' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendationOption$memory' => '<p> The memory size of the Amazon ECS service recommendation option. </p>', 'MemorySizeConfiguration$memory' => '<p> The amount of memory in the container. </p>', 'ServiceConfiguration$memory' => '<p> The amount of memory used by the tasks in the Amazon ECS service. </p>', ], ], 'NullableMemoryReservation' => [ 'base' => NULL, 'refs' => [ 'MemorySizeConfiguration$memoryReservation' => '<p> The limit of memory reserve for the container. </p>', ], ], 'NullableStorageThroughput' => [ 'base' => NULL, 'refs' => [ 'DBStorageConfiguration$storageThroughput' => '<p> The storage throughput of the RDS storage. </p>', ], ], 'NumberOfCores' => [ 'base' => NULL, 'refs' => [ 'LicenseConfiguration$numberOfCores' => '<p> The current number of cores associated with the instance. </p>', ], ], 'NumberOfInvocations' => [ 'base' => NULL, 'refs' => [ 'LambdaFunctionRecommendation$numberOfInvocations' => '<p>The number of times your function code was applied during the look-back period.</p>', ], ], 'NumberOfMemberAccountsOptedIn' => [ 'base' => NULL, 'refs' => [ 'GetEnrollmentStatusResponse$numberOfMemberAccountsOptedIn' => '<p>The count of organization member accounts that are opted in to the service, if your account is an organization management account.</p>', ], ], 'OperatingSystem' => [ 'base' => NULL, 'refs' => [ 'LicenseConfiguration$operatingSystem' => '<p> The operating system of the instance. </p>', 'LicenseRecommendationOption$operatingSystem' => '<p> The operating system of a license recommendation option. </p>', ], ], 'OptInRequiredException' => [ 'base' => '<p>The account is not opted in to Compute Optimizer.</p>', 'refs' => [], ], 'PerformanceRisk' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendationOption$performanceRisk' => '<p>The performance risk of the Auto Scaling group configuration recommendation.</p> <p>Performance risk indicates the likelihood of the recommended instance type not meeting the resource needs of your workload. Compute Optimizer calculates an individual performance risk score for each specification of the recommended instance, including CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput, and network PPS. The performance risk of the recommended instance is calculated as the maximum performance risk score across the analyzed resource specifications.</p> <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning that the recommended resource is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely you should validate whether the recommendation will meet the performance requirements of your workload before migrating your resource.</p>', 'InstanceRecommendationOption$performanceRisk' => '<p>The performance risk of the instance recommendation option.</p> <p>Performance risk indicates the likelihood of the recommended instance type not meeting the resource needs of your workload. Compute Optimizer calculates an individual performance risk score for each specification of the recommended instance, including CPU, memory, EBS throughput, EBS IOPS, disk throughput, disk IOPS, network throughput, and network PPS. The performance risk of the recommended instance is calculated as the maximum performance risk score across the analyzed resource specifications.</p> <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning that the recommended resource is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely you should validate whether the recommendation will meet the performance requirements of your workload before migrating your resource.</p>', 'RDSDBInstanceRecommendationOption$performanceRisk' => '<p> The performance risk of the RDS instance recommendation option. </p>', 'VolumeRecommendationOption$performanceRisk' => '<p>The performance risk of the volume recommendation option.</p> <p>Performance risk is the likelihood of the recommended volume type meeting the performance requirement of your workload.</p> <p>The value ranges from <code>0</code> - <code>4</code>, with <code>0</code> meaning that the recommended resource is predicted to always provide enough hardware capability. The higher the performance risk is, the more likely you should validate whether the recommendation will meet the performance requirements of your workload before migrating your resource.</p>', ], ], 'Period' => [ 'base' => NULL, 'refs' => [ 'GetEC2RecommendationProjectedMetricsRequest$period' => '<p>The granularity, in seconds, of the projected metrics data points.</p>', 'GetECSServiceRecommendationProjectedMetricsRequest$period' => '<p> The granularity, in seconds, of the projected metrics data points. </p>', 'GetRDSDatabaseRecommendationProjectedMetricsRequest$period' => '<p> The granularity, in seconds, of the projected metrics data points. </p>', ], ], 'PlatformDifference' => [ 'base' => NULL, 'refs' => [ 'PlatformDifferences$member' => NULL, ], ], 'PlatformDifferences' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendationOption$platformDifferences' => '<p>Describes the configuration differences between the current instance and the recommended instance type. You should consider the configuration differences before migrating your workloads from the current instance to the recommended instance type. The <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-resize.html">Change the instance type guide for Linux</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-resize.html">Change the instance type guide for Windows</a> provide general guidance for getting started with an instance migration.</p> <p>Platform differences include:</p> <ul> <li> <p> <b> <code>Hypervisor</code> </b> — The hypervisor of the recommended instance type is different than that of the current instance. For example, the recommended instance type uses a Nitro hypervisor and the current instance uses a Xen hypervisor. The differences that you should consider between these hypervisors are covered in the <a href="http://aws.amazon.com/ec2/faqs/#Nitro_Hypervisor">Nitro Hypervisor</a> section of the Amazon EC2 frequently asked questions. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the <i>Amazon EC2 User Guide for Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#ec2-nitro-instances">Instances built on the Nitro System</a> in the <i>Amazon EC2 User Guide for Windows</i>.</p> </li> <li> <p> <b> <code>NetworkInterface</code> </b> — The network interface of the recommended instance type is different than that of the current instance. For example, the recommended instance type supports enhanced networking and the current instance might not. To enable enhanced networking for the recommended instance type, you must install the Elastic Network Adapter (ENA) driver or the Intel 82599 Virtual Function driver. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/enhanced-networking.html">Enhanced networking on Linux</a> in the <i>Amazon EC2 User Guide for Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/enhanced-networking.html">Enhanced networking on Windows</a> in the <i>Amazon EC2 User Guide for Windows</i>.</p> </li> <li> <p> <b> <code>StorageInterface</code> </b> — The storage interface of the recommended instance type is different than that of the current instance. For example, the recommended instance type uses an NVMe storage interface and the current instance does not. To access NVMe volumes for the recommended instance type, you will need to install or upgrade the NVMe driver. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe on Linux instances</a> in the <i>Amazon EC2 User Guide for Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/nvme-ebs-volumes.html">Amazon EBS and NVMe on Windows instances</a> in the <i>Amazon EC2 User Guide for Windows</i>.</p> </li> <li> <p> <b> <code>InstanceStoreAvailability</code> </b> — The recommended instance type does not support instance store volumes and the current instance does. Before migrating, you might need to back up the data on your instance store volumes if you want to preserve them. For more information, see <a href="https://aws.amazon.com/premiumsupport/knowledge-center/back-up-instance-store-ebs/">How do I back up an instance store volume on my Amazon EC2 instance to Amazon EBS?</a> in the <i>Amazon Web Services Premium Support Knowledge Base</i>. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <i>Amazon EC2 User Guide for Linux</i>, or see <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/instance-types.html#instance-networking-storage">Networking and storage features</a> and <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/InstanceStorage.html">Amazon EC2 instance store</a> in the <i>Amazon EC2 User Guide for Windows</i>.</p> </li> <li> <p> <b> <code>VirtualizationType</code> </b> — The recommended instance type uses the hardware virtual machine (HVM) virtualization type and the current instance uses the paravirtual (PV) virtualization type. For more information about the differences between these virtualization types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/virtualization_types.html">Linux AMI virtualization types</a> in the <i>Amazon EC2 User Guide for Linux</i>, or <a href="https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/windows-ami-version-history.html#virtualization-types">Windows AMI virtualization types</a> in the <i>Amazon EC2 User Guide for Windows</i>.</p> </li> <li> <p> <b> <code>Architecture</code> </b> — The CPU architecture between the recommended instance type and the current instance is different. For example, the recommended instance type might use an Arm CPU architecture and the current instance type might use a different one, such as x86. Before migrating, you should consider recompiling the software on your instance for the new architecture. Alternatively, you might switch to an Amazon Machine Image (AMI) that supports the new architecture. For more information about the CPU architecture for each instance type, see <a href="http://aws.amazon.com/ec2/instance-types/">Amazon EC2 Instance Types</a>.</p> </li> </ul>', ], ], 'PreferredResource' => [ 'base' => '<p> The preference to control which resource type values are considered when generating rightsizing recommendations. You can specify this preference as a combination of include and exclude lists. You must specify either an <code>includeList</code> or <code>excludeList</code>. If the preference is an empty set of resource type values, an error occurs. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/rightsizing-preferences.html"> Rightsizing recommendation preferences</a> in the <i>Compute Optimizer User Guide</i>. </p> <note> <ul> <li> <p>This preference is only available for the Amazon EC2 instance and Auto Scaling group resource types.</p> </li> <li> <p>Compute Optimizer only supports the customization of <code>Ec2InstanceTypes</code>.</p> </li> </ul> </note>', 'refs' => [ 'PreferredResources$member' => NULL, ], ], 'PreferredResourceName' => [ 'base' => NULL, 'refs' => [ 'EffectivePreferredResource$name' => '<p> The name of the preferred resource list. </p>', 'PreferredResource$name' => '<p> The type of preferred resource to customize. </p> <note> <p>Compute Optimizer only supports the customization of <code>Ec2InstanceTypes</code>.</p> </note>', ], ], 'PreferredResourceValue' => [ 'base' => NULL, 'refs' => [ 'PreferredResourceValues$member' => NULL, ], ], 'PreferredResourceValues' => [ 'base' => NULL, 'refs' => [ 'EffectivePreferredResource$includeList' => '<p> The list of preferred resource values that you want considered as rightsizing recommendation candidates. </p>', 'EffectivePreferredResource$effectiveIncludeList' => '<p> The expanded version of your preferred resource\'s include list. </p>', 'EffectivePreferredResource$excludeList' => '<p> The list of preferred resources values that you want excluded from rightsizing recommendation candidates. </p>', 'PreferredResource$includeList' => '<p> The preferred resource type values to include in the recommendation candidates. You can specify the exact resource type value, such as m5.large, or use wild card expressions, such as m5. If this isn’t specified, all supported resources are included by default. You can specify up to 1000 values in this list. </p>', 'PreferredResource$excludeList' => '<p> The preferred resource type values to exclude from the recommendation candidates. If this isn’t specified, all supported resources are included by default. You can specify up to 1000 values in this list. </p>', ], ], 'PreferredResources' => [ 'base' => NULL, 'refs' => [ 'PutRecommendationPreferencesRequest$preferredResources' => '<p> The preference to control which resource type values are considered when generating rightsizing recommendations. You can specify this preference as a combination of include and exclude lists. You must specify either an <code>includeList</code> or <code>excludeList</code>. If the preference is an empty set of resource type values, an error occurs. </p> <note> <p>You can only set this preference for the Amazon EC2 instance and Auto Scaling group resource types.</p> </note>', ], ], 'ProjectedMetric' => [ 'base' => '<p>Describes a projected utilization metric of a recommendation option, such as an Amazon EC2 instance. This represents the projected utilization of a recommendation option had you used that resource during the analyzed period.</p> <p>Compare the utilization metric data of your resource against its projected utilization metric data to determine the performance difference between your current resource and the recommended option.</p> <note> <p>The <code>Cpu</code>, <code>Memory</code>, <code>GPU</code>, and <code>GPU_MEMORY</code> metrics are the only projected utilization metrics returned when you run the <a>GetEC2RecommendationProjectedMetrics</a> action. Additionally, these metrics are only returned for resources with the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a> and <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#nvidia-cw-agent">Enabling NVIDIA GPU utilization with the CloudWatch Agent</a>.</p> </note>', 'refs' => [ 'ProjectedMetrics$member' => NULL, ], ], 'ProjectedMetrics' => [ 'base' => NULL, 'refs' => [ 'RecommendedOptionProjectedMetric$projectedMetrics' => '<p>An array of objects that describe a projected utilization metric.</p>', ], ], 'ProjectedUtilizationMetrics' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendationOption$projectedUtilizationMetrics' => '<p>An array of objects that describe the projected utilization metrics of the Auto Scaling group recommendation option.</p> <note> <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected utilization metrics returned. Additionally, the <code>Memory</code> metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note>', 'InstanceRecommendationOption$projectedUtilizationMetrics' => '<p>An array of objects that describe the projected utilization metrics of the instance recommendation option.</p> <note> <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected utilization metrics returned. Additionally, the <code>Memory</code> metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note>', ], ], 'PutRecommendationPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutRecommendationPreferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'RDSDBInstanceRecommendationOption' => [ 'base' => '<p> Describes the recommendation options for an Amazon RDS instance. </p>', 'refs' => [ 'RDSDBInstanceRecommendationOptions$member' => NULL, ], ], 'RDSDBInstanceRecommendationOptions' => [ 'base' => NULL, 'refs' => [ 'RDSDBRecommendation$instanceRecommendationOptions' => '<p> An array of objects that describe the recommendation options for the Amazon RDS instance. </p>', ], ], 'RDSDBMetricName' => [ 'base' => NULL, 'refs' => [ 'RDSDBUtilizationMetric$name' => '<p> The name of the utilization metric. </p>', 'RDSDatabaseProjectedMetric$name' => '<p> The name of the projected metric. </p>', ], ], 'RDSDBMetricStatistic' => [ 'base' => NULL, 'refs' => [ 'RDSDBUtilizationMetric$statistic' => '<p> The statistic of the utilization metric. </p> <p>The Compute Optimizer API, Command Line Interface (CLI), and SDKs return utilization metrics using only the <code>Maximum</code> statistic, which is the highest value observed during the specified period.</p> <p>The Compute Optimizer console displays graphs for some utilization metrics using the <code>Average</code> statistic, which is the value of <code>Sum</code> / <code>SampleCount</code> during the specified period. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/viewing-recommendations.html">Viewing resource recommendations</a> in the <i>Compute Optimizer User Guide</i>. You can also get averaged utilization metric data for your resources using Amazon CloudWatch. For more information, see the <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html">Amazon CloudWatch User Guide</a>.</p>', ], ], 'RDSDBProjectedUtilizationMetrics' => [ 'base' => NULL, 'refs' => [ 'RDSDBInstanceRecommendationOption$projectedUtilizationMetrics' => '<p> An array of objects that describe the projected utilization metrics of the RDS instance recommendation option. </p>', ], ], 'RDSDBRecommendation' => [ 'base' => '<p> Describes an Amazon RDS recommendation. </p>', 'refs' => [ 'RDSDBRecommendations$member' => NULL, ], ], 'RDSDBRecommendationFilter' => [ 'base' => '<p> Describes a filter that returns a more specific list of Amazon RDS recommendations. Use this filter with the <a>GetECSServiceRecommendations</a> action. </p>', 'refs' => [ 'RDSDBRecommendationFilters$member' => NULL, ], ], 'RDSDBRecommendationFilterName' => [ 'base' => NULL, 'refs' => [ 'RDSDBRecommendationFilter$name' => '<p> The name of the filter. </p> <p> Specify <code>Finding</code> to return recommendations with a specific finding classification. </p> <p>You can filter your Amazon RDS recommendations by <code>tag:key</code> and <code>tag-key</code> tags.</p> <p>A <code>tag:key</code> is a key and value combination of a tag assigned to your Amazon RDS recommendations. Use the tag key in the filter name and the tag value as the filter value. For example, to find all Amazon RDS service recommendations that have a tag with the key of <code>Owner</code> and the value of <code>TeamA</code>, specify <code>tag:Owner</code> for the filter name and <code>TeamA</code> for the filter value.</p> <p>A <code>tag-key</code> is the key of a tag assigned to your Amazon RDS recommendations. Use this filter to find all of your Amazon RDS recommendations that have a tag with a specific key. This doesn’t consider the tag value. For example, you can find your Amazon RDS service recommendations with a tag key value of <code>Owner</code> or without any tag keys assigned.</p>', ], ], 'RDSDBRecommendationFilters' => [ 'base' => NULL, 'refs' => [ 'ExportRDSDatabaseRecommendationsRequest$filters' => '<p> An array of objects to specify a filter that exports a more specific set of Amazon RDS recommendations. </p>', 'GetRDSDatabaseRecommendationsRequest$filters' => '<p> An array of objects to specify a filter that returns a more specific list of Amazon RDS recommendations. </p>', ], ], 'RDSDBRecommendations' => [ 'base' => NULL, 'refs' => [ 'GetRDSDatabaseRecommendationsResponse$rdsDBRecommendations' => '<p> An array of objects that describe the Amazon RDS recommendations. </p>', ], ], 'RDSDBStorageRecommendationOption' => [ 'base' => '<p> Describes the recommendation options for Amazon RDS storage. </p>', 'refs' => [ 'RDSDBStorageRecommendationOptions$member' => NULL, ], ], 'RDSDBStorageRecommendationOptions' => [ 'base' => NULL, 'refs' => [ 'RDSDBRecommendation$storageRecommendationOptions' => '<p> An array of objects that describe the recommendation options for Amazon RDS storage. </p>', ], ], 'RDSDBUtilizationMetric' => [ 'base' => '<p> Describes the utilization metric of an Amazon RDS. </p> <p> To determine the performance difference between your current Amazon RDS and the recommended option, compare the utilization metric data of your service against its projected utilization metric data. </p>', 'refs' => [ 'RDSDBProjectedUtilizationMetrics$member' => NULL, 'RDSDBUtilizationMetrics$member' => NULL, ], ], 'RDSDBUtilizationMetrics' => [ 'base' => NULL, 'refs' => [ 'RDSDBRecommendation$utilizationMetrics' => '<p> An array of objects that describe the utilization metrics of the Amazon RDS. </p>', ], ], 'RDSDatabaseProjectedMetric' => [ 'base' => '<p> Describes the projected metrics of an Amazon RDS recommendation option. </p> <p> To determine the performance difference between your current Amazon RDS and the recommended option, compare the metric data of your service against its projected metric data. </p>', 'refs' => [ 'RDSDatabaseProjectedMetrics$member' => NULL, ], ], 'RDSDatabaseProjectedMetrics' => [ 'base' => NULL, 'refs' => [ 'RDSDatabaseRecommendedOptionProjectedMetric$projectedMetrics' => '<p> An array of objects that describe the projected metric. </p>', ], ], 'RDSDatabaseRecommendedOptionProjectedMetric' => [ 'base' => '<p> Describes the projected metrics of an Amazon RDS recommendation option. </p> <p> To determine the performance difference between your current Amazon RDS and the recommended option, compare the metric data of your service against its projected metric data. </p>', 'refs' => [ 'RDSDatabaseRecommendedOptionProjectedMetrics$member' => NULL, ], ], 'RDSDatabaseRecommendedOptionProjectedMetrics' => [ 'base' => NULL, 'refs' => [ 'GetRDSDatabaseRecommendationProjectedMetricsResponse$recommendedOptionProjectedMetrics' => '<p> An array of objects that describes the projected metrics. </p>', ], ], 'RDSEffectiveRecommendationPreferences' => [ 'base' => '<p> Describes the effective recommendation preferences for Amazon RDS. </p>', 'refs' => [ 'RDSDBRecommendation$effectiveRecommendationPreferences' => '<p> Describes the effective recommendation preferences for Amazon RDS. </p>', ], ], 'RDSInstanceEstimatedMonthlySavings' => [ 'base' => '<p> Describes the estimated monthly savings possible for Amazon RDS instances by adopting Compute Optimizer recommendations. This is based on Amazon RDS pricing after applying Savings Plans discounts. </p>', 'refs' => [ 'RDSInstanceSavingsOpportunityAfterDiscounts$estimatedMonthlySavings' => '<p> The estimated monthly savings possible by adopting Compute Optimizer’s Amazon RDS instance recommendations. This includes any applicable Savings Plans discounts. </p>', ], ], 'RDSInstanceFinding' => [ 'base' => NULL, 'refs' => [ 'RDSDBRecommendation$instanceFinding' => '<p> The finding classification of an Amazon RDS instance. </p> <p>Findings for Amazon RDS instance include:</p> <ul> <li> <p> <b> <code>Underprovisioned</code> </b> — When Compute Optimizer detects that there’s not enough resource specifications, an Amazon RDS is considered under-provisioned.</p> </li> <li> <p> <b> <code>Overprovisioned</code> </b> — When Compute Optimizer detects that there’s excessive resource specifications, an Amazon RDS is considered over-provisioned.</p> </li> <li> <p> <b> <code>Optimized</code> </b> — When the specifications of your Amazon RDS instance meet the performance requirements of your workload, the service is considered optimized.</p> </li> </ul>', ], ], 'RDSInstanceFindingReasonCode' => [ 'base' => NULL, 'refs' => [ 'RDSInstanceFindingReasonCodes$member' => NULL, ], ], 'RDSInstanceFindingReasonCodes' => [ 'base' => NULL, 'refs' => [ 'RDSDBRecommendation$instanceFindingReasonCodes' => '<p> The reason for the finding classification of an Amazon RDS instance. </p>', ], ], 'RDSInstanceSavingsOpportunityAfterDiscounts' => [ 'base' => '<p> Describes the savings opportunity for Amazon RDS instance recommendations after applying Savings Plans discounts. </p> <p> Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation. </p>', 'refs' => [ 'RDSDBInstanceRecommendationOption$savingsOpportunityAfterDiscounts' => '<p> Describes the savings opportunity for Amazon RDS recommendations or for the recommendation option. </p> <p>Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation.</p>', ], ], 'RDSSavingsEstimationMode' => [ 'base' => '<p> Describes the savings estimation mode used for calculating savings opportunity for Amazon RDS. </p>', 'refs' => [ 'RDSEffectiveRecommendationPreferences$savingsEstimationMode' => '<p> Describes the savings estimation mode preference applied for calculating savings opportunity for Amazon RDS. </p>', ], ], 'RDSSavingsEstimationModeSource' => [ 'base' => NULL, 'refs' => [ 'RDSSavingsEstimationMode$source' => '<p> Describes the source for calculating the savings opportunity for Amazon RDS. </p>', ], ], 'RDSStorageEstimatedMonthlySavings' => [ 'base' => '<p> Describes the estimated monthly savings possible for Amazon RDS storage by adopting Compute Optimizer recommendations. This is based on Amazon RDS pricing after applying Savings Plans discounts. </p>', 'refs' => [ 'RDSStorageSavingsOpportunityAfterDiscounts$estimatedMonthlySavings' => '<p> The estimated monthly savings possible by adopting Compute Optimizer’s Amazon RDS storage recommendations. This includes any applicable Savings Plans discounts. </p>', ], ], 'RDSStorageFinding' => [ 'base' => NULL, 'refs' => [ 'RDSDBRecommendation$storageFinding' => '<p> The finding classification of Amazon RDS storage. </p> <p>Findings for Amazon RDS instance include:</p> <ul> <li> <p> <b> <code>Underprovisioned</code> </b> — When Compute Optimizer detects that there’s not enough storage, an Amazon RDS is considered under-provisioned.</p> </li> <li> <p> <b> <code>Overprovisioned</code> </b> — When Compute Optimizer detects that there’s excessive storage, an Amazon RDS is considered over-provisioned.</p> </li> <li> <p> <b> <code>Optimized</code> </b> — When the storage of your Amazon RDS meet the performance requirements of your workload, the service is considered optimized.</p> </li> </ul>', ], ], 'RDSStorageFindingReasonCode' => [ 'base' => NULL, 'refs' => [ 'RDSStorageFindingReasonCodes$member' => NULL, ], ], 'RDSStorageFindingReasonCodes' => [ 'base' => NULL, 'refs' => [ 'RDSDBRecommendation$storageFindingReasonCodes' => '<p> The reason for the finding classification of Amazon RDS storage. </p>', ], ], 'RDSStorageSavingsOpportunityAfterDiscounts' => [ 'base' => '<p> Describes the savings opportunity for Amazon RDS storage recommendations after applying Savings Plans discounts. </p> <p> Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation. </p>', 'refs' => [ 'RDSDBStorageRecommendationOption$savingsOpportunityAfterDiscounts' => '<p> Describes the savings opportunity for Amazon RDS storage recommendations or for the recommendation option. </p> <p> Savings opportunity represents the estimated monthly savings after applying Savings Plans discounts. You can achieve this by implementing a given Compute Optimizer recommendation. </p>', ], ], 'Rank' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendationOption$rank' => '<p>The rank of the Auto Scaling group recommendation option.</p> <p>The top recommendation option is ranked as <code>1</code>.</p>', 'InstanceRecommendationOption$rank' => '<p>The rank of the instance recommendation option.</p> <p>The top recommendation option is ranked as <code>1</code>.</p>', 'LambdaFunctionMemoryRecommendationOption$rank' => '<p>The rank of the function recommendation option.</p> <p>The top recommendation option is ranked as <code>1</code>.</p>', 'LicenseRecommendationOption$rank' => '<p> The rank of the license recommendation option. </p> <p> The top recommendation option is ranked as <code>1</code>. </p>', 'RDSDBInstanceRecommendationOption$rank' => '<p> The rank identifier of the RDS instance recommendation option. </p>', 'RDSDBStorageRecommendationOption$rank' => '<p> The rank identifier of the RDS storage recommendation option. </p>', 'RDSDatabaseRecommendedOptionProjectedMetric$rank' => '<p> The rank identifier of the RDS instance recommendation option. </p>', 'RecommendedOptionProjectedMetric$rank' => '<p>The rank of the recommendation option projected metric.</p> <p>The top recommendation option is ranked as <code>1</code>.</p> <p>The projected metric rank correlates to the recommendation option rank. For example, the projected metric ranked as <code>1</code> is related to the recommendation option that is also ranked as <code>1</code> in the same response.</p>', 'VolumeRecommendationOption$rank' => '<p>The rank of the volume recommendation option.</p> <p>The top recommendation option is ranked as <code>1</code>.</p>', ], ], 'ReasonCodeSummaries' => [ 'base' => NULL, 'refs' => [ 'Summary$reasonCodeSummaries' => '<p>An array of objects that summarize a finding reason code.</p>', ], ], 'ReasonCodeSummary' => [ 'base' => '<p>A summary of a finding reason code.</p>', 'refs' => [ 'ReasonCodeSummaries$member' => NULL, ], ], 'RecommendationExportJob' => [ 'base' => '<p>Describes a recommendation export job.</p> <p>Use the <a>DescribeRecommendationExportJobs</a> action to view your recommendation export jobs.</p> <p>Use the <a>ExportAutoScalingGroupRecommendations</a> or <a>ExportEC2InstanceRecommendations</a> actions to request an export of your recommendations.</p>', 'refs' => [ 'RecommendationExportJobs$member' => NULL, ], ], 'RecommendationExportJobs' => [ 'base' => NULL, 'refs' => [ 'DescribeRecommendationExportJobsResponse$recommendationExportJobs' => '<p>An array of objects that describe recommendation export jobs.</p>', ], ], 'RecommendationOptions' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendation$recommendationOptions' => '<p>An array of objects that describe the recommendation options for the instance.</p>', ], ], 'RecommendationPreferenceName' => [ 'base' => NULL, 'refs' => [ 'RecommendationPreferenceNames$member' => NULL, ], ], 'RecommendationPreferenceNames' => [ 'base' => NULL, 'refs' => [ 'DeleteRecommendationPreferencesRequest$recommendationPreferenceNames' => '<p>The name of the recommendation preference to delete.</p>', ], ], 'RecommendationPreferences' => [ 'base' => '<p>Describes the recommendation preferences to return in the response of a <a>GetAutoScalingGroupRecommendations</a>, <a>GetEC2InstanceRecommendations</a>, <a>GetEC2RecommendationProjectedMetrics</a>, <a>GetRDSDatabaseRecommendations</a>, and <a>GetRDSDatabaseRecommendationProjectedMetrics</a> request.</p>', 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$recommendationPreferences' => '<p>An object to specify the preferences for the Auto Scaling group recommendations to export.</p>', 'ExportEC2InstanceRecommendationsRequest$recommendationPreferences' => '<p>An object to specify the preferences for the Amazon EC2 instance recommendations to export.</p>', 'ExportRDSDatabaseRecommendationsRequest$recommendationPreferences' => NULL, 'GetAutoScalingGroupRecommendationsRequest$recommendationPreferences' => '<p>An object to specify the preferences for the Auto Scaling group recommendations to return in the response.</p>', 'GetEC2InstanceRecommendationsRequest$recommendationPreferences' => '<p>An object to specify the preferences for the Amazon EC2 instance recommendations to return in the response.</p>', 'GetEC2RecommendationProjectedMetricsRequest$recommendationPreferences' => '<p>An object to specify the preferences for the Amazon EC2 recommendation projected metrics to return in the response.</p>', 'GetRDSDatabaseRecommendationProjectedMetricsRequest$recommendationPreferences' => NULL, 'GetRDSDatabaseRecommendationsRequest$recommendationPreferences' => NULL, ], ], 'RecommendationPreferencesDetail' => [ 'base' => '<p>Describes a recommendation preference.</p>', 'refs' => [ 'RecommendationPreferencesDetails$member' => NULL, ], ], 'RecommendationPreferencesDetails' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationPreferencesResponse$recommendationPreferencesDetails' => '<p>An array of objects that describe recommendation preferences.</p>', ], ], 'RecommendationSource' => [ 'base' => '<p>Describes the source of a recommendation, such as an Amazon EC2 instance or Auto Scaling group.</p>', 'refs' => [ 'RecommendationSources$member' => NULL, ], ], 'RecommendationSourceArn' => [ 'base' => NULL, 'refs' => [ 'RecommendationSource$recommendationSourceArn' => '<p>The Amazon Resource Name (ARN) of the recommendation source.</p>', ], ], 'RecommendationSourceType' => [ 'base' => NULL, 'refs' => [ 'RecommendationSource$recommendationSourceType' => '<p>The resource type of the recommendation source.</p>', 'RecommendationSummary$recommendationResourceType' => '<p>The resource type that the recommendation summary applies to.</p>', ], ], 'RecommendationSources' => [ 'base' => NULL, 'refs' => [ 'InstanceRecommendation$recommendationSources' => '<p>An array of objects that describe the source resource of the recommendation.</p>', ], ], 'RecommendationSummaries' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationSummariesResponse$recommendationSummaries' => '<p>An array of objects that summarize a recommendation.</p>', ], ], 'RecommendationSummary' => [ 'base' => '<p>A summary of a recommendation.</p>', 'refs' => [ 'RecommendationSummaries$member' => NULL, ], ], 'RecommendedDBInstanceClass' => [ 'base' => NULL, 'refs' => [ 'RDSDatabaseRecommendedOptionProjectedMetric$recommendedDBInstanceClass' => '<p> The recommended DB instance class for the Amazon RDS. </p>', ], ], 'RecommendedInstanceType' => [ 'base' => NULL, 'refs' => [ 'RecommendedOptionProjectedMetric$recommendedInstanceType' => '<p>The recommended instance type.</p>', ], ], 'RecommendedOptionProjectedMetric' => [ 'base' => '<p>Describes a projected utilization metric of a recommendation option.</p> <note> <p>The <code>Cpu</code> and <code>Memory</code> metrics are the only projected utilization metrics returned when you run the <a>GetEC2RecommendationProjectedMetrics</a> action. Additionally, the <code>Memory</code> metric is returned only for resources that have the unified CloudWatch agent installed on them. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html#cw-agent">Enabling Memory Utilization with the CloudWatch Agent</a>.</p> </note>', 'refs' => [ 'RecommendedOptionProjectedMetrics$member' => NULL, ], ], 'RecommendedOptionProjectedMetrics' => [ 'base' => NULL, 'refs' => [ 'GetEC2RecommendationProjectedMetricsResponse$recommendedOptionProjectedMetrics' => '<p>An array of objects that describes projected metrics.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'GetEffectiveRecommendationPreferencesRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which to confirm effective recommendation preferences. Only EC2 instance and Auto Scaling group ARNs are currently supported.</p>', 'GetRDSDatabaseRecommendationProjectedMetricsRequest$resourceArn' => '<p> The ARN that identifies the Amazon RDS. </p> <p> The following is the format of the ARN: </p> <p> <code>arn:aws:rds:{region}:{accountId}:db:{resourceName}</code> </p>', 'LicenseRecommendation$resourceArn' => '<p> The ARN that identifies the Amazon EC2 instance. </p>', 'RDSDBRecommendation$resourceArn' => '<p> The ARN of the current Amazon RDS. </p> <p> The following is the format of the ARN: </p> <p> <code>arn:aws:rds:{region}:{accountId}:db:{resourceName}</code> </p>', 'ResourceArns$member' => NULL, ], ], 'ResourceArns' => [ 'base' => NULL, 'refs' => [ 'GetLicenseRecommendationsRequest$resourceArns' => '<p> The ARN that identifies the Amazon EC2 instance. </p> <p> The following is the format of the ARN: </p> <p> <code>arn:aws:ec2:region:aws_account_id:instance/instance-id</code> </p>', 'GetRDSDatabaseRecommendationsRequest$resourceArns' => '<p> The ARN that identifies the Amazon RDS. </p> <p> The following is the format of the ARN: </p> <p> <code>arn:aws:rds:{region}:{accountId}:db:{resourceName}</code> </p> <p> The following is the format of a DB Cluster ARN: </p> <p> <code>arn:aws:rds:{region}:{accountId}:cluster:{resourceName}</code> </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>A resource that is required for the action doesn\'t exist.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'DeleteRecommendationPreferencesRequest$resourceType' => '<p>The target resource type of the recommendation preference to delete.</p> <p>The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto Scaling group.</p>', 'GetRecommendationPreferencesRequest$resourceType' => '<p>The target resource type of the recommendation preference for which to return preferences.</p> <p>The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto Scaling group.</p>', 'PutRecommendationPreferencesRequest$resourceType' => '<p>The target resource type of the recommendation preference to create.</p> <p>The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto Scaling group.</p>', 'RecommendationExportJob$resourceType' => '<p>The resource type of the exported recommendations.</p>', 'RecommendationPreferencesDetail$resourceType' => '<p>The target resource type of the recommendation preference to create.</p> <p>The <code>Ec2Instance</code> option encompasses standalone instances and instances that are part of Auto Scaling groups. The <code>AutoScalingGroup</code> option encompasses only instances that are part of an Auto Scaling group.</p>', ], ], 'RootVolume' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$rootVolume' => '<p> Contains the image used to boot the instance during launch. </p>', ], ], 'S3Destination' => [ 'base' => '<p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and object keys of a recommendations export file, and its associated metadata file.</p>', 'refs' => [ 'ExportAutoScalingGroupRecommendationsResponse$s3Destination' => '<p>An object that describes the destination Amazon S3 bucket of a recommendations export file.</p>', 'ExportDestination$s3' => '<p>An object that describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and object keys of a recommendations export file, and its associated metadata file.</p>', 'ExportEBSVolumeRecommendationsResponse$s3Destination' => NULL, 'ExportEC2InstanceRecommendationsResponse$s3Destination' => '<p>An object that describes the destination Amazon S3 bucket of a recommendations export file.</p>', 'ExportECSServiceRecommendationsResponse$s3Destination' => NULL, 'ExportLambdaFunctionRecommendationsResponse$s3Destination' => NULL, 'ExportLicenseRecommendationsResponse$s3Destination' => NULL, 'ExportRDSDatabaseRecommendationsResponse$s3Destination' => NULL, ], ], 'S3DestinationConfig' => [ 'base' => '<p>Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for a recommendations export job.</p> <p>You must create the destination Amazon S3 bucket for your recommendations export before you create the export job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it has the required permission policy to allow Compute Optimizer to write the export file to it. If you plan to specify an object prefix when you create the export job, you must include the object prefix in the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'refs' => [ 'ExportAutoScalingGroupRecommendationsRequest$s3DestinationConfig' => '<p>An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for the export job.</p> <p>You must create the destination Amazon S3 bucket for your recommendations export before you create the export job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it has the required permissions policy to allow Compute Optimizer to write the export file to it. If you plan to specify an object prefix when you create the export job, you must include the object prefix in the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'ExportEBSVolumeRecommendationsRequest$s3DestinationConfig' => NULL, 'ExportEC2InstanceRecommendationsRequest$s3DestinationConfig' => '<p>An object to specify the destination Amazon Simple Storage Service (Amazon S3) bucket name and key prefix for the export job.</p> <p>You must create the destination Amazon S3 bucket for your recommendations export before you create the export job. Compute Optimizer does not create the S3 bucket for you. After you create the S3 bucket, ensure that it has the required permissions policy to allow Compute Optimizer to write the export file to it. If you plan to specify an object prefix when you create the export job, you must include the object prefix in the policy that you add to the S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html">Amazon S3 Bucket Policy for Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'ExportECSServiceRecommendationsRequest$s3DestinationConfig' => NULL, 'ExportLambdaFunctionRecommendationsRequest$s3DestinationConfig' => NULL, 'ExportLicenseRecommendationsRequest$s3DestinationConfig' => NULL, 'ExportRDSDatabaseRecommendationsRequest$s3DestinationConfig' => NULL, ], ], 'SavingsEstimationMode' => [ 'base' => NULL, 'refs' => [ 'PutRecommendationPreferencesRequest$savingsEstimationMode' => '<p> The status of the savings estimation mode preference to create or update. </p> <p>Specify the <code>AfterDiscounts</code> status to activate the preference, or specify <code>BeforeDiscounts</code> to deactivate the preference.</p> <p>Only the account manager or delegated administrator of your organization can activate this preference.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/savings-estimation-mode.html"> Savings estimation mode</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'RecommendationPreferencesDetail$savingsEstimationMode' => '<p> Describes the savings estimation mode used for calculating savings opportunity. </p> <p>Only the account manager or delegated administrator of your organization can activate this preference.</p>', ], ], 'SavingsOpportunity' => [ 'base' => '<p>Describes the savings opportunity for recommendations of a given resource type or for the recommendation option of an individual resource.</p> <p>Savings opportunity represents the estimated monthly savings you can achieve by implementing a given Compute Optimizer recommendation.</p> <important> <p>Savings opportunity data requires that you opt in to Cost Explorer, as well as activate <b>Receive Amazon EC2 resource recommendations</b> in the Cost Explorer preferences page. That creates a connection between Cost Explorer and Compute Optimizer. With this connection, Cost Explorer generates savings estimates considering the price of existing resources, the price of recommended resources, and historical usage data. Estimated monthly savings reflects the projected dollar savings associated with each of the recommendations generated. For more information, see <a href="https://docs.aws.amazon.com/cost-management/latest/userguide/ce-enable.html">Enabling Cost Explorer</a> and <a href="https://docs.aws.amazon.com/cost-management/latest/userguide/ce-rightsizing.html">Optimizing your cost with Rightsizing Recommendations</a> in the <i>Cost Management User Guide</i>.</p> </important>', 'refs' => [ 'AutoScalingGroupRecommendationOption$savingsOpportunity' => '<p>An object that describes the savings opportunity for the Auto Scaling group recommendation option. Savings opportunity includes the estimated monthly savings amount and percentage.</p>', 'ECSServiceRecommendationOption$savingsOpportunity' => NULL, 'InstanceRecommendationOption$savingsOpportunity' => '<p>An object that describes the savings opportunity for the instance recommendation option. Savings opportunity includes the estimated monthly savings amount and percentage.</p>', 'LambdaFunctionMemoryRecommendationOption$savingsOpportunity' => '<p>An object that describes the savings opportunity for the Lambda function recommendation option. Savings opportunity includes the estimated monthly savings amount and percentage.</p>', 'LicenseRecommendationOption$savingsOpportunity' => NULL, 'RDSDBInstanceRecommendationOption$savingsOpportunity' => NULL, 'RDSDBStorageRecommendationOption$savingsOpportunity' => NULL, 'RecommendationSummary$savingsOpportunity' => '<p>An object that describes the savings opportunity for a given resource type. Savings opportunity includes the estimated monthly savings amount and percentage.</p>', 'VolumeRecommendationOption$savingsOpportunity' => '<p>An object that describes the savings opportunity for the EBS volume recommendation option. Savings opportunity includes the estimated monthly savings amount and percentage.</p>', ], ], 'SavingsOpportunityPercentage' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupSavingsOpportunityAfterDiscounts$savingsOpportunityPercentage' => '<p> The estimated monthly savings possible as a percentage of monthly cost after applying the Savings Plans and Reserved Instances discounts. This saving can be achieved by adopting Compute Optimizer’s Auto Scaling group recommendations. </p>', 'EBSSavingsOpportunityAfterDiscounts$savingsOpportunityPercentage' => '<p> The estimated monthly savings possible as a percentage of monthly cost after applying the specific discounts. This saving can be achieved by adopting Compute Optimizer’s Amazon EBS volume recommendations. </p>', 'ECSSavingsOpportunityAfterDiscounts$savingsOpportunityPercentage' => '<p> The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s Amazon ECS service recommendations. This includes any applicable Savings Plans discounts. </p>', 'InstanceSavingsOpportunityAfterDiscounts$savingsOpportunityPercentage' => '<p> The estimated monthly savings possible as a percentage of monthly cost after applying the Savings Plans and Reserved Instances discounts. This saving can be achieved by adopting Compute Optimizer’s EC2 instance recommendations. </p>', 'LambdaSavingsOpportunityAfterDiscounts$savingsOpportunityPercentage' => '<p> The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s Lambda function recommendations. This includes any applicable Savings Plans discounts. </p>', 'RDSInstanceSavingsOpportunityAfterDiscounts$savingsOpportunityPercentage' => '<p> The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s Amazon RDS instance recommendations. This includes any applicable Savings Plans discounts. </p>', 'RDSStorageSavingsOpportunityAfterDiscounts$savingsOpportunityPercentage' => '<p> The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer’s Amazon RDS storage recommendations. This includes any applicable Savings Plans discounts. </p>', 'SavingsOpportunity$savingsOpportunityPercentage' => '<p>The estimated monthly savings possible as a percentage of monthly cost by adopting Compute Optimizer recommendations for a given resource.</p>', ], ], 'Scope' => [ 'base' => '<p>Describes the scope of a recommendation preference.</p> <p>Recommendation preferences can be created at the organization level (for management accounts of an organization only), account level, and resource level. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p> <note> <p>You cannot create recommendation preferences for Auto Scaling groups at the organization and account levels. You can create recommendation preferences for Auto Scaling groups only at the resource level by specifying a scope name of <code>ResourceArn</code> and a scope value of the Auto Scaling group Amazon Resource Name (ARN). This will configure the preference for all instances that are part of the specified Auto Scaling group. You also cannot create recommendation preferences at the resource level for instances that are part of an Auto Scaling group. You can create recommendation preferences at the resource level only for standalone instances.</p> </note>', 'refs' => [ 'DeleteRecommendationPreferencesRequest$scope' => '<p>An object that describes the scope of the recommendation preference to delete.</p> <p>You can delete recommendation preferences that are created at the organization level (for management accounts of an organization only), account level, and resource level. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'GetRecommendationPreferencesRequest$scope' => '<p>An object that describes the scope of the recommendation preference to return.</p> <p>You can return recommendation preferences that are created at the organization level (for management accounts of an organization only), account level, and resource level. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p>', 'PutRecommendationPreferencesRequest$scope' => '<p>An object that describes the scope of the recommendation preference to create.</p> <p>You can create recommendation preferences at the organization level (for management accounts of an organization only), account level, and resource level. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p> <note> <p>You cannot create recommendation preferences for Auto Scaling groups at the organization and account levels. You can create recommendation preferences for Auto Scaling groups only at the resource level by specifying a scope name of <code>ResourceArn</code> and a scope value of the Auto Scaling group Amazon Resource Name (ARN). This will configure the preference for all instances that are part of the specified Auto Scaling group. You also cannot create recommendation preferences at the resource level for instances that are part of an Auto Scaling group. You can create recommendation preferences at the resource level only for standalone instances.</p> </note>', 'RecommendationPreferencesDetail$scope' => '<p>An object that describes the scope of the recommendation preference.</p> <p>Recommendation preferences can be created at the organization level (for management accounts of an organization only), account level, and resource level. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html">Activating enhanced infrastructure metrics</a> in the <i>Compute Optimizer User Guide</i>.</p>', ], ], 'ScopeName' => [ 'base' => NULL, 'refs' => [ 'Scope$name' => '<p>The name of the scope.</p> <p>The following scopes are possible:</p> <ul> <li> <p> <code>Organization</code> - Specifies that the recommendation preference applies at the organization level, for all member accounts of an organization.</p> </li> <li> <p> <code>AccountId</code> - Specifies that the recommendation preference applies at the account level, for all resources of a given resource type in an account.</p> </li> <li> <p> <code>ResourceArn</code> - Specifies that the recommendation preference applies at the individual resource level.</p> </li> </ul>', ], ], 'ScopeValue' => [ 'base' => NULL, 'refs' => [ 'Scope$value' => '<p>The value of the scope.</p> <p>If you specified the <code>name</code> of the scope as:</p> <ul> <li> <p> <code>Organization</code> - The <code>value</code> must be <code>ALL_ACCOUNTS</code>.</p> </li> <li> <p> <code>AccountId</code> - The <code>value</code> must be a 12-digit Amazon Web Services account ID.</p> </li> <li> <p> <code>ResourceArn</code> - The <code>value</code> must be the Amazon Resource Name (ARN) of an EC2 instance or an Auto Scaling group.</p> </li> </ul> <p>Only EC2 instance and Auto Scaling group ARNs are currently supported.</p>', ], ], 'ServiceArn' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendation$serviceArn' => '<p> The Amazon Resource Name (ARN) of the current Amazon ECS service. </p> <p> The following is the format of the ARN: </p> <p> <code>arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name</code> </p>', 'GetECSServiceRecommendationProjectedMetricsRequest$serviceArn' => '<p> The ARN that identifies the Amazon ECS service. </p> <p> The following is the format of the ARN: </p> <p> <code>arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name</code> </p>', 'ServiceArns$member' => NULL, ], ], 'ServiceArns' => [ 'base' => NULL, 'refs' => [ 'GetECSServiceRecommendationsRequest$serviceArns' => '<p> The ARN that identifies the Amazon ECS service. </p> <p> The following is the format of the ARN: </p> <p> <code>arn:aws:ecs:region:aws_account_id:service/cluster-name/service-name</code> </p>', ], ], 'ServiceConfiguration' => [ 'base' => '<p> The Amazon ECS service configurations used for recommendations. </p>', 'refs' => [ 'ECSServiceRecommendation$currentServiceConfiguration' => '<p> The configuration of the current Amazon ECS service. </p>', ], ], 'ServiceUnavailableException' => [ 'base' => '<p>The request has failed due to a temporary failure of the server.</p>', 'refs' => [], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'AccountEnrollmentStatus$status' => '<p>The account enrollment status.</p>', 'GetEnrollmentStatusResponse$status' => '<p>The enrollment status of the account.</p>', 'UpdateEnrollmentStatusRequest$status' => '<p>The new enrollment status of the account.</p> <p>The following status options are available:</p> <ul> <li> <p> <code>Active</code> - Opts in your account to the Compute Optimizer service. Compute Optimizer begins analyzing the configuration and utilization metrics of your Amazon Web Services resources after you opt in. For more information, see <a href="https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html">Metrics analyzed by Compute Optimizer</a> in the <i>Compute Optimizer User Guide</i>.</p> </li> <li> <p> <code>Inactive</code> - Opts out your account from the Compute Optimizer service. Your account\'s recommendations and related metrics data will be deleted from Compute Optimizer after you opt out.</p> </li> </ul> <note> <p>The <code>Pending</code> and <code>Failed</code> options cannot be used to update the enrollment status of an account. They are returned in the response of a request to update the enrollment status of an account.</p> </note>', 'UpdateEnrollmentStatusResponse$status' => '<p>The enrollment status of the account.</p>', ], ], 'StatusReason' => [ 'base' => NULL, 'refs' => [ 'AccountEnrollmentStatus$statusReason' => '<p>The reason for the account enrollment status.</p> <p>For example, an account might show a status of <code>Pending</code> because member accounts of an organization require more time to be enrolled in the service.</p>', 'GetEnrollmentStatusResponse$statusReason' => '<p>The reason for the enrollment status of the account.</p> <p>For example, an account might show a status of <code>Pending</code> because member accounts of an organization require more time to be enrolled in the service.</p>', 'UpdateEnrollmentStatusResponse$statusReason' => '<p>The reason for the enrollment status of the account. For example, an account might show a status of <code>Pending</code> because member accounts of an organization require more time to be enrolled in the service.</p>', ], ], 'StorageType' => [ 'base' => NULL, 'refs' => [ 'DBStorageConfiguration$storageType' => '<p> The type of RDS storage. </p>', ], ], 'Summaries' => [ 'base' => NULL, 'refs' => [ 'RecommendationSummary$summaries' => '<p>An array of objects that describe a recommendation summary.</p>', ], ], 'Summary' => [ 'base' => '<p>The summary of a recommendation.</p>', 'refs' => [ 'Summaries$member' => NULL, ], ], 'SummaryValue' => [ 'base' => NULL, 'refs' => [ 'ReasonCodeSummary$value' => '<p>The value of the finding reason code summary.</p>', 'Summary$value' => '<p>The value of the recommendation summary.</p>', ], ], 'Tag' => [ 'base' => '<p> A list of tag key and value pairs that you define. </p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p> One part of a key-value pair that makes up a tag. A key is a general label that acts like a category for more specific tag values. </p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p> One part of a key-value pair that make up a tag. A value acts as a descriptor within a tag category (key). The value can be empty or null. </p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'ECSServiceRecommendation$tags' => '<p> A list of tags assigned to your Amazon ECS service recommendations. </p>', 'InstanceRecommendation$tags' => '<p> A list of tags assigned to your Amazon EC2 instance recommendations. </p>', 'LambdaFunctionRecommendation$tags' => '<p> A list of tags assigned to your Lambda function recommendations. </p>', 'LicenseRecommendation$tags' => '<p> A list of tags assigned to an EC2 instance. </p>', 'RDSDBRecommendation$tags' => '<p> A list of tags assigned to your Amazon RDS recommendations. </p>', 'VolumeRecommendation$tags' => '<p> A list of tags assigned to your Amazon EBS volume recommendations. </p>', ], ], 'TaskDefinitionArn' => [ 'base' => NULL, 'refs' => [ 'ServiceConfiguration$taskDefinitionArn' => '<p> The task definition ARN used by the tasks in the Amazon ECS service. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'GetEC2RecommendationProjectedMetricsRequest$startTime' => '<p>The timestamp of the first projected metrics data point to return.</p>', 'GetEC2RecommendationProjectedMetricsRequest$endTime' => '<p>The timestamp of the last projected metrics data point to return.</p>', 'GetECSServiceRecommendationProjectedMetricsRequest$startTime' => '<p> The timestamp of the first projected metrics data point to return. </p>', 'GetECSServiceRecommendationProjectedMetricsRequest$endTime' => '<p> The timestamp of the last projected metrics data point to return. </p>', 'GetRDSDatabaseRecommendationProjectedMetricsRequest$startTime' => '<p> The timestamp of the first projected metrics data point to return. </p>', 'GetRDSDatabaseRecommendationProjectedMetricsRequest$endTime' => '<p> The timestamp of the last projected metrics data point to return. </p>', 'Timestamps$member' => NULL, ], ], 'Timestamps' => [ 'base' => NULL, 'refs' => [ 'ECSServiceProjectedMetric$timestamps' => '<p> The timestamps of the projected metric. </p>', 'ProjectedMetric$timestamps' => '<p>The timestamps of the projected utilization metric.</p>', 'RDSDatabaseProjectedMetric$timestamps' => '<p> The timestamps of the projected metric. </p>', ], ], 'UpdateEnrollmentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnrollmentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpperBoundValue' => [ 'base' => NULL, 'refs' => [ 'ECSServiceProjectedUtilizationMetric$upperBoundValue' => '<p> The upper bound values for the projected utilization metrics. </p>', ], ], 'UtilizationMetric' => [ 'base' => '<p>Describes a utilization metric of a resource, such as an Amazon EC2 instance.</p> <p>Compare the utilization metric data of your resource against its projected utilization metric data to determine the performance difference between your current resource and the recommended option.</p>', 'refs' => [ 'ProjectedUtilizationMetrics$member' => NULL, 'UtilizationMetrics$member' => NULL, ], ], 'UtilizationMetrics' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupRecommendation$utilizationMetrics' => '<p>An array of objects that describe the utilization metrics of the Auto Scaling group.</p>', 'InstanceRecommendation$utilizationMetrics' => '<p>An array of objects that describe the utilization metrics of the instance.</p>', ], ], 'UtilizationPreference' => [ 'base' => '<p> The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory utilization headroom. </p> <note> <p>This preference is only available for the Amazon EC2 instance resource type.</p> </note>', 'refs' => [ 'UtilizationPreferences$member' => NULL, ], ], 'UtilizationPreferences' => [ 'base' => NULL, 'refs' => [ 'EffectiveRecommendationPreferences$utilizationPreferences' => '<p> The resource’s CPU and memory utilization preferences, such as threshold and headroom, that are used to generate rightsizing recommendations. </p> <note> <p>This preference is only available for the Amazon EC2 instance resource type.</p> </note>', 'GetEffectiveRecommendationPreferencesResponse$utilizationPreferences' => '<p> The resource’s CPU and memory utilization preferences, such as threshold and headroom, that were used to generate rightsizing recommendations. It considers all applicable preferences that you set at the resource, account, and organization level. </p> <p>To validate that the preference is applied to your last generated set of recommendations, review the <code>effectiveRecommendationPreferences</code> value in the response of the GetAutoScalingGroupRecommendations or GetEC2InstanceRecommendations actions.</p>', 'PutRecommendationPreferencesRequest$utilizationPreferences' => '<p> The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory utilization headroom. When this preference isn\'t specified, we use the following default values. </p> <p>CPU utilization:</p> <ul> <li> <p> <code>P99_5</code> for threshold</p> </li> <li> <p> <code>PERCENT_20</code> for headroom</p> </li> </ul> <p>Memory utilization:</p> <ul> <li> <p> <code>PERCENT_20</code> for headroom</p> </li> </ul> <note> <ul> <li> <p>You can only set CPU and memory utilization preferences for the Amazon EC2 instance resource type.</p> </li> <li> <p>The threshold setting isn’t available for memory utilization.</p> </li> </ul> </note>', 'RecommendationPreferencesDetail$utilizationPreferences' => '<p> The preference to control the resource’s CPU utilization threshold, CPU utilization headroom, and memory utilization headroom. If the preference isn’t set, this object is null. </p> <note> <p>This preference is only available for the Amazon EC2 instance resource type.</p> </note>', ], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'AutoScalingGroupEstimatedMonthlySavings$value' => '<p> The value of the estimated monthly savings. </p>', 'EBSEstimatedMonthlySavings$value' => '<p> The value of the estimated monthly savings. </p>', 'ECSEstimatedMonthlySavings$value' => '<p> The value of the estimated monthly savings for Amazon ECS services. </p>', 'EstimatedMonthlySavings$value' => '<p>The value of the estimated monthly savings.</p>', 'InstanceEstimatedMonthlySavings$value' => '<p> The value of the estimated monthly savings. </p>', 'LambdaEstimatedMonthlySavings$value' => '<p> The value of the estimated monthly savings. </p>', 'RDSInstanceEstimatedMonthlySavings$value' => '<p> The value of the estimated monthly savings for Amazon RDS instances. </p>', 'RDSStorageEstimatedMonthlySavings$value' => '<p> The value of the estimated monthly savings for Amazon RDS storage. </p>', ], ], 'VeryLow' => [ 'base' => NULL, 'refs' => [ 'CurrentPerformanceRiskRatings$veryLow' => '<p>A count of the applicable resource types with a very low performance risk rating.</p>', ], ], 'VolumeArn' => [ 'base' => NULL, 'refs' => [ 'VolumeArns$member' => NULL, 'VolumeRecommendation$volumeArn' => '<p>The Amazon Resource Name (ARN) of the current volume.</p>', ], ], 'VolumeArns' => [ 'base' => NULL, 'refs' => [ 'GetEBSVolumeRecommendationsRequest$volumeArns' => '<p>The Amazon Resource Name (ARN) of the volumes for which to return recommendations.</p>', ], ], 'VolumeBaselineIOPS' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$volumeBaselineIOPS' => '<p>The baseline IOPS of the volume.</p>', ], ], 'VolumeBaselineThroughput' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$volumeBaselineThroughput' => '<p>The baseline throughput of the volume.</p>', ], ], 'VolumeBurstIOPS' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$volumeBurstIOPS' => '<p>The burst IOPS of the volume.</p>', ], ], 'VolumeBurstThroughput' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$volumeBurstThroughput' => '<p>The burst throughput of the volume.</p>', ], ], 'VolumeConfiguration' => [ 'base' => '<p>Describes the configuration of an Amazon Elastic Block Store (Amazon EBS) volume.</p>', 'refs' => [ 'VolumeRecommendation$currentConfiguration' => '<p>An array of objects that describe the current configuration of the volume.</p>', 'VolumeRecommendationOption$configuration' => '<p>An array of objects that describe a volume configuration.</p>', ], ], 'VolumeRecommendation' => [ 'base' => '<p>Describes an Amazon Elastic Block Store (Amazon EBS) volume recommendation.</p>', 'refs' => [ 'VolumeRecommendations$member' => NULL, ], ], 'VolumeRecommendationOption' => [ 'base' => '<p>Describes a recommendation option for an Amazon Elastic Block Store (Amazon EBS) instance.</p>', 'refs' => [ 'VolumeRecommendationOptions$member' => NULL, ], ], 'VolumeRecommendationOptions' => [ 'base' => NULL, 'refs' => [ 'VolumeRecommendation$volumeRecommendationOptions' => '<p>An array of objects that describe the recommendation options for the volume.</p>', ], ], 'VolumeRecommendations' => [ 'base' => NULL, 'refs' => [ 'GetEBSVolumeRecommendationsResponse$volumeRecommendations' => '<p>An array of objects that describe volume recommendations.</p>', ], ], 'VolumeSize' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$volumeSize' => '<p>The size of the volume, in GiB.</p>', ], ], 'VolumeType' => [ 'base' => NULL, 'refs' => [ 'VolumeConfiguration$volumeType' => '<p>The volume type.</p> <p>This can be <code>gp2</code> for General Purpose SSD, <code>io1</code> or <code>io2</code> for Provisioned IOPS SSD, <code>st1</code> for Throughput Optimized HDD, <code>sc1</code> for Cold HDD, or <code>standard</code> for Magnetic volumes.</p>', ], ], ],];
