<?php
// This file was auto-generated from sdk-root/src/data/connect/2017-08-08/docs-2.json
return [ 'version' => '2.0', 'service' => '<ul> <li> <p> <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_Operations_Amazon_Connect_Service.html">Amazon Connect actions</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_Types_Amazon_Connect_Service.html">Amazon Connect data types</a> </p> </li> </ul> <p>Amazon Connect is a cloud-based contact center solution that you use to set up and manage a customer contact center and provide reliable customer engagement at any scale.</p> <p>Amazon Connect provides metrics and real-time reporting that enable you to optimize contact routing. You can also resolve customer issues more efficiently by getting customers in touch with the appropriate agents.</p> <p>There are limits to the number of Amazon Connect resources that you can create. There are also limits to the number of requests that you can make per second. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <p>You can connect programmatically to an Amazon Web Services service by using an endpoint. For a list of Amazon Connect endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/connect_region.html">Amazon Connect Endpoints</a>.</p>', 'operations' => [ 'ActivateEvaluationForm' => '<p>Activates an evaluation form in the specified Amazon Connect instance. After the evaluation form is activated, it is available to start new evaluations based on the form. </p>', 'AssociateAnalyticsDataSet' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Associates the specified dataset for a Amazon Connect instance with the target account. You can associate only one dataset in a single call.</p>', 'AssociateApprovedOrigin' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Associates an approved origin to an Amazon Connect instance.</p>', 'AssociateBot' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Allows the specified Amazon Connect instance to access the specified Amazon Lex or Amazon Lex V2 bot.</p>', 'AssociateDefaultVocabulary' => '<p>Associates an existing vocabulary as the default. Contact Lens for Amazon Connect uses the vocabulary in post-call and real-time analysis sessions for the given language.</p>', 'AssociateFlow' => '<p>Associates a connect resource to a flow.</p>', 'AssociateInstanceStorageConfig' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Associates a storage resource type for the first time. You can only associate one type of storage configuration in a single call. This means, for example, that you can\'t define an instance with multiple S3 buckets for storing chat transcripts.</p> <p>This API does not create a resource that doesn\'t exist. It only associates it to the instance. Ensure that the resource being specified in the storage configuration, like an S3 bucket, exists when being used for association.</p>', 'AssociateLambdaFunction' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Allows the specified Amazon Connect instance to access the specified Lambda function.</p>', 'AssociateLexBot' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Allows the specified Amazon Connect instance to access the specified Amazon Lex V1 bot. This API only supports the association of Amazon Lex V1 bots.</p>', 'AssociatePhoneNumberContactFlow' => '<p>Associates a flow with a phone number claimed to your Amazon Connect instance.</p> <important> <p>If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone number ARN or UUID value for the <code>PhoneNumberId</code> URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.</p> </important>', 'AssociateQueueQuickConnects' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Associates a set of quick connects with a queue.</p>', 'AssociateRoutingProfileQueues' => '<p>Associates a set of queues with a routing profile.</p>', 'AssociateSecurityKey' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Associates a security key to the instance.</p>', 'AssociateTrafficDistributionGroupUser' => '<p>Associates an agent with a traffic distribution group.</p>', 'AssociateUserProficiencies' => '<p>&gt;Associates a set of proficiencies with a user.</p>', 'BatchAssociateAnalyticsDataSet' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Associates a list of analytics datasets for a given Amazon Connect instance to a target account. You can associate multiple datasets in a single call.</p>', 'BatchDisassociateAnalyticsDataSet' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Removes a list of analytics datasets associated with a given Amazon Connect instance. You can disassociate multiple datasets in a single call.</p>', 'BatchGetAttachedFileMetadata' => '<p>Allows you to retrieve metadata about multiple attached files on an associated resource. Each attached file provided in the input list must be associated with the input AssociatedResourceArn.</p>', 'BatchGetFlowAssociation' => '<p>Retrieve the flow associations for the given resources.</p>', 'BatchPutContact' => '<note> <p>Only the Amazon Connect outbound campaigns service principal is allowed to assume a role in your account and call this API.</p> </note> <p>Allows you to create a batch of contacts in Amazon Connect. The outbound campaigns capability ingests dial requests via the <a href="https://docs.aws.amazon.com/connect-outbound/latest/APIReference/API_PutDialRequestBatch.html">PutDialRequestBatch</a> API. It then uses BatchPutContact to create contacts corresponding to those dial requests. If agents are available, the dial requests are dialed out, which results in a voice call. The resulting voice call uses the same contactId that was created by BatchPutContact. </p>', 'ClaimPhoneNumber' => '<p>Claims an available phone number to your Amazon Connect instance or traffic distribution group. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance or traffic distribution group was created.</p> <p>For more information about how to use this operation, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-number.html">Claim a phone number in your country</a> and <a href="https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-numbers-traffic-distribution-groups.html">Claim phone numbers to traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>. </p> <important> <p>You can call the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html">SearchAvailablePhoneNumbers</a> API for available phone numbers that you can claim. Call the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html">DescribePhoneNumber</a> API to verify the status of a previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html">ClaimPhoneNumber</a> operation.</p> </important> <p>If you plan to claim and release numbers frequently, contact us for a service quota exception. Otherwise, it is possible you will be blocked from claiming and releasing any more numbers until up to 180 days past the oldest number released has expired.</p> <p>By default you can claim and release up to 200% of your maximum number of active phone numbers. If you claim and release phone numbers using the UI or API during a rolling 180 day cycle that exceeds 200% of your phone number service level quota, you will be blocked from claiming any more numbers until 180 days past the oldest number released has expired. </p> <p>For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 180 day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.</p>', 'CompleteAttachedFileUpload' => '<p>Allows you to confirm that the attached file has been uploaded using the pre-signed URL provided in the StartAttachedFileUpload API.</p>', 'CreateAgentStatus' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Creates an agent status for the specified Amazon Connect instance.</p>', 'CreateContactFlow' => '<p>Creates a flow for the specified Amazon Connect instance.</p> <p>You can also create and update flows using the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow language</a>.</p>', 'CreateContactFlowModule' => '<p>Creates a flow module for the specified Amazon Connect instance. </p>', 'CreateEvaluationForm' => '<p>Creates an evaluation form in the specified Amazon Connect instance. The form can be used to define questions related to agent performance, and create sections to organize such questions. Question and section identifiers cannot be duplicated within the same evaluation form.</p>', 'CreateHoursOfOperation' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Creates hours of operation. </p>', 'CreateInstance' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Initiates an Amazon Connect instance with all the supported channels enabled. It does not attach any storage, such as Amazon Simple Storage Service (Amazon S3) or Amazon Kinesis. It also does not allow for any configurations on features, such as Contact Lens for Amazon Connect. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-instances.html">Create an Amazon Connect instance</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <p>Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.</p>', 'CreateIntegrationAssociation' => '<p>Creates an Amazon Web Services resource association with an Amazon Connect instance.</p>', 'CreateParticipant' => '<p>Adds a new participant into an on-going chat contact. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-customize-flow.html">Customize chat flow experiences by integrating custom participants</a>.</p>', 'CreatePersistentContactAssociation' => '<p>Enables rehydration of chats for the lifespan of a contact. For more information about chat rehydration, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent chat</a> in the <i>Amazon Connect Administrator Guide</i>. </p>', 'CreatePredefinedAttribute' => '<p>Creates a new predefined attribute for the specified Amazon Connect instance. <i>Predefined attributes</i> are attributes in an Amazon Connect instance that can be used to route contacts to an agent or pools of agents within a queue. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/predefined-attributes.html">Create predefined attributes for routing contacts to agents</a>.</p>', 'CreatePrompt' => '<p>Creates a prompt. For more information about prompts, such as supported file types and maximum length, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/prompts.html">Create prompts</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'CreateQueue' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Creates a new queue for the specified Amazon Connect instance.</p> <important> <ul> <li> <p>If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for <code>OutboundCallerIdNumberId</code>. However, if the phone number is claimed to a traffic distribution group that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.</p> </li> <li> <p>Only use the phone number ARN format that doesn\'t contain <code>instance</code> in the path, for example, <code>arn:aws:connect:us-east-1:1234567890:phone-number/uuid</code>. This is the same ARN format that is returned when you call the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a> API.</p> </li> <li> <p>If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic distribution group, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region">Allow or Deny queue API actions for phone numbers in a replica Region</a>.</p> </li> </ul> </important>', 'CreateQuickConnect' => '<p>Creates a quick connect for the specified Amazon Connect instance.</p>', 'CreateRoutingProfile' => '<p>Creates a new routing profile.</p>', 'CreateRule' => '<p>Creates a rule for the specified Amazon Connect instance.</p> <p>Use the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html">Rules Function language</a> to code conditions for the rule. </p>', 'CreateSecurityProfile' => '<p>Creates a security profile.</p> <p>For information about security profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>. For a mapping of the API name and user interface name of the security profile permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a>. </p>', 'CreateTaskTemplate' => '<p>Creates a new task template in the specified Amazon Connect instance.</p>', 'CreateTrafficDistributionGroup' => '<p>Creates a traffic distribution group given an Amazon Connect instance that has been replicated. </p> <note> <p>The <code>SignInConfig</code> distribution is available only on a default <code>TrafficDistributionGroup</code> (see the <code>IsDefault</code> parameter in the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html">TrafficDistributionGroup</a> data type). If you call <code>UpdateTrafficDistribution</code> with a modified <code>SignInConfig</code> and a non-default <code>TrafficDistributionGroup</code>, an <code>InvalidRequestException</code> is returned.</p> </note> <p>For more information about creating traffic distribution groups, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html">Set up traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>. </p>', 'CreateUseCase' => '<p>Creates a use case for an integration association.</p>', 'CreateUser' => '<p>Creates a user account for the specified Amazon Connect instance.</p> <important> <p>Certain <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UserIdentityInfo.html">UserIdentityInfo</a> parameters are required in some situations. For example, <code>Email</code> is required if you are using SAML for identity management. <code>FirstName</code> and <code>LastName</code> are required if you are using Amazon Connect or SAML for identity management.</p> </important> <p>For information about how to create users using the Amazon Connect admin website, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html">Add Users</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'CreateUserHierarchyGroup' => '<p>Creates a new user hierarchy group.</p>', 'CreateView' => '<p>Creates a new view with the possible status of <code>SAVED</code> or <code>PUBLISHED</code>.</p> <p>The views will have a unique name for each connect instance.</p> <p>It performs basic content validation if the status is <code>SAVED</code> or full content validation if the status is set to <code>PUBLISHED</code>. An error is returned if validation fails. It associates either the <code>$SAVED</code> qualifier or both of the <code>$SAVED</code> and <code>$LATEST</code> qualifiers with the provided view content based on the status. The view is idempotent if ClientToken is provided.</p>', 'CreateViewVersion' => '<p>Publishes a new version of the view identifier.</p> <p>Versions are immutable and monotonically increasing.</p> <p>It returns the highest version if there is no change in content compared to that version. An error is displayed if the supplied ViewContentSha256 is different from the ViewContentSha256 of the <code>$LATEST</code> alias.</p>', 'CreateVocabulary' => '<p>Creates a custom vocabulary associated with your Amazon Connect instance. You can set a custom vocabulary to be your default vocabulary for a given language. Contact Lens for Amazon Connect uses the default vocabulary in post-call and real-time contact analysis sessions for that language.</p>', 'DeactivateEvaluationForm' => '<p>Deactivates an evaluation form in the specified Amazon Connect instance. After a form is deactivated, it is no longer available for users to start new evaluations based on the form. </p>', 'DeleteAttachedFile' => '<p>Deletes an attached file along with the underlying S3 Object.</p> <important> <p>The attached file is <b>permanently deleted</b> if S3 bucket versioning is not enabled.</p> </important>', 'DeleteContactEvaluation' => '<p>Deletes a contact evaluation in the specified Amazon Connect instance.</p>', 'DeleteContactFlow' => '<p>Deletes a flow for the specified Amazon Connect instance.</p>', 'DeleteContactFlowModule' => '<p>Deletes the specified flow module.</p>', 'DeleteEvaluationForm' => '<p>Deletes an evaluation form in the specified Amazon Connect instance. </p> <ul> <li> <p>If the version property is provided, only the specified version of the evaluation form is deleted.</p> </li> <li> <p>If no version is provided, then the full form (all versions) is deleted.</p> </li> </ul>', 'DeleteHoursOfOperation' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Deletes an hours of operation.</p>', 'DeleteInstance' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Deletes the Amazon Connect instance. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-connect-instance.html">Delete your Amazon Connect instance</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <p>Amazon Connect enforces a limit on the total number of instances that you can create or delete in 30 days. If you exceed this limit, you will get an error message indicating there has been an excessive number of attempts at creating or deleting instances. You must wait 30 days before you can restart creating and deleting instances in your account.</p>', 'DeleteIntegrationAssociation' => '<p>Deletes an Amazon Web Services resource association from an Amazon Connect instance. The association must not have any use cases associated with it.</p>', 'DeletePredefinedAttribute' => '<p>Deletes a predefined attribute from the specified Amazon Connect instance.</p>', 'DeletePrompt' => '<p>Deletes a prompt.</p>', 'DeleteQueue' => '<p>Deletes a queue. It isn\'t possible to delete a queue by using the Amazon Connect admin website.</p>', 'DeleteQuickConnect' => '<p>Deletes a quick connect. </p> <important> <p>After calling <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteUser.html">DeleteUser</a>, it\'s important to call <code>DeleteQuickConnect</code> to delete any records related to the deleted users. This will help you:</p> <ul> <li> <p>Avoid dangling resources that impact your service quotas.</p> </li> <li> <p>Remove deleted users so they don\'t appear to agents as transfer options.</p> </li> <li> <p>Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you\'re using <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html">Amazon Connect Global Resiliency</a>. </p> </li> </ul> </important>', 'DeleteRoutingProfile' => '<p>Deletes a routing profile.</p>', 'DeleteRule' => '<p>Deletes a rule for the specified Amazon Connect instance.</p>', 'DeleteSecurityProfile' => '<p>Deletes a security profile.</p>', 'DeleteTaskTemplate' => '<p>Deletes the task template.</p>', 'DeleteTrafficDistributionGroup' => '<p>Deletes a traffic distribution group. This API can be called only in the Region where the traffic distribution group is created.</p> <p>For more information about deleting traffic distribution groups, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-traffic-distribution-groups.html">Delete traffic distribution groups</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'DeleteUseCase' => '<p>Deletes a use case from an integration association.</p>', 'DeleteUser' => '<p>Deletes a user account from the specified Amazon Connect instance.</p> <p>For information about what happens to a user\'s data when their account is deleted, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html">Delete Users from Your Amazon Connect Instance</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <important> <p>After calling DeleteUser, call <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteQuickConnect.html">DeleteQuickConnect</a> to delete any records related to the deleted users. This will help you:</p> <ul> <li> <p>Avoid dangling resources that impact your service quotas.</p> </li> <li> <p>Remove deleted users so they don\'t appear to agents as transfer options.</p> </li> <li> <p>Avoid the disruption of other Amazon Connect processes, such as instance replication and syncing if you\'re using <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-connect-global-resiliency.html">Amazon Connect Global Resiliency</a>. </p> </li> </ul> </important>', 'DeleteUserHierarchyGroup' => '<p>Deletes an existing user hierarchy group. It must not be associated with any agents or have any active child groups.</p>', 'DeleteView' => '<p>Deletes the view entirely. It deletes the view and all associated qualifiers (versions and aliases).</p>', 'DeleteViewVersion' => '<p>Deletes the particular version specified in <code>ViewVersion</code> identifier.</p>', 'DeleteVocabulary' => '<p>Deletes the vocabulary that has the given identifier.</p>', 'DescribeAgentStatus' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Describes an agent status.</p>', 'DescribeAuthenticationProfile' => '<p>This API is in preview release for Amazon Connect and is subject to change. To request access to this API, contact Amazon Web Services Support.</p> <p>Describes the target authentication profile.</p>', 'DescribeContact' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Describes the specified contact. </p> <important> <p>Contact information remains available in Amazon Connect for 24 months, and then it is deleted.</p> <p>Only data from November 12, 2021, and later is returned by this API.</p> </important>', 'DescribeContactEvaluation' => '<p>Describes a contact evaluation in the specified Amazon Connect instance.</p>', 'DescribeContactFlow' => '<p>Describes the specified flow.</p> <p>You can also create and update flows using the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow language</a>.</p> <p>Use the <code>$SAVED</code> alias in the request to describe the <code>SAVED</code> content of a Flow. For example, <code>arn:aws:.../contact-flow/{id}:$SAVED</code>. Once a contact flow is published, <code>$SAVED</code> needs to be supplied to view saved content that has not been published.</p> <p>In the response, <b>Status</b> indicates the flow status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code> status will initiate validation on the content. <code>SAVED</code> does not initiate validation of the content. <code>SAVED</code> | <code>PUBLISHED</code> </p>', 'DescribeContactFlowModule' => '<p>Describes the specified flow module.</p> <p>Use the <code>$SAVED</code> alias in the request to describe the <code>SAVED</code> content of a Flow. For example, <code>arn:aws:.../contact-flow/{id}:$SAVED</code>. Once a contact flow is published, <code>$SAVED</code> needs to be supplied to view saved content that has not been published.</p>', 'DescribeEvaluationForm' => '<p>Describes an evaluation form in the specified Amazon Connect instance. If the version property is not provided, the latest version of the evaluation form is described.</p>', 'DescribeHoursOfOperation' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Describes the hours of operation.</p>', 'DescribeInstance' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns the current state of the specified instance identifier. It tracks the instance while it is being created and returns an error status, if applicable. </p> <p>If an instance is not created successfully, the instance status reason field returns details relevant to the reason. The instance in a failed state is returned only for 24 hours after the CreateInstance API was invoked.</p>', 'DescribeInstanceAttribute' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Describes the specified instance attribute.</p>', 'DescribeInstanceStorageConfig' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Retrieves the current storage configurations for the specified resource type, association ID, and instance ID.</p>', 'DescribePhoneNumber' => '<p>Gets details and status of a phone number that’s claimed to your Amazon Connect instance or traffic distribution group.</p> <important> <p>If the number is claimed to a traffic distribution group, and you are calling in the Amazon Web Services Region where the traffic distribution group was created, you can use either a phone number ARN or UUID value for the <code>PhoneNumberId</code> URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.</p> </important>', 'DescribePredefinedAttribute' => '<p>Describes a predefined attribute for the specified Amazon Connect instance. <i>Predefined attributes</i> are attributes in an Amazon Connect instance that can be used to route contacts to an agent or pools of agents within a queue. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/predefined-attributes.html">Create predefined attributes for routing contacts to agents</a>.</p>', 'DescribePrompt' => '<p>Describes the prompt.</p>', 'DescribeQueue' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Describes the specified queue.</p>', 'DescribeQuickConnect' => '<p>Describes the quick connect.</p>', 'DescribeRoutingProfile' => '<p>Describes the specified routing profile.</p>', 'DescribeRule' => '<p>Describes a rule for the specified Amazon Connect instance.</p>', 'DescribeSecurityProfile' => '<p>Gets basic information about the security profile.</p> <p>For information about security profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>. For a mapping of the API name and user interface name of the security profile permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a>. </p>', 'DescribeTrafficDistributionGroup' => '<p>Gets details and status of a traffic distribution group.</p>', 'DescribeUser' => '<p>Describes the specified user. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID in the Amazon Connect console</a> (it’s the final part of the ARN). The console does not display the user IDs. Instead, list the users and note the IDs provided in the output.</p>', 'DescribeUserHierarchyGroup' => '<p>Describes the specified hierarchy group.</p>', 'DescribeUserHierarchyStructure' => '<p>Describes the hierarchy structure of the specified Amazon Connect instance.</p>', 'DescribeView' => '<p>Retrieves the view for the specified Amazon Connect instance and view identifier.</p> <p>The view identifier can be supplied as a ViewId or ARN.</p> <p> <code>$SAVED</code> needs to be supplied if a view is unpublished.</p> <p>The view identifier can contain an optional qualifier, for example, <code>&lt;view-id&gt;:$SAVED</code>, which is either an actual version number or an Amazon Connect managed qualifier <code>$SAVED | $LATEST</code>. If it is not supplied, then <code>$LATEST</code> is assumed for customer managed views and an error is returned if there is no published content available. Version 1 is assumed for Amazon Web Services managed views.</p>', 'DescribeVocabulary' => '<p>Describes the specified vocabulary.</p>', 'DisassociateAnalyticsDataSet' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Removes the dataset ID associated with a given Amazon Connect instance.</p>', 'DisassociateApprovedOrigin' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Revokes access to integrated applications from Amazon Connect.</p>', 'DisassociateBot' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Revokes authorization from the specified instance to access the specified Amazon Lex or Amazon Lex V2 bot. </p>', 'DisassociateFlow' => '<p>Disassociates a connect resource from a flow.</p>', 'DisassociateInstanceStorageConfig' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Removes the storage type configurations for the specified resource type and association ID.</p>', 'DisassociateLambdaFunction' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Remove the Lambda function from the dropdown options available in the relevant flow blocks.</p>', 'DisassociateLexBot' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Revokes authorization from the specified instance to access the specified Amazon Lex bot.</p>', 'DisassociatePhoneNumberContactFlow' => '<p>Removes the flow association from a phone number claimed to your Amazon Connect instance.</p> <important> <p>If the number is claimed to a traffic distribution group, and you are calling this API using an instance in the Amazon Web Services Region where the traffic distribution group was created, you can use either a full phone number ARN or UUID value for the <code>PhoneNumberId</code> URI request parameter. However, if the number is claimed to a traffic distribution group and you are calling this API using an instance in the alternate Amazon Web Services Region associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.</p> </important>', 'DisassociateQueueQuickConnects' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Disassociates a set of quick connects from a queue.</p>', 'DisassociateRoutingProfileQueues' => '<p>Disassociates a set of queues from a routing profile.</p>', 'DisassociateSecurityKey' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Deletes the specified security key.</p>', 'DisassociateTrafficDistributionGroupUser' => '<p>Disassociates an agent from a traffic distribution group.</p>', 'DisassociateUserProficiencies' => '<p>Disassociates a set of proficiencies from a user.</p>', 'DismissUserContact' => '<p>Dismisses contacts from an agent’s CCP and returns the agent to an available state, which allows the agent to receive a new routed contact. Contacts can only be dismissed if they are in a <code>MISSED</code>, <code>ERROR</code>, <code>ENDED</code>, or <code>REJECTED</code> state in the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">Agent Event Stream</a>.</p>', 'GetAttachedFile' => '<p>Provides a pre-signed URL for download of an approved attached file. This API also returns metadata about the attached file. It will only return a downloadURL if the status of the attached file is <code>APPROVED</code>.</p>', 'GetContactAttributes' => '<p>Retrieves the contact attributes for the specified contact.</p>', 'GetCurrentMetricData' => '<p>Gets the real-time metric data from the specified Amazon Connect instance.</p> <p>For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'GetCurrentUserData' => '<p>Gets the real-time active user data from the specified Amazon Connect instance. </p>', 'GetFederationToken' => '<p>Supports SAML sign-in for Amazon Connect. Retrieves a token for federation. The token is for the Amazon Connect user which corresponds to the IAM credentials that were used to invoke this action. </p> <p>For more information about how SAML sign-in works in Amazon Connect, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/configure-saml.html ">Configure SAML with IAM for Amazon Connect in the <i>Amazon Connect Administrator Guide</i>.</a> </p> <note> <p>This API doesn\'t support root users. If you try to invoke GetFederationToken with root credentials, an error message similar to the following one appears: </p> <p> <code>Provided identity: Principal: .... User: .... cannot be used for federation with Amazon Connect</code> </p> </note>', 'GetFlowAssociation' => '<p>Retrieves the flow associated for a given resource.</p>', 'GetMetricData' => '<p>Gets historical metric data from the specified Amazon Connect instance.</p> <p>For a description of each historical metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <note> <p>We recommend using the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricDataV2.html">GetMetricDataV2</a> API. It provides more flexibility, features, and the ability to query longer time ranges than <code>GetMetricData</code>. Use it to retrieve historical agent and contact metrics for the last 3 months, at varying intervals. You can also use it to build custom dashboards to measure historical queue and agent performance. For example, you can track the number of incoming contacts for the last 7 days, with data split by day, to see how contact volume changed per day of the week.</p> </note>', 'GetMetricDataV2' => '<p>Gets metric data from the specified Amazon Connect instance. </p> <p> <code>GetMetricDataV2</code> offers more features than <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html">GetMetricData</a>, the previous version of this API. It has new metrics, offers filtering at a metric level, and offers the ability to filter and group data by channels, queues, routing profiles, agents, and agent hierarchy levels. It can retrieve historical data for the last 3 months, at varying intervals. </p> <p>For a description of the historical metrics that are supported by <code>GetMetricDataV2</code> and <code>GetMetricData</code>, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical metrics definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'GetPromptFile' => '<p>Gets the prompt file.</p>', 'GetTaskTemplate' => '<p>Gets details about a specific task template in the specified Amazon Connect instance.</p>', 'GetTrafficDistribution' => '<p>Retrieves the current traffic distribution for a given traffic distribution group.</p>', 'ImportPhoneNumber' => '<p>Imports a claimed phone number from an external service, such as Amazon Pinpoint, into an Amazon Connect instance. You can call this API only in the same Amazon Web Services Region where the Amazon Connect instance was created.</p> <important> <p>Call the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html">DescribePhoneNumber</a> API to verify the status of a previous <code>ImportPhoneNumber</code> operation. </p> </important> <p>If you plan to claim or import numbers and then release numbers frequently, contact us for a service quota exception. Otherwise, it is possible you will be blocked from claiming and releasing any more numbers until up to 180 days past the oldest number released has expired. </p> <p> By default you can claim or import and then release up to 200% of your maximum number of active phone numbers. If you claim or import and then release phone numbers using the UI or API during a rolling 180 day cycle that exceeds 200% of your phone number service level quota, you will be blocked from claiming or importing any more numbers until 180 days past the oldest number released has expired. </p> <p>For example, if you already have 99 claimed or imported numbers and a service level quota of 99 phone numbers, and in any 180 day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point you are blocked from claiming any more numbers until you open an Amazon Web Services Support ticket. </p>', 'ListAgentStatuses' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Lists agent statuses.</p>', 'ListAnalyticsDataAssociations' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Lists the association status of requested dataset ID for a given Amazon Connect instance.</p>', 'ListApprovedOrigins' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns a paginated list of all approved origins associated with the instance.</p>', 'ListAuthenticationProfiles' => '<p>This API is in preview release for Amazon Connect and is subject to change. To request access to this API, contact Amazon Web Services Support.</p> <p>Provides summary information about the authentication profiles in a specified Amazon Connect instance.</p>', 'ListBots' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>For the specified version of Amazon Lex, returns a paginated list of all the Amazon Lex bots currently associated with the instance. Use this API to returns both Amazon Lex V1 and V2 bots.</p>', 'ListContactEvaluations' => '<p>Lists contact evaluations in the specified Amazon Connect instance.</p>', 'ListContactFlowModules' => '<p>Provides information about the flow modules for the specified Amazon Connect instance.</p>', 'ListContactFlows' => '<p>Provides information about the flows for the specified Amazon Connect instance.</p> <p>You can also create and update flows using the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow language</a>.</p> <p>For more information about flows, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html">Flows</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListContactReferences' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>For the specified <code>referenceTypes</code>, returns a list of references associated with the contact. <i>References</i> are links to documents that are related to a contact, such as emails, attachments, or URLs.</p>', 'ListDefaultVocabularies' => '<p>Lists the default vocabularies for the specified Amazon Connect instance.</p>', 'ListEvaluationFormVersions' => '<p>Lists versions of an evaluation form in the specified Amazon Connect instance.</p>', 'ListEvaluationForms' => '<p>Lists evaluation forms in the specified Amazon Connect instance.</p>', 'ListFlowAssociations' => '<p>List the flow association based on the filters.</p>', 'ListHoursOfOperations' => '<p>Provides information about the hours of operation for the specified Amazon Connect instance.</p> <p>For more information about hours of operation, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html">Set the Hours of Operation for a Queue</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListInstanceAttributes' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns a paginated list of all attribute types for the given instance.</p>', 'ListInstanceStorageConfigs' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns a paginated list of storage configs for the identified instance and resource type.</p>', 'ListInstances' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Return a list of instances which are in active state, creation-in-progress state, and failed state. Instances that aren\'t successfully created (they are in a failed state) are returned only for 24 hours after the CreateInstance API was invoked.</p>', 'ListIntegrationAssociations' => '<p>Provides summary information about the Amazon Web Services resource associations for the specified Amazon Connect instance.</p>', 'ListLambdaFunctions' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns a paginated list of all Lambda functions that display in the dropdown options in the relevant flow blocks.</p>', 'ListLexBots' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns a paginated list of all the Amazon Lex V1 bots currently associated with the instance. To return both Amazon Lex V1 and V2 bots, use the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListBots.html">ListBots</a> API. </p>', 'ListPhoneNumbers' => '<p>Provides information about the phone numbers for the specified Amazon Connect instance. </p> <p>For more information about phone numbers, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <important> <ul> <li> <p>We recommend using <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a> to return phone number types. ListPhoneNumbers doesn\'t support number types <code>UIFN</code>, <code>SHARED</code>, <code>THIRD_PARTY_TF</code>, and <code>THIRD_PARTY_DID</code>. While it returns numbers of those types, it incorrectly lists them as <code>TOLL_FREE</code> or <code>DID</code>. </p> </li> <li> <p>The phone number <code>Arn</code> value that is returned from each of the items in the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbers.html#connect-ListPhoneNumbers-response-PhoneNumberSummaryList">PhoneNumberSummaryList</a> cannot be used to tag phone number resources. It will fail with a <code>ResourceNotFoundException</code>. Instead, use the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a> API. It returns the new phone number ARN that can be used to tag phone number resources.</p> </li> </ul> </important>', 'ListPhoneNumbersV2' => '<p>Lists phone numbers claimed to your Amazon Connect instance or traffic distribution group. If the provided <code>TargetArn</code> is a traffic distribution group, you can call this API in both Amazon Web Services Regions associated with traffic distribution group.</p> <p>For more information about phone numbers, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html">Set Up Phone Numbers for Your Contact Center</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <note> <ul> <li> <p>When given an instance ARN, <code>ListPhoneNumbersV2</code> returns only the phone numbers claimed to the instance.</p> </li> <li> <p>When given a traffic distribution group ARN <code>ListPhoneNumbersV2</code> returns only the phone numbers claimed to the traffic distribution group.</p> </li> </ul> </note>', 'ListPredefinedAttributes' => '<p>Lists predefined attributes for the specified Amazon Connect instance. <i>Predefined attributes</i> are attributes in an Amazon Connect instance that can be used to route contacts to an agent or pools of agents within a queue. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/predefined-attributes.html">Create predefined attributes for routing contacts to agents</a>.</p>', 'ListPrompts' => '<p>Provides information about the prompts for the specified Amazon Connect instance.</p>', 'ListQueueQuickConnects' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Lists the quick connects associated with a queue.</p>', 'ListQueues' => '<p>Provides information about the queues for the specified Amazon Connect instance.</p> <p>If you do not specify a <code>QueueTypes</code> parameter, both standard and agent queues are returned. This might cause an unexpected truncation of results if you have more than 1000 agents and you limit the number of results of the API call in code.</p> <p>For more information about queues, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html">Queues: Standard and Agent</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListQuickConnects' => '<p>Provides information about the quick connects for the specified Amazon Connect instance. </p>', 'ListRealtimeContactAnalysisSegmentsV2' => '<p>Provides a list of analysis segments for a real-time analysis session. </p>', 'ListRoutingProfileQueues' => '<p>Lists the queues associated with a routing profile.</p>', 'ListRoutingProfiles' => '<p>Provides summary information about the routing profiles for the specified Amazon Connect instance.</p> <p>For more information about routing profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html">Routing Profiles</a> and <a href="https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html">Create a Routing Profile</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListRules' => '<p>List all rules for the specified Amazon Connect instance.</p>', 'ListSecurityKeys' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Returns a paginated list of all security keys associated with the instance.</p>', 'ListSecurityProfileApplications' => '<p>Returns a list of third-party applications in a specific security profile.</p>', 'ListSecurityProfilePermissions' => '<p>Lists the permissions granted to a security profile.</p> <p>For information about security profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>. For a mapping of the API name and user interface name of the security profile permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a>. </p>', 'ListSecurityProfiles' => '<p>Provides summary information about the security profiles for the specified Amazon Connect instance.</p> <p>For more information about security profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>. For a mapping of the API name and user interface name of the security profile permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a>. </p>', 'ListTagsForResource' => '<p>Lists the tags for the specified resource.</p> <p>For sample policies that use tags, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html">Amazon Connect Identity-Based Policy Examples</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListTaskTemplates' => '<p>Lists task templates for the specified Amazon Connect instance.</p>', 'ListTrafficDistributionGroupUsers' => '<p>Lists traffic distribution group users.</p>', 'ListTrafficDistributionGroups' => '<p>Lists traffic distribution groups.</p>', 'ListUseCases' => '<p>Lists the use cases for the integration association. </p>', 'ListUserHierarchyGroups' => '<p>Provides summary information about the hierarchy groups for the specified Amazon Connect instance.</p> <p>For more information about agent hierarchies, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html">Set Up Agent Hierarchies</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ListUserProficiencies' => '<p>Lists proficiencies associated with a user.</p>', 'ListUsers' => '<p>Provides summary information about the users for the specified Amazon Connect instance.</p>', 'ListViewVersions' => '<p>Returns all the available versions for the specified Amazon Connect instance and view identifier.</p> <p>Results will be sorted from highest to lowest.</p>', 'ListViews' => '<p>Returns views in the given instance.</p> <p>Results are sorted primarily by type, and secondarily by name.</p>', 'MonitorContact' => '<p>Initiates silent monitoring of a contact. The Contact Control Panel (CCP) of the user specified by <i>userId</i> will be set to silent monitoring mode on the contact.</p>', 'PauseContact' => '<p>Allows pausing an ongoing task contact.</p>', 'PutUserStatus' => '<p>Changes the current status of a user or agent in Amazon Connect. If the agent is currently handling a contact, this sets the agent\'s next status.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/metrics-agent-status.html">Agent status</a> and <a href="https://docs.aws.amazon.com/connect/latest/adminguide/set-next-status.html">Set your next status</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ReleasePhoneNumber' => '<p>Releases a phone number previously claimed to an Amazon Connect instance or traffic distribution group. You can call this API only in the Amazon Web Services Region where the number was claimed.</p> <important> <p>To release phone numbers from a traffic distribution group, use the <code>ReleasePhoneNumber</code> API, not the Amazon Connect admin website.</p> <p>After releasing a phone number, the phone number enters into a cooldown period for up to 180 days. It cannot be searched for or claimed again until the period has ended. If you accidentally release a phone number, contact Amazon Web Services Support.</p> </important> <p>If you plan to claim and release numbers frequently, contact us for a service quota exception. Otherwise, it is possible you will be blocked from claiming and releasing any more numbers until up to 180 days past the oldest number released has expired.</p> <p>By default you can claim and release up to 200% of your maximum number of active phone numbers. If you claim and release phone numbers using the UI or API during a rolling 180 day cycle that exceeds 200% of your phone number service level quota, you will be blocked from claiming any more numbers until 180 days past the oldest number released has expired. </p> <p>For example, if you already have 99 claimed numbers and a service level quota of 99 phone numbers, and in any 180 day period you release 99, claim 99, and then release 99, you will have exceeded the 200% limit. At that point you are blocked from claiming any more numbers until you open an Amazon Web Services support ticket.</p>', 'ReplicateInstance' => '<p>Replicates an Amazon Connect instance in the specified Amazon Web Services Region and copies configuration information for Amazon Connect resources across Amazon Web Services Regions. </p> <p>For more information about replicating an Amazon Connect instance, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html">Create a replica of your existing Amazon Connect instance</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ResumeContact' => '<p>Allows resuming a task contact in a paused state.</p>', 'ResumeContactRecording' => '<p>When a contact is being recorded, and the recording has been suspended using SuspendContactRecording, this API resumes recording whatever recording is selected in the flow configuration: call, screen, or both. If only call recording or only screen recording is enabled, then it would resume.</p> <p>Voice and screen recordings are supported.</p>', 'SearchAgentStatuses' => '<p>Searches AgentStatuses in an Amazon Connect instance, with optional filtering.</p>', 'SearchAvailablePhoneNumbers' => '<p>Searches for available phone numbers that you can claim to your Amazon Connect instance or traffic distribution group. If the provided <code>TargetArn</code> is a traffic distribution group, you can call this API in both Amazon Web Services Regions associated with the traffic distribution group.</p>', 'SearchContactFlowModules' => '<p>Searches the flow modules in an Amazon Connect instance, with optional filtering.</p>', 'SearchContactFlows' => '<p>Searches the contact flows in an Amazon Connect instance, with optional filtering.</p>', 'SearchContacts' => '<p>Searches contacts in an Amazon Connect instance.</p>', 'SearchHoursOfOperations' => '<p>Searches the hours of operation in an Amazon Connect instance, with optional filtering.</p>', 'SearchPredefinedAttributes' => '<p>Searches predefined attributes that meet certain criteria. <i>Predefined attributes</i> are attributes in an Amazon Connect instance that can be used to route contacts to an agent or pools of agents within a queue. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/predefined-attributes.html">Create predefined attributes for routing contacts to agents</a>.</p>', 'SearchPrompts' => '<p>Searches prompts in an Amazon Connect instance, with optional filtering.</p>', 'SearchQueues' => '<p>Searches queues in an Amazon Connect instance, with optional filtering.</p>', 'SearchQuickConnects' => '<p>Searches quick connects in an Amazon Connect instance, with optional filtering.</p>', 'SearchResourceTags' => '<p>Searches tags used in an Amazon Connect instance using optional search criteria.</p>', 'SearchRoutingProfiles' => '<p>Searches routing profiles in an Amazon Connect instance, with optional filtering.</p>', 'SearchSecurityProfiles' => '<p>Searches security profiles in an Amazon Connect instance, with optional filtering.</p> <p>For information about security profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>. For a mapping of the API name and user interface name of the security profile permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a>. </p>', 'SearchUserHierarchyGroups' => '<p>Searches UserHierarchyGroups in an Amazon Connect instance, with optional filtering.</p> <important> <p>The UserHierarchyGroup with <code>"LevelId": "0"</code> is the foundation for building levels on top of an instance. It is not user-definable, nor is it visible in the UI.</p> </important>', 'SearchUsers' => '<p>Searches users in an Amazon Connect instance, with optional filtering. </p> <note> <p> <code>AfterContactWorkTimeLimit</code> is returned in milliseconds. </p> </note>', 'SearchVocabularies' => '<p>Searches for vocabularies within a specific Amazon Connect instance using <code>State</code>, <code>NameStartsWith</code>, and <code>LanguageCode</code>.</p>', 'SendChatIntegrationEvent' => '<p>Processes chat integration events from Amazon Web Services or external integrations to Amazon Connect. A chat integration event includes:</p> <ul> <li> <p>SourceId, DestinationId, and Subtype: a set of identifiers, uniquely representing a chat</p> </li> <li> <p> ChatEvent: details of the chat action to perform such as sending a message, event, or disconnecting from a chat</p> </li> </ul> <p>When a chat integration event is sent with chat identifiers that do not map to an active chat contact, a new chat contact is also created before handling chat action. </p> <p>Access to this API is currently restricted to Amazon Pinpoint for supporting SMS integration. </p>', 'StartAttachedFileUpload' => '<p>Provides a pre-signed Amazon S3 URL in response for uploading your content.</p> <important> <p>You may only use this API to upload attachments to an <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Amazon Connect Case</a>.</p> </important>', 'StartChatContact' => '<p>Initiates a flow to start a new chat for the customer. Response of this API provides a token required to obtain credentials from the <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a> API in the Amazon Connect Participant Service.</p> <p>When a new chat contact is successfully created, clients must subscribe to the participant’s connection for the created chat within 5 minutes. This is achieved by invoking <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a> with WEBSOCKET and CONNECTION_CREDENTIALS. </p> <p>A 429 error occurs in the following situations:</p> <ul> <li> <p>API rate limit is exceeded. API TPS throttling returns a <code>TooManyRequests</code> exception.</p> </li> <li> <p>The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">quota for concurrent active chats</a> is exceeded. Active chat throttling returns a <code>LimitExceededException</code>.</p> </li> </ul> <p>If you use the <code>ChatDurationInMinutes</code> parameter and receive a 400 error, your account may not support the ability to configure custom chat durations. For more information, contact Amazon Web Services Support. </p> <p>For more information about chat, see the following topics in the <i>Amazon Connect Administrator Guide</i>: </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/connect/latest/adminguide/web-and-mobile-chat.html">Concepts: Web and mobile messaging capabilities in Amazon Connect</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-best-practices.html#bp-security-chat">Amazon Connect Chat security best practices</a> </p> </li> </ul>', 'StartContactEvaluation' => '<p>Starts an empty evaluation in the specified Amazon Connect instance, using the given evaluation form for the particular contact. The evaluation form version used for the contact evaluation corresponds to the currently activated version. If no version is activated for the evaluation form, the contact evaluation cannot be started. </p> <note> <p>Evaluations created through the public API do not contain answer values suggested from automation.</p> </note>', 'StartContactRecording' => '<p>Starts recording the contact: </p> <ul> <li> <p>If the API is called <i>before</i> the agent joins the call, recording starts when the agent joins the call.</p> </li> <li> <p>If the API is called <i>after</i> the agent joins the call, recording starts at the time of the API call.</p> </li> </ul> <p>StartContactRecording is a one-time action. For example, if you use StopContactRecording to stop recording an ongoing call, you can\'t use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend and resume it, such as when collecting sensitive information (for example, a credit card number), use SuspendContactRecording and ResumeContactRecording.</p> <p>You can use this API to override the recording behavior configured in the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html">Set recording behavior</a> block.</p> <p>Only voice recordings are supported at this time.</p>', 'StartContactStreaming' => '<p> Initiates real-time message streaming for a new chat contact.</p> <p> For more information about message streaming, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html">Enable real-time chat message streaming</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <p>For more information about chat, see the following topics in the <i>Amazon Connect Administrator Guide</i>: </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/connect/latest/adminguide/web-and-mobile-chat.html">Concepts: Web and mobile messaging capabilities in Amazon Connect</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-best-practices.html#bp-security-chat">Amazon Connect Chat security best practices</a> </p> </li> </ul>', 'StartOutboundVoiceContact' => '<p>Places an outbound call to a contact, and then initiates the flow. It performs the actions in the flow that\'s specified (in <code>ContactFlowId</code>).</p> <p>Agents do not initiate the outbound API, which means that they do not dial the contact. If the flow places an outbound call to a contact, and then puts the contact in queue, the call is then routed to the agent, like any other inbound case.</p> <p>There is a 60-second dialing timeout for this operation. If the call is not connected after 60 seconds, it fails.</p> <note> <p>UK numbers with a 447 prefix are not allowed by default. Before you can dial these UK mobile numbers, you must submit a service quota increase request. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>. </p> </note> <note> <p>Campaign calls are not allowed by default. Before you can make a call with <code>TrafficType</code> = <code>CAMPAIGN</code>, you must submit a service quota increase request to the quota <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#outbound-communications-quotas">Amazon Connect campaigns</a>. </p> </note>', 'StartTaskContact' => '<p>Initiates a flow to start a new task contact. For more information about task contacts, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/tasks.html">Concepts: Tasks in Amazon Connect</a> in the <i>Amazon Connect Administrator Guide</i>. </p> <p>When using <code>PreviousContactId</code> and <code>RelatedContactId</code> input parameters, note the following:</p> <ul> <li> <p> <code>PreviousContactId</code> </p> <ul> <li> <p>Any updates to user-defined task contact attributes on any contact linked through the same <code>PreviousContactId</code> will affect every contact in the chain.</p> </li> <li> <p>There can be a maximum of 12 linked task contacts in a chain. That is, 12 task contacts can be created that share the same <code>PreviousContactId</code>.</p> </li> </ul> </li> <li> <p> <code>RelatedContactId</code> </p> <ul> <li> <p>Copies contact attributes from the related task contact to the new contact.</p> </li> <li> <p>Any update on attributes in a new task contact does not update attributes on previous contact.</p> </li> <li> <p>There’s no limit on the number of task contacts that can be created that use the same <code>RelatedContactId</code>.</p> </li> </ul> </li> </ul> <p>In addition, when calling StartTaskContact include only one of these parameters: <code>ContactFlowID</code>, <code>QuickConnectID</code>, or <code>TaskTemplateID</code>. Only one parameter is required as long as the task template has a flow configured to run it. If more than one parameter is specified, or only the <code>TaskTemplateID</code> is specified but it does not have a flow configured, the request returns an error because Amazon Connect cannot identify the unique flow to run when the task is created.</p> <p>A <code>ServiceQuotaExceededException</code> occurs when the number of open tasks exceeds the active tasks quota or there are already 12 tasks referencing the same <code>PreviousContactId</code>. For more information about service quotas for task contacts, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect service quotas</a> in the <i>Amazon Connect Administrator Guide</i>. </p>', 'StartWebRTCContact' => '<p>Places an inbound in-app, web, or video call to a contact, and then initiates the flow. It performs the actions in the flow that are specified (in ContactFlowId) and present in the Amazon Connect instance (specified as InstanceId).</p>', 'StopContact' => '<p>Ends the specified contact. Use this API to stop queued callbacks. It does not work for voice contacts that use the following initiation methods:</p> <ul> <li> <p>DISCONNECT</p> </li> <li> <p>TRANSFER</p> </li> <li> <p>QUEUE_TRANSFER</p> </li> <li> <p>EXTERNAL_OUTBOUND</p> </li> <li> <p>MONITOR</p> </li> </ul> <p>Chat and task contacts can be terminated in any state, regardless of initiation method.</p>', 'StopContactRecording' => '<p>Stops recording a call when a contact is being recorded. StopContactRecording is a one-time action. If you use StopContactRecording to stop recording an ongoing call, you can\'t use StartContactRecording to restart it. For scenarios where the recording has started and you want to suspend it for sensitive information (for example, to collect a credit card number), and then restart it, use SuspendContactRecording and ResumeContactRecording.</p> <p>Only voice recordings are supported at this time.</p>', 'StopContactStreaming' => '<p> Ends message streaming on a specified contact. To restart message streaming on that contact, call the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html">StartContactStreaming</a> API. </p>', 'SubmitContactEvaluation' => '<p>Submits a contact evaluation in the specified Amazon Connect instance. Answers included in the request are merged with existing answers for the given evaluation. If no answers or notes are passed, the evaluation is submitted with the existing answers and notes. You can delete an answer or note by passing an empty object (<code>{}</code>) to the question identifier. </p> <p>If a contact evaluation is already in submitted state, this operation will trigger a resubmission.</p>', 'SuspendContactRecording' => '<p>When a contact is being recorded, this API suspends recording whatever is selected in the flow configuration: call, screen, or both. If only call recording or only screen recording is enabled, then it would be suspended. For example, you might suspend the screen recording while collecting sensitive information, such as a credit card number. Then use ResumeContactRecording to restart recording the screen.</p> <p>The period of time that the recording is suspended is filled with silence in the final recording.</p> <p>Voice and screen recordings are supported.</p>', 'TagContact' => '<p>Adds the specified tags to the contact resource. For more information about this API is used, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/granular-billing.html">Set up granular billing for a detailed view of your Amazon Connect usage</a>. </p>', 'TagResource' => '<p>Adds the specified tags to the specified resource.</p> <p>Some of the supported resource types are agents, routing profiles, queues, quick connects, contact flows, agent statuses, hours of operation, phone numbers, security profiles, and task templates. For a complete list, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/tagging.html">Tagging resources in Amazon Connect</a>.</p> <p>For sample policies that use tags, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html">Amazon Connect Identity-Based Policy Examples</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'TransferContact' => '<p>Transfers contacts from one agent or queue to another agent or queue at any point after a contact is created. You can transfer a contact to another queue by providing the flow which orchestrates the contact to the destination queue. This gives you more control over contact handling and helps you adhere to the service level agreement (SLA) guaranteed to your customers.</p> <p>Note the following requirements:</p> <ul> <li> <p>Transfer is supported for only <code>TASK</code> contacts.</p> </li> <li> <p>Do not use both <code>QueueId</code> and <code>UserId</code> in the same call.</p> </li> <li> <p>The following flow types are supported: Inbound flow, Transfer to agent flow, and Transfer to queue flow.</p> </li> <li> <p>The <code>TransferContact</code> API can be called only on active contacts.</p> </li> <li> <p>A contact cannot be transferred more than 11 times.</p> </li> </ul>', 'UntagContact' => '<p>Removes the specified tags from the contact resource. For more information about this API is used, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/granular-billing.html">Set up granular billing for a detailed view of your Amazon Connect usage</a>.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified resource.</p>', 'UpdateAgentStatus' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates agent status.</p>', 'UpdateAuthenticationProfile' => '<p>This API is in preview release for Amazon Connect and is subject to change. To request access to this API, contact Amazon Web Services Support.</p> <p>Updates the selected authentication profile.</p>', 'UpdateContact' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Adds or updates user-defined contact information associated with the specified contact. At least one field to be updated must be present in the request.</p> <important> <p>You can add or update user-defined contact information for both ongoing and completed contacts.</p> </important>', 'UpdateContactAttributes' => '<p>Creates or updates user-defined contact attributes associated with the specified contact.</p> <p>You can create or update user-defined attributes for both ongoing and completed contacts. For example, while the call is active, you can update the customer\'s name or the reason the customer called. You can add notes about steps that the agent took during the call that display to the next agent that takes the call. You can also update attributes for a contact using data from your CRM application and save the data with the contact in Amazon Connect. You could also flag calls for additional analysis, such as legal review or to identify abusive callers.</p> <p>Contact attributes are available in Amazon Connect for 24 months, and are then deleted. For information about contact record retention and the maximum size of the contact record attributes section, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits">Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>. </p>', 'UpdateContactEvaluation' => '<p>Updates details about a contact evaluation in the specified Amazon Connect instance. A contact evaluation must be in draft state. Answers included in the request are merged with existing answers for the given evaluation. An answer or note can be deleted by passing an empty object (<code>{}</code>) to the question identifier. </p>', 'UpdateContactFlowContent' => '<p>Updates the specified flow.</p> <p>You can also create and update flows using the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow language</a>.</p> <p>Use the <code>$SAVED</code> alias in the request to describe the <code>SAVED</code> content of a Flow. For example, <code>arn:aws:.../contact-flow/{id}:$SAVED</code>. Once a contact flow is published, <code>$SAVED</code> needs to be supplied to view saved content that has not been published.</p>', 'UpdateContactFlowMetadata' => '<p>Updates metadata about specified flow.</p>', 'UpdateContactFlowModuleContent' => '<p>Updates specified flow module for the specified Amazon Connect instance. </p> <p>Use the <code>$SAVED</code> alias in the request to describe the <code>SAVED</code> content of a Flow. For example, <code>arn:aws:.../contact-flow/{id}:$SAVED</code>. Once a contact flow is published, <code>$SAVED</code> needs to be supplied to view saved content that has not been published.</p>', 'UpdateContactFlowModuleMetadata' => '<p>Updates metadata about specified flow module.</p>', 'UpdateContactFlowName' => '<p>The name of the flow.</p> <p>You can also create and update flows using the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow language</a>.</p>', 'UpdateContactRoutingData' => '<p>Updates routing priority and age on the contact (<b>QueuePriority</b> and <b>QueueTimeAdjustmentInSeconds</b>). These properties can be used to change a customer\'s position in the queue. For example, you can move a contact to the back of the queue by setting a lower routing priority relative to other contacts in queue; or you can move a contact to the front of the queue by increasing the routing age which will make the contact look artificially older and therefore higher up in the first-in-first-out routing order. Note that adjusting the routing age of a contact affects only its position in queue, and not its actual queue wait time as reported through metrics. These properties can also be updated by using <a href="https://docs.aws.amazon.com/connect/latest/adminguide/change-routing-priority.html">the Set routing priority / age flow block</a>.</p> <note> <p>Either <b>QueuePriority</b> or <b>QueueTimeAdjustmentInSeconds</b> should be provided within the request body, but not both.</p> </note>', 'UpdateContactSchedule' => '<p>Updates the scheduled time of a task contact that is already scheduled.</p>', 'UpdateEvaluationForm' => '<p>Updates details about a specific evaluation form version in the specified Amazon Connect instance. Question and section identifiers cannot be duplicated within the same evaluation form.</p> <p>This operation does not support partial updates. Instead it does a full update of evaluation form content.</p>', 'UpdateHoursOfOperation' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the hours of operation.</p>', 'UpdateInstanceAttribute' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the value for the specified attribute type.</p>', 'UpdateInstanceStorageConfig' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates an existing configuration for a resource type. This API is idempotent.</p>', 'UpdateParticipantRoleConfig' => '<p>Updates timeouts for when human chat participants are to be considered idle, and when agents are automatically disconnected from a chat due to idleness. You can set four timers:</p> <ul> <li> <p>Customer idle timeout</p> </li> <li> <p>Customer auto-disconnect timeout</p> </li> <li> <p>Agent idle timeout</p> </li> <li> <p>Agent auto-disconnect timeout</p> </li> </ul> <p>For more information about how chat timeouts work, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-chat-timeouts.html">Set up chat timeouts for human participants</a>. </p>', 'UpdatePhoneNumber' => '<p>Updates your claimed phone number from its current Amazon Connect instance or traffic distribution group to another Amazon Connect instance or traffic distribution group in the same Amazon Web Services Region.</p> <important> <p>After using this API, you must verify that the phone number is attached to the correct flow in the target instance or traffic distribution group. You need to do this because the API switches only the phone number to a new instance or traffic distribution group. It doesn\'t migrate the flow configuration of the phone number, too.</p> <p>You can call <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html">DescribePhoneNumber</a> API to verify the status of a previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html">UpdatePhoneNumber</a> operation.</p> </important>', 'UpdatePhoneNumberMetadata' => '<p>Updates a phone number’s metadata.</p> <important> <p>To verify the status of a previous UpdatePhoneNumberMetadata operation, call the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html">DescribePhoneNumber</a> API.</p> </important>', 'UpdatePredefinedAttribute' => '<p>Updates a predefined attribute for the specified Amazon Connect instance. <i>Predefined attributes</i> are attributes in an Amazon Connect instance that can be used to route contacts to an agent or pools of agents within a queue. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/predefined-attributes.html">Create predefined attributes for routing contacts to agents</a>.</p>', 'UpdatePrompt' => '<p>Updates a prompt.</p>', 'UpdateQueueHoursOfOperation' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the hours of operation for the specified queue.</p>', 'UpdateQueueMaxContacts' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the maximum number of contacts allowed in a queue before it is considered full.</p>', 'UpdateQueueName' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the name and description of a queue. At least <code>Name</code> or <code>Description</code> must be provided.</p>', 'UpdateQueueOutboundCallerConfig' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the outbound caller ID name, number, and outbound whisper flow for a specified queue.</p> <important> <ul> <li> <p>If the phone number is claimed to a traffic distribution group that was created in the same Region as the Amazon Connect instance where you are calling this API, then you can use a full phone number ARN or a UUID for <code>OutboundCallerIdNumberId</code>. However, if the phone number is claimed to a traffic distribution group that is in one Region, and you are calling this API from an instance in another Amazon Web Services Region that is associated with the traffic distribution group, you must provide a full phone number ARN. If a UUID is provided in this scenario, you will receive a <code>ResourceNotFoundException</code>.</p> </li> <li> <p>Only use the phone number ARN format that doesn\'t contain <code>instance</code> in the path, for example, <code>arn:aws:connect:us-east-1:1234567890:phone-number/uuid</code>. This is the same ARN format that is returned when you call the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a> API.</p> </li> <li> <p>If you plan to use IAM policies to allow/deny access to this API for phone number resources claimed to a traffic distribution group, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_resource-level-policy-examples.html#allow-deny-queue-actions-replica-region">Allow or Deny queue API actions for phone numbers in a replica Region</a>.</p> </li> </ul> </important>', 'UpdateQueueStatus' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Updates the status of the queue.</p>', 'UpdateQuickConnectConfig' => '<p>Updates the configuration settings for the specified quick connect.</p>', 'UpdateQuickConnectName' => '<p>Updates the name and description of a quick connect. The request accepts the following data in JSON format. At least <code>Name</code> or <code>Description</code> must be provided.</p>', 'UpdateRoutingProfileAgentAvailabilityTimer' => '<p>Whether agents with this routing profile will have their routing order calculated based on <i>time since their last inbound contact</i> or <i>longest idle time</i>. </p>', 'UpdateRoutingProfileConcurrency' => '<p>Updates the channels that agents can handle in the Contact Control Panel (CCP) for a routing profile.</p>', 'UpdateRoutingProfileDefaultOutboundQueue' => '<p>Updates the default outbound queue of a routing profile.</p>', 'UpdateRoutingProfileName' => '<p>Updates the name and description of a routing profile. The request accepts the following data in JSON format. At least <code>Name</code> or <code>Description</code> must be provided.</p>', 'UpdateRoutingProfileQueues' => '<p>Updates the properties associated with a set of queues for a routing profile.</p>', 'UpdateRule' => '<p>Updates a rule for the specified Amazon Connect instance.</p> <p>Use the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html">Rules Function language</a> to code conditions for the rule. </p>', 'UpdateSecurityProfile' => '<p>Updates a security profile.</p> <p>For information about security profiles, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html">Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>. For a mapping of the API name and user interface name of the security profile permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a>. </p>', 'UpdateTaskTemplate' => '<p>Updates details about a specific task template in the specified Amazon Connect instance. This operation does not support partial updates. Instead it does a full update of template content.</p>', 'UpdateTrafficDistribution' => '<p>Updates the traffic distribution for a given traffic distribution group. </p> <note> <p>The <code>SignInConfig</code> distribution is available only on a default <code>TrafficDistributionGroup</code> (see the <code>IsDefault</code> parameter in the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html">TrafficDistributionGroup</a> data type). If you call <code>UpdateTrafficDistribution</code> with a modified <code>SignInConfig</code> and a non-default <code>TrafficDistributionGroup</code>, an <code>InvalidRequestException</code> is returned.</p> </note> <p>For more information about updating a traffic distribution group, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/update-telephony-traffic-distribution.html">Update telephony traffic distribution across Amazon Web Services Regions </a> in the <i>Amazon Connect Administrator Guide</i>. </p>', 'UpdateUserHierarchy' => '<p>Assigns the specified hierarchy group to the specified user.</p>', 'UpdateUserHierarchyGroupName' => '<p>Updates the name of the user hierarchy group. </p>', 'UpdateUserHierarchyStructure' => '<p>Updates the user hierarchy structure: add, remove, and rename user hierarchy levels.</p>', 'UpdateUserIdentityInfo' => '<p>Updates the identity information for the specified user.</p> <important> <p>We strongly recommend limiting who has the ability to invoke <code>UpdateUserIdentityInfo</code>. Someone with that ability can change the login credentials of other users by changing their email address. This poses a security risk to your organization. They can change the email address of a user to the attacker\'s email address, and then reset the password through email. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html">Best Practices for Security Profiles</a> in the <i>Amazon Connect Administrator Guide</i>.</p> </important>', 'UpdateUserPhoneConfig' => '<p>Updates the phone configuration settings for the specified user.</p>', 'UpdateUserProficiencies' => '<p>Updates the properties associated with the proficiencies of a user.</p>', 'UpdateUserRoutingProfile' => '<p>Assigns the specified routing profile to the specified user.</p>', 'UpdateUserSecurityProfiles' => '<p>Assigns the specified security profiles to the specified user.</p>', 'UpdateViewContent' => '<p>Updates the view content of the given view identifier in the specified Amazon Connect instance.</p> <p>It performs content validation if <code>Status</code> is set to <code>SAVED</code> and performs full content validation if <code>Status</code> is <code>PUBLISHED</code>. Note that the <code>$SAVED</code> alias\' content will always be updated, but the <code>$LATEST</code> alias\' content will only be updated if <code>Status</code> is <code>PUBLISHED</code>.</p>', 'UpdateViewMetadata' => '<p>Updates the view metadata. Note that either <code>Name</code> or <code>Description</code> must be provided.</p>', ], 'shapes' => [ 'ARN' => [ 'base' => NULL, 'refs' => [ 'ActivateEvaluationFormResponse$EvaluationFormArn' => '<p>The Amazon Resource Name (ARN) for the evaluation form resource.</p>', 'AgentHierarchyGroup$Arn' => '<p>The Amazon Resource Name (ARN) of the group.</p>', 'AgentStatus$AgentStatusARN' => '<p>The Amazon Resource Name (ARN) of the agent status.</p>', 'AgentStatusReference$StatusArn' => '<p>The Amazon Resource Name (ARN) of the agent\'s status.</p>', 'AgentStatusSummary$Arn' => '<p>The Amazon Resource Name (ARN) for the agent status.</p>', 'AnalyticsDataAssociationResult$ResourceShareArn' => '<p>The Amazon Resource Name (ARN) of the Resource Access Manager share. </p>', 'AssociateAnalyticsDataSetResponse$ResourceShareArn' => '<p>The Amazon Resource Name (ARN) of the Resource Access Manager share. </p>', 'AssociateFlowRequest$ResourceId' => '<p>The identifier of the resource.</p>', 'AssociateFlowRequest$FlowId' => '<p>The identifier of the flow.</p>', 'AttachedFile$FileArn' => '<p>The unique identifier of the attached file resource (ARN).</p>', 'AttachedFile$AssociatedResourceArn' => '<p>The resource to which the attached file is (being) uploaded to. <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Cases</a> are the only current supported resource.</p> <note> <p>This value must be a valid ARN.</p> </note>', 'AuthenticationProfile$Arn' => '<p>The Amazon Resource Name (ARN) for the authentication profile.</p>', 'AuthenticationProfileSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the authentication profile summary.</p>', 'BatchGetAttachedFileMetadataRequest$AssociatedResourceArn' => '<p>The resource to which the attached file is (being) uploaded to. <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Cases</a> are the only current supported resource.</p> <note> <p>This value must be a valid ARN.</p> </note>', 'ClaimPhoneNumberRequest$TargetArn' => '<p>The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number inbound traffic is routed through. You must enter <code>InstanceId</code> or <code>TargetArn</code>. </p>', 'ClaimPhoneNumberResponse$PhoneNumberArn' => '<p>The Amazon Resource Name (ARN) of the phone number.</p>', 'ClaimedPhoneNumberSummary$PhoneNumberArn' => '<p>The Amazon Resource Name (ARN) of the phone number.</p>', 'ClaimedPhoneNumberSummary$TargetArn' => '<p>The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number inbound traffic is routed through.</p>', 'ClaimedPhoneNumberSummary$SourcePhoneNumberArn' => '<p>The claimed phone number ARN that was previously imported from the external service, such as Amazon Pinpoint. If it is from Amazon Pinpoint, it looks like the ARN of the phone number that was imported from Amazon Pinpoint.</p>', 'CompleteAttachedFileUploadRequest$AssociatedResourceArn' => '<p>The resource to which the attached file is (being) uploaded to. <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Cases</a> are the only current supported resource.</p> <note> <p>This value must be a valid ARN.</p> </note>', 'Contact$Arn' => '<p>The Amazon Resource Name (ARN) for the contact.</p>', 'ContactFlow$Arn' => '<p>The Amazon Resource Name (ARN) of the flow.</p>', 'ContactFlowModule$Arn' => '<p>The Amazon Resource Name (ARN).</p>', 'ContactFlowModuleSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the flow module.</p>', 'ContactFlowSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the flow.</p>', 'ContactSearchSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the contact.</p>', 'CreateAgentStatusResponse$AgentStatusARN' => '<p>The Amazon Resource Name (ARN) of the agent status.</p>', 'CreateContactFlowModuleResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the flow module.</p>', 'CreateContactFlowResponse$ContactFlowArn' => '<p>The Amazon Resource Name (ARN) of the flow.</p>', 'CreateEvaluationFormResponse$EvaluationFormArn' => '<p>The Amazon Resource Name (ARN) for the evaluation form resource.</p>', 'CreateHoursOfOperationResponse$HoursOfOperationArn' => '<p>The Amazon Resource Name (ARN) for the hours of operation.</p>', 'CreateInstanceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the instance.</p>', 'CreateIntegrationAssociationRequest$IntegrationArn' => '<p>The Amazon Resource Name (ARN) of the integration.</p> <note> <p>When integrating with Amazon Pinpoint, the Amazon Connect and Amazon Pinpoint instances must be in the same account.</p> </note>', 'CreateIntegrationAssociationResponse$IntegrationAssociationArn' => '<p>The Amazon Resource Name (ARN) for the association.</p>', 'CreatePromptResponse$PromptARN' => '<p>The Amazon Resource Name (ARN) of the prompt.</p>', 'CreateQueueResponse$QueueArn' => '<p>The Amazon Resource Name (ARN) of the queue.</p>', 'CreateQuickConnectResponse$QuickConnectARN' => '<p>The Amazon Resource Name (ARN) for the quick connect. </p>', 'CreateRoutingProfileResponse$RoutingProfileArn' => '<p>The Amazon Resource Name (ARN) of the routing profile.</p>', 'CreateRuleResponse$RuleArn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'CreateSecurityProfileResponse$SecurityProfileArn' => '<p>The Amazon Resource Name (ARN) for the security profile.</p>', 'CreateUseCaseResponse$UseCaseArn' => '<p>The Amazon Resource Name (ARN) for the use case.</p>', 'CreateUserHierarchyGroupResponse$HierarchyGroupArn' => '<p>The Amazon Resource Name (ARN) of the hierarchy group. </p>', 'CreateUserResponse$UserArn' => '<p>The Amazon Resource Name (ARN) of the user account.</p>', 'CreateVocabularyResponse$VocabularyArn' => '<p>The Amazon Resource Name (ARN) of the custom vocabulary.</p>', 'CreatedByInfo$ConnectUserArn' => '<p>An agent ARN representing a <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-resources-for-iam-policies">connect user</a>.</p>', 'CreatedByInfo$AWSIdentityArn' => '<p>STS or IAM ARN representing the identity of API Caller. SDK users cannot populate this and this value is calculated automatically if <code>ConnectUserArn</code> is not provided.</p>', 'DeactivateEvaluationFormResponse$EvaluationFormArn' => '<p>The Amazon Resource Name (ARN) for the evaluation form resource.</p>', 'DeleteAttachedFileRequest$AssociatedResourceArn' => '<p>The resource to which the attached file is (being) uploaded to. <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Cases</a> are the only current supported resource.</p> <note> <p>This value must be a valid ARN.</p> </note>', 'DeleteVocabularyResponse$VocabularyArn' => '<p>The Amazon Resource Name (ARN) of the custom vocabulary.</p>', 'DisassociateFlowRequest$ResourceId' => '<p>The identifier of the resource.</p>', 'Evaluation$EvaluationArn' => '<p>The Amazon Resource Name (ARN) for the contact evaluation resource.</p>', 'EvaluationForm$EvaluationFormArn' => '<p>The Amazon Resource Name (ARN) for the evaluation form resource.</p>', 'EvaluationForm$CreatedBy' => '<p>The Amazon Resource Name (ARN) of the user who created the evaluation form.</p>', 'EvaluationForm$LastModifiedBy' => '<p>The Amazon Resource Name (ARN) of the user who last updated the evaluation form.</p>', 'EvaluationFormContent$EvaluationFormArn' => '<p>The Amazon Resource Name (ARN) for the evaluation form resource.</p>', 'EvaluationFormSummary$EvaluationFormArn' => '<p>The Amazon Resource Name (ARN) for the evaluation form resource.</p>', 'EvaluationFormSummary$CreatedBy' => '<p>The Amazon Resource Name (ARN) of the user who created the evaluation form.</p>', 'EvaluationFormSummary$LastModifiedBy' => '<p>The Amazon Resource Name (ARN) of the user who last updated the evaluation form.</p>', 'EvaluationFormSummary$LastActivatedBy' => '<p> The Amazon Resource Name (ARN) of the user who last activated the evaluation form.</p>', 'EvaluationFormVersionSummary$EvaluationFormArn' => '<p>The Amazon Resource Name (ARN) for the evaluation form resource.</p>', 'EvaluationFormVersionSummary$CreatedBy' => '<p>The Amazon Resource Name (ARN) of the user who created the evaluation form.</p>', 'EvaluationFormVersionSummary$LastModifiedBy' => '<p>The Amazon Resource Name (ARN) of the user who last updated the evaluation form.</p>', 'EvaluationMetadata$EvaluatorArn' => '<p>The Amazon Resource Name (ARN) of the user who last updated the evaluation.</p>', 'EvaluationSummary$EvaluationArn' => '<p>The Amazon Resource Name (ARN) for the contact evaluation resource.</p>', 'EvaluationSummary$EvaluatorArn' => '<p>The Amazon Resource Name (ARN) of the user who last updated the evaluation.</p>', 'FlowAssociationSummary$ResourceId' => '<p>The identifier of the resource.</p>', 'FlowAssociationSummary$FlowId' => '<p>The identifier of the flow.</p>', 'GetAttachedFileRequest$AssociatedResourceArn' => '<p>The resource to which the attached file is (being) uploaded to. <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Cases</a> are the only current supported resource.</p> <note> <p>This value must be a valid ARN.</p> </note>', 'GetAttachedFileResponse$FileArn' => '<p>The unique identifier of the attached file resource (ARN).</p>', 'GetAttachedFileResponse$AssociatedResourceArn' => '<p>The resource to which the attached file is (being) uploaded to. <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Cases</a> are the only current supported resource.</p>', 'GetFederationTokenResponse$UserArn' => '<p>The Amazon Resource Name (ARN) of the user.</p>', 'GetFlowAssociationRequest$ResourceId' => '<p>The identifier of the resource.</p>', 'GetFlowAssociationResponse$ResourceId' => '<p>The identifier of the resource.</p>', 'GetFlowAssociationResponse$FlowId' => '<p>The identifier of the flow.</p>', 'GetMetricDataV2Request$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource. This includes the <code>instanceId</code> an Amazon Connect instance.</p>', 'HierarchyGroup$Arn' => '<p>The Amazon Resource Name (ARN) of the hierarchy group.</p>', 'HierarchyGroupSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the hierarchy group.</p>', 'HierarchyGroupSummaryReference$Arn' => '<p>The Amazon Resource Name (ARN) for the hierarchy group. </p>', 'HierarchyLevel$Arn' => '<p>The Amazon Resource Name (ARN) of the hierarchy level.</p>', 'HoursOfOperation$HoursOfOperationArn' => '<p>The Amazon Resource Name (ARN) for the hours of operation.</p>', 'HoursOfOperationSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the hours of operation.</p>', 'ImportPhoneNumberRequest$SourcePhoneNumberArn' => '<p>The claimed phone number ARN being imported from the external service, such as Amazon Pinpoint. If it is from Amazon Pinpoint, it looks like the ARN of the phone number to import from Amazon Pinpoint.</p>', 'ImportPhoneNumberResponse$PhoneNumberArn' => '<p>The Amazon Resource Name (ARN) of the phone number.</p>', 'Instance$Arn' => '<p>The Amazon Resource Name (ARN) of the instance.</p>', 'Instance$ServiceRole' => '<p>The service role of the instance.</p>', 'InstanceSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the instance.</p>', 'InstanceSummary$ServiceRole' => '<p>The service role of the instance.</p>', 'IntegrationAssociationSummary$IntegrationAssociationArn' => '<p>The Amazon Resource Name (ARN) for the AppIntegration association.</p>', 'IntegrationAssociationSummary$IntegrationArn' => '<p>The Amazon Resource Name (ARN) for the AppIntegration.</p>', 'KinesisFirehoseConfig$FirehoseArn' => '<p>The Amazon Resource Name (ARN) of the delivery stream.</p>', 'KinesisStreamConfig$StreamArn' => '<p>The Amazon Resource Name (ARN) of the data stream.</p>', 'ListIntegrationAssociationsRequest$IntegrationArn' => '<p>The Amazon Resource Name (ARN) of the integration.</p>', 'ListPhoneNumbersSummary$PhoneNumberArn' => '<p>The Amazon Resource Name (ARN) of the phone number.</p>', 'ListPhoneNumbersSummary$TargetArn' => '<p>The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number inbound traffic is routed through.</p>', 'ListPhoneNumbersSummary$SourcePhoneNumberArn' => '<p>The claimed phone number ARN that was previously imported from the external service, such as Amazon Pinpoint. If it is from Amazon Pinpoint, it looks like the ARN of the phone number that was imported from Amazon Pinpoint.</p>', 'ListPhoneNumbersV2Request$TargetArn' => '<p>The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number inbound traffic is routed through. If both <code>TargetArn</code> and <code>InstanceId</code> input are not provided, this API lists numbers claimed to all the Amazon Connect instances belonging to your account in the same Amazon Web Services Region as the request.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource. All Amazon Connect resources (instances, queues, flows, routing profiles, etc) have an ARN. To locate the ARN for an instance, for example, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">Find your Amazon Connect instance ID/ARN</a>. </p>', 'MonitorContactResponse$ContactArn' => '<p>The ARN of the contact.</p>', 'PhoneNumberSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the phone number.</p>', 'Prompt$PromptARN' => '<p>The Amazon Resource Name (ARN) of the prompt.</p>', 'PromptSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the prompt.</p>', 'Queue$QueueArn' => '<p>The Amazon Resource Name (ARN) for the queue.</p>', 'QueueReference$Arn' => '<p>The Amazon Resource Name (ARN) of the queue.</p>', 'QueueSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the queue.</p>', 'QuickConnect$QuickConnectARN' => '<p>The Amazon Resource Name (ARN) of the quick connect.</p>', 'QuickConnectSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the quick connect.</p>', 'ReplicateInstanceResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the replicated instance.</p>', 'ResourceInUseException$ResourceId' => '<p>The identifier for the resource.</p>', 'RoutingProfile$RoutingProfileArn' => '<p>The Amazon Resource Name (ARN) of the routing profile.</p>', 'RoutingProfileQueueConfigSummary$QueueArn' => '<p>The Amazon Resource Name (ARN) of the queue.</p>', 'RoutingProfileReference$Arn' => '<p>The Amazon Resource Name (ARN) of the routing profile.</p>', 'RoutingProfileSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the routing profile.</p>', 'Rule$RuleArn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'Rule$LastUpdatedBy' => '<p>The Amazon Resource Name (ARN) of the user who last updated the rule.</p>', 'RuleSummary$RuleArn' => '<p>The Amazon Resource Name (ARN) of the rule.</p>', 'SearchAvailablePhoneNumbersRequest$TargetArn' => '<p>The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number inbound traffic is routed through. You must enter <code>InstanceId</code> or <code>TargetArn</code>. </p>', 'SecurityProfile$Arn' => '<p>The Amazon Resource Name (ARN) for the secruity profile.</p>', 'SecurityProfileSearchSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the security profile.</p>', 'SecurityProfileSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the security profile.</p>', 'StartAttachedFileUploadRequest$AssociatedResourceArn' => '<p>The resource to which the attached file is (being) uploaded to. <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html">Cases</a> are the only current supported resource.</p> <note> <p>This value must be a valid ARN.</p> </note>', 'StartAttachedFileUploadResponse$FileArn' => '<p>The unique identifier of the attached file resource (ARN).</p>', 'StartContactEvaluationResponse$EvaluationArn' => '<p>The Amazon Resource Name (ARN) for the contact evaluation resource.</p>', 'SubmitContactEvaluationResponse$EvaluationArn' => '<p>The Amazon Resource Name (ARN) for the contact evaluation resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'TransferContactResponse$ContactArn' => '<p>The Amazon Resource Name (ARN) of the contact.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UpdateContactEvaluationResponse$EvaluationArn' => '<p>The Amazon Resource Name (ARN) for the contact evaluation resource.</p>', 'UpdateEvaluationFormResponse$EvaluationFormArn' => '<p>The Amazon Resource Name (ARN) for the contact evaluation resource.</p>', 'UpdatePhoneNumberRequest$TargetArn' => '<p>The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution groups that phone number inbound traffic is routed through. You must enter <code>InstanceId</code> or <code>TargetArn</code>. </p>', 'UpdatePhoneNumberResponse$PhoneNumberArn' => '<p>The Amazon Resource Name (ARN) of the phone number.</p>', 'UpdatePromptResponse$PromptARN' => '<p>The Amazon Resource Name (ARN) of the prompt.</p>', 'UseCase$UseCaseArn' => '<p>The Amazon Resource Name (ARN) for the use case.</p>', 'User$Arn' => '<p>The Amazon Resource Name (ARN) of the user account.</p>', 'UserReference$Arn' => '<p>The Amazon Resource Name (ARN) for the user.</p>', 'UserSearchSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the user.</p>', 'UserSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the user account.</p>', 'View$Arn' => '<p>The Amazon Resource Name (ARN) of the view.</p>', 'ViewSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the view.</p>', 'ViewVersionSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the view version.</p>', 'Vocabulary$Arn' => '<p>The Amazon Resource Name (ARN) of the custom vocabulary.</p>', 'VocabularySummary$Arn' => '<p>The Amazon Resource Name (ARN) of the custom vocabulary.</p>', 'WisdomInfo$SessionArn' => '<p>The Amazon Resource Name (ARN) of the Wisdom session.</p>', 'resourceArnListMaxLimit100$member' => NULL, ], ], 'AWSAccountId' => [ 'base' => NULL, 'refs' => [ 'AnalyticsDataAssociationResult$TargetAccountId' => '<p>The identifier of the target account. </p>', 'AssociateAnalyticsDataSetRequest$TargetAccountId' => '<p>The identifier of the target account. Use to associate a dataset to a different account than the one containing the Amazon Connect instance. If not specified, by default this value is the Amazon Web Services account that has the Amazon Connect instance.</p>', 'AssociateAnalyticsDataSetResponse$TargetAccountId' => '<p>The identifier of the target account. </p>', 'BatchAssociateAnalyticsDataSetRequest$TargetAccountId' => '<p>The identifier of the target account. Use to associate a dataset to a different account than the one containing the Amazon Connect instance. If not specified, by default this value is the Amazon Web Services account that has the Amazon Connect instance.</p>', 'BatchDisassociateAnalyticsDataSetRequest$TargetAccountId' => '<p>The identifier of the target account. Use to disassociate a dataset from a different account than the one containing the Amazon Connect instance. If not specified, by default this value is the Amazon Web Services account that has the Amazon Connect instance.</p>', 'DisassociateAnalyticsDataSetRequest$TargetAccountId' => '<p>The identifier of the target account. Use to associate a dataset to a different account than the one containing the Amazon Connect instance. If not specified, by default this value is the Amazon Web Services account that has the Amazon Connect instance.</p>', ], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient permissions to perform this action.</p>', 'refs' => [], ], 'AccessTokenDuration' => [ 'base' => NULL, 'refs' => [ 'AuthenticationProfile$PeriodicSessionDuration' => '<p>The short lived session duration configuration for users logged in to Amazon Connect, in minutes. This value determines the maximum possible time before an agent is authenticated. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts">Configure the session duration</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'UpdateAuthenticationProfileRequest$PeriodicSessionDuration' => '<p>The short lived session duration configuration for users logged in to Amazon Connect, in minutes. This value determines the maximum possible time before an agent is authenticated. For more information, For more information on how to configure IP addresses, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts">Configure session timeouts</a> in the <i>Amazon Connect Administrator Guide</i>. </p>', ], ], 'ActionSummaries' => [ 'base' => NULL, 'refs' => [ 'RuleSummary$ActionSummaries' => '<p>A list of ActionTypes associated with a rule. </p>', ], ], 'ActionSummary' => [ 'base' => '<p>Information about an action.</p>', 'refs' => [ 'ActionSummaries$member' => NULL, ], ], 'ActionType' => [ 'base' => NULL, 'refs' => [ 'ActionSummary$ActionType' => '<p>The action type.</p>', 'RuleAction$ActionType' => '<p>The type of action that creates a rule.</p>', ], ], 'ActivateEvaluationFormRequest' => [ 'base' => NULL, 'refs' => [], ], 'ActivateEvaluationFormResponse' => [ 'base' => NULL, 'refs' => [], ], 'AfterContactWorkTimeLimit' => [ 'base' => NULL, 'refs' => [ 'UserPhoneConfig$AfterContactWorkTimeLimit' => '<p>The After Call Work (ACW) timeout setting, in seconds. This parameter has a minimum value of 0 and a maximum value of 2,000,000 seconds (24 days). Enter 0 if you don\'t want to allocate a specific amount of ACW time. It essentially means an indefinite amount of time. When the conversation ends, ACW starts; the agent must choose Close contact to end ACW. </p> <note> <p>When returned by a <code>SearchUsers</code> call, <code>AfterContactWorkTimeLimit</code> is returned in milliseconds. </p> </note>', ], ], 'AgentAvailabilityTimer' => [ 'base' => NULL, 'refs' => [ 'CreateRoutingProfileRequest$AgentAvailabilityTimer' => '<p>Whether agents with this routing profile will have their routing order calculated based on <i>longest idle time</i> or <i>time since their last inbound contact</i>. </p>', 'RoutingProfile$AgentAvailabilityTimer' => '<p>Whether agents with this routing profile will have their routing order calculated based on <i>time since their last inbound contact</i> or <i>longest idle time</i>. </p>', 'UpdateRoutingProfileAgentAvailabilityTimerRequest$AgentAvailabilityTimer' => '<p>Whether agents with this routing profile will have their routing order calculated based on <i>time since their last inbound contact</i> or <i>longest idle time</i>. </p>', ], ], 'AgentConfig' => [ 'base' => '<p>The distribution of agents between the instance and its replica(s).</p>', 'refs' => [ 'GetTrafficDistributionResponse$AgentConfig' => '<p>The distribution of agents between the instance and its replica(s).</p>', 'UpdateTrafficDistributionRequest$AgentConfig' => '<p>The distribution of agents between the instance and its replica(s).</p>', ], ], 'AgentContactReference' => [ 'base' => '<p>Information about the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_Contact.html">contact</a> associated to the user.</p>', 'refs' => [ 'AgentContactReferenceList$member' => NULL, ], ], 'AgentContactReferenceList' => [ 'base' => NULL, 'refs' => [ 'UserData$Contacts' => '<p>A list of contact reference information.</p>', ], ], 'AgentFirstName' => [ 'base' => NULL, 'refs' => [ 'UserIdentityInfo$FirstName' => '<p>The first name. This is required if you are using Amazon Connect or SAML for identity management.</p>', 'UserIdentityInfoLite$FirstName' => '<p>The user\'s first name.</p>', ], ], 'AgentHierarchyGroup' => [ 'base' => '<p>Information about an agent hierarchy group.</p>', 'refs' => [ 'HierarchyGroups$Level1' => '<p>The group at level one of the agent hierarchy.</p>', 'HierarchyGroups$Level2' => '<p>The group at level two of the agent hierarchy.</p>', 'HierarchyGroups$Level3' => '<p>The group at level three of the agent hierarchy.</p>', 'HierarchyGroups$Level4' => '<p>The group at level four of the agent hierarchy.</p>', 'HierarchyGroups$Level5' => '<p>The group at level five of the agent hierarchy.</p>', ], ], 'AgentHierarchyGroups' => [ 'base' => '<p>A structure that defines search criteria for contacts using agent hierarchy group levels. For more information about agent hierarchies, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html">Set Up Agent Hierarchies</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'refs' => [ 'SearchCriteria$AgentHierarchyGroups' => '<p>The agent hierarchy groups of the agent at the time of handling the contact.</p>', ], ], 'AgentId' => [ 'base' => NULL, 'refs' => [ 'AgentIds$member' => NULL, ], ], 'AgentIds' => [ 'base' => NULL, 'refs' => [ 'AgentsCriteria$AgentIds' => '<p>An object to specify a list of agents, by user ID.</p>', ], ], 'AgentInfo' => [ 'base' => '<p>Information about the agent who accepted the contact.</p>', 'refs' => [ 'Contact$AgentInfo' => '<p>Information about the agent who accepted the contact.</p>', ], ], 'AgentLastName' => [ 'base' => NULL, 'refs' => [ 'UserIdentityInfo$LastName' => '<p>The last name. This is required if you are using Amazon Connect or SAML for identity management.</p>', 'UserIdentityInfoLite$LastName' => '<p>The user\'s last name.</p>', ], ], 'AgentPauseDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'AgentInfo$AgentPauseDurationInSeconds' => '<p>Agent pause duration for a contact in seconds.</p>', ], ], 'AgentQualityMetrics' => [ 'base' => '<p>Information about the quality of the Agent\'s media connection</p>', 'refs' => [ 'QualityMetrics$Agent' => '<p>Information about the quality of Agent media connection.</p>', ], ], 'AgentResourceId' => [ 'base' => NULL, 'refs' => [ 'AgentInfo$Id' => '<p>The identifier of the agent who accepted the contact.</p>', 'AgentResourceIdList$member' => NULL, 'ContactSearchSummaryAgentInfo$Id' => '<p>The identifier of the agent who accepted the contact.</p>', 'GetFederationTokenResponse$UserId' => '<p>The identifier for the user. This can be the ID or the ARN of the user.</p>', 'MonitorContactRequest$UserId' => '<p>The identifier of the user account.</p>', 'TransferContactRequest$UserId' => '<p>The identifier for the user. This can be the ID or the ARN of the user.</p>', ], ], 'AgentResourceIdList' => [ 'base' => NULL, 'refs' => [ 'SearchCriteria$AgentIds' => '<p>The identifiers of agents who handled the contacts.</p>', ], ], 'AgentStatus' => [ 'base' => '<p>Contains information about an agent status.</p>', 'refs' => [ 'AgentStatusList$member' => NULL, 'DescribeAgentStatusResponse$AgentStatus' => '<p>The agent status.</p>', ], ], 'AgentStatusDescription' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$Description' => '<p>The description of the agent status.</p>', 'CreateAgentStatusRequest$Description' => '<p>The description of the status.</p>', ], ], 'AgentStatusId' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$AgentStatusId' => '<p>The identifier of the agent status.</p>', 'AgentStatusSummary$Id' => '<p>The identifier for an agent status.</p>', 'CreateAgentStatusResponse$AgentStatusId' => '<p>The identifier of the agent status.</p>', 'DescribeAgentStatusRequest$AgentStatusId' => '<p>The identifier for the agent status.</p>', 'PutUserStatusRequest$AgentStatusId' => '<p>The identifier of the agent status.</p>', 'UpdateAgentStatusRequest$AgentStatusId' => '<p>The identifier of the agent status.</p>', ], ], 'AgentStatusList' => [ 'base' => NULL, 'refs' => [ 'SearchAgentStatusesResponse$AgentStatuses' => '<p>The search criteria to be used to return agent statuses.</p>', ], ], 'AgentStatusName' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$Name' => '<p>The name of the agent status.</p>', 'AgentStatusReference$StatusName' => '<p>The name of the agent status.</p>', 'AgentStatusSummary$Name' => '<p>The name of the agent status.</p>', 'CreateAgentStatusRequest$Name' => '<p>The name of the status.</p>', 'UpdateAgentStatusRequest$Name' => '<p>The name of the agent status.</p>', 'UserData$NextStatus' => '<p>The Next status of the agent.</p>', ], ], 'AgentStatusOrderNumber' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$DisplayOrder' => '<p>The display order of the agent status.</p>', 'CreateAgentStatusRequest$DisplayOrder' => '<p>The display order of the status.</p>', 'UpdateAgentStatusRequest$DisplayOrder' => '<p>The display order of the agent status.</p>', ], ], 'AgentStatusReference' => [ 'base' => '<p>Information about the agent\'s status.</p>', 'refs' => [ 'UserData$Status' => '<p>The status of the agent that they manually set in their Contact Control Panel (CCP), or that the supervisor manually changes in the real-time metrics report.</p>', ], ], 'AgentStatusSearchConditionList' => [ 'base' => NULL, 'refs' => [ 'AgentStatusSearchCriteria$OrConditions' => '<p>A list of conditions which would be applied together with an <code>OR</code> condition.</p>', 'AgentStatusSearchCriteria$AndConditions' => '<p>A leaf node condition which can be used to specify a string condition.</p> <note> <p>The currently supported values for <code>FieldName</code> are <code>name</code>,&#x2028;&#x2028; <code>description</code>, <code>state</code>, <code>type</code>, <code>displayOrder</code>,&#x2028; and <code>resourceID</code>.</p> </note>', ], ], 'AgentStatusSearchCriteria' => [ 'base' => '<p>The search criteria to be used to return agent statuses.</p>', 'refs' => [ 'AgentStatusSearchConditionList$member' => NULL, 'SearchAgentStatusesRequest$SearchCriteria' => '<p>The search criteria to be used to return agent statuses.</p>', ], ], 'AgentStatusSearchFilter' => [ 'base' => '<p>Filters to be applied to search results.</p>', 'refs' => [ 'SearchAgentStatusesRequest$SearchFilter' => '<p>Filters to be applied to search results.</p>', ], ], 'AgentStatusState' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$State' => '<p>The state of the agent status.</p>', 'CreateAgentStatusRequest$State' => '<p>The state of the status.</p>', 'UpdateAgentStatusRequest$State' => '<p>The state of the agent status.</p>', ], ], 'AgentStatusSummary' => [ 'base' => '<p>Summary information for an agent status.</p>', 'refs' => [ 'AgentStatusSummaryList$member' => NULL, ], ], 'AgentStatusSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAgentStatusResponse$AgentStatusSummaryList' => '<p>A summary of agent statuses.</p>', ], ], 'AgentStatusType' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$Type' => '<p>The type of agent status.</p>', 'AgentStatusSummary$Type' => '<p>The type of the agent status.</p>', 'AgentStatusTypes$member' => NULL, ], ], 'AgentStatusTypes' => [ 'base' => NULL, 'refs' => [ 'ListAgentStatusRequest$AgentStatusTypes' => '<p>Available agent status types.</p>', ], ], 'AgentUsername' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Username' => '<p>The user name for the account. For instances not using SAML for identity management, the user name can include up to 20 characters. If you are using SAML for identity management, the user name can include up to 64 characters from [a-zA-Z0-9_-.\\@]+.</p> <p>Username can include @ only if used in an email format. For example:</p> <ul> <li> <p>Correct: testuser</p> </li> <li> <p>Correct: testuser@example.com</p> </li> <li> <p>Incorrect: testuser@example</p> </li> </ul>', 'User$Username' => '<p>The user name assigned to the user account.</p>', 'UserSearchSummary$Username' => '<p>The name of the user.</p>', 'UserSummary$Username' => '<p>The Amazon Connect user name of the user account.</p>', ], ], 'AgentsCriteria' => [ 'base' => '<p>Can be used to define a list of preferred agents to target the contact to within the queue.&#x2028; Note that agents must have the queue in their routing profile in order to be offered the&#x2028; contact.</p>', 'refs' => [ 'MatchCriteria$AgentsCriteria' => '<p>An object to define agentIds.</p>', ], ], 'AgentsMinOneMaxHundred' => [ 'base' => NULL, 'refs' => [ 'UserDataFilters$Agents' => '<p>A list of up to 100 agent IDs or ARNs.</p>', ], ], 'AliasArn' => [ 'base' => NULL, 'refs' => [ 'LexV2Bot$AliasArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Lex V2 bot.</p>', ], ], 'AllowedAccessControlTags' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$AllowedAccessControlTags' => '<p>The list of tags that a security profile uses to restrict access to resources in Amazon Connect.</p>', 'SecurityProfile$AllowedAccessControlTags' => '<p>The list of tags that a security profile uses to restrict access to resources in Amazon Connect.</p>', 'UpdateSecurityProfileRequest$AllowedAccessControlTags' => '<p>The list of tags that a security profile uses to restrict access to resources in Amazon Connect.</p>', ], ], 'AllowedCapabilities' => [ 'base' => '<p>Information about the capabilities enabled for participants of the contact.</p>', 'refs' => [ 'StartWebRTCContactRequest$AllowedCapabilities' => '<p>Information about the video sharing capabilities of the participants (customer, agent).</p>', ], ], 'AllowedMonitorCapabilities' => [ 'base' => NULL, 'refs' => [ 'MonitorContactRequest$AllowedMonitorCapabilities' => '<p>Specify which monitoring actions the user is allowed to take. For example, whether the user is allowed to escalate from silent monitoring to barge. AllowedMonitorCapabilities is required if barge is enabled.</p>', ], ], 'AnalyticsDataAssociationResult' => [ 'base' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>Information about associations that are successfully created: <code>DataSetId</code>, <code>TargetAccountId</code>, <code>ResourceShareId</code>, <code>ResourceShareArn</code>. </p>', 'refs' => [ 'AnalyticsDataAssociationResults$member' => NULL, ], ], 'AnalyticsDataAssociationResults' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateAnalyticsDataSetResponse$Created' => '<p>Information about associations that are successfully created: <code>DataSetId</code>, <code>TargetAccountId</code>, <code>ResourceShareId</code>, <code>ResourceShareArn</code>. </p>', 'ListAnalyticsDataAssociationsResponse$Results' => '<p>An array of successful results: <code>DataSetId</code>, <code>TargetAccountId</code>, <code>ResourceShareId</code>, <code>ResourceShareArn</code>. This is a paginated API, so <code>nextToken</code> is given if there are more results to be returned.</p>', ], ], 'AnswerMachineDetectionConfig' => [ 'base' => '<p>Configuration of the answering machine detection.</p>', 'refs' => [ 'StartOutboundVoiceContactRequest$AnswerMachineDetectionConfig' => '<p>Configuration of the answering machine detection for this outbound call. </p>', ], ], 'AnsweringMachineDetectionStatus' => [ 'base' => NULL, 'refs' => [ 'Contact$AnsweringMachineDetectionStatus' => '<p>Indicates how an <a href="https://docs.aws.amazon.com/connect/latest/adminguide/how-to-create-campaigns.html">outbound campaign</a> call is actually disposed if the contact is connected to Amazon Connect.</p>', ], ], 'Application' => [ 'base' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>A third-party application\'s metadata.</p>', 'refs' => [ 'Applications$member' => NULL, ], ], 'ApplicationPermissions' => [ 'base' => NULL, 'refs' => [ 'Application$ApplicationPermissions' => '<p>The permissions that the agent is granted on the application. Only the <code>ACCESS</code> permission is supported.</p>', ], ], 'Applications' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$Applications' => '<p>A list of third-party applications that the security profile will give access to.</p>', 'ListSecurityProfileApplicationsResponse$Applications' => '<p>A list of the third-party application\'s metadata.</p>', 'UpdateSecurityProfileRequest$Applications' => '<p>A list of the third-party application\'s metadata.</p>', ], ], 'ApproximateTotalCount' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataResponse$ApproximateTotalCount' => '<p>The total count of the result, regardless of the current page size. </p>', 'GetCurrentUserDataResponse$ApproximateTotalCount' => '<p>The total count of the result, regardless of the current page size.</p>', 'SearchAgentStatusesResponse$ApproximateTotalCount' => '<p>The total number of agent statuses which matched your search query.</p>', 'SearchContactFlowModulesResponse$ApproximateTotalCount' => '<p>The total number of contact flows which matched your search query.</p>', 'SearchContactFlowsResponse$ApproximateTotalCount' => '<p>The total number of contact flows which matched your search query.</p>', 'SearchHoursOfOperationsResponse$ApproximateTotalCount' => '<p>The total number of hours of operations which matched your search query.</p>', 'SearchPredefinedAttributesResponse$ApproximateTotalCount' => '<p>The approximate number of predefined attributes which matched your search query.</p>', 'SearchPromptsResponse$ApproximateTotalCount' => '<p>The total number of quick connects which matched your search query.</p>', 'SearchQueuesResponse$ApproximateTotalCount' => '<p>The total number of queues which matched your search query.</p>', 'SearchQuickConnectsResponse$ApproximateTotalCount' => '<p>The total number of quick connects which matched your search query.</p>', 'SearchRoutingProfilesResponse$ApproximateTotalCount' => '<p>The total number of routing profiles which matched your search query.</p>', 'SearchSecurityProfilesResponse$ApproximateTotalCount' => '<p>The total number of security profiles which matched your search query.</p>', 'SearchUserHierarchyGroupsResponse$ApproximateTotalCount' => '<p>The total number of userHierarchyGroups which matched your search query.</p>', 'SearchUsersResponse$ApproximateTotalCount' => '<p>The total number of users who matched your search query.</p>', ], ], 'ArtifactId' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisAttachment$AttachmentId' => '<p>A unique identifier for the attachment.</p>', ], ], 'ArtifactStatus' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisAttachment$Status' => '<p>Status of the attachment.</p>', ], ], 'AssignContactCategoryActionDefinition' => [ 'base' => '<p>This action must be set if <code>TriggerEventSource</code> is one of the following values: <code>OnPostCallAnalysisAvailable</code> | <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> | <code>OnPostChatAnalysisAvailable</code>. Contact is categorized using the rule name.</p> <p> <code>RuleName</code> is used as <code>ContactCategory</code>.</p>', 'refs' => [ 'RuleAction$AssignContactCategoryAction' => '<p>Information about the contact category action.</p> <p>Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> | <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> | <code>OnPostChatAnalysisAvailable</code> | <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code> </p>', ], ], 'AssociateAnalyticsDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateAnalyticsDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateApprovedOriginRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDefaultVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateDefaultVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateInstanceStorageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateInstanceStorageConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateLambdaFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateLexBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociatePhoneNumberContactFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateQueueQuickConnectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateRoutingProfileQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSecurityKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateSecurityKeyResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTrafficDistributionGroupUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateTrafficDistributionGroupUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'AssociateUserProficienciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociatedQueueIdList' => [ 'base' => NULL, 'refs' => [ 'RoutingProfile$AssociatedQueueIds' => '<p>The IDs of the associated queue.</p>', ], ], 'AssociationId' => [ 'base' => NULL, 'refs' => [ 'AssociateInstanceStorageConfigResponse$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'AssociateSecurityKeyResponse$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'DescribeInstanceStorageConfigRequest$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'DisassociateInstanceStorageConfigRequest$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'DisassociateSecurityKeyRequest$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'InstanceStorageConfig$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'SecurityKey$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', 'UpdateInstanceStorageConfigRequest$AssociationId' => '<p>The existing association identifier that uniquely identifies the resource type and storage config for the given instance ID.</p>', ], ], 'AttachedFile' => [ 'base' => '<p>Information about the attached file.</p>', 'refs' => [ 'AttachedFilesList$member' => NULL, ], ], 'AttachedFileError' => [ 'base' => '<p>Error describing a failure to retrieve attached file metadata through BatchGetAttachedFileMetadata action.</p>', 'refs' => [ 'AttachedFileErrorsList$member' => NULL, ], ], 'AttachedFileErrorsList' => [ 'base' => NULL, 'refs' => [ 'BatchGetAttachedFileMetadataResponse$Errors' => '<p>List of errors of attached files that could not be retrieved. </p>', ], ], 'AttachedFileInvalidRequestExceptionReason' => [ 'base' => NULL, 'refs' => [ 'InvalidRequestExceptionReason$AttachedFileInvalidRequestExceptionReason' => '<p>Reason why the StartAttachedFiledUpload request was invalid.</p>', ], ], 'AttachedFilesList' => [ 'base' => NULL, 'refs' => [ 'BatchGetAttachedFileMetadataResponse$Files' => '<p>List of attached files that were successfully retrieved. </p>', ], ], 'AttachmentName' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisAttachment$AttachmentName' => '<p>A case-sensitive name of the attachment being uploaded. Can be redacted.</p>', ], ], 'AttachmentReference' => [ 'base' => '<p>Information about a reference when the <code>referenceType</code> is <code>ATTACHMENT</code>. Otherwise, null.</p>', 'refs' => [ 'ReferenceSummary$Attachment' => '<p>Information about the reference when the <code>referenceType</code> is <code>ATTACHMENT</code>. Otherwise, null.</p>', ], ], 'Attendee' => [ 'base' => '<p>The attendee information, including attendee ID and join token.</p>', 'refs' => [ 'ConnectionData$Attendee' => '<p>The attendee information, including attendee ID and join token.</p>', ], ], 'AttendeeId' => [ 'base' => NULL, 'refs' => [ 'Attendee$AttendeeId' => '<p>The Amazon Chime SDK attendee ID.</p>', ], ], 'Attribute' => [ 'base' => '<p>A toggle for an individual feature at the instance level.</p>', 'refs' => [ 'AttributesList$member' => NULL, 'DescribeInstanceAttributeResponse$Attribute' => '<p>The type of attribute.</p>', ], ], 'AttributeAndCondition' => [ 'base' => '<p>A list of conditions which would be applied together with an <code>AND</code> condition.</p>', 'refs' => [ 'AttributeOrConditionList$member' => NULL, 'ControlPlaneUserAttributeFilter$AndCondition' => '<p>A list of conditions which would be applied together with an <code>AND</code> condition.</p>', ], ], 'AttributeCondition' => [ 'base' => '<p>An object to specify the predefined attribute condition.</p>', 'refs' => [ 'Expression$AttributeCondition' => '<p>An object to specify the predefined attribute condition.</p>', ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'Attributes$key' => NULL, ], ], 'AttributeOrConditionList' => [ 'base' => NULL, 'refs' => [ 'ControlPlaneUserAttributeFilter$OrConditions' => '<p>A list of conditions which would be applied together with an <code>OR</code> condition.</p>', ], ], 'AttributeValue' => [ 'base' => NULL, 'refs' => [ 'Attributes$value' => NULL, ], ], 'Attributes' => [ 'base' => NULL, 'refs' => [ 'ContactDataRequest$Attributes' => '<p>List of attributes to be stored in a contact.</p>', 'GetContactAttributesResponse$Attributes' => '<p>Information about the attributes.</p>', 'NewSessionDetails$Attributes' => '<p> A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows just like any other contact attributes. </p> <p> There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters. </p>', 'StartChatContactRequest$Attributes' => '<p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows just like any other contact attributes. </p> <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>', 'StartOutboundVoiceContactRequest$Attributes' => '<p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.</p> <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>', 'StartTaskContactRequest$Attributes' => '<p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.</p> <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p>', 'StartWebRTCContactRequest$Attributes' => '<p>A custom key-value pair using an attribute map. The attributes are standard Amazon Connect attributes, and can be accessed in flows just like any other contact attributes.</p> <p>There can be up to 32,768 UTF-8 bytes across all key-value pairs per contact. Attribute keys can include only alphanumeric, -, and _ characters.</p>', 'UpdateContactAttributesRequest$Attributes' => '<p>The Amazon Connect attributes. These attributes can be accessed in flows just like any other contact attributes.</p> <p>You can have up to 32,768 UTF-8 bytes across all attributes for a contact. Attribute keys can include only alphanumeric, dash, and underscore characters.</p> <p>When the attributes for a contact exceed 32 KB, the contact is routed down the Error branch of the flow. As a mitigation, consider the following options:</p> <ul> <li> <p>Remove unnecessary attributes by setting their values to empty.</p> </li> <li> <p>If the attributes are only used in one flow and don\'t need to be referred to outside of that flow (for example, by a Lambda or another flow), then use flow attributes. This way you aren\'t needlessly persisting the 32 KB of information from one flow to another. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/set-contact-attributes.html">Flow block: Set contact attributes</a> in the <i>Amazon Connect Administrator Guide</i>. </p> </li> </ul>', ], ], 'AttributesList' => [ 'base' => NULL, 'refs' => [ 'ListInstanceAttributesResponse$Attributes' => '<p>The attribute types.</p>', ], ], 'AudioFeatures' => [ 'base' => '<p>Has audio-specific configurations as the operating parameter for Echo Reduction.</p>', 'refs' => [ 'MeetingFeaturesConfiguration$Audio' => '<p>The configuration settings for the audio features available to a meeting.</p>', ], ], 'AudioQualityMetricsInfo' => [ 'base' => '<p>Contains information for score and potential quality issues for Audio</p>', 'refs' => [ 'AgentQualityMetrics$Audio' => '<p>Information about the audio quality of the Agent</p>', 'CustomerQualityMetrics$Audio' => '<p>Information about the audio quality of the Customer</p>', ], ], 'AudioQualityScore' => [ 'base' => NULL, 'refs' => [ 'AudioQualityMetricsInfo$QualityScore' => '<p>Number measuring the estimated quality of the media connection.</p>', ], ], 'AuthenticationProfile' => [ 'base' => '<p>This API is in preview release for Amazon Connect and is subject to change. To request access to this API, contact Amazon Web Services Support.</p> <p>Information about an authentication profile. An authentication profile is a resource that stores the authentication settings for users in your contact center. You use authentication profiles to set up IP address range restrictions and session timeouts. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html">Set IP address restrictions or session timeouts</a>. </p>', 'refs' => [ 'DescribeAuthenticationProfileResponse$AuthenticationProfile' => '<p>The authentication profile object being described.</p>', ], ], 'AuthenticationProfileDescription' => [ 'base' => NULL, 'refs' => [ 'AuthenticationProfile$Description' => '<p>The description for the authentication profile.</p>', 'UpdateAuthenticationProfileRequest$Description' => '<p>The description for the authentication profile.</p>', ], ], 'AuthenticationProfileId' => [ 'base' => NULL, 'refs' => [ 'AuthenticationProfile$Id' => '<p>A unique identifier for the authentication profile. </p>', 'AuthenticationProfileSummary$Id' => '<p>The unique identifier of the authentication profile.</p>', 'DescribeAuthenticationProfileRequest$AuthenticationProfileId' => '<p>A unique identifier for the authentication profile. </p>', 'UpdateAuthenticationProfileRequest$AuthenticationProfileId' => '<p>A unique identifier for the authentication profile. </p>', ], ], 'AuthenticationProfileName' => [ 'base' => NULL, 'refs' => [ 'AuthenticationProfile$Name' => '<p>The name for the authentication profile.</p>', 'AuthenticationProfileSummary$Name' => '<p>The name of the authentication profile summary.</p>', 'UpdateAuthenticationProfileRequest$Name' => '<p>The name for the authentication profile.</p>', ], ], 'AuthenticationProfileSummary' => [ 'base' => '<p>This API is in preview release for Amazon Connect and is subject to change. To request access to this API, contact Amazon Web Services Support.</p> <p>A summary of a given authentication profile.</p>', 'refs' => [ 'AuthenticationProfileSummaryList$member' => NULL, ], ], 'AuthenticationProfileSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAuthenticationProfilesResponse$AuthenticationProfileSummaryList' => '<p>A summary of a given authentication profile.</p>', ], ], 'AutoAccept' => [ 'base' => NULL, 'refs' => [ 'UserPhoneConfig$AutoAccept' => '<p>The Auto accept setting.</p>', ], ], 'AvailableNumberSummary' => [ 'base' => '<p>Information about available phone numbers.</p>', 'refs' => [ 'AvailableNumbersList$member' => NULL, ], ], 'AvailableNumbersList' => [ 'base' => NULL, 'refs' => [ 'SearchAvailablePhoneNumbersResponse$AvailableNumbersList' => '<p>A list of available phone numbers that you can claim to your Amazon Connect instance or traffic distribution group.</p>', ], ], 'AwsRegion' => [ 'base' => NULL, 'refs' => [ 'Distribution$Region' => '<p>The Amazon Web Services Region where the traffic is distributed.</p>', 'ReplicateInstanceRequest$ReplicaRegion' => '<p>The Amazon Web Services Region where to replicate the Amazon Connect instance.</p>', 'SignInDistribution$Region' => '<p>The Amazon Web Services Region of the sign in distribution.</p>', ], ], 'BatchAssociateAnalyticsDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchAssociateAnalyticsDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateAnalyticsDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDisassociateAnalyticsDataSetResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAttachedFileMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetAttachedFileMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetFlowAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetFlowAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'BehaviorType' => [ 'base' => NULL, 'refs' => [ 'CrossChannelBehavior$BehaviorType' => '<p>Specifies the other channels that can be routed to an agent handling their current channel.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AnswerMachineDetectionConfig$EnableAnswerMachineDetection' => '<p>The flag to indicate if answer machine detection analysis needs to be performed for a voice call. If set to <code>true</code>, <code>TrafficType</code> must be set as <code>CAMPAIGN</code>. </p>', 'AnswerMachineDetectionConfig$AwaitAnswerMachinePrompt' => '<p>Wait for the answering machine prompt.</p>', 'AuthenticationProfile$IsDefault' => '<p>Shows whether the authentication profile is the default authentication profile for the Amazon Connect instance. The default authentication profile applies to all agents in an Amazon Connect instance, unless overridden by another authentication profile.</p>', 'AuthenticationProfileSummary$IsDefault' => '<p>Shows whether the authentication profile is the default authentication profile for the Amazon Connect instance. The default authentication profile applies to all agents in an Amazon Connect instance, unless overridden by another authentication profile.</p>', 'EvaluationAnswerData$NotApplicable' => '<p>The flag to mark the question as not applicable.</p>', 'EvaluationFormNumericQuestionOption$AutomaticFail' => '<p>The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall evaluation gets a score of 0.</p>', 'EvaluationFormQuestion$NotApplicableEnabled' => '<p>The flag to enable not applicable answers to the question.</p>', 'EvaluationFormSingleSelectQuestionOption$AutomaticFail' => '<p>The flag to mark the option as automatic fail. If an automatic fail answer is provided, the overall evaluation gets a score of 0.</p>', 'EvaluationScore$NotApplicable' => '<p>The flag to mark the item as not applicable for scoring.</p>', 'EvaluationScore$AutomaticFail' => '<p>The flag that marks the item as automatic fail. If the item or a child item gets an automatic fail answer, this flag will be true.</p>', 'FieldValueUnion$BooleanValue' => '<p>A Boolean number value type.</p>', 'MetricFilterV2$Negate' => '<p>The flag to use to filter on requested metric filter values or to not filter on requested metric filter values. By default the negate is <code>false</code>, which indicates to filter on the requested metric filter. </p>', 'RoutingProfile$IsDefault' => '<p>Whether this a default routing profile.</p>', 'SignInDistribution$Enabled' => '<p>Whether sign in distribution is enabled.</p>', 'TrafficDistributionGroup$IsDefault' => '<p>Whether this is the default traffic distribution group created during instance replication. The default traffic distribution group cannot be deleted by the <code>DeleteTrafficDistributionGroup</code> API. The default traffic distribution group is deleted as part of the process for deleting a replica.</p> <note> <p>The <code>SignInConfig</code> distribution is available only on a default <code>TrafficDistributionGroup</code> (see the <code>IsDefault</code> parameter in the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_TrafficDistributionGroup.html">TrafficDistributionGroup</a> data type). If you call <code>UpdateTrafficDistribution</code> with a modified <code>SignInConfig</code> and a non-default <code>TrafficDistributionGroup</code>, an <code>InvalidRequestException</code> is returned.</p> </note>', 'TrafficDistributionGroupSummary$IsDefault' => '<p>Whether this is the default traffic distribution group created during instance replication. The default traffic distribution group cannot be deleted by the <code>DeleteTrafficDistributionGroup</code> API. The default traffic distribution group is deleted as part of the process for deleting a replica.</p>', 'UpdateAgentStatusRequest$ResetOrderNumber' => '<p>A number indicating the reset order of the agent status.</p>', ], ], 'BotName' => [ 'base' => NULL, 'refs' => [ 'DisassociateLexBotRequest$BotName' => '<p>The name of the Amazon Lex bot. Maximum character limit of 50.</p>', 'LexBot$Name' => '<p>The name of the Amazon Lex bot.</p>', ], ], 'BoxedBoolean' => [ 'base' => NULL, 'refs' => [ 'UpdateEvaluationFormRequest$CreateNewVersion' => '<p>A flag indicating whether the operation must create a new version.</p>', ], ], 'BucketName' => [ 'base' => NULL, 'refs' => [ 'S3Config$BucketName' => '<p>The S3 bucket name.</p>', ], ], 'Campaign' => [ 'base' => '<p>Information associated with a campaign.</p>', 'refs' => [ 'Contact$Campaign' => NULL, 'ContactDataRequest$Campaign' => '<p>Structure to store information associated with a campaign.</p>', ], ], 'CampaignId' => [ 'base' => NULL, 'refs' => [ 'Campaign$CampaignId' => '<p>A unique identifier for a campaign.</p>', 'StartOutboundVoiceContactRequest$CampaignId' => '<p>The campaign identifier of the outbound communication.</p>', ], ], 'Channel' => [ 'base' => NULL, 'refs' => [ 'AgentContactReference$Channel' => '<p>The channel of the contact.</p>', 'ChannelList$member' => NULL, 'ChannelToCountMap$key' => NULL, 'Channels$member' => NULL, 'Contact$Channel' => '<p>How the contact reached your contact center.</p>', 'ContactSearchSummary$Channel' => '<p>How the contact reached your contact center.</p>', 'Dimensions$Channel' => '<p>The channel used for grouping and filters.</p>', 'MediaConcurrency$Channel' => '<p>The channels that agents can handle in the Contact Control Panel (CCP).</p>', 'RoutingProfileQueueConfigSummary$Channel' => '<p>The channels this queue supports.</p>', 'RoutingProfileQueueReference$Channel' => '<p>The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.</p>', ], ], 'ChannelList' => [ 'base' => NULL, 'refs' => [ 'SearchCriteria$Channels' => '<p>The list of channels associated with contacts.</p>', ], ], 'ChannelToCountMap' => [ 'base' => NULL, 'refs' => [ 'UserData$AvailableSlotsByChannel' => '<p>A map of available slots by channel. The key is a channel name. The value is an integer: the available number of slots. </p>', 'UserData$MaxSlotsByChannel' => '<p>A map of maximum slots by channel. The key is a channel name. The value is an integer: the maximum number of slots. This is calculated from <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_MediaConcurrency.html">MediaConcurrency</a> of the <code>RoutingProfile</code> assigned to the agent. </p>', 'UserData$ActiveSlotsByChannel' => '<p> A map of active slots by channel. The key is a channel name. The value is an integer: the number of active slots. </p>', ], ], 'Channels' => [ 'base' => NULL, 'refs' => [ 'Filters$Channels' => '<p>The channel to use to filter the metrics.</p>', ], ], 'ChatContent' => [ 'base' => NULL, 'refs' => [ 'ChatEvent$Content' => '<p>Content of the message or event. This is required when <code>Type</code> is <code>MESSAGE</code> and for certain <code>ContentTypes</code> when <code>Type</code> is <code>EVENT</code>.</p> <ul> <li> <p>For allowed message content, see the <code>Content</code> parameter in the <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html">SendMessage</a> topic in the <i>Amazon Connect Participant Service API Reference</i>.</p> </li> <li> <p>For allowed event content, see the <code>Content</code> parameter in the <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html">SendEvent</a> topic in the <i>Amazon Connect Participant Service API Reference</i>. </p> </li> </ul>', 'ChatMessage$Content' => '<p>The content of the chat message. </p> <ul> <li> <p>For <code>text/plain</code> and <code>text/markdown</code>, the Length Constraints are Minimum of 1, Maximum of 1024. </p> </li> <li> <p>For <code>application/json</code>, the Length Constraints are Minimum of 1, Maximum of 12000. </p> </li> <li> <p>For <code>application/vnd.amazonaws.connect.message.interactive.response</code>, the Length Constraints are Minimum of 1, Maximum of 12288.</p> </li> </ul>', ], ], 'ChatContentType' => [ 'base' => NULL, 'refs' => [ 'ChatEvent$ContentType' => '<p>Type of content. This is required when <code>Type</code> is <code>MESSAGE</code> or <code>EVENT</code>. </p> <ul> <li> <p>For allowed message content types, see the <code>ContentType</code> parameter in the <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendMessage.html">SendMessage</a> topic in the <i>Amazon Connect Participant Service API Reference</i>.</p> </li> <li> <p>For allowed event content types, see the <code>ContentType</code> parameter in the <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_SendEvent.html">SendEvent</a> topic in the <i>Amazon Connect Participant Service API Reference</i>. </p> </li> </ul>', 'ChatMessage$ContentType' => '<p>The type of the content. Supported types are <code>text/plain</code>, <code>text/markdown</code>, <code>application/json</code>, and <code>application/vnd.amazonaws.connect.message.interactive.response</code>.</p>', ], ], 'ChatDurationInMinutes' => [ 'base' => NULL, 'refs' => [ 'StartChatContactRequest$ChatDurationInMinutes' => '<p>The total duration of the newly started chat session. If not specified, the chat session duration defaults to 25 hour. The minimum configurable time is 60 minutes. The maximum configurable time is 10,080 minutes (7 days).</p>', ], ], 'ChatEvent' => [ 'base' => '<p>Chat integration event containing payload to perform different chat actions such as:</p> <ul> <li> <p>Sending a chat message</p> </li> <li> <p>Sending a chat event, such as typing</p> </li> <li> <p>Disconnecting from a chat</p> </li> </ul>', 'refs' => [ 'SendChatIntegrationEventRequest$Event' => '<p>Chat integration event payload</p>', ], ], 'ChatEventType' => [ 'base' => NULL, 'refs' => [ 'ChatEvent$Type' => '<p>Type of chat integration event. </p>', ], ], 'ChatMessage' => [ 'base' => '<p>A chat message.</p>', 'refs' => [ 'StartChatContactRequest$InitialMessage' => '<p>The initial message to be sent to the newly created chat. If you have a Lex bot in your flow, the initial message is not delivered to the Lex bot.</p>', ], ], 'ChatParticipantRoleConfig' => [ 'base' => '<p>Configuration information for the chat participant role.</p>', 'refs' => [ 'UpdateParticipantRoleConfigChannelInfo$Chat' => '<p>Configuration information for the chat participant role.</p>', ], ], 'ChatStreamingConfiguration' => [ 'base' => '<p>The streaming configuration, such as the Amazon SNS streaming endpoint.</p>', 'refs' => [ 'NewSessionDetails$StreamingConfiguration' => NULL, 'StartContactStreamingRequest$ChatStreamingConfiguration' => '<p>The streaming configuration, such as the Amazon SNS streaming endpoint.</p>', ], ], 'ChatStreamingEndpointARN' => [ 'base' => NULL, 'refs' => [ 'ChatStreamingConfiguration$StreamingEndpointArn' => '<p>The Amazon Resource Name (ARN) of the standard Amazon SNS topic. The Amazon Resource Name (ARN) of the streaming endpoint that is used to publish real-time message streaming for chat conversations.</p>', ], ], 'ClaimPhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'ClaimPhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'ClaimedPhoneNumberSummary' => [ 'base' => '<p>Information about a phone number that has been claimed to your Amazon Connect instance or traffic distribution group.</p>', 'refs' => [ 'DescribePhoneNumberResponse$ClaimedPhoneNumberSummary' => '<p>Information about a phone number that\'s been claimed to your Amazon Connect instance or traffic distribution group.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'BatchPutContactRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'ClaimPhoneNumberRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p> <p>Pattern: <code>^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$</code> </p>', 'CreateContactFlowModuleRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'CreateEvaluationFormRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'CreateInstanceRequest$ClientToken' => '<p>The idempotency token.</p>', 'CreateParticipantRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'CreatePersistentContactAssociationRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'CreateRuleRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'CreateTaskTemplateRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'CreateTrafficDistributionGroupRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'CreateVocabularyRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>. If a create request is received more than once with same client token, subsequent requests return the previous response without creating a vocabulary again.</p>', 'ImportPhoneNumberRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'MonitorContactRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'ReleasePhoneNumberRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'ReplicateInstanceRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'StartAttachedFileUploadRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'StartChatContactRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'StartContactEvaluationRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'StartContactStreamingRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'StartOutboundVoiceContactRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>. The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned. </p>', 'StartTaskContactRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'StartWebRTCContactRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p> <p>The token is valid for 7 days after creation. If a contact is already started, the contact ID is returned.</p>', 'TransferContactRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'UpdateEvaluationFormRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'UpdatePhoneNumberMetadataRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', 'UpdatePhoneNumberRequest$ClientToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with idempotent APIs</a>.</p>', ], ], 'CommonAttributeAndCondition' => [ 'base' => '<p>A list of conditions which would be applied together with an <code>AND</code> condition.</p>', 'refs' => [ 'CommonAttributeOrConditionList$member' => NULL, 'ControlPlaneAttributeFilter$AndCondition' => '<p>A list of conditions which would be applied together with an <code>AND</code> condition.</p>', ], ], 'CommonAttributeOrConditionList' => [ 'base' => NULL, 'refs' => [ 'ControlPlaneAttributeFilter$OrConditions' => '<p>A list of conditions which would be applied together with an <code>OR</code> condition.</p>', ], ], 'CommonNameLength127' => [ 'base' => NULL, 'refs' => [ 'CreateHoursOfOperationRequest$Name' => '<p>The name of the hours of operation.</p>', 'CreatePromptRequest$Name' => '<p>The name of the prompt.</p>', 'CreateQueueRequest$Name' => '<p>The name of the queue.</p>', 'HoursOfOperation$Name' => '<p>The name for the hours of operation.</p>', 'Prompt$Name' => '<p>The name of the prompt.</p>', 'Queue$Name' => '<p>The name of the queue.</p>', 'UpdateHoursOfOperationRequest$Name' => '<p>The name of the hours of operation.</p>', 'UpdatePromptRequest$Name' => '<p>The name of the prompt.</p>', 'UpdateQueueNameRequest$Name' => '<p>The name of the queue.</p>', ], ], 'Comparison' => [ 'base' => NULL, 'refs' => [ 'Threshold$Comparison' => '<p>The type of comparison. Only "less than" (LT) comparisons are supported.</p>', ], ], 'ComparisonOperator' => [ 'base' => NULL, 'refs' => [ 'AttributeCondition$ComparisonOperator' => '<p>The operator of the condition.</p>', ], ], 'CompleteAttachedFileUploadRequest' => [ 'base' => 'Request to CompleteAttachedFileUpload API', 'refs' => [], ], 'CompleteAttachedFileUploadResponse' => [ 'base' => 'Response from CompleteAttachedFileUpload API', 'refs' => [], ], 'Concurrency' => [ 'base' => NULL, 'refs' => [ 'MediaConcurrency$Concurrency' => '<p>The number of contacts an agent can have on a channel simultaneously.</p> <p>Valid Range for <code>VOICE</code>: Minimum value of 1. Maximum value of 1.</p> <p>Valid Range for <code>CHAT</code>: Minimum value of 1. Maximum value of 10.</p> <p>Valid Range for <code>TASK</code>: Minimum value of 1. Maximum value of 10.</p>', ], ], 'Condition' => [ 'base' => '<p>A leaf node condition which can be used to specify a ProficiencyName, ProficiencyValue and ProficiencyLimit.</p>', 'refs' => [ 'Conditions$member' => NULL, ], ], 'Conditions' => [ 'base' => NULL, 'refs' => [ 'ListCondition$Conditions' => '<p>A list of Condition objects which would be applied together with an AND condition.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Operation cannot be performed at this time as there is a conflict with another operation or contact state.</p>', 'refs' => [], ], 'ConnectionData' => [ 'base' => '<p>Information required to join the call.</p>', 'refs' => [ 'StartWebRTCContactResponse$ConnectionData' => '<p>Information required for the client application (mobile application or website) to connect to the call.</p>', ], ], 'Contact' => [ 'base' => '<p>Contains information about a contact.</p>', 'refs' => [ 'DescribeContactResponse$Contact' => '<p>Information about the contact.</p>', ], ], 'ContactAnalysis' => [ 'base' => '<p>A structure that defines search criteria for contacts using analysis outputs from Amazon Connect Contact Lens.</p>', 'refs' => [ 'SearchCriteria$ContactAnalysis' => '<p>Search criteria based on analysis outputs from Amazon Connect Contact Lens.</p>', ], ], 'ContactDataRequest' => [ 'base' => '<p>Request object with information to create a contact.</p>', 'refs' => [ 'ContactDataRequestList$member' => NULL, ], ], 'ContactDataRequestList' => [ 'base' => NULL, 'refs' => [ 'BatchPutContactRequest$ContactDataRequestList' => '<p>List of individual contact requests.</p>', ], ], 'ContactFilter' => [ 'base' => '<p>Filters user data based on the contact information that is associated to the users. It contains a list of <a href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">contact states</a>.</p>', 'refs' => [ 'UserDataFilters$ContactFilter' => '<p>A filter for the user data based on the contact information that is associated to the user. It contains a list of contact states. </p>', ], ], 'ContactFlow' => [ 'base' => '<p>Contains information about a flow.</p>', 'refs' => [ 'ContactFlowSearchSummaryList$member' => NULL, 'DescribeContactFlowResponse$ContactFlow' => '<p>Information about the flow.</p>', ], ], 'ContactFlowContent' => [ 'base' => NULL, 'refs' => [ 'ContactFlow$Content' => '<p>The JSON string that represents the content of the flow. For an example, see <a href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in Amazon Connect Flow language</a>. </p> <p>Length Constraints: Minimum length of 1. Maximum length of 256000.</p>', 'CreateContactFlowRequest$Content' => '<p>The JSON string that represents the content of the flow. For an example, see <a href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in Amazon Connect Flow language</a>. </p> <p>Length Constraints: Minimum length of 1. Maximum length of 256000.</p>', 'UpdateContactFlowContentRequest$Content' => '<p>The JSON string that represents the content of the flow. For an example, see <a href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in Amazon Connect Flow language</a>. </p> <p>Length Constraints: Minimum length of 1. Maximum length of 256000.</p>', ], ], 'ContactFlowDescription' => [ 'base' => NULL, 'refs' => [ 'ContactFlow$Description' => '<p>The description of the flow.</p>', 'CreateContactFlowRequest$Description' => '<p>The description of the flow. </p>', 'UpdateContactFlowMetadataRequest$Description' => '<p>The description of the flow.</p>', 'UpdateContactFlowNameRequest$Description' => '<p>The description of the flow.</p>', ], ], 'ContactFlowId' => [ 'base' => NULL, 'refs' => [ 'AssociatePhoneNumberContactFlowRequest$ContactFlowId' => '<p>The identifier of the flow.</p>', 'ContactFlow$Id' => '<p>The identifier of the flow.</p>', 'ContactFlowSummary$Id' => '<p>The identifier of the flow.</p>', 'CreateContactFlowResponse$ContactFlowId' => '<p>The identifier of the flow.</p>', 'CreateTaskTemplateRequest$ContactFlowId' => '<p>The identifier of the flow that runs by default when a task is created by referencing this template.</p>', 'DeleteContactFlowRequest$ContactFlowId' => '<p>The identifier of the flow.</p>', 'DescribeContactFlowRequest$ContactFlowId' => '<p>The identifier of the flow.</p>', 'GetTaskTemplateResponse$ContactFlowId' => '<p>The identifier of the flow that runs by default when a task is created by referencing this template.</p>', 'OutboundCallerConfig$OutboundFlowId' => '<p>The outbound whisper flow to be used during an outbound call.</p>', 'PauseContactRequest$ContactFlowId' => '<p>The identifier of the flow.</p>', 'QueueQuickConnectConfig$ContactFlowId' => '<p>The identifier of the flow.</p>', 'ResumeContactRequest$ContactFlowId' => '<p>The identifier of the flow.</p>', 'StartChatContactRequest$ContactFlowId' => '<p>The identifier of the flow for initiating the chat. To see the ContactFlowId in the Amazon Connect admin website, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the flow. On the flow page, under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p> <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>', 'StartOutboundVoiceContactRequest$ContactFlowId' => '<p>The identifier of the flow for the outbound call. To see the ContactFlowId in the Amazon Connect admin website, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the flow. On the flow page, under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p> <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>', 'StartTaskContactRequest$ContactFlowId' => '<p>The identifier of the flow for initiating the tasks. To see the ContactFlowId in the Amazon Connect admin website, on the navigation menu go to <b>Routing</b>, <b>Contact Flows</b>. Choose the flow. On the flow page, under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p> <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>', 'StartWebRTCContactRequest$ContactFlowId' => '<p>The identifier of the flow for the call. To see the ContactFlowId in the Amazon Connect admin website, on the navigation menu go to <b>Routing</b>, <b>Flows</b>. Choose the flow. On the flow page, under the name of the flow, choose <b>Show additional flow information</b>. The ContactFlowId is the last part of the ARN, shown here in bold: </p> <p>arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/<b>846ec553-a005-41c0-8341-xxxxxxxxxxxx</b> </p>', 'TaskActionDefinition$ContactFlowId' => '<p>The identifier of the flow.</p>', 'TransferContactRequest$ContactFlowId' => '<p>The identifier of the flow.</p>', 'UpdateContactFlowContentRequest$ContactFlowId' => '<p>The identifier of the flow.</p>', 'UpdateContactFlowMetadataRequest$ContactFlowId' => '<p>The identifier of the flow.</p>', 'UpdateContactFlowNameRequest$ContactFlowId' => '<p>The identifier of the flow.</p>', 'UpdateTaskTemplateRequest$ContactFlowId' => '<p>The identifier of the flow that runs by default when a task is created by referencing this template.</p>', 'UpdateTaskTemplateResponse$ContactFlowId' => '<p>The identifier of the flow that runs by default when a task is created by referencing this template.</p>', 'UserQuickConnectConfig$ContactFlowId' => '<p>The identifier of the flow.</p>', ], ], 'ContactFlowModule' => [ 'base' => '<p>Contains information about a flow module.</p>', 'refs' => [ 'ContactFlowModuleSearchSummaryList$member' => NULL, 'DescribeContactFlowModuleResponse$ContactFlowModule' => '<p>Information about the flow module.</p>', ], ], 'ContactFlowModuleContent' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModule$Content' => '<p>The JSON string that represents the content of the flow. For an example, see <a href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in Amazon Connect Flow language</a>. </p>', 'CreateContactFlowModuleRequest$Content' => '<p>The JSON string that represents the content of the flow. For an example, see <a href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in Amazon Connect Flow language</a>. </p>', 'UpdateContactFlowModuleContentRequest$Content' => '<p>The JSON string that represents the content of the flow. For an example, see <a href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language-example.html">Example flow in Amazon Connect Flow language</a>. </p>', ], ], 'ContactFlowModuleDescription' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModule$Description' => '<p>The description of the flow module.</p>', 'CreateContactFlowModuleRequest$Description' => '<p>The description of the flow module. </p>', 'UpdateContactFlowModuleMetadataRequest$Description' => '<p>The description of the flow module.</p>', ], ], 'ContactFlowModuleId' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModule$Id' => '<p>The identifier of the flow module.</p>', 'ContactFlowModuleSummary$Id' => '<p>The identifier of the flow module.</p>', 'CreateContactFlowModuleResponse$Id' => '<p>The identifier of the flow module.</p>', 'DeleteContactFlowModuleRequest$ContactFlowModuleId' => '<p>The identifier of the flow module.</p>', 'DescribeContactFlowModuleRequest$ContactFlowModuleId' => '<p>The identifier of the flow module.</p>', 'UpdateContactFlowModuleContentRequest$ContactFlowModuleId' => '<p>The identifier of the flow module.</p>', 'UpdateContactFlowModuleMetadataRequest$ContactFlowModuleId' => '<p>The identifier of the flow module.</p>', ], ], 'ContactFlowModuleName' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModule$Name' => '<p>The name of the flow module.</p>', 'ContactFlowModuleSummary$Name' => '<p>The name of the flow module.</p>', 'CreateContactFlowModuleRequest$Name' => '<p>The name of the flow module.</p>', 'UpdateContactFlowModuleMetadataRequest$Name' => '<p>The name of the flow module.</p>', ], ], 'ContactFlowModuleSearchConditionList' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModuleSearchCriteria$OrConditions' => '<p>A list of conditions which would be applied together with an <code>OR</code> condition.</p>', 'ContactFlowModuleSearchCriteria$AndConditions' => '<p>A list of conditions which would be applied together with an <code>AND</code> condition.</p>', ], ], 'ContactFlowModuleSearchCriteria' => [ 'base' => '<p>The search criteria to be used to return flow modules.</p>', 'refs' => [ 'ContactFlowModuleSearchConditionList$member' => NULL, 'SearchContactFlowModulesRequest$SearchCriteria' => '<p>The search criteria to be used to return contact flow modules.</p> <note> <p>The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2 characters and a maximum of 25 characters. Any queries with character lengths outside of this range will result in invalid results.</p> </note>', ], ], 'ContactFlowModuleSearchFilter' => [ 'base' => '<p>The search criteria to be used to return flow modules.</p>', 'refs' => [ 'SearchContactFlowModulesRequest$SearchFilter' => '<p>Filters to be applied to search results.</p>', ], ], 'ContactFlowModuleSearchSummaryList' => [ 'base' => NULL, 'refs' => [ 'SearchContactFlowModulesResponse$ContactFlowModules' => '<p>The search criteria to be used to return contact flow modules.</p>', ], ], 'ContactFlowModuleState' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModule$State' => '<p>The type of flow module.</p>', 'ContactFlowModuleSummary$State' => '<p>The type of flow module.</p>', 'ListContactFlowModulesRequest$ContactFlowModuleState' => '<p>The state of the flow module.</p>', 'UpdateContactFlowModuleMetadataRequest$State' => '<p>The state of flow module.</p>', ], ], 'ContactFlowModuleStatus' => [ 'base' => NULL, 'refs' => [ 'ContactFlowModule$Status' => '<p>The status of the flow module.</p>', ], ], 'ContactFlowModuleSummary' => [ 'base' => '<p>Contains summary information about a flow.</p>', 'refs' => [ 'ContactFlowModulesSummaryList$member' => NULL, ], ], 'ContactFlowModulesSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListContactFlowModulesResponse$ContactFlowModulesSummaryList' => '<p>Information about the flow module.</p>', ], ], 'ContactFlowName' => [ 'base' => NULL, 'refs' => [ 'ContactFlow$Name' => '<p>The name of the flow.</p>', 'ContactFlowSummary$Name' => '<p>The name of the flow.</p>', 'CreateContactFlowRequest$Name' => '<p>The name of the flow.</p>', 'UpdateContactFlowMetadataRequest$Name' => '<p>The name of the flow.</p>', 'UpdateContactFlowNameRequest$Name' => '<p>The name of the flow.</p>', ], ], 'ContactFlowNotPublishedException' => [ 'base' => '<p>The flow has not been published.</p>', 'refs' => [], ], 'ContactFlowSearchConditionList' => [ 'base' => NULL, 'refs' => [ 'ContactFlowSearchCriteria$OrConditions' => '<p>A list of conditions which would be applied together with an <code>OR</code> condition.</p>', 'ContactFlowSearchCriteria$AndConditions' => '<p>A list of conditions which would be applied together with an <code>AND</code> condition.</p>', ], ], 'ContactFlowSearchCriteria' => [ 'base' => '<p>The search criteria to be used to return contact flows.</p>', 'refs' => [ 'ContactFlowSearchConditionList$member' => NULL, 'SearchContactFlowsRequest$SearchCriteria' => '<p>The search criteria to be used to return flows.</p> <note> <p>The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2 characters and a maximum of 25 characters. Any queries with character lengths outside of this range will result in invalid results.</p> </note>', ], ], 'ContactFlowSearchFilter' => [ 'base' => '<p>Filters to be applied to search results.</p>', 'refs' => [ 'SearchContactFlowsRequest$SearchFilter' => '<p>Filters to be applied to search results.</p>', ], ], 'ContactFlowSearchSummaryList' => [ 'base' => NULL, 'refs' => [ 'SearchContactFlowsResponse$ContactFlows' => '<p>Information about the flows.</p>', ], ], 'ContactFlowState' => [ 'base' => NULL, 'refs' => [ 'ContactFlow$State' => '<p>The type of flow.</p>', 'ContactFlowSearchCriteria$StateCondition' => '<p>The state of the flow.</p>', 'ContactFlowSummary$ContactFlowState' => '<p>The type of flow.</p>', 'UpdateContactFlowMetadataRequest$ContactFlowState' => '<p>The state of flow.</p>', ], ], 'ContactFlowStatus' => [ 'base' => NULL, 'refs' => [ 'ContactFlow$Status' => '<p>The status of the contact flow.</p>', 'ContactFlowSearchCriteria$StatusCondition' => '<p>The status of the flow.</p>', 'ContactFlowSummary$ContactFlowStatus' => '<p>The status of the contact flow.</p>', 'CreateContactFlowRequest$Status' => '<p>Indicates the flow status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code> status will initiate validation on the content. the <code>SAVED</code> status does not initiate validation of the content. <code>SAVED</code> | <code>PUBLISHED</code>.</p>', ], ], 'ContactFlowSummary' => [ 'base' => '<p>Contains summary information about a flow.</p> <p>You can also create and update flows using the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html">Amazon Connect Flow language</a>.</p>', 'refs' => [ 'ContactFlowSummaryList$member' => NULL, ], ], 'ContactFlowSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListContactFlowsResponse$ContactFlowSummaryList' => '<p>Information about the flows.</p>', ], ], 'ContactFlowType' => [ 'base' => NULL, 'refs' => [ 'ContactFlow$Type' => '<p>The type of the flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a flow type</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'ContactFlowSearchCriteria$TypeCondition' => '<p>The type of flow.</p>', 'ContactFlowSummary$ContactFlowType' => '<p>The type of flow.</p>', 'ContactFlowTypes$member' => NULL, 'CreateContactFlowRequest$Type' => '<p>The type of the flow. For descriptions of the available types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types">Choose a flow type</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', ], ], 'ContactFlowTypes' => [ 'base' => NULL, 'refs' => [ 'ListContactFlowsRequest$ContactFlowTypes' => '<p>The type of flow.</p>', ], ], 'ContactId' => [ 'base' => NULL, 'refs' => [ 'AgentContactReference$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. </p>', 'Contact$Id' => '<p>The identifier for the contact.</p>', 'Contact$InitialContactId' => '<p>If this contact is related to other contacts, this is the ID of the initial contact.</p>', 'Contact$PreviousContactId' => '<p>If this contact is not the first contact, this is the ID of the previous contact.</p>', 'Contact$RelatedContactId' => '<p>The contactId that is <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html#relatedcontactid">related</a> to this contact.</p>', 'ContactSearchSummary$Id' => '<p>The identifier of the contact summary.</p>', 'ContactSearchSummary$InitialContactId' => '<p>If this contact is related to other contacts, this is the ID of the initial contact.</p>', 'ContactSearchSummary$PreviousContactId' => '<p>If this contact is not the first contact, this is the ID of the previous contact.</p>', 'CreateParticipantRequest$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. Only contacts in the CHAT channel are supported.</p>', 'CreatePersistentContactAssociationRequest$InitialContactId' => '<p>This is the contactId of the current contact that the <code>CreatePersistentContactAssociation</code> API is being called from.</p>', 'CreatePersistentContactAssociationRequest$SourceContactId' => '<p>The contactId from which a persistent chat session must be started.</p>', 'CreatePersistentContactAssociationResponse$ContinuedFromContactId' => '<p>The contactId from which a persistent chat session is started. This field is populated only for persistent chat.</p>', 'DescribeContactRequest$ContactId' => '<p>The identifier of the contact.</p>', 'DismissUserContactRequest$ContactId' => '<p>The identifier of the contact.</p>', 'EvaluationMetadata$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. </p>', 'GetContactAttributesRequest$InitialContactId' => '<p>The identifier of the initial contact.</p>', 'ListContactEvaluationsRequest$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. </p>', 'ListContactReferencesRequest$ContactId' => '<p>The identifier of the initial contact.</p>', 'ListRealtimeContactAnalysisSegmentsV2Request$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. </p>', 'MonitorContactRequest$ContactId' => '<p>The identifier of the contact.</p>', 'MonitorContactResponse$ContactId' => '<p>The identifier of the contact.</p>', 'PauseContactRequest$ContactId' => '<p>The identifier of the contact.</p>', 'PersistentChat$SourceContactId' => '<p>The contactId from which a persistent chat session must be started.</p>', 'ResumeContactRecordingRequest$ContactId' => '<p>The identifier of the contact.</p>', 'ResumeContactRecordingRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'ResumeContactRequest$ContactId' => '<p>The identifier of the contact.</p>', 'SendChatIntegrationEventResponse$InitialContactId' => '<p>Identifier of chat contact used to handle integration event. This may be null if the integration event is not valid without an already existing chat contact.</p>', 'StartChatContactRequest$RelatedContactId' => '<p>The unique identifier for an Amazon Connect contact. This identifier is related to the chat starting.</p> <note> <p>You cannot provide data for both RelatedContactId and PersistentChat. </p> </note>', 'StartChatContactResponse$ContactId' => '<p>The identifier of this contact within the Amazon Connect instance. </p>', 'StartChatContactResponse$ContinuedFromContactId' => '<p>The contactId from which a persistent chat session is started. This field is populated only for persistent chats.</p>', 'StartContactEvaluationRequest$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. </p>', 'StartContactRecordingRequest$ContactId' => '<p>The identifier of the contact.</p>', 'StartContactRecordingRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'StartContactStreamingRequest$ContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'StartOutboundVoiceContactRequest$RelatedContactId' => '<p>The <code>contactId</code> that is related to this contact. Linking voice, task, or chat by using <code>RelatedContactID</code> copies over contact attributes from the related contact to the new contact. All updates to user-defined attributes in the new contact are limited to the individual contact ID. There are no limits to the number of contacts that can be linked by using <code>RelatedContactId</code>. </p>', 'StartOutboundVoiceContactResponse$ContactId' => '<p>The identifier of this contact within the Amazon Connect instance.</p>', 'StartTaskContactRequest$PreviousContactId' => '<p>The identifier of the previous chat, voice, or task contact. Any updates to user-defined attributes to task contacts linked using the same <code>PreviousContactID</code> will affect every contact in the chain. There can be a maximum of 12 linked task contacts in a chain.</p>', 'StartTaskContactRequest$RelatedContactId' => '<p>The contactId that is <a href="https://docs.aws.amazon.com/connect/latest/adminguide/tasks.html#linked-tasks">related</a> to this contact. Linking tasks together by using <code>RelatedContactID</code> copies over contact attributes from the related task contact to the new task contact. All updates to user-defined attributes in the new task contact are limited to the individual contact ID, unlike what happens when tasks are linked by using <code>PreviousContactID</code>. There are no limits to the number of contacts that can be linked by using <code>RelatedContactId</code>. </p>', 'StartTaskContactResponse$ContactId' => '<p>The identifier of this contact within the Amazon Connect instance.</p>', 'StartWebRTCContactRequest$RelatedContactId' => '<p>The unique identifier for an Amazon Connect contact. This identifier is related to the contact starting.</p>', 'StartWebRTCContactResponse$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. </p>', 'StopContactRecordingRequest$ContactId' => '<p>The identifier of the contact.</p>', 'StopContactRecordingRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'StopContactRequest$ContactId' => '<p>The ID of the contact.</p>', 'StopContactStreamingRequest$ContactId' => '<p>The identifier of the contact. This is the identifier of the contact that is associated with the first interaction with the contact center.</p>', 'SuccessfulRequest$ContactId' => '<p>The contactId of the contact that was created successfully.</p>', 'SuspendContactRecordingRequest$ContactId' => '<p>The identifier of the contact.</p>', 'SuspendContactRecordingRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'TagContactRequest$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. </p>', 'TransferContactRequest$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. </p>', 'TransferContactResponse$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. </p>', 'UntagContactRequest$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. </p>', 'UpdateContactAttributesRequest$InitialContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with the contact center.</p>', 'UpdateContactRequest$ContactId' => '<p>The identifier of the contact. This is the identifier of the contact associated with the first interaction with your contact center.</p>', 'UpdateContactRoutingDataRequest$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. </p>', 'UpdateContactScheduleRequest$ContactId' => '<p>The identifier of the contact.</p>', 'UpdateParticipantRoleConfigRequest$ContactId' => '<p>The identifier of the contact in this instance of Amazon Connect. </p>', ], ], 'ContactInitiationMethod' => [ 'base' => NULL, 'refs' => [ 'AgentContactReference$InitiationMethod' => '<p>How the contact was initiated.</p>', 'Contact$InitiationMethod' => '<p>Indicates how the contact was initiated.</p>', 'ContactSearchSummary$InitiationMethod' => '<p>Indicates how the contact was initiated.</p>', 'InitiationMethodList$member' => NULL, ], ], 'ContactNotFoundException' => [ 'base' => '<p>The contact with the specified ID is not active or does not exist. Applies to Voice calls only, not to Chat or Task contacts.</p>', 'refs' => [], ], 'ContactReferences' => [ 'base' => NULL, 'refs' => [ 'StartOutboundVoiceContactRequest$References' => '<p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Contacts can have the following reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> | <code>STRING</code> | <code>DATE</code> | <code>EMAIL</code>. <code>ATTACHMENT</code> is not a supported reference type during voice contact creation.</p>', 'StartTaskContactRequest$References' => '<p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the following reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> | <code>STRING</code> | <code>DATE</code> | <code>EMAIL</code>. <code>ATTACHMENT</code> is not a supported reference type during task creation.</p>', 'StartWebRTCContactRequest$References' => '<p>A formatted URL that is shown to an agent in the Contact Control Panel (CCP). Tasks can have the following reference types at the time of creation: <code>URL</code> | <code>NUMBER</code> | <code>STRING</code> | <code>DATE</code> | <code>EMAIL</code>. <code>ATTACHMENT</code> is not a supported reference type during task creation.</p>', 'TaskActionDefinition$References' => '<p>Information about the reference when the <code>referenceType</code> is <code>URL</code>. Otherwise, null. (Supports variable injection in the <code>Value</code> field.)</p>', 'UpdateContactRequest$References' => '<p>Well-formed data on contact, shown to agents on Contact Control Panel (CCP).</p>', ], ], 'ContactSearchSummary' => [ 'base' => '<p>Information of returned contact.</p>', 'refs' => [ 'Contacts$member' => NULL, ], ], 'ContactSearchSummaryAgentInfo' => [ 'base' => '<p>Information about the agent who accepted the contact.</p>', 'refs' => [ 'ContactSearchSummary$AgentInfo' => '<p>Information about the agent who accepted the contact.</p>', ], ], 'ContactSearchSummaryQueueInfo' => [ 'base' => '<p>If this contact was queued, this contains information about the queue.</p>', 'refs' => [ 'ContactSearchSummary$QueueInfo' => '<p>If this contact was queued, this contains information about the queue.</p>', ], ], 'ContactState' => [ 'base' => NULL, 'refs' => [ 'AgentContactReference$AgentContactState' => '<p>The <a href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">state of the contact</a>.</p> <note> <p>When <code>AgentContactState</code> is set to <code>CONNECTED_ONHOLD</code>, <code>StateStartTimestamp</code> is not changed. Instead, <code>StateStartTimestamp</code> reflects the time the contact was <code>CONNECTED</code> to the agent.</p> </note>', 'ContactStates$member' => NULL, ], ], 'ContactStates' => [ 'base' => NULL, 'refs' => [ 'ContactFilter$ContactStates' => '<p>A list of up to 9 <a href="https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html">contact states</a>.</p>', ], ], 'ContactTagKey' => [ 'base' => NULL, 'refs' => [ 'ContactTagKeys$member' => NULL, 'ContactTagMap$key' => NULL, ], ], 'ContactTagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagContactRequest$TagKeys' => '<p>A list of tag keys. Existing tags on the contact whose keys are members of this list will be removed.</p>', ], ], 'ContactTagMap' => [ 'base' => NULL, 'refs' => [ 'Contact$Tags' => '<p>Tags associated with the contact. This contains both Amazon Web Services generated and user-defined tags.</p>', 'TagContactRequest$Tags' => '<p>The tags to be assigned to the contact resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p> <note> <p>Authorization is not supported by this tag.</p> </note>', ], ], 'ContactTagValue' => [ 'base' => NULL, 'refs' => [ 'ContactTagMap$value' => NULL, ], ], 'Contacts' => [ 'base' => NULL, 'refs' => [ 'SearchContactsResponse$Contacts' => '<p>Information about the contacts.</p>', ], ], 'Content' => [ 'base' => NULL, 'refs' => [ 'SendNotificationActionDefinition$Content' => '<p>Notification content. Supports variable injection. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath reference</a> in the <i>Amazon Connect Administrators Guide</i>.</p>', ], ], 'ContentType' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisAttachment$ContentType' => '<p>Describes the MIME file type of the attachment. For a list of supported file types, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/feature-limits.html">Feature specifications</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', ], ], 'ControlPlaneAttributeFilter' => [ 'base' => '<p>An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an <code>OR</code> or <code>AND</code> (List of List) input where: </p> <ul> <li> <p>The top level list specifies conditions that need to be applied with <code>OR</code> operator.</p> </li> <li> <p>The inner list specifies conditions that need to be applied with <code>AND</code> operator.</p> </li> </ul>', 'refs' => [ 'AgentStatusSearchFilter$AttributeFilter' => '<p>An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an <code>OR</code> of <code>AND</code> (List of List) input where: </p> <ul> <li> <p>The top level list specifies conditions that need to be applied with <code>OR</code> operator.</p> </li> <li> <p>The inner list specifies conditions that need to be applied with <code>AND</code> operator.</p> </li> </ul>', 'UserHierarchyGroupSearchFilter$AttributeFilter' => '<p>An object that can be used to specify Tag conditions inside the SearchFilter. This accepts an OR or AND (List of List) input where:</p> <ul> <li> <p>The top level list specifies conditions that need to be applied with <code>OR</code> operator.</p> </li> <li> <p>The inner list specifies conditions that need to be applied with <code>AND</code> operator.</p> </li> </ul>', ], ], 'ControlPlaneTagFilter' => [ 'base' => '<p>An object that can be used to specify Tag conditions inside the <code>SearchFilter</code>. This accepts an <code>OR</code> of <code>AND</code> (List of List) input where: </p> <ul> <li> <p>Top level list specifies conditions that need to be applied with <code>OR</code> operator</p> </li> <li> <p>Inner list specifies conditions that need to be applied with <code>AND</code> operator.</p> </li> </ul>', 'refs' => [ 'ContactFlowModuleSearchFilter$TagFilter' => NULL, 'ContactFlowSearchFilter$TagFilter' => NULL, 'HoursOfOperationSearchFilter$TagFilter' => NULL, 'PromptSearchFilter$TagFilter' => NULL, 'QueueSearchFilter$TagFilter' => NULL, 'QuickConnectSearchFilter$TagFilter' => NULL, 'RoutingProfileSearchFilter$TagFilter' => NULL, 'SecurityProfilesSearchFilter$TagFilter' => NULL, 'UserSearchFilter$TagFilter' => NULL, ], ], 'ControlPlaneUserAttributeFilter' => [ 'base' => '<p>An object that can be used to specify Tag conditions or Hierarchy Group conditions inside the <code>SearchFilter</code>.</p> <p>This accepts an <code>OR</code> of <code>AND</code> (List of List) input where:</p> <ul> <li> <p>The top level list specifies conditions that need to be applied with <code>OR</code> operator</p> </li> <li> <p>The inner list specifies conditions that need to be applied with <code>AND</code> operator.</p> </li> </ul> <note> <p>Only one field can be populated. Maximum number of allowed Tag conditions is 25. Maximum number of allowed Hierarchy Group conditions is 20. </p> </note>', 'refs' => [ 'UserSearchFilter$UserAttributeFilter' => '<p>An object that can be used to specify Tag conditions or Hierarchy Group conditions inside the SearchFilter.</p> <p>This accepts an <code>OR</code> of <code>AND</code> (List of List) input where:</p> <ul> <li> <p>The top level list specifies conditions that need to be applied with <code>OR</code> operator.</p> </li> <li> <p>The inner list specifies conditions that need to be applied with <code>AND</code> operator.</p> </li> </ul> <note> <p>Only one field can be populated. This object can’t be used along with TagFilter. Request can either contain TagFilter or UserAttributeFilter if SearchFilter is specified, combination of both is not supported and such request will throw AccessDeniedException.</p> </note>', ], ], 'CreateAgentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAgentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCaseActionDefinition' => [ 'base' => '<p>The <code>CreateCase</code> action definition.</p>', 'refs' => [ 'RuleAction$CreateCaseAction' => '<p>Information about the create case action.</p> <p>Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> | <code>OnPostChatAnalysisAvailable</code>.</p>', ], ], 'CreateContactFlowModuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateContactFlowModuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateContactFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateContactFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEvaluationFormRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEvaluationFormResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateHoursOfOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateHoursOfOperationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntegrationAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateIntegrationAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateParticipantRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateParticipantResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePersistentContactAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePersistentContactAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatePredefinedAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePromptRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePromptResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateQuickConnectRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateQuickConnectResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoutingProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRoutingProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$SecurityProfileName' => '<p>The name of the security profile.</p>', ], ], 'CreateSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTaskTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTaskTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficDistributionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTrafficDistributionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUseCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUseCaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserHierarchyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserHierarchyGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateViewRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateViewResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateViewVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateViewVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatedByInfo' => [ 'base' => '<p>Information on the identity that created the file.</p>', 'refs' => [ 'AttachedFile$CreatedBy' => '<p>Represents the identity that created the file.</p>', 'GetAttachedFileResponse$CreatedBy' => '<p>Represents the identity that created the file.</p>', 'StartAttachedFileUploadRequest$CreatedBy' => '<p>Represents the identity that created the file.</p>', 'StartAttachedFileUploadResponse$CreatedBy' => '<p>Represents the identity that created the file.</p>', ], ], 'Credentials' => [ 'base' => '<p>Contains credentials to use for federation.</p>', 'refs' => [ 'GetFederationTokenResponse$Credentials' => '<p>The credentials to use for federation.</p>', ], ], 'CrossChannelBehavior' => [ 'base' => '<p>Defines the cross-channel routing behavior that allows an agent working on a contact in one channel to be offered a contact from a different channel.</p>', 'refs' => [ 'MediaConcurrency$CrossChannelBehavior' => '<p>Defines the cross-channel routing behavior for each channel that is enabled for this Routing Profile. For example, this allows you to offer an agent a different contact from another channel when they are currently working with a contact from a Voice channel.</p>', ], ], 'CurrentMetric' => [ 'base' => '<p>Contains information about a real-time metric. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'refs' => [ 'CurrentMetricData$Metric' => '<p>Information about the metric.</p>', 'CurrentMetrics$member' => NULL, ], ], 'CurrentMetricData' => [ 'base' => '<p>Contains the data for a real-time metric.</p>', 'refs' => [ 'CurrentMetricDataCollections$member' => NULL, ], ], 'CurrentMetricDataCollections' => [ 'base' => NULL, 'refs' => [ 'CurrentMetricResult$Collections' => '<p>The set of metrics.</p>', ], ], 'CurrentMetricName' => [ 'base' => '<p>The current metric names.</p>', 'refs' => [ 'CurrentMetric$Name' => '<p>The name of the metric.</p>', 'CurrentMetricSortCriteria$SortByMetric' => NULL, ], ], 'CurrentMetricResult' => [ 'base' => '<p>Contains information about a set of real-time metrics.</p>', 'refs' => [ 'CurrentMetricResults$member' => NULL, ], ], 'CurrentMetricResults' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataResponse$MetricResults' => '<p>Information about the real-time metrics.</p>', ], ], 'CurrentMetricSortCriteria' => [ 'base' => '<p>The way to sort the resulting response based on metrics. By default resources are sorted based on <code>AGENTS_ONLINE</code>, <code>DESCENDING</code>. The metric collection is sorted based on the input metrics.</p>', 'refs' => [ 'CurrentMetricSortCriteriaMaxOne$member' => NULL, ], ], 'CurrentMetricSortCriteriaMaxOne' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$SortCriteria' => '<p>The way to sort the resulting response based on metrics. You can enter one sort criteria. By default resources are sorted based on <code>AGENTS_ONLINE</code>, <code>DESCENDING</code>. The metric collection is sorted based on the input metrics.</p> <p>Note the following:</p> <ul> <li> <p>Sorting on <code>SLOTS_ACTIVE</code> and <code>SLOTS_AVAILABLE</code> is not supported.</p> </li> </ul>', ], ], 'CurrentMetrics' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$CurrentMetrics' => '<p>The metrics to retrieve. Specify the name and unit for each metric. The following metrics are available. For a description of all the metrics, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html">Real-time Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <dl> <dt>AGENTS_AFTER_CONTACT_WORK</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#aftercallwork-real-time">ACW</a> </p> </dd> <dt>AGENTS_AVAILABLE</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#available-real-time">Available</a> </p> </dd> <dt>AGENTS_ERROR</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#error-real-time">Error</a> </p> </dd> <dt>AGENTS_NON_PRODUCTIVE</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#non-productive-time-real-time">NPT (Non-Productive Time)</a> </p> </dd> <dt>AGENTS_ON_CALL</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p> </dd> <dt>AGENTS_ON_CONTACT</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#on-call-real-time">On contact</a> </p> </dd> <dt>AGENTS_ONLINE</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#online-real-time">Online</a> </p> </dd> <dt>AGENTS_STAFFED</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#staffed-real-time">Staffed</a> </p> </dd> <dt>CONTACTS_IN_QUEUE</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#in-queue-real-time">In queue</a> </p> </dd> <dt>CONTACTS_SCHEDULED</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#scheduled-real-time">Scheduled</a> </p> </dd> <dt>OLDEST_CONTACT_AGE</dt> <dd> <p>Unit: SECONDS</p> <p>When you use groupings, Unit says SECONDS and the Value is returned in SECONDS. </p> <p>When you do not use groupings, Unit says SECONDS but the Value is returned in MILLISECONDS. For example, if you get a response like this:</p> <p> <code>{ "Metric": { "Name": "OLDEST_CONTACT_AGE", "Unit": "SECONDS" }, "Value": 24113.0 </code>}</p> <p>The actual OLDEST_CONTACT_AGE is 24 seconds.</p> <p>When the filter <code>RoutingStepExpression</code> is used, this metric is still calculated from enqueue time. For example, if a contact that has been queued under <code>&lt;Expression 1&gt;</code> for 10 seconds has expired and <code>&lt;Expression 2&gt;</code> becomes active, then <code>OLDEST_CONTACT_AGE</code> for this queue will be counted starting from 10, not 0.</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#oldest-real-time">Oldest</a> </p> </dd> <dt>SLOTS_ACTIVE</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#active-real-time">Active</a> </p> </dd> <dt>SLOTS_AVAILABLE</dt> <dd> <p>Unit: COUNT</p> <p>Name in real-time metrics report: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html#availability-real-time">Availability</a> </p> </dd> </dl>', ], ], 'Customer' => [ 'base' => '<p>Information about the Customer on the contact.</p>', 'refs' => [ 'Contact$Customer' => '<p>Information about the Customer on the contact.</p>', ], ], 'CustomerQualityMetrics' => [ 'base' => '<p>Information about the quality of the Customer\'s media connection</p>', 'refs' => [ 'QualityMetrics$Customer' => '<p>Information about the quality of Customer media connection.</p>', ], ], 'CustomerVoiceActivity' => [ 'base' => '<p>Information about customer’s voice activity.</p>', 'refs' => [ 'Contact$CustomerVoiceActivity' => '<p>Information about customer’s voice activity.</p>', ], ], 'DataSetId' => [ 'base' => NULL, 'refs' => [ 'AnalyticsDataAssociationResult$DataSetId' => '<p>The identifier of the dataset.</p>', 'AssociateAnalyticsDataSetRequest$DataSetId' => '<p>The identifier of the dataset to associate with the target account.</p>', 'AssociateAnalyticsDataSetResponse$DataSetId' => '<p>The identifier of the dataset that was associated.</p>', 'DataSetIds$member' => NULL, 'DisassociateAnalyticsDataSetRequest$DataSetId' => '<p>The identifier of the dataset to remove.</p>', 'ListAnalyticsDataAssociationsRequest$DataSetId' => '<p>The identifier of the dataset to get the association status.</p>', ], ], 'DataSetIds' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateAnalyticsDataSetRequest$DataSetIds' => '<p>An array of dataset identifiers to associate.</p>', 'BatchDisassociateAnalyticsDataSetRequest$DataSetIds' => '<p>An array of associated dataset identifiers to remove.</p>', 'BatchDisassociateAnalyticsDataSetResponse$Deleted' => '<p>An array of successfully disassociated dataset identifiers.</p>', ], ], 'DateReference' => [ 'base' => '<p>Information about a reference when the <code>referenceType</code> is <code>DATE</code>. Otherwise, null.</p>', 'refs' => [ 'ReferenceSummary$Date' => '<p>Information about a reference when the <code>referenceType</code> is <code>DATE</code>. Otherwise, null.</p>', ], ], 'DeactivateEvaluationFormRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeactivateEvaluationFormResponse' => [ 'base' => NULL, 'refs' => [], ], 'DefaultVocabulary' => [ 'base' => '<p>Contains information about a default vocabulary.</p>', 'refs' => [ 'DefaultVocabularyList$member' => NULL, ], ], 'DefaultVocabularyList' => [ 'base' => NULL, 'refs' => [ 'ListDefaultVocabulariesResponse$DefaultVocabularyList' => '<p>A list of default vocabularies.</p>', ], ], 'Delay' => [ 'base' => NULL, 'refs' => [ 'RoutingProfileQueueConfig$Delay' => '<p>The delay, in seconds, a contact should be in the queue before they are routed to an available agent. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and delay</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'RoutingProfileQueueConfigSummary$Delay' => '<p>The delay, in seconds, that a contact should be in the queue before they are routed to an available agent. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and delay</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', ], ], 'DeleteAttachedFileRequest' => [ 'base' => 'Request to DeleteAttachedFile API', 'refs' => [], ], 'DeleteAttachedFileResponse' => [ 'base' => 'Response from DeleteAttachedFile API', 'refs' => [], ], 'DeleteContactEvaluationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContactFlowModuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContactFlowModuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContactFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteContactFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEvaluationFormRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteHoursOfOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIntegrationAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePredefinedAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePromptRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteQuickConnectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRoutingProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTaskTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTaskTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficDistributionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTrafficDistributionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUseCaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserHierarchyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteViewRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteViewResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteViewVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteViewVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAgentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAgentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAuthenticationProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAuthenticationProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactEvaluationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactEvaluationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactFlowModuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactFlowModuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEvaluationFormRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEvaluationFormResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHoursOfOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeHoursOfOperationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceAttributeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceStorageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInstanceStorageConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePredefinedAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePredefinedAttributeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePromptRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePromptResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQueueResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQuickConnectRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeQuickConnectResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRoutingProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRoutingProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRuleResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityProfileResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficDistributionGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTrafficDistributionGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserHierarchyGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserHierarchyGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserHierarchyStructureRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserHierarchyStructureResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeViewRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeViewResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'Contact$Description' => '<p>The description of the contact.</p>', 'StartOutboundVoiceContactRequest$Description' => '<p>A description of the voice contact that is shown to an agent in the Contact Control Panel (CCP).</p>', 'StartTaskContactRequest$Description' => '<p>A description of the task that is shown to an agent in the Contact Control Panel (CCP).</p>', 'StartWebRTCContactRequest$Description' => '<p>A description of the task that is shown to an agent in the Contact Control Panel (CCP).</p>', 'UpdateContactRequest$Description' => '<p>The description of the contact.</p>', ], ], 'Description250' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficDistributionGroupRequest$Description' => '<p>A description for the traffic distribution group.</p>', 'TrafficDistributionGroup$Description' => '<p>The description of the traffic distribution group.</p>', ], ], 'DestinationId' => [ 'base' => NULL, 'refs' => [ 'SendChatIntegrationEventRequest$DestinationId' => '<p>Chat system identifier, used in part to uniquely identify chat. This is associated with the Amazon Connect instance and flow to be used to start chats. For SMS, this is the phone number destination of inbound SMS messages represented by an Amazon Pinpoint phone number ARN.</p>', ], ], 'DestinationNotAllowedException' => [ 'base' => '<p>Outbound calls to the destination number are not allowed.</p>', 'refs' => [], ], 'DeviceInfo' => [ 'base' => '<p>Information regarding the device.</p>', 'refs' => [ 'AgentInfo$DeviceInfo' => '<p>Information regarding Agent’s device.</p>', 'Customer$DeviceInfo' => '<p>Information regarding Customer’s device.</p>', ], ], 'Dimensions' => [ 'base' => '<p>Contains information about the dimensions for a set of metrics.</p>', 'refs' => [ 'CurrentMetricResult$Dimensions' => '<p>The dimensions for the metrics.</p>', 'HistoricalMetricResult$Dimensions' => '<p>The dimension for the metrics.</p>', ], ], 'DimensionsV2Key' => [ 'base' => NULL, 'refs' => [ 'DimensionsV2Map$key' => NULL, ], ], 'DimensionsV2Map' => [ 'base' => NULL, 'refs' => [ 'MetricResultV2$Dimensions' => '<p>The dimension for the metrics.</p>', ], ], 'DimensionsV2Value' => [ 'base' => NULL, 'refs' => [ 'DimensionsV2Map$value' => NULL, ], ], 'DirectoryAlias' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$InstanceAlias' => '<p>The name for your instance.</p>', 'Instance$InstanceAlias' => '<p>The alias of instance.</p>', 'InstanceSummary$InstanceAlias' => '<p>The alias of the instance.</p>', 'ReplicateInstanceRequest$ReplicaAlias' => '<p>The alias for the replicated instance. The <code>ReplicaAlias</code> must be unique.</p>', ], ], 'DirectoryId' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$DirectoryId' => '<p>The identifier for the directory.</p>', ], ], 'DirectoryType' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$IdentityManagementType' => '<p>The type of identity management for your Amazon Connect users.</p>', 'Instance$IdentityManagementType' => '<p>The identity management type.</p>', 'InstanceSummary$IdentityManagementType' => '<p>The identity management type of the instance.</p>', ], ], 'DirectoryUserId' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$DirectoryUserId' => '<p>The identifier of the user account in the directory used for identity management. If Amazon Connect cannot access the directory, you can specify this identifier to authenticate users. If you include the identifier, we assume that Amazon Connect cannot access the directory. Otherwise, the identity information is used to authenticate users from your directory.</p> <p>This parameter is required if you are using an existing directory for identity management in Amazon Connect when Amazon Connect cannot access your directory to authenticate users. If you are using SAML for identity management and include this parameter, an error is returned.</p>', 'User$DirectoryUserId' => '<p>The identifier of the user account in the directory used for identity management.</p>', 'UserSearchSummary$DirectoryUserId' => '<p>The directory identifier of the user.</p>', ], ], 'DisassociateAnalyticsDataSetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateApprovedOriginRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateFlowResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateInstanceStorageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateLambdaFunctionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateLexBotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociatePhoneNumberContactFlowRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateQueueQuickConnectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateRoutingProfileQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateSecurityKeyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTrafficDistributionGroupUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateTrafficDistributionGroupUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateUserProficienciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisconnectDetails' => [ 'base' => '<p>Information about the call disconnect experience.</p>', 'refs' => [ 'Contact$DisconnectDetails' => '<p>Information about the call disconnect experience.</p>', ], ], 'DisconnectReason' => [ 'base' => '<p>Contains details about why a contact was disconnected. Only Amazon Connect outbound campaigns can provide this field.</p>', 'refs' => [ 'StopContactRequest$DisconnectReason' => '<p>The reason a contact can be disconnected. Only Amazon Connect outbound campaigns can provide this field.</p>', ], ], 'DisconnectReasonCode' => [ 'base' => NULL, 'refs' => [ 'DisconnectReason$Code' => '<p>A code that indicates how the contact was terminated.</p>', ], ], 'DismissUserContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'DismissUserContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisplayName' => [ 'base' => NULL, 'refs' => [ 'ParticipantDetails$DisplayName' => '<p>Display name of the participant.</p>', 'ParticipantDetailsToAdd$DisplayName' => '<p>The display name of the participant.</p>', 'RealTimeContactAnalysisSegmentAttachments$DisplayName' => '<p>The display name of the participant. Can be redacted. </p>', 'RealTimeContactAnalysisSegmentEvent$DisplayName' => '<p>The display name of the participant. Can be redacted.</p>', 'RealTimeContactAnalysisSegmentTranscript$DisplayName' => '<p>The display name of the participant.</p>', ], ], 'Distribution' => [ 'base' => '<p>Information about a traffic distribution.</p>', 'refs' => [ 'DistributionList$member' => NULL, ], ], 'DistributionList' => [ 'base' => NULL, 'refs' => [ 'AgentConfig$Distributions' => '<p>Information about traffic distributions.</p>', 'TelephonyConfig$Distributions' => '<p>Information about traffic distributions.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'FieldValueUnion$DoubleValue' => '<p>A Double number value type.</p>', ], ], 'DownloadUrlMetadata' => [ 'base' => '<p>Metadata used to download the attached file.</p>', 'refs' => [ 'GetAttachedFileResponse$DownloadUrlMetadata' => '<p>URL and expiry to be used when downloading the attached file. </p>', ], ], 'DuplicateResourceException' => [ 'base' => '<p>A resource with the specified name already exists.</p>', 'refs' => [], ], 'DurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'Expiry$DurationInSeconds' => '<p>The number of seconds to wait before expiring the routing step.</p>', 'RoutingCriteriaInputStepExpiry$DurationInSeconds' => '<p>The number of seconds that the contact will be routed only to agents matching this routing&#x2028; step, if expiry was configured for this routing step.</p>', ], ], 'Email' => [ 'base' => NULL, 'refs' => [ 'UserIdentityInfo$Email' => '<p>The email address. If you are using SAML for identity management and include this parameter, an error is returned.</p>', 'UserIdentityInfo$SecondaryEmail' => '<p>The user\'s secondary email address. If you provide a secondary email, the user receives email notifications - other than password reset notifications - to this email address instead of to their primary email address.</p> <p>Pattern: <code>(?=^.{0,265}$)[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,63}</code> </p>', ], ], 'EmailReference' => [ 'base' => '<p>Information about a reference when the <code>referenceType</code> is <code>EMAIL</code>. Otherwise, null.</p>', 'refs' => [ 'ReferenceSummary$Email' => '<p>Information about a reference when the <code>referenceType</code> is <code>EMAIL</code>. Otherwise, null.</p>', ], ], 'EmptyFieldValue' => [ 'base' => '<p>An empty value.</p>', 'refs' => [ 'FieldValueUnion$EmptyValue' => '<p>An empty value.</p>', ], ], 'EncryptionConfig' => [ 'base' => '<p>The encryption configuration.</p>', 'refs' => [ 'KinesisVideoStreamConfig$EncryptionConfig' => '<p>The encryption configuration.</p>', 'S3Config$EncryptionConfig' => '<p>The Amazon S3 encryption configuration.</p>', ], ], 'EncryptionType' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfig$EncryptionType' => '<p>The type of encryption.</p>', ], ], 'EndAssociatedTasksActionDefinition' => [ 'base' => '<p>End associated tasks related to a case.</p>', 'refs' => [ 'RuleAction$EndAssociatedTasksAction' => '<p>Information about the end associated tasks action.</p> <p>Supported only for <code>TriggerEventSource</code> values: <code>OnCaseUpdate</code>.</p>', ], ], 'Endpoint' => [ 'base' => '<p>Information about the endpoint.</p>', 'refs' => [ 'ContactDataRequest$SystemEndpoint' => '<p>Endpoint associated with the Amazon Connect instance from which outbound contact will be initiated for the campaign.</p>', 'ContactDataRequest$CustomerEndpoint' => '<p>Endpoint of the customer for which contact will be initiated.</p>', ], ], 'EndpointAddress' => [ 'base' => NULL, 'refs' => [ 'Endpoint$Address' => '<p>Address of the endpoint.</p>', ], ], 'EndpointType' => [ 'base' => NULL, 'refs' => [ 'Endpoint$Type' => '<p>Type of the endpoint.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'AttachedFileError$ErrorCode' => '<p> Status code describing the failure. </p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AttachedFileError$ErrorMessage' => '<p>Why the attached file couldn\'t be retrieved. </p>', ], ], 'ErrorResult' => [ 'base' => '<p>This API is in preview release for Amazon Connect and is subject to change.</p> <p>List of errors for dataset association failures. </p>', 'refs' => [ 'ErrorResults$member' => NULL, ], ], 'ErrorResults' => [ 'base' => NULL, 'refs' => [ 'BatchAssociateAnalyticsDataSetResponse$Errors' => '<p>A list of errors for datasets that aren\'t successfully associated with the target account.</p>', 'BatchDisassociateAnalyticsDataSetResponse$Errors' => '<p>A list of errors for any datasets not successfully removed.</p>', ], ], 'Evaluation' => [ 'base' => '<p>Information about a contact evaluation.</p>', 'refs' => [ 'DescribeContactEvaluationResponse$Evaluation' => '<p>Information about the evaluation form completed for a specific contact.</p>', ], ], 'EvaluationAnswerData' => [ 'base' => '<p>Information about answer data for a contact evaluation. Answer data must be either string, numeric, or not applicable.</p>', 'refs' => [ 'EvaluationAnswerInput$Value' => '<p>The value for an answer in a contact evaluation.</p>', 'EvaluationAnswerOutput$Value' => '<p>The value for an answer in a contact evaluation.</p>', 'EvaluationAnswerOutput$SystemSuggestedValue' => '<p>The system suggested value for an answer in a contact evaluation.</p>', ], ], 'EvaluationAnswerDataNumericValue' => [ 'base' => NULL, 'refs' => [ 'EvaluationAnswerData$NumericValue' => '<p>The numeric value for an answer in a contact evaluation.</p>', ], ], 'EvaluationAnswerDataStringValue' => [ 'base' => NULL, 'refs' => [ 'EvaluationAnswerData$StringValue' => '<p>The string value for an answer in a contact evaluation.</p>', ], ], 'EvaluationAnswerInput' => [ 'base' => '<p>Information about input answers for a contact evaluation.</p>', 'refs' => [ 'EvaluationAnswersInputMap$value' => NULL, ], ], 'EvaluationAnswerOutput' => [ 'base' => '<p>Information about output answers for a contact evaluation.</p>', 'refs' => [ 'EvaluationAnswersOutputMap$value' => NULL, ], ], 'EvaluationAnswersInputMap' => [ 'base' => NULL, 'refs' => [ 'SubmitContactEvaluationRequest$Answers' => '<p>A map of question identifiers to answer value.</p>', 'UpdateContactEvaluationRequest$Answers' => '<p>A map of question identifiers to answer value.</p>', ], ], 'EvaluationAnswersOutputMap' => [ 'base' => NULL, 'refs' => [ 'Evaluation$Answers' => '<p>A map of question identifiers to answer value.</p>', ], ], 'EvaluationForm' => [ 'base' => '<p>Information about the evaluation form.</p>', 'refs' => [ 'DescribeEvaluationFormResponse$EvaluationForm' => '<p>Information about the evaluation form.</p>', ], ], 'EvaluationFormContent' => [ 'base' => '<p>Information about an evaluation form used in a contact evaluation.</p>', 'refs' => [ 'DescribeContactEvaluationResponse$EvaluationForm' => '<p>Information about the evaluation form.</p>', ], ], 'EvaluationFormDescription' => [ 'base' => NULL, 'refs' => [ 'CreateEvaluationFormRequest$Description' => '<p>The description of the evaluation form.</p>', 'EvaluationForm$Description' => '<p>The description of the evaluation form.</p>', 'EvaluationFormContent$Description' => '<p>The description of the evaluation form.</p>', 'UpdateEvaluationFormRequest$Description' => '<p>The description of the evaluation form.</p>', ], ], 'EvaluationFormId' => [ 'base' => NULL, 'refs' => [ 'SubmitAutoEvaluationActionDefinition$EvaluationFormId' => '<p>The identifier of the auto-evaluation enabled form.</p>', ], ], 'EvaluationFormItem' => [ 'base' => '<p>Information about an item from an evaluation form. The item must be either a section or a question.</p>', 'refs' => [ 'EvaluationFormItemsList$member' => NULL, ], ], 'EvaluationFormItemWeight' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormQuestion$Weight' => '<p>The scoring weight of the section.</p>', 'EvaluationFormSection$Weight' => '<p>The scoring weight of the section.</p>', ], ], 'EvaluationFormItemsList' => [ 'base' => NULL, 'refs' => [ 'CreateEvaluationFormRequest$Items' => '<p>Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.</p>', 'EvaluationForm$Items' => '<p>Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.</p>', 'EvaluationFormContent$Items' => '<p>Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.</p>', 'EvaluationFormSection$Items' => '<p>The items of the section.</p>', 'UpdateEvaluationFormRequest$Items' => '<p>Items that are part of the evaluation form. The total number of sections and questions must not exceed 100 each. Questions must be contained in a section.</p>', ], ], 'EvaluationFormNumericQuestionAutomation' => [ 'base' => '<p>Information about the automation configuration in numeric questions.</p>', 'refs' => [ 'EvaluationFormNumericQuestionProperties$Automation' => '<p>The automation properties of the numeric question.</p>', ], ], 'EvaluationFormNumericQuestionOption' => [ 'base' => '<p>Information about the option range used for scoring in numeric questions.</p>', 'refs' => [ 'EvaluationFormNumericQuestionOptionList$member' => NULL, ], ], 'EvaluationFormNumericQuestionOptionList' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormNumericQuestionProperties$Options' => '<p>The scoring options of the numeric question.</p>', ], ], 'EvaluationFormNumericQuestionProperties' => [ 'base' => '<p>Information about properties for a numeric question in an evaluation form.</p>', 'refs' => [ 'EvaluationFormQuestionTypeProperties$Numeric' => '<p>The properties of the numeric question.</p>', ], ], 'EvaluationFormQuestion' => [ 'base' => '<p>Information about a question from an evaluation form.</p>', 'refs' => [ 'EvaluationFormItem$Question' => '<p>The information of the question.</p>', ], ], 'EvaluationFormQuestionAnswerScore' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormNumericQuestionOption$Score' => '<p>The score assigned to answer values within the range option.</p>', 'EvaluationFormSingleSelectQuestionOption$Score' => '<p>The score assigned to the answer option.</p>', ], ], 'EvaluationFormQuestionInstructions' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormQuestion$Instructions' => '<p>The instructions of the section.</p>', 'EvaluationFormSection$Instructions' => '<p>The instructions of the section.</p>', ], ], 'EvaluationFormQuestionTitle' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormQuestion$Title' => '<p>The title of the question.</p>', ], ], 'EvaluationFormQuestionType' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormQuestion$QuestionType' => '<p>The type of the question.</p>', ], ], 'EvaluationFormQuestionTypeProperties' => [ 'base' => '<p>Information about properties for a question in an evaluation form. The question type properties must be either for a numeric question or a single select question.</p>', 'refs' => [ 'EvaluationFormQuestion$QuestionTypeProperties' => '<p>The properties of the type of question. Text questions do not have to define question type properties.</p>', ], ], 'EvaluationFormScoringMode' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormScoringStrategy$Mode' => '<p>The scoring mode of the evaluation form.</p>', ], ], 'EvaluationFormScoringStatus' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormScoringStrategy$Status' => '<p>The scoring status of the evaluation form.</p>', ], ], 'EvaluationFormScoringStrategy' => [ 'base' => '<p>Information about scoring strategy for an evaluation form.</p>', 'refs' => [ 'CreateEvaluationFormRequest$ScoringStrategy' => '<p>A scoring strategy of the evaluation form.</p>', 'EvaluationForm$ScoringStrategy' => '<p>A scoring strategy of the evaluation form.</p>', 'EvaluationFormContent$ScoringStrategy' => '<p>A scoring strategy of the evaluation form.</p>', 'UpdateEvaluationFormRequest$ScoringStrategy' => '<p>A scoring strategy of the evaluation form.</p>', ], ], 'EvaluationFormSection' => [ 'base' => '<p>Information about a section from an evaluation form. A section can contain sections and/or questions. Evaluation forms can only contain sections and subsections (two level nesting).</p>', 'refs' => [ 'EvaluationFormItem$Section' => '<p>The information of the section.</p>', ], ], 'EvaluationFormSectionTitle' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormSection$Title' => '<p>The title of the section.</p>', ], ], 'EvaluationFormSingleSelectQuestionAutomation' => [ 'base' => '<p>Information about the automation configuration in single select questions. Automation options are evaluated in order, and the first matched option is applied. If no automation option matches, and there is a default option, then the default option is applied.</p>', 'refs' => [ 'EvaluationFormSingleSelectQuestionProperties$Automation' => '<p>The display mode of the single select question.</p>', ], ], 'EvaluationFormSingleSelectQuestionAutomationOption' => [ 'base' => '<p>Information about the automation option of a single select question.</p>', 'refs' => [ 'EvaluationFormSingleSelectQuestionAutomationOptionList$member' => NULL, ], ], 'EvaluationFormSingleSelectQuestionAutomationOptionList' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormSingleSelectQuestionAutomation$Options' => '<p>The automation options of the single select question.</p>', ], ], 'EvaluationFormSingleSelectQuestionDisplayMode' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormSingleSelectQuestionProperties$DisplayAs' => '<p>The display mode of the single select question.</p>', ], ], 'EvaluationFormSingleSelectQuestionOption' => [ 'base' => '<p>Information about the automation configuration in single select questions.</p>', 'refs' => [ 'EvaluationFormSingleSelectQuestionOptionList$member' => NULL, ], ], 'EvaluationFormSingleSelectQuestionOptionList' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormSingleSelectQuestionProperties$Options' => '<p>The answer options of the single select question.</p>', ], ], 'EvaluationFormSingleSelectQuestionOptionText' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormSingleSelectQuestionOption$Text' => '<p>The title of the answer option.</p>', ], ], 'EvaluationFormSingleSelectQuestionProperties' => [ 'base' => '<p>Information about the options in single select questions.</p>', 'refs' => [ 'EvaluationFormQuestionTypeProperties$SingleSelect' => '<p>The properties of the numeric question.</p>', ], ], 'EvaluationFormSummary' => [ 'base' => '<p>Summary information about an evaluation form.</p>', 'refs' => [ 'EvaluationFormSummaryList$member' => NULL, ], ], 'EvaluationFormSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEvaluationFormsResponse$EvaluationFormSummaryList' => '<p>Provides details about a list of evaluation forms belonging to an instance.</p>', ], ], 'EvaluationFormTitle' => [ 'base' => NULL, 'refs' => [ 'CreateEvaluationFormRequest$Title' => '<p>A title of the evaluation form.</p>', 'EvaluationForm$Title' => '<p>A title of the evaluation form.</p>', 'EvaluationFormContent$Title' => '<p>A title of the evaluation form.</p>', 'EvaluationFormSummary$Title' => '<p>A title of the evaluation form.</p>', 'EvaluationSummary$EvaluationFormTitle' => '<p>A title of the evaluation form.</p>', 'UpdateEvaluationFormRequest$Title' => '<p>A title of the evaluation form.</p>', ], ], 'EvaluationFormVersionIsLocked' => [ 'base' => NULL, 'refs' => [ 'EvaluationForm$Locked' => '<p>The flag indicating whether the evaluation form is locked for changes.</p>', 'EvaluationFormVersionSummary$Locked' => '<p>The flag indicating whether the evaluation form is locked for changes.</p>', ], ], 'EvaluationFormVersionStatus' => [ 'base' => NULL, 'refs' => [ 'EvaluationForm$Status' => '<p>The status of the evaluation form.</p>', 'EvaluationFormVersionSummary$Status' => '<p>The status of the evaluation form.</p>', ], ], 'EvaluationFormVersionSummary' => [ 'base' => '<p>Summary information about an evaluation form.</p>', 'refs' => [ 'EvaluationFormVersionSummaryList$member' => NULL, ], ], 'EvaluationFormVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListEvaluationFormVersionsResponse$EvaluationFormVersionSummaryList' => '<p>Provides details about a list of evaluation forms belonging to an instance.</p>', ], ], 'EvaluationMetadata' => [ 'base' => '<p>Metadata information about a contact evaluation.</p>', 'refs' => [ 'Evaluation$Metadata' => '<p>Metadata about the contact evaluation.</p>', ], ], 'EvaluationNote' => [ 'base' => '<p>Information about notes for a contact evaluation.</p>', 'refs' => [ 'EvaluationNotesMap$value' => NULL, ], ], 'EvaluationNoteString' => [ 'base' => NULL, 'refs' => [ 'EvaluationNote$Value' => '<p>The note for an item (section or question) in a contact evaluation.</p> <note> <p>Even though a note in an evaluation can have up to 3072 chars, there is also a limit on the total number of chars for all the notes in the evaluation combined. Assuming there are N questions in the evaluation being submitted, then the max char limit for all notes combined is N x 1024.</p> </note>', ], ], 'EvaluationNotesMap' => [ 'base' => NULL, 'refs' => [ 'Evaluation$Notes' => '<p>A map of question identifiers to note value.</p>', 'SubmitContactEvaluationRequest$Notes' => '<p>A map of question identifiers to note value.</p>', 'UpdateContactEvaluationRequest$Notes' => '<p>A map of question identifiers to note value.</p>', ], ], 'EvaluationScore' => [ 'base' => '<p>Information about scores of a contact evaluation item (section or question).</p>', 'refs' => [ 'EvaluationMetadata$Score' => '<p>The overall score of the contact evaluation.</p>', 'EvaluationScoresMap$value' => NULL, 'EvaluationSummary$Score' => '<p>The overall score of the contact evaluation.</p>', ], ], 'EvaluationScorePercentage' => [ 'base' => NULL, 'refs' => [ 'EvaluationScore$Percentage' => '<p>The score percentage for an item in a contact evaluation.</p>', ], ], 'EvaluationScoresMap' => [ 'base' => NULL, 'refs' => [ 'Evaluation$Scores' => '<p>A map of item (section or question) identifiers to score value.</p>', ], ], 'EvaluationStatus' => [ 'base' => NULL, 'refs' => [ 'Evaluation$Status' => '<p>The status of the contact evaluation.</p>', 'EvaluationSummary$Status' => '<p>The status of the contact evaluation.</p>', ], ], 'EvaluationSummary' => [ 'base' => '<p>Summary information about a contact evaluation.</p>', 'refs' => [ 'EvaluationSummaryList$member' => NULL, ], ], 'EvaluationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListContactEvaluationsResponse$EvaluationSummaryList' => '<p>Provides details about a list of contact evaluations belonging to an instance.</p>', ], ], 'EventBridgeActionDefinition' => [ 'base' => '<p>The EventBridge action definition.</p>', 'refs' => [ 'RuleAction$EventBridgeAction' => '<p>Information about the EventBridge action.</p> <p>Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> | <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> | <code>OnPostChatAnalysisAvailable</code> | <code>OnContactEvaluationSubmit</code> | <code>OnMetricDataUpdate</code> </p>', ], ], 'EventBridgeActionName' => [ 'base' => NULL, 'refs' => [ 'EventBridgeActionDefinition$Name' => '<p>The name.</p>', ], ], 'EventSourceName' => [ 'base' => NULL, 'refs' => [ 'ListRulesRequest$EventSourceName' => '<p>The name of the event source.</p>', 'RuleSummary$EventSourceName' => '<p>The name of the event source.</p>', 'RuleTriggerEventSource$EventSourceName' => '<p>The name of the event source.</p>', ], ], 'Expiry' => [ 'base' => '<p>An object to specify the expiration of a routing step.</p>', 'refs' => [ 'Step$Expiry' => '<p>An object to specify the expiration of a routing step.</p>', ], ], 'Expression' => [ 'base' => '<p>A tagged union to specify expression for a routing step.</p>', 'refs' => [ 'Expressions$member' => NULL, 'RoutingCriteriaInputStep$Expression' => '<p>A tagged union to specify expression for a routing step.</p>', 'Step$Expression' => '<p>A tagged union to specify expression for a routing step.</p>', ], ], 'Expressions' => [ 'base' => NULL, 'refs' => [ 'Expression$AndExpression' => '<p>List of routing expressions which will be AND-ed together.</p>', 'Expression$OrExpression' => '<p>List of routing expressions which will be OR-ed together.</p>', ], ], 'FailedRequest' => [ 'base' => '<p>Request for which contact failed to be generated.</p>', 'refs' => [ 'FailedRequestList$member' => NULL, ], ], 'FailedRequestList' => [ 'base' => NULL, 'refs' => [ 'BatchPutContactResponse$FailedRequestList' => '<p>List of requests for which contact creation failed.</p>', ], ], 'FailureReasonCode' => [ 'base' => NULL, 'refs' => [ 'FailedRequest$FailureReasonCode' => '<p>Reason code for the failure.</p>', ], ], 'FieldStringValue' => [ 'base' => NULL, 'refs' => [ 'FieldValueUnion$StringValue' => '<p>String value type.</p>', ], ], 'FieldValue' => [ 'base' => '<p>Object for case field values.</p>', 'refs' => [ 'FieldValues$member' => NULL, ], ], 'FieldValueId' => [ 'base' => NULL, 'refs' => [ 'FieldValue$Id' => '<p>Unique identifier of a field.</p>', ], ], 'FieldValueUnion' => [ 'base' => '<p>Object to store union of Field values.</p>', 'refs' => [ 'FieldValue$Value' => '<p>Union of potential field value types.</p>', ], ], 'FieldValues' => [ 'base' => NULL, 'refs' => [ 'CreateCaseActionDefinition$Fields' => '<p>An array of objects with <code>Field ID</code> and <code>Value</code> data.</p>', 'UpdateCaseActionDefinition$Fields' => '<p>An array of objects with <code>Field ID</code> and Value data.</p>', ], ], 'FileId' => [ 'base' => NULL, 'refs' => [ 'AttachedFile$FileId' => '<p>The unique identifier of the attached file resource.</p>', 'AttachedFileError$FileId' => '<p>The unique identifier of the attached file resource.</p>', 'CompleteAttachedFileUploadRequest$FileId' => '<p>The unique identifier of the attached file resource.</p>', 'DeleteAttachedFileRequest$FileId' => '<p>The unique identifier of the attached file resource.</p>', 'FileIdList$member' => NULL, 'GetAttachedFileRequest$FileId' => '<p>The unique identifier of the attached file resource.</p>', 'GetAttachedFileResponse$FileId' => '<p>The unique identifier of the attached file resource.</p>', 'StartAttachedFileUploadResponse$FileId' => '<p>The unique identifier of the attached file resource.</p>', ], ], 'FileIdList' => [ 'base' => NULL, 'refs' => [ 'BatchGetAttachedFileMetadataRequest$FileIds' => '<p>The unique identifiers of the attached file resource.</p>', ], ], 'FileName' => [ 'base' => NULL, 'refs' => [ 'AttachedFile$FileName' => '<p>A case-sensitive name of the attached file being uploaded.</p>', 'GetAttachedFileResponse$FileName' => '<p>A case-sensitive name of the attached file being uploaded.</p>', 'StartAttachedFileUploadRequest$FileName' => '<p>A case-sensitive name of the attached file being uploaded.</p>', ], ], 'FileSizeInBytes' => [ 'base' => NULL, 'refs' => [ 'AttachedFile$FileSizeInBytes' => '<p>The size of the attached file in bytes.</p>', 'GetAttachedFileResponse$FileSizeInBytes' => '<p>The size of the attached file in bytes.</p>', 'StartAttachedFileUploadRequest$FileSizeInBytes' => '<p>The size of the attached file in bytes.</p>', ], ], 'FileStatusType' => [ 'base' => NULL, 'refs' => [ 'AttachedFile$FileStatus' => '<p>The current status of the attached file.</p>', 'GetAttachedFileResponse$FileStatus' => '<p>The current status of the attached file.</p>', 'StartAttachedFileUploadResponse$FileStatus' => '<p>The current status of the attached file.</p>', ], ], 'FileUseCaseType' => [ 'base' => NULL, 'refs' => [ 'AttachedFile$FileUseCaseType' => '<p>The use case for the file.</p>', 'GetAttachedFileResponse$FileUseCaseType' => '<p>The use case for the file.</p>', 'StartAttachedFileUploadRequest$FileUseCaseType' => '<p>The use case for the file.</p>', ], ], 'FilterV2' => [ 'base' => '<p>Contains the filter to apply when retrieving metrics with the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricDataV2.html">GetMetricDataV2</a> API.</p>', 'refs' => [ 'FiltersV2List$member' => NULL, ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'FilterV2$FilterValues' => '<p>The identifiers to use for filtering data. For example, if you have a filter key of <code>QUEUE</code>, you would add queue IDs or ARNs in <code>FilterValues</code>. </p>', ], ], 'Filters' => [ 'base' => '<p>Contains the filter to apply when retrieving metrics.</p>', 'refs' => [ 'GetCurrentMetricDataRequest$Filters' => '<p>The filters to apply to returned metrics. You can filter up to the following limits:</p> <ul> <li> <p>Queues: 100</p> </li> <li> <p>Routing profiles: 100</p> </li> <li> <p>Channels: 3 (VOICE, CHAT, and TASK channels are supported.)</p> </li> <li> <p>RoutingStepExpressions: 50</p> </li> </ul> <p>Metric data is retrieved only for the resources associated with the queues or routing profiles, and by any channels included in the filter. (You cannot filter by both queue AND routing profile.) You can include both resource IDs and resource ARNs in the same request.</p> <p>When using the <code>RoutingStepExpression</code> filter, you need to pass exactly one <code>QueueId</code>. The filter is also case sensitive so when using the <code>RoutingStepExpression</code> filter, grouping by <code>ROUTING_STEP_EXPRESSION</code> is required.</p> <p>Currently tagging is only supported on the resources that are passed in the filter.</p>', 'GetMetricDataRequest$Filters' => '<p>The queues, up to 100, or channels, to use to filter the metrics returned. Metric data is retrieved only for the resources associated with the queues or channels included in the filter. You can include both queue IDs and queue ARNs in the same request. VOICE, CHAT, and TASK channels are supported.</p> <p>RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2 for more up-to-date features.</p> <note> <p>To filter by <code>Queues</code>, enter the queue ID/ARN, not the name of the queue.</p> </note>', ], ], 'FiltersV2List' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataV2Request$Filters' => '<p>The filters to apply to returned metrics. You can filter on the following resources:</p> <ul> <li> <p>Agents</p> </li> <li> <p>Campaigns</p> </li> <li> <p>Channels</p> </li> <li> <p>Feature</p> </li> <li> <p>Queues</p> </li> <li> <p>Routing profiles</p> </li> <li> <p>Routing step expression</p> </li> <li> <p>User hierarchy groups</p> </li> </ul> <p>At least one filter must be passed from queues, routing profiles, agents, or user hierarchy groups.</p> <p>For metrics for outbound campaigns analytics, you can also use campaigns to satisfy at least one filter requirement.</p> <p>To filter by phone number, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/create-historical-metrics-report.html">Create a historical metrics report</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <p>Note the following limits:</p> <ul> <li> <p> <b>Filter keys</b>: A maximum of 5 filter keys are supported in a single request. Valid filter keys: <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> | <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> | <code>AGENT_HIERARCHY_LEVEL_FIVE</code> | <code>ANSWERING_MACHINE_DETECTION_STATUS</code> | <code>CAMPAIGN</code> | <code>CASE_TEMPLATE_ARN</code> | <code>CASE_STATUS</code> | <code>CHANNEL</code> | <code>contact/segmentAttributes/connect:Subtype</code> | <code>DISCONNECT_REASON</code> | <code>FEATURE</code> | <code>FLOW_TYPE</code> | <code>FLOWS_NEXT_RESOURCE_ID</code> | <code>FLOWS_NEXT_RESOURCE_QUEUE_ID</code> | <code>FLOWS_OUTCOME_TYPE</code> | <code>FLOWS_RESOURCE_ID</code> | <code>INITIATION_METHOD</code> | <code>RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>ROUTING_PROFILE</code> | <code>ROUTING_STEP_EXPRESSION</code> | <code>QUEUE</code> | <code>Q_CONNECT_ENABLED</code> | </p> </li> <li> <p> <b>Filter values</b>: A maximum of 100 filter values are supported in a single request. VOICE, CHAT, and TASK are valid <code>filterValue</code> for the CHANNEL filter key. They do not count towards limitation of 100 filter values. For example, a GetMetricDataV2 request can filter by 50 queues, 35 agents, and 15 routing profiles for a total of 100 filter values, along with 3 channel filters. </p> <p> <code>contact_lens_conversational_analytics</code> is a valid filterValue for the <code>FEATURE</code> filter key. It is available only to contacts analyzed by Contact Lens conversational analytics.</p> <p> <code>connect:Chat</code>, <code>connect:SMS</code>, <code>connect:Telephony</code>, and <code>connect:WebRTC</code> are valid <code>filterValue</code> examples (not exhaustive) for the <code>contact/segmentAttributes/connect:Subtype filter</code> key.</p> <p> <code>ROUTING_STEP_EXPRESSION</code> is a valid filter key with a filter value up to 3000 length. This filter is case and order sensitive. JSON string fields must be sorted in ascending order and JSON array order should be kept as is.</p> <p> <code>Q_CONNECT_ENABLED</code>. TRUE and FALSE are the only valid filterValues for the <code>Q_CONNECT_ENABLED</code> filter key. </p> <ul> <li> <p>TRUE includes all contacts that had Amazon Q in Connect enabled as part of the flow.</p> </li> <li> <p>FALSE includes all contacts that did not have Amazon Q in Connect enabled as part of the flow</p> </li> </ul> <p>This filter is available only for contact record-driven metrics. </p> <p> <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-outbound-campaigns_Campaign.html">Campaign</a> ARNs are valid <code>filterValues</code> for the <code>CAMPAIGN</code> filter key.</p> </li> </ul>', ], ], 'FlowAssociationResourceType' => [ 'base' => NULL, 'refs' => [ 'AssociateFlowRequest$ResourceType' => '<p>A valid resource type.</p>', 'DisassociateFlowRequest$ResourceType' => '<p>A valid resource type.</p>', 'GetFlowAssociationRequest$ResourceType' => '<p>A valid resource type.</p>', 'GetFlowAssociationResponse$ResourceType' => '<p>A valid resource type.</p>', ], ], 'FlowAssociationSummary' => [ 'base' => '<p>Information about flow associations.</p>', 'refs' => [ 'FlowAssociationSummaryList$member' => NULL, ], ], 'FlowAssociationSummaryList' => [ 'base' => NULL, 'refs' => [ 'BatchGetFlowAssociationResponse$FlowAssociationSummaryList' => '<p>Information about flow associations.</p>', 'ListFlowAssociationsResponse$FlowAssociationSummaryList' => '<p>Summary of flow associations.</p>', ], ], 'FunctionArn' => [ 'base' => NULL, 'refs' => [ 'AssociateLambdaFunctionRequest$FunctionArn' => '<p>The Amazon Resource Name (ARN) for the Lambda function being associated. Maximum number of characters allowed is 140.</p>', 'DisassociateLambdaFunctionRequest$FunctionArn' => '<p>The Amazon Resource Name (ARN) of the Lambda function being disassociated.</p>', 'FunctionArnsList$member' => NULL, ], ], 'FunctionArnsList' => [ 'base' => NULL, 'refs' => [ 'ListLambdaFunctionsResponse$LambdaFunctions' => '<p>The Lambdafunction ARNs associated with the specified instance.</p>', ], ], 'GetAttachedFileRequest' => [ 'base' => 'Request to GetAttachedFile API.', 'refs' => [], ], 'GetAttachedFileResponse' => [ 'base' => 'Response from GetAttachedFile API.', 'refs' => [], ], 'GetContactAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetContactAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCurrentMetricDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCurrentMetricDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCurrentUserDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCurrentUserDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFederationTokenRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFederationTokenResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetFlowAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetFlowAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricDataV2Request' => [ 'base' => NULL, 'refs' => [], ], 'GetMetricDataV2Response' => [ 'base' => NULL, 'refs' => [], ], 'GetPromptFileRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPromptFileResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTaskTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTaskTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTrafficDistributionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTrafficDistributionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Grouping' => [ 'base' => NULL, 'refs' => [ 'Groupings$member' => NULL, ], ], 'GroupingV2' => [ 'base' => NULL, 'refs' => [ 'GroupingsV2$member' => NULL, ], ], 'Groupings' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$Groupings' => '<p>The grouping applied to the metrics returned. For example, when grouped by <code>QUEUE</code>, the metrics returned apply to each queue rather than aggregated for all queues. </p> <ul> <li> <p>If you group by <code>CHANNEL</code>, you should include a Channels filter. VOICE, CHAT, and TASK channels are supported.</p> </li> <li> <p>If you group by <code>ROUTING_PROFILE</code>, you must include either a queue or routing profile filter. In addition, a routing profile filter is required for metrics <code>CONTACTS_SCHEDULED</code>, <code>CONTACTS_IN_QUEUE</code>, and <code> OLDEST_CONTACT_AGE</code>.</p> </li> <li> <p>If no <code>Grouping</code> is included in the request, a summary of metrics is returned.</p> </li> <li> <p>When using the <code>RoutingStepExpression</code> filter, group by <code>ROUTING_STEP_EXPRESSION</code> is required.</p> </li> </ul>', 'GetMetricDataRequest$Groupings' => '<p>The grouping applied to the metrics returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values returned apply to the metrics for each queue rather than aggregated for all queues.</p> <p>If no grouping is specified, a summary of metrics for all queues is returned.</p> <p>RoutingStepExpression is not a valid filter for GetMetricData and we recommend switching to GetMetricDataV2 for more up-to-date features.</p>', ], ], 'GroupingsV2' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataV2Request$Groupings' => '<p>The grouping applied to the metrics that are returned. For example, when results are grouped by queue, the metrics returned are grouped by queue. The values that are returned apply to the metrics for each queue. They are not aggregated for all queues.</p> <p>If no grouping is specified, a summary of all metrics is returned.</p> <p>Valid grouping keys: <code>AGENT</code> | <code>AGENT_HIERARCHY_LEVEL_ONE</code> | <code>AGENT_HIERARCHY_LEVEL_TWO</code> | <code>AGENT_HIERARCHY_LEVEL_THREE</code> | <code>AGENT_HIERARCHY_LEVEL_FOUR</code> | <code>AGENT_HIERARCHY_LEVEL_FIVE</code> | <code>ANSWERING_MACHINE_DETECTION_STATUS</code> | <code>CAMPAIGN</code> | <code>CASE_TEMPLATE_ARN</code> | <code>CASE_STATUS</code> | <code>CHANNEL</code> | <code>contact/segmentAttributes/connect:Subtype</code> | <code>DISCONNECT_REASON</code> | <code>FLOWS_RESOURCE_ID</code> | <code>FLOWS_MODULE_RESOURCE_ID</code> | <code>FLOW_TYPE</code> | <code>FLOWS_OUTCOME_TYPE</code> | <code>INITIATION_METHOD</code> | <code>Q_CONNECT_ENABLED</code> | <code>QUEUE</code> | <code>RESOURCE_PUBLISHED_TIMESTAMP</code> | <code>ROUTING_PROFILE</code> | <code>ROUTING_STEP_EXPRESSION</code> </p>', ], ], 'HierarchyGroup' => [ 'base' => '<p>Contains information about a hierarchy group.</p>', 'refs' => [ 'DescribeUserHierarchyGroupResponse$HierarchyGroup' => '<p>Information about the hierarchy group.</p>', 'UserHierarchyGroupList$member' => NULL, ], ], 'HierarchyGroupCondition' => [ 'base' => '<p>A leaf node condition which can be used to specify a hierarchy group condition.</p>', 'refs' => [ 'AttributeAndCondition$HierarchyGroupCondition' => NULL, 'ControlPlaneUserAttributeFilter$HierarchyGroupCondition' => NULL, 'UserSearchCriteria$HierarchyGroupCondition' => '<p>A leaf node condition which can be used to specify a hierarchy group condition.</p>', ], ], 'HierarchyGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$AllowedAccessControlHierarchyGroupId' => '<p>The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.</p>', 'CreateUserHierarchyGroupRequest$ParentGroupId' => '<p>The identifier for the parent hierarchy group. The user hierarchy is created at level one if the parent group ID is null.</p>', 'CreateUserHierarchyGroupResponse$HierarchyGroupId' => '<p>The identifier of the hierarchy group.</p>', 'CreateUserRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group for the user.</p>', 'DeleteUserHierarchyGroupRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group.</p>', 'DescribeUserHierarchyGroupRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group.</p>', 'HierarchyGroup$Id' => '<p>The identifier of the hierarchy group.</p>', 'HierarchyGroupIdList$member' => NULL, 'HierarchyGroupSummary$Id' => '<p>The identifier of the hierarchy group.</p>', 'HierarchyGroupSummaryReference$Id' => '<p>The unique identifier for the hierarchy group.</p>', 'SecurityProfile$AllowedAccessControlHierarchyGroupId' => '<p>The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.</p>', 'UpdateSecurityProfileRequest$AllowedAccessControlHierarchyGroupId' => '<p>The identifier of the hierarchy group that a security profile uses to restrict access to resources in Amazon Connect.</p>', 'UpdateUserHierarchyGroupNameRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group.</p>', 'UpdateUserHierarchyRequest$HierarchyGroupId' => '<p>The identifier of the hierarchy group.</p>', 'User$HierarchyGroupId' => '<p>The identifier of the hierarchy group for the user.</p>', 'UserDataHierarchyGroups$member' => NULL, 'UserSearchSummary$HierarchyGroupId' => '<p>The identifier of the user\'s hierarchy group.</p>', ], ], 'HierarchyGroupIdList' => [ 'base' => NULL, 'refs' => [ 'AgentHierarchyGroups$L1Ids' => '<p>The identifiers for level 1 hierarchy groups.</p>', 'AgentHierarchyGroups$L2Ids' => '<p>The identifiers for level 2 hierarchy groups.</p>', 'AgentHierarchyGroups$L3Ids' => '<p>The identifiers for level 3 hierarchy groups.</p>', 'AgentHierarchyGroups$L4Ids' => '<p>The identifiers for level 4 hierarchy groups.</p>', 'AgentHierarchyGroups$L5Ids' => '<p>The identifiers for level 5 hierarchy groups.</p>', ], ], 'HierarchyGroupMatchType' => [ 'base' => NULL, 'refs' => [ 'HierarchyGroupCondition$HierarchyGroupMatchType' => '<p>The type of hierarchy group match.</p>', ], ], 'HierarchyGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateUserHierarchyGroupRequest$Name' => '<p>The name of the user hierarchy group. Must not be more than 100 characters.</p>', 'HierarchyGroup$Name' => '<p>The name of the hierarchy group.</p>', 'HierarchyGroupSummary$Name' => '<p>The name of the hierarchy group.</p>', 'UpdateUserHierarchyGroupNameRequest$Name' => '<p>The name of the hierarchy group. Must not be more than 100 characters.</p>', ], ], 'HierarchyGroupSummary' => [ 'base' => '<p>Contains summary information about a hierarchy group.</p>', 'refs' => [ 'HierarchyGroupSummaryList$member' => NULL, 'HierarchyPath$LevelOne' => '<p>Information about level one.</p>', 'HierarchyPath$LevelTwo' => '<p>Information about level two.</p>', 'HierarchyPath$LevelThree' => '<p>Information about level three.</p>', 'HierarchyPath$LevelFour' => '<p>Information about level four.</p>', 'HierarchyPath$LevelFive' => '<p>Information about level five.</p>', ], ], 'HierarchyGroupSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListUserHierarchyGroupsResponse$UserHierarchyGroupSummaryList' => '<p>Information about the hierarchy groups.</p>', ], ], 'HierarchyGroupSummaryReference' => [ 'base' => '<p>Information about the hierarchy group.</p>', 'refs' => [ 'HierarchyPathReference$LevelOne' => '<p>Information about level one.</p>', 'HierarchyPathReference$LevelTwo' => '<p>Information about level two.</p>', 'HierarchyPathReference$LevelThree' => '<p>Information about level three.</p>', 'HierarchyPathReference$LevelFour' => '<p>Information about level four.</p>', 'HierarchyPathReference$LevelFive' => '<p>Information about level five.</p>', ], ], 'HierarchyGroups' => [ 'base' => '<p>Information about the agent hierarchy. Hierarchies can be configured with up to five levels.</p>', 'refs' => [ 'AgentInfo$HierarchyGroups' => '<p>The agent hierarchy groups for the agent.</p>', ], ], 'HierarchyLevel' => [ 'base' => '<p>Contains information about a hierarchy level.</p>', 'refs' => [ 'HierarchyStructure$LevelOne' => '<p>Information about level one.</p>', 'HierarchyStructure$LevelTwo' => '<p>Information about level two.</p>', 'HierarchyStructure$LevelThree' => '<p>Information about level three.</p>', 'HierarchyStructure$LevelFour' => '<p>Information about level four.</p>', 'HierarchyStructure$LevelFive' => '<p>Information about level five.</p>', ], ], 'HierarchyLevelId' => [ 'base' => NULL, 'refs' => [ 'HierarchyGroup$LevelId' => '<p>The identifier of the level in the hierarchy group.</p>', 'HierarchyLevel$Id' => '<p>The identifier of the hierarchy level.</p>', ], ], 'HierarchyLevelName' => [ 'base' => NULL, 'refs' => [ 'HierarchyLevel$Name' => '<p>The name of the hierarchy level.</p>', 'HierarchyLevelUpdate$Name' => '<p>The name of the user hierarchy level. Must not be more than 50 characters.</p>', ], ], 'HierarchyLevelUpdate' => [ 'base' => '<p>Contains information about the hierarchy level to update.</p>', 'refs' => [ 'HierarchyStructureUpdate$LevelOne' => '<p>The update for level one.</p>', 'HierarchyStructureUpdate$LevelTwo' => '<p>The update for level two.</p>', 'HierarchyStructureUpdate$LevelThree' => '<p>The update for level three.</p>', 'HierarchyStructureUpdate$LevelFour' => '<p>The update for level four.</p>', 'HierarchyStructureUpdate$LevelFive' => '<p>The update for level five.</p>', ], ], 'HierarchyPath' => [ 'base' => '<p>Contains information about the levels of a hierarchy group.</p>', 'refs' => [ 'HierarchyGroup$HierarchyPath' => '<p>Information about the levels in the hierarchy group.</p>', ], ], 'HierarchyPathReference' => [ 'base' => '<p>Information about the levels in the hierarchy group.</p>', 'refs' => [ 'UserData$HierarchyPath' => '<p>Contains information about the levels of a hierarchy group assigned to a user.</p>', ], ], 'HierarchyRestrictedResourceList' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$HierarchyRestrictedResources' => '<p>The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following are acceptable ResourceNames: <code>User</code>.</p>', 'SecurityProfile$HierarchyRestrictedResources' => '<p>The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following are acceptable ResourceNames: <code>User</code>.</p>', 'UpdateSecurityProfileRequest$HierarchyRestrictedResources' => '<p>The list of resources that a security profile applies hierarchy restrictions to in Amazon Connect. Following are acceptable ResourceNames: <code>User</code>.</p>', ], ], 'HierarchyRestrictedResourceName' => [ 'base' => NULL, 'refs' => [ 'HierarchyRestrictedResourceList$member' => NULL, ], ], 'HierarchyStructure' => [ 'base' => '<p>Contains information about a hierarchy structure.</p>', 'refs' => [ 'DescribeUserHierarchyStructureResponse$HierarchyStructure' => '<p>Information about the hierarchy structure.</p>', ], ], 'HierarchyStructureUpdate' => [ 'base' => '<p>Contains information about the level hierarchy to update.</p>', 'refs' => [ 'UpdateUserHierarchyStructureRequest$HierarchyStructure' => '<p>The hierarchy levels to update.</p>', ], ], 'HistoricalMetric' => [ 'base' => '<p>Contains information about a historical metric. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'refs' => [ 'HistoricalMetricData$Metric' => '<p>Information about the metric.</p>', 'HistoricalMetrics$member' => NULL, ], ], 'HistoricalMetricData' => [ 'base' => '<p>Contains the data for a historical metric.</p>', 'refs' => [ 'HistoricalMetricDataCollections$member' => NULL, ], ], 'HistoricalMetricDataCollections' => [ 'base' => NULL, 'refs' => [ 'HistoricalMetricResult$Collections' => '<p>The set of metrics.</p>', ], ], 'HistoricalMetricName' => [ 'base' => '<p>The historical metric names.</p>', 'refs' => [ 'HistoricalMetric$Name' => '<p>The name of the metric.</p>', ], ], 'HistoricalMetricResult' => [ 'base' => '<p>Contains information about the historical metrics retrieved.</p>', 'refs' => [ 'HistoricalMetricResults$member' => NULL, ], ], 'HistoricalMetricResults' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataResponse$MetricResults' => '<p>Information about the historical metrics.</p> <p>If no grouping is specified, a summary of metric data is returned.</p>', ], ], 'HistoricalMetrics' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataRequest$HistoricalMetrics' => '<p>The metrics to retrieve. Specify the name, unit, and statistic for each metric. The following historical metrics are available. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical Metrics Definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <note> <p>This API does not support a contacts incoming metric (there\'s no CONTACTS_INCOMING metric missing from the documented list). </p> </note> <dl> <dt>ABANDON_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>AFTER_CONTACT_WORK_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>API_CONTACTS_HANDLED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CALLBACK_CONTACTS_HANDLED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_ABANDONED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_AGENT_HUNG_UP_FIRST</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_CONSULTED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_HANDLED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_HANDLED_INCOMING</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_HANDLED_OUTBOUND</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_HOLD_ABANDONS</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_MISSED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_QUEUED</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_TRANSFERRED_IN</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_TRANSFERRED_IN_FROM_QUEUE</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_TRANSFERRED_OUT</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt> <dd> <p>Unit: COUNT</p> <p>Statistic: SUM</p> </dd> <dt>HANDLE_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>HOLD_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>INTERACTION_AND_HOLD_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>INTERACTION_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>OCCUPANCY</dt> <dd> <p>Unit: PERCENT</p> <p>Statistic: AVG</p> </dd> <dt>QUEUE_ANSWER_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: AVG</p> </dd> <dt>QUEUED_TIME</dt> <dd> <p>Unit: SECONDS</p> <p>Statistic: MAX</p> </dd> <dt>SERVICE_LEVEL</dt> <dd> <p>You can include up to 20 SERVICE_LEVEL metrics in a request.</p> <p>Unit: PERCENT</p> <p>Statistic: AVG</p> <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than"). </p> </dd> </dl>', ], ], 'Hours' => [ 'base' => NULL, 'refs' => [ 'KinesisVideoStreamConfig$RetentionPeriodHours' => '<p>The number of hours data is retained in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p> <p>The default value is 0, indicating that the stream does not persist data.</p>', ], ], 'Hours24Format' => [ 'base' => NULL, 'refs' => [ 'HoursOfOperationTimeSlice$Hours' => '<p>The hours.</p>', ], ], 'HoursOfOperation' => [ 'base' => '<p>Information about of the hours of operation.</p>', 'refs' => [ 'DescribeHoursOfOperationResponse$HoursOfOperation' => '<p>The hours of operation.</p>', 'HoursOfOperationList$member' => NULL, ], ], 'HoursOfOperationConfig' => [ 'base' => '<p>Contains information about the hours of operation.</p>', 'refs' => [ 'HoursOfOperationConfigList$member' => NULL, ], ], 'HoursOfOperationConfigList' => [ 'base' => NULL, 'refs' => [ 'CreateHoursOfOperationRequest$Config' => '<p>Configuration information for the hours of operation: day, start time, and end time.</p>', 'HoursOfOperation$Config' => '<p>Configuration information for the hours of operation.</p>', 'UpdateHoursOfOperationRequest$Config' => '<p>Configuration information of the hours of operation.</p>', ], ], 'HoursOfOperationDays' => [ 'base' => NULL, 'refs' => [ 'HoursOfOperationConfig$Day' => '<p>The day that the hours of operation applies to.</p>', ], ], 'HoursOfOperationDescription' => [ 'base' => NULL, 'refs' => [ 'CreateHoursOfOperationRequest$Description' => '<p>The description of the hours of operation.</p>', 'HoursOfOperation$Description' => '<p>The description for the hours of operation.</p>', ], ], 'HoursOfOperationId' => [ 'base' => NULL, 'refs' => [ 'CreateHoursOfOperationResponse$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', 'CreateQueueRequest$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', 'DeleteHoursOfOperationRequest$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', 'DescribeHoursOfOperationRequest$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', 'HoursOfOperation$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', 'HoursOfOperationSummary$Id' => '<p>The identifier of the hours of operation.</p>', 'Queue$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', 'UpdateHoursOfOperationRequest$HoursOfOperationId' => '<p>The identifier of the hours of operation.</p>', 'UpdateQueueHoursOfOperationRequest$HoursOfOperationId' => '<p>The identifier for the hours of operation.</p>', ], ], 'HoursOfOperationList' => [ 'base' => NULL, 'refs' => [ 'SearchHoursOfOperationsResponse$HoursOfOperations' => '<p>Information about the hours of operations.</p>', ], ], 'HoursOfOperationName' => [ 'base' => NULL, 'refs' => [ 'HoursOfOperationSummary$Name' => '<p>The name of the hours of operation.</p>', ], ], 'HoursOfOperationSearchConditionList' => [ 'base' => NULL, 'refs' => [ 'HoursOfOperationSearchCriteria$OrConditions' => '<p>A list of conditions which would be applied together with an OR condition.</p>', 'HoursOfOperationSearchCriteria$AndConditions' => '<p>A list of conditions which would be applied together with an AND condition.</p>', ], ], 'HoursOfOperationSearchCriteria' => [ 'base' => '<p>The search criteria to be used to return hours of operations.</p>', 'refs' => [ 'HoursOfOperationSearchConditionList$member' => NULL, 'SearchHoursOfOperationsRequest$SearchCriteria' => '<p>The search criteria to be used to return hours of operations.</p>', ], ], 'HoursOfOperationSearchFilter' => [ 'base' => '<p>Filters to be applied to search results.</p>', 'refs' => [ 'SearchHoursOfOperationsRequest$SearchFilter' => '<p>Filters to be applied to search results.</p>', ], ], 'HoursOfOperationSummary' => [ 'base' => '<p>Contains summary information about hours of operation for a contact center.</p>', 'refs' => [ 'HoursOfOperationSummaryList$member' => NULL, ], ], 'HoursOfOperationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListHoursOfOperationsResponse$HoursOfOperationSummaryList' => '<p>Information about the hours of operation.</p>', ], ], 'HoursOfOperationTimeSlice' => [ 'base' => '<p>The start time or end time for an hours of operation.</p>', 'refs' => [ 'HoursOfOperationConfig$StartTime' => '<p>The start time that your contact center opens.</p>', 'HoursOfOperationConfig$EndTime' => '<p>The end time that your contact center closes.</p>', ], ], 'ISO8601Datetime' => [ 'base' => NULL, 'refs' => [ 'AttachedFile$CreationTime' => '<p>The time of Creation of the file resource as an ISO timestamp. It\'s specified in ISO 8601 format: <code>yyyy-MM-ddThh:mm:ss.SSSZ</code>. For example, <code>2024-05-03T02:41:28.172Z</code>.</p>', 'DownloadUrlMetadata$UrlExpiry' => '<p>The expiration time of the URL in ISO timestamp. It\'s specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>', 'GetAttachedFileResponse$CreationTime' => '<p>The time of Creation of the file resource as an ISO timestamp. It\'s specified in ISO 8601 format: <code>yyyy-MM-ddThh:mm:ss.SSSZ</code>. For example, <code>2024-05-03T02:41:28.172Z</code>.</p>', 'ParticipantTokenCredentials$Expiry' => '<p>The expiration of the token. It\'s specified in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>', 'StartAttachedFileUploadResponse$CreationTime' => '<p>The time of Creation of the file resource as an ISO timestamp. It\'s specified in ISO 8601 format: <code>yyyy-MM-ddThh:mm:ss.SSSZ</code>. For example, <code>2024-05-03T02:41:28.172Z</code>.</p>', 'UploadUrlMetadata$UrlExpiry' => '<p>The expiration time of the URL in ISO timestamp. It\'s specified in ISO 8601 format: <code>yyyy-MM-ddThh:mm:ss.SSSZ</code>. For example, <code>2019-11-08T02:41:28.172Z</code>.</p>', ], ], 'IdempotencyException' => [ 'base' => '<p>An entity with the same name already exists.</p>', 'refs' => [], ], 'ImportPhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportPhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'InboundCallsEnabled' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$InboundCallsEnabled' => '<p>Your contact center handles incoming contacts.</p>', 'Instance$InboundCallsEnabled' => '<p>Whether inbound calls are enabled.</p>', 'InstanceSummary$InboundCallsEnabled' => '<p>Whether inbound calls are enabled.</p>', ], ], 'Index' => [ 'base' => NULL, 'refs' => [ 'RoutingCriteria$Index' => '<p>Information about the index of the routing criteria.</p>', ], ], 'InitiationMethodList' => [ 'base' => NULL, 'refs' => [ 'SearchCriteria$InitiationMethods' => '<p>The list of initiation methods associated with contacts.</p>', ], ], 'Instance' => [ 'base' => '<p>The Amazon Connect instance.</p>', 'refs' => [ 'DescribeInstanceResponse$Instance' => '<p>The name of the instance.</p>', ], ], 'InstanceArn' => [ 'base' => NULL, 'refs' => [ 'TrafficDistributionGroup$InstanceArn' => '<p>The Amazon Resource Name (ARN).</p>', 'TrafficDistributionGroupSummary$InstanceArn' => '<p>The Amazon Resource Name (ARN) of the traffic distribution group.</p>', ], ], 'InstanceAttributeType' => [ 'base' => NULL, 'refs' => [ 'Attribute$AttributeType' => '<p>The type of attribute.</p>', 'DescribeInstanceAttributeRequest$AttributeType' => '<p>The type of attribute.</p>', 'UpdateInstanceAttributeRequest$AttributeType' => '<p>The type of attribute.</p> <note> <p>Only allowlisted customers can consume USE_CUSTOM_TTS_VOICES. To access this feature, contact Amazon Web Services Support for allowlisting.</p> </note>', ], ], 'InstanceAttributeValue' => [ 'base' => NULL, 'refs' => [ 'Attribute$Value' => '<p>The value of the attribute.</p>', 'UpdateInstanceAttributeRequest$Value' => '<p>The value for the attribute. Maximum character limit is 100. </p>', ], ], 'InstanceId' => [ 'base' => NULL, 'refs' => [ 'ActivateEvaluationFormRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateAnalyticsDataSetRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateApprovedOriginRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateBotRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateDefaultVocabularyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateFlowRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateInstanceStorageConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateLambdaFunctionRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateLexBotRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociatePhoneNumberContactFlowRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateQueueQuickConnectsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateRoutingProfileQueuesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateSecurityKeyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateTrafficDistributionGroupUserRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'AssociateUserProficienciesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN of the instance).</p>', 'BatchAssociateAnalyticsDataSetRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'BatchDisassociateAnalyticsDataSetRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'BatchGetAttachedFileMetadataRequest$InstanceId' => '<p>The unique identifier of the Connect instance.</p>', 'BatchGetFlowAssociationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'BatchPutContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ClaimPhoneNumberRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance. You must enter <code>InstanceId</code> or <code>TargetArn</code>. </p>', 'ClaimedPhoneNumberSummary$InstanceId' => '<p>The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CompleteAttachedFileUploadRequest$InstanceId' => '<p>The unique identifier of the Amazon Connect instance.</p>', 'CreateAgentStatusRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateContactFlowModuleRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateContactFlowRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'CreateEvaluationFormRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateHoursOfOperationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateInstanceResponse$Id' => '<p>The identifier for the instance.</p>', 'CreateIntegrationAssociationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateParticipantRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance. </p>', 'CreatePersistentContactAssociationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreatePredefinedAttributeRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.</p>', 'CreatePromptRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateQueueRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateQuickConnectRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateRoutingProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateRuleRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateSecurityProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateTaskTemplateRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateUseCaseRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateUserHierarchyGroupRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateUserRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'CreateVocabularyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeactivateEvaluationFormRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DefaultVocabulary$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteAttachedFileRequest$InstanceId' => '<p>The unique identifier of the Connect instance.</p>', 'DeleteContactEvaluationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteContactFlowModuleRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteContactFlowRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteEvaluationFormRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteHoursOfOperationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteInstanceRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteIntegrationAssociationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeletePredefinedAttributeRequest$InstanceId' => '<p> The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.</p>', 'DeletePromptRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteQueueRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteQuickConnectRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteRoutingProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteRuleRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteSecurityProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteTaskTemplateRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteUseCaseRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteUserHierarchyGroupRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteUserRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DeleteVocabularyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeAgentStatusRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeAuthenticationProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeContactEvaluationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeContactFlowModuleRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeContactFlowRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'DescribeContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeEvaluationFormRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeHoursOfOperationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeInstanceAttributeRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeInstanceRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeInstanceStorageConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribePredefinedAttributeRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribePromptRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeQueueRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeQuickConnectRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeRoutingProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeRuleRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeSecurityProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeUserHierarchyGroupRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeUserHierarchyStructureRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeUserRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DescribeVocabularyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DisassociateAnalyticsDataSetRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DisassociateApprovedOriginRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DisassociateBotRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DisassociateFlowRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DisassociateInstanceStorageConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DisassociateLambdaFunctionRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance..</p>', 'DisassociateLexBotRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DisassociatePhoneNumberContactFlowRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DisassociateQueueQuickConnectsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DisassociateRoutingProfileQueuesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DisassociateSecurityKeyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DisassociateTrafficDistributionGroupUserRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'DisassociateUserProficienciesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.</p>', 'DismissUserContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'GetAttachedFileRequest$InstanceId' => '<p>The unique identifier of the Connect instance.</p>', 'GetContactAttributesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'GetCurrentMetricDataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'GetCurrentUserDataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'GetFederationTokenRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'GetFlowAssociationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'GetMetricDataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'GetPromptFileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'GetTaskTemplateRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'GetTaskTemplateResponse$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ImportPhoneNumberRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'Instance$Id' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'InstanceSummary$Id' => '<p>The identifier of the instance.</p>', 'IntegrationAssociationSummary$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListAgentStatusRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListAnalyticsDataAssociationsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListApprovedOriginsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListAuthenticationProfilesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListBotsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListContactEvaluationsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListContactFlowModulesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListContactFlowsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListContactReferencesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListDefaultVocabulariesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListEvaluationFormVersionsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListEvaluationFormsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListFlowAssociationsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListHoursOfOperationsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListInstanceAttributesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListInstanceStorageConfigsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListIntegrationAssociationsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListLambdaFunctionsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListLexBotsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListPhoneNumbersRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListPhoneNumbersSummary$InstanceId' => '<p>The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListPhoneNumbersV2Request$InstanceId' => '<p>The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance. If both <code>TargetArn</code> and <code>InstanceId</code> are not provided, this API lists numbers claimed to all the Amazon Connect instances belonging to your account in the same AWS Region as the request.</p>', 'ListPredefinedAttributesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.</p>', 'ListPromptsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'ListQueueQuickConnectsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListQueuesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListQuickConnectsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListRealtimeContactAnalysisSegmentsV2Request$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListRoutingProfileQueuesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListRoutingProfilesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListRulesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListSecurityKeysRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListSecurityProfileApplicationsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListSecurityProfilePermissionsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListSecurityProfilesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListTaskTemplatesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListUseCasesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListUserHierarchyGroupsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ListUserProficienciesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.</p>', 'ListUsersRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'MonitorContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'PauseContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the <code>instanceId</code> in the ARN of the instance.</p>', 'PutUserStatusRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ReplicateInstanceResponse$Id' => '<p>The identifier of the replicated instance. You can find the <code>instanceId</code> in the ARN of the instance. The replicated instance has the same identifier as the instance it was replicated from.</p>', 'ResumeContactRecordingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ResumeContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the <code>instanceId</code> in the ARN of the instance.</p>', 'RoutingProfile$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'SearchAgentStatusesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'SearchAvailablePhoneNumbersRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance. You must enter <code>InstanceId</code> or <code>TargetArn</code>. </p>', 'SearchContactFlowModulesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.</p>', 'SearchContactFlowsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.</p>', 'SearchContactsRequest$InstanceId' => '<p>The identifier of Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.</p>', 'SearchHoursOfOperationsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'SearchPredefinedAttributesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.</p>', 'SearchPromptsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'SearchQueuesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'SearchQuickConnectsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'SearchRoutingProfilesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'SearchSecurityProfilesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'SearchUserHierarchyGroupsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'SearchUsersRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p> <note> <p>InstanceID is a required field. The "Required: No" below is incorrect.</p> </note>', 'SearchVocabulariesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'SecurityProfile$OrganizationResourceId' => '<p>The organization resource identifier for the security profile.</p>', 'SecurityProfileSearchSummary$OrganizationResourceId' => '<p>The organization resource identifier.</p>', 'StartAttachedFileUploadRequest$InstanceId' => '<p>The unique identifier of the Amazon Connect instance.</p>', 'StartChatContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'StartContactEvaluationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'StartContactRecordingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'StartContactStreamingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'StartOutboundVoiceContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'StartTaskContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'StartWebRTCContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'StopContactRecordingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'StopContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'StopContactStreamingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'SubmitContactEvaluationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'SuspendContactRecordingRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'TagContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'TransferContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UntagContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateAgentStatusRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateAuthenticationProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateContactAttributesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateContactEvaluationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateContactFlowContentRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'UpdateContactFlowMetadataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateContactFlowModuleContentRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateContactFlowModuleMetadataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateContactFlowNameRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance.</p>', 'UpdateContactRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateContactRoutingDataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateContactScheduleRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateEvaluationFormRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateHoursOfOperationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateInstanceAttributeRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateInstanceStorageConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateParticipantRoleConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdatePhoneNumberRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance that phone numbers are claimed to. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance. You must enter <code>InstanceId</code> or <code>TargetArn</code>. </p>', 'UpdatePredefinedAttributeRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdatePromptRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateQueueHoursOfOperationRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateQueueMaxContactsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateQueueNameRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateQueueOutboundCallerConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateQueueStatusRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateQuickConnectConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateQuickConnectNameRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateRoutingProfileAgentAvailabilityTimerRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateRoutingProfileConcurrencyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateRoutingProfileDefaultOutboundQueueRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateRoutingProfileNameRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateRoutingProfileQueuesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateRuleRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateSecurityProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateTaskTemplateRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateTaskTemplateResponse$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateUserHierarchyGroupNameRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateUserHierarchyRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateUserHierarchyStructureRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateUserIdentityInfoRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateUserPhoneConfigRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateUserProficienciesRequest$InstanceId' => '<p> The identifier of the Amazon Connect instance. You can find the instance ID in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateUserRoutingProfileRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'UpdateUserSecurityProfilesRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', ], ], 'InstanceIdOrArn' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficDistributionGroupRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance that has been replicated. You can find the <code>instanceId</code> in the ARN of the instance.</p>', 'ListTrafficDistributionGroupsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance.</p>', 'ReplicateInstanceRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can <a href="https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html">find the instance ID</a> in the Amazon Resource Name (ARN) of the instance. You can provide the <code>InstanceId</code>, or the entire ARN.</p>', 'SearchResourceTagsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the Amazon Resource Name (ARN) of the instance.</p>', ], ], 'InstanceStatus' => [ 'base' => NULL, 'refs' => [ 'Instance$InstanceStatus' => '<p>The state of the instance.</p>', 'InstanceSummary$InstanceStatus' => '<p>The state of the instance.</p>', ], ], 'InstanceStatusReason' => [ 'base' => '<p>Relevant details why the instance was not successfully created.</p>', 'refs' => [ 'Instance$StatusReason' => '<p>Relevant details why the instance was not successfully created. </p>', ], ], 'InstanceStorageConfig' => [ 'base' => '<p>The storage configuration for the instance.</p>', 'refs' => [ 'AssociateInstanceStorageConfigRequest$StorageConfig' => '<p>A valid storage type.</p>', 'DescribeInstanceStorageConfigResponse$StorageConfig' => '<p>A valid storage type.</p>', 'InstanceStorageConfigs$member' => NULL, 'UpdateInstanceStorageConfigRequest$StorageConfig' => NULL, ], ], 'InstanceStorageConfigs' => [ 'base' => NULL, 'refs' => [ 'ListInstanceStorageConfigsResponse$StorageConfigs' => '<p>A valid storage type.</p>', ], ], 'InstanceStorageResourceType' => [ 'base' => NULL, 'refs' => [ 'AssociateInstanceStorageConfigRequest$ResourceType' => '<p>A valid resource type. To <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-contact-analysis-segment-streams.html">enable streaming for real-time analysis of contacts</a>, use the following types:</p> <ul> <li> <p>For chat contacts, use <code>REAL_TIME_CONTACT_ANALYSIS_CHAT_SEGMENTS</code>.</p> </li> <li> <p>For voice contacts, use <code>REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS</code>.</p> </li> </ul> <note> <p> <code>REAL_TIME_CONTACT_ANALYSIS_SEGMENTS</code> is deprecated, but it is still supported and will apply only to VOICE channel contacts. Use <code>REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS</code> for voice contacts moving forward.</p> <p>If you have previously associated a stream with <code>REAL_TIME_CONTACT_ANALYSIS_SEGMENTS</code>, no action is needed to update the stream to <code>REAL_TIME_CONTACT_ANALYSIS_VOICE_SEGMENTS</code>.</p> </note>', 'DescribeInstanceStorageConfigRequest$ResourceType' => '<p>A valid resource type.</p>', 'DisassociateInstanceStorageConfigRequest$ResourceType' => '<p>A valid resource type.</p>', 'ListInstanceStorageConfigsRequest$ResourceType' => '<p>A valid resource type.</p>', 'UpdateInstanceStorageConfigRequest$ResourceType' => '<p>A valid resource type.</p>', ], ], 'InstanceSummary' => [ 'base' => '<p>Information about the instance.</p>', 'refs' => [ 'InstanceSummaryList$member' => NULL, ], ], 'InstanceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListInstancesResponse$InstanceSummaryList' => '<p>Information about the instances.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormNumericQuestionOption$MinValue' => '<p>The minimum answer value of the range option.</p>', 'EvaluationFormNumericQuestionOption$MaxValue' => '<p>The maximum answer value of the range option.</p>', 'EvaluationFormNumericQuestionProperties$MinValue' => '<p>The minimum answer value.</p>', 'EvaluationFormNumericQuestionProperties$MaxValue' => '<p>The maximum answer value.</p>', ], ], 'IntegerCount' => [ 'base' => NULL, 'refs' => [ 'ChannelToCountMap$value' => NULL, ], ], 'IntegrationAssociationId' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationAssociationResponse$IntegrationAssociationId' => '<p>The identifier for the integration association.</p>', 'CreateUseCaseRequest$IntegrationAssociationId' => '<p>The identifier for the integration association.</p>', 'DeleteIntegrationAssociationRequest$IntegrationAssociationId' => '<p>The identifier for the integration association.</p>', 'DeleteUseCaseRequest$IntegrationAssociationId' => '<p>The identifier for the integration association.</p>', 'IntegrationAssociationSummary$IntegrationAssociationId' => '<p>The identifier for the AppIntegration association.</p>', 'ListUseCasesRequest$IntegrationAssociationId' => '<p>The identifier for the integration association.</p>', 'RuleTriggerEventSource$IntegrationAssociationId' => '<p>The identifier for the integration association.</p>', ], ], 'IntegrationAssociationSummary' => [ 'base' => '<p>Contains summary information about the associated AppIntegrations.</p>', 'refs' => [ 'IntegrationAssociationSummaryList$member' => NULL, ], ], 'IntegrationAssociationSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListIntegrationAssociationsResponse$IntegrationAssociationSummaryList' => '<p>The associations.</p>', ], ], 'IntegrationType' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationAssociationRequest$IntegrationType' => '<p>The type of information to be ingested.</p>', 'IntegrationAssociationSummary$IntegrationType' => '<p>The integration type.</p>', 'ListIntegrationAssociationsRequest$IntegrationType' => '<p>The integration type.</p>', ], ], 'InternalServiceException' => [ 'base' => '<p>Request processing failed because of an error or failure with the service.</p>', 'refs' => [], ], 'IntervalDetails' => [ 'base' => '<p>Information about the interval period to use for returning results.</p>', 'refs' => [ 'GetMetricDataV2Request$Interval' => '<p>The interval period and timezone to apply to returned metrics.</p> <ul> <li> <p> <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid <code>IntervalPeriod</code> values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> | <code>HOUR</code> | <code>DAY</code> | <code>WEEK</code> | <code>TOTAL</code>. </p> <p>For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the <code>TOTAL</code> interval period. </p> <p>The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on which <code>IntervalPeriod</code> is requested. </p> <ul> <li> <p> <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3 days.</p> </li> <li> <p> <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3 days.</p> </li> <li> <p> <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3 days.</p> </li> <li> <p> <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35 days.</p> </li> <li> <p> <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35 days.</p> </li> <li> <p> <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35 days.</p> </li> </ul> </li> <li> <p> <code>TimeZone</code>: The timezone applied to requested metrics.</p> </li> </ul>', ], ], 'IntervalPeriod' => [ 'base' => NULL, 'refs' => [ 'IntervalDetails$IntervalPeriod' => '<p> <code>IntervalPeriod</code>: An aggregated grouping applied to request metrics. Valid <code>IntervalPeriod</code> values are: <code>FIFTEEN_MIN</code> | <code>THIRTY_MIN</code> | <code>HOUR</code> | <code>DAY</code> | <code>WEEK</code> | <code>TOTAL</code>. </p> <p>For example, if <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and <code>EndTime</code> differs by 1 day, then Amazon Connect returns 48 results in the response. Each result is aggregated by the THIRTY_MIN period. By default Amazon Connect aggregates results based on the <code>TOTAL</code> interval period. </p> <p>The following list describes restrictions on <code>StartTime</code> and <code>EndTime</code> based on what <code>IntervalPeriod</code> is requested. </p> <ul> <li> <p> <code>FIFTEEN_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3 days.</p> </li> <li> <p> <code>THIRTY_MIN</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3 days.</p> </li> <li> <p> <code>HOUR</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 3 days.</p> </li> <li> <p> <code>DAY</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35 days.</p> </li> <li> <p> <code>WEEK</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35 days.</p> </li> <li> <p> <code>TOTAL</code>: The difference between <code>StartTime</code> and <code>EndTime</code> must be less than 35 days.</p> </li> </ul>', 'MetricInterval$Interval' => '<p>The interval period provided in the API request. </p>', ], ], 'InvalidContactFlowException' => [ 'base' => '<p>The flow is not valid.</p>', 'refs' => [], ], 'InvalidContactFlowModuleException' => [ 'base' => '<p>The problems with the module. Please fix before trying again.</p>', 'refs' => [], ], 'InvalidParameterException' => [ 'base' => '<p>One or more of the specified parameters are not valid.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request is not valid.</p>', 'refs' => [], ], 'InvalidRequestExceptionReason' => [ 'base' => '<p>Reason why the request was invalid.</p>', 'refs' => [ 'InvalidRequestException$Reason' => NULL, ], ], 'InvisibleFieldInfo' => [ 'base' => '<p>A field that is invisible to an agent.</p>', 'refs' => [ 'InvisibleTaskTemplateFields$member' => NULL, ], ], 'InvisibleTaskTemplateFields' => [ 'base' => NULL, 'refs' => [ 'TaskTemplateConstraints$InvisibleFields' => '<p>Lists the fields that are invisible to agents.</p>', ], ], 'IpCidr' => [ 'base' => NULL, 'refs' => [ 'IpCidrList$member' => NULL, ], ], 'IpCidrList' => [ 'base' => NULL, 'refs' => [ 'AuthenticationProfile$AllowedIps' => '<p>A list of IP address range strings that are allowed to access the Amazon Connect instance. For more information about how to configure IP addresses, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac">Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'AuthenticationProfile$BlockedIps' => '<p>A list of IP address range strings that are blocked from accessing the Amazon Connect instance. For more information about how to configure IP addresses, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac">Configure IP address based access control</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'UpdateAuthenticationProfileRequest$AllowedIps' => '<p>A list of IP address range strings that are allowed to access the instance. For more information on how to configure IP addresses, see<a href="https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts">Configure session timeouts</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', 'UpdateAuthenticationProfileRequest$BlockedIps' => '<p>A list of IP address range strings that are blocked from accessing the instance. For more information on how to configure IP addresses, For more information on how to configure IP addresses, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-ip-based-ac">Configure IP-based access control</a> in the <i>Amazon Connect Administrator Guide</i>. </p>', ], ], 'JoinToken' => [ 'base' => NULL, 'refs' => [ 'Attendee$JoinToken' => '<p>The join token used by the Amazon Chime SDK attendee.</p>', ], ], 'KeyId' => [ 'base' => NULL, 'refs' => [ 'EncryptionConfig$KeyId' => '<p>The full ARN of the encryption key. </p> <note> <p>Be sure to provide the full ARN of the encryption key, not just the ID.</p> <p>Amazon Connect supports only KMS keys with the default key spec of <a href="https://docs.aws.amazon.com/kms/latest/developerguide/asymmetric-key-specs.html#key-spec-symmetric-default"> <code>SYMMETRIC_DEFAULT</code> </a>. </p> </note>', ], ], 'KinesisFirehoseConfig' => [ 'base' => '<p>Configuration information of a Kinesis Data Firehose delivery stream.</p>', 'refs' => [ 'InstanceStorageConfig$KinesisFirehoseConfig' => '<p>The configuration of the Kinesis Firehose delivery stream.</p>', ], ], 'KinesisStreamConfig' => [ 'base' => '<p>Configuration information of a Kinesis data stream.</p>', 'refs' => [ 'InstanceStorageConfig$KinesisStreamConfig' => '<p>The configuration of the Kinesis data stream.</p>', ], ], 'KinesisVideoStreamConfig' => [ 'base' => '<p>Configuration information of a Kinesis video stream.</p>', 'refs' => [ 'InstanceStorageConfig$KinesisVideoStreamConfig' => '<p>The configuration of the Kinesis video stream.</p>', ], ], 'LargeNextToken' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersV2Request$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListPhoneNumbersV2Response$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListRealtimeContactAnalysisSegmentsV2Request$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListRealtimeContactAnalysisSegmentsV2Response$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchAvailablePhoneNumbersRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchAvailablePhoneNumbersResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchContactsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchContactsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', ], ], 'LexBot' => [ 'base' => '<p>Configuration information of an Amazon Lex bot.</p>', 'refs' => [ 'AssociateBotRequest$LexBot' => NULL, 'AssociateLexBotRequest$LexBot' => '<p>The Amazon Lex bot to associate with the instance.</p>', 'DisassociateBotRequest$LexBot' => NULL, 'LexBotConfig$LexBot' => NULL, 'LexBotsList$member' => NULL, ], ], 'LexBotConfig' => [ 'base' => '<p>Configuration information of an Amazon Lex or Amazon Lex V2 bot.</p>', 'refs' => [ 'LexBotConfigList$member' => NULL, ], ], 'LexBotConfigList' => [ 'base' => NULL, 'refs' => [ 'ListBotsResponse$LexBots' => '<p>The names and Amazon Web Services Regions of the Amazon Lex or Amazon Lex V2 bots associated with the specified instance.</p>', ], ], 'LexBotsList' => [ 'base' => NULL, 'refs' => [ 'ListLexBotsResponse$LexBots' => '<p>The names and Amazon Web Services Regions of the Amazon Lex bots associated with the specified instance.</p>', ], ], 'LexRegion' => [ 'base' => NULL, 'refs' => [ 'DisassociateLexBotRequest$LexRegion' => '<p>The Amazon Web Services Region in which the Amazon Lex bot has been created.</p>', 'LexBot$LexRegion' => '<p>The Amazon Web Services Region where the Amazon Lex bot was created.</p>', ], ], 'LexV2Bot' => [ 'base' => '<p>Configuration information of an Amazon Lex V2 bot.</p>', 'refs' => [ 'AssociateBotRequest$LexV2Bot' => '<p>The Amazon Lex V2 bot to associate with the instance.</p>', 'DisassociateBotRequest$LexV2Bot' => '<p>The Amazon Lex V2 bot to disassociate from the instance.</p>', 'LexBotConfig$LexV2Bot' => '<p>Configuration information of an Amazon Lex V2 bot.</p>', ], ], 'LexVersion' => [ 'base' => NULL, 'refs' => [ 'ListBotsRequest$LexVersion' => '<p>The version of Amazon Lex or Amazon Lex V2.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The allowed limit for the resource has been exceeded.</p>', 'refs' => [], ], 'ListAgentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAgentStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAnalyticsDataAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAnalyticsDataAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListApprovedOriginsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApprovedOriginsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListAuthenticationProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAuthenticationProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCondition' => [ 'base' => '<p>A leaf node condition which can be used to specify a List condition to search users with attributes included in Lists like Proficiencies.</p>', 'refs' => [ 'UserSearchCriteria$ListCondition' => '<p>A leaf node condition which can be used to specify a List condition to search users with attributes included in Lists like Proficiencies.</p>', ], ], 'ListContactEvaluationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContactEvaluationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListContactFlowModulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContactFlowModulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListContactFlowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContactFlowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListContactReferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListContactReferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDefaultVocabulariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDefaultVocabulariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEvaluationFormVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEvaluationFormVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEvaluationFormsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEvaluationFormsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowAssociationResourceType' => [ 'base' => NULL, 'refs' => [ 'BatchGetFlowAssociationRequest$ResourceType' => '<p>The type of resource association.</p>', 'FlowAssociationSummary$ResourceType' => '<p>The type of resource association.</p>', 'ListFlowAssociationsRequest$ResourceType' => '<p>A valid resource type.</p>', ], ], 'ListFlowAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFlowAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListHoursOfOperationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListHoursOfOperationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceStorageConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceStorageConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListInstancesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstancesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListIntegrationAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListIntegrationAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLambdaFunctionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLambdaFunctionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLexBotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLexBotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersSummary' => [ 'base' => '<p>Information about phone numbers that have been claimed to your Amazon Connect instance or traffic distribution group.</p>', 'refs' => [ 'ListPhoneNumbersSummaryList$member' => NULL, ], ], 'ListPhoneNumbersSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersV2Response$ListPhoneNumbersSummaryList' => '<p>Information about phone numbers that have been claimed to your Amazon Connect instances or traffic distribution groups.</p>', ], ], 'ListPhoneNumbersV2Request' => [ 'base' => NULL, 'refs' => [], ], 'ListPhoneNumbersV2Response' => [ 'base' => NULL, 'refs' => [], ], 'ListPredefinedAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPredefinedAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPromptsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPromptsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQueueQuickConnectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQueueQuickConnectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQueuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListQuickConnectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListQuickConnectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRealtimeContactAnalysisSegmentsV2Request' => [ 'base' => NULL, 'refs' => [], ], 'ListRealtimeContactAnalysisSegmentsV2Response' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutingProfileQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutingProfileQueuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutingProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRoutingProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityKeysRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityKeysResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfileApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfileApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilePermissionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilePermissionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTaskTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTaskTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrafficDistributionGroupUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrafficDistributionGroupUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrafficDistributionGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTrafficDistributionGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUseCasesRequest' => [ 'base' => '<p>Provides summary information about the use cases for the specified integration association.</p>', 'refs' => [], ], 'ListUseCasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserHierarchyGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserHierarchyGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUserProficienciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUserProficienciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListViewVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListViewVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListViewsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListViewsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'RoutingProfile$NumberOfAssociatedQueues' => '<p>The number of associated queues in routing profile.</p>', 'RoutingProfile$NumberOfAssociatedUsers' => '<p>The number of associated users in routing profile.</p>', ], ], 'MatchCriteria' => [ 'base' => '<p>An object to define AgentsCriteria.</p>', 'refs' => [ 'AttributeCondition$MatchCriteria' => '<p>An object to define <code>AgentsCriteria</code>.</p>', ], ], 'MaxResult10' => [ 'base' => NULL, 'refs' => [ 'ListInstanceStorageConfigsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListInstancesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListTrafficDistributionGroupUsersRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListTrafficDistributionGroupsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchAvailablePhoneNumbersRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'MaxResult100' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'GetCurrentUserDataRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'GetMetricDataRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'GetMetricDataV2Request$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListDefaultVocabulariesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListEvaluationFormVersionsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListEvaluationFormsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListIntegrationAssociationsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListPredefinedAttributesRequest$MaxResults' => '<p>The maximum number of results to return per page. </p>', 'ListQueueQuickConnectsRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', 'ListRealtimeContactAnalysisSegmentsV2Request$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListRoutingProfileQueuesRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', 'ListTaskTemplatesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p> <important> <p>It is not expected that you set this.</p> </important>', 'ListUseCasesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListUserProficienciesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchAgentStatusesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchContactFlowModulesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchContactFlowsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchContactsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchHoursOfOperationsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchPredefinedAttributesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchPromptsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchQuickConnectsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchResourceTagsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchSecurityProfilesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchUserHierarchyGroupsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchVocabulariesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'MaxResult1000' => [ 'base' => NULL, 'refs' => [ 'ListAgentStatusRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListAnalyticsDataAssociationsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListAuthenticationProfilesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListContactFlowModulesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListContactFlowsRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', 'ListFlowAssociationsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListHoursOfOperationsRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', 'ListPhoneNumbersRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', 'ListPhoneNumbersV2Request$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListPromptsRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', 'ListQueuesRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', 'ListQuickConnectsRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', 'ListRoutingProfilesRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', 'ListSecurityProfileApplicationsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListSecurityProfilePermissionsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListSecurityProfilesRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', 'ListUserHierarchyGroupsRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', 'ListUsersRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', ], ], 'MaxResult2' => [ 'base' => NULL, 'refs' => [ 'ListSecurityKeysRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'MaxResult200' => [ 'base' => NULL, 'refs' => [ 'ListRulesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'MaxResult25' => [ 'base' => NULL, 'refs' => [ 'ListApprovedOriginsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListBotsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListLambdaFunctionsRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'ListLexBotsRequest$MaxResults' => '<p>The maximum number of results to return per page. If no value is specified, the default is 10. </p>', ], ], 'MaxResult500' => [ 'base' => NULL, 'refs' => [ 'SearchQueuesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchRoutingProfilesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', 'SearchUsersRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'MaxResult7' => [ 'base' => NULL, 'refs' => [ 'ListInstanceAttributesRequest$MaxResults' => '<p>The maximum number of results to return per page.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListViewVersionsRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', 'ListViewsRequest$MaxResults' => '<p>The maximum number of results to return per page. The default MaxResult size is 100.</p>', ], ], 'MaximumResultReturnedException' => [ 'base' => '<p>Maximum number (1000) of tags have been returned with current request. Consider changing request parameters to get more tags.</p>', 'refs' => [], ], 'MediaConcurrencies' => [ 'base' => NULL, 'refs' => [ 'CreateRoutingProfileRequest$MediaConcurrencies' => '<p>The channels that agents can handle in the Contact Control Panel (CCP) for this routing profile.</p>', 'RoutingProfile$MediaConcurrencies' => '<p>The channels agents can handle in the Contact Control Panel (CCP) for this routing profile.</p>', 'UpdateRoutingProfileConcurrencyRequest$MediaConcurrencies' => '<p>The channels that agents can handle in the Contact Control Panel (CCP).</p>', ], ], 'MediaConcurrency' => [ 'base' => '<p>Contains information about which channels are supported, and how many contacts an agent can have on a channel simultaneously.</p>', 'refs' => [ 'MediaConcurrencies$member' => NULL, ], ], 'MediaPlacement' => [ 'base' => '<p>A set of endpoints used by clients to connect to the media service group for an Amazon Chime SDK meeting.</p>', 'refs' => [ 'Meeting$MediaPlacement' => '<p>The media placement for the meeting.</p>', ], ], 'MediaRegion' => [ 'base' => NULL, 'refs' => [ 'Meeting$MediaRegion' => '<p>The Amazon Web Services Region in which you create the meeting.</p>', ], ], 'Meeting' => [ 'base' => '<p>A meeting created using the Amazon Chime SDK.</p>', 'refs' => [ 'ConnectionData$Meeting' => '<p>A meeting created using the Amazon Chime SDK.</p>', ], ], 'MeetingFeatureStatus' => [ 'base' => NULL, 'refs' => [ 'AudioFeatures$EchoReduction' => '<p>Makes echo reduction available to clients who connect to the meeting.</p>', ], ], 'MeetingFeaturesConfiguration' => [ 'base' => '<p>The configuration settings of the features available to a meeting.</p>', 'refs' => [ 'Meeting$MeetingFeatures' => '<p>The configuration settings of the features available to a meeting.</p>', ], ], 'MeetingId' => [ 'base' => NULL, 'refs' => [ 'Meeting$MeetingId' => '<p>The Amazon Chime SDK meeting ID.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'ContactFlowNotPublishedException$Message' => NULL, 'ContactNotFoundException$Message' => '<p>The message.</p>', 'DestinationNotAllowedException$Message' => '<p>The message about the outbound calls.</p>', 'DuplicateResourceException$Message' => NULL, 'IdempotencyException$Message' => NULL, 'InternalServiceException$Message' => '<p>The message.</p>', 'InvalidParameterException$Message' => '<p>The message about the parameters.</p>', 'InvalidRequestException$Message' => '<p>The message about the request.</p>', 'LimitExceededException$Message' => '<p>The message about the limit.</p>', 'MaximumResultReturnedException$Message' => NULL, 'OutboundContactNotPermittedException$Message' => '<p>The message about the contact.</p>', 'OutputTypeNotFoundException$Message' => NULL, 'PropertyValidationException$Message' => NULL, 'PropertyValidationExceptionProperty$Message' => '<p>A message describing why the property is not valid.</p>', 'ResourceConflictException$Message' => NULL, 'ResourceInUseException$Message' => NULL, 'ResourceNotFoundException$Message' => '<p>The message about the resource.</p>', 'ResourceNotReadyException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'UserNotFoundException$Message' => NULL, ], ], 'MetadataUrl' => [ 'base' => NULL, 'refs' => [ 'DownloadUrlMetadata$Url' => '<p>A pre-signed URL that should be used to download the attached file. </p>', 'UploadUrlMetadata$Url' => '<p>A pre-signed S3 URL that should be used for uploading the attached file. </p>', ], ], 'MetricDataCollectionsV2' => [ 'base' => NULL, 'refs' => [ 'MetricResultV2$Collections' => '<p>The set of metrics.</p>', ], ], 'MetricDataV2' => [ 'base' => '<p>Contains the name, thresholds, and metric filters.</p>', 'refs' => [ 'MetricDataCollectionsV2$member' => NULL, ], ], 'MetricFilterV2' => [ 'base' => '<p>Contains information about the filter used when retrieving metrics. <code>MetricFiltersV2</code> can be used on the following metrics: <code>AVG_AGENT_CONNECTING_TIME</code>, <code>CONTACTS_CREATED</code>, <code>CONTACTS_HANDLED</code>, <code>SUM_CONTACTS_DISCONNECTED</code>.</p>', 'refs' => [ 'MetricFiltersV2List$member' => NULL, ], ], 'MetricFilterValueList' => [ 'base' => NULL, 'refs' => [ 'MetricFilterV2$MetricFilterValues' => '<p>The values to use for filtering data. </p> <p>Valid metric filter values for <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>TRANSFER</code> | <code>QUEUE_TRANSFER</code> | <code>CALLBACK</code> | <code>API</code> </p> <p>Valid metric filter values for <code>DISCONNECT_REASON</code>: <code>CUSTOMER_DISCONNECT</code> | <code>AGENT_DISCONNECT</code> | <code>THIRD_PARTY_DISCONNECT</code> | <code>TELECOM_PROBLEM</code> | <code>BARGED</code> | <code>CONTACT_FLOW_DISCONNECT</code> | <code>OTHER</code> | <code>EXPIRED</code> | <code>API</code> </p>', ], ], 'MetricFiltersV2List' => [ 'base' => NULL, 'refs' => [ 'MetricV2$MetricFilters' => '<p>Contains the filters to be used when returning data.</p>', ], ], 'MetricInterval' => [ 'base' => '<p>The interval period with the start and end time for the metrics.</p>', 'refs' => [ 'MetricResultV2$MetricInterval' => '<p>The interval period with the start and end time for the metrics.</p>', ], ], 'MetricNameV2' => [ 'base' => NULL, 'refs' => [ 'MetricV2$Name' => '<p>The name of the metric.</p> <important> <p>This parameter is required. The following Required = No is incorrect.</p> </important>', ], ], 'MetricResultV2' => [ 'base' => '<p>Contains information about the metric results.</p>', 'refs' => [ 'MetricResultsV2$member' => NULL, ], ], 'MetricResultsV2' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataV2Response$MetricResults' => '<p>Information about the metrics requested in the API request If no grouping is specified, a summary of metric data is returned. </p>', ], ], 'MetricV2' => [ 'base' => '<p>Contains information about the metric.</p>', 'refs' => [ 'MetricDataV2$Metric' => '<p>The metric name, thresholds, and metric filters of the returned metric.</p>', 'MetricsV2$member' => NULL, ], ], 'MetricsV2' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataV2Request$Metrics' => '<p>The metrics to retrieve. Specify the name, groupings, and filters for each metric. The following historical metrics are available. For a description of each metric, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html">Historical metrics definitions</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <dl> <dt>ABANDONMENT_RATE</dt> <dd> <p>Unit: Percent</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#abandonment-rate-historical">Abandonment rate</a> </p> </dd> <dt>AGENT_ADHERENT_TIME</dt> <dd> <p>This metric is available only in Amazon Web Services Regions where <a href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting, capacity planning, and scheduling</a> is available.</p> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy </p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherent-time-historical">Adherent time</a> </p> </dd> <dt>AGENT_ANSWER_RATE</dt> <dd> <p>Unit: Percent</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-answer-rate-historical">Agent answer rate</a> </p> </dd> <dt>AGENT_NON_ADHERENT_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#non-adherent-time">Non-adherent time</a> </p> </dd> <dt>AGENT_NON_RESPONSE</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy </p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-non-response">Agent non-response</a> </p> </dd> <dt>AGENT_NON_RESPONSE_WITHOUT_CUSTOMER_ABANDONS</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy</p> <p>Data for this metric is available starting from October 1, 2023 0:00:00 GMT.</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-nonresponse-no-abandon-historical">Agent non-response without customer abandons</a> </p> </dd> <dt>AGENT_OCCUPANCY</dt> <dd> <p>Unit: Percentage</p> <p>Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy </p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#occupancy-historical">Occupancy</a> </p> </dd> <dt>AGENT_SCHEDULE_ADHERENCE</dt> <dd> <p>This metric is available only in Amazon Web Services Regions where <a href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting, capacity planning, and scheduling</a> is available.</p> <p>Unit: Percent</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#adherence-historical">Adherence</a> </p> </dd> <dt>AGENT_SCHEDULED_TIME</dt> <dd> <p>This metric is available only in Amazon Web Services Regions where <a href="https://docs.aws.amazon.com/connect/latest/adminguide/regions.html#optimization_region">Forecasting, capacity planning, and scheduling</a> is available.</p> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#scheduled-time-historical">Scheduled time</a> </p> </dd> <dt>AVG_ABANDON_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-abandon-time-historical">Average queue abandon time</a> </p> </dd> <dt>AVG_ACTIVE_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-active-time-historical">Average active time</a> </p> </dd> <dt>AVG_AFTER_CONTACT_WORK_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid metric filter key: <code>INITIATION_METHOD</code> </p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-acw-time-historical">Average after contact work time</a> </p> <note> <p>Feature is a valid filter but not a valid grouping.</p> </note> </dd> <dt>AVG_AGENT_CONNECTING_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid metric filter key: <code>INITIATION_METHOD</code>. For now, this metric only supports the following as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> | <code>API</code> </p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-avg-agent-api-connecting-time">Average agent API connecting time</a> </p> <note> <p>The <code>Negate</code> key in Metric Level Filters is not applicable for this metric.</p> </note> </dd> <dt>AVG_AGENT_PAUSE_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-pause-time-historical">Average agent pause time</a> </p> </dd> <dt>AVG_CASE_RELATED_CONTACTS</dt> <dd> <p>Unit: Count</p> <p>Required filter key: CASE_TEMPLATE_ARN</p> <p>Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contacts-case-historical">Average contacts per case</a> </p> </dd> <dt>AVG_CASE_RESOLUTION_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Required filter key: CASE_TEMPLATE_ARN</p> <p>Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-case-resolution-time-historical">Average case resolution time</a> </p> </dd> <dt>AVG_CONTACT_DURATION</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-contact-duration-historical">Average contact duration</a> </p> <note> <p>Feature is a valid filter but not a valid grouping.</p> </note> </dd> <dt>AVG_CONVERSATION_DURATION</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-conversation-duration-historical">Average conversation duration</a> </p> </dd> <dt>AVG_DIALS_PER_MINUTE</dt> <dd> <p>This metric is available only for contacts analyzed by outbound campaigns analytics.</p> <p>Unit: Count</p> <p>Valid groupings and filters: Campaign, Agent, Queue, Routing Profile</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-dials-historical">Average dials per minute</a> </p> </dd> <dt>AVG_FLOW_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-flow-time-historical">Average flow time</a> </p> </dd> <dt>AVG_GREETING_TIME_AGENT</dt> <dd> <p>This metric is available only for contacts analyzed by Contact Lens conversational analytics.</p> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-greeting-time-agent-historical">Average agent greeting time</a> </p> </dd> <dt>AVG_HANDLE_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, RoutingStepExpression</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-handle-time-historical">Average handle time</a> </p> <note> <p>Feature is a valid filter but not a valid grouping.</p> </note> </dd> <dt>AVG_HOLD_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-customer-hold-time-historical">Average customer hold time</a> </p> <note> <p>Feature is a valid filter but not a valid grouping.</p> </note> </dd> <dt>AVG_HOLD_TIME_ALL_CONTACTS</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#avg-customer-hold-time-all-contacts-historical">Average customer hold time all contacts</a> </p> </dd> <dt>AVG_HOLDS</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-holds-historical">Average holds</a> </p> <note> <p>Feature is a valid filter but not a valid grouping.</p> </note> </dd> <dt>AVG_INTERACTION_AND_HOLD_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-customer-hold-time-historical">Average agent interaction and customer hold time</a> </p> </dd> <dt>AVG_INTERACTION_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid metric filter key: <code>INITIATION_METHOD</code> </p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-agent-interaction-time-historical">Average agent interaction time</a> </p> <note> <p>Feature is a valid filter but not a valid grouping.</p> </note> </dd> <dt>AVG_INTERRUPTIONS_AGENT</dt> <dd> <p>This metric is available only for contacts analyzed by Contact Lens conversational analytics.</p> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-agent-historical">Average agent interruptions</a> </p> </dd> <dt>AVG_INTERRUPTION_TIME_AGENT</dt> <dd> <p>This metric is available only for contacts analyzed by Contact Lens conversational analytics.</p> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-interruptions-time-agent-historical">Average agent interruption time</a> </p> </dd> <dt>AVG_NON_TALK_TIME</dt> <dd> <p>This metric is available only for contacts analyzed by Contact Lens conversational analytics.</p> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html##average-non-talk-time-historical">Average non-talk time</a> </p> </dd> <dt>AVG_QUEUE_ANSWER_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-queue-answer-time-historical">Average queue answer time</a> </p> <note> <p>Feature is a valid filter but not a valid grouping.</p> </note> </dd> <dt>AVG_RESOLUTION_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-resolution-time-historical">Average resolution time</a> </p> </dd> <dt>AVG_TALK_TIME</dt> <dd> <p>This metric is available only for contacts analyzed by Contact Lens conversational analytics.</p> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-historical">Average talk time</a> </p> </dd> <dt>AVG_TALK_TIME_AGENT</dt> <dd> <p>This metric is available only for contacts analyzed by Contact Lens conversational analytics.</p> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-agent-historical">Average agent talk time</a> </p> </dd> <dt>AVG_TALK_TIME_CUSTOMER</dt> <dd> <p>This metric is available only for contacts analyzed by Contact Lens conversational analytics.</p> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-talk-time-customer-historical">Average customer talk time</a> </p> </dd> <dt>AVG_WAIT_TIME_AFTER_CUSTOMER_CONNECTION</dt> <dd> <p>This metric is available only for contacts analyzed by outbound campaigns analytics.</p> <p>Unit: Seconds</p> <p>Valid groupings and filters: Campaign</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#average-wait-time-historical">Average wait time after customer connection</a> </p> </dd> <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X</dt> <dd> <p>This metric is available only for contacts analyzed by outbound campaigns analytics.</p> <p>Unit: Count</p> <p>Valid groupings and filters: Campaign, Agent </p> <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-historical">Campaign contacts abandoned after X</a> </p> </dd> <dt>CAMPAIGN_CONTACTS_ABANDONED_AFTER_X_RATE</dt> <dd> <p>This metric is available only for contacts analyzed by outbound campaigns analytics.</p> <p>Unit: Percent</p> <p>Valid groupings and filters: Campaign, Agent </p> <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>GT</code> (for <i>Greater than</i>).</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#campaign-contacts-abandoned-rate-historical">Campaign contacts abandoned after X rate</a> </p> </dd> <dt>CASES_CREATED</dt> <dd> <p>Unit: Count</p> <p>Required filter key: CASE_TEMPLATE_ARN</p> <p>Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-created-historical">Cases created</a> </p> </dd> <dt>CONTACTS_CREATED</dt> <dd> <p>Unit: Count</p> <p>Valid metric filter key: <code>INITIATION_METHOD</code> </p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-created-historical">Contacts created</a> </p> <note> <p>Feature is a valid filter but not a valid grouping.</p> </note> </dd> <dt>CONTACTS_HANDLED</dt> <dd> <p>Unit: Count</p> <p>Valid metric filter key: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code> </p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#api-contacts-handled-historical">API contacts handled</a> </p> <note> <p>Feature is a valid filter but not a valid grouping.</p> </note> </dd> <dt>CONTACTS_HANDLED_BY_CONNECTED_TO_AGENT</dt> <dd> <p>Unit: Count</p> <p>Valid metric filter key: <code>INITIATION_METHOD</code> </p> <p>Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical">Contacts handled (connected to agent timestamp)</a> </p> </dd> <dt>CONTACTS_HOLD_ABANDONS</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-handled-by-connected-to-agent-historical">Contacts hold disconnect</a> </p> </dd> <dt>CONTACTS_ON_HOLD_AGENT_DISCONNECT</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-agent-disconnect-historical">Contacts hold agent disconnect</a> </p> </dd> <dt>CONTACTS_ON_HOLD_CUSTOMER_DISCONNECT</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical">Contacts hold customer disconnect</a> </p> </dd> <dt>CONTACTS_PUT_ON_HOLD</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-hold-customer-disconnect-historical">Contacts put on hold</a> </p> </dd> <dt>CONTACTS_TRANSFERRED_OUT_EXTERNAL</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-external-historical">Contacts transferred out external</a> </p> </dd> <dt>CONTACTS_TRANSFERRED_OUT_INTERNAL</dt> <dd> <p>Unit: Percent</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-internal-historical">Contacts transferred out internal</a> </p> </dd> <dt>CONTACTS_QUEUED</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-historical">Contacts queued</a> </p> </dd> <dt>CONTACTS_QUEUED_BY_ENQUEUE</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-queued-by-enqueue-historical">Contacts queued (enqueue timestamp)</a> </p> </dd> <dt>CONTACTS_REMOVED_FROM_QUEUE_IN_X</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect</p> <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-removed-historical">Contacts removed from queue in X seconds</a> </p> </dd> <dt>CONTACTS_RESOLVED_IN_X</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>Threshold: For <code>ThresholdValue</code> enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than").</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-resolved-historical">Contacts resolved in X</a> </p> </dd> <dt>CONTACTS_TRANSFERRED_OUT</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Feature, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-historical">Contacts transferred out</a> </p> <note> <p>Feature is a valid filter but not a valid grouping.</p> </note> </dd> <dt>CONTACTS_TRANSFERRED_OUT_BY_AGENT</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical">Contacts transferred out by agent</a> </p> </dd> <dt>CONTACTS_TRANSFERRED_OUT_FROM_QUEUE</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-transferred-out-by-agent-historical">Contacts transferred out queue</a> </p> </dd> <dt>CURRENT_CASES</dt> <dd> <p>Unit: Count</p> <p>Required filter key: CASE_TEMPLATE_ARN</p> <p>Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#current-cases-historical">Current cases</a> </p> </dd> <dt>DELIVERY_ATTEMPTS</dt> <dd> <p>This metric is available only for contacts analyzed by outbound campaigns analytics.</p> <p>Unit: Count</p> <p>Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>, <code>DISCONNECT_REASON</code> </p> <p>Valid groupings and filters: Campaign, Agent, Queue, Routing Profile, Answering Machine Detection Status, Disconnect Reason</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempts-historical">Delivery attempts</a> </p> </dd> <dt>DELIVERY_ATTEMPT_DISPOSITION_RATE</dt> <dd> <p>This metric is available only for contacts analyzed by outbound campaigns analytics, and with the answering machine detection enabled.</p> <p>Unit: Percent</p> <p>Valid metric filter key: <code>ANSWERING_MACHINE_DETECTION_STATUS</code>, <code>DISCONNECT_REASON</code> </p> <p>Valid groupings and filters: Campaign, Agent, Answering Machine Detection Status, Disconnect Reason</p> <note> <p>Answering Machine Detection Status and Disconnect Reason are valid filters but not valid groupings.</p> </note> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#delivery-attempt-disposition-rate-historical">Delivery attempt disposition rate</a> </p> </dd> <dt>FLOWS_OUTCOME</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-historical">Flows outcome</a> </p> </dd> <dt>FLOWS_STARTED</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows resource ID, Initiation method, Resource published timestamp</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-started-historical">Flows started</a> </p> </dd> <dt>HUMAN_ANSWERED_CALLS</dt> <dd> <p>This metric is available only for contacts analyzed by outbound campaigns analytics, and with the answering machine detection enabled.</p> <p>Unit: Count</p> <p>Valid groupings and filters: Campaign, Agent</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#human-answered-historical">Human answered</a> </p> </dd> <dt>MAX_FLOW_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-flow-time-historical">Maximum flow time</a> </p> </dd> <dt>MAX_QUEUED_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#maximum-queued-time-historical">Maximum queued time</a> </p> </dd> <dt>MIN_FLOW_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#minimum-flow-time-historical">Minimum flow time</a> </p> </dd> <dt>PERCENT_CASES_FIRST_CONTACT_RESOLVED</dt> <dd> <p>Unit: Percent</p> <p>Required filter key: CASE_TEMPLATE_ARN</p> <p>Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-first-contact-historical">Cases resolved on first contact</a> </p> </dd> <dt>PERCENT_CONTACTS_STEP_EXPIRED</dt> <dd> <p>Unit: Percent</p> <p>Valid groupings and filters: Queue, RoutingStepExpression</p> <p>UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.</p> </dd> <dt>PERCENT_CONTACTS_STEP_JOINED</dt> <dd> <p>Unit: Percent</p> <p>Valid groupings and filters: Queue, RoutingStepExpression</p> <p>UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.</p> </dd> <dt>PERCENT_FLOWS_OUTCOME</dt> <dd> <p>Unit: Percent</p> <p>Valid metric filter key: <code>FLOWS_OUTCOME_TYPE</code> </p> <p>Valid groupings and filters: Channel, contact/segmentAttributes/connect:Subtype, Flow type, Flows module resource ID, Flows next resource ID, Flows next resource queue ID, Flows outcome type, Flows resource ID, Initiation method, Resource published timestamp</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#flows-outcome-percentage-historical">Flows outcome percentage</a>.</p> <note> <p>The <code>FLOWS_OUTCOME_TYPE</code> is not a valid grouping.</p> </note> </dd> <dt>PERCENT_NON_TALK_TIME</dt> <dd> <p>This metric is available only for contacts analyzed by Contact Lens conversational analytics.</p> <p>Unit: Percentage</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ntt-historical">Non-talk time percent</a> </p> </dd> <dt>PERCENT_TALK_TIME</dt> <dd> <p>This metric is available only for contacts analyzed by Contact Lens conversational analytics.</p> <p>Unit: Percentage</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#tt-historical">Talk time percent</a> </p> </dd> <dt>PERCENT_TALK_TIME_AGENT</dt> <dd> <p>This metric is available only for contacts analyzed by Contact Lens conversational analytics.</p> <p>Unit: Percentage</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttagent-historical">Agent talk time percent</a> </p> </dd> <dt>PERCENT_TALK_TIME_CUSTOMER</dt> <dd> <p>This metric is available only for contacts analyzed by Contact Lens conversational analytics.</p> <p>Unit: Percentage</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#ttcustomer-historical">Customer talk time percent</a> </p> </dd> <dt>REOPENED_CASE_ACTIONS</dt> <dd> <p>Unit: Count</p> <p>Required filter key: CASE_TEMPLATE_ARN</p> <p>Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-reopened-historical">Cases reopened</a> </p> </dd> <dt>RESOLVED_CASE_ACTIONS</dt> <dd> <p>Unit: Count</p> <p>Required filter key: CASE_TEMPLATE_ARN</p> <p>Valid groupings and filters: CASE_TEMPLATE_ARN, CASE_STATUS</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#cases-resolved-historical">Cases resolved</a> </p> </dd> <dt>SERVICE_LEVEL</dt> <dd> <p>You can include up to 20 SERVICE_LEVEL metrics in a request.</p> <p>Unit: Percent</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Q in Connect</p> <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than"). </p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#service-level-historical">Service level X</a> </p> </dd> <dt>STEP_CONTACTS_QUEUED</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, RoutingStepExpression</p> <p>UI name: This metric is available in Real-time Metrics UI but not on the Historical Metrics UI.</p> </dd> <dt>SUM_AFTER_CONTACT_WORK_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#acw-historical">After contact work time</a> </p> </dd> <dt>SUM_CONNECTING_TIME_AGENT</dt> <dd> <p>Unit: Seconds</p> <p>Valid metric filter key: <code>INITIATION_METHOD</code>. This metric only supports the following filter keys as <code>INITIATION_METHOD</code>: <code>INBOUND</code> | <code>OUTBOUND</code> | <code>CALLBACK</code> | <code>API</code> </p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#htm-agent-api-connecting-time">Agent API connecting time</a> </p> <note> <p>The <code>Negate</code> key in Metric Level Filters is not applicable for this metric.</p> </note> </dd> <dt>SUM_CONTACTS_ABANDONED</dt> <dd> <p>Unit: Count</p> <p>Metric filter: </p> <ul> <li> <p>Valid values: <code>API</code>| <code>Incoming</code> | <code>Outbound</code> | <code>Transfer</code> | <code>Callback</code> | <code>Queue_Transfer</code>| <code>Disconnect</code> </p> </li> </ul> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, RoutingStepExpression, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-historical">Contact abandoned</a> </p> </dd> <dt>SUM_CONTACTS_ABANDONED_IN_X</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than"). </p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-abandoned-x-historical">Contacts abandoned in X seconds</a> </p> </dd> <dt>SUM_CONTACTS_ANSWERED_IN_X</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>Threshold: For <code>ThresholdValue</code>, enter any whole number from 1 to 604800 (inclusive), in seconds. For <code>Comparison</code>, you must enter <code>LT</code> (for "Less than"). </p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contacts-answered-x-historical">Contacts answered in X seconds</a> </p> </dd> <dt>SUM_CONTACT_FLOW_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-flow-time-historical">Contact flow time</a> </p> </dd> <dt>SUM_CONTACT_TIME_AGENT</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-on-contact-time-historical">Agent on contact time</a> </p> </dd> <dt>SUM_CONTACTS_DISCONNECTED </dt> <dd> <p>Valid metric filter key: <code>DISCONNECT_REASON</code> </p> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-disconnected-historical">Contact disconnected</a> </p> </dd> <dt>SUM_ERROR_STATUS_TIME_AGENT</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#error-status-time-historical">Error status time</a> </p> </dd> <dt>SUM_HANDLE_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#contact-handle-time-historical">Contact handle time</a> </p> </dd> <dt>SUM_HOLD_TIME</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#customer-hold-time-historical">Customer hold time</a> </p> </dd> <dt>SUM_IDLE_TIME_AGENT</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-idle-time-historica">Agent idle time</a> </p> </dd> <dt>SUM_INTERACTION_AND_HOLD_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-hold-time-historical">Agent interaction and hold time</a> </p> </dd> <dt>SUM_INTERACTION_TIME</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, Agent, Agent Hierarchy</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#agent-interaction-time-historical">Agent interaction time</a> </p> </dd> <dt>SUM_NON_PRODUCTIVE_TIME_AGENT</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#npt-historical">Non-Productive Time</a> </p> </dd> <dt>SUM_ONLINE_TIME_AGENT</dt> <dd> <p>Unit: Seconds</p> <p>Valid groupings and filters: Routing Profile, Agent, Agent Hierarchy</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#online-time-historical">Online time</a> </p> </dd> <dt>SUM_RETRY_CALLBACK_ATTEMPTS</dt> <dd> <p>Unit: Count</p> <p>Valid groupings and filters: Queue, Channel, Routing Profile, contact/segmentAttributes/connect:Subtype, Q in Connect</p> <p>UI name: <a href="https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html#callback-attempts-historical">Callback attempts</a> </p> </dd> </dl>', ], ], 'MinutesLimit60' => [ 'base' => NULL, 'refs' => [ 'HoursOfOperationTimeSlice$Minutes' => '<p>The minutes.</p>', ], ], 'MonitorCapability' => [ 'base' => NULL, 'refs' => [ 'AllowedMonitorCapabilities$member' => NULL, ], ], 'MonitorContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'MonitorContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'Contact$Name' => '<p>The name of the contact.</p>', 'StartOutboundVoiceContactRequest$Name' => '<p>The name of a voice contact that is shown to an agent in the Contact Control Panel (CCP).</p>', 'StartTaskContactRequest$Name' => '<p>The name of a task that is shown to an agent in the Contact Control Panel (CCP).</p>', 'UpdateContactRequest$Name' => '<p>The name of the contact.</p>', ], ], 'Name128' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficDistributionGroupRequest$Name' => '<p>The name for the traffic distribution group. </p>', 'TrafficDistributionGroup$Name' => '<p>The name of the traffic distribution group.</p>', 'TrafficDistributionGroupSummary$Name' => '<p>The name of the traffic distribution group.</p>', ], ], 'Namespace' => [ 'base' => NULL, 'refs' => [ 'Application$Namespace' => '<p>Namespace of the application that you want to give access to.</p>', ], ], 'NewChatCreated' => [ 'base' => NULL, 'refs' => [ 'SendChatIntegrationEventResponse$NewChatCreated' => '<p>Whether handling the integration event resulted in creating a new chat or acting on existing chat.</p>', ], ], 'NewSessionDetails' => [ 'base' => '<p>Payload of chat properties to apply when starting a new contact.</p>', 'refs' => [ 'SendChatIntegrationEventRequest$NewSessionDetails' => '<p>Contact properties to apply when starting a new chat. If the integration event is handled with an existing chat, this is ignored.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetCurrentMetricDataRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p> <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>', 'GetCurrentMetricDataResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p> <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>', 'GetCurrentUserDataRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'GetCurrentUserDataResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'GetMetricDataRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'GetMetricDataResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p> <p>The token expires after 5 minutes from the time it is created. Subsequent requests that use the token must use the same request parameters as the request that generated the token.</p>', 'ListAgentStatusRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListAgentStatusResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListAnalyticsDataAssociationsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListAnalyticsDataAssociationsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListApprovedOriginsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListApprovedOriginsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListAuthenticationProfilesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListAuthenticationProfilesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListBotsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListBotsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListContactEvaluationsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p> <important> <p>This is not expected to be set because the value returned in the previous response is always null.</p> </important>', 'ListContactEvaluationsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p> <important> <p>This is always returned as null in the response.</p> </important>', 'ListContactFlowModulesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListContactFlowModulesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListContactFlowsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListContactFlowsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListContactReferencesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p> <important> <p>This is not expected to be set, because the value returned in the previous response is always null.</p> </important>', 'ListContactReferencesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p> <important> <p>This is always returned as null in the response.</p> </important>', 'ListEvaluationFormVersionsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListEvaluationFormVersionsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListEvaluationFormsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListEvaluationFormsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListFlowAssociationsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListFlowAssociationsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListHoursOfOperationsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListHoursOfOperationsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListInstanceAttributesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListInstanceAttributesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListInstanceStorageConfigsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListInstanceStorageConfigsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListInstancesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListInstancesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListIntegrationAssociationsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListIntegrationAssociationsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListLambdaFunctionsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListLambdaFunctionsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListLexBotsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListLexBotsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListPhoneNumbersRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListPhoneNumbersResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListPredefinedAttributesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListPredefinedAttributesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListPromptsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListPromptsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListQueueQuickConnectsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListQueueQuickConnectsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListQueuesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListQueuesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListQuickConnectsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListQuickConnectsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListRoutingProfileQueuesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListRoutingProfileQueuesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListRoutingProfilesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListRoutingProfilesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListRulesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListRulesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListSecurityKeysRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListSecurityKeysResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListSecurityProfileApplicationsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListSecurityProfileApplicationsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListSecurityProfilePermissionsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListSecurityProfilePermissionsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListSecurityProfilesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListSecurityProfilesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListTaskTemplatesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p> <important> <p>It is not expected that you set this because the value returned in the previous response is always null.</p> </important>', 'ListTaskTemplatesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p> <important> <p>This is always returned as a null in the response.</p> </important>', 'ListTrafficDistributionGroupUsersRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListTrafficDistributionGroupUsersResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListTrafficDistributionGroupsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListTrafficDistributionGroupsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListUseCasesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListUseCasesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListUserHierarchyGroupsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListUserHierarchyGroupsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListUserProficienciesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListUserProficienciesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'ListUsersRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListUsersResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', ], ], 'NextToken2500' => [ 'base' => NULL, 'refs' => [ 'GetMetricDataV2Request$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'GetMetricDataV2Response$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchAgentStatusesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchAgentStatusesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchContactFlowModulesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchContactFlowModulesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchContactFlowsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchContactFlowsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchHoursOfOperationsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchHoursOfOperationsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchPredefinedAttributesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchPredefinedAttributesResponse$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchPromptsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchPromptsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchQueuesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchQueuesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchQuickConnectsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchQuickConnectsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchResourceTagsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchResourceTagsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchRoutingProfilesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchRoutingProfilesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchSecurityProfilesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchSecurityProfilesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchUserHierarchyGroupsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchUserHierarchyGroupsResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchUsersRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchUsersResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', ], ], 'NotificationContentType' => [ 'base' => NULL, 'refs' => [ 'SendNotificationActionDefinition$ContentType' => '<p>Content type format.</p>', ], ], 'NotificationDeliveryType' => [ 'base' => NULL, 'refs' => [ 'SendNotificationActionDefinition$DeliveryMethod' => '<p>Notification delivery method.</p>', ], ], 'NotificationRecipientType' => [ 'base' => '<p>The type of notification recipient.</p>', 'refs' => [ 'SendNotificationActionDefinition$Recipient' => '<p>Notification recipient.</p>', ], ], 'NullableProficiencyLevel' => [ 'base' => NULL, 'refs' => [ 'AttributeCondition$ProficiencyLevel' => '<p>The proficiency level of the condition.</p>', ], ], 'NullableProficiencyLimitValue' => [ 'base' => NULL, 'refs' => [ 'NumberCondition$MinValue' => '<p>The minValue to be used while evaluating the number condition.</p>', 'NumberCondition$MaxValue' => '<p>The maxValue to be used while evaluating the number condition.</p>', ], ], 'NumberComparisonType' => [ 'base' => NULL, 'refs' => [ 'NumberCondition$ComparisonType' => '<p>The type of comparison to be made when evaluating the number condition.</p>', ], ], 'NumberCondition' => [ 'base' => '<p>A leaf node condition which can be used to specify a numeric condition.</p> <note> <p>The currently supported value for <code>FieldName</code> is <code>limit</code>.</p> </note>', 'refs' => [ 'Condition$NumberCondition' => '<p>A leaf node condition which can be used to specify a numeric condition.</p>', ], ], 'NumberReference' => [ 'base' => '<p>Information about a reference when the <code>referenceType</code> is <code>NUMBER</code>. Otherwise, null.</p>', 'refs' => [ 'ReferenceSummary$Number' => '<p>Information about a reference when the <code>referenceType</code> is <code>NUMBER</code>. Otherwise, null.</p>', ], ], 'NumericQuestionPropertyAutomationLabel' => [ 'base' => NULL, 'refs' => [ 'NumericQuestionPropertyValueAutomation$Label' => '<p>The property label of the automation.</p>', ], ], 'NumericQuestionPropertyValueAutomation' => [ 'base' => '<p>Information about the property value used in automation of a numeric questions. Label values are associated with minimum and maximum values for the numeric question.</p> <ul> <li> <p>Sentiment scores have a minimum value of -5 and maximum value of 5.</p> </li> <li> <p> Duration labels, such as <code>NON_TALK_TIME</code>, <code>CONTACT_DURATION</code>, <code>AGENT_INTERACTION_DURATION</code>, <code>CUSTOMER_HOLD_TIME</code> have a minimum value of 0 and maximum value of 28800.</p> </li> <li> <p>Percentages have a minimum value of 0 and maximum value of 100. </p> </li> <li> <p> <code>NUMBER_OF_INTERRUPTIONS</code> has a minimum value of 0 and maximum value of 1000.</p> </li> </ul>', 'refs' => [ 'EvaluationFormNumericQuestionAutomation$PropertyValue' => '<p>The property value of the automation.</p>', ], ], 'OperatingSystem' => [ 'base' => NULL, 'refs' => [ 'DeviceInfo$OperatingSystem' => '<p>Operating system that the participant used for the call.</p>', ], ], 'Origin' => [ 'base' => NULL, 'refs' => [ 'AssociateApprovedOriginRequest$Origin' => '<p>The domain to add to your allow list.</p>', 'DisassociateApprovedOriginRequest$Origin' => '<p>The domain URL of the integrated application.</p>', 'OriginsList$member' => NULL, ], ], 'OriginsList' => [ 'base' => NULL, 'refs' => [ 'ListApprovedOriginsResponse$Origins' => '<p>The approved origins.</p>', ], ], 'OutboundCallerConfig' => [ 'base' => '<p>The outbound caller ID name, number, and outbound whisper flow.</p>', 'refs' => [ 'CreateQueueRequest$OutboundCallerConfig' => '<p>The outbound caller ID name, number, and outbound whisper flow.</p>', 'Queue$OutboundCallerConfig' => '<p>The outbound caller ID name, number, and outbound whisper flow.</p>', 'UpdateQueueOutboundCallerConfigRequest$OutboundCallerConfig' => '<p>The outbound caller ID name, number, and outbound whisper flow.</p>', ], ], 'OutboundCallerIdName' => [ 'base' => NULL, 'refs' => [ 'OutboundCallerConfig$OutboundCallerIdName' => '<p>The caller ID name.</p>', ], ], 'OutboundCallsEnabled' => [ 'base' => NULL, 'refs' => [ 'CreateInstanceRequest$OutboundCallsEnabled' => '<p>Your contact center allows outbound calls.</p>', 'Instance$OutboundCallsEnabled' => '<p>Whether outbound calls are enabled.</p>', 'InstanceSummary$OutboundCallsEnabled' => '<p>Whether outbound calls are enabled.</p>', ], ], 'OutboundContactNotPermittedException' => [ 'base' => '<p>The contact is not permitted.</p>', 'refs' => [], ], 'OutputTypeNotFoundException' => [ 'base' => '<p>Thrown for analyzed content when requested OutputType was not enabled for a given contact. For example, if an OutputType.Raw was requested for a contact that had `RedactedOnly` Redaction policy set in Contact flow.</p>', 'refs' => [], ], 'PEM' => [ 'base' => NULL, 'refs' => [ 'AssociateSecurityKeyRequest$Key' => '<p>A valid security key in PEM format.</p>', 'SecurityKey$Key' => '<p>The key of the security key.</p>', ], ], 'ParticipantCapabilities' => [ 'base' => '<p>The configuration for the allowed capabilities for participants present over the call.</p>', 'refs' => [ 'AgentInfo$Capabilities' => NULL, 'AllowedCapabilities$Customer' => '<p>Information about the customer\'s video sharing capabilities.</p>', 'AllowedCapabilities$Agent' => '<p>Information about the agent\'s video sharing capabilities.</p>', 'Customer$Capabilities' => NULL, ], ], 'ParticipantDetails' => [ 'base' => '<p>The customer\'s details.</p>', 'refs' => [ 'NewSessionDetails$ParticipantDetails' => NULL, 'StartChatContactRequest$ParticipantDetails' => '<p>Information identifying the participant.</p>', 'StartWebRTCContactRequest$ParticipantDetails' => NULL, ], ], 'ParticipantDetailsToAdd' => [ 'base' => '<p>The details to add for the participant.</p>', 'refs' => [ 'CreateParticipantRequest$ParticipantDetails' => '<p>Information identifying the participant.</p> <important> <p>The only Valid value for <code>ParticipantRole</code> is <code>CUSTOM_BOT</code>. </p> <p> <code>DisplayName</code> is <b>Required</b>.</p> </important>', ], ], 'ParticipantId' => [ 'base' => NULL, 'refs' => [ 'CreateParticipantResponse$ParticipantId' => '<p>The identifier for a chat participant. The participantId for a chat participant is the same throughout the chat lifecycle.</p>', 'RealTimeContactAnalysisSegmentAttachments$ParticipantId' => '<p>The identifier of the participant.</p>', 'RealTimeContactAnalysisSegmentEvent$ParticipantId' => '<p>The identifier of the participant.</p>', 'RealTimeContactAnalysisSegmentTranscript$ParticipantId' => '<p>The identifier of the participant.</p>', 'StartChatContactResponse$ParticipantId' => '<p>The identifier for a chat participant. The participantId for a chat participant is the same throughout the chat lifecycle.</p>', 'StartWebRTCContactResponse$ParticipantId' => '<p>The identifier for a contact participant. The <code>ParticipantId</code> for a contact participant is the same throughout the contact lifecycle.</p>', ], ], 'ParticipantRole' => [ 'base' => NULL, 'refs' => [ 'ParticipantDetailsToAdd$ParticipantRole' => '<p>The role of the participant being added.</p>', 'RealTimeContactAnalysisSegmentAttachments$ParticipantRole' => '<p>The role of the participant. For example, is it a customer, agent, or system.</p>', 'RealTimeContactAnalysisSegmentEvent$ParticipantRole' => '<p>The role of the participant. For example, is it a customer, agent, or system.</p>', 'RealTimeContactAnalysisSegmentTranscript$ParticipantRole' => '<p>The role of the participant. For example, is it a customer, agent, or system.</p>', 'TranscriptCriteria$ParticipantRole' => '<p>The participant role in a transcript</p>', ], ], 'ParticipantTimerAction' => [ 'base' => NULL, 'refs' => [ 'ParticipantTimerValue$ParticipantTimerAction' => '<p>The timer action. Currently only one value is allowed: <code>Unset</code>. It deletes a timer.</p>', ], ], 'ParticipantTimerConfigList' => [ 'base' => NULL, 'refs' => [ 'ChatParticipantRoleConfig$ParticipantTimerConfigList' => '<p>A list of participant timers. You can specify any unique combination of role and timer type. Duplicate entries error out the request with a 400.</p>', ], ], 'ParticipantTimerConfiguration' => [ 'base' => '<p>Configuration information for the timer. After the timer configuration is set, it persists for the duration of the chat. It persists across new contacts in the chain, for example, transfer contacts.</p> <p>For more information about how chat timeouts work, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-chat-timeouts.html">Set up chat timeouts for human participants</a>. </p>', 'refs' => [ 'ParticipantTimerConfigList$member' => NULL, ], ], 'ParticipantTimerDurationInMinutes' => [ 'base' => NULL, 'refs' => [ 'ParticipantTimerValue$ParticipantTimerDurationInMinutes' => '<p>The duration of a timer, in minutes. </p>', ], ], 'ParticipantTimerType' => [ 'base' => NULL, 'refs' => [ 'ParticipantTimerConfiguration$TimerType' => '<p>The type of timer. <code>IDLE</code> indicates the timer applies for considering a human chat participant as idle. <code>DISCONNECT_NONCUSTOMER</code> indicates the timer applies to automatically disconnecting a chat participant due to idleness.</p>', ], ], 'ParticipantTimerValue' => [ 'base' => '<p>The value of the timer. Either the timer action (<code>Unset</code> to delete the timer), or the duration of the timer in minutes. Only one value can be set.</p> <p>For more information about how chat timeouts work, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/setup-chat-timeouts.html">Set up chat timeouts for human participants</a>. </p>', 'refs' => [ 'ParticipantTimerConfiguration$TimerValue' => '<p>The value of the timer. Either the timer action (Unset to delete the timer), or the duration of the timer in minutes. Only one value can be set.</p>', ], ], 'ParticipantToken' => [ 'base' => NULL, 'refs' => [ 'ParticipantTokenCredentials$ParticipantToken' => '<p>The token used by the chat participant to call <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant. </p>', 'StartChatContactResponse$ParticipantToken' => '<p>The token used by the chat participant to call <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a>. The participant token is valid for the lifetime of a chat participant.</p>', 'StartWebRTCContactResponse$ParticipantToken' => '<p>The token used by the contact participant to call the <a href="https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html">CreateParticipantConnection</a> API. The participant token is valid for the lifetime of a contact participant.</p>', ], ], 'ParticipantTokenCredentials' => [ 'base' => '<p>The credentials used by the participant.</p>', 'refs' => [ 'CreateParticipantResponse$ParticipantCredentials' => '<p>The token used by the chat participant to call <code>CreateParticipantConnection</code>. The participant token is valid for the lifetime of a chat participant.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Password' => '<p>The password for the user account. A password is required if you are using Amazon Connect for identity management. Otherwise, it is an error to include a password.</p>', ], ], 'PauseContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'PauseContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'Distribution$Percentage' => '<p>The percentage of the traffic that is distributed, in increments of 10.</p>', ], ], 'Permission' => [ 'base' => NULL, 'refs' => [ 'ApplicationPermissions$member' => NULL, ], ], 'PermissionsList' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$Permissions' => '<p>Permissions assigned to the security profile. For a list of valid permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a>. </p>', 'ListSecurityProfilePermissionsResponse$Permissions' => '<p>The permissions granted to the security profile. For a complete list of valid permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a>.</p>', 'UpdateSecurityProfileRequest$Permissions' => '<p>The permissions granted to a security profile. For a list of valid permissions, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html">List of security profile permissions</a>.</p>', ], ], 'PersistentChat' => [ 'base' => '<p>Enable persistent chats. For more information about enabling persistent chat, and for example use cases and how to configure for them, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent chat</a>.</p>', 'refs' => [ 'StartChatContactRequest$PersistentChat' => '<p>Enable persistent chats. For more information about enabling persistent chat, and for example use cases and how to configure for them, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html">Enable persistent chat</a>.</p>', ], ], 'PhoneNumber' => [ 'base' => NULL, 'refs' => [ 'AvailableNumberSummary$PhoneNumber' => '<p>The phone number. Phone numbers are formatted <code>[+] [country code] [subscriber number including area code]</code>.</p>', 'ClaimPhoneNumberRequest$PhoneNumber' => '<p>The phone number you want to claim. Phone numbers are formatted <code>[+] [country code] [subscriber number including area code]</code>.</p>', 'ClaimedPhoneNumberSummary$PhoneNumber' => '<p>The phone number. Phone numbers are formatted <code>[+] [country code] [subscriber number including area code]</code>.</p>', 'ListPhoneNumbersSummary$PhoneNumber' => '<p>The phone number. Phone numbers are formatted <code>[+] [country code] [subscriber number including area code]</code>.</p>', 'PhoneNumberQuickConnectConfig$PhoneNumber' => '<p>The phone number in E.164 format.</p>', 'PhoneNumberSummary$PhoneNumber' => '<p>The phone number.</p>', 'StartOutboundVoiceContactRequest$DestinationPhoneNumber' => '<p>The phone number of the customer, in E.164 format.</p>', 'StartOutboundVoiceContactRequest$SourcePhoneNumber' => '<p>The phone number associated with the Amazon Connect instance, in E.164 format. If you do not specify a source phone number, you must specify a queue.</p>', 'UserIdentityInfo$Mobile' => '<p>The user\'s mobile number.</p>', 'UserPhoneConfig$DeskPhoneNumber' => '<p>The phone number for the user\'s desk phone.</p>', ], ], 'PhoneNumberCountryCode' => [ 'base' => NULL, 'refs' => [ 'AvailableNumberSummary$PhoneNumberCountryCode' => '<p>The ISO country code.</p>', 'ClaimedPhoneNumberSummary$PhoneNumberCountryCode' => '<p>The ISO country code.</p>', 'ListPhoneNumbersSummary$PhoneNumberCountryCode' => '<p>The ISO country code.</p>', 'PhoneNumberCountryCodes$member' => NULL, 'PhoneNumberSummary$PhoneNumberCountryCode' => '<p>The ISO country code.</p>', 'SearchAvailablePhoneNumbersRequest$PhoneNumberCountryCode' => '<p>The ISO country code.</p>', ], ], 'PhoneNumberCountryCodes' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersRequest$PhoneNumberCountryCodes' => '<p>The ISO country code.</p>', 'ListPhoneNumbersV2Request$PhoneNumberCountryCodes' => '<p>The ISO country code.</p>', ], ], 'PhoneNumberDescription' => [ 'base' => NULL, 'refs' => [ 'ClaimPhoneNumberRequest$PhoneNumberDescription' => '<p>The description of the phone number.</p>', 'ClaimedPhoneNumberSummary$PhoneNumberDescription' => '<p>The description of the phone number.</p>', 'ImportPhoneNumberRequest$PhoneNumberDescription' => '<p>The description of the phone number.</p>', 'ListPhoneNumbersSummary$PhoneNumberDescription' => '<p>The description of the phone number.</p>', 'UpdatePhoneNumberMetadataRequest$PhoneNumberDescription' => '<p>The description of the phone number.</p>', ], ], 'PhoneNumberId' => [ 'base' => NULL, 'refs' => [ 'AssociatePhoneNumberContactFlowRequest$PhoneNumberId' => '<p>A unique identifier for the phone number.</p>', 'ClaimPhoneNumberResponse$PhoneNumberId' => '<p>A unique identifier for the phone number.</p>', 'ClaimedPhoneNumberSummary$PhoneNumberId' => '<p>A unique identifier for the phone number.</p>', 'DescribePhoneNumberRequest$PhoneNumberId' => '<p>A unique identifier for the phone number.</p>', 'DisassociatePhoneNumberContactFlowRequest$PhoneNumberId' => '<p>A unique identifier for the phone number.</p>', 'ImportPhoneNumberResponse$PhoneNumberId' => '<p>A unique identifier for the phone number.</p>', 'ListPhoneNumbersSummary$PhoneNumberId' => '<p>A unique identifier for the phone number.</p>', 'OutboundCallerConfig$OutboundCallerIdNumberId' => '<p>The caller ID number.</p>', 'PhoneNumberSummary$Id' => '<p>The identifier of the phone number.</p>', 'ReleasePhoneNumberRequest$PhoneNumberId' => '<p>A unique identifier for the phone number.</p>', 'UpdatePhoneNumberMetadataRequest$PhoneNumberId' => '<p>The Amazon Resource Name (ARN) or resource ID of the phone number.</p>', 'UpdatePhoneNumberRequest$PhoneNumberId' => '<p>A unique identifier for the phone number.</p>', 'UpdatePhoneNumberResponse$PhoneNumberId' => '<p>A unique identifier for the phone number.</p>', ], ], 'PhoneNumberPrefix' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersV2Request$PhoneNumberPrefix' => '<p>The prefix of the phone number. If provided, it must contain <code>+</code> as part of the country code.</p>', 'SearchAvailablePhoneNumbersRequest$PhoneNumberPrefix' => '<p>The prefix of the phone number. If provided, it must contain <code>+</code> as part of the country code.</p>', ], ], 'PhoneNumberQuickConnectConfig' => [ 'base' => '<p>Contains information about a phone number for a quick connect.</p>', 'refs' => [ 'QuickConnectConfig$PhoneConfig' => '<p>The phone configuration. This is required only if QuickConnectType is PHONE_NUMBER.</p>', ], ], 'PhoneNumberStatus' => [ 'base' => '<p>The status of the phone number.</p> <ul> <li> <p> <code>CLAIMED</code> means the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html">ClaimPhoneNumber</a> or <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html">UpdatePhoneNumber</a> operation succeeded.</p> </li> <li> <p> <code>IN_PROGRESS</code> means a <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html">ClaimPhoneNumber</a>, <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html">UpdatePhoneNumber</a>, or <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumberMetadata.html">UpdatePhoneNumberMetadata</a> operation is still in progress and has not yet completed. You can call <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html">DescribePhoneNumber</a> at a later time to verify if the previous operation has completed.</p> </li> <li> <p> <code>FAILED</code> indicates that the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html">ClaimPhoneNumber</a> or <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html">UpdatePhoneNumber</a> operation has failed. It will include a message indicating the failure reason. A common reason for a failure may be that the <code>TargetArn</code> value you are claiming or updating a phone number to has reached its limit of total claimed numbers. If you received a <code>FAILED</code> status from a <code>ClaimPhoneNumber</code> API call, you have one day to retry claiming the phone number before the number is released back to the inventory for other customers to claim.</p> </li> </ul>', 'refs' => [ 'ClaimedPhoneNumberSummary$PhoneNumberStatus' => '<p>The status of the phone number.</p> <ul> <li> <p> <code>CLAIMED</code> means the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html">ClaimPhoneNumber</a> or <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html">UpdatePhoneNumber</a> operation succeeded.</p> </li> <li> <p> <code>IN_PROGRESS</code> means a <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html">ClaimPhoneNumber</a>, <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html">UpdatePhoneNumber</a>, or <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumberMetadata.html">UpdatePhoneNumberMetadata</a> operation is still in progress and has not yet completed. You can call <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html">DescribePhoneNumber</a> at a later time to verify if the previous operation has completed.</p> </li> <li> <p> <code>FAILED</code> indicates that the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html">ClaimPhoneNumber</a> or <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html">UpdatePhoneNumber</a> operation has failed. It will include a message indicating the failure reason. A common reason for a failure may be that the <code>TargetArn</code> value you are claiming or updating a phone number to has reached its limit of total claimed numbers. If you received a <code>FAILED</code> status from a <code>ClaimPhoneNumber</code> API call, you have one day to retry claiming the phone number before the number is released back to the inventory for other customers to claim.</p> </li> </ul> <note> <p>You will not be billed for the phone number during the 1-day period if number claiming fails. </p> </note>', ], ], 'PhoneNumberSummary' => [ 'base' => '<p>Contains summary information about a phone number for a contact center.</p>', 'refs' => [ 'PhoneNumberSummaryList$member' => NULL, ], ], 'PhoneNumberSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersResponse$PhoneNumberSummaryList' => '<p>Information about the phone numbers.</p>', ], ], 'PhoneNumberType' => [ 'base' => NULL, 'refs' => [ 'AvailableNumberSummary$PhoneNumberType' => '<p>The type of phone number.</p>', 'ClaimedPhoneNumberSummary$PhoneNumberType' => '<p>The type of phone number.</p>', 'ListPhoneNumbersSummary$PhoneNumberType' => '<p>The type of phone number.</p>', 'PhoneNumberSummary$PhoneNumberType' => '<p>The type of phone number.</p>', 'PhoneNumberTypes$member' => NULL, 'SearchAvailablePhoneNumbersRequest$PhoneNumberType' => '<p>The type of phone number.</p>', ], ], 'PhoneNumberTypes' => [ 'base' => NULL, 'refs' => [ 'ListPhoneNumbersRequest$PhoneNumberTypes' => '<p>The type of phone number.</p> <note> <p>We recommend using <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html">ListPhoneNumbersV2</a> to return phone number types. While ListPhoneNumbers returns number types <code>UIFN</code>, <code>SHARED</code>, <code>THIRD_PARTY_TF</code>, and <code>THIRD_PARTY_DID</code>, it incorrectly lists them as <code>TOLL_FREE</code> or <code>DID</code>. </p> </note>', 'ListPhoneNumbersV2Request$PhoneNumberTypes' => '<p>The type of phone number.</p>', ], ], 'PhoneNumberWorkflowMessage' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberStatus$Message' => '<p>The status message.</p>', ], ], 'PhoneNumberWorkflowStatus' => [ 'base' => NULL, 'refs' => [ 'PhoneNumberStatus$Status' => '<p>The status.</p>', ], ], 'PhoneType' => [ 'base' => NULL, 'refs' => [ 'UserPhoneConfig$PhoneType' => '<p>The phone type.</p>', ], ], 'PlatformName' => [ 'base' => NULL, 'refs' => [ 'DeviceInfo$PlatformName' => '<p>Name of the platform that the participant used for the call.</p>', ], ], 'PlatformVersion' => [ 'base' => NULL, 'refs' => [ 'DeviceInfo$PlatformVersion' => '<p>Version of the platform that the participant used for the call.</p>', ], ], 'PotentialAudioQualityIssue' => [ 'base' => NULL, 'refs' => [ 'PotentialAudioQualityIssues$member' => NULL, ], ], 'PotentialAudioQualityIssues' => [ 'base' => NULL, 'refs' => [ 'AudioQualityMetricsInfo$PotentialQualityIssues' => '<p>List of potential issues causing degradation of quality on a media connection. If the service did not detect any potential quality issues the list is empty.</p> <p>Valid values: <code>HighPacketLoss</code> | <code>HighRoundTripTime</code> | <code>HighJitterBuffer</code> </p>', ], ], 'PotentialDisconnectIssue' => [ 'base' => NULL, 'refs' => [ 'DisconnectDetails$PotentialDisconnectIssue' => '<p>Indicates the potential disconnection issues for a call. This field is not populated if the service does not detect potential issues.</p>', ], ], 'PredefinedAttribute' => [ 'base' => '<p>Information about a predefined attribute.</p>', 'refs' => [ 'DescribePredefinedAttributeResponse$PredefinedAttribute' => '<p>Information about the predefined attribute.</p>', 'PredefinedAttributeSearchSummaryList$member' => NULL, ], ], 'PredefinedAttributeName' => [ 'base' => NULL, 'refs' => [ 'AttributeCondition$Name' => '<p>The name of predefined attribute.</p>', 'CreatePredefinedAttributeRequest$Name' => '<p> The name of the predefined attribute. </p>', 'DeletePredefinedAttributeRequest$Name' => '<p> The name of the predefined attribute.</p>', 'DescribePredefinedAttributeRequest$Name' => '<p>The name of the predefined attribute.</p>', 'PredefinedAttribute$Name' => '<p>The name of the predefined attribute.</p>', 'PredefinedAttributeSummary$Name' => '<p>The name of the predefined attribute.</p>', 'UpdatePredefinedAttributeRequest$Name' => '<p>The name of the predefined attribute.</p>', 'UserProficiency$AttributeName' => '<p>The name of user\'s proficiency. You must use name of predefined attribute present in the Amazon Connect instance.</p>', 'UserProficiencyDisassociate$AttributeName' => '<p>The name of user\'s proficiency.</p>', ], ], 'PredefinedAttributeSearchConditionList' => [ 'base' => NULL, 'refs' => [ 'PredefinedAttributeSearchCriteria$OrConditions' => '<p>A list of conditions which would be applied together with an <code>OR</code> condition.</p>', 'PredefinedAttributeSearchCriteria$AndConditions' => '<p>A list of conditions which would be applied together with an <code>AND</code> condition.</p>', ], ], 'PredefinedAttributeSearchCriteria' => [ 'base' => '<p>The search criteria to be used to return predefined attributes.</p>', 'refs' => [ 'PredefinedAttributeSearchConditionList$member' => NULL, 'SearchPredefinedAttributesRequest$SearchCriteria' => '<p>The search criteria to be used to return predefined attributes.</p>', ], ], 'PredefinedAttributeSearchSummaryList' => [ 'base' => NULL, 'refs' => [ 'SearchPredefinedAttributesResponse$PredefinedAttributes' => '<p>Predefined attributes matched by the search criteria.</p>', ], ], 'PredefinedAttributeStringValue' => [ 'base' => NULL, 'refs' => [ 'PredefinedAttributeStringValuesList$member' => NULL, 'UserProficiency$AttributeValue' => '<p>The value of user\'s proficiency. You must use value of predefined attribute present in the Amazon Connect instance.</p>', 'UserProficiencyDisassociate$AttributeValue' => '<p>The value of user\'s proficiency.</p>', ], ], 'PredefinedAttributeStringValuesList' => [ 'base' => NULL, 'refs' => [ 'PredefinedAttributeValues$StringList' => '<p>Predefined attribute values of type string list.</p>', ], ], 'PredefinedAttributeSummary' => [ 'base' => '<p>Summary of a predefined attribute.</p>', 'refs' => [ 'PredefinedAttributeSummaryList$member' => NULL, ], ], 'PredefinedAttributeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPredefinedAttributesResponse$PredefinedAttributeSummaryList' => '<p>Summary of the predefined attributes.</p>', ], ], 'PredefinedAttributeValues' => [ 'base' => '<p>Information about values of a predefined attribute.</p>', 'refs' => [ 'CreatePredefinedAttributeRequest$Values' => '<p> The values of the predefined attribute. </p>', 'PredefinedAttribute$Values' => '<p>The values of the predefined attribute.</p>', 'UpdatePredefinedAttributeRequest$Values' => '<p>The values of the predefined attribute.</p>', ], ], 'Prefix' => [ 'base' => NULL, 'refs' => [ 'KinesisVideoStreamConfig$Prefix' => '<p>The prefix of the video stream.</p>', 'S3Config$BucketPrefix' => '<p>The S3 bucket prefix.</p>', ], ], 'Priority' => [ 'base' => NULL, 'refs' => [ 'RoutingProfileQueueConfig$Priority' => '<p>The order in which contacts are to be handled for the queue. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and delay</a>.</p>', 'RoutingProfileQueueConfigSummary$Priority' => '<p>The order in which contacts are to be handled for the queue. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing-profiles-priority.html">Queues: priority and delay</a>.</p>', ], ], 'ProblemDetail' => [ 'base' => '<p>Information about a problem detail.</p>', 'refs' => [ 'Problems$member' => NULL, ], ], 'ProblemMessageString' => [ 'base' => NULL, 'refs' => [ 'ProblemDetail$message' => '<p>The problem detail\'s message.</p>', ], ], 'Problems' => [ 'base' => NULL, 'refs' => [ 'InvalidContactFlowException$problems' => '<p>The problems with the flow. Please fix before trying again.</p>', 'InvalidContactFlowModuleException$Problems' => NULL, ], ], 'ProficiencyLevel' => [ 'base' => NULL, 'refs' => [ 'UserProficiency$Level' => '<p>The level of the proficiency. The valid values are 1, 2, 3, 4 and 5.</p>', ], ], 'ProficiencyValue' => [ 'base' => NULL, 'refs' => [ 'AttributeCondition$Value' => '<p>The value of predefined attribute.</p>', ], ], 'Prompt' => [ 'base' => '<p>Information about a prompt.</p>', 'refs' => [ 'DescribePromptResponse$Prompt' => '<p>Information about the prompt.</p>', 'PromptList$member' => NULL, ], ], 'PromptDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePromptRequest$Description' => '<p>The description of the prompt.</p>', 'Prompt$Description' => '<p>The description of the prompt.</p>', 'UpdatePromptRequest$Description' => '<p>A description of the prompt.</p>', ], ], 'PromptId' => [ 'base' => NULL, 'refs' => [ 'CreatePromptResponse$PromptId' => '<p>A unique identifier for the prompt.</p>', 'DeletePromptRequest$PromptId' => '<p>A unique identifier for the prompt.</p>', 'DescribePromptRequest$PromptId' => '<p>A unique identifier for the prompt.</p>', 'GetPromptFileRequest$PromptId' => '<p>A unique identifier for the prompt.</p>', 'Prompt$PromptId' => '<p>A unique identifier for the prompt.</p>', 'PromptSummary$Id' => '<p>The identifier of the prompt.</p>', 'UpdatePromptRequest$PromptId' => '<p>A unique identifier for the prompt.</p>', 'UpdatePromptResponse$PromptId' => '<p>A unique identifier for the prompt.</p>', ], ], 'PromptList' => [ 'base' => NULL, 'refs' => [ 'SearchPromptsResponse$Prompts' => '<p>Information about the prompts.</p>', ], ], 'PromptName' => [ 'base' => NULL, 'refs' => [ 'PromptSummary$Name' => '<p>The name of the prompt.</p>', ], ], 'PromptPresignedUrl' => [ 'base' => NULL, 'refs' => [ 'GetPromptFileResponse$PromptPresignedUrl' => '<p>A generated URL to the prompt that can be given to an unauthorized user so they can access the prompt in S3.</p>', ], ], 'PromptSearchConditionList' => [ 'base' => NULL, 'refs' => [ 'PromptSearchCriteria$OrConditions' => '<p>A list of conditions which would be applied together with an OR condition.</p>', 'PromptSearchCriteria$AndConditions' => '<p>A list of conditions which would be applied together with an AND condition.</p>', ], ], 'PromptSearchCriteria' => [ 'base' => '<p>The search criteria to be used to return prompts.</p>', 'refs' => [ 'PromptSearchConditionList$member' => NULL, 'SearchPromptsRequest$SearchCriteria' => '<p>The search criteria to be used to return prompts.</p>', ], ], 'PromptSearchFilter' => [ 'base' => '<p>Filters to be applied to search results.</p>', 'refs' => [ 'SearchPromptsRequest$SearchFilter' => '<p>Filters to be applied to search results.</p>', ], ], 'PromptSummary' => [ 'base' => '<p>Contains information about the prompt.</p>', 'refs' => [ 'PromptSummaryList$member' => NULL, ], ], 'PromptSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListPromptsResponse$PromptSummaryList' => '<p>Information about the prompts.</p>', ], ], 'PropertyValidationException' => [ 'base' => '<p>The property is not valid.</p>', 'refs' => [], ], 'PropertyValidationExceptionProperty' => [ 'base' => '<p>Contains information about why a property is not valid.</p>', 'refs' => [ 'PropertyValidationExceptionPropertyList$member' => NULL, ], ], 'PropertyValidationExceptionPropertyList' => [ 'base' => NULL, 'refs' => [ 'PropertyValidationException$PropertyList' => NULL, ], ], 'PropertyValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'PropertyValidationExceptionProperty$Reason' => '<p>Why the property is not valid.</p>', ], ], 'PutUserStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutUserStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'QualityMetrics' => [ 'base' => '<p>Information about the quality of the participant\'s media connection.</p>', 'refs' => [ 'Contact$QualityMetrics' => '<p>Information about the quality of the participant\'s media connection.</p>', ], ], 'Queue' => [ 'base' => '<p>Contains information about a queue.</p>', 'refs' => [ 'DescribeQueueResponse$Queue' => '<p>The name of the queue.</p>', 'QueueSearchSummaryList$member' => NULL, ], ], 'QueueDescription' => [ 'base' => NULL, 'refs' => [ 'CreateQueueRequest$Description' => '<p>The description of the queue.</p>', 'Queue$Description' => '<p>The description of the queue.</p>', 'UpdateQueueNameRequest$Description' => '<p>The description of the queue.</p>', ], ], 'QueueId' => [ 'base' => NULL, 'refs' => [ 'AssociateQueueQuickConnectsRequest$QueueId' => '<p>The identifier for the queue.</p>', 'AssociatedQueueIdList$member' => NULL, 'ContactDataRequest$QueueId' => '<p>The identifier of the queue associated with the Amazon Connect instance in which contacts that are created will be queued.</p>', 'ContactSearchSummaryQueueInfo$Id' => '<p>The unique identifier for the queue.</p>', 'CreateQueueResponse$QueueId' => '<p>The identifier for the queue.</p>', 'CreateRoutingProfileRequest$DefaultOutboundQueueId' => '<p>The default outbound queue for the routing profile.</p>', 'DeleteQueueRequest$QueueId' => '<p>The identifier for the queue.</p>', 'DescribeQueueRequest$QueueId' => '<p>The identifier for the queue.</p>', 'DisassociateQueueQuickConnectsRequest$QueueId' => '<p>The identifier for the queue.</p>', 'ListQueueQuickConnectsRequest$QueueId' => '<p>The identifier for the queue.</p>', 'Queue$QueueId' => '<p>The identifier for the queue.</p>', 'QueueIdList$member' => NULL, 'QueueInfo$Id' => '<p>The unique identifier for the queue.</p>', 'QueueQuickConnectConfig$QueueId' => '<p>The identifier for the queue.</p>', 'QueueReference$Id' => '<p>The identifier of the queue.</p>', 'QueueSummary$Id' => '<p>The identifier of the queue.</p>', 'Queues$member' => NULL, 'RoutingProfile$DefaultOutboundQueueId' => '<p>The identifier of the default outbound queue for this routing profile.</p>', 'RoutingProfileQueueConfigSummary$QueueId' => '<p>The identifier for the queue.</p>', 'RoutingProfileQueueReference$QueueId' => '<p>The identifier for the queue.</p>', 'StartOutboundVoiceContactRequest$QueueId' => '<p>The queue for the call. If you specify a queue, the phone displayed for caller ID is the phone number specified in the queue. If you do not specify a queue, the queue defined in the flow is used. If you do not specify a queue, you must specify a source phone number.</p>', 'TransferContactRequest$QueueId' => '<p>The identifier for the queue.</p>', 'UpdateQueueHoursOfOperationRequest$QueueId' => '<p>The identifier for the queue.</p>', 'UpdateQueueMaxContactsRequest$QueueId' => '<p>The identifier for the queue.</p>', 'UpdateQueueNameRequest$QueueId' => '<p>The identifier for the queue.</p>', 'UpdateQueueOutboundCallerConfigRequest$QueueId' => '<p>The identifier for the queue.</p>', 'UpdateQueueStatusRequest$QueueId' => '<p>The identifier for the queue.</p>', 'UpdateRoutingProfileDefaultOutboundQueueRequest$DefaultOutboundQueueId' => '<p>The identifier for the default outbound queue.</p>', ], ], 'QueueIdList' => [ 'base' => NULL, 'refs' => [ 'SearchCriteria$QueueIds' => '<p>The list of queue IDs associated with contacts.</p>', ], ], 'QueueInfo' => [ 'base' => '<p>If this contact was queued, this contains information about the queue. </p>', 'refs' => [ 'Contact$QueueInfo' => '<p>If this contact was queued, this contains information about the queue. </p>', ], ], 'QueueMaxContacts' => [ 'base' => NULL, 'refs' => [ 'CreateQueueRequest$MaxContacts' => '<p>The maximum number of contacts that can be in the queue before it is considered full.</p>', 'Queue$MaxContacts' => '<p>The maximum number of contacts that can be in the queue before it is considered full.</p>', 'UpdateQueueMaxContactsRequest$MaxContacts' => '<p>The maximum number of contacts that can be in the queue before it is considered full.</p>', ], ], 'QueueName' => [ 'base' => NULL, 'refs' => [ 'QueueSummary$Name' => '<p>The name of the queue.</p>', 'RoutingProfileQueueConfigSummary$QueueName' => '<p>The name of the queue.</p>', ], ], 'QueuePriority' => [ 'base' => NULL, 'refs' => [ 'Contact$QueuePriority' => '<p>An integer that represents the queue priority to be applied to the contact (lower priorities are routed preferentially). Cannot be specified if the QueueTimeAdjustmentSeconds is specified. Must be statically defined, must be larger than zero, and a valid integer value. Default Value is 5.</p>', 'UpdateContactRoutingDataRequest$QueuePriority' => '<p>Priority of the contact in the queue. The default priority for new contacts is 5. You can raise the priority of a contact compared to other contacts in the queue by assigning them a higher priority, such as 1 or 2.</p>', ], ], 'QueueQuickConnectConfig' => [ 'base' => '<p>Contains information about a queue for a quick connect. The flow must be of type Transfer to Queue.</p>', 'refs' => [ 'QuickConnectConfig$QueueConfig' => '<p>The queue configuration. This is required only if QuickConnectType is QUEUE.</p>', ], ], 'QueueReference' => [ 'base' => '<p>Contains information about a queue resource for which metrics are returned.</p>', 'refs' => [ 'AgentContactReference$Queue' => NULL, 'Dimensions$Queue' => '<p>Information about the queue for which metrics are returned.</p>', ], ], 'QueueSearchConditionList' => [ 'base' => NULL, 'refs' => [ 'QueueSearchCriteria$OrConditions' => '<p>A list of conditions which would be applied together with an OR condition.</p>', 'QueueSearchCriteria$AndConditions' => '<p>A list of conditions which would be applied together with an AND condition.</p>', ], ], 'QueueSearchCriteria' => [ 'base' => '<p>The search criteria to be used to return queues.</p> <note> <p>The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2 characters and a maximum of 25 characters. Any queries with character lengths outside of this range will throw invalid results. </p> </note>', 'refs' => [ 'QueueSearchConditionList$member' => NULL, 'SearchQueuesRequest$SearchCriteria' => '<p>The search criteria to be used to return queues.</p> <note> <p>The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2 characters and a maximum of 25 characters. Any queries with character lengths outside of this range will throw invalid results. </p> </note>', ], ], 'QueueSearchFilter' => [ 'base' => '<p>Filters to be applied to search results.</p>', 'refs' => [ 'SearchQueuesRequest$SearchFilter' => '<p>Filters to be applied to search results.</p>', ], ], 'QueueSearchSummaryList' => [ 'base' => NULL, 'refs' => [ 'SearchQueuesResponse$Queues' => '<p>Information about the queues.</p>', ], ], 'QueueStatus' => [ 'base' => NULL, 'refs' => [ 'Queue$Status' => '<p>The status of the queue.</p>', 'UpdateQueueStatusRequest$Status' => '<p>The status of the queue.</p>', ], ], 'QueueSummary' => [ 'base' => '<p>Contains summary information about a queue.</p>', 'refs' => [ 'QueueSummaryList$member' => NULL, ], ], 'QueueSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListQueuesResponse$QueueSummaryList' => '<p>Information about the queues.</p>', ], ], 'QueueTimeAdjustmentSeconds' => [ 'base' => NULL, 'refs' => [ 'Contact$QueueTimeAdjustmentSeconds' => '<p>An integer that represents the queue time adjust to be applied to the contact, in seconds (longer / larger queue time are routed preferentially). Cannot be specified if the QueuePriority is specified. Must be statically defined and a valid integer value.</p>', 'UpdateContactRoutingDataRequest$QueueTimeAdjustmentSeconds' => '<p>The number of seconds to add or subtract from the contact\'s routing age. Contacts are routed to agents on a first-come, first-serve basis. This means that changing their amount of time in queue compared to others also changes their position in queue.</p>', ], ], 'QueueType' => [ 'base' => NULL, 'refs' => [ 'QueueSummary$QueueType' => '<p>The type of queue.</p>', 'QueueTypes$member' => NULL, ], ], 'QueueTypes' => [ 'base' => NULL, 'refs' => [ 'ListQueuesRequest$QueueTypes' => '<p>The type of queue.</p>', ], ], 'Queues' => [ 'base' => NULL, 'refs' => [ 'Filters$Queues' => '<p>The queues to use to filter the metrics. You should specify at least one queue, and can specify up to 100 queues per request. The <code>GetCurrentMetricsData</code> API in particular requires a queue when you include a <code>Filter</code> in your request. </p>', 'UserDataFilters$Queues' => '<p>A list of up to 100 queues or ARNs.</p>', ], ], 'QuickConnect' => [ 'base' => '<p>Contains information about a quick connect.</p>', 'refs' => [ 'DescribeQuickConnectResponse$QuickConnect' => '<p>Information about the quick connect.</p>', 'QuickConnectSearchSummaryList$member' => NULL, ], ], 'QuickConnectConfig' => [ 'base' => '<p>Contains configuration settings for a quick connect.</p>', 'refs' => [ 'CreateQuickConnectRequest$QuickConnectConfig' => '<p>Configuration settings for the quick connect.</p>', 'QuickConnect$QuickConnectConfig' => '<p>Contains information about the quick connect.</p>', 'UpdateQuickConnectConfigRequest$QuickConnectConfig' => '<p>Information about the configuration settings for the quick connect.</p>', ], ], 'QuickConnectDescription' => [ 'base' => NULL, 'refs' => [ 'CreateQuickConnectRequest$Description' => '<p>The description of the quick connect.</p>', 'QuickConnect$Description' => '<p>The description.</p>', ], ], 'QuickConnectId' => [ 'base' => NULL, 'refs' => [ 'CreateQuickConnectResponse$QuickConnectId' => '<p>The identifier for the quick connect. </p>', 'DeleteQuickConnectRequest$QuickConnectId' => '<p>The identifier for the quick connect.</p>', 'DescribeQuickConnectRequest$QuickConnectId' => '<p>The identifier for the quick connect.</p>', 'QuickConnect$QuickConnectId' => '<p>The identifier for the quick connect.</p>', 'QuickConnectSummary$Id' => '<p>The identifier for the quick connect.</p>', 'QuickConnectsList$member' => NULL, 'StartTaskContactRequest$QuickConnectId' => '<p>The identifier for the quick connect. Tasks that are created by using <code>QuickConnectId</code> will use the flow that is defined on agent or queue quick connect. For more information about quick connects, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/quick-connects.html">Create quick connects</a>.</p>', 'UpdateQuickConnectConfigRequest$QuickConnectId' => '<p>The identifier for the quick connect.</p>', 'UpdateQuickConnectNameRequest$QuickConnectId' => '<p>The identifier for the quick connect.</p>', ], ], 'QuickConnectName' => [ 'base' => NULL, 'refs' => [ 'CreateQuickConnectRequest$Name' => '<p>A unique name of the quick connect.</p>', 'QuickConnect$Name' => '<p>The name of the quick connect.</p>', 'QuickConnectSummary$Name' => '<p>The name of the quick connect.</p>', 'UpdateQuickConnectNameRequest$Name' => '<p>The name of the quick connect.</p>', ], ], 'QuickConnectSearchConditionList' => [ 'base' => NULL, 'refs' => [ 'QuickConnectSearchCriteria$OrConditions' => '<p>A list of conditions which would be applied together with an OR condition.</p>', 'QuickConnectSearchCriteria$AndConditions' => '<p>A list of conditions which would be applied together with an AND condition.</p>', ], ], 'QuickConnectSearchCriteria' => [ 'base' => '<p>The search criteria to be used to return quick connects.</p>', 'refs' => [ 'QuickConnectSearchConditionList$member' => NULL, 'SearchQuickConnectsRequest$SearchCriteria' => '<p>The search criteria to be used to return quick connects.</p>', ], ], 'QuickConnectSearchFilter' => [ 'base' => '<p>Filters to be applied to search results.</p>', 'refs' => [ 'SearchQuickConnectsRequest$SearchFilter' => '<p>Filters to be applied to search results.</p>', ], ], 'QuickConnectSearchSummaryList' => [ 'base' => NULL, 'refs' => [ 'SearchQuickConnectsResponse$QuickConnects' => '<p>Information about the quick connects.</p>', ], ], 'QuickConnectSummary' => [ 'base' => '<p>Contains summary information about a quick connect.</p>', 'refs' => [ 'QuickConnectSummaryList$member' => NULL, ], ], 'QuickConnectSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListQueueQuickConnectsResponse$QuickConnectSummaryList' => '<p>Information about the quick connects.</p>', 'ListQuickConnectsResponse$QuickConnectSummaryList' => '<p>Information about the quick connects.</p>', ], ], 'QuickConnectType' => [ 'base' => NULL, 'refs' => [ 'QuickConnectConfig$QuickConnectType' => '<p>The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE). </p>', 'QuickConnectSummary$QuickConnectType' => '<p>The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>', 'QuickConnectTypes$member' => NULL, ], ], 'QuickConnectTypes' => [ 'base' => NULL, 'refs' => [ 'ListQuickConnectsRequest$QuickConnectTypes' => '<p>The type of quick connect. In the Amazon Connect admin website, when you create a quick connect, you are prompted to assign one of the following types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).</p>', ], ], 'QuickConnectsList' => [ 'base' => NULL, 'refs' => [ 'AssociateQueueQuickConnectsRequest$QuickConnectIds' => '<p>The quick connects to associate with this queue.</p>', 'CreateQueueRequest$QuickConnectIds' => '<p>The quick connects available to agents who are working the queue.</p>', 'DisassociateQueueQuickConnectsRequest$QuickConnectIds' => '<p>The quick connects to disassociate from the queue.</p>', ], ], 'ReadOnlyFieldInfo' => [ 'base' => '<p>Indicates a field that is read-only to an agent.</p>', 'refs' => [ 'ReadOnlyTaskTemplateFields$member' => NULL, ], ], 'ReadOnlyTaskTemplateFields' => [ 'base' => NULL, 'refs' => [ 'TaskTemplateConstraints$ReadOnlyFields' => '<p>Lists the fields that are read-only to agents, and cannot be edited.</p>', ], ], 'RealTimeContactAnalysisAttachment' => [ 'base' => '<p>Object that describes attached file. </p>', 'refs' => [ 'RealTimeContactAnalysisAttachments$member' => NULL, ], ], 'RealTimeContactAnalysisAttachments' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisSegmentAttachments$Attachments' => '<p>List of objects describing an individual attachment.</p>', ], ], 'RealTimeContactAnalysisCategoryDetails' => [ 'base' => '<p>Provides information about the category rule that was matched.</p>', 'refs' => [ 'RealTimeContactAnalysisMatchedDetails$value' => NULL, ], ], 'RealTimeContactAnalysisCategoryName' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisMatchedDetails$key' => NULL, ], ], 'RealTimeContactAnalysisCharacterInterval' => [ 'base' => '<p>Begin and end offsets for a part of text.</p>', 'refs' => [ 'RealTimeContactAnalysisCharacterIntervals$member' => NULL, 'RealTimeContactAnalysisTranscriptItemWithCharacterOffsets$CharacterOffsets' => '<p>List of character intervals within transcript content/text.</p>', 'RealTimeContactAnalysisTranscriptItemWithContent$CharacterOffsets' => NULL, ], ], 'RealTimeContactAnalysisCharacterIntervals' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisTranscriptItemRedaction$CharacterOffsets' => '<p>List of character intervals each describing a part of the text that was redacted. For <code>OutputType.Raw</code>, part of the original text that contains data that can be redacted. For <code> OutputType.Redacted</code>, part of the string with redaction tag.</p>', ], ], 'RealTimeContactAnalysisContentType' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisSegmentTranscript$ContentType' => '<p>The type of content of the item. For example, <code>text/plain</code>.</p>', ], ], 'RealTimeContactAnalysisEventType' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisSegmentEvent$EventType' => '<p>Type of the event. For example, <code>application/vnd.amazonaws.connect.event.participant.left</code>.</p>', ], ], 'RealTimeContactAnalysisId256' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisSegmentAttachments$Id' => '<p>The identifier of the segment.</p>', 'RealTimeContactAnalysisSegmentEvent$Id' => '<p>The identifier of the contact event.</p>', 'RealTimeContactAnalysisSegmentTranscript$Id' => '<p>The identifier of the transcript.</p>', 'RealTimeContactAnalysisTranscriptItemWithCharacterOffsets$Id' => '<p>Transcript identifier. Matches the identifier from one of the TranscriptSegments.</p>', 'RealTimeContactAnalysisTranscriptItemWithContent$Id' => '<p>Transcript identifier. Matches the identifier from one of the TranscriptSegments.</p>', ], ], 'RealTimeContactAnalysisIssueDetected' => [ 'base' => '<p>Potential issues that are detected based on an artificial intelligence analysis of each turn in the conversation.</p>', 'refs' => [ 'RealTimeContactAnalysisIssuesDetected$member' => NULL, ], ], 'RealTimeContactAnalysisIssuesDetected' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisSegmentIssues$IssuesDetected' => '<p>List of the issues detected.</p>', ], ], 'RealTimeContactAnalysisMatchedDetails' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisSegmentCategories$MatchedDetails' => '<p>Map between the name of the matched rule and RealTimeContactAnalysisCategoryDetails.</p>', ], ], 'RealTimeContactAnalysisOffset' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisCharacterInterval$BeginOffsetChar' => '<p>The beginning of the character interval.</p>', 'RealTimeContactAnalysisCharacterInterval$EndOffsetChar' => '<p>The end of the character interval.</p>', ], ], 'RealTimeContactAnalysisOutputType' => [ 'base' => NULL, 'refs' => [ 'ListRealtimeContactAnalysisSegmentsV2Request$OutputType' => '<p>The Contact Lens output type to be returned.</p>', ], ], 'RealTimeContactAnalysisPointOfInterest' => [ 'base' => '<p>The section of the contact transcript segment that category rule was detected.</p>', 'refs' => [ 'RealTimeContactAnalysisPointsOfInterest$member' => NULL, ], ], 'RealTimeContactAnalysisPointsOfInterest' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisCategoryDetails$PointsOfInterest' => '<p>List of PointOfInterest - objects describing a single match of a rule.</p>', ], ], 'RealTimeContactAnalysisPostContactSummaryContent' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisSegmentPostContactSummary$Content' => '<p>The content of the summary.</p>', ], ], 'RealTimeContactAnalysisPostContactSummaryFailureCode' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisSegmentPostContactSummary$FailureCode' => '<p>If the summary failed to be generated, one of the following failure codes occurs:</p> <ul> <li> <p> <code>QUOTA_EXCEEDED</code>: The number of concurrent analytics jobs reached your service quota.</p> </li> <li> <p> <code>INSUFFICIENT_CONVERSATION_CONTENT</code>: The conversation needs to have at least one turn from both the participants in order to generate the summary.</p> </li> <li> <p> <code>FAILED_SAFETY_GUIDELINES</code>: The generated summary cannot be provided because it failed to meet system safety guidelines.</p> </li> <li> <p> <code>INVALID_ANALYSIS_CONFIGURATION</code>: This code occurs when, for example, you\'re using a <a href="https://docs.aws.amazon.com/connect/latest/adminguide/supported-languages.html#supported-languages-contact-lens">language</a> that isn\'t supported by generative AI-powered post-contact summaries. </p> </li> <li> <p> <code>INTERNAL_ERROR</code>: Internal system error.</p> </li> </ul>', ], ], 'RealTimeContactAnalysisPostContactSummaryStatus' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisSegmentPostContactSummary$Status' => '<p>Whether the summary was successfully COMPLETED or FAILED to be generated.</p>', ], ], 'RealTimeContactAnalysisSegmentAttachments' => [ 'base' => '<p>Segment containing list of attachments.</p>', 'refs' => [ 'RealtimeContactAnalysisSegment$Attachments' => '<p>The analyzed attachments.</p>', ], ], 'RealTimeContactAnalysisSegmentCategories' => [ 'base' => '<p>The matched category rules.</p>', 'refs' => [ 'RealtimeContactAnalysisSegment$Categories' => NULL, ], ], 'RealTimeContactAnalysisSegmentEvent' => [ 'base' => '<p>Segment type describing a contact event.</p>', 'refs' => [ 'RealtimeContactAnalysisSegment$Event' => NULL, ], ], 'RealTimeContactAnalysisSegmentIssues' => [ 'base' => '<p>Segment type containing a list of detected issues.</p>', 'refs' => [ 'RealtimeContactAnalysisSegment$Issues' => NULL, ], ], 'RealTimeContactAnalysisSegmentPostContactSummary' => [ 'base' => '<p>Information about the post-contact summary for a real-time contact segment.</p>', 'refs' => [ 'RealtimeContactAnalysisSegment$PostContactSummary' => '<p>Information about the post-contact summary.</p>', ], ], 'RealTimeContactAnalysisSegmentTranscript' => [ 'base' => '<p>The analyzed transcript segment.</p>', 'refs' => [ 'RealtimeContactAnalysisSegment$Transcript' => NULL, ], ], 'RealTimeContactAnalysisSegmentType' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisSegmentTypes$member' => NULL, ], ], 'RealTimeContactAnalysisSegmentTypes' => [ 'base' => NULL, 'refs' => [ 'ListRealtimeContactAnalysisSegmentsV2Request$SegmentTypes' => '<p>Enum with segment types . Each value corresponds to a segment type returned in the segments list of the API. Each segment type has its own structure. Different channels may have different sets of supported segment types.</p>', ], ], 'RealTimeContactAnalysisSentimentLabel' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisSegmentTranscript$Sentiment' => '<p>The sentiment detected for this piece of transcript.</p>', ], ], 'RealTimeContactAnalysisStatus' => [ 'base' => NULL, 'refs' => [ 'ListRealtimeContactAnalysisSegmentsV2Response$Status' => '<p>Status of real-time contact analysis.</p>', ], ], 'RealTimeContactAnalysisSupportedChannel' => [ 'base' => NULL, 'refs' => [ 'ListRealtimeContactAnalysisSegmentsV2Response$Channel' => '<p>The channel of the contact. <code>Voice</code> will not be returned. </p>', ], ], 'RealTimeContactAnalysisTimeData' => [ 'base' => '<p>Object describing time with which the segment is associated. It can have different representations of time. Currently supported: absoluteTime</p>', 'refs' => [ 'RealTimeContactAnalysisSegmentAttachments$Time' => '<p>Field describing the time of the event. It can have different representations of time.</p>', 'RealTimeContactAnalysisSegmentEvent$Time' => '<p>Field describing the time of the event. It can have different representations of time.</p>', 'RealTimeContactAnalysisSegmentTranscript$Time' => '<p>Field describing the time of the event. It can have different representations of time.</p>', ], ], 'RealTimeContactAnalysisTimeInstant' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisTimeData$AbsoluteTime' => '<p>Time represented in ISO 8601 format: yyyy-MM-ddThh:mm:ss.SSSZ. For example, 2019-11-08T02:41:28.172Z.</p>', ], ], 'RealTimeContactAnalysisTranscriptContent' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisSegmentTranscript$Content' => '<p>The content of the transcript. Can be redacted.</p>', 'RealTimeContactAnalysisTranscriptItemWithContent$Content' => '<p>Part of the transcript content that contains identified issue. Can be redacted</p>', ], ], 'RealTimeContactAnalysisTranscriptItemRedaction' => [ 'base' => '<p>Object describing redaction applied to the segment.</p>', 'refs' => [ 'RealTimeContactAnalysisSegmentTranscript$Redaction' => '<p>Object describing redaction that was applied to the transcript. If transcript has the field it means part of the transcript was redacted.</p>', ], ], 'RealTimeContactAnalysisTranscriptItemWithCharacterOffsets' => [ 'base' => '<p>Transcript representation containing Id and list of character intervals that are associated with analysis data. For example, this object within a <code>RealTimeContactAnalysisPointOfInterest</code> in <code>Category.MatchedDetails</code> would have character interval describing part of the text that matched category.</p>', 'refs' => [ 'RealTimeContactAnalysisTranscriptItemsWithCharacterOffsets$member' => NULL, ], ], 'RealTimeContactAnalysisTranscriptItemWithContent' => [ 'base' => '<p>Transcript representation containing Id, Content and list of character intervals that are associated with analysis data. For example, this object within an issue detected would describe both content that contains identified issue and intervals where that content is taken from.</p>', 'refs' => [ 'RealTimeContactAnalysisTranscriptItemsWithContent$member' => NULL, ], ], 'RealTimeContactAnalysisTranscriptItemsWithCharacterOffsets' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisPointOfInterest$TranscriptItems' => '<p>List of the transcript items (segments) that are associated with a given point of interest. </p>', ], ], 'RealTimeContactAnalysisTranscriptItemsWithContent' => [ 'base' => NULL, 'refs' => [ 'RealTimeContactAnalysisIssueDetected$TranscriptItems' => '<p>List of the transcript items (segments) that are associated with a given issue.</p>', ], ], 'RealtimeContactAnalysisSegment' => [ 'base' => '<p>An analyzed segment for a real-time analysis session.</p>', 'refs' => [ 'RealtimeContactAnalysisSegments$member' => NULL, ], ], 'RealtimeContactAnalysisSegments' => [ 'base' => NULL, 'refs' => [ 'ListRealtimeContactAnalysisSegmentsV2Response$Segments' => '<p>An analyzed transcript or category.</p>', ], ], 'Reference' => [ 'base' => '<p>Well-formed data on a contact, used by agents to complete a contact request. You can have up to 4,096 UTF-8 bytes across all references for a contact.</p>', 'refs' => [ 'ContactReferences$value' => NULL, ], ], 'ReferenceId' => [ 'base' => NULL, 'refs' => [ 'EvaluationFormQuestion$RefId' => '<p>The identifier of the question. An identifier must be unique within the evaluation form.</p>', 'EvaluationFormSection$RefId' => '<p>The identifier of the section. An identifier must be unique within the evaluation form.</p>', 'EvaluationFormSingleSelectQuestionAutomation$DefaultOptionRefId' => '<p>The identifier of the default answer option, when none of the automation options match the criteria.</p>', 'EvaluationFormSingleSelectQuestionOption$RefId' => '<p>The identifier of the answer option. An identifier must be unique within the question.</p>', 'SingleSelectQuestionRuleCategoryAutomation$OptionRefId' => '<p>The identifier of the answer option.</p>', ], ], 'ReferenceKey' => [ 'base' => NULL, 'refs' => [ 'AttachmentReference$Name' => '<p>Identifier of the attachment reference.</p>', 'ContactReferences$key' => NULL, 'DateReference$Name' => '<p>Identifier of the date reference.</p>', 'EmailReference$Name' => '<p>Identifier of the email reference.</p>', 'NumberReference$Name' => '<p>Identifier of the number reference.</p>', 'StringReference$Name' => '<p>Identifier of the string reference.</p>', 'UrlReference$Name' => '<p>Identifier of the URL reference.</p>', ], ], 'ReferenceStatus' => [ 'base' => NULL, 'refs' => [ 'AttachmentReference$Status' => '<p>Status of the attachment reference type.</p>', ], ], 'ReferenceSummary' => [ 'base' => '<p>Contains summary information about a reference. <code>ReferenceSummary</code> contains only one non null field between the URL and attachment based on the reference type.</p>', 'refs' => [ 'ReferenceSummaryList$member' => NULL, ], ], 'ReferenceSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListContactReferencesResponse$ReferenceSummaryList' => '<p>Information about the flows.</p>', ], ], 'ReferenceType' => [ 'base' => NULL, 'refs' => [ 'Reference$Type' => '<p>The type of the reference. <code>DATE</code> must be of type Epoch timestamp. </p>', 'ReferenceTypes$member' => NULL, ], ], 'ReferenceTypes' => [ 'base' => NULL, 'refs' => [ 'ListContactReferencesRequest$ReferenceTypes' => '<p>The type of reference.</p>', ], ], 'ReferenceValue' => [ 'base' => NULL, 'refs' => [ 'AttachmentReference$Value' => '<p>The location path of the attachment reference.</p>', 'DateReference$Value' => '<p>A valid date.</p>', 'EmailReference$Value' => '<p>A valid email address.</p>', 'NumberReference$Value' => '<p>A valid number.</p>', 'Reference$Value' => '<p>A valid value for the reference. For example, for a URL reference, a formatted URL that is displayed to an agent in the Contact Control Panel (CCP).</p>', 'StringReference$Value' => '<p>A valid string.</p>', 'UrlReference$Value' => '<p>A valid URL.</p>', ], ], 'RefreshTokenDuration' => [ 'base' => NULL, 'refs' => [ 'AuthenticationProfile$MaxSessionDuration' => '<p>The long lived session duration for users logged in to Amazon Connect, in minutes. After this time period, users must log in again. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/authentication-profiles.html#configure-session-timeouts">Configure the session duration</a> in the <i>Amazon Connect Administrator Guide</i>.</p>', ], ], 'RegionName' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'AgentStatusSummary$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'AuthenticationProfile$LastModifiedRegion' => '<p>The Amazon Web Services Region where the authentication profile was last modified.</p>', 'AuthenticationProfileSummary$LastModifiedRegion' => '<p>The Amazon Web Services Region when the authentication profile summary was last modified.</p>', 'GetPromptFileResponse$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'HierarchyGroup$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'HierarchyGroupSummary$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'HierarchyLevel$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'HoursOfOperation$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'HoursOfOperationSummary$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'ListQueueQuickConnectsResponse$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'ListRoutingProfileQueuesResponse$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'ListSecurityProfileApplicationsResponse$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'ListSecurityProfilePermissionsResponse$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'ListUserProficienciesResponse$LastModifiedRegion' => '<p>The region in which a user\'s proficiencies were last modified.</p>', 'PredefinedAttribute$LastModifiedRegion' => '<p>Last modified region.</p>', 'PredefinedAttributeSummary$LastModifiedRegion' => '<p>Last modified region.</p>', 'Prompt$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'PromptSummary$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'Queue$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'QueueSummary$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'QuickConnect$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'QuickConnectSummary$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'RoutingProfile$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'RoutingProfileSummary$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'SecurityProfile$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'SecurityProfileSummary$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'User$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', 'UserSummary$LastModifiedRegion' => '<p>The Amazon Web Services Region where this resource was last modified.</p>', ], ], 'RehydrationType' => [ 'base' => NULL, 'refs' => [ 'CreatePersistentContactAssociationRequest$RehydrationType' => '<p>The contactId chosen for rehydration depends on the type chosen.</p> <ul> <li> <p> <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact of the specified past ended chat session. To use this type, provide the <code>initialContactId</code> of the past ended chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect determines what the most recent chat contact on the past ended chat session and uses it to start a persistent chat. </p> </li> <li> <p> <code>FROM_SEGMENT</code>: Rehydrates a chat from the specified past chat contact provided in the <code>sourceContactId</code> field. </p> </li> </ul> <p>The actual contactId used for rehydration is provided in the response of this API.</p> <p>To illustrate how to use rehydration type, consider the following example: A customer starts a chat session. Agent a1 accepts the chat and a conversation starts between the customer and Agent a1. This first contact creates a contact ID <b>C1</b>. Agent a1 then transfers the chat to Agent a2. This creates another contact ID <b>C2</b>. At this point Agent a2 ends the chat. The customer is forwarded to the disconnect flow for a post chat survey that creates another contact ID <b>C3</b>. After the chat survey, the chat session ends. Later, the customer returns and wants to resume their past chat session. At this point, the customer can have following use cases: </p> <ul> <li> <p> <b>Use Case 1</b>: The customer wants to continue the past chat session but they want to hide the post chat survey. For this they will use the following configuration:</p> <ul> <li> <p> <b>Configuration</b> </p> <ul> <li> <p>SourceContactId = "C2"</p> </li> <li> <p>RehydrationType = "FROM_SEGMENT"</p> </li> </ul> </li> <li> <p> <b>Expected behavior</b> </p> <ul> <li> <p>This starts a persistent chat session from the specified past ended contact (C2). Transcripts of past chat sessions C2 and C1 are accessible in the current persistent chat session. Note that chat segment C3 is dropped from the persistent chat session.</p> </li> </ul> </li> </ul> </li> <li> <p> <b>Use Case 2</b>: The customer wants to continue the past chat session and see the transcript of the entire past engagement, including the post chat survey. For this they will use the following configuration:</p> <ul> <li> <p> <b>Configuration</b> </p> <ul> <li> <p>SourceContactId = "C1"</p> </li> <li> <p>RehydrationType = "ENTIRE_PAST_SESSION"</p> </li> </ul> </li> <li> <p> <b>Expected behavior</b> </p> <ul> <li> <p>This starts a persistent chat session from the most recently ended chat contact (C3). Transcripts of past chat sessions C3, C2 and C1 are accessible in the current persistent chat session.</p> </li> </ul> </li> </ul> </li> </ul>', 'PersistentChat$RehydrationType' => '<p>The contactId that is used for rehydration depends on the rehydration type. RehydrationType is required for persistent chat. </p> <ul> <li> <p> <code>ENTIRE_PAST_SESSION</code>: Rehydrates a chat from the most recently terminated past chat contact of the specified past ended chat session. To use this type, provide the <code>initialContactId</code> of the past ended chat session in the <code>sourceContactId</code> field. In this type, Amazon Connect determines the most recent chat contact on the specified chat session that has ended, and uses it to start a persistent chat. </p> </li> <li> <p> <code>FROM_SEGMENT</code>: Rehydrates a chat from the past chat contact that is specified in the <code>sourceContactId</code> field. </p> </li> </ul> <p>The actual contactId used for rehydration is provided in the response of this API. </p>', ], ], 'ReleasePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReplicateInstanceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ReplicateInstanceResponse' => [ 'base' => NULL, 'refs' => [], ], 'RequestIdentifier' => [ 'base' => NULL, 'refs' => [ 'ContactDataRequest$RequestIdentifier' => '<p>Identifier to uniquely identify individual requests in the batch.</p>', 'FailedRequest$RequestIdentifier' => '<p>Request identifier provided in the API call in the ContactDataRequest to create a contact.</p>', 'SuccessfulRequest$RequestIdentifier' => '<p>Request identifier provided in the API call in the ContactDataRequest to create a contact.</p>', ], ], 'RequiredFieldInfo' => [ 'base' => '<p>Information about a required field.</p>', 'refs' => [ 'RequiredTaskTemplateFields$member' => NULL, ], ], 'RequiredTaskTemplateFields' => [ 'base' => NULL, 'refs' => [ 'TaskTemplateConstraints$RequiredFields' => '<p>Lists the fields that are required to be filled by agents.</p>', ], ], 'ResourceArnOrId' => [ 'base' => NULL, 'refs' => [ 'FilterV2$FilterKey' => '<p>The key to use for filtering data. For example, <code>QUEUE</code>, <code>ROUTING_PROFILE, AGENT</code>, <code>CHANNEL</code>, <code>AGENT_HIERARCHY_LEVEL_ONE</code>, <code>AGENT_HIERARCHY_LEVEL_TWO</code>, <code>AGENT_HIERARCHY_LEVEL_THREE</code>, <code>AGENT_HIERARCHY_LEVEL_FOUR</code>, <code>AGENT_HIERARCHY_LEVEL_FIVE</code>. There must be at least 1 key and a maximum 5 keys. </p>', 'FilterValueList$member' => NULL, 'ThresholdV2$Comparison' => '<p>The type of comparison. Only "less than" (LT) and "greater than" (GT) comparisons are supported.</p>', ], ], 'ResourceConflictException' => [ 'base' => '<p>A resource already has that name.</p>', 'refs' => [], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ActivateEvaluationFormRequest$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'ActivateEvaluationFormResponse$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'CreateEvaluationFormResponse$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'DeactivateEvaluationFormRequest$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'DeactivateEvaluationFormResponse$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'DeleteContactEvaluationRequest$EvaluationId' => '<p>A unique identifier for the contact evaluation.</p>', 'DeleteEvaluationFormRequest$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'DescribeContactEvaluationRequest$EvaluationId' => '<p>A unique identifier for the contact evaluation.</p>', 'DescribeEvaluationFormRequest$EvaluationFormId' => '<p>A unique identifier for the contact evaluation.</p>', 'Evaluation$EvaluationId' => '<p>A unique identifier for the contact evaluation.</p>', 'EvaluationAnswersInputMap$key' => NULL, 'EvaluationAnswersOutputMap$key' => NULL, 'EvaluationForm$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'EvaluationFormContent$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'EvaluationFormSummary$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'EvaluationFormVersionSummary$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'EvaluationMetadata$ContactAgentId' => '<p>The identifier of the agent who performed the contact.</p>', 'EvaluationNotesMap$key' => NULL, 'EvaluationScoresMap$key' => NULL, 'EvaluationSummary$EvaluationId' => '<p>A unique identifier for the contact evaluation.</p>', 'EvaluationSummary$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'ListEvaluationFormVersionsRequest$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'StartContactEvaluationRequest$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'StartContactEvaluationResponse$EvaluationId' => '<p>A unique identifier for the contact evaluation.</p>', 'SubmitContactEvaluationRequest$EvaluationId' => '<p>A unique identifier for the contact evaluation.</p>', 'SubmitContactEvaluationResponse$EvaluationId' => '<p>A unique identifier for the contact evaluation.</p>', 'UpdateContactEvaluationRequest$EvaluationId' => '<p>A unique identifier for the contact evaluation.</p>', 'UpdateContactEvaluationResponse$EvaluationId' => '<p>A unique identifier for the contact evaluation.</p>', 'UpdateEvaluationFormRequest$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', 'UpdateEvaluationFormResponse$EvaluationFormId' => '<p>The unique identifier for the evaluation form.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>That resource is already in use. Please try another.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource was not found.</p>', 'refs' => [], ], 'ResourceNotReadyException' => [ 'base' => '<p>The resource is not ready.</p>', 'refs' => [], ], 'ResourceTagsSearchCriteria' => [ 'base' => '<p>The search criteria to be used to search tags.</p>', 'refs' => [ 'SearchResourceTagsRequest$SearchCriteria' => '<p>The search criteria to be used to return tags.</p>', ], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceInUseException$ResourceType' => '<p>The type of resource.</p>', ], ], 'ResourceTypeList' => [ 'base' => NULL, 'refs' => [ 'SearchResourceTagsRequest$ResourceTypes' => '<p>The list of resource types to be used to search tags from. If not provided or if any empty list is provided, this API will search from all supported resource types.</p> <p class="title"> <b>Supported resource types</b> </p> <ul> <li> <p>AGENT</p> </li> <li> <p>ROUTING_PROFILE</p> </li> <li> <p>STANDARD_QUEUE</p> </li> <li> <p>SECURITY_PROFILE</p> </li> <li> <p>OPERATING_HOURS</p> </li> <li> <p>PROMPT</p> </li> <li> <p>CONTACT_FLOW</p> </li> <li> <p>FLOW_MODULE</p> </li> </ul>', ], ], 'ResumeContactRecordingRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResumeContactRecordingResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResumeContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResumeContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'RoutingCriteria' => [ 'base' => '<p>Latest routing criteria on the contact.</p>', 'refs' => [ 'Contact$RoutingCriteria' => '<p>Latest routing criteria on the contact.</p>', ], ], 'RoutingCriteriaInput' => [ 'base' => '<p>An object to define the RoutingCriteria.</p>', 'refs' => [ 'UpdateContactRoutingDataRequest$RoutingCriteria' => '<p>Updates the routing criteria on the contact. These properties can be used to change how a&#x2028; contact is routed within the queue.</p>', ], ], 'RoutingCriteriaInputStep' => [ 'base' => '<p>Step defines the list of agents to be routed or route based on the agent requirements such as ProficiencyLevel, Name, or Value.</p>', 'refs' => [ 'RoutingCriteriaInputSteps$member' => NULL, ], ], 'RoutingCriteriaInputStepExpiry' => [ 'base' => '<p>Specify whether this routing criteria step should apply for only a limited amount of time,&#x2028; or if it should never expire.</p>', 'refs' => [ 'RoutingCriteriaInputStep$Expiry' => '<p>An object to specify the expiration of a routing step.</p>', ], ], 'RoutingCriteriaInputSteps' => [ 'base' => NULL, 'refs' => [ 'RoutingCriteriaInput$Steps' => '<p>When Amazon Connect does not find an available agent meeting the requirements in a step for&#x2028; a given step duration, the routing criteria will move on to the next step sequentially until a&#x2028; join is completed with an agent. When all steps are exhausted, the contact will be offered to any agent in the queue.</p>', ], ], 'RoutingCriteriaStepStatus' => [ 'base' => NULL, 'refs' => [ 'Step$Status' => '<p>Represents status of the Routing step.</p>', ], ], 'RoutingExpression' => [ 'base' => NULL, 'refs' => [ 'Dimensions$RoutingStepExpression' => '<p>The expression of a step in a routing criteria.</p>', 'RoutingExpressions$member' => NULL, ], ], 'RoutingExpressions' => [ 'base' => NULL, 'refs' => [ 'Filters$RoutingStepExpressions' => '<p>A list of expressions as a filter, in which an expression is an object of a step in a routing criteria.</p>', ], ], 'RoutingProfile' => [ 'base' => '<p>Contains information about a routing profile.</p>', 'refs' => [ 'DescribeRoutingProfileResponse$RoutingProfile' => '<p>The routing profile.</p>', 'RoutingProfileList$member' => NULL, ], ], 'RoutingProfileDescription' => [ 'base' => NULL, 'refs' => [ 'CreateRoutingProfileRequest$Description' => '<p>Description of the routing profile. Must not be more than 250 characters.</p>', 'RoutingProfile$Description' => '<p>The description of the routing profile.</p>', 'UpdateRoutingProfileNameRequest$Description' => '<p>The description of the routing profile. Must not be more than 250 characters.</p>', ], ], 'RoutingProfileId' => [ 'base' => NULL, 'refs' => [ 'AssociateRoutingProfileQueuesRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'CreateRoutingProfileResponse$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'CreateUserRequest$RoutingProfileId' => '<p>The identifier of the routing profile for the user.</p>', 'DeleteRoutingProfileRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'DescribeRoutingProfileRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'DisassociateRoutingProfileQueuesRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'ListRoutingProfileQueuesRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'RoutingProfile$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'RoutingProfileReference$Id' => '<p>The identifier of the routing profile.</p>', 'RoutingProfileSummary$Id' => '<p>The identifier of the routing profile.</p>', 'RoutingProfiles$member' => NULL, 'UpdateRoutingProfileAgentAvailabilityTimerRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'UpdateRoutingProfileConcurrencyRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'UpdateRoutingProfileDefaultOutboundQueueRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'UpdateRoutingProfileNameRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'UpdateRoutingProfileQueuesRequest$RoutingProfileId' => '<p>The identifier of the routing profile.</p>', 'UpdateUserRoutingProfileRequest$RoutingProfileId' => '<p>The identifier of the routing profile for the user.</p>', 'User$RoutingProfileId' => '<p>The identifier of the routing profile for the user.</p>', 'UserSearchSummary$RoutingProfileId' => '<p>The identifier of the user\'s routing profile.</p>', ], ], 'RoutingProfileList' => [ 'base' => NULL, 'refs' => [ 'SearchRoutingProfilesResponse$RoutingProfiles' => '<p>Information about the routing profiles.</p>', ], ], 'RoutingProfileName' => [ 'base' => NULL, 'refs' => [ 'CreateRoutingProfileRequest$Name' => '<p>The name of the routing profile. Must not be more than 127 characters.</p>', 'RoutingProfile$Name' => '<p>The name of the routing profile.</p>', 'RoutingProfileSummary$Name' => '<p>The name of the routing profile.</p>', 'UpdateRoutingProfileNameRequest$Name' => '<p>The name of the routing profile. Must not be more than 127 characters.</p>', ], ], 'RoutingProfileQueueConfig' => [ 'base' => '<p>Contains information about the queue and channel for which priority and delay can be set.</p>', 'refs' => [ 'RoutingProfileQueueConfigList$member' => NULL, ], ], 'RoutingProfileQueueConfigList' => [ 'base' => NULL, 'refs' => [ 'AssociateRoutingProfileQueuesRequest$QueueConfigs' => '<p>The queues to associate with this routing profile.</p>', 'CreateRoutingProfileRequest$QueueConfigs' => '<p>The inbound queues associated with the routing profile. If no queue is added, the agent can make only outbound calls.</p> <p>The limit of 10 array members applies to the maximum number of <code>RoutingProfileQueueConfig</code> objects that can be passed during a CreateRoutingProfile API request. It is different from the quota of 50 queues per routing profile per instance that is listed in <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon Connect service quotas</a>. </p>', 'UpdateRoutingProfileQueuesRequest$QueueConfigs' => '<p>The queues to be updated for this routing profile. Queues must first be associated to the routing profile. You can do this using AssociateRoutingProfileQueues.</p>', ], ], 'RoutingProfileQueueConfigSummary' => [ 'base' => '<p>Contains summary information about a routing profile queue.</p>', 'refs' => [ 'RoutingProfileQueueConfigSummaryList$member' => NULL, ], ], 'RoutingProfileQueueConfigSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRoutingProfileQueuesResponse$RoutingProfileQueueConfigSummaryList' => '<p>Information about the routing profiles.</p>', ], ], 'RoutingProfileQueueReference' => [ 'base' => '<p>Contains the channel and queue identifier for a routing profile.</p>', 'refs' => [ 'RoutingProfileQueueConfig$QueueReference' => '<p>Contains information about a queue resource.</p>', 'RoutingProfileQueueReferenceList$member' => NULL, ], ], 'RoutingProfileQueueReferenceList' => [ 'base' => NULL, 'refs' => [ 'DisassociateRoutingProfileQueuesRequest$QueueReferences' => '<p>The queues to disassociate from this routing profile.</p>', ], ], 'RoutingProfileReference' => [ 'base' => '<p>Information about the routing profile assigned to the user.</p>', 'refs' => [ 'Dimensions$RoutingProfile' => NULL, 'UserData$RoutingProfile' => '<p>Information about the routing profile that is assigned to the user.</p>', ], ], 'RoutingProfileSearchConditionList' => [ 'base' => NULL, 'refs' => [ 'RoutingProfileSearchCriteria$OrConditions' => '<p>A list of conditions which would be applied together with an OR condition.</p>', 'RoutingProfileSearchCriteria$AndConditions' => '<p>A list of conditions which would be applied together with an AND condition.</p>', ], ], 'RoutingProfileSearchCriteria' => [ 'base' => '<p>The search criteria to be used to return routing profiles.</p> <note> <p>The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2 characters and a maximum of 25 characters. Any queries with character lengths outside of this range will throw invalid results. </p> </note>', 'refs' => [ 'RoutingProfileSearchConditionList$member' => NULL, 'SearchRoutingProfilesRequest$SearchCriteria' => '<p>The search criteria to be used to return routing profiles.</p> <note> <p>The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2 characters and a maximum of 25 characters. Any queries with character lengths outside of this range will throw invalid results. </p> </note>', ], ], 'RoutingProfileSearchFilter' => [ 'base' => '<p>Filters to be applied to search results.</p>', 'refs' => [ 'SearchRoutingProfilesRequest$SearchFilter' => '<p>Filters to be applied to search results.</p>', ], ], 'RoutingProfileSummary' => [ 'base' => '<p>Contains summary information about a routing profile.</p>', 'refs' => [ 'RoutingProfileSummaryList$member' => NULL, ], ], 'RoutingProfileSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRoutingProfilesResponse$RoutingProfileSummaryList' => '<p>Information about the routing profiles.</p>', ], ], 'RoutingProfiles' => [ 'base' => NULL, 'refs' => [ 'Filters$RoutingProfiles' => '<p>A list of up to 100 routing profile IDs or ARNs.</p>', 'UserDataFilters$RoutingProfiles' => '<p>A list of up to 100 routing profile IDs or ARNs.</p>', ], ], 'Rule' => [ 'base' => '<p>Information about a rule.</p>', 'refs' => [ 'DescribeRuleResponse$Rule' => '<p>Information about the rule.</p>', ], ], 'RuleAction' => [ 'base' => '<p>Information about the action to be performed when a rule is triggered.</p>', 'refs' => [ 'RuleActions$member' => NULL, ], ], 'RuleActions' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$Actions' => '<p>A list of actions to be run when the rule is triggered.</p>', 'Rule$Actions' => '<p>A list of actions to be run when the rule is triggered.</p>', 'UpdateRuleRequest$Actions' => '<p>A list of actions to be run when the rule is triggered.</p>', ], ], 'RuleFunction' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$Function' => '<p>The conditions of the rule.</p>', 'Rule$Function' => '<p>The conditions of the rule.</p>', 'UpdateRuleRequest$Function' => '<p>The conditions of the rule.</p>', ], ], 'RuleId' => [ 'base' => NULL, 'refs' => [ 'CreateRuleResponse$RuleId' => '<p>A unique identifier for the rule.</p>', 'DeleteRuleRequest$RuleId' => '<p>A unique identifier for the rule.</p>', 'DescribeRuleRequest$RuleId' => '<p>A unique identifier for the rule.</p>', 'Rule$RuleId' => '<p>A unique identifier for the rule.</p>', 'RuleSummary$RuleId' => '<p>A unique identifier for the rule.</p>', 'UpdateRuleRequest$RuleId' => '<p>A unique identifier for the rule.</p>', ], ], 'RuleName' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$Name' => '<p>A unique name for the rule.</p>', 'Rule$Name' => '<p>The name of the rule.</p>', 'RuleSummary$Name' => '<p>The name of the rule.</p>', 'UpdateRuleRequest$Name' => '<p>The name of the rule. You can change the name only if <code>TriggerEventSource</code> is one of the following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code> </p>', ], ], 'RulePublishStatus' => [ 'base' => NULL, 'refs' => [ 'CreateRuleRequest$PublishStatus' => '<p>The publish status of the rule.</p>', 'ListRulesRequest$PublishStatus' => '<p>The publish status of the rule.</p>', 'Rule$PublishStatus' => '<p>The publish status of the rule.</p>', 'RuleSummary$PublishStatus' => '<p>The publish status of the rule.</p>', 'UpdateRuleRequest$PublishStatus' => '<p>The publish status of the rule.</p>', ], ], 'RuleSummary' => [ 'base' => '<p>A list of <code>ActionTypes</code> associated with a rule. </p>', 'refs' => [ 'RuleSummaryList$member' => NULL, ], ], 'RuleSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListRulesResponse$RuleSummaryList' => '<p>Summary information about a rule.</p>', ], ], 'RuleTriggerEventSource' => [ 'base' => '<p>The name of the event source. This field is required if <code>TriggerEventSource</code> is one of the following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code> | <code>OnContactEvaluationSubmit</code> | <code>OnMetricDataUpdate</code>.</p>', 'refs' => [ 'CreateRuleRequest$TriggerEventSource' => '<p>The event source to trigger the rule.</p>', 'Rule$TriggerEventSource' => '<p>The event source to trigger the rule.</p>', ], ], 'S3Config' => [ 'base' => '<p>Information about the Amazon Simple Storage Service (Amazon S3) storage type.</p>', 'refs' => [ 'InstanceStorageConfig$S3Config' => '<p>The S3 bucket configuration.</p>', ], ], 'S3Uri' => [ 'base' => NULL, 'refs' => [ 'CreatePromptRequest$S3Uri' => '<p>The URI for the S3 bucket where the prompt is stored. You can provide S3 pre-signed URLs returned by the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetPromptFile.html">GetPromptFile</a> API instead of providing S3 URIs.</p>', 'UpdatePromptRequest$S3Uri' => '<p>The URI for the S3 bucket where the prompt is stored. You can provide S3 pre-signed URLs returned by the <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_GetPromptFile.html">GetPromptFile</a> API instead of providing S3 URIs.</p>', ], ], 'SearchAgentStatusesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchAgentStatusesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchAvailablePhoneNumbersRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchAvailablePhoneNumbersResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchContactFlowModulesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchContactFlowModulesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchContactFlowsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchContactFlowsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchContactsMatchType' => [ 'base' => NULL, 'refs' => [ 'SearchableContactAttributes$MatchType' => '<p>The match type combining search criteria using multiple searchable contact attributes.</p>', 'Transcript$MatchType' => '<p>The match type combining search criteria using multiple transcript criteria.</p>', 'TranscriptCriteria$MatchType' => '<p>The match type combining search criteria using multiple search texts in a transcript criteria.</p>', ], ], 'SearchContactsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchContactsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchContactsTimeRange' => [ 'base' => '<p>A structure of time range that you want to search results.</p>', 'refs' => [ 'SearchContactsRequest$TimeRange' => '<p>Time range that you want to search results.</p>', ], ], 'SearchContactsTimeRangeType' => [ 'base' => NULL, 'refs' => [ 'SearchContactsTimeRange$Type' => '<p>The type of timestamp to search.</p>', ], ], 'SearchCriteria' => [ 'base' => '<p>A structure of search criteria to be used to return contacts.</p>', 'refs' => [ 'SearchContactsRequest$SearchCriteria' => '<p>The search criteria to be used to return contacts.</p>', ], ], 'SearchHoursOfOperationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchHoursOfOperationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchPredefinedAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchPredefinedAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchPromptsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchPromptsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchQueuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchQuickConnectsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchQuickConnectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchResourceTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchResourceTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchRoutingProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchRoutingProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchSecurityProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchSecurityProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchText' => [ 'base' => NULL, 'refs' => [ 'SearchTextList$member' => NULL, ], ], 'SearchTextList' => [ 'base' => NULL, 'refs' => [ 'TranscriptCriteria$SearchText' => '<p>The words or phrases used to search within a transcript.</p>', ], ], 'SearchUserHierarchyGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchUserHierarchyGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchVocabulariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'SearchVocabulariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'SearchableContactAttributeKey' => [ 'base' => NULL, 'refs' => [ 'SearchableContactAttributesCriteria$Key' => '<p>The key containing a searchable user-defined contact attribute.</p>', ], ], 'SearchableContactAttributeValue' => [ 'base' => NULL, 'refs' => [ 'SearchableContactAttributeValueList$member' => NULL, ], ], 'SearchableContactAttributeValueList' => [ 'base' => NULL, 'refs' => [ 'SearchableContactAttributesCriteria$Values' => '<p>The list of values to search for within a user-defined contact attribute.</p>', ], ], 'SearchableContactAttributes' => [ 'base' => '<p>A structure that defines search criteria based on user-defined contact attributes that are configured for contact search.</p>', 'refs' => [ 'SearchCriteria$SearchableContactAttributes' => '<p>The search criteria based on user-defined contact attributes that have been configured for contact search. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/search-custom-attributes.html">Search by custom contact attributes</a> in the <i>Amazon Connect Administrator Guide</i>.</p> <important> <p>To use <code>SearchableContactAttributes</code> in a search request, the <code>GetContactAttributes</code> action is required to perform an API request. For more information, see <a href="https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-actions-as-permissions">https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonconnect.html#amazonconnect-actions-as-permissions</a>Actions defined by Amazon Connect.</p> </important>', ], ], 'SearchableContactAttributesCriteria' => [ 'base' => '<p>The search criteria based on user-defned contact attribute key and values to search on.</p>', 'refs' => [ 'SearchableContactAttributesCriteriaList$member' => NULL, ], ], 'SearchableContactAttributesCriteriaList' => [ 'base' => NULL, 'refs' => [ 'SearchableContactAttributes$Criteria' => '<p>The list of criteria based on user-defined contact attributes that are configured for contact search.</p>', ], ], 'SearchableQueueType' => [ 'base' => NULL, 'refs' => [ 'QueueSearchCriteria$QueueTypeCondition' => '<p>The type of queue.</p>', ], ], 'SecurityKey' => [ 'base' => '<p>Configuration information of the security key.</p>', 'refs' => [ 'SecurityKeysList$member' => NULL, ], ], 'SecurityKeysList' => [ 'base' => NULL, 'refs' => [ 'ListSecurityKeysResponse$SecurityKeys' => '<p>The security keys.</p>', ], ], 'SecurityProfile' => [ 'base' => '<p>Contains information about a security profile.</p>', 'refs' => [ 'DescribeSecurityProfileResponse$SecurityProfile' => '<p>The security profile.</p>', ], ], 'SecurityProfileDescription' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$Description' => '<p>The description of the security profile.</p>', 'SecurityProfile$Description' => '<p>The description of the security profile.</p>', 'SecurityProfileSearchSummary$Description' => '<p>The description of the security profile.</p>', 'UpdateSecurityProfileRequest$Description' => '<p>The description of the security profile.</p>', ], ], 'SecurityProfileId' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileResponse$SecurityProfileId' => '<p>The identifier for the security profle.</p>', 'DeleteSecurityProfileRequest$SecurityProfileId' => '<p>The identifier for the security profle.</p>', 'DescribeSecurityProfileRequest$SecurityProfileId' => '<p>The identifier for the security profle.</p>', 'ListSecurityProfileApplicationsRequest$SecurityProfileId' => '<p>The identifier for the security profle.</p>', 'ListSecurityProfilePermissionsRequest$SecurityProfileId' => '<p>The identifier for the security profle.</p>', 'SecurityProfile$Id' => '<p>The identifier for the security profile.</p>', 'SecurityProfileIds$member' => NULL, 'SecurityProfileSearchSummary$Id' => '<p>The identifier of the security profile.</p>', 'SecurityProfileSummary$Id' => '<p>The identifier of the security profile.</p>', 'UpdateSecurityProfileRequest$SecurityProfileId' => '<p>The identifier for the security profle.</p>', ], ], 'SecurityProfileIds' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$SecurityProfileIds' => '<p>The identifier of the security profile for the user.</p>', 'UpdateUserSecurityProfilesRequest$SecurityProfileIds' => '<p>The identifiers of the security profiles for the user.</p>', 'User$SecurityProfileIds' => '<p>The identifiers of the security profiles for the user.</p>', 'UserSearchSummary$SecurityProfileIds' => '<p>The identifiers of the user\'s security profiles.</p>', ], ], 'SecurityProfileName' => [ 'base' => NULL, 'refs' => [ 'SecurityProfile$SecurityProfileName' => '<p>The name for the security profile.</p>', 'SecurityProfileSearchSummary$SecurityProfileName' => '<p>The name of the security profile.</p>', 'SecurityProfileSummary$Name' => '<p>The name of the security profile.</p>', ], ], 'SecurityProfilePermission' => [ 'base' => NULL, 'refs' => [ 'PermissionsList$member' => NULL, ], ], 'SecurityProfilePolicyKey' => [ 'base' => NULL, 'refs' => [ 'AllowedAccessControlTags$key' => NULL, ], ], 'SecurityProfilePolicyValue' => [ 'base' => NULL, 'refs' => [ 'AllowedAccessControlTags$value' => NULL, ], ], 'SecurityProfileSearchConditionList' => [ 'base' => NULL, 'refs' => [ 'SecurityProfileSearchCriteria$OrConditions' => '<p>A list of conditions which would be applied together with an OR condition.</p>', 'SecurityProfileSearchCriteria$AndConditions' => '<p>A list of conditions which would be applied together with an AND condition.</p>', ], ], 'SecurityProfileSearchCriteria' => [ 'base' => '<p>The search criteria to be used to return security profiles.</p> <note> <p>The <code>name</code> field support "contains" queries with a minimum of 2 characters and maximum of 25 characters. Any queries with character lengths outside of this range will throw invalid results.</p> </note>', 'refs' => [ 'SearchSecurityProfilesRequest$SearchCriteria' => '<p>The search criteria to be used to return security profiles. </p> <note> <p>The <code>name</code> field support "contains" queries with a minimum of 2 characters and maximum of 25 characters. Any queries with character lengths outside of this range will throw invalid results.</p> </note> <note> <p>The currently supported value for <code>FieldName</code>: <code>name</code> </p> </note>', 'SecurityProfileSearchConditionList$member' => NULL, ], ], 'SecurityProfileSearchSummary' => [ 'base' => '<p>Information about the returned security profiles.</p>', 'refs' => [ 'SecurityProfilesSearchSummaryList$member' => NULL, ], ], 'SecurityProfileSummary' => [ 'base' => '<p>Contains information about a security profile.</p>', 'refs' => [ 'SecurityProfileSummaryList$member' => NULL, ], ], 'SecurityProfileSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListSecurityProfilesResponse$SecurityProfileSummaryList' => '<p>Information about the security profiles.</p>', ], ], 'SecurityProfilesSearchFilter' => [ 'base' => '<p>Filters to be applied to search results.</p>', 'refs' => [ 'SearchSecurityProfilesRequest$SearchFilter' => '<p>Filters to be applied to search results.</p>', ], ], 'SecurityProfilesSearchSummaryList' => [ 'base' => NULL, 'refs' => [ 'SearchSecurityProfilesResponse$SecurityProfiles' => '<p>Information about the security profiles.</p>', ], ], 'SecurityToken' => [ 'base' => NULL, 'refs' => [ 'Credentials$AccessToken' => '<p>An access token generated for a federated user to access Amazon Connect.</p>', 'Credentials$RefreshToken' => '<p>Renews a token generated for a user to access the Amazon Connect instance.</p>', ], ], 'SegmentAttributeName' => [ 'base' => NULL, 'refs' => [ 'SegmentAttributes$key' => NULL, ], ], 'SegmentAttributeValue' => [ 'base' => '<p>A value for a segment attribute. This is structured as a map where the key is <code>valueString</code> and the value is a string.</p>', 'refs' => [ 'SegmentAttributes$value' => NULL, ], ], 'SegmentAttributeValueString' => [ 'base' => NULL, 'refs' => [ 'SegmentAttributeValue$ValueString' => '<p>The value of a segment attribute.</p>', ], ], 'SegmentAttributes' => [ 'base' => NULL, 'refs' => [ 'Contact$SegmentAttributes' => '<p>A set of system defined key-value pairs stored on individual contact segments using an attribute map. The attributes are standard Amazon Connect attributes and can be accessed in flows. Attribute keys can include only alphanumeric, -, and _ characters. This field can be used to show channel subtype. For example, <code>connect:Guide</code> or <code>connect:SMS</code>.</p>', 'StartChatContactRequest$SegmentAttributes' => '<p>A set of system defined key-value pairs stored on individual contact segments using an attribute map. The attributes are standard Amazon Connect attributes. They can be accessed in flows.</p> <p>Attribute keys can include only alphanumeric, -, and _.</p> <p>This field can be used to show channel subtype, such as <code>connect:Guide</code>.</p> <note> <p>The types <code>application/vnd.amazonaws.connect.message.interactive</code> and <code>application/vnd.amazonaws.connect.message.interactive.response</code> must be present in the SupportedMessagingContentTypes field of this API in order to set <code>SegmentAttributes</code> as {<code> "connect:Subtype": {"valueString" : "connect:Guide" }}</code>.</p> </note>', ], ], 'SendChatIntegrationEventRequest' => [ 'base' => NULL, 'refs' => [], ], 'SendChatIntegrationEventResponse' => [ 'base' => NULL, 'refs' => [], ], 'SendNotificationActionDefinition' => [ 'base' => '<p>Information about the send notification action.</p>', 'refs' => [ 'RuleAction$SendNotificationAction' => '<p>Information about the send notification action.</p> <p>Supported only for <code>TriggerEventSource</code> values: <code>OnPostCallAnalysisAvailable</code> | <code>OnRealTimeCallAnalysisAvailable</code> | <code>OnRealTimeChatAnalysisAvailable</code> | <code>OnPostChatAnalysisAvailable</code> | <code>OnContactEvaluationSubmit</code> | <code>OnMetricDataUpdate</code> </p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The service quota has been exceeded.</p>', 'refs' => [], ], 'SignInConfig' => [ 'base' => '<p>The distribution that determines which Amazon Web Services Regions should be used to sign in agents in to both the instance and its replica(s).</p>', 'refs' => [ 'GetTrafficDistributionResponse$SignInConfig' => '<p>The distribution that determines which Amazon Web Services Regions should be used to sign in agents in to both the instance and its replica(s).</p>', 'UpdateTrafficDistributionRequest$SignInConfig' => '<p>The distribution that determines which Amazon Web Services Regions should be used to sign in agents in to both the instance and its replica(s).</p>', ], ], 'SignInDistribution' => [ 'base' => '<p>The distribution of sign in traffic between the instance and its replica(s).</p>', 'refs' => [ 'SignInDistributionList$member' => NULL, ], ], 'SignInDistributionList' => [ 'base' => NULL, 'refs' => [ 'SignInConfig$Distributions' => '<p>Information about traffic distributions.</p>', ], ], 'SingleSelectOptions' => [ 'base' => NULL, 'refs' => [ 'TaskTemplateField$SingleSelectOptions' => '<p>A list of options for a single select field.</p>', ], ], 'SingleSelectQuestionRuleCategoryAutomation' => [ 'base' => '<p>Information about the automation option based on a rule category for a single select question.</p>', 'refs' => [ 'EvaluationFormSingleSelectQuestionAutomationOption$RuleCategory' => '<p>The automation option based on a rule category for the single select question.</p>', ], ], 'SingleSelectQuestionRuleCategoryAutomationCondition' => [ 'base' => NULL, 'refs' => [ 'SingleSelectQuestionRuleCategoryAutomation$Condition' => '<p>The condition to apply for the automation option. If the condition is <code>PRESENT</code>, then the option is applied when the contact data includes the category. Similarly, if the condition is <code>NOT_PRESENT</code>, then the option is applied when the contact data does not include the category.</p>', ], ], 'SingleSelectQuestionRuleCategoryAutomationLabel' => [ 'base' => NULL, 'refs' => [ 'SingleSelectQuestionRuleCategoryAutomation$Category' => '<p> The category name, as defined in Rules.</p>', ], ], 'SnapshotVersion' => [ 'base' => NULL, 'refs' => [ 'GetTaskTemplateRequest$SnapshotVersion' => '<p>The system generated version of a task template that is associated with a task, when the task is created.</p>', ], ], 'Sort' => [ 'base' => '<p>A structure that defines the field name to sort by and a sort order.</p>', 'refs' => [ 'SearchContactsRequest$Sort' => '<p>Specifies a field to sort by and a sort order.</p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'CurrentMetricSortCriteria$SortOrder' => '<p>The way to sort.</p>', 'Sort$Order' => '<p>An ascending or descending sort.</p>', ], ], 'SortableFieldName' => [ 'base' => NULL, 'refs' => [ 'Sort$FieldName' => '<p>The name of the field on which to sort.</p>', ], ], 'SourceApplicationName' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationAssociationRequest$SourceApplicationName' => '<p>The name of the external application. This field is only required for the EVENT integration type.</p>', 'IntegrationAssociationSummary$SourceApplicationName' => '<p>The user-provided, friendly name for the external application.</p>', ], ], 'SourceId' => [ 'base' => NULL, 'refs' => [ 'SendChatIntegrationEventRequest$SourceId' => '<p>External identifier of chat customer participant, used in part to uniquely identify a chat. For SMS, this is the E164 phone number of the chat customer participant.</p>', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationAssociationRequest$SourceType' => '<p>The type of the data source. This field is only required for the EVENT integration type.</p>', 'IntegrationAssociationSummary$SourceType' => '<p>The name of the source.</p>', ], ], 'StartAttachedFileUploadRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAttachedFileUploadResponse' => [ 'base' => 'Response from StartAttachedFileUpload API.', 'refs' => [], ], 'StartChatContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartChatContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartContactEvaluationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartContactEvaluationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartContactRecordingRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartContactRecordingResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartContactStreamingRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartContactStreamingResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartOutboundVoiceContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartOutboundVoiceContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTaskContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTaskContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartWebRTCContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartWebRTCContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'Statistic' => [ 'base' => NULL, 'refs' => [ 'HistoricalMetric$Statistic' => '<p>The statistic for the metric.</p>', ], ], 'Step' => [ 'base' => '<p>Step signifies the criteria to be used for routing to an agent</p>', 'refs' => [ 'Steps$member' => NULL, ], ], 'Steps' => [ 'base' => NULL, 'refs' => [ 'RoutingCriteria$Steps' => '<p>List of routing steps. When Amazon Connect does not find an available agent meeting the requirements in a step for a given step duration, the routing criteria will move on to the next step sequentially until a join is completed with an agent. When all steps are exhausted, the contact will be offered to any agent in the queue.</p>', ], ], 'StopContactRecordingRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopContactRecordingResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopContactStreamingRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopContactStreamingResponse' => [ 'base' => NULL, 'refs' => [], ], 'StorageType' => [ 'base' => NULL, 'refs' => [ 'InstanceStorageConfig$StorageType' => '<p>A valid storage type.</p>', ], ], 'StreamingId' => [ 'base' => NULL, 'refs' => [ 'StartContactStreamingResponse$StreamingId' => '<p>The identifier of the streaming configuration enabled. </p>', 'StopContactStreamingRequest$StreamingId' => '<p>The identifier of the streaming configuration enabled. </p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AnalyticsDataAssociationResult$ResourceShareId' => '<p>The Resource Access Manager share ID.</p>', 'AssociateAnalyticsDataSetResponse$ResourceShareId' => '<p>The Resource Access Manager share ID that is generated.</p>', 'ErrorResult$ErrorCode' => '<p>The error code.</p>', 'ErrorResult$ErrorMessage' => '<p>The corresponding error message for the error code.</p>', 'FailedRequest$FailureReasonMessage' => '<p>Why the request to create a contact failed.</p>', 'HierarchyGroupCondition$Value' => '<p>The value in the hierarchy group condition.</p>', 'InstanceStatusReason$Message' => '<p>The message.</p>', 'IntervalDetails$TimeZone' => '<p>The timezone applied to requested metrics.</p>', 'MetricFilterV2$MetricFilterKey' => '<p>The key to use for filtering data. </p> <p>Valid metric filter keys: <code>INITIATION_METHOD</code>, <code>DISCONNECT_REASON</code>. These are the same values as the <code>InitiationMethod</code> and <code>DisconnectReason</code> in the contact record. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/ctr-data-model.html#ctr-ContactTraceRecord">ContactTraceRecord</a> in the <i>Amazon Connect Administrator Guide</i>. </p>', 'MetricFilterValueList$member' => NULL, 'NumberCondition$FieldName' => '<p>The name of the field in the number condition.</p>', 'PropertyValidationExceptionProperty$PropertyPath' => '<p>The full property path.</p>', 'ResourceTypeList$member' => NULL, 'StringCondition$FieldName' => '<p>The name of the field in the string condition.</p>', 'StringCondition$Value' => '<p>The value of the string.</p>', 'TagCondition$TagKey' => '<p>The tag key in the tag condition.</p>', 'TagCondition$TagValue' => '<p>The tag value in the tag condition.</p>', 'UserTagMap$key' => NULL, 'UserTagMap$value' => NULL, ], ], 'StringComparisonType' => [ 'base' => NULL, 'refs' => [ 'StringCondition$ComparisonType' => '<p>The type of comparison to be made when evaluating the string condition.</p>', 'TagSearchCondition$tagKeyComparisonType' => '<p>The type of comparison to be made when evaluating the tag key in tag search condition.</p>', 'TagSearchCondition$tagValueComparisonType' => '<p>The type of comparison to be made when evaluating the tag value in tag search condition.</p>', ], ], 'StringCondition' => [ 'base' => '<p>A leaf node condition which can be used to specify a string condition.</p>', 'refs' => [ 'AgentStatusSearchCriteria$StringCondition' => '<p>A leaf node condition which can be used to specify a string condition.</p> <note> <p>The currently supported values for <code>FieldName</code> are <code>name</code>,&#x2028;&#x2028; <code>description</code>, <code>state</code>, <code>type</code>, <code>displayOrder</code>,&#x2028; and <code>resourceID</code>.</p> </note>', 'Condition$StringCondition' => '<p>A leaf node condition which can be used to specify a string condition.</p> <note> <p>The currently supported values for <code>FieldName</code> are <code>name</code> and&#x2028; <code>value</code>.</p> </note>', 'ContactFlowModuleSearchCriteria$StringCondition' => NULL, 'ContactFlowSearchCriteria$StringCondition' => NULL, 'HoursOfOperationSearchCriteria$StringCondition' => '<p>A leaf node condition which can be used to specify a string condition.</p> <note> <p>The currently supported values for <code>FieldName</code> are <code>name</code>, <code>description</code>, <code>timezone</code>, and <code>resourceID</code>.</p> </note>', 'PredefinedAttributeSearchCriteria$StringCondition' => NULL, 'PromptSearchCriteria$StringCondition' => '<p>A leaf node condition which can be used to specify a string condition.</p> <note> <p>The currently supported values for <code>FieldName</code> are <code>name</code>, <code>description</code>, and <code>resourceID</code>.</p> </note>', 'QueueSearchCriteria$StringCondition' => '<p>A leaf node condition which can be used to specify a string condition.</p> <note> <p>The currently supported values for <code>FieldName</code> are <code>name</code>, <code>description</code>, and <code>resourceID</code>.</p> </note>', 'QuickConnectSearchCriteria$StringCondition' => '<p>A leaf node condition which can be used to specify a string condition.</p> <note> <p>The currently supported values for <code>FieldName</code> are <code>name</code>, <code>description</code>, and <code>resourceID</code>.</p> </note>', 'RoutingProfileSearchCriteria$StringCondition' => '<p>A leaf node condition which can be used to specify a string condition.</p> <note> <p>The currently supported values for <code>FieldName</code> are <code>associatedQueueIds</code>, <code>name</code>, <code>description</code>, and <code>resourceID</code>.</p> </note>', 'SecurityProfileSearchCriteria$StringCondition' => NULL, 'UserHierarchyGroupSearchCriteria$StringCondition' => '<p>A leaf node condition which can be used to specify a string condition.</p> <note> <p>The currently supported values for <code>FieldName</code> are <code>name</code>,&#x2028;&#x2028; <code>parentId</code>, <code>levelId</code>, and <code>resourceID</code>.</p> </note>', 'UserSearchCriteria$StringCondition' => '<p>A leaf node condition which can be used to specify a string condition.</p> <p>The currently supported values for <code>FieldName</code> are <code>Username</code>, <code>FirstName</code>, <code>LastName</code>, <code>RoutingProfileId</code>, <code>SecurityProfileId</code>, <code>ResourceId</code>.</p>', ], ], 'StringReference' => [ 'base' => '<p>Information about a reference when the <code>referenceType</code> is <code>STRING</code>. Otherwise, null.</p>', 'refs' => [ 'ReferenceSummary$String' => '<p>Information about a reference when the <code>referenceType</code> is <code>STRING</code>. Otherwise, null.</p>', ], ], 'Subject' => [ 'base' => NULL, 'refs' => [ 'SendNotificationActionDefinition$Subject' => '<p>The subject of the email if the delivery method is <code>EMAIL</code>. Supports variable injection. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath reference</a> in the <i>Amazon Connect Administrators Guide</i>.</p>', ], ], 'SubmitAutoEvaluationActionDefinition' => [ 'base' => '<p>Information about the submit automated evaluation action.</p>', 'refs' => [ 'RuleAction$SubmitAutoEvaluationAction' => '<p>Information about the submit automated evaluation action.</p>', ], ], 'SubmitContactEvaluationRequest' => [ 'base' => NULL, 'refs' => [], ], 'SubmitContactEvaluationResponse' => [ 'base' => NULL, 'refs' => [], ], 'Subtype' => [ 'base' => NULL, 'refs' => [ 'SendChatIntegrationEventRequest$Subtype' => '<p>Classification of a channel. This is used in part to uniquely identify chat. </p> <p>Valid value: <code>["connect:sms"]</code> </p>', ], ], 'SuccessfulRequest' => [ 'base' => '<p>Request for which contact was successfully created.</p>', 'refs' => [ 'SuccessfulRequestList$member' => NULL, ], ], 'SuccessfulRequestList' => [ 'base' => NULL, 'refs' => [ 'BatchPutContactResponse$SuccessfulRequestList' => '<p>List of requests for which contact was successfully created.</p>', ], ], 'SupportedMessagingContentType' => [ 'base' => NULL, 'refs' => [ 'SupportedMessagingContentTypes$member' => NULL, ], ], 'SupportedMessagingContentTypes' => [ 'base' => NULL, 'refs' => [ 'NewSessionDetails$SupportedMessagingContentTypes' => '<p> The supported chat message content types. Supported types are <code>text/plain</code>, <code>text/markdown</code>, <code>application/json</code>, <code>application/vnd.amazonaws.connect.message.interactive</code>, and <code>application/vnd.amazonaws.connect.message.interactive.response</code>. </p> <p>Content types must always contain <code> text/plain</code>. You can then put any other supported type in the list. For example, all the following lists are valid because they contain <code>text/plain</code>: <code>[text/plain, text/markdown, application/json]</code>, <code> [text/markdown, text/plain]</code>, <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>. </p>', 'StartChatContactRequest$SupportedMessagingContentTypes' => '<p>The supported chat message content types. Supported types are <code>text/plain</code>, <code>text/markdown</code>, <code>application/json</code>, <code>application/vnd.amazonaws.connect.message.interactive</code>, and <code>application/vnd.amazonaws.connect.message.interactive.response</code>. </p> <p>Content types must always contain <code>text/plain</code>. You can then put any other supported type in the list. For example, all the following lists are valid because they contain <code>text/plain</code>: <code>[text/plain, text/markdown, application/json]</code>, <code>[text/markdown, text/plain]</code>, <code>[text/plain, application/json, application/vnd.amazonaws.connect.message.interactive.response]</code>. </p> <note> <p>The type <code>application/vnd.amazonaws.connect.message.interactive</code> is required to use the <a href="https://docs.aws.amazon.com/connect/latest/adminguide/show-view-block.html">Show view</a> flow block.</p> </note>', ], ], 'SuspendContactRecordingRequest' => [ 'base' => NULL, 'refs' => [], ], 'SuspendContactRecordingResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagAndConditionList' => [ 'base' => NULL, 'refs' => [ 'AttributeAndCondition$TagConditions' => '<p>A leaf node condition which can be used to specify a tag condition.</p>', 'CommonAttributeAndCondition$TagConditions' => '<p>A leaf node condition which can be used to specify a tag condition.</p>', 'ControlPlaneTagFilter$AndConditions' => '<p>A list of conditions which would be applied together with an <code>AND</code> condition.</p>', 'TagOrConditionList$member' => NULL, ], ], 'TagCondition' => [ 'base' => '<p>A leaf node condition which can be used to specify a tag condition, for example, <code>HAVE BPO = 123</code>. </p>', 'refs' => [ 'ControlPlaneAttributeFilter$TagCondition' => NULL, 'ControlPlaneTagFilter$TagCondition' => '<p>A leaf node condition which can be used to specify a tag condition. </p>', 'ControlPlaneUserAttributeFilter$TagCondition' => NULL, 'TagAndConditionList$member' => NULL, ], ], 'TagContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, 'TagSet$key' => '<p>The tag key in the tagSet.</p>', ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys.</p>', ], ], 'TagKeyString' => [ 'base' => NULL, 'refs' => [ 'TagSearchCondition$tagKey' => '<p>The tag key used in the tag search condition.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'AgentStatus$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'AttachedFile$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, <code>{ "Tags": {"key1":"value1", "key2":"value2"} }</code>.</p>', 'ClaimPhoneNumberRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'ClaimedPhoneNumberSummary$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'ContactFlow$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'ContactFlowModule$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateAgentStatusRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateContactFlowModuleRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateContactFlowRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateHoursOfOperationRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateInstanceRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, <code>{ "tags": {"key1":"value1", "key2":"value2"} }</code>.</p>', 'CreateIntegrationAssociationRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreatePromptRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateQueueRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateQuickConnectRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateRoutingProfileRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateSecurityProfileRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateTrafficDistributionGroupRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateUseCaseRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateUserHierarchyGroupRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateUserRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateViewRequest$Tags' => '<p>The tags associated with the view resource (not specific to view version).These tags can be used to organize, track, or control access for this resource. For example, { "tags": {"key1":"value1", "key2":"value2"} }.</p>', 'CreateVocabularyRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'Evaluation$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'EvaluationForm$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'GetAttachedFileResponse$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, <code>{ "Tags": {"key1":"value1", "key2":"value2"} }</code>.</p>', 'GetTaskTemplateResponse$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'HierarchyGroup$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'HoursOfOperation$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'ImportPhoneNumberRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'Instance$Tags' => '<p>The tags of an instance.</p>', 'ListTagsForResourceResponse$tags' => '<p>Information about the tags.</p>', 'Prompt$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'Queue$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'QuickConnect$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'RoutingProfile$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'Rule$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'SecurityProfile$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'SecurityProfileSearchSummary$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'StartAttachedFileUploadRequest$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, <code>{ "Tags": {"key1":"value1", "key2":"value2"} }</code>.</p>', 'TagResourceRequest$tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'TrafficDistributionGroup$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'User$Tags' => '<p>The tags.</p>', 'UserSearchSummary$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', 'View$Tags' => '<p>The tags associated with the view resource (not specific to view version).</p>', 'Vocabulary$Tags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }.</p>', ], ], 'TagOrConditionList' => [ 'base' => NULL, 'refs' => [ 'ControlPlaneTagFilter$OrConditions' => '<p>A list of conditions which would be applied together with an <code>OR</code> condition. </p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagRestrictedResourceList' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityProfileRequest$TagRestrictedResources' => '<p>The list of resources that a security profile applies tag restrictions to in Amazon Connect. Following are acceptable ResourceNames: <code>User</code> | <code>SecurityProfile</code> | <code>Queue</code> | <code>RoutingProfile</code> </p>', 'SecurityProfile$TagRestrictedResources' => '<p>The list of resources that a security profile applies tag restrictions to in Amazon Connect.</p>', 'UpdateSecurityProfileRequest$TagRestrictedResources' => '<p>The list of resources that a security profile applies tag restrictions to in Amazon Connect.</p>', ], ], 'TagRestrictedResourceName' => [ 'base' => NULL, 'refs' => [ 'TagRestrictedResourceList$member' => NULL, ], ], 'TagSearchCondition' => [ 'base' => '<p>The search criteria to be used to return tags.</p>', 'refs' => [ 'ResourceTagsSearchCriteria$TagSearchCondition' => '<p>The search criteria to be used to return tags.</p>', ], ], 'TagSet' => [ 'base' => '<p>A tag set contains tag key and tag value.</p>', 'refs' => [ 'TagsList$member' => NULL, ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, 'TagSet$value' => '<p>The tag value in the tagSet.</p>', ], ], 'TagValueString' => [ 'base' => NULL, 'refs' => [ 'TagSearchCondition$tagValue' => '<p>The tag value used in the tag search condition.</p>', ], ], 'TagsList' => [ 'base' => NULL, 'refs' => [ 'SearchResourceTagsResponse$Tags' => '<p>A list of tags used in the Amazon Connect instance.</p>', ], ], 'TargetListType' => [ 'base' => NULL, 'refs' => [ 'ListCondition$TargetListType' => '<p>The type of target list that will be used to filter the users.</p>', ], ], 'TaskActionDefinition' => [ 'base' => '<p>Information about the task action.</p>', 'refs' => [ 'RuleAction$TaskAction' => '<p>Information about the task action. This field is required if <code>TriggerEventSource</code> is one of the following values: <code>OnZendeskTicketCreate</code> | <code>OnZendeskTicketStatusUpdate</code> | <code>OnSalesforceCaseCreate</code> </p>', ], ], 'TaskDescriptionExpression' => [ 'base' => NULL, 'refs' => [ 'TaskActionDefinition$Description' => '<p>The description. Supports variable injection. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath reference</a> in the <i>Amazon Connect Administrators Guide</i>.</p>', ], ], 'TaskNameExpression' => [ 'base' => NULL, 'refs' => [ 'TaskActionDefinition$Name' => '<p>The name. Supports variable injection. For more information, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/contact-lens-variable-injection.html">JSONPath reference</a> in the <i>Amazon Connect Administrators Guide</i>.</p>', ], ], 'TaskTemplateArn' => [ 'base' => NULL, 'refs' => [ 'CreateTaskTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the task template resource.</p>', 'GetTaskTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN).</p>', 'TaskTemplateMetadata$Arn' => '<p>The Amazon Resource Name (ARN) of the task template.</p>', 'UpdateTaskTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) for the task template resource.</p>', ], ], 'TaskTemplateConstraints' => [ 'base' => '<p>Describes constraints that apply to the template fields.</p>', 'refs' => [ 'CreateTaskTemplateRequest$Constraints' => '<p>Constraints that are applicable to the fields listed.</p>', 'GetTaskTemplateResponse$Constraints' => '<p>Constraints that are applicable to the fields listed.</p>', 'UpdateTaskTemplateRequest$Constraints' => '<p>Constraints that are applicable to the fields listed.</p>', 'UpdateTaskTemplateResponse$Constraints' => '<p>Constraints that are applicable to the fields listed.</p>', ], ], 'TaskTemplateDefaultFieldValue' => [ 'base' => '<p>Describes a default field and its corresponding value.</p>', 'refs' => [ 'TaskTemplateDefaultFieldValueList$member' => NULL, ], ], 'TaskTemplateDefaultFieldValueList' => [ 'base' => NULL, 'refs' => [ 'TaskTemplateDefaults$DefaultFieldValues' => '<p>Default value for the field.</p>', ], ], 'TaskTemplateDefaults' => [ 'base' => '<p>Describes default values for fields on a template.</p>', 'refs' => [ 'CreateTaskTemplateRequest$Defaults' => '<p>The default values for fields when a task is created by referencing this template.</p>', 'GetTaskTemplateResponse$Defaults' => '<p>The default values for fields when a task is created by referencing this template.</p>', 'UpdateTaskTemplateRequest$Defaults' => '<p>The default values for fields when a task is created by referencing this template.</p>', 'UpdateTaskTemplateResponse$Defaults' => '<p>The default values for fields when a task is created by referencing this template.</p>', ], ], 'TaskTemplateDescription' => [ 'base' => NULL, 'refs' => [ 'CreateTaskTemplateRequest$Description' => '<p>The description of the task template.</p>', 'GetTaskTemplateResponse$Description' => '<p>The description of the task template.</p>', 'TaskTemplateMetadata$Description' => '<p>The description of the task template.</p>', 'UpdateTaskTemplateRequest$Description' => '<p>The description of the task template.</p>', 'UpdateTaskTemplateResponse$Description' => '<p>The description of the task template.</p>', ], ], 'TaskTemplateField' => [ 'base' => '<p>Describes a single task template field.</p>', 'refs' => [ 'TaskTemplateFields$member' => NULL, ], ], 'TaskTemplateFieldDescription' => [ 'base' => NULL, 'refs' => [ 'TaskTemplateField$Description' => '<p>The description of the field.</p>', ], ], 'TaskTemplateFieldIdentifier' => [ 'base' => '<p>The identifier of the task template field.</p>', 'refs' => [ 'InvisibleFieldInfo$Id' => '<p>Identifier of the invisible field.</p>', 'ReadOnlyFieldInfo$Id' => '<p>Identifier of the read-only field.</p>', 'RequiredFieldInfo$Id' => '<p>The unique identifier for the field.</p>', 'TaskTemplateDefaultFieldValue$Id' => '<p>Identifier of a field. </p>', 'TaskTemplateField$Id' => '<p>The unique identifier for the field.</p>', ], ], 'TaskTemplateFieldName' => [ 'base' => NULL, 'refs' => [ 'TaskTemplateFieldIdentifier$Name' => '<p>The name of the task template field.</p>', ], ], 'TaskTemplateFieldType' => [ 'base' => NULL, 'refs' => [ 'TaskTemplateField$Type' => '<p>Indicates the type of field.</p>', ], ], 'TaskTemplateFieldValue' => [ 'base' => NULL, 'refs' => [ 'TaskTemplateDefaultFieldValue$DefaultValue' => '<p>Default value for the field.</p>', ], ], 'TaskTemplateFields' => [ 'base' => NULL, 'refs' => [ 'CreateTaskTemplateRequest$Fields' => '<p>Fields that are part of the template.</p>', 'GetTaskTemplateResponse$Fields' => '<p>Fields that are part of the template.</p>', 'UpdateTaskTemplateRequest$Fields' => '<p>Fields that are part of the template.</p>', 'UpdateTaskTemplateResponse$Fields' => '<p>Fields that are part of the template.</p>', ], ], 'TaskTemplateId' => [ 'base' => NULL, 'refs' => [ 'CreateTaskTemplateResponse$Id' => '<p>The identifier of the task template resource.</p>', 'DeleteTaskTemplateRequest$TaskTemplateId' => '<p>A unique identifier for the task template.</p>', 'GetTaskTemplateRequest$TaskTemplateId' => '<p>A unique identifier for the task template.</p>', 'GetTaskTemplateResponse$Id' => '<p>A unique identifier for the task template.</p>', 'StartTaskContactRequest$TaskTemplateId' => '<p>A unique identifier for the task template. For more information about task templates, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/task-templates.html">Create task templates</a> in the <i>Amazon Connect Administrator Guide</i>. </p>', 'TaskTemplateMetadata$Id' => '<p>A unique identifier for the task template.</p>', 'UpdateTaskTemplateRequest$TaskTemplateId' => '<p>A unique identifier for the task template.</p>', 'UpdateTaskTemplateResponse$Id' => '<p>The identifier of the task template resource.</p>', ], ], 'TaskTemplateList' => [ 'base' => NULL, 'refs' => [ 'ListTaskTemplatesResponse$TaskTemplates' => '<p>Provides details about a list of task templates belonging to an instance.</p>', ], ], 'TaskTemplateMetadata' => [ 'base' => '<p>Contains summary information about the task template.</p>', 'refs' => [ 'TaskTemplateList$member' => NULL, ], ], 'TaskTemplateName' => [ 'base' => NULL, 'refs' => [ 'CreateTaskTemplateRequest$Name' => '<p>The name of the task template.</p>', 'GetTaskTemplateResponse$Name' => '<p>The name of the task template.</p>', 'ListTaskTemplatesRequest$Name' => '<p>The name of the task template.</p>', 'TaskTemplateMetadata$Name' => '<p>The name of the task template.</p>', 'UpdateTaskTemplateRequest$Name' => '<p>The name of the task template.</p>', 'UpdateTaskTemplateResponse$Name' => '<p>The name of the task template.</p>', ], ], 'TaskTemplateSingleSelectOption' => [ 'base' => NULL, 'refs' => [ 'SingleSelectOptions$member' => NULL, ], ], 'TaskTemplateStatus' => [ 'base' => NULL, 'refs' => [ 'CreateTaskTemplateRequest$Status' => '<p>Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task that refers to this template cannot be created. </p>', 'GetTaskTemplateResponse$Status' => '<p>Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task that refers to this template cannot be created.</p>', 'ListTaskTemplatesRequest$Status' => '<p>Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task that refers to this template cannot be created.</p>', 'TaskTemplateMetadata$Status' => '<p>Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task that refers to this template cannot be created.</p>', 'UpdateTaskTemplateRequest$Status' => '<p>Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task that refers to this template cannot be created.</p>', 'UpdateTaskTemplateResponse$Status' => '<p>Marks a template as <code>ACTIVE</code> or <code>INACTIVE</code> for a task to refer to it. Tasks can only be created from <code>ACTIVE</code> templates. If a template is marked as <code>INACTIVE</code>, then a task that refers to this template cannot be created.</p>', ], ], 'TelephonyConfig' => [ 'base' => '<p>The distribution of traffic between the instance and its replicas.</p>', 'refs' => [ 'GetTrafficDistributionResponse$TelephonyConfig' => '<p>The distribution of traffic between the instance and its replicas.</p>', 'UpdateTrafficDistributionRequest$TelephonyConfig' => '<p>The distribution of traffic between the instance and its replica(s).</p>', ], ], 'TemplateId' => [ 'base' => NULL, 'refs' => [ 'CreateCaseActionDefinition$TemplateId' => '<p>A unique identifier of a template.</p>', ], ], 'Threshold' => [ 'base' => '<p>Contains information about the threshold for service level metrics.</p>', 'refs' => [ 'HistoricalMetric$Threshold' => '<p>The threshold for the metric, used with service level metrics.</p>', ], ], 'ThresholdCollections' => [ 'base' => NULL, 'refs' => [ 'MetricV2$Threshold' => '<p>Contains information about the threshold for service level metrics.</p>', ], ], 'ThresholdV2' => [ 'base' => '<p>Contains information about the threshold for service level metrics.</p>', 'refs' => [ 'ThresholdCollections$member' => NULL, ], ], 'ThresholdValue' => [ 'base' => NULL, 'refs' => [ 'Threshold$ThresholdValue' => '<p>The threshold value to compare.</p>', 'ThresholdV2$ThresholdValue' => '<p>The threshold value to compare.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The throttling limit has been exceeded.</p>', 'refs' => [], ], 'TimeZone' => [ 'base' => NULL, 'refs' => [ 'CreateHoursOfOperationRequest$TimeZone' => '<p>The time zone of the hours of operation.</p>', 'HoursOfOperation$TimeZone' => '<p>The time zone for the hours of operation.</p>', 'UpdateHoursOfOperationRequest$TimeZone' => '<p>The time zone of the hours of operation.</p>', ], ], 'TimerEligibleParticipantRoles' => [ 'base' => NULL, 'refs' => [ 'ParticipantTimerConfiguration$ParticipantRole' => '<p>The role of the participant in the chat conversation.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AgentContactReference$StateStartTimestamp' => '<p>The epoch timestamp when the contact state started.</p>', 'AgentContactReference$ConnectedToAgentTimestamp' => '<p>The time at which the contact was connected to an agent.</p>', 'AgentStatus$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'AgentStatusReference$StatusStartTimestamp' => '<p>The start timestamp of the agent\'s status.</p>', 'AgentStatusSummary$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'AuthenticationProfile$CreatedTime' => '<p>The timestamp when the authentication profile was created.</p>', 'AuthenticationProfile$LastModifiedTime' => '<p>The timestamp when the authentication profile was last modified.</p>', 'AuthenticationProfileSummary$LastModifiedTime' => '<p>The timestamp when the authentication profile summary was last modified.</p>', 'Evaluation$CreatedTime' => '<p>The timestamp for when the evaluation was created.</p>', 'Evaluation$LastModifiedTime' => '<p>The timestamp for when the evaluation was last updated.</p>', 'EvaluationForm$CreatedTime' => '<p>The timestamp for when the evaluation form was created.</p>', 'EvaluationForm$LastModifiedTime' => '<p>The timestamp for when the evaluation form was last updated.</p>', 'EvaluationFormSummary$CreatedTime' => '<p>The timestamp for when the evaluation form was created.</p>', 'EvaluationFormSummary$LastModifiedTime' => '<p>The timestamp for when the evaluation form was last updated.</p>', 'EvaluationFormSummary$LastActivatedTime' => '<p>The timestamp for when the evaluation form was last activated.</p>', 'EvaluationFormVersionSummary$CreatedTime' => '<p>The timestamp for when the evaluation form was created.</p>', 'EvaluationFormVersionSummary$LastModifiedTime' => '<p>The timestamp for when the evaluation form was last updated.</p>', 'EvaluationSummary$CreatedTime' => '<p>The timestamp for when the evaluation was created.</p>', 'EvaluationSummary$LastModifiedTime' => '<p>The timestamp for when the evaluation was last updated.</p>', 'GetMetricDataV2Request$StartTime' => '<p>The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be before the end time timestamp. The start and end time depends on the <code>IntervalPeriod</code> selected. By default the time range between start and end time is 35 days. Historical metrics are available for 3 months.</p>', 'GetMetricDataV2Request$EndTime' => '<p>The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be later than the start time timestamp. It cannot be later than the current timestamp.</p>', 'GetPromptFileResponse$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'HierarchyGroup$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'HierarchyGroupSummary$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'HierarchyLevel$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'HoursOfOperation$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'HoursOfOperationSummary$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'Instance$CreatedTime' => '<p>When the instance was created.</p>', 'InstanceSummary$CreatedTime' => '<p>When the instance was created.</p>', 'ListQueueQuickConnectsResponse$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'ListRoutingProfileQueuesResponse$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'ListSecurityProfileApplicationsResponse$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'ListSecurityProfilePermissionsResponse$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'ListUserProficienciesResponse$LastModifiedTime' => '<p>The last time that the user\'s proficiencies are were modified.</p>', 'MetricInterval$StartTime' => '<p>The timestamp, in UNIX Epoch time format. Start time is based on the interval period selected. </p>', 'MetricInterval$EndTime' => '<p>The timestamp, in UNIX Epoch time format. End time is based on the interval period selected. For example, If <code>IntervalPeriod</code> is selected <code>THIRTY_MIN</code>, <code>StartTime</code> and <code>EndTime</code> in the API request differs by 1 day, then 48 results are returned in the response. Each result is aggregated by the 30 minutes period, with each <code>StartTime</code> and <code>EndTime</code> differing by 30 minutes. </p>', 'PredefinedAttribute$LastModifiedTime' => '<p>Last modified time.</p>', 'PredefinedAttributeSummary$LastModifiedTime' => '<p>Last modified time.</p>', 'Prompt$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'PromptSummary$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'Queue$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'QueueSummary$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'QuickConnect$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'QuickConnectSummary$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'RoutingProfile$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'RoutingProfileSummary$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'Rule$CreatedTime' => '<p>The timestamp for when the rule was created.</p>', 'Rule$LastUpdatedTime' => '<p>The timestamp for the when the rule was last updated.</p>', 'RuleSummary$CreatedTime' => '<p>The timestamp for when the rule was created. </p>', 'RuleSummary$LastUpdatedTime' => '<p>The timestamp for when the rule was last updated.</p>', 'SearchContactsTimeRange$StartTime' => '<p>The start time of the time range.</p>', 'SearchContactsTimeRange$EndTime' => '<p>The end time of the time range.</p>', 'SecurityProfile$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'SecurityProfileSummary$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'StartTaskContactRequest$ScheduledTime' => '<p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>', 'UpdateContactScheduleRequest$ScheduledTime' => '<p>The timestamp, in Unix Epoch seconds format, at which to start running the inbound flow. The scheduled time cannot be in the past. It must be within up to 6 days in future. </p>', 'User$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'UserSummary$LastModifiedTime' => '<p>The timestamp when this resource was last modified.</p>', 'View$CreatedTime' => '<p>The timestamp of when the view was created.</p>', 'View$LastModifiedTime' => '<p>Latest timestamp of the <code>UpdateViewContent</code> or <code>CreateViewVersion</code> operations.</p>', ], ], 'TooManyRequestsException' => [ 'base' => '<p>Displayed when rate-related API limits are exceeded.</p>', 'refs' => [], ], 'TotalCount' => [ 'base' => NULL, 'refs' => [ 'SearchContactsResponse$TotalCount' => '<p>The total number of contacts which matched your search query.</p>', ], ], 'TotalPauseCount' => [ 'base' => NULL, 'refs' => [ 'Contact$TotalPauseCount' => '<p>Total pause count for a contact.</p>', ], ], 'TotalPauseDurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'Contact$TotalPauseDurationInSeconds' => '<p>Total pause duration for a contact in seconds.</p>', ], ], 'TrafficDistributionGroup' => [ 'base' => '<p>Information about a traffic distribution group.</p>', 'refs' => [ 'DescribeTrafficDistributionGroupResponse$TrafficDistributionGroup' => '<p>Information about the traffic distribution group.</p>', ], ], 'TrafficDistributionGroupArn' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficDistributionGroupResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the traffic distribution group.</p>', 'GetTrafficDistributionResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the traffic distribution group.</p>', 'TrafficDistributionGroup$Arn' => '<p>The Amazon Resource Name (ARN) of the traffic distribution group.</p>', 'TrafficDistributionGroupSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the traffic distribution group.</p>', ], ], 'TrafficDistributionGroupId' => [ 'base' => NULL, 'refs' => [ 'CreateTrafficDistributionGroupResponse$Id' => '<p>The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.</p>', 'GetTrafficDistributionResponse$Id' => '<p>The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.</p>', 'TrafficDistributionGroup$Id' => '<p>The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.</p>', 'TrafficDistributionGroupSummary$Id' => '<p>The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.</p>', ], ], 'TrafficDistributionGroupIdOrArn' => [ 'base' => NULL, 'refs' => [ 'AssociateTrafficDistributionGroupUserRequest$TrafficDistributionGroupId' => '<p>The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.</p>', 'DeleteTrafficDistributionGroupRequest$TrafficDistributionGroupId' => '<p>The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.</p>', 'DescribeTrafficDistributionGroupRequest$TrafficDistributionGroupId' => '<p>The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.</p>', 'DisassociateTrafficDistributionGroupUserRequest$TrafficDistributionGroupId' => '<p>The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.</p>', 'GetTrafficDistributionRequest$Id' => '<p>The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.</p>', 'ListTrafficDistributionGroupUsersRequest$TrafficDistributionGroupId' => '<p>The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region.</p>', 'UpdateTrafficDistributionRequest$Id' => '<p>The identifier of the traffic distribution group. This can be the ID or the ARN if the API is being called in the Region where the traffic distribution group was created. The ARN must be provided if the call is from the replicated Region. </p>', ], ], 'TrafficDistributionGroupStatus' => [ 'base' => NULL, 'refs' => [ 'TrafficDistributionGroup$Status' => '<p>The status of the traffic distribution group.</p> <ul> <li> <p> <code>CREATION_IN_PROGRESS</code> means the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html">CreateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.</p> </li> <li> <p> <code>ACTIVE</code> means the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html">CreateTrafficDistributionGroup</a> operation has succeeded.</p> </li> <li> <p> <code>CREATION_FAILED</code> indicates that the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html">CreateTrafficDistributionGroup</a> operation has failed.</p> </li> <li> <p> <code>PENDING_DELETION</code> means the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html">DeleteTrafficDistributionGroup</a> operation is still in progress and has not yet completed.</p> </li> <li> <p> <code>DELETION_FAILED</code> means the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html">DeleteTrafficDistributionGroup</a> operation has failed.</p> </li> <li> <p> <code>UPDATE_IN_PROGRESS</code> means the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistribution.html">UpdateTrafficDistribution</a> operation is still in progress and has not yet completed.</p> </li> </ul>', 'TrafficDistributionGroupSummary$Status' => '<p>The status of the traffic distribution group. </p> <ul> <li> <p> <code>CREATION_IN_PROGRESS</code> means the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html">CreateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.</p> </li> <li> <p> <code>ACTIVE</code> means the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html">CreateTrafficDistributionGroup</a> operation has succeeded.</p> </li> <li> <p> <code>CREATION_FAILED</code> indicates that the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateTrafficDistributionGroup.html">CreateTrafficDistributionGroup</a> operation has failed.</p> </li> <li> <p> <code>PENDING_DELETION</code> means the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html">DeleteTrafficDistributionGroup</a> operation is still in progress and has not yet completed.</p> </li> <li> <p> <code>DELETION_FAILED</code> means the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_DeleteTrafficDistributionGroup.html">DeleteTrafficDistributionGroup</a> operation has failed.</p> </li> <li> <p> <code>UPDATE_IN_PROGRESS</code> means the previous <a href="https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdateTrafficDistributionGroup.html">UpdateTrafficDistributionGroup</a> operation is still in progress and has not yet completed.</p> </li> </ul>', ], ], 'TrafficDistributionGroupSummary' => [ 'base' => '<p>Information about traffic distribution groups.</p>', 'refs' => [ 'TrafficDistributionGroupSummaryList$member' => NULL, ], ], 'TrafficDistributionGroupSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTrafficDistributionGroupsResponse$TrafficDistributionGroupSummaryList' => '<p>A list of traffic distribution groups.</p>', ], ], 'TrafficDistributionGroupUserSummary' => [ 'base' => '<p>Summary information about a traffic distribution group user.</p>', 'refs' => [ 'TrafficDistributionGroupUserSummaryList$member' => NULL, ], ], 'TrafficDistributionGroupUserSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTrafficDistributionGroupUsersResponse$TrafficDistributionGroupUserSummaryList' => '<p>A list of traffic distribution group users.</p>', ], ], 'TrafficType' => [ 'base' => NULL, 'refs' => [ 'StartOutboundVoiceContactRequest$TrafficType' => '<p>Denotes the class of traffic. Calls with different traffic types are handled differently by Amazon Connect. The default value is <code>GENERAL</code>. Use <code>CAMPAIGN</code> if <code>EnableAnswerMachineDetection</code> is set to <code>true</code>. For all other cases, use <code>GENERAL</code>. </p>', ], ], 'Transcript' => [ 'base' => '<p>A structure that defines search criteria and matching logic to search for contacts by matching text with transcripts analyzed by Amazon Connect Contact Lens.</p>', 'refs' => [ 'ContactAnalysis$Transcript' => '<p>Search criteria based on transcript analyzed by Amazon Connect Contact Lens.</p>', ], ], 'TranscriptCriteria' => [ 'base' => '<p>A structure that defines search criteria base on words or phrases, participants in the Contact Lens conversational analytics transcript.</p>', 'refs' => [ 'TranscriptCriteriaList$member' => NULL, ], ], 'TranscriptCriteriaList' => [ 'base' => NULL, 'refs' => [ 'Transcript$Criteria' => '<p>The list of search criteria based on Contact Lens conversational analytics transcript.</p>', ], ], 'TransferContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'TransferContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'URI' => [ 'base' => NULL, 'refs' => [ 'CreateIntegrationAssociationRequest$SourceApplicationUrl' => '<p>The URL for the external application. This field is only required for the EVENT integration type.</p>', 'IntegrationAssociationSummary$SourceApplicationUrl' => '<p>The URL for the external application.</p>', 'MediaPlacement$AudioHostUrl' => '<p>The audio host URL.</p>', 'MediaPlacement$AudioFallbackUrl' => '<p>The audio fallback URL.</p>', 'MediaPlacement$SignalingUrl' => '<p>The signaling URL.</p>', 'MediaPlacement$TurnControlUrl' => '<p>The turn control URL.</p>', 'MediaPlacement$EventIngestionUrl' => '<p>The event ingestion URL to which you send client meeting events.</p>', ], ], 'URLExpiryInSeconds' => [ 'base' => NULL, 'refs' => [ 'GetAttachedFileRequest$UrlExpiryInSeconds' => '<p>Optional override for the expiry of the pre-signed S3 URL in seconds. The default value is 300.</p>', 'StartAttachedFileUploadRequest$UrlExpiryInSeconds' => '<p>Optional override for the expiry of the pre-signed S3 URL in seconds. The default value is 300.</p>', ], ], 'Unit' => [ 'base' => NULL, 'refs' => [ 'CurrentMetric$Unit' => '<p>The unit for the metric.</p>', 'HistoricalMetric$Unit' => '<p>The unit for the metric.</p>', ], ], 'UntagContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAgentStatusDescription' => [ 'base' => NULL, 'refs' => [ 'UpdateAgentStatusRequest$Description' => '<p>The description of the agent status.</p>', ], ], 'UpdateAgentStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAuthenticationProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCaseActionDefinition' => [ 'base' => '<p>The <code>UpdateCase</code> action definition.</p>', 'refs' => [ 'RuleAction$UpdateCaseAction' => '<p>Information about the update case action.</p> <p>Supported only for <code>TriggerEventSource</code> values: <code>OnCaseCreate</code> | <code>OnCaseUpdate</code>.</p>', ], ], 'UpdateContactAttributesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactAttributesResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactEvaluationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactEvaluationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowModuleContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowModuleContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowModuleMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowModuleMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactFlowNameResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactRoutingDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactRoutingDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactScheduleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateContactScheduleResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEvaluationFormRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEvaluationFormResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateHoursOfOperationDescription' => [ 'base' => NULL, 'refs' => [ 'UpdateHoursOfOperationRequest$Description' => '<p>The description of the hours of operation.</p>', ], ], 'UpdateHoursOfOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInstanceAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateInstanceStorageConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateParticipantRoleConfigChannelInfo' => [ 'base' => '<p>Configuration information for the chat participant role.</p>', 'refs' => [ 'UpdateParticipantRoleConfigRequest$ChannelConfiguration' => '<p>The Amazon Connect channel you want to configure.</p>', ], ], 'UpdateParticipantRoleConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateParticipantRoleConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePhoneNumberResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePredefinedAttributeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePromptRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePromptResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueHoursOfOperationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueMaxContactsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueOutboundCallerConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQueueStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQuickConnectConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateQuickConnectDescription' => [ 'base' => NULL, 'refs' => [ 'UpdateQuickConnectNameRequest$Description' => '<p>The description of the quick connect.</p>', ], ], 'UpdateQuickConnectNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingProfileAgentAvailabilityTimerRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingProfileConcurrencyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingProfileDefaultOutboundQueueRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingProfileNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRoutingProfileQueuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRuleRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTaskTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTaskTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrafficDistributionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTrafficDistributionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserHierarchyGroupNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserHierarchyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserHierarchyStructureRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserIdentityInfoRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserPhoneConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserProficienciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRoutingProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserSecurityProfilesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateViewContentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateViewContentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateViewMetadataRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateViewMetadataResponse' => [ 'base' => NULL, 'refs' => [], ], 'UploadUrlMetadata' => [ 'base' => '<p>Fields required when uploading an attached file. </p>', 'refs' => [ 'StartAttachedFileUploadResponse$UploadUrlMetadata' => '<p>Information to be used while uploading the attached file. </p>', ], ], 'Url' => [ 'base' => NULL, 'refs' => [ 'GetFederationTokenResponse$SignInUrl' => '<p>The URL to sign into the user\'s instance. </p>', 'Instance$InstanceAccessUrl' => '<p>This URL allows contact center users to access the Amazon Connect admin website.</p>', 'InstanceSummary$InstanceAccessUrl' => '<p>This URL allows contact center users to access the Amazon Connect admin website.</p>', ], ], 'UrlMetadataSignedHeaders' => [ 'base' => NULL, 'refs' => [ 'UploadUrlMetadata$HeadersToInclude' => '<p>A map of headers that should be provided when uploading the attached file. </p>', ], ], 'UrlMetadataSignedHeadersKey' => [ 'base' => NULL, 'refs' => [ 'UrlMetadataSignedHeaders$key' => NULL, ], ], 'UrlMetadataSignedHeadersValue' => [ 'base' => NULL, 'refs' => [ 'UrlMetadataSignedHeaders$value' => NULL, ], ], 'UrlReference' => [ 'base' => '<p>The URL reference.</p>', 'refs' => [ 'ReferenceSummary$Url' => '<p>Information about the reference when the <code>referenceType</code> is <code>URL</code>. Otherwise, null.</p>', ], ], 'UseCase' => [ 'base' => '<p>Contains the use case.</p>', 'refs' => [ 'UseCaseSummaryList$member' => NULL, ], ], 'UseCaseId' => [ 'base' => NULL, 'refs' => [ 'CreateUseCaseResponse$UseCaseId' => '<p>The identifier of the use case.</p>', 'DeleteUseCaseRequest$UseCaseId' => '<p>The identifier for the use case.</p>', 'UseCase$UseCaseId' => '<p>The identifier for the use case.</p>', ], ], 'UseCaseSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListUseCasesResponse$UseCaseSummaryList' => '<p>The use cases.</p>', ], ], 'UseCaseType' => [ 'base' => NULL, 'refs' => [ 'CreateUseCaseRequest$UseCaseType' => '<p>The type of use case to associate to the integration association. Each integration association can have only one of each use case type.</p>', 'UseCase$UseCaseType' => '<p>The type of use case to associate to the integration association. Each integration association can have only one of each use case type.</p>', ], ], 'User' => [ 'base' => '<p>Contains information about a user account for an Amazon Connect instance.</p>', 'refs' => [ 'DescribeUserResponse$User' => '<p>Information about the user account and configuration settings.</p>', ], ], 'UserData' => [ 'base' => '<p>Data for a user.</p>', 'refs' => [ 'UserDataList$member' => NULL, ], ], 'UserDataFilters' => [ 'base' => '<p>A filter for the user data.</p>', 'refs' => [ 'GetCurrentUserDataRequest$Filters' => '<p>The filters to apply to returned user data. You can filter up to the following limits:</p> <ul> <li> <p>Queues: 100</p> </li> <li> <p>Routing profiles: 100</p> </li> <li> <p>Agents: 100</p> </li> <li> <p>Contact states: 9</p> </li> <li> <p>User hierarchy groups: 1</p> </li> </ul> <p> The user data is retrieved for only the specified values/resources in the filter. A maximum of one filter can be passed from queues, routing profiles, agents, and user hierarchy groups. </p> <p>Currently tagging is only supported on the resources that are passed in the filter.</p>', ], ], 'UserDataHierarchyGroups' => [ 'base' => NULL, 'refs' => [ 'UserDataFilters$UserHierarchyGroups' => '<p>A UserHierarchyGroup ID or ARN.</p>', ], ], 'UserDataList' => [ 'base' => NULL, 'refs' => [ 'GetCurrentUserDataResponse$UserDataList' => '<p>A list of the user data that is returned.</p>', ], ], 'UserHierarchyGroupList' => [ 'base' => NULL, 'refs' => [ 'SearchUserHierarchyGroupsResponse$UserHierarchyGroups' => '<p>Information about the userHierarchyGroups.</p>', ], ], 'UserHierarchyGroupSearchConditionList' => [ 'base' => NULL, 'refs' => [ 'UserHierarchyGroupSearchCriteria$OrConditions' => '<p>A list of conditions which would be applied together with an OR condition.</p>', 'UserHierarchyGroupSearchCriteria$AndConditions' => '<p>A list of conditions which would be applied together with an AND condition.</p>', ], ], 'UserHierarchyGroupSearchCriteria' => [ 'base' => '<p>The search criteria to be used to return userHierarchyGroup.</p>', 'refs' => [ 'SearchUserHierarchyGroupsRequest$SearchCriteria' => '<p>The search criteria to be used to return UserHierarchyGroups.</p>', 'UserHierarchyGroupSearchConditionList$member' => NULL, ], ], 'UserHierarchyGroupSearchFilter' => [ 'base' => '<p>Filters to be applied to search results.</p>', 'refs' => [ 'SearchUserHierarchyGroupsRequest$SearchFilter' => '<p>Filters to be applied to search results.</p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'AgentsMinOneMaxHundred$member' => NULL, 'AssociateTrafficDistributionGroupUserRequest$UserId' => '<p>The identifier of the user account. This can be the ID or the ARN of the user. </p>', 'AssociateUserProficienciesRequest$UserId' => '<p>The identifier of the user account.</p>', 'CreateUserResponse$UserId' => '<p>The identifier of the user account.</p>', 'DeleteUserRequest$UserId' => '<p>The identifier of the user.</p>', 'DescribeUserRequest$UserId' => '<p>The identifier of the user account.</p>', 'DisassociateTrafficDistributionGroupUserRequest$UserId' => '<p>The identifier for the user. This can be the ID or the ARN of the user.</p>', 'DisassociateUserProficienciesRequest$UserId' => '<p>The identifier of the user account.</p>', 'DismissUserContactRequest$UserId' => '<p>The identifier of the user account.</p>', 'ListUserProficienciesRequest$UserId' => '<p>The identifier of the user account.</p>', 'PutUserStatusRequest$UserId' => '<p>The identifier of the user.</p>', 'TrafficDistributionGroupUserSummary$UserId' => '<p>The identifier for the user. This can be the ID or the ARN of the user.</p>', 'UpdateUserHierarchyRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserIdentityInfoRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserPhoneConfigRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserProficienciesRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserRoutingProfileRequest$UserId' => '<p>The identifier of the user account.</p>', 'UpdateUserSecurityProfilesRequest$UserId' => '<p>The identifier of the user account.</p>', 'User$Id' => '<p>The identifier of the user account.</p>', 'UserIdList$member' => NULL, 'UserQuickConnectConfig$UserId' => '<p>The identifier of the user.</p>', 'UserReference$Id' => '<p>The unique identifier for the user.</p>', 'UserSearchSummary$Id' => '<p>The identifier of the user\'s summary.</p>', 'UserSummary$Id' => '<p>The identifier of the user account.</p>', ], ], 'UserIdList' => [ 'base' => NULL, 'refs' => [ 'NotificationRecipientType$UserIds' => '<p>A list of user IDs.</p>', ], ], 'UserIdentityInfo' => [ 'base' => '<p>Contains information about the identity of a user.</p> <note> <p>For Amazon Connect instances that are created with the <code>EXISTING_DIRECTORY</code> identity management type, <code>FirstName</code>, <code>LastName</code>, and <code>Email</code> cannot be updated from within Amazon Connect because they are managed by the directory.</p> </note>', 'refs' => [ 'CreateUserRequest$IdentityInfo' => '<p>The information about the identity of the user.</p>', 'UpdateUserIdentityInfoRequest$IdentityInfo' => '<p>The identity information for the user.</p>', 'User$IdentityInfo' => '<p>Information about the user identity.</p>', ], ], 'UserIdentityInfoLite' => [ 'base' => '<p>The user\'s first name and last name.</p>', 'refs' => [ 'UserSearchSummary$IdentityInfo' => '<p>The user\'s first name and last name.</p>', ], ], 'UserNotFoundException' => [ 'base' => '<p>No user with the specified credentials was found in the Amazon Connect instance.</p>', 'refs' => [], ], 'UserPhoneConfig' => [ 'base' => '<p>Contains information about the phone configuration settings for a user.</p>', 'refs' => [ 'CreateUserRequest$PhoneConfig' => '<p>The phone settings for the user.</p>', 'UpdateUserPhoneConfigRequest$PhoneConfig' => '<p>Information about phone configuration settings for the user.</p>', 'User$PhoneConfig' => '<p>Information about the phone configuration for the user.</p>', 'UserSearchSummary$PhoneConfig' => NULL, ], ], 'UserProficiency' => [ 'base' => '<p>Information about proficiency of a user.</p>', 'refs' => [ 'UserProficiencyList$member' => NULL, ], ], 'UserProficiencyDisassociate' => [ 'base' => '<p>Information about proficiency to be disassociated from the user.</p>', 'refs' => [ 'UserProficiencyDisassociateList$member' => NULL, ], ], 'UserProficiencyDisassociateList' => [ 'base' => NULL, 'refs' => [ 'DisassociateUserProficienciesRequest$UserProficiencies' => '<p>The proficiencies to disassociate from the user.</p>', ], ], 'UserProficiencyList' => [ 'base' => NULL, 'refs' => [ 'AssociateUserProficienciesRequest$UserProficiencies' => '<p>The proficiencies to associate with the user.</p>', 'ListUserProficienciesResponse$UserProficiencyList' => '<p>Information about the user proficiencies.</p>', 'UpdateUserProficienciesRequest$UserProficiencies' => '<p>The proficiencies to be updated for the user. Proficiencies must first be associated to the user. You can do this using AssociateUserProficiencies API.</p>', ], ], 'UserQuickConnectConfig' => [ 'base' => '<p>Contains information about the quick connect configuration settings for a user. The contact flow must be of type Transfer to Agent.</p>', 'refs' => [ 'QuickConnectConfig$UserConfig' => '<p>The user configuration. This is required only if QuickConnectType is USER.</p>', ], ], 'UserReference' => [ 'base' => '<p>Information about the user.</p>', 'refs' => [ 'UserData$User' => '<p>Information about the user for the data that is returned. It contains the <code>resourceId</code> and ARN of the user. </p>', ], ], 'UserSearchConditionList' => [ 'base' => NULL, 'refs' => [ 'UserSearchCriteria$OrConditions' => '<p>A list of conditions which would be applied together with an <code>OR</code> condition.</p>', 'UserSearchCriteria$AndConditions' => '<p>A list of conditions which would be applied together with an <code>AND</code> condition. </p>', ], ], 'UserSearchCriteria' => [ 'base' => '<p>The search criteria to be used to return users.</p> <note> <p>The <code>name</code> and <code>description</code> fields support "contains" queries with a minimum of 2 characters and a maximum of 25 characters. Any queries with character lengths outside of this range will throw invalid results. </p> </note>', 'refs' => [ 'SearchUsersRequest$SearchCriteria' => NULL, 'UserSearchConditionList$member' => NULL, ], ], 'UserSearchFilter' => [ 'base' => '<p>Filters to be applied to search results.</p>', 'refs' => [ 'SearchUsersRequest$SearchFilter' => '<p>Filters to be applied to search results.</p>', ], ], 'UserSearchSummary' => [ 'base' => '<p>Information about the returned users.</p>', 'refs' => [ 'UserSearchSummaryList$member' => NULL, ], ], 'UserSearchSummaryList' => [ 'base' => NULL, 'refs' => [ 'SearchUsersResponse$Users' => '<p>Information about the users.</p>', ], ], 'UserSummary' => [ 'base' => '<p>Contains summary information about a user.</p>', 'refs' => [ 'UserSummaryList$member' => NULL, ], ], 'UserSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListUsersResponse$UserSummaryList' => '<p>Information about the users.</p>', ], ], 'UserTagMap' => [ 'base' => NULL, 'refs' => [ 'NotificationRecipientType$UserTags' => '<p>The tags used to organize, track, or control access for this resource. For example, { "Tags": {"key1":"value1", "key2":"value2"} }. Amazon Connect users with the specified tags will be notified.</p>', ], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'CurrentMetricData$Value' => '<p>The value of the metric.</p>', 'HistoricalMetricData$Value' => '<p>The value of the metric.</p>', 'MetricDataV2$Value' => '<p>The corresponding value of the metric returned in the response.</p>', ], ], 'VersionNumber' => [ 'base' => NULL, 'refs' => [ 'ActivateEvaluationFormRequest$EvaluationFormVersion' => '<p>The version of the evaluation form to activate. If the version property is not provided, the latest version of the evaluation form is activated.</p>', 'ActivateEvaluationFormResponse$EvaluationFormVersion' => '<p>A version of the evaluation form.</p>', 'DeactivateEvaluationFormRequest$EvaluationFormVersion' => '<p>A version of the evaluation form. If the version property is not provided, the latest version of the evaluation form is deactivated.</p>', 'DeactivateEvaluationFormResponse$EvaluationFormVersion' => '<p>The version of the deactivated evaluation form resource.</p>', 'DeleteEvaluationFormRequest$EvaluationFormVersion' => '<p>The unique identifier for the evaluation form.</p>', 'DescribeEvaluationFormRequest$EvaluationFormVersion' => '<p>A version of the evaluation form.</p>', 'EvaluationForm$EvaluationFormVersion' => '<p>A version of the evaluation form.</p>', 'EvaluationFormContent$EvaluationFormVersion' => '<p>A version of the evaluation form.</p>', 'EvaluationFormSummary$LatestVersion' => '<p>The version number of the latest evaluation form version.</p>', 'EvaluationFormSummary$ActiveVersion' => '<p>The version of the active evaluation form version.</p>', 'EvaluationFormVersionSummary$EvaluationFormVersion' => '<p>A version of the evaluation form.</p>', 'UpdateEvaluationFormRequest$EvaluationFormVersion' => '<p>A version of the evaluation form to update.</p>', 'UpdateEvaluationFormResponse$EvaluationFormVersion' => '<p>The version of the updated evaluation form resource.</p>', ], ], 'VideoCapability' => [ 'base' => NULL, 'refs' => [ 'ParticipantCapabilities$Video' => '<p>The configuration having the video sharing capabilities for participants over the call.</p>', ], ], 'View' => [ 'base' => '<p>A view resource object. Contains metadata and content necessary to render the view.</p>', 'refs' => [ 'CreateViewResponse$View' => '<p>A view resource object. Contains metadata and content necessary to render the view.</p>', 'CreateViewVersionResponse$View' => '<p>All view data is contained within the View object.</p>', 'DescribeViewResponse$View' => '<p>All view data is contained within the View object.</p>', 'UpdateViewContentResponse$View' => '<p>A view resource object. Contains metadata and content necessary to render the view.</p>', ], ], 'ViewAction' => [ 'base' => NULL, 'refs' => [ 'ViewActions$member' => NULL, ], ], 'ViewActions' => [ 'base' => NULL, 'refs' => [ 'ViewContent$Actions' => '<p>A list of possible actions from the view.</p>', 'ViewInputContent$Actions' => '<p>A list of possible actions from the view.</p>', ], ], 'ViewContent' => [ 'base' => '<p>View content containing all content necessary to render a view except for runtime input data.</p>', 'refs' => [ 'View$Content' => '<p>View content containing all content necessary to render a view except for runtime input data.</p>', ], ], 'ViewContentSha256' => [ 'base' => NULL, 'refs' => [ 'CreateViewVersionRequest$ViewContentSha256' => '<p>Indicates the checksum value of the latest published view content.</p>', 'View$ViewContentSha256' => '<p>Indicates the checksum value of the latest published view content.</p>', ], ], 'ViewDescription' => [ 'base' => NULL, 'refs' => [ 'CreateViewRequest$Description' => '<p>The description of the view.</p>', 'CreateViewVersionRequest$VersionDescription' => '<p>The description for the version being published.</p>', 'UpdateViewMetadataRequest$Description' => '<p>The description of the view.</p>', 'View$Description' => '<p>The description of the view.</p>', 'View$VersionDescription' => '<p>The description of the version.</p>', 'ViewSummary$Description' => '<p>The description of the view.</p>', 'ViewVersionSummary$Description' => '<p>The description of the view version.</p>', 'ViewVersionSummary$VersionDescription' => '<p>The description of the view version.</p>', ], ], 'ViewId' => [ 'base' => NULL, 'refs' => [ 'CreateViewVersionRequest$ViewId' => '<p>The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.</p>', 'DeleteViewRequest$ViewId' => '<p>The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.</p>', 'DeleteViewVersionRequest$ViewId' => '<p>The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.</p>', 'DescribeViewRequest$ViewId' => '<p>The ViewId of the view. This must be an ARN for Amazon Web Services managed views.</p>', 'ListViewVersionsRequest$ViewId' => '<p>The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.</p>', 'UpdateViewContentRequest$ViewId' => '<p>The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.</p>', 'UpdateViewMetadataRequest$ViewId' => '<p>The identifier of the view. Both <code>ViewArn</code> and <code>ViewId</code> can be used.</p>', 'View$Id' => '<p>The identifier of the view.</p>', 'ViewSummary$Id' => '<p>The identifier of the view.</p>', 'ViewVersionSummary$Id' => '<p>The identifier of the view version.</p>', ], ], 'ViewInputContent' => [ 'base' => '<p>View content containing all content necessary to render a view except for runtime input data and the runtime input schema, which is auto-generated by this operation.</p>', 'refs' => [ 'CreateViewRequest$Content' => '<p>View content containing all content necessary to render a view except for runtime input data.</p> <p>The total uncompressed content has a maximum file size of 400kB.</p>', 'UpdateViewContentRequest$Content' => '<p>View content containing all content necessary to render a view except for runtime input data and the runtime input schema, which is auto-generated by this operation.</p> <p>The total uncompressed content has a maximum file size of 400kB.</p>', ], ], 'ViewInputSchema' => [ 'base' => NULL, 'refs' => [ 'ViewContent$InputSchema' => '<p>The data schema matching data that the view template must be provided to render.</p>', ], ], 'ViewName' => [ 'base' => NULL, 'refs' => [ 'CreateViewRequest$Name' => '<p>The name of the view.</p>', 'UpdateViewMetadataRequest$Name' => '<p>The name of the view.</p>', 'View$Name' => '<p>The name of the view.</p>', 'ViewSummary$Name' => '<p>The name of the view.</p>', 'ViewVersionSummary$Name' => '<p>The name of the view version.</p>', ], ], 'ViewStatus' => [ 'base' => NULL, 'refs' => [ 'CreateViewRequest$Status' => '<p>Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code> status will initiate validation on the content.</p>', 'UpdateViewContentRequest$Status' => '<p>Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code> status will initiate validation on the content.</p>', 'View$Status' => '<p>Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code> status will initiate validation on the content.</p>', 'ViewSummary$Status' => '<p>Indicates the view status as either <code>SAVED</code> or <code>PUBLISHED</code>. The <code>PUBLISHED</code> status will initiate validation on the content.</p>', ], ], 'ViewSummary' => [ 'base' => '<p>A summary of a view\'s metadata.</p>', 'refs' => [ 'ViewsSummaryList$member' => NULL, ], ], 'ViewTemplate' => [ 'base' => NULL, 'refs' => [ 'ViewContent$Template' => '<p>The view template representing the structure of the view.</p>', 'ViewInputContent$Template' => '<p>The view template representing the structure of the view.</p>', ], ], 'ViewType' => [ 'base' => NULL, 'refs' => [ 'ListViewsRequest$Type' => '<p>The type of the view.</p>', 'View$Type' => '<p>The type of the view - <code>CUSTOMER_MANAGED</code>.</p>', 'ViewSummary$Type' => '<p>The type of the view.</p>', 'ViewVersionSummary$Type' => '<p>The type of the view version.</p>', ], ], 'ViewVersion' => [ 'base' => NULL, 'refs' => [ 'DeleteViewVersionRequest$ViewVersion' => '<p>The version number of the view.</p>', 'View$Version' => '<p>Current version of the view.</p>', 'ViewVersionSummary$Version' => '<p>The sequentially incremented version of the view version.</p>', ], ], 'ViewVersionSummary' => [ 'base' => '<p>A summary of a view version\'s metadata.</p>', 'refs' => [ 'ViewVersionSummaryList$member' => NULL, ], ], 'ViewVersionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListViewVersionsResponse$ViewVersionSummaryList' => '<p>A list of view version summaries.</p>', ], ], 'ViewsClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateViewRequest$ClientToken' => '<p>A unique Id for each create view request to avoid duplicate view creation. For example, the view is idempotent ClientToken is provided.</p>', ], ], 'ViewsInstanceId' => [ 'base' => NULL, 'refs' => [ 'CreateViewRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'CreateViewVersionRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DeleteViewRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DeleteViewVersionRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'DescribeViewRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListViewVersionsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'ListViewsRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateViewContentRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', 'UpdateViewMetadataRequest$InstanceId' => '<p>The identifier of the Amazon Connect instance. You can find the instanceId in the ARN of the instance.</p>', ], ], 'ViewsNextToken' => [ 'base' => NULL, 'refs' => [ 'ListViewVersionsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListViewVersionsResponse$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListViewsRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListViewsResponse$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', ], ], 'ViewsSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListViewsResponse$ViewsSummaryList' => '<p>A list of view summaries.</p>', ], ], 'Vocabulary' => [ 'base' => '<p>Contains information about a custom vocabulary.</p>', 'refs' => [ 'DescribeVocabularyResponse$Vocabulary' => '<p>A list of specific words that you want Contact Lens for Amazon Connect to recognize in your audio input. They are generally domain-specific words and phrases, words that Contact Lens is not recognizing, or proper nouns.</p>', ], ], 'VocabularyContent' => [ 'base' => NULL, 'refs' => [ 'CreateVocabularyRequest$Content' => '<p>The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with <code>Phrase</code>, <code>IPA</code>, <code>SoundsLike</code>, and <code>DisplayAs</code> fields. Separate the fields with TAB characters. The size limit is 50KB. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table">Create a custom vocabulary using a table</a>.</p>', 'Vocabulary$Content' => '<p>The content of the custom vocabulary in plain-text format with a table of values. Each row in the table represents a word or a phrase, described with <code>Phrase</code>, <code>IPA</code>, <code>SoundsLike</code>, and <code>DisplayAs</code> fields. Separate the fields with TAB characters. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table">Create a custom vocabulary using a table</a>.</p>', ], ], 'VocabularyFailureReason' => [ 'base' => NULL, 'refs' => [ 'Vocabulary$FailureReason' => '<p>The reason why the custom vocabulary was not created.</p>', 'VocabularySummary$FailureReason' => '<p>The reason why the custom vocabulary was not created.</p>', ], ], 'VocabularyId' => [ 'base' => NULL, 'refs' => [ 'AssociateDefaultVocabularyRequest$VocabularyId' => '<p>The identifier of the custom vocabulary. If this is empty, the default is set to none.</p>', 'CreateVocabularyResponse$VocabularyId' => '<p>The identifier of the custom vocabulary.</p>', 'DefaultVocabulary$VocabularyId' => '<p>The identifier of the custom vocabulary.</p>', 'DeleteVocabularyRequest$VocabularyId' => '<p>The identifier of the custom vocabulary.</p>', 'DeleteVocabularyResponse$VocabularyId' => '<p>The identifier of the custom vocabulary.</p>', 'DescribeVocabularyRequest$VocabularyId' => '<p>The identifier of the custom vocabulary.</p>', 'Vocabulary$Id' => '<p>The identifier of the custom vocabulary.</p>', 'VocabularySummary$Id' => '<p>The identifier of the custom vocabulary.</p>', ], ], 'VocabularyLanguageCode' => [ 'base' => NULL, 'refs' => [ 'AssociateDefaultVocabularyRequest$LanguageCode' => '<p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>', 'CreateVocabularyRequest$LanguageCode' => '<p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>', 'DefaultVocabulary$LanguageCode' => '<p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>', 'ListDefaultVocabulariesRequest$LanguageCode' => '<p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>', 'SearchVocabulariesRequest$LanguageCode' => '<p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>', 'Vocabulary$LanguageCode' => '<p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>', 'VocabularySummary$LanguageCode' => '<p>The language code of the vocabulary entries. For a list of languages and their corresponding language codes, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html">What is Amazon Transcribe?</a> </p>', ], ], 'VocabularyLastModifiedTime' => [ 'base' => NULL, 'refs' => [ 'Vocabulary$LastModifiedTime' => '<p>The timestamp when the custom vocabulary was last modified.</p>', 'VocabularySummary$LastModifiedTime' => '<p>The timestamp when the custom vocabulary was last modified.</p>', ], ], 'VocabularyName' => [ 'base' => NULL, 'refs' => [ 'CreateVocabularyRequest$VocabularyName' => '<p>A unique name of the custom vocabulary.</p>', 'DefaultVocabulary$VocabularyName' => '<p>A unique name of the custom vocabulary.</p>', 'SearchVocabulariesRequest$NameStartsWith' => '<p>The starting pattern of the name of the vocabulary.</p>', 'Vocabulary$Name' => '<p>A unique name of the custom vocabulary.</p>', 'VocabularySummary$Name' => '<p>A unique name of the custom vocabulary.</p>', ], ], 'VocabularyNextToken' => [ 'base' => NULL, 'refs' => [ 'ListDefaultVocabulariesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'ListDefaultVocabulariesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', 'SearchVocabulariesRequest$NextToken' => '<p>The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results.</p>', 'SearchVocabulariesResponse$NextToken' => '<p>If there are additional results, this is the token for the next set of results.</p>', ], ], 'VocabularyState' => [ 'base' => NULL, 'refs' => [ 'CreateVocabularyResponse$State' => '<p>The current state of the custom vocabulary.</p>', 'DeleteVocabularyResponse$State' => '<p>The current state of the custom vocabulary.</p>', 'SearchVocabulariesRequest$State' => '<p>The current state of the custom vocabulary.</p>', 'Vocabulary$State' => '<p>The current state of the custom vocabulary.</p>', 'VocabularySummary$State' => '<p>The current state of the custom vocabulary.</p>', ], ], 'VocabularySummary' => [ 'base' => '<p>Contains summary information about the custom vocabulary.</p>', 'refs' => [ 'VocabularySummaryList$member' => NULL, ], ], 'VocabularySummaryList' => [ 'base' => NULL, 'refs' => [ 'SearchVocabulariesResponse$VocabularySummaryList' => '<p>The list of the available custom vocabularies.</p>', ], ], 'VoiceRecordingConfiguration' => [ 'base' => '<p>Contains information about the recording configuration settings.</p>', 'refs' => [ 'StartContactRecordingRequest$VoiceRecordingConfiguration' => '<p>The person being recorded.</p>', ], ], 'VoiceRecordingTrack' => [ 'base' => NULL, 'refs' => [ 'VoiceRecordingConfiguration$VoiceRecordingTrack' => '<p>Identifies which track is being recorded.</p>', ], ], 'WisdomInfo' => [ 'base' => '<p>Information about Amazon Connect Wisdom.</p>', 'refs' => [ 'Contact$WisdomInfo' => '<p>Information about Amazon Connect Wisdom.</p>', ], ], 'resourceArnListMaxLimit100' => [ 'base' => NULL, 'refs' => [ 'BatchGetFlowAssociationRequest$ResourceIds' => '<p>A list of resource identifiers to retrieve flow associations.</p>', ], ], 'timestamp' => [ 'base' => NULL, 'refs' => [ 'AgentInfo$ConnectedToAgentTimestamp' => '<p>The timestamp when the contact was connected to the agent.</p>', 'Contact$InitiationTimestamp' => '<p>The date and time this contact was initiated, in UTC time. For <code>INBOUND</code>, this is when the contact arrived. For <code>OUTBOUND</code>, this is when the agent began dialing. For <code>CALLBACK</code>, this is when the callback contact was created. For <code>TRANSFER</code> and <code>QUEUE_TRANSFER</code>, this is when the transfer was initiated. For <code>API</code>, this is when the request arrived. For <code>EXTERNAL_OUTBOUND</code>, this is when the agent started dialing the external participant. For <code>MONITOR</code>, this is when the supervisor started listening to a contact.</p>', 'Contact$DisconnectTimestamp' => '<p>The timestamp when the customer endpoint disconnected from Amazon Connect.</p>', 'Contact$LastUpdateTimestamp' => '<p>The timestamp when contact was last updated.</p>', 'Contact$LastPausedTimestamp' => '<p>The timestamp when the contact was last paused.</p>', 'Contact$LastResumedTimestamp' => '<p>The timestamp when the contact was last resumed.</p>', 'Contact$ScheduledTimestamp' => '<p>The timestamp, in Unix epoch time format, at which to start running the inbound flow. </p>', 'Contact$ConnectedToSystemTimestamp' => '<p>The timestamp when customer endpoint connected to Amazon Connect.</p>', 'ContactSearchSummary$InitiationTimestamp' => '<p>The date and time this contact was initiated, in UTC time. For <code>INBOUND</code>, this is when the contact arrived. For <code>OUTBOUND</code>, this is when the agent began dialing. For <code>CALLBACK</code>, this is when the callback contact was created. For <code>TRANSFER</code> and <code>QUEUE_TRANSFER</code>, this is when the transfer was initiated. For API, this is when the request arrived. For <code>EXTERNAL_OUTBOUND</code>, this is when the agent started dialing the external participant. For <code>MONITOR</code>, this is when the supervisor started listening to a contact.</p>', 'ContactSearchSummary$DisconnectTimestamp' => '<p>The timestamp when the customer endpoint disconnected from Amazon Connect.</p>', 'ContactSearchSummary$ScheduledTimestamp' => '<p>The timestamp, in Unix epoch time format, at which to start running the inbound flow.</p>', 'ContactSearchSummaryAgentInfo$ConnectedToAgentTimestamp' => '<p>The timestamp when the contact was connected to the agent.</p>', 'ContactSearchSummaryQueueInfo$EnqueueTimestamp' => '<p>The timestamp when the contact was added to the queue.</p>', 'Credentials$AccessTokenExpiration' => '<p>A token generated with an expiration time for the session a user is logged in to Amazon Connect.</p>', 'Credentials$RefreshTokenExpiration' => '<p>Renews the expiration timer for a generated token.</p>', 'CustomerVoiceActivity$GreetingStartTimestamp' => '<p>Timestamp that measures the beginning of the customer greeting from an outbound voice call.</p>', 'CustomerVoiceActivity$GreetingEndTimestamp' => '<p>Timestamp that measures the end of the customer greeting from an outbound voice call.</p>', 'Expiry$ExpiryTimestamp' => '<p>The timestamp indicating when the routing step expires.</p>', 'GetCurrentMetricDataResponse$DataSnapshotTime' => '<p>The time at which the metrics were retrieved and cached for pagination.</p>', 'GetMetricDataRequest$StartTime' => '<p>The timestamp, in UNIX Epoch time format, at which to start the reporting interval for the retrieval of historical metrics data. The time must be specified using a multiple of 5 minutes, such as 10:05, 10:10, 10:15.</p> <p>The start time cannot be earlier than 24 hours before the time of the request. Historical metrics are available only for 24 hours.</p>', 'GetMetricDataRequest$EndTime' => '<p>The timestamp, in UNIX Epoch time format, at which to end the reporting interval for the retrieval of historical metrics data. The time must be specified using an interval of 5 minutes, such as 11:00, 11:05, 11:10, and must be later than the start time timestamp.</p> <p>The time range between the start and end time must be less than 24 hours.</p>', 'GetTaskTemplateResponse$LastModifiedTime' => '<p>The timestamp when the task template was last modified.</p>', 'GetTaskTemplateResponse$CreatedTime' => '<p>The timestamp when the task template was created.</p>', 'QueueInfo$EnqueueTimestamp' => '<p>The timestamp when the contact was added to the queue.</p>', 'RoutingCriteria$ActivationTimestamp' => '<p>The timestamp indicating when the routing criteria is set to active. A routing criteria is activated when contact is transferred to a queue. ActivationTimestamp will be set on routing criteria for contacts in agent queue even though Routing criteria is never activated for contacts in agent queue.</p>', 'SecurityKey$CreationTime' => '<p>When the security key was created.</p>', 'TaskTemplateMetadata$LastModifiedTime' => '<p>The timestamp when the task template was last modified.</p>', 'TaskTemplateMetadata$CreatedTime' => '<p>The timestamp when the task template was created.</p>', 'UpdateTaskTemplateResponse$LastModifiedTime' => '<p>The timestamp when the task template was last modified.</p>', 'UpdateTaskTemplateResponse$CreatedTime' => '<p>The timestamp when the task template was created.</p>', ], ], ],];
