<?php
// This file was auto-generated from sdk-root/src/data/discovery/2015-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon Web Services Application Discovery Service</fullname> <p>Amazon Web Services Application Discovery Service (Application Discovery Service) helps you plan application migration projects. It automatically identifies servers, virtual machines (VMs), and network dependencies in your on-premises data centers. For more information, see the <a href="http://aws.amazon.com/application-discovery/faqs/">Amazon Web Services Application Discovery Service FAQ</a>. </p> <p>Application Discovery Service offers three ways of performing discovery and collecting data about your on-premises servers:</p> <ul> <li> <p> <b>Agentless discovery</b> using Amazon Web Services Application Discovery Service Agentless Collector (Agentless Collector), which doesn\'t require you to install an agent on each host.</p> <ul> <li> <p>Agentless Collector gathers server information regardless of the operating systems, which minimizes the time required for initial on-premises infrastructure assessment.</p> </li> <li> <p>Agentless Collector doesn\'t collect information about network dependencies, only agent-based discovery collects that information. </p> </li> </ul> </li> </ul> <ul> <li> <p> <b>Agent-based discovery</b> using the Amazon Web Services Application Discovery Agent (Application Discovery Agent) collects a richer set of data than agentless discovery, which you install on one or more hosts in your data center.</p> <ul> <li> <p> The agent captures infrastructure and application information, including an inventory of running processes, system performance information, resource utilization, and network dependencies.</p> </li> <li> <p>The information collected by agents is secured at rest and in transit to the Application Discovery Service database in the Amazon Web Services cloud. For more information, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-agent.html">Amazon Web Services Application Discovery Agent</a>.</p> </li> </ul> </li> </ul> <ul> <li> <p> <b>Amazon Web Services Partner Network (APN) solutions</b> integrate with Application Discovery Service, enabling you to import details of your on-premises environment directly into Amazon Web Services Migration Hub (Migration Hub) without using Agentless Collector or Application Discovery Agent.</p> <ul> <li> <p>Third-party application discovery tools can query Amazon Web Services Application Discovery Service, and they can write to the Application Discovery Service database using the public API.</p> </li> <li> <p>In this way, you can import data into Migration Hub and view it, so that you can associate applications with servers and track migrations.</p> </li> </ul> </li> </ul> <p> <b>Working With This Guide</b> </p> <p>This API reference provides descriptions, syntax, and usage examples for each of the actions and data types for Application Discovery Service. The topic for each action shows the API request parameters and the response. Alternatively, you can use one of the Amazon Web Services SDKs to access an API that is tailored to the programming language or platform that you\'re using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">Amazon Web Services SDKs</a>.</p> <note> <ul> <li> <p>Remember that you must set your Migration Hub home Region before you call any of these APIs.</p> </li> <li> <p>You must make API calls for write actions (create, notify, associate, disassociate, import, or put) while in your home Region, or a <code>HomeRegionNotSetException</code> error is returned.</p> </li> <li> <p>API calls for read actions (list, describe, stop, and delete) are permitted outside of your home Region.</p> </li> <li> <p>Although it is unlikely, the Migration Hub home Region could change. If you call APIs outside the home Region, an <code>InvalidInputException</code> is returned.</p> </li> <li> <p>You must call <code>GetHomeRegion</code> to obtain the latest Migration Hub home Region.</p> </li> </ul> </note> <p>This guide is intended for use with the <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/">Amazon Web Services Application Discovery Service User Guide</a>.</p> <important> <p>All data is handled according to the <a href="https://aws.amazon.com/privacy/">Amazon Web Services Privacy Policy</a>. You can operate Application Discovery Service offline to inspect collected data before it is shared with the service.</p> </important>', 'operations' => [ 'AssociateConfigurationItemsToApplication' => '<p>Associates one or more configuration items with an application.</p>', 'BatchDeleteAgents' => '<p> Deletes one or more agents or collectors as specified by ID. Deleting an agent or collector does not delete the previously discovered data. To delete the data collected, use <code>StartBatchDeleteConfigurationTask</code>. </p>', 'BatchDeleteImportData' => '<p>Deletes one or more import tasks, each identified by their import ID. Each import task has a number of records that can identify servers or applications. </p> <p>Amazon Web Services Application Discovery Service has built-in matching logic that will identify when discovered servers match existing entries that you\'ve previously discovered, the information for the already-existing discovered server is updated. When you delete an import task that contains records that were used to match, the information in those matched records that comes from the deleted records will also be deleted.</p>', 'CreateApplication' => '<p>Creates an application with the given name and description.</p>', 'CreateTags' => '<p>Creates one or more tags for configuration items. Tags are metadata that help you categorize IT assets. This API accepts a list of multiple configuration items.</p> <important> <p>Do not store sensitive information (like personal data) in tags.</p> </important>', 'DeleteApplications' => '<p>Deletes a list of applications and their associations with configuration items.</p>', 'DeleteTags' => '<p>Deletes the association between configuration items and one or more tags. This API accepts a list of multiple configuration items.</p>', 'DescribeAgents' => '<p>Lists agents or collectors as specified by ID or other filters. All agents/collectors associated with your user can be listed if you call <code>DescribeAgents</code> as is without passing any parameters.</p>', 'DescribeBatchDeleteConfigurationTask' => '<p> Takes a unique deletion task identifier as input and returns metadata about a configuration deletion task.</p>', 'DescribeConfigurations' => '<p>Retrieves attributes for a list of configuration item IDs.</p> <note> <p>All of the supplied IDs must be for the same asset type from one of the following:</p> <ul> <li> <p>server</p> </li> <li> <p>application</p> </li> <li> <p>process</p> </li> <li> <p>connection</p> </li> </ul> <p>Output fields are specific to the asset type specified. For example, the output for a <i>server</i> configuration item includes a list of attributes about the server, such as host name, operating system, number of network cards, etc.</p> <p>For a complete list of outputs for each asset type, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#DescribeConfigurations">Using the DescribeConfigurations Action</a> in the <i>Amazon Web Services Application Discovery Service User Guide</i>.</p> </note>', 'DescribeContinuousExports' => '<p>Lists exports as specified by ID. All continuous exports associated with your user can be listed if you call <code>DescribeContinuousExports</code> as is without passing any parameters.</p>', 'DescribeExportConfigurations' => '<p> <code>DescribeExportConfigurations</code> is deprecated. Use <a href="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeExportTasks.html">DescribeExportTasks</a>, instead.</p>', 'DescribeExportTasks' => '<p>Retrieve status of one or more export tasks. You can retrieve the status of up to 100 export tasks.</p>', 'DescribeImportTasks' => '<p>Returns an array of import tasks for your account, including status information, times, IDs, the Amazon S3 Object URL for the import file, and more.</p>', 'DescribeTags' => '<p>Retrieves a list of configuration items that have tags as specified by the key-value pairs, name and value, passed to the optional parameter <code>filters</code>.</p> <p>There are three valid tag filter names:</p> <ul> <li> <p>tagKey</p> </li> <li> <p>tagValue</p> </li> <li> <p>configurationId</p> </li> </ul> <p>Also, all configuration items associated with your user that have tags can be listed if you call <code>DescribeTags</code> as is without passing any parameters.</p>', 'DisassociateConfigurationItemsFromApplication' => '<p>Disassociates one or more configuration items from an application.</p>', 'ExportConfigurations' => '<p>Deprecated. Use <code>StartExportTask</code> instead.</p> <p>Exports all discovered configuration data to an Amazon S3 bucket or an application that enables you to view and evaluate the data. Data includes tags and tag associations, processes, connections, servers, and system performance. This API returns an export ID that you can query using the <i>DescribeExportConfigurations</i> API. The system imposes a limit of two configuration exports in six hours.</p>', 'GetDiscoverySummary' => '<p>Retrieves a short summary of discovered assets.</p> <p>This API operation takes no request parameters and is called as is at the command prompt as shown in the example.</p>', 'ListConfigurations' => '<p>Retrieves a list of configuration items as specified by the value passed to the required parameter <code>configurationType</code>. Optional filtering may be applied to refine search results.</p>', 'ListServerNeighbors' => '<p>Retrieves a list of servers that are one network hop away from a specified server.</p>', 'StartBatchDeleteConfigurationTask' => '<p> Takes a list of configurationId as input and starts an asynchronous deletion task to remove the configurationItems. Returns a unique deletion task identifier. </p>', 'StartContinuousExport' => '<p>Start the continuous flow of agent\'s discovered data into Amazon Athena.</p>', 'StartDataCollectionByAgentIds' => '<p>Instructs the specified agents to start collecting data.</p>', 'StartExportTask' => '<p>Begins the export of a discovered data report to an Amazon S3 bucket managed by Amazon Web Services.</p> <note> <p>Exports might provide an estimate of fees and savings based on certain information that you provide. Fee estimates do not include any taxes that might apply. Your actual fees and savings depend on a variety of factors, including your actual usage of Amazon Web Services services, which might vary from the estimates provided in this report.</p> </note> <p>If you do not specify <code>preferences</code> or <code>agentIds</code> in the filter, a summary of all servers, applications, tags, and performance is generated. This data is an aggregation of all server data collected through on-premises tooling, file import, application grouping and applying tags.</p> <p>If you specify <code>agentIds</code> in a filter, the task exports up to 72 hours of detailed data collected by the identified Application Discovery Agent, including network, process, and performance details. A time range for exported agent data may be set by using <code>startTime</code> and <code>endTime</code>. Export of detailed agent data is limited to five concurrently running exports. Export of detailed agent data is limited to two exports per day.</p> <p>If you enable <code>ec2RecommendationsPreferences</code> in <code>preferences</code> , an Amazon EC2 instance matching the characteristics of each server in Application Discovery Service is generated. Changing the attributes of the <code>ec2RecommendationsPreferences</code> changes the criteria of the recommendation.</p>', 'StartImportTask' => '<p>Starts an import task, which allows you to import details of your on-premises environment directly into Amazon Web Services Migration Hub without having to use the Amazon Web Services Application Discovery Service (Application Discovery Service) tools such as the Amazon Web Services Application Discovery Service Agentless Collector or Application Discovery Agent. This gives you the option to perform migration assessment and planning directly from your imported data, including the ability to group your devices as applications and track their migration status.</p> <p>To start an import request, do this:</p> <ol> <li> <p>Download the specially formatted comma separated value (CSV) import template, which you can find here: <a href="https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv">https://s3.us-west-2.amazonaws.com/templates-7cffcf56-bd96-4b1c-b45b-a5b42f282e46/import_template.csv</a>.</p> </li> <li> <p>Fill out the template with your server and application data.</p> </li> <li> <p>Upload your import file to an Amazon S3 bucket, and make a note of it\'s Object URL. Your import file must be in the CSV format.</p> </li> <li> <p>Use the console or the <code>StartImportTask</code> command with the Amazon Web Services CLI or one of the Amazon Web Services SDKs to import the records from your file.</p> </li> </ol> <p>For more information, including step-by-step procedures, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-import.html">Migration Hub Import</a> in the <i>Amazon Web Services Application Discovery Service User Guide</i>.</p> <note> <p>There are limits to the number of import tasks you can create (and delete) in an Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/ads_service_limits.html">Amazon Web Services Application Discovery Service Limits</a> in the <i>Amazon Web Services Application Discovery Service User Guide</i>.</p> </note>', 'StopContinuousExport' => '<p>Stop the continuous flow of agent\'s discovered data into Amazon Athena.</p>', 'StopDataCollectionByAgentIds' => '<p>Instructs the specified agents to stop collecting data.</p>', 'UpdateApplication' => '<p>Updates metadata about an application.</p>', ], 'shapes' => [ 'AgentConfigurationStatus' => [ 'base' => '<p>Information about agents that were instructed to start collecting data. Information includes the agent ID, a description of the operation, and whether the agent configuration was updated.</p>', 'refs' => [ 'AgentConfigurationStatusList$member' => NULL, ], ], 'AgentConfigurationStatusList' => [ 'base' => NULL, 'refs' => [ 'StartDataCollectionByAgentIdsResponse$agentsConfigurationStatus' => '<p>Information about agents that were instructed to start collecting data. Information includes the agent ID, a description of the operation performed, and whether the agent configuration was updated.</p>', 'StopDataCollectionByAgentIdsResponse$agentsConfigurationStatus' => '<p>Information about the agents that were instructed to stop collecting data. Information includes the agent ID, a description of the operation performed, and whether the agent configuration was updated.</p>', ], ], 'AgentId' => [ 'base' => NULL, 'refs' => [ 'AgentIds$member' => NULL, 'AgentInfo$agentId' => '<p>The agent or collector ID.</p>', 'BatchDeleteAgentError$agentId' => '<p> The ID of the agent or data collector to delete. </p>', 'DeleteAgent$agentId' => '<p> The ID of the agent or data collector to delete. </p>', ], ], 'AgentIds' => [ 'base' => NULL, 'refs' => [ 'DescribeAgentsRequest$agentIds' => '<p>The agent or the collector IDs for which you want information. If you specify no IDs, the system returns information about all agents/collectors associated with your user.</p>', 'StartDataCollectionByAgentIdsRequest$agentIds' => '<p>The IDs of the agents from which to start collecting data. If you send a request to an agent ID that you do not have permission to contact, according to your Amazon Web Services account, the service does not throw an exception. Instead, it returns the error in the <i>Description</i> field. If you send a request to multiple agents and you do not have permission to contact some of those agents, the system does not throw an exception. Instead, the system shows <code>Failed</code> in the <i>Description</i> field.</p>', 'StopDataCollectionByAgentIdsRequest$agentIds' => '<p>The IDs of the agents from which to stop collecting data.</p>', ], ], 'AgentInfo' => [ 'base' => '<p>Information about agents associated with the user’s Amazon Web Services account. Information includes agent IDs, IP addresses, media access control (MAC) addresses, agent or collector status, hostname where the agent resides, and agent version for each agent.</p>', 'refs' => [ 'AgentsInfo$member' => NULL, ], ], 'AgentNetworkInfo' => [ 'base' => '<p>Network details about the host where the agent/collector resides.</p>', 'refs' => [ 'AgentNetworkInfoList$member' => NULL, ], ], 'AgentNetworkInfoList' => [ 'base' => NULL, 'refs' => [ 'AgentInfo$agentNetworkInfoList' => '<p>Network details about the host where the agent or collector resides.</p>', ], ], 'AgentStatus' => [ 'base' => NULL, 'refs' => [ 'AgentInfo$health' => '<p>The health of the agent.</p>', ], ], 'AgentsInfo' => [ 'base' => NULL, 'refs' => [ 'DescribeAgentsResponse$agentsInfo' => '<p>Lists agents or the collector by ID or lists all agents/collectors associated with your user, if you did not specify an agent/collector ID. The output includes agent/collector IDs, IP addresses, media access control (MAC) addresses, agent/collector health, host name where the agent/collector resides, and the version number of each agent/collector.</p>', ], ], 'ApplicationDescription' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$description' => '<p>Description of the application to be created.</p>', 'UpdateApplicationRequest$description' => '<p>New description of the application to be updated.</p>', ], ], 'ApplicationId' => [ 'base' => NULL, 'refs' => [ 'ApplicationIdsList$member' => NULL, 'AssociateConfigurationItemsToApplicationRequest$applicationConfigurationId' => '<p>The configuration ID of an application with which items are to be associated.</p>', 'DisassociateConfigurationItemsFromApplicationRequest$applicationConfigurationId' => '<p>Configuration ID of an application from which each item is disassociated.</p>', 'UpdateApplicationRequest$configurationId' => '<p>Configuration ID of the application to be updated.</p>', ], ], 'ApplicationIdsList' => [ 'base' => NULL, 'refs' => [ 'DeleteApplicationsRequest$configurationIds' => '<p>Configuration ID of an application to be deleted.</p>', ], ], 'ApplicationName' => [ 'base' => NULL, 'refs' => [ 'CreateApplicationRequest$name' => '<p>Name of the application to be created.</p>', 'UpdateApplicationRequest$name' => '<p>New name of the application to be updated.</p>', ], ], 'AssociateConfigurationItemsToApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateConfigurationItemsToApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizationErrorException' => [ 'base' => '<p>The user does not have permission to perform the action. Check the IAM policy associated with this user.</p>', 'refs' => [], ], 'BatchDeleteAgentError' => [ 'base' => '<p> An object representing the agent or data collector that failed to delete, each containing agentId, errorMessage, and errorCode. </p>', 'refs' => [ 'BatchDeleteAgentErrors$member' => NULL, ], ], 'BatchDeleteAgentErrors' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteAgentsResponse$errors' => '<p> A list of agent IDs that failed to delete during the deletion task, each paired with an error message. </p>', ], ], 'BatchDeleteAgentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteAgentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteConfigurationTask' => [ 'base' => '<p> A metadata object that represents the deletion task being executed. </p>', 'refs' => [ 'DescribeBatchDeleteConfigurationTaskResponse$task' => '<p> The <code>BatchDeleteConfigurationTask</code> that represents the deletion task being executed. </p>', ], ], 'BatchDeleteConfigurationTaskStatus' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteConfigurationTask$status' => '<p> The current execution status of the deletion task. Valid status are: INITIALIZING | VALIDATING | DELETING | COMPLETED | FAILED. </p>', ], ], 'BatchDeleteImportDataError' => [ 'base' => '<p>Error messages returned for each import task that you deleted as a response for this command.</p>', 'refs' => [ 'BatchDeleteImportDataErrorList$member' => NULL, ], ], 'BatchDeleteImportDataErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteImportDataError$errorCode' => '<p>The type of error that occurred for a specific import task.</p>', ], ], 'BatchDeleteImportDataErrorDescription' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteImportDataError$errorDescription' => '<p>The description of the error that occurred for a specific import task.</p>', ], ], 'BatchDeleteImportDataErrorList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteImportDataResponse$errors' => '<p>Error messages returned for each import task that you deleted as a response for this command.</p>', ], ], 'BatchDeleteImportDataRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteImportDataResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AgentConfigurationStatus$operationSucceeded' => '<p>Information about the status of the <code>StartDataCollection</code> and <code>StopDataCollection</code> operations. The system has recorded the data collection operation. The agent receives this command the next time it polls for a new command. </p>', 'BatchDeleteImportDataRequest$deleteHistory' => '<p> Set to <code>true</code> to remove the deleted import task from <a>DescribeImportTasks</a>. </p>', 'DeleteAgent$force' => '<p> Optional flag used to force delete an agent or data collector. It is needed to delete any agent in HEALTHY/UNHEALTHY/RUNNING status. Note that deleting an agent that is actively reporting health causes it to be re-registered with a different agent ID after data collector re-connects with Amazon Web Services. </p>', 'ExportInfo$isTruncated' => '<p>If true, the export of agent information exceeded the size limit for a single export and the exported data is incomplete for the requested time range. To address this, select a smaller time range for the export by using <code>startDate</code> and <code>endDate</code>.</p>', 'ListServerNeighborsRequest$portInformationNeeded' => '<p>Flag to indicate if port and protocol information is needed as part of the response.</p>', ], ], 'BoxedInteger' => [ 'base' => NULL, 'refs' => [ 'NeighborConnectionDetail$destinationPort' => '<p>The destination network port for the connection.</p>', ], ], 'ClientRequestToken' => [ 'base' => NULL, 'refs' => [ 'ImportTask$clientRequestToken' => '<p>A unique token used to prevent the same import request from occurring more than once. If you didn\'t provide a token, a token was automatically generated when the import task request was sent.</p>', 'StartImportTaskRequest$clientRequestToken' => '<p>Optional. A unique token that you can provide to prevent the same import request from occurring more than once. If you don\'t provide a token, a token is automatically generated.</p> <p>Sending more than one <code>StartImportTask</code> request with the same client request token will return information about the original import task with that client request token.</p>', ], ], 'Condition' => [ 'base' => NULL, 'refs' => [ 'ExportFilter$condition' => '<p>Supported condition: <code>EQUALS</code> </p>', 'Filter$condition' => '<p>A conditional operator. The following operators are valid: EQUALS, NOT_EQUALS, CONTAINS, NOT_CONTAINS. If you specify multiple filters, the system utilizes all filters as though concatenated by <i>AND</i>. If you specify multiple values for a particular filter, the system differentiates the values using <i>OR</i>. Calling either <i>DescribeConfigurations</i> or <i>ListConfigurations</i> returns attributes of matching configuration items.</p>', ], ], 'Configuration' => [ 'base' => NULL, 'refs' => [ 'Configurations$member' => NULL, ], ], 'ConfigurationId' => [ 'base' => NULL, 'refs' => [ 'ConfigurationIdList$member' => NULL, 'ConfigurationTag$configurationId' => '<p>The configuration ID for the item to tag. You can specify a list of keys and values.</p>', 'DeletionWarning$configurationId' => '<p> The unique identifier of the configuration that produced a warning. </p>', 'FailedConfiguration$configurationId' => '<p> The unique identifier of the configuration the failed to delete. </p>', 'ListServerNeighborsRequest$configurationId' => '<p>Configuration ID of the server for which neighbors are being listed.</p>', 'NeighborConnectionDetail$sourceServerId' => '<p>The ID of the server that opened the network connection.</p>', 'NeighborConnectionDetail$destinationServerId' => '<p>The ID of the server that accepted the network connection.</p>', ], ], 'ConfigurationIdList' => [ 'base' => NULL, 'refs' => [ 'AssociateConfigurationItemsToApplicationRequest$configurationIds' => '<p>The ID of each configuration item to be associated with an application.</p>', 'BatchDeleteConfigurationTask$requestedConfigurations' => '<p> The list of configuration IDs that were originally requested to be deleted by the deletion task. </p>', 'BatchDeleteConfigurationTask$deletedConfigurations' => '<p> The list of configuration IDs that were successfully deleted by the deletion task. </p>', 'CreateTagsRequest$configurationIds' => '<p>A list of configuration items that you want to tag.</p>', 'DeleteTagsRequest$configurationIds' => '<p>A list of configuration items with tags that you want to delete.</p>', 'DescribeConfigurationsRequest$configurationIds' => '<p>One or more configuration IDs.</p>', 'DisassociateConfigurationItemsFromApplicationRequest$configurationIds' => '<p>Configuration ID of each item to be disassociated from an application.</p>', 'ListServerNeighborsRequest$neighborConfigurationIds' => '<p>List of configuration IDs to test for one-hop-away.</p>', 'StartBatchDeleteConfigurationTaskRequest$configurationIds' => '<p> The list of configuration IDs that will be deleted by the task. </p>', ], ], 'ConfigurationItemType' => [ 'base' => NULL, 'refs' => [ 'ConfigurationTag$configurationType' => '<p>A type of IT asset to tag.</p>', 'ListConfigurationsRequest$configurationType' => '<p>A valid configuration identified by Application Discovery Service. </p>', ], ], 'ConfigurationTag' => [ 'base' => '<p>Tags for a configuration item. Tags are metadata that help you categorize IT assets.</p>', 'refs' => [ 'ConfigurationTagSet$member' => NULL, ], ], 'ConfigurationTagSet' => [ 'base' => NULL, 'refs' => [ 'DescribeTagsResponse$tags' => '<p>Depending on the input, this is a list of configuration items tagged with a specific tag, or a list of tags for a specific configuration item.</p>', ], ], 'Configurations' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationsResponse$configurations' => '<p>Returns configuration details, including the configuration ID, attribute names, and attribute values.</p>', ], ], 'ConfigurationsDownloadUrl' => [ 'base' => NULL, 'refs' => [ 'ExportInfo$configurationsDownloadUrl' => '<p>A URL for an Amazon S3 bucket where you can review the exported data. The URL is displayed only if the export succeeded.</p>', ], ], 'ConfigurationsExportId' => [ 'base' => NULL, 'refs' => [ 'ContinuousExportDescription$exportId' => '<p>The unique ID assigned to this export.</p>', 'ContinuousExportIds$member' => NULL, 'ExportConfigurationsResponse$exportId' => '<p>A unique identifier that you can use to query the export status.</p>', 'ExportIds$member' => NULL, 'ExportInfo$exportId' => '<p>A unique identifier used to query an export.</p>', 'StartContinuousExportResponse$exportId' => '<p>The unique ID assigned to this export.</p>', 'StartExportTaskResponse$exportId' => '<p>A unique identifier used to query the status of an export request.</p>', 'StopContinuousExportRequest$exportId' => '<p>The unique ID assigned to this export.</p>', ], ], 'ConflictErrorException' => [ 'base' => '<p>Conflict error.</p>', 'refs' => [], ], 'ContinuousExportDescription' => [ 'base' => '<p>A list of continuous export descriptions.</p>', 'refs' => [ 'ContinuousExportDescriptions$member' => NULL, ], ], 'ContinuousExportDescriptions' => [ 'base' => NULL, 'refs' => [ 'DescribeContinuousExportsResponse$descriptions' => '<p>A list of continuous export descriptions.</p>', ], ], 'ContinuousExportIds' => [ 'base' => NULL, 'refs' => [ 'DescribeContinuousExportsRequest$exportIds' => '<p>The unique IDs assigned to the exports.</p>', ], ], 'ContinuousExportStatus' => [ 'base' => NULL, 'refs' => [ 'ContinuousExportDescription$status' => '<p>Describes the status of the export. Can be one of the following values:</p> <ul> <li> <p>START_IN_PROGRESS - setting up resources to start continuous export.</p> </li> <li> <p>START_FAILED - an error occurred setting up continuous export. To recover, call start-continuous-export again.</p> </li> <li> <p>ACTIVE - data is being exported to the customer bucket.</p> </li> <li> <p>ERROR - an error occurred during export. To fix the issue, call stop-continuous-export and start-continuous-export.</p> </li> <li> <p>STOP_IN_PROGRESS - stopping the export.</p> </li> <li> <p>STOP_FAILED - an error occurred stopping the export. To recover, call stop-continuous-export again.</p> </li> <li> <p>INACTIVE - the continuous export has been stopped. Data is no longer being exported to the customer bucket.</p> </li> </ul>', ], ], 'CreateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomerAgentInfo' => [ 'base' => '<p>Inventory data for installed discovery agents.</p>', 'refs' => [ 'GetDiscoverySummaryResponse$agentSummary' => '<p>Details about discovered agents, including agent status and health.</p>', ], ], 'CustomerAgentlessCollectorInfo' => [ 'base' => '<p>The inventory data for installed Agentless Collector collectors. </p>', 'refs' => [ 'GetDiscoverySummaryResponse$agentlessCollectorSummary' => '<p> Details about Agentless Collector collectors, including status. </p>', ], ], 'CustomerConnectorInfo' => [ 'base' => '<p>Inventory data for installed discovery connectors.</p>', 'refs' => [ 'GetDiscoverySummaryResponse$connectorSummary' => '<p>Details about discovered connectors, including connector status and health.</p>', ], ], 'CustomerMeCollectorInfo' => [ 'base' => '<p> The inventory data for installed Migration Evaluator collectors. </p>', 'refs' => [ 'GetDiscoverySummaryResponse$meCollectorSummary' => '<p> Details about Migration Evaluator collectors, including collector status and health. </p>', ], ], 'DataSource' => [ 'base' => NULL, 'refs' => [ 'ContinuousExportDescription$dataSource' => '<p>The type of data collector used to gather this data (currently only offered for AGENT).</p>', 'StartContinuousExportResponse$dataSource' => '<p>The type of data collector used to gather this data (currently only offered for AGENT).</p>', ], ], 'DatabaseName' => [ 'base' => NULL, 'refs' => [ 'SchemaStorageConfig$key' => NULL, ], ], 'DeleteAgent' => [ 'base' => '<p> An object representing the agent or data collector to be deleted along with the optional configurations for error handling. </p>', 'refs' => [ 'DeleteAgents$member' => NULL, ], ], 'DeleteAgentErrorCode' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteAgentError$errorCode' => '<p> The type of error that occurred for the delete failed agent. Valid status are: AGENT_IN_USE | NOT_FOUND | INTERNAL_SERVER_ERROR. </p>', ], ], 'DeleteAgents' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteAgentsRequest$deleteAgents' => '<p> The list of agents to delete. </p>', ], ], 'DeleteApplicationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteApplicationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeletionConfigurationItemType' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteConfigurationTask$configurationType' => '<p> The type of configuration item to delete. Supported types are: SERVER. </p>', 'StartBatchDeleteConfigurationTaskRequest$configurationType' => '<p> The type of configuration item to delete. Supported types are: SERVER. </p>', ], ], 'DeletionWarning' => [ 'base' => '<p> A configuration ID paired with a warning message. </p>', 'refs' => [ 'DeletionWarningsList$member' => NULL, ], ], 'DeletionWarningsList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteConfigurationTask$deletionWarnings' => '<p> A list of configuration IDs that produced warnings regarding their deletion, paired with a warning message. </p>', ], ], 'DescribeAgentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAgentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBatchDeleteConfigurationTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBatchDeleteConfigurationTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConfigurationsAttribute' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationsAttributes$member' => NULL, ], ], 'DescribeConfigurationsAttributes' => [ 'base' => NULL, 'refs' => [ 'DescribeConfigurationsResponse$configurations' => '<p>A key in the response map. The value is an array of data.</p>', ], ], 'DescribeConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContinuousExportsMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeContinuousExportsRequest$maxResults' => '<p>A number between 1 and 100 specifying the maximum number of continuous export descriptions returned.</p>', ], ], 'DescribeContinuousExportsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeContinuousExportsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeExportTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportTasksFilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeImportTasksRequest$filters' => '<p>An array of name-value pairs that you provide to filter the results for the <code>DescribeImportTask</code> request to a specific subset of results. Currently, wildcard values aren\'t supported for filters.</p>', ], ], 'DescribeImportTasksMaxResults' => [ 'base' => NULL, 'refs' => [ 'DescribeImportTasksRequest$maxResults' => '<p>The maximum number of results that you want this request to return, up to 100.</p>', ], ], 'DescribeImportTasksRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeImportTasksResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateConfigurationItemsFromApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateConfigurationItemsFromApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'EC2InstanceType' => [ 'base' => NULL, 'refs' => [ 'ExcludedInstanceTypes$member' => NULL, ], ], 'Ec2RecommendationsExportPreferences' => [ 'base' => '<p> Indicates that the exported data must include EC2 instance type matches for on-premises servers that are discovered through Amazon Web Services Application Discovery Service. </p>', 'refs' => [ 'ExportPreferences$ec2RecommendationsPreferences' => '<p> If enabled, exported data includes EC2 instance type matches for on-premises servers discovered through Amazon Web Services Application Discovery Service. </p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'FailedConfiguration$errorMessage' => '<p> A descriptive message indicating why the associated configuration failed to delete. </p>', ], ], 'ErrorStatusCode' => [ 'base' => NULL, 'refs' => [ 'FailedConfiguration$errorStatusCode' => '<p> The integer error code associated with the error message. </p>', ], ], 'ExcludedInstanceTypes' => [ 'base' => NULL, 'refs' => [ 'Ec2RecommendationsExportPreferences$excludedInstanceTypes' => '<p> An array of instance types to exclude from recommendations. </p>', ], ], 'ExportConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ExportDataFormat' => [ 'base' => NULL, 'refs' => [ 'ExportDataFormats$member' => NULL, ], ], 'ExportDataFormats' => [ 'base' => NULL, 'refs' => [ 'StartExportTaskRequest$exportDataFormat' => '<p>The file format for the returned export data. Default value is <code>CSV</code>. <b>Note:</b> <i>The</i> <code>GRAPHML</code> <i>option has been deprecated.</i> </p>', ], ], 'ExportEnabled' => [ 'base' => NULL, 'refs' => [ 'Ec2RecommendationsExportPreferences$enabled' => '<p> If set to true, the export <a href="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html#API_StartExportTask_RequestSyntax">preferences</a> is set to <code>Ec2RecommendationsExportPreferences</code>. </p>', ], ], 'ExportFilter' => [ 'base' => '<p>Used to select which agent\'s data is to be exported. A single agent ID may be selected for export using the <a href="http://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html">StartExportTask</a> action.</p>', 'refs' => [ 'ExportFilters$member' => NULL, ], ], 'ExportFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeExportTasksRequest$filters' => '<p>One or more filters.</p> <ul> <li> <p> <code>AgentId</code> - ID of the agent whose collected data will be exported</p> </li> </ul>', 'StartExportTaskRequest$filters' => '<p>If a filter is present, it selects the single <code>agentId</code> of the Application Discovery Agent for which data is exported. The <code>agentId</code> can be found in the results of the <code>DescribeAgents</code> API or CLI. If no filter is present, <code>startTime</code> and <code>endTime</code> are ignored and exported data includes both Amazon Web Services Application Discovery Service Agentless Collector collectors data and summary data from Application Discovery Agent agents. </p>', ], ], 'ExportIds' => [ 'base' => NULL, 'refs' => [ 'DescribeExportConfigurationsRequest$exportIds' => '<p>A list of continuous export IDs to search for.</p>', 'DescribeExportTasksRequest$exportIds' => '<p>One or more unique identifiers used to query the status of an export request.</p>', ], ], 'ExportInfo' => [ 'base' => '<p>Information regarding the export status of discovered data. The value is an array of objects.</p>', 'refs' => [ 'ExportsInfo$member' => NULL, ], ], 'ExportPreferences' => [ 'base' => '<p> Indicates the type of data that is being exported. Only one <code>ExportPreferences</code> can be enabled for a <a href="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_StartExportTask.html">StartExportTask</a> action. </p>', 'refs' => [ 'StartExportTaskRequest$preferences' => '<p> Indicates the type of data that needs to be exported. Only one <a href="https://docs.aws.amazon.com/application-discovery/latest/APIReference/API_ExportPreferences.html">ExportPreferences</a> can be enabled at any time. </p>', ], ], 'ExportRequestTime' => [ 'base' => NULL, 'refs' => [ 'ExportInfo$exportRequestTime' => '<p>The time that the data export was initiated.</p>', ], ], 'ExportStatus' => [ 'base' => NULL, 'refs' => [ 'ExportInfo$exportStatus' => '<p>The status of the data export job.</p>', ], ], 'ExportStatusMessage' => [ 'base' => NULL, 'refs' => [ 'ExportInfo$statusMessage' => '<p>A status message provided for API callers.</p>', ], ], 'ExportsInfo' => [ 'base' => NULL, 'refs' => [ 'DescribeExportConfigurationsResponse$exportsInfo' => '<p/>', 'DescribeExportTasksResponse$exportsInfo' => '<p>Contains one or more sets of export request details. When the status of a request is <code>SUCCEEDED</code>, the response includes a URL for an Amazon S3 bucket where you can view the data in a CSV file.</p>', ], ], 'FailedConfiguration' => [ 'base' => '<p> A configuration ID paired with an error message. </p>', 'refs' => [ 'FailedConfigurationList$member' => NULL, ], ], 'FailedConfigurationList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteConfigurationTask$failedConfigurations' => '<p> A list of configuration IDs that failed to delete during the deletion task, each paired with an error message. </p>', ], ], 'Filter' => [ 'base' => '<p>A filter that can use conditional operators.</p> <p>For more information about filters, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html">Querying Discovered Configuration Items</a> in the <i>Amazon Web Services Application Discovery Service User Guide</i>. </p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'ExportFilter$name' => '<p>A single <code>ExportFilter</code> name. Supported filters: <code>agentIds</code>.</p>', 'TagFilter$name' => '<p>A name of the tag filter.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValues$member' => NULL, ], ], 'FilterValues' => [ 'base' => NULL, 'refs' => [ 'ExportFilter$values' => '<p>A single agent ID for a Discovery Agent. An agent ID can be found using the <a href="http://docs.aws.amazon.com/application-discovery/latest/APIReference/API_DescribeAgents.html">DescribeAgents</a> action. Typically an ADS agent ID is in the form <code>o-0123456789abcdef0</code>.</p>', 'Filter$values' => '<p>A string value on which to filter. For example, if you choose the <code>destinationServer.osVersion</code> filter name, you could specify <code>Ubuntu</code> for the value.</p>', 'TagFilter$values' => '<p>Values for the tag filter.</p>', ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'DescribeAgentsRequest$filters' => '<p>You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example: </p> <p> <code>{"key": "collectionStatus", "value": "STARTED"}</code> </p>', 'ListConfigurationsRequest$filters' => '<p>You can filter the request using various logical operators and a <i>key</i>-<i>value</i> format. For example: </p> <p> <code>{"key": "serverType", "value": "webServer"}</code> </p> <p>For a complete list of filter options and guidance about using them with this action, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action</a> in the <i>Amazon Web Services Application Discovery Service User Guide</i>.</p>', ], ], 'GetDiscoverySummaryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDiscoverySummaryResponse' => [ 'base' => NULL, 'refs' => [], ], 'HomeRegionNotSetException' => [ 'base' => '<p>The home Region is not set. Set the home Region to continue.</p>', 'refs' => [], ], 'ImportStatus' => [ 'base' => NULL, 'refs' => [ 'ImportTask$status' => '<p>The status of the import task. An import can have the status of <code>IMPORT_COMPLETE</code> and still have some records fail to import from the overall request. More information can be found in the downloadable archive defined in the <code>errorsAndFailedEntriesZip</code> field, or in the Migration Hub management console.</p>', ], ], 'ImportTask' => [ 'base' => '<p>An array of information related to the import task request that includes status information, times, IDs, the Amazon S3 Object URL for the import file, and more.</p>', 'refs' => [ 'ImportTaskList$member' => NULL, 'StartImportTaskResponse$task' => '<p>An array of information related to the import task request including status information, times, IDs, the Amazon S3 Object URL for the import file, and more. </p>', ], ], 'ImportTaskFilter' => [ 'base' => '<p>A name-values pair of elements you can use to filter the results when querying your import tasks. Currently, wildcards are not supported for filters.</p> <note> <p>When filtering by import status, all other filter values are ignored.</p> </note>', 'refs' => [ 'DescribeImportTasksFilterList$member' => NULL, ], ], 'ImportTaskFilterName' => [ 'base' => NULL, 'refs' => [ 'ImportTaskFilter$name' => '<p>The name, status, or import task ID for a specific import task.</p>', ], ], 'ImportTaskFilterValue' => [ 'base' => NULL, 'refs' => [ 'ImportTaskFilterValueList$member' => NULL, ], ], 'ImportTaskFilterValueList' => [ 'base' => NULL, 'refs' => [ 'ImportTaskFilter$values' => '<p>An array of strings that you can provide to match against a specific name, status, or import task ID to filter the results for your import task queries.</p>', ], ], 'ImportTaskIdentifier' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteImportDataError$importTaskId' => '<p>The unique import ID associated with the error that occurred.</p>', 'ImportTask$importTaskId' => '<p>The unique ID for a specific import task. These IDs aren\'t globally unique, but they are unique within an Amazon Web Services account.</p>', 'ToDeleteIdentifierList$member' => NULL, ], ], 'ImportTaskList' => [ 'base' => NULL, 'refs' => [ 'DescribeImportTasksResponse$tasks' => '<p>A returned array of import tasks that match any applied filters, up to the specified number of maximum results.</p>', ], ], 'ImportTaskName' => [ 'base' => NULL, 'refs' => [ 'ImportTask$name' => '<p>A descriptive name for an import task. You can use this name to filter future requests related to this import task, such as identifying applications and servers that were included in this import task. We recommend that you use a meaningful name for each import task.</p>', 'StartImportTaskRequest$name' => '<p>A descriptive name for this request. You can use this name to filter future requests related to this import task, such as identifying applications and servers that were included in this import task. We recommend that you use a meaningful name for each import task.</p>', ], ], 'ImportURL' => [ 'base' => NULL, 'refs' => [ 'ImportTask$importUrl' => '<p>The URL for your import file that you\'ve uploaded to Amazon S3.</p>', 'StartImportTaskRequest$importUrl' => '<p>The URL for your import file that you\'ve uploaded to Amazon S3.</p> <note> <p>If you\'re using the Amazon Web Services CLI, this URL is structured as follows: <code>s3://BucketName/ImportFileName.CSV</code> </p> </note>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'CustomerAgentInfo$activeAgents' => '<p>Number of active discovery agents.</p>', 'CustomerAgentInfo$healthyAgents' => '<p>Number of healthy discovery agents</p>', 'CustomerAgentInfo$blackListedAgents' => '<p>Number of blacklisted discovery agents.</p>', 'CustomerAgentInfo$shutdownAgents' => '<p>Number of discovery agents with status SHUTDOWN.</p>', 'CustomerAgentInfo$unhealthyAgents' => '<p>Number of unhealthy discovery agents.</p>', 'CustomerAgentInfo$totalAgents' => '<p>Total number of discovery agents.</p>', 'CustomerAgentInfo$unknownAgents' => '<p>Number of unknown discovery agents.</p>', 'CustomerAgentlessCollectorInfo$activeAgentlessCollectors' => '<p>The number of active Agentless Collector collectors. </p>', 'CustomerAgentlessCollectorInfo$healthyAgentlessCollectors' => '<p>The number of healthy Agentless Collector collectors. </p>', 'CustomerAgentlessCollectorInfo$denyListedAgentlessCollectors' => '<p>The number of deny-listed Agentless Collector collectors. </p>', 'CustomerAgentlessCollectorInfo$shutdownAgentlessCollectors' => '<p>The number of Agentless Collector collectors with <code>SHUTDOWN</code> status. </p>', 'CustomerAgentlessCollectorInfo$unhealthyAgentlessCollectors' => '<p> The number of unhealthy Agentless Collector collectors. </p>', 'CustomerAgentlessCollectorInfo$totalAgentlessCollectors' => '<p> The total number of Agentless Collector collectors. </p>', 'CustomerAgentlessCollectorInfo$unknownAgentlessCollectors' => '<p> The number of unknown Agentless Collector collectors. </p>', 'CustomerConnectorInfo$activeConnectors' => '<p>Number of active discovery connectors.</p>', 'CustomerConnectorInfo$healthyConnectors' => '<p>Number of healthy discovery connectors.</p>', 'CustomerConnectorInfo$blackListedConnectors' => '<p>Number of blacklisted discovery connectors.</p>', 'CustomerConnectorInfo$shutdownConnectors' => '<p>Number of discovery connectors with status SHUTDOWN,</p>', 'CustomerConnectorInfo$unhealthyConnectors' => '<p>Number of unhealthy discovery connectors.</p>', 'CustomerConnectorInfo$totalConnectors' => '<p>Total number of discovery connectors.</p>', 'CustomerConnectorInfo$unknownConnectors' => '<p>Number of unknown discovery connectors.</p>', 'CustomerMeCollectorInfo$activeMeCollectors' => '<p> The number of active Migration Evaluator collectors. </p>', 'CustomerMeCollectorInfo$healthyMeCollectors' => '<p> The number of healthy Migration Evaluator collectors. </p>', 'CustomerMeCollectorInfo$denyListedMeCollectors' => '<p> The number of deny-listed Migration Evaluator collectors. </p>', 'CustomerMeCollectorInfo$shutdownMeCollectors' => '<p> The number of Migration Evaluator collectors with <code>SHUTDOWN</code> status. </p>', 'CustomerMeCollectorInfo$unhealthyMeCollectors' => '<p> The number of unhealthy Migration Evaluator collectors. </p>', 'CustomerMeCollectorInfo$totalMeCollectors' => '<p> The total number of Migration Evaluator collectors. </p>', 'CustomerMeCollectorInfo$unknownMeCollectors' => '<p> The number of unknown Migration Evaluator collectors. </p>', 'DescribeAgentsRequest$maxResults' => '<p>The total number of agents/collectors to return in a single page of output. The maximum value is 100.</p>', 'DescribeExportConfigurationsRequest$maxResults' => '<p>A number between 1 and 100 specifying the maximum number of continuous export descriptions returned.</p>', 'DescribeExportTasksRequest$maxResults' => '<p>The maximum number of volume results returned by <code>DescribeExportTasks</code> in paginated output. When this parameter is used, <code>DescribeExportTasks</code> only returns <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.</p>', 'DescribeTagsRequest$maxResults' => '<p>The total number of items to return in a single page of output. The maximum value is 100.</p>', 'ImportTask$serverImportSuccess' => '<p>The total number of server records in the import file that were successfully imported.</p>', 'ImportTask$serverImportFailure' => '<p>The total number of server records in the import file that failed to be imported.</p>', 'ImportTask$applicationImportSuccess' => '<p>The total number of application records in the import file that were successfully imported.</p>', 'ImportTask$applicationImportFailure' => '<p>The total number of application records in the import file that failed to be imported.</p>', 'ListConfigurationsRequest$maxResults' => '<p>The total number of items to return. The maximum value is 100.</p>', 'ListServerNeighborsRequest$maxResults' => '<p>Maximum number of results to return in a single page of output.</p>', ], ], 'InvalidParameterException' => [ 'base' => '<p>One or more parameters are not valid. Verify the parameters and try again.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>The value of one or more parameters are either invalid or out of range. Verify the parameter values and try again.</p>', 'refs' => [], ], 'LimitExceededException' => [ 'base' => '<p> The limit of 200 configuration IDs per request has been exceeded. </p>', 'refs' => [], ], 'ListConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServerNeighborsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServerNeighborsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'GetDiscoverySummaryResponse$servers' => '<p>The number of servers discovered.</p>', 'GetDiscoverySummaryResponse$applications' => '<p>The number of applications discovered.</p>', 'GetDiscoverySummaryResponse$serversMappedToApplications' => '<p>The number of servers mapped to applications.</p>', 'GetDiscoverySummaryResponse$serversMappedtoTags' => '<p>The number of servers mapped to tags.</p>', 'ListServerNeighborsResponse$knownDependencyCount' => '<p>Count of distinct servers that are one hop away from the given server.</p>', 'NeighborConnectionDetail$connectionsCount' => '<p>The number of open network connections with the neighboring server.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'AuthorizationErrorException$message' => NULL, 'ConflictErrorException$message' => NULL, 'HomeRegionNotSetException$message' => NULL, 'InvalidParameterException$message' => NULL, 'InvalidParameterValueException$message' => NULL, 'LimitExceededException$message' => NULL, 'OperationNotPermittedException$message' => NULL, 'ResourceInUseException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServerInternalErrorException$message' => NULL, ], ], 'NeighborConnectionDetail' => [ 'base' => '<p>Details about neighboring servers.</p>', 'refs' => [ 'NeighborDetailsList$member' => NULL, ], ], 'NeighborDetailsList' => [ 'base' => NULL, 'refs' => [ 'ListServerNeighborsResponse$neighbors' => '<p>List of distinct servers that are one hop away from the given server.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'DescribeAgentsRequest$nextToken' => '<p>Token to retrieve the next set of results. For example, if you previously specified 100 IDs for <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.</p>', 'DescribeAgentsResponse$nextToken' => '<p>Token to retrieve the next set of results. For example, if you specified 100 IDs for <code>DescribeAgentsRequest$agentIds</code> but set <code>DescribeAgentsRequest$maxResults</code> to 10, you received a set of 10 results along with this token. Use this token in the next query to retrieve the next set of 10.</p>', 'DescribeContinuousExportsRequest$nextToken' => '<p>The token from the previous call to <code>DescribeExportTasks</code>.</p>', 'DescribeContinuousExportsResponse$nextToken' => '<p>The token from the previous call to <code>DescribeExportTasks</code>.</p>', 'DescribeExportConfigurationsRequest$nextToken' => '<p>The token from the previous call to describe-export-tasks.</p>', 'DescribeExportConfigurationsResponse$nextToken' => '<p>The token from the previous call to describe-export-tasks.</p>', 'DescribeExportTasksRequest$nextToken' => '<p>The <code>nextToken</code> value returned from a previous paginated <code>DescribeExportTasks</code> request where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from the end of the previous results that returned the <code>nextToken</code> value. This value is null when there are no more results to return.</p>', 'DescribeExportTasksResponse$nextToken' => '<p>The <code>nextToken</code> value to include in a future <code>DescribeExportTasks</code> request. When the results of a <code>DescribeExportTasks</code> request exceed <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'DescribeImportTasksRequest$nextToken' => '<p>The token to request a specific page of results.</p>', 'DescribeImportTasksResponse$nextToken' => '<p>The token to request the next page of results.</p>', 'DescribeTagsRequest$nextToken' => '<p>A token to start the list. Use this token to get the next set of results.</p>', 'DescribeTagsResponse$nextToken' => '<p>The call returns a token. Use this token to get the next set of results.</p>', 'ListConfigurationsRequest$nextToken' => '<p>Token to retrieve the next set of results. For example, if a previous call to ListConfigurations returned 100 items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.</p>', 'ListConfigurationsResponse$nextToken' => '<p>Token to retrieve the next set of results. For example, if your call to ListConfigurations returned 100 items, but you set <code>ListConfigurationsRequest$maxResults</code> to 10, you received a set of 10 results along with this token. Use this token in the next query to retrieve the next set of 10.</p>', ], ], 'OfferingClass' => [ 'base' => NULL, 'refs' => [ 'ReservedInstanceOptions$offeringClass' => '<p> The flexibility to change the instance types needed for your Reserved Instance. </p>', ], ], 'OperationNotPermittedException' => [ 'base' => '<p>This operation is not permitted.</p>', 'refs' => [], ], 'OrderByElement' => [ 'base' => '<p>A field and direction for ordered output.</p>', 'refs' => [ 'OrderByList$member' => NULL, ], ], 'OrderByElementFieldName' => [ 'base' => NULL, 'refs' => [ 'OrderByElement$fieldName' => '<p>The field on which to order.</p>', ], ], 'OrderByList' => [ 'base' => NULL, 'refs' => [ 'ListConfigurationsRequest$orderBy' => '<p>Certain filter criteria return output that can be sorted in ascending or descending order. For a list of output characteristics for each filter, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/discovery-api-queries.html#ListConfigurations">Using the ListConfigurations Action</a> in the <i>Amazon Web Services Application Discovery Service User Guide</i>.</p>', ], ], 'PurchasingOption' => [ 'base' => NULL, 'refs' => [ 'ReservedInstanceOptions$purchasingOption' => '<p> The payment plan to use for your Reserved Instance. </p>', ], ], 'ReservedInstanceOptions' => [ 'base' => '<p> Used to provide Reserved Instance preferences for the recommendation. </p>', 'refs' => [ 'Ec2RecommendationsExportPreferences$reservedInstanceOptions' => '<p> The contract type for a reserved instance. If blank, we assume an On-Demand instance is preferred. </p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>This issue occurs when the same <code>clientRequestToken</code> is used with the <code>StartImportTask</code> action, but with different parameters. For example, you use the same request token but have two different import URLs, you can encounter this issue. If the import tasks are meant to be different, use a different <code>clientRequestToken</code>, and try again.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified configuration ID was not located. Verify the configuration ID and try again.</p>', 'refs' => [], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'ContinuousExportDescription$s3Bucket' => '<p>The name of the s3 bucket where the export data parquet files are stored.</p>', 'StartContinuousExportResponse$s3Bucket' => '<p>The name of the s3 bucket where the export data parquet files are stored.</p>', ], ], 'S3PresignedUrl' => [ 'base' => NULL, 'refs' => [ 'ImportTask$errorsAndFailedEntriesZip' => '<p>A link to a compressed archive folder (in the ZIP format) that contains an error log and a file of failed records. You can use these two files to quickly identify records that failed, why they failed, and correct those records. Afterward, you can upload the corrected file to your Amazon S3 bucket and create another import task request.</p> <p>This field also includes authorization information so you can confirm the authenticity of the compressed archive before you download it.</p> <p>If some records failed to be imported we recommend that you correct the records in the failed entries file and then imports that failed entries file. This prevents you from having to correct and update the larger original file and attempt importing it again.</p>', ], ], 'SchemaStorageConfig' => [ 'base' => NULL, 'refs' => [ 'ContinuousExportDescription$schemaStorageConfig' => '<p>An object which describes how the data is stored.</p> <ul> <li> <p> <code>databaseName</code> - the name of the Glue database used to store the schema.</p> </li> </ul>', 'StartContinuousExportResponse$schemaStorageConfig' => '<p>A dictionary which describes how the data is stored.</p> <ul> <li> <p> <code>databaseName</code> - the name of the Glue database used to store the schema.</p> </li> </ul>', ], ], 'ServerInternalErrorException' => [ 'base' => '<p>The server experienced an internal error. Try again.</p>', 'refs' => [], ], 'StartBatchDeleteConfigurationTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartBatchDeleteConfigurationTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartContinuousExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartContinuousExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartDataCollectionByAgentIdsRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartDataCollectionByAgentIdsResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartExportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartExportTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartImportTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartImportTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopContinuousExportRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopContinuousExportResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopDataCollectionByAgentIdsRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopDataCollectionByAgentIdsResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AgentConfigurationStatus$agentId' => '<p>The agent ID.</p>', 'AgentConfigurationStatus$description' => '<p>A description of the operation performed.</p>', 'AgentInfo$hostName' => '<p>The name of the host where the agent or collector resides. The host can be a server or virtual machine.</p>', 'AgentInfo$connectorId' => '<p>The ID of the connector.</p>', 'AgentInfo$version' => '<p>The agent or collector version.</p>', 'AgentInfo$lastHealthPingTime' => '<p>Time since agent health was reported.</p>', 'AgentInfo$collectionStatus' => '<p>Status of the collection process for an agent.</p>', 'AgentInfo$agentType' => '<p>Type of agent.</p>', 'AgentInfo$registeredTime' => '<p>Agent\'s first registration timestamp in UTC.</p>', 'AgentNetworkInfo$ipAddress' => '<p>The IP address for the host where the agent/collector resides.</p>', 'AgentNetworkInfo$macAddress' => '<p>The MAC address for the host where the agent/collector resides.</p>', 'BatchDeleteAgentError$errorMessage' => '<p> The description of the error that occurred for the delete failed agent. </p>', 'Configuration$key' => NULL, 'Configuration$value' => NULL, 'CreateApplicationResponse$configurationId' => '<p>Configuration ID of an application to be created.</p>', 'DescribeConfigurationsAttribute$key' => NULL, 'DescribeConfigurationsAttribute$value' => NULL, 'Filter$name' => '<p>The name of the filter.</p>', 'ListServerNeighborsRequest$nextToken' => '<p>Token to retrieve the next set of results. For example, if you previously specified 100 IDs for <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with a token. Use that token in this query to get the next set of 10.</p>', 'ListServerNeighborsResponse$nextToken' => '<p>Token to retrieve the next set of results. For example, if you specified 100 IDs for <code>ListServerNeighborsRequest$neighborConfigurationIds</code> but set <code>ListServerNeighborsRequest$maxResults</code> to 10, you received a set of 10 results along with this token. Use this token in the next query to retrieve the next set of 10.</p>', 'NeighborConnectionDetail$transportProtocol' => '<p>The network protocol used for the connection.</p>', 'SchemaStorageConfig$value' => NULL, ], ], 'StringMax255' => [ 'base' => NULL, 'refs' => [ 'ContinuousExportDescription$statusDetail' => '<p>Contains information about any errors that have occurred. This data type can have the following values:</p> <ul> <li> <p>ACCESS_DENIED - You don’t have permission to start Data Exploration in Amazon Athena. Contact your Amazon Web Services administrator for help. For more information, see <a href="http://docs.aws.amazon.com/application-discovery/latest/userguide/setting-up.html">Setting Up Amazon Web Services Application Discovery Service</a> in the Application Discovery Service User Guide.</p> </li> <li> <p>DELIVERY_STREAM_LIMIT_FAILURE - You reached the limit for Amazon Kinesis Data Firehose delivery streams. Reduce the number of streams or request a limit increase and try again. For more information, see <a href="http://docs.aws.amazon.com/streams/latest/dev/service-sizes-and-limits.html">Kinesis Data Streams Limits</a> in the Amazon Kinesis Data Streams Developer Guide.</p> </li> <li> <p>FIREHOSE_ROLE_MISSING - The Data Exploration feature is in an error state because your user is missing the Amazon Web ServicesApplicationDiscoveryServiceFirehose role. Turn on Data Exploration in Amazon Athena and try again. For more information, see <a href="https://docs.aws.amazon.com/application-discovery/latest/userguide/security-iam-awsmanpol.html#security-iam-awsmanpol-create-firehose-role">Creating the Amazon Web ServicesApplicationDiscoveryServiceFirehose Role</a> in the Application Discovery Service User Guide.</p> </li> <li> <p>FIREHOSE_STREAM_DOES_NOT_EXIST - The Data Exploration feature is in an error state because your user is missing one or more of the Kinesis data delivery streams.</p> </li> <li> <p>INTERNAL_FAILURE - The Data Exploration feature is in an error state because of an internal failure. Try again later. If this problem persists, contact Amazon Web Services Support.</p> </li> <li> <p>LAKE_FORMATION_ACCESS_DENIED - You don\'t have sufficient lake formation permissions to start continuous export. For more information, see <a href="http://docs.aws.amazon.com/lake-formation/latest/dg/upgrade-glue-lake-formation.html"> Upgrading Amazon Web Services Glue Data Permissions to the Amazon Web Services Lake Formation Model </a> in the Amazon Web Services <i>Lake Formation Developer Guide</i>. </p> <p>You can use one of the following two ways to resolve this issue.</p> <ol> <li> <p>If you don’t want to use the Lake Formation permission model, you can change the default Data Catalog settings to use only Amazon Web Services Identity and Access Management (IAM) access control for new databases. For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/getting-started-setup.html#setup-change-cat-settings">Change Data Catalog Settings</a> in the <i>Lake Formation Developer Guide</i>.</p> </li> <li> <p>You can give the service-linked IAM roles AWSServiceRoleForApplicationDiscoveryServiceContinuousExport and AWSApplicationDiscoveryServiceFirehose the required Lake Formation permissions. For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/granting-database-permissions.html"> Granting Database Permissions</a> in the <i>Lake Formation Developer Guide</i>. </p> <ol> <li> <p>AWSServiceRoleForApplicationDiscoveryServiceContinuousExport - Grant database creator permissions, which gives the role database creation ability and implicit permissions for any created tables. For more information, see <a href="https://docs.aws.amazon.com/lake-formation/latest/dg/implicit-permissions.html"> Implicit Lake Formation Permissions </a> in the <i>Lake Formation Developer Guide</i>.</p> </li> <li> <p>AWSApplicationDiscoveryServiceFirehose - Grant describe permissions for all tables in the database.</p> </li> </ol> </li> </ol> </li> <li> <p>S3_BUCKET_LIMIT_FAILURE - You reached the limit for Amazon S3 buckets. Reduce the number of S3 buckets or request a limit increase and try again. For more information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket Restrictions and Limitations</a> in the Amazon Simple Storage Service Developer Guide.</p> </li> <li> <p>S3_NOT_SIGNED_UP - Your account is not signed up for the Amazon S3 service. You must sign up before you can use Amazon S3. You can sign up at the following URL: <a href="https://aws.amazon.com/s3">https://aws.amazon.com/s3</a>.</p> </li> </ul>', ], ], 'Tag' => [ 'base' => '<p>Metadata that help you categorize IT assets.</p> <important> <p>Do not store sensitive information (like personal data) in tags.</p> </important>', 'refs' => [ 'TagSet$member' => NULL, ], ], 'TagFilter' => [ 'base' => '<p>The tag filter. Valid names are: <code>tagKey</code>, <code>tagValue</code>, <code>configurationId</code>.</p>', 'refs' => [ 'TagFilters$member' => NULL, ], ], 'TagFilters' => [ 'base' => NULL, 'refs' => [ 'DescribeTagsRequest$filters' => '<p>You can filter the list using a <i>key</i>-<i>value</i> format. You can separate these items by using logical operators. Allowed filters include <code>tagKey</code>, <code>tagValue</code>, and <code>configurationId</code>. </p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'ConfigurationTag$key' => '<p>A type of tag on which to filter. For example, <i>serverType</i>.</p>', 'Tag$key' => '<p>The type of tag on which to filter.</p>', ], ], 'TagSet' => [ 'base' => NULL, 'refs' => [ 'CreateTagsRequest$tags' => '<p>Tags that you want to associate with one or more configuration items. Specify the tags that you want to create in a <i>key</i>-<i>value</i> format. For example:</p> <p> <code>{"key": "serverType", "value": "webServer"}</code> </p>', 'DeleteTagsRequest$tags' => '<p>Tags that you want to delete from one or more configuration items. Specify the tags that you want to delete in a <i>key</i>-<i>value</i> format. For example:</p> <p> <code>{"key": "serverType", "value": "webServer"}</code> </p>', ], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'ConfigurationTag$value' => '<p>A value on which to filter. For example <i>key = serverType</i> and <i>value = web server</i>.</p>', 'Tag$value' => '<p>A value for a tag key on which to filter.</p>', ], ], 'Tenancy' => [ 'base' => NULL, 'refs' => [ 'Ec2RecommendationsExportPreferences$tenancy' => '<p> The target tenancy to use for your recommended EC2 instances. </p>', ], ], 'TermLength' => [ 'base' => NULL, 'refs' => [ 'ReservedInstanceOptions$termLength' => '<p> The preferred duration of the Reserved Instance term. </p>', ], ], 'TimeStamp' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteConfigurationTask$startTime' => '<p> An epoch seconds timestamp (UTC) of when the deletion task was started. </p>', 'BatchDeleteConfigurationTask$endTime' => '<p> An epoch seconds timestamp (UTC) of when the deletion task was completed or failed. </p>', 'ConfigurationTag$timeOfCreation' => '<p>The time the configuration tag was created in Coordinated Universal Time (UTC).</p>', 'ContinuousExportDescription$startTime' => '<p>The timestamp representing when the continuous export was started.</p>', 'ContinuousExportDescription$stopTime' => '<p>The timestamp that represents when this continuous export was stopped.</p>', 'ExportInfo$requestedStartTime' => '<p>The value of <code>startTime</code> parameter in the <code>StartExportTask</code> request. If no <code>startTime</code> was requested, this result does not appear in <code>ExportInfo</code>.</p>', 'ExportInfo$requestedEndTime' => '<p>The <code>endTime</code> used in the <code>StartExportTask</code> request. If no <code>endTime</code> was requested, this result does not appear in <code>ExportInfo</code>.</p>', 'ImportTask$importRequestTime' => '<p>The time that the import task request was made, presented in the Unix time stamp format.</p>', 'ImportTask$importCompletionTime' => '<p>The time that the import task request finished, presented in the Unix time stamp format.</p>', 'ImportTask$importDeletedTime' => '<p>The time that the import task request was deleted, presented in the Unix time stamp format.</p>', 'StartContinuousExportResponse$startTime' => '<p>The timestamp representing when the continuous export was started.</p>', 'StartExportTaskRequest$startTime' => '<p>The start timestamp for exported data from the single Application Discovery Agent selected in the filters. If no value is specified, data is exported starting from the first data collected by the agent.</p>', 'StartExportTaskRequest$endTime' => '<p>The end timestamp for exported data from the single Application Discovery Agent selected in the filters. If no value is specified, exported data includes the most recent data collected by the agent.</p>', 'StopContinuousExportResponse$startTime' => '<p>Timestamp that represents when this continuous export started collecting data.</p>', 'StopContinuousExportResponse$stopTime' => '<p>Timestamp that represents when this continuous export was stopped.</p>', ], ], 'ToDeleteIdentifierList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteImportDataRequest$importTaskIds' => '<p>The IDs for the import tasks that you want to delete.</p>', ], ], 'UUID' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteConfigurationTask$taskId' => '<p> The deletion task\'s unique identifier. </p>', 'DescribeBatchDeleteConfigurationTaskRequest$taskId' => '<p> The ID of the task to delete. </p>', 'StartBatchDeleteConfigurationTaskResponse$taskId' => '<p> The unique identifier associated with the newly started deletion task. </p>', ], ], 'UpdateApplicationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UsageMetricBasis' => [ 'base' => '<p> Specifies the performance metrics to use for the server that is used for recommendations. </p>', 'refs' => [ 'Ec2RecommendationsExportPreferences$cpuPerformanceMetricBasis' => '<p> The recommended EC2 instance type that matches the CPU usage metric of server performance data. </p>', 'Ec2RecommendationsExportPreferences$ramPerformanceMetricBasis' => '<p> The recommended EC2 instance type that matches the Memory usage metric of server performance data. </p>', ], ], 'UsageMetricBasisName' => [ 'base' => NULL, 'refs' => [ 'UsageMetricBasis$name' => '<p> A utilization metric that is used by the recommendations. </p>', ], ], 'UsageMetricPercentageAdjust' => [ 'base' => NULL, 'refs' => [ 'UsageMetricBasis$percentageAdjust' => '<p> Specifies the percentage of the specified utilization metric that is used by the recommendations. </p>', ], ], 'UserPreferredRegion' => [ 'base' => NULL, 'refs' => [ 'Ec2RecommendationsExportPreferences$preferredRegion' => '<p> The target Amazon Web Services Region for the recommendations. You can use any of the Region codes available for the chosen service, as listed in <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Amazon Web Services service endpoints</a> in the <i>Amazon Web Services General Reference</i>. </p>', ], ], 'WarningCode' => [ 'base' => NULL, 'refs' => [ 'DeletionWarning$warningCode' => '<p> The integer warning code associated with the warning message. </p>', ], ], 'WarningText' => [ 'base' => NULL, 'refs' => [ 'DeletionWarning$warningText' => '<p> A descriptive message of the warning the associated configuration ID produced. </p>', ], ], 'orderString' => [ 'base' => NULL, 'refs' => [ 'OrderByElement$sortOrder' => '<p>Ordering direction.</p>', ], ], ],];
