<?php
// This file was auto-generated from sdk-root/src/data/dms/2016-01-01/examples-1.json
return [ 'version' => '1.0', 'examples' => [ 'AddTagsToResource' => [ [ 'input' => [ 'ResourceArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E', 'Tags' => [ [ 'Key' => 'Acount', 'Value' => '1633456', ], ], ], 'output' => [], 'comments' => [ 'input' => [ 'ResourceArn' => 'Required. Use the ARN of the resource you want to tag.', 'Tags' => 'Required. Use the Key/Value pair format.', ], 'output' => [], ], 'description' => 'Adds metadata tags to an AWS DMS resource, including replication instance, endpoint, security group, and migration task. These tags can also be used with cost allocation reporting to track cost associated with AWS DMS resources, or used in a Condition statement in an IAM policy for AWS DMS.', 'id' => 'add-tags-to-resource-1481744141435', 'title' => 'Add tags to resource', ], ], 'CreateDataProvider' => [ [ 'input' => [ 'DataProviderName' => 'sqlServer-dev', 'Description' => 'description', 'Engine' => 'sqlserver', 'Settings' => [ 'MicrosoftSqlServerSettings' => [ 'DatabaseName' => 'DatabaseName', 'Port' => 11112, 'ServerName' => 'ServerName2', 'SslMode' => 'none', ], ], 'Tags' => [ [ 'Key' => 'access', 'Value' => 'authorizedusers', ], ], ], 'output' => [ 'DataProvider' => [ 'DataProviderArn' => 'arn:aws:dms:us-east-1:012345678901:data-provider:my-target-dataprovider', 'DataProviderCreationTime' => '2023-05-12T10:50:41.988561Z', 'DataProviderName' => 'my-target-dataprovider', 'Engine' => 'postgres', 'Settings' => [ 'PostgreSqlSettings' => [ 'DatabaseName' => 'target', 'Port' => 5432, 'ServerName' => 'postrgesql.a1b2c3d4e5f6.us-east-1.rds.amazonaws.com', 'SslMode' => 'none', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Creates the data provider with the specified parameters.', 'id' => 'create-data-provider-1689726511871', 'title' => 'Create Data Provider', ], ], 'CreateEndpoint' => [ [ 'input' => [ 'CertificateArn' => '', 'DatabaseName' => 'testdb', 'EndpointIdentifier' => 'test-endpoint-1', 'EndpointType' => 'source', 'EngineName' => 'mysql', 'ExtraConnectionAttributes' => '', 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/4c1731d6-5435-ed4d-be13-d53411a7cfbd', 'Password' => 'pasword', 'Port' => 3306, 'ServerName' => 'mydb.cx1llnox7iyx.us-west-2.rds.amazonaws.com', 'SslMode' => 'require', 'Tags' => [ [ 'Key' => 'Acount', 'Value' => '143327655', ], ], 'Username' => 'username', ], 'output' => [ 'Endpoint' => [ 'EndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:RAAR3R22XSH46S3PWLC3NJAWKM', 'EndpointIdentifier' => 'test-endpoint-1', 'EndpointType' => 'source', 'EngineName' => 'mysql', 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/4c1731d6-5435-ed4d-be13-d53411a7cfbd', 'Port' => 3306, 'ServerName' => 'mydb.cx1llnox7iyx.us-west-2.rds.amazonaws.com', 'Status' => 'active', 'Username' => 'username', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Creates an endpoint using the provided settings.', 'id' => 'create-endpoint-1481746254348', 'title' => 'Create endpoint', ], ], 'CreateInstanceProfile' => [ [ 'input' => [ 'Description' => 'Description', 'InstanceProfileName' => 'my-instance-profile', 'KmsKeyArn' => 'arn:aws:kms:us-east-1:012345678901:key/01234567-89ab-cdef-0123-456789abcdef', 'NetworkType' => 'DUAL', 'PubliclyAccessible' => true, 'SubnetGroupIdentifier' => 'my-subnet-group', 'Tags' => [ [ 'Key' => 'access', 'Value' => 'authorizedusers', ], ], ], 'output' => [ 'InstanceProfile' => [ 'InstanceProfileArn' => 'arn:aws:dms:us-east-1:012345678901:instance-profile:my-instance-profile', 'InstanceProfileCreationTime' => '2022-12-16T09:44:43.543246Z', 'InstanceProfileName' => 'my-instance-profile', 'KmsKeyArn' => 'arn:aws:kms:us-east-1:012345678901:key/01234567-89ab-cdef-0123-456789abcdef', 'PubliclyAccessible' => true, 'SubnetGroupIdentifier' => 'public-subnets', 'VpcIdentifier' => 'vpc-0a1b2c3d4e5f6g7h8', 'VpcSecurityGroups' => [ 'sg-0123456', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Creates the instance profile using the specified parameters.', 'id' => 'create-instance-profile-1689716070633', 'title' => 'Create Instance Profile', ], ], 'CreateMigrationProject' => [ [ 'input' => [ 'Description' => 'description', 'InstanceProfileIdentifier' => 'ip-au-17', 'MigrationProjectName' => 'my-migration-project', 'SchemaConversionApplicationAttributes' => [ 'S3BucketPath' => 'arn:aws:s3:::mylogin-bucket', 'S3BucketRoleArn' => 'arn:aws:iam::012345678901:role/Admin', ], 'SourceDataProviderDescriptors' => [ [ 'DataProviderIdentifier' => 'arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', 'SecretsManagerAccessRoleArn' => 'arn:aws:iam::012345678901:role/myuser-admin-access', 'SecretsManagerSecretId' => 'arn:aws:secretsmanager:us-east-1:012345678901:secret:myorg/example1/ALL.SOURCE.ORACLE_12-A1B2C3', ], ], 'Tags' => [ [ 'Key' => 'access', 'Value' => 'authorizedusers', ], ], 'TargetDataProviderDescriptors' => [ [ 'DataProviderIdentifier' => 'arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', 'SecretsManagerAccessRoleArn' => 'arn:aws:iam::012345678901:role/myuser-admin-access', 'SecretsManagerSecretId' => 'arn:aws:secretsmanager:us-east-1:012345678901:secret:myorg/example1/TARGET.postgresql-A1B2C3', ], ], 'TransformationRules' => '{"key0":"value0","key1":"value1","key2":"value2"}', ], 'output' => [ 'MigrationProject' => [ 'InstanceProfileArn' => 'arn:aws:dms:us-east-1:012345678901:instance-profile:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'InstanceProfileName' => 'my-instance-profile', 'MigrationProjectArn' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'MigrationProjectCreationTime' => '2023-04-19T11:45:15.805253Z', 'MigrationProjectName' => 'my-migration-project', 'SchemaConversionApplicationAttributes' => [ 'S3BucketPath' => 'my-s3-bucket/my_folder', 'S3BucketRoleArn' => 'arn:aws:iam::012345678901:role/my-s3role', ], 'SourceDataProviderDescriptors' => [ [ 'DataProviderArn' => 'arn:aws:dms:us-east-1:012345678901:data-provider:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'DataProviderName' => 'source-oracle-12', 'SecretsManagerAccessRoleArn' => 'arn:aws:iam::012345678901:role/my-access-role', 'SecretsManagerSecretId' => 'arn:aws:secretsmanager:us-east-1:012345678901:secret:myuser/ALL.SOURCE.ORACLE_12-0123456', ], ], 'TargetDataProviderDescriptors' => [ [ 'DataProviderArn' => 'arn:aws:dms:us-east-1:012345678901:data-provider:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'DataProviderName' => 'target-dataprovider-3', 'SecretsManagerAccessRoleArn' => 'arn:aws:iam::012345678901:role/dmytbon-admin-access', 'SecretsManagerSecretId' => 'arn:aws:secretsmanager:us-east-1:012345678901:secret:myuser/TARGET.postgresql-0123456', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Creates the migration project with the specified parameters.', 'id' => 'create-migration-project-1689716672685', 'title' => 'Create Migration Project', ], ], 'CreateReplicationInstance' => [ [ 'input' => [ 'AllocatedStorage' => 123, 'AutoMinorVersionUpgrade' => true, 'AvailabilityZone' => '', 'EngineVersion' => '', 'KmsKeyId' => '', 'MultiAZ' => true, 'PreferredMaintenanceWindow' => '', 'PubliclyAccessible' => true, 'ReplicationInstanceClass' => '', 'ReplicationInstanceIdentifier' => '', 'ReplicationSubnetGroupIdentifier' => '', 'Tags' => [ [ 'Key' => 'string', 'Value' => 'string', ], ], 'VpcSecurityGroupIds' => [], ], 'output' => [ 'ReplicationInstance' => [ 'AllocatedStorage' => 5, 'AutoMinorVersionUpgrade' => true, 'EngineVersion' => '1.5.0', 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/4c1731d6-5435-ed4d-be13-d53411a7cfbd', 'PendingModifiedValues' => [], 'PreferredMaintenanceWindow' => 'sun:06:00-sun:14:00', 'PubliclyAccessible' => true, 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', 'ReplicationInstanceClass' => 'dms.t2.micro', 'ReplicationInstanceIdentifier' => 'test-rep-1', 'ReplicationInstanceStatus' => 'creating', 'ReplicationSubnetGroup' => [ 'ReplicationSubnetGroupDescription' => 'default', 'ReplicationSubnetGroupIdentifier' => 'default', 'SubnetGroupStatus' => 'Complete', 'Subnets' => [ [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1d', ], 'SubnetIdentifier' => 'subnet-f6dd91af', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1b', ], 'SubnetIdentifier' => 'subnet-3605751d', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1c', ], 'SubnetIdentifier' => 'subnet-c2daefb5', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1e', ], 'SubnetIdentifier' => 'subnet-85e90cb8', 'SubnetStatus' => 'Active', ], ], 'VpcId' => 'vpc-6741a603', ], ], ], 'comments' => [ 'output' => [], ], 'description' => 'Creates the replication instance using the specified parameters.', 'id' => 'create-replication-instance-1481746705295', 'title' => 'Create replication instance', ], ], 'CreateReplicationSubnetGroup' => [ [ 'input' => [ 'ReplicationSubnetGroupDescription' => 'US West subnet group', 'ReplicationSubnetGroupIdentifier' => 'us-west-2ab-vpc-215ds366', 'SubnetIds' => [ 'subnet-e145356n', 'subnet-58f79200', ], 'Tags' => [ [ 'Key' => 'Acount', 'Value' => '145235', ], ], ], 'output' => [ 'ReplicationSubnetGroup' => [], ], 'comments' => [ 'output' => [], ], 'description' => 'Creates a replication subnet group given a list of the subnet IDs in a VPC.', 'id' => 'create-replication-subnet-group-1481747297930', 'title' => 'Create replication subnet group', ], ], 'CreateReplicationTask' => [ [ 'input' => [ 'CdcStartTime' => '2016-12-14T18:25:43Z', 'MigrationType' => 'full-load', 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', 'ReplicationTaskIdentifier' => 'task1', 'ReplicationTaskSettings' => '', 'SourceEndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ZW5UAN6P4E77EC7YWHK4RZZ3BE', 'TableMappings' => 'file://mappingfile.json', 'Tags' => [ [ 'Key' => 'Acount', 'Value' => '24352226', ], ], 'TargetEndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E', ], 'output' => [ 'ReplicationTask' => [ 'MigrationType' => 'full-load', 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', 'ReplicationTaskArn' => 'arn:aws:dms:us-east-1:123456789012:task:OEAMB3NXSTZ6LFYZFEPPBBXPYM', 'ReplicationTaskCreationDate' => '2016-12-14T18:25:43Z', 'ReplicationTaskIdentifier' => 'task1', 'ReplicationTaskSettings' => '{"TargetMetadata":{"TargetSchema":"","SupportLobs":true,"FullLobMode":true,"LobChunkSize":64,"LimitedSizeLobMode":false,"LobMaxSize":0},"FullLoadSettings":{"FullLoadEnabled":true,"ApplyChangesEnabled":false,"TargetTablePrepMode":"DROP_AND_CREATE","CreatePkAfterFullLoad":false,"StopTaskCachedChangesApplied":false,"StopTaskCachedChangesNotApplied":false,"ResumeEnabled":false,"ResumeMinTableSize":100000,"ResumeOnlyClusteredPKTables":true,"MaxFullLoadSubTasks":8,"TransactionConsistencyTimeout":600,"CommitRate":10000},"Logging":{"EnableLogging":false}}', 'SourceEndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ZW5UAN6P4E77EC7YWHK4RZZ3BE', 'Status' => 'creating', 'TableMappings' => 'file://mappingfile.json', 'TargetEndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Creates a replication task using the specified parameters.', 'id' => 'create-replication-task-1481747646288', 'title' => 'Create replication task', ], ], 'DeleteCertificate' => [ [ 'input' => [ 'CertificateArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUSM457DE6XFJCJQ', ], 'output' => [ 'Certificate' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Deletes the specified certificate.', 'id' => 'delete-certificate-1481751957981', 'title' => 'Delete Certificate', ], ], 'DeleteConnection' => [ [ 'input' => [ 'EndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:RAAR3R22XSH46S3PWLC3NJAWKM', 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', ], 'output' => [ 'Connection' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Deletes the connection between the replication instance and the endpoint.', 'id' => 'delete-connection-1481751957981', 'title' => 'Delete Connection', ], ], 'DeleteDataProvider' => [ [ 'input' => [ 'DataProviderIdentifier' => 'arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', ], 'output' => [ 'DataProvider' => [ 'DataProviderArn' => 'arn:aws:dms:us-east-1:012345678901:data-provider:my-target-data-provider', 'DataProviderCreationTime' => '2023-05-12T10:50:41.988561Z', 'DataProviderName' => 'my-target-data-provider', 'Engine' => 'postgres', 'Settings' => [ 'PostgreSqlSettings' => [ 'DatabaseName' => 'target', 'Port' => 5432, 'ServerName' => 'postrgesql.0a1b2c3d4e5f.us-east-1.rds.amazonaws.com', 'SslMode' => 'none', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Deletes the specified data provider.', 'id' => 'delete-data-provider-1689724476356', 'title' => 'Delete Data Provider', ], ], 'DeleteEndpoint' => [ [ 'input' => [ 'EndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:RAAR3R22XSH46S3PWLC3NJAWKM', ], 'output' => [ 'Endpoint' => [ 'EndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:RAAR3R22XSH46S3PWLC3NJAWKM', 'EndpointIdentifier' => 'test-endpoint-1', 'EndpointType' => 'source', 'EngineName' => 'mysql', 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/4c1731d6-5435-ed4d-be13-d53411a7cfbd', 'Port' => 3306, 'ServerName' => 'mydb.cx1llnox7iyx.us-west-2.rds.amazonaws.com', 'Status' => 'active', 'Username' => 'username', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Deletes the specified endpoint. All tasks associated with the endpoint must be deleted before you can delete the endpoint.', 'id' => 'delete-endpoint-1481752425530', 'title' => 'Delete Endpoint', ], ], 'DeleteInstanceProfile' => [ [ 'input' => [ 'InstanceProfileIdentifier' => 'arn:aws:dms:us-east-1:012345678901:instance-profile:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', ], 'output' => [ 'InstanceProfile' => [ 'InstanceProfileArn' => 'arn:aws:dms:us-east-1:012345678901:instance-profile:my-instance-profile', 'InstanceProfileCreationTime' => '2022-12-16T09:44:43.543246Z', 'InstanceProfileName' => 'my-instance-profile', 'KmsKeyArn' => 'arn:aws:kms:us-east-1:012345678901:key/01234567-89ab-cdef-0123-456789abcdef', 'PubliclyAccessible' => true, 'SubnetGroupIdentifier' => 'public-subnets', 'VpcIdentifier' => 'vpc-0a1b2c3d4e5f6g7h8', 'VpcSecurityGroups' => [ 'sg-0123456', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Deletes the specified instance profile.', 'id' => 'delete-instance-profile-1689716924105', 'title' => 'Delete Instance Profile', ], ], 'DeleteMigrationProject' => [ [ 'input' => [ 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', ], 'output' => [ 'MigrationProject' => [ 'InstanceProfileArn' => 'arn:aws:dms:us-east-1:012345678901:instance-profile:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'InstanceProfileName' => 'my-instance-profile', 'MigrationProjectArn' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'MigrationProjectCreationTime' => '2023-04-19T11:45:15.805253Z', 'MigrationProjectName' => 'my-migration-project', 'SchemaConversionApplicationAttributes' => [ 'S3BucketPath' => 'my-s3-bucket/my_folder', 'S3BucketRoleArn' => 'arn:aws:iam::012345678901:role/my-s3role', ], 'SourceDataProviderDescriptors' => [ [ 'DataProviderArn' => 'arn:aws:dms:us-east-1:012345678901:data-provider:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'DataProviderName' => 'all-source-oracle-12', 'SecretsManagerAccessRoleArn' => 'arn:aws:iam::012345678901:role/my-access-role', 'SecretsManagerSecretId' => 'arn:aws:secretsmanager:us-east-1:012345678901:secret:myuser/ALL.SOURCE.ORACLE_12-0123456', ], ], 'TargetDataProviderDescriptors' => [ [ 'DataProviderArn' => 'arn:aws:dms:us-east-1:012345678901:data-provider:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'DataProviderName' => 'sde-obilyns-dataprovider-3', 'SecretsManagerAccessRoleArn' => 'arn:aws:iam::437223687239:role/dmytbon-admin-access', 'SecretsManagerSecretId' => 'arn:aws:secretsmanager:us-east-1:012345678901:secret:myuser/TARGET.postgresql-0123456', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Deletes the specified migration project.', 'id' => 'delete-migration-project-1689717217454', 'title' => 'Delete Migration Project', ], ], 'DeleteReplicationInstance' => [ [ 'input' => [ 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', ], 'output' => [ 'ReplicationInstance' => [ 'AllocatedStorage' => 5, 'AutoMinorVersionUpgrade' => true, 'EngineVersion' => '1.5.0', 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/4c1731d6-5435-ed4d-be13-d53411a7cfbd', 'PendingModifiedValues' => [], 'PreferredMaintenanceWindow' => 'sun:06:00-sun:14:00', 'PubliclyAccessible' => true, 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', 'ReplicationInstanceClass' => 'dms.t2.micro', 'ReplicationInstanceIdentifier' => 'test-rep-1', 'ReplicationInstanceStatus' => 'creating', 'ReplicationSubnetGroup' => [ 'ReplicationSubnetGroupDescription' => 'default', 'ReplicationSubnetGroupIdentifier' => 'default', 'SubnetGroupStatus' => 'Complete', 'Subnets' => [ [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1d', ], 'SubnetIdentifier' => 'subnet-f6dd91af', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1b', ], 'SubnetIdentifier' => 'subnet-3605751d', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1c', ], 'SubnetIdentifier' => 'subnet-c2daefb5', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1e', ], 'SubnetIdentifier' => 'subnet-85e90cb8', 'SubnetStatus' => 'Active', ], ], 'VpcId' => 'vpc-6741a603', ], ], ], 'comments' => [ 'output' => [], ], 'description' => 'Deletes the specified replication instance. You must delete any migration tasks that are associated with the replication instance before you can delete it.', 'id' => 'delete-replication-instance-1481752552839', 'title' => 'Delete Replication Instance', ], ], 'DeleteReplicationSubnetGroup' => [ [ 'input' => [ 'ReplicationSubnetGroupIdentifier' => 'us-west-2ab-vpc-215ds366', ], 'output' => [], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Deletes a replication subnet group.', 'id' => 'delete-replication-subnet-group-1481752728597', 'title' => 'Delete Replication Subnet Group', ], ], 'DeleteReplicationTask' => [ [ 'input' => [ 'ReplicationTaskArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', ], 'output' => [ 'ReplicationTask' => [ 'MigrationType' => 'full-load', 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', 'ReplicationTaskArn' => 'arn:aws:dms:us-east-1:123456789012:task:OEAMB3NXSTZ6LFYZFEPPBBXPYM', 'ReplicationTaskCreationDate' => '2016-12-14T18:25:43Z', 'ReplicationTaskIdentifier' => 'task1', 'ReplicationTaskSettings' => '{"TargetMetadata":{"TargetSchema":"","SupportLobs":true,"FullLobMode":true,"LobChunkSize":64,"LimitedSizeLobMode":false,"LobMaxSize":0},"FullLoadSettings":{"FullLoadEnabled":true,"ApplyChangesEnabled":false,"TargetTablePrepMode":"DROP_AND_CREATE","CreatePkAfterFullLoad":false,"StopTaskCachedChangesApplied":false,"StopTaskCachedChangesNotApplied":false,"ResumeEnabled":false,"ResumeMinTableSize":100000,"ResumeOnlyClusteredPKTables":true,"MaxFullLoadSubTasks":8,"TransactionConsistencyTimeout":600,"CommitRate":10000},"Logging":{"EnableLogging":false}}', 'SourceEndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ZW5UAN6P4E77EC7YWHK4RZZ3BE', 'Status' => 'creating', 'TableMappings' => 'file://mappingfile.json', 'TargetEndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Deletes the specified replication task.', 'id' => 'delete-replication-task-1481752903506', 'title' => 'Delete Replication Task', ], ], 'DescribeAccountAttributes' => [ [ 'input' => [], 'output' => [ 'AccountQuotas' => [ [ 'AccountQuotaName' => 'ReplicationInstances', 'Max' => 20, 'Used' => 0, ], [ 'AccountQuotaName' => 'AllocatedStorage', 'Max' => 20, 'Used' => 0, ], [ 'AccountQuotaName' => 'Endpoints', 'Max' => 20, 'Used' => 0, ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Lists all of the AWS DMS attributes for a customer account. The attributes include AWS DMS quotas for the account, such as the number of replication instances allowed. The description for a quota includes the quota name, current usage toward that quota, and the quota\'s maximum value. This operation does not take any parameters.', 'id' => 'describe-acount-attributes-1481753085663', 'title' => 'Describe acount attributes', ], ], 'DescribeCertificates' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'string', 'Values' => [ 'string', 'string', ], ], ], 'Marker' => '', 'MaxRecords' => 123, ], 'output' => [ 'Certificates' => [], 'Marker' => '', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Provides a description of the certificate.', 'id' => 'describe-certificates-1481753186244', 'title' => 'Describe certificates', ], ], 'DescribeConnections' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'string', 'Values' => [ 'string', 'string', ], ], ], 'Marker' => '', 'MaxRecords' => 123, ], 'output' => [ 'Connections' => [ [ 'EndpointArn' => 'arn:aws:dms:us-east-arn:aws:dms:us-east-1:123456789012:endpoint:ZW5UAN6P4E77EC7YWHK4RZZ3BE', 'EndpointIdentifier' => 'testsrc1', 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', 'ReplicationInstanceIdentifier' => 'test', 'Status' => 'successful', ], ], 'Marker' => '', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Describes the status of the connections that have been made between the replication instance and an endpoint. Connections are created when you test an endpoint.', 'id' => 'describe-connections-1481754477953', 'title' => 'Describe connections', ], ], 'DescribeConversionConfiguration' => [ [ 'input' => [ 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', ], 'output' => [ 'ConversionConfiguration' => '{"Common project settings":{"ShowSeverityLevelInSql":"CRITICAL"},"ORACLE_TO_POSTGRESQL" : {"ToTimeZone":false,"LastDayBuiltinFunctionOracle":false, "NextDayBuiltinFunctionOracle":false,"ConvertProceduresToFunction":false,"NvlBuiltinFunctionOracle":false,"DbmsAssertBuiltinFunctionOracle":false}}', 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns configuration parameters for a schema conversion project.', 'id' => 'describe-conversion-configuration-1689717690907', 'title' => 'Describe Conversion Configuration', ], ], 'DescribeDataProviders' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'data-provider-identifier', 'Values' => [ 'arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', ], ], ], 'Marker' => 'EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', 'MaxRecords' => 20, ], 'output' => [ 'DataProviders' => [ [ 'DataProviderArn' => 'arn:aws:dms:us-east-1:012345678901:data-provider:my-target-data-provider', 'DataProviderCreationTime' => '2023-05-12T10:50:41.988561Z', 'DataProviderName' => 'my-target-data-provider', 'Engine' => 'postgres', 'Settings' => [ 'PostgreSqlSettings' => [ 'DatabaseName' => 'target', 'Port' => 5432, 'ServerName' => 'postrgesql.0a1b2c3d4e5f.us-east-1.rds.amazonaws.com', 'SslMode' => 'none', ], ], ], ], 'Marker' => 'EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => '', 'id' => 'describe-data-providers-1689725897156', 'title' => 'Describe Data Providers', ], ], 'DescribeEndpointTypes' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'string', 'Values' => [ 'string', 'string', ], ], ], 'Marker' => '', 'MaxRecords' => 123, ], 'output' => [ 'Marker' => '', 'SupportedEndpointTypes' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns information about the type of endpoints available.', 'id' => 'describe-endpoint-types-1481754742591', 'title' => 'Describe endpoint types', ], ], 'DescribeEndpoints' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'string', 'Values' => [ 'string', 'string', ], ], ], 'Marker' => '', 'MaxRecords' => 123, ], 'output' => [ 'Endpoints' => [], 'Marker' => '', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns information about the endpoints for your account in the current region.', 'id' => 'describe-endpoints-1481754926060', 'title' => 'Describe endpoints', ], ], 'DescribeExtensionPackAssociations' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'instance-profile-identifier', 'Values' => [ 'arn:aws:dms:us-east-1:012345678901:instance-profile:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', ], ], ], 'Marker' => '0123456789abcdefghijklmnopqrs', 'MaxRecords' => 20, 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', ], 'output' => [ 'Marker' => '0123456789abcdefghijklmnopqrs', 'Requests' => [ [ 'MigrationProjectArn' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'RequestIdentifier' => '01234567-89ab-cdef-0123-456789abcdef', 'Status' => 'SUCCESS', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns a paginated list of extension pack associations for the specified migration project.', 'id' => 'describe-extension-pack-associations-1689718322580', 'title' => 'Describe Extension Pack Associations', ], ], 'DescribeInstanceProfiles' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'instance-profile-identifier', 'Values' => [ 'arn:aws:dms:us-east-1:012345678901:instance-profile:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', ], ], ], 'Marker' => '0123456789abcdefghijklmnopqrs', 'MaxRecords' => 20, ], 'output' => [ 'InstanceProfiles' => [ [ 'InstanceProfileArn' => 'arn:aws:dms:us-east-1:012345678901:instance-profile:my-instance-profile', 'InstanceProfileCreationTime' => '2022-12-16T09:44:43.543246Z', 'InstanceProfileName' => 'my-instance-profile', 'KmsKeyArn' => 'arn:aws:kms:us-east-1:012345678901:key/01234567-89ab-cdef-0123-456789abcdef', 'PubliclyAccessible' => true, 'SubnetGroupIdentifier' => 'public-subnets', 'VpcIdentifier' => 'vpc-0a1b2c3d4e5f6g7h8', ], ], 'Marker' => '0123456789abcdefghijklmnopqrs', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns a paginated list of instance profiles for your account in the current region.', 'id' => 'describe-instance-profiles-1689718406840', 'title' => 'Describe Instance Profiles', ], ], 'DescribeMetadataModelAssessments' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'my-migration-project', 'Values' => [ 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', ], ], ], 'Marker' => '0123456789abcdefghijklmnopqrs', 'MaxRecords' => 20, 'MigrationProjectIdentifier' => '', ], 'output' => [ 'Marker' => 'ASDLKJASDJKHDFHGDNBGDASKJHGFK', 'Requests' => [ [ 'MigrationProjectArn' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'RequestIdentifier' => '01234567-89ab-cdef-0123-456789abcdef', 'Status' => 'SUCCESS', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns a paginated list of metadata model assessments for your account in the current region.', 'id' => 'describe-metadata-model-assessments-1689718702303', 'title' => 'Describe Metadata Model Assessments', ], ], 'DescribeMetadataModelConversions' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'request-id', 'Values' => [ '01234567-89ab-cdef-0123-456789abcdef', ], ], ], 'Marker' => 'EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ123456', 'MaxRecords' => 123, 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', ], 'output' => [ 'Marker' => '0123456789abcdefghijklmnopqrs', 'Requests' => [ [ 'MigrationProjectArn' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'RequestIdentifier' => '01234567-89ab-cdef-0123-456789abcdef', 'Status' => 'SUCCESS', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns a paginated list of metadata model conversions for a migration project.', 'id' => 'describe-metadata-model-conversions-1689719021495', 'title' => 'Describe Metadata Model Conversions', ], ], 'DescribeMetadataModelExportsAsScript' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'request-id', 'Values' => [ '01234567-89ab-cdef-0123-456789abcdef', ], ], ], 'Marker' => '0123456789abcdefghijklmnopqrs', 'MaxRecords' => 20, 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', ], 'output' => [ 'Marker' => '0123456789abcdefghijklmnopqrs', 'Requests' => [ [ 'MigrationProjectArn' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'RequestIdentifier' => '01234567-89ab-cdef-0123-456789abcdef', 'Status' => 'SUCCESS', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns a paginated list of metadata model exports.', 'id' => 'describe-metadata-model-exports-as-script-1689719253938', 'title' => 'Describe Metadata Model Exports As Script', ], ], 'DescribeMetadataModelExportsToTarget' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'request-id', 'Values' => [ '01234567-89ab-cdef-0123-456789abcdef', ], ], ], 'Marker' => '0123456789abcdefghijklmnopqrs', 'MaxRecords' => 20, 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', ], 'output' => [ 'Marker' => '0123456789abcdefghijklmnopqrs', 'Requests' => [ [ 'MigrationProjectArn' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'RequestIdentifier' => '01234567-89ab-cdef-0123-456789abcdef', 'Status' => 'SUCCESS', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns a paginated list of metadata model exports.', 'id' => 'describe-metadata-model-exports-to-target-1689719484750', 'title' => 'Describe Metadata Model Exports To Target', ], ], 'DescribeMetadataModelImports' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'request-id', 'Values' => [ '01234567-89ab-cdef-0123-456789abcdef', ], ], ], 'Marker' => '0123456789abcdefghijklmnopqrs', 'MaxRecords' => 20, 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', ], 'output' => [ 'Marker' => '0123456789abcdefghijklmnopqrs', 'Requests' => [ [ 'MigrationProjectArn' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'RequestIdentifier' => '01234567-89ab-cdef-0123-456789abcdef', 'Status' => 'SUCCESS', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns a paginated list of metadata model imports.', 'id' => 'describe-metadata-model-imports-1689719771322', 'title' => 'Describe Metadata Model Imports', ], ], 'DescribeMigrationProjects' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'migration-project-identifier', 'Values' => [ 'arn:aws:dms:us-east-1:012345678901:migration-project:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ12345678901', ], ], ], 'Marker' => 'EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ123456', 'MaxRecords' => 20, ], 'output' => [ 'Marker' => '0123456789abcdefghijklmnopqrs', 'MigrationProjects' => [ [ 'InstanceProfileArn' => 'arn:aws:dms:us-east-1:012345678901:instance-profile:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'InstanceProfileName' => 'my-instance-profile', 'MigrationProjectArn' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'MigrationProjectCreationTime' => '2023-04-19T11:45:15.805253Z', 'MigrationProjectName' => 'my-migration-project', 'SchemaConversionApplicationAttributes' => [ 'S3BucketPath' => 'my-s3-bucket/my_folder', 'S3BucketRoleArn' => 'arn:aws:iam::012345678901:role/my-s3role', ], 'SourceDataProviderDescriptors' => [ [ 'DataProviderArn' => 'arn:aws:dms:us-east-1:012345678901:data-provider:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'DataProviderName' => 'all-source-oracle-12', 'SecretsManagerAccessRoleArn' => 'arn:aws:iam::012345678901:role/my-access-role', 'SecretsManagerSecretId' => 'arn:aws:secretsmanager:us-east-1:012345678901:secret:mygroup/myalias/ALL.SOURCE.ORACLE_12-012345', ], ], 'TargetDataProviderDescriptors' => [ [ 'DataProviderArn' => 'arn:aws:dms:us-east-1:012345678901:data-provider:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'DataProviderName' => 'my-data-provider', 'SecretsManagerAccessRoleArn' => 'arn:aws:iam::012345678901:role/dmytbon-admin-access', 'SecretsManagerSecretId' => 'arn:aws:secretsmanager:us-east-1:012345678901:secret:mygroup/myalias/TARGET.postgresql-012345', ], ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns a paginated list of migration projects for your account in the current region.', 'id' => 'describe-migration-projects-1689719912075', 'title' => 'Describe Migration Projects', ], ], 'DescribeOrderableReplicationInstances' => [ [ 'input' => [ 'Marker' => '', 'MaxRecords' => 123, ], 'output' => [ 'Marker' => '', 'OrderableReplicationInstances' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns information about the replication instance types that can be created in the specified region.', 'id' => 'describe-orderable-replication-instances-1481755123669', 'title' => 'Describe orderable replication instances', ], ], 'DescribeRefreshSchemasStatus' => [ [ 'input' => [ 'EndpointArn' => '', ], 'output' => [ 'RefreshSchemasStatus' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns the status of the refresh-schemas operation.', 'id' => 'describe-refresh-schema-status-1481755303497', 'title' => 'Describe refresh schema status', ], ], 'DescribeReplicationInstances' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'string', 'Values' => [ 'string', 'string', ], ], ], 'Marker' => '', 'MaxRecords' => 123, ], 'output' => [ 'Marker' => '', 'ReplicationInstances' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns the status of the refresh-schemas operation.', 'id' => 'describe-replication-instances-1481755443952', 'title' => 'Describe replication instances', ], ], 'DescribeReplicationSubnetGroups' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'string', 'Values' => [ 'string', 'string', ], ], ], 'Marker' => '', 'MaxRecords' => 123, ], 'output' => [ 'Marker' => '', 'ReplicationSubnetGroups' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns information about the replication subnet groups.', 'id' => 'describe-replication-subnet-groups-1481755621284', 'title' => 'Describe replication subnet groups', ], ], 'DescribeReplicationTasks' => [ [ 'input' => [ 'Filters' => [ [ 'Name' => 'string', 'Values' => [ 'string', 'string', ], ], ], 'Marker' => '', 'MaxRecords' => 123, ], 'output' => [ 'Marker' => '', 'ReplicationTasks' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns information about replication tasks for your account in the current region.', 'id' => 'describe-replication-tasks-1481755777563', 'title' => 'Describe replication tasks', ], ], 'DescribeSchemas' => [ [ 'input' => [ 'EndpointArn' => '', 'Marker' => '', 'MaxRecords' => 123, ], 'output' => [ 'Marker' => '', 'Schemas' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns information about the schema for the specified endpoint.', 'id' => 'describe-schemas-1481755933924', 'title' => 'Describe schemas', ], ], 'DescribeTableStatistics' => [ [ 'input' => [ 'Marker' => '', 'MaxRecords' => 123, 'ReplicationTaskArn' => '', ], 'output' => [ 'Marker' => '', 'ReplicationTaskArn' => '', 'TableStatistics' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Returns table statistics on the database migration task, including table name, rows inserted, rows updated, and rows deleted.', 'id' => 'describe-table-statistics-1481756071890', 'title' => 'Describe table statistics', ], ], 'ExportMetadataModelAssessment' => [ [ 'input' => [ 'AssessmentReportTypes' => [ 'pdf', ], 'FileName' => 'file', 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'SelectionRules' => '{"rules": [{"rule-type": "selection","rule-id": "1","rule-name": "1","object-locator": {"server-name": "aurora-pg.cluster-a1b2c3d4e5f6.us-east-1.rds.amazonaws.com", "schema-name": "schema1", "table-name": "Cities"},"rule-action": "explicit"} ]}', ], 'output' => [ 'CsvReport' => [ 'ObjectURL' => 'url', 'S3ObjectKey' => 'object-name', ], 'PdfReport' => [ 'ObjectURL' => 'url', 'S3ObjectKey' => 'object-name', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Saves a copy of a database migration assessment report to your S3 bucket. DMS can save your assessment report as a comma-separated value (CSV) or a PDF file.', 'id' => 'export-metadata-model-assessment-1689720309558', 'title' => 'Export Metadata Model Assessment', ], ], 'ImportCertificate' => [ [ 'input' => [ 'CertificateIdentifier' => '', 'CertificatePem' => '', ], 'output' => [ 'Certificate' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Uploads the specified certificate.', 'id' => 'import-certificate-1481756197206', 'title' => 'Import certificate', ], ], 'ListTagsForResource' => [ [ 'input' => [ 'ResourceArn' => '', ], 'output' => [ 'TagList' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Lists all tags for an AWS DMS resource.', 'id' => 'list-tags-for-resource-1481761095501', 'title' => 'List tags for resource', ], ], 'ModifyConversionConfiguration' => [ [ 'input' => [ 'ConversionConfiguration' => '{"Common project settings":{"ShowSeverityLevelInSql":"CRITICAL"},"ORACLE_TO_POSTGRESQL" : {"ToTimeZone":false,"LastDayBuiltinFunctionOracle":false, "NextDayBuiltinFunctionOracle":false,"ConvertProceduresToFunction":false,"NvlBuiltinFunctionOracle":false,"DbmsAssertBuiltinFunctionOracle":false}}', 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', ], 'output' => [ 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Modifies the specified schema conversion configuration using the provided parameters.', 'id' => 'modify-conversion-configuration-1689720529855', 'title' => 'Modify Conversion Configuration', ], ], 'ModifyDataProvider' => [ [ 'input' => [ 'DataProviderIdentifier' => 'arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', 'DataProviderName' => 'new-name', 'Description' => 'description', 'Engine' => 'sqlserver', 'Settings' => [ 'MicrosoftSqlServerSettings' => [ 'DatabaseName' => 'DatabaseName', 'Port' => 11112, 'ServerName' => 'ServerName2', 'SslMode' => 'none', ], ], ], 'output' => [ 'DataProvider' => [ 'DataProviderArn' => 'arn:aws:dms:us-east-1:012345678901:data-provider:my-target-data-provider', 'DataProviderCreationTime' => '2023-05-12T10:50:41.988561Z', 'DataProviderName' => 'my-target-data-provider', 'Engine' => 'postgres', 'Settings' => [ 'PostgreSqlSettings' => [ 'DatabaseName' => 'target', 'Port' => 5432, 'ServerName' => 'postrgesql.0a1b2c3d4e5f.us-east-1.rds.amazonaws.com', 'SslMode' => 'none', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Modifies the specified data provider using the provided settings.', 'id' => 'modify-data-provider-1689720700567', 'title' => 'Modify Data Provider', ], ], 'ModifyEndpoint' => [ [ 'input' => [ 'CertificateArn' => '', 'DatabaseName' => '', 'EndpointArn' => '', 'EndpointIdentifier' => '', 'EndpointType' => 'source', 'EngineName' => '', 'ExtraConnectionAttributes' => '', 'Password' => '', 'Port' => 123, 'ServerName' => '', 'SslMode' => 'require', 'Username' => '', ], 'output' => [ 'Endpoint' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Modifies the specified endpoint.', 'id' => 'modify-endpoint-1481761649937', 'title' => 'Modify endpoint', ], ], 'ModifyInstanceProfile' => [ [ 'input' => [ 'AvailabilityZone' => '', 'Description' => '', 'InstanceProfileIdentifier' => '', 'InstanceProfileName' => '', 'KmsKeyArn' => '', 'NetworkType' => '', 'PubliclyAccessible' => true, 'SubnetGroupIdentifier' => '', 'VpcSecurityGroups' => [], ], 'output' => [ 'InstanceProfile' => [ 'InstanceProfileArn' => 'arn:aws:dms:us-east-1:012345678901:instance-profile:my-instance-profile', 'InstanceProfileCreationTime' => '2022-12-16T09:44:43.543246Z', 'InstanceProfileName' => 'my-instance-profile', 'KmsKeyArn' => 'arn:aws:kms:us-east-1:012345678901:key/01234567-89ab-cdef-0123-456789abcdef', 'PubliclyAccessible' => true, 'SubnetGroupIdentifier' => 'public-subnets', 'VpcIdentifier' => 'vpc-0a1b2c3d4e5f6g7h8', 'VpcSecurityGroups' => [ 'sg-0123456', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Modifies the specified instance profile using the provided parameters.', 'id' => 'modify-instance-profile-1689724223329', 'title' => 'Modify Instance Profile', ], ], 'ModifyMigrationProject' => [ [ 'input' => [ 'Description' => 'description', 'InstanceProfileIdentifier' => 'my-instance-profile', 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', 'MigrationProjectName' => 'new-name', 'SchemaConversionApplicationAttributes' => [ 'S3BucketPath' => 'arn:aws:s3:::myuser-bucket', 'S3BucketRoleArn' => 'arn:aws:iam::012345678901:role/Admin', ], 'SourceDataProviderDescriptors' => [ [ 'DataProviderIdentifier' => 'arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', 'SecretsManagerAccessRoleArn' => 'arn:aws:iam::012345678901:role/myuser-admin-access', 'SecretsManagerSecretId' => 'arn:aws:secretsmanager:us-east-1:012345678901:secret:myorg/myuser/ALL.SOURCE.ORACLE_12-A1B2C3', ], ], 'TargetDataProviderDescriptors' => [ [ 'DataProviderIdentifier' => 'arn:aws:dms:us-east-1:012345678901:data-provider:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', 'SecretsManagerAccessRoleArn' => 'arn:aws:iam::012345678901:role/myuser-admin-access', 'SecretsManagerSecretId' => 'arn:aws:secretsmanager:us-east-1:012345678901:secret:myorg/myuser/TARGET.postgresql-A1B2C3', ], ], ], 'output' => [ 'MigrationProject' => [ 'InstanceProfileArn' => 'arn:aws:dms:us-east-1:012345678901:instance-profile:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'InstanceProfileName' => 'my-instance-profile', 'MigrationProjectArn' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'MigrationProjectCreationTime' => '2023-04-19T11:45:15.805253Z', 'MigrationProjectName' => 'my-migration-project', 'SchemaConversionApplicationAttributes' => [ 'S3BucketPath' => 'my-s3-bucket/my_folder', 'S3BucketRoleArn' => 'arn:aws:iam::012345678901:role/my-s3role', ], 'SourceDataProviderDescriptors' => [ [ 'DataProviderArn' => 'arn:aws:dms:us-east-1:012345678901:data-provider:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'DataProviderName' => 'all-source-oracle-12', 'SecretsManagerAccessRoleArn' => 'arn:aws:iam::012345678901:role/my-access-role', 'SecretsManagerSecretId' => 'arn:aws:secretsmanager:us-east-1:012345678901:secret:mygroup/myalias/ALL.SOURCE.ORACLE_12-TP5rA9', ], ], 'TargetDataProviderDescriptors' => [ [ 'DataProviderArn' => 'arn:aws:dms:us-east-1:012345678901:data-provider:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'DataProviderName' => 'my-dataprovider', 'SecretsManagerAccessRoleArn' => 'arn:aws:iam::012345678901:role/my-access-role', 'SecretsManagerSecretId' => 'arn:aws:secretsmanager:us-east-1:012345678901:secret:mygroup/myalias/TARGET.postgresql-mysecret', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Modifies the specified migration project using the provided parameters.', 'id' => 'modify-migration-project-1689721117475', 'title' => 'Modify Migration Project', ], ], 'ModifyReplicationInstance' => [ [ 'input' => [ 'AllocatedStorage' => 123, 'AllowMajorVersionUpgrade' => true, 'ApplyImmediately' => true, 'AutoMinorVersionUpgrade' => true, 'EngineVersion' => '1.5.0', 'MultiAZ' => true, 'PreferredMaintenanceWindow' => 'sun:06:00-sun:14:00', 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', 'ReplicationInstanceClass' => 'dms.t2.micro', 'ReplicationInstanceIdentifier' => 'test-rep-1', 'VpcSecurityGroupIds' => [], ], 'output' => [ 'ReplicationInstance' => [ 'AllocatedStorage' => 5, 'AutoMinorVersionUpgrade' => true, 'EngineVersion' => '1.5.0', 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/4c1731d6-5435-ed4d-be13-d53411a7cfbd', 'PendingModifiedValues' => [], 'PreferredMaintenanceWindow' => 'sun:06:00-sun:14:00', 'PubliclyAccessible' => true, 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', 'ReplicationInstanceClass' => 'dms.t2.micro', 'ReplicationInstanceIdentifier' => 'test-rep-1', 'ReplicationInstanceStatus' => 'available', 'ReplicationSubnetGroup' => [ 'ReplicationSubnetGroupDescription' => 'default', 'ReplicationSubnetGroupIdentifier' => 'default', 'SubnetGroupStatus' => 'Complete', 'Subnets' => [ [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1d', ], 'SubnetIdentifier' => 'subnet-f6dd91af', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1b', ], 'SubnetIdentifier' => 'subnet-3605751d', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1c', ], 'SubnetIdentifier' => 'subnet-c2daefb5', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1e', ], 'SubnetIdentifier' => 'subnet-85e90cb8', 'SubnetStatus' => 'Active', ], ], 'VpcId' => 'vpc-6741a603', ], ], ], 'comments' => [ 'output' => [], ], 'description' => 'Modifies the replication instance to apply new settings. You can change one or more parameters by specifying these parameters and the new values in the request. Some settings are applied during the maintenance window.', 'id' => 'modify-replication-instance-1481761784746', 'title' => 'Modify replication instance', ], ], 'ModifyReplicationSubnetGroup' => [ [ 'input' => [ 'ReplicationSubnetGroupDescription' => '', 'ReplicationSubnetGroupIdentifier' => '', 'SubnetIds' => [], ], 'output' => [ 'ReplicationSubnetGroup' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Modifies the settings for the specified replication subnet group.', 'id' => 'modify-replication-subnet-group-1481762275392', 'title' => 'Modify replication subnet group', ], ], 'RefreshSchemas' => [ [ 'input' => [ 'EndpointArn' => '', 'ReplicationInstanceArn' => '', ], 'output' => [ 'RefreshSchemasStatus' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Populates the schema for the specified endpoint. This is an asynchronous operation and can take several minutes. You can check the status of this operation by calling the describe-refresh-schemas-status operation.', 'id' => 'refresh-schema-1481762399111', 'title' => 'Refresh schema', ], ], 'RemoveTagsFromResource' => [ [ 'input' => [ 'ResourceArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E', 'TagKeys' => [], ], 'output' => [], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Removes metadata tags from an AWS DMS resource.', 'id' => 'remove-tags-from-resource-1481762571330', 'title' => 'Remove tags from resource', ], ], 'StartExtensionPackAssociation' => [ [ 'input' => [ 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', ], 'output' => [ 'RequestIdentifier' => '01234567-89ab-cdef-0123-456789abcdef', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Applies the extension pack to your target database.', 'id' => 'start-extension-pack-association-1689721897266', 'title' => 'Start Extension Pack Association', ], ], 'StartMetadataModelAssessment' => [ [ 'input' => [ 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'SelectionRules' => '{"rules": [{"rule-type": "selection","rule-id": "1","rule-name": "1","object-locator": {"server-name": "aurora-pg.cluster-0a1b2c3d4e5f.us-east-1.rds.amazonaws.com", "schema-name": "schema1", "table-name": "Cities"},"rule-action": "explicit"} ]}', ], 'output' => [ 'RequestIdentifier' => '01234567-89ab-cdef-0123-456789abcdef', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Creates a database migration assessment report by assessing the migration complexity for your source database.', 'id' => 'start-metadata-model-assessment-1689722322596', 'title' => 'Start Metadata Model Assessment', ], ], 'StartMetadataModelConversion' => [ [ 'input' => [ 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'SelectionRules' => '{"rules": [{"rule-type": "selection","rule-id": "1","rule-name": "1","object-locator": {"server-name": "aurora-pg.cluster-0a1b2c3d4e5f.us-east-1.rds.amazonaws.com", "schema-name": "schema1", "table-name": "Cities"},"rule-action": "explicit"} ]}', ], 'output' => [ 'RequestIdentifier' => '01234567-89ab-cdef-0123-456789abcdef', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Converts your source database objects to a format compatible with the target database. ', 'id' => 'start-metadata-model-conversion-1689722427798', 'title' => 'Start Metadata Model Conversion', ], ], 'StartMetadataModelExportAsScript' => [ [ 'input' => [ 'FileName' => 'FILE', 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'Origin' => 'SOURCE', 'SelectionRules' => '{"rules": [{"rule-type": "selection","rule-id": "1","rule-name": "1","object-locator": {"server-name": "aurora-pg.cluster-0a1b2c3d4e5f.us-east-1.rds.amazonaws.com", "schema-name": "schema1", "table-name": "Cities"},"rule-action": "explicit"} ]}', ], 'output' => [ 'RequestIdentifier' => '01234567-89ab-cdef-0123-456789abcdef', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Saves your converted code to a file as a SQL script, and stores this file on your S3 bucket.', 'id' => 'start-metadata-model-export-as-script-1689722681469', 'title' => 'Start Metadata Model Export As Script', ], ], 'StartMetadataModelExportToTarget' => [ [ 'input' => [ 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:EXAMPLEABCDEFGHIJKLMNOPQRSTUVWXYZ012345', 'OverwriteExtensionPack' => true, 'SelectionRules' => '{"rules": [{"rule-type": "selection","rule-id": "1","rule-name": "1","object-locator": {"server-name": "aurora-pg.cluster-a1b2c3d4e5f6.us-east-1.rds.amazonaws.com", "schema-name": "schema1", "table-name": "Cities"},"rule-action": "explicit"} ]}', ], 'output' => [ 'RequestIdentifier' => '01234567-89ab-cdef-0123-456789abcdef', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Applies converted database objects to your target database.', 'id' => 'start-metadata-model-export-to-target-1689783666835', 'title' => 'Start Metadata Model Export To Target', ], ], 'StartMetadataModelImport' => [ [ 'input' => [ 'MigrationProjectIdentifier' => 'arn:aws:dms:us-east-1:012345678901:migration-project:0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ012', 'Origin' => 'SOURCE', 'Refresh' => false, 'SelectionRules' => '{"rules": [{"rule-type": "selection","rule-id": "1","rule-name": "1","object-locator": {"server-name": "aurora-pg.cluster-0a1b2c3d4e5f.us-east-1.rds.amazonaws.com", "schema-name": "schema1", "table-name": "Cities"},"rule-action": "explicit"} ]}', ], 'output' => [ 'RequestIdentifier' => '01234567-89ab-cdef-0123-456789abcdef', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Loads the metadata for all the dependent database objects of the parent object.', 'id' => 'start-metadata-model-import-1689723124259', 'title' => 'Start Metadata Model Import', ], ], 'StartReplicationTask' => [ [ 'input' => [ 'CdcStartTime' => '2016-12-14T13:33:20Z', 'ReplicationTaskArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', 'StartReplicationTaskType' => 'start-replication', ], 'output' => [ 'ReplicationTask' => [ 'MigrationType' => 'full-load', 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', 'ReplicationTaskArn' => 'arn:aws:dms:us-east-1:123456789012:task:OEAMB3NXSTZ6LFYZFEPPBBXPYM', 'ReplicationTaskCreationDate' => '2016-12-14T18:25:43Z', 'ReplicationTaskIdentifier' => 'task1', 'ReplicationTaskSettings' => '{"TargetMetadata":{"TargetSchema":"","SupportLobs":true,"FullLobMode":true,"LobChunkSize":64,"LimitedSizeLobMode":false,"LobMaxSize":0},"FullLoadSettings":{"FullLoadEnabled":true,"ApplyChangesEnabled":false,"TargetTablePrepMode":"DROP_AND_CREATE","CreatePkAfterFullLoad":false,"StopTaskCachedChangesApplied":false,"StopTaskCachedChangesNotApplied":false,"ResumeEnabled":false,"ResumeMinTableSize":100000,"ResumeOnlyClusteredPKTables":true,"MaxFullLoadSubTasks":8,"TransactionConsistencyTimeout":600,"CommitRate":10000},"Logging":{"EnableLogging":false}}', 'SourceEndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ZW5UAN6P4E77EC7YWHK4RZZ3BE', 'Status' => 'creating', 'TableMappings' => 'file://mappingfile.json', 'TargetEndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Starts the replication task.', 'id' => 'start-replication-task-1481762706778', 'title' => 'Start replication task', ], ], 'StopReplicationTask' => [ [ 'input' => [ 'ReplicationTaskArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E', ], 'output' => [ 'ReplicationTask' => [ 'MigrationType' => 'full-load', 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', 'ReplicationTaskArn' => 'arn:aws:dms:us-east-1:123456789012:task:OEAMB3NXSTZ6LFYZFEPPBBXPYM', 'ReplicationTaskCreationDate' => '2016-12-14T18:25:43Z', 'ReplicationTaskIdentifier' => 'task1', 'ReplicationTaskSettings' => '{"TargetMetadata":{"TargetSchema":"","SupportLobs":true,"FullLobMode":true,"LobChunkSize":64,"LimitedSizeLobMode":false,"LobMaxSize":0},"FullLoadSettings":{"FullLoadEnabled":true,"ApplyChangesEnabled":false,"TargetTablePrepMode":"DROP_AND_CREATE","CreatePkAfterFullLoad":false,"StopTaskCachedChangesApplied":false,"StopTaskCachedChangesNotApplied":false,"ResumeEnabled":false,"ResumeMinTableSize":100000,"ResumeOnlyClusteredPKTables":true,"MaxFullLoadSubTasks":8,"TransactionConsistencyTimeout":600,"CommitRate":10000},"Logging":{"EnableLogging":false}}', 'SourceEndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ZW5UAN6P4E77EC7YWHK4RZZ3BE', 'Status' => 'creating', 'TableMappings' => 'file://mappingfile.json', 'TargetEndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Stops the replication task.', 'id' => 'stop-replication-task-1481762924947', 'title' => 'Stop replication task', ], ], 'TestConnection' => [ [ 'input' => [ 'EndpointArn' => 'arn:aws:dms:us-east-1:123456789012:endpoint:RAAR3R22XSH46S3PWLC3NJAWKM', 'ReplicationInstanceArn' => 'arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ', ], 'output' => [ 'Connection' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'Tests the connection between the replication instance and the endpoint.', 'id' => 'test-conection-1481763017636', 'title' => 'Test conection', ], ], ],];
