<?php
// This file was auto-generated from sdk-root/src/data/elasticache/2015-02-02/docs-2.json
return [ 'version' => '2.0', 'service' => '<fullname>Amazon ElastiCache</fullname> <p>Amazon ElastiCache is a web service that makes it easier to set up, operate, and scale a distributed cache in the cloud.</p> <p>With ElastiCache, customers get all of the benefits of a high-performance, in-memory cache with less of the administrative burden involved in launching and managing a distributed cache. The service makes setup, scaling, and cluster failure handling much simpler than in a self-managed cache deployment.</p> <p>In addition, through integration with Amazon CloudWatch, customers get enhanced visibility into the key performance statistics associated with their cache and can receive alarms if a part of their cache runs hot.</p>', 'operations' => [ 'AddTagsToResource' => '<p>A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource-level permissions</a>.</p> <p> For example, you can use cost-allocation tags to your ElastiCache resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Tagging.html">Using Cost Allocation Tags in Amazon ElastiCache</a> in the <i>ElastiCache User Guide</i>.</p>', 'AuthorizeCacheSecurityGroupIngress' => '<p>Allows network ingress to a cache security group. Applications using ElastiCache must be running on Amazon EC2, and Amazon EC2 security groups are used as the authorization mechanism.</p> <note> <p>You cannot authorize ingress from an Amazon EC2 security group in one region to an ElastiCache cluster in another region.</p> </note>', 'BatchApplyUpdateAction' => '<p>Apply the service update. For more information on service updates and applying them, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/applying-updates.html">Applying Service Updates</a>.</p>', 'BatchStopUpdateAction' => '<p>Stop the service update. For more information on service updates and stopping them, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/stopping-self-service-updates.html">Stopping Service Updates</a>.</p>', 'CompleteMigration' => '<p>Complete the migration of data.</p>', 'CopyServerlessCacheSnapshot' => '<p>Creates a copy of an existing serverless cache’s snapshot. Available for Redis OSS and Serverless Memcached only.</p>', 'CopySnapshot' => '<p>Makes a copy of an existing snapshot.</p> <note> <p>This operation is valid for Redis OSS only.</p> </note> <important> <p>Users or groups that have permissions to use the <code>CopySnapshot</code> operation can create their own Amazon S3 buckets and copy snapshots to it. To control access to your snapshots, use an IAM policy to control who has the ability to use the <code>CopySnapshot</code> operation. For more information about using IAM to control the use of ElastiCache operations, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html">Exporting Snapshots</a> and <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.html">Authentication &amp; Access Control</a>.</p> </important> <p>You could receive the following error messages.</p> <p class="title"> <b>Error Messages</b> </p> <ul> <li> <p> <b>Error Message:</b> The S3 bucket %s is outside of the region.</p> <p> <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket">Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li> <li> <p> <b>Error Message:</b> The S3 bucket %s does not exist.</p> <p> <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket">Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li> <li> <p> <b>Error Message:</b> The S3 bucket %s is not owned by the authenticated user.</p> <p> <b>Solution:</b> Create an Amazon S3 bucket in the same region as your snapshot. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-create-s3-bucket">Step 1: Create an Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li> <li> <p> <b>Error Message:</b> The authenticated user does not have sufficient permissions to perform the desired activity.</p> <p> <b>Solution:</b> Contact your system administrator to get the needed permissions.</p> </li> <li> <p> <b>Error Message:</b> The S3 bucket %s already contains an object with key %s.</p> <p> <b>Solution:</b> Give the <code>TargetSnapshotName</code> a new and unique value. If exporting a snapshot, you could alternatively create a new Amazon S3 bucket and use this same value for <code>TargetSnapshotName</code>.</p> </li> <li> <p> <b>Error Message: </b> ElastiCache has not been granted READ permissions %s on the S3 Bucket.</p> <p> <b>Solution:</b> Add List and Read permissions on the bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li> <li> <p> <b>Error Message: </b> ElastiCache has not been granted WRITE permissions %s on the S3 Bucket.</p> <p> <b>Solution:</b> Add Upload/Delete permissions on the bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li> <li> <p> <b>Error Message: </b> ElastiCache has not been granted READ_ACP permissions %s on the S3 Bucket.</p> <p> <b>Solution:</b> Add View Permissions on the bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the ElastiCache User Guide.</p> </li> </ul>', 'CreateCacheCluster' => '<p>Creates a cluster. All nodes in the cluster run the same protocol-compliant cache engine software, either Memcached or Redis OSS.</p> <p>This operation is not supported for Redis OSS (cluster mode enabled) clusters.</p>', 'CreateCacheParameterGroup' => '<p>Creates a new Amazon ElastiCache cache parameter group. An ElastiCache cache parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster or replication group using the CacheParameterGroup.</p> <p>A newly created CacheParameterGroup is an exact duplicate of the default parameter group for the CacheParameterGroupFamily. To customize the newly created CacheParameterGroup you can change the values of specific parameters. For more information, see:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyCacheParameterGroup.html">ModifyCacheParameterGroup</a> in the ElastiCache API Reference.</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ParameterGroups.html">Parameters and Parameter Groups</a> in the ElastiCache User Guide.</p> </li> </ul>', 'CreateCacheSecurityGroup' => '<p>Creates a new cache security group. Use a cache security group to control access to one or more clusters.</p> <p>Cache security groups are only used when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC). If you are creating a cluster inside of a VPC, use a cache subnet group instead. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_CreateCacheSubnetGroup.html">CreateCacheSubnetGroup</a>.</p>', 'CreateCacheSubnetGroup' => '<p>Creates a new cache subnet group.</p> <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p>', 'CreateGlobalReplicationGroup' => '<p>Global Datastore for Redis OSS offers fully managed, fast, reliable and secure cross-region replication. Using Global Datastore for Redis OSS, you can create cross-region read replica clusters for ElastiCache (Redis OSS) to enable low-latency reads and disaster recovery across regions. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastore.html">Replication Across Regions Using Global Datastore</a>. </p> <ul> <li> <p>The <b>GlobalReplicationGroupIdSuffix</b> is the name of the Global datastore.</p> </li> <li> <p>The <b>PrimaryReplicationGroupId</b> represents the name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.</p> </li> </ul>', 'CreateReplicationGroup' => '<p>Creates a Redis OSS (cluster mode disabled) or a Redis OSS (cluster mode enabled) replication group.</p> <p>This API can be used to create a standalone regional replication group or a secondary replication group associated with a Global datastore.</p> <p>A Redis OSS (cluster mode disabled) replication group is a collection of nodes, where one of the nodes is a read/write primary and the others are read-only replicas. Writes to the primary are asynchronously propagated to the replicas.</p> <p>A Redis OSS cluster-mode enabled cluster is comprised of from 1 to 90 shards (API/CLI: node groups). Each shard has a primary node and up to 5 read-only replica nodes. The configuration can range from 90 shards and 0 replicas to 15 shards and 5 replicas, which is the maximum number or replicas allowed. </p> <p>The node or shard limit can be increased to a maximum of 500 per cluster if the Redis OSS engine version is 5.0.6 or higher. For example, you can choose to configure a 500 node cluster that ranges between 83 shards (one primary and 5 replicas per shard) and 500 shards (single primary and no replicas). Make sure there are enough available IP addresses to accommodate the increase. Common pitfalls include the subnets in the subnet group have too small a CIDR range or the subnets are shared and heavily used by other clusters. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.Creating.html">Creating a Subnet Group</a>. For versions below 5.0.6, the limit is 250 per cluster.</p> <p>To request a limit increase, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html">Amazon Service Limits</a> and choose the limit type <b>Nodes per cluster per instance type</b>. </p> <p>When a Redis OSS (cluster mode disabled) replication group has been successfully created, you can add one or more read replicas to it, up to a total of 5 read replicas. If you need to increase or decrease the number of node groups (console: shards), you can use ElastiCache (Redis OSS) scaling. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Scaling.html">Scaling ElastiCache (Redis OSS) Clusters</a> in the <i>ElastiCache User Guide</i>.</p> <note> <p>This operation is valid for Redis OSS only.</p> </note>', 'CreateServerlessCache' => '<p>Creates a serverless cache.</p>', 'CreateServerlessCacheSnapshot' => '<p>This API creates a copy of an entire ServerlessCache at a specific moment in time. Available for Redis OSS and Serverless Memcached only.</p>', 'CreateSnapshot' => '<p>Creates a copy of an entire cluster or replication group at a specific moment in time.</p> <note> <p>This operation is valid for Redis OSS only.</p> </note>', 'CreateUser' => '<p>For Redis OSS engine version 6.0 onwards: Creates a Redis OSS user. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access Control (RBAC)</a>.</p>', 'CreateUserGroup' => '<p>For Redis OSS engine version 6.0 onwards: Creates a Redis OSS user group. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access Control (RBAC)</a> </p>', 'DecreaseNodeGroupsInGlobalReplicationGroup' => '<p>Decreases the number of node groups in a Global datastore</p>', 'DecreaseReplicaCount' => '<p>Dynamically decreases the number of replicas in a Redis OSS (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis OSS (cluster mode enabled) replication group. This operation is performed with no cluster down time.</p>', 'DeleteCacheCluster' => '<p>Deletes a previously provisioned cluster. <code>DeleteCacheCluster</code> deletes all associated cache nodes, node endpoints and the cluster itself. When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the cluster; you cannot cancel or revert this operation.</p> <p>This operation is not valid for:</p> <ul> <li> <p>Redis OSS (cluster mode enabled) clusters</p> </li> <li> <p>Redis OSS (cluster mode disabled) clusters</p> </li> <li> <p>A cluster that is the last read replica of a replication group</p> </li> <li> <p>A cluster that is the primary node of a replication group</p> </li> <li> <p>A node group (shard) that has Multi-AZ mode enabled</p> </li> <li> <p>A cluster from a Redis OSS (cluster mode enabled) replication group</p> </li> <li> <p>A cluster that is not in the <code>available</code> state</p> </li> </ul>', 'DeleteCacheParameterGroup' => '<p>Deletes the specified cache parameter group. You cannot delete a cache parameter group if it is associated with any cache clusters. You cannot delete the default cache parameter groups in your account.</p>', 'DeleteCacheSecurityGroup' => '<p>Deletes a cache security group.</p> <note> <p>You cannot delete a cache security group if it is associated with any clusters.</p> </note>', 'DeleteCacheSubnetGroup' => '<p>Deletes a cache subnet group.</p> <note> <p>You cannot delete a default cache subnet group or one that is associated with any clusters.</p> </note>', 'DeleteGlobalReplicationGroup' => '<p>Deleting a Global datastore is a two-step process: </p> <ul> <li> <p>First, you must <a>DisassociateGlobalReplicationGroup</a> to remove the secondary clusters in the Global datastore.</p> </li> <li> <p>Once the Global datastore contains only the primary cluster, you can use the <code>DeleteGlobalReplicationGroup</code> API to delete the Global datastore while retainining the primary cluster using <code>RetainPrimaryReplicationGroup=true</code>.</p> </li> </ul> <p>Since the Global Datastore has only a primary cluster, you can delete the Global Datastore while retaining the primary by setting <code>RetainPrimaryReplicationGroup=true</code>. The primary cluster is never deleted when deleting a Global Datastore. It can only be deleted when it no longer is associated with any Global Datastore.</p> <p>When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.</p>', 'DeleteReplicationGroup' => '<p>Deletes an existing replication group. By default, this operation deletes the entire replication group, including the primary/primaries and all of the read replicas. If the replication group has only one primary, you can optionally delete only the read replicas, while retaining the primary by setting <code>RetainPrimaryCluster=true</code>.</p> <p>When you receive a successful response from this operation, Amazon ElastiCache immediately begins deleting the selected resources; you cannot cancel or revert this operation.</p> <note> <ul> <li> <p> <code>CreateSnapshot</code> permission is required to create a final snapshot. Without this permission, the API call will fail with an <code>Access Denied</code> exception.</p> </li> <li> <p>This operation is valid for Redis OSS only.</p> </li> </ul> </note>', 'DeleteServerlessCache' => '<p>Deletes a specified existing serverless cache.</p> <note> <p> <code>CreateServerlessCacheSnapshot</code> permission is required to create a final snapshot. Without this permission, the API call will fail with an <code>Access Denied</code> exception.</p> </note>', 'DeleteServerlessCacheSnapshot' => '<p>Deletes an existing serverless cache snapshot. Available for Redis OSS and Serverless Memcached only.</p>', 'DeleteSnapshot' => '<p>Deletes an existing snapshot. When you receive a successful response from this operation, ElastiCache immediately begins deleting the snapshot; you cannot cancel or revert this operation.</p> <note> <p>This operation is valid for Redis OSS only.</p> </note>', 'DeleteUser' => '<p>For Redis OSS engine version 6.0 onwards: Deletes a user. The user will be removed from all user groups and in turn removed from all replication groups. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access Control (RBAC)</a>. </p>', 'DeleteUserGroup' => '<p>For Redis OSS engine version 6.0 onwards: Deletes a user group. The user group must first be disassociated from the replication group before it can be deleted. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.RBAC.html">Using Role Based Access Control (RBAC)</a>. </p>', 'DescribeCacheClusters' => '<p>Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cache cluster if a cluster identifier is supplied.</p> <p>By default, abbreviated information about the clusters is returned. You can use the optional <i>ShowCacheNodeInfo</i> flag to retrieve detailed information about the cache nodes associated with the clusters. These details include the DNS address and port for the cache node endpoint.</p> <p>If the cluster is in the <i>creating</i> state, only cluster-level information is displayed until all of the nodes are successfully provisioned.</p> <p>If the cluster is in the <i>deleting</i> state, only cluster-level information is displayed.</p> <p>If cache nodes are currently being added to the cluster, node endpoint information and creation time for the additional nodes are not displayed until they are completely provisioned. When the cluster state is <i>available</i>, the cluster is ready for use.</p> <p>If cache nodes are currently being removed from the cluster, no endpoint information for the removed nodes is displayed.</p>', 'DescribeCacheEngineVersions' => '<p>Returns a list of the available cache engines and their versions.</p>', 'DescribeCacheParameterGroups' => '<p>Returns a list of cache parameter group descriptions. If a cache parameter group name is specified, the list contains only the descriptions for that group.</p>', 'DescribeCacheParameters' => '<p>Returns the detailed parameter list for a particular cache parameter group.</p>', 'DescribeCacheSecurityGroups' => '<p>Returns a list of cache security group descriptions. If a cache security group name is specified, the list contains only the description of that group. This applicable only when you have ElastiCache in Classic setup </p>', 'DescribeCacheSubnetGroups' => '<p>Returns a list of cache subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group. This is applicable only when you have ElastiCache in VPC setup. All ElastiCache clusters now launch in VPC by default. </p>', 'DescribeEngineDefaultParameters' => '<p>Returns the default engine and system parameter information for the specified cache engine.</p>', 'DescribeEvents' => '<p>Returns events related to clusters, cache security groups, and cache parameter groups. You can obtain events specific to a particular cluster, cache security group, or cache parameter group by providing the name as a parameter.</p> <p>By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days\' worth of events if necessary.</p>', 'DescribeGlobalReplicationGroups' => '<p>Returns information about a particular global replication group. If no identifier is specified, returns information about all Global datastores. </p>', 'DescribeReplicationGroups' => '<p>Returns information about a particular replication group. If no identifier is specified, <code>DescribeReplicationGroups</code> returns information about all replication groups.</p> <note> <p>This operation is valid for Redis OSS only.</p> </note>', 'DescribeReservedCacheNodes' => '<p>Returns information about reserved cache nodes for this account, or about a specified reserved cache node.</p>', 'DescribeReservedCacheNodesOfferings' => '<p>Lists available reserved cache node offerings.</p>', 'DescribeServerlessCacheSnapshots' => '<p>Returns information about serverless cache snapshots. By default, this API lists all of the customer’s serverless cache snapshots. It can also describe a single serverless cache snapshot, or the snapshots associated with a particular serverless cache. Available for Redis OSS and Serverless Memcached only.</p>', 'DescribeServerlessCaches' => '<p>Returns information about a specific serverless cache. If no identifier is specified, then the API returns information on all the serverless caches belonging to this Amazon Web Services account.</p>', 'DescribeServiceUpdates' => '<p>Returns details of the service updates</p>', 'DescribeSnapshots' => '<p>Returns information about cluster or replication group snapshots. By default, <code>DescribeSnapshots</code> lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cache cluster.</p> <note> <p>This operation is valid for Redis OSS only.</p> </note>', 'DescribeUpdateActions' => '<p>Returns details of the update actions </p>', 'DescribeUserGroups' => '<p>Returns a list of user groups.</p>', 'DescribeUsers' => '<p>Returns a list of users.</p>', 'DisassociateGlobalReplicationGroup' => '<p>Remove a secondary cluster from the Global datastore using the Global datastore name. The secondary cluster will no longer receive updates from the primary cluster, but will remain as a standalone cluster in that Amazon region.</p>', 'ExportServerlessCacheSnapshot' => '<p>Provides the functionality to export the serverless cache snapshot data to Amazon S3. Available for Redis OSS only.</p>', 'FailoverGlobalReplicationGroup' => '<p>Used to failover the primary region to a secondary region. The secondary region will become primary, and all other clusters will become secondary.</p>', 'IncreaseNodeGroupsInGlobalReplicationGroup' => '<p>Increase the number of node groups in the Global datastore</p>', 'IncreaseReplicaCount' => '<p>Dynamically increases the number of replicas in a Redis OSS (cluster mode disabled) replication group or the number of replica nodes in one or more node groups (shards) of a Redis OSS (cluster mode enabled) replication group. This operation is performed with no cluster down time.</p>', 'ListAllowedNodeTypeModifications' => '<p>Lists all available node types that you can scale your Redis OSS cluster\'s or replication group\'s current node type.</p> <p>When you use the <code>ModifyCacheCluster</code> or <code>ModifyReplicationGroup</code> operations to scale your cluster or replication group, the value of the <code>CacheNodeType</code> parameter must be one of the node types returned by this operation.</p>', 'ListTagsForResource' => '<p>Lists all tags currently on a named resource.</p> <p> A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource-level permissions</a>.</p> <p>If the cluster is not in the <i>available</i> state, <code>ListTagsForResource</code> returns an error.</p>', 'ModifyCacheCluster' => '<p>Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration parameters by specifying the parameters and the new values.</p>', 'ModifyCacheParameterGroup' => '<p>Modifies the parameters of a cache parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.</p>', 'ModifyCacheSubnetGroup' => '<p>Modifies an existing cache subnet group.</p>', 'ModifyGlobalReplicationGroup' => '<p>Modifies the settings for a Global datastore.</p>', 'ModifyReplicationGroup' => '<p>Modifies the settings for a replication group. This is limited to Redis OSS 7 and newer.</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/scaling-redis-cluster-mode-enabled.html">Scaling for Amazon ElastiCache (Redis OSS) (cluster mode enabled)</a> in the ElastiCache User Guide</p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_ModifyReplicationGroupShardConfiguration.html">ModifyReplicationGroupShardConfiguration</a> in the ElastiCache API Reference</p> </li> </ul> <note> <p>This operation is valid for Redis OSS only.</p> </note>', 'ModifyReplicationGroupShardConfiguration' => '<p>Modifies a replication group\'s shards (node groups) by allowing you to add shards, remove shards, or rebalance the keyspaces among existing shards.</p>', 'ModifyServerlessCache' => '<p>This API modifies the attributes of a serverless cache.</p>', 'ModifyUser' => '<p>Changes user password(s) and/or access string.</p>', 'ModifyUserGroup' => '<p>Changes the list of users that belong to the user group.</p>', 'PurchaseReservedCacheNodesOffering' => '<p>Allows you to purchase a reserved cache node offering. Reserved nodes are not eligible for cancellation and are non-refundable. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/reserved-nodes.html">Managing Costs with Reserved Nodes</a> for Redis OSS or <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/reserved-nodes.html">Managing Costs with Reserved Nodes</a> for Memcached.</p>', 'RebalanceSlotsInGlobalReplicationGroup' => '<p>Redistribute slots to ensure uniform distribution across existing shards in the cluster.</p>', 'RebootCacheCluster' => '<p>Reboots some, or all, of the cache nodes within a provisioned cluster. This operation applies any modified cache parameter groups to the cluster. The reboot operation takes place as soon as possible, and results in a momentary outage to the cluster. During the reboot, the cluster status is set to REBOOTING.</p> <p>The reboot causes the contents of the cache (for each cache node being rebooted) to be lost.</p> <p>When the reboot is complete, a cluster event is created.</p> <p>Rebooting a cluster is currently supported on Memcached and Redis OSS (cluster mode disabled) clusters. Rebooting is not supported on Redis OSS (cluster mode enabled) clusters.</p> <p>If you make changes to parameters that require a Redis OSS (cluster mode enabled) cluster reboot for the changes to be applied, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/nodes.rebooting.html">Rebooting a Cluster</a> for an alternate process.</p>', 'RemoveTagsFromResource' => '<p>Removes the tags identified by the <code>TagKeys</code> list from the named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/IAM.ResourceLevelPermissions.html">Resource-level permissions</a>.</p>', 'ResetCacheParameterGroup' => '<p>Modifies the parameters of a cache parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire cache parameter group, specify the <code>ResetAllParameters</code> and <code>CacheParameterGroupName</code> parameters.</p>', 'RevokeCacheSecurityGroupIngress' => '<p>Revokes ingress from a cache security group. Use this operation to disallow access from an Amazon EC2 security group that had been previously authorized.</p>', 'StartMigration' => '<p>Start the migration of data.</p>', 'TestFailover' => '<p>Represents the input of a <code>TestFailover</code> operation which tests automatic failover on a specified node group (called shard in the console) in a replication group (called cluster in the console).</p> <p>This API is designed for testing the behavior of your application in case of ElastiCache failover. It is not designed to be an operational tool for initiating a failover to overcome a problem you may have with the cluster. Moreover, in certain conditions such as large-scale operational events, Amazon may block this API. </p> <p class="title"> <b>Note the following</b> </p> <ul> <li> <p>A customer can use this operation to test automatic failover on up to 15 shards (called node groups in the ElastiCache API and Amazon CLI) in any rolling 24-hour period.</p> </li> <li> <p>If calling this operation on shards in different clusters (called replication groups in the API and CLI), the calls can be made concurrently.</p> <p> </p> </li> <li> <p>If calling this operation multiple times on different shards in the same Redis OSS (cluster mode enabled) replication group, the first node replacement must complete before a subsequent call can be made.</p> </li> <li> <p>To determine whether the node replacement is complete you can check Events using the Amazon ElastiCache console, the Amazon CLI, or the ElastiCache API. Look for the following automatic failover related events, listed here in order of occurrance:</p> <ol> <li> <p>Replication group message: <code>Test Failover API called for node group &lt;node-group-id&gt;</code> </p> </li> <li> <p>Cache cluster message: <code>Failover from primary node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed</code> </p> </li> <li> <p>Replication group message: <code>Failover from primary node &lt;primary-node-id&gt; to replica node &lt;node-id&gt; completed</code> </p> </li> <li> <p>Cache cluster message: <code>Recovering cache nodes &lt;node-id&gt;</code> </p> </li> <li> <p>Cache cluster message: <code>Finished recovery for cache nodes &lt;node-id&gt;</code> </p> </li> </ol> <p>For more information see:</p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ECEvents.Viewing.html">Viewing ElastiCache Events</a> in the <i>ElastiCache User Guide</i> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/APIReference/API_DescribeEvents.html">DescribeEvents</a> in the ElastiCache API Reference</p> </li> </ul> </li> </ul> <p>Also see, <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html#auto-failover-test">Testing Multi-AZ </a> in the <i>ElastiCache User Guide</i>.</p>', 'TestMigration' => '<p> Async API to test connection between source and target replication group. </p>', ], 'shapes' => [ 'APICallRateForCustomerExceededFault' => [ 'base' => '<p>The customer has exceeded the allowed rate of API calls.</p>', 'refs' => [], ], 'AZMode' => [ 'base' => NULL, 'refs' => [ 'CreateCacheClusterMessage$AZMode' => '<p>Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster\'s region.</p> <p>This parameter is only supported for Memcached clusters.</p> <p>If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes <code>single-az</code> mode.</p>', 'ModifyCacheClusterMessage$AZMode' => '<p>Specifies whether the new nodes in this Memcached cluster are all created in a single Availability Zone or created across multiple Availability Zones.</p> <p>Valid values: <code>single-az</code> | <code>cross-az</code>.</p> <p>This option is only supported for Memcached clusters.</p> <note> <p>You cannot specify <code>single-az</code> if the Memcached cluster already has cache nodes in different Availability Zones. If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone.</p> <p>Only newly created nodes are located in different Availability Zones. </p> </note>', ], ], 'AccessString' => [ 'base' => NULL, 'refs' => [ 'CreateUserMessage$AccessString' => '<p>Access permissions string used for this user.</p>', 'ModifyUserMessage$AccessString' => '<p>Access permissions string used for this user.</p>', 'ModifyUserMessage$AppendAccessString' => '<p>Adds additional user permissions to the access string.</p>', ], ], 'AddTagsToResourceMessage' => [ 'base' => '<p>Represents the input of an AddTagsToResource operation.</p>', 'refs' => [], ], 'AllowedNodeGroupId' => [ 'base' => NULL, 'refs' => [ 'ConfigureShard$NodeGroupId' => '<p>The 4-digit id for the node group you are configuring. For Redis OSS (cluster mode disabled) replication groups, the node group id is always 0001. To find a Redis OSS (cluster mode enabled)\'s node group\'s (shard\'s) id, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/shard-find-id.html">Finding a Shard\'s Id</a>.</p>', 'NodeGroupConfiguration$NodeGroupId' => '<p>Either the ElastiCache (Redis OSS) supplied 4-digit id or a user supplied id for the node group these configuration values apply to.</p>', 'NodeGroupsToRemoveList$member' => NULL, 'NodeGroupsToRetainList$member' => NULL, 'ReshardingConfiguration$NodeGroupId' => '<p>Either the ElastiCache (Redis OSS) supplied 4-digit id or a user supplied id for the node group these configuration values apply to.</p>', 'TestFailoverMessage$NodeGroupId' => '<p>The name of the node group (called shard in the console) in this replication group on which automatic failover is to be tested. You may test automatic failover on up to 15 node groups in any rolling 24-hour period.</p>', ], ], 'AllowedNodeTypeModificationsMessage' => [ 'base' => '<p>Represents the allowed node types you can use to modify your cluster or replication group.</p>', 'refs' => [], ], 'AuthTokenUpdateStatus' => [ 'base' => NULL, 'refs' => [ 'PendingModifiedValues$AuthTokenStatus' => '<p>The auth token status</p>', 'ReplicationGroupPendingModifiedValues$AuthTokenStatus' => '<p>The auth token status</p>', ], ], 'AuthTokenUpdateStrategyType' => [ 'base' => NULL, 'refs' => [ 'ModifyCacheClusterMessage$AuthTokenUpdateStrategy' => '<p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p> <ul> <li> <p>ROTATE - default, if no update strategy is provided</p> </li> <li> <p>SET - allowed only after ROTATE</p> </li> <li> <p>DELETE - allowed only when transitioning to RBAC</p> </li> </ul> <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis OSS AUTH</a> </p>', 'ModifyReplicationGroupMessage$AuthTokenUpdateStrategy' => '<p>Specifies the strategy to use to update the AUTH token. This parameter must be specified with the <code>auth-token</code> parameter. Possible values:</p> <ul> <li> <p>ROTATE - default, if no update strategy is provided</p> </li> <li> <p>SET - allowed only after ROTATE</p> </li> <li> <p>DELETE - allowed only when transitioning to RBAC</p> </li> </ul> <p> For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/auth.html">Authenticating Users with Redis OSS AUTH</a> </p>', ], ], 'Authentication' => [ 'base' => '<p>Indicates whether the user requires a password to authenticate.</p>', 'refs' => [ 'User$Authentication' => '<p>Denotes whether the user requires a password to authenticate.</p>', ], ], 'AuthenticationMode' => [ 'base' => '<p>Specifies the authentication mode to use.</p>', 'refs' => [ 'CreateUserMessage$AuthenticationMode' => '<p>Specifies how to authenticate the user.</p>', 'ModifyUserMessage$AuthenticationMode' => '<p>Specifies how to authenticate the user.</p>', ], ], 'AuthenticationType' => [ 'base' => NULL, 'refs' => [ 'Authentication$Type' => '<p>Indicates whether the user requires a password to authenticate.</p>', ], ], 'AuthorizationAlreadyExistsFault' => [ 'base' => '<p>The specified Amazon EC2 security group is already authorized for the specified cache security group.</p>', 'refs' => [], ], 'AuthorizationNotFoundFault' => [ 'base' => '<p>The specified Amazon EC2 security group is not authorized for the specified cache security group.</p>', 'refs' => [], ], 'AuthorizeCacheSecurityGroupIngressMessage' => [ 'base' => '<p>Represents the input of an AuthorizeCacheSecurityGroupIngress operation.</p>', 'refs' => [], ], 'AuthorizeCacheSecurityGroupIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'AutomaticFailoverStatus' => [ 'base' => NULL, 'refs' => [ 'GlobalReplicationGroupMember$AutomaticFailover' => '<p>Indicates whether automatic failover is enabled for the replication group.</p>', 'ReplicationGroup$AutomaticFailover' => '<p>Indicates the status of automatic failover for this Redis OSS replication group.</p>', 'Snapshot$AutomaticFailover' => '<p>Indicates the status of automatic failover for the source Redis OSS replication group.</p>', ], ], 'AvailabilityZone' => [ 'base' => '<p>Describes an Availability Zone in which the cluster is launched.</p>', 'refs' => [ 'Subnet$SubnetAvailabilityZone' => '<p>The Availability Zone associated with the subnet.</p>', ], ], 'AvailabilityZonesList' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationGroupMessage$PreferredCacheClusterAZs' => '<p>A list of EC2 Availability Zones in which the replication group\'s clusters are created. The order of the Availability Zones in the list is the order in which clusters are allocated. The primary cluster is created in the first AZ in the list.</p> <p>This parameter is not used if there is more than one node group (shard). You should use <code>NodeGroupConfiguration</code> instead.</p> <note> <p>If you are creating your replication group in an Amazon VPC (recommended), you can only locate clusters in Availability Zones associated with the subnets in the selected subnet group.</p> <p>The number of Availability Zones listed must equal the value of <code>NumCacheClusters</code>.</p> </note> <p>Default: system chosen Availability Zones.</p>', 'NodeGroupConfiguration$ReplicaAvailabilityZones' => '<p>A list of Availability Zones to be used for the read replicas. The number of Availability Zones in this list must match the value of <code>ReplicaCount</code> or <code>ReplicasPerNodeGroup</code> if not specified.</p>', 'ReshardingConfiguration$PreferredAvailabilityZones' => '<p>A list of preferred availability zones for the nodes in this cluster.</p>', ], ], 'AwsQueryErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidParameterCombinationException$message' => '<p>Two or more parameters that must not be used together were used together.</p>', 'InvalidParameterValueException$message' => '<p>A parameter value is invalid.</p>', ], ], 'BatchApplyUpdateActionMessage' => [ 'base' => NULL, 'refs' => [], ], 'BatchStopUpdateActionMessage' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$AutoMinorVersionUpgrade' => '<p> If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.  </p>', 'CacheCluster$ReplicationGroupLogDeliveryEnabled' => '<p>A boolean value indicating whether log delivery is enabled for the replication group.</p>', 'CacheNodeTypeSpecificParameter$IsModifiable' => '<p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.</p>', 'CacheParameterGroup$IsGlobal' => '<p>Indicates whether the parameter group is associated with a Global datastore</p>', 'CompleteMigrationMessage$Force' => '<p>Forces the migration to stop without ensuring that data is in sync. It is recommended to use this option only to abort the migration and not recommended when application wants to continue migration to ElastiCache.</p>', 'DecreaseNodeGroupsInGlobalReplicationGroupMessage$ApplyImmediately' => '<p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is true. </p>', 'DecreaseReplicaCountMessage$ApplyImmediately' => '<p>If <code>True</code>, the number of replica nodes is decreased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>', 'DeleteGlobalReplicationGroupMessage$RetainPrimaryReplicationGroup' => '<p>The primary replication group is retained as a standalone replication group. </p>', 'DescribeCacheEngineVersionsMessage$DefaultOnly' => '<p>If <code>true</code>, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>', 'IncreaseNodeGroupsInGlobalReplicationGroupMessage$ApplyImmediately' => '<p>Indicates that the process begins immediately. At present, the only permitted value for this parameter is true.</p>', 'IncreaseReplicaCountMessage$ApplyImmediately' => '<p>If <code>True</code>, the number of replica nodes is increased immediately. <code>ApplyImmediately=False</code> is not currently supported.</p>', 'ModifyCacheClusterMessage$ApplyImmediately' => '<p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the cluster.</p> <p>If <code>false</code>, changes to the cluster are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p> <important> <p>If you perform a <code>ModifyCacheCluster</code> before a pending modification is applied, the pending modification is replaced by the newer modification.</p> </important> <p>Valid values: <code>true</code> | <code>false</code> </p> <p>Default: <code>false</code> </p>', 'ModifyGlobalReplicationGroupMessage$ApplyImmediately' => '<p>This parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible. Modifications to Global Replication Groups cannot be requested to be applied in PreferredMaintenceWindow. </p>', 'ModifyReplicationGroupMessage$ApplyImmediately' => '<p>If <code>true</code>, this parameter causes the modifications in this request and any pending modifications to be applied, asynchronously and as soon as possible, regardless of the <code>PreferredMaintenanceWindow</code> setting for the replication group.</p> <p>If <code>false</code>, changes to the nodes in the replication group are applied on the next maintenance reboot, or the next failure reboot, whichever occurs first.</p> <p>Valid values: <code>true</code> | <code>false</code> </p> <p>Default: <code>false</code> </p>', 'ModifyReplicationGroupShardConfigurationMessage$ApplyImmediately' => '<p>Indicates that the shard reconfiguration process begins immediately. At present, the only permitted value for this parameter is <code>true</code>.</p> <p>Value: true</p>', 'Parameter$IsModifiable' => '<p>Indicates whether (<code>true</code>) or not (<code>false</code>) the parameter can be modified. Some parameters have security or operational implications that prevent them from being changed.</p>', 'RebalanceSlotsInGlobalReplicationGroupMessage$ApplyImmediately' => '<p>If <code>True</code>, redistribution is applied immediately.</p>', 'ReplicationGroup$AutoMinorVersionUpgrade' => '<p>If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions. </p>', 'ResetCacheParameterGroupMessage$ResetAllParameters' => '<p>If <code>true</code>, all parameters in the cache parameter group are reset to their default values. If <code>false</code>, only the parameters listed by <code>ParameterNameValues</code> are reset to their default values.</p> <p>Valid values: <code>true</code> | <code>false</code> </p>', 'Snapshot$AutoMinorVersionUpgrade' => '<p> If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.  </p>', ], ], 'BooleanOptional' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$AuthTokenEnabled' => '<p>A flag that enables using an <code>AuthToken</code> (password) when issuing Redis OSS commands.</p> <p>Default: <code>false</code> </p>', 'CacheCluster$TransitEncryptionEnabled' => '<p>A flag that enables in-transit encryption when set to <code>true</code>.</p> <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version <code>3.2.6</code>, <code>4.x</code> or later.</p> <p>Default: <code>false</code> </p>', 'CacheCluster$AtRestEncryptionEnabled' => '<p>A flag that enables encryption at-rest when set to <code>true</code>.</p> <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To enable at-rest encryption on a cluster you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create a cluster.</p> <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version <code>3.2.6</code>, <code>4.x</code> or later.</p> <p>Default: <code>false</code> </p>', 'CreateCacheClusterMessage$AutoMinorVersionUpgrade' => '<p> If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.  </p>', 'CreateCacheClusterMessage$TransitEncryptionEnabled' => '<p>A flag that enables in-transit encryption when set to true.</p>', 'CreateReplicationGroupMessage$AutomaticFailoverEnabled' => '<p>Specifies whether a read-only replica is automatically promoted to read/write primary if the existing primary fails.</p> <p> <code>AutomaticFailoverEnabled</code> must be enabled for Redis OSS (cluster mode enabled) replication groups.</p> <p>Default: false</p>', 'CreateReplicationGroupMessage$MultiAZEnabled' => '<p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a>.</p>', 'CreateReplicationGroupMessage$AutoMinorVersionUpgrade' => '<p> If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.  </p>', 'CreateReplicationGroupMessage$TransitEncryptionEnabled' => '<p>A flag that enables in-transit encryption when set to <code>true</code>.</p> <p>This parameter is valid only if the <code>Engine</code> parameter is <code>redis</code>, the <code>EngineVersion</code> parameter is <code>3.2.6</code>, <code>4.x</code> or later, and the cluster is being created in an Amazon VPC.</p> <p>If you enable in-transit encryption, you must also specify a value for <code>CacheSubnetGroup</code>.</p> <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version <code>3.2.6</code>, <code>4.x</code> or later.</p> <p>Default: <code>false</code> </p> <important> <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p> </important>', 'CreateReplicationGroupMessage$AtRestEncryptionEnabled' => '<p>A flag that enables encryption at rest when set to <code>true</code>.</p> <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group. </p> <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version <code>3.2.6</code>, <code>4.x</code> or later.</p> <p>Default: <code>false</code> </p>', 'CreateReplicationGroupMessage$DataTieringEnabled' => '<p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>', 'CreateUserMessage$NoPasswordRequired' => '<p>Indicates a password is not required for this user.</p>', 'DeleteReplicationGroupMessage$RetainPrimaryCluster' => '<p>If set to <code>true</code>, all of the read replicas are deleted, but the primary node is retained.</p>', 'DescribeCacheClustersMessage$ShowCacheNodeInfo' => '<p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to retrieve information about the individual cache nodes.</p>', 'DescribeCacheClustersMessage$ShowCacheClustersNotInReplicationGroups' => '<p>An optional flag that can be included in the <code>DescribeCacheCluster</code> request to show only nodes (API/CLI: clusters) that are not members of a replication group. In practice, this mean Memcached and single node Redis OSS clusters.</p>', 'DescribeGlobalReplicationGroupsMessage$ShowMemberInfo' => '<p>Returns the list of members that comprise the Global datastore.</p>', 'DescribeSnapshotsMessage$ShowNodeGroupConfig' => '<p>A Boolean value which if true, the node group (shard) configuration is included in the snapshot description.</p>', 'DescribeUpdateActionsMessage$ShowNodeLevelUpdateStatus' => '<p>Dictates whether to include node level update status in the response </p>', 'GlobalReplicationGroup$ClusterEnabled' => '<p>A flag that indicates whether the Global datastore is cluster enabled.</p>', 'GlobalReplicationGroup$AuthTokenEnabled' => '<p>A flag that enables using an <code>AuthToken</code> (password) when issuing Redis OSS commands.</p> <p>Default: <code>false</code> </p>', 'GlobalReplicationGroup$TransitEncryptionEnabled' => '<p>A flag that enables in-transit encryption when set to true.</p> <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version <code>3.2.6</code>, <code>4.x</code> or later.</p>', 'GlobalReplicationGroup$AtRestEncryptionEnabled' => '<p>A flag that enables encryption at rest when set to <code>true</code>.</p> <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the replication group is created. To enable encryption at rest on a replication group you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create the replication group. </p> <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version <code>3.2.6</code>, <code>4.x</code> or later.</p>', 'LogDeliveryConfigurationRequest$Enabled' => '<p>Specify if log delivery is enabled. Default <code>true</code>.</p>', 'ModifyCacheClusterMessage$AutoMinorVersionUpgrade' => '<p> If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.  </p>', 'ModifyGlobalReplicationGroupMessage$AutomaticFailoverEnabled' => '<p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure. </p>', 'ModifyReplicationGroupMessage$AutomaticFailoverEnabled' => '<p>Determines whether a read replica is automatically promoted to read/write primary if the existing primary encounters a failure.</p> <p>Valid values: <code>true</code> | <code>false</code> </p>', 'ModifyReplicationGroupMessage$MultiAZEnabled' => '<p>A flag to indicate MultiAZ is enabled.</p>', 'ModifyReplicationGroupMessage$AutoMinorVersionUpgrade' => '<p> If you are running Redis OSS engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next auto minor version upgrade campaign. This parameter is disabled for previous versions.  </p>', 'ModifyReplicationGroupMessage$RemoveUserGroups' => '<p>Removes the user group associated with this replication group.</p>', 'ModifyReplicationGroupMessage$TransitEncryptionEnabled' => '<p>A flag that enables in-transit encryption when set to true. If you are enabling in-transit encryption for an existing cluster, you must also set <code>TransitEncryptionMode</code> to <code>preferred</code>.</p>', 'ModifyServerlessCacheRequest$RemoveUserGroup' => '<p>The identifier of the UserGroup to be removed from association with the Redis OSS serverless cache. Available for Redis OSS only. Default is NULL.</p>', 'ModifyUserMessage$NoPasswordRequired' => '<p>Indicates no password is required for the user.</p>', 'PendingModifiedValues$TransitEncryptionEnabled' => '<p>A flag that enables in-transit encryption when set to true.</p>', 'ReplicationGroup$ClusterEnabled' => '<p>A flag indicating whether or not this replication group is cluster enabled; i.e., whether its data can be partitioned across multiple shards (API/CLI: node groups).</p> <p>Valid values: <code>true</code> | <code>false</code> </p>', 'ReplicationGroup$AuthTokenEnabled' => '<p>A flag that enables using an <code>AuthToken</code> (password) when issuing Redis OSS commands.</p> <p>Default: <code>false</code> </p>', 'ReplicationGroup$TransitEncryptionEnabled' => '<p>A flag that enables in-transit encryption when set to <code>true</code>.</p> <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version <code>3.2.6</code>, <code>4.x</code> or later.</p> <p>Default: <code>false</code> </p>', 'ReplicationGroup$AtRestEncryptionEnabled' => '<p>A flag that enables encryption at-rest when set to <code>true</code>.</p> <p>You cannot modify the value of <code>AtRestEncryptionEnabled</code> after the cluster is created. To enable encryption at-rest on a cluster you must set <code>AtRestEncryptionEnabled</code> to <code>true</code> when you create a cluster.</p> <p> <b>Required:</b> Only available when creating a replication group in an Amazon VPC using Redis OSS version <code>3.2.6</code>, <code>4.x</code> or later.</p> <p>Default: <code>false</code> </p>', 'ReplicationGroupPendingModifiedValues$TransitEncryptionEnabled' => '<p>A flag that enables in-transit encryption when set to true.</p>', 'ServiceUpdate$AutoUpdateAfterRecommendedApplyByDate' => '<p>Indicates whether the service update will be automatically applied once the recommended apply-by date has expired. </p>', ], ], 'CacheCluster' => [ 'base' => '<p>Contains all of the attributes of a specific cluster.</p>', 'refs' => [ 'CacheClusterList$member' => NULL, 'CreateCacheClusterResult$CacheCluster' => NULL, 'DeleteCacheClusterResult$CacheCluster' => NULL, 'ModifyCacheClusterResult$CacheCluster' => NULL, 'RebootCacheClusterResult$CacheCluster' => NULL, ], ], 'CacheClusterAlreadyExistsFault' => [ 'base' => '<p>You already have a cluster with the given identifier.</p>', 'refs' => [], ], 'CacheClusterIdList' => [ 'base' => NULL, 'refs' => [ 'BatchApplyUpdateActionMessage$CacheClusterIds' => '<p>The cache cluster IDs</p>', 'BatchStopUpdateActionMessage$CacheClusterIds' => '<p>The cache cluster IDs</p>', 'DescribeUpdateActionsMessage$CacheClusterIds' => '<p>The cache cluster IDs</p>', ], ], 'CacheClusterList' => [ 'base' => NULL, 'refs' => [ 'CacheClusterMessage$CacheClusters' => '<p>A list of clusters. Each item in the list contains detailed information about one cluster.</p>', ], ], 'CacheClusterMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeCacheClusters</code> operation.</p>', 'refs' => [], ], 'CacheClusterNotFoundFault' => [ 'base' => '<p>The requested cluster ID does not refer to an existing cluster.</p>', 'refs' => [], ], 'CacheEngineVersion' => [ 'base' => '<p>Provides all of the details about a particular cache engine version.</p>', 'refs' => [ 'CacheEngineVersionList$member' => NULL, ], ], 'CacheEngineVersionList' => [ 'base' => NULL, 'refs' => [ 'CacheEngineVersionMessage$CacheEngineVersions' => '<p>A list of cache engine version details. Each element in the list contains detailed information about one cache engine version.</p>', ], ], 'CacheEngineVersionMessage' => [ 'base' => '<p>Represents the output of a <a>DescribeCacheEngineVersions</a> operation.</p>', 'refs' => [], ], 'CacheNode' => [ 'base' => '<p>Represents an individual cache node within a cluster. Each cache node runs its own instance of the cluster\'s protocol-compliant caching software - either Memcached or Redis OSS.</p> <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: </p> <p> <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>, <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>, <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized:</p> <ul> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li> </ul> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: </p> <p> <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>, <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>, <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Additional node type info</b> </p> <ul> <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li> <li> <p>Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.</p> </li> <li> <p>Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.</p> </li> <li> <p>Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis OSS version 2.8.22 and later.</p> </li> </ul>', 'refs' => [ 'CacheNodeList$member' => NULL, ], ], 'CacheNodeIdsList' => [ 'base' => NULL, 'refs' => [ 'CacheParameterGroupStatus$CacheNodeIdsToReboot' => '<p>A list of the cache node IDs which need to be rebooted for parameter changes to be applied. A node ID is a numeric identifier (0001, 0002, etc.).</p>', 'ModifyCacheClusterMessage$CacheNodeIdsToRemove' => '<p>A list of cache node IDs to be removed. A node ID is a numeric identifier (0001, 0002, etc.). This parameter is only valid when <code>NumCacheNodes</code> is less than the existing number of cache nodes. The number of cache node IDs supplied in this parameter must match the difference between the existing number of cache nodes in the cluster or pending cache nodes, whichever is greater, and the value of <code>NumCacheNodes</code> in the request.</p> <p>For example: If you have 3 active cache nodes, 7 pending cache nodes, and the number of cache nodes in this <code>ModifyCacheCluster</code> call is 5, you must list 2 (7 - 5) cache node IDs to remove.</p>', 'PendingModifiedValues$CacheNodeIdsToRemove' => '<p>A list of cache node IDs that are being removed (or will be removed) from the cluster. A node ID is a 4-digit numeric identifier (0001, 0002, etc.).</p>', 'RebootCacheClusterMessage$CacheNodeIdsToReboot' => '<p>A list of cache node IDs to reboot. A node ID is a numeric identifier (0001, 0002, etc.). To reboot an entire cluster, specify all of the cache node IDs.</p>', ], ], 'CacheNodeList' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$CacheNodes' => '<p>A list of cache nodes that are members of the cluster.</p>', ], ], 'CacheNodeTypeSpecificParameter' => [ 'base' => '<p>A parameter that has a different value for each cache node type it is applied to. For example, in a Redis OSS cluster, a <code>cache.m1.large</code> cache node type would have a larger <code>maxmemory</code> value than a <code>cache.m1.small</code> type.</p>', 'refs' => [ 'CacheNodeTypeSpecificParametersList$member' => NULL, ], ], 'CacheNodeTypeSpecificParametersList' => [ 'base' => NULL, 'refs' => [ 'CacheParameterGroupDetails$CacheNodeTypeSpecificParameters' => '<p>A list of parameters specific to a particular cache node type. Each element in the list contains detailed information about one parameter.</p>', 'EngineDefaults$CacheNodeTypeSpecificParameters' => '<p>A list of parameters specific to a particular cache node type. Each element in the list contains detailed information about one parameter.</p>', ], ], 'CacheNodeTypeSpecificValue' => [ 'base' => '<p>A value that applies only to a certain cache node type.</p>', 'refs' => [ 'CacheNodeTypeSpecificValueList$member' => NULL, ], ], 'CacheNodeTypeSpecificValueList' => [ 'base' => NULL, 'refs' => [ 'CacheNodeTypeSpecificParameter$CacheNodeTypeSpecificValues' => '<p>A list of cache node types and their corresponding values for this parameter.</p>', ], ], 'CacheNodeUpdateStatus' => [ 'base' => '<p>The status of the service update on the cache node</p>', 'refs' => [ 'CacheNodeUpdateStatusList$member' => NULL, ], ], 'CacheNodeUpdateStatusList' => [ 'base' => NULL, 'refs' => [ 'UpdateAction$CacheNodeUpdateStatus' => '<p>The status of the service update on the cache node</p>', ], ], 'CacheParameterGroup' => [ 'base' => '<p>Represents the output of a <code>CreateCacheParameterGroup</code> operation.</p>', 'refs' => [ 'CacheParameterGroupList$member' => NULL, 'CreateCacheParameterGroupResult$CacheParameterGroup' => NULL, ], ], 'CacheParameterGroupAlreadyExistsFault' => [ 'base' => '<p>A cache parameter group with the requested name already exists.</p>', 'refs' => [], ], 'CacheParameterGroupDetails' => [ 'base' => '<p>Represents the output of a <code>DescribeCacheParameters</code> operation.</p>', 'refs' => [], ], 'CacheParameterGroupList' => [ 'base' => NULL, 'refs' => [ 'CacheParameterGroupsMessage$CacheParameterGroups' => '<p>A list of cache parameter groups. Each element in the list contains detailed information about one cache parameter group.</p>', ], ], 'CacheParameterGroupNameMessage' => [ 'base' => '<p>Represents the output of one of the following operations:</p> <ul> <li> <p> <code>ModifyCacheParameterGroup</code> </p> </li> <li> <p> <code>ResetCacheParameterGroup</code> </p> </li> </ul>', 'refs' => [], ], 'CacheParameterGroupNotFoundFault' => [ 'base' => '<p>The requested cache parameter group name does not refer to an existing cache parameter group.</p>', 'refs' => [], ], 'CacheParameterGroupQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the maximum number of cache security groups.</p>', 'refs' => [], ], 'CacheParameterGroupStatus' => [ 'base' => '<p>Status of the cache parameter group.</p>', 'refs' => [ 'CacheCluster$CacheParameterGroup' => '<p>Status of the cache parameter group.</p>', ], ], 'CacheParameterGroupsMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeCacheParameterGroups</code> operation.</p>', 'refs' => [], ], 'CacheSecurityGroup' => [ 'base' => '<p>Represents the output of one of the following operations:</p> <ul> <li> <p> <code>AuthorizeCacheSecurityGroupIngress</code> </p> </li> <li> <p> <code>CreateCacheSecurityGroup</code> </p> </li> <li> <p> <code>RevokeCacheSecurityGroupIngress</code> </p> </li> </ul>', 'refs' => [ 'AuthorizeCacheSecurityGroupIngressResult$CacheSecurityGroup' => NULL, 'CacheSecurityGroups$member' => NULL, 'CreateCacheSecurityGroupResult$CacheSecurityGroup' => NULL, 'RevokeCacheSecurityGroupIngressResult$CacheSecurityGroup' => NULL, ], ], 'CacheSecurityGroupAlreadyExistsFault' => [ 'base' => '<p>A cache security group with the specified name already exists.</p>', 'refs' => [], ], 'CacheSecurityGroupMembership' => [ 'base' => '<p>Represents a cluster\'s status within a particular cache security group.</p>', 'refs' => [ 'CacheSecurityGroupMembershipList$member' => NULL, ], ], 'CacheSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$CacheSecurityGroups' => '<p>A list of cache security group elements, composed of name and status sub-elements.</p>', ], ], 'CacheSecurityGroupMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeCacheSecurityGroups</code> operation.</p>', 'refs' => [], ], 'CacheSecurityGroupNameList' => [ 'base' => NULL, 'refs' => [ 'CreateCacheClusterMessage$CacheSecurityGroupNames' => '<p>A list of security group names to associate with this cluster.</p> <p>Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).</p>', 'CreateReplicationGroupMessage$CacheSecurityGroupNames' => '<p>A list of cache security group names to associate with this replication group.</p>', 'ModifyCacheClusterMessage$CacheSecurityGroupNames' => '<p>A list of cache security group names to authorize on this cluster. This change is asynchronously applied as soon as possible.</p> <p>You can use this parameter only with clusters that are created outside of an Amazon Virtual Private Cloud (Amazon VPC).</p> <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be "Default".</p>', 'ModifyReplicationGroupMessage$CacheSecurityGroupNames' => '<p>A list of cache security group names to authorize for the clusters in this replication group. This change is asynchronously applied as soon as possible.</p> <p>This parameter can be used only with replication group containing clusters running outside of an Amazon Virtual Private Cloud (Amazon VPC).</p> <p>Constraints: Must contain no more than 255 alphanumeric characters. Must not be <code>Default</code>.</p>', ], ], 'CacheSecurityGroupNotFoundFault' => [ 'base' => '<p>The requested cache security group name does not refer to an existing cache security group.</p>', 'refs' => [], ], 'CacheSecurityGroupQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the allowed number of cache security groups.</p>', 'refs' => [], ], 'CacheSecurityGroups' => [ 'base' => NULL, 'refs' => [ 'CacheSecurityGroupMessage$CacheSecurityGroups' => '<p>A list of cache security groups. Each element in the list contains detailed information about one group.</p>', ], ], 'CacheSubnetGroup' => [ 'base' => '<p>Represents the output of one of the following operations:</p> <ul> <li> <p> <code>CreateCacheSubnetGroup</code> </p> </li> <li> <p> <code>ModifyCacheSubnetGroup</code> </p> </li> </ul>', 'refs' => [ 'CacheSubnetGroups$member' => NULL, 'CreateCacheSubnetGroupResult$CacheSubnetGroup' => NULL, 'ModifyCacheSubnetGroupResult$CacheSubnetGroup' => NULL, ], ], 'CacheSubnetGroupAlreadyExistsFault' => [ 'base' => '<p>The requested cache subnet group name is already in use by an existing cache subnet group.</p>', 'refs' => [], ], 'CacheSubnetGroupInUse' => [ 'base' => '<p>The requested cache subnet group is currently in use.</p>', 'refs' => [], ], 'CacheSubnetGroupMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeCacheSubnetGroups</code> operation.</p>', 'refs' => [], ], 'CacheSubnetGroupNotFoundFault' => [ 'base' => '<p>The requested cache subnet group name does not refer to an existing cache subnet group.</p>', 'refs' => [], ], 'CacheSubnetGroupQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the allowed number of cache subnet groups.</p>', 'refs' => [], ], 'CacheSubnetGroups' => [ 'base' => NULL, 'refs' => [ 'CacheSubnetGroupMessage$CacheSubnetGroups' => '<p>A list of cache subnet groups. Each element in the list contains detailed information about one group.</p>', ], ], 'CacheSubnetQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the allowed number of subnets in a cache subnet group.</p>', 'refs' => [], ], 'CacheUsageLimits' => [ 'base' => '<p>The usage limits for storage and ElastiCache Processing Units for the cache.</p>', 'refs' => [ 'CreateServerlessCacheRequest$CacheUsageLimits' => '<p>Sets the cache usage limits for storage and ElastiCache Processing Units for the cache.</p>', 'ModifyServerlessCacheRequest$CacheUsageLimits' => '<p>Modify the cache usage limit for the serverless cache.</p>', 'ServerlessCache$CacheUsageLimits' => '<p>The cache usage limit for the serverless cache.</p>', ], ], 'ChangeType' => [ 'base' => NULL, 'refs' => [ 'CacheNodeTypeSpecificParameter$ChangeType' => '<p>Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to be applied. You can force a reboot or wait until the next maintenance window\'s reboot. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a Cluster</a>.</p>', 'Parameter$ChangeType' => '<p>Indicates whether a change to the parameter is applied immediately or requires a reboot for the change to be applied. You can force a reboot or wait until the next maintenance window\'s reboot. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Clusters.Rebooting.html">Rebooting a Cluster</a>.</p>', ], ], 'CloudWatchLogsDestinationDetails' => [ 'base' => '<p>The configuration details of the CloudWatch Logs destination.</p>', 'refs' => [ 'DestinationDetails$CloudWatchLogsDetails' => '<p>The configuration details of the CloudWatch Logs destination.</p>', ], ], 'ClusterIdList' => [ 'base' => NULL, 'refs' => [ 'ReplicationGroup$MemberClusters' => '<p>The names of all the cache clusters that are part of this replication group.</p>', ], ], 'ClusterMode' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationGroupMessage$ClusterMode' => '<p>Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to Compatible. Compatible mode allows your Redis OSS clients to connect using both cluster mode enabled and cluster mode disabled. After you migrate all Redis OSS clients to use cluster mode enabled, you can then complete cluster mode configuration and set the cluster mode to Enabled.</p>', 'ModifyReplicationGroupMessage$ClusterMode' => '<p>Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to Compatible. Compatible mode allows your Redis OSS clients to connect using both cluster mode enabled and cluster mode disabled. After you migrate all Redis OSS clients to use cluster mode enabled, you can then complete cluster mode configuration and set the cluster mode to Enabled.</p>', 'ReplicationGroup$ClusterMode' => '<p>Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to Compatible. Compatible mode allows your Redis OSS clients to connect using both cluster mode enabled and cluster mode disabled. After you migrate all Redis OSS clients to use cluster mode enabled, you can then complete cluster mode configuration and set the cluster mode to Enabled.</p>', 'ReplicationGroupPendingModifiedValues$ClusterMode' => '<p>Enabled or Disabled. To modify cluster mode from Disabled to Enabled, you must first set the cluster mode to Compatible. Compatible mode allows your Redis OSS clients to connect using both cluster mode enabled and cluster mode disabled. After you migrate all Redis OSS clients to use cluster mode enabled, you can then complete cluster mode configuration and set the cluster mode to Enabled.</p>', ], ], 'ClusterQuotaForCustomerExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the allowed number of clusters per customer.</p>', 'refs' => [], ], 'CompleteMigrationMessage' => [ 'base' => NULL, 'refs' => [], ], 'CompleteMigrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ConfigureShard' => [ 'base' => '<p>Node group (shard) configuration options when adding or removing replicas. Each node group (shard) configuration has the following members: NodeGroupId, NewReplicaCount, and PreferredAvailabilityZones. </p>', 'refs' => [ 'ReplicaConfigurationList$member' => NULL, ], ], 'CopyServerlessCacheSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CopyServerlessCacheSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CopySnapshotMessage' => [ 'base' => '<p>Represents the input of a <code>CopySnapshotMessage</code> operation.</p>', 'refs' => [], ], 'CopySnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCacheClusterMessage' => [ 'base' => '<p>Represents the input of a CreateCacheCluster operation.</p>', 'refs' => [], ], 'CreateCacheClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCacheParameterGroupMessage' => [ 'base' => '<p>Represents the input of a <code>CreateCacheParameterGroup</code> operation.</p>', 'refs' => [], ], 'CreateCacheParameterGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCacheSecurityGroupMessage' => [ 'base' => '<p>Represents the input of a <code>CreateCacheSecurityGroup</code> operation.</p>', 'refs' => [], ], 'CreateCacheSecurityGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateCacheSubnetGroupMessage' => [ 'base' => '<p>Represents the input of a <code>CreateCacheSubnetGroup</code> operation.</p>', 'refs' => [], ], 'CreateCacheSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlobalReplicationGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateGlobalReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateReplicationGroupMessage' => [ 'base' => '<p>Represents the input of a <code>CreateReplicationGroup</code> operation.</p>', 'refs' => [], ], 'CreateReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateServerlessCacheRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServerlessCacheResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateServerlessCacheSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateServerlessCacheSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotMessage' => [ 'base' => '<p>Represents the input of a <code>CreateSnapshot</code> operation.</p>', 'refs' => [], ], 'CreateSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserMessage' => [ 'base' => NULL, 'refs' => [], ], 'CustomerNodeEndpoint' => [ 'base' => '<p>The endpoint from which data should be migrated.</p>', 'refs' => [ 'CustomerNodeEndpointList$member' => NULL, ], ], 'CustomerNodeEndpointList' => [ 'base' => NULL, 'refs' => [ 'StartMigrationMessage$CustomerNodeEndpointList' => '<p>List of endpoints from which data should be migrated. For Redis OSS (cluster mode disabled), list should have only one element.</p>', 'TestMigrationMessage$CustomerNodeEndpointList' => '<p> List of endpoints from which data should be migrated. List should have only one element. </p>', ], ], 'DataStorage' => [ 'base' => '<p>The data storage limit.</p>', 'refs' => [ 'CacheUsageLimits$DataStorage' => '<p> The maximum data storage limit in the cache, expressed in Gigabytes. </p>', ], ], 'DataStorageUnit' => [ 'base' => NULL, 'refs' => [ 'DataStorage$Unit' => '<p>The unit that the storage is measured in, in GB.</p>', ], ], 'DataTieringStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicationGroup$DataTiering' => '<p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>', 'Snapshot$DataTiering' => '<p>Enables data tiering. Data tiering is only supported for replication groups using the r6gd node type. This parameter must be set to true when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/data-tiering.html">Data tiering</a>.</p>', ], ], 'DecreaseNodeGroupsInGlobalReplicationGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'DecreaseNodeGroupsInGlobalReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DecreaseReplicaCountMessage' => [ 'base' => NULL, 'refs' => [], ], 'DecreaseReplicaCountResult' => [ 'base' => NULL, 'refs' => [], ], 'DefaultUserAssociatedToUserGroupFault' => [ 'base' => '<p>The default user assigned to the user group.</p>', 'refs' => [], ], 'DefaultUserRequired' => [ 'base' => '<p>You must add default user to a user group.</p>', 'refs' => [], ], 'DeleteCacheClusterMessage' => [ 'base' => '<p>Represents the input of a <code>DeleteCacheCluster</code> operation.</p>', 'refs' => [], ], 'DeleteCacheClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCacheParameterGroupMessage' => [ 'base' => '<p>Represents the input of a <code>DeleteCacheParameterGroup</code> operation.</p>', 'refs' => [], ], 'DeleteCacheSecurityGroupMessage' => [ 'base' => '<p>Represents the input of a <code>DeleteCacheSecurityGroup</code> operation.</p>', 'refs' => [], ], 'DeleteCacheSubnetGroupMessage' => [ 'base' => '<p>Represents the input of a <code>DeleteCacheSubnetGroup</code> operation.</p>', 'refs' => [], ], 'DeleteGlobalReplicationGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGlobalReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteReplicationGroupMessage' => [ 'base' => '<p>Represents the input of a <code>DeleteReplicationGroup</code> operation.</p>', 'refs' => [], ], 'DeleteReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServerlessCacheRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServerlessCacheResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServerlessCacheSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServerlessCacheSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotMessage' => [ 'base' => '<p>Represents the input of a <code>DeleteSnapshot</code> operation.</p>', 'refs' => [], ], 'DeleteSnapshotResult' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCacheClustersMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeCacheClusters</code> operation.</p>', 'refs' => [], ], 'DescribeCacheEngineVersionsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeCacheEngineVersions</code> operation.</p>', 'refs' => [], ], 'DescribeCacheParameterGroupsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeCacheParameterGroups</code> operation.</p>', 'refs' => [], ], 'DescribeCacheParametersMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeCacheParameters</code> operation.</p>', 'refs' => [], ], 'DescribeCacheSecurityGroupsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeCacheSecurityGroups</code> operation.</p>', 'refs' => [], ], 'DescribeCacheSubnetGroupsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeCacheSubnetGroups</code> operation.</p>', 'refs' => [], ], 'DescribeEngineDefaultParametersMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeEngineDefaultParameters</code> operation.</p>', 'refs' => [], ], 'DescribeEngineDefaultParametersResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeEvents</code> operation.</p>', 'refs' => [], ], 'DescribeGlobalReplicationGroupsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGlobalReplicationGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReplicationGroupsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeReplicationGroups</code> operation.</p>', 'refs' => [], ], 'DescribeReservedCacheNodesMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeReservedCacheNodes</code> operation.</p>', 'refs' => [], ], 'DescribeReservedCacheNodesOfferingsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeReservedCacheNodesOfferings</code> operation.</p>', 'refs' => [], ], 'DescribeServerlessCacheSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServerlessCacheSnapshotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServerlessCachesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServerlessCachesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServiceUpdatesMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotsListMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeSnapshots</code> operation.</p>', 'refs' => [], ], 'DescribeSnapshotsMessage' => [ 'base' => '<p>Represents the input of a <code>DescribeSnapshotsMessage</code> operation.</p>', 'refs' => [], ], 'DescribeUpdateActionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserGroupsMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserGroupsResult' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUsersMessage' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUsersResult' => [ 'base' => NULL, 'refs' => [], ], 'DestinationDetails' => [ 'base' => '<p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>', 'refs' => [ 'LogDeliveryConfiguration$DestinationDetails' => '<p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>', 'LogDeliveryConfigurationRequest$DestinationDetails' => '<p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>', 'PendingLogDeliveryConfiguration$DestinationDetails' => '<p>Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.</p>', ], ], 'DestinationType' => [ 'base' => NULL, 'refs' => [ 'LogDeliveryConfiguration$DestinationType' => '<p>Returns the destination type, either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code>.</p>', 'LogDeliveryConfigurationRequest$DestinationType' => '<p>Specify either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> as the destination type.</p>', 'PendingLogDeliveryConfiguration$DestinationType' => '<p>Returns the destination type, either CloudWatch Logs or Kinesis Data Firehose.</p>', ], ], 'DisassociateGlobalReplicationGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateGlobalReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'RecurringCharge$RecurringChargeAmount' => '<p>The monetary amount of the recurring charge.</p>', 'ReservedCacheNode$FixedPrice' => '<p>The fixed price charged for this reserved cache node.</p>', 'ReservedCacheNode$UsagePrice' => '<p>The hourly price charged for this reserved cache node.</p>', 'ReservedCacheNodesOffering$FixedPrice' => '<p>The fixed price charged for this offering.</p>', 'ReservedCacheNodesOffering$UsagePrice' => '<p>The hourly price charged for this offering.</p>', 'SlotMigration$ProgressPercentage' => '<p>The percentage of the slot migration that is complete.</p>', ], ], 'DuplicateUserNameFault' => [ 'base' => '<p>A user with this username already exists.</p>', 'refs' => [], ], 'EC2SecurityGroup' => [ 'base' => '<p>Provides ownership and status information for an Amazon EC2 security group.</p>', 'refs' => [ 'EC2SecurityGroupList$member' => NULL, ], ], 'EC2SecurityGroupList' => [ 'base' => NULL, 'refs' => [ 'CacheSecurityGroup$EC2SecurityGroups' => '<p>A list of Amazon EC2 security groups that are associated with this cache security group.</p>', ], ], 'ECPUPerSecond' => [ 'base' => '<p>The configuration for the number of ElastiCache Processing Units (ECPU) the cache can consume per second.</p>', 'refs' => [ 'CacheUsageLimits$ECPUPerSecond' => NULL, ], ], 'Endpoint' => [ 'base' => '<p>Represents the information required for client programs to connect to a cache node. This value is read-only.</p>', 'refs' => [ 'CacheCluster$ConfigurationEndpoint' => '<p>Represents a Memcached cluster endpoint which can be used by an application to connect to any node in the cluster. The configuration endpoint will always have <code>.cfg</code> in it.</p> <p>Example: <code>mem-3.9dvc4r<u>.cfg</u>.usw2.cache.amazonaws.com:11211</code> </p>', 'CacheNode$Endpoint' => '<p>The hostname for connecting to this cache node.</p>', 'NodeGroup$PrimaryEndpoint' => '<p>The endpoint of the primary node in this node group (shard).</p>', 'NodeGroup$ReaderEndpoint' => '<p>The endpoint of the replica nodes in this node group (shard). This value is read-only.</p>', 'NodeGroupMember$ReadEndpoint' => '<p>The information required for client programs to connect to a node for read operations. The read endpoint is only applicable on Redis OSS (cluster mode disabled) clusters.</p>', 'ReplicationGroup$ConfigurationEndpoint' => '<p>The configuration endpoint for this replication group. Use the configuration endpoint to connect to this replication group.</p>', 'ServerlessCache$Endpoint' => NULL, 'ServerlessCache$ReaderEndpoint' => NULL, ], ], 'EngineDefaults' => [ 'base' => '<p>Represents the output of a <code>DescribeEngineDefaultParameters</code> operation.</p>', 'refs' => [ 'DescribeEngineDefaultParametersResult$EngineDefaults' => NULL, ], ], 'EngineType' => [ 'base' => NULL, 'refs' => [ 'CreateUserGroupMessage$Engine' => '<p>The current supported value is Redis user. </p>', 'CreateUserMessage$Engine' => '<p>The current supported value is Redis. </p>', 'DescribeUsersMessage$Engine' => '<p>The Redis OSS engine. </p>', 'User$Engine' => '<p>The current supported value is Redis.</p>', 'UserGroup$Engine' => '<p>The current supported value is Redis user. </p>', ], ], 'Event' => [ 'base' => '<p>Represents a single occurrence of something interesting within the system. Some examples of events are creating a cluster, adding or removing a cache node, or rebooting a node.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'EventsMessage$Events' => '<p>A list of events. Each element in the list contains detailed information about one event.</p>', ], ], 'EventsMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeEvents</code> operation.</p>', 'refs' => [], ], 'ExportServerlessCacheSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExportServerlessCacheSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'FailoverGlobalReplicationGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'FailoverGlobalReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'Filter' => [ 'base' => '<p>Used to streamline results of a search based on the property being filtered.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeUsersMessage$Filters' => '<p>Filter to determine the list of User IDs to return.</p>', ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'Filter$Name' => '<p>The property being filtered. For example, UserId.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValueList$member' => NULL, ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>The property values to filter on. For example, "user-123".</p>', ], ], 'GlobalNodeGroup' => [ 'base' => '<p>Indicates the slot configuration and global identifier for a slice group.</p>', 'refs' => [ 'GlobalNodeGroupList$member' => NULL, ], ], 'GlobalNodeGroupIdList' => [ 'base' => NULL, 'refs' => [ 'DecreaseNodeGroupsInGlobalReplicationGroupMessage$GlobalNodeGroupsToRemove' => '<p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRemove is a list of NodeGroupIds to remove from the cluster. ElastiCache (Redis OSS) will attempt to remove all node groups listed by GlobalNodeGroupsToRemove from the cluster. </p>', 'DecreaseNodeGroupsInGlobalReplicationGroupMessage$GlobalNodeGroupsToRetain' => '<p>If the value of NodeGroupCount is less than the current number of node groups (shards), then either NodeGroupsToRemove or NodeGroupsToRetain is required. GlobalNodeGroupsToRetain is a list of NodeGroupIds to retain from the cluster. ElastiCache (Redis OSS) will attempt to retain all node groups listed by GlobalNodeGroupsToRetain from the cluster. </p>', ], ], 'GlobalNodeGroupList' => [ 'base' => NULL, 'refs' => [ 'GlobalReplicationGroup$GlobalNodeGroups' => '<p>Indicates the slot configuration and global identifier for each slice group.</p>', ], ], 'GlobalReplicationGroup' => [ 'base' => '<p>Consists of a primary cluster that accepts writes and an associated secondary cluster that resides in a different Amazon region. The secondary cluster accepts only reads. The primary cluster automatically replicates updates to the secondary cluster.</p> <ul> <li> <p>The <b>GlobalReplicationGroupIdSuffix</b> represents the name of the Global datastore, which is what you use to associate a secondary cluster.</p> </li> </ul>', 'refs' => [ 'CreateGlobalReplicationGroupResult$GlobalReplicationGroup' => NULL, 'DecreaseNodeGroupsInGlobalReplicationGroupResult$GlobalReplicationGroup' => NULL, 'DeleteGlobalReplicationGroupResult$GlobalReplicationGroup' => NULL, 'DisassociateGlobalReplicationGroupResult$GlobalReplicationGroup' => NULL, 'FailoverGlobalReplicationGroupResult$GlobalReplicationGroup' => NULL, 'GlobalReplicationGroupList$member' => NULL, 'IncreaseNodeGroupsInGlobalReplicationGroupResult$GlobalReplicationGroup' => NULL, 'ModifyGlobalReplicationGroupResult$GlobalReplicationGroup' => NULL, 'RebalanceSlotsInGlobalReplicationGroupResult$GlobalReplicationGroup' => NULL, ], ], 'GlobalReplicationGroupAlreadyExistsFault' => [ 'base' => '<p>The Global datastore name already exists.</p>', 'refs' => [], ], 'GlobalReplicationGroupInfo' => [ 'base' => '<p>The name of the Global datastore and role of this replication group in the Global datastore.</p>', 'refs' => [ 'ReplicationGroup$GlobalReplicationGroupInfo' => '<p>The name of the Global datastore and role of this replication group in the Global datastore.</p>', ], ], 'GlobalReplicationGroupList' => [ 'base' => NULL, 'refs' => [ 'DescribeGlobalReplicationGroupsResult$GlobalReplicationGroups' => '<p>Indicates the slot configuration and global identifier for each slice group.</p>', ], ], 'GlobalReplicationGroupMember' => [ 'base' => '<p>A member of a Global datastore. It contains the Replication Group Id, the Amazon region and the role of the replication group. </p>', 'refs' => [ 'GlobalReplicationGroupMemberList$member' => NULL, ], ], 'GlobalReplicationGroupMemberList' => [ 'base' => NULL, 'refs' => [ 'GlobalReplicationGroup$Members' => '<p>The replication groups that comprise the Global datastore.</p>', ], ], 'GlobalReplicationGroupNotFoundFault' => [ 'base' => '<p>The Global datastore does not exist</p>', 'refs' => [], ], 'IncreaseNodeGroupsInGlobalReplicationGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'IncreaseNodeGroupsInGlobalReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'IncreaseReplicaCountMessage' => [ 'base' => NULL, 'refs' => [], ], 'IncreaseReplicaCountResult' => [ 'base' => NULL, 'refs' => [], ], 'InputAuthenticationType' => [ 'base' => NULL, 'refs' => [ 'AuthenticationMode$Type' => '<p>Specifies the authentication type. Possible options are IAM authentication, password and no password.</p>', ], ], 'InsufficientCacheClusterCapacityFault' => [ 'base' => '<p>The requested cache node type is not available in the specified Availability Zone. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/ErrorMessages.html#ErrorMessages.INSUFFICIENT_CACHE_CLUSTER_CAPACITY">InsufficientCacheClusterCapacity</a> in the ElastiCache User Guide.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ConfigureShard$NewReplicaCount' => '<p>The number of replicas you want in this node group at the end of this operation. The maximum value for <code>NewReplicaCount</code> is 5. The minimum value depends upon the type of Redis OSS replication group you are working with.</p> <p>The minimum number of replicas in a shard or replication group is:</p> <ul> <li> <p>Redis OSS (cluster mode disabled)</p> <ul> <li> <p>If Multi-AZ: 1</p> </li> <li> <p>If Multi-AZ: 0</p> </li> </ul> </li> <li> <p>Redis OSS (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p> </li> </ul>', 'DecreaseNodeGroupsInGlobalReplicationGroupMessage$NodeGroupCount' => '<p>The number of node groups (shards) that results from the modification of the shard configuration</p>', 'Endpoint$Port' => '<p>The port number that the cache engine is listening on.</p>', 'IncreaseNodeGroupsInGlobalReplicationGroupMessage$NodeGroupCount' => '<p>Total number of node groups you want</p>', 'ModifyReplicationGroupShardConfigurationMessage$NodeGroupCount' => '<p>The number of node groups (shards) that results from the modification of the shard configuration.</p>', 'ReservedCacheNode$Duration' => '<p>The duration of the reservation in seconds.</p>', 'ReservedCacheNode$CacheNodeCount' => '<p>The number of cache nodes that have been reserved.</p>', 'ReservedCacheNodesOffering$Duration' => '<p>The duration of the offering. in seconds.</p>', ], ], 'IntegerOptional' => [ 'base' => NULL, 'refs' => [ 'Authentication$PasswordCount' => '<p>The number of passwords belonging to the user. The maximum is two.</p>', 'CacheCluster$NumCacheNodes' => '<p>The number of cache nodes in the cluster.</p> <p>For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p>', 'CacheCluster$SnapshotRetentionLimit' => '<p>The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <important> <p> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p> </important>', 'CreateCacheClusterMessage$NumCacheNodes' => '<p>The initial number of cache nodes that the cluster has.</p> <p>For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p> <p>If you need more than 40 nodes for your Memcached cluster, please fill out the ElastiCache Limit Increase Request form at <a href="http://aws.amazon.com/contact-us/elasticache-node-limit-request/">http://aws.amazon.com/contact-us/elasticache-node-limit-request/</a>.</p>', 'CreateCacheClusterMessage$Port' => '<p>The port number on which each of the cache nodes accepts connections.</p>', 'CreateCacheClusterMessage$SnapshotRetentionLimit' => '<p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note> <p>Default: 0 (i.e., automatic backups are disabled for this cache cluster).</p>', 'CreateReplicationGroupMessage$NumCacheClusters' => '<p>The number of clusters this replication group initially has.</p> <p>This parameter is not used if there is more than one node group (shard). You should use <code>ReplicasPerNodeGroup</code> instead.</p> <p>If <code>AutomaticFailoverEnabled</code> is <code>true</code>, the value of this parameter must be at least 2. If <code>AutomaticFailoverEnabled</code> is <code>false</code> you can omit this parameter (it will default to 1), or you can explicitly set it to a value between 2 and 6.</p> <p>The maximum permitted value for <code>NumCacheClusters</code> is 6 (1 primary plus 5 replicas).</p>', 'CreateReplicationGroupMessage$NumNodeGroups' => '<p>An optional parameter that specifies the number of node groups (shards) for this Redis OSS (cluster mode enabled) replication group. For Redis OSS (cluster mode disabled) either omit this parameter or set it to 1.</p> <p>Default: 1</p>', 'CreateReplicationGroupMessage$ReplicasPerNodeGroup' => '<p>An optional parameter that specifies the number of replica nodes in each node group (shard). Valid values are 0 to 5.</p>', 'CreateReplicationGroupMessage$Port' => '<p>The port number on which each member of the replication group accepts connections.</p>', 'CreateReplicationGroupMessage$SnapshotRetentionLimit' => '<p>The number of days for which ElastiCache retains automatic snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <p>Default: 0 (i.e., automatic backups are disabled for this cluster).</p>', 'CreateServerlessCacheRequest$SnapshotRetentionLimit' => '<p>The number of snapshots that will be retained for the serverless cache that is being created. As new snapshots beyond this limit are added, the oldest snapshots will be deleted on a rolling basis. Available for Redis OSS and Serverless Memcached only.</p>', 'CustomerNodeEndpoint$Port' => '<p>The port of the node endpoint</p>', 'DataStorage$Maximum' => '<p>The upper limit for data storage the cache is set to use.</p>', 'DataStorage$Minimum' => '<p>The lower limit for data storage the cache is set to use.</p>', 'DecreaseReplicaCountMessage$NewReplicaCount' => '<p>The number of read replica nodes you want at the completion of this operation. For Redis OSS (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis OSS (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group\'s node groups.</p> <p>The minimum number of replicas in a shard or replication group is:</p> <ul> <li> <p>Redis OSS (cluster mode disabled)</p> <ul> <li> <p>If Multi-AZ is enabled: 1</p> </li> <li> <p>If Multi-AZ is not enabled: 0</p> </li> </ul> </li> <li> <p>Redis OSS (cluster mode enabled): 0 (though you will not be able to failover to a replica if your primary node fails)</p> </li> </ul>', 'DescribeCacheClustersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeCacheEngineVersionsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeCacheParameterGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeCacheParametersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeCacheSecurityGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeCacheSubnetGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeEngineDefaultParametersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeEventsMessage$Duration' => '<p>The number of minutes worth of events to retrieve.</p>', 'DescribeEventsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeGlobalReplicationGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>', 'DescribeReplicationGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeReservedCacheNodesMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeReservedCacheNodesOfferingsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 100</p> <p>Constraints: minimum 20; maximum 100.</p>', 'DescribeServerlessCacheSnapshotsRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified max-results value, a market is included in the response so that remaining results can be retrieved. Available for Redis OSS and Serverless Memcached only.The default is 50. The Validation Constraints are a maximum of 50.</p>', 'DescribeServerlessCachesRequest$MaxResults' => '<p>The maximum number of records in the response. If more records exist than the specified max-records value, the next token is included in the response so that remaining results can be retrieved. The default is 50.</p>', 'DescribeServiceUpdatesMessage$MaxRecords' => '<p>The maximum number of records to include in the response</p>', 'DescribeSnapshotsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified <code>MaxRecords</code> value, a marker is included in the response so that the remaining results can be retrieved.</p> <p>Default: 50</p> <p>Constraints: minimum 20; maximum 50.</p>', 'DescribeUpdateActionsMessage$MaxRecords' => '<p>The maximum number of records to include in the response</p>', 'DescribeUserGroupsMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>', 'DescribeUsersMessage$MaxRecords' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved. </p>', 'ECPUPerSecond$Maximum' => '<p>The configuration for the maximum number of ECPUs the cache can consume per second.</p>', 'ECPUPerSecond$Minimum' => '<p>The configuration for the minimum number of ECPUs the cache should be able consume per second.</p>', 'IncreaseReplicaCountMessage$NewReplicaCount' => '<p>The number of read replica nodes you want at the completion of this operation. For Redis OSS (cluster mode disabled) replication groups, this is the number of replica nodes in the replication group. For Redis OSS (cluster mode enabled) replication groups, this is the number of replica nodes in each of the replication group\'s node groups.</p>', 'ModifyCacheClusterMessage$NumCacheNodes' => '<p>The number of cache nodes that the cluster should have. If the value for <code>NumCacheNodes</code> is greater than the sum of the number of current cache nodes and the number of cache nodes pending creation (which may be zero), more nodes are added. If the value is less than the number of existing cache nodes, nodes are removed. If the value is equal to the number of current cache nodes, any pending add or remove requests are canceled.</p> <p>If you are removing cache nodes, you must use the <code>CacheNodeIdsToRemove</code> parameter to provide the IDs of the specific cache nodes to remove.</p> <p>For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p> <note> <p>Adding or removing Memcached cache nodes can be applied immediately or as a pending operation (see <code>ApplyImmediately</code>).</p> <p>A pending operation to modify the number of cache nodes in a cluster during its maintenance window, whether by adding or removing nodes in accordance with the scale out architecture, is not queued. The customer\'s latest request to add or remove nodes to the cluster overrides any previous pending operations to modify the number of cache nodes in the cluster. For example, a request to remove 2 nodes would override a previous pending operation to remove 3 nodes. Similarly, a request to add 2 nodes would override a previous pending operation to remove 3 nodes and vice versa. As Memcached cache nodes may now be provisioned in different Availability Zones with flexible cache node placement, a request to add nodes does not automatically override a previous pending operation to add nodes. The customer can modify the previous pending operation to add more nodes or explicitly cancel the pending request and retry the new request. To cancel pending operations to modify the number of cache nodes in a cluster, use the <code>ModifyCacheCluster</code> request and set <code>NumCacheNodes</code> equal to the number of cache nodes currently in the cluster.</p> </note>', 'ModifyCacheClusterMessage$SnapshotRetentionLimit' => '<p>The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <note> <p>If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p> </note>', 'ModifyReplicationGroupMessage$SnapshotRetentionLimit' => '<p>The number of days for which ElastiCache retains automatic node group (shard) snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <p> <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>', 'ModifyServerlessCacheRequest$SnapshotRetentionLimit' => '<p>The number of days for which Elasticache retains automatic snapshots before deleting them. Available for Redis OSS and Serverless Memcached only. Default = NULL, i.e. the existing snapshot-retention-limit will not be removed or modified. The maximum value allowed is 35 days.</p>', 'NodeGroupConfiguration$ReplicaCount' => '<p>The number of read replica nodes in this node group (shard).</p>', 'PendingModifiedValues$NumCacheNodes' => '<p>The new number of cache nodes for the cluster.</p> <p>For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p>', 'PurchaseReservedCacheNodesOfferingMessage$CacheNodeCount' => '<p>The number of cache node instances to reserve.</p> <p>Default: <code>1</code> </p>', 'ReplicationGroup$SnapshotRetentionLimit' => '<p>The number of days for which ElastiCache retains automatic cluster snapshots before deleting them. For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p> <important> <p> If the value of <code>SnapshotRetentionLimit</code> is set to zero (0), backups are turned off.</p> </important>', 'ServerlessCache$SnapshotRetentionLimit' => '<p>The current setting for the number of serverless cache snapshots the system will retain. Available for Redis OSS and Serverless Memcached only.</p>', 'Snapshot$NumCacheNodes' => '<p>The number of cache nodes in the source cluster.</p> <p>For clusters running Redis OSS, this value must be 1. For clusters running Memcached, this value must be between 1 and 40.</p>', 'Snapshot$Port' => '<p>The port number used by each cache nodes in the source cluster.</p>', 'Snapshot$SnapshotRetentionLimit' => '<p>For an automatic snapshot, the number of days for which ElastiCache retains the snapshot before deleting it.</p> <p>For manual snapshots, this field reflects the <code>SnapshotRetentionLimit</code> for the source cluster when the snapshot was created. This field is otherwise ignored: Manual snapshots do not expire, and can only be deleted using the <code>DeleteSnapshot</code> operation. </p> <p> <b>Important</b> If the value of SnapshotRetentionLimit is set to zero (0), backups are turned off.</p>', 'Snapshot$NumNodeGroups' => '<p>The number of node groups (shards) in this snapshot. When restoring from a snapshot, the number of node groups (shards) in the snapshot and in the restored replication group must be the same.</p>', ], ], 'InvalidARNFault' => [ 'base' => '<p>The requested Amazon Resource Name (ARN) does not refer to an existing resource.</p>', 'refs' => [], ], 'InvalidCacheClusterStateFault' => [ 'base' => '<p>The requested cluster is not in the <code>available</code> state.</p>', 'refs' => [], ], 'InvalidCacheParameterGroupStateFault' => [ 'base' => '<p>The current state of the cache parameter group does not allow the requested operation to occur.</p>', 'refs' => [], ], 'InvalidCacheSecurityGroupStateFault' => [ 'base' => '<p>The current state of the cache security group does not allow deletion.</p>', 'refs' => [], ], 'InvalidCredentialsException' => [ 'base' => '<p>You must enter valid credentials.</p>', 'refs' => [], ], 'InvalidGlobalReplicationGroupStateFault' => [ 'base' => '<p>The Global datastore is not available or in primary-only state.</p>', 'refs' => [], ], 'InvalidKMSKeyFault' => [ 'base' => '<p>The KMS key supplied is not valid.</p>', 'refs' => [], ], 'InvalidParameterCombinationException' => [ 'base' => '<p>Two or more incompatible parameters were specified.</p>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p>The value for a parameter is invalid.</p>', 'refs' => [], ], 'InvalidReplicationGroupStateFault' => [ 'base' => '<p>The requested replication group is not in the <code>available</code> state.</p>', 'refs' => [], ], 'InvalidServerlessCacheSnapshotStateFault' => [ 'base' => '<p>The state of the serverless cache snapshot was not received. Available for Redis OSS and Serverless Memcached only.</p>', 'refs' => [], ], 'InvalidServerlessCacheStateFault' => [ 'base' => '<p>The account for these credentials is not currently active.</p>', 'refs' => [], ], 'InvalidSnapshotStateFault' => [ 'base' => '<p>The current state of the snapshot does not allow the requested operation to occur.</p>', 'refs' => [], ], 'InvalidSubnet' => [ 'base' => '<p>An invalid subnet identifier was specified.</p>', 'refs' => [], ], 'InvalidUserGroupStateFault' => [ 'base' => '<p>The user group is not in an active state.</p>', 'refs' => [], ], 'InvalidUserStateFault' => [ 'base' => '<p>The user is not in active state.</p>', 'refs' => [], ], 'InvalidVPCNetworkStateFault' => [ 'base' => '<p>The VPC network is in an invalid state.</p>', 'refs' => [], ], 'IpDiscovery' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$IpDiscovery' => '<p>The network type associated with the cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.</p>', 'CreateCacheClusterMessage$IpDiscovery' => '<p>The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.</p>', 'CreateReplicationGroupMessage$IpDiscovery' => '<p>The network type you choose when creating a replication group, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.</p>', 'ModifyCacheClusterMessage$IpDiscovery' => '<p>The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.</p>', 'ModifyReplicationGroupMessage$IpDiscovery' => '<p>The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.</p>', 'ReplicationGroup$IpDiscovery' => '<p>The network type you choose when modifying a cluster, either <code>ipv4</code> | <code>ipv6</code>. IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.</p>', ], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'RemoveTagsFromResourceMessage$TagKeys' => '<p>A list of <code>TagKeys</code> identifying the tags you want removed from the named resource.</p>', ], ], 'KinesisFirehoseDestinationDetails' => [ 'base' => '<p>The configuration details of the Kinesis Data Firehose destination.</p>', 'refs' => [ 'DestinationDetails$KinesisFirehoseDetails' => '<p>The configuration details of the Kinesis Data Firehose destination.</p>', ], ], 'ListAllowedNodeTypeModificationsMessage' => [ 'base' => '<p>The input parameters for the <code>ListAllowedNodeTypeModifications</code> operation.</p>', 'refs' => [], ], 'ListTagsForResourceMessage' => [ 'base' => '<p>The input parameters for the <code>ListTagsForResource</code> operation.</p>', 'refs' => [], ], 'LogDeliveryConfiguration' => [ 'base' => '<p>Returns the destination, format and type of the logs. </p>', 'refs' => [ 'LogDeliveryConfigurationList$member' => NULL, ], ], 'LogDeliveryConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$LogDeliveryConfigurations' => '<p>Returns the destination, format and type of the logs.</p>', 'ReplicationGroup$LogDeliveryConfigurations' => '<p>Returns the destination, format and type of the logs. </p>', ], ], 'LogDeliveryConfigurationRequest' => [ 'base' => '<p>Specifies the destination, format and type of the logs. </p>', 'refs' => [ 'LogDeliveryConfigurationRequestList$member' => NULL, ], ], 'LogDeliveryConfigurationRequestList' => [ 'base' => NULL, 'refs' => [ 'CreateCacheClusterMessage$LogDeliveryConfigurations' => '<p>Specifies the destination, format and type of the logs. </p>', 'CreateReplicationGroupMessage$LogDeliveryConfigurations' => '<p>Specifies the destination, format and type of the logs.</p>', 'ModifyCacheClusterMessage$LogDeliveryConfigurations' => '<p>Specifies the destination, format and type of the logs.</p>', 'ModifyReplicationGroupMessage$LogDeliveryConfigurations' => '<p>Specifies the destination, format and type of the logs.</p>', ], ], 'LogDeliveryConfigurationStatus' => [ 'base' => NULL, 'refs' => [ 'LogDeliveryConfiguration$Status' => '<p>Returns the log delivery configuration status. Values are one of <code>enabling</code> | <code>disabling</code> | <code>modifying</code> | <code>active</code> | <code>error</code> </p>', ], ], 'LogFormat' => [ 'base' => NULL, 'refs' => [ 'LogDeliveryConfiguration$LogFormat' => '<p>Returns the log format, either JSON or TEXT.</p>', 'LogDeliveryConfigurationRequest$LogFormat' => '<p>Specifies either JSON or TEXT</p>', 'PendingLogDeliveryConfiguration$LogFormat' => '<p>Returns the log format, either JSON or TEXT</p>', ], ], 'LogType' => [ 'base' => NULL, 'refs' => [ 'LogDeliveryConfiguration$LogType' => '<p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log.</p>', 'LogDeliveryConfigurationRequest$LogType' => '<p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..</p>', 'PendingLogDeliveryConfiguration$LogType' => '<p>Refers to <a href="https://redis.io/commands/slowlog">slow-log</a> or engine-log..</p>', ], ], 'ModifyCacheClusterMessage' => [ 'base' => '<p>Represents the input of a <code>ModifyCacheCluster</code> operation.</p>', 'refs' => [], ], 'ModifyCacheClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyCacheParameterGroupMessage' => [ 'base' => '<p>Represents the input of a <code>ModifyCacheParameterGroup</code> operation.</p>', 'refs' => [], ], 'ModifyCacheSubnetGroupMessage' => [ 'base' => '<p>Represents the input of a <code>ModifyCacheSubnetGroup</code> operation.</p>', 'refs' => [], ], 'ModifyCacheSubnetGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyGlobalReplicationGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyGlobalReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyReplicationGroupMessage' => [ 'base' => '<p>Represents the input of a <code>ModifyReplicationGroups</code> operation.</p>', 'refs' => [], ], 'ModifyReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyReplicationGroupShardConfigurationMessage' => [ 'base' => '<p>Represents the input for a <code>ModifyReplicationGroupShardConfiguration</code> operation.</p>', 'refs' => [], ], 'ModifyReplicationGroupShardConfigurationResult' => [ 'base' => NULL, 'refs' => [], ], 'ModifyServerlessCacheRequest' => [ 'base' => NULL, 'refs' => [], ], 'ModifyServerlessCacheResponse' => [ 'base' => NULL, 'refs' => [], ], 'ModifyUserGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'ModifyUserMessage' => [ 'base' => NULL, 'refs' => [], ], 'MultiAZStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicationGroup$MultiAZ' => '<p>A flag indicating if you have Multi-AZ enabled to enhance fault tolerance. For more information, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/AutoFailover.html">Minimizing Downtime: Multi-AZ</a> </p>', ], ], 'NetworkType' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$NetworkType' => '<p>Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.</p>', 'CreateCacheClusterMessage$NetworkType' => '<p>Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>. </p>', 'CreateReplicationGroupMessage$NetworkType' => '<p>Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.</p>', 'NetworkTypeList$member' => NULL, 'ReplicationGroup$NetworkType' => '<p>Must be either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.</p>', ], ], 'NetworkTypeList' => [ 'base' => NULL, 'refs' => [ 'CacheSubnetGroup$SupportedNetworkTypes' => '<p>Either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.</p>', 'Subnet$SupportedNetworkTypes' => '<p>Either <code>ipv4</code> | <code>ipv6</code> | <code>dual_stack</code>. IPv6 is supported for workloads using Redis OSS engine version 6.2 onward or Memcached engine version 1.6.6 on all instances built on the <a href="http://aws.amazon.com/ec2/nitro/">Nitro system</a>.</p>', ], ], 'NoOperationFault' => [ 'base' => '<p>The operation was not performed because no changes were required.</p>', 'refs' => [], ], 'NodeGroup' => [ 'base' => '<p>Represents a collection of cache nodes in a replication group. One node in the node group is the read/write primary node. All the other nodes are read-only Replica nodes.</p>', 'refs' => [ 'NodeGroupList$member' => NULL, ], ], 'NodeGroupConfiguration' => [ 'base' => '<p>Node group (shard) configuration options. Each node group (shard) configuration has the following: <code>Slots</code>, <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>.</p>', 'refs' => [ 'NodeGroupConfigurationList$member' => NULL, 'NodeSnapshot$NodeGroupConfiguration' => '<p>The configuration for the source node group (shard).</p>', ], ], 'NodeGroupConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationGroupMessage$NodeGroupConfiguration' => '<p>A list of node group (shard) configuration options. Each node group (shard) configuration has the following members: <code>PrimaryAvailabilityZone</code>, <code>ReplicaAvailabilityZones</code>, <code>ReplicaCount</code>, and <code>Slots</code>.</p> <p>If you\'re creating a Redis OSS (cluster mode disabled) or a Redis OSS (cluster mode enabled) replication group, you can use this parameter to individually configure each node group (shard), or you can omit this parameter. However, it is required when seeding a Redis OSS (cluster mode enabled) cluster from a S3 rdb file. You must configure each node group (shard) using this parameter because you must specify the slots for each node group.</p>', ], ], 'NodeGroupList' => [ 'base' => NULL, 'refs' => [ 'ReplicationGroup$NodeGroups' => '<p>A list of node groups in this replication group. For Redis OSS (cluster mode disabled) replication groups, this is a single-element list. For Redis OSS (cluster mode enabled) replication groups, the list contains an entry for each node group (shard).</p>', ], ], 'NodeGroupMember' => [ 'base' => '<p>Represents a single node within a node group (shard).</p>', 'refs' => [ 'NodeGroupMemberList$member' => NULL, ], ], 'NodeGroupMemberList' => [ 'base' => NULL, 'refs' => [ 'NodeGroup$NodeGroupMembers' => '<p>A list containing information about individual nodes within the node group (shard).</p>', ], ], 'NodeGroupMemberUpdateStatus' => [ 'base' => '<p>The status of the service update on the node group member </p>', 'refs' => [ 'NodeGroupMemberUpdateStatusList$member' => NULL, ], ], 'NodeGroupMemberUpdateStatusList' => [ 'base' => NULL, 'refs' => [ 'NodeGroupUpdateStatus$NodeGroupMemberUpdateStatus' => '<p>The status of the service update on the node group member</p>', ], ], 'NodeGroupNotFoundFault' => [ 'base' => '<p>The node group specified by the <code>NodeGroupId</code> parameter could not be found. Please verify that the node group exists and that you spelled the <code>NodeGroupId</code> value correctly.</p>', 'refs' => [], ], 'NodeGroupUpdateStatus' => [ 'base' => '<p>The status of the service update on the node group </p>', 'refs' => [ 'NodeGroupUpdateStatusList$member' => NULL, ], ], 'NodeGroupUpdateStatusList' => [ 'base' => NULL, 'refs' => [ 'UpdateAction$NodeGroupUpdateStatus' => '<p>The status of the service update on the node group</p>', ], ], 'NodeGroupsPerReplicationGroupQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the maximum allowed number of node groups (shards) in a single replication group. The default maximum is 90</p>', 'refs' => [], ], 'NodeGroupsToRemoveList' => [ 'base' => NULL, 'refs' => [ 'ModifyReplicationGroupShardConfigurationMessage$NodeGroupsToRemove' => '<p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRemove</code> is a list of <code>NodeGroupId</code>s to remove from the cluster.</p> <p>ElastiCache (Redis OSS) will attempt to remove all node groups listed by <code>NodeGroupsToRemove</code> from the cluster.</p>', ], ], 'NodeGroupsToRetainList' => [ 'base' => NULL, 'refs' => [ 'ModifyReplicationGroupShardConfigurationMessage$NodeGroupsToRetain' => '<p>If the value of <code>NodeGroupCount</code> is less than the current number of node groups (shards), then either <code>NodeGroupsToRemove</code> or <code>NodeGroupsToRetain</code> is required. <code>NodeGroupsToRetain</code> is a list of <code>NodeGroupId</code>s to retain in the cluster.</p> <p>ElastiCache (Redis OSS) will attempt to remove all node groups except those listed by <code>NodeGroupsToRetain</code> from the cluster.</p>', ], ], 'NodeQuotaForClusterExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the allowed number of cache nodes in a single cluster.</p>', 'refs' => [], ], 'NodeQuotaForCustomerExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the allowed number of cache nodes per customer.</p>', 'refs' => [], ], 'NodeSnapshot' => [ 'base' => '<p>Represents an individual cache node in a snapshot of a cluster.</p>', 'refs' => [ 'NodeSnapshotList$member' => NULL, ], ], 'NodeSnapshotList' => [ 'base' => NULL, 'refs' => [ 'Snapshot$NodeSnapshots' => '<p>A list of the cache nodes in the source cluster.</p>', ], ], 'NodeTypeList' => [ 'base' => NULL, 'refs' => [ 'AllowedNodeTypeModificationsMessage$ScaleUpModifications' => '<p>A string list, each element of which specifies a cache node type which you can use to scale your cluster or replication group.</p> <p>When scaling up a Redis OSS cluster or replication group using <code>ModifyCacheCluster</code> or <code>ModifyReplicationGroup</code>, use a value from this list for the <code>CacheNodeType</code> parameter.</p>', 'AllowedNodeTypeModificationsMessage$ScaleDownModifications' => '<p>A string list, each element of which specifies a cache node type which you can use to scale your cluster or replication group. When scaling down a Redis OSS cluster or replication group using ModifyCacheCluster or ModifyReplicationGroup, use a value from this list for the CacheNodeType parameter. </p>', ], ], 'NodeUpdateInitiatedBy' => [ 'base' => NULL, 'refs' => [ 'CacheNodeUpdateStatus$NodeUpdateInitiatedBy' => '<p>Reflects whether the update was initiated by the customer or automatically applied</p>', 'NodeGroupMemberUpdateStatus$NodeUpdateInitiatedBy' => '<p>Reflects whether the update was initiated by the customer or automatically applied</p>', ], ], 'NodeUpdateStatus' => [ 'base' => NULL, 'refs' => [ 'CacheNodeUpdateStatus$NodeUpdateStatus' => '<p>The update status of the node</p>', 'NodeGroupMemberUpdateStatus$NodeUpdateStatus' => '<p>The update status of the node</p>', ], ], 'NotificationConfiguration' => [ 'base' => '<p>Describes a notification topic and its status. Notification topics are used for publishing ElastiCache events to subscribers using Amazon Simple Notification Service (SNS).</p>', 'refs' => [ 'CacheCluster$NotificationConfiguration' => '<p>Describes a notification topic and its status. Notification topics are used for publishing ElastiCache events to subscribers using Amazon Simple Notification Service (SNS). </p>', ], ], 'OutpostArnsList' => [ 'base' => NULL, 'refs' => [ 'NodeGroupConfiguration$ReplicaOutpostArns' => '<p>The outpost ARN of the node replicas.</p>', ], ], 'OutpostMode' => [ 'base' => NULL, 'refs' => [ 'CreateCacheClusterMessage$OutpostMode' => '<p>Specifies whether the nodes in the cluster are created in a single outpost or across multiple outposts.</p>', ], ], 'Parameter' => [ 'base' => '<p>Describes an individual setting that controls some aspect of ElastiCache behavior.</p>', 'refs' => [ 'ParametersList$member' => NULL, ], ], 'ParameterNameValue' => [ 'base' => '<p>Describes a name-value pair that is used to update the value of a parameter.</p>', 'refs' => [ 'ParameterNameValueList$member' => NULL, ], ], 'ParameterNameValueList' => [ 'base' => NULL, 'refs' => [ 'ModifyCacheParameterGroupMessage$ParameterNameValues' => '<p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be modified per request.</p>', 'ResetCacheParameterGroupMessage$ParameterNameValues' => '<p>An array of parameter names to reset to their default values. If <code>ResetAllParameters</code> is <code>true</code>, do not use <code>ParameterNameValues</code>. If <code>ResetAllParameters</code> is <code>false</code>, you must specify the name of at least one parameter to reset.</p>', ], ], 'ParametersList' => [ 'base' => NULL, 'refs' => [ 'CacheParameterGroupDetails$Parameters' => '<p>A list of <a>Parameter</a> instances.</p>', 'EngineDefaults$Parameters' => '<p>Contains a list of engine default parameters.</p>', ], ], 'PasswordListInput' => [ 'base' => NULL, 'refs' => [ 'AuthenticationMode$Passwords' => '<p>Specifies the passwords to use for authentication if <code>Type</code> is set to <code>password</code>.</p>', 'CreateUserMessage$Passwords' => '<p>Passwords used for this user. You can create up to two passwords for each user.</p>', 'ModifyUserMessage$Passwords' => '<p>The passwords belonging to the user. You are allowed up to two.</p>', ], ], 'PendingAutomaticFailoverStatus' => [ 'base' => NULL, 'refs' => [ 'ReplicationGroupPendingModifiedValues$AutomaticFailoverStatus' => '<p>Indicates the status of automatic failover for this Redis OSS replication group.</p>', ], ], 'PendingLogDeliveryConfiguration' => [ 'base' => '<p>The log delivery configurations being modified </p>', 'refs' => [ 'PendingLogDeliveryConfigurationList$member' => NULL, ], ], 'PendingLogDeliveryConfigurationList' => [ 'base' => NULL, 'refs' => [ 'PendingModifiedValues$LogDeliveryConfigurations' => '<p>The log delivery configurations being modified </p>', 'ReplicationGroupPendingModifiedValues$LogDeliveryConfigurations' => '<p>The log delivery configurations being modified </p>', ], ], 'PendingModifiedValues' => [ 'base' => '<p>A group of settings that are applied to the cluster in the future, or that are currently being applied.</p>', 'refs' => [ 'CacheCluster$PendingModifiedValues' => NULL, ], ], 'PreferredAvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'ConfigureShard$PreferredAvailabilityZones' => '<p>A list of <code>PreferredAvailabilityZone</code> strings that specify which availability zones the replication group\'s nodes are to be in. The nummber of <code>PreferredAvailabilityZone</code> values must equal the value of <code>NewReplicaCount</code> plus 1 to account for the primary node. If this member of <code>ReplicaConfiguration</code> is omitted, ElastiCache (Redis OSS) selects the availability zone for each of the replicas.</p>', 'CreateCacheClusterMessage$PreferredAvailabilityZones' => '<p>A list of the Availability Zones in which cache nodes are created. The order of the zones in the list is not important.</p> <p>This option is only supported on Memcached.</p> <note> <p>If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.</p> <p>The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code>.</p> </note> <p>If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or repeat the Availability Zone multiple times in the list.</p> <p>Default: System chosen Availability Zones.</p>', 'ModifyCacheClusterMessage$NewAvailabilityZones' => '<note> <p>This option is only supported on Memcached clusters.</p> </note> <p>The list of Availability Zones where the new Memcached cache nodes are created.</p> <p>This parameter is only valid when <code>NumCacheNodes</code> in the request is greater than the sum of the number of active cache nodes and the number of cache nodes pending creation (which may be zero). The number of Availability Zones supplied in this list must match the cache nodes being added in this request.</p> <p>Scenarios:</p> <ul> <li> <p> <b>Scenario 1:</b> You have 3 active nodes and wish to add 2 nodes. Specify <code>NumCacheNodes=5</code> (3 + 2) and optionally specify two Availability Zones for the two new nodes.</p> </li> <li> <p> <b>Scenario 2:</b> You have 3 active nodes and 2 nodes pending creation (from the scenario 1 call) and want to add 1 more node. Specify <code>NumCacheNodes=6</code> ((3 + 2) + 1) and optionally specify an Availability Zone for the new node.</p> </li> <li> <p> <b>Scenario 3:</b> You want to cancel all pending operations. Specify <code>NumCacheNodes=3</code> to cancel all pending operations.</p> </li> </ul> <p>The Availability Zone placement of nodes pending creation cannot be modified. If you wish to cancel any nodes pending creation, add 0 nodes by setting <code>NumCacheNodes</code> to the number of current nodes.</p> <p>If <code>cross-az</code> is specified, existing Memcached nodes remain in their current Availability Zone. Only newly created nodes can be located in different Availability Zones. For guidance on how to move existing Memcached nodes to different Availability Zones, see the <b>Availability Zone Considerations</b> section of <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/mem-ug/CacheNodes.SupportedTypes.html">Cache Node Considerations for Memcached</a>.</p> <p> <b>Impact of new add/remove requests upon pending requests</b> </p> <ul> <li> <p>Scenario-1</p> <ul> <li> <p>Pending Action: Delete</p> </li> <li> <p>New Request: Delete</p> </li> <li> <p>Result: The new delete, pending or immediate, replaces the pending delete.</p> </li> </ul> </li> <li> <p>Scenario-2</p> <ul> <li> <p>Pending Action: Delete</p> </li> <li> <p>New Request: Create</p> </li> <li> <p>Result: The new create, pending or immediate, replaces the pending delete.</p> </li> </ul> </li> <li> <p>Scenario-3</p> <ul> <li> <p>Pending Action: Create</p> </li> <li> <p>New Request: Delete</p> </li> <li> <p>Result: The new delete, pending or immediate, replaces the pending create.</p> </li> </ul> </li> <li> <p>Scenario-4</p> <ul> <li> <p>Pending Action: Create</p> </li> <li> <p>New Request: Create</p> </li> <li> <p>Result: The new create is added to the pending create.</p> <important> <p> <b>Important:</b> If the new create request is <b>Apply Immediately - Yes</b>, all creates are performed immediately. If the new create request is <b>Apply Immediately - No</b>, all creates are pending.</p> </important> </li> </ul> </li> </ul>', ], ], 'PreferredOutpostArnList' => [ 'base' => NULL, 'refs' => [ 'ConfigureShard$PreferredOutpostArns' => '<p>The outpost ARNs in which the cache cluster is created.</p>', 'CreateCacheClusterMessage$PreferredOutpostArns' => '<p>The outpost ARNs in which the cache cluster is created.</p>', ], ], 'ProcessedUpdateAction' => [ 'base' => '<p>Update action that has been processed for the corresponding apply/stop request</p>', 'refs' => [ 'ProcessedUpdateActionList$member' => NULL, ], ], 'ProcessedUpdateActionList' => [ 'base' => NULL, 'refs' => [ 'UpdateActionResultsMessage$ProcessedUpdateActions' => '<p>Update actions that have been processed successfully</p>', ], ], 'PurchaseReservedCacheNodesOfferingMessage' => [ 'base' => '<p>Represents the input of a <code>PurchaseReservedCacheNodesOffering</code> operation.</p>', 'refs' => [], ], 'PurchaseReservedCacheNodesOfferingResult' => [ 'base' => NULL, 'refs' => [], ], 'RebalanceSlotsInGlobalReplicationGroupMessage' => [ 'base' => NULL, 'refs' => [], ], 'RebalanceSlotsInGlobalReplicationGroupResult' => [ 'base' => NULL, 'refs' => [], ], 'RebootCacheClusterMessage' => [ 'base' => '<p>Represents the input of a <code>RebootCacheCluster</code> operation.</p>', 'refs' => [], ], 'RebootCacheClusterResult' => [ 'base' => NULL, 'refs' => [], ], 'RecurringCharge' => [ 'base' => '<p>Contains the specific price and frequency of a recurring charges for a reserved cache node, or for a reserved cache node offering.</p>', 'refs' => [ 'RecurringChargeList$member' => NULL, ], ], 'RecurringChargeList' => [ 'base' => NULL, 'refs' => [ 'ReservedCacheNode$RecurringCharges' => '<p>The recurring price charged to run this reserved cache node.</p>', 'ReservedCacheNodesOffering$RecurringCharges' => '<p>The recurring price charged to run this reserved cache node.</p>', ], ], 'RegionalConfiguration' => [ 'base' => '<p>A list of the replication groups </p>', 'refs' => [ 'RegionalConfigurationList$member' => NULL, ], ], 'RegionalConfigurationList' => [ 'base' => NULL, 'refs' => [ 'IncreaseNodeGroupsInGlobalReplicationGroupMessage$RegionalConfigurations' => '<p>Describes the replication group IDs, the Amazon regions where they are stored and the shard configuration for each that comprise the Global datastore</p>', ], ], 'RemoveReplicasList' => [ 'base' => NULL, 'refs' => [ 'DecreaseReplicaCountMessage$ReplicasToRemove' => '<p>A list of the node ids to remove from the replication group or node group (shard).</p>', ], ], 'RemoveTagsFromResourceMessage' => [ 'base' => '<p>Represents the input of a <code>RemoveTagsFromResource</code> operation.</p>', 'refs' => [], ], 'ReplicaConfigurationList' => [ 'base' => NULL, 'refs' => [ 'DecreaseReplicaCountMessage$ReplicaConfiguration' => '<p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis OSS (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>', 'IncreaseReplicaCountMessage$ReplicaConfiguration' => '<p>A list of <code>ConfigureShard</code> objects that can be used to configure each shard in a Redis OSS (cluster mode enabled) replication group. The <code>ConfigureShard</code> has three members: <code>NewReplicaCount</code>, <code>NodeGroupId</code>, and <code>PreferredAvailabilityZones</code>.</p>', ], ], 'ReplicationGroup' => [ 'base' => '<p>Contains all of the attributes of a specific Redis OSS replication group.</p>', 'refs' => [ 'CompleteMigrationResponse$ReplicationGroup' => NULL, 'CreateReplicationGroupResult$ReplicationGroup' => NULL, 'DecreaseReplicaCountResult$ReplicationGroup' => NULL, 'DeleteReplicationGroupResult$ReplicationGroup' => NULL, 'IncreaseReplicaCountResult$ReplicationGroup' => NULL, 'ModifyReplicationGroupResult$ReplicationGroup' => NULL, 'ModifyReplicationGroupShardConfigurationResult$ReplicationGroup' => NULL, 'ReplicationGroupList$member' => NULL, 'StartMigrationResponse$ReplicationGroup' => NULL, 'TestFailoverResult$ReplicationGroup' => NULL, 'TestMigrationResponse$ReplicationGroup' => NULL, ], ], 'ReplicationGroupAlreadyExistsFault' => [ 'base' => '<p>The specified replication group already exists.</p>', 'refs' => [], ], 'ReplicationGroupAlreadyUnderMigrationFault' => [ 'base' => '<p>The targeted replication group is not available. </p>', 'refs' => [], ], 'ReplicationGroupIdList' => [ 'base' => NULL, 'refs' => [ 'BatchApplyUpdateActionMessage$ReplicationGroupIds' => '<p>The replication group IDs</p>', 'BatchStopUpdateActionMessage$ReplicationGroupIds' => '<p>The replication group IDs</p>', 'DescribeUpdateActionsMessage$ReplicationGroupIds' => '<p>The replication group IDs</p>', ], ], 'ReplicationGroupList' => [ 'base' => NULL, 'refs' => [ 'ReplicationGroupMessage$ReplicationGroups' => '<p>A list of replication groups. Each item in the list contains detailed information about one replication group.</p>', ], ], 'ReplicationGroupMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeReplicationGroups</code> operation.</p>', 'refs' => [], ], 'ReplicationGroupNotFoundFault' => [ 'base' => '<p>The specified replication group does not exist.</p>', 'refs' => [], ], 'ReplicationGroupNotUnderMigrationFault' => [ 'base' => '<p>The designated replication group is not available for data migration.</p>', 'refs' => [], ], 'ReplicationGroupOutpostArnList' => [ 'base' => NULL, 'refs' => [ 'ReplicationGroup$MemberClustersOutpostArns' => '<p>The outpost ARNs of the replication group\'s member clusters.</p>', ], ], 'ReplicationGroupPendingModifiedValues' => [ 'base' => '<p>The settings to be applied to the Redis OSS replication group, either immediately or during the next maintenance window.</p>', 'refs' => [ 'ReplicationGroup$PendingModifiedValues' => '<p>A group of settings to be applied to the replication group, either immediately or during the next maintenance window.</p>', ], ], 'ReservedCacheNode' => [ 'base' => '<p>Represents the output of a <code>PurchaseReservedCacheNodesOffering</code> operation.</p>', 'refs' => [ 'PurchaseReservedCacheNodesOfferingResult$ReservedCacheNode' => NULL, 'ReservedCacheNodeList$member' => NULL, ], ], 'ReservedCacheNodeAlreadyExistsFault' => [ 'base' => '<p>You already have a reservation with the given identifier.</p>', 'refs' => [], ], 'ReservedCacheNodeList' => [ 'base' => NULL, 'refs' => [ 'ReservedCacheNodeMessage$ReservedCacheNodes' => '<p>A list of reserved cache nodes. Each element in the list contains detailed information about one node.</p>', ], ], 'ReservedCacheNodeMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeReservedCacheNodes</code> operation.</p>', 'refs' => [], ], 'ReservedCacheNodeNotFoundFault' => [ 'base' => '<p>The requested reserved cache node was not found.</p>', 'refs' => [], ], 'ReservedCacheNodeQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the user\'s cache node quota.</p>', 'refs' => [], ], 'ReservedCacheNodesOffering' => [ 'base' => '<p>Describes all of the attributes of a reserved cache node offering.</p>', 'refs' => [ 'ReservedCacheNodesOfferingList$member' => NULL, ], ], 'ReservedCacheNodesOfferingList' => [ 'base' => NULL, 'refs' => [ 'ReservedCacheNodesOfferingMessage$ReservedCacheNodesOfferings' => '<p>A list of reserved cache node offerings. Each element in the list contains detailed information about one offering.</p>', ], ], 'ReservedCacheNodesOfferingMessage' => [ 'base' => '<p>Represents the output of a <code>DescribeReservedCacheNodesOfferings</code> operation.</p>', 'refs' => [], ], 'ReservedCacheNodesOfferingNotFoundFault' => [ 'base' => '<p>The requested cache node offering does not exist.</p>', 'refs' => [], ], 'ResetCacheParameterGroupMessage' => [ 'base' => '<p>Represents the input of a <code>ResetCacheParameterGroup</code> operation.</p>', 'refs' => [], ], 'ReshardingConfiguration' => [ 'base' => '<p>A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node group in the resharded cluster.</p>', 'refs' => [ 'ReshardingConfigurationList$member' => NULL, ], ], 'ReshardingConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ModifyReplicationGroupShardConfigurationMessage$ReshardingConfiguration' => '<p>Specifies the preferred availability zones for each node group in the cluster. If the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards), you can use this parameter to specify the preferred availability zones of the cluster\'s shards. If you omit this parameter ElastiCache selects availability zones for you.</p> <p>You can specify this parameter only if the value of <code>NodeGroupCount</code> is greater than the current number of node groups (shards).</p>', 'RegionalConfiguration$ReshardingConfiguration' => '<p>A list of <code>PreferredAvailabilityZones</code> objects that specifies the configuration of a node group in the resharded cluster. </p>', ], ], 'ReshardingStatus' => [ 'base' => '<p>The status of an online resharding operation.</p>', 'refs' => [ 'ReplicationGroupPendingModifiedValues$Resharding' => '<p>The status of an online resharding operation.</p>', ], ], 'RevokeCacheSecurityGroupIngressMessage' => [ 'base' => '<p>Represents the input of a <code>RevokeCacheSecurityGroupIngress</code> operation.</p>', 'refs' => [], ], 'RevokeCacheSecurityGroupIngressResult' => [ 'base' => NULL, 'refs' => [], ], 'SecurityGroupIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateCacheClusterMessage$SecurityGroupIds' => '<p>One or more VPC security groups associated with the cluster.</p> <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p>', 'CreateReplicationGroupMessage$SecurityGroupIds' => '<p>One or more Amazon VPC security groups associated with this replication group.</p> <p>Use this parameter only when you are creating a replication group in an Amazon Virtual Private Cloud (Amazon VPC).</p>', 'CreateServerlessCacheRequest$SecurityGroupIds' => '<p>A list of the one or more VPC security groups to be associated with the serverless cache. The security group will authorize traffic access for the VPC end-point (private-link). If no other information is given this will be the VPC’s Default Security Group that is associated with the cluster VPC end-point.</p>', 'ModifyCacheClusterMessage$SecurityGroupIds' => '<p>Specifies the VPC Security Groups associated with the cluster.</p> <p>This parameter can be used only with clusters that are created in an Amazon Virtual Private Cloud (Amazon VPC).</p>', 'ModifyReplicationGroupMessage$SecurityGroupIds' => '<p>Specifies the VPC Security Groups associated with the clusters in the replication group.</p> <p>This parameter can be used only with replication group containing clusters running in an Amazon Virtual Private Cloud (Amazon VPC).</p>', 'ModifyServerlessCacheRequest$SecurityGroupIds' => '<p>The new list of VPC security groups to be associated with the serverless cache. Populating this list means the current VPC security groups will be removed. This security group is used to authorize traffic access for the VPC end-point (private-link). Default = NULL - the existing list of VPC security groups is not removed.</p>', 'ServerlessCache$SecurityGroupIds' => '<p>The IDs of the EC2 security groups associated with the serverless cache.</p>', ], ], 'SecurityGroupMembership' => [ 'base' => '<p>Represents a single cache security group and its status.</p>', 'refs' => [ 'SecurityGroupMembershipList$member' => NULL, ], ], 'SecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$SecurityGroups' => '<p>A list of VPC Security Groups associated with the cluster.</p>', ], ], 'ServerlessCache' => [ 'base' => '<p>The resource representing a serverless cache.</p>', 'refs' => [ 'CreateServerlessCacheResponse$ServerlessCache' => '<p>The response for the attempt to create the serverless cache.</p>', 'DeleteServerlessCacheResponse$ServerlessCache' => '<p>Provides the details of the specified serverless cache that is about to be deleted.</p>', 'ModifyServerlessCacheResponse$ServerlessCache' => '<p>The response for the attempt to modify the serverless cache.</p>', 'ServerlessCacheList$member' => NULL, ], ], 'ServerlessCacheAlreadyExistsFault' => [ 'base' => '<p>A serverless cache with this name already exists.</p>', 'refs' => [], ], 'ServerlessCacheConfiguration' => [ 'base' => '<p>The configuration settings for a specific serverless cache.</p>', 'refs' => [ 'ServerlessCacheSnapshot$ServerlessCacheConfiguration' => '<p>The configuration of the serverless cache, at the time the snapshot was taken. Available for Redis OSS and Serverless Memcached only.</p>', ], ], 'ServerlessCacheList' => [ 'base' => NULL, 'refs' => [ 'DescribeServerlessCachesResponse$ServerlessCaches' => '<p>The serverless caches associated with a given description request.</p>', ], ], 'ServerlessCacheNotFoundFault' => [ 'base' => '<p>The serverless cache was not found or does not exist.</p>', 'refs' => [], ], 'ServerlessCacheQuotaForCustomerExceededFault' => [ 'base' => '<p>The number of serverless caches exceeds the customer quota.</p>', 'refs' => [], ], 'ServerlessCacheSnapshot' => [ 'base' => '<p>The resource representing a serverless cache snapshot. Available for Redis OSS and Serverless Memcached only.</p>', 'refs' => [ 'CopyServerlessCacheSnapshotResponse$ServerlessCacheSnapshot' => '<p>The response for the attempt to copy the serverless cache snapshot. Available for Redis OSS and Serverless Memcached only.</p>', 'CreateServerlessCacheSnapshotResponse$ServerlessCacheSnapshot' => '<p>The state of a serverless cache snapshot at a specific point in time, to the millisecond. Available for Redis OSS and Serverless Memcached only.</p>', 'DeleteServerlessCacheSnapshotResponse$ServerlessCacheSnapshot' => '<p>The snapshot to be deleted. Available for Redis OSS and Serverless Memcached only.</p>', 'ExportServerlessCacheSnapshotResponse$ServerlessCacheSnapshot' => '<p>The state of a serverless cache at a specific point in time, to the millisecond. Available for Redis OSS and Serverless Memcached only.</p>', 'ServerlessCacheSnapshotList$member' => NULL, ], ], 'ServerlessCacheSnapshotAlreadyExistsFault' => [ 'base' => '<p>A serverless cache snapshot with this name already exists. Available for Redis OSS and Serverless Memcached only.</p>', 'refs' => [], ], 'ServerlessCacheSnapshotList' => [ 'base' => NULL, 'refs' => [ 'DescribeServerlessCacheSnapshotsResponse$ServerlessCacheSnapshots' => '<p>The serverless caches snapshots associated with a given description request. Available for Redis OSS and Serverless Memcached only.</p>', ], ], 'ServerlessCacheSnapshotNotFoundFault' => [ 'base' => '<p>This serverless cache snapshot could not be found or does not exist. Available for Redis OSS and Serverless Memcached only.</p>', 'refs' => [], ], 'ServerlessCacheSnapshotQuotaExceededFault' => [ 'base' => '<p>The number of serverless cache snapshots exceeds the customer snapshot quota. Available for Redis OSS and Serverless Memcached only.</p>', 'refs' => [], ], 'ServiceLinkedRoleNotFoundFault' => [ 'base' => '<p>The specified service linked role (SLR) was not found.</p>', 'refs' => [], ], 'ServiceUpdate' => [ 'base' => '<p>An update that you can apply to your Redis OSS clusters.</p>', 'refs' => [ 'ServiceUpdateList$member' => NULL, ], ], 'ServiceUpdateList' => [ 'base' => NULL, 'refs' => [ 'ServiceUpdatesMessage$ServiceUpdates' => '<p>A list of service updates</p>', ], ], 'ServiceUpdateNotFoundFault' => [ 'base' => '<p>The service update doesn\'t exist</p>', 'refs' => [], ], 'ServiceUpdateSeverity' => [ 'base' => NULL, 'refs' => [ 'ServiceUpdate$ServiceUpdateSeverity' => '<p>The severity of the service update</p>', 'UpdateAction$ServiceUpdateSeverity' => '<p>The severity of the service update</p>', ], ], 'ServiceUpdateStatus' => [ 'base' => NULL, 'refs' => [ 'ServiceUpdate$ServiceUpdateStatus' => '<p>The status of the service update</p>', 'ServiceUpdateStatusList$member' => NULL, 'UpdateAction$ServiceUpdateStatus' => '<p>The status of the service update</p>', ], ], 'ServiceUpdateStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeServiceUpdatesMessage$ServiceUpdateStatus' => '<p>The status of the service update</p>', 'DescribeUpdateActionsMessage$ServiceUpdateStatus' => '<p>The status of the service update</p>', ], ], 'ServiceUpdateType' => [ 'base' => NULL, 'refs' => [ 'ServiceUpdate$ServiceUpdateType' => '<p>Reflects the nature of the service update</p>', 'UpdateAction$ServiceUpdateType' => '<p>Reflects the nature of the service update </p>', ], ], 'ServiceUpdatesMessage' => [ 'base' => NULL, 'refs' => [], ], 'SlaMet' => [ 'base' => NULL, 'refs' => [ 'UpdateAction$SlaMet' => '<p>If yes, all nodes in the replication group have been updated by the recommended apply-by date. If no, at least one node in the replication group have not been updated by the recommended apply-by date. If N/A, the replication group was created after the recommended apply-by date.</p>', ], ], 'SlotMigration' => [ 'base' => '<p>Represents the progress of an online resharding operation.</p>', 'refs' => [ 'ReshardingStatus$SlotMigration' => '<p>Represents the progress of an online resharding operation.</p>', ], ], 'Snapshot' => [ 'base' => '<p>Represents a copy of an entire Redis OSS cluster as of the time when the snapshot was taken.</p>', 'refs' => [ 'CopySnapshotResult$Snapshot' => NULL, 'CreateSnapshotResult$Snapshot' => NULL, 'DeleteSnapshotResult$Snapshot' => NULL, 'SnapshotList$member' => NULL, ], ], 'SnapshotAlreadyExistsFault' => [ 'base' => '<p>You already have a snapshot with the given name.</p>', 'refs' => [], ], 'SnapshotArnsList' => [ 'base' => NULL, 'refs' => [ 'CreateCacheClusterMessage$SnapshotArns' => '<p>A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis OSS RDB snapshot file stored in Amazon S3. The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note> <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>', 'CreateReplicationGroupMessage$SnapshotArns' => '<p>A list of Amazon Resource Names (ARN) that uniquely identify the Redis OSS RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new replication group. The Amazon S3 object name in the ARN cannot contain any commas. The new replication group will have the number of node groups (console: shards) specified by the parameter <i>NumNodeGroups</i> or the number of node groups configured by <i>NodeGroupConfiguration</i> regardless of the number of ARNs specified here.</p> <p>Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code> </p>', 'CreateServerlessCacheRequest$SnapshotArnsToRestore' => '<p>The ARN(s) of the snapshot that the new serverless cache will be created from. Available for Redis OSS and Serverless Memcached only.</p>', ], ], 'SnapshotFeatureNotSupportedFault' => [ 'base' => '<p>You attempted one of the following operations:</p> <ul> <li> <p>Creating a snapshot of a Redis OSS cluster running on a <code>cache.t1.micro</code> cache node.</p> </li> <li> <p>Creating a snapshot of a cluster that is running Memcached rather than Redis OSS.</p> </li> </ul> <p>Neither of these are supported by ElastiCache.</p>', 'refs' => [], ], 'SnapshotList' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotsListMessage$Snapshots' => '<p>A list of snapshots. Each item in the list contains detailed information about one snapshot.</p>', ], ], 'SnapshotNotFoundFault' => [ 'base' => '<p>The requested snapshot name does not refer to an existing snapshot.</p>', 'refs' => [], ], 'SnapshotQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the maximum number of snapshots.</p>', 'refs' => [], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsMessage$SourceType' => '<p>The event source to retrieve events for. If no value is specified, all events are returned.</p>', 'Event$SourceType' => '<p>Specifies the origin of this event - a cluster, a parameter group, a security group, etc.</p>', ], ], 'StartMigrationMessage' => [ 'base' => NULL, 'refs' => [], ], 'StartMigrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceMessage$ResourceName' => '<p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>. ElastiCache resources are <i>cluster</i> and <i>snapshot</i>.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>', 'AuthorizeCacheSecurityGroupIngressMessage$CacheSecurityGroupName' => '<p>The cache security group that allows network ingress.</p>', 'AuthorizeCacheSecurityGroupIngressMessage$EC2SecurityGroupName' => '<p>The Amazon EC2 security group to be authorized for ingress to the cache security group.</p>', 'AuthorizeCacheSecurityGroupIngressMessage$EC2SecurityGroupOwnerId' => '<p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>', 'AvailabilityZone$Name' => '<p>The name of the Availability Zone.</p>', 'AvailabilityZonesList$member' => NULL, 'BatchApplyUpdateActionMessage$ServiceUpdateName' => '<p>The unique ID of the service update</p>', 'BatchStopUpdateActionMessage$ServiceUpdateName' => '<p>The unique ID of the service update</p>', 'CacheCluster$CacheClusterId' => '<p>The user-supplied identifier of the cluster. This identifier is a unique key that identifies a cluster.</p>', 'CacheCluster$ClientDownloadLandingPage' => '<p>The URL of the web page where you can download the latest ElastiCache client library.</p>', 'CacheCluster$CacheNodeType' => '<p>The name of the compute and memory capacity node type for the cluster.</p> <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: </p> <p> <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>, <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>, <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized:</p> <ul> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li> </ul> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: </p> <p> <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>, <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>, <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Additional node type info</b> </p> <ul> <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li> <li> <p>Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.</p> </li> <li> <p>Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.</p> </li> <li> <p>Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis OSS version 2.8.22 and later.</p> </li> </ul>', 'CacheCluster$Engine' => '<p>The name of the cache engine (<code>memcached</code> or <code>redis</code>) to be used for this cluster.</p>', 'CacheCluster$EngineVersion' => '<p>The version of the cache engine that is used in this cluster.</p>', 'CacheCluster$CacheClusterStatus' => '<p>The current state of this cluster, one of the following values: <code>available</code>, <code>creating</code>, <code>deleted</code>, <code>deleting</code>, <code>incompatible-network</code>, <code>modifying</code>, <code>rebooting cluster nodes</code>, <code>restore-failed</code>, or <code>snapshotting</code>.</p>', 'CacheCluster$PreferredAvailabilityZone' => '<p>The name of the Availability Zone in which the cluster is located or "Multiple" if the cache nodes are located in different Availability Zones.</p>', 'CacheCluster$PreferredOutpostArn' => '<p>The outpost ARN in which the cache cluster is created.</p>', 'CacheCluster$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'CacheCluster$CacheSubnetGroupName' => '<p>The name of the cache subnet group associated with the cluster.</p>', 'CacheCluster$ReplicationGroupId' => '<p>The replication group to which this cluster belongs. If this field is empty, the cluster is not associated with any replication group.</p>', 'CacheCluster$SnapshotWindow' => '<p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster.</p> <p>Example: <code>05:00-09:00</code> </p>', 'CacheCluster$ARN' => '<p>The ARN (Amazon Resource Name) of the cache cluster.</p>', 'CacheClusterIdList$member' => NULL, 'CacheClusterMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'CacheEngineVersion$Engine' => '<p>The name of the cache engine.</p>', 'CacheEngineVersion$EngineVersion' => '<p>The version number of the cache engine.</p>', 'CacheEngineVersion$CacheParameterGroupFamily' => '<p>The name of the cache parameter group family associated with this cache engine.</p> <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis7</code> </p>', 'CacheEngineVersion$CacheEngineDescription' => '<p>The description of the cache engine.</p>', 'CacheEngineVersion$CacheEngineVersionDescription' => '<p>The description of the cache engine version.</p>', 'CacheEngineVersionMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'CacheNode$CacheNodeId' => '<p>The cache node identifier. A node ID is a numeric identifier (0001, 0002, etc.). The combination of cluster ID and node ID uniquely identifies every cache node used in a customer\'s Amazon account.</p>', 'CacheNode$CacheNodeStatus' => '<p>The current state of this cache node, one of the following values: <code>available</code>, <code>creating</code>, <code>rebooting</code>, or <code>deleting</code>.</p>', 'CacheNode$ParameterGroupStatus' => '<p>The status of the parameter group applied to this cache node.</p>', 'CacheNode$SourceCacheNodeId' => '<p>The ID of the primary node to which this read replica node is synchronized. If this field is empty, this node is not associated with a primary cluster.</p>', 'CacheNode$CustomerAvailabilityZone' => '<p>The Availability Zone where this node was created and now resides.</p>', 'CacheNode$CustomerOutpostArn' => '<p>The customer outpost ARN of the cache node.</p>', 'CacheNodeIdsList$member' => NULL, 'CacheNodeTypeSpecificParameter$ParameterName' => '<p>The name of the parameter.</p>', 'CacheNodeTypeSpecificParameter$Description' => '<p>A description of the parameter.</p>', 'CacheNodeTypeSpecificParameter$Source' => '<p>The source of the parameter value.</p>', 'CacheNodeTypeSpecificParameter$DataType' => '<p>The valid data type for the parameter.</p>', 'CacheNodeTypeSpecificParameter$AllowedValues' => '<p>The valid range of values for the parameter.</p>', 'CacheNodeTypeSpecificParameter$MinimumEngineVersion' => '<p>The earliest cache engine version to which the parameter can apply.</p>', 'CacheNodeTypeSpecificValue$CacheNodeType' => '<p>The cache node type for which this value applies.</p>', 'CacheNodeTypeSpecificValue$Value' => '<p>The value for the cache node type.</p>', 'CacheNodeUpdateStatus$CacheNodeId' => '<p>The node ID of the cache cluster</p>', 'CacheParameterGroup$CacheParameterGroupName' => '<p>The name of the cache parameter group.</p>', 'CacheParameterGroup$CacheParameterGroupFamily' => '<p>The name of the cache parameter group family that this cache parameter group is compatible with.</p> <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis7</code> </p>', 'CacheParameterGroup$Description' => '<p>The description for this cache parameter group.</p>', 'CacheParameterGroup$ARN' => '<p>The ARN (Amazon Resource Name) of the cache parameter group.</p>', 'CacheParameterGroupDetails$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'CacheParameterGroupNameMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group.</p>', 'CacheParameterGroupStatus$CacheParameterGroupName' => '<p>The name of the cache parameter group.</p>', 'CacheParameterGroupStatus$ParameterApplyStatus' => '<p>The status of parameter updates.</p>', 'CacheParameterGroupsMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'CacheSecurityGroup$OwnerId' => '<p>The Amazon account ID of the cache security group owner.</p>', 'CacheSecurityGroup$CacheSecurityGroupName' => '<p>The name of the cache security group.</p>', 'CacheSecurityGroup$Description' => '<p>The description of the cache security group.</p>', 'CacheSecurityGroup$ARN' => '<p>The ARN of the cache security group,</p>', 'CacheSecurityGroupMembership$CacheSecurityGroupName' => '<p>The name of the cache security group.</p>', 'CacheSecurityGroupMembership$Status' => '<p>The membership status in the cache security group. The status changes when a cache security group is modified, or when the cache security groups assigned to a cluster are modified.</p>', 'CacheSecurityGroupMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'CacheSecurityGroupNameList$member' => NULL, 'CacheSubnetGroup$CacheSubnetGroupName' => '<p>The name of the cache subnet group.</p>', 'CacheSubnetGroup$CacheSubnetGroupDescription' => '<p>The description of the cache subnet group.</p>', 'CacheSubnetGroup$VpcId' => '<p>The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group.</p>', 'CacheSubnetGroup$ARN' => '<p>The ARN (Amazon Resource Name) of the cache subnet group.</p>', 'CacheSubnetGroupMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'CloudWatchLogsDestinationDetails$LogGroup' => '<p>The name of the CloudWatch Logs log group.</p>', 'ClusterIdList$member' => NULL, 'CompleteMigrationMessage$ReplicationGroupId' => '<p>The ID of the replication group to which data is being migrated.</p>', 'CopyServerlessCacheSnapshotRequest$SourceServerlessCacheSnapshotName' => '<p>The identifier of the existing serverless cache’s snapshot to be copied. Available for Redis OSS and Serverless Memcached only.</p>', 'CopyServerlessCacheSnapshotRequest$TargetServerlessCacheSnapshotName' => '<p>The identifier for the snapshot to be created. Available for Redis OSS and Serverless Memcached only.</p>', 'CopyServerlessCacheSnapshotRequest$KmsKeyId' => '<p>The identifier of the KMS key used to encrypt the target snapshot. Available for Redis OSS and Serverless Memcached only.</p>', 'CopySnapshotMessage$SourceSnapshotName' => '<p>The name of an existing snapshot from which to make a copy.</p>', 'CopySnapshotMessage$TargetSnapshotName' => '<p>A name for the snapshot copy. ElastiCache does not permit overwriting a snapshot, therefore this name must be unique within its context - ElastiCache or an Amazon S3 bucket if exporting.</p>', 'CopySnapshotMessage$TargetBucket' => '<p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access.</p> <p>When using this parameter to export a snapshot, be sure Amazon ElastiCache has the needed permissions to this S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html#backups-exporting-grant-access">Step 2: Grant ElastiCache Access to Your Amazon S3 Bucket</a> in the <i>Amazon ElastiCache User Guide</i>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/backups-exporting.html">Exporting a Snapshot</a> in the <i>Amazon ElastiCache User Guide</i>.</p>', 'CopySnapshotMessage$KmsKeyId' => '<p>The ID of the KMS key used to encrypt the target snapshot.</p>', 'CreateCacheClusterMessage$CacheClusterId' => '<p>The node group (shard) identifier. This parameter is stored as a lowercase string.</p> <p> <b>Constraints:</b> </p> <ul> <li> <p>A name must contain from 1 to 50 alphanumeric characters or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'CreateCacheClusterMessage$ReplicationGroupId' => '<p>The ID of the replication group to which this cluster should belong. If this parameter is specified, the cluster is added to the specified replication group as a read replica; otherwise, the cluster is a standalone primary that is not part of any replication group.</p> <p>If the specified replication group is Multi-AZ enabled and the Availability Zone is not specified, the cluster is created in Availability Zones that provide the best spread of read replicas across Availability Zones.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note>', 'CreateCacheClusterMessage$PreferredAvailabilityZone' => '<p>The EC2 Availability Zone in which the cluster is created.</p> <p>All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code>.</p> <p>Default: System chosen Availability Zone.</p>', 'CreateCacheClusterMessage$CacheNodeType' => '<p>The compute and memory capacity of the nodes in the node group (shard).</p> <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: </p> <p> <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>, <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>, <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized:</p> <ul> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li> </ul> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: </p> <p> <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>, <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>, <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Additional node type info</b> </p> <ul> <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li> <li> <p>Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.</p> </li> <li> <p>Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.</p> </li> <li> <p>Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis OSS version 2.8.22 and later.</p> </li> </ul>', 'CreateCacheClusterMessage$Engine' => '<p>The name of the cache engine to be used for this cluster.</p> <p>Valid values for this parameter are: <code>memcached</code> | <code>redis</code> </p>', 'CreateCacheClusterMessage$EngineVersion' => '<p>The version number of the cache engine to be used for this cluster. To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.</p> <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>', 'CreateCacheClusterMessage$CacheParameterGroupName' => '<p>The name of the parameter group to associate with this cluster. If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has <code>cluster-enabled=\'yes\'</code> when creating a cluster.</p>', 'CreateCacheClusterMessage$CacheSubnetGroupName' => '<p>The name of the subnet group to be used for the cluster.</p> <p>Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).</p> <important> <p>If you\'re going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p> </important>', 'CreateCacheClusterMessage$SnapshotName' => '<p>The name of a Redis OSS snapshot from which to restore data into the new node group (shard). The snapshot status changes to <code>restoring</code> while the new node group (shard) is being created.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note>', 'CreateCacheClusterMessage$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. </p>', 'CreateCacheClusterMessage$NotificationTopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note> <p>The Amazon SNS topic owner must be the same as the cluster owner.</p> </note>', 'CreateCacheClusterMessage$SnapshotWindow' => '<p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p> <p>Example: <code>05:00-09:00</code> </p> <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note>', 'CreateCacheClusterMessage$AuthToken' => '<p> <b>Reserved parameter.</b> The password used to access a password protected server.</p> <p>Password constraints:</p> <ul> <li> <p>Must be only printable ASCII characters.</p> </li> <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li> <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li> </ul> <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>', 'CreateCacheClusterMessage$PreferredOutpostArn' => '<p>The outpost ARN in which the cache cluster is created.</p>', 'CreateCacheParameterGroupMessage$CacheParameterGroupName' => '<p>A user-specified name for the cache parameter group.</p>', 'CreateCacheParameterGroupMessage$CacheParameterGroupFamily' => '<p>The name of the cache parameter group family that the cache parameter group can be used with.</p> <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis7</code> </p>', 'CreateCacheParameterGroupMessage$Description' => '<p>A user-specified description for the cache parameter group.</p>', 'CreateCacheSecurityGroupMessage$CacheSecurityGroupName' => '<p>A name for the cache security group. This value is stored as a lowercase string.</p> <p>Constraints: Must contain no more than 255 alphanumeric characters. Cannot be the word "Default".</p> <p>Example: <code>mysecuritygroup</code> </p>', 'CreateCacheSecurityGroupMessage$Description' => '<p>A description for the cache security group.</p>', 'CreateCacheSubnetGroupMessage$CacheSubnetGroupName' => '<p>A name for the cache subnet group. This value is stored as a lowercase string.</p> <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p> <p>Example: <code>mysubnetgroup</code> </p>', 'CreateCacheSubnetGroupMessage$CacheSubnetGroupDescription' => '<p>A description for the cache subnet group.</p>', 'CreateGlobalReplicationGroupMessage$GlobalReplicationGroupIdSuffix' => '<p>The suffix name of a Global datastore. Amazon ElastiCache automatically applies a prefix to the Global datastore ID when it is created. Each Amazon Region has its own prefix. For instance, a Global datastore ID created in the US-West-1 region will begin with "dsdfu" along with the suffix name you provide. The suffix, combined with the auto-generated prefix, guarantees uniqueness of the Global datastore name across multiple regions. </p> <p>For a full list of Amazon Regions and their respective Global datastore iD prefixes, see <a href="http://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/Redis-Global-Datastores-CLI.html">Using the Amazon CLI with Global datastores </a>.</p>', 'CreateGlobalReplicationGroupMessage$GlobalReplicationGroupDescription' => '<p>Provides details of the Global datastore</p>', 'CreateGlobalReplicationGroupMessage$PrimaryReplicationGroupId' => '<p>The name of the primary cluster that accepts writes and will replicate updates to the secondary cluster.</p>', 'CreateReplicationGroupMessage$ReplicationGroupId' => '<p>The replication group identifier. This parameter is stored as a lowercase string.</p> <p>Constraints:</p> <ul> <li> <p>A name must contain from 1 to 40 alphanumeric characters or hyphens.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>A name cannot end with a hyphen or contain two consecutive hyphens.</p> </li> </ul>', 'CreateReplicationGroupMessage$ReplicationGroupDescription' => '<p>A user-created description for the replication group.</p>', 'CreateReplicationGroupMessage$GlobalReplicationGroupId' => '<p>The name of the Global datastore</p>', 'CreateReplicationGroupMessage$PrimaryClusterId' => '<p>The identifier of the cluster that serves as the primary for this replication group. This cluster must already exist and have a status of <code>available</code>.</p> <p>This parameter is not required if <code>NumCacheClusters</code>, <code>NumNodeGroups</code>, or <code>ReplicasPerNodeGroup</code> is specified.</p>', 'CreateReplicationGroupMessage$CacheNodeType' => '<p>The compute and memory capacity of the nodes in the node group (shard).</p> <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: </p> <p> <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>, <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>, <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized:</p> <ul> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li> </ul> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: </p> <p> <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>, <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>, <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Additional node type info</b> </p> <ul> <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li> <li> <p>Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.</p> </li> <li> <p>Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.</p> </li> <li> <p>Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis OSS version 2.8.22 and later.</p> </li> </ul>', 'CreateReplicationGroupMessage$Engine' => '<p>The name of the cache engine to be used for the clusters in this replication group. The value must be set to <code>Redis</code>.</p>', 'CreateReplicationGroupMessage$EngineVersion' => '<p>The version number of the cache engine to be used for the clusters in this replication group. To view the supported cache engine versions, use the <code>DescribeCacheEngineVersions</code> operation.</p> <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>) in the <i>ElastiCache User Guide</i>, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version. </p>', 'CreateReplicationGroupMessage$CacheParameterGroupName' => '<p>The name of the parameter group to associate with this replication group. If this argument is omitted, the default cache parameter group for the specified engine is used.</p> <p>If you are running Redis OSS version 3.2.4 or later, only one node group (shard), and want to use a default parameter group, we recommend that you specify the parameter group by name. </p> <ul> <li> <p>To create a Redis OSS (cluster mode disabled) replication group, use <code>CacheParameterGroupName=default.redis3.2</code>.</p> </li> <li> <p>To create a Redis OSS (cluster mode enabled) replication group, use <code>CacheParameterGroupName=default.redis3.2.cluster.on</code>.</p> </li> </ul>', 'CreateReplicationGroupMessage$CacheSubnetGroupName' => '<p>The name of the cache subnet group to be used for the replication group.</p> <important> <p>If you\'re going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SubnetGroups.html">Subnets and Subnet Groups</a>.</p> </important>', 'CreateReplicationGroupMessage$SnapshotName' => '<p>The name of a snapshot from which to restore data into the new replication group. The snapshot status changes to <code>restoring</code> while the new replication group is being created.</p>', 'CreateReplicationGroupMessage$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'CreateReplicationGroupMessage$NotificationTopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p> <note> <p>The Amazon SNS topic owner must be the same as the cluster owner.</p> </note>', 'CreateReplicationGroupMessage$SnapshotWindow' => '<p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p> <p>Example: <code>05:00-09:00</code> </p> <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>', 'CreateReplicationGroupMessage$AuthToken' => '<p> <b>Reserved parameter.</b> The password used to access a password protected server.</p> <p> <code>AuthToken</code> can be specified only on replication groups where <code>TransitEncryptionEnabled</code> is <code>true</code>.</p> <important> <p>For HIPAA compliance, you must specify <code>TransitEncryptionEnabled</code> as <code>true</code>, an <code>AuthToken</code>, and a <code>CacheSubnetGroup</code>.</p> </important> <p>Password constraints:</p> <ul> <li> <p>Must be only printable ASCII characters.</p> </li> <li> <p>Must be at least 16 characters and no more than 128 characters in length.</p> </li> <li> <p>The only permitted printable special characters are !, &amp;, #, $, ^, &lt;, &gt;, and -. Other printable special characters cannot be used in the AUTH token.</p> </li> </ul> <p>For more information, see <a href="http://redis.io/commands/AUTH">AUTH password</a> at http://redis.io/commands/AUTH.</p>', 'CreateReplicationGroupMessage$KmsKeyId' => '<p>The ID of the KMS key used to encrypt the disk in the cluster.</p>', 'CreateReplicationGroupMessage$ServerlessCacheSnapshotName' => '<p>The name of the snapshot used to create a replication group. Available for Redis OSS only.</p>', 'CreateServerlessCacheRequest$ServerlessCacheName' => '<p>User-provided identifier for the serverless cache. This parameter is stored as a lowercase string.</p>', 'CreateServerlessCacheRequest$Description' => '<p>User-provided description for the serverless cache. The default is NULL, i.e. if no description is provided then an empty string will be returned. The maximum length is 255 characters. </p>', 'CreateServerlessCacheRequest$Engine' => '<p>The name of the cache engine to be used for creating the serverless cache.</p>', 'CreateServerlessCacheRequest$MajorEngineVersion' => '<p>The version of the cache engine that will be used to create the serverless cache.</p>', 'CreateServerlessCacheRequest$KmsKeyId' => '<p>ARN of the customer managed key for encrypting the data at rest. If no KMS key is provided, a default service key is used.</p>', 'CreateServerlessCacheRequest$UserGroupId' => '<p>The identifier of the UserGroup to be associated with the serverless cache. Available for Redis OSS only. Default is NULL.</p>', 'CreateServerlessCacheRequest$DailySnapshotTime' => '<p>The daily time that snapshots will be created from the new serverless cache. By default this number is populated with 0, i.e. no snapshots will be created on an automatic daily basis. Available for Redis OSS and Serverless Memcached only.</p>', 'CreateServerlessCacheSnapshotRequest$ServerlessCacheSnapshotName' => '<p>The name for the snapshot being created. Must be unique for the customer account. Available for Redis OSS and Serverless Memcached only. Must be between 1 and 255 characters.</p>', 'CreateServerlessCacheSnapshotRequest$ServerlessCacheName' => '<p>The name of an existing serverless cache. The snapshot is created from this cache. Available for Redis OSS and Serverless Memcached only.</p>', 'CreateServerlessCacheSnapshotRequest$KmsKeyId' => '<p>The ID of the KMS key used to encrypt the snapshot. Available for Redis OSS and Serverless Memcached only. Default: NULL</p>', 'CreateSnapshotMessage$ReplicationGroupId' => '<p>The identifier of an existing replication group. The snapshot is created from this replication group.</p>', 'CreateSnapshotMessage$CacheClusterId' => '<p>The identifier of an existing cluster. The snapshot is created from this cluster.</p>', 'CreateSnapshotMessage$SnapshotName' => '<p>A name for the snapshot being created.</p>', 'CreateSnapshotMessage$KmsKeyId' => '<p>The ID of the KMS key used to encrypt the snapshot.</p>', 'CreateUserGroupMessage$UserGroupId' => '<p>The ID of the user group.</p>', 'CustomerNodeEndpoint$Address' => '<p>The address of the node endpoint</p>', 'DecreaseNodeGroupsInGlobalReplicationGroupMessage$GlobalReplicationGroupId' => '<p>The name of the Global datastore</p>', 'DecreaseReplicaCountMessage$ReplicationGroupId' => '<p>The id of the replication group from which you want to remove replica nodes.</p>', 'DeleteCacheClusterMessage$CacheClusterId' => '<p>The cluster identifier for the cluster to be deleted. This parameter is not case sensitive.</p>', 'DeleteCacheClusterMessage$FinalSnapshotIdentifier' => '<p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. ElastiCache creates the snapshot, and then deletes the cluster immediately afterward.</p>', 'DeleteCacheParameterGroupMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group to delete.</p> <note> <p>The specified cache security group must not be associated with any clusters.</p> </note>', 'DeleteCacheSecurityGroupMessage$CacheSecurityGroupName' => '<p>The name of the cache security group to delete.</p> <note> <p>You cannot delete the default security group.</p> </note>', 'DeleteCacheSubnetGroupMessage$CacheSubnetGroupName' => '<p>The name of the cache subnet group to delete.</p> <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p>', 'DeleteGlobalReplicationGroupMessage$GlobalReplicationGroupId' => '<p>The name of the Global datastore</p>', 'DeleteReplicationGroupMessage$ReplicationGroupId' => '<p>The identifier for the cluster to be deleted. This parameter is not case sensitive.</p>', 'DeleteReplicationGroupMessage$FinalSnapshotIdentifier' => '<p>The name of a final node group (shard) snapshot. ElastiCache creates the snapshot from the primary node in the cluster, rather than one of the replicas; this is to ensure that it captures the freshest data. After the final snapshot is taken, the replication group is immediately deleted.</p>', 'DeleteServerlessCacheRequest$ServerlessCacheName' => '<p>The identifier of the serverless cache to be deleted.</p>', 'DeleteServerlessCacheRequest$FinalSnapshotName' => '<p>Name of the final snapshot to be taken before the serverless cache is deleted. Available for Redis OSS and Serverless Memcached only. Default: NULL, i.e. a final snapshot is not taken.</p>', 'DeleteServerlessCacheSnapshotRequest$ServerlessCacheSnapshotName' => '<p>Idenfitier of the snapshot to be deleted. Available for Redis OSS and Serverless Memcached only.</p>', 'DeleteSnapshotMessage$SnapshotName' => '<p>The name of the snapshot to be deleted.</p>', 'DeleteUserGroupMessage$UserGroupId' => '<p>The ID of the user group.</p>', 'DescribeCacheClustersMessage$CacheClusterId' => '<p>The user-supplied cluster identifier. If this parameter is specified, only information about that specific cluster is returned. This parameter isn\'t case sensitive.</p>', 'DescribeCacheClustersMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeCacheEngineVersionsMessage$Engine' => '<p>The cache engine to return. Valid values: <code>memcached</code> | <code>redis</code> </p>', 'DescribeCacheEngineVersionsMessage$EngineVersion' => '<p>The cache engine version to return.</p> <p>Example: <code>1.4.14</code> </p>', 'DescribeCacheEngineVersionsMessage$CacheParameterGroupFamily' => '<p>The name of a specific cache parameter group family to return details for.</p> <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> | <code>redis7</code> </p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 255 alphanumeric characters</p> </li> <li> <p>First character must be a letter</p> </li> <li> <p>Cannot end with a hyphen or contain two consecutive hyphens</p> </li> </ul>', 'DescribeCacheEngineVersionsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeCacheParameterGroupsMessage$CacheParameterGroupName' => '<p>The name of a specific cache parameter group to return details for.</p>', 'DescribeCacheParameterGroupsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeCacheParametersMessage$CacheParameterGroupName' => '<p>The name of a specific cache parameter group to return details for.</p>', 'DescribeCacheParametersMessage$Source' => '<p>The parameter types to return.</p> <p>Valid values: <code>user</code> | <code>system</code> | <code>engine-default</code> </p>', 'DescribeCacheParametersMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeCacheSecurityGroupsMessage$CacheSecurityGroupName' => '<p>The name of the cache security group to return details for.</p>', 'DescribeCacheSecurityGroupsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeCacheSubnetGroupsMessage$CacheSubnetGroupName' => '<p>The name of the cache subnet group to return details for.</p>', 'DescribeCacheSubnetGroupsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEngineDefaultParametersMessage$CacheParameterGroupFamily' => '<p>The name of the cache parameter group family.</p> <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.x</code> | <code>redis6.2</code> | <code>redis7</code> </p>', 'DescribeEngineDefaultParametersMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeEventsMessage$SourceIdentifier' => '<p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>', 'DescribeEventsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeGlobalReplicationGroupsMessage$GlobalReplicationGroupId' => '<p>The name of the Global datastore</p>', 'DescribeGlobalReplicationGroupsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>. </p>', 'DescribeGlobalReplicationGroupsResult$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>', 'DescribeReplicationGroupsMessage$ReplicationGroupId' => '<p>The identifier for the replication group to be described. This parameter is not case sensitive.</p> <p>If you do not specify this parameter, information about all replication groups is returned.</p>', 'DescribeReplicationGroupsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeReservedCacheNodesMessage$ReservedCacheNodeId' => '<p>The reserved cache node identifier filter value. Use this parameter to show only the reservation that matches the specified reservation ID.</p>', 'DescribeReservedCacheNodesMessage$ReservedCacheNodesOfferingId' => '<p>The offering identifier filter value. Use this parameter to show only purchased reservations matching the specified offering identifier.</p>', 'DescribeReservedCacheNodesMessage$CacheNodeType' => '<p>The cache node type filter value. Use this parameter to show only those reservations matching the specified cache node type.</p> <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: </p> <p> <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>, <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>, <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized:</p> <ul> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li> </ul> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: </p> <p> <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>, <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>, <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Additional node type info</b> </p> <ul> <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li> <li> <p>Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.</p> </li> <li> <p>Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.</p> </li> <li> <p>Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis OSS version 2.8.22 and later.</p> </li> </ul>', 'DescribeReservedCacheNodesMessage$Duration' => '<p>The duration filter value, specified in years or seconds. Use this parameter to show only reservations for this duration.</p> <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>', 'DescribeReservedCacheNodesMessage$ProductDescription' => '<p>The product description filter value. Use this parameter to show only those reservations matching the specified product description.</p>', 'DescribeReservedCacheNodesMessage$OfferingType' => '<p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p> <p>Valid values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization"|"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>', 'DescribeReservedCacheNodesMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeReservedCacheNodesOfferingsMessage$ReservedCacheNodesOfferingId' => '<p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p> <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>', 'DescribeReservedCacheNodesOfferingsMessage$CacheNodeType' => '<p>The cache node type filter value. Use this parameter to show only the available offerings matching the specified cache node type.</p> <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: </p> <p> <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>, <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>, <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized:</p> <ul> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li> </ul> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: </p> <p> <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>, <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>, <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Additional node type info</b> </p> <ul> <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li> <li> <p>Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.</p> </li> <li> <p>Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.</p> </li> <li> <p>Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis OSS version 2.8.22 and later.</p> </li> </ul>', 'DescribeReservedCacheNodesOfferingsMessage$Duration' => '<p>Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a given duration.</p> <p>Valid Values: <code>1 | 3 | 31536000 | 94608000</code> </p>', 'DescribeReservedCacheNodesOfferingsMessage$ProductDescription' => '<p>The product description filter value. Use this parameter to show only the available offerings matching the specified product description.</p>', 'DescribeReservedCacheNodesOfferingsMessage$OfferingType' => '<p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type.</p> <p>Valid Values: <code>"Light Utilization"|"Medium Utilization"|"Heavy Utilization" |"All Upfront"|"Partial Upfront"| "No Upfront"</code> </p>', 'DescribeReservedCacheNodesOfferingsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeServerlessCacheSnapshotsRequest$ServerlessCacheName' => '<p>The identifier of serverless cache. If this parameter is specified, only snapshots associated with that specific serverless cache are described. Available for Redis OSS and Serverless Memcached only.</p>', 'DescribeServerlessCacheSnapshotsRequest$ServerlessCacheSnapshotName' => '<p>The identifier of the serverless cache’s snapshot. If this parameter is specified, only this snapshot is described. Available for Redis OSS and Serverless Memcached only.</p>', 'DescribeServerlessCacheSnapshotsRequest$SnapshotType' => '<p>The type of snapshot that is being described. Available for Redis OSS and Serverless Memcached only.</p>', 'DescribeServerlessCacheSnapshotsRequest$NextToken' => '<p>An optional marker returned from a prior request to support pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by max-results. Available for Redis OSS and Serverless Memcached only.</p>', 'DescribeServerlessCacheSnapshotsResponse$NextToken' => '<p>An optional marker returned from a prior request to support pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by max-results. Available for Redis OSS and Serverless Memcached only.</p>', 'DescribeServerlessCachesRequest$ServerlessCacheName' => '<p>The identifier for the serverless cache. If this parameter is specified, only information about that specific serverless cache is returned. Default: NULL</p>', 'DescribeServerlessCachesRequest$NextToken' => '<p>An optional marker returned from a prior request to support pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxResults.</p>', 'DescribeServerlessCachesResponse$NextToken' => '<p>An optional marker returned from a prior request to support pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxResults.</p>', 'DescribeServiceUpdatesMessage$ServiceUpdateName' => '<p>The unique ID of the service update</p>', 'DescribeServiceUpdatesMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeSnapshotsListMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeSnapshotsMessage$ReplicationGroupId' => '<p>A user-supplied replication group identifier. If this parameter is specified, only snapshots associated with that specific replication group are described.</p>', 'DescribeSnapshotsMessage$CacheClusterId' => '<p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>', 'DescribeSnapshotsMessage$SnapshotName' => '<p>A user-supplied name of the snapshot. If this parameter is specified, only this snapshot are described.</p>', 'DescribeSnapshotsMessage$SnapshotSource' => '<p>If set to <code>system</code>, the output shows snapshots that were automatically created by ElastiCache. If set to <code>user</code> the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>', 'DescribeSnapshotsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeUpdateActionsMessage$ServiceUpdateName' => '<p>The unique ID of the service update</p>', 'DescribeUpdateActionsMessage$Engine' => '<p>The Elasticache engine to which the update applies. Either Redis OSS or Memcached.</p>', 'DescribeUpdateActionsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'DescribeUserGroupsMessage$UserGroupId' => '<p>The ID of the user group.</p>', 'DescribeUserGroupsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>', 'DescribeUserGroupsResult$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.&gt;</p>', 'DescribeUsersMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>', 'DescribeUsersResult$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords. &gt;</p>', 'DisassociateGlobalReplicationGroupMessage$GlobalReplicationGroupId' => '<p>The name of the Global datastore</p>', 'DisassociateGlobalReplicationGroupMessage$ReplicationGroupId' => '<p>The name of the secondary cluster you wish to remove from the Global datastore</p>', 'DisassociateGlobalReplicationGroupMessage$ReplicationGroupRegion' => '<p>The Amazon region of secondary cluster you wish to remove from the Global datastore</p>', 'EC2SecurityGroup$Status' => '<p>The status of the Amazon EC2 security group.</p>', 'EC2SecurityGroup$EC2SecurityGroupName' => '<p>The name of the Amazon EC2 security group.</p>', 'EC2SecurityGroup$EC2SecurityGroupOwnerId' => '<p>The Amazon account ID of the Amazon EC2 security group owner.</p>', 'Endpoint$Address' => '<p>The DNS hostname of the cache node.</p>', 'EngineDefaults$CacheParameterGroupFamily' => '<p>Specifies the name of the cache parameter group family to which the engine default parameters apply.</p> <p>Valid values are: <code>memcached1.4</code> | <code>memcached1.5</code> | <code>memcached1.6</code> | <code>redis2.6</code> | <code>redis2.8</code> | <code>redis3.2</code> | <code>redis4.0</code> | <code>redis5.0</code> | <code>redis6.0</code> | <code>redis6.x</code> | <code>redis7</code> </p>', 'EngineDefaults$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'Event$SourceIdentifier' => '<p>The identifier for the source of the event. For example, if the event occurred at the cluster level, the identifier would be the name of the cluster.</p>', 'Event$Message' => '<p>The text of the event.</p>', 'EventsMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'ExportServerlessCacheSnapshotRequest$ServerlessCacheSnapshotName' => '<p>The identifier of the serverless cache snapshot to be exported to S3. Available for Redis OSS only.</p>', 'ExportServerlessCacheSnapshotRequest$S3BucketName' => '<p>Name of the Amazon S3 bucket to export the snapshot to. The Amazon S3 bucket must also be in same region as the snapshot. Available for Redis OSS only.</p>', 'FailoverGlobalReplicationGroupMessage$GlobalReplicationGroupId' => '<p>The name of the Global datastore</p>', 'FailoverGlobalReplicationGroupMessage$PrimaryRegion' => '<p>The Amazon region of the primary cluster of the Global datastore</p>', 'FailoverGlobalReplicationGroupMessage$PrimaryReplicationGroupId' => '<p>The name of the primary replication group</p>', 'GlobalNodeGroup$GlobalNodeGroupId' => '<p>The name of the global node group</p>', 'GlobalNodeGroup$Slots' => '<p>The keyspace for this node group</p>', 'GlobalNodeGroupIdList$member' => NULL, 'GlobalReplicationGroup$GlobalReplicationGroupId' => '<p>The name of the Global datastore</p>', 'GlobalReplicationGroup$GlobalReplicationGroupDescription' => '<p>The optional description of the Global datastore</p>', 'GlobalReplicationGroup$Status' => '<p>The status of the Global datastore</p>', 'GlobalReplicationGroup$CacheNodeType' => '<p>The cache node type of the Global datastore</p>', 'GlobalReplicationGroup$Engine' => '<p>The Elasticache engine. For Redis OSS only.</p>', 'GlobalReplicationGroup$EngineVersion' => '<p>The Elasticache (Redis OSS) engine version.</p>', 'GlobalReplicationGroup$ARN' => '<p>The ARN (Amazon Resource Name) of the global replication group.</p>', 'GlobalReplicationGroupInfo$GlobalReplicationGroupId' => '<p>The name of the Global datastore</p>', 'GlobalReplicationGroupInfo$GlobalReplicationGroupMemberRole' => '<p>The role of the replication group in a Global datastore. Can be primary or secondary.</p>', 'GlobalReplicationGroupMember$ReplicationGroupId' => '<p>The replication group id of the Global datastore member.</p>', 'GlobalReplicationGroupMember$ReplicationGroupRegion' => '<p>The Amazon region of the Global datastore member.</p>', 'GlobalReplicationGroupMember$Role' => '<p>Indicates the role of the replication group, primary or secondary.</p>', 'GlobalReplicationGroupMember$Status' => '<p>The status of the membership of the replication group.</p>', 'IncreaseNodeGroupsInGlobalReplicationGroupMessage$GlobalReplicationGroupId' => '<p>The name of the Global datastore</p>', 'IncreaseReplicaCountMessage$ReplicationGroupId' => '<p>The id of the replication group to which you want to add replica nodes.</p>', 'KeyList$member' => NULL, 'KinesisFirehoseDestinationDetails$DeliveryStream' => '<p>The name of the Kinesis Data Firehose delivery stream.</p>', 'ListAllowedNodeTypeModificationsMessage$CacheClusterId' => '<p>The name of the cluster you want to scale up to a larger node instanced type. ElastiCache uses the cluster id to identify the current node type of this cluster and from that to create a list of node types you can scale up to.</p> <important> <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p> </important>', 'ListAllowedNodeTypeModificationsMessage$ReplicationGroupId' => '<p>The name of the replication group want to scale up to a larger node type. ElastiCache uses the replication group id to identify the current node type being used by this replication group, and from that to create a list of node types you can scale up to.</p> <important> <p>You must provide a value for either the <code>CacheClusterId</code> or the <code>ReplicationGroupId</code>.</p> </important>', 'ListTagsForResourceMessage$ResourceName' => '<p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces</a>.</p>', 'LogDeliveryConfiguration$Message' => '<p>Returns an error message for the log delivery configuration.</p>', 'ModifyCacheClusterMessage$CacheClusterId' => '<p>The cluster identifier. This value is stored as a lowercase string.</p>', 'ModifyCacheClusterMessage$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'ModifyCacheClusterMessage$NotificationTopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note> <p>The Amazon SNS topic owner must be same as the cluster owner.</p> </note>', 'ModifyCacheClusterMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group to apply to this cluster. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>', 'ModifyCacheClusterMessage$NotificationTopicStatus' => '<p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is <code>active</code>.</p> <p>Valid values: <code>active</code> | <code>inactive</code> </p>', 'ModifyCacheClusterMessage$EngineVersion' => '<p>The upgraded version of the cache engine to be run on the cache nodes.</p> <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version. </p>', 'ModifyCacheClusterMessage$SnapshotWindow' => '<p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your cluster. </p>', 'ModifyCacheClusterMessage$CacheNodeType' => '<p>A valid cache node type that you want to scale this cluster up to.</p>', 'ModifyCacheClusterMessage$AuthToken' => '<p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update</code> parameter. Password constraints:</p> <ul> <li> <p>Must be only printable ASCII characters</p> </li> <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li> <li> <p>Cannot contain any of the following characters: \'/\', \'"\', or \'@\', \'%\'</p> </li> </ul> <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>', 'ModifyCacheParameterGroupMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group to modify.</p>', 'ModifyCacheSubnetGroupMessage$CacheSubnetGroupName' => '<p>The name for the cache subnet group. This value is stored as a lowercase string.</p> <p>Constraints: Must contain no more than 255 alphanumeric characters or hyphens.</p> <p>Example: <code>mysubnetgroup</code> </p>', 'ModifyCacheSubnetGroupMessage$CacheSubnetGroupDescription' => '<p>A description of the cache subnet group.</p>', 'ModifyGlobalReplicationGroupMessage$GlobalReplicationGroupId' => '<p>The name of the Global datastore</p>', 'ModifyGlobalReplicationGroupMessage$CacheNodeType' => '<p>A valid cache node type that you want to scale this Global datastore to.</p>', 'ModifyGlobalReplicationGroupMessage$EngineVersion' => '<p>The upgraded version of the cache engine to be run on the clusters in the Global datastore. </p>', 'ModifyGlobalReplicationGroupMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group to use with the Global datastore. It must be compatible with the major engine version used by the Global datastore.</p>', 'ModifyGlobalReplicationGroupMessage$GlobalReplicationGroupDescription' => '<p>A description of the Global datastore</p>', 'ModifyReplicationGroupMessage$ReplicationGroupId' => '<p>The identifier of the replication group to modify.</p>', 'ModifyReplicationGroupMessage$ReplicationGroupDescription' => '<p>A description for the replication group. Maximum length is 255 characters.</p>', 'ModifyReplicationGroupMessage$PrimaryClusterId' => '<p>For replication groups with a single primary, if this parameter is specified, ElastiCache promotes the specified cluster in the specified replication group to the primary role. The nodes of all other clusters in the replication group are read replicas.</p>', 'ModifyReplicationGroupMessage$SnapshottingClusterId' => '<p>The cluster ID that is used as the daily snapshot source for the replication group. This parameter cannot be set for Redis OSS (cluster mode enabled) replication groups.</p>', 'ModifyReplicationGroupMessage$NodeGroupId' => '<p>Deprecated. This parameter is not used.</p>', 'ModifyReplicationGroupMessage$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'ModifyReplicationGroupMessage$NotificationTopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications are sent.</p> <note> <p>The Amazon SNS topic owner must be same as the replication group owner. </p> </note>', 'ModifyReplicationGroupMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group to apply to all of the clusters in this replication group. This change is asynchronously applied as soon as possible for parameters when the <code>ApplyImmediately</code> parameter is specified as <code>true</code> for this request.</p>', 'ModifyReplicationGroupMessage$NotificationTopicStatus' => '<p>The status of the Amazon SNS notification topic for the replication group. Notifications are sent only if the status is <code>active</code>.</p> <p>Valid values: <code>active</code> | <code>inactive</code> </p>', 'ModifyReplicationGroupMessage$EngineVersion' => '<p>The upgraded version of the cache engine to be run on the clusters in the replication group.</p> <p> <b>Important:</b> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a>), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing replication group and create it anew with the earlier engine version. </p>', 'ModifyReplicationGroupMessage$SnapshotWindow' => '<p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of the node group (shard) specified by <code>SnapshottingClusterId</code>.</p> <p>Example: <code>05:00-09:00</code> </p> <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p>', 'ModifyReplicationGroupMessage$CacheNodeType' => '<p>A valid cache node type that you want to scale this replication group to.</p>', 'ModifyReplicationGroupMessage$AuthToken' => '<p>Reserved parameter. The password used to access a password protected server. This parameter must be specified with the <code>auth-token-update-strategy </code> parameter. Password constraints:</p> <ul> <li> <p>Must be only printable ASCII characters</p> </li> <li> <p>Must be at least 16 characters and no more than 128 characters in length</p> </li> <li> <p>Cannot contain any of the following characters: \'/\', \'"\', or \'@\', \'%\'</p> </li> </ul> <p> For more information, see AUTH password at <a href="http://redis.io/commands/AUTH">AUTH</a>.</p>', 'ModifyReplicationGroupShardConfigurationMessage$ReplicationGroupId' => '<p>The name of the Redis OSS (cluster mode enabled) cluster (replication group) on which the shards are to be configured.</p>', 'ModifyServerlessCacheRequest$ServerlessCacheName' => '<p>User-provided identifier for the serverless cache to be modified.</p>', 'ModifyServerlessCacheRequest$Description' => '<p>User provided description for the serverless cache. Default = NULL, i.e. the existing description is not removed/modified. The description has a maximum length of 255 characters.</p>', 'ModifyServerlessCacheRequest$UserGroupId' => '<p>The identifier of the UserGroup to be associated with the serverless cache. Available for Redis OSS only. Default is NULL - the existing UserGroup is not removed.</p>', 'ModifyServerlessCacheRequest$DailySnapshotTime' => '<p>The daily time during which Elasticache begins taking a daily snapshot of the serverless cache. Available for Redis OSS and Serverless Memcached only. The default is NULL, i.e. the existing snapshot time configured for the cluster is not removed.</p>', 'ModifyUserGroupMessage$UserGroupId' => '<p>The ID of the user group.</p>', 'NodeGroup$NodeGroupId' => '<p>The identifier for the node group (shard). A Redis OSS (cluster mode disabled) replication group contains only 1 node group; therefore, the node group ID is 0001. A Redis OSS (cluster mode enabled) replication group contains 1 to 90 node groups numbered 0001 to 0090. Optionally, the user can provide the id for a node group. </p>', 'NodeGroup$Status' => '<p>The current state of this replication group - <code>creating</code>, <code>available</code>, <code>modifying</code>, <code>deleting</code>.</p>', 'NodeGroup$Slots' => '<p>The keyspace for this node group (shard).</p>', 'NodeGroupConfiguration$Slots' => '<p>A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383. The string is in the format <code>startkey-endkey</code>.</p> <p>Example: <code>"0-3999"</code> </p>', 'NodeGroupConfiguration$PrimaryAvailabilityZone' => '<p>The Availability Zone where the primary node of this node group (shard) is launched.</p>', 'NodeGroupConfiguration$PrimaryOutpostArn' => '<p>The outpost ARN of the primary node.</p>', 'NodeGroupMember$CacheClusterId' => '<p>The ID of the cluster to which the node belongs.</p>', 'NodeGroupMember$CacheNodeId' => '<p>The ID of the node within its cluster. A node ID is a numeric identifier (0001, 0002, etc.).</p>', 'NodeGroupMember$PreferredAvailabilityZone' => '<p>The name of the Availability Zone in which the node is located.</p>', 'NodeGroupMember$PreferredOutpostArn' => '<p>The outpost ARN of the node group member.</p>', 'NodeGroupMember$CurrentRole' => '<p>The role that is currently assigned to the node - <code>primary</code> or <code>replica</code>. This member is only applicable for Redis OSS (cluster mode disabled) replication groups.</p>', 'NodeGroupMemberUpdateStatus$CacheClusterId' => '<p>The cache cluster ID</p>', 'NodeGroupMemberUpdateStatus$CacheNodeId' => '<p>The node ID of the cache cluster</p>', 'NodeGroupUpdateStatus$NodeGroupId' => '<p>The ID of the node group</p>', 'NodeSnapshot$CacheClusterId' => '<p>A unique identifier for the source cluster.</p>', 'NodeSnapshot$NodeGroupId' => '<p>A unique identifier for the source node group (shard).</p>', 'NodeSnapshot$CacheNodeId' => '<p>The cache node identifier for the node in the source cluster.</p>', 'NodeSnapshot$CacheSize' => '<p>The size of the cache on the source cache node.</p>', 'NodeTypeList$member' => NULL, 'NotificationConfiguration$TopicArn' => '<p>The Amazon Resource Name (ARN) that identifies the topic.</p>', 'NotificationConfiguration$TopicStatus' => '<p>The current state of the topic.</p>', 'OutpostArnsList$member' => NULL, 'Parameter$ParameterName' => '<p>The name of the parameter.</p>', 'Parameter$ParameterValue' => '<p>The value of the parameter.</p>', 'Parameter$Description' => '<p>A description of the parameter.</p>', 'Parameter$Source' => '<p>The source of the parameter.</p>', 'Parameter$DataType' => '<p>The valid data type for the parameter.</p>', 'Parameter$AllowedValues' => '<p>The valid range of values for the parameter.</p>', 'Parameter$MinimumEngineVersion' => '<p>The earliest cache engine version to which the parameter can apply.</p>', 'ParameterNameValue$ParameterName' => '<p>The name of the parameter.</p>', 'ParameterNameValue$ParameterValue' => '<p>The value of the parameter.</p>', 'PasswordListInput$member' => NULL, 'PendingModifiedValues$EngineVersion' => '<p>The new cache engine version that the cluster runs.</p>', 'PendingModifiedValues$CacheNodeType' => '<p>The cache node type that this cluster or replication group is scaled to.</p>', 'PreferredAvailabilityZoneList$member' => NULL, 'PreferredOutpostArnList$member' => NULL, 'ProcessedUpdateAction$ReplicationGroupId' => '<p>The ID of the replication group</p>', 'ProcessedUpdateAction$CacheClusterId' => '<p>The ID of the cache cluster</p>', 'ProcessedUpdateAction$ServiceUpdateName' => '<p>The unique ID of the service update</p>', 'PurchaseReservedCacheNodesOfferingMessage$ReservedCacheNodesOfferingId' => '<p>The ID of the reserved cache node offering to purchase.</p> <p>Example: <code>438012d3-4052-4cc7-b2e3-8d3372e0e706</code> </p>', 'PurchaseReservedCacheNodesOfferingMessage$ReservedCacheNodeId' => '<p>A customer-specified identifier to track this reservation.</p> <note> <p>The Reserved Cache Node ID is an unique customer-specified identifier to track this reservation. If this parameter is not specified, ElastiCache automatically generates an identifier for the reservation.</p> </note> <p>Example: myreservationID</p>', 'RebalanceSlotsInGlobalReplicationGroupMessage$GlobalReplicationGroupId' => '<p>The name of the Global datastore</p>', 'RebootCacheClusterMessage$CacheClusterId' => '<p>The cluster identifier. This parameter is stored as a lowercase string.</p>', 'RecurringCharge$RecurringChargeFrequency' => '<p>The frequency of the recurring charge.</p>', 'RegionalConfiguration$ReplicationGroupId' => '<p>The name of the secondary cluster</p>', 'RegionalConfiguration$ReplicationGroupRegion' => '<p>The Amazon region where the cluster is stored</p>', 'RemoveReplicasList$member' => NULL, 'RemoveTagsFromResourceMessage$ResourceName' => '<p>The Amazon Resource Name (ARN) of the resource from which you want the tags removed, for example <code>arn:aws:elasticache:us-west-2:0123456789:cluster:myCluster</code> or <code>arn:aws:elasticache:us-west-2:0123456789:snapshot:mySnapshot</code>.</p> <p>For more information about ARNs, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs) and Amazon Service Namespaces</a>.</p>', 'ReplicationGroup$ReplicationGroupId' => '<p>The identifier for the replication group.</p>', 'ReplicationGroup$Description' => '<p>The user supplied description of the replication group.</p>', 'ReplicationGroup$Status' => '<p>The current state of this replication group - <code>creating</code>, <code>available</code>, <code>modifying</code>, <code>deleting</code>, <code>create-failed</code>, <code>snapshotting</code>.</p>', 'ReplicationGroup$SnapshottingClusterId' => '<p>The cluster ID that is used as the daily snapshot source for the replication group.</p>', 'ReplicationGroup$SnapshotWindow' => '<p>The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).</p> <p>Example: <code>05:00-09:00</code> </p> <p>If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.</p> <note> <p>This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code>.</p> </note>', 'ReplicationGroup$CacheNodeType' => '<p>The name of the compute and memory capacity node type for each node in the replication group.</p>', 'ReplicationGroup$KmsKeyId' => '<p>The ID of the KMS key used to encrypt the disk in the cluster.</p>', 'ReplicationGroup$ARN' => '<p>The ARN (Amazon Resource Name) of the replication group.</p>', 'ReplicationGroupIdList$member' => NULL, 'ReplicationGroupMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'ReplicationGroupOutpostArnList$member' => NULL, 'ReplicationGroupPendingModifiedValues$PrimaryClusterId' => '<p>The primary cluster ID that is applied immediately (if <code>--apply-immediately</code> was specified), or during the next maintenance window.</p>', 'ReservedCacheNode$ReservedCacheNodeId' => '<p>The unique identifier for the reservation.</p>', 'ReservedCacheNode$ReservedCacheNodesOfferingId' => '<p>The offering identifier.</p>', 'ReservedCacheNode$CacheNodeType' => '<p>The cache node type for the reserved cache nodes.</p> <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: </p> <p> <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>, <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>, <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized:</p> <ul> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li> </ul> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: </p> <p> <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>, <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>, <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Additional node type info</b> </p> <ul> <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li> <li> <p>Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.</p> </li> <li> <p>Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.</p> </li> <li> <p>Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis OSS version 2.8.22 and later.</p> </li> </ul>', 'ReservedCacheNode$ProductDescription' => '<p>The description of the reserved cache node.</p>', 'ReservedCacheNode$OfferingType' => '<p>The offering type of this reserved cache node.</p>', 'ReservedCacheNode$State' => '<p>The state of the reserved cache node.</p>', 'ReservedCacheNode$ReservationARN' => '<p>The Amazon Resource Name (ARN) of the reserved cache node.</p> <p>Example: <code>arn:aws:elasticache:us-east-1:123456789012:reserved-instance:ri-2017-03-27-08-33-25-582</code> </p>', 'ReservedCacheNodeMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'ReservedCacheNodesOffering$ReservedCacheNodesOfferingId' => '<p>A unique identifier for the reserved cache node offering.</p>', 'ReservedCacheNodesOffering$CacheNodeType' => '<p>The cache node type for the reserved cache node.</p> <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: </p> <p> <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>, <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>, <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized:</p> <ul> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li> </ul> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: </p> <p> <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>, <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>, <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Additional node type info</b> </p> <ul> <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li> <li> <p>Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.</p> </li> <li> <p>Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.</p> </li> <li> <p>Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis OSS version 2.8.22 and later.</p> </li> </ul>', 'ReservedCacheNodesOffering$ProductDescription' => '<p>The cache engine used by the offering.</p>', 'ReservedCacheNodesOffering$OfferingType' => '<p>The offering type.</p>', 'ReservedCacheNodesOfferingMessage$Marker' => '<p>Provides an identifier to allow retrieval of paginated results.</p>', 'ResetCacheParameterGroupMessage$CacheParameterGroupName' => '<p>The name of the cache parameter group to reset.</p>', 'RevokeCacheSecurityGroupIngressMessage$CacheSecurityGroupName' => '<p>The name of the cache security group to revoke ingress from.</p>', 'RevokeCacheSecurityGroupIngressMessage$EC2SecurityGroupName' => '<p>The name of the Amazon EC2 security group to revoke access from.</p>', 'RevokeCacheSecurityGroupIngressMessage$EC2SecurityGroupOwnerId' => '<p>The Amazon account number of the Amazon EC2 security group owner. Note that this is not the same thing as an Amazon access key ID - you must provide a valid Amazon account number for this parameter.</p>', 'SecurityGroupIdsList$member' => NULL, 'SecurityGroupMembership$SecurityGroupId' => '<p>The identifier of the cache security group.</p>', 'SecurityGroupMembership$Status' => '<p>The status of the cache security group membership. The status changes whenever a cache security group is modified, or when the cache security groups assigned to a cluster are modified.</p>', 'ServerlessCache$ServerlessCacheName' => '<p>The unique identifier of the serverless cache.</p>', 'ServerlessCache$Description' => '<p>A description of the serverless cache.</p>', 'ServerlessCache$Status' => '<p>The current status of the serverless cache. The allowed values are CREATING, AVAILABLE, DELETING, CREATE-FAILED and MODIFYING.</p>', 'ServerlessCache$Engine' => '<p>The engine the serverless cache is compatible with.</p>', 'ServerlessCache$MajorEngineVersion' => '<p>The version number of the engine the serverless cache is compatible with.</p>', 'ServerlessCache$FullEngineVersion' => '<p>The name and version number of the engine the serverless cache is compatible with.</p>', 'ServerlessCache$KmsKeyId' => '<p>The ID of the Amazon Web Services Key Management Service (KMS) key that is used to encrypt data at rest in the serverless cache.</p>', 'ServerlessCache$ARN' => '<p>The Amazon Resource Name (ARN) of the serverless cache.</p>', 'ServerlessCache$UserGroupId' => '<p>The identifier of the user group associated with the serverless cache. Available for Redis OSS only. Default is NULL.</p>', 'ServerlessCache$DailySnapshotTime' => '<p>The daily time that a cache snapshot will be created. Default is NULL, i.e. snapshots will not be created at a specific time on a daily basis. Available for Redis OSS and Serverless Memcached only.</p>', 'ServerlessCacheConfiguration$ServerlessCacheName' => '<p>The identifier of a serverless cache.</p>', 'ServerlessCacheConfiguration$Engine' => '<p>The engine that the serverless cache is configured with.</p>', 'ServerlessCacheConfiguration$MajorEngineVersion' => '<p>The engine version number that the serverless cache is configured with.</p>', 'ServerlessCacheSnapshot$ServerlessCacheSnapshotName' => '<p>The identifier of a serverless cache snapshot. Available for Redis OSS and Serverless Memcached only.</p>', 'ServerlessCacheSnapshot$ARN' => '<p>The Amazon Resource Name (ARN) of a serverless cache snapshot. Available for Redis OSS and Serverless Memcached only.</p>', 'ServerlessCacheSnapshot$KmsKeyId' => '<p>The ID of the Amazon Web Services Key Management Service (KMS) key of a serverless cache snapshot. Available for Redis OSS and Serverless Memcached only.</p>', 'ServerlessCacheSnapshot$SnapshotType' => '<p>The type of snapshot of serverless cache. Available for Redis OSS and Serverless Memcached only.</p>', 'ServerlessCacheSnapshot$Status' => '<p>The current status of the serverless cache. Available for Redis OSS and Serverless Memcached only.</p>', 'ServerlessCacheSnapshot$BytesUsedForCache' => '<p>The total size of a serverless cache snapshot, in bytes. Available for Redis OSS and Serverless Memcached only.</p>', 'ServiceUpdate$ServiceUpdateName' => '<p>The unique ID of the service update</p>', 'ServiceUpdate$ServiceUpdateDescription' => '<p>Provides details of the service update</p>', 'ServiceUpdate$Engine' => '<p>The Elasticache engine to which the update applies. Either Redis OSS or Memcached.</p>', 'ServiceUpdate$EngineVersion' => '<p>The Elasticache engine version to which the update applies. Either Redis OSS or Memcached engine version.</p>', 'ServiceUpdate$EstimatedUpdateTime' => '<p>The estimated length of time the service update will take</p>', 'ServiceUpdatesMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'Snapshot$SnapshotName' => '<p>The name of a snapshot. For an automatic snapshot, the name is system-generated. For a manual snapshot, this is the user-provided name.</p>', 'Snapshot$ReplicationGroupId' => '<p>The unique identifier of the source replication group.</p>', 'Snapshot$ReplicationGroupDescription' => '<p>A description of the source replication group.</p>', 'Snapshot$CacheClusterId' => '<p>The user-supplied identifier of the source cluster.</p>', 'Snapshot$SnapshotStatus' => '<p>The status of the snapshot. Valid values: <code>creating</code> | <code>available</code> | <code>restoring</code> | <code>copying</code> | <code>deleting</code>.</p>', 'Snapshot$SnapshotSource' => '<p>Indicates whether the snapshot is from an automatic backup (<code>automated</code>) or was created manually (<code>manual</code>).</p>', 'Snapshot$CacheNodeType' => '<p>The name of the compute and memory capacity node type for the source cluster.</p> <p>The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts.</p> <ul> <li> <p>General purpose:</p> <ul> <li> <p>Current generation: </p> <p> <b>M7g node types</b>: <code>cache.m7g.large</code>, <code>cache.m7g.xlarge</code>, <code>cache.m7g.2xlarge</code>, <code>cache.m7g.4xlarge</code>, <code>cache.m7g.8xlarge</code>, <code>cache.m7g.12xlarge</code>, <code>cache.m7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>M6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.m6g.large</code>, <code>cache.m6g.xlarge</code>, <code>cache.m6g.2xlarge</code>, <code>cache.m6g.4xlarge</code>, <code>cache.m6g.8xlarge</code>, <code>cache.m6g.12xlarge</code>, <code>cache.m6g.16xlarge</code> </p> <p> <b>M5 node types:</b> <code>cache.m5.large</code>, <code>cache.m5.xlarge</code>, <code>cache.m5.2xlarge</code>, <code>cache.m5.4xlarge</code>, <code>cache.m5.12xlarge</code>, <code>cache.m5.24xlarge</code> </p> <p> <b>M4 node types:</b> <code>cache.m4.large</code>, <code>cache.m4.xlarge</code>, <code>cache.m4.2xlarge</code>, <code>cache.m4.4xlarge</code>, <code>cache.m4.10xlarge</code> </p> <p> <b>T4g node types</b> (available only for Redis OSS engine version 5.0.6 onward and Memcached engine version 1.5.16 onward): <code>cache.t4g.micro</code>, <code>cache.t4g.small</code>, <code>cache.t4g.medium</code> </p> <p> <b>T3 node types:</b> <code>cache.t3.micro</code>, <code>cache.t3.small</code>, <code>cache.t3.medium</code> </p> <p> <b>T2 node types:</b> <code>cache.t2.micro</code>, <code>cache.t2.small</code>, <code>cache.t2.medium</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>T1 node types:</b> <code>cache.t1.micro</code> </p> <p> <b>M1 node types:</b> <code>cache.m1.small</code>, <code>cache.m1.medium</code>, <code>cache.m1.large</code>, <code>cache.m1.xlarge</code> </p> <p> <b>M3 node types:</b> <code>cache.m3.medium</code>, <code>cache.m3.large</code>, <code>cache.m3.xlarge</code>, <code>cache.m3.2xlarge</code> </p> </li> </ul> </li> <li> <p>Compute optimized:</p> <ul> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>C1 node types:</b> <code>cache.c1.xlarge</code> </p> </li> </ul> </li> <li> <p>Memory optimized:</p> <ul> <li> <p>Current generation: </p> <p> <b>R7g node types</b>: <code>cache.r7g.large</code>, <code>cache.r7g.xlarge</code>, <code>cache.r7g.2xlarge</code>, <code>cache.r7g.4xlarge</code>, <code>cache.r7g.8xlarge</code>, <code>cache.r7g.12xlarge</code>, <code>cache.r7g.16xlarge</code> </p> <note> <p>For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types</a> </p> </note> <p> <b>R6g node types</b> (available only for Redis OSS engine version 5.0.6 onward and for Memcached engine version 1.5.16 onward): <code>cache.r6g.large</code>, <code>cache.r6g.xlarge</code>, <code>cache.r6g.2xlarge</code>, <code>cache.r6g.4xlarge</code>, <code>cache.r6g.8xlarge</code>, <code>cache.r6g.12xlarge</code>, <code>cache.r6g.16xlarge</code> </p> <p> <b>R5 node types:</b> <code>cache.r5.large</code>, <code>cache.r5.xlarge</code>, <code>cache.r5.2xlarge</code>, <code>cache.r5.4xlarge</code>, <code>cache.r5.12xlarge</code>, <code>cache.r5.24xlarge</code> </p> <p> <b>R4 node types:</b> <code>cache.r4.large</code>, <code>cache.r4.xlarge</code>, <code>cache.r4.2xlarge</code>, <code>cache.r4.4xlarge</code>, <code>cache.r4.8xlarge</code>, <code>cache.r4.16xlarge</code> </p> </li> <li> <p>Previous generation: (not recommended. Existing clusters are still supported but creation of new clusters is not supported for these types.)</p> <p> <b>M2 node types:</b> <code>cache.m2.xlarge</code>, <code>cache.m2.2xlarge</code>, <code>cache.m2.4xlarge</code> </p> <p> <b>R3 node types:</b> <code>cache.r3.large</code>, <code>cache.r3.xlarge</code>, <code>cache.r3.2xlarge</code>, <code>cache.r3.4xlarge</code>, <code>cache.r3.8xlarge</code> </p> </li> </ul> </li> </ul> <p> <b>Additional node type info</b> </p> <ul> <li> <p>All current generation instance types are created in Amazon VPC by default.</p> </li> <li> <p>Redis OSS append-only files (AOF) are not supported for T1 or T2 instances.</p> </li> <li> <p>Redis OSS Multi-AZ with automatic failover is not supported on T1 instances.</p> </li> <li> <p>Redis OSS configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis OSS version 2.8.22 and later.</p> </li> </ul>', 'Snapshot$Engine' => '<p>The name of the cache engine (<code>memcached</code> or <code>redis</code>) used by the source cluster.</p>', 'Snapshot$EngineVersion' => '<p>The version of the cache engine version that is used by the source cluster.</p>', 'Snapshot$PreferredAvailabilityZone' => '<p>The name of the Availability Zone in which the source cluster is located.</p>', 'Snapshot$PreferredOutpostArn' => '<p>The ARN (Amazon Resource Name) of the preferred outpost.</p>', 'Snapshot$PreferredMaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'Snapshot$TopicArn' => '<p>The Amazon Resource Name (ARN) for the topic used by the source cluster for publishing notifications.</p>', 'Snapshot$CacheParameterGroupName' => '<p>The cache parameter group that is associated with the source cluster.</p>', 'Snapshot$CacheSubnetGroupName' => '<p>The name of the cache subnet group associated with the source cluster.</p>', 'Snapshot$VpcId' => '<p>The Amazon Virtual Private Cloud identifier (VPC ID) of the cache subnet group for the source cluster.</p>', 'Snapshot$SnapshotWindow' => '<p>The daily time range during which ElastiCache takes daily snapshots of the source cluster.</p>', 'Snapshot$KmsKeyId' => '<p>The ID of the KMS key used to encrypt the snapshot.</p>', 'Snapshot$ARN' => '<p>The ARN (Amazon Resource Name) of the snapshot.</p>', 'SnapshotArnsList$member' => NULL, 'StartMigrationMessage$ReplicationGroupId' => '<p>The ID of the replication group to which data should be migrated.</p>', 'Subnet$SubnetIdentifier' => '<p>The unique identifier for the subnet.</p>', 'SubnetIdentifierList$member' => NULL, 'SubnetIdsList$member' => NULL, 'SubnetOutpost$SubnetOutpostArn' => '<p>The outpost ARN of the subnet.</p>', 'Tag$Key' => '<p>The key for the tag. May not be null.</p>', 'Tag$Value' => '<p>The tag\'s value. May be null.</p>', 'TestFailoverMessage$ReplicationGroupId' => '<p>The name of the replication group (console: cluster) whose automatic failover is being tested by this operation.</p>', 'TestMigrationMessage$ReplicationGroupId' => '<p> The ID of the replication group to which data is to be migrated. </p>', 'UGReplicationGroupIdList$member' => NULL, 'UGServerlessCacheIdList$member' => NULL, 'UnprocessedUpdateAction$ReplicationGroupId' => '<p>The replication group ID</p>', 'UnprocessedUpdateAction$CacheClusterId' => '<p>The ID of the cache cluster</p>', 'UnprocessedUpdateAction$ServiceUpdateName' => '<p>The unique ID of the service update</p>', 'UnprocessedUpdateAction$ErrorType' => '<p>The error type for requests that are not processed</p>', 'UnprocessedUpdateAction$ErrorMessage' => '<p>The error message that describes the reason the request was not processed</p>', 'UpdateAction$ReplicationGroupId' => '<p>The ID of the replication group</p>', 'UpdateAction$CacheClusterId' => '<p>The ID of the cache cluster</p>', 'UpdateAction$ServiceUpdateName' => '<p>The unique ID of the service update</p>', 'UpdateAction$NodesUpdated' => '<p>The progress of the service update on the replication group</p>', 'UpdateAction$EstimatedUpdateTime' => '<p>The estimated length of time for the update to complete</p>', 'UpdateAction$Engine' => '<p>The Elasticache engine to which the update applies. Either Redis OSS or Memcached.</p>', 'UpdateActionsMessage$Marker' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.</p>', 'User$UserId' => '<p>The ID of the user.</p>', 'User$UserName' => '<p>The username of the user.</p>', 'User$Status' => '<p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>', 'User$MinimumEngineVersion' => '<p>The minimum engine version required, which is Redis OSS 6.0</p>', 'User$AccessString' => '<p>Access permissions string used for this user.</p>', 'User$ARN' => '<p>The Amazon Resource Name (ARN) of the user.</p>', 'UserGroup$UserGroupId' => '<p>The ID of the user group.</p>', 'UserGroup$Status' => '<p>Indicates user group status. Can be "creating", "active", "modifying", "deleting".</p>', 'UserGroup$MinimumEngineVersion' => '<p>The minimum engine version required, which is Redis OSS 6.0</p>', 'UserGroup$ARN' => '<p>The Amazon Resource Name (ARN) of the user group.</p>', ], ], 'Subnet' => [ 'base' => '<p>Represents the subnet associated with a cluster. This parameter refers to subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with ElastiCache.</p>', 'refs' => [ 'SubnetList$member' => NULL, ], ], 'SubnetIdentifierList' => [ 'base' => NULL, 'refs' => [ 'CreateCacheSubnetGroupMessage$SubnetIds' => '<p>A list of VPC subnet IDs for the cache subnet group.</p>', 'ModifyCacheSubnetGroupMessage$SubnetIds' => '<p>The EC2 subnet IDs for the cache subnet group.</p>', ], ], 'SubnetIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateServerlessCacheRequest$SubnetIds' => '<p>A list of the identifiers of the subnets where the VPC endpoint for the serverless cache will be deployed. All the subnetIds must belong to the same VPC.</p>', 'ServerlessCache$SubnetIds' => '<p>If no subnet IDs are given and your VPC is in us-west-1, then ElastiCache will select 2 default subnets across AZs in your VPC. For all other Regions, if no subnet IDs are given then ElastiCache will select 3 default subnets across AZs in your default VPC.</p>', ], ], 'SubnetInUse' => [ 'base' => '<p>The requested subnet is being used by another cache subnet group.</p>', 'refs' => [], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'CacheSubnetGroup$Subnets' => '<p>A list of subnets associated with the cache subnet group.</p>', ], ], 'SubnetNotAllowedFault' => [ 'base' => '<p>At least one subnet ID does not match the other subnet IDs. This mismatch typically occurs when a user sets one subnet ID to a regional Availability Zone and a different one to an outpost. Or when a user sets the subnet ID to an Outpost when not subscribed on this service.</p>', 'refs' => [], ], 'SubnetOutpost' => [ 'base' => '<p>The ID of the outpost subnet.</p>', 'refs' => [ 'Subnet$SubnetOutpost' => '<p>The outpost ARN of the subnet.</p>', ], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$CacheClusterCreateTime' => '<p>The date and time when the cluster was created.</p>', 'CacheCluster$AuthTokenLastModifiedDate' => '<p>The date the auth token was last modified</p>', 'CacheNode$CacheNodeCreateTime' => '<p>The date and time when the cache node was created.</p>', 'CacheNodeUpdateStatus$NodeDeletionDate' => '<p>The deletion date of the node</p>', 'CacheNodeUpdateStatus$NodeUpdateStartDate' => '<p>The start date of the update for a node</p>', 'CacheNodeUpdateStatus$NodeUpdateEndDate' => '<p>The end date of the update for a node</p>', 'CacheNodeUpdateStatus$NodeUpdateInitiatedDate' => '<p>The date when the update is triggered</p>', 'CacheNodeUpdateStatus$NodeUpdateStatusModifiedDate' => '<p>The date when the NodeUpdateStatus was last modified&gt;</p>', 'DescribeEventsMessage$StartTime' => '<p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format.</p> <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>', 'DescribeEventsMessage$EndTime' => '<p>The end of the time interval for which to retrieve events, specified in ISO 8601 format.</p> <p> <b>Example:</b> 2017-03-30T07:03:49.555Z</p>', 'Event$Date' => '<p>The date and time when the event occurred.</p>', 'NodeGroupMemberUpdateStatus$NodeDeletionDate' => '<p>The deletion date of the node</p>', 'NodeGroupMemberUpdateStatus$NodeUpdateStartDate' => '<p>The start date of the update for a node</p>', 'NodeGroupMemberUpdateStatus$NodeUpdateEndDate' => '<p>The end date of the update for a node</p>', 'NodeGroupMemberUpdateStatus$NodeUpdateInitiatedDate' => '<p>The date when the update is triggered</p>', 'NodeGroupMemberUpdateStatus$NodeUpdateStatusModifiedDate' => '<p>The date when the NodeUpdateStatus was last modified</p>', 'NodeSnapshot$CacheNodeCreateTime' => '<p>The date and time when the cache node was created in the source cluster.</p>', 'NodeSnapshot$SnapshotCreateTime' => '<p>The date and time when the source node\'s metadata and cache data set was obtained for the snapshot.</p>', 'ReplicationGroup$AuthTokenLastModifiedDate' => '<p>The date the auth token was last modified</p>', 'ReplicationGroup$ReplicationGroupCreateTime' => '<p>The date and time when the cluster was created.</p>', 'ReservedCacheNode$StartTime' => '<p>The time the reservation started.</p>', 'ServerlessCache$CreateTime' => '<p>When the serverless cache was created. </p>', 'ServerlessCacheSnapshot$CreateTime' => '<p>The date and time that the source serverless cache\'s metadata and cache data set was obtained for the snapshot. Available for Redis OSS and Serverless Memcached only.</p>', 'ServerlessCacheSnapshot$ExpiryTime' => '<p>The time that the serverless cache snapshot will expire. Available for Redis OSS and Serverless Memcached only.</p>', 'ServiceUpdate$ServiceUpdateReleaseDate' => '<p>The date when the service update is initially available</p>', 'ServiceUpdate$ServiceUpdateEndDate' => '<p>The date after which the service update is no longer available</p>', 'ServiceUpdate$ServiceUpdateRecommendedApplyByDate' => '<p>The recommendend date to apply the service update in order to ensure compliance. For information on compliance, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service">Self-Service Security Updates for Compliance</a>.</p>', 'Snapshot$CacheClusterCreateTime' => '<p>The date and time when the source cluster was created.</p>', 'TimeRangeFilter$StartTime' => '<p>The start time of the time range filter</p>', 'TimeRangeFilter$EndTime' => '<p>The end time of the time range filter</p>', 'UpdateAction$ServiceUpdateReleaseDate' => '<p>The date the update is first available</p>', 'UpdateAction$ServiceUpdateRecommendedApplyByDate' => '<p>The recommended date to apply the service update to ensure compliance. For information on compliance, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/elasticache-compliance.html#elasticache-compliance-self-service">Self-Service Security Updates for Compliance</a>.</p>', 'UpdateAction$UpdateActionAvailableDate' => '<p>The date that the service update is available to a replication group</p>', 'UpdateAction$UpdateActionStatusModifiedDate' => '<p>The date when the UpdateActionStatus was last modified</p>', ], ], 'Tag' => [ 'base' => '<p>A tag that can be added to an ElastiCache cluster or replication group. Tags are composed of a Key/Value pair. You can use tags to categorize and track all your ElastiCache resources, with the exception of global replication group. When you add or remove tags on replication groups, those actions will be replicated to all nodes in the replication group. A tag with a null Value is permitted.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'AddTagsToResourceMessage$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'CopyServerlessCacheSnapshotRequest$Tags' => '<p>A list of tags to be added to the target snapshot resource. A tag is a key-value pair. Available for Redis OSS and Serverless Memcached only. Default: NULL</p>', 'CopySnapshotMessage$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'CreateCacheClusterMessage$Tags' => '<p>A list of tags to be added to this resource.</p>', 'CreateCacheParameterGroupMessage$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'CreateCacheSecurityGroupMessage$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'CreateCacheSubnetGroupMessage$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'CreateReplicationGroupMessage$Tags' => '<p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=<code>myKey</code>, Value=<code>myKeyValue</code>. You can include multiple tags as shown following: Key=<code>myKey</code>, Value=<code>myKeyValue</code> Key=<code>mySecondKey</code>, Value=<code>mySecondKeyValue</code>. Tags on replication groups will be replicated to all nodes.</p>', 'CreateServerlessCacheRequest$Tags' => '<p>The list of tags (key, value) pairs to be added to the serverless cache resource. Default is NULL.</p>', 'CreateServerlessCacheSnapshotRequest$Tags' => '<p>A list of tags to be added to the snapshot resource. A tag is a key-value pair. Available for Redis OSS and Serverless Memcached only.</p>', 'CreateSnapshotMessage$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'CreateUserGroupMessage$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted. Available for Redis OSS only.</p>', 'CreateUserMessage$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'PurchaseReservedCacheNodesOfferingMessage$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'TagListMessage$TagList' => '<p>A list of tags as key-value pairs.</p>', ], ], 'TagListMessage' => [ 'base' => '<p>Represents the output from the <code>AddTagsToResource</code>, <code>ListTagsForResource</code>, and <code>RemoveTagsFromResource</code> operations.</p>', 'refs' => [], ], 'TagNotFoundFault' => [ 'base' => '<p>The requested tag was not found on this resource.</p>', 'refs' => [], ], 'TagQuotaPerResourceExceeded' => [ 'base' => '<p>The request cannot be processed because it would cause the resource to have more than the allowed number of tags. The maximum number of tags permitted on a resource is 50.</p>', 'refs' => [], ], 'TestFailoverMessage' => [ 'base' => NULL, 'refs' => [], ], 'TestFailoverNotAvailableFault' => [ 'base' => '<p>The <code>TestFailover</code> action is not available.</p>', 'refs' => [], ], 'TestFailoverResult' => [ 'base' => NULL, 'refs' => [], ], 'TestMigrationMessage' => [ 'base' => NULL, 'refs' => [], ], 'TestMigrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'TimeRangeFilter' => [ 'base' => '<p>Filters update actions from the service updates that are in available status during the time range.</p>', 'refs' => [ 'DescribeUpdateActionsMessage$ServiceUpdateTimeRange' => '<p>The range of time specified to search for service updates that are in available status</p>', ], ], 'TransitEncryptionMode' => [ 'base' => NULL, 'refs' => [ 'CacheCluster$TransitEncryptionMode' => '<p>A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p>', 'CreateReplicationGroupMessage$TransitEncryptionMode' => '<p>A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p> <p>When setting <code>TransitEncryptionEnabled</code> to <code>true</code>, you can set your <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request, to allow both encrypted and unencrypted connections at the same time. Once you migrate all your Redis OSS clients to use encrypted connections you can modify the value to <code>required</code> to allow encrypted connections only.</p> <p>Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires you to first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set <code>TransitEncryptionMode</code> to <code>required</code>.</p> <p>This process will not trigger the replacement of the replication group.</p>', 'ModifyReplicationGroupMessage$TransitEncryptionMode' => '<p>A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p> <p>You must set <code>TransitEncryptionEnabled</code> to <code>true</code>, for your existing cluster, and set <code>TransitEncryptionMode</code> to <code>preferred</code> in the same request to allow both encrypted and unencrypted connections at the same time. Once you migrate all your Redis OSS clients to use encrypted connections you can set the value to <code>required</code> to allow encrypted connections only.</p> <p>Setting <code>TransitEncryptionMode</code> to <code>required</code> is a two-step process that requires you to first set the <code>TransitEncryptionMode</code> to <code>preferred</code>, after that you can set <code>TransitEncryptionMode</code> to <code>required</code>. </p>', 'PendingModifiedValues$TransitEncryptionMode' => '<p>A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p>', 'ReplicationGroup$TransitEncryptionMode' => '<p>A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p>', 'ReplicationGroupPendingModifiedValues$TransitEncryptionMode' => '<p>A setting that allows you to migrate your clients to use in-transit encryption, with no downtime.</p>', ], ], 'UGReplicationGroupIdList' => [ 'base' => NULL, 'refs' => [ 'UserGroup$ReplicationGroups' => '<p>A list of replication groups that the user group can access.</p>', ], ], 'UGServerlessCacheIdList' => [ 'base' => NULL, 'refs' => [ 'UserGroup$ServerlessCaches' => '<p>Indicates which serverless caches the specified user group is associated with. Available for Redis OSS and Serverless Memcached only.</p>', ], ], 'UnprocessedUpdateAction' => [ 'base' => '<p>Update action that has failed to be processed for the corresponding apply/stop request</p>', 'refs' => [ 'UnprocessedUpdateActionList$member' => NULL, ], ], 'UnprocessedUpdateActionList' => [ 'base' => NULL, 'refs' => [ 'UpdateActionResultsMessage$UnprocessedUpdateActions' => '<p>Update actions that haven\'t been processed successfully</p>', ], ], 'UpdateAction' => [ 'base' => '<p>The status of the service update for a specific replication group</p>', 'refs' => [ 'UpdateActionList$member' => NULL, ], ], 'UpdateActionList' => [ 'base' => NULL, 'refs' => [ 'UpdateActionsMessage$UpdateActions' => '<p>Returns a list of update actions</p>', ], ], 'UpdateActionResultsMessage' => [ 'base' => NULL, 'refs' => [], ], 'UpdateActionStatus' => [ 'base' => NULL, 'refs' => [ 'ProcessedUpdateAction$UpdateActionStatus' => '<p>The status of the update action on the Redis OSS cluster</p>', 'UpdateAction$UpdateActionStatus' => '<p>The status of the update action</p>', 'UpdateActionStatusList$member' => NULL, ], ], 'UpdateActionStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeUpdateActionsMessage$UpdateActionStatus' => '<p>The status of the update action.</p>', ], ], 'UpdateActionsMessage' => [ 'base' => NULL, 'refs' => [], ], 'User' => [ 'base' => NULL, 'refs' => [ 'UserList$member' => NULL, ], ], 'UserAlreadyExistsFault' => [ 'base' => '<p>A user with this ID already exists.</p>', 'refs' => [], ], 'UserGroup' => [ 'base' => NULL, 'refs' => [ 'UserGroupList$member' => NULL, ], ], 'UserGroupAlreadyExistsFault' => [ 'base' => '<p>The user group with this ID already exists.</p>', 'refs' => [], ], 'UserGroupId' => [ 'base' => NULL, 'refs' => [ 'UserGroupIdList$member' => NULL, 'UserGroupIdListInput$member' => NULL, ], ], 'UserGroupIdList' => [ 'base' => NULL, 'refs' => [ 'ModifyReplicationGroupMessage$UserGroupIdsToAdd' => '<p>The ID of the user group you are associating with the replication group.</p>', 'ModifyReplicationGroupMessage$UserGroupIdsToRemove' => '<p>The ID of the user group to disassociate from the replication group, meaning the users in the group no longer can access the replication group.</p>', 'ReplicationGroup$UserGroupIds' => '<p>The ID of the user group associated to the replication group.</p>', 'User$UserGroupIds' => '<p>Returns a list of the user group IDs the user belongs to.</p>', 'UserGroupsUpdateStatus$UserGroupIdsToAdd' => '<p>The ID of the user group to add.</p>', 'UserGroupsUpdateStatus$UserGroupIdsToRemove' => '<p>The ID of the user group to remove.</p>', ], ], 'UserGroupIdListInput' => [ 'base' => NULL, 'refs' => [ 'CreateReplicationGroupMessage$UserGroupIds' => '<p>The user group to associate with the replication group.</p>', ], ], 'UserGroupList' => [ 'base' => NULL, 'refs' => [ 'DescribeUserGroupsResult$UserGroups' => '<p>Returns a list of user groups.</p>', ], ], 'UserGroupNotFoundFault' => [ 'base' => '<p>The user group was not found or does not exist</p>', 'refs' => [], ], 'UserGroupPendingChanges' => [ 'base' => '<p>Returns the updates being applied to the user group.</p>', 'refs' => [ 'UserGroup$PendingChanges' => '<p>A list of updates being applied to the user group.</p>', ], ], 'UserGroupQuotaExceededFault' => [ 'base' => '<p>The number of users exceeds the user group limit.</p>', 'refs' => [], ], 'UserGroupsUpdateStatus' => [ 'base' => '<p>The status of the user group update.</p>', 'refs' => [ 'ReplicationGroupPendingModifiedValues$UserGroups' => '<p>The user group being modified.</p>', ], ], 'UserId' => [ 'base' => NULL, 'refs' => [ 'CreateUserMessage$UserId' => '<p>The ID of the user.</p>', 'DeleteUserMessage$UserId' => '<p>The ID of the user.</p>', 'DescribeUsersMessage$UserId' => '<p>The ID of the user.</p>', 'ModifyUserMessage$UserId' => '<p>The ID of the user.</p>', 'UserIdList$member' => NULL, 'UserIdListInput$member' => NULL, ], ], 'UserIdList' => [ 'base' => NULL, 'refs' => [ 'UserGroup$UserIds' => '<p>The list of user IDs that belong to the user group.</p>', 'UserGroupPendingChanges$UserIdsToRemove' => '<p>The list of user IDs to remove.</p>', 'UserGroupPendingChanges$UserIdsToAdd' => '<p>The list of user IDs to add.</p>', ], ], 'UserIdListInput' => [ 'base' => NULL, 'refs' => [ 'CreateUserGroupMessage$UserIds' => '<p>The list of user IDs that belong to the user group.</p>', 'ModifyUserGroupMessage$UserIdsToAdd' => '<p>The list of user IDs to add to the user group.</p>', 'ModifyUserGroupMessage$UserIdsToRemove' => '<p>The list of user IDs to remove from the user group.</p>', ], ], 'UserList' => [ 'base' => NULL, 'refs' => [ 'DescribeUsersResult$Users' => '<p>A list of users.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'CreateUserMessage$UserName' => '<p>The username of the user.</p>', ], ], 'UserNotFoundFault' => [ 'base' => '<p>The user does not exist or could not be found.</p>', 'refs' => [], ], 'UserQuotaExceededFault' => [ 'base' => '<p>The quota of users has been exceeded.</p>', 'refs' => [], ], ],];
