<?php
// This file was auto-generated from sdk-root/src/data/emr-containers/2020-10-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon EMR on EKS provides a deployment option for Amazon EMR that allows you to run open-source big data frameworks on Amazon Elastic Kubernetes Service (Amazon EKS). With this deployment option, you can focus on running analytics workloads while Amazon EMR on EKS builds, configures, and manages containers for open-source applications. For more information about Amazon EMR on EKS concepts and tasks, see <a href="https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/emr-eks.html">What is Amazon EMR on EKS</a>.</p> <p> <i>Amazon EMR containers</i> is the API name for Amazon EMR on EKS. The <code>emr-containers</code> prefix is used in the following scenarios: </p> <ul> <li> <p>It is the prefix in the CLI commands for Amazon EMR on EKS. For example, <code>aws emr-containers start-job-run</code>.</p> </li> <li> <p>It is the prefix before IAM policy actions for Amazon EMR on EKS. For example, <code>"Action": [ "emr-containers:StartJobRun"]</code>. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-actions">Policy actions for Amazon EMR on EKS</a>.</p> </li> <li> <p>It is the prefix used in Amazon EMR on EKS service endpoints. For example, <code>emr-containers.us-east-2.amazonaws.com</code>. For more information, see <a href="https://docs.aws.amazon.com/emr/latest/EMR-on-EKS-DevelopmentGuide/service-quotas.html#service-endpoints">Amazon EMR on EKSService Endpoints</a>.</p> </li> </ul>', 'operations' => [ 'CancelJobRun' => '<p>Cancels a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.</p>', 'CreateJobTemplate' => '<p>Creates a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.</p>', 'CreateManagedEndpoint' => '<p>Creates a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.</p>', 'CreateSecurityConfiguration' => '<p>Creates a security configuration. Security configurations in Amazon EMR on EKS are templates for different security setups. You can use security configurations to configure the Lake Formation integration setup. You can also create a security configuration to re-use a security setup each time you create a virtual cluster.</p>', 'CreateVirtualCluster' => '<p>Creates a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.</p>', 'DeleteJobTemplate' => '<p>Deletes a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.</p>', 'DeleteManagedEndpoint' => '<p>Deletes a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.</p>', 'DeleteVirtualCluster' => '<p>Deletes a virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.</p>', 'DescribeJobRun' => '<p>Displays detailed information about a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.</p>', 'DescribeJobTemplate' => '<p>Displays detailed information about a specified job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.</p>', 'DescribeManagedEndpoint' => '<p>Displays detailed information about a managed endpoint. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.</p>', 'DescribeSecurityConfiguration' => '<p>Displays detailed information about a specified security configuration. Security configurations in Amazon EMR on EKS are templates for different security setups. You can use security configurations to configure the Lake Formation integration setup. You can also create a security configuration to re-use a security setup each time you create a virtual cluster.</p>', 'DescribeVirtualCluster' => '<p>Displays detailed information about a specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.</p>', 'GetManagedEndpointSessionCredentials' => '<p>Generate a session token to connect to a managed endpoint. </p>', 'ListJobRuns' => '<p>Lists job runs based on a set of parameters. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.</p>', 'ListJobTemplates' => '<p>Lists job templates based on a set of parameters. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.</p>', 'ListManagedEndpoints' => '<p>Lists managed endpoints based on a set of parameters. A managed endpoint is a gateway that connects Amazon EMR Studio to Amazon EMR on EKS so that Amazon EMR Studio can communicate with your virtual cluster.</p>', 'ListSecurityConfigurations' => '<p>Lists security configurations based on a set of parameters. Security configurations in Amazon EMR on EKS are templates for different security setups. You can use security configurations to configure the Lake Formation integration setup. You can also create a security configuration to re-use a security setup each time you create a virtual cluster.</p>', 'ListTagsForResource' => '<p>Lists the tags assigned to the resources.</p>', 'ListVirtualClusters' => '<p>Lists information about the specified virtual cluster. Virtual cluster is a managed entity on Amazon EMR on EKS. You can create, describe, list and delete virtual clusters. They do not consume any additional resource in your system. A single virtual cluster maps to a single Kubernetes namespace. Given this relationship, you can model virtual clusters the same way you model Kubernetes namespaces to meet your requirements.</p>', 'StartJobRun' => '<p>Starts a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS.</p>', 'TagResource' => '<p>Assigns tags to resources. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value, both of which you define. Tags enable you to categorize your Amazon Web Services resources by attributes such as purpose, owner, or environment. When you have many resources of the same type, you can quickly identify a specific resource based on the tags you\'ve assigned to it. For example, you can define a set of tags for your Amazon EMR on EKS clusters to help you track each cluster\'s owner and stack level. We recommend that you devise a consistent set of tag keys for each resource type. You can then search and filter the resources based on the tags that you add.</p>', 'UntagResource' => '<p>Removes tags from resources.</p>', ], 'shapes' => [ 'ACMCertArn' => [ 'base' => NULL, 'refs' => [ 'Certificate$certificateArn' => '<p>The ARN of the certificate generated for managed endpoint.</p>', 'CreateManagedEndpointRequest$certificateArn' => '<p>The certificate ARN provided by users for the managed endpoint. This field is under deprecation and will be removed in future releases.</p>', 'Endpoint$certificateArn' => '<p>The certificate ARN of the endpoint. This field is under deprecation and will be removed in future.</p>', ], ], 'AuthorizationConfiguration' => [ 'base' => '<p>Authorization-related configuration inputs for the security configuration.</p>', 'refs' => [ 'SecurityConfigurationData$authorizationConfiguration' => '<p>Authorization-related configuration input for the security configuration.</p>', ], ], 'Base64Encoded' => [ 'base' => NULL, 'refs' => [ 'Certificate$certificateData' => '<p>The base64 encoded PEM certificate data generated for managed endpoint.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ListVirtualClustersRequest$eksAccessEntryIntegrated' => '<p>Optional Boolean that specifies whether the operation should return the virtual clusters that have the access entry integration enabled or disabled. If not specified, the operation returns all applicable virtual clusters.</p>', ], ], 'CancelJobRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelJobRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'Certificate' => [ 'base' => '<p>The entity representing certificate data generated for managed endpoint.</p>', 'refs' => [ 'Endpoint$certificateAuthority' => '<p>The certificate generated by emr control plane on customer behalf to secure the managed endpoint.</p>', ], ], 'CertificateProviderType' => [ 'base' => NULL, 'refs' => [ 'TLSCertificateConfiguration$certificateProviderType' => '<p>The TLS certificate type. Acceptable values: <code>PEM</code> or <code>Custom</code>.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateJobTemplateRequest$clientToken' => '<p>The client token of the job template.</p>', 'CreateManagedEndpointRequest$clientToken' => '<p>The client idempotency token for this create call.</p>', 'CreateSecurityConfigurationRequest$clientToken' => '<p>The client idempotency token to use when creating the security configuration.</p>', 'CreateVirtualClusterRequest$clientToken' => '<p>The client token of the virtual cluster.</p>', 'GetManagedEndpointSessionCredentialsRequest$clientToken' => '<p>The client idempotency token of the job run request.</p>', 'JobRun$clientToken' => '<p>The client token used to start a job run.</p>', 'StartJobRunRequest$clientToken' => '<p>The client idempotency token of the job run request. </p>', ], ], 'CloudWatchMonitoringConfiguration' => [ 'base' => '<p>A configuration for CloudWatch monitoring. You can configure your jobs to send log information to CloudWatch Logs.</p>', 'refs' => [ 'MonitoringConfiguration$cloudWatchMonitoringConfiguration' => '<p>Monitoring configurations for CloudWatch.</p>', ], ], 'ClusterId' => [ 'base' => NULL, 'refs' => [ 'ContainerProvider$id' => '<p>The ID of the container cluster.</p>', 'SecureNamespaceInfo$clusterId' => '<p>The ID of the Amazon EKS cluster where Amazon EMR on EKS jobs run.</p>', ], ], 'Configuration' => [ 'base' => '<p>A configuration specification to be used when provisioning virtual clusters, which can include configurations for applications and software bundled with Amazon EMR on EKS. A configuration consists of a classification, properties, and optional nested configurations. A classification refers to an application-specific configuration file. Properties are the settings you want to change in that file.</p>', 'refs' => [ 'ConfigurationList$member' => NULL, ], ], 'ConfigurationList' => [ 'base' => NULL, 'refs' => [ 'Configuration$configurations' => '<p>A list of additional configurations to apply within a configuration object.</p>', 'ConfigurationOverrides$applicationConfiguration' => '<p>The configurations for the application running by the job run. </p>', 'ParametricConfigurationOverrides$applicationConfiguration' => '<p> The configurations for the application running by the job run.</p>', ], ], 'ConfigurationOverrides' => [ 'base' => '<p>A configuration specification to be used to override existing configurations.</p>', 'refs' => [ 'CreateManagedEndpointRequest$configurationOverrides' => '<p>The configuration settings that will be used to override existing configurations.</p>', 'Endpoint$configurationOverrides' => '<p>The configuration settings that are used to override existing configurations for endpoints.</p>', 'JobRun$configurationOverrides' => '<p>The configuration settings that are used to override default configuration.</p>', 'StartJobRunRequest$configurationOverrides' => '<p>The configuration overrides for the job run.</p>', ], ], 'ContainerInfo' => [ 'base' => '<p>The information about the container used for a job run or a managed endpoint.</p>', 'refs' => [ 'ContainerProvider$info' => '<p>The information about the container cluster.</p>', ], ], 'ContainerLogRotationConfiguration' => [ 'base' => '<p>The settings for container log rotation.</p>', 'refs' => [ 'MonitoringConfiguration$containerLogRotationConfiguration' => '<p>Enable or disable container log rotation.</p>', ], ], 'ContainerProvider' => [ 'base' => '<p>The information about the container provider.</p>', 'refs' => [ 'CreateVirtualClusterRequest$containerProvider' => '<p>The container provider of the virtual cluster.</p>', 'VirtualCluster$containerProvider' => '<p>The container provider of the virtual cluster.</p>', ], ], 'ContainerProviderType' => [ 'base' => NULL, 'refs' => [ 'ContainerProvider$type' => '<p>The type of the container provider. Amazon EKS is the only supported type as of now.</p>', 'ListVirtualClustersRequest$containerProviderType' => '<p>The container provider type of the virtual cluster. Amazon EKS is the only supported type as of now.</p>', ], ], 'CreateJobTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateJobTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateManagedEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateManagedEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVirtualClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVirtualClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CredentialType' => [ 'base' => NULL, 'refs' => [ 'GetManagedEndpointSessionCredentialsRequest$credentialType' => '<p>Type of the token requested. Currently supported and default value of this field is “TOKEN.”</p>', ], ], 'Credentials' => [ 'base' => '<p>The structure containing the session token being returned.</p>', 'refs' => [ 'GetManagedEndpointSessionCredentialsResponse$credentials' => '<p>The structure containing the session credentials.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'CreateJobTemplateResponse$createdAt' => '<p>This output displays the date and time when the job template was created.</p>', 'Endpoint$createdAt' => '<p>The date and time when the endpoint was created.</p>', 'GetManagedEndpointSessionCredentialsResponse$expiresAt' => '<p>The date and time when the session token will expire.</p>', 'JobRun$createdAt' => '<p>The date and time when the job run was created.</p>', 'JobRun$finishedAt' => '<p>The date and time when the job run has finished.</p>', 'JobTemplate$createdAt' => '<p> The date and time when the job template was created.</p>', 'ListJobRunsRequest$createdBefore' => '<p>The date and time before which the job runs were submitted.</p>', 'ListJobRunsRequest$createdAfter' => '<p>The date and time after which the job runs were submitted.</p>', 'ListJobTemplatesRequest$createdAfter' => '<p>The date and time after which the job templates were created.</p>', 'ListJobTemplatesRequest$createdBefore' => '<p> The date and time before which the job templates were created.</p>', 'ListManagedEndpointsRequest$createdBefore' => '<p>The date and time before which the endpoints are created.</p>', 'ListManagedEndpointsRequest$createdAfter' => '<p> The date and time after which the endpoints are created.</p>', 'ListSecurityConfigurationsRequest$createdAfter' => '<p>The date and time after which the security configuration was created.</p>', 'ListSecurityConfigurationsRequest$createdBefore' => '<p>The date and time before which the security configuration was created.</p>', 'ListVirtualClustersRequest$createdAfter' => '<p>The date and time after which the virtual clusters are created.</p>', 'ListVirtualClustersRequest$createdBefore' => '<p>The date and time before which the virtual clusters are created.</p>', 'SecurityConfiguration$createdAt' => '<p>The date and time that the job run was created.</p>', 'VirtualCluster$createdAt' => '<p>The date and time when the virtual cluster is created.</p>', ], ], 'DeleteJobTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteJobTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteManagedEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteManagedEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVirtualClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVirtualClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeJobTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeManagedEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeManagedEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSecurityConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVirtualClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVirtualClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'EKSRequestThrottledException' => [ 'base' => '<p>The request exceeded the Amazon EKS API operation limits.</p>', 'refs' => [], ], 'EksInfo' => [ 'base' => '<p>The information about the Amazon EKS cluster.</p>', 'refs' => [ 'ContainerInfo$eksInfo' => '<p>The information about the Amazon EKS cluster.</p>', ], ], 'EncryptionConfiguration' => [ 'base' => '<p>Configurations related to encryption for the security configuration.</p>', 'refs' => [ 'AuthorizationConfiguration$encryptionConfiguration' => '<p>Encryption-related configuration input for the security configuration.</p>', ], ], 'Endpoint' => [ 'base' => '<p>This entity represents the endpoint that is managed by Amazon EMR on EKS.</p>', 'refs' => [ 'DescribeManagedEndpointResponse$endpoint' => '<p>This output displays information about a managed endpoint.</p>', 'Endpoints$member' => NULL, ], ], 'EndpointArn' => [ 'base' => NULL, 'refs' => [ 'CreateManagedEndpointResponse$arn' => '<p>The output contains the ARN of the managed endpoint.</p>', 'Endpoint$arn' => '<p>The ARN of the endpoint.</p>', ], ], 'EndpointState' => [ 'base' => NULL, 'refs' => [ 'Endpoint$state' => '<p>The state of the endpoint.</p>', 'EndpointStates$member' => NULL, ], ], 'EndpointStates' => [ 'base' => NULL, 'refs' => [ 'ListManagedEndpointsRequest$states' => '<p>The states of the managed endpoints.</p>', ], ], 'EndpointType' => [ 'base' => NULL, 'refs' => [ 'CreateManagedEndpointRequest$type' => '<p>The type of the managed endpoint.</p>', 'Endpoint$type' => '<p>The type of the endpoint.</p>', 'EndpointTypes$member' => NULL, ], ], 'EndpointTypes' => [ 'base' => NULL, 'refs' => [ 'ListManagedEndpointsRequest$types' => '<p>The types of the managed endpoints.</p>', ], ], 'Endpoints' => [ 'base' => NULL, 'refs' => [ 'ListManagedEndpointsResponse$endpoints' => '<p>The managed endpoints to be listed.</p>', ], ], 'EntryPointArgument' => [ 'base' => NULL, 'refs' => [ 'EntryPointArguments$member' => NULL, ], ], 'EntryPointArguments' => [ 'base' => NULL, 'refs' => [ 'SparkSubmitJobDriver$entryPointArguments' => '<p>The arguments for job application.</p>', ], ], 'EntryPointPath' => [ 'base' => NULL, 'refs' => [ 'SparkSqlJobDriver$entryPoint' => '<p>The SQL file to be executed.</p>', 'SparkSubmitJobDriver$entryPoint' => '<p>The entry point of job application.</p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'Endpoint$failureReason' => '<p> The reasons why the endpoint has failed. </p>', 'JobRun$failureReason' => '<p>The reasons why the job run has failed.</p>', ], ], 'GetManagedEndpointSessionCredentialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetManagedEndpointSessionCredentialsResponse' => [ 'base' => NULL, 'refs' => [], ], 'IAMRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateManagedEndpointRequest$executionRoleArn' => '<p>The ARN of the execution role.</p>', 'Endpoint$executionRoleArn' => '<p>The execution role ARN of the endpoint.</p>', 'GetManagedEndpointSessionCredentialsRequest$executionRoleArn' => '<p>The IAM Execution Role ARN that will be used by the job run. </p>', 'JobRun$executionRoleArn' => '<p>The execution role ARN of the job run.</p>', 'LakeFormationConfiguration$queryEngineRoleArn' => '<p>The query engine IAM role ARN that is tied to the secure Spark job. The <code>QueryEngine</code> role assumes the <code>JobExecutionRole</code> to execute all the Lake Formation calls.</p>', 'StartJobRunRequest$executionRoleArn' => '<p>The execution role ARN for the job run.</p>', ], ], 'InTransitEncryptionConfiguration' => [ 'base' => '<p>Configurations related to in-transit encryption for the security configuration.</p>', 'refs' => [ 'EncryptionConfiguration$inTransitEncryptionConfiguration' => '<p>In-transit encryption-related input for the security configuration.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>This is an internal server exception.</p>', 'refs' => [], ], 'JavaInteger' => [ 'base' => NULL, 'refs' => [ 'GetManagedEndpointSessionCredentialsRequest$durationInSeconds' => '<p>Duration in seconds for which the session token is valid. The default duration is 15 minutes and the maximum is 12 hours.</p>', 'ListJobRunsRequest$maxResults' => '<p>The maximum number of job runs that can be listed.</p>', 'ListJobTemplatesRequest$maxResults' => '<p> The maximum number of job templates that can be listed.</p>', 'ListManagedEndpointsRequest$maxResults' => '<p>The maximum number of managed endpoints that can be listed.</p>', 'ListSecurityConfigurationsRequest$maxResults' => '<p>The maximum number of security configurations the operation can list.</p>', 'ListVirtualClustersRequest$maxResults' => '<p>The maximum number of virtual clusters that can be listed.</p>', 'RetryPolicyConfiguration$maxAttempts' => '<p>The maximum number of attempts on the job\'s driver.</p>', 'RetryPolicyExecution$currentAttemptCount' => '<p>The current number of attempts made on the driver of the job.</p>', ], ], 'JobArn' => [ 'base' => NULL, 'refs' => [ 'JobRun$arn' => '<p>The ARN of job run.</p>', 'StartJobRunResponse$arn' => '<p>This output lists the ARN of job run.</p>', ], ], 'JobDriver' => [ 'base' => '<p>Specify the driver that the job runs on. Exactly one of the two available job drivers is required, either sparkSqlJobDriver or sparkSubmitJobDriver.</p>', 'refs' => [ 'JobRun$jobDriver' => '<p>Parameters of job driver for the job run.</p>', 'JobTemplateData$jobDriver' => NULL, 'StartJobRunRequest$jobDriver' => '<p>The job driver for the job run.</p>', ], ], 'JobRun' => [ 'base' => '<p>This entity describes a job run. A job run is a unit of work, such as a Spark jar, PySpark script, or SparkSQL query, that you submit to Amazon EMR on EKS. </p>', 'refs' => [ 'DescribeJobRunResponse$jobRun' => '<p>The output displays information about a job run.</p>', 'JobRuns$member' => NULL, ], ], 'JobRunState' => [ 'base' => NULL, 'refs' => [ 'JobRun$state' => '<p>The state of the job run. </p>', 'JobRunStates$member' => NULL, ], ], 'JobRunStates' => [ 'base' => NULL, 'refs' => [ 'ListJobRunsRequest$states' => '<p>The states of the job run.</p>', ], ], 'JobRuns' => [ 'base' => NULL, 'refs' => [ 'ListJobRunsResponse$jobRuns' => '<p>This output lists information about the specified job runs.</p>', ], ], 'JobTemplate' => [ 'base' => '<p>This entity describes a job template. Job template stores values of StartJobRun API request in a template and can be used to start a job run. Job template allows two use cases: avoid repeating recurring StartJobRun API request values, enforcing certain values in StartJobRun API request.</p>', 'refs' => [ 'DescribeJobTemplateResponse$jobTemplate' => '<p>This output displays information about the specified job template.</p>', 'JobTemplates$member' => NULL, ], ], 'JobTemplateArn' => [ 'base' => NULL, 'refs' => [ 'CreateJobTemplateResponse$arn' => '<p>This output display the ARN of the created job template.</p>', 'JobTemplate$arn' => '<p>The ARN of the job template.</p>', ], ], 'JobTemplateData' => [ 'base' => '<p>The values of StartJobRun API requests used in job runs started using the job template.</p>', 'refs' => [ 'CreateJobTemplateRequest$jobTemplateData' => '<p>The job template data which holds values of StartJobRun API request.</p>', 'JobTemplate$jobTemplateData' => '<p>The job template data which holds values of StartJobRun API request.</p>', ], ], 'JobTemplates' => [ 'base' => NULL, 'refs' => [ 'ListJobTemplatesResponse$templates' => '<p>This output lists information about the specified job templates.</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateJobTemplateRequest$kmsKeyArn' => '<p>The KMS key ARN used to encrypt the job template.</p>', 'JobTemplate$kmsKeyArn' => '<p> The KMS key ARN used to encrypt the job template.</p>', ], ], 'KubernetesNamespace' => [ 'base' => NULL, 'refs' => [ 'EksInfo$namespace' => '<p>The namespaces of the Amazon EKS cluster.</p>', 'SecureNamespaceInfo$namespace' => '<p>The namespace of the Amazon EKS cluster where the system jobs run.</p>', ], ], 'LakeFormationConfiguration' => [ 'base' => '<p>Lake Formation related configuration inputs for the security configuration.</p>', 'refs' => [ 'AuthorizationConfiguration$lakeFormationConfiguration' => '<p>Lake Formation related configuration inputs for the security configuration.</p>', ], ], 'ListJobRunsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobRunsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListJobTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListJobTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListManagedEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListManagedEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVirtualClustersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVirtualClustersResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogContext' => [ 'base' => NULL, 'refs' => [ 'GetManagedEndpointSessionCredentialsRequest$logContext' => '<p>String identifier used to separate sections of the execution logs uploaded to S3.</p>', ], ], 'LogGroupName' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMonitoringConfiguration$logGroupName' => '<p>The name of the log group for log publishing.</p>', ], ], 'MaxFilesToKeep' => [ 'base' => NULL, 'refs' => [ 'ContainerLogRotationConfiguration$maxFilesToKeep' => '<p>The number of files to keep in container after rotation.</p>', ], ], 'MonitoringConfiguration' => [ 'base' => '<p>Configuration setting for monitoring.</p>', 'refs' => [ 'ConfigurationOverrides$monitoringConfiguration' => '<p>The configurations for monitoring.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListJobRunsRequest$nextToken' => '<p>The token for the next set of job runs to return.</p>', 'ListJobRunsResponse$nextToken' => '<p>This output displays the token for the next set of job runs.</p>', 'ListJobTemplatesRequest$nextToken' => '<p> The token for the next set of job templates to return.</p>', 'ListJobTemplatesResponse$nextToken' => '<p> This output displays the token for the next set of job templates.</p>', 'ListManagedEndpointsRequest$nextToken' => '<p> The token for the next set of managed endpoints to return. </p>', 'ListManagedEndpointsResponse$nextToken' => '<p> The token for the next set of endpoints to return. </p>', 'ListSecurityConfigurationsRequest$nextToken' => '<p>The token for the next set of security configurations to return.</p>', 'ListSecurityConfigurationsResponse$nextToken' => '<p>The token for the next set of security configurations to return.</p>', 'ListVirtualClustersRequest$nextToken' => '<p>The token for the next set of virtual clusters to return. </p>', 'ListVirtualClustersResponse$nextToken' => '<p>This output displays the token for the next set of virtual clusters.</p>', ], ], 'ParametricCloudWatchMonitoringConfiguration' => [ 'base' => '<p> A configuration for CloudWatch monitoring. You can configure your jobs to send log information to CloudWatch Logs. This data type allows job template parameters to be specified within.</p>', 'refs' => [ 'ParametricMonitoringConfiguration$cloudWatchMonitoringConfiguration' => '<p> Monitoring configurations for CloudWatch.</p>', ], ], 'ParametricConfigurationOverrides' => [ 'base' => '<p> A configuration specification to be used to override existing configurations. This data type allows job template parameters to be specified within.</p>', 'refs' => [ 'JobTemplateData$configurationOverrides' => '<p> The configuration settings that are used to override defaults configuration.</p>', ], ], 'ParametricIAMRoleArn' => [ 'base' => NULL, 'refs' => [ 'JobTemplateData$executionRoleArn' => '<p>The execution role ARN of the job run.</p>', ], ], 'ParametricMonitoringConfiguration' => [ 'base' => '<p> Configuration setting for monitoring. This data type allows job template parameters to be specified within.</p>', 'refs' => [ 'ParametricConfigurationOverrides$monitoringConfiguration' => '<p> The configurations for monitoring. </p>', ], ], 'ParametricReleaseLabel' => [ 'base' => NULL, 'refs' => [ 'JobTemplateData$releaseLabel' => '<p> The release version of Amazon EMR.</p>', ], ], 'ParametricS3MonitoringConfiguration' => [ 'base' => '<p> Amazon S3 configuration for monitoring log publishing. You can configure your jobs to send log information to Amazon S3. This data type allows job template parameters to be specified within.</p>', 'refs' => [ 'ParametricMonitoringConfiguration$s3MonitoringConfiguration' => '<p> Amazon S3 configuration for monitoring log publishing.</p>', ], ], 'PersistentAppUI' => [ 'base' => NULL, 'refs' => [ 'MonitoringConfiguration$persistentAppUI' => '<p>Monitoring configurations for the persistent application UI. </p>', ], ], 'ReleaseLabel' => [ 'base' => NULL, 'refs' => [ 'CreateManagedEndpointRequest$releaseLabel' => '<p>The Amazon EMR release version.</p>', 'Endpoint$releaseLabel' => '<p>The EMR release version to be used for the endpoint.</p>', 'JobRun$releaseLabel' => '<p>The release version of Amazon EMR.</p>', 'StartJobRunRequest$releaseLabel' => '<p>The Amazon EMR release version to use for the job run.</p>', ], ], 'RequestIdentityUserArn' => [ 'base' => NULL, 'refs' => [ 'JobRun$createdBy' => '<p>The user who created the job run.</p>', 'JobTemplate$createdBy' => '<p> The user who created the job template.</p>', 'SecurityConfiguration$createdBy' => '<p>The user who created the job run.</p>', ], ], 'RequestThrottledException' => [ 'base' => '<p>The request throttled.</p>', 'refs' => [], ], 'ResourceIdString' => [ 'base' => NULL, 'refs' => [ 'CancelJobRunRequest$id' => '<p>The ID of the job run to cancel.</p>', 'CancelJobRunRequest$virtualClusterId' => '<p>The ID of the virtual cluster for which the job run will be canceled.</p>', 'CancelJobRunResponse$id' => '<p>The output contains the ID of the cancelled job run.</p>', 'CancelJobRunResponse$virtualClusterId' => '<p>The output contains the virtual cluster ID for which the job run is cancelled.</p>', 'CreateJobTemplateResponse$id' => '<p>This output display the created job template ID.</p>', 'CreateManagedEndpointRequest$virtualClusterId' => '<p>The ID of the virtual cluster for which a managed endpoint is created.</p>', 'CreateManagedEndpointResponse$id' => '<p>The output contains the ID of the managed endpoint.</p>', 'CreateManagedEndpointResponse$virtualClusterId' => '<p>The output contains the ID of the virtual cluster.</p>', 'CreateSecurityConfigurationResponse$id' => '<p>The ID of the security configuration.</p>', 'CreateVirtualClusterRequest$securityConfigurationId' => '<p>The ID of the security configuration.</p>', 'CreateVirtualClusterResponse$id' => '<p>This output contains the virtual cluster ID.</p>', 'DeleteJobTemplateRequest$id' => '<p>The ID of the job template that will be deleted.</p>', 'DeleteJobTemplateResponse$id' => '<p>This output contains the ID of the job template that was deleted.</p>', 'DeleteManagedEndpointRequest$id' => '<p>The ID of the managed endpoint.</p>', 'DeleteManagedEndpointRequest$virtualClusterId' => '<p>The ID of the endpoint\'s virtual cluster.</p>', 'DeleteManagedEndpointResponse$id' => '<p>The output displays the ID of the managed endpoint.</p>', 'DeleteManagedEndpointResponse$virtualClusterId' => '<p>The output displays the ID of the endpoint\'s virtual cluster.</p>', 'DeleteVirtualClusterRequest$id' => '<p>The ID of the virtual cluster that will be deleted.</p>', 'DeleteVirtualClusterResponse$id' => '<p>This output contains the ID of the virtual cluster that will be deleted. </p>', 'DescribeJobRunRequest$id' => '<p>The ID of the job run request. </p>', 'DescribeJobRunRequest$virtualClusterId' => '<p>The ID of the virtual cluster for which the job run is submitted.</p>', 'DescribeJobTemplateRequest$id' => '<p>The ID of the job template that will be described.</p>', 'DescribeManagedEndpointRequest$id' => '<p>This output displays ID of the managed endpoint.</p>', 'DescribeManagedEndpointRequest$virtualClusterId' => '<p>The ID of the endpoint\'s virtual cluster.</p>', 'DescribeSecurityConfigurationRequest$id' => '<p>The ID of the security configuration.</p>', 'DescribeVirtualClusterRequest$id' => '<p>The ID of the virtual cluster that will be described.</p>', 'Endpoint$id' => '<p>The ID of the endpoint.</p>', 'Endpoint$virtualClusterId' => '<p>The ID of the endpoint\'s virtual cluster.</p>', 'GetManagedEndpointSessionCredentialsResponse$id' => '<p>The identifier of the session token returned.</p>', 'JobRun$id' => '<p>The ID of the job run.</p>', 'JobRun$virtualClusterId' => '<p>The ID of the job run\'s virtual cluster.</p>', 'JobTemplate$id' => '<p>The ID of the job template.</p>', 'ListJobRunsRequest$virtualClusterId' => '<p>The ID of the virtual cluster for which to list the job run. </p>', 'ListManagedEndpointsRequest$virtualClusterId' => '<p>The ID of the virtual cluster.</p>', 'SecurityConfiguration$id' => '<p>The ID of the security configuration.</p>', 'StartJobRunRequest$virtualClusterId' => '<p>The virtual cluster ID for which the job run request is submitted.</p>', 'StartJobRunRequest$jobTemplateId' => '<p>The job template ID to be used to start the job run.</p>', 'StartJobRunResponse$id' => '<p>This output displays the started job run ID.</p>', 'StartJobRunResponse$virtualClusterId' => '<p>This output displays the virtual cluster ID for which the job run was submitted.</p>', 'VirtualCluster$id' => '<p>The ID of the virtual cluster.</p>', 'VirtualCluster$securityConfigurationId' => '<p>The ID of the security configuration.</p>', ], ], 'ResourceNameString' => [ 'base' => NULL, 'refs' => [ 'CreateJobTemplateRequest$name' => '<p>The specified name of the job template.</p>', 'CreateJobTemplateResponse$name' => '<p>This output displays the name of the created job template.</p>', 'CreateManagedEndpointRequest$name' => '<p>The name of the managed endpoint.</p>', 'CreateManagedEndpointResponse$name' => '<p>The output contains the name of the managed endpoint.</p>', 'CreateSecurityConfigurationRequest$name' => '<p>The name of the security configuration.</p>', 'CreateSecurityConfigurationResponse$name' => '<p>The name of the security configuration.</p>', 'CreateVirtualClusterRequest$name' => '<p>The specified name of the virtual cluster.</p>', 'CreateVirtualClusterResponse$name' => '<p>This output contains the name of the virtual cluster.</p>', 'Endpoint$name' => '<p>The name of the endpoint.</p>', 'JobRun$name' => '<p>The name of the job run.</p>', 'JobTemplate$name' => '<p>The name of the job template.</p>', 'ListJobRunsRequest$name' => '<p>The name of the job run.</p>', 'SecurityConfiguration$name' => '<p>The name of the security configuration.</p>', 'StartJobRunRequest$name' => '<p>The name of the job run.</p>', 'StartJobRunResponse$name' => '<p>This output displays the name of the started job run.</p>', 'VirtualCluster$name' => '<p>The name of the virtual cluster.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource was not found.</p>', 'refs' => [], ], 'RetryPolicyConfiguration' => [ 'base' => '<p>The configuration of the retry policy that the job runs on.</p>', 'refs' => [ 'JobRun$retryPolicyConfiguration' => '<p>The configuration of the retry policy that the job runs on.</p>', 'StartJobRunRequest$retryPolicyConfiguration' => '<p>The retry policy configuration for the job run.</p>', ], ], 'RetryPolicyExecution' => [ 'base' => '<p>The current status of the retry policy executed on the job.</p>', 'refs' => [ 'JobRun$retryPolicyExecution' => '<p>The current status of the retry policy executed on the job.</p>', ], ], 'RotationSize' => [ 'base' => NULL, 'refs' => [ 'ContainerLogRotationConfiguration$rotationSize' => '<p>The file size at which to rotate logs. Minimum of 2KB, Maximum of 2GB.</p>', ], ], 'RsiArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of tagged resources.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of resources.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of resources.</p>', ], ], 'S3MonitoringConfiguration' => [ 'base' => '<p> Amazon S3 configuration for monitoring log publishing. You can configure your jobs to send log information to Amazon S3.</p>', 'refs' => [ 'MonitoringConfiguration$s3MonitoringConfiguration' => '<p>Amazon S3 configuration for monitoring log publishing.</p>', ], ], 'SecretsManagerArn' => [ 'base' => NULL, 'refs' => [ 'TLSCertificateConfiguration$publicCertificateSecretArn' => '<p>Secrets Manager ARN that contains the public TLS certificate contents, used for communication between the user job and the system job.</p>', 'TLSCertificateConfiguration$privateCertificateSecretArn' => '<p>Secrets Manager ARN that contains the private TLS certificate contents, used for communication between the user job and the system job.</p>', ], ], 'SecureNamespaceInfo' => [ 'base' => '<p>Namespace inputs for the system job.</p>', 'refs' => [ 'LakeFormationConfiguration$secureNamespaceInfo' => '<p>The namespace input of the system job.</p>', ], ], 'SecurityConfiguration' => [ 'base' => '<p>Inputs related to the security configuration. Security configurations in Amazon EMR on EKS are templates for different security setups. You can use security configurations to configure the Lake Formation integration setup. You can also create a security configuration to re-use a security setup each time you create a virtual cluster.</p>', 'refs' => [ 'DescribeSecurityConfigurationResponse$securityConfiguration' => '<p>Details of the security configuration.</p>', 'SecurityConfigurations$member' => NULL, ], ], 'SecurityConfigurationArn' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityConfigurationResponse$arn' => '<p>The ARN (Amazon Resource Name) of the security configuration.</p>', 'SecurityConfiguration$arn' => '<p>The ARN (Amazon Resource Name) of the security configuration.</p>', ], ], 'SecurityConfigurationData' => [ 'base' => '<p>Configurations related to the security configuration for the request.</p>', 'refs' => [ 'CreateSecurityConfigurationRequest$securityConfigurationData' => '<p>Security configuration input for the request.</p>', 'SecurityConfiguration$securityConfigurationData' => '<p>Security configuration inputs for the request.</p>', ], ], 'SecurityConfigurations' => [ 'base' => NULL, 'refs' => [ 'ListSecurityConfigurationsResponse$securityConfigurations' => '<p>The list of returned security configurations.</p>', ], ], 'SensitivePropertiesMap' => [ 'base' => NULL, 'refs' => [ 'Configuration$properties' => '<p>A set of properties specified within a configuration classification.</p>', ], ], 'SessionTagValue' => [ 'base' => NULL, 'refs' => [ 'LakeFormationConfiguration$authorizedSessionTagValue' => '<p>The session tag to authorize Amazon EMR on EKS for API calls to Lake Formation.</p>', ], ], 'SparkSqlJobDriver' => [ 'base' => '<p>The job driver for job type.</p>', 'refs' => [ 'JobDriver$sparkSqlJobDriver' => '<p>The job driver for job type.</p>', ], ], 'SparkSqlParameters' => [ 'base' => NULL, 'refs' => [ 'SparkSqlJobDriver$sparkSqlParameters' => '<p>The Spark parameters to be included in the Spark SQL command.</p>', ], ], 'SparkSubmitJobDriver' => [ 'base' => '<p>The information about job driver for Spark submit.</p>', 'refs' => [ 'JobDriver$sparkSubmitJobDriver' => '<p>The job driver parameters specified for spark submit.</p>', ], ], 'SparkSubmitParameters' => [ 'base' => NULL, 'refs' => [ 'SparkSubmitJobDriver$sparkSubmitParameters' => '<p>The Spark submit parameters that are used for job runs.</p>', ], ], 'StartJobRunRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartJobRunResponse' => [ 'base' => NULL, 'refs' => [], ], 'String1024' => [ 'base' => NULL, 'refs' => [ 'Configuration$classification' => '<p>The classification within a configuration.</p>', 'EKSRequestThrottledException$message' => NULL, 'InternalServerException$message' => NULL, 'ListVirtualClustersRequest$containerProviderId' => '<p>The container provider ID of the virtual cluster.</p>', 'RequestThrottledException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'SensitivePropertiesMap$key' => NULL, 'SensitivePropertiesMap$value' => NULL, 'TemplateParameterConfiguration$defaultValue' => '<p>The default value for the job template parameter.</p>', 'TemplateParameterInputMap$value' => NULL, 'ValidationException$message' => NULL, ], ], 'String128' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'String2048' => [ 'base' => NULL, 'refs' => [ 'GetManagedEndpointSessionCredentialsRequest$endpointIdentifier' => '<p>The ARN of the managed endpoint for which the request is submitted. </p>', 'GetManagedEndpointSessionCredentialsRequest$virtualClusterIdentifier' => '<p>The ARN of the Virtual Cluster which the Managed Endpoint belongs to. </p>', 'JobTemplate$decryptionError' => '<p>The error message in case the decryption of job template fails.</p>', ], ], 'String256' => [ 'base' => NULL, 'refs' => [ 'CloudWatchMonitoringConfiguration$logStreamNamePrefix' => '<p>The specified name prefix for log streams.</p>', 'Endpoint$securityGroup' => '<p>The security group configuration of the endpoint. </p>', 'Endpoint$stateDetails' => '<p> Additional details of the endpoint state. </p>', 'JobRun$stateDetails' => '<p>Additional details of the job run state.</p>', 'ParametricCloudWatchMonitoringConfiguration$logStreamNamePrefix' => '<p> The specified name prefix for log streams.</p>', 'SubnetIds$member' => NULL, ], ], 'StringEmpty256' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'SubnetIds' => [ 'base' => NULL, 'refs' => [ 'Endpoint$subnetIds' => '<p>The subnet IDs of the endpoint. </p>', ], ], 'TLSCertificateConfiguration' => [ 'base' => '<p>Configurations related to the TLS certificate for the security configuration.</p>', 'refs' => [ 'InTransitEncryptionConfiguration$tlsCertificateConfiguration' => '<p>TLS certificate-related configuration input for the security configuration.</p>', ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys of the resources.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateJobTemplateRequest$tags' => '<p>The tags that are associated with the job template.</p>', 'CreateManagedEndpointRequest$tags' => '<p>The tags of the managed endpoint. </p>', 'CreateSecurityConfigurationRequest$tags' => '<p>The tags to add to the security configuration.</p>', 'CreateVirtualClusterRequest$tags' => '<p>The tags assigned to the virtual cluster.</p>', 'Endpoint$tags' => '<p>The tags of the endpoint. </p>', 'JobRun$tags' => '<p>The assigned tags of the job run.</p>', 'JobTemplate$tags' => '<p>The tags assigned to the job template.</p>', 'JobTemplateData$jobTags' => '<p>The tags assigned to jobs started using the job template.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags assigned to resources.</p>', 'SecurityConfiguration$tags' => '<p>The tags to assign to the security configuration.</p>', 'StartJobRunRequest$tags' => '<p>The tags assigned to job runs.</p>', 'TagResourceRequest$tags' => '<p>The tags assigned to resources.</p>', 'VirtualCluster$tags' => '<p>The assigned tags of the virtual cluster.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TemplateParameter' => [ 'base' => NULL, 'refs' => [ 'ParametricCloudWatchMonitoringConfiguration$logGroupName' => '<p> The name of the log group for log publishing.</p>', 'ParametricMonitoringConfiguration$persistentAppUI' => '<p> Monitoring configurations for the persistent application UI.</p>', ], ], 'TemplateParameterConfiguration' => [ 'base' => '<p>The configuration of a job template parameter.</p>', 'refs' => [ 'TemplateParameterConfigurationMap$value' => NULL, ], ], 'TemplateParameterConfigurationMap' => [ 'base' => NULL, 'refs' => [ 'JobTemplateData$parameterConfiguration' => '<p>The configuration of parameters existing in the job template.</p>', ], ], 'TemplateParameterDataType' => [ 'base' => NULL, 'refs' => [ 'TemplateParameterConfiguration$type' => '<p>The type of the job template parameter. Allowed values are: ‘STRING’, ‘NUMBER’.</p>', ], ], 'TemplateParameterInputMap' => [ 'base' => NULL, 'refs' => [ 'StartJobRunRequest$jobTemplateParameters' => '<p>The values of job template parameters to start a job run.</p>', ], ], 'TemplateParameterName' => [ 'base' => NULL, 'refs' => [ 'TemplateParameterConfigurationMap$key' => NULL, 'TemplateParameterInputMap$key' => NULL, ], ], 'Token' => [ 'base' => NULL, 'refs' => [ 'Credentials$token' => '<p>The actual session token being returned.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UriString' => [ 'base' => NULL, 'refs' => [ 'Endpoint$serverUrl' => '<p>The server URL of the endpoint.</p>', 'ParametricS3MonitoringConfiguration$logUri' => '<p>Amazon S3 destination URI for log publishing.</p>', 'S3MonitoringConfiguration$logUri' => '<p>Amazon S3 destination URI for log publishing.</p>', ], ], 'ValidationException' => [ 'base' => '<p>There are invalid parameters in the client request.</p>', 'refs' => [], ], 'VirtualCluster' => [ 'base' => '<p>This entity describes a virtual cluster. A virtual cluster is a Kubernetes namespace that Amazon EMR is registered with. Amazon EMR uses virtual clusters to run jobs and host endpoints. Multiple virtual clusters can be backed by the same physical cluster. However, each virtual cluster maps to one namespace on an Amazon EKS cluster. Virtual clusters do not create any active resources that contribute to your bill or that require lifecycle management outside the service.</p>', 'refs' => [ 'DescribeVirtualClusterResponse$virtualCluster' => '<p>This output displays information about the specified virtual cluster.</p>', 'VirtualClusters$member' => NULL, ], ], 'VirtualClusterArn' => [ 'base' => NULL, 'refs' => [ 'CreateVirtualClusterResponse$arn' => '<p>This output contains the ARN of virtual cluster.</p>', 'VirtualCluster$arn' => '<p>The ARN of the virtual cluster.</p>', ], ], 'VirtualClusterState' => [ 'base' => NULL, 'refs' => [ 'VirtualCluster$state' => '<p>The state of the virtual cluster.</p>', 'VirtualClusterStates$member' => NULL, ], ], 'VirtualClusterStates' => [ 'base' => NULL, 'refs' => [ 'ListVirtualClustersRequest$states' => '<p>The states of the requested virtual clusters.</p>', ], ], 'VirtualClusters' => [ 'base' => NULL, 'refs' => [ 'ListVirtualClustersResponse$virtualClusters' => '<p>This output lists the specified virtual clusters.</p>', ], ], ],];
