<?php
// This file was auto-generated from sdk-root/src/data/entityresolution/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Welcome to the <i>Entity Resolution API Reference</i>.</p> <p>Entity Resolution is an Amazon Web Services service that provides pre-configured entity resolution capabilities that enable developers and analysts at advertising and marketing companies to build an accurate and complete view of their consumers.</p> <p> With Entity Resolution, you can match source records containing consumer identifiers, such as name, email address, and phone number. This is true even when these records have incomplete or conflicting identifiers. For example, Entity Resolution can effectively match a source record from a customer relationship management (CRM) system with a source record from a marketing system containing campaign information.</p> <p>To learn more about Entity Resolution concepts, procedures, and best practices, see the <a href="https://docs.aws.amazon.com/entityresolution/latest/userguide/what-is-service.html">Entity Resolution User Guide</a>.</p>', 'operations' => [ 'AddPolicyStatement' => '<p>Adds a policy statement object. To retrieve a list of existing policy statements, use the <code>GetPolicy</code> API.</p>', 'BatchDeleteUniqueId' => '<p>Deletes multiple unique IDs in a matching workflow.</p>', 'CreateIdMappingWorkflow' => '<p>Creates an <code>IdMappingWorkflow</code> object which stores the configuration of the data processing job to be run. Each <code>IdMappingWorkflow</code> must have a unique workflow name. To modify an existing workflow, use the <code>UpdateIdMappingWorkflow</code> API.</p>', 'CreateIdNamespace' => '<p>Creates an ID namespace object which will help customers provide metadata explaining their dataset and how to use it. Each ID namespace must have a unique name. To modify an existing ID namespace, use the <code>UpdateIdNamespace</code> API.</p>', 'CreateMatchingWorkflow' => '<p>Creates a <code>MatchingWorkflow</code> object which stores the configuration of the data processing job to be run. It is important to note that there should not be a pre-existing <code>MatchingWorkflow</code> with the same name. To modify an existing workflow, utilize the <code>UpdateMatchingWorkflow</code> API.</p>', 'CreateSchemaMapping' => '<p>Creates a schema mapping, which defines the schema of the input customer records table. The <code>SchemaMapping</code> also provides Entity Resolution with some metadata about the table, such as the attribute types of the columns and which columns to match on.</p>', 'DeleteIdMappingWorkflow' => '<p>Deletes the <code>IdMappingWorkflow</code> with a given name. This operation will succeed even if a workflow with the given name does not exist.</p>', 'DeleteIdNamespace' => '<p>Deletes the <code>IdNamespace</code> with a given name.</p>', 'DeleteMatchingWorkflow' => '<p>Deletes the <code>MatchingWorkflow</code> with a given name. This operation will succeed even if a workflow with the given name does not exist.</p>', 'DeletePolicyStatement' => '<p>Deletes the policy statement.</p>', 'DeleteSchemaMapping' => '<p>Deletes the <code>SchemaMapping</code> with a given name. This operation will succeed even if a schema with the given name does not exist. This operation will fail if there is a <code>MatchingWorkflow</code> object that references the <code>SchemaMapping</code> in the workflow\'s <code>InputSourceConfig</code>.</p>', 'GetIdMappingJob' => '<p>Gets the status, metrics, and errors (if there are any) that are associated with a job.</p>', 'GetIdMappingWorkflow' => '<p>Returns the <code>IdMappingWorkflow</code> with a given name, if it exists.</p>', 'GetIdNamespace' => '<p>Returns the <code>IdNamespace</code> with a given name, if it exists.</p>', 'GetMatchId' => '<p>Returns the corresponding Match ID of a customer record if the record has been processed.</p>', 'GetMatchingJob' => '<p>Gets the status, metrics, and errors (if there are any) that are associated with a job.</p>', 'GetMatchingWorkflow' => '<p>Returns the <code>MatchingWorkflow</code> with a given name, if it exists.</p>', 'GetPolicy' => '<p>Returns the resource-based policy.</p>', 'GetProviderService' => '<p>Returns the <code>ProviderService</code> of a given name.</p>', 'GetSchemaMapping' => '<p>Returns the SchemaMapping of a given name.</p>', 'ListIdMappingJobs' => '<p>Lists all ID mapping jobs for a given workflow.</p>', 'ListIdMappingWorkflows' => '<p>Returns a list of all the <code>IdMappingWorkflows</code> that have been created for an Amazon Web Services account.</p>', 'ListIdNamespaces' => '<p>Returns a list of all ID namespaces.</p>', 'ListMatchingJobs' => '<p>Lists all jobs for a given workflow.</p>', 'ListMatchingWorkflows' => '<p>Returns a list of all the <code>MatchingWorkflows</code> that have been created for an Amazon Web Services account.</p>', 'ListProviderServices' => '<p>Returns a list of all the <code>ProviderServices</code> that are available in this Amazon Web Services Region.</p>', 'ListSchemaMappings' => '<p>Returns a list of all the <code>SchemaMappings</code> that have been created for an Amazon Web Services account.</p>', 'ListTagsForResource' => '<p>Displays the tags associated with an Entity Resolution resource. In Entity Resolution, <code>SchemaMapping</code>, and <code>MatchingWorkflow</code> can be tagged.</p>', 'PutPolicy' => '<p>Updates the resource-based policy.</p>', 'StartIdMappingJob' => '<p>Starts the <code>IdMappingJob</code> of a workflow. The workflow must have previously been created using the <code>CreateIdMappingWorkflow</code> endpoint.</p>', 'StartMatchingJob' => '<p>Starts the <code>MatchingJob</code> of a workflow. The workflow must have previously been created using the <code>CreateMatchingWorkflow</code> endpoint.</p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified Entity Resolution resource. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. In Entity Resolution, <code>SchemaMapping</code> and <code>MatchingWorkflow</code> can be tagged. Tags don\'t have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters. You can use the <code>TagResource</code> action with a resource that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.</p>', 'UntagResource' => '<p>Removes one or more tags from the specified Entity Resolution resource. In Entity Resolution, <code>SchemaMapping</code>, and <code>MatchingWorkflow</code> can be tagged.</p>', 'UpdateIdMappingWorkflow' => '<p>Updates an existing <code>IdMappingWorkflow</code>. This method is identical to <code>CreateIdMappingWorkflow</code>, except it uses an HTTP <code>PUT</code> request instead of a <code>POST</code> request, and the <code>IdMappingWorkflow</code> must already exist for the method to succeed.</p>', 'UpdateIdNamespace' => '<p>Updates an existing ID namespace.</p>', 'UpdateMatchingWorkflow' => '<p>Updates an existing <code>MatchingWorkflow</code>. This method is identical to <code>CreateMatchingWorkflow</code>, except it uses an HTTP <code>PUT</code> request instead of a <code>POST</code> request, and the <code>MatchingWorkflow</code> must already exist for the method to succeed.</p>', 'UpdateSchemaMapping' => '<p>Updates a schema mapping.</p> <note> <p>A schema is immutable if it is being used by a workflow. Therefore, you can\'t update a schema mapping if it\'s associated with a workflow. </p> </note>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action. </p>', 'refs' => [], ], 'AddPolicyStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'AddPolicyStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'AttributeMatchingModel' => [ 'base' => NULL, 'refs' => [ 'IdMappingRuleBasedProperties$attributeMatchingModel' => '<p>The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the <code>attributeMatchingModel</code>. </p> <p>If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the value of the <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code> attribute type. </p> <p>If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.</p>', 'NamespaceRuleBasedProperties$attributeMatchingModel' => '<p>The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the <code>attributeMatchingModel</code>. </p> <p>If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an attribute type. For example, if the value of the <code>Email</code> field of Profile A matches the value of <code>BusinessEmail</code> field of Profile B, the two profiles are matched on the <code>Email</code> attribute type. </p> <p>If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.</p>', 'RuleBasedProperties$attributeMatchingModel' => '<p>The comparison type. You can either choose <code>ONE_TO_ONE</code> or <code>MANY_TO_MANY</code> as the <code>attributeMatchingModel</code>. </p> <p>If you choose <code>MANY_TO_MANY</code>, the system can match attributes across the sub-types of an attribute type. For example, if the value of the <code>Email</code> field of Profile A and the value of <code>BusinessEmail</code> field of Profile B matches, the two profiles are matched on the <code>Email</code> attribute type. </p> <p>If you choose <code>ONE_TO_ONE</code>, the system can only match attributes if the sub-types are an exact match. For example, for the <code>Email</code> attribute type, the system will only consider it a match if the value of the <code>Email</code> field of Profile A matches the value of the <code>Email</code> field of Profile B.</p>', ], ], 'AttributeName' => [ 'base' => NULL, 'refs' => [ 'OutputAttribute$name' => '<p>A name of a column to be written to the output. This must be an <code>InputField</code> name in the schema mapping.</p>', 'ProviderSchemaAttribute$fieldName' => '<p>The field name.</p>', 'ProviderSchemaAttribute$subType' => '<p>The sub type of the provider schema attribute.</p>', 'RuleMatchingKeysList$member' => NULL, 'SchemaInputAttribute$fieldName' => '<p>A string containing the field name.</p>', 'SchemaInputAttribute$groupName' => '<p>A string that instructs Entity Resolution to combine several columns into a unified column with the identical attribute type. </p> <p>For example, when working with columns such as <code>first_name</code>, <code>middle_name</code>, and <code>last_name</code>, assigning them a common <code>groupName</code> will prompt Entity Resolution to concatenate them into a single value.</p>', 'SchemaInputAttribute$matchKey' => '<p>A key that allows grouping of multiple input attributes into a unified matching group. </p> <p>For example, consider a scenario where the source table contains various addresses, such as <code>business_address</code> and <code>shipping_address</code>. By assigning a <code>matchKey</code> called <code>address</code> to both attributes, Entity Resolution will match records across these fields to create a consolidated matching group.</p> <p>If no <code>matchKey</code> is specified for a column, it won\'t be utilized for matching purposes but will still be included in the output table.</p>', 'SchemaInputAttribute$subType' => '<p>The subtype of the attribute, selected from a list of values.</p>', ], ], 'AwsAccountId' => [ 'base' => NULL, 'refs' => [ 'AwsAccountIdList$member' => NULL, ], ], 'AwsAccountIdList' => [ 'base' => NULL, 'refs' => [ 'ProviderIntermediateDataAccessConfiguration$awsAccountIds' => '<p>The Amazon Web Services account that provider can use to read or write data into the customer\'s intermediate S3 bucket.</p>', ], ], 'BatchDeleteUniqueIdInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchDeleteUniqueIdInputInputSourceString' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteUniqueIdInput$inputSource' => '<p>The input source for the batch delete unique ID operation.</p>', ], ], 'BatchDeleteUniqueIdOutput' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'GetMatchIdInput$applyNormalization' => '<p>Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an <code>AttributeType</code> of <code>PHONE_NUMBER</code>, and the data in the input table is in a format of 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.</p>', 'GetProviderServiceOutput$anonymizedOutput' => '<p>Specifies whether output data from the provider is anonymized. A value of <code>TRUE</code> means the output will be anonymized and you can\'t relate the data that comes back from the provider to the identifying input. A value of <code>FALSE</code> means the output won\'t be anonymized and you can relate the data that comes back from the provider to your source data. </p>', 'GetSchemaMappingOutput$hasWorkflows' => '<p>Specifies whether the schema mapping has been applied to a workflow.</p>', 'InputSource$applyNormalization' => '<p>Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an <code>AttributeType</code> of <code>PHONE_NUMBER</code>, and the data in the input table is in a format of 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.</p>', 'OutputAttribute$hashed' => '<p>Enables the ability to hash the column values in the output.</p>', 'OutputSource$applyNormalization' => '<p>Normalizes the attributes defined in the schema in the input data. For example, if an attribute has an <code>AttributeType</code> of <code>PHONE_NUMBER</code>, and the data in the input table is in a format of 1234567890, Entity Resolution will normalize this field in the output to (123)-456-7890.</p>', 'ProviderSchemaAttribute$hashing' => '<p>The hashing attribute of the provider schema.</p>', 'SchemaInputAttribute$hashed' => '<p> Indicates if the column values are hashed in the schema input. If the value is set to <code>TRUE</code>, the column values are hashed. If the value is set to <code>FALSE</code>, the column values are cleartext.</p>', 'SchemaMappingSummary$hasWorkflows' => '<p>Specifies whether the schema mapping has been applied to a workflow.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request could not be processed because of conflict in the current state of the resource. Example: Workflow already exists, Schema already exists, Workflow is currently running, etc. </p>', 'refs' => [], ], 'CreateIdMappingWorkflowInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateIdMappingWorkflowOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateIdNamespaceInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateIdNamespaceOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMatchingWorkflowInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMatchingWorkflowOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSchemaMappingInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateSchemaMappingOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIdMappingWorkflowInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIdMappingWorkflowOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIdNamespaceInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteIdNamespaceOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMatchingWorkflowInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMatchingWorkflowOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyStatementInput' => [ 'base' => NULL, 'refs' => [], ], 'DeletePolicyStatementOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSchemaMappingInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSchemaMappingOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUniqueIdError' => [ 'base' => '<p>The Delete Unique Id error.</p>', 'refs' => [ 'DeleteUniqueIdErrorsList$member' => NULL, ], ], 'DeleteUniqueIdErrorType' => [ 'base' => NULL, 'refs' => [ 'DeleteUniqueIdError$errorType' => '<p> The error type for the batch delete unique ID operation.</p>', ], ], 'DeleteUniqueIdErrorsList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteUniqueIdOutput$errors' => '<p> The errors from deleting multiple unique IDs.</p>', ], ], 'DeleteUniqueIdStatus' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteUniqueIdOutput$status' => '<p>The status of the batch delete unique ID operation.</p>', ], ], 'DeletedUniqueId' => [ 'base' => '<p>The deleted unique ID.</p>', 'refs' => [ 'DeletedUniqueIdList$member' => NULL, ], ], 'DeletedUniqueIdList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteUniqueIdOutput$deleted' => '<p>The unique IDs that were deleted.</p>', ], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateIdMappingWorkflowInput$description' => '<p>A description of the workflow.</p>', 'CreateIdMappingWorkflowOutput$description' => '<p>A description of the workflow.</p>', 'CreateIdNamespaceInput$description' => '<p>The description of the ID namespace.</p>', 'CreateIdNamespaceOutput$description' => '<p>The description of the ID namespace.</p>', 'CreateMatchingWorkflowInput$description' => '<p>A description of the workflow.</p>', 'CreateMatchingWorkflowOutput$description' => '<p>A description of the workflow.</p>', 'CreateSchemaMappingInput$description' => '<p>A description of the schema.</p>', 'CreateSchemaMappingOutput$description' => '<p>A description of the schema.</p>', 'GetIdMappingWorkflowOutput$description' => '<p>A description of the workflow.</p>', 'GetIdNamespaceOutput$description' => '<p>The description of the ID namespace.</p>', 'GetMatchingWorkflowOutput$description' => '<p>A description of the workflow.</p>', 'GetSchemaMappingOutput$description' => '<p>A description of the schema.</p>', 'IdNamespaceSummary$description' => '<p>The description of the ID namespace.</p>', 'UpdateIdMappingWorkflowInput$description' => '<p>A description of the workflow.</p>', 'UpdateIdMappingWorkflowOutput$description' => '<p>A description of the workflow.</p>', 'UpdateIdNamespaceInput$description' => '<p>The description of the ID namespace.</p>', 'UpdateIdNamespaceOutput$description' => '<p>The description of the ID namespace.</p>', 'UpdateMatchingWorkflowInput$description' => '<p>A description of the workflow.</p>', 'UpdateMatchingWorkflowOutput$description' => '<p>A description of the workflow.</p>', 'UpdateSchemaMappingInput$description' => '<p>A description of the schema.</p>', 'UpdateSchemaMappingOutput$description' => '<p>A description of the schema.</p>', ], ], 'DisconnectedUniqueIdsList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteUniqueIdOutput$disconnectedUniqueIds' => '<p>The unique IDs that were disconnected.</p>', ], ], 'Document' => [ 'base' => NULL, 'refs' => [ 'GetProviderServiceOutput$providerConfigurationDefinition' => '<p>The definition of the provider configuration.</p>', 'GetProviderServiceOutput$providerEntityOutputDefinition' => '<p>The definition of the provider entity output.</p>', 'GetProviderServiceOutput$providerJobConfiguration' => '<p>Provider service job configurations.</p>', 'NamespaceProviderProperties$providerConfiguration' => '<p>An object which defines any additional configurations required by the provider service.</p>', 'ProviderIdNameSpaceConfiguration$providerSourceConfigurationDefinition' => '<p>Configurations required for the source ID namespace.</p>', 'ProviderIdNameSpaceConfiguration$providerTargetConfigurationDefinition' => '<p>Configurations required for the target ID namespace.</p>', 'ProviderProperties$providerConfiguration' => '<p>The required configuration fields to use with the provider service.</p>', ], ], 'EntityName' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteUniqueIdInput$workflowName' => '<p>The name of the workflow.</p>', 'CreateIdMappingWorkflowInput$workflowName' => '<p>The name of the workflow. There can\'t be multiple <code>IdMappingWorkflows</code> with the same name.</p>', 'CreateIdMappingWorkflowOutput$workflowName' => '<p>The name of the workflow.</p>', 'CreateIdNamespaceInput$idNamespaceName' => '<p>The name of the ID namespace.</p>', 'CreateIdNamespaceOutput$idNamespaceName' => '<p>The name of the ID namespace.</p>', 'CreateMatchingWorkflowInput$workflowName' => '<p>The name of the workflow. There can\'t be multiple <code>MatchingWorkflows</code> with the same name.</p>', 'CreateMatchingWorkflowOutput$workflowName' => '<p>The name of the workflow.</p>', 'CreateSchemaMappingInput$schemaName' => '<p>The name of the schema. There can\'t be multiple <code>SchemaMappings</code> with the same name.</p>', 'CreateSchemaMappingOutput$schemaName' => '<p>The name of the schema.</p>', 'DeleteIdMappingWorkflowInput$workflowName' => '<p>The name of the workflow to be deleted.</p>', 'DeleteIdNamespaceInput$idNamespaceName' => '<p>The name of the ID namespace.</p>', 'DeleteMatchingWorkflowInput$workflowName' => '<p>The name of the workflow to be retrieved.</p>', 'DeleteSchemaMappingInput$schemaName' => '<p>The name of the schema to delete.</p>', 'GetIdMappingWorkflowInput$workflowName' => '<p>The name of the workflow.</p>', 'GetIdMappingWorkflowOutput$workflowName' => '<p>The name of the workflow.</p>', 'GetIdNamespaceOutput$idNamespaceName' => '<p>The name of the ID namespace.</p>', 'GetMatchIdInput$workflowName' => '<p>The name of the workflow.</p>', 'GetMatchingJobInput$workflowName' => '<p>The name of the workflow.</p>', 'GetMatchingWorkflowInput$workflowName' => '<p>The name of the workflow.</p>', 'GetMatchingWorkflowOutput$workflowName' => '<p>The name of the workflow.</p>', 'GetProviderServiceInput$providerName' => '<p>The name of the provider. This name is typically the company name.</p>', 'GetProviderServiceOutput$providerName' => '<p>The name of the provider. This name is typically the company name.</p>', 'GetProviderServiceOutput$providerServiceName' => '<p>The name of the product that the provider service provides. </p>', 'GetSchemaMappingInput$schemaName' => '<p>The name of the schema to be retrieved.</p>', 'GetSchemaMappingOutput$schemaName' => '<p>The name of the schema.</p>', 'IdMappingWorkflowInputSource$schemaName' => '<p>The name of the schema to be retrieved.</p>', 'IdMappingWorkflowSummary$workflowName' => '<p>The name of the workflow.</p>', 'IdNamespaceInputSource$schemaName' => '<p>The name of the schema.</p>', 'IdNamespaceSummary$idNamespaceName' => '<p>The name of the ID namespace.</p>', 'InputSource$schemaName' => '<p>The name of the schema to be retrieved.</p>', 'ListMatchingJobsInput$workflowName' => '<p>The name of the workflow to be retrieved.</p>', 'ListProviderServicesInput$providerName' => '<p>The name of the provider. This name is typically the company name.</p>', 'MatchingWorkflowSummary$workflowName' => '<p>The name of the workflow.</p>', 'ProviderServiceSummary$providerName' => '<p>The name of the provider. This name is typically the company name.</p>', 'ProviderServiceSummary$providerServiceName' => '<p>The name of the product that the provider service provides.</p>', 'SchemaMappingSummary$schemaName' => '<p>The name of the schema.</p>', 'StartMatchingJobInput$workflowName' => '<p>The name of the matching job to be retrieved.</p>', 'UpdateIdMappingWorkflowInput$workflowName' => '<p>The name of the workflow.</p>', 'UpdateIdMappingWorkflowOutput$workflowName' => '<p>The name of the workflow.</p>', 'UpdateIdNamespaceInput$idNamespaceName' => '<p>The name of the ID namespace.</p>', 'UpdateIdNamespaceOutput$idNamespaceName' => '<p>The name of the ID namespace.</p>', 'UpdateMatchingWorkflowInput$workflowName' => '<p>The name of the workflow to be retrieved.</p>', 'UpdateMatchingWorkflowOutput$workflowName' => '<p>The name of the workflow.</p>', 'UpdateSchemaMappingInput$schemaName' => '<p>The name of the schema. There can\'t be multiple <code>SchemaMappings</code> with the same name.</p>', 'UpdateSchemaMappingOutput$schemaName' => '<p>The name of the schema.</p>', ], ], 'EntityNameOrIdMappingWorkflowArn' => [ 'base' => NULL, 'refs' => [ 'GetIdMappingJobInput$workflowName' => '<p>The name of the workflow.</p>', 'ListIdMappingJobsInput$workflowName' => '<p>The name of the workflow to be retrieved.</p>', 'StartIdMappingJobInput$workflowName' => '<p>The name of the ID mapping job to be retrieved.</p>', ], ], 'EntityNameOrIdNamespaceArn' => [ 'base' => NULL, 'refs' => [ 'GetIdNamespaceInput$idNamespaceName' => '<p>The name of the ID namespace.</p>', ], ], 'ErrorDetails' => [ 'base' => '<p>An object containing an error message, if there was an error.</p>', 'refs' => [ 'GetIdMappingJobOutput$errorDetails' => NULL, 'GetMatchingJobOutput$errorDetails' => '<p>An object containing an error message, if there was an error.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'ErrorDetails$errorMessage' => '<p>The error message from the job, if there is one.</p>', 'ExceedsLimitException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'ExceedsLimitException' => [ 'base' => '<p>The request was rejected because it attempted to create resources beyond the current Entity Resolution account limits. The error message describes the limit exceeded. </p>', 'refs' => [], ], 'GetIdMappingJobInput' => [ 'base' => NULL, 'refs' => [], ], 'GetIdMappingJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetIdMappingWorkflowInput' => [ 'base' => NULL, 'refs' => [], ], 'GetIdMappingWorkflowOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetIdNamespaceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetIdNamespaceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMatchIdInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMatchIdOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMatchingJobInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMatchingJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMatchingWorkflowInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMatchingWorkflowOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'GetPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetProviderServiceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetProviderServiceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetSchemaMappingInput' => [ 'base' => NULL, 'refs' => [], ], 'GetSchemaMappingOutput' => [ 'base' => NULL, 'refs' => [], ], 'IdMappingJobMetrics' => [ 'base' => '<p>An object containing <code>InputRecords</code>, <code>RecordsNotProcessed</code>, <code>TotalRecordsProcessed</code>, <code>TotalMappedRecords</code>, <code>TotalMappedSourceRecords</code>, and <code>TotalMappedTargetRecords</code>.</p>', 'refs' => [ 'GetIdMappingJobOutput$metrics' => '<p>Metrics associated with the execution, specifically total records processed, unique IDs generated, and records the execution skipped.</p>', ], ], 'IdMappingJobOutputSource' => [ 'base' => '<p>An object containing <code>KMSArn</code>, <code>OutputS3Path</code>, and <code>RoleARN</code>.</p>', 'refs' => [ 'IdMappingJobOutputSourceConfig$member' => NULL, ], ], 'IdMappingJobOutputSourceConfig' => [ 'base' => NULL, 'refs' => [ 'GetIdMappingJobOutput$outputSourceConfig' => '<p>A list of <code>OutputSource</code> objects.</p>', 'StartIdMappingJobInput$outputSourceConfig' => '<p>A list of <code>OutputSource</code> objects.</p>', 'StartIdMappingJobOutput$outputSourceConfig' => '<p>A list of <code>OutputSource</code> objects.</p>', ], ], 'IdMappingRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateIdMappingWorkflowInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.</p>', 'CreateIdMappingWorkflowOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.</p>', 'GetIdMappingWorkflowOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access Amazon Web Services resources on your behalf.</p>', 'UpdateIdMappingWorkflowInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access Amazon Web Services resources on your behalf.</p>', 'UpdateIdMappingWorkflowOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access Amazon Web Services resources on your behalf.</p>', ], ], 'IdMappingRuleBasedProperties' => [ 'base' => '<p> An object that defines the list of matching rules to run in an ID mapping workflow.</p>', 'refs' => [ 'IdMappingTechniques$ruleBasedProperties' => '<p> An object which defines any additional configurations required by rule-based matching.</p>', ], ], 'IdMappingRuleBasedPropertiesRulesList' => [ 'base' => NULL, 'refs' => [ 'IdMappingRuleBasedProperties$rules' => '<p> The rules that can be used for ID mapping.</p>', ], ], 'IdMappingTechniques' => [ 'base' => '<p>An object which defines the ID mapping technique and any additional configurations.</p>', 'refs' => [ 'CreateIdMappingWorkflowInput$idMappingTechniques' => '<p>An object which defines the ID mapping technique and any additional configurations.</p>', 'CreateIdMappingWorkflowOutput$idMappingTechniques' => '<p>An object which defines the ID mapping technique and any additional configurations.</p>', 'GetIdMappingWorkflowOutput$idMappingTechniques' => '<p>An object which defines the ID mapping technique and any additional configurations.</p>', 'UpdateIdMappingWorkflowInput$idMappingTechniques' => '<p>An object which defines the ID mapping technique and any additional configurations.</p>', 'UpdateIdMappingWorkflowOutput$idMappingTechniques' => '<p>An object which defines the ID mapping technique and any additional configurations.</p>', ], ], 'IdMappingType' => [ 'base' => NULL, 'refs' => [ 'IdMappingTechniques$idMappingType' => '<p>The type of ID mapping.</p>', 'IdNamespaceIdMappingWorkflowMetadata$idMappingType' => '<p>The type of ID mapping.</p>', 'IdNamespaceIdMappingWorkflowProperties$idMappingType' => '<p>The type of ID mapping.</p>', ], ], 'IdMappingWorkflowArn' => [ 'base' => NULL, 'refs' => [ 'CreateIdMappingWorkflowOutput$workflowArn' => '<p>The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>IDMappingWorkflow</code>.</p>', 'GetIdMappingWorkflowOutput$workflowArn' => '<p>The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>IdMappingWorkflow</code> .</p>', 'IdMappingWorkflowSummary$workflowArn' => '<p>The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>IdMappingWorkflow</code>.</p>', 'UpdateIdMappingWorkflowOutput$workflowArn' => '<p>The Amazon Resource Name (ARN) of the workflow role. Entity Resolution assumes this role to access Amazon Web Services resources on your behalf.</p>', ], ], 'IdMappingWorkflowInputSource' => [ 'base' => '<p>An object containing <code>InputSourceARN</code>, <code>SchemaName</code>, and <code>Type</code>.</p>', 'refs' => [ 'IdMappingWorkflowInputSourceConfig$member' => NULL, ], ], 'IdMappingWorkflowInputSourceConfig' => [ 'base' => NULL, 'refs' => [ 'CreateIdMappingWorkflowInput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'CreateIdMappingWorkflowOutput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'GetIdMappingWorkflowOutput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'UpdateIdMappingWorkflowInput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'UpdateIdMappingWorkflowOutput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', ], ], 'IdMappingWorkflowInputSourceInputSourceARNString' => [ 'base' => NULL, 'refs' => [ 'IdMappingWorkflowInputSource$inputSourceARN' => '<p>An Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.</p>', ], ], 'IdMappingWorkflowList' => [ 'base' => NULL, 'refs' => [ 'ListIdMappingWorkflowsOutput$workflowSummaries' => '<p>A list of <code>IdMappingWorkflowSummary</code> objects.</p>', ], ], 'IdMappingWorkflowOutputSource' => [ 'base' => '<p>The output source for the ID mapping workflow.</p>', 'refs' => [ 'IdMappingWorkflowOutputSourceConfig$member' => NULL, ], ], 'IdMappingWorkflowOutputSourceConfig' => [ 'base' => NULL, 'refs' => [ 'CreateIdMappingWorkflowInput$outputSourceConfig' => '<p>A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> and <code>Output</code>.</p>', 'CreateIdMappingWorkflowOutput$outputSourceConfig' => '<p>A list of <code>IdMappingWorkflowOutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> and <code>Output</code>.</p>', 'GetIdMappingWorkflowOutput$outputSourceConfig' => '<p>A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> and <code>KMSArn</code>.</p>', 'UpdateIdMappingWorkflowInput$outputSourceConfig' => '<p>A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> and <code>KMSArn</code>.</p>', 'UpdateIdMappingWorkflowOutput$outputSourceConfig' => '<p>A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code> and <code>KMSArn</code>.</p>', ], ], 'IdMappingWorkflowRuleDefinitionType' => [ 'base' => NULL, 'refs' => [ 'IdMappingRuleBasedProperties$ruleDefinitionType' => '<p> The set of rules you can use in an ID mapping workflow. The limitations specified for the source or target to define the match rules must be compatible.</p>', 'IdMappingWorkflowRuleDefinitionTypeList$member' => NULL, ], ], 'IdMappingWorkflowRuleDefinitionTypeList' => [ 'base' => NULL, 'refs' => [ 'NamespaceRuleBasedProperties$ruleDefinitionTypes' => '<p> The sets of rules you can use in an ID mapping workflow. The limitations specified for the source and target must be compatible.</p>', ], ], 'IdMappingWorkflowSummary' => [ 'base' => '<p>A list of <code>IdMappingWorkflowSummary</code> objects, each of which contain the fields <code>WorkflowName</code>, <code>WorkflowArn</code>, <code>CreatedAt</code>, and <code>UpdatedAt</code>.</p>', 'refs' => [ 'IdMappingWorkflowList$member' => NULL, ], ], 'IdNamespaceArn' => [ 'base' => NULL, 'refs' => [ 'CreateIdNamespaceOutput$idNamespaceArn' => '<p>The Amazon Resource Name (ARN) of the ID namespace.</p>', 'GetIdNamespaceOutput$idNamespaceArn' => '<p>The Amazon Resource Name (ARN) of the ID namespace.</p>', 'IdNamespaceSummary$idNamespaceArn' => '<p>The Amazon Resource Name (ARN) of the ID namespace.</p>', 'UpdateIdNamespaceOutput$idNamespaceArn' => '<p>The Amazon Resource Name (ARN) of the ID namespace.</p>', ], ], 'IdNamespaceIdMappingWorkflowMetadata' => [ 'base' => '<p>The settings for the ID namespace for the ID mapping workflow job.</p>', 'refs' => [ 'IdNamespaceIdMappingWorkflowMetadataList$member' => NULL, ], ], 'IdNamespaceIdMappingWorkflowMetadataList' => [ 'base' => NULL, 'refs' => [ 'IdNamespaceSummary$idMappingWorkflowProperties' => '<p>An object which defines any additional configurations required by the ID mapping workflow.</p>', ], ], 'IdNamespaceIdMappingWorkflowProperties' => [ 'base' => '<p>An object containing <code>IdMappingType</code>, <code>ProviderProperties</code>, and <code>RuleBasedProperties</code>.</p>', 'refs' => [ 'IdNamespaceIdMappingWorkflowPropertiesList$member' => NULL, ], ], 'IdNamespaceIdMappingWorkflowPropertiesList' => [ 'base' => NULL, 'refs' => [ 'CreateIdNamespaceInput$idMappingWorkflowProperties' => '<p>Determines the properties of <code>IdMappingWorflow</code> where this <code>IdNamespace</code> can be used as a <code>Source</code> or a <code>Target</code>.</p>', 'CreateIdNamespaceOutput$idMappingWorkflowProperties' => '<p>Determines the properties of <code>IdMappingWorkflow</code> where this <code>IdNamespace</code> can be used as a <code>Source</code> or a <code>Target</code>.</p>', 'GetIdNamespaceOutput$idMappingWorkflowProperties' => '<p>Determines the properties of <code>IdMappingWorkflow</code> where this <code>IdNamespace</code> can be used as a <code>Source</code> or a <code>Target</code>.</p>', 'UpdateIdNamespaceInput$idMappingWorkflowProperties' => '<p>Determines the properties of <code>IdMappingWorkflow</code> where this <code>IdNamespace</code> can be used as a <code>Source</code> or a <code>Target</code>.</p>', 'UpdateIdNamespaceOutput$idMappingWorkflowProperties' => '<p>Determines the properties of <code>IdMappingWorkflow</code> where this <code>IdNamespace</code> can be used as a <code>Source</code> or a <code>Target</code>.</p>', ], ], 'IdNamespaceInputSource' => [ 'base' => '<p>An object containing <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'refs' => [ 'IdNamespaceInputSourceConfig$member' => NULL, ], ], 'IdNamespaceInputSourceConfig' => [ 'base' => NULL, 'refs' => [ 'CreateIdNamespaceInput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'CreateIdNamespaceOutput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'GetIdNamespaceOutput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'UpdateIdNamespaceInput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'UpdateIdNamespaceOutput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', ], ], 'IdNamespaceInputSourceInputSourceARNString' => [ 'base' => NULL, 'refs' => [ 'IdNamespaceInputSource$inputSourceARN' => '<p>An Glue table Amazon Resource Name (ARN) or a matching workflow ARN for the input source table.</p>', ], ], 'IdNamespaceList' => [ 'base' => NULL, 'refs' => [ 'ListIdNamespacesOutput$idNamespaceSummaries' => '<p>A list of <code>IdNamespaceSummaries</code> objects.</p>', ], ], 'IdNamespaceSummary' => [ 'base' => '<p>A summary of ID namespaces.</p>', 'refs' => [ 'IdNamespaceList$member' => NULL, ], ], 'IdNamespaceType' => [ 'base' => NULL, 'refs' => [ 'CreateIdNamespaceInput$type' => '<p>The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>. </p> <p>The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID mapping workflow. </p> <p>The <code>TARGET</code> contains a configuration of <code>targetId</code> to which all <code>sourceIds</code> will resolve to.</p>', 'CreateIdNamespaceOutput$type' => '<p>The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.</p> <p>The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID mapping workflow. </p> <p>The <code>TARGET</code> contains a configuration of <code>targetId</code> to which all <code>sourceIds</code> will resolve to.</p>', 'GetIdNamespaceOutput$type' => '<p>The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.</p> <p>The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID mapping workflow. </p> <p>The <code>TARGET</code> contains a configuration of <code>targetId</code> to which all <code>sourceIds</code> will resolve to.</p>', 'IdMappingWorkflowInputSource$type' => '<p>The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>. </p> <p>The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID mapping workflow. </p> <p>The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code> will resolve to.</p>', 'IdNamespaceSummary$type' => '<p>The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.</p> <p>The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID mapping workflow. </p> <p>The <code>TARGET</code> contains a configuration of <code>targetId</code> which all <code>sourceIds</code> will resolve to.</p>', 'UpdateIdNamespaceOutput$type' => '<p>The type of ID namespace. There are two types: <code>SOURCE</code> and <code>TARGET</code>.</p> <p>The <code>SOURCE</code> contains configurations for <code>sourceId</code> data that will be processed in an ID mapping workflow. </p> <p>The <code>TARGET</code> contains a configuration of <code>targetId</code> to which all <code>sourceIds</code> will resolve to.</p>', ], ], 'IncrementalRunConfig' => [ 'base' => '<p>An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.</p>', 'refs' => [ 'CreateMatchingWorkflowInput$incrementalRunConfig' => '<p>An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.</p>', 'CreateMatchingWorkflowOutput$incrementalRunConfig' => '<p>An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.</p>', 'GetMatchingWorkflowOutput$incrementalRunConfig' => '<p>An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.</p>', 'UpdateMatchingWorkflowInput$incrementalRunConfig' => '<p>An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.</p>', 'UpdateMatchingWorkflowOutput$incrementalRunConfig' => '<p>An object which defines an incremental run type and has only <code>incrementalRunType</code> as a field.</p>', ], ], 'IncrementalRunType' => [ 'base' => NULL, 'refs' => [ 'IncrementalRunConfig$incrementalRunType' => '<p>The type of incremental run. It takes only one value: <code>IMMEDIATE</code>.</p>', ], ], 'InputSource' => [ 'base' => '<p>An object containing <code>InputSourceARN</code>, <code>SchemaName</code>, and <code>ApplyNormalization</code>.</p>', 'refs' => [ 'InputSourceConfig$member' => NULL, ], ], 'InputSourceConfig' => [ 'base' => NULL, 'refs' => [ 'CreateMatchingWorkflowInput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'CreateMatchingWorkflowOutput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'GetMatchingWorkflowOutput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'UpdateMatchingWorkflowInput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', 'UpdateMatchingWorkflowOutput$inputSourceConfig' => '<p>A list of <code>InputSource</code> objects, which have the fields <code>InputSourceARN</code> and <code>SchemaName</code>.</p>', ], ], 'InputSourceInputSourceARNString' => [ 'base' => NULL, 'refs' => [ 'InputSource$inputSourceARN' => '<p>An Glue table Amazon Resource Name (ARN) for the input source table.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ExceedsLimitException$quotaValue' => '<p>The current quota value for the customers.</p>', 'IdMappingJobMetrics$inputRecords' => '<p>The total number of records that were input for processing.</p>', 'IdMappingJobMetrics$recordsNotProcessed' => '<p>The total number of records that did not get processed.</p>', 'IdMappingJobMetrics$totalMappedRecords' => '<p> The total number of records that were mapped.</p>', 'IdMappingJobMetrics$totalMappedSourceRecords' => '<p> The total number of mapped source records.</p>', 'IdMappingJobMetrics$totalMappedTargetRecords' => '<p> The total number of distinct mapped target records.</p>', 'IdMappingJobMetrics$totalRecordsProcessed' => '<p>The total number of records that were processed.</p>', 'JobMetrics$inputRecords' => '<p>The total number of input records.</p>', 'JobMetrics$matchIDs' => '<p>The total number of <code>matchID</code>s generated.</p>', 'JobMetrics$recordsNotProcessed' => '<p>The total number of records that did not get processed.</p>', 'JobMetrics$totalRecordsProcessed' => '<p>The total number of records processed.</p>', ], ], 'IntermediateSourceConfiguration' => [ 'base' => '<p>The Amazon S3 location that temporarily stores your data while it processes. Your information won\'t be saved permanently.</p>', 'refs' => [ 'ProviderProperties$intermediateSourceConfiguration' => '<p>The Amazon S3 location that temporarily stores your data while it processes. Your information won\'t be saved permanently.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>This exception occurs when there is an internal failure in the Entity Resolution service. </p>', 'refs' => [], ], 'JobId' => [ 'base' => NULL, 'refs' => [ 'GetIdMappingJobInput$jobId' => '<p>The ID of the job.</p>', 'GetIdMappingJobOutput$jobId' => '<p>The ID of the job.</p>', 'GetMatchingJobInput$jobId' => '<p>The ID of the job.</p>', 'GetMatchingJobOutput$jobId' => '<p>The ID of the job.</p>', 'JobSummary$jobId' => '<p>The ID of the job.</p>', 'StartIdMappingJobOutput$jobId' => '<p>The ID of the job.</p>', 'StartMatchingJobOutput$jobId' => '<p>The ID of the job.</p>', ], ], 'JobList' => [ 'base' => NULL, 'refs' => [ 'ListIdMappingJobsOutput$jobs' => '<p>A list of <code>JobSummary</code> objects.</p>', 'ListMatchingJobsOutput$jobs' => '<p>A list of <code>JobSummary</code> objects, each of which contain the ID, status, start time, and end time of a job.</p>', ], ], 'JobMetrics' => [ 'base' => '<p>An object containing <code>InputRecords</code>, <code>TotalRecordsProcessed</code>, <code>MatchIDs</code>, and <code>RecordsNotProcessed</code>.</p>', 'refs' => [ 'GetMatchingJobOutput$metrics' => '<p>Metrics associated with the execution, specifically total records processed, unique IDs generated, and records the execution skipped.</p>', ], ], 'JobOutputSource' => [ 'base' => '<p>An object containing <code>KMSArn</code>, <code>OutputS3Path</code>, and <code>RoleArn</code>.</p>', 'refs' => [ 'JobOutputSourceConfig$member' => NULL, ], ], 'JobOutputSourceConfig' => [ 'base' => NULL, 'refs' => [ 'GetMatchingJobOutput$outputSourceConfig' => '<p>A list of <code>OutputSource</code> objects.</p>', ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'GetIdMappingJobOutput$status' => '<p>The current status of the job.</p>', 'GetMatchingJobOutput$status' => '<p>The current status of the job.</p>', 'JobSummary$status' => '<p>The current status of the job.</p>', ], ], 'JobSummary' => [ 'base' => '<p>An object containing the <code>JobId</code>, <code>Status</code>, <code>StartTime</code>, and <code>EndTime</code> of a job.</p>', 'refs' => [ 'JobList$member' => NULL, ], ], 'KMSArn' => [ 'base' => NULL, 'refs' => [ 'IdMappingJobOutputSource$KMSArn' => '<p>Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS key.</p>', 'IdMappingWorkflowOutputSource$KMSArn' => '<p>Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS key.</p>', 'JobOutputSource$KMSArn' => '<p>Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS key.</p>', 'OutputSource$KMSArn' => '<p>Customer KMS ARN for encryption at rest. If not provided, system will use an Entity Resolution managed KMS key.</p>', ], ], 'ListIdMappingJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListIdMappingJobsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListIdMappingJobsInput$maxResults' => '<p>The maximum number of objects returned per page.</p>', ], ], 'ListIdMappingJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListIdMappingWorkflowsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListIdMappingWorkflowsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListIdMappingWorkflowsInput$maxResults' => '<p>The maximum number of objects returned per page.</p>', ], ], 'ListIdMappingWorkflowsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListIdNamespacesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListIdNamespacesInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListIdNamespacesInput$maxResults' => '<p>The maximum number of <code>IdNamespace</code> objects returned per page.</p>', ], ], 'ListIdNamespacesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMatchingJobsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMatchingJobsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListMatchingJobsInput$maxResults' => '<p>The maximum number of objects returned per page.</p>', ], ], 'ListMatchingJobsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMatchingWorkflowsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMatchingWorkflowsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListMatchingWorkflowsInput$maxResults' => '<p>The maximum number of objects returned per page.</p>', ], ], 'ListMatchingWorkflowsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListProviderServicesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProviderServicesInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListProviderServicesInput$maxResults' => '<p>The maximum number of objects returned per page.</p>', ], ], 'ListProviderServicesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListSchemaMappingsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListSchemaMappingsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSchemaMappingsInput$maxResults' => '<p>The maximum number of objects returned per page.</p>', ], ], 'ListSchemaMappingsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'MatchPurpose' => [ 'base' => NULL, 'refs' => [ 'RuleBasedProperties$matchPurpose' => '<p> An indicator of whether to generate IDs and index the data or not.</p> <p>If you choose <code>IDENTIFIER_GENERATION</code>, the process generates IDs and indexes the data.</p> <p>If you choose <code>INDEXING</code>, the process indexes the data without generating IDs.</p>', ], ], 'MatchingWorkflowArn' => [ 'base' => NULL, 'refs' => [ 'CreateMatchingWorkflowOutput$workflowArn' => '<p>The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>MatchingWorkflow</code>.</p>', 'GetMatchingWorkflowOutput$workflowArn' => '<p>The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>MatchingWorkflow</code>.</p>', 'MatchingWorkflowSummary$workflowArn' => '<p>The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>MatchingWorkflow</code>.</p>', ], ], 'MatchingWorkflowList' => [ 'base' => NULL, 'refs' => [ 'ListMatchingWorkflowsOutput$workflowSummaries' => '<p>A list of <code>MatchingWorkflowSummary</code> objects, each of which contain the fields <code>WorkflowName</code>, <code>WorkflowArn</code>, <code>CreatedAt</code>, and <code>UpdatedAt</code>.</p>', ], ], 'MatchingWorkflowSummary' => [ 'base' => '<p>A list of <code>MatchingWorkflowSummary</code> objects, each of which contain the fields <code>WorkflowName</code>, <code>WorkflowArn</code>, <code>CreatedAt</code>, <code>UpdatedAt</code>.</p>', 'refs' => [ 'MatchingWorkflowList$member' => NULL, ], ], 'NamespaceProviderProperties' => [ 'base' => '<p>An object containing <code>ProviderConfiguration</code> and <code>ProviderServiceArn</code>.</p>', 'refs' => [ 'IdNamespaceIdMappingWorkflowProperties$providerProperties' => '<p>An object which defines any additional configurations required by the provider service.</p>', ], ], 'NamespaceRuleBasedProperties' => [ 'base' => '<p> The rule-based properties of an ID namespace. These properties define how the ID namespace can be used in an ID mapping workflow.</p>', 'refs' => [ 'IdNamespaceIdMappingWorkflowProperties$ruleBasedProperties' => '<p> An object which defines any additional configurations required by rule-based matching.</p>', ], ], 'NamespaceRuleBasedPropertiesRulesList' => [ 'base' => NULL, 'refs' => [ 'NamespaceRuleBasedProperties$rules' => '<p> The rules for the ID namespace.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListIdMappingJobsInput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListIdMappingJobsOutput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListIdMappingWorkflowsInput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListIdMappingWorkflowsOutput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListIdNamespacesInput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListIdNamespacesOutput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListMatchingJobsInput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListMatchingJobsOutput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListMatchingWorkflowsInput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListMatchingWorkflowsOutput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListProviderServicesInput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListProviderServicesOutput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListSchemaMappingsInput$nextToken' => '<p>The pagination token from the previous API call.</p>', 'ListSchemaMappingsOutput$nextToken' => '<p>The pagination token from the previous API call.</p>', ], ], 'OutputAttribute' => [ 'base' => '<p>A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and <code>Hashed</code>. Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.</p>', 'refs' => [ 'OutputSourceOutputList$member' => NULL, ], ], 'OutputSource' => [ 'base' => '<p>A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and <code>Hashed</code>. Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.</p>', 'refs' => [ 'OutputSourceConfig$member' => NULL, ], ], 'OutputSourceConfig' => [ 'base' => NULL, 'refs' => [ 'CreateMatchingWorkflowInput$outputSourceConfig' => '<p>A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>, <code>ApplyNormalization</code>, and <code>Output</code>.</p>', 'CreateMatchingWorkflowOutput$outputSourceConfig' => '<p>A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>, <code>ApplyNormalization</code>, and <code>Output</code>.</p>', 'GetMatchingWorkflowOutput$outputSourceConfig' => '<p>A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>, <code>ApplyNormalization</code>, and <code>Output</code>.</p>', 'UpdateMatchingWorkflowInput$outputSourceConfig' => '<p>A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>, <code>ApplyNormalization</code>, and <code>Output</code>.</p>', 'UpdateMatchingWorkflowOutput$outputSourceConfig' => '<p>A list of <code>OutputSource</code> objects, each of which contains fields <code>OutputS3Path</code>, <code>ApplyNormalization</code>, and <code>Output</code>.</p>', ], ], 'OutputSourceOutputList' => [ 'base' => NULL, 'refs' => [ 'OutputSource$output' => '<p>A list of <code>OutputAttribute</code> objects, each of which have the fields <code>Name</code> and <code>Hashed</code>. Each of these objects selects a column to be included in the output table, and whether the values of the column should be hashed.</p>', ], ], 'PolicyDocument' => [ 'base' => NULL, 'refs' => [ 'AddPolicyStatementOutput$policy' => '<p>The resource-based policy.</p>', 'DeletePolicyStatementOutput$policy' => '<p>The resource-based policy.</p>', 'GetPolicyOutput$policy' => '<p>The resource-based policy.</p>', 'PutPolicyInput$policy' => '<p>The resource-based policy.</p> <important> <p>If you set the value of the <code>effect</code> parameter in the <code>policy</code> to <code>Deny</code> for the <code>PutPolicy</code> operation, you must also set the value of the <code>effect</code> parameter to <code>Deny</code> for the <code>AddPolicyStatement</code> operation.</p> </important>', 'PutPolicyOutput$policy' => '<p>The resource-based policy.</p>', ], ], 'PolicyToken' => [ 'base' => NULL, 'refs' => [ 'AddPolicyStatementOutput$token' => '<p>A unique identifier for the current revision of the policy.</p>', 'DeletePolicyStatementOutput$token' => '<p>A unique identifier for the deleted policy.</p>', 'GetPolicyOutput$token' => '<p>A unique identifier for the current revision of the policy.</p>', 'PutPolicyInput$token' => '<p>A unique identifier for the current revision of the policy.</p>', 'PutPolicyOutput$token' => '<p>A unique identifier for the current revision of the policy.</p>', ], ], 'ProviderComponentSchema' => [ 'base' => '<p>The input schema supported by provider service.</p>', 'refs' => [ 'GetProviderServiceOutput$providerComponentSchema' => '<p>Input schema for the provider service.</p>', ], ], 'ProviderEndpointConfiguration' => [ 'base' => '<p>The required configuration fields to use with the provider service.</p>', 'refs' => [ 'GetProviderServiceOutput$providerEndpointConfiguration' => '<p>The required configuration fields to use with the provider service.</p>', ], ], 'ProviderIdNameSpaceConfiguration' => [ 'base' => '<p>The provider configuration required for different ID namespace types.</p>', 'refs' => [ 'GetProviderServiceOutput$providerIdNameSpaceConfiguration' => '<p>The provider configuration required for different ID namespace types.</p>', ], ], 'ProviderIntermediateDataAccessConfiguration' => [ 'base' => '<p>The required configuration fields to give intermediate access to a provider service.</p>', 'refs' => [ 'GetProviderServiceOutput$providerIntermediateDataAccessConfiguration' => '<p>The Amazon Web Services accounts and the S3 permissions that are required by some providers to create an S3 bucket for intermediate data storage.</p>', ], ], 'ProviderMarketplaceConfiguration' => [ 'base' => '<p>The identifiers of the provider service, from Data Exchange.</p>', 'refs' => [ 'ProviderEndpointConfiguration$marketplaceConfiguration' => '<p>The identifiers of the provider service, from Data Exchange.</p>', ], ], 'ProviderProperties' => [ 'base' => '<p>An object containing the <code>providerServiceARN</code>, <code>intermediateSourceConfiguration</code>, and <code>providerConfiguration</code>.</p>', 'refs' => [ 'IdMappingTechniques$providerProperties' => '<p>An object which defines any additional configurations required by the provider service.</p>', 'ResolutionTechniques$providerProperties' => '<p>The properties of the provider service.</p>', ], ], 'ProviderSchemaAttribute' => [ 'base' => '<p>The provider schema attribute.</p>', 'refs' => [ 'ProviderSchemaAttributes$member' => NULL, ], ], 'ProviderSchemaAttributes' => [ 'base' => NULL, 'refs' => [ 'ProviderComponentSchema$providerSchemaAttributes' => '<p>The provider schema attributes.</p>', ], ], 'ProviderServiceArn' => [ 'base' => NULL, 'refs' => [ 'GetProviderServiceInput$providerServiceName' => '<p>The ARN (Amazon Resource Name) of the product that the provider service provides.</p>', 'GetProviderServiceOutput$providerServiceArn' => '<p>The ARN (Amazon Resource Name) that Entity Resolution generated for the provider service.</p>', 'NamespaceProviderProperties$providerServiceArn' => '<p>The Amazon Resource Name (ARN) of the provider service.</p>', 'ProviderProperties$providerServiceArn' => '<p>The ARN of the provider service.</p>', 'ProviderServiceSummary$providerServiceArn' => '<p>The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>providerService</code>.</p>', ], ], 'ProviderServiceDisplayName' => [ 'base' => NULL, 'refs' => [ 'GetProviderServiceOutput$providerServiceDisplayName' => '<p>The display name of the provider service.</p>', 'ProviderServiceSummary$providerServiceDisplayName' => '<p>The display name of the provider service.</p>', ], ], 'ProviderServiceList' => [ 'base' => NULL, 'refs' => [ 'ListProviderServicesOutput$providerServiceSummaries' => '<p>A list of <code>ProviderServices</code> objects.</p>', ], ], 'ProviderServiceSummary' => [ 'base' => '<p>A list of <code>ProviderService</code> objects, each of which contain the fields <code>providerName</code>, <code>providerServiceArn</code>, <code>providerServiceName</code>, and <code>providerServiceType</code>.</p>', 'refs' => [ 'ProviderServiceList$member' => NULL, ], ], 'PutPolicyInput' => [ 'base' => NULL, 'refs' => [], ], 'PutPolicyOutput' => [ 'base' => NULL, 'refs' => [], ], 'RecordAttributeMap' => [ 'base' => NULL, 'refs' => [ 'GetMatchIdInput$record' => '<p>The record to fetch the Match ID for.</p>', ], ], 'RecordAttributeMapKeyString' => [ 'base' => NULL, 'refs' => [ 'RecordAttributeMap$key' => NULL, ], ], 'RecordAttributeMapValueString' => [ 'base' => NULL, 'refs' => [ 'RecordAttributeMap$value' => NULL, ], ], 'RecordMatchingModel' => [ 'base' => NULL, 'refs' => [ 'IdMappingRuleBasedProperties$recordMatchingModel' => '<p> The type of matching record that is allowed to be used in an ID mapping workflow. </p> <p>If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source can be matched to the same record in the target.</p> <p>If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, multiple records in the source can be matched to one record in the target.</p>', 'RecordMatchingModelList$member' => NULL, ], ], 'RecordMatchingModelList' => [ 'base' => NULL, 'refs' => [ 'NamespaceRuleBasedProperties$recordMatchingModels' => '<p> The type of matching record that is allowed to be used in an ID mapping workflow. </p> <p>If the value is set to <code>ONE_SOURCE_TO_ONE_TARGET</code>, only one record in the source is matched to one record in the target. </p> <p>If the value is set to <code>MANY_SOURCE_TO_ONE_TARGET</code>, all matching records in the source are matched to one record in the target.</p>', ], ], 'RequiredBucketActionsList' => [ 'base' => NULL, 'refs' => [ 'ProviderIntermediateDataAccessConfiguration$requiredBucketActions' => '<p>The S3 bucket actions that the provider requires permission for.</p>', ], ], 'ResolutionTechniques' => [ 'base' => '<p>An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.</p>', 'refs' => [ 'CreateMatchingWorkflowInput$resolutionTechniques' => '<p>An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.</p>', 'CreateMatchingWorkflowOutput$resolutionTechniques' => '<p>An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.</p>', 'GetMatchingWorkflowOutput$resolutionTechniques' => '<p>An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.</p>', 'UpdateMatchingWorkflowInput$resolutionTechniques' => '<p>An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code>.</p>', 'UpdateMatchingWorkflowOutput$resolutionTechniques' => '<p>An object which defines the <code>resolutionType</code> and the <code>ruleBasedProperties</code> </p>', ], ], 'ResolutionType' => [ 'base' => NULL, 'refs' => [ 'MatchingWorkflowSummary$resolutionType' => '<p>The method that has been specified for data matching, either using matching provided by Entity Resolution or through a provider service.</p>', 'ResolutionTechniques$resolutionType' => '<p>The type of matching. There are three types of matching: <code>RULE_MATCHING</code>, <code>ML_MATCHING</code>, and <code>PROVIDER</code>.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource could not be found. </p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateIdNamespaceInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access the resources defined in this <code>IdNamespace</code> on your behalf as part of the workflow run.</p>', 'CreateIdNamespaceOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access the resources defined in <code>inputSourceConfig</code> on your behalf as part of the workflow run.</p>', 'GetIdNamespaceOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access the resources defined in this <code>IdNamespace</code> on your behalf as part of a workflow run.</p>', 'IdMappingJobOutputSource$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access Amazon Web Services resources on your behalf as part of workflow execution.</p>', 'JobOutputSource$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access Amazon Web Services resources on your behalf as part of workflow execution.</p>', 'UpdateIdNamespaceInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access the resources defined in this <code>IdNamespace</code> on your behalf as part of a workflow run.</p>', 'UpdateIdNamespaceOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access the resources defined in this <code>IdNamespace</code> on your behalf as part of a workflow run.</p>', ], ], 'Rule' => [ 'base' => '<p>An object containing <code>RuleName</code>, and <code>MatchingKeys</code>.</p>', 'refs' => [ 'IdMappingRuleBasedPropertiesRulesList$member' => NULL, 'NamespaceRuleBasedPropertiesRulesList$member' => NULL, 'RuleBasedPropertiesRulesList$member' => NULL, ], ], 'RuleBasedProperties' => [ 'base' => '<p>An object which defines the list of matching rules to run in a matching workflow. RuleBasedProperties contain a <code>Rules</code> field, which is a list of rule objects.</p>', 'refs' => [ 'ResolutionTechniques$ruleBasedProperties' => '<p>An object which defines the list of matching rules to run and has a field <code>Rules</code>, which is a list of rule objects.</p>', ], ], 'RuleBasedPropertiesRulesList' => [ 'base' => NULL, 'refs' => [ 'RuleBasedProperties$rules' => '<p>A list of <code>Rule</code> objects, each of which have fields <code>RuleName</code> and <code>MatchingKeys</code>.</p>', ], ], 'RuleMatchingKeysList' => [ 'base' => NULL, 'refs' => [ 'Rule$matchingKeys' => '<p>A list of <code>MatchingKeys</code>. The <code>MatchingKeys</code> must have been defined in the <code>SchemaMapping</code>. Two records are considered to match according to this rule if all of the <code>MatchingKeys</code> match.</p>', ], ], 'RuleRuleNameString' => [ 'base' => NULL, 'refs' => [ 'Rule$ruleName' => '<p>A name for the matching rule.</p>', ], ], 'S3Path' => [ 'base' => NULL, 'refs' => [ 'IdMappingJobOutputSource$outputS3Path' => '<p>The S3 path to which Entity Resolution will write the output table.</p>', 'IdMappingWorkflowOutputSource$outputS3Path' => '<p>The S3 path to which Entity Resolution will write the output table.</p>', 'IntermediateSourceConfiguration$intermediateS3Path' => '<p>The Amazon S3 location (bucket and prefix). For example: <code>s3://provider_bucket/DOC-EXAMPLE-BUCKET</code> </p>', 'JobOutputSource$outputS3Path' => '<p>The S3 path to which Entity Resolution will write the output table.</p>', 'OutputSource$outputS3Path' => '<p>The S3 path to which Entity Resolution will write the output table.</p>', ], ], 'SchemaAttributeType' => [ 'base' => NULL, 'refs' => [ 'ProviderSchemaAttribute$type' => '<p>The type of the provider schema attribute.</p>', 'SchemaInputAttribute$type' => '<p>The type of the attribute, selected from a list of values.</p>', ], ], 'SchemaInputAttribute' => [ 'base' => '<p>An object containing <code>FieldName</code>, <code>Type</code>, <code>GroupName</code>, <code>MatchKey</code>, <code>Hashing</code>, and <code>SubType</code>.</p>', 'refs' => [ 'SchemaInputAttributes$member' => NULL, ], ], 'SchemaInputAttributes' => [ 'base' => NULL, 'refs' => [ 'CreateSchemaMappingInput$mappedInputFields' => '<p>A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the source data table, and contains column name plus additional information that Entity Resolution uses for matching.</p>', 'CreateSchemaMappingOutput$mappedInputFields' => '<p>A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the source data table, and contains column name plus additional information that Entity Resolution uses for matching.</p>', 'GetSchemaMappingOutput$mappedInputFields' => '<p>A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the source data table, and contains column name plus additional information Venice uses for matching.</p>', 'UpdateSchemaMappingInput$mappedInputFields' => '<p>A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the source data table, and contains column name plus additional information that Entity Resolution uses for matching.</p>', 'UpdateSchemaMappingOutput$mappedInputFields' => '<p>A list of <code>MappedInputFields</code>. Each <code>MappedInputField</code> corresponds to a column the source data table, and contains column name plus additional information that Entity Resolution uses for matching.</p>', ], ], 'SchemaList' => [ 'base' => NULL, 'refs' => [ 'Schemas$member' => NULL, ], ], 'SchemaMappingArn' => [ 'base' => NULL, 'refs' => [ 'CreateSchemaMappingOutput$schemaArn' => '<p>The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>SchemaMapping</code>.</p>', 'GetSchemaMappingOutput$schemaArn' => '<p>The ARN (Amazon Resource Name) that Entity Resolution generated for the SchemaMapping.</p>', 'SchemaMappingSummary$schemaArn' => '<p>The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>SchemaMapping</code>.</p>', 'UpdateSchemaMappingOutput$schemaArn' => '<p>The ARN (Amazon Resource Name) that Entity Resolution generated for the <code>SchemaMapping</code>.</p>', ], ], 'SchemaMappingList' => [ 'base' => NULL, 'refs' => [ 'ListSchemaMappingsOutput$schemaList' => '<p>A list of <code>SchemaMappingSummary</code> objects, each of which contain the fields <code>SchemaName</code>, <code>SchemaArn</code>, <code>CreatedAt</code>, <code>UpdatedAt</code>.</p>', ], ], 'SchemaMappingSummary' => [ 'base' => '<p>An object containing <code>SchemaName</code>, <code>SchemaArn</code>, <code>CreatedAt</code>, and<code>UpdatedAt</code>.</p>', 'refs' => [ 'SchemaMappingList$member' => NULL, ], ], 'Schemas' => [ 'base' => NULL, 'refs' => [ 'ProviderComponentSchema$schemas' => '<p>Input schema for the provider service.</p>', ], ], 'ServiceType' => [ 'base' => NULL, 'refs' => [ 'GetProviderServiceOutput$providerServiceType' => '<p>The type of provider service.</p>', 'ProviderServiceSummary$providerServiceType' => '<p>The type of provider service.</p>', ], ], 'StartIdMappingJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartIdMappingJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StartMatchingJobInput' => [ 'base' => NULL, 'refs' => [], ], 'StartMatchingJobOutput' => [ 'base' => NULL, 'refs' => [], ], 'StatementAction' => [ 'base' => NULL, 'refs' => [ 'StatementActionList$member' => NULL, ], ], 'StatementActionList' => [ 'base' => NULL, 'refs' => [ 'AddPolicyStatementInput$action' => '<p>The action that the principal can use on the resource. </p> <p>For example, <code>entityresolution:GetIdMappingJob</code>, <code>entityresolution:GetMatchingJob</code>.</p>', ], ], 'StatementCondition' => [ 'base' => NULL, 'refs' => [ 'AddPolicyStatementInput$condition' => '<p>A set of condition keys that you can use in key policies.</p>', ], ], 'StatementEffect' => [ 'base' => NULL, 'refs' => [ 'AddPolicyStatementInput$effect' => '<p>Determines whether the permissions specified in the policy are to be allowed (<code>Allow</code>) or denied (<code>Deny</code>).</p> <important> <p> If you set the value of the <code>effect</code> parameter to <code>Deny</code> for the <code>AddPolicyStatement</code> operation, you must also set the value of the <code>effect</code> parameter in the <code>policy</code> to <code>Deny</code> for the <code>PutPolicy</code> operation.</p> </important>', ], ], 'StatementId' => [ 'base' => NULL, 'refs' => [ 'AddPolicyStatementInput$statementId' => '<p>A statement identifier that differentiates the statement from others in the same policy.</p>', 'DeletePolicyStatementInput$statementId' => '<p>A statement identifier that differentiates the statement from others in the same policy.</p>', ], ], 'StatementPrincipal' => [ 'base' => NULL, 'refs' => [ 'StatementPrincipalList$member' => NULL, ], ], 'StatementPrincipalList' => [ 'base' => NULL, 'refs' => [ 'AddPolicyStatementInput$principal' => '<p>The Amazon Web Services service or Amazon Web Services account that can access the resource defined as ARN.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'CreateMatchingWorkflowInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.</p>', 'CreateMatchingWorkflowOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.</p>', 'DeleteIdMappingWorkflowOutput$message' => '<p>A successful operation message.</p>', 'DeleteIdNamespaceOutput$message' => '<p>A successful operation message.</p>', 'DeleteMatchingWorkflowOutput$message' => '<p>A successful operation message.</p>', 'DeleteSchemaMappingOutput$message' => '<p>A successful operation message.</p>', 'ExceedsLimitException$quotaName' => '<p>The name of the quota that has been breached.</p>', 'GetMatchIdOutput$matchId' => '<p>The unique identifiers for this group of match records.</p>', 'GetMatchIdOutput$matchRule' => '<p>The rule the record matched on.</p>', 'GetMatchingWorkflowOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to access Amazon Web Services resources on your behalf.</p>', 'ProviderIdNameSpaceConfiguration$description' => '<p>The description of the ID namespace.</p>', 'ProviderMarketplaceConfiguration$assetId' => '<p>The asset ID on Data Exchange.</p>', 'ProviderMarketplaceConfiguration$dataSetId' => '<p>The dataset ID on Data Exchange.</p>', 'ProviderMarketplaceConfiguration$listingId' => '<p>The listing ID on Data Exchange.</p>', 'ProviderMarketplaceConfiguration$revisionId' => '<p>The revision ID on Data Exchange.</p>', 'RequiredBucketActionsList$member' => NULL, 'SchemaList$member' => NULL, 'UpdateMatchingWorkflowInput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.</p>', 'UpdateMatchingWorkflowOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role. Entity Resolution assumes this role to create resources on your behalf as part of workflow execution.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$tagKeys' => '<p>The list of tag keys to remove from the resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateIdMappingWorkflowInput$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateIdNamespaceInput$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateIdNamespaceOutput$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateMatchingWorkflowInput$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'CreateSchemaMappingInput$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'GetIdMappingWorkflowOutput$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'GetIdNamespaceOutput$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'GetMatchingWorkflowOutput$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'GetSchemaMappingOutput$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'ListTagsForResourceOutput$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', 'TagResourceInput$tags' => '<p>The tags used to organize, track, or control access for this resource.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling. </p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateIdNamespaceOutput$createdAt' => '<p>The timestamp of when the ID namespace was created.</p>', 'CreateIdNamespaceOutput$updatedAt' => '<p>The timestamp of when the ID namespace was last updated.</p>', 'GetIdMappingJobOutput$endTime' => '<p>The time at which the job has finished.</p>', 'GetIdMappingJobOutput$startTime' => '<p>The time at which the job was started.</p>', 'GetIdMappingWorkflowOutput$createdAt' => '<p>The timestamp of when the workflow was created.</p>', 'GetIdMappingWorkflowOutput$updatedAt' => '<p>The timestamp of when the workflow was last updated.</p>', 'GetIdNamespaceOutput$createdAt' => '<p>The timestamp of when the ID namespace was created.</p>', 'GetIdNamespaceOutput$updatedAt' => '<p>The timestamp of when the ID namespace was last updated.</p>', 'GetMatchingJobOutput$endTime' => '<p>The time at which the job has finished.</p>', 'GetMatchingJobOutput$startTime' => '<p>The time at which the job was started.</p>', 'GetMatchingWorkflowOutput$createdAt' => '<p>The timestamp of when the workflow was created.</p>', 'GetMatchingWorkflowOutput$updatedAt' => '<p>The timestamp of when the workflow was last updated.</p>', 'GetSchemaMappingOutput$createdAt' => '<p>The timestamp of when the <code>SchemaMapping</code> was created.</p>', 'GetSchemaMappingOutput$updatedAt' => '<p>The timestamp of when the <code>SchemaMapping</code> was last updated.</p>', 'IdMappingWorkflowSummary$createdAt' => '<p>The timestamp of when the workflow was created.</p>', 'IdMappingWorkflowSummary$updatedAt' => '<p>The timestamp of when the workflow was last updated.</p>', 'IdNamespaceSummary$createdAt' => '<p>The timestamp of when the ID namespace was created.</p>', 'IdNamespaceSummary$updatedAt' => '<p>The timestamp of when the ID namespace was last updated.</p>', 'JobSummary$endTime' => '<p>The time at which the job has finished.</p>', 'JobSummary$startTime' => '<p>The time at which the job was started.</p>', 'MatchingWorkflowSummary$createdAt' => '<p>The timestamp of when the workflow was created.</p>', 'MatchingWorkflowSummary$updatedAt' => '<p>The timestamp of when the workflow was last updated.</p>', 'SchemaMappingSummary$createdAt' => '<p>The timestamp of when the <code>SchemaMapping</code> was created.</p>', 'SchemaMappingSummary$updatedAt' => '<p>The timestamp of when the <code>SchemaMapping</code> was last updated.</p>', 'UpdateIdNamespaceOutput$createdAt' => '<p>The timestamp of when the ID namespace was created.</p>', 'UpdateIdNamespaceOutput$updatedAt' => '<p>The timestamp of when the ID namespace was last updated.</p>', ], ], 'UniqueId' => [ 'base' => NULL, 'refs' => [ 'DeleteUniqueIdError$uniqueId' => '<p>The unique ID that could not be deleted.</p>', 'DeletedUniqueId$uniqueId' => '<p> The unique ID of the deleted item.</p>', 'DisconnectedUniqueIdsList$member' => NULL, 'UniqueIdList$member' => NULL, ], ], 'UniqueIdList' => [ 'base' => NULL, 'refs' => [ 'BatchDeleteUniqueIdInput$uniqueIds' => '<p>The unique IDs to delete.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdMappingWorkflowInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdMappingWorkflowOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdNamespaceInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateIdNamespaceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMatchingWorkflowInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMatchingWorkflowOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSchemaMappingInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSchemaMappingOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by Entity Resolution. </p>', 'refs' => [], ], 'VeniceGlobalArn' => [ 'base' => NULL, 'refs' => [ 'AddPolicyStatementInput$arn' => '<p>The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.</p>', 'AddPolicyStatementOutput$arn' => '<p>The Amazon Resource Name (ARN) of the resource that will be accessed by the principal.</p>', 'DeletePolicyStatementInput$arn' => '<p>The ARN of the resource for which the policy need to be deleted.</p>', 'DeletePolicyStatementOutput$arn' => '<p>The ARN of the resource for which the policy need to be deleted.</p>', 'GetPolicyInput$arn' => '<p>The Amazon Resource Name (ARN) of the resource for which the policy need to be returned.</p>', 'GetPolicyOutput$arn' => '<p>The Entity Resolution resource ARN.</p>', 'ListTagsForResourceInput$resourceArn' => '<p>The ARN of the resource for which you want to view tags.</p>', 'PutPolicyInput$arn' => '<p>The Amazon Resource Name (ARN) of the resource for which the policy needs to be updated.</p>', 'PutPolicyOutput$arn' => '<p>The Entity Resolution resource ARN.</p>', 'TagResourceInput$resourceArn' => '<p>The ARN of the resource for which you want to view tags.</p>', 'UntagResourceInput$resourceArn' => '<p>The ARN of the resource for which you want to untag.</p>', ], ], ],];
