<?php
// This file was auto-generated from sdk-root/src/data/finspace/2021-03-12/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The FinSpace management service provides the APIs for managing FinSpace environments.</p>', 'operations' => [ 'CreateEnvironment' => '<p>Create a new FinSpace environment.</p>', 'CreateKxChangeset' => '<p> Creates a changeset for a kdb database. A changeset allows you to add and delete existing files by using an ordered list of change requests. </p>', 'CreateKxCluster' => '<p>Creates a new kdb cluster.</p>', 'CreateKxDatabase' => '<p>Creates a new kdb database in the environment.</p>', 'CreateKxDataview' => '<p> Creates a snapshot of kdb database with tiered storage capabilities and a pre-warmed cache, ready for mounting on kdb clusters. Dataviews are only available for clusters running on a scaling group. They are not supported on dedicated clusters. </p>', 'CreateKxEnvironment' => '<p>Creates a managed kdb environment for the account.</p>', 'CreateKxScalingGroup' => '<p>Creates a new scaling group. </p>', 'CreateKxUser' => '<p>Creates a user in FinSpace kdb environment with an associated IAM role.</p>', 'CreateKxVolume' => '<p> Creates a new volume with a specific amount of throughput and storage capacity. </p>', 'DeleteEnvironment' => '<p>Delete an FinSpace environment.</p>', 'DeleteKxCluster' => '<p>Deletes a kdb cluster.</p>', 'DeleteKxClusterNode' => '<p>Deletes the specified nodes from a cluster. </p>', 'DeleteKxDatabase' => '<p>Deletes the specified database and all of its associated data. This action is irreversible. You must copy any data out of the database before deleting it if the data is to be retained.</p>', 'DeleteKxDataview' => '<p> Deletes the specified dataview. Before deleting a dataview, make sure that it is not in use by any cluster. </p>', 'DeleteKxEnvironment' => '<p>Deletes the kdb environment. This action is irreversible. Deleting a kdb environment will remove all the associated data and any services running in it. </p>', 'DeleteKxScalingGroup' => '<p> Deletes the specified scaling group. This action is irreversible. You cannot delete a scaling group until all the clusters running on it have been deleted.</p>', 'DeleteKxUser' => '<p>Deletes a user in the specified kdb environment.</p>', 'DeleteKxVolume' => '<p> Deletes a volume. You can only delete a volume if it\'s not attached to a cluster or a dataview. When a volume is deleted, any data on the volume is lost. This action is irreversible. </p>', 'GetEnvironment' => '<p>Returns the FinSpace environment object.</p>', 'GetKxChangeset' => '<p>Returns information about a kdb changeset.</p>', 'GetKxCluster' => '<p>Retrieves information about a kdb cluster.</p>', 'GetKxConnectionString' => '<p>Retrieves a connection string for a user to connect to a kdb cluster. You must call this API using the same role that you have defined while creating a user. </p>', 'GetKxDatabase' => '<p>Returns database information for the specified environment ID.</p>', 'GetKxDataview' => '<p> Retrieves details of the dataview. </p>', 'GetKxEnvironment' => '<p>Retrieves all the information for the specified kdb environment.</p>', 'GetKxScalingGroup' => '<p> Retrieves details of a scaling group.</p>', 'GetKxUser' => '<p>Retrieves information about the specified kdb user.</p>', 'GetKxVolume' => '<p> Retrieves the information about the volume. </p>', 'ListEnvironments' => '<p>A list of all of your FinSpace environments.</p>', 'ListKxChangesets' => '<p>Returns a list of all the changesets for a database.</p>', 'ListKxClusterNodes' => '<p>Lists all the nodes in a kdb cluster.</p>', 'ListKxClusters' => '<p>Returns a list of clusters.</p>', 'ListKxDatabases' => '<p>Returns a list of all the databases in the kdb environment.</p>', 'ListKxDataviews' => '<p> Returns a list of all the dataviews in the database.</p>', 'ListKxEnvironments' => '<p>Returns a list of kdb environments created in an account.</p>', 'ListKxScalingGroups' => '<p> Returns a list of scaling groups in a kdb environment.</p>', 'ListKxUsers' => '<p>Lists all the users in a kdb environment.</p>', 'ListKxVolumes' => '<p> Lists all the volumes in a kdb environment. </p>', 'ListTagsForResource' => '<p>A list of all tags for a resource.</p>', 'TagResource' => '<p>Adds metadata tags to a FinSpace resource.</p>', 'UntagResource' => '<p>Removes metadata tags from a FinSpace resource.</p>', 'UpdateEnvironment' => '<p>Update your FinSpace environment.</p>', 'UpdateKxClusterCodeConfiguration' => '<p> Allows you to update code configuration on a running cluster. By using this API you can update the code, the initialization script path, and the command line arguments for a specific cluster. The configuration that you want to update will override any existing configurations on the cluster. </p>', 'UpdateKxClusterDatabases' => '<p>Updates the databases mounted on a kdb cluster, which includes the <code>changesetId</code> and all the dbPaths to be cached. This API does not allow you to change a database name or add a database if you created a cluster without one. </p> <p>Using this API you can point a cluster to a different changeset and modify a list of partitions being cached.</p>', 'UpdateKxDatabase' => '<p>Updates information for the given kdb database.</p>', 'UpdateKxDataview' => '<p> Updates the specified dataview. The dataviews get automatically updated when any new changesets are ingested. Each update of the dataview creates a new version, including changeset details and cache configurations</p>', 'UpdateKxEnvironment' => '<p>Updates information for the given kdb environment.</p>', 'UpdateKxEnvironmentNetwork' => '<p>Updates environment network to connect to your internal network by using a transit gateway. This API supports request to create a transit gateway attachment from FinSpace VPC to your transit gateway ID and create a custom Route-53 outbound resolvers.</p> <p>Once you send a request to update a network, you cannot change it again. Network update might require termination of any clusters that are running in the existing network.</p>', 'UpdateKxUser' => '<p>Updates the user details. You can only update the IAM role associated with a user.</p>', 'UpdateKxVolume' => '<p> Updates the throughput or capacity of a volume. During the update process, the filesystem might be unavailable for a few minutes. You can retry any operations after the update is complete. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AttachedClusterList' => [ 'base' => NULL, 'refs' => [ 'KxDataviewActiveVersion$attachedClusters' => '<p> The list of clusters that are currently using this dataview. </p>', ], ], 'AttributeMap' => [ 'base' => NULL, 'refs' => [ 'FederationParameters$attributeMap' => '<p>SAML attribute name and value. The name must always be <code>Email</code> and the value should be set to the attribute definition in which user email is set. For example, name would be <code>Email</code> and value <code>http://schemas.xmlsoap.org/ws/2005/05/identity/claims/emailaddress</code>. Please check your SAML 2.0 compliant identity provider (IdP) documentation for details.</p>', ], ], 'AutoScalingConfiguration' => [ 'base' => '<p>The configuration based on which FinSpace will scale in or scale out nodes in your cluster. </p>', 'refs' => [ 'CreateKxClusterRequest$autoScalingConfiguration' => '<p>The configuration based on which FinSpace will scale in or scale out nodes in your cluster.</p>', 'CreateKxClusterResponse$autoScalingConfiguration' => '<p>The configuration based on which FinSpace will scale in or scale out nodes in your cluster.</p>', 'GetKxClusterResponse$autoScalingConfiguration' => '<p>The configuration based on which FinSpace will scale in or scale out nodes in your cluster.</p>', ], ], 'AutoScalingMetric' => [ 'base' => NULL, 'refs' => [ 'AutoScalingConfiguration$autoScalingMetric' => '<p> The metric your cluster will track in order to scale in and out. For example, <code>CPU_UTILIZATION_PERCENTAGE</code> is the average CPU usage across all the nodes in a cluster.</p>', ], ], 'AutoScalingMetricTarget' => [ 'base' => NULL, 'refs' => [ 'AutoScalingConfiguration$metricTarget' => '<p>The desired value of the chosen <code>autoScalingMetric</code>. When the metric drops below this value, the cluster will scale in. When the metric goes above this value, the cluster will scale out. You can set the target value between 1 and 100 percent.</p>', ], ], 'AvailabilityZoneId' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZoneIds$member' => NULL, 'CreateKxClusterRequest$availabilityZoneId' => '<p>The availability zone identifiers for the requested regions.</p>', 'CreateKxClusterResponse$availabilityZoneId' => '<p> The availability zone identifiers for the requested regions. </p>', 'CreateKxDataviewRequest$availabilityZoneId' => '<p> The identifier of the availability zones. </p>', 'CreateKxDataviewResponse$availabilityZoneId' => '<p> The identifier of the availability zones. </p>', 'CreateKxScalingGroupRequest$availabilityZoneId' => '<p>The identifier of the availability zones.</p>', 'CreateKxScalingGroupResponse$availabilityZoneId' => '<p>The identifier of the availability zones.</p>', 'GetKxClusterResponse$availabilityZoneId' => '<p> The availability zone identifiers for the requested regions. </p>', 'GetKxDataviewResponse$availabilityZoneId' => '<p> The identifier of the availability zones. </p>', 'GetKxScalingGroupResponse$availabilityZoneId' => '<p>The identifier of the availability zones.</p>', 'KxCluster$availabilityZoneId' => '<p> The availability zone identifiers for the requested regions. </p>', 'KxDataviewListEntry$availabilityZoneId' => '<p> The identifier of the availability zones. </p>', 'KxNode$availabilityZoneId' => '<p>The identifier of the availability zones where subnets for the environment are created.</p>', 'KxScalingGroup$availabilityZoneId' => '<p>The identifier of the availability zones.</p>', 'UpdateKxDataviewResponse$availabilityZoneId' => '<p> The identifier of the availability zones. </p>', ], ], 'AvailabilityZoneIds' => [ 'base' => NULL, 'refs' => [ 'CreateKxVolumeRequest$availabilityZoneIds' => '<p>The identifier of the availability zones.</p>', 'CreateKxVolumeResponse$availabilityZoneIds' => '<p>The identifier of the availability zones.</p>', 'GetKxEnvironmentResponse$availabilityZoneIds' => '<p>The identifier of the availability zones where subnets for the environment are created.</p>', 'GetKxVolumeResponse$availabilityZoneIds' => '<p>The identifier of the availability zones.</p>', 'KxEnvironment$availabilityZoneIds' => '<p>The identifier of the availability zones where subnets for the environment are created.</p>', 'KxVolume$availabilityZoneIds' => '<p>The identifier of the availability zones.</p>', 'UpdateKxEnvironmentNetworkResponse$availabilityZoneIds' => '<p>The identifier of the availability zones where subnets for the environment are created.</p>', 'UpdateKxEnvironmentResponse$availabilityZoneIds' => '<p>The identifier of the availability zones where subnets for the environment are created.</p>', 'UpdateKxVolumeResponse$availabilityZoneIds' => '<p>The identifier of the availability zones.</p>', ], ], 'BoxedInteger' => [ 'base' => NULL, 'refs' => [ 'ListKxEnvironmentsRequest$maxResults' => '<p>The maximum number of results to return in this request.</p>', ], ], 'CapacityConfiguration' => [ 'base' => '<p>A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of instances, and number of instances.</p>', 'refs' => [ 'CreateKxClusterRequest$capacityConfiguration' => '<p>A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of instances, and number of instances.</p>', 'CreateKxClusterResponse$capacityConfiguration' => '<p>A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of instances, and number of instances.</p>', 'GetKxClusterResponse$capacityConfiguration' => '<p>A structure for the metadata of a cluster. It includes information like the CPUs needed, memory of instances, and number of instances.</p>', ], ], 'ChangeRequest' => [ 'base' => '<p>A list of change request objects.</p>', 'refs' => [ 'ChangeRequests$member' => NULL, ], ], 'ChangeRequests' => [ 'base' => NULL, 'refs' => [ 'CreateKxChangesetRequest$changeRequests' => '<p>A list of change request objects that are run in order. A change request object consists of <code>changeType</code> , <code>s3Path</code>, and <code>dbPath</code>. A changeType can have the following values: </p> <ul> <li> <p>PUT – Adds or updates files in a database.</p> </li> <li> <p>DELETE – Deletes files in a database.</p> </li> </ul> <p>All the change requests require a mandatory <code>dbPath</code> attribute that defines the path within the database directory. All database paths must start with a leading / and end with a trailing /. The <code>s3Path</code> attribute defines the s3 source file path and is required for a PUT change type. The <code>s3path</code> must end with a trailing / if it is a directory and must end without a trailing / if it is a file. </p> <p>Here are few examples of how you can use the change request object:</p> <ol> <li> <p>This request adds a single sym file at database root location. </p> <p> <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/sym", "dbPath":"/"}</code> </p> </li> <li> <p>This request adds files in the given <code>s3Path</code> under the 2020.01.02 partition of the database.</p> <p> <code>{ "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/", "dbPath":"/2020.01.02/"}</code> </p> </li> <li> <p>This request adds files in the given <code>s3Path</code> under the <i>taq</i> table partition of the database.</p> <p> <code>[ { "changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code> </p> </li> <li> <p>This request deletes the 2020.01.02 partition of the database.</p> <p> <code>[{ "changeType": "DELETE", "dbPath": "/2020.01.02/"} ]</code> </p> </li> <li> <p>The <i>DELETE</i> request allows you to delete the existing files under the 2020.01.02 partition of the database, and the <i>PUT</i> request adds a new taq table under it.</p> <p> <code>[ {"changeType": "DELETE", "dbPath":"/2020.01.02/"}, {"changeType": "PUT", "s3Path":"s3://bucket/db/2020.01.02/taq/", "dbPath":"/2020.01.02/taq/"}]</code> </p> </li> </ol>', 'CreateKxChangesetResponse$changeRequests' => '<p>A list of change requests.</p>', 'GetKxChangesetResponse$changeRequests' => '<p>A list of change request objects that are run in order.</p>', ], ], 'ChangeType' => [ 'base' => NULL, 'refs' => [ 'ChangeRequest$changeType' => '<p>Defines the type of change request. A <code>changeType</code> can have the following values:</p> <ul> <li> <p>PUT – Adds or updates files in a database.</p> </li> <li> <p>DELETE – Deletes files in a database.</p> </li> </ul>', ], ], 'ChangesetId' => [ 'base' => NULL, 'refs' => [ 'CreateKxChangesetResponse$changesetId' => '<p>A unique identifier for the changeset.</p>', 'CreateKxDataviewRequest$changesetId' => '<p> A unique identifier of the changeset that you want to use to ingest data. </p>', 'CreateKxDataviewResponse$changesetId' => '<p>A unique identifier for the changeset.</p>', 'GetKxChangesetRequest$changesetId' => '<p>A unique identifier of the changeset for which you want to retrieve data.</p>', 'GetKxChangesetResponse$changesetId' => '<p>A unique identifier for the changeset.</p>', 'GetKxDatabaseResponse$lastCompletedChangesetId' => '<p>A unique identifier for the changeset.</p>', 'GetKxDataviewResponse$changesetId' => '<p> A unique identifier of the changeset that you want to use to ingest data. </p>', 'KxChangesetListEntry$changesetId' => '<p>A unique identifier for the changeset.</p>', 'KxDatabaseConfiguration$changesetId' => '<p>A unique identifier of the changeset that is associated with the cluster.</p>', 'KxDataviewActiveVersion$changesetId' => '<p>A unique identifier for the changeset.</p>', 'KxDataviewConfiguration$changesetId' => '<p>A unique identifier for the changeset.</p>', 'KxDataviewListEntry$changesetId' => '<p>A unique identifier for the changeset.</p>', 'UpdateKxDataviewRequest$changesetId' => '<p>A unique identifier for the changeset.</p>', 'UpdateKxDataviewResponse$changesetId' => '<p>A unique identifier for the changeset.</p>', ], ], 'ChangesetStatus' => [ 'base' => NULL, 'refs' => [ 'CreateKxChangesetResponse$status' => '<p>Status of the changeset creation process.</p> <ul> <li> <p>Pending – Changeset creation is pending.</p> </li> <li> <p>Processing – Changeset creation is running.</p> </li> <li> <p>Failed – Changeset creation has failed.</p> </li> <li> <p>Complete – Changeset creation has succeeded.</p> </li> </ul>', 'GetKxChangesetResponse$status' => '<p>Status of the changeset creation process.</p> <ul> <li> <p>Pending – Changeset creation is pending.</p> </li> <li> <p>Processing – Changeset creation is running.</p> </li> <li> <p>Failed – Changeset creation has failed.</p> </li> <li> <p>Complete – Changeset creation has succeeded.</p> </li> </ul>', 'KxChangesetListEntry$status' => '<p> Status of the changeset.</p> <ul> <li> <p>Pending – Changeset creation is pending.</p> </li> <li> <p>Processing – Changeset creation is running.</p> </li> <li> <p>Failed – Changeset creation has failed.</p> </li> <li> <p>Complete – Changeset creation has succeeded.</p> </li> </ul>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'CreateKxEnvironmentRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'CreateKxScalingGroupRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'CreateKxUserRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'CreateKxVolumeRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'DeleteKxEnvironmentRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'DeleteKxUserRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'UpdateKxEnvironmentNetworkRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'UpdateKxEnvironmentRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'UpdateKxUserRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', ], ], 'ClientTokenString' => [ 'base' => NULL, 'refs' => [ 'CreateKxChangesetRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'CreateKxDatabaseRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'CreateKxDataviewRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'DeleteKxClusterRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'DeleteKxDatabaseRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'DeleteKxDataviewRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'DeleteKxScalingGroupRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'DeleteKxVolumeRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'UpdateKxClusterCodeConfigurationRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'UpdateKxClusterDatabasesRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'UpdateKxDatabaseRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'UpdateKxDataviewRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', 'UpdateKxVolumeRequest$clientToken' => '<p>A token that ensures idempotency. This token expires in 10 minutes.</p>', ], ], 'ClusterNodeCount' => [ 'base' => NULL, 'refs' => [ 'KxScalingGroupConfiguration$nodeCount' => '<p> The number of kdb cluster nodes. </p>', ], ], 'CodeConfiguration' => [ 'base' => '<p>The structure of the customer code available within the running cluster.</p>', 'refs' => [ 'CreateKxClusterRequest$code' => '<p>The details of the custom code that you want to use inside a cluster when analyzing a data. It consists of the S3 source bucket, location, S3 object version, and the relative path from where the custom code is loaded into the cluster. </p>', 'CreateKxClusterResponse$code' => '<p>The details of the custom code that you want to use inside a cluster when analyzing a data. It consists of the S3 source bucket, location, S3 object version, and the relative path from where the custom code is loaded into the cluster. </p>', 'GetKxClusterResponse$code' => '<p>The details of the custom code that you want to use inside a cluster when analyzing a data. It consists of the S3 source bucket, location, S3 object version, and the relative path from where the custom code is loaded into the cluster. </p>', 'UpdateKxClusterCodeConfigurationRequest$code' => NULL, ], ], 'ConflictException' => [ 'base' => '<p>There was a conflict with this action, and it could not be completed.</p>', 'refs' => [], ], 'CooldownTime' => [ 'base' => NULL, 'refs' => [ 'AutoScalingConfiguration$scaleInCooldownSeconds' => '<p>The duration in seconds that FinSpace will wait after a scale in event before initiating another scaling event.</p>', 'AutoScalingConfiguration$scaleOutCooldownSeconds' => '<p>The duration in seconds that FinSpace will wait after a scale out event before initiating another scaling event.</p>', ], ], 'CpuCount' => [ 'base' => NULL, 'refs' => [ 'KxScalingGroupConfiguration$cpu' => '<p> The number of vCPUs that you want to reserve for each node of this kdb cluster on the scaling group host. </p>', ], ], 'CreateEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxChangesetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxChangesetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxDataviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxDataviewResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxScalingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxScalingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateKxVolumeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomDNSConfiguration' => [ 'base' => NULL, 'refs' => [ 'GetKxEnvironmentResponse$customDNSConfiguration' => '<p>A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.</p>', 'KxEnvironment$customDNSConfiguration' => '<p>A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.</p>', 'UpdateKxEnvironmentNetworkRequest$customDNSConfiguration' => '<p>A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.</p>', 'UpdateKxEnvironmentNetworkResponse$customDNSConfiguration' => '<p>A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.</p>', 'UpdateKxEnvironmentResponse$customDNSConfiguration' => '<p>A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.</p>', ], ], 'CustomDNSServer' => [ 'base' => '<p>A list of DNS server name and server IP. This is used to set up Route-53 outbound resolvers.</p>', 'refs' => [ 'CustomDNSConfiguration$member' => NULL, ], ], 'DataBundleArn' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the data bundle.</p>', 'refs' => [ 'DataBundleArns$member' => NULL, ], ], 'DataBundleArns' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$dataBundles' => '<p>The list of Amazon Resource Names (ARN) of the data bundles to install. Currently supported data bundle ARNs:</p> <ul> <li> <p> <code>arn:aws:finspace:${Region}::data-bundle/capital-markets-sample</code> - Contains sample Capital Markets datasets, categories and controlled vocabularies.</p> </li> <li> <p> <code>arn:aws:finspace:${Region}::data-bundle/taq</code> (default) - Contains trades and quotes data in addition to sample Capital Markets data.</p> </li> </ul>', ], ], 'DatabaseArn' => [ 'base' => NULL, 'refs' => [ 'CreateKxDatabaseResponse$databaseArn' => '<p>The ARN identifier of the database.</p>', 'GetKxDatabaseResponse$databaseArn' => '<p>The ARN identifier of the database.</p>', ], ], 'DatabaseName' => [ 'base' => NULL, 'refs' => [ 'CreateKxChangesetRequest$databaseName' => '<p>The name of the kdb database.</p>', 'CreateKxChangesetResponse$databaseName' => '<p>The name of the kdb database.</p>', 'CreateKxDatabaseRequest$databaseName' => '<p>The name of the kdb database.</p>', 'CreateKxDatabaseResponse$databaseName' => '<p>The name of the kdb database.</p>', 'CreateKxDataviewRequest$databaseName' => '<p> The name of the database where you want to create a dataview. </p>', 'CreateKxDataviewResponse$databaseName' => '<p>The name of the database where you want to create a dataview.</p>', 'DeleteKxDatabaseRequest$databaseName' => '<p>The name of the kdb database that you want to delete.</p>', 'DeleteKxDataviewRequest$databaseName' => '<p>The name of the database whose dataview you want to delete.</p>', 'GetKxChangesetRequest$databaseName' => '<p>The name of the kdb database.</p>', 'GetKxChangesetResponse$databaseName' => '<p>The name of the kdb database.</p>', 'GetKxDatabaseRequest$databaseName' => '<p>The name of the kdb database.</p>', 'GetKxDatabaseResponse$databaseName' => '<p>The name of the kdb database for which the information is retrieved.</p>', 'GetKxDataviewRequest$databaseName' => '<p> The name of the database where you created the dataview.</p>', 'GetKxDataviewResponse$databaseName' => '<p> The name of the database where you created the dataview.</p>', 'KxDatabaseConfiguration$databaseName' => '<p>The name of the kdb database. When this parameter is specified in the structure, S3 with the whole database is included by default.</p>', 'KxDatabaseListEntry$databaseName' => '<p>The name of the kdb database.</p>', 'KxDataviewListEntry$databaseName' => '<p> A unique identifier of the database.</p>', 'ListKxChangesetsRequest$databaseName' => '<p>The name of the kdb database.</p>', 'ListKxDataviewsRequest$databaseName' => '<p> The name of the database where the dataviews were created.</p>', 'UpdateKxDatabaseRequest$databaseName' => '<p>The name of the kdb database.</p>', 'UpdateKxDatabaseResponse$databaseName' => '<p>The name of the kdb database.</p>', 'UpdateKxDataviewRequest$databaseName' => '<p> The name of the database.</p>', 'UpdateKxDataviewResponse$databaseName' => '<p> The name of the database. </p>', ], ], 'DbPath' => [ 'base' => NULL, 'refs' => [ 'ChangeRequest$dbPath' => '<p>Defines the path within the database directory. </p>', 'DbPaths$member' => NULL, 'SegmentConfigurationDbPathList$member' => NULL, ], ], 'DbPaths' => [ 'base' => NULL, 'refs' => [ 'KxDatabaseCacheConfiguration$dbPaths' => '<p>Specifies the portions of database that will be loaded into the cache for access.</p>', ], ], 'DeleteEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxClusterNodeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxClusterNodeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxDataviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxDataviewResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxScalingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxScalingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteKxVolumeResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$description' => '<p>The description of the FinSpace environment to be created.</p>', 'CreateKxDatabaseRequest$description' => '<p>A description of the database.</p>', 'CreateKxDatabaseResponse$description' => '<p>A description of the database.</p>', 'CreateKxDataviewRequest$description' => '<p>A description of the dataview.</p>', 'CreateKxDataviewResponse$description' => '<p>A description of the dataview.</p>', 'CreateKxEnvironmentRequest$description' => '<p>A description for the kdb environment.</p>', 'CreateKxEnvironmentResponse$description' => '<p>A description for the kdb environment.</p>', 'CreateKxVolumeRequest$description' => '<p> A description of the volume. </p>', 'CreateKxVolumeResponse$description' => '<p> A description of the volume. </p>', 'Environment$description' => '<p>The description of the FinSpace environment.</p>', 'GetKxDatabaseResponse$description' => '<p>A description of the database.</p>', 'GetKxDataviewResponse$description' => '<p>A description of the dataview.</p>', 'GetKxEnvironmentResponse$description' => '<p>A description for the kdb environment.</p>', 'GetKxVolumeResponse$description' => '<p> A description of the volume. </p>', 'KxDataviewListEntry$description' => '<p> A description for the dataview list entry.</p>', 'KxEnvironment$description' => '<p>A description of the kdb environment.</p>', 'KxVolume$description' => '<p> A description of the volume. </p>', 'UpdateEnvironmentRequest$description' => '<p>The description of the environment.</p>', 'UpdateKxDatabaseRequest$description' => '<p>A description of the database.</p>', 'UpdateKxDatabaseResponse$description' => '<p>A description of the database.</p>', 'UpdateKxDataviewRequest$description' => '<p> The description for a dataview. </p>', 'UpdateKxDataviewResponse$description' => '<p>A description of the dataview.</p>', 'UpdateKxEnvironmentNetworkResponse$description' => '<p>The description of the environment.</p>', 'UpdateKxEnvironmentRequest$description' => '<p>A description of the kdb environment.</p>', 'UpdateKxEnvironmentResponse$description' => '<p>The description of the environment.</p>', 'UpdateKxVolumeRequest$description' => '<p> A description of the volume. </p>', 'UpdateKxVolumeResponse$description' => '<p> The description for the volume. </p>', ], ], 'EmailId' => [ 'base' => NULL, 'refs' => [ 'SuperuserParameters$emailAddress' => '<p>The email address of the superuser.</p>', ], ], 'Environment' => [ 'base' => '<p>Represents an FinSpace environment.</p>', 'refs' => [ 'EnvironmentList$member' => NULL, 'GetEnvironmentResponse$environment' => '<p>The name of the FinSpace environment.</p>', 'UpdateEnvironmentResponse$environment' => '<p>Returns the FinSpace environment object.</p>', ], ], 'EnvironmentArn' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentResponse$environmentArn' => '<p>The Amazon Resource Name (ARN) of the FinSpace environment that you created.</p>', 'CreateKxEnvironmentResponse$environmentArn' => '<p>The ARN identifier of the environment.</p>', 'Environment$environmentArn' => '<p>The Amazon Resource Name (ARN) of your FinSpace environment.</p>', 'GetKxEnvironmentResponse$environmentArn' => '<p>The ARN identifier of the environment.</p>', 'KxEnvironment$environmentArn' => '<p>The Amazon Resource Name (ARN) of your kdb environment.</p>', 'UpdateKxEnvironmentNetworkResponse$environmentArn' => '<p>The ARN identifier of the environment.</p>', 'UpdateKxEnvironmentResponse$environmentArn' => '<p>The ARN identifier of the environment.</p>', ], ], 'EnvironmentErrorMessage' => [ 'base' => NULL, 'refs' => [ 'GetKxEnvironmentResponse$errorMessage' => '<p>Specifies the error message that appears if a flow fails.</p>', 'KxEnvironment$errorMessage' => '<p>Specifies the error message that appears if a flow fails. </p>', 'UpdateKxEnvironmentNetworkResponse$errorMessage' => '<p>Specifies the error message that appears if a flow fails.</p>', 'UpdateKxEnvironmentResponse$errorMessage' => '<p>Specifies the error message that appears if a flow fails.</p>', ], ], 'EnvironmentId' => [ 'base' => NULL, 'refs' => [ 'CreateKxChangesetRequest$environmentId' => '<p>A unique identifier of the kdb environment.</p>', 'CreateKxChangesetResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'CreateKxDatabaseRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'CreateKxDatabaseResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'CreateKxDataviewRequest$environmentId' => '<p>A unique identifier for the kdb environment, where you want to create the dataview. </p>', 'CreateKxDataviewResponse$environmentId' => '<p>A unique identifier for the kdb environment, where you want to create the dataview. </p>', 'DeleteKxDatabaseRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'DeleteKxDataviewRequest$environmentId' => '<p>A unique identifier for the kdb environment, from where you want to delete the dataview. </p>', 'GetKxChangesetRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'GetKxChangesetResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'GetKxDatabaseRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'GetKxDatabaseResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'GetKxDataviewRequest$environmentId' => '<p>A unique identifier for the kdb environment, from where you want to retrieve the dataview details.</p>', 'GetKxDataviewResponse$environmentId' => '<p>A unique identifier for the kdb environment, from where you want to retrieve the dataview details.</p>', 'KxDataviewListEntry$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'ListKxChangesetsRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'ListKxDatabasesRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'ListKxDataviewsRequest$environmentId' => '<p>A unique identifier for the kdb environment, for which you want to retrieve a list of dataviews.</p>', 'UpdateKxDatabaseRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'UpdateKxDatabaseResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'UpdateKxDataviewRequest$environmentId' => '<p>A unique identifier for the kdb environment, where you want to update the dataview.</p>', 'UpdateKxDataviewResponse$environmentId' => '<p>A unique identifier for the kdb environment, where you want to update the dataview.</p>', ], ], 'EnvironmentList' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsResponse$environments' => '<p>A list of all of your FinSpace environments.</p>', ], ], 'EnvironmentName' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$name' => '<p>The name of the FinSpace environment to be created.</p>', 'Environment$name' => '<p>The name of the FinSpace environment.</p>', 'UpdateEnvironmentRequest$name' => '<p>The name of the environment.</p>', ], ], 'EnvironmentStatus' => [ 'base' => NULL, 'refs' => [ 'CreateKxEnvironmentResponse$status' => '<p>The status of the kdb environment.</p>', 'Environment$status' => '<p>The current status of creation of the FinSpace environment.</p>', 'GetKxEnvironmentResponse$status' => '<p>The status of the kdb environment.</p>', 'KxEnvironment$status' => '<p>The status of the environment creation. </p> <ul> <li> <p>CREATE_REQUESTED – Environment creation has been requested.</p> </li> <li> <p>CREATING – Environment is in the process of being created.</p> </li> <li> <p>FAILED_CREATION – Environment creation has failed.</p> </li> <li> <p>CREATED – Environment is successfully created and is currently active.</p> </li> <li> <p>DELETE REQUESTED – Environment deletion has been requested.</p> </li> <li> <p>DELETING – Environment is in the process of being deleted.</p> </li> <li> <p>RETRY_DELETION – Initial environment deletion failed, system is reattempting delete.</p> </li> <li> <p>DELETED – Environment has been deleted.</p> </li> <li> <p>FAILED_DELETION – Environment deletion has failed.</p> </li> </ul>', 'UpdateKxEnvironmentNetworkResponse$status' => '<p>The status of the kdb environment.</p>', 'UpdateKxEnvironmentResponse$status' => '<p>The status of the kdb environment.</p>', ], ], 'ErrorDetails' => [ 'base' => NULL, 'refs' => [ 'ErrorInfo$errorType' => '<p>Specifies the type of error.</p>', ], ], 'ErrorInfo' => [ 'base' => '<p>Provides details in the event of a failed flow, including the error type and the related error message.</p>', 'refs' => [ 'CreateKxChangesetResponse$errorInfo' => '<p>The details of the error that you receive when creating a changeset. It consists of the type of error and the error message.</p>', 'GetKxChangesetResponse$errorInfo' => '<p>Provides details in the event of a failed flow, including the error type and the related error message.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ErrorInfo$errorMessage' => '<p>Specifies the error message that appears if a flow fails. </p>', ], ], 'ExecutionRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterRequest$executionRole' => '<p>An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster.</p>', 'CreateKxClusterResponse$executionRole' => '<p> An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster. </p>', 'GetKxClusterResponse$executionRole' => '<p> An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster. </p>', 'KxCluster$executionRole' => '<p> An IAM role that defines a set of permissions associated with a cluster. These permissions are assumed when a cluster attempts to access another cluster. </p>', ], ], 'FederationAttributeKey' => [ 'base' => NULL, 'refs' => [ 'AttributeMap$key' => NULL, ], ], 'FederationAttributeValue' => [ 'base' => NULL, 'refs' => [ 'AttributeMap$value' => NULL, ], ], 'FederationMode' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$federationMode' => '<p>Authentication mode for the environment.</p> <ul> <li> <p> <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.</p> </li> <li> <p> <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace environment.</p> </li> </ul>', 'Environment$federationMode' => '<p>The authentication mode for the environment.</p>', 'UpdateEnvironmentRequest$federationMode' => '<p>Authentication mode for the environment.</p> <ul> <li> <p> <code>FEDERATED</code> - Users access FinSpace through Single Sign On (SSO) via your Identity provider.</p> </li> <li> <p> <code>LOCAL</code> - Users access FinSpace via email and password managed within the FinSpace environment.</p> </li> </ul>', ], ], 'FederationParameters' => [ 'base' => '<p>Configuration information when authentication mode is FEDERATED.</p>', 'refs' => [ 'CreateEnvironmentRequest$federationParameters' => '<p>Configuration information when authentication mode is FEDERATED.</p>', 'Environment$federationParameters' => '<p>Configuration information when authentication mode is FEDERATED.</p>', 'UpdateEnvironmentRequest$federationParameters' => NULL, ], ], 'FederationProviderName' => [ 'base' => NULL, 'refs' => [ 'FederationParameters$federationProviderName' => '<p>Name of the identity provider (IdP).</p>', ], ], 'FinSpaceTaggableArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name of the resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) for the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>A FinSpace resource from which you want to remove a tag or tags. The value for this parameter is an Amazon Resource Name (ARN).</p>', ], ], 'GetEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKxChangesetRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKxChangesetResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKxClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKxClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKxConnectionStringRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKxConnectionStringResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKxDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKxDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKxDataviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKxDataviewResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKxEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKxEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKxScalingGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKxScalingGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKxUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKxUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetKxVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetKxVolumeResponse' => [ 'base' => NULL, 'refs' => [], ], 'IPAddressType' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$ipAddressType' => '<p>The IP address type for cluster network configuration parameters. The following type is available:</p> <ul> <li> <p>IP_V4 – IP address version 4</p> </li> </ul>', ], ], 'IcmpTypeCode' => [ 'base' => '<p> Defines the ICMP protocol that consists of the ICMP type and code. </p>', 'refs' => [ 'NetworkACLEntry$icmpTypeCode' => '<p> Defines the ICMP protocol that consists of the ICMP type and code. </p>', ], ], 'IcmpTypeOrCode' => [ 'base' => NULL, 'refs' => [ 'IcmpTypeCode$type' => '<p>The ICMP type. A value of <i>-1</i> means all types. </p>', 'IcmpTypeCode$code' => '<p> The ICMP code. A value of <i>-1</i> means all codes for the specified ICMP type. </p>', ], ], 'IdType' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentResponse$environmentId' => '<p>The unique identifier for FinSpace environment that you created.</p>', 'CreateKxEnvironmentResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'CreateKxUserRequest$environmentId' => '<p>A unique identifier for the kdb environment where you want to create a user.</p>', 'CreateKxUserResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'DeleteEnvironmentRequest$environmentId' => '<p>The identifier for the FinSpace environment.</p>', 'DeleteKxEnvironmentRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'DeleteKxUserRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'Environment$environmentId' => '<p>The identifier of the FinSpace environment.</p>', 'Environment$awsAccountId' => '<p>The ID of the AWS account in which the FinSpace environment is created.</p>', 'Environment$dedicatedServiceAccountId' => '<p>The AWS account ID of the dedicated service account associated with your FinSpace environment.</p>', 'GetEnvironmentRequest$environmentId' => '<p>The identifier of the FinSpace environment.</p>', 'GetKxConnectionStringRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'GetKxEnvironmentRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'GetKxEnvironmentResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'GetKxEnvironmentResponse$awsAccountId' => '<p>The unique identifier of the AWS account that is used to create the kdb environment.</p>', 'GetKxEnvironmentResponse$dedicatedServiceAccountId' => '<p>A unique identifier for the AWS environment infrastructure account.</p>', 'GetKxUserRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'GetKxUserResponse$userName' => '<p>A unique identifier for the user.</p>', 'GetKxUserResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'KxEnvironment$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'KxEnvironment$awsAccountId' => '<p>The unique identifier of the AWS account in which you create the kdb environment.</p>', 'KxEnvironment$dedicatedServiceAccountId' => '<p>A unique identifier for the AWS environment infrastructure account.</p>', 'ListKxUsersRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'UpdateEnvironmentRequest$environmentId' => '<p>The identifier of the FinSpace environment.</p>', 'UpdateKxEnvironmentNetworkRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'UpdateKxEnvironmentNetworkResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'UpdateKxEnvironmentNetworkResponse$awsAccountId' => '<p>The unique identifier of the AWS account that is used to create the kdb environment.</p>', 'UpdateKxEnvironmentNetworkResponse$dedicatedServiceAccountId' => '<p>A unique identifier for the AWS environment infrastructure account.</p>', 'UpdateKxEnvironmentRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'UpdateKxEnvironmentResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'UpdateKxEnvironmentResponse$awsAccountId' => '<p>The unique identifier of the AWS account that is used to create the kdb environment.</p>', 'UpdateKxEnvironmentResponse$dedicatedServiceAccountId' => '<p>A unique identifier for the AWS environment infrastructure account.</p>', 'UpdateKxUserRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'UpdateKxUserResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', ], ], 'InitializationScriptFilePath' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterRequest$initializationScript' => '<p>Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i> file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, <code>somedir/init.q</code>.</p>', 'CreateKxClusterResponse$initializationScript' => '<p>Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i> file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, <code>somedir/init.q</code>.</p>', 'GetKxClusterResponse$initializationScript' => '<p>Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i> file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, <code>somedir/init.q</code>.</p>', 'KxCluster$initializationScript' => '<p>Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i> file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, <code>somedir/init.q</code>.</p>', 'UpdateKxClusterCodeConfigurationRequest$initializationScript' => '<p>Specifies a Q program that will be run at launch of a cluster. It is a relative path within <i>.zip</i> file that contains the custom code, which will be loaded on the cluster. It must include the file name itself. For example, <code>somedir/init.q</code>.</p> <p>You cannot update this parameter for a <code>NO_RESTART</code> deployment.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The request is invalid. Something is wrong with the input to the request.</p>', 'refs' => [], ], 'KmsKeyARN' => [ 'base' => NULL, 'refs' => [ 'CreateKxEnvironmentRequest$kmsKeyId' => '<p>The KMS key ID to encrypt your data in the FinSpace environment.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$kmsKeyId' => '<p>The KMS key id to encrypt your data in the FinSpace environment.</p>', 'CreateKxEnvironmentResponse$kmsKeyId' => '<p>The KMS key ID to encrypt your data in the FinSpace environment.</p>', 'Environment$kmsKeyId' => '<p>The KMS key id used to encrypt in the FinSpace environment.</p>', 'GetKxEnvironmentResponse$kmsKeyId' => '<p>The KMS key ID to encrypt your data in the FinSpace environment.</p>', 'KxEnvironment$kmsKeyId' => '<p>The unique identifier of the KMS key.</p>', 'UpdateKxEnvironmentNetworkResponse$kmsKeyId' => '<p>The KMS key ID to encrypt your data in the FinSpace environment.</p>', 'UpdateKxEnvironmentResponse$kmsKeyId' => '<p>The KMS key ID to encrypt your data in the FinSpace environment.</p>', ], ], 'KxAttachedCluster' => [ 'base' => '<p>The structure containing the metadata of the attached clusters.</p>', 'refs' => [ 'KxAttachedClusters$member' => NULL, ], ], 'KxAttachedClusters' => [ 'base' => NULL, 'refs' => [ 'GetKxVolumeResponse$attachedClusters' => '<p> A list of cluster identifiers that a volume is attached to. </p>', 'UpdateKxVolumeResponse$attachedClusters' => '<p> Specifies the clusters that a volume is attached to. </p>', ], ], 'KxAzMode' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterRequest$azMode' => '<p>The number of availability zones you want to assign per cluster. This can be one of the following </p> <ul> <li> <p> <code>SINGLE</code> – Assigns one availability zone per cluster.</p> </li> <li> <p> <code>MULTI</code> – Assigns all the availability zones per cluster.</p> </li> </ul>', 'CreateKxClusterResponse$azMode' => '<p>The number of availability zones you want to assign per cluster. This can be one of the following </p> <ul> <li> <p> <code>SINGLE</code> – Assigns one availability zone per cluster.</p> </li> <li> <p> <code>MULTI</code> – Assigns all the availability zones per cluster.</p> </li> </ul>', 'CreateKxDataviewRequest$azMode' => '<p>The number of availability zones you want to assign per volume. Currently, FinSpace only supports <code>SINGLE</code> for volumes. This places dataview in a single AZ.</p>', 'CreateKxDataviewResponse$azMode' => '<p>The number of availability zones you want to assign per volume. Currently, FinSpace only supports <code>SINGLE</code> for volumes. This places dataview in a single AZ.</p>', 'CreateKxVolumeRequest$azMode' => '<p>The number of availability zones you want to assign per volume. Currently, FinSpace only supports <code>SINGLE</code> for volumes. This places dataview in a single AZ.</p>', 'CreateKxVolumeResponse$azMode' => '<p>The number of availability zones you want to assign per volume. Currently, FinSpace only supports <code>SINGLE</code> for volumes. This places dataview in a single AZ.</p>', 'GetKxClusterResponse$azMode' => '<p>The number of availability zones you want to assign per cluster. This can be one of the following </p> <ul> <li> <p> <code>SINGLE</code> – Assigns one availability zone per cluster.</p> </li> <li> <p> <code>MULTI</code> – Assigns all the availability zones per cluster.</p> </li> </ul>', 'GetKxDataviewResponse$azMode' => '<p>The number of availability zones you want to assign per volume. Currently, FinSpace only supports <code>SINGLE</code> for volumes. This places dataview in a single AZ.</p>', 'GetKxVolumeResponse$azMode' => '<p>The number of availability zones you want to assign per volume. Currently, FinSpace only supports <code>SINGLE</code> for volumes. This places dataview in a single AZ.</p>', 'KxCluster$azMode' => '<p>The number of availability zones assigned per cluster. This can be one of the following:</p> <ul> <li> <p> <code>SINGLE</code> – Assigns one availability zone per cluster.</p> </li> <li> <p> <code>MULTI</code> – Assigns all the availability zones per cluster.</p> </li> </ul>', 'KxDataviewListEntry$azMode' => '<p>The number of availability zones you want to assign per volume. Currently, FinSpace only supports <code>SINGLE</code> for volumes. This places dataview in a single AZ.</p>', 'KxVolume$azMode' => '<p>The number of availability zones you want to assign per volume. Currently, FinSpace only supports <code>SINGLE</code> for volumes. This places dataview in a single AZ.</p>', 'UpdateKxDataviewResponse$azMode' => '<p>The number of availability zones you want to assign per volume. Currently, FinSpace only supports <code>SINGLE</code> for volumes. This places dataview in a single AZ.</p>', 'UpdateKxVolumeResponse$azMode' => '<p>The number of availability zones you want to assign per volume. Currently, FinSpace only supports <code>SINGLE</code> for volumes. This places dataview in a single AZ.</p>', ], ], 'KxCacheStorageConfiguration' => [ 'base' => '<p>The configuration for read only disk cache associated with a cluster.</p>', 'refs' => [ 'KxCacheStorageConfigurations$member' => NULL, ], ], 'KxCacheStorageConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterRequest$cacheStorageConfigurations' => '<p>The configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. </p>', 'CreateKxClusterResponse$cacheStorageConfigurations' => '<p>The configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. </p>', 'GetKxClusterResponse$cacheStorageConfigurations' => '<p>The configurations for a read only cache storage associated with a cluster. This cache will be stored as an FSx Lustre that reads from the S3 store. </p>', ], ], 'KxCacheStorageSize' => [ 'base' => NULL, 'refs' => [ 'KxCacheStorageConfiguration$size' => '<p>The size of cache in Gigabytes.</p>', ], ], 'KxCacheStorageType' => [ 'base' => NULL, 'refs' => [ 'KxCacheStorageConfiguration$type' => '<p>The type of cache storage. The valid values are: </p> <ul> <li> <p>CACHE_1000 – This type provides at least 1000 MB/s disk access throughput. </p> </li> <li> <p>CACHE_250 – This type provides at least 250 MB/s disk access throughput. </p> </li> <li> <p>CACHE_12 – This type provides at least 12 MB/s disk access throughput. </p> </li> </ul> <p>For cache type <code>CACHE_1000</code> and <code>CACHE_250</code> you can select cache size as 1200 GB or increments of 2400 GB. For cache type <code>CACHE_12</code> you can select the cache size in increments of 6000 GB.</p>', 'KxDatabaseCacheConfiguration$cacheType' => '<p>The type of disk cache. This parameter is used to map the database path to cache storage. The valid values are:</p> <ul> <li> <p>CACHE_1000 – This type provides at least 1000 MB/s disk access throughput. </p> </li> </ul>', ], ], 'KxChangesetListEntry' => [ 'base' => '<p>Details of changeset.</p>', 'refs' => [ 'KxChangesets$member' => NULL, ], ], 'KxChangesets' => [ 'base' => NULL, 'refs' => [ 'ListKxChangesetsResponse$kxChangesets' => '<p>A list of changesets for a database.</p>', ], ], 'KxCluster' => [ 'base' => '<p>The details of a kdb cluster.</p>', 'refs' => [ 'KxClusters$member' => NULL, ], ], 'KxClusterCodeDeploymentConfiguration' => [ 'base' => '<p> The configuration that allows you to choose how you want to update code on a cluster. Depending on the option you choose, you can reduce the time it takes to update the cluster. </p>', 'refs' => [ 'UpdateKxClusterCodeConfigurationRequest$deploymentConfiguration' => '<p> The configuration that allows you to choose how you want to update the code on a cluster. </p>', ], ], 'KxClusterCodeDeploymentStrategy' => [ 'base' => NULL, 'refs' => [ 'KxClusterCodeDeploymentConfiguration$deploymentStrategy' => '<p> The type of deployment that you want on a cluster. </p> <ul> <li> <p>ROLLING – This options updates the cluster by stopping the exiting q process and starting a new q process with updated configuration.</p> </li> <li> <p>NO_RESTART – This option updates the cluster without stopping the running q process. It is only available for <code>GP</code> type cluster. This option is quicker as it reduces the turn around time to update configuration on a cluster. </p> <p>With this deployment mode, you cannot update the <code>initializationScript</code> and <code>commandLineArguments</code> parameters.</p> </li> <li> <p>FORCE – This option updates the cluster by immediately stopping all the running processes before starting up new ones with the updated configuration. </p> </li> </ul>', ], ], 'KxClusterDescription' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterRequest$clusterDescription' => '<p>A description of the cluster.</p>', 'CreateKxClusterResponse$clusterDescription' => '<p>A description of the cluster.</p>', 'GetKxClusterResponse$clusterDescription' => '<p>A description of the cluster.</p>', 'KxCluster$clusterDescription' => '<p>A description of the cluster.</p>', ], ], 'KxClusterName' => [ 'base' => NULL, 'refs' => [ 'AttachedClusterList$member' => NULL, 'CreateKxClusterRequest$clusterName' => '<p>A unique name for the cluster that you want to create.</p>', 'CreateKxClusterResponse$clusterName' => '<p>A unique name for the cluster.</p>', 'DeleteKxClusterNodeRequest$clusterName' => '<p>The name of the cluster, for which you want to delete the nodes.</p>', 'DeleteKxClusterRequest$clusterName' => '<p>The name of the cluster that you want to delete.</p>', 'GetKxClusterRequest$clusterName' => '<p>The name of the cluster that you want to retrieve.</p>', 'GetKxClusterResponse$clusterName' => '<p>A unique name for the cluster.</p>', 'GetKxConnectionStringRequest$clusterName' => '<p>A name of the kdb cluster.</p>', 'KxAttachedCluster$clusterName' => '<p>A unique name for the attached cluster.</p>', 'KxCluster$clusterName' => '<p>A unique name for the cluster.</p>', 'KxClusterNameList$member' => NULL, 'ListKxClusterNodesRequest$clusterName' => '<p>A unique name for the cluster.</p>', 'UpdateKxClusterCodeConfigurationRequest$clusterName' => '<p>The name of the cluster.</p>', 'UpdateKxClusterDatabasesRequest$clusterName' => '<p>A unique name for the cluster that you want to modify.</p>', ], ], 'KxClusterNameList' => [ 'base' => NULL, 'refs' => [ 'GetKxScalingGroupResponse$clusters' => '<p> The list of Managed kdb clusters that are currently active in the given scaling group. </p>', 'KxScalingGroup$clusters' => '<p> The list of clusters currently active in a given scaling group. </p>', ], ], 'KxClusterNodeIdString' => [ 'base' => NULL, 'refs' => [ 'DeleteKxClusterNodeRequest$nodeId' => '<p>A unique identifier for the node that you want to delete.</p>', 'KxNode$nodeId' => '<p>A unique identifier for the node.</p>', ], ], 'KxClusterStatus' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterResponse$status' => '<p>The status of cluster creation.</p> <ul> <li> <p>PENDING – The cluster is pending creation.</p> </li> <li> <p>CREATING – The cluster creation process is in progress.</p> </li> <li> <p>CREATE_FAILED – The cluster creation process has failed.</p> </li> <li> <p>RUNNING – The cluster creation process is running.</p> </li> <li> <p>UPDATING – The cluster is in the process of being updated.</p> </li> <li> <p>DELETING – The cluster is in the process of being deleted.</p> </li> <li> <p>DELETED – The cluster has been deleted.</p> </li> <li> <p>DELETE_FAILED – The cluster failed to delete.</p> </li> </ul>', 'GetKxClusterResponse$status' => '<p>The status of cluster creation.</p> <ul> <li> <p>PENDING – The cluster is pending creation.</p> </li> <li> <p>CREATING – The cluster creation process is in progress.</p> </li> <li> <p>CREATE_FAILED – The cluster creation process has failed.</p> </li> <li> <p>RUNNING – The cluster creation process is running.</p> </li> <li> <p>UPDATING – The cluster is in the process of being updated.</p> </li> <li> <p>DELETING – The cluster is in the process of being deleted.</p> </li> <li> <p>DELETED – The cluster has been deleted.</p> </li> <li> <p>DELETE_FAILED – The cluster failed to delete.</p> </li> </ul>', 'KxAttachedCluster$clusterStatus' => '<p>The status of the attached cluster.</p> <ul> <li> <p>PENDING – The cluster is pending creation.</p> </li> <li> <p>CREATING – The cluster creation process is in progress.</p> </li> <li> <p>CREATE_FAILED – The cluster creation process has failed.</p> </li> <li> <p>RUNNING – The cluster creation process is running.</p> </li> <li> <p>UPDATING – The cluster is in the process of being updated.</p> </li> <li> <p>DELETING – The cluster is in the process of being deleted.</p> </li> <li> <p>DELETED – The cluster has been deleted.</p> </li> <li> <p>DELETE_FAILED – The cluster failed to delete.</p> </li> </ul>', 'KxCluster$status' => '<p>The status of a cluster.</p> <ul> <li> <p>PENDING – The cluster is pending creation.</p> </li> <li> <p>CREATING –The cluster creation process is in progress.</p> </li> <li> <p>CREATE_FAILED– The cluster creation process has failed.</p> </li> <li> <p>RUNNING – The cluster creation process is running.</p> </li> <li> <p>UPDATING – The cluster is in the process of being updated.</p> </li> <li> <p> DELETING – The cluster is in the process of being deleted.</p> </li> <li> <p>DELETED – The cluster has been deleted.</p> </li> <li> <p>DELETE_FAILED – The cluster failed to delete.</p> </li> </ul>', ], ], 'KxClusterStatusReason' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterResponse$statusReason' => '<p>The error message when a failed state occurs. </p>', 'GetKxClusterResponse$statusReason' => '<p>The error message when a failed state occurs. </p>', 'GetKxScalingGroupResponse$statusReason' => '<p> The error message when a failed state occurs. </p>', 'KxCluster$statusReason' => '<p>The error message when a failed state occurs. </p>', 'KxScalingGroup$statusReason' => '<p> The error message when a failed state occurs. </p>', ], ], 'KxClusterType' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterRequest$clusterType' => '<p>Specifies the type of KDB database that is being created. The following types are available: </p> <ul> <li> <p>HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed kdb databases mounted to the cluster.</p> </li> <li> <p>RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.</p> </li> <li> <p>GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a writable local storage.</p> </li> <li> <p>GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.</p> </li> <li> <p>Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.</p> </li> </ul>', 'CreateKxClusterResponse$clusterType' => '<p>Specifies the type of KDB database that is being created. The following types are available: </p> <ul> <li> <p>HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed kdb databases mounted to the cluster.</p> </li> <li> <p>RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.</p> </li> <li> <p>GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a writable local storage.</p> </li> <li> <p>GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.</p> </li> <li> <p>Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.</p> </li> </ul>', 'GetKxClusterResponse$clusterType' => '<p>Specifies the type of KDB database that is being created. The following types are available: </p> <ul> <li> <p>HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed kdb databases mounted to the cluster.</p> </li> <li> <p>RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.</p> </li> <li> <p>GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a writable local storage.</p> </li> <li> <p>GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.</p> </li> <li> <p>Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.</p> </li> </ul>', 'KxAttachedCluster$clusterType' => '<p>Specifies the type of cluster. The volume for TP and RDB cluster types will be used for TP logs.</p>', 'KxCluster$clusterType' => '<p>Specifies the type of KDB database that is being created. The following types are available: </p> <ul> <li> <p>HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed kdb databases mounted to the cluster.</p> </li> <li> <p>RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.</p> </li> <li> <p>GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a writable local storage.</p> </li> <li> <p>GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.</p> </li> <li> <p>Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.</p> </li> </ul>', 'ListKxClustersRequest$clusterType' => '<p>Specifies the type of KDB database that is being created. The following types are available: </p> <ul> <li> <p>HDB – A Historical Database. The data is only accessible with read-only permissions from one of the FinSpace managed kdb databases mounted to the cluster.</p> </li> <li> <p>RDB – A Realtime Database. This type of database captures all the data from a ticker plant and stores it in memory until the end of day, after which it writes all of its data to a disk and reloads the HDB. This cluster type requires local storage for temporary storage of data during the savedown process. If you specify this field in your request, you must provide the <code>savedownStorageConfiguration</code> parameter.</p> </li> <li> <p>GATEWAY – A gateway cluster allows you to access data across processes in kdb systems. It allows you to create your own routing logic using the initialization scripts and custom code. This type of cluster does not require a writable local storage.</p> </li> <li> <p>GP – A general purpose cluster allows you to quickly iterate on code during development by granting greater access to system commands and enabling a fast reload of custom code. This cluster type can optionally mount databases including cache and savedown storage. For this cluster type, the node count is fixed at 1. It does not support autoscaling and supports only <code>SINGLE</code> AZ mode.</p> </li> <li> <p>Tickerplant – A tickerplant cluster allows you to subscribe to feed handlers based on IAM permissions. It can publish to RDBs, other Tickerplants, and real-time subscribers (RTS). Tickerplants can persist messages to log, which is readable by any RDB environment. It supports only single-node that is only one kdb process.</p> </li> </ul>', ], ], 'KxClusters' => [ 'base' => NULL, 'refs' => [ 'ListKxClustersResponse$kxClusterSummaries' => '<p>Lists the cluster details.</p>', ], ], 'KxCommandLineArgument' => [ 'base' => '<p>Defines the key-value pairs to make them available inside the cluster.</p>', 'refs' => [ 'KxCommandLineArguments$member' => NULL, ], ], 'KxCommandLineArgumentKey' => [ 'base' => NULL, 'refs' => [ 'KxCommandLineArgument$key' => '<p>The name of the key.</p>', ], ], 'KxCommandLineArgumentValue' => [ 'base' => NULL, 'refs' => [ 'KxCommandLineArgument$value' => '<p>The value of the key.</p>', ], ], 'KxCommandLineArguments' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterRequest$commandLineArguments' => '<p>Defines the key-value pairs to make them available inside the cluster.</p>', 'CreateKxClusterResponse$commandLineArguments' => '<p>Defines the key-value pairs to make them available inside the cluster.</p>', 'GetKxClusterResponse$commandLineArguments' => '<p>Defines key-value pairs to make them available inside the cluster.</p>', 'UpdateKxClusterCodeConfigurationRequest$commandLineArguments' => '<p>Specifies the key-value pairs to make them available inside the cluster.</p> <p>You cannot update this parameter for a <code>NO_RESTART</code> deployment.</p>', ], ], 'KxDatabaseCacheConfiguration' => [ 'base' => '<p>The structure of database cache configuration that is used for mapping database paths to cache types in clusters.</p>', 'refs' => [ 'KxDatabaseCacheConfigurations$member' => NULL, ], ], 'KxDatabaseCacheConfigurations' => [ 'base' => NULL, 'refs' => [ 'KxDatabaseConfiguration$cacheConfigurations' => '<p>Configuration details for the disk cache used to increase performance reading from a kdb database mounted to the cluster.</p>', ], ], 'KxDatabaseConfiguration' => [ 'base' => '<p>The configuration of data that is available for querying from this database.</p>', 'refs' => [ 'KxDatabaseConfigurations$member' => NULL, ], ], 'KxDatabaseConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterRequest$databases' => '<p>A list of databases that will be available for querying.</p>', 'CreateKxClusterResponse$databases' => '<p>A list of databases that will be available for querying.</p>', 'GetKxClusterResponse$databases' => '<p> A list of databases mounted on the cluster.</p>', 'UpdateKxClusterDatabasesRequest$databases' => '<p> The structure of databases mounted on the cluster.</p>', ], ], 'KxDatabaseListEntry' => [ 'base' => '<p>Details about a FinSpace managed kdb database</p>', 'refs' => [ 'KxDatabases$member' => NULL, ], ], 'KxDatabases' => [ 'base' => NULL, 'refs' => [ 'ListKxDatabasesResponse$kxDatabases' => '<p>A list of databases in the kdb environment.</p>', ], ], 'KxDataviewActiveVersion' => [ 'base' => '<p> The active version of the dataview that is currently in use by this cluster. </p>', 'refs' => [ 'KxDataviewActiveVersionList$member' => NULL, ], ], 'KxDataviewActiveVersionList' => [ 'base' => NULL, 'refs' => [ 'GetKxDataviewResponse$activeVersions' => '<p> The current active changeset versions of the database on the given dataview. </p>', 'KxDataviewListEntry$activeVersions' => '<p> The active changeset versions for the given dataview entry. </p>', 'UpdateKxDataviewResponse$activeVersions' => '<p> The current active changeset versions of the database on the given dataview. </p>', ], ], 'KxDataviewConfiguration' => [ 'base' => '<p> The structure that stores the configuration details of a dataview.</p>', 'refs' => [ 'KxDatabaseConfiguration$dataviewConfiguration' => '<p> The configuration of the dataview to be used with specified cluster. </p>', ], ], 'KxDataviewListEntry' => [ 'base' => '<p> A collection of kdb dataview entries. </p>', 'refs' => [ 'KxDataviews$member' => NULL, ], ], 'KxDataviewName' => [ 'base' => NULL, 'refs' => [ 'CreateKxDataviewRequest$dataviewName' => '<p>A unique identifier for the dataview.</p>', 'CreateKxDataviewResponse$dataviewName' => '<p>A unique identifier for the dataview.</p>', 'DeleteKxDataviewRequest$dataviewName' => '<p>The name of the dataview that you want to delete.</p>', 'GetKxDataviewRequest$dataviewName' => '<p>A unique identifier for the dataview.</p>', 'GetKxDataviewResponse$dataviewName' => '<p>A unique identifier for the dataview.</p>', 'KxDatabaseCacheConfiguration$dataviewName' => '<p> The name of the dataview to be used for caching historical data on disk. </p>', 'KxDatabaseConfiguration$dataviewName' => '<p> The name of the dataview to be used for caching historical data on disk. </p>', 'KxDataviewConfiguration$dataviewName' => '<p> The unique identifier of the dataview.</p>', 'KxDataviewListEntry$dataviewName' => '<p> A unique identifier of the dataview.</p>', 'UpdateKxDataviewRequest$dataviewName' => '<p>The name of the dataview that you want to update.</p>', 'UpdateKxDataviewResponse$dataviewName' => '<p> The name of the database under which the dataview was created. </p>', ], ], 'KxDataviewSegmentConfiguration' => [ 'base' => '<p> The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. </p>', 'refs' => [ 'KxDataviewSegmentConfigurationList$member' => NULL, ], ], 'KxDataviewSegmentConfigurationList' => [ 'base' => NULL, 'refs' => [ 'CreateKxDataviewRequest$segmentConfigurations' => '<p> The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. </p>', 'CreateKxDataviewResponse$segmentConfigurations' => '<p> The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. </p>', 'GetKxDataviewResponse$segmentConfigurations' => '<p> The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. </p>', 'KxDataviewActiveVersion$segmentConfigurations' => '<p> The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. </p>', 'KxDataviewConfiguration$segmentConfigurations' => '<p> The db path and volume configuration for the segmented database.</p>', 'KxDataviewListEntry$segmentConfigurations' => '<p> The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. </p>', 'UpdateKxDataviewRequest$segmentConfigurations' => '<p> The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. </p>', 'UpdateKxDataviewResponse$segmentConfigurations' => '<p> The configuration that contains the database path of the data that you want to place on each selected volume. Each segment must have a unique database path for each volume. If you do not explicitly specify any database path for a volume, they are accessible from the cluster through the default S3/object store segment. </p>', ], ], 'KxDataviewStatus' => [ 'base' => NULL, 'refs' => [ 'CreateKxDataviewResponse$status' => '<p> The status of dataview creation.</p> <ul> <li> <p> <code>CREATING</code> – The dataview creation is in progress.</p> </li> <li> <p> <code>UPDATING</code> – The dataview is in the process of being updated.</p> </li> <li> <p> <code>ACTIVE</code> – The dataview is active.</p> </li> </ul>', 'GetKxDataviewResponse$status' => '<p> The status of dataview creation.</p> <ul> <li> <p> <code>CREATING</code> – The dataview creation is in progress.</p> </li> <li> <p> <code>UPDATING</code> – The dataview is in the process of being updated.</p> </li> <li> <p> <code>ACTIVE</code> – The dataview is active.</p> </li> </ul>', 'KxDataviewListEntry$status' => '<p> The status of a given dataview entry. </p>', 'UpdateKxDataviewResponse$status' => '<p> The status of dataview creation.</p> <ul> <li> <p> <code>CREATING</code> – The dataview creation is in progress.</p> </li> <li> <p> <code>UPDATING</code> – The dataview is in the process of being updated.</p> </li> <li> <p> <code>ACTIVE</code> – The dataview is active.</p> </li> </ul>', ], ], 'KxDataviewStatusReason' => [ 'base' => NULL, 'refs' => [ 'GetKxDataviewResponse$statusReason' => '<p> The error message when a failed state occurs. </p>', 'KxDataviewListEntry$statusReason' => '<p> The error message when a failed state occurs. </p>', ], ], 'KxDataviews' => [ 'base' => NULL, 'refs' => [ 'ListKxDataviewsResponse$kxDataviews' => '<p> The list of kdb dataviews that are currently active for the given database. </p>', ], ], 'KxDeploymentConfiguration' => [ 'base' => '<p> The configuration that allows you to choose how you want to update the databases on a cluster. Depending on the option you choose, you can reduce the time it takes to update the cluster. </p>', 'refs' => [ 'UpdateKxClusterDatabasesRequest$deploymentConfiguration' => '<p> The configuration that allows you to choose how you want to update the databases on a cluster. </p>', ], ], 'KxDeploymentStrategy' => [ 'base' => NULL, 'refs' => [ 'KxDeploymentConfiguration$deploymentStrategy' => '<p> The type of deployment that you want on a cluster. </p> <ul> <li> <p>ROLLING – This options updates the cluster by stopping the exiting q process and starting a new q process with updated configuration.</p> </li> <li> <p>NO_RESTART – This option updates the cluster without stopping the running q process. It is only available for <code>HDB</code> type cluster. This option is quicker as it reduces the turn around time to update configuration on a cluster. </p> <p>With this deployment mode, you cannot update the <code>initializationScript</code> and <code>commandLineArguments</code> parameters.</p> </li> </ul>', ], ], 'KxEnvironment' => [ 'base' => '<p>The details of a kdb environment.</p>', 'refs' => [ 'KxEnvironmentList$member' => NULL, ], ], 'KxEnvironmentId' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'CreateKxClusterResponse$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'CreateKxScalingGroupRequest$environmentId' => '<p>A unique identifier for the kdb environment, where you want to create the scaling group. </p>', 'CreateKxScalingGroupResponse$environmentId' => '<p>A unique identifier for the kdb environment, where you create the scaling group. </p>', 'CreateKxVolumeRequest$environmentId' => '<p>A unique identifier for the kdb environment, whose clusters can attach to the volume. </p>', 'CreateKxVolumeResponse$environmentId' => '<p>A unique identifier for the kdb environment, whose clusters can attach to the volume. </p>', 'DeleteKxClusterNodeRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'DeleteKxClusterRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'DeleteKxScalingGroupRequest$environmentId' => '<p>A unique identifier for the kdb environment, from where you want to delete the dataview. </p>', 'DeleteKxVolumeRequest$environmentId' => '<p>A unique identifier for the kdb environment, whose clusters can attach to the volume. </p>', 'GetKxClusterRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'GetKxScalingGroupRequest$environmentId' => '<p>A unique identifier for the kdb environment. </p>', 'GetKxVolumeRequest$environmentId' => '<p>A unique identifier for the kdb environment, whose clusters can attach to the volume. </p>', 'GetKxVolumeResponse$environmentId' => '<p>A unique identifier for the kdb environment, whose clusters can attach to the volume. </p>', 'ListKxClusterNodesRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'ListKxClustersRequest$environmentId' => '<p>A unique identifier for the kdb environment.</p>', 'ListKxScalingGroupsRequest$environmentId' => '<p>A unique identifier for the kdb environment, for which you want to retrieve a list of scaling groups.</p>', 'ListKxVolumesRequest$environmentId' => '<p>A unique identifier for the kdb environment, whose clusters can attach to the volume. </p>', 'UpdateKxClusterCodeConfigurationRequest$environmentId' => '<p> A unique identifier of the kdb environment. </p>', 'UpdateKxClusterDatabasesRequest$environmentId' => '<p>The unique identifier of a kdb environment.</p>', 'UpdateKxVolumeRequest$environmentId' => '<p>A unique identifier for the kdb environment where you created the storage volume. </p>', 'UpdateKxVolumeResponse$environmentId' => '<p>A unique identifier for the kdb environment where you want to update the volume. </p>', ], ], 'KxEnvironmentList' => [ 'base' => NULL, 'refs' => [ 'ListKxEnvironmentsResponse$environments' => '<p>A list of environments in an account.</p>', ], ], 'KxEnvironmentName' => [ 'base' => NULL, 'refs' => [ 'CreateKxEnvironmentRequest$name' => '<p>The name of the kdb environment that you want to create.</p>', 'CreateKxEnvironmentResponse$name' => '<p>The name of the kdb environment.</p>', 'GetKxEnvironmentResponse$name' => '<p>The name of the kdb environment.</p>', 'KxEnvironment$name' => '<p>The name of the kdb environment.</p>', 'UpdateKxEnvironmentNetworkResponse$name' => '<p>The name of the kdb environment.</p>', 'UpdateKxEnvironmentRequest$name' => '<p>The name of the kdb environment.</p>', 'UpdateKxEnvironmentResponse$name' => '<p>The name of the kdb environment.</p>', ], ], 'KxHostType' => [ 'base' => NULL, 'refs' => [ 'CreateKxScalingGroupRequest$hostType' => '<p> The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be placed.</p> <p>You can add one of the following values:</p> <ul> <li> <p> <code>kx.sg.4xlarge</code> – The host type with a configuration of 108 GiB memory and 16 vCPUs.</p> </li> <li> <p> <code>kx.sg.8xlarge</code> – The host type with a configuration of 216 GiB memory and 32 vCPUs.</p> </li> <li> <p> <code>kx.sg.16xlarge</code> – The host type with a configuration of 432 GiB memory and 64 vCPUs.</p> </li> <li> <p> <code>kx.sg.32xlarge</code> – The host type with a configuration of 864 GiB memory and 128 vCPUs.</p> </li> <li> <p> <code>kx.sg1.16xlarge</code> – The host type with a configuration of 1949 GiB memory and 64 vCPUs.</p> </li> <li> <p> <code>kx.sg1.24xlarge</code> – The host type with a configuration of 2948 GiB memory and 96 vCPUs.</p> </li> </ul>', 'CreateKxScalingGroupResponse$hostType' => '<p> The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be placed. </p>', 'GetKxScalingGroupResponse$hostType' => '<p> The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be placed.</p> <p>It can have one of the following values:</p> <ul> <li> <p> <code>kx.sg.4xlarge</code> – The host type with a configuration of 108 GiB memory and 16 vCPUs.</p> </li> <li> <p> <code>kx.sg.8xlarge</code> – The host type with a configuration of 216 GiB memory and 32 vCPUs.</p> </li> <li> <p> <code>kx.sg.16xlarge</code> – The host type with a configuration of 432 GiB memory and 64 vCPUs.</p> </li> <li> <p> <code>kx.sg.32xlarge</code> – The host type with a configuration of 864 GiB memory and 128 vCPUs.</p> </li> <li> <p> <code>kx.sg1.16xlarge</code> – The host type with a configuration of 1949 GiB memory and 64 vCPUs.</p> </li> <li> <p> <code>kx.sg1.24xlarge</code> – The host type with a configuration of 2948 GiB memory and 96 vCPUs.</p> </li> </ul>', 'KxScalingGroup$hostType' => '<p> The memory and CPU capabilities of the scaling group host on which FinSpace Managed kdb clusters will be placed.</p> <p>You can add one of the following values:</p> <ul> <li> <p> <code>kx.sg.4xlarge</code> – The host type with a configuration of 108 GiB memory and 16 vCPUs.</p> </li> <li> <p> <code>kx.sg.8xlarge</code> – The host type with a configuration of 216 GiB memory and 32 vCPUs.</p> </li> <li> <p> <code>kx.sg.16xlarge</code> – The host type with a configuration of 432 GiB memory and 64 vCPUs.</p> </li> <li> <p> <code>kx.sg.32xlarge</code> – The host type with a configuration of 864 GiB memory and 128 vCPUs.</p> </li> <li> <p> <code>kx.sg1.16xlarge</code> – The host type with a configuration of 1949 GiB memory and 64 vCPUs.</p> </li> <li> <p> <code>kx.sg1.24xlarge</code> – The host type with a configuration of 2948 GiB memory and 96 vCPUs.</p> </li> </ul>', ], ], 'KxNAS1Configuration' => [ 'base' => '<p> The structure containing the size and type of the network attached storage (NAS_1) file system volume. </p>', 'refs' => [ 'CreateKxVolumeRequest$nas1Configuration' => '<p> Specifies the configuration for the Network attached storage (NAS_1) file system volume. This parameter is required when you choose <code>volumeType</code> as <i>NAS_1</i>.</p>', 'CreateKxVolumeResponse$nas1Configuration' => '<p> Specifies the configuration for the Network attached storage (NAS_1) file system volume.</p>', 'GetKxVolumeResponse$nas1Configuration' => '<p> Specifies the configuration for the Network attached storage (NAS_1) file system volume.</p>', 'UpdateKxVolumeRequest$nas1Configuration' => '<p> Specifies the configuration for the Network attached storage (NAS_1) file system volume.</p>', 'UpdateKxVolumeResponse$nas1Configuration' => '<p> Specifies the configuration for the Network attached storage (NAS_1) file system volume.</p>', ], ], 'KxNAS1Size' => [ 'base' => NULL, 'refs' => [ 'KxNAS1Configuration$size' => '<p> The size of the network attached storage. For storage type <code>SSD_1000</code> and <code>SSD_250</code> you can select the minimum size as 1200 GB or increments of 2400 GB. For storage type <code>HDD_12</code> you can select the minimum size as 6000 GB or increments of 6000 GB.</p>', ], ], 'KxNAS1Type' => [ 'base' => NULL, 'refs' => [ 'KxNAS1Configuration$type' => '<p> The type of the network attached storage. </p>', ], ], 'KxNode' => [ 'base' => '<p>A structure that stores metadata for a kdb node.</p>', 'refs' => [ 'KxNodeSummaries$member' => NULL, ], ], 'KxNodeStatus' => [ 'base' => NULL, 'refs' => [ 'KxNode$status' => '<p> Specifies the status of the cluster nodes. </p> <ul> <li> <p> <code>RUNNING</code> – The node is actively serving.</p> </li> <li> <p> <code>PROVISIONING</code> – The node is being prepared.</p> </li> </ul>', ], ], 'KxNodeSummaries' => [ 'base' => NULL, 'refs' => [ 'ListKxClusterNodesResponse$nodes' => '<p>A list of nodes associated with the cluster.</p>', ], ], 'KxSavedownStorageConfiguration' => [ 'base' => '<p>The size and type of temporary storage that is used to hold data during the savedown process. All the data written to this storage space is lost when the cluster node is restarted.</p>', 'refs' => [ 'CreateKxClusterRequest$savedownStorageConfiguration' => '<p>The size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose <code>clusterType</code> as RDB. All the data written to this storage space is lost when the cluster node is restarted.</p>', 'CreateKxClusterResponse$savedownStorageConfiguration' => '<p>The size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose <code>clusterType</code> as RDB. All the data written to this storage space is lost when the cluster node is restarted.</p>', 'GetKxClusterResponse$savedownStorageConfiguration' => '<p>The size and type of the temporary storage that is used to hold data during the savedown process. This parameter is required when you choose <code>clusterType</code> as RDB. All the data written to this storage space is lost when the cluster node is restarted.</p>', ], ], 'KxSavedownStorageSize' => [ 'base' => NULL, 'refs' => [ 'KxSavedownStorageConfiguration$size' => '<p>The size of temporary storage in gibibytes.</p>', ], ], 'KxSavedownStorageType' => [ 'base' => NULL, 'refs' => [ 'KxSavedownStorageConfiguration$type' => '<p>The type of writeable storage space for temporarily storing your savedown data. The valid values are:</p> <ul> <li> <p>SDS01 – This type represents 3000 IOPS and io2 ebs volume type.</p> </li> </ul>', ], ], 'KxScalingGroup' => [ 'base' => '<p> A structure for storing metadata of scaling group.</p>', 'refs' => [ 'KxScalingGroupList$member' => NULL, ], ], 'KxScalingGroupConfiguration' => [ 'base' => '<p>The structure that stores the capacity configuration details of a scaling group.</p>', 'refs' => [ 'CreateKxClusterRequest$scalingGroupConfiguration' => '<p>The structure that stores the configuration details of a scaling group.</p>', 'CreateKxClusterResponse$scalingGroupConfiguration' => '<p>The structure that stores the configuration details of a scaling group.</p>', 'GetKxClusterResponse$scalingGroupConfiguration' => NULL, ], ], 'KxScalingGroupList' => [ 'base' => NULL, 'refs' => [ 'ListKxScalingGroupsResponse$scalingGroups' => '<p> A list of scaling groups available in a kdb environment.</p>', ], ], 'KxScalingGroupName' => [ 'base' => NULL, 'refs' => [ 'CreateKxScalingGroupRequest$scalingGroupName' => '<p>A unique identifier for the kdb scaling group. </p>', 'CreateKxScalingGroupResponse$scalingGroupName' => '<p>A unique identifier for the kdb scaling group. </p>', 'DeleteKxScalingGroupRequest$scalingGroupName' => '<p>A unique identifier for the kdb scaling group. </p>', 'GetKxScalingGroupRequest$scalingGroupName' => '<p>A unique identifier for the kdb scaling group. </p>', 'GetKxScalingGroupResponse$scalingGroupName' => '<p>A unique identifier for the kdb scaling group. </p>', 'KxScalingGroup$scalingGroupName' => '<p>A unique identifier for the kdb scaling group. </p>', 'KxScalingGroupConfiguration$scalingGroupName' => '<p>A unique identifier for the kdb scaling group. </p>', ], ], 'KxScalingGroupStatus' => [ 'base' => NULL, 'refs' => [ 'CreateKxScalingGroupResponse$status' => '<p>The status of scaling group.</p> <ul> <li> <p>CREATING – The scaling group creation is in progress.</p> </li> <li> <p>CREATE_FAILED – The scaling group creation has failed.</p> </li> <li> <p>ACTIVE – The scaling group is active.</p> </li> <li> <p>UPDATING – The scaling group is in the process of being updated.</p> </li> <li> <p>UPDATE_FAILED – The update action failed.</p> </li> <li> <p>DELETING – The scaling group is in the process of being deleted.</p> </li> <li> <p>DELETE_FAILED – The system failed to delete the scaling group.</p> </li> <li> <p>DELETED – The scaling group is successfully deleted.</p> </li> </ul>', 'GetKxScalingGroupResponse$status' => '<p>The status of scaling group.</p> <ul> <li> <p>CREATING – The scaling group creation is in progress.</p> </li> <li> <p>CREATE_FAILED – The scaling group creation has failed.</p> </li> <li> <p>ACTIVE – The scaling group is active.</p> </li> <li> <p>UPDATING – The scaling group is in the process of being updated.</p> </li> <li> <p>UPDATE_FAILED – The update action failed.</p> </li> <li> <p>DELETING – The scaling group is in the process of being deleted.</p> </li> <li> <p>DELETE_FAILED – The system failed to delete the scaling group.</p> </li> <li> <p>DELETED – The scaling group is successfully deleted.</p> </li> </ul>', 'KxScalingGroup$status' => '<p> The status of scaling groups. </p>', ], ], 'KxUser' => [ 'base' => '<p>A structure that stores metadata for a kdb user.</p>', 'refs' => [ 'KxUserList$member' => NULL, ], ], 'KxUserArn' => [ 'base' => NULL, 'refs' => [ 'CreateKxUserResponse$userArn' => '<p> The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs and how to use ARNs in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>. </p>', 'GetKxConnectionStringRequest$userArn' => '<p> The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs and how to use ARNs in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>. </p>', 'GetKxUserResponse$userArn' => '<p> The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs and how to use ARNs in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>. </p>', 'KxUser$userArn' => '<p> The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs and how to use ARNs in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>. </p>', 'UpdateKxUserResponse$userArn' => '<p> The Amazon Resource Name (ARN) that identifies the user. For more information about ARNs and how to use ARNs in policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM Identifiers</a> in the <i>IAM User Guide</i>. </p>', ], ], 'KxUserList' => [ 'base' => NULL, 'refs' => [ 'ListKxUsersResponse$users' => '<p>A list of users in a kdb environment.</p>', ], ], 'KxUserNameString' => [ 'base' => NULL, 'refs' => [ 'CreateKxUserRequest$userName' => '<p>A unique identifier for the user.</p>', 'CreateKxUserResponse$userName' => '<p>A unique identifier for the user.</p>', 'DeleteKxUserRequest$userName' => '<p>A unique identifier for the user that you want to delete.</p>', 'GetKxUserRequest$userName' => '<p>A unique identifier for the user.</p>', 'KxUser$userName' => '<p>A unique identifier for the user.</p>', 'UpdateKxUserRequest$userName' => '<p>A unique identifier for the user.</p>', 'UpdateKxUserResponse$userName' => '<p>A unique identifier for the user.</p>', ], ], 'KxVolume' => [ 'base' => '<p> The structure that contains the metadata of the volume. </p>', 'refs' => [ 'KxVolumes$member' => NULL, ], ], 'KxVolumeArn' => [ 'base' => NULL, 'refs' => [ 'CreateKxVolumeResponse$volumeArn' => '<p> The ARN identifier of the volume. </p>', 'GetKxVolumeResponse$volumeArn' => '<p> The ARN identifier of the volume. </p>', 'UpdateKxVolumeResponse$volumeArn' => '<p> The ARN identifier of the volume. </p>', ], ], 'KxVolumeName' => [ 'base' => NULL, 'refs' => [ 'CreateKxVolumeRequest$volumeName' => '<p>A unique identifier for the volume.</p>', 'CreateKxVolumeResponse$volumeName' => '<p>A unique identifier for the volume.</p>', 'DeleteKxVolumeRequest$volumeName' => '<p> The name of the volume that you want to delete. </p>', 'GetKxVolumeRequest$volumeName' => '<p>A unique identifier for the volume.</p>', 'GetKxVolumeResponse$volumeName' => '<p> A unique identifier for the volume.</p>', 'KxDataviewSegmentConfiguration$volumeName' => '<p> The name of the volume where you want to add data. </p>', 'KxSavedownStorageConfiguration$volumeName' => '<p> The name of the kdb volume that you want to use as writeable save-down storage for clusters. </p>', 'KxVolume$volumeName' => '<p>A unique identifier for the volume.</p>', 'UpdateKxVolumeRequest$volumeName' => '<p> A unique identifier for the volume.</p>', 'UpdateKxVolumeResponse$volumeName' => '<p>A unique identifier for the volume that you want to update.</p>', ], ], 'KxVolumeStatus' => [ 'base' => NULL, 'refs' => [ 'CreateKxVolumeResponse$status' => '<p>The status of volume creation.</p> <ul> <li> <p>CREATING – The volume creation is in progress.</p> </li> <li> <p>CREATE_FAILED – The volume creation has failed.</p> </li> <li> <p>ACTIVE – The volume is active.</p> </li> <li> <p>UPDATING – The volume is in the process of being updated.</p> </li> <li> <p>UPDATE_FAILED – The update action failed.</p> </li> <li> <p>UPDATED – The volume is successfully updated.</p> </li> <li> <p>DELETING – The volume is in the process of being deleted.</p> </li> <li> <p>DELETE_FAILED – The system failed to delete the volume.</p> </li> <li> <p>DELETED – The volume is successfully deleted.</p> </li> </ul>', 'GetKxVolumeResponse$status' => '<p>The status of volume creation.</p> <ul> <li> <p>CREATING – The volume creation is in progress.</p> </li> <li> <p>CREATE_FAILED – The volume creation has failed.</p> </li> <li> <p>ACTIVE – The volume is active.</p> </li> <li> <p>UPDATING – The volume is in the process of being updated.</p> </li> <li> <p>UPDATE_FAILED – The update action failed.</p> </li> <li> <p>UPDATED – The volume is successfully updated.</p> </li> <li> <p>DELETING – The volume is in the process of being deleted.</p> </li> <li> <p>DELETE_FAILED – The system failed to delete the volume.</p> </li> <li> <p>DELETED – The volume is successfully deleted.</p> </li> </ul>', 'KxVolume$status' => '<p>The status of volume.</p> <ul> <li> <p>CREATING – The volume creation is in progress.</p> </li> <li> <p>CREATE_FAILED – The volume creation has failed.</p> </li> <li> <p>ACTIVE – The volume is active.</p> </li> <li> <p>UPDATING – The volume is in the process of being updated.</p> </li> <li> <p>UPDATE_FAILED – The update action failed.</p> </li> <li> <p>UPDATED – The volume is successfully updated.</p> </li> <li> <p>DELETING – The volume is in the process of being deleted.</p> </li> <li> <p>DELETE_FAILED – The system failed to delete the volume.</p> </li> <li> <p>DELETED – The volume is successfully deleted.</p> </li> </ul>', 'UpdateKxVolumeResponse$status' => '<p>The status of the volume.</p> <ul> <li> <p>CREATING – The volume creation is in progress.</p> </li> <li> <p>CREATE_FAILED – The volume creation has failed.</p> </li> <li> <p>ACTIVE – The volume is active.</p> </li> <li> <p>UPDATING – The volume is in the process of being updated.</p> </li> <li> <p>UPDATE_FAILED – The update action failed.</p> </li> <li> <p>UPDATED – The volume is successfully updated.</p> </li> <li> <p>DELETING – The volume is in the process of being deleted.</p> </li> <li> <p>DELETE_FAILED – The system failed to delete the volume.</p> </li> <li> <p>DELETED – The volume is successfully deleted.</p> </li> </ul>', ], ], 'KxVolumeStatusReason' => [ 'base' => NULL, 'refs' => [ 'CreateKxVolumeResponse$statusReason' => '<p>The error message when a failed state occurs. </p>', 'GetKxVolumeResponse$statusReason' => '<p>The error message when a failed state occurs. </p>', 'KxVolume$statusReason' => '<p>The error message when a failed state occurs. </p>', 'UpdateKxVolumeResponse$statusReason' => '<p>The error message when a failed state occurs. </p>', ], ], 'KxVolumeType' => [ 'base' => NULL, 'refs' => [ 'CreateKxVolumeRequest$volumeType' => '<p> The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. When you select <code>NAS_1</code> volume type, you must also provide <code>nas1Configuration</code>. </p>', 'CreateKxVolumeResponse$volumeType' => '<p> The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. </p>', 'GetKxVolumeResponse$volumeType' => '<p> The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. </p>', 'KxVolume$volumeType' => '<p> The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. </p>', 'ListKxVolumesRequest$volumeType' => '<p> The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. </p>', 'UpdateKxVolumeResponse$volumeType' => '<p> The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. </p>', ], ], 'KxVolumes' => [ 'base' => NULL, 'refs' => [ 'ListKxVolumesResponse$kxVolumeSummaries' => '<p> A summary of volumes. </p>', ], ], 'LimitExceededException' => [ 'base' => '<p>A service limit or quota is exceeded.</p>', 'refs' => [], ], 'ListEnvironmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEnvironmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKxChangesetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKxChangesetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKxClusterNodesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKxClusterNodesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKxClustersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKxClustersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKxDatabasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKxDatabasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKxDataviewsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKxDataviewsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKxEnvironmentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKxEnvironmentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKxScalingGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKxScalingGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKxUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKxUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListKxVolumesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListKxVolumesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListKxChangesetsRequest$maxResults' => '<p>The maximum number of results to return in this request.</p>', 'ListKxClustersRequest$maxResults' => '<p>The maximum number of results to return in this request.</p>', 'ListKxDatabasesRequest$maxResults' => '<p>The maximum number of results to return in this request.</p>', 'ListKxDataviewsRequest$maxResults' => '<p>The maximum number of results to return in this request.</p>', 'ListKxScalingGroupsRequest$maxResults' => '<p>The maximum number of results to return in this request.</p>', 'ListKxVolumesRequest$maxResults' => '<p>The maximum number of results to return in this request.</p>', ], ], 'MemoryMib' => [ 'base' => NULL, 'refs' => [ 'KxScalingGroupConfiguration$memoryLimit' => '<p> An optional hard limit on the amount of memory a kdb cluster can use. </p>', 'KxScalingGroupConfiguration$memoryReservation' => '<p> A reservation of the minimum amount of memory that should be available on the scaling group for a kdb cluster to be successfully placed in a scaling group. </p>', ], ], 'NameString' => [ 'base' => NULL, 'refs' => [ 'SuperuserParameters$firstName' => '<p>The first name of the superuser.</p>', 'SuperuserParameters$lastName' => '<p>The last name of the superuser.</p>', ], ], 'NetworkACLConfiguration' => [ 'base' => NULL, 'refs' => [ 'TransitGatewayConfiguration$attachmentNetworkAclConfiguration' => '<p> The rules that define how you manage the outbound traffic from kdb network to your internal network. </p>', ], ], 'NetworkACLEntry' => [ 'base' => '<p> The network access control list (ACL) is an optional layer of security for your VPC that acts as a firewall for controlling traffic in and out of one or more subnets. The entry is a set of numbered ingress and egress rules that determine whether a packet should be allowed in or out of a subnet associated with the ACL. We process the entries in the ACL according to the rule numbers, in ascending order. </p>', 'refs' => [ 'NetworkACLConfiguration$member' => NULL, ], ], 'NodeCount' => [ 'base' => NULL, 'refs' => [ 'AutoScalingConfiguration$minNodeCount' => '<p>The lowest number of nodes to scale. This value must be at least 1 and less than the <code>maxNodeCount</code>. If the nodes in a cluster belong to multiple availability zones, then <code>minNodeCount</code> must be at least 3.</p>', 'AutoScalingConfiguration$maxNodeCount' => '<p>The highest number of nodes to scale. This value cannot be greater than 5.</p>', 'CapacityConfiguration$nodeCount' => '<p>The number of instances running in a cluster.</p>', ], ], 'NodeType' => [ 'base' => NULL, 'refs' => [ 'CapacityConfiguration$nodeType' => '<p>The type that determines the hardware of the host computer used for your cluster instance. Each node type offers different memory and storage capabilities. Choose a node type based on the requirements of the application or software that you plan to run on your instance.</p> <p>You can only specify one of the following values:</p> <ul> <li> <p> <code>kx.s.large</code> – The node type with a configuration of 12 GiB memory and 2 vCPUs.</p> </li> <li> <p> <code>kx.s.xlarge</code> – The node type with a configuration of 27 GiB memory and 4 vCPUs.</p> </li> <li> <p> <code>kx.s.2xlarge</code> – The node type with a configuration of 54 GiB memory and 8 vCPUs.</p> </li> <li> <p> <code>kx.s.4xlarge</code> – The node type with a configuration of 108 GiB memory and 16 vCPUs.</p> </li> <li> <p> <code>kx.s.8xlarge</code> – The node type with a configuration of 216 GiB memory and 32 vCPUs.</p> </li> <li> <p> <code>kx.s.16xlarge</code> – The node type with a configuration of 432 GiB memory and 64 vCPUs.</p> </li> <li> <p> <code>kx.s.32xlarge</code> – The node type with a configuration of 864 GiB memory and 128 vCPUs.</p> </li> </ul>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsRequest$nextToken' => '<p>A token generated by FinSpace that specifies where to continue pagination if a previous request was truncated. To get the next set of pages, pass in the <code>nextToken</code>nextToken value from the response object of the previous page call.</p>', 'ListEnvironmentsResponse$nextToken' => '<p>A token that you can use in a subsequent call to retrieve the next set of results.</p>', 'ListKxChangesetsRequest$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxChangesetsResponse$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxClusterNodesRequest$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxClusterNodesResponse$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxClustersRequest$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxClustersResponse$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxDatabasesRequest$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxDatabasesResponse$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxDataviewsRequest$nextToken' => '<p> A token that indicates where a results page should begin. </p>', 'ListKxDataviewsResponse$nextToken' => '<p> A token that indicates where a results page should begin. </p>', 'ListKxEnvironmentsRequest$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxEnvironmentsResponse$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxScalingGroupsRequest$nextToken' => '<p> A token that indicates where a results page should begin. </p>', 'ListKxScalingGroupsResponse$nextToken' => '<p> A token that indicates where a results page should begin. </p>', 'ListKxUsersRequest$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxUsersResponse$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxVolumesRequest$nextToken' => '<p>A token that indicates where a results page should begin.</p>', 'ListKxVolumesResponse$nextToken' => '<p>A token that indicates where a results page should begin.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'PortRange$from' => '<p> The first port in the range. </p>', 'PortRange$to' => '<p> The last port in the range. </p>', ], ], 'PortRange' => [ 'base' => '<p> The range of ports the rule applies to. </p>', 'refs' => [ 'NetworkACLEntry$portRange' => '<p> The range of ports the rule applies to. </p>', ], ], 'Protocol' => [ 'base' => NULL, 'refs' => [ 'NetworkACLEntry$protocol' => '<p> The protocol number. A value of <i>-1</i> means all the protocols. </p>', ], ], 'ReleaseLabel' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterRequest$releaseLabel' => '<p>The version of FinSpace managed kdb to run.</p>', 'CreateKxClusterResponse$releaseLabel' => '<p>A version of the FinSpace managed kdb to run.</p>', 'GetKxClusterResponse$releaseLabel' => '<p>The version of FinSpace managed kdb to run.</p>', 'KxCluster$releaseLabel' => '<p>A version of the FinSpace managed kdb to run.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The specified resource group already exists.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>One or more resources can\'t be found.</p>', 'refs' => [], ], 'ResultLimit' => [ 'base' => NULL, 'refs' => [ 'ListEnvironmentsRequest$maxResults' => '<p>The maximum number of results to return in this request.</p>', 'ListKxClusterNodesRequest$maxResults' => '<p>The maximum number of results to return in this request.</p>', 'ListKxUsersRequest$maxResults' => '<p>The maximum number of results to return in this request.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateKxUserRequest$iamRole' => '<p>The IAM role ARN that will be associated with the user.</p>', 'CreateKxUserResponse$iamRole' => '<p>The IAM role ARN that will be associated with the user.</p>', 'GetKxUserResponse$iamRole' => '<p>The IAM role ARN that is associated with the user.</p>', 'KxUser$iamRole' => '<p>The IAM role ARN that is associated with the user.</p>', 'UpdateKxUserRequest$iamRole' => '<p>The IAM role ARN that is associated with the user.</p>', 'UpdateKxUserResponse$iamRole' => '<p>The IAM role ARN that is associated with the user.</p>', ], ], 'RuleAction' => [ 'base' => NULL, 'refs' => [ 'NetworkACLEntry$ruleAction' => '<p> Indicates whether to allow or deny the traffic that matches the rule. </p>', ], ], 'RuleNumber' => [ 'base' => NULL, 'refs' => [ 'NetworkACLEntry$ruleNumber' => '<p> The rule number for the entry. For example <i>100</i>. All the network ACL entries are processed in ascending order by rule number. </p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'CodeConfiguration$s3Bucket' => '<p>A unique name for the S3 bucket.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'CodeConfiguration$s3Key' => '<p>The full S3 path (excluding bucket) to the .zip file. This file contains the code that is loaded onto the cluster when it\'s started.</p>', ], ], 'S3ObjectVersion' => [ 'base' => NULL, 'refs' => [ 'CodeConfiguration$s3ObjectVersion' => '<p>The version of an S3 object.</p>', ], ], 'S3Path' => [ 'base' => NULL, 'refs' => [ 'ChangeRequest$s3Path' => '<p>Defines the S3 path of the source file that is required to add or update files in a database.</p>', ], ], 'SamlMetadataDocument' => [ 'base' => NULL, 'refs' => [ 'FederationParameters$samlMetadataDocument' => '<p>SAML 2.0 Metadata document from identity provider (IdP).</p>', ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$securityGroupIds' => '<p>The unique identifier of the VPC security group applied to the VPC endpoint ENI for the cluster.</p>', ], ], 'SecurityGroupIdString' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIdList$member' => NULL, ], ], 'SegmentConfigurationDbPathList' => [ 'base' => NULL, 'refs' => [ 'KxDataviewSegmentConfiguration$dbPaths' => '<p> The database path of the data that you want to place on each selected volume for the segment. Each segment must have a unique database path for each volume.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p> You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use Service Quotas to request a service quota increase.</p>', 'refs' => [], ], 'SignedKxConnectionString' => [ 'base' => NULL, 'refs' => [ 'GetKxConnectionStringResponse$signedConnectionString' => '<p>The signed connection string that you can use to connect to clusters.</p>', ], ], 'SmsDomainUrl' => [ 'base' => NULL, 'refs' => [ 'Environment$sageMakerStudioDomainUrl' => '<p>The URL of the integrated FinSpace notebook environment in your web application.</p>', ], ], 'SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$subnetIds' => '<p>The identifier of the subnet that the Privatelink VPC endpoint uses to connect to the cluster.</p>', ], ], 'SubnetIdString' => [ 'base' => NULL, 'refs' => [ 'SubnetIdList$member' => NULL, ], ], 'SuperuserParameters' => [ 'base' => '<p>Configuration information for the superuser.</p>', 'refs' => [ 'CreateEnvironmentRequest$superuserParameters' => '<p>Configuration information for the superuser.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys (names) of one or more tags to be removed.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentRequest$tags' => '<p>Add tags to your FinSpace environment.</p>', 'CreateKxClusterRequest$tags' => '<p>A list of key-value pairs to label the cluster. You can add up to 50 tags to a cluster.</p>', 'CreateKxDatabaseRequest$tags' => '<p>A list of key-value pairs to label the kdb database. You can add up to 50 tags to your kdb database</p>', 'CreateKxDataviewRequest$tags' => '<p> A list of key-value pairs to label the dataview. You can add up to 50 tags to a dataview. </p>', 'CreateKxEnvironmentRequest$tags' => '<p>A list of key-value pairs to label the kdb environment. You can add up to 50 tags to your kdb environment.</p>', 'CreateKxScalingGroupRequest$tags' => '<p> A list of key-value pairs to label the scaling group. You can add up to 50 tags to a scaling group. </p>', 'CreateKxUserRequest$tags' => '<p>A list of key-value pairs to label the user. You can add up to 50 tags to a user.</p>', 'CreateKxVolumeRequest$tags' => '<p> A list of key-value pairs to label the volume. You can add up to 50 tags to a volume. </p>', 'ListTagsForResourceResponse$tags' => '<p>A list of all tags for a resource.</p>', 'TagResourceRequest$tags' => '<p>One or more tags to be assigned to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TickerplantLogConfiguration' => [ 'base' => '<p> A configuration to store the Tickerplant logs. It consists of a list of volumes that will be mounted to your cluster. For the cluster type <code>Tickerplant</code>, the location of the TP volume on the cluster will be available by using the global variable <code>.aws.tp_log_path</code>. </p>', 'refs' => [ 'CreateKxClusterRequest$tickerplantLogConfiguration' => '<p> A configuration to store Tickerplant logs. It consists of a list of volumes that will be mounted to your cluster. For the cluster type <code>Tickerplant</code>, the location of the TP volume on the cluster will be available by using the global variable <code>.aws.tp_log_path</code>. </p>', 'CreateKxClusterResponse$tickerplantLogConfiguration' => NULL, 'GetKxClusterResponse$tickerplantLogConfiguration' => NULL, ], ], 'TickerplantLogVolumes' => [ 'base' => NULL, 'refs' => [ 'TickerplantLogConfiguration$tickerplantLogVolumes' => '<p> The name of the volumes for tickerplant logs. </p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateKxChangesetResponse$createdTimestamp' => '<p>The timestamp at which the changeset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'CreateKxChangesetResponse$lastModifiedTimestamp' => '<p>The timestamp at which the changeset was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'CreateKxClusterResponse$lastModifiedTimestamp' => '<p>The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'CreateKxClusterResponse$createdTimestamp' => '<p>The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'CreateKxDatabaseResponse$createdTimestamp' => '<p>The timestamp at which the database is created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'CreateKxDatabaseResponse$lastModifiedTimestamp' => '<p>The last time that the database was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'CreateKxDataviewResponse$createdTimestamp' => '<p> The timestamp at which the dataview was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'CreateKxDataviewResponse$lastModifiedTimestamp' => '<p> The last time that the dataview was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000. </p>', 'CreateKxEnvironmentResponse$creationTimestamp' => '<p>The timestamp at which the kdb environment was created in FinSpace.</p>', 'CreateKxScalingGroupResponse$lastModifiedTimestamp' => '<p> The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000. </p>', 'CreateKxScalingGroupResponse$createdTimestamp' => '<p> The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'CreateKxVolumeResponse$createdTimestamp' => '<p>The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetKxChangesetResponse$createdTimestamp' => '<p>The timestamp at which the changeset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetKxChangesetResponse$activeFromTimestamp' => '<p>Beginning time from which the changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetKxChangesetResponse$lastModifiedTimestamp' => '<p>The timestamp at which the changeset was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetKxClusterResponse$lastModifiedTimestamp' => '<p>The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetKxClusterResponse$createdTimestamp' => '<p>The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetKxDatabaseResponse$createdTimestamp' => '<p>The timestamp at which the database is created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetKxDatabaseResponse$lastModifiedTimestamp' => '<p>The last time that the database was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetKxDataviewResponse$createdTimestamp' => '<p>The timestamp at which the dataview was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetKxDataviewResponse$lastModifiedTimestamp' => '<p> The last time that the dataview was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000. </p>', 'GetKxEnvironmentResponse$creationTimestamp' => '<p>The timestamp at which the kdb environment was created in FinSpace. </p>', 'GetKxEnvironmentResponse$updateTimestamp' => '<p>The timestamp at which the kdb environment was updated. </p>', 'GetKxScalingGroupResponse$lastModifiedTimestamp' => '<p> The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000. </p>', 'GetKxScalingGroupResponse$createdTimestamp' => '<p> The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'GetKxVolumeResponse$createdTimestamp' => '<p> The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000. </p>', 'GetKxVolumeResponse$lastModifiedTimestamp' => '<p>The last time that the volume was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxChangesetListEntry$createdTimestamp' => '<p>The timestamp at which the changeset was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxChangesetListEntry$activeFromTimestamp' => '<p>Beginning time from which the changeset is active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxChangesetListEntry$lastModifiedTimestamp' => '<p>The timestamp at which the changeset was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxCluster$lastModifiedTimestamp' => '<p>The last time that the cluster was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxCluster$createdTimestamp' => '<p>The timestamp at which the cluster was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxDatabaseListEntry$createdTimestamp' => '<p>The timestamp at which the database was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxDatabaseListEntry$lastModifiedTimestamp' => '<p>The last time that the database was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxDataviewActiveVersion$createdTimestamp' => '<p> The timestamp at which the dataview version was active. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxDataviewListEntry$createdTimestamp' => '<p> The timestamp at which the dataview list entry was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxDataviewListEntry$lastModifiedTimestamp' => '<p>The last time that the dataview list was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxEnvironment$creationTimestamp' => '<p>The timestamp at which the kdb environment was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxEnvironment$updateTimestamp' => '<p>The timestamp at which the kdb environment was modified in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxNode$launchTime' => '<p>The time when a particular node is started. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxScalingGroup$lastModifiedTimestamp' => '<p> The last time that the scaling group was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000. </p>', 'KxScalingGroup$createdTimestamp' => '<p> The timestamp at which the scaling group was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000. </p>', 'KxUser$createTimestamp' => '<p>The timestamp at which the kdb user was created. </p>', 'KxUser$updateTimestamp' => '<p>The timestamp at which the kdb user was updated. </p>', 'KxVolume$createdTimestamp' => '<p> The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'KxVolume$lastModifiedTimestamp' => '<p>The last time that the volume was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'UpdateKxDatabaseResponse$lastModifiedTimestamp' => '<p>The last time that the database was modified. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'UpdateKxDataviewResponse$createdTimestamp' => '<p> The timestamp at which the dataview was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000. </p>', 'UpdateKxDataviewResponse$lastModifiedTimestamp' => '<p> The last time that the dataview was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000. </p>', 'UpdateKxEnvironmentNetworkResponse$creationTimestamp' => '<p>The timestamp at which the kdb environment was created in FinSpace. </p>', 'UpdateKxEnvironmentNetworkResponse$updateTimestamp' => '<p>The timestamp at which the kdb environment was updated. </p>', 'UpdateKxEnvironmentResponse$creationTimestamp' => '<p>The timestamp at which the kdb environment was created in FinSpace. </p>', 'UpdateKxEnvironmentResponse$updateTimestamp' => '<p>The timestamp at which the kdb environment was updated. </p>', 'UpdateKxVolumeResponse$createdTimestamp' => '<p> The timestamp at which the volume was created in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', 'UpdateKxVolumeResponse$lastModifiedTimestamp' => '<p>The last time that the volume was updated in FinSpace. The value is determined as epoch time in milliseconds. For example, the value for Monday, November 1, 2021 12:00:00 PM UTC is specified as 1635768000000.</p>', ], ], 'TransitGatewayConfiguration' => [ 'base' => '<p>The structure of the transit gateway and network configuration that is used to connect the kdb environment to an internal network.</p>', 'refs' => [ 'GetKxEnvironmentResponse$transitGatewayConfiguration' => NULL, 'KxEnvironment$transitGatewayConfiguration' => '<p>Specifies the transit gateway and network configuration to connect the kdb environment to an internal network.</p>', 'UpdateKxEnvironmentNetworkRequest$transitGatewayConfiguration' => '<p>Specifies the transit gateway and network configuration to connect the kdb environment to an internal network.</p>', 'UpdateKxEnvironmentNetworkResponse$transitGatewayConfiguration' => NULL, 'UpdateKxEnvironmentResponse$transitGatewayConfiguration' => NULL, ], ], 'TransitGatewayID' => [ 'base' => NULL, 'refs' => [ 'TransitGatewayConfiguration$transitGatewayID' => '<p>The identifier of the transit gateway created by the customer to connect outbound traffics from kdb network to your internal network.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxClusterCodeConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxClusterCodeConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxClusterDatabasesRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxClusterDatabasesResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxDatabaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxDatabaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxDataviewRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxDataviewResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxEnvironmentNetworkRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxEnvironmentNetworkResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxEnvironmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxEnvironmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxVolumeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateKxVolumeResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidCIDRBlock' => [ 'base' => NULL, 'refs' => [ 'NetworkACLEntry$cidrBlock' => '<p> The IPv4 network range to allow or deny, in CIDR notation. For example, <code>172.16.0.0/24</code>. We modify the specified CIDR block to its canonical form. For example, if you specify <code>100.68.0.18/18</code>, we modify it to <code>100.68.0.0/18</code>. </p>', ], ], 'ValidCIDRSpace' => [ 'base' => NULL, 'refs' => [ 'TransitGatewayConfiguration$routableCIDRSpace' => '<p>The routing CIDR on behalf of kdb environment. It could be any "/26 range in the 100.64.0.0 CIDR space. After providing, it will be added to the customer\'s transit gateway routing table so that the traffics could be routed to kdb network.</p>', ], ], 'ValidHostname' => [ 'base' => NULL, 'refs' => [ 'CustomDNSServer$customDNSServerName' => '<p>The name of the DNS server.</p>', ], ], 'ValidIPAddress' => [ 'base' => NULL, 'refs' => [ 'CustomDNSServer$customDNSServerIP' => '<p>The IP address of the DNS server.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input fails to satisfy the constraints specified by an AWS service.</p>', 'refs' => [], ], 'VersionId' => [ 'base' => NULL, 'refs' => [ 'KxDataviewActiveVersion$versionId' => '<p> A unique identifier of the active version.</p>', 'KxDataviewConfiguration$dataviewVersionId' => '<p> The version of the dataview corresponding to a given changeset. </p>', ], ], 'Volume' => [ 'base' => '<p> The structure that consists of name and type of volume.</p>', 'refs' => [ 'Volumes$member' => NULL, ], ], 'VolumeName' => [ 'base' => NULL, 'refs' => [ 'TickerplantLogVolumes$member' => NULL, 'Volume$volumeName' => '<p>A unique identifier for the volume.</p>', ], ], 'VolumeType' => [ 'base' => NULL, 'refs' => [ 'Volume$volumeType' => '<p> The type of file system volume. Currently, FinSpace only supports <code>NAS_1</code> volume type. </p>', ], ], 'Volumes' => [ 'base' => NULL, 'refs' => [ 'CreateKxClusterResponse$volumes' => '<p> A list of volumes mounted on the cluster. </p>', 'GetKxClusterResponse$volumes' => '<p> A list of volumes attached to the cluster. </p>', 'KxCluster$volumes' => '<p> A list of volumes attached to the cluster. </p>', ], ], 'VpcConfiguration' => [ 'base' => '<p>Configuration details about the network where the Privatelink endpoint of the cluster resides.</p>', 'refs' => [ 'CreateKxClusterRequest$vpcConfiguration' => '<p>Configuration details about the network where the Privatelink endpoint of the cluster resides.</p>', 'CreateKxClusterResponse$vpcConfiguration' => '<p>Configuration details about the network where the Privatelink endpoint of the cluster resides.</p>', 'GetKxClusterResponse$vpcConfiguration' => '<p>Configuration details about the network where the Privatelink endpoint of the cluster resides.</p>', ], ], 'VpcIdString' => [ 'base' => NULL, 'refs' => [ 'VpcConfiguration$vpcId' => '<p>The identifier of the VPC endpoint.</p>', ], ], 'arn' => [ 'base' => NULL, 'refs' => [ 'GetKxScalingGroupResponse$scalingGroupArn' => '<p> The ARN identifier for the scaling group. </p>', ], ], 'booleanValue' => [ 'base' => NULL, 'refs' => [ 'CreateKxDataviewRequest$autoUpdate' => '<p>The option to specify whether you want to apply all the future additions and corrections automatically to the dataview, when you ingest new changesets. The default value is false.</p>', 'CreateKxDataviewRequest$readWrite' => '<p> The option to specify whether you want to make the dataview writable to perform database maintenance. The following are some considerations related to writable dataviews.&#x2028;&#x2028;</p> <ul> <li> <p>You cannot create partial writable dataviews. When you create writeable dataviews you must provide the entire database path.</p> </li> <li> <p>You cannot perform updates on a writeable dataview. Hence, <code>autoUpdate</code> must be set as <b>False</b> if <code>readWrite</code> is <b>True</b> for a dataview.</p> </li> <li> <p>You must also use a unique volume for creating a writeable dataview. So, if you choose a volume that is already in use by another dataview, the dataview creation fails.</p> </li> <li> <p>Once you create a dataview as writeable, you cannot change it to read-only. So, you cannot update the <code>readWrite</code> parameter later.</p> </li> </ul>', 'CreateKxDataviewResponse$autoUpdate' => '<p>The option to select whether you want to apply all the future additions and corrections automatically to the dataview when you ingest new changesets. The default value is false.</p>', 'CreateKxDataviewResponse$readWrite' => '<p>Returns True if the dataview is created as writeable and False otherwise. </p>', 'GetKxDataviewResponse$autoUpdate' => '<p>The option to specify whether you want to apply all the future additions and corrections automatically to the dataview when new changesets are ingested. The default value is false.</p>', 'GetKxDataviewResponse$readWrite' => '<p>Returns True if the dataview is created as writeable and False otherwise. </p>', 'KxDataviewListEntry$autoUpdate' => '<p> The option to specify whether you want to apply all the future additions and corrections automatically to the dataview when you ingest new changesets. The default value is false. </p>', 'KxDataviewListEntry$readWrite' => '<p> Returns True if the dataview is created as writeable and False otherwise. </p>', 'KxDataviewSegmentConfiguration$onDemand' => '<p>Enables on-demand caching on the selected database path when a particular file or a column of the database is accessed. When on demand caching is <b>True</b>, dataviews perform minimal loading of files on the filesystem as needed. When it is set to <b>False</b>, everything is cached. The default value is <b>False</b>. </p>', 'UpdateKxDataviewResponse$autoUpdate' => '<p>The option to specify whether you want to apply all the future additions and corrections automatically to the dataview when new changesets are ingested. The default value is false.</p>', 'UpdateKxDataviewResponse$readWrite' => '<p>Returns True if the dataview is created as writeable and False otherwise. </p>', ], ], 'dnsStatus' => [ 'base' => NULL, 'refs' => [ 'GetKxEnvironmentResponse$dnsStatus' => '<p>The status of DNS configuration.</p>', 'KxEnvironment$dnsStatus' => '<p>The status of DNS configuration.</p>', 'UpdateKxEnvironmentNetworkResponse$dnsStatus' => '<p>The status of DNS configuration.</p>', 'UpdateKxEnvironmentResponse$dnsStatus' => '<p>The status of DNS configuration.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'ConflictException$reason' => '<p>The reason for the conflict exception.</p>', 'InternalServerException$message' => NULL, 'InvalidRequestException$message' => NULL, 'LimitExceededException$message' => NULL, 'ResourceAlreadyExistsException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'numBytes' => [ 'base' => NULL, 'refs' => [ 'GetKxDatabaseResponse$numBytes' => '<p>The total number of bytes in the database.</p>', ], ], 'numChangesets' => [ 'base' => NULL, 'refs' => [ 'GetKxDatabaseResponse$numChangesets' => '<p>The total number of changesets in the database.</p>', ], ], 'numFiles' => [ 'base' => NULL, 'refs' => [ 'GetKxDatabaseResponse$numFiles' => '<p>The total number of files in the database.</p>', ], ], 'stringValueLength1to255' => [ 'base' => NULL, 'refs' => [ 'GetKxEnvironmentResponse$certificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the certificate authority of the kdb environment.</p>', 'KxEnvironment$certificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the certificate authority:</p>', ], ], 'tgwStatus' => [ 'base' => NULL, 'refs' => [ 'GetKxEnvironmentResponse$tgwStatus' => '<p>The status of the network configuration.</p>', 'KxEnvironment$tgwStatus' => '<p>The status of the network configuration.</p>', 'UpdateKxEnvironmentNetworkResponse$tgwStatus' => '<p>The status of the network configuration.</p>', 'UpdateKxEnvironmentResponse$tgwStatus' => '<p>The status of the network configuration.</p>', ], ], 'url' => [ 'base' => NULL, 'refs' => [ 'CreateEnvironmentResponse$environmentUrl' => '<p>The sign-in URL for the web application of the FinSpace environment you created.</p>', 'Environment$environmentUrl' => '<p>The sign-in URL for the web application of your FinSpace environment.</p>', 'FederationParameters$samlMetadataURL' => '<p>Provide the metadata URL from your SAML 2.0 compliant identity provider (IdP).</p>', 'FederationParameters$applicationCallBackURL' => '<p>The redirect or sign-in URL that should be entered into the SAML 2.0 compliant identity provider configuration (IdP).</p>', ], ], 'urn' => [ 'base' => NULL, 'refs' => [ 'FederationParameters$federationURN' => '<p>The Uniform Resource Name (URN). Also referred as Service Provider URN or Audience URI or Service Provider Entity ID.</p>', ], ], ],];
