<?php
// This file was auto-generated from sdk-root/src/data/fis/2020-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Web Services Fault Injection Service is a managed service that enables you to perform fault injection experiments on your Amazon Web Services workloads. For more information, see the <a href="https://docs.aws.amazon.com/fis/latest/userguide/">Fault Injection Service User Guide</a>.</p>', 'operations' => [ 'CreateExperimentTemplate' => '<p>Creates an experiment template. </p> <p>An experiment template includes the following components:</p> <ul> <li> <p> <b>Targets</b>: A target can be a specific resource in your Amazon Web Services environment, or one or more resources that match criteria that you specify, for example, resources that have specific tags.</p> </li> <li> <p> <b>Actions</b>: The actions to carry out on the target. You can specify multiple actions, the duration of each action, and when to start each action during an experiment.</p> </li> <li> <p> <b>Stop conditions</b>: If a stop condition is triggered while an experiment is running, the experiment is automatically stopped. You can define a stop condition as a CloudWatch alarm.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-templates.html">experiment templates</a> in the <i>Fault Injection Service User Guide</i>.</p>', 'CreateTargetAccountConfiguration' => '<p>Creates a target account configuration for the experiment template. A target account configuration is required when <code>accountTargeting</code> of <code>experimentOptions</code> is set to <code>multi-account</code>. For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/experiment-options.html">experiment options</a> in the <i>Fault Injection Service User Guide</i>. </p>', 'DeleteExperimentTemplate' => '<p>Deletes the specified experiment template.</p>', 'DeleteTargetAccountConfiguration' => '<p>Deletes the specified target account configuration of the experiment template.</p>', 'GetAction' => '<p>Gets information about the specified FIS action.</p>', 'GetExperiment' => '<p>Gets information about the specified experiment.</p>', 'GetExperimentTargetAccountConfiguration' => '<p>Gets information about the specified target account configuration of the experiment.</p>', 'GetExperimentTemplate' => '<p>Gets information about the specified experiment template.</p>', 'GetTargetAccountConfiguration' => '<p>Gets information about the specified target account configuration of the experiment template.</p>', 'GetTargetResourceType' => '<p>Gets information about the specified resource type.</p>', 'ListActions' => '<p>Lists the available FIS actions.</p>', 'ListExperimentResolvedTargets' => '<p>Lists the resolved targets information of the specified experiment.</p>', 'ListExperimentTargetAccountConfigurations' => '<p>Lists the target account configurations of the specified experiment.</p>', 'ListExperimentTemplates' => '<p>Lists your experiment templates.</p>', 'ListExperiments' => '<p>Lists your experiments.</p>', 'ListTagsForResource' => '<p>Lists the tags for the specified resource.</p>', 'ListTargetAccountConfigurations' => '<p>Lists the target account configurations of the specified experiment template.</p>', 'ListTargetResourceTypes' => '<p>Lists the target resource types.</p>', 'StartExperiment' => '<p>Starts running an experiment from the specified experiment template.</p>', 'StopExperiment' => '<p>Stops the specified experiment.</p>', 'TagResource' => '<p>Applies the specified tags to the specified resource.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified resource.</p>', 'UpdateExperimentTemplate' => '<p>Updates the specified experiment template.</p>', 'UpdateTargetAccountConfiguration' => '<p>Updates the target account configuration for the specified experiment template.</p>', ], 'shapes' => [ 'AccountTargeting' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateExperimentOptionsInput$accountTargeting' => '<p>Specifies the account targeting setting for experiment options.</p>', 'ExperimentOptions$accountTargeting' => '<p>The account targeting setting for an experiment.</p>', 'ExperimentTemplateExperimentOptions$accountTargeting' => '<p>The account targeting setting for an experiment template. </p>', ], ], 'Action' => [ 'base' => '<p>Describes an action. For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/fis-actions-reference.html">FIS actions</a> in the <i>Fault Injection Service User Guide</i>.</p>', 'refs' => [ 'GetActionResponse$action' => '<p>Information about the action.</p>', ], ], 'ActionDescription' => [ 'base' => NULL, 'refs' => [ 'Action$description' => '<p>The description for the action.</p>', 'ActionSummary$description' => '<p>The description for the action.</p>', ], ], 'ActionId' => [ 'base' => NULL, 'refs' => [ 'Action$id' => '<p>The ID of the action.</p>', 'ActionSummary$id' => '<p>The ID of the action.</p>', 'CreateExperimentTemplateActionInput$actionId' => '<p>The ID of the action. The format of the action ID is: aws:<i>service-name</i>:<i>action-type</i>.</p>', 'ExperimentAction$actionId' => '<p>The ID of the action.</p>', 'ExperimentTemplateAction$actionId' => '<p>The ID of the action.</p>', 'GetActionRequest$id' => '<p>The ID of the action.</p>', 'UpdateExperimentTemplateActionInputItem$actionId' => '<p>The ID of the action.</p>', ], ], 'ActionParameter' => [ 'base' => '<p>Describes a parameter for an action.</p>', 'refs' => [ 'ActionParameterMap$value' => NULL, ], ], 'ActionParameterDescription' => [ 'base' => NULL, 'refs' => [ 'ActionParameter$description' => '<p>The parameter description.</p>', ], ], 'ActionParameterMap' => [ 'base' => NULL, 'refs' => [ 'Action$parameters' => '<p>The action parameters, if applicable.</p>', ], ], 'ActionParameterName' => [ 'base' => NULL, 'refs' => [ 'ActionParameterMap$key' => NULL, ], ], 'ActionParameterRequired' => [ 'base' => NULL, 'refs' => [ 'ActionParameter$required' => '<p>Indicates whether the parameter is required.</p>', ], ], 'ActionSummary' => [ 'base' => '<p>Provides a summary of an action.</p>', 'refs' => [ 'ActionSummaryList$member' => NULL, ], ], 'ActionSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListActionsResponse$actions' => '<p>The actions.</p>', ], ], 'ActionTarget' => [ 'base' => '<p>Describes a target for an action.</p>', 'refs' => [ 'ActionTargetMap$value' => NULL, ], ], 'ActionTargetMap' => [ 'base' => NULL, 'refs' => [ 'Action$targets' => '<p>The supported targets for the action.</p>', 'ActionSummary$targets' => '<p>The targets for the action.</p>', ], ], 'ActionTargetName' => [ 'base' => NULL, 'refs' => [ 'ActionTargetMap$key' => NULL, ], ], 'ActionsMode' => [ 'base' => NULL, 'refs' => [ 'ExperimentOptions$actionsMode' => '<p>The actions mode of the experiment that is set from the StartExperiment API command.</p>', 'StartExperimentExperimentOptionsInput$actionsMode' => '<p>Specifies the actions mode for experiment options.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'CreateTargetAccountConfigurationRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', 'StartExperimentRequest$clientToken' => '<p>Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.</p>', ], ], 'CloudWatchLogGroupArn' => [ 'base' => NULL, 'refs' => [ 'ExperimentCloudWatchLogsLogConfiguration$logGroupArn' => '<p>The Amazon Resource Name (ARN) of the destination Amazon CloudWatch Logs log group.</p>', 'ExperimentTemplateCloudWatchLogsLogConfiguration$logGroupArn' => '<p>The Amazon Resource Name (ARN) of the destination Amazon CloudWatch Logs log group.</p>', 'ExperimentTemplateCloudWatchLogsLogConfigurationInput$logGroupArn' => '<p>The Amazon Resource Name (ARN) of the destination Amazon CloudWatch Logs log group.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The request could not be processed because of a conflict.</p>', 'refs' => [], ], 'CreateExperimentTemplateActionInput' => [ 'base' => '<p>Specifies an action for an experiment template.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/actions.html">Actions</a> in the <i>Fault Injection Service User Guide</i>.</p>', 'refs' => [ 'CreateExperimentTemplateActionInputMap$value' => NULL, ], ], 'CreateExperimentTemplateActionInputMap' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateRequest$actions' => '<p>The actions for the experiment.</p>', ], ], 'CreateExperimentTemplateExperimentOptionsInput' => [ 'base' => '<p>Specifies experiment options for an experiment template.</p>', 'refs' => [ 'CreateExperimentTemplateRequest$experimentOptions' => '<p>The experiment options for the experiment template.</p>', ], ], 'CreateExperimentTemplateLogConfigurationInput' => [ 'base' => '<p>Specifies the configuration for experiment logging.</p>', 'refs' => [ 'CreateExperimentTemplateRequest$logConfiguration' => '<p>The configuration for experiment logging.</p>', ], ], 'CreateExperimentTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperimentTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateExperimentTemplateStopConditionInput' => [ 'base' => '<p>Specifies a stop condition for an experiment template.</p>', 'refs' => [ 'CreateExperimentTemplateStopConditionInputList$member' => NULL, ], ], 'CreateExperimentTemplateStopConditionInputList' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateRequest$stopConditions' => '<p>The stop conditions.</p>', ], ], 'CreateExperimentTemplateTargetInput' => [ 'base' => '<p>Specifies a target for an experiment. You must specify at least one Amazon Resource Name (ARN) or at least one resource tag. You cannot specify both ARNs and tags.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/targets.html">Targets</a> in the <i>Fault Injection Service User Guide</i>.</p>', 'refs' => [ 'CreateExperimentTemplateTargetInputMap$value' => NULL, ], ], 'CreateExperimentTemplateTargetInputMap' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateRequest$targets' => '<p>The targets for the experiment.</p>', ], ], 'CreateTargetAccountConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTargetAccountConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreationTime' => [ 'base' => NULL, 'refs' => [ 'Experiment$creationTime' => '<p>The time that the experiment was created.</p>', 'ExperimentSummary$creationTime' => '<p>The time that the experiment was created.</p>', 'ExperimentTemplate$creationTime' => '<p>The time the experiment template was created.</p>', 'ExperimentTemplateSummary$creationTime' => '<p>The time that the experiment template was created.</p>', ], ], 'DeleteExperimentTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteExperimentTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTargetAccountConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTargetAccountConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'EmptyTargetResolutionMode' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateExperimentOptionsInput$emptyTargetResolutionMode' => '<p>Specifies the empty target resolution mode for experiment options.</p>', 'ExperimentOptions$emptyTargetResolutionMode' => '<p>The empty target resolution mode for an experiment.</p>', 'ExperimentTemplateExperimentOptions$emptyTargetResolutionMode' => '<p>The empty target resolution mode for an experiment template.</p>', 'UpdateExperimentTemplateExperimentOptionsInput$emptyTargetResolutionMode' => '<p>The empty target resolution mode of the experiment template.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'ConflictException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'Experiment' => [ 'base' => '<p>Describes an experiment.</p>', 'refs' => [ 'GetExperimentResponse$experiment' => '<p>Information about the experiment.</p>', 'StartExperimentResponse$experiment' => '<p>Information about the experiment.</p>', 'StopExperimentResponse$experiment' => '<p>Information about the experiment.</p>', ], ], 'ExperimentAction' => [ 'base' => '<p>Describes the action for an experiment.</p>', 'refs' => [ 'ExperimentActionMap$value' => NULL, ], ], 'ExperimentActionDescription' => [ 'base' => NULL, 'refs' => [ 'ExperimentAction$description' => '<p>The description for the action.</p>', ], ], 'ExperimentActionEndTime' => [ 'base' => NULL, 'refs' => [ 'ExperimentAction$endTime' => '<p>The time that the action ended.</p>', ], ], 'ExperimentActionMap' => [ 'base' => NULL, 'refs' => [ 'Experiment$actions' => '<p>The actions for the experiment.</p>', ], ], 'ExperimentActionName' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionMap$key' => NULL, ], ], 'ExperimentActionParameter' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionParameterMap$value' => NULL, ], ], 'ExperimentActionParameterMap' => [ 'base' => NULL, 'refs' => [ 'ExperimentAction$parameters' => '<p>The parameters for the action.</p>', ], ], 'ExperimentActionParameterName' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionParameterMap$key' => NULL, ], ], 'ExperimentActionStartAfter' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionStartAfterList$member' => NULL, ], ], 'ExperimentActionStartAfterList' => [ 'base' => NULL, 'refs' => [ 'ExperimentAction$startAfter' => '<p>The name of the action that must be completed before this action starts.</p>', ], ], 'ExperimentActionStartTime' => [ 'base' => NULL, 'refs' => [ 'ExperimentAction$startTime' => '<p>The time that the action started.</p>', ], ], 'ExperimentActionState' => [ 'base' => '<p>Describes the state of an action.</p>', 'refs' => [ 'ExperimentAction$state' => '<p>The state of the action.</p>', ], ], 'ExperimentActionStatus' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionState$status' => '<p>The state of the action.</p>', ], ], 'ExperimentActionStatusReason' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionState$reason' => '<p>The reason for the state.</p>', ], ], 'ExperimentActionTargetMap' => [ 'base' => NULL, 'refs' => [ 'ExperimentAction$targets' => '<p>The targets for the action.</p>', ], ], 'ExperimentActionTargetName' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionTargetMap$key' => NULL, ], ], 'ExperimentCloudWatchLogsLogConfiguration' => [ 'base' => '<p>Describes the configuration for experiment logging to Amazon CloudWatch Logs.</p>', 'refs' => [ 'ExperimentLogConfiguration$cloudWatchLogsConfiguration' => '<p>The configuration for experiment logging to Amazon CloudWatch Logs.</p>', ], ], 'ExperimentEndTime' => [ 'base' => NULL, 'refs' => [ 'Experiment$endTime' => '<p>The time that the experiment ended.</p>', ], ], 'ExperimentError' => [ 'base' => '<p>Describes the error when an experiment has <code>failed</code>.</p>', 'refs' => [ 'ExperimentState$error' => '<p>The error information of the experiment when the action has <code>failed</code>.</p>', ], ], 'ExperimentErrorAccountId' => [ 'base' => NULL, 'refs' => [ 'ExperimentError$accountId' => '<p>The Amazon Web Services Account ID where the experiment failure occurred.</p>', ], ], 'ExperimentErrorCode' => [ 'base' => NULL, 'refs' => [ 'ExperimentError$code' => '<p>The error code for the failed experiment.</p>', ], ], 'ExperimentErrorLocation' => [ 'base' => NULL, 'refs' => [ 'ExperimentError$location' => '<p>Context for the section of the experiment template that failed.</p>', ], ], 'ExperimentId' => [ 'base' => NULL, 'refs' => [ 'Experiment$id' => '<p>The ID of the experiment.</p>', 'ExperimentSummary$id' => '<p>The ID of the experiment.</p>', 'GetExperimentRequest$id' => '<p>The ID of the experiment.</p>', 'GetExperimentTargetAccountConfigurationRequest$experimentId' => '<p>The ID of the experiment.</p>', 'ListExperimentResolvedTargetsRequest$experimentId' => '<p>The ID of the experiment.</p>', 'ListExperimentTargetAccountConfigurationsRequest$experimentId' => '<p>The ID of the experiment.</p>', 'StopExperimentRequest$id' => '<p>The ID of the experiment.</p>', ], ], 'ExperimentLogConfiguration' => [ 'base' => '<p>Describes the configuration for experiment logging.</p>', 'refs' => [ 'Experiment$logConfiguration' => '<p>The configuration for experiment logging.</p>', ], ], 'ExperimentOptions' => [ 'base' => '<p>Describes the options for an experiment.</p>', 'refs' => [ 'Experiment$experimentOptions' => '<p>The experiment options for the experiment.</p>', 'ExperimentSummary$experimentOptions' => '<p>The experiment options for the experiment.</p>', ], ], 'ExperimentS3LogConfiguration' => [ 'base' => '<p>Describes the configuration for experiment logging to Amazon S3.</p>', 'refs' => [ 'ExperimentLogConfiguration$s3Configuration' => '<p>The configuration for experiment logging to Amazon S3.</p>', ], ], 'ExperimentStartTime' => [ 'base' => NULL, 'refs' => [ 'Experiment$startTime' => '<p>The time that the experiment started.</p>', ], ], 'ExperimentState' => [ 'base' => '<p>Describes the state of an experiment.</p>', 'refs' => [ 'Experiment$state' => '<p>The state of the experiment.</p>', 'ExperimentSummary$state' => '<p>The state of the experiment.</p>', ], ], 'ExperimentStatus' => [ 'base' => NULL, 'refs' => [ 'ExperimentState$status' => '<p>The state of the experiment.</p>', ], ], 'ExperimentStatusReason' => [ 'base' => NULL, 'refs' => [ 'ExperimentState$reason' => '<p>The reason for the state.</p>', ], ], 'ExperimentStopCondition' => [ 'base' => '<p>Describes the stop condition for an experiment.</p>', 'refs' => [ 'ExperimentStopConditionList$member' => NULL, ], ], 'ExperimentStopConditionList' => [ 'base' => NULL, 'refs' => [ 'Experiment$stopConditions' => '<p>The stop conditions for the experiment.</p>', ], ], 'ExperimentSummary' => [ 'base' => '<p>Provides a summary of an experiment.</p>', 'refs' => [ 'ExperimentSummaryList$member' => NULL, ], ], 'ExperimentSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListExperimentsResponse$experiments' => '<p>The experiments.</p>', ], ], 'ExperimentTarget' => [ 'base' => '<p>Describes a target for an experiment.</p>', 'refs' => [ 'ExperimentTargetMap$value' => NULL, ], ], 'ExperimentTargetAccountConfiguration' => [ 'base' => '<p>Describes a target account configuration for an experiment.</p>', 'refs' => [ 'GetExperimentTargetAccountConfigurationResponse$targetAccountConfiguration' => '<p>Information about the target account configuration.</p>', ], ], 'ExperimentTargetAccountConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListExperimentTargetAccountConfigurationsResponse$targetAccountConfigurations' => '<p>The target account configurations.</p>', ], ], 'ExperimentTargetAccountConfigurationSummary' => [ 'base' => '<p>Provides a summary of a target account configuration.</p>', 'refs' => [ 'ExperimentTargetAccountConfigurationList$member' => NULL, ], ], 'ExperimentTargetFilter' => [ 'base' => '<p>Describes a filter used for the target resources in an experiment.</p>', 'refs' => [ 'ExperimentTargetFilterList$member' => NULL, ], ], 'ExperimentTargetFilterList' => [ 'base' => NULL, 'refs' => [ 'ExperimentTarget$filters' => '<p>The filters to apply to identify target resources using specific attributes.</p>', ], ], 'ExperimentTargetFilterPath' => [ 'base' => NULL, 'refs' => [ 'ExperimentTargetFilter$path' => '<p>The attribute path for the filter.</p>', ], ], 'ExperimentTargetFilterValue' => [ 'base' => NULL, 'refs' => [ 'ExperimentTargetFilterValues$member' => NULL, ], ], 'ExperimentTargetFilterValues' => [ 'base' => NULL, 'refs' => [ 'ExperimentTargetFilter$values' => '<p>The attribute values for the filter.</p>', ], ], 'ExperimentTargetMap' => [ 'base' => NULL, 'refs' => [ 'Experiment$targets' => '<p>The targets for the experiment.</p>', ], ], 'ExperimentTargetName' => [ 'base' => NULL, 'refs' => [ 'ExperimentActionTargetMap$value' => NULL, 'ExperimentTargetMap$key' => NULL, ], ], 'ExperimentTargetParameterMap' => [ 'base' => NULL, 'refs' => [ 'ExperimentTarget$parameters' => '<p>The resource type parameters.</p>', ], ], 'ExperimentTargetParameterName' => [ 'base' => NULL, 'refs' => [ 'ExperimentTargetParameterMap$key' => NULL, ], ], 'ExperimentTargetParameterValue' => [ 'base' => NULL, 'refs' => [ 'ExperimentTargetParameterMap$value' => NULL, ], ], 'ExperimentTargetSelectionMode' => [ 'base' => NULL, 'refs' => [ 'ExperimentTarget$selectionMode' => '<p>Scopes the identified resources to a specific count or percentage.</p>', ], ], 'ExperimentTemplate' => [ 'base' => '<p>Describes an experiment template.</p>', 'refs' => [ 'CreateExperimentTemplateResponse$experimentTemplate' => '<p>Information about the experiment template.</p>', 'DeleteExperimentTemplateResponse$experimentTemplate' => '<p>Information about the experiment template.</p>', 'GetExperimentTemplateResponse$experimentTemplate' => '<p>Information about the experiment template.</p>', 'UpdateExperimentTemplateResponse$experimentTemplate' => '<p>Information about the experiment template.</p>', ], ], 'ExperimentTemplateAction' => [ 'base' => '<p>Describes an action for an experiment template.</p>', 'refs' => [ 'ExperimentTemplateActionMap$value' => NULL, ], ], 'ExperimentTemplateActionDescription' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateActionInput$description' => '<p>A description for the action.</p>', 'ExperimentTemplateAction$description' => '<p>A description for the action.</p>', 'UpdateExperimentTemplateActionInputItem$description' => '<p>A description for the action.</p>', ], ], 'ExperimentTemplateActionMap' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplate$actions' => '<p>The actions for the experiment.</p>', ], ], 'ExperimentTemplateActionName' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateActionInputMap$key' => NULL, 'ExperimentTemplateActionMap$key' => NULL, 'UpdateExperimentTemplateActionInputMap$key' => NULL, ], ], 'ExperimentTemplateActionParameter' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateActionParameterMap$value' => NULL, ], ], 'ExperimentTemplateActionParameterMap' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateActionInput$parameters' => '<p>The parameters for the action, if applicable.</p>', 'ExperimentTemplateAction$parameters' => '<p>The parameters for the action.</p>', 'UpdateExperimentTemplateActionInputItem$parameters' => '<p>The parameters for the action, if applicable.</p>', ], ], 'ExperimentTemplateActionParameterName' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateActionParameterMap$key' => NULL, ], ], 'ExperimentTemplateActionStartAfter' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateActionStartAfterList$member' => NULL, ], ], 'ExperimentTemplateActionStartAfterList' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateActionInput$startAfter' => '<p>The name of the action that must be completed before the current action starts. Omit this parameter to run the action at the start of the experiment.</p>', 'ExperimentTemplateAction$startAfter' => '<p>The name of the action that must be completed before the current action starts.</p>', 'UpdateExperimentTemplateActionInputItem$startAfter' => '<p>The name of the action that must be completed before the current action starts. Omit this parameter to run the action at the start of the experiment.</p>', ], ], 'ExperimentTemplateActionTargetMap' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateActionInput$targets' => '<p>The targets for the action.</p>', 'ExperimentTemplateAction$targets' => '<p>The targets for the action.</p>', 'UpdateExperimentTemplateActionInputItem$targets' => '<p>The targets for the action.</p>', ], ], 'ExperimentTemplateActionTargetName' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateActionTargetMap$key' => NULL, ], ], 'ExperimentTemplateCloudWatchLogsLogConfiguration' => [ 'base' => '<p>Describes the configuration for experiment logging to Amazon CloudWatch Logs.</p>', 'refs' => [ 'ExperimentTemplateLogConfiguration$cloudWatchLogsConfiguration' => '<p>The configuration for experiment logging to Amazon CloudWatch Logs.</p>', ], ], 'ExperimentTemplateCloudWatchLogsLogConfigurationInput' => [ 'base' => '<p>Specifies the configuration for experiment logging to Amazon CloudWatch Logs.</p>', 'refs' => [ 'CreateExperimentTemplateLogConfigurationInput$cloudWatchLogsConfiguration' => '<p>The configuration for experiment logging to Amazon CloudWatch Logs.</p>', 'UpdateExperimentTemplateLogConfigurationInput$cloudWatchLogsConfiguration' => '<p>The configuration for experiment logging to Amazon CloudWatch Logs.</p>', ], ], 'ExperimentTemplateDescription' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateRequest$description' => '<p>A description for the experiment template.</p>', 'ExperimentTemplate$description' => '<p>The description for the experiment template.</p>', 'ExperimentTemplateSummary$description' => '<p>The description of the experiment template.</p>', 'UpdateExperimentTemplateRequest$description' => '<p>A description for the template.</p>', ], ], 'ExperimentTemplateExperimentOptions' => [ 'base' => '<p>Describes the experiment options for an experiment template.</p>', 'refs' => [ 'ExperimentTemplate$experimentOptions' => '<p>The experiment options for an experiment template.</p>', ], ], 'ExperimentTemplateId' => [ 'base' => NULL, 'refs' => [ 'CreateTargetAccountConfigurationRequest$experimentTemplateId' => '<p>The experiment template ID.</p>', 'DeleteExperimentTemplateRequest$id' => '<p>The ID of the experiment template.</p>', 'DeleteTargetAccountConfigurationRequest$experimentTemplateId' => '<p>The ID of the experiment template.</p>', 'Experiment$experimentTemplateId' => '<p>The ID of the experiment template.</p>', 'ExperimentSummary$experimentTemplateId' => '<p>The ID of the experiment template.</p>', 'ExperimentTemplate$id' => '<p>The ID of the experiment template.</p>', 'ExperimentTemplateSummary$id' => '<p>The ID of the experiment template.</p>', 'GetExperimentTemplateRequest$id' => '<p>The ID of the experiment template.</p>', 'GetTargetAccountConfigurationRequest$experimentTemplateId' => '<p>The ID of the experiment template.</p>', 'ListExperimentsRequest$experimentTemplateId' => '<p>The ID of the experiment template.</p>', 'ListTargetAccountConfigurationsRequest$experimentTemplateId' => '<p>The ID of the experiment template.</p>', 'StartExperimentRequest$experimentTemplateId' => '<p>The ID of the experiment template.</p>', 'UpdateExperimentTemplateRequest$id' => '<p>The ID of the experiment template.</p>', 'UpdateTargetAccountConfigurationRequest$experimentTemplateId' => '<p>The ID of the experiment template.</p>', ], ], 'ExperimentTemplateLogConfiguration' => [ 'base' => '<p>Describes the configuration for experiment logging.</p>', 'refs' => [ 'ExperimentTemplate$logConfiguration' => '<p>The configuration for experiment logging.</p>', ], ], 'ExperimentTemplateS3LogConfiguration' => [ 'base' => '<p>Describes the configuration for experiment logging to Amazon S3.</p>', 'refs' => [ 'ExperimentTemplateLogConfiguration$s3Configuration' => '<p>The configuration for experiment logging to Amazon S3.</p>', ], ], 'ExperimentTemplateS3LogConfigurationInput' => [ 'base' => '<p>Specifies the configuration for experiment logging to Amazon S3.</p>', 'refs' => [ 'CreateExperimentTemplateLogConfigurationInput$s3Configuration' => '<p>The configuration for experiment logging to Amazon S3.</p>', 'UpdateExperimentTemplateLogConfigurationInput$s3Configuration' => '<p>The configuration for experiment logging to Amazon S3.</p>', ], ], 'ExperimentTemplateStopCondition' => [ 'base' => '<p>Describes a stop condition for an experiment template.</p>', 'refs' => [ 'ExperimentTemplateStopConditionList$member' => NULL, ], ], 'ExperimentTemplateStopConditionList' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplate$stopConditions' => '<p>The stop conditions for the experiment.</p>', ], ], 'ExperimentTemplateSummary' => [ 'base' => '<p>Provides a summary of an experiment template.</p>', 'refs' => [ 'ExperimentTemplateSummaryList$member' => NULL, ], ], 'ExperimentTemplateSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListExperimentTemplatesResponse$experimentTemplates' => '<p>The experiment templates.</p>', ], ], 'ExperimentTemplateTarget' => [ 'base' => '<p>Describes a target for an experiment template.</p>', 'refs' => [ 'ExperimentTemplateTargetMap$value' => NULL, ], ], 'ExperimentTemplateTargetFilter' => [ 'base' => '<p>Describes a filter used for the target resources in an experiment template.</p>', 'refs' => [ 'ExperimentTemplateTargetFilterList$member' => NULL, ], ], 'ExperimentTemplateTargetFilterInputList' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateTargetInput$filters' => '<p>The filters to apply to identify target resources using specific attributes.</p>', 'UpdateExperimentTemplateTargetInput$filters' => '<p>The filters to apply to identify target resources using specific attributes.</p>', ], ], 'ExperimentTemplateTargetFilterList' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateTarget$filters' => '<p>The filters to apply to identify target resources using specific attributes.</p>', ], ], 'ExperimentTemplateTargetFilterPath' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateTargetFilter$path' => '<p>The attribute path for the filter.</p>', 'ExperimentTemplateTargetInputFilter$path' => '<p>The attribute path for the filter.</p>', ], ], 'ExperimentTemplateTargetFilterValue' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateTargetFilterValues$member' => NULL, ], ], 'ExperimentTemplateTargetFilterValues' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateTargetFilter$values' => '<p>The attribute values for the filter.</p>', 'ExperimentTemplateTargetInputFilter$values' => '<p>The attribute values for the filter.</p>', ], ], 'ExperimentTemplateTargetInputFilter' => [ 'base' => '<p>Specifies a filter used for the target resource input in an experiment template.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/fis/latest/userguide/targets.html#target-filters">Resource filters</a> in the <i>Fault Injection Service User Guide</i>.</p>', 'refs' => [ 'ExperimentTemplateTargetFilterInputList$member' => NULL, ], ], 'ExperimentTemplateTargetMap' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplate$targets' => '<p>The targets for the experiment.</p>', ], ], 'ExperimentTemplateTargetName' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateTargetInputMap$key' => NULL, 'ExperimentTemplateActionTargetMap$value' => NULL, 'ExperimentTemplateTargetMap$key' => NULL, 'UpdateExperimentTemplateTargetInputMap$key' => NULL, ], ], 'ExperimentTemplateTargetParameterMap' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateTargetInput$parameters' => '<p>The resource type parameters.</p>', 'ExperimentTemplateTarget$parameters' => '<p>The resource type parameters.</p>', 'UpdateExperimentTemplateTargetInput$parameters' => '<p>The resource type parameters.</p>', ], ], 'ExperimentTemplateTargetParameterName' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateTargetParameterMap$key' => NULL, ], ], 'ExperimentTemplateTargetParameterValue' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplateTargetParameterMap$value' => NULL, ], ], 'ExperimentTemplateTargetSelectionMode' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateTargetInput$selectionMode' => '<p>Scopes the identified resources to a specific count of the resources at random, or a percentage of the resources. All identified resources are included in the target.</p> <ul> <li> <p>ALL - Run the action on all identified targets. This is the default.</p> </li> <li> <p>COUNT(n) - Run the action on the specified number of targets, chosen from the identified targets at random. For example, COUNT(1) selects one of the targets.</p> </li> <li> <p>PERCENT(n) - Run the action on the specified percentage of targets, chosen from the identified targets at random. For example, PERCENT(25) selects 25% of the targets.</p> </li> </ul>', 'ExperimentTemplateTarget$selectionMode' => '<p>Scopes the identified resources to a specific count or percentage.</p>', 'UpdateExperimentTemplateTargetInput$selectionMode' => '<p>Scopes the identified resources to a specific count or percentage.</p>', ], ], 'GetActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentTargetAccountConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentTargetAccountConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetExperimentTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTargetAccountConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTargetAccountConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTargetResourceTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTargetResourceTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'LastUpdateTime' => [ 'base' => NULL, 'refs' => [ 'ExperimentTemplate$lastUpdateTime' => '<p>The time the experiment template was last updated.</p>', 'ExperimentTemplateSummary$lastUpdateTime' => '<p>The time that the experiment template was last updated.</p>', ], ], 'ListActionsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListActionsRequest$maxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListActionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentResolvedTargetsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListExperimentResolvedTargetsRequest$maxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value.</p>', ], ], 'ListExperimentResolvedTargetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentResolvedTargetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentTargetAccountConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentTargetAccountConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentTemplatesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListExperimentTemplatesRequest$maxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListExperimentTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListExperimentsRequest$maxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListExperimentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListExperimentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetAccountConfigurationsMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTargetAccountConfigurationsRequest$maxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned nextToken value.</p>', ], ], 'ListTargetAccountConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetAccountConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetResourceTypesMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListTargetResourceTypesRequest$maxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p>', ], ], 'ListTargetResourceTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTargetResourceTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogSchemaVersion' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateLogConfigurationInput$logSchemaVersion' => '<p>The schema version.</p>', 'ExperimentLogConfiguration$logSchemaVersion' => '<p>The schema version.</p>', 'ExperimentTemplateLogConfiguration$logSchemaVersion' => '<p>The schema version.</p>', 'UpdateExperimentTemplateLogConfigurationInput$logSchemaVersion' => '<p>The schema version.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListActionsRequest$nextToken' => '<p>The token for the next page of results.</p>', 'ListActionsResponse$nextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListExperimentResolvedTargetsRequest$nextToken' => '<p>The token for the next page of results.</p>', 'ListExperimentResolvedTargetsResponse$nextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'ListExperimentTargetAccountConfigurationsRequest$nextToken' => '<p>The token for the next page of results.</p>', 'ListExperimentTargetAccountConfigurationsResponse$nextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'ListExperimentTemplatesRequest$nextToken' => '<p>The token for the next page of results.</p>', 'ListExperimentTemplatesResponse$nextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListExperimentsRequest$nextToken' => '<p>The token for the next page of results.</p>', 'ListExperimentsResponse$nextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', 'ListTargetAccountConfigurationsRequest$nextToken' => '<p>The token for the next page of results.</p>', 'ListTargetAccountConfigurationsResponse$nextToken' => '<p>The token to use to retrieve the next page of results. This value is null when there are no more results to return.</p>', 'ListTargetResourceTypesRequest$nextToken' => '<p>The token for the next page of results.</p>', 'ListTargetResourceTypesResponse$nextToken' => '<p>The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more results to return.</p>', ], ], 'ResolvedTarget' => [ 'base' => '<p>Describes a resolved target.</p>', 'refs' => [ 'ResolvedTargetList$member' => NULL, ], ], 'ResolvedTargetList' => [ 'base' => NULL, 'refs' => [ 'ListExperimentResolvedTargetsResponse$resolvedTargets' => '<p>The resolved targets.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'Action$arn' => '<p>The Amazon Resource Name (ARN) of the action.</p>', 'ActionSummary$arn' => '<p>The Amazon Resource Name (ARN) of the action.</p>', 'Experiment$arn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'ExperimentSummary$arn' => '<p>The Amazon Resource Name (ARN) of the experiment.</p>', 'ExperimentTemplate$arn' => '<p>The Amazon Resource Name (ARN) of the experiment template.</p>', 'ExperimentTemplateSummary$arn' => '<p>The Amazon Resource Name (ARN) of the experiment template.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'ResourceArnList$member' => NULL, 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource.</p>', ], ], 'ResourceArnList' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateTargetInput$resourceArns' => '<p>The Amazon Resource Names (ARNs) of the resources.</p>', 'ExperimentTarget$resourceArns' => '<p>The Amazon Resource Names (ARNs) of the resources.</p>', 'ExperimentTemplateTarget$resourceArns' => '<p>The Amazon Resource Names (ARNs) of the targets.</p>', 'UpdateExperimentTemplateTargetInput$resourceArns' => '<p>The Amazon Resource Names (ARNs) of the targets.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource cannot be found.</p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.</p>', 'CreateTargetAccountConfigurationRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role for the target account.</p>', 'Experiment$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.</p>', 'ExperimentTargetAccountConfiguration$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role for the target account.</p>', 'ExperimentTargetAccountConfigurationSummary$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role for the target account.</p>', 'ExperimentTemplate$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role.</p>', 'TargetAccountConfiguration$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role for the target account.</p>', 'TargetAccountConfigurationSummary$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role for the target account.</p>', 'UpdateExperimentTemplateRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that grants the FIS service permission to perform service actions on your behalf.</p>', 'UpdateTargetAccountConfigurationRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role for the target account.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'ExperimentS3LogConfiguration$bucketName' => '<p>The name of the destination bucket.</p>', 'ExperimentTemplateS3LogConfiguration$bucketName' => '<p>The name of the destination bucket.</p>', 'ExperimentTemplateS3LogConfigurationInput$bucketName' => '<p>The name of the destination bucket.</p>', ], ], 'S3ObjectKey' => [ 'base' => NULL, 'refs' => [ 'ExperimentS3LogConfiguration$prefix' => '<p>The bucket prefix.</p>', 'ExperimentTemplateS3LogConfiguration$prefix' => '<p>The bucket prefix.</p>', 'ExperimentTemplateS3LogConfigurationInput$prefix' => '<p>The bucket prefix.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>You have exceeded your service quota.</p>', 'refs' => [], ], 'StartExperimentExperimentOptionsInput' => [ 'base' => '<p>Specifies experiment options for running an experiment.</p>', 'refs' => [ 'StartExperimentRequest$experimentOptions' => '<p>The experiment options for running the experiment.</p>', ], ], 'StartExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopConditionSource' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateStopConditionInput$source' => '<p>The source for the stop condition. Specify <code>aws:cloudwatch:alarm</code> if the stop condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop condition.</p>', 'ExperimentStopCondition$source' => '<p>The source for the stop condition.</p>', 'ExperimentTemplateStopCondition$source' => '<p>The source for the stop condition.</p>', 'UpdateExperimentTemplateStopConditionInput$source' => '<p>The source for the stop condition. Specify <code>aws:cloudwatch:alarm</code> if the stop condition is defined by a CloudWatch alarm. Specify <code>none</code> if there is no stop condition.</p>', ], ], 'StopConditionValue' => [ 'base' => NULL, 'refs' => [ 'CreateExperimentTemplateStopConditionInput$value' => '<p>The Amazon Resource Name (ARN) of the CloudWatch alarm. This is required if the source is a CloudWatch alarm.</p>', 'ExperimentStopCondition$value' => '<p>The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.</p>', 'ExperimentTemplateStopCondition$value' => '<p>The Amazon Resource Name (ARN) of the CloudWatch alarm, if applicable.</p>', 'UpdateExperimentTemplateStopConditionInput$value' => '<p>The Amazon Resource Name (ARN) of the CloudWatch alarm.</p>', ], ], 'StopExperimentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopExperimentResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag keys to remove.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'Action$tags' => '<p>The tags for the action.</p>', 'ActionSummary$tags' => '<p>The tags for the action.</p>', 'CreateExperimentTemplateRequest$tags' => '<p>The tags to apply to the experiment template.</p>', 'CreateExperimentTemplateTargetInput$resourceTags' => '<p>The tags for the target resources.</p>', 'Experiment$tags' => '<p>The tags for the experiment.</p>', 'ExperimentSummary$tags' => '<p>The tags for the experiment.</p>', 'ExperimentTarget$resourceTags' => '<p>The tags for the target resources.</p>', 'ExperimentTemplate$tags' => '<p>The tags for the experiment template.</p>', 'ExperimentTemplateSummary$tags' => '<p>The tags for the experiment template.</p>', 'ExperimentTemplateTarget$resourceTags' => '<p>The tags for the target resources.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags for the resource.</p>', 'StartExperimentRequest$tags' => '<p>The tags to apply to the experiment.</p>', 'TagResourceRequest$tags' => '<p>The tags for the resource.</p>', 'UpdateExperimentTemplateTargetInput$resourceTags' => '<p>The tags for the target resources.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'TargetAccountConfiguration' => [ 'base' => '<p>Describes a target account configuration.</p>', 'refs' => [ 'CreateTargetAccountConfigurationResponse$targetAccountConfiguration' => '<p>Information about the target account configuration.</p>', 'DeleteTargetAccountConfigurationResponse$targetAccountConfiguration' => '<p>Information about the target account configuration.</p>', 'GetTargetAccountConfigurationResponse$targetAccountConfiguration' => '<p>Information about the target account configuration.</p>', 'UpdateTargetAccountConfigurationResponse$targetAccountConfiguration' => '<p>Information about the target account configuration.</p>', ], ], 'TargetAccountConfigurationDescription' => [ 'base' => NULL, 'refs' => [ 'CreateTargetAccountConfigurationRequest$description' => '<p>The description of the target account.</p>', 'ExperimentTargetAccountConfiguration$description' => '<p>The description of the target account.</p>', 'ExperimentTargetAccountConfigurationSummary$description' => '<p>The description of the target account.</p>', 'TargetAccountConfiguration$description' => '<p>The description of the target account.</p>', 'TargetAccountConfigurationSummary$description' => '<p>The description of the target account.</p>', 'UpdateTargetAccountConfigurationRequest$description' => '<p>The description of the target account.</p>', ], ], 'TargetAccountConfigurationList' => [ 'base' => NULL, 'refs' => [ 'ListTargetAccountConfigurationsResponse$targetAccountConfigurations' => '<p>The target account configurations.</p>', ], ], 'TargetAccountConfigurationSummary' => [ 'base' => '<p>Provides a summary of a target account configuration.</p>', 'refs' => [ 'TargetAccountConfigurationList$member' => NULL, ], ], 'TargetAccountConfigurationsCount' => [ 'base' => NULL, 'refs' => [ 'Experiment$targetAccountConfigurationsCount' => '<p>The count of target account configurations for the experiment.</p>', 'ExperimentTemplate$targetAccountConfigurationsCount' => '<p>The count of target account configurations for the experiment template.</p>', ], ], 'TargetAccountId' => [ 'base' => NULL, 'refs' => [ 'CreateTargetAccountConfigurationRequest$accountId' => '<p>The Amazon Web Services account ID of the target account.</p>', 'DeleteTargetAccountConfigurationRequest$accountId' => '<p>The Amazon Web Services account ID of the target account.</p>', 'ExperimentTargetAccountConfiguration$accountId' => '<p>The Amazon Web Services account ID of the target account.</p>', 'ExperimentTargetAccountConfigurationSummary$accountId' => '<p>The Amazon Web Services account ID of the target account.</p>', 'GetExperimentTargetAccountConfigurationRequest$accountId' => '<p>The Amazon Web Services account ID of the target account.</p>', 'GetTargetAccountConfigurationRequest$accountId' => '<p>The Amazon Web Services account ID of the target account.</p>', 'TargetAccountConfiguration$accountId' => '<p>The Amazon Web Services account ID of the target account.</p>', 'TargetAccountConfigurationSummary$accountId' => '<p>The Amazon Web Services account ID of the target account.</p>', 'UpdateTargetAccountConfigurationRequest$accountId' => '<p>The Amazon Web Services account ID of the target account.</p>', ], ], 'TargetInformationKey' => [ 'base' => NULL, 'refs' => [ 'TargetInformationMap$key' => NULL, ], ], 'TargetInformationMap' => [ 'base' => NULL, 'refs' => [ 'ResolvedTarget$targetInformation' => '<p>Information about the target.</p>', ], ], 'TargetInformationValue' => [ 'base' => NULL, 'refs' => [ 'TargetInformationMap$value' => NULL, ], ], 'TargetName' => [ 'base' => NULL, 'refs' => [ 'ListExperimentResolvedTargetsRequest$targetName' => '<p>The name of the target.</p>', 'ResolvedTarget$targetName' => '<p>The name of the target.</p>', ], ], 'TargetResourceType' => [ 'base' => '<p>Describes a resource type.</p>', 'refs' => [ 'GetTargetResourceTypeResponse$targetResourceType' => '<p>Information about the resource type.</p>', ], ], 'TargetResourceTypeDescription' => [ 'base' => NULL, 'refs' => [ 'TargetResourceType$description' => '<p>A description of the resource type.</p>', 'TargetResourceTypeSummary$description' => '<p>A description of the resource type.</p>', ], ], 'TargetResourceTypeId' => [ 'base' => NULL, 'refs' => [ 'ActionTarget$resourceType' => '<p>The resource type of the target.</p>', 'CreateExperimentTemplateTargetInput$resourceType' => '<p>The resource type. The resource type must be supported for the specified action.</p>', 'ExperimentTarget$resourceType' => '<p>The resource type.</p>', 'ExperimentTemplateTarget$resourceType' => '<p>The resource type.</p>', 'GetTargetResourceTypeRequest$resourceType' => '<p>The resource type.</p>', 'ResolvedTarget$resourceType' => '<p>The resource type of the target.</p>', 'TargetResourceType$resourceType' => '<p>The resource type.</p>', 'TargetResourceTypeSummary$resourceType' => '<p>The resource type.</p>', 'UpdateExperimentTemplateTargetInput$resourceType' => '<p>The resource type. The resource type must be supported for the specified action.</p>', ], ], 'TargetResourceTypeParameter' => [ 'base' => '<p>Describes the parameters for a resource type. Use parameters to determine which tasks are identified during target resolution.</p>', 'refs' => [ 'TargetResourceTypeParameterMap$value' => NULL, ], ], 'TargetResourceTypeParameterDescription' => [ 'base' => NULL, 'refs' => [ 'TargetResourceTypeParameter$description' => '<p>A description of the parameter.</p>', ], ], 'TargetResourceTypeParameterMap' => [ 'base' => NULL, 'refs' => [ 'TargetResourceType$parameters' => '<p>The parameters for the resource type.</p>', ], ], 'TargetResourceTypeParameterName' => [ 'base' => NULL, 'refs' => [ 'TargetResourceTypeParameterMap$key' => NULL, ], ], 'TargetResourceTypeParameterRequired' => [ 'base' => NULL, 'refs' => [ 'TargetResourceTypeParameter$required' => '<p>Indicates whether the parameter is required.</p>', ], ], 'TargetResourceTypeSummary' => [ 'base' => '<p>Describes a resource type.</p>', 'refs' => [ 'TargetResourceTypeSummaryList$member' => NULL, ], ], 'TargetResourceTypeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListTargetResourceTypesResponse$targetResourceTypes' => '<p>The target resource types.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperimentTemplateActionInputItem' => [ 'base' => '<p>Specifies an action for an experiment template.</p>', 'refs' => [ 'UpdateExperimentTemplateActionInputMap$value' => NULL, ], ], 'UpdateExperimentTemplateActionInputMap' => [ 'base' => NULL, 'refs' => [ 'UpdateExperimentTemplateRequest$actions' => '<p>The actions for the experiment.</p>', ], ], 'UpdateExperimentTemplateExperimentOptionsInput' => [ 'base' => '<p>Specifies an experiment option for an experiment template.</p>', 'refs' => [ 'UpdateExperimentTemplateRequest$experimentOptions' => '<p>The experiment options for the experiment template.</p>', ], ], 'UpdateExperimentTemplateLogConfigurationInput' => [ 'base' => '<p>Specifies the configuration for experiment logging.</p>', 'refs' => [ 'UpdateExperimentTemplateRequest$logConfiguration' => '<p>The configuration for experiment logging.</p>', ], ], 'UpdateExperimentTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperimentTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateExperimentTemplateStopConditionInput' => [ 'base' => '<p>Specifies a stop condition for an experiment. You can define a stop condition as a CloudWatch alarm.</p>', 'refs' => [ 'UpdateExperimentTemplateStopConditionInputList$member' => NULL, ], ], 'UpdateExperimentTemplateStopConditionInputList' => [ 'base' => NULL, 'refs' => [ 'UpdateExperimentTemplateRequest$stopConditions' => '<p>The stop conditions for the experiment.</p>', ], ], 'UpdateExperimentTemplateTargetInput' => [ 'base' => '<p>Specifies a target for an experiment. You must specify at least one Amazon Resource Name (ARN) or at least one resource tag. You cannot specify both.</p>', 'refs' => [ 'UpdateExperimentTemplateTargetInputMap$value' => NULL, ], ], 'UpdateExperimentTemplateTargetInputMap' => [ 'base' => NULL, 'refs' => [ 'UpdateExperimentTemplateRequest$targets' => '<p>The targets for the experiment.</p>', ], ], 'UpdateTargetAccountConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTargetAccountConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>The specified input is not valid, or fails to satisfy the constraints for the request.</p>', 'refs' => [], ], ],];
