<?php
// This file was auto-generated from sdk-root/src/data/identitystore/2020-06-15/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>The Identity Store service used by IAM Identity Center provides a single place to retrieve all of your identities (users and groups). For more information, see the <a href="https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html">IAM Identity Center User Guide</a>.</p> <p>This reference guide describes the identity store operations that you can call programmatically and includes detailed information about data types and errors.</p> <note> <p>IAM Identity Center uses the <code>sso</code> and <code>identitystore</code> API namespaces.</p> </note>', 'operations' => [ 'CreateGroup' => '<p>Creates a group within the specified identity store.</p>', 'CreateGroupMembership' => '<p>Creates a relationship between a member and a group. The following identifiers must be specified: <code>GroupId</code>, <code>IdentityStoreId</code>, and <code>MemberId</code>.</p>', 'CreateUser' => '<p>Creates a user within the specified identity store.</p>', 'DeleteGroup' => '<p>Delete a group within an identity store given <code>GroupId</code>.</p>', 'DeleteGroupMembership' => '<p>Delete a membership within a group given <code>MembershipId</code>.</p>', 'DeleteUser' => '<p>Deletes a user within an identity store given <code>UserId</code>.</p>', 'DescribeGroup' => '<p>Retrieves the group metadata and attributes from <code>GroupId</code> in an identity store.</p> <note> <p>If you have administrator access to a member account, you can use this API from the member account. Read about <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html">member accounts</a> in the <i>Organizations User Guide</i>. </p> </note>', 'DescribeGroupMembership' => '<p>Retrieves membership metadata and attributes from <code>MembershipId</code> in an identity store.</p> <note> <p>If you have administrator access to a member account, you can use this API from the member account. Read about <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html">member accounts</a> in the <i>Organizations User Guide</i>. </p> </note>', 'DescribeUser' => '<p>Retrieves the user metadata and attributes from the <code>UserId</code> in an identity store.</p> <note> <p>If you have administrator access to a member account, you can use this API from the member account. Read about <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html">member accounts</a> in the <i>Organizations User Guide</i>. </p> </note>', 'GetGroupId' => '<p>Retrieves <code>GroupId</code> in an identity store.</p> <note> <p>If you have administrator access to a member account, you can use this API from the member account. Read about <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html">member accounts</a> in the <i>Organizations User Guide</i>. </p> </note>', 'GetGroupMembershipId' => '<p>Retrieves the <code>MembershipId</code> in an identity store.</p> <note> <p>If you have administrator access to a member account, you can use this API from the member account. Read about <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html">member accounts</a> in the <i>Organizations User Guide</i>. </p> </note>', 'GetUserId' => '<p>Retrieves the <code>UserId</code> in an identity store.</p> <note> <p>If you have administrator access to a member account, you can use this API from the member account. Read about <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html">member accounts</a> in the <i>Organizations User Guide</i>. </p> </note>', 'IsMemberInGroups' => '<p>Checks the user\'s membership in all requested groups and returns if the member exists in all queried groups.</p> <note> <p>If you have administrator access to a member account, you can use this API from the member account. Read about <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html">member accounts</a> in the <i>Organizations User Guide</i>. </p> </note>', 'ListGroupMemberships' => '<p>For the specified group in the specified identity store, returns the list of all <code>GroupMembership</code> objects and returns results in paginated form.</p> <note> <p>If you have administrator access to a member account, you can use this API from the member account. Read about <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html">member accounts</a> in the <i>Organizations User Guide</i>. </p> </note>', 'ListGroupMembershipsForMember' => '<p>For the specified member in the specified identity store, returns the list of all <code>GroupMembership</code> objects and returns results in paginated form.</p> <note> <p>If you have administrator access to a member account, you can use this API from the member account. Read about <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html">member accounts</a> in the <i>Organizations User Guide</i>. </p> </note>', 'ListGroups' => '<p>Lists all groups in the identity store. Returns a paginated list of complete <code>Group</code> objects. Filtering for a <code>Group</code> by the <code>DisplayName</code> attribute is deprecated. Instead, use the <code>GetGroupId</code> API action.</p> <note> <p>If you have administrator access to a member account, you can use this API from the member account. Read about <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html">member accounts</a> in the <i>Organizations User Guide</i>. </p> </note>', 'ListUsers' => '<p>Lists all users in the identity store. Returns a paginated list of complete <code>User</code> objects. Filtering for a <code>User</code> by the <code>UserName</code> attribute is deprecated. Instead, use the <code>GetUserId</code> API action.</p> <note> <p>If you have administrator access to a member account, you can use this API from the member account. Read about <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html">member accounts</a> in the <i>Organizations User Guide</i>.</p> </note>', 'UpdateGroup' => '<p>For the specified group in the specified identity store, updates the group metadata and attributes.</p>', 'UpdateUser' => '<p>For the specified user in the specified identity store, updates the user metadata and attributes.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'Address' => [ 'base' => '<p>The address associated with the specified user.</p>', 'refs' => [ 'Addresses$member' => NULL, ], ], 'Addresses' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Addresses' => '<p>A list of <code>Address</code> objects containing addresses associated with the user.</p>', 'DescribeUserResponse$Addresses' => '<p>The physical address of the user.</p>', 'User$Addresses' => '<p>A list of <code>Address</code> objects containing addresses associated with the user.</p>', ], ], 'AlternateIdentifier' => [ 'base' => '<p>A unique identifier for a user or group that is not the primary identifier. This value can be an identifier from an external identity provider (IdP) that is associated with the user, the group, or a unique attribute.</p>', 'refs' => [ 'GetGroupIdRequest$AlternateIdentifier' => '<p>A unique identifier for a user or group that is not the primary identifier. This value can be an identifier from an external identity provider (IdP) that is associated with the user, the group, or a unique attribute. For the unique attribute, the only valid path is <code>displayName</code>.</p>', 'GetUserIdRequest$AlternateIdentifier' => '<p>A unique identifier for a user or group that is not the primary identifier. This value can be an identifier from an external identity provider (IdP) that is associated with the user, the group, or a unique attribute. For the unique attribute, the only valid paths are <code>userName</code> and <code>emails.value</code>.</p>', ], ], 'AttributeOperation' => [ 'base' => '<p>An operation that applies to the requested group. This operation might add, replace, or remove an attribute.</p>', 'refs' => [ 'AttributeOperations$member' => NULL, ], ], 'AttributeOperations' => [ 'base' => NULL, 'refs' => [ 'UpdateGroupRequest$Operations' => '<p>A list of <code>AttributeOperation</code> objects to apply to the requested group. These operations might add, replace, or remove an attribute.</p>', 'UpdateUserRequest$Operations' => '<p>A list of <code>AttributeOperation</code> objects to apply to the requested user. These operations might add, replace, or remove an attribute.</p>', ], ], 'AttributePath' => [ 'base' => NULL, 'refs' => [ 'AttributeOperation$AttributePath' => '<p>A string representation of the path to a given attribute or sub-attribute. Supports JMESPath.</p>', 'Filter$AttributePath' => '<p>The attribute path that is used to specify which attribute name to search. Length limit is 255 characters. For example, <code>UserName</code> is a valid attribute path for the <code>ListUsers</code> API, and <code>DisplayName</code> is a valid attribute path for the <code>ListGroups</code> API.</p>', 'UniqueAttribute$AttributePath' => '<p>A string representation of the path to a given attribute or sub-attribute. Supports JMESPath.</p>', ], ], 'AttributeValue' => [ 'base' => '<p>The value of the attribute. This is a <code>Document</code> type. This type is not supported by Java V1, Go V1, and older versions of the CLI.</p>', 'refs' => [ 'AttributeOperation$AttributeValue' => '<p>The value of the attribute. This is a <code>Document</code> type. This type is not supported by Java V1, Go V1, and older versions of the CLI.</p>', 'UniqueAttribute$AttributeValue' => '<p>The value of the attribute. This is a <code>Document</code> type. This type is not supported by Java V1, Go V1, and older versions of the CLI.</p>', ], ], 'ConflictException' => [ 'base' => '<p>This request cannot be completed for one of the following reasons:</p> <ul> <li> <p>Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve the conflict before retrying this request.</p> </li> <li> <p>The requested resource was being concurrently modified by another request.</p> </li> </ul>', 'refs' => [], ], 'ConflictExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ConflictException$Reason' => '<p>This request cannot be completed for one of the following reasons:</p> <ul> <li> <p>Performing the requested operation would violate an existing uniqueness claim in the identity store. Resolve the conflict before retrying this request.</p> </li> <li> <p>The requested resource was being concurrently modified by another request.</p> </li> </ul>', ], ], 'CreateGroupMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupMembershipRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupMembershipResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'Email' => [ 'base' => '<p>The email address associated with the user.</p>', 'refs' => [ 'Emails$member' => NULL, ], ], 'Emails' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$Emails' => '<p>A list of <code>Email</code> objects containing email addresses associated with the user.</p>', 'DescribeUserResponse$Emails' => '<p>The email address of the user.</p>', 'User$Emails' => '<p>A list of <code>Email</code> objects containing email addresses associated with the user.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'InternalServerException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ServiceQuotaExceededException$Message' => NULL, 'ThrottlingException$Message' => NULL, 'ValidationException$Message' => NULL, ], ], 'ExternalId' => [ 'base' => '<p>The identifier issued to this resource by an external identity provider.</p>', 'refs' => [ 'AlternateIdentifier$ExternalId' => '<p>The identifier issued to this resource by an external identity provider.</p>', 'ExternalIds$member' => NULL, ], ], 'ExternalIdIdentifier' => [ 'base' => NULL, 'refs' => [ 'ExternalId$Id' => '<p>The identifier issued to this resource by an external identity provider.</p>', ], ], 'ExternalIdIssuer' => [ 'base' => NULL, 'refs' => [ 'ExternalId$Issuer' => '<p>The issuer for an external identifier.</p>', ], ], 'ExternalIds' => [ 'base' => NULL, 'refs' => [ 'DescribeGroupResponse$ExternalIds' => '<p>A list of <code>ExternalId</code> objects that contains the identifiers issued to this resource by an external identity provider.</p>', 'DescribeUserResponse$ExternalIds' => '<p>A list of <code>ExternalId</code> objects that contains the identifiers issued to this resource by an external identity provider.</p>', 'Group$ExternalIds' => '<p>A list of <code>ExternalId</code> objects that contains the identifiers issued to this resource by an external identity provider.</p>', 'User$ExternalIds' => '<p>A list of <code>ExternalId</code> objects that contains the identifiers issued to this resource by an external identity provider.</p>', ], ], 'Filter' => [ 'base' => '<p>A query filter used by <code>ListUsers</code> and <code>ListGroups</code>. This filter object provides the attribute name and attribute value to search users or groups.</p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'ListGroupsRequest$Filters' => '<p>A list of <code>Filter</code> objects, which is used in the <code>ListUsers</code> and <code>ListGroups</code> requests.</p>', 'ListUsersRequest$Filters' => '<p>A list of <code>Filter</code> objects, which is used in the <code>ListUsers</code> and <code>ListGroups</code> requests. </p>', ], ], 'GetGroupIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupIdResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupMembershipIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetGroupMembershipIdResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUserIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUserIdResponse' => [ 'base' => NULL, 'refs' => [], ], 'Group' => [ 'base' => '<p>A group object that contains the metadata and attributes for a specified group.</p>', 'refs' => [ 'Groups$member' => NULL, ], ], 'GroupDisplayName' => [ 'base' => NULL, 'refs' => [ 'CreateGroupRequest$DisplayName' => '<p>A string containing the name of the group. This value is commonly displayed when the group is referenced. <code>Administrator</code> and <code>AWSAdministrators</code> are reserved names and can\'t be used for users or groups.</p>', 'DescribeGroupResponse$DisplayName' => '<p>The group’s display name value. The length limit is 1,024 characters. This value can consist of letters, accented characters, symbols, numbers, punctuation, tab, new line, carriage return, space, and nonbreaking space in this attribute. This value is specified at the time that the group is created and stored as an attribute of the group object in the identity store.</p>', 'Group$DisplayName' => '<p>The display name value for the group. The length limit is 1,024 characters. This value can consist of letters, accented characters, symbols, numbers, punctuation, tab, new line, carriage return, space, and nonbreaking space in this attribute. This value is specified at the time the group is created and stored as an attribute of the group object in the identity store.</p>', ], ], 'GroupIds' => [ 'base' => NULL, 'refs' => [ 'IsMemberInGroupsRequest$GroupIds' => '<p>A list of identifiers for groups in the identity store.</p>', ], ], 'GroupMembership' => [ 'base' => '<p>Contains the identifiers for a group, a group member, and a <code>GroupMembership</code> object in the identity store.</p>', 'refs' => [ 'GroupMemberships$member' => NULL, ], ], 'GroupMembershipExistenceResult' => [ 'base' => '<p>Indicates whether a resource is a member of a group in the identity store.</p>', 'refs' => [ 'GroupMembershipExistenceResults$member' => NULL, ], ], 'GroupMembershipExistenceResults' => [ 'base' => NULL, 'refs' => [ 'IsMemberInGroupsResponse$Results' => '<p>A list containing the results of membership existence checks.</p>', ], ], 'GroupMemberships' => [ 'base' => NULL, 'refs' => [ 'ListGroupMembershipsForMemberResponse$GroupMemberships' => '<p>A list of <code>GroupMembership</code> objects in the group for a specified member.</p>', 'ListGroupMembershipsResponse$GroupMemberships' => '<p>A list of <code>GroupMembership</code> objects in the group.</p>', ], ], 'Groups' => [ 'base' => NULL, 'refs' => [ 'ListGroupsResponse$Groups' => '<p>A list of <code>Group</code> objects in the identity store.</p>', ], ], 'IdentityStoreId' => [ 'base' => NULL, 'refs' => [ 'CreateGroupMembershipRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'CreateGroupMembershipResponse$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'CreateGroupRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'CreateGroupResponse$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'CreateUserRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'CreateUserResponse$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'DeleteGroupMembershipRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'DeleteGroupRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'DeleteUserRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'DescribeGroupMembershipRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'DescribeGroupMembershipResponse$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'DescribeGroupRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store, such as <code>d-1234567890</code>. In this example, <code>d-</code> is a fixed prefix, and <code>1234567890</code> is a randomly generated string that contains numbers and lower case letters. This value is generated at the time that a new identity store is created.</p>', 'DescribeGroupResponse$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'DescribeUserRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store, such as <code>d-1234567890</code>. In this example, <code>d-</code> is a fixed prefix, and <code>1234567890</code> is a randomly generated string that contains numbers and lower case letters. This value is generated at the time that a new identity store is created.</p>', 'DescribeUserResponse$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'GetGroupIdRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'GetGroupIdResponse$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'GetGroupMembershipIdRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'GetGroupMembershipIdResponse$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'GetUserIdRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'GetUserIdResponse$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'Group$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'GroupMembership$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'IsMemberInGroupsRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'ListGroupMembershipsForMemberRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'ListGroupMembershipsRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'ListGroupsRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store, such as <code>d-1234567890</code>. In this example, <code>d-</code> is a fixed prefix, and <code>1234567890</code> is a randomly generated string that contains numbers and lower case letters. This value is generated at the time that a new identity store is created.</p>', 'ListUsersRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store, such as <code>d-1234567890</code>. In this example, <code>d-</code> is a fixed prefix, and <code>1234567890</code> is a randomly generated string that contains numbers and lower case letters. This value is generated at the time that a new identity store is created.</p>', 'UpdateGroupRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'UpdateUserRequest$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', 'User$IdentityStoreId' => '<p>The globally unique identifier for the identity store.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure with an internal server.</p>', 'refs' => [], ], 'IsMemberInGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'IsMemberInGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembershipsForMemberRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembershipsForMemberResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembershipsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupMembershipsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListGroupMembershipsForMemberRequest$MaxResults' => '<p>The maximum number of results to be returned per request. This parameter is used in the <code>ListUsers</code> and <code>ListGroups</code> requests to specify how many results to return in one page. The length limit is 50 characters.</p>', 'ListGroupMembershipsRequest$MaxResults' => '<p>The maximum number of results to be returned per request. This parameter is used in all <code>List</code> requests to specify how many results to return in one page.</p>', 'ListGroupsRequest$MaxResults' => '<p>The maximum number of results to be returned per request. This parameter is used in the <code>ListUsers</code> and <code>ListGroups</code> requests to specify how many results to return in one page. The length limit is 50 characters.</p>', 'ListUsersRequest$MaxResults' => '<p>The maximum number of results to be returned per request. This parameter is used in the <code>ListUsers</code> and <code>ListGroups</code> requests to specify how many results to return in one page. The length limit is 50 characters.</p>', ], ], 'MemberId' => [ 'base' => '<p>An object containing the identifier of a group member.</p>', 'refs' => [ 'CreateGroupMembershipRequest$MemberId' => '<p>An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the specific identifier for a user indicates that the user is a member of the group.</p>', 'DescribeGroupMembershipResponse$MemberId' => NULL, 'GetGroupMembershipIdRequest$MemberId' => '<p>An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the specific identifier for a user indicates that the user is a member of the group.</p>', 'GroupMembership$MemberId' => '<p>An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the specific identifier for a user indicates that the user is a member of the group.</p>', 'GroupMembershipExistenceResult$MemberId' => '<p>An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the specific identifier for a user indicates that the user is a member of the group.</p>', 'IsMemberInGroupsRequest$MemberId' => '<p>An object containing the identifier of a group member.</p>', 'ListGroupMembershipsForMemberRequest$MemberId' => '<p>An object that contains the identifier of a group member. Setting the <code>UserID</code> field to the specific identifier for a user indicates that the user is a member of the group.</p>', ], ], 'Name' => [ 'base' => '<p>The full name of the user.</p>', 'refs' => [ 'CreateUserRequest$Name' => '<p>An object containing the name of the user.</p>', 'DescribeUserResponse$Name' => '<p>The name of the user.</p>', 'User$Name' => '<p>An object containing the name of the user.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListGroupMembershipsForMemberRequest$NextToken' => '<p>The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page.</p>', 'ListGroupMembershipsForMemberResponse$NextToken' => '<p>The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page. </p>', 'ListGroupMembershipsRequest$NextToken' => '<p>The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code> and <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page.</p>', 'ListGroupMembershipsResponse$NextToken' => '<p>The pagination token used for the <code>ListUsers</code>, <code>ListGroups</code>, and <code>ListGroupMemberships</code> API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page.</p>', 'ListGroupsRequest$NextToken' => '<p>The pagination token used for the <code>ListUsers</code> and <code>ListGroups</code> API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page.</p>', 'ListGroupsResponse$NextToken' => '<p>The pagination token used for the <code>ListUsers</code> and <code>ListGroups</code> API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it1 is used in the API request to search for the next page.</p>', 'ListUsersRequest$NextToken' => '<p>The pagination token used for the <code>ListUsers</code> and <code>ListGroups</code> API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page.</p>', 'ListUsersResponse$NextToken' => '<p>The pagination token used for the <code>ListUsers</code> and <code>ListGroups</code> API operations. This value is generated by the identity store service. It is returned in the API response if the total results are more than the size of one page. This token is also returned when it is used in the API request to search for the next page.</p>', ], ], 'PhoneNumber' => [ 'base' => '<p>The phone number associated with the user.</p>', 'refs' => [ 'PhoneNumbers$member' => NULL, ], ], 'PhoneNumbers' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$PhoneNumbers' => '<p>A list of <code>PhoneNumber</code> objects containing phone numbers associated with the user.</p>', 'DescribeUserResponse$PhoneNumbers' => '<p>A list of <code>PhoneNumber</code> objects associated with a user.</p>', 'User$PhoneNumbers' => '<p>A list of <code>PhoneNumber</code> objects containing phone numbers associated with the user.</p>', ], ], 'RequestId' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$RequestId' => '<p>The identifier for each request. This value is a globally unique ID that is generated by the identity store service for each sent request, and is then returned inside the exception if the request fails.</p>', 'ConflictException$RequestId' => '<p>The identifier for each request. This value is a globally unique ID that is generated by the identity store service for each sent request, and is then returned inside the exception if the request fails.</p>', 'InternalServerException$RequestId' => '<p>The identifier for each request. This value is a globally unique ID that is generated by the identity store service for each sent request, and is then returned inside the exception if the request fails.</p>', 'ResourceNotFoundException$RequestId' => '<p>The identifier for each request. This value is a globally unique ID that is generated by the identity store service for each sent request, and is then returned inside the exception if the request fails.</p>', 'ServiceQuotaExceededException$RequestId' => '<p>The identifier for each request. This value is a globally unique ID that is generated by the identity store service for each sent request, and is then returned inside the exception if the request fails.</p>', 'ThrottlingException$RequestId' => '<p>The identifier for each request. This value is a globally unique ID that is generated by the identity store service for each sent request, and is then returned inside the exception if the request fails.</p>', 'ValidationException$RequestId' => '<p>The identifier for each request. This value is a globally unique ID that is generated by the identity store service for each sent request, and is then returned inside the exception if the request fails.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'CreateGroupMembershipRequest$GroupId' => '<p>The identifier for a group in the identity store.</p>', 'CreateGroupMembershipResponse$MembershipId' => '<p>The identifier for a newly created <code>GroupMembership</code> in an identity store.</p>', 'CreateGroupResponse$GroupId' => '<p>The identifier of the newly created group in the identity store.</p>', 'CreateUserResponse$UserId' => '<p>The identifier of the newly created user in the identity store.</p>', 'DeleteGroupMembershipRequest$MembershipId' => '<p>The identifier for a <code>GroupMembership</code> in an identity store.</p>', 'DeleteGroupRequest$GroupId' => '<p>The identifier for a group in the identity store.</p>', 'DeleteUserRequest$UserId' => '<p>The identifier for a user in the identity store.</p>', 'DescribeGroupMembershipRequest$MembershipId' => '<p>The identifier for a <code>GroupMembership</code> in an identity store.</p>', 'DescribeGroupMembershipResponse$MembershipId' => '<p>The identifier for a <code>GroupMembership</code> in an identity store.</p>', 'DescribeGroupMembershipResponse$GroupId' => '<p>The identifier for a group in the identity store.</p>', 'DescribeGroupRequest$GroupId' => '<p>The identifier for a group in the identity store.</p>', 'DescribeGroupResponse$GroupId' => '<p>The identifier for a group in the identity store.</p>', 'DescribeUserRequest$UserId' => '<p>The identifier for a user in the identity store.</p>', 'DescribeUserResponse$UserId' => '<p>The identifier for a user in the identity store.</p>', 'GetGroupIdResponse$GroupId' => '<p>The identifier for a group in the identity store.</p>', 'GetGroupMembershipIdRequest$GroupId' => '<p>The identifier for a group in the identity store.</p>', 'GetGroupMembershipIdResponse$MembershipId' => '<p>The identifier for a <code>GroupMembership</code> in an identity store.</p>', 'GetUserIdResponse$UserId' => '<p>The identifier for a user in the identity store.</p>', 'Group$GroupId' => '<p>The identifier for a group in the identity store.</p>', 'GroupIds$member' => NULL, 'GroupMembership$MembershipId' => '<p>The identifier for a <code>GroupMembership</code> object in an identity store.</p>', 'GroupMembership$GroupId' => '<p>The identifier for a group in the identity store.</p>', 'GroupMembershipExistenceResult$GroupId' => '<p>The identifier for a group in the identity store.</p>', 'ListGroupMembershipsRequest$GroupId' => '<p>The identifier for a group in the identity store.</p>', 'MemberId$UserId' => '<p>An object containing the identifiers of resources that can be members.</p>', 'ResourceNotFoundException$ResourceId' => '<p>The identifier for a resource in the identity store that can be used as <code>UserId</code> or <code>GroupId</code>. The format for <code>ResourceId</code> is either <code>UUID</code> or <code>1234567890-UUID</code>, where <code>UUID</code> is a randomly generated value for each resource when it is created and <code>1234567890</code> represents the <code>IdentityStoreId</code> string value. In the case that the identity store is migrated from a legacy SSO identity store, the <code>ResourceId</code> for that identity store will be in the format of <code>UUID</code>. Otherwise, it will be in the <code>1234567890-UUID</code> format.</p>', 'UpdateGroupRequest$GroupId' => '<p>The identifier for a group in the identity store.</p>', 'UpdateUserRequest$UserId' => '<p>The identifier for a user in the identity store.</p>', 'User$UserId' => '<p>The identifier for a user in the identity store.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Indicates that a requested resource is not found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$ResourceType' => '<p>An enum object indicating the type of resource in the identity store service. Valid values include USER, GROUP, and IDENTITY_STORE.</p>', ], ], 'RetryAfterSeconds' => [ 'base' => NULL, 'refs' => [ 'InternalServerException$RetryAfterSeconds' => '<p>The number of seconds to wait before retrying the next request.</p>', 'ThrottlingException$RetryAfterSeconds' => '<p>The number of seconds to wait before retrying the next request.</p>', ], ], 'SensitiveBooleanType' => [ 'base' => NULL, 'refs' => [ 'Address$Primary' => '<p>A Boolean value representing whether this is the primary address for the associated resource.</p>', 'Email$Primary' => '<p>A Boolean value representing whether this is the primary email address for the associated resource.</p>', 'GroupMembershipExistenceResult$MembershipExists' => '<p>Indicates whether a membership relation exists or not.</p>', 'PhoneNumber$Primary' => '<p>A Boolean value representing whether this is the primary phone number for the associated resource.</p>', ], ], 'SensitiveStringType' => [ 'base' => NULL, 'refs' => [ 'Address$StreetAddress' => '<p>The street of the address.</p>', 'Address$Locality' => '<p>A string of the address locality.</p>', 'Address$Region' => '<p>The region of the address.</p>', 'Address$PostalCode' => '<p>The postal code of the address.</p>', 'Address$Country' => '<p>The country of the address.</p>', 'Address$Formatted' => '<p>A string containing a formatted version of the address for display.</p>', 'Address$Type' => '<p>A string representing the type of address. For example, "Home."</p>', 'CreateGroupRequest$Description' => '<p>A string containing the description of the group.</p>', 'CreateUserRequest$DisplayName' => '<p>A string containing the name of the user. This value is typically formatted for display when the user is referenced. For example, "John Doe." </p>', 'CreateUserRequest$NickName' => '<p>A string containing an alternate name for the user.</p>', 'CreateUserRequest$ProfileUrl' => '<p>A string containing a URL that might be associated with the user.</p>', 'CreateUserRequest$UserType' => '<p>A string indicating the type of user. Possible values are left unspecified. The value can vary based on your specific use case.</p>', 'CreateUserRequest$Title' => '<p>A string containing the title of the user. Possible values are left unspecified. The value can vary based on your specific use case.</p>', 'CreateUserRequest$PreferredLanguage' => '<p>A string containing the preferred language of the user. For example, "American English" or "en-us."</p>', 'CreateUserRequest$Locale' => '<p>A string containing the geographical region or location of the user.</p>', 'CreateUserRequest$Timezone' => '<p>A string containing the time zone of the user.</p>', 'DescribeGroupResponse$Description' => '<p>A string containing a description of the group.</p>', 'DescribeUserResponse$DisplayName' => '<p>The display name of the user.</p>', 'DescribeUserResponse$NickName' => '<p>An alternative descriptive name for the user.</p>', 'DescribeUserResponse$ProfileUrl' => '<p>A URL link for the user\'s profile.</p>', 'DescribeUserResponse$UserType' => '<p>A string indicating the type of user.</p>', 'DescribeUserResponse$Title' => '<p>A string containing the title of the user.</p>', 'DescribeUserResponse$PreferredLanguage' => '<p>The preferred language of the user.</p>', 'DescribeUserResponse$Locale' => '<p>A string containing the geographical region or location of the user.</p>', 'DescribeUserResponse$Timezone' => '<p>The time zone for a user.</p>', 'Email$Value' => '<p>A string containing an email address. For example, "johndoe@amazon.com."</p>', 'Email$Type' => '<p>A string representing the type of address. For example, "Work."</p>', 'Filter$AttributeValue' => '<p>Represents the data for an attribute. Each attribute value is described as a name-value pair. </p>', 'Group$Description' => '<p>A string containing a description of the specified group.</p>', 'Name$Formatted' => '<p>A string containing a formatted version of the name for display.</p>', 'Name$FamilyName' => '<p>The family name of the user.</p>', 'Name$GivenName' => '<p>The given name of the user.</p>', 'Name$MiddleName' => '<p>The middle name of the user.</p>', 'Name$HonorificPrefix' => '<p>The honorific prefix of the user. For example, "Dr."</p>', 'Name$HonorificSuffix' => '<p>The honorific suffix of the user. For example, "M.D."</p>', 'PhoneNumber$Value' => '<p>A string containing a phone number. For example, "8675309" or "+1 (800) 123-4567".</p>', 'PhoneNumber$Type' => '<p>A string representing the type of a phone number. For example, "Mobile."</p>', 'User$DisplayName' => '<p>A string containing the name of the user that is formatted for display when the user is referenced. For example, "John Doe."</p>', 'User$NickName' => '<p>A string containing an alternate name for the user.</p>', 'User$ProfileUrl' => '<p>A string containing a URL that might be associated with the user.</p>', 'User$UserType' => '<p>A string indicating the type of user. Possible values are left unspecified. The value can vary based on your specific use case.</p>', 'User$Title' => '<p>A string containing the title of the user. Possible values are left unspecified. The value can vary based on your specific use case.</p>', 'User$PreferredLanguage' => '<p>A string containing the preferred language of the user. For example, "American English" or "en-us."</p>', 'User$Locale' => '<p>A string containing the geographical region or location of the user.</p>', 'User$Timezone' => '<p>A string containing the time zone of the user.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The request would cause the number of users or groups in the identity store to exceed the maximum allowed.</p>', 'refs' => [], ], 'ThrottlingException' => [ 'base' => '<p>Indicates that the principal has crossed the throttling limits of the API operations.</p>', 'refs' => [], ], 'UniqueAttribute' => [ 'base' => '<p>An entity attribute that\'s unique to a specific entity.</p>', 'refs' => [ 'AlternateIdentifier$UniqueAttribute' => '<p>An entity attribute that\'s unique to a specific entity.</p>', ], ], 'UpdateGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'User' => [ 'base' => '<p>A user object that contains the metadata and attributes for a specified user.</p>', 'refs' => [ 'Users$member' => NULL, ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$UserName' => '<p>A unique string used to identify the user. The length limit is 128 characters. This value can consist of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created and stored as an attribute of the user object in the identity store. <code>Administrator</code> and <code>AWSAdministrators</code> are reserved names and can\'t be used for users or groups.</p>', 'DescribeUserResponse$UserName' => '<p>A unique string used to identify the user. The length limit is 128 characters. This value can consist of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created and stored as an attribute of the user object in the identity store.</p>', 'User$UserName' => '<p>A unique string used to identify the user. The length limit is 128 characters. This value can consist of letters, accented characters, symbols, numbers, and punctuation. This value is specified at the time the user is created and stored as an attribute of the user object in the identity store.</p>', ], ], 'Users' => [ 'base' => NULL, 'refs' => [ 'ListUsersResponse$Users' => '<p>A list of <code>User</code> objects in the identity store.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The request failed because it contains a syntax error.</p>', 'refs' => [], ], ],];
