<?php
// This file was auto-generated from sdk-root/src/data/internetmonitor/2021-06-03/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon CloudWatch Internet Monitor provides visibility into how internet issues impact the performance and availability between your applications hosted on Amazon Web Services and your end users. It can reduce the time it takes for you to diagnose internet issues from days to minutes. Internet Monitor uses the connectivity data that Amazon Web Services captures from its global networking footprint to calculate a baseline of performance and availability for internet traffic. This is the same data that Amazon Web Services uses to monitor internet uptime and availability. With those measurements as a baseline, Internet Monitor raises awareness for you when there are significant problems for your end users in the different geographic locations where your application runs.</p> <p>Internet Monitor publishes internet measurements to CloudWatch Logs and CloudWatch Metrics, to easily support using CloudWatch tools with health information for geographies and networks specific to your application. Internet Monitor sends health events to Amazon EventBridge so that you can set up notifications. If an issue is caused by the Amazon Web Services network, you also automatically receive an Amazon Web Services Health Dashboard notification with the steps that Amazon Web Services is taking to mitigate the problem.</p> <p>To use Internet Monitor, you create a <i>monitor</i> and associate your application\'s resources with it - VPCs, NLBs, CloudFront distributions, or WorkSpaces directories - so Internet Monitor can determine where your application\'s internet traffic is. Internet Monitor then provides internet measurements from Amazon Web Services that are specific to the locations and ASNs (typically, internet service providers or ISPs) that communicate with your application.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-InternetMonitor.html">Using Amazon CloudWatch Internet Monitor</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', 'operations' => [ 'CreateMonitor' => '<p>Creates a monitor in Amazon CloudWatch Internet Monitor. A monitor is built based on information from the application resources that you add: VPCs, Network Load Balancers (NLBs), Amazon CloudFront distributions, and Amazon WorkSpaces directories. Internet Monitor then publishes internet measurements from Amazon Web Services that are specific to the <i>city-networks</i>. That is, the locations and ASNs (typically internet service providers or ISPs), where clients access your application. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-InternetMonitor.html">Using Amazon CloudWatch Internet Monitor</a> in the <i>Amazon CloudWatch User Guide</i>.</p> <p>When you create a monitor, you choose the percentage of traffic that you want to monitor. You can also set a maximum limit for the number of city-networks where client traffic is monitored, that caps the total traffic that Internet Monitor monitors. A city-network maximum is the limit of city-networks, but you only pay for the number of city-networks that are actually monitored. You can update your monitor at any time to change the percentage of traffic to monitor or the city-networks maximum. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html">Choosing a city-network maximum value</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', 'DeleteMonitor' => '<p>Deletes a monitor in Amazon CloudWatch Internet Monitor. </p>', 'GetHealthEvent' => '<p>Gets information that Amazon CloudWatch Internet Monitor has created and stored about a health event for a specified monitor. This information includes the impacted locations, and all the information related to the event, by location.</p> <p>The information returned includes the impact on performance, availability, and round-trip time, information about the network providers (ASNs), the event type, and so on.</p> <p>Information rolled up at the global traffic level is also returned, including the impact type and total traffic impact.</p>', 'GetInternetEvent' => '<p>Gets information that Amazon CloudWatch Internet Monitor has generated about an internet event. Internet Monitor displays information about recent global health events, called internet events, on a global outages map that is available to all Amazon Web Services customers. </p> <p>The information returned here includes the impacted location, when the event started and (if the event is over) ended, the type of event (<code>PERFORMANCE</code> or <code>AVAILABILITY</code>), and the status (<code>ACTIVE</code> or <code>RESOLVED</code>).</p>', 'GetMonitor' => '<p>Gets information about a monitor in Amazon CloudWatch Internet Monitor based on a monitor name. The information returned includes the Amazon Resource Name (ARN), create time, modified time, resources included in the monitor, and status information.</p>', 'GetQueryResults' => '<p>Return the data for a query with the Amazon CloudWatch Internet Monitor query interface. Specify the query that you want to return results for by providing a <code>QueryId</code> and a monitor name.</p> <p>For more information about using the query interface, including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html">Using the Amazon CloudWatch Internet Monitor query interface</a> in the Amazon CloudWatch Internet Monitor User Guide.</p>', 'GetQueryStatus' => '<p>Returns the current status of a query for the Amazon CloudWatch Internet Monitor query interface, for a specified query ID and monitor. When you run a query, check the status to make sure that the query has <code>SUCCEEDED</code> before you review the results.</p> <ul> <li> <p> <code>QUEUED</code>: The query is scheduled to run.</p> </li> <li> <p> <code>RUNNING</code>: The query is in progress but not complete.</p> </li> <li> <p> <code>SUCCEEDED</code>: The query completed sucessfully.</p> </li> <li> <p> <code>FAILED</code>: The query failed due to an error.</p> </li> <li> <p> <code>CANCELED</code>: The query was canceled.</p> </li> </ul>', 'ListHealthEvents' => '<p>Lists all health events for a monitor in Amazon CloudWatch Internet Monitor. Returns information for health events including the event start and end times, and the status.</p> <note> <p>Health events that have start times during the time frame that is requested are not included in the list of health events.</p> </note>', 'ListInternetEvents' => '<p>Lists internet events that cause performance or availability issues for client locations. Amazon CloudWatch Internet Monitor displays information about recent global health events, called internet events, on a global outages map that is available to all Amazon Web Services customers. </p> <p>You can constrain the list of internet events returned by providing a start time and end time to define a total time frame for events you want to list. Both start time and end time specify the time when an event started. End time is optional. If you don\'t include it, the default end time is the current time.</p> <p>You can also limit the events returned to a specific status (<code>ACTIVE</code> or <code>RESOLVED</code>) or type (<code>PERFORMANCE</code> or <code>AVAILABILITY</code>).</p>', 'ListMonitors' => '<p>Lists all of your monitors for Amazon CloudWatch Internet Monitor and their statuses, along with the Amazon Resource Name (ARN) and name of each monitor.</p>', 'ListTagsForResource' => '<p>Lists the tags for a resource. Tags are supported only for monitors in Amazon CloudWatch Internet Monitor.</p>', 'StartQuery' => '<p>Start a query to return data for a specific query type for the Amazon CloudWatch Internet Monitor query interface. Specify a time period for the data that you want returned by using <code>StartTime</code> and <code>EndTime</code>. You filter the query results to return by providing parameters that you specify with <code>FilterParameters</code>.</p> <p>For more information about using the query interface, including examples, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html">Using the Amazon CloudWatch Internet Monitor query interface</a> in the Amazon CloudWatch Internet Monitor User Guide.</p>', 'StopQuery' => '<p>Stop a query that is progress for a specific monitor.</p>', 'TagResource' => '<p>Adds a tag to a resource. Tags are supported only for monitors in Amazon CloudWatch Internet Monitor. You can add a maximum of 50 tags in Internet Monitor.</p> <p>A minimum of one tag is required for this call. It returns an error if you use the <code>TagResource</code> request with 0 tags.</p>', 'UntagResource' => '<p>Removes a tag from a resource.</p>', 'UpdateMonitor' => '<p>Updates a monitor. You can update a monitor to change the percentage of traffic to monitor or the maximum number of city-networks (locations and ASNs), to add or remove resources, or to change the status of the monitor. Note that you can\'t change the name of a monitor.</p> <p>The city-network maximum that you choose is the limit, but you only pay for the number of city-networks that are actually monitored. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html">Choosing a city-network maximum value</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have sufficient permission to perform this action.</p>', 'refs' => [], ], 'AccountId' => [ 'base' => NULL, 'refs' => [ 'GetHealthEventInput$LinkedAccountId' => '<p>The account ID for an account that you\'ve set up cross-account sharing for in Amazon CloudWatch Internet Monitor. You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet Monitor cross-account observability</a> in the Amazon CloudWatch Internet Monitor User Guide.</p>', 'GetMonitorInput$LinkedAccountId' => '<p>The account ID for an account that you\'ve set up cross-account sharing for in Amazon CloudWatch Internet Monitor. You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet Monitor cross-account observability</a> in the Amazon CloudWatch Internet Monitor User Guide.</p>', 'ListHealthEventsInput$LinkedAccountId' => '<p>The account ID for an account that you\'ve set up cross-account sharing for in Amazon CloudWatch Internet Monitor. You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet Monitor cross-account observability</a> in the Amazon CloudWatch Internet Monitor User Guide.</p>', 'StartQueryInput$LinkedAccountId' => '<p>The account ID for an account that you\'ve set up cross-account sharing for in Amazon CloudWatch Internet Monitor. You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet Monitor cross-account observability</a> in the Amazon CloudWatch Internet Monitor User Guide.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'GetHealthEventOutput$EventArn' => '<p>The Amazon Resource Name (ARN) of the event.</p>', 'GetInternetEventOutput$EventArn' => '<p>The Amazon Resource Name (ARN) of the internet event.</p>', 'HealthEvent$EventArn' => '<p>The Amazon Resource Name (ARN) of the event.</p>', 'InternetEventSummary$EventArn' => '<p>The Amazon Resource Name (ARN) of the internet event.</p>', 'SetOfARNs$member' => NULL, ], ], 'AvailabilityMeasurement' => [ 'base' => '<p>Amazon CloudWatch Internet Monitor calculates measurements about the availability for your application\'s internet traffic between client locations and Amazon Web Services. Amazon Web Services has substantial historical data about internet performance and availability between Amazon Web Services services and different network providers and geographies. By applying statistical analysis to the data, Internet Monitor can detect when the performance and availability for your application has dropped, compared to an estimated baseline that\'s already calculated. To make it easier to see those drops, we report that information to you in the form of health scores: a performance score and an availability score.</p> <p>Availability in Internet Monitor represents the estimated percentage of traffic that is not seeing an availability drop. For example, an availability score of 99% for an end user and service location pair is equivalent to 1% of the traffic experiencing an availability drop for that pair.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores">How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch Internet Monitor section of the <i>Amazon CloudWatch User Guide</i>.</p>', 'refs' => [ 'InternetHealth$Availability' => '<p>Availability in Internet Monitor represents the estimated percentage of traffic that is not seeing an availability drop. For example, an availability score of 99% for an end user and service location pair is equivalent to 1% of the traffic experiencing an availability drop for that pair.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores">How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>A bad request was received.</p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ListMonitorsInput$IncludeLinkedAccounts' => '<p>A boolean option that you can set to <code>TRUE</code> to include monitors for linked accounts in a list of monitors, when you\'ve set up cross-account sharing in Amazon CloudWatch Internet Monitor. You configure cross-account sharing by using Amazon CloudWatch Observability Access Manager. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cwim-cross-account.html">Internet Monitor cross-account observability</a> in the Amazon CloudWatch Internet Monitor User Guide.</p>', ], ], 'ClientLocation' => [ 'base' => '<p>The impacted location, such as a city, that Amazon Web Services clients access application resources from.</p>', 'refs' => [ 'GetInternetEventOutput$ClientLocation' => '<p>The impacted location, such as a city, where clients access Amazon Web Services application resources.</p>', 'InternetEventSummary$ClientLocation' => '<p>The impacted location, such as a city, that Amazon Web Services clients access application resources from.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The requested resource is in use.</p>', 'refs' => [], ], 'CreateMonitorInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitorOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMonitorInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMonitorOutput' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'AvailabilityMeasurement$ExperienceScore' => '<p>Experience scores, or health scores are calculated for different geographic and network provider combinations (that is, different granularities) and also summed into global scores. If you view performance or availability scores without filtering for any specific geography or service provider, Amazon CloudWatch Internet Monitor provides global health scores.</p> <p>The Amazon CloudWatch Internet Monitor chapter in the <i>CloudWatch User Guide</i> includes detailed information about how Internet Monitor calculates health scores, including performance and availability scores, and when it creates and resolves health events. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores">How Amazon Web Services calculates performance and availability scores</a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'AvailabilityMeasurement$PercentOfTotalTrafficImpacted' => '<p>The impact on total traffic that a health event has, in increased latency or reduced availability. This is the percentage of how much latency has increased or availability has decreased during the event, compared to what is typical for traffic from this client location to the Amazon Web Services location using this client network.</p> <p>For information about how Internet Monitor calculates impact, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html">How Internet Monitor works</a> in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch User Guide.</p>', 'AvailabilityMeasurement$PercentOfClientLocationImpacted' => '<p>The percentage of impact caused by a health event for client location traffic globally.</p> <p>For information about how Internet Monitor calculates impact, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html">Inside Internet Monitor</a> in the Amazon CloudWatch Internet Monitor section of the Amazon CloudWatch User Guide.</p>', 'ClientLocation$Latitude' => '<p>The latitude where the internet event is located.</p>', 'ClientLocation$Longitude' => '<p>The longitude where the internet event is located.</p>', 'GetHealthEventOutput$PercentOfTotalTrafficImpacted' => '<p>The impact on total traffic that a health event has, in increased latency or reduced availability. This is the percentage of how much latency has increased or availability has decreased during the event, compared to what is typical for traffic from this client location to the Amazon Web Services location using this client network.</p>', 'HealthEvent$PercentOfTotalTrafficImpacted' => '<p>The impact on total traffic that a health event has, in increased latency or reduced availability. This is the percentage of how much latency has increased or availability has decreased during the event, compared to what is typical for traffic from this client location to the Amazon Web Services location using this client network.</p>', 'ImpactedLocation$Latitude' => '<p>The latitude where the health event is located.</p>', 'ImpactedLocation$Longitude' => '<p>The longitude where the health event is located.</p>', 'PerformanceMeasurement$ExperienceScore' => '<p>Experience scores, or health scores, are calculated for different geographic and network provider combinations (that is, different granularities) and also totaled into global scores. If you view performance or availability scores without filtering for any specific geography or service provider, Amazon CloudWatch Internet Monitor provides global health scores.</p> <p>The Amazon CloudWatch Internet Monitor chapter in the CloudWatch User Guide includes detailed information about how Internet Monitor calculates health scores, including performance and availability scores, and when it creates and resolves health events. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores">How Amazon Web Services calculates performance and availability scores</a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'PerformanceMeasurement$PercentOfTotalTrafficImpacted' => '<p>The impact on total traffic that a health event has, in increased latency or reduced availability. This is the percentage of how much latency has increased or availability has decreased during the event, compared to what is typical for traffic from this client location to the Amazon Web Services location using this client network.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMHealthEventStartStop">When Amazon Web Services creates and resolves health events</a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'PerformanceMeasurement$PercentOfClientLocationImpacted' => '<p>How much performance impact was caused by a health event at a client location. For performance, this is the percentage of how much latency increased during the event compared to typical performance for traffic, from this client location to an Amazon Web Services location, using a specific client network. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMHealthEventStartStop">When Amazon Web Services creates and resolves health events</a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'RoundTripTime$P50' => '<p>RTT at the 50th percentile (p50).</p>', 'RoundTripTime$P90' => '<p>RTT at the 90th percentile (p90). </p>', 'RoundTripTime$P95' => '<p>RTT at the 95th percentile (p95). </p>', ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'FilterParameter$Values' => '<p>One or more values to be used, together with the specified operator, to filter data for a query. For example, you could specify an array of values such as <code>["Seattle", "Redmond"]</code>. Values in the array are separated by commas.</p>', ], ], 'FilterParameter' => [ 'base' => '<p>A filter that you use with the results of a Amazon CloudWatch Internet Monitor query that you created and ran. The query sets up a repository of data that is a subset of your application\'s Internet Monitor data. <code>FilterParameter</code> is a string that defines how you want to filter the repository of data to return a set of results, based on your criteria.</p> <p>The filter parameters that you can specify depend on the query type that you used to create the repository, since each query type returns a different set of Internet Monitor data.</p> <p>For each filter, you specify a field (such as <code>city</code>), an operator (such as <code>not_equals</code>, and a value or array of values (such as <code>["Seattle", "Redmond"]</code>). Separate values in the array with commas.</p> <p>For more information about specifying filter parameters, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html">Using the Amazon CloudWatch Internet Monitor query interface</a> in the Amazon CloudWatch Internet Monitor User Guide.</p>', 'refs' => [ 'FilterParameters$member' => NULL, ], ], 'FilterParameters' => [ 'base' => NULL, 'refs' => [ 'StartQueryInput$FilterParameters' => '<p>The <code>FilterParameters</code> field that you use with Amazon CloudWatch Internet Monitor queries is a string the defines how you want a query to be filtered. The filter parameters that you can specify depend on the query type, since each query type returns a different set of Internet Monitor data.</p> <p>For more information about specifying filter parameters, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html">Using the Amazon CloudWatch Internet Monitor query interface</a> in the Amazon CloudWatch Internet Monitor User Guide.</p>', ], ], 'GetHealthEventInput' => [ 'base' => NULL, 'refs' => [], ], 'GetHealthEventOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetInternetEventInput' => [ 'base' => NULL, 'refs' => [], ], 'GetInternetEventOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMonitorInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMonitorOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryResultsInput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryResultsOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryStatusInput' => [ 'base' => NULL, 'refs' => [], ], 'GetQueryStatusOutput' => [ 'base' => NULL, 'refs' => [], ], 'HealthEvent' => [ 'base' => '<p>Information about a health event created in a monitor in Amazon CloudWatch Internet Monitor.</p>', 'refs' => [ 'HealthEventList$member' => NULL, ], ], 'HealthEventImpactType' => [ 'base' => NULL, 'refs' => [ 'GetHealthEventOutput$ImpactType' => '<p>The type of impairment of a specific health event.</p>', 'HealthEvent$ImpactType' => '<p>The type of impairment for a health event.</p>', ], ], 'HealthEventList' => [ 'base' => NULL, 'refs' => [ 'ListHealthEventsOutput$HealthEvents' => '<p>A list of health events.</p>', ], ], 'HealthEventName' => [ 'base' => NULL, 'refs' => [ 'GetHealthEventInput$EventId' => '<p>The internally-generated identifier of a health event. Because <code>EventID</code> contains the forward slash (“/”) character, you must URL-encode the <code>EventID</code> field in the request URL.</p>', 'GetHealthEventOutput$EventId' => '<p>The internally-generated identifier of a health event.</p>', 'HealthEvent$EventId' => '<p>The internally-generated identifier of a specific network traffic impairment health event.</p>', ], ], 'HealthEventStatus' => [ 'base' => NULL, 'refs' => [ 'GetHealthEventOutput$Status' => '<p>The status of a health event.</p>', 'HealthEvent$Status' => '<p>The status of a health event.</p>', 'ImpactedLocation$Status' => '<p>The status of the health event at an impacted location.</p>', 'ListHealthEventsInput$EventStatus' => '<p>The status of a health event.</p>', ], ], 'HealthEventsConfig' => [ 'base' => '<p>A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for an overall performance or availability issue, across an application\'s geographies.</p> <p>Defines the percentages, for overall performance scores and availability scores for an application, that are the thresholds for when Amazon CloudWatch Internet Monitor creates a health event. You can override the defaults to set a custom threshold for overall performance or availability scores, or both.</p> <p>You can also set thresholds for local health scores,, where Internet Monitor creates a health event when scores cross a threshold for one or more city-networks, in addition to creating an event when an overall score crosses a threshold.</p> <p>If you don\'t set a health event threshold, the default value is 95%.</p> <p>For local thresholds, you also set a minimum percentage of overall traffic that is impacted by an issue before Internet Monitor creates an event. In addition, you can disable local thresholds, for performance scores, availability scores, or both.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview"> Change health event thresholds</a> in the Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'refs' => [ 'CreateMonitorInput$HealthEventsConfig' => '<p>Defines the threshold percentages and other configuration information for when Amazon CloudWatch Internet Monitor creates a health event. Internet Monitor creates a health event when an internet issue that affects your application end users has a health score percentage that is at or below a specific threshold, and, sometimes, when other criteria are met.</p> <p>If you don\'t set a health event threshold, the default value is 95%.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview"> Change health event thresholds</a> in the Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'GetMonitorOutput$HealthEventsConfig' => '<p>The list of health event threshold configurations. The threshold percentage for a health score determines, along with other configuration information, when Internet Monitor creates a health event when there\'s an internet issue that affects your application end users.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview"> Change health event thresholds</a> in the Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'UpdateMonitorInput$HealthEventsConfig' => '<p>The list of health score thresholds. A threshold percentage for health scores, along with other configuration information, determines when Internet Monitor creates a health event when there\'s an internet issue that affects your application end users.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview"> Change health event thresholds</a> in the Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', ], ], 'ImpactedLocation' => [ 'base' => '<p>Information about a location impacted by a health event in Amazon CloudWatch Internet Monitor.</p> <p>Geographic regions are hierarchically categorized into country, subdivision, metro and city geographic granularities. The geographic region is identified based on the IP address used at the client locations.</p>', 'refs' => [ 'ImpactedLocationsList$member' => NULL, ], ], 'ImpactedLocationsList' => [ 'base' => NULL, 'refs' => [ 'GetHealthEventOutput$ImpactedLocations' => '<p>The locations affected by a health event.</p>', 'HealthEvent$ImpactedLocations' => '<p>The locations impacted by the health event.</p>', ], ], 'InternalServerErrorException' => [ 'base' => '<p>There was an internal server error.</p>', 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>An internal error occurred.</p>', 'refs' => [], ], 'InternetEventId' => [ 'base' => NULL, 'refs' => [ 'GetInternetEventInput$EventId' => '<p>The <code>EventId</code> of the internet event to return information for. </p>', 'GetInternetEventOutput$EventId' => '<p>The internally-generated identifier of an internet event.</p>', 'InternetEventSummary$EventId' => '<p>The internally-generated identifier of an internet event.</p>', ], ], 'InternetEventMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListInternetEventsInput$MaxResults' => '<p>The number of query results that you want to return with this call.</p>', ], ], 'InternetEventStatus' => [ 'base' => NULL, 'refs' => [ 'GetInternetEventOutput$EventStatus' => '<p>The status of the internet event.</p>', 'InternetEventSummary$EventStatus' => '<p>The status of an internet event.</p>', ], ], 'InternetEventSummary' => [ 'base' => '<p>A summary of information about an internet event in Amazon CloudWatch Internet Monitor. Internet events are issues that cause performance degradation or availability problems for impacted Amazon Web Services client locations. Internet Monitor displays information about recent global health events, called internet events, on a global outages map that is available to all Amazon Web Services customers. </p>', 'refs' => [ 'InternetEventsList$member' => NULL, ], ], 'InternetEventType' => [ 'base' => NULL, 'refs' => [ 'GetInternetEventOutput$EventType' => '<p>The type of network impairment.</p>', 'InternetEventSummary$EventType' => '<p>The type of network impairment.</p>', ], ], 'InternetEventsList' => [ 'base' => NULL, 'refs' => [ 'ListInternetEventsOutput$InternetEvents' => '<p>A set of internet events returned for the list operation.</p>', ], ], 'InternetHealth' => [ 'base' => '<p>Internet health includes measurements calculated by Amazon CloudWatch Internet Monitor about the performance and availability for your application on the internet. Amazon Web Services has substantial historical data about internet performance and availability between Amazon Web Services services and different network providers and geographies. By applying statistical analysis to the data, Internet Monitor can detect when the performance and availability for your application has dropped, compared to an estimated baseline that\'s already calculated. To make it easier to see those drops, Internet Monitor reports the information to you in the form of health scores: a performance score and an availability score.</p>', 'refs' => [ 'ImpactedLocation$InternetHealth' => '<p>The calculated health at a specific location.</p>', ], ], 'InternetMeasurementsLogDelivery' => [ 'base' => '<p>Publish internet measurements to an Amazon S3 bucket in addition to CloudWatch Logs.</p>', 'refs' => [ 'CreateMonitorInput$InternetMeasurementsLogDelivery' => '<p>Publish internet measurements for Internet Monitor to an Amazon S3 bucket in addition to CloudWatch Logs.</p>', 'GetMonitorOutput$InternetMeasurementsLogDelivery' => '<p>Publish internet measurements for Internet Monitor to another location, such as an Amazon S3 bucket. The measurements are also published to Amazon CloudWatch Logs.</p>', 'UpdateMonitorInput$InternetMeasurementsLogDelivery' => '<p>Publish internet measurements for Internet Monitor to another location, such as an Amazon S3 bucket. The measurements are also published to Amazon CloudWatch Logs.</p>', ], ], 'Ipv4PrefixList' => [ 'base' => NULL, 'refs' => [ 'ImpactedLocation$Ipv4Prefixes' => '<p>The IPv4 prefixes at the client location that was impacted by the health event.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The request exceeded a service quota.</p>', 'refs' => [], ], 'ListHealthEventsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListHealthEventsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListInternetEventsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListInternetEventsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitorsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitorsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'LocalHealthEventsConfig' => [ 'base' => '<p>A complex type with the configuration information that determines the threshold and other conditions for when Internet Monitor creates a health event for a local performance or availability issue, when scores cross a threshold for one or more city-networks.</p> <p>Defines the percentages, for performance scores or availability scores, that are the local thresholds for when Amazon CloudWatch Internet Monitor creates a health event. Also defines whether a local threshold is enabled or disabled, and the minimum percentage of overall traffic that must be impacted by an issue before Internet Monitor creates an event when a threshold is crossed for a local health score.</p> <p>If you don\'t set a local health event threshold, the default value is 60%.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-overview.html#IMUpdateThresholdFromOverview"> Change health event thresholds</a> in the Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'refs' => [ 'HealthEventsConfig$AvailabilityLocalHealthEventsConfig' => '<p>The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local availability issue.</p>', 'HealthEventsConfig$PerformanceLocalHealthEventsConfig' => '<p>The configuration that determines the threshold and other conditions for when Internet Monitor creates a health event for a local performance issue.</p>', ], ], 'LocalHealthEventsConfigStatus' => [ 'base' => NULL, 'refs' => [ 'LocalHealthEventsConfig$Status' => '<p>The status of whether Internet Monitor creates a health event based on a threshold percentage set for a local health score. The status can be <code>ENABLED</code> or <code>DISABLED</code>.</p>', ], ], 'LogDeliveryStatus' => [ 'base' => NULL, 'refs' => [ 'S3Config$LogDeliveryStatus' => '<p>The status of publishing Internet Monitor internet measurements to an Amazon S3 bucket.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ClientLocation$ASNumber' => '<p>The Autonomous System Number (ASN) of the network at an impacted location.</p>', 'ImpactedLocation$ASNumber' => '<p>The Autonomous System Number (ASN) of the network at an impacted location.</p>', 'Network$ASNumber' => '<p>The Autonomous System Number (ASN) of the internet provider or network.</p>', ], ], 'MaxCityNetworksToMonitor' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorInput$MaxCityNetworksToMonitor' => '<p>The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the ASN or network provider, such as an internet service provider (ISP), that clients access the resources through. Setting this limit can help control billing costs.</p> <p>To learn more, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html">Choosing a city-network maximum value </a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'GetMonitorOutput$MaxCityNetworksToMonitor' => '<p>The maximum number of city-networks to monitor for your resources. A city-network is the location (city) where clients access your application resources from and the ASN or network provider, such as an internet service provider (ISP), that clients access the resources through. This limit can help control billing costs.</p> <p>To learn more, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMCityNetworksMaximum.html">Choosing a city-network maximum value </a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'UpdateMonitorInput$MaxCityNetworksToMonitor' => '<p>The maximum number of city-networks to monitor for your application. A city-network is the location (city) where clients access your application resources from and the ASN or network provider, such as an internet service provider (ISP), that clients access the resources through. Setting this limit can help control billing costs.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListHealthEventsInput$MaxResults' => '<p>The number of health event objects that you want to return with this call. </p>', 'ListMonitorsInput$MaxResults' => '<p>The number of monitor objects that you want to return with this call.</p>', ], ], 'Monitor' => [ 'base' => '<p>The description of and information about a monitor in Amazon CloudWatch Internet Monitor. </p>', 'refs' => [ 'MonitorList$member' => NULL, ], ], 'MonitorArn' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorOutput$Arn' => '<p>The Amazon Resource Name (ARN) of the monitor.</p>', 'GetMonitorOutput$MonitorArn' => '<p>The Amazon Resource Name (ARN) of the monitor.</p>', 'ListTagsForResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) for a resource.</p>', 'Monitor$MonitorArn' => '<p>The Amazon Resource Name (ARN) of the monitor.</p>', 'TagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) for a tag that you add to a resource. Tags are supported only for monitors in Amazon CloudWatch Internet Monitor.</p>', 'UntagResourceInput$ResourceArn' => '<p>The Amazon Resource Name (ARN) for a tag you remove a resource from.</p>', 'UpdateMonitorOutput$MonitorArn' => '<p>The Amazon Resource Name (ARN) of the monitor.</p>', ], ], 'MonitorConfigState' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorOutput$Status' => '<p>The status of a monitor.</p>', 'GetMonitorOutput$Status' => '<p>The status of the monitor.</p>', 'Monitor$Status' => '<p>The status of a monitor.</p>', 'UpdateMonitorInput$Status' => '<p>The status for a monitor. The accepted values for <code>Status</code> with the <code>UpdateMonitor</code> API call are the following: <code>ACTIVE</code> and <code>INACTIVE</code>. The following values are <i>not</i> accepted: <code>PENDING</code>, and <code>ERROR</code>.</p>', 'UpdateMonitorOutput$Status' => '<p>The status of a monitor.</p>', ], ], 'MonitorList' => [ 'base' => NULL, 'refs' => [ 'ListMonitorsOutput$Monitors' => '<p>A list of monitors.</p>', ], ], 'MonitorProcessingStatusCode' => [ 'base' => NULL, 'refs' => [ 'GetMonitorOutput$ProcessingStatus' => '<p>The health of the data processing for the monitor.</p>', 'Monitor$ProcessingStatus' => '<p>The health of data processing for the monitor.</p>', ], ], 'Network' => [ 'base' => '<p>An internet service provider (ISP) or network (ASN) in Amazon CloudWatch Internet Monitor.</p>', 'refs' => [ 'NetworkList$member' => NULL, ], ], 'NetworkImpairment' => [ 'base' => '<p>Information about the network impairment for a specific network measured by Amazon CloudWatch Internet Monitor.</p>', 'refs' => [ 'ImpactedLocation$CausedBy' => '<p>The cause of the impairment. There are two types of network impairments: Amazon Web Services network issues or internet issues. Internet issues are typically a problem with a network provider, like an internet service provider (ISP).</p>', ], ], 'NetworkList' => [ 'base' => NULL, 'refs' => [ 'NetworkImpairment$Networks' => '<p>The networks that could be impacted by a network impairment event.</p>', 'NetworkImpairment$AsPath' => '<p>The combination of the Autonomous System Number (ASN) of the network and the name of the network.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>The request specifies something that doesn\'t exist.</p>', 'refs' => [], ], 'Operator' => [ 'base' => NULL, 'refs' => [ 'FilterParameter$Operator' => '<p>The operator to use with the filter field and a value, such as <code>not_equals</code>.</p>', ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'GetHealthEventOutput$HealthScoreThreshold' => '<p>The threshold percentage for a health score that determines, along with other configuration information, when Internet Monitor creates a health event when there\'s an internet issue that affects your application end users.</p>', 'HealthEvent$HealthScoreThreshold' => '<p>The value of the threshold percentage for performance or availability that was configured when Amazon CloudWatch Internet Monitor created the health event.</p>', 'HealthEventsConfig$AvailabilityScoreThreshold' => '<p>The health event threshold percentage set for availability scores.</p>', 'HealthEventsConfig$PerformanceScoreThreshold' => '<p>The health event threshold percentage set for performance scores.</p>', 'LocalHealthEventsConfig$HealthScoreThreshold' => '<p>The health event threshold percentage set for a local health score.</p>', 'LocalHealthEventsConfig$MinTrafficImpact' => '<p>The minimum percentage of overall traffic for an application that must be impacted by an issue before Internet Monitor creates an event when a threshold is crossed for a local health score.</p> <p>If you don\'t set a minimum traffic impact threshold, the default value is 0.1%.</p>', ], ], 'PerformanceMeasurement' => [ 'base' => '<p>Amazon CloudWatch Internet Monitor calculates measurements about the performance for your application\'s internet traffic between client locations and Amazon Web Services. Amazon Web Services has substantial historical data about internet performance and availability between Amazon Web Services services and different network providers and geographies. By applying statistical analysis to the data, Internet Monitor can detect when the performance and availability for your application has dropped, compared to an estimated baseline that\'s already calculated. To make it easier to see those drops, we report that information to you in the form of health scores: a performance score and an availability score.</p> <p>Performance in Internet Monitor represents the estimated percentage of traffic that is not seeing a performance drop. For example, a performance score of 99% for an end user and service location pair is equivalent to 1% of the traffic experiencing a performance drop for that pair.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores">How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'refs' => [ 'InternetHealth$Performance' => '<p>Performance in Internet Monitor represents the estimated percentage of traffic that is not seeing a performance drop. For example, a performance score of 99% for an end user and service location pair is equivalent to 1% of the traffic experiencing a performance drop for that pair.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMExperienceScores">How Internet Monitor calculates performance and availability scores</a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', ], ], 'QueryData' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsOutput$Data' => '<p>The data results that the query returns. Data is returned in arrays, aligned with the <code>Fields</code> for the query, which creates a repository of Amazon CloudWatch Internet Monitor information for your application. Then, you can filter the information in the repository by using <code>FilterParameters</code> that you define.</p>', ], ], 'QueryField' => [ 'base' => '<p>Defines a field to query for your application\'s Amazon CloudWatch Internet Monitor data. You create a data repository by running a query of a specific type. Each <code>QueryType</code> includes a specific set of fields and datatypes to retrieve data for. </p>', 'refs' => [ 'QueryFields$member' => NULL, ], ], 'QueryFields' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsOutput$Fields' => '<p>The fields that the query returns data for. Fields are name-data type pairs, such as <code>availability_score</code>-<code>float</code>.</p>', ], ], 'QueryMaxResults' => [ 'base' => NULL, 'refs' => [ 'GetQueryResultsInput$MaxResults' => '<p>The number of query results that you want to return with this call.</p>', ], ], 'QueryRow' => [ 'base' => NULL, 'refs' => [ 'QueryData$member' => NULL, ], ], 'QueryStatus' => [ 'base' => NULL, 'refs' => [ 'GetQueryStatusOutput$Status' => '<p>The current status for a query.</p>', ], ], 'QueryType' => [ 'base' => NULL, 'refs' => [ 'StartQueryInput$QueryType' => '<p>The type of query to run. The following are the three types of queries that you can run using the Internet Monitor query interface:</p> <ul> <li> <p> <code>MEASUREMENTS</code>: Provides availability score, performance score, total traffic, and round-trip times, at 5 minute intervals.</p> </li> <li> <p> <code>TOP_LOCATIONS</code>: Provides availability score, performance score, total traffic, and time to first byte (TTFB) information, for the top location and ASN combinations that you\'re monitoring, by traffic volume.</p> </li> <li> <p> <code>TOP_LOCATION_DETAILS</code>: Provides TTFB for Amazon CloudFront, your current configuration, and the best performing EC2 configuration, at 1 hour intervals.</p> </li> <li> <p> <code>OVERALL_TRAFFIC_SUGGESTIONS</code>: Provides TTFB, using a 30-day weighted average, for all traffic in each Amazon Web Services location that is monitored.</p> </li> <li> <p> <code>OVERALL_TRAFFIC_SUGGESTIONS_DETAILS</code>: Provides TTFB, using a 30-day weighted average, for each top location, for a proposed Amazon Web Services location. Must provide a Amazon Web Services location to search.</p> </li> </ul> <p>For lists of the fields returned with each query type and more information about how each type of query is performed, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-view-cw-tools-cwim-query.html"> Using the Amazon CloudWatch Internet Monitor query interface</a> in the Amazon CloudWatch Internet Monitor User Guide.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorInput$MonitorName' => '<p>The name of the monitor. </p>', 'DeleteMonitorInput$MonitorName' => '<p>The name of the monitor to delete.</p>', 'GetHealthEventInput$MonitorName' => '<p>The name of the monitor.</p>', 'GetMonitorInput$MonitorName' => '<p>The name of the monitor.</p>', 'GetMonitorOutput$MonitorName' => '<p>The name of the monitor.</p>', 'GetQueryResultsInput$MonitorName' => '<p>The name of the monitor to return data for.</p>', 'GetQueryStatusInput$MonitorName' => '<p>The name of the monitor.</p>', 'ListHealthEventsInput$MonitorName' => '<p>The name of the monitor.</p>', 'Monitor$MonitorName' => '<p>The name of the monitor.</p>', 'StartQueryInput$MonitorName' => '<p>The name of the monitor to query.</p>', 'StopQueryInput$MonitorName' => '<p>The name of the monitor.</p>', 'UpdateMonitorInput$MonitorName' => '<p>The name of the monitor. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The request specifies a resource that doesn\'t exist.</p>', 'refs' => [], ], 'RoundTripTime' => [ 'base' => '<p>Round-trip time (RTT) is how long it takes for a request from the user to return a response to the user. Amazon CloudWatch Internet Monitor calculates RTT at different percentiles: p50, p90, and p95.</p>', 'refs' => [ 'PerformanceMeasurement$RoundTripTime' => '<p>This is the percentage of how much round-trip time increased during the event compared to typical round-trip time for your application for traffic. </p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-IM-inside-internet-monitor.html#IMHealthEventStartStop">When Amazon Web Services creates and resolves health events</a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', ], ], 'S3Config' => [ 'base' => '<p>The configuration for publishing Amazon CloudWatch Internet Monitor internet measurements to Amazon S3. The configuration includes the bucket name and (optionally) prefix for the S3 bucket to store the measurements, and the delivery status. The delivery status is <code>ENABLED</code> or <code>DISABLED</code>, depending on whether you choose to deliver internet measurements to S3 logs.</p>', 'refs' => [ 'InternetMeasurementsLogDelivery$S3Config' => '<p>The configuration information for publishing Internet Monitor internet measurements to Amazon S3. The configuration includes the bucket name and (optionally) prefix for the S3 bucket to store the measurements, and the delivery status. The delivery status is <code>ENABLED</code> or <code>DISABLED</code>, depending on whether you choose to deliver internet measurements to S3 logs.</p>', ], ], 'S3ConfigBucketNameString' => [ 'base' => NULL, 'refs' => [ 'S3Config$BucketName' => '<p>The Amazon S3 bucket name.</p>', ], ], 'SetOfARNs' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorInput$Resources' => '<p>The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs). Resources can be VPCs, NLBs, Amazon CloudFront distributions, or Amazon WorkSpaces directories.</p> <p>You can add a combination of VPCs and CloudFront distributions, or you can add WorkSpaces directories, or you can add NLBs. You can\'t add NLBs or WorkSpaces directories together with any other resources.</p> <note> <p>If you add only Amazon VPC resources, at least one VPC must have an Internet Gateway attached to it, to make sure that it has internet connectivity.</p> </note>', 'GetMonitorOutput$Resources' => '<p>The resources monitored by the monitor. Resources are listed by their Amazon Resource Names (ARNs).</p>', 'UpdateMonitorInput$ResourcesToAdd' => '<p>The resources to include in a monitor, which you provide as a set of Amazon Resource Names (ARNs). Resources can be VPCs, NLBs, Amazon CloudFront distributions, or Amazon WorkSpaces directories.</p> <p>You can add a combination of VPCs and CloudFront distributions, or you can add WorkSpaces directories, or you can add NLBs. You can\'t add NLBs or WorkSpaces directories together with any other resources.</p> <note> <p>If you add only Amazon Virtual Private Clouds resources, at least one VPC must have an Internet Gateway attached to it, to make sure that it has internet connectivity.</p> </note>', 'UpdateMonitorInput$ResourcesToRemove' => '<p>The resources to remove from a monitor, which you provide as a set of Amazon Resource Names (ARNs).</p>', ], ], 'StartQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'StartQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'StopQueryInput' => [ 'base' => NULL, 'refs' => [], ], 'StopQueryOutput' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'BadRequestException$message' => NULL, 'ClientLocation$ASName' => '<p>The name of the internet service provider (ISP) or network (ASN).</p>', 'ClientLocation$Country' => '<p>The name of the country where the internet event is located.</p>', 'ClientLocation$Subdivision' => '<p>The subdivision location where the health event is located. The subdivision usually maps to states in most countries (including the United States). For United Kingdom, it maps to a country (England, Scotland, Wales) or province (Northern Ireland).</p>', 'ClientLocation$Metro' => '<p>The metro area where the health event is located.</p> <p>Metro indicates a metropolitan region in the United States, such as the region around New York City. In non-US countries, this is a second-level subdivision. For example, in the United Kingdom, it could be a county, a London borough, a unitary authority, council area, and so on.</p>', 'ClientLocation$City' => '<p>The name of the city where the internet event is located.</p>', 'ConflictException$message' => NULL, 'CreateMonitorInput$ClientToken' => '<p>A unique, case-sensitive string of up to 64 ASCII characters that you specify to make an idempotent API request. Don\'t reuse the same client token for other API requests.</p>', 'FilterList$member' => NULL, 'FilterParameter$Field' => '<p>A data field that you want to filter, to further scope your application\'s Internet Monitor data in a repository that you created by running a query. A field might be <code>city</code>, for example. The field must be one of the fields that was returned by the specific query that you used to create the repository.</p>', 'GetMonitorOutput$ProcessingStatusInfo' => '<p>Additional information about the health of the data processing for the monitor.</p>', 'GetQueryResultsInput$QueryId' => '<p>The ID of the query that you want to return data results for. A <code>QueryId</code> is an internally-generated identifier for a specific query.</p>', 'GetQueryResultsInput$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'GetQueryResultsOutput$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'GetQueryStatusInput$QueryId' => '<p>The ID of the query that you want to return the status for. A <code>QueryId</code> is an internally-generated dentifier for a specific query.</p>', 'ImpactedLocation$ASName' => '<p>The name of the internet service provider (ISP) or network (ASN).</p>', 'ImpactedLocation$Country' => '<p>The name of the country where the health event is located.</p>', 'ImpactedLocation$Subdivision' => '<p>The subdivision location where the health event is located. The subdivision usually maps to states in most countries (including the United States). For United Kingdom, it maps to a country (England, Scotland, Wales) or province (Northern Ireland).</p>', 'ImpactedLocation$Metro' => '<p>The metro area where the health event is located.</p> <p>Metro indicates a metropolitan region in the United States, such as the region around New York City. In non-US countries, this is a second-level subdivision. For example, in the United Kingdom, it could be a county, a London borough, a unitary authority, council area, and so on.</p>', 'ImpactedLocation$City' => '<p>The name of the city where the health event is located.</p>', 'ImpactedLocation$CountryCode' => '<p>The country code where the health event is located. The ISO 3166-2 codes for the country is provided, when available. </p>', 'ImpactedLocation$SubdivisionCode' => '<p>The subdivision code where the health event is located. The ISO 3166-2 codes for country subdivisions is provided, when available. </p>', 'ImpactedLocation$ServiceLocation' => '<p>The service location where the health event is located.</p>', 'InternalServerErrorException$message' => NULL, 'InternalServerException$message' => NULL, 'Ipv4PrefixList$member' => NULL, 'LimitExceededException$message' => NULL, 'ListHealthEventsInput$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListHealthEventsOutput$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListInternetEventsInput$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListInternetEventsInput$EventStatus' => '<p>The status of an internet event.</p>', 'ListInternetEventsInput$EventType' => '<p>The type of network impairment.</p>', 'ListInternetEventsOutput$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListMonitorsInput$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'ListMonitorsInput$MonitorStatus' => '<p>The status of a monitor. This includes the status of the data processing for the monitor and the status of the monitor itself.</p> <p>For information about the statuses for a monitor, see <a href="https://docs.aws.amazon.com/internet-monitor/latest/api/API_Monitor.html"> Monitor</a>.</p>', 'ListMonitorsOutput$NextToken' => '<p>The token for the next set of results. You receive this token from a previous call.</p>', 'Network$ASName' => '<p>The name of the internet service provider (ISP) or network (ASN).</p>', 'NotFoundException$message' => NULL, 'QueryField$Name' => '<p>The name of a field to query your application\'s Amazon CloudWatch Internet Monitor data for, such as <code>availability_score</code>.</p>', 'QueryField$Type' => '<p>The data type for a query field, which must correspond to the field you\'re defining for <code>QueryField</code>. For example, if the query field name is <code>availability_score</code>, the data type is <code>float</code>.</p>', 'QueryRow$member' => NULL, 'ResourceNotFoundException$message' => NULL, 'S3Config$BucketPrefix' => '<p>The Amazon S3 bucket prefix.</p>', 'StartQueryOutput$QueryId' => '<p>The internally-generated identifier of a specific query.</p>', 'StopQueryInput$QueryId' => '<p>The ID of the query that you want to stop. A <code>QueryId</code> is an internally-generated identifier for a specific query.</p>', 'ThrottlingException$message' => NULL, 'TooManyRequestsException$message' => NULL, 'UpdateMonitorInput$ClientToken' => '<p>A unique, case-sensitive string of up to 64 ASCII characters that you specify to make an idempotent API request. You should not reuse the same client token for other API requests.</p>', 'ValidationException$message' => NULL, ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'GetHealthEventOutput$StartedAt' => '<p>The time when a health event started.</p>', 'GetHealthEventOutput$EndedAt' => '<p>The time when a health event was resolved. If the health event is still active, the end time is not set.</p>', 'GetHealthEventOutput$CreatedAt' => '<p>The time when a health event was created.</p>', 'GetHealthEventOutput$LastUpdatedAt' => '<p>The time when a health event was last updated or recalculated.</p>', 'GetInternetEventOutput$StartedAt' => '<p>The time when the internet event started.</p>', 'GetInternetEventOutput$EndedAt' => '<p>The time when the internet event ended. If the event hasn\'t ended yet, this value is empty.</p>', 'GetMonitorOutput$CreatedAt' => '<p>The time when the monitor was created.</p>', 'GetMonitorOutput$ModifiedAt' => '<p>The last time that the monitor was modified.</p>', 'HealthEvent$StartedAt' => '<p>When a health event started.</p>', 'HealthEvent$EndedAt' => '<p>The time when a health event ended. If the health event is still active, then the end time is not set.</p>', 'HealthEvent$CreatedAt' => '<p>When the health event was created.</p>', 'HealthEvent$LastUpdatedAt' => '<p>When the health event was last updated.</p>', 'InternetEventSummary$StartedAt' => '<p>The time when an internet event started.</p>', 'InternetEventSummary$EndedAt' => '<p>The time when an internet event ended. If the event hasn\'t ended yet, this value is empty.</p>', 'ListHealthEventsInput$StartTime' => '<p>The time when a health event started.</p>', 'ListHealthEventsInput$EndTime' => '<p>The time when a health event ended. If the health event is still ongoing, then the end time is not set.</p>', 'ListInternetEventsInput$StartTime' => '<p>The start time of the time window that you want to get a list of internet events for.</p>', 'ListInternetEventsInput$EndTime' => '<p>The end time of the time window that you want to get a list of internet events for.</p>', 'StartQueryInput$StartTime' => '<p>The timestamp that is the beginning of the period that you want to retrieve data for with your query.</p>', 'StartQueryInput$EndTime' => '<p>The timestamp that is the end of the period that you want to retrieve data for with your query.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeys$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$TagKeys' => '<p>Tag keys that you remove from a resource.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorInput$Tags' => '<p>The tags for a monitor. You can add a maximum of 50 tags in Internet Monitor.</p>', 'GetMonitorOutput$Tags' => '<p>The tags that have been added to monitor.</p>', 'ListTagsForResourceOutput$Tags' => '<p>Tags for a resource.</p>', 'TagResourceInput$Tags' => '<p>Tags that you add to a resource. You can add a maximum of 50 tags in Internet Monitor.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'TooManyRequestsException' => [ 'base' => '<p>There were too many requests.</p>', 'refs' => [], ], 'TrafficPercentageToMonitor' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorInput$TrafficPercentageToMonitor' => '<p>The percentage of the internet-facing traffic for your application that you want to monitor with this monitor. If you set a city-networks maximum, that limit overrides the traffic percentage that you set.</p> <p>To learn more, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMTrafficPercentage.html">Choosing an application traffic percentage to monitor </a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'GetMonitorOutput$TrafficPercentageToMonitor' => '<p>The percentage of the internet-facing traffic for your application to monitor with this monitor. If you set a city-networks maximum, that limit overrides the traffic percentage that you set.</p> <p>To learn more, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMTrafficPercentage.html">Choosing an application traffic percentage to monitor </a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', 'UpdateMonitorInput$TrafficPercentageToMonitor' => '<p>The percentage of the internet-facing traffic for your application that you want to monitor with this monitor. If you set a city-networks maximum, that limit overrides the traffic percentage that you set.</p> <p>To learn more, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/IMTrafficPercentage.html">Choosing an application traffic percentage to monitor </a> in the Amazon CloudWatch Internet Monitor section of the <i>CloudWatch User Guide</i>.</p>', ], ], 'TriangulationEventType' => [ 'base' => NULL, 'refs' => [ 'NetworkImpairment$NetworkEventType' => '<p>The type of network impairment.</p>', ], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMonitorInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMonitorOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>Invalid request.</p>', 'refs' => [], ], ],];
