<?php
// This file was auto-generated from sdk-root/src/data/iottwinmaker/2021-11-29/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>IoT TwinMaker is a service with which you can build operational digital twins of physical systems. IoT TwinMaker overlays measurements and analysis from real-world sensors, cameras, and enterprise applications so you can create data visualizations to monitor your physical factory, building, or industrial plant. You can use this real-world data to monitor operations and diagnose and repair errors.</p>', 'operations' => [ 'BatchPutPropertyValues' => '<p>Sets values for multiple time series properties.</p>', 'CancelMetadataTransferJob' => '<p>Cancels the metadata transfer job.</p>', 'CreateComponentType' => '<p>Creates a component type.</p>', 'CreateEntity' => '<p>Creates an entity.</p>', 'CreateMetadataTransferJob' => '<p>Creates a new metadata transfer job.</p>', 'CreateScene' => '<p>Creates a scene.</p>', 'CreateSyncJob' => '<p>This action creates a SyncJob.</p>', 'CreateWorkspace' => '<p>Creates a workplace.</p>', 'DeleteComponentType' => '<p>Deletes a component type.</p>', 'DeleteEntity' => '<p>Deletes an entity.</p>', 'DeleteScene' => '<p>Deletes a scene.</p>', 'DeleteSyncJob' => '<p>Delete the SyncJob.</p>', 'DeleteWorkspace' => '<p>Deletes a workspace.</p>', 'ExecuteQuery' => '<p>Run queries to access information from your knowledge graph of entities within individual workspaces.</p> <note> <p>The ExecuteQuery action only works with <a href="https://docs.aws.amazon.com/sdk-for-java/latest/developer-guide/home.html">Amazon Web Services Java SDK2</a>. ExecuteQuery will not work with any Amazon Web Services Java SDK version &lt; 2.x.</p> </note>', 'GetComponentType' => '<p>Retrieves information about a component type.</p>', 'GetEntity' => '<p>Retrieves information about an entity.</p>', 'GetMetadataTransferJob' => '<p>Gets a nmetadata transfer job.</p>', 'GetPricingPlan' => '<p>Gets the pricing plan.</p>', 'GetPropertyValue' => '<p>Gets the property values for a component, component type, entity, or workspace.</p> <p>You must specify a value for either <code>componentName</code>, <code>componentTypeId</code>, <code>entityId</code>, or <code>workspaceId</code>.</p>', 'GetPropertyValueHistory' => '<p>Retrieves information about the history of a time series property value for a component, component type, entity, or workspace.</p> <p>You must specify a value for <code>workspaceId</code>. For entity-specific queries, specify values for <code>componentName</code> and <code>entityId</code>. For cross-entity quries, specify a value for <code>componentTypeId</code>.</p>', 'GetScene' => '<p>Retrieves information about a scene.</p>', 'GetSyncJob' => '<p>Gets the SyncJob.</p>', 'GetWorkspace' => '<p>Retrieves information about a workspace.</p>', 'ListComponentTypes' => '<p>Lists all component types in a workspace.</p>', 'ListComponents' => '<p>This API lists the components of an entity.</p>', 'ListEntities' => '<p>Lists all entities in a workspace.</p>', 'ListMetadataTransferJobs' => '<p>Lists the metadata transfer jobs.</p>', 'ListProperties' => '<p>This API lists the properties of a component.</p>', 'ListScenes' => '<p>Lists all scenes in a workspace.</p>', 'ListSyncJobs' => '<p>List all SyncJobs.</p>', 'ListSyncResources' => '<p>Lists the sync resources.</p>', 'ListTagsForResource' => '<p>Lists all tags associated with a resource.</p>', 'ListWorkspaces' => '<p>Retrieves information about workspaces in the current account.</p>', 'TagResource' => '<p>Adds tags to a resource.</p>', 'UntagResource' => '<p>Removes tags from a resource.</p>', 'UpdateComponentType' => '<p>Updates information in a component type.</p>', 'UpdateEntity' => '<p>Updates an entity.</p>', 'UpdatePricingPlan' => '<p>Update the pricing plan.</p>', 'UpdateScene' => '<p>Updates a scene.</p>', 'UpdateWorkspace' => '<p>Updates a workspace.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>Access is denied.</p>', 'refs' => [], ], 'BatchPutPropertyError' => [ 'base' => '<p>An error returned by the <code>BatchPutProperty</code> action.</p>', 'refs' => [ 'Errors$member' => NULL, ], ], 'BatchPutPropertyErrorEntry' => [ 'base' => '<p>An object that contains information about errors returned by the <code>BatchPutProperty</code> action.</p>', 'refs' => [ 'ErrorEntries$member' => NULL, ], ], 'BatchPutPropertyValuesRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchPutPropertyValuesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ComponentPropertyGroupResponse$isInherited' => '<p>A Boolean value that specifies whether the property group is inherited from a parent entity</p>', 'ComponentResponse$areAllPropertiesReturned' => '<p>This flag notes whether all properties of the component are returned in the API response. The maximum number of properties returned is 800.</p>', 'ComponentResponse$areAllCompositeComponentsReturned' => '<p>This flag notes whether all <code>compositeComponents</code> are returned in the API response.</p>', 'CompositeComponentTypeResponse$isInherited' => '<p>This boolean indicates whether this <code>compositeComponentType</code> is inherited from its parent.</p>', 'CreateComponentTypeRequest$isSingleton' => '<p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>', 'DataConnector$isNative' => '<p>A Boolean value that specifies whether the data connector is native to IoT TwinMaker.</p>', 'DataValue$booleanValue' => '<p>A Boolean value.</p>', 'DeleteEntityRequest$isRecursive' => '<p>A Boolean value that specifies whether the operation deletes child entities.</p>', 'EntitySummary$hasChildEntities' => '<p>An <b>eventual</b> Boolean value that specifies whether the entity has child entities or not.</p>', 'FilterByAsset$includeOffspring' => '<p>Includes sub-assets.[need description hekp for this]</p>', 'FilterByAsset$includeAssetModel' => '<p>Boolean to include the asset model.</p>', 'FilterByAssetModel$includeOffspring' => '<p>Include asset offspring. [need desc.]</p>', 'FilterByAssetModel$includeAssets' => '<p>Bolean to include assets.</p>', 'FunctionResponse$isInherited' => '<p>Indicates whether this function is inherited.</p>', 'GetComponentTypeResponse$isSingleton' => '<p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>', 'GetComponentTypeResponse$isAbstract' => '<p>A Boolean value that specifies whether the component type is abstract.</p>', 'GetComponentTypeResponse$isSchemaInitialized' => '<p>A Boolean value that specifies whether the component type has a schema initializer and that the schema initializer has run.</p>', 'GetEntityResponse$hasChildEntities' => '<p>A Boolean value that specifies whether the entity has associated child entities.</p>', 'GetEntityResponse$areAllComponentsReturned' => '<p>This flag notes whether all components are returned in the API response. The maximum number of components returned is 30.</p>', 'ListComponentTypesFilter$isAbstract' => '<p>A Boolean value that specifies whether the component types in the list are abstract.</p>', 'PropertyDefinitionRequest$isRequiredInEntity' => '<p>A Boolean value that specifies whether the property is required.</p>', 'PropertyDefinitionRequest$isExternalId' => '<p>A Boolean value that specifies whether the property ID comes from an external data store.</p>', 'PropertyDefinitionRequest$isStoredExternally' => '<p>A Boolean value that specifies whether the property is stored externally.</p>', 'PropertyDefinitionRequest$isTimeSeries' => '<p>A Boolean value that specifies whether the property consists of time series data.</p>', 'PropertyDefinitionResponse$isTimeSeries' => '<p>A Boolean value that specifies whether the property consists of time series data.</p>', 'PropertyDefinitionResponse$isRequiredInEntity' => '<p>A Boolean value that specifies whether the property is required in an entity.</p>', 'PropertyDefinitionResponse$isExternalId' => '<p>A Boolean value that specifies whether the property ID comes from an external data store.</p>', 'PropertyDefinitionResponse$isStoredExternally' => '<p>A Boolean value that specifies whether the property is stored externally.</p>', 'PropertyDefinitionResponse$isImported' => '<p>A Boolean value that specifies whether the property definition is imported from an external data store.</p>', 'PropertyDefinitionResponse$isFinal' => '<p>A Boolean value that specifies whether the property definition can be updated.</p>', 'PropertyDefinitionResponse$isInherited' => '<p>A Boolean value that specifies whether the property definition is inherited from a parent entity.</p>', 'PropertyGroupResponse$isInherited' => '<p>A Boolean value that specifies whether the property group is inherited from a parent entity</p>', 'PropertyResponse$areAllPropertyValuesReturned' => '<p>This flag notes whether all values of a list or map type property are returned in the API response. The maximum number of values per property returned is 50.</p>', 'PropertySummary$areAllPropertyValuesReturned' => '<p>This flag notes whether all values of a list or map type property are returned in the API response. The maximum number of values per property returned is 50.</p>', 'UpdateComponentTypeRequest$isSingleton' => '<p>A Boolean value that specifies whether an entity can have more than one component of this type.</p>', ], ], 'BundleInformation' => [ 'base' => '<p>Information about the pricing bundle.</p>', 'refs' => [ 'PricingPlan$bundleInformation' => '<p>The pricing plan\'s bundle information.</p>', ], ], 'BundleName' => [ 'base' => NULL, 'refs' => [ 'PricingBundles$member' => NULL, ], ], 'CancelMetadataTransferJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelMetadataTransferJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'ColumnDescription' => [ 'base' => '<p>A description of the column in the query results.</p>', 'refs' => [ 'ColumnDescriptions$member' => NULL, ], ], 'ColumnDescriptions' => [ 'base' => NULL, 'refs' => [ 'ExecuteQueryResponse$columnDescriptions' => '<p>A list of ColumnDescription objects.</p>', ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'ColumnDescription$name' => '<p>The name of the column description.</p>', ], ], 'ColumnType' => [ 'base' => NULL, 'refs' => [ 'ColumnDescription$type' => '<p>The type of the column description.</p>', ], ], 'ComponentPath' => [ 'base' => NULL, 'refs' => [ 'ComponentSummary$componentPath' => '<p>This string specifies the path to the composite component, starting from the top-level component.</p>', 'CompositeComponentUpdatesMapRequest$key' => NULL, 'CompositeComponentsMapRequest$key' => NULL, 'EntityPropertyReference$componentPath' => '<p>This string specifies the path to the composite component, starting from the top-level component.</p>', 'GetPropertyValueHistoryRequest$componentPath' => '<p>This string specifies the path to the composite component, starting from the top-level component.</p>', 'GetPropertyValueRequest$componentPath' => '<p>This string specifies the path to the composite component, starting from the top-level component.</p>', 'ListComponentsRequest$componentPath' => '<p>This string specifies the path to the composite component, starting from the top-level component.</p>', 'ListPropertiesRequest$componentPath' => '<p>This string specifies the path to the composite component, starting from the top-level component.</p>', ], ], 'ComponentPropertyGroupRequest' => [ 'base' => '<p>The component property group request.</p>', 'refs' => [ 'ComponentPropertyGroupRequests$value' => NULL, ], ], 'ComponentPropertyGroupRequests' => [ 'base' => NULL, 'refs' => [ 'ComponentRequest$propertyGroups' => '<p>The property groups.</p>', 'ComponentUpdateRequest$propertyGroupUpdates' => '<p>The property group updates.</p>', 'CompositeComponentRequest$propertyGroups' => '<p>The property groups.</p>', 'CompositeComponentUpdateRequest$propertyGroupUpdates' => '<p>The property group updates.</p>', ], ], 'ComponentPropertyGroupResponse' => [ 'base' => '<p>The component property group response.</p>', 'refs' => [ 'ComponentPropertyGroupResponses$value' => NULL, ], ], 'ComponentPropertyGroupResponses' => [ 'base' => NULL, 'refs' => [ 'ComponentResponse$propertyGroups' => '<p>The property groups.</p>', 'ComponentSummary$propertyGroups' => '<p>The property groups.</p>', ], ], 'ComponentRequest' => [ 'base' => '<p>An object that sets information about a component type create or update request.</p>', 'refs' => [ 'ComponentsMapRequest$value' => NULL, ], ], 'ComponentResponse' => [ 'base' => '<p>An object that returns information about a component type create or update request.</p>', 'refs' => [ 'ComponentsMap$value' => NULL, ], ], 'ComponentSummaries' => [ 'base' => NULL, 'refs' => [ 'ListComponentsResponse$componentSummaries' => '<p>A list of objects that contain information about the components.</p>', ], ], 'ComponentSummary' => [ 'base' => '<p>An object that returns information about a component summary.</p>', 'refs' => [ 'ComponentSummaries$member' => NULL, 'CompositeComponentResponse$value' => NULL, ], ], 'ComponentTypeId' => [ 'base' => NULL, 'refs' => [ 'ComponentRequest$componentTypeId' => '<p>The ID of the component type.</p>', 'ComponentResponse$componentTypeId' => '<p>The ID of the component type.</p>', 'ComponentSummary$componentTypeId' => '<p>The ID of the component type.</p>', 'ComponentTypeSummary$componentTypeId' => '<p>The ID of the component type.</p>', 'ComponentUpdateRequest$componentTypeId' => '<p>The ID of the component type.</p>', 'CompositeComponentTypeRequest$componentTypeId' => '<p>This is the <code>componentTypeId</code> that the <code>compositeComponentType</code> refers to.</p>', 'CompositeComponentTypeResponse$componentTypeId' => '<p>This is the <code>componentTypeId</code> that this <code>compositeComponentType</code> refers to.</p>', 'CreateComponentTypeRequest$componentTypeId' => '<p>The ID of the component type.</p>', 'DeleteComponentTypeRequest$componentTypeId' => '<p>The ID of the component type to delete.</p>', 'ExtendsFrom$member' => NULL, 'FilterByComponentType$componentTypeId' => '<p>The component type Id.</p>', 'GetComponentTypeRequest$componentTypeId' => '<p>The ID of the component type.</p>', 'GetComponentTypeResponse$componentTypeId' => '<p>The ID of the component type.</p>', 'GetPropertyValueHistoryRequest$componentTypeId' => '<p>The ID of the component type.</p>', 'GetPropertyValueRequest$componentTypeId' => '<p>The ID of the component type whose property values the operation returns.</p>', 'ListComponentTypesFilter$extendsFrom' => '<p>The component type that the component types in the list extend.</p>', 'ListEntitiesFilter$componentTypeId' => '<p>The ID of the component type in the entities in the list.</p>', 'Relationship$targetComponentTypeId' => '<p>The ID of the target component type associated with this relationship.</p>', 'UpdateComponentTypeRequest$componentTypeId' => '<p>The ID of the component type.</p>', 'UpdateComponentTypeResponse$componentTypeId' => '<p>The ID of the component type.</p>', ], ], 'ComponentTypeName' => [ 'base' => NULL, 'refs' => [ 'ComponentTypeSummary$componentTypeName' => '<p>The component type name.</p>', 'CreateComponentTypeRequest$componentTypeName' => '<p>A friendly name for the component type.</p>', 'GetComponentTypeResponse$componentTypeName' => '<p>The component type name.</p>', 'UpdateComponentTypeRequest$componentTypeName' => '<p>The component type name.</p>', ], ], 'ComponentTypeSummaries' => [ 'base' => NULL, 'refs' => [ 'ListComponentTypesResponse$componentTypeSummaries' => '<p>A list of objects that contain information about the component types.</p>', ], ], 'ComponentTypeSummary' => [ 'base' => '<p>An object that contains information about a component type.</p>', 'refs' => [ 'ComponentTypeSummaries$member' => NULL, ], ], 'ComponentUpdateRequest' => [ 'base' => '<p>The component update request.</p>', 'refs' => [ 'ComponentUpdatesMapRequest$value' => NULL, ], ], 'ComponentUpdateType' => [ 'base' => NULL, 'refs' => [ 'ComponentUpdateRequest$updateType' => '<p>The update type of the component update request.</p>', 'CompositeComponentUpdateRequest$updateType' => '<p>The update type of the component update request.</p>', ], ], 'ComponentUpdatesMapRequest' => [ 'base' => NULL, 'refs' => [ 'UpdateEntityRequest$componentUpdates' => '<p>An object that maps strings to the component updates in the request. Each string in the mapping must be unique to this object.</p>', ], ], 'ComponentsMap' => [ 'base' => NULL, 'refs' => [ 'GetEntityResponse$components' => '<p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>', ], ], 'ComponentsMapRequest' => [ 'base' => NULL, 'refs' => [ 'CreateEntityRequest$components' => '<p>An object that maps strings to the components in the entity. Each string in the mapping must be unique to this object.</p>', ], ], 'CompositeComponentRequest' => [ 'base' => '<p>An object that sets information about the composite component update request.</p>', 'refs' => [ 'CompositeComponentsMapRequest$value' => NULL, ], ], 'CompositeComponentResponse' => [ 'base' => NULL, 'refs' => [ 'ComponentResponse$compositeComponents' => '<p>This lists objects that contain information about the <code>compositeComponents</code>.</p>', ], ], 'CompositeComponentTypeRequest' => [ 'base' => '<p>An object that sets information about the composite component types of a component type.</p>', 'refs' => [ 'CompositeComponentTypesRequest$value' => NULL, ], ], 'CompositeComponentTypeResponse' => [ 'base' => '<p>An object that returns information about the composite component types of a component type.</p>', 'refs' => [ 'CompositeComponentTypesResponse$value' => NULL, ], ], 'CompositeComponentTypesRequest' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeRequest$compositeComponentTypes' => '<p>This is an object that maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code>. <code>CompositeComponentType</code> is referenced by <code>componentTypeId</code>.</p>', 'UpdateComponentTypeRequest$compositeComponentTypes' => '<p>This is an object that maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code>. <code>CompositeComponentType</code> is referenced by <code>componentTypeId</code>.</p>', ], ], 'CompositeComponentTypesResponse' => [ 'base' => NULL, 'refs' => [ 'GetComponentTypeResponse$compositeComponentTypes' => '<p>This is an object that maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code>. <code>CompositeComponentType</code> is referenced by <code>componentTypeId</code>.</p>', ], ], 'CompositeComponentUpdateRequest' => [ 'base' => '<p>An object that sets information about the composite component update request.</p>', 'refs' => [ 'CompositeComponentUpdatesMapRequest$value' => NULL, ], ], 'CompositeComponentUpdatesMapRequest' => [ 'base' => NULL, 'refs' => [ 'UpdateEntityRequest$compositeComponentUpdates' => '<p>This is an object that maps strings to <code>compositeComponent</code> updates in the request. Each key of the map represents the <code>componentPath</code> of the <code>compositeComponent</code>.</p>', ], ], 'CompositeComponentsMapRequest' => [ 'base' => NULL, 'refs' => [ 'CreateEntityRequest$compositeComponents' => '<p>This is an object that maps strings to <code>compositeComponent</code> updates in the request. Each key of the map represents the <code>componentPath</code> of the <code>compositeComponent</code>.</p>', ], ], 'Configuration' => [ 'base' => NULL, 'refs' => [ 'PropertyDefinitionRequest$configuration' => '<p>A mapping that specifies configuration information about the property. Use this field to specify information that you read from and write to an external source.</p>', 'PropertyDefinitionResponse$configuration' => '<p>A mapping that specifies configuration information about the property.</p>', ], ], 'ConflictException' => [ 'base' => '<p>A conflict occurred.</p>', 'refs' => [], ], 'ConnectorFailureException' => [ 'base' => '<p>The connector failed.</p>', 'refs' => [], ], 'ConnectorTimeoutException' => [ 'base' => '<p>The connector timed out.</p>', 'refs' => [], ], 'CreateComponentTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateComponentTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEntityRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEntityResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMetadataTransferJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMetadataTransferJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSceneRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSceneResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSyncJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSyncJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataConnector' => [ 'base' => '<p>The data connector.</p>', 'refs' => [ 'FunctionRequest$implementedBy' => '<p>The data connector.</p>', 'FunctionResponse$implementedBy' => '<p>The data connector.</p>', ], ], 'DataType' => [ 'base' => '<p>An object that specifies the data type of a property.</p>', 'refs' => [ 'DataType$nestedType' => '<p>The nested type in the data type.</p>', 'PropertyDefinitionRequest$dataType' => '<p>An object that contains information about the data type.</p>', 'PropertyDefinitionResponse$dataType' => '<p>An object that contains information about the data type.</p>', ], ], 'DataValue' => [ 'base' => '<p>An object that specifies a value for a property.</p>', 'refs' => [ 'DataValueList$member' => NULL, 'DataValueMap$value' => NULL, 'PropertyDefinitionRequest$defaultValue' => '<p>An object that contains the default value.</p>', 'PropertyDefinitionResponse$defaultValue' => '<p>An object that contains the default value.</p>', 'PropertyFilter$value' => '<p>The value associated with this property filter.</p>', 'PropertyLatestValue$propertyValue' => '<p>The value of the property.</p>', 'PropertyRequest$value' => '<p>The value of the property.</p>', 'PropertyResponse$value' => '<p>The value of the property.</p>', 'PropertySummary$value' => '<p>This is the value for the property.</p>', 'PropertyTableValue$value' => NULL, 'PropertyValue$value' => '<p>An object that specifies a value for a time series property.</p>', ], ], 'DataValueList' => [ 'base' => NULL, 'refs' => [ 'DataType$allowedValues' => '<p>The allowed values for this data type.</p>', 'DataValue$listValue' => '<p>A list of multiple values.</p>', ], ], 'DataValueMap' => [ 'base' => NULL, 'refs' => [ 'DataValue$mapValue' => '<p>An object that maps strings to multiple <code>DataValue</code> objects.</p>', ], ], 'DeleteComponentTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteComponentTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEntityRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEntityResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSceneRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSceneResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSyncJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSyncJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'ComponentRequest$description' => '<p>The description of the component request.</p>', 'ComponentResponse$description' => '<p>The description of the component type.</p>', 'ComponentSummary$description' => '<p>The description of the component request.</p>', 'ComponentTypeSummary$description' => '<p>The description of the component type.</p>', 'ComponentUpdateRequest$description' => '<p>The description of the component type.</p>', 'CompositeComponentRequest$description' => '<p>The description of the component type.</p>', 'CompositeComponentUpdateRequest$description' => '<p>The description of the component type.</p>', 'CreateComponentTypeRequest$description' => '<p>The description of the component type.</p>', 'CreateEntityRequest$description' => '<p>The description of the entity.</p>', 'CreateMetadataTransferJobRequest$description' => '<p>The metadata transfer job description.</p>', 'CreateSceneRequest$description' => '<p>The description for this scene.</p>', 'CreateWorkspaceRequest$description' => '<p>The description of the workspace.</p>', 'EntitySummary$description' => '<p>The description of the entity.</p>', 'GetComponentTypeResponse$description' => '<p>The description of the component type.</p>', 'GetEntityResponse$description' => '<p>The description of the entity.</p>', 'GetMetadataTransferJobResponse$description' => '<p>The metadata transfer job description.</p>', 'GetSceneResponse$description' => '<p>The description of the scene.</p>', 'GetWorkspaceResponse$description' => '<p>The description of the workspace.</p>', 'SceneSummary$description' => '<p>The scene description.</p>', 'UpdateComponentTypeRequest$description' => '<p>The description of the component type.</p>', 'UpdateEntityRequest$description' => '<p>The description of the entity.</p>', 'UpdateSceneRequest$description' => '<p>The description of this scene.</p>', 'UpdateWorkspaceRequest$description' => '<p>The description of the workspace.</p>', 'WorkspaceSummary$description' => '<p>The description of the workspace.</p>', ], ], 'DestinationConfiguration' => [ 'base' => '<p>The [link to action] metadata transfer job destination configuration.</p>', 'refs' => [ 'CreateMetadataTransferJobRequest$destination' => '<p>The metadata transfer job destination.</p>', 'GetMetadataTransferJobResponse$destination' => '<p>The metadata transfer job\'s destination.</p>', ], ], 'DestinationType' => [ 'base' => NULL, 'refs' => [ 'DestinationConfiguration$type' => '<p>The destination type.</p>', 'ListMetadataTransferJobsRequest$destinationType' => '<p>The metadata transfer job\'s destination type.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'DataValue$doubleValue' => '<p>A double value.</p>', ], ], 'EntityId' => [ 'base' => NULL, 'refs' => [ 'CreateEntityRequest$entityId' => '<p>The ID of the entity.</p>', 'CreateEntityResponse$entityId' => '<p>The ID of the entity.</p>', 'DeleteEntityRequest$entityId' => '<p>The ID of the entity to delete.</p>', 'EntityPropertyReference$entityId' => '<p>The ID of the entity.</p>', 'EntitySummary$entityId' => '<p>The ID of the entity.</p>', 'FilterByEntity$entityId' => '<p>The entity Id.</p>', 'GetEntityRequest$entityId' => '<p>The ID of the entity.</p>', 'GetEntityResponse$entityId' => '<p>The ID of the entity.</p>', 'GetPropertyValueHistoryRequest$entityId' => '<p>The ID of the entity.</p>', 'GetPropertyValueRequest$entityId' => '<p>The ID of the entity whose property values the operation returns.</p>', 'ListComponentsRequest$entityId' => '<p>The ID for the entity whose metadata (component/properties) is returned by the operation.</p>', 'ListPropertiesRequest$entityId' => '<p>The ID for the entity whose metadata (component/properties) is returned by the operation.</p>', 'RelationshipValue$targetEntityId' => '<p>The ID of the target entity associated with this relationship value.</p>', 'UpdateEntityRequest$entityId' => '<p>The ID of the entity.</p>', ], ], 'EntityName' => [ 'base' => NULL, 'refs' => [ 'CreateEntityRequest$entityName' => '<p>The name of the entity.</p>', 'EntitySummary$entityName' => '<p>The name of the entity.</p>', 'GetEntityResponse$entityName' => '<p>The name of the entity.</p>', 'UpdateEntityRequest$entityName' => '<p>The name of the entity.</p>', ], ], 'EntityPropertyReference' => [ 'base' => '<p>An object that uniquely identifies an entity property.</p>', 'refs' => [ 'PropertyLatestValue$propertyReference' => '<p>An object that specifies information about a property.</p>', 'PropertyValueEntry$entityPropertyReference' => '<p>An object that contains information about the entity that has the property.</p>', 'PropertyValueHistory$entityPropertyReference' => '<p>An object that uniquely identifies an entity property.</p>', ], ], 'EntitySummaries' => [ 'base' => NULL, 'refs' => [ 'ListEntitiesResponse$entitySummaries' => '<p>A list of objects that contain information about the entities.</p>', ], ], 'EntitySummary' => [ 'base' => '<p>An object that contains information about an entity.</p>', 'refs' => [ 'EntitySummaries$member' => NULL, ], ], 'Entries' => [ 'base' => NULL, 'refs' => [ 'BatchPutPropertyValuesRequest$entries' => '<p>An object that maps strings to the property value entries to set. Each string in the mapping must be unique to this object.</p>', ], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'ErrorDetails$code' => '<p>The error code.</p>', ], ], 'ErrorDetails' => [ 'base' => '<p>The error details.</p>', 'refs' => [ 'MetadataTransferJobStatus$error' => '<p>The metadata transfer job error.</p>', 'Status$error' => '<p>The error message.</p>', 'SyncJobStatus$error' => '<p>The SyncJob error.</p>', 'SyncResourceStatus$error' => '<p>The status error.</p>', ], ], 'ErrorEntries' => [ 'base' => NULL, 'refs' => [ 'BatchPutPropertyValuesResponse$errorEntries' => '<p>Entries that caused errors in the batch put operation.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'ConnectorFailureException$message' => NULL, 'ConnectorTimeoutException$message' => NULL, 'ErrorDetails$message' => '<p>The error message.</p>', 'InternalServerException$message' => NULL, 'QueryTimeoutException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'SceneError$message' => '<p>The SceneError message.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'Errors' => [ 'base' => NULL, 'refs' => [ 'BatchPutPropertyErrorEntry$errors' => '<p>A list of objects that contain information about errors returned by the <code>BatchPutProperty</code> action.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'TooManyTagsException$message' => NULL, ], ], 'ExecuteQueryRequest' => [ 'base' => NULL, 'refs' => [], ], 'ExecuteQueryResponse' => [ 'base' => NULL, 'refs' => [], ], 'Expression' => [ 'base' => NULL, 'refs' => [ 'DataValue$expression' => '<p>An expression that produces the value.</p>', ], ], 'ExtendsFrom' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeRequest$extendsFrom' => '<p>Specifies the parent component type to extend.</p>', 'GetComponentTypeResponse$extendsFrom' => '<p>The name of the parent component type that this component type extends.</p>', 'UpdateComponentTypeRequest$extendsFrom' => '<p>Specifies the component type that this component type extends.</p>', ], ], 'ExternalIdProperty' => [ 'base' => NULL, 'refs' => [ 'EntityPropertyReference$externalIdProperty' => '<p>A mapping of external IDs to property names. External IDs uniquely identify properties from external data stores.</p>', ], ], 'FilterByAsset' => [ 'base' => '<p>Filter by asset. [TwinMaker asset]</p>', 'refs' => [ 'IotSiteWiseSourceConfigurationFilter$filterByAsset' => '<p>Filter by asset.</p>', ], ], 'FilterByAssetModel' => [ 'base' => '<p>Filter by asset model.</p>', 'refs' => [ 'IotSiteWiseSourceConfigurationFilter$filterByAssetModel' => '<p>Filter by asset model.</p>', ], ], 'FilterByComponentType' => [ 'base' => '<p>Filter by component type.</p>', 'refs' => [ 'IotTwinMakerSourceConfigurationFilter$filterByComponentType' => '<p>Filter by component type.</p>', ], ], 'FilterByEntity' => [ 'base' => '<p>Vilter by entity.</p>', 'refs' => [ 'IotTwinMakerSourceConfigurationFilter$filterByEntity' => '<p>Filter by entity.</p>', ], ], 'FunctionRequest' => [ 'base' => '<p>The function request body.</p>', 'refs' => [ 'FunctionsRequest$value' => NULL, ], ], 'FunctionResponse' => [ 'base' => '<p>The function response.</p>', 'refs' => [ 'FunctionsResponse$value' => NULL, ], ], 'FunctionsRequest' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeRequest$functions' => '<p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>', 'UpdateComponentTypeRequest$functions' => '<p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>', ], ], 'FunctionsResponse' => [ 'base' => NULL, 'refs' => [ 'GetComponentTypeResponse$functions' => '<p>An object that maps strings to the functions in the component type. Each string in the mapping must be unique to this object.</p>', ], ], 'GeneratedSceneMetadataMap' => [ 'base' => NULL, 'refs' => [ 'GetSceneResponse$generatedSceneMetadata' => '<p>The generated scene metadata.</p>', ], ], 'GetComponentTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetComponentTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEntityRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEntityResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMetadataTransferJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMetadataTransferJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPricingPlanRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPricingPlanResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertyValueHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertyValueHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertyValueRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPropertyValueResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSceneRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSceneResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSyncJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSyncJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GroupType' => [ 'base' => NULL, 'refs' => [ 'ComponentPropertyGroupRequest$groupType' => '<p>The group type.</p>', 'ComponentPropertyGroupResponse$groupType' => '<p>The group type.</p>', 'PropertyGroupRequest$groupType' => '<p>The group type.</p>', 'PropertyGroupResponse$groupType' => '<p>The group types.</p>', ], ], 'Id' => [ 'base' => NULL, 'refs' => [ 'BatchPutPropertyValuesRequest$workspaceId' => '<p>The ID of the workspace that contains the properties to set.</p>', 'CancelMetadataTransferJobRequest$metadataTransferJobId' => '<p>The metadata transfer job Id.</p>', 'CancelMetadataTransferJobResponse$metadataTransferJobId' => '<p>The metadata transfer job Id.</p>', 'CreateComponentTypeRequest$workspaceId' => '<p>The ID of the workspace that contains the component type.</p>', 'CreateEntityRequest$workspaceId' => '<p>The ID of the workspace that contains the entity.</p>', 'CreateMetadataTransferJobRequest$metadataTransferJobId' => '<p>The metadata transfer job Id.</p>', 'CreateMetadataTransferJobResponse$metadataTransferJobId' => '<p>The metadata transfer job Id.</p>', 'CreateSceneRequest$workspaceId' => '<p>The ID of the workspace that contains the scene.</p>', 'CreateSceneRequest$sceneId' => '<p>The ID of the scene.</p>', 'CreateSyncJobRequest$workspaceId' => '<p>The workspace ID.</p>', 'CreateWorkspaceRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'DeleteComponentTypeRequest$workspaceId' => '<p>The ID of the workspace that contains the component type.</p>', 'DeleteEntityRequest$workspaceId' => '<p>The ID of the workspace that contains the entity to delete.</p>', 'DeleteSceneRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'DeleteSceneRequest$sceneId' => '<p>The ID of the scene to delete.</p>', 'DeleteSyncJobRequest$workspaceId' => '<p>The workspace ID.</p>', 'DeleteWorkspaceRequest$workspaceId' => '<p>The ID of the workspace to delete.</p>', 'ExecuteQueryRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'GetComponentTypeRequest$workspaceId' => '<p>The ID of the workspace that contains the component type.</p>', 'GetComponentTypeResponse$workspaceId' => '<p>The ID of the workspace that contains the component type.</p>', 'GetEntityRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'GetEntityResponse$workspaceId' => '<p>The ID of the workspace.</p>', 'GetMetadataTransferJobRequest$metadataTransferJobId' => '<p>The metadata transfer job Id.</p>', 'GetMetadataTransferJobResponse$metadataTransferJobId' => '<p>The metadata transfer job Id.</p>', 'GetPropertyValueHistoryRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'GetPropertyValueRequest$workspaceId' => '<p>The ID of the workspace whose values the operation returns.</p>', 'GetSceneRequest$workspaceId' => '<p>The ID of the workspace that contains the scene.</p>', 'GetSceneRequest$sceneId' => '<p>The ID of the scene.</p>', 'GetSceneResponse$workspaceId' => '<p>The ID of the workspace that contains the scene.</p>', 'GetSceneResponse$sceneId' => '<p>The ID of the scene.</p>', 'GetSyncJobRequest$workspaceId' => '<p>The workspace ID.</p>', 'GetSyncJobResponse$workspaceId' => '<p>The ID of the workspace that contains the sync job.</p>', 'GetWorkspaceResponse$workspaceId' => '<p>The ID of the workspace.</p>', 'ListComponentTypesRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'ListComponentTypesResponse$workspaceId' => '<p>The ID of the workspace.</p>', 'ListComponentsRequest$workspaceId' => '<p>The workspace ID.</p>', 'ListEntitiesRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'ListMetadataTransferJobsFilter$workspaceId' => '<p>The workspace Id.</p>', 'ListPropertiesRequest$workspaceId' => '<p>The workspace ID.</p>', 'ListScenesRequest$workspaceId' => '<p>The ID of the workspace that contains the scenes.</p>', 'ListSyncJobsRequest$workspaceId' => '<p>The ID of the workspace that contains the sync job.</p>', 'ListSyncResourcesRequest$workspaceId' => '<p>The ID of the workspace that contains the sync job.</p>', 'MetadataTransferJobSummary$metadataTransferJobId' => '<p>The metadata transfer job summary Id.</p>', 'SceneSummary$sceneId' => '<p>The ID of the scene.</p>', 'SyncJobSummary$workspaceId' => '<p>The ID of the workspace that contains the sync job.</p>', 'SyncResourceFilter$resourceId' => '<p>The sync resource filter resource ID.</p>', 'SyncResourceFilter$externalId' => '<p>The external ID.</p>', 'SyncResourceSummary$externalId' => '<p>The external ID.</p>', 'SyncResourceSummary$resourceId' => '<p>The resource ID.</p>', 'UpdateComponentTypeRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'UpdateComponentTypeResponse$workspaceId' => '<p>The ID of the workspace that contains the component type.</p>', 'UpdateEntityRequest$workspaceId' => '<p>The ID of the workspace that contains the entity.</p>', 'UpdateSceneRequest$workspaceId' => '<p>The ID of the workspace that contains the scene.</p>', 'UpdateSceneRequest$sceneId' => '<p>The ID of the scene.</p>', 'UpdateWorkspaceRequest$workspaceId' => '<p>The ID of the workspace.</p>', 'WorkspaceSummary$workspaceId' => '<p>The ID of the workspace.</p>', ], ], 'IdOrArn' => [ 'base' => NULL, 'refs' => [ 'GetWorkspaceRequest$workspaceId' => '<p>The ID of the workspace.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DataValue$integerValue' => '<p>An integer value.</p>', 'MetadataTransferJobProgress$totalCount' => '<p>The total count. [of what]</p>', 'MetadataTransferJobProgress$succeededCount' => '<p>The succeeded count.</p>', 'MetadataTransferJobProgress$skippedCount' => '<p>The skipped count.</p>', 'MetadataTransferJobProgress$failedCount' => '<p>The failed count.</p>', 'MetadataTransferJobStatus$queuedPosition' => '<p>The queued position.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>An unexpected error has occurred.</p>', 'refs' => [], ], 'InterpolationParameters' => [ 'base' => '<p>An object that specifies how to interpolate data in a list.</p>', 'refs' => [ 'GetPropertyValueHistoryRequest$interpolation' => '<p>An object that specifies the interpolation type and the interval over which to interpolate data.</p>', ], ], 'InterpolationType' => [ 'base' => NULL, 'refs' => [ 'InterpolationParameters$interpolationType' => '<p>The interpolation type.</p>', ], ], 'IntervalInSeconds' => [ 'base' => NULL, 'refs' => [ 'InterpolationParameters$intervalInSeconds' => '<p>The interpolation time interval in seconds.</p>', ], ], 'IotSiteWiseSourceConfiguration' => [ 'base' => '<p>The metadata transfer job AWS IoT SiteWise source configuration.</p>', 'refs' => [ 'SourceConfiguration$iotSiteWiseConfiguration' => '<p>The source configuration IoT SiteWise configuration.</p>', ], ], 'IotSiteWiseSourceConfigurationFilter' => [ 'base' => '<p>The AWS IoT SiteWise soucre configuration filter.[need held with desc here]</p>', 'refs' => [ 'IotSiteWiseSourceConfigurationFilters$member' => NULL, ], ], 'IotSiteWiseSourceConfigurationFilters' => [ 'base' => NULL, 'refs' => [ 'IotSiteWiseSourceConfiguration$filters' => '<p>The AWS IoT SiteWise soucre configuration filters.</p>', ], ], 'IotTwinMakerDestinationConfiguration' => [ 'base' => '<p>The metadata transfer job AWS IoT TwinMaker destination configuration.</p>', 'refs' => [ 'DestinationConfiguration$iotTwinMakerConfiguration' => '<p>The metadata transfer job Amazon Web Services IoT TwinMaker configuration.</p>', ], ], 'IotTwinMakerSourceConfiguration' => [ 'base' => '<p>The metadata transfer job AWS IoT TwinMaker source configuration.</p>', 'refs' => [ 'SourceConfiguration$iotTwinMakerConfiguration' => '<p>The source configuration IoT TwinMaker configuration.</p>', ], ], 'IotTwinMakerSourceConfigurationFilter' => [ 'base' => '<p>The metadata transfer job AWS IoT TwinMaker source configuration filter.</p>', 'refs' => [ 'IotTwinMakerSourceConfigurationFilters$member' => NULL, ], ], 'IotTwinMakerSourceConfigurationFilters' => [ 'base' => NULL, 'refs' => [ 'IotTwinMakerSourceConfiguration$filters' => '<p>The metadata transfer job AWS IoT TwinMaker source configuration filters.</p>', ], ], 'LambdaArn' => [ 'base' => NULL, 'refs' => [ 'LambdaFunction$arn' => '<p>The ARN of the Lambda function.</p>', ], ], 'LambdaFunction' => [ 'base' => '<p>The Lambda function.</p>', 'refs' => [ 'DataConnector$lambda' => '<p>The Lambda function associated with this data connector.</p>', ], ], 'LinkedService' => [ 'base' => NULL, 'refs' => [ 'LinkedServices$member' => NULL, ], ], 'LinkedServices' => [ 'base' => NULL, 'refs' => [ 'GetWorkspaceResponse$linkedServices' => '<p>A list of services that are linked to the workspace.</p>', 'WorkspaceSummary$linkedServices' => '<p>A list of services that are linked to the workspace.</p>', ], ], 'ListComponentTypesFilter' => [ 'base' => '<p>An object that filters items in a list of component types.</p> <note> <p>Only one object is accepted as a valid input.</p> </note>', 'refs' => [ 'ListComponentTypesFilters$member' => NULL, ], ], 'ListComponentTypesFilters' => [ 'base' => NULL, 'refs' => [ 'ListComponentTypesRequest$filters' => '<p>A list of objects that filter the request.</p>', ], ], 'ListComponentTypesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentTypesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEntitiesFilter' => [ 'base' => '<p>An object that filters items in a list of entities.</p>', 'refs' => [ 'ListEntitiesFilters$member' => NULL, ], ], 'ListEntitiesFilters' => [ 'base' => NULL, 'refs' => [ 'ListEntitiesRequest$filters' => '<p>A list of objects that filter the request.</p> <note> <p>Only one object is accepted as a valid input.</p> </note>', ], ], 'ListEntitiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEntitiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMetadataTransferJobsFilter' => [ 'base' => '<p>The ListMetadataTransferJobs filter.</p>', 'refs' => [ 'ListMetadataTransferJobsFilters$member' => NULL, ], ], 'ListMetadataTransferJobsFilters' => [ 'base' => NULL, 'refs' => [ 'ListMetadataTransferJobsRequest$filters' => '<p>An object that filters metadata transfer jobs.</p>', ], ], 'ListMetadataTransferJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMetadataTransferJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPropertiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPropertiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListScenesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListScenesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSyncJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSyncJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSyncResourcesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSyncResourcesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkspacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkspacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'DataValue$longValue' => '<p>A long value.</p>', 'PricingPlan$billableEntityCount' => '<p>The billable entity count.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueHistoryRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p> <p>Valid Range: Minimum value of 1. Maximum value of 250.</p>', 'GetPropertyValueRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p> <p>Valid Range: Minimum value of 1. Maximum value of 250.</p>', 'ListComponentTypesRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p> <p>Valid Range: Minimum value of 1. Maximum value of 250.</p>', 'ListComponentTypesResponse$maxResults' => '<p>Specifies the maximum number of results to display.</p>', 'ListComponentsRequest$maxResults' => '<p>The maximum number of results returned at one time. The default is 25.</p>', 'ListEntitiesRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p> <p>Valid Range: Minimum value of 1. Maximum value of 250.</p>', 'ListMetadataTransferJobsRequest$maxResults' => '<p>The maximum number of results to return at one time.</p>', 'ListPropertiesRequest$maxResults' => '<p>The maximum number of results returned at one time. The default is 25.</p>', 'ListScenesRequest$maxResults' => '<p>Specifies the maximum number of results to display.</p>', 'ListSyncJobsRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 50.</p> <p>Valid Range: Minimum value of 0. Maximum value of 200.</p>', 'ListSyncResourcesRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 50.</p> <p>Valid Range: Minimum value of 0. Maximum value of 200.</p>', 'ListTagsForResourceRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p> <p>Valid Range: Minimum value of 1. Maximum value of 250.</p>', 'ListWorkspacesRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 25.</p> <p>Valid Range: Minimum value of 1. Maximum value of 250.</p>', ], ], 'MetadataTransferJobProgress' => [ 'base' => '<p>The metadata transfer job\'s progress.</p>', 'refs' => [ 'CancelMetadataTransferJobResponse$progress' => '<p>The metadata transfer job\'s progress.</p>', 'GetMetadataTransferJobResponse$progress' => '<p>The metadata transfer job\'s progress.</p>', 'MetadataTransferJobSummary$progress' => '<p>The metadata transfer job summary progess.</p>', ], ], 'MetadataTransferJobState' => [ 'base' => NULL, 'refs' => [ 'ListMetadataTransferJobsFilter$state' => '<p>The filter state.</p>', 'MetadataTransferJobStatus$state' => '<p>The metadata transfer job state.</p>', ], ], 'MetadataTransferJobStatus' => [ 'base' => '<p>The metadata transfer job status.</p>', 'refs' => [ 'CancelMetadataTransferJobResponse$status' => '<p>The metadata transfer job\'s status.</p>', 'CreateMetadataTransferJobResponse$status' => '<p>The metadata transfer job response status.</p>', 'GetMetadataTransferJobResponse$status' => '<p>The metadata transfer job\'s status.</p>', 'MetadataTransferJobSummary$status' => '<p>The metadata transfer job summary status.</p>', ], ], 'MetadataTransferJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListMetadataTransferJobsResponse$metadataTransferJobSummaries' => '<p>The metadata transfer job summaries.</p>', ], ], 'MetadataTransferJobSummary' => [ 'base' => '<p>The metadata transfer job summary.</p>', 'refs' => [ 'MetadataTransferJobSummaries$member' => NULL, ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'ComponentPropertyGroupRequests$key' => NULL, 'ComponentPropertyGroupResponses$key' => NULL, 'ComponentResponse$componentName' => '<p>The name of the component.</p>', 'ComponentSummary$componentName' => '<p>The name of the component.</p>', 'ComponentUpdatesMapRequest$key' => NULL, 'ComponentsMap$key' => NULL, 'ComponentsMapRequest$key' => NULL, 'CompositeComponentResponse$key' => NULL, 'CompositeComponentTypesRequest$key' => NULL, 'CompositeComponentTypesResponse$key' => NULL, 'Configuration$key' => NULL, 'EntityPropertyReference$componentName' => '<p>The name of the component.</p>', 'EntityPropertyReference$propertyName' => '<p>The name of the property.</p>', 'FunctionsRequest$key' => NULL, 'FunctionsResponse$key' => NULL, 'GeneratedSceneMetadataMap$key' => NULL, 'GetPropertyValueHistoryRequest$componentName' => '<p>The name of the component.</p>', 'GetPropertyValueRequest$componentName' => '<p>The name of the component whose property values the operation returns.</p>', 'GetPropertyValueRequest$propertyGroupName' => '<p>The property group name.</p>', 'ListPropertiesRequest$componentName' => '<p>The name of the component whose properties are returned by the operation.</p>', 'PropertyDefinitionsRequest$key' => NULL, 'PropertyDefinitionsResponse$key' => NULL, 'PropertyGroupsRequest$key' => NULL, 'PropertyGroupsResponse$key' => NULL, 'PropertyLatestValueMap$key' => NULL, 'PropertyNames$member' => NULL, 'PropertyRequests$key' => NULL, 'PropertyResponses$key' => NULL, 'PropertySummary$propertyName' => '<p>This is the name of the property.</p>', 'PropertyTableValue$key' => NULL, 'RelationshipValue$targetComponentName' => '<p>The name of the target component associated with the relationship value.</p>', 'RequiredProperties$member' => NULL, 'SceneMetadataMap$key' => NULL, ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ExecuteQueryRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ExecuteQueryResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'GetPropertyValueHistoryRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'GetPropertyValueHistoryResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'GetPropertyValueRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'GetPropertyValueResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListComponentTypesRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListComponentTypesResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListComponentsRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListComponentsResponse$nextToken' => '<p>The string that specifies the next page of component results.</p>', 'ListEntitiesRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListEntitiesResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListMetadataTransferJobsRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListMetadataTransferJobsResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListPropertiesRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListPropertiesResponse$nextToken' => '<p>The string that specifies the next page of property results.</p>', 'ListScenesRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListScenesResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListSyncJobsRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListSyncJobsResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListSyncResourcesRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListSyncResourcesResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListTagsForResourceRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListTagsForResourceResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListWorkspacesRequest$nextToken' => '<p>The string that specifies the next page of results.</p>', 'ListWorkspacesResponse$nextToken' => '<p>The string that specifies the next page of results.</p>', ], ], 'Order' => [ 'base' => NULL, 'refs' => [ 'OrderBy$order' => '<p>The set order that filters results.</p>', ], ], 'OrderBy' => [ 'base' => '<p>Filter criteria that orders the return output. It can be sorted in ascending or descending order.</p>', 'refs' => [ 'OrderByList$member' => NULL, ], ], 'OrderByList' => [ 'base' => NULL, 'refs' => [ 'TabularConditions$orderBy' => '<p>Filter criteria that orders the output. It can be sorted in ascending or descending order.</p>', ], ], 'OrderByTime' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueHistoryRequest$orderByTime' => '<p>The time direction to use in the result order.</p>', ], ], 'ParentEntityId' => [ 'base' => NULL, 'refs' => [ 'CreateEntityRequest$parentEntityId' => '<p>The ID of the entity\'s parent entity.</p>', 'EntitySummary$parentEntityId' => '<p>The ID of the parent entity.</p>', 'GetEntityResponse$parentEntityId' => '<p>The ID of the parent entity for this entity.</p>', 'ListEntitiesFilter$parentEntityId' => '<p>The parent of the entities in the list.</p>', 'ParentEntityUpdateRequest$parentEntityId' => '<p>The ID of the parent entity.</p>', ], ], 'ParentEntityUpdateRequest' => [ 'base' => '<p>The parent entity update request.</p>', 'refs' => [ 'UpdateEntityRequest$parentEntityUpdate' => '<p>An object that describes the update request for a parent entity.</p>', ], ], 'ParentEntityUpdateType' => [ 'base' => NULL, 'refs' => [ 'ParentEntityUpdateRequest$updateType' => '<p>The type of the update.</p>', ], ], 'PricingBundles' => [ 'base' => NULL, 'refs' => [ 'BundleInformation$bundleNames' => '<p>The bundle names.</p>', 'UpdatePricingPlanRequest$bundleNames' => '<p>The bundle names.</p>', ], ], 'PricingMode' => [ 'base' => NULL, 'refs' => [ 'PricingPlan$pricingMode' => '<p>The pricing mode.</p>', 'UpdatePricingPlanRequest$pricingMode' => '<p>The pricing mode.</p>', ], ], 'PricingPlan' => [ 'base' => '<p>The pricing plan.</p>', 'refs' => [ 'GetPricingPlanResponse$currentPricingPlan' => '<p>The chosen pricing plan for the current billing cycle.</p>', 'GetPricingPlanResponse$pendingPricingPlan' => '<p>The pending pricing plan.</p>', 'UpdatePricingPlanResponse$currentPricingPlan' => '<p>Update the current pricing plan.</p>', 'UpdatePricingPlanResponse$pendingPricingPlan' => '<p>Update the pending pricing plan.</p>', ], ], 'PricingTier' => [ 'base' => NULL, 'refs' => [ 'BundleInformation$pricingTier' => '<p>The pricing tier.</p>', ], ], 'PropertyDefinitionRequest' => [ 'base' => '<p>An object that sets information about a property.</p>', 'refs' => [ 'PropertyDefinitionsRequest$value' => NULL, 'PropertyRequest$definition' => '<p>An object that specifies information about a property.</p>', ], ], 'PropertyDefinitionResponse' => [ 'base' => '<p>An object that contains response data from a property definition request.</p>', 'refs' => [ 'PropertyDefinitionsResponse$value' => NULL, 'PropertyResponse$definition' => '<p>An object that specifies information about a property.</p>', 'PropertySummary$definition' => '<p>This is the schema for the property.</p>', ], ], 'PropertyDefinitionsRequest' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeRequest$propertyDefinitions' => '<p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>', 'UpdateComponentTypeRequest$propertyDefinitions' => '<p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>', ], ], 'PropertyDefinitionsResponse' => [ 'base' => NULL, 'refs' => [ 'GetComponentTypeResponse$propertyDefinitions' => '<p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>', ], ], 'PropertyDisplayName' => [ 'base' => NULL, 'refs' => [ 'PropertyDefinitionRequest$displayName' => '<p>A friendly name for the property.</p>', 'PropertyDefinitionResponse$displayName' => '<p>A friendly name for the property.</p>', ], ], 'PropertyFilter' => [ 'base' => '<p>An object that filters items returned by a property request.</p>', 'refs' => [ 'PropertyFilters$member' => NULL, ], ], 'PropertyFilters' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueHistoryRequest$propertyFilters' => '<p>A list of objects that filter the property value history request.</p>', 'TabularConditions$propertyFilters' => '<p>You can filter the request using various logical operators and a key-value format. For example:</p> <p> <code>{"key": "serverType", "value": "webServer"}</code> </p>', ], ], 'PropertyGroupRequest' => [ 'base' => '<p/>', 'refs' => [ 'PropertyGroupsRequest$value' => NULL, ], ], 'PropertyGroupResponse' => [ 'base' => '<p>The property group response</p>', 'refs' => [ 'PropertyGroupsResponse$value' => NULL, ], ], 'PropertyGroupUpdateType' => [ 'base' => NULL, 'refs' => [ 'ComponentPropertyGroupRequest$updateType' => '<p>The update type.</p>', ], ], 'PropertyGroupsRequest' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeRequest$propertyGroups' => '<p/>', 'UpdateComponentTypeRequest$propertyGroups' => '<p>The property groups.</p>', ], ], 'PropertyGroupsResponse' => [ 'base' => NULL, 'refs' => [ 'GetComponentTypeResponse$propertyGroups' => '<p>The maximum number of results to return at one time. The default is 25.</p> <p>Valid Range: Minimum value of 1. Maximum value of 250.</p>', ], ], 'PropertyLatestValue' => [ 'base' => '<p>The latest value of the property.</p>', 'refs' => [ 'PropertyLatestValueMap$value' => NULL, ], ], 'PropertyLatestValueMap' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueResponse$propertyValues' => '<p>An object that maps strings to the properties and latest property values in the response. Each string in the mapping must be unique to this object.</p>', ], ], 'PropertyNames' => [ 'base' => NULL, 'refs' => [ 'ComponentPropertyGroupRequest$propertyNames' => '<p>The property names.</p>', 'ComponentPropertyGroupResponse$propertyNames' => '<p>The names of properties</p>', 'PropertyGroupRequest$propertyNames' => '<p>The names of properties.</p>', 'PropertyGroupResponse$propertyNames' => '<p>The names of properties.</p>', ], ], 'PropertyRequest' => [ 'base' => '<p>An object that sets information about a property.</p>', 'refs' => [ 'PropertyRequests$value' => NULL, ], ], 'PropertyRequests' => [ 'base' => NULL, 'refs' => [ 'ComponentRequest$properties' => '<p>An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>', 'ComponentUpdateRequest$propertyUpdates' => '<p>An object that maps strings to the properties to set in the component type update. Each string in the mapping must be unique to this object.</p>', 'CompositeComponentRequest$properties' => '<p>This is an object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>', 'CompositeComponentUpdateRequest$propertyUpdates' => '<p>An object that maps strings to the properties to set in the component type update. Each string in the mapping must be unique to this object.</p>', ], ], 'PropertyResponse' => [ 'base' => '<p>An object that contains information about a property response.</p>', 'refs' => [ 'PropertyResponses$value' => NULL, ], ], 'PropertyResponses' => [ 'base' => NULL, 'refs' => [ 'ComponentResponse$properties' => '<p>An object that maps strings to the properties to set in the component type. Each string in the mapping must be unique to this object.</p>', ], ], 'PropertySummaries' => [ 'base' => NULL, 'refs' => [ 'ListPropertiesResponse$propertySummaries' => '<p>A list of objects that contain information about the properties.</p>', ], ], 'PropertySummary' => [ 'base' => '<p>This is an object that contains the information of a property.</p>', 'refs' => [ 'PropertySummaries$member' => NULL, ], ], 'PropertyTableValue' => [ 'base' => NULL, 'refs' => [ 'TabularPropertyValue$member' => NULL, ], ], 'PropertyUpdateType' => [ 'base' => NULL, 'refs' => [ 'PropertyRequest$updateType' => '<p>The update type of the update property request.</p>', ], ], 'PropertyValue' => [ 'base' => '<p>An object that contains information about a value for a time series property.</p>', 'refs' => [ 'PropertyValues$member' => NULL, 'Values$member' => NULL, ], ], 'PropertyValueEntry' => [ 'base' => '<p>An object that specifies information about time series property values. This object is used and consumed by the <a href="https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_BatchPutPropertyValues.html">BatchPutPropertyValues</a> action.</p>', 'refs' => [ 'BatchPutPropertyError$entry' => '<p>An object that contains information about errors returned by the <code>BatchPutProperty</code> action.</p>', 'Entries$member' => NULL, ], ], 'PropertyValueHistory' => [ 'base' => '<p>The history of values for a time series property.</p>', 'refs' => [ 'PropertyValueList$member' => NULL, ], ], 'PropertyValueList' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueHistoryResponse$propertyValues' => '<p>An object that maps strings to the property definitions in the component type. Each string in the mapping must be unique to this object.</p>', ], ], 'PropertyValues' => [ 'base' => NULL, 'refs' => [ 'PropertyValueEntry$propertyValues' => '<p>A list of objects that specify time series property values.</p>', ], ], 'QueryResultValue' => [ 'base' => NULL, 'refs' => [ 'RowData$member' => NULL, ], ], 'QueryServiceMaxResults' => [ 'base' => NULL, 'refs' => [ 'ExecuteQueryRequest$maxResults' => '<p>The maximum number of results to return at one time. The default is 50.</p>', ], ], 'QueryStatement' => [ 'base' => NULL, 'refs' => [ 'ExecuteQueryRequest$queryStatement' => '<p>The query statement.</p>', ], ], 'QueryTimeoutException' => [ 'base' => '<p>The query timeout exception.</p>', 'refs' => [], ], 'Relationship' => [ 'base' => '<p>An object that specifies a relationship with another component type.</p>', 'refs' => [ 'DataType$relationship' => '<p>A relationship that associates a component with another component.</p>', ], ], 'RelationshipValue' => [ 'base' => '<p>A value that associates a component and an entity.</p>', 'refs' => [ 'DataValue$relationshipValue' => '<p>A value that relates a component to another component.</p>', ], ], 'RequiredProperties' => [ 'base' => NULL, 'refs' => [ 'FunctionRequest$requiredProperties' => '<p>The required properties of the function.</p>', 'FunctionResponse$requiredProperties' => '<p>The required properties of the function.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource wasn\'t found.</p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateSyncJobRequest$syncRole' => '<p>The SyncJob IAM role. This IAM role is used by the SyncJob to read from the syncSource, and create, update, or delete the corresponding resources.</p>', 'CreateWorkspaceRequest$role' => '<p>The ARN of the execution role associated with the workspace.</p>', 'GetMetadataTransferJobResponse$metadataTransferJobRole' => '<p>The metadata transfer job\'s role.</p>', 'GetSyncJobResponse$syncRole' => '<p>The sync IAM role.</p>', 'GetWorkspaceResponse$role' => '<p>The ARN of the execution role associated with the workspace.</p>', 'UpdateWorkspaceRequest$role' => '<p>The ARN of the execution role associated with the workspace.</p>', ], ], 'Row' => [ 'base' => '<p>Represents a single row in the query results.</p>', 'refs' => [ 'Rows$member' => NULL, ], ], 'RowData' => [ 'base' => NULL, 'refs' => [ 'Row$rowData' => '<p>The data in a row of query results.</p>', ], ], 'Rows' => [ 'base' => NULL, 'refs' => [ 'ExecuteQueryResponse$rows' => '<p>Represents a single row in the query results.</p>', ], ], 'S3DestinationConfiguration' => [ 'base' => '<p>The S3 destination configuration.</p>', 'refs' => [ 'DestinationConfiguration$s3Configuration' => '<p>The metadata transfer job S3 configuration. [need to add S3 entity]</p>', ], ], 'S3DestinationLocation' => [ 'base' => NULL, 'refs' => [ 'S3DestinationConfiguration$location' => '<p>The S3 destination configuration location.</p>', ], ], 'S3Location' => [ 'base' => NULL, 'refs' => [ 'CreateWorkspaceRequest$s3Location' => '<p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>', 'GetWorkspaceResponse$s3Location' => '<p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>', 'UpdateWorkspaceRequest$s3Location' => '<p>The ARN of the S3 bucket where resources associated with the workspace are stored.</p>', ], ], 'S3SourceConfiguration' => [ 'base' => '<p>The S3 destination source configuration.</p>', 'refs' => [ 'SourceConfiguration$s3Configuration' => '<p>The source configuration S3 configuration.</p>', ], ], 'S3SourceLocation' => [ 'base' => NULL, 'refs' => [ 'S3SourceConfiguration$location' => '<p>The S3 destination source configuration location.</p>', ], ], 'S3Url' => [ 'base' => NULL, 'refs' => [ 'CreateSceneRequest$contentLocation' => '<p>The relative path that specifies the location of the content definition file.</p>', 'GetSceneResponse$contentLocation' => '<p>The relative path that specifies the location of the content definition file.</p>', 'SceneSummary$contentLocation' => '<p>The relative path that specifies the location of the content definition file.</p>', 'UpdateSceneRequest$contentLocation' => '<p>The relative path that specifies the location of the content definition file.</p>', ], ], 'SceneCapabilities' => [ 'base' => NULL, 'refs' => [ 'CreateSceneRequest$capabilities' => '<p>A list of capabilities that the scene uses to render itself.</p>', 'GetSceneResponse$capabilities' => '<p>A list of capabilities that the scene uses to render.</p>', 'UpdateSceneRequest$capabilities' => '<p>A list of capabilities that the scene uses to render.</p>', ], ], 'SceneCapability' => [ 'base' => NULL, 'refs' => [ 'SceneCapabilities$member' => NULL, ], ], 'SceneError' => [ 'base' => '<p>The scene error.</p>', 'refs' => [ 'GetSceneResponse$error' => '<p>The SceneResponse error.</p>', ], ], 'SceneErrorCode' => [ 'base' => NULL, 'refs' => [ 'SceneError$code' => '<p>The SceneError code.</p>', ], ], 'SceneMetadataMap' => [ 'base' => NULL, 'refs' => [ 'CreateSceneRequest$sceneMetadata' => '<p>The request metadata.</p>', 'GetSceneResponse$sceneMetadata' => '<p>The response metadata.</p>', 'UpdateSceneRequest$sceneMetadata' => '<p>The scene metadata.</p>', ], ], 'SceneMetadataValue' => [ 'base' => NULL, 'refs' => [ 'GeneratedSceneMetadataMap$value' => NULL, 'SceneMetadataMap$value' => NULL, ], ], 'SceneSummaries' => [ 'base' => NULL, 'refs' => [ 'ListScenesResponse$sceneSummaries' => '<p>A list of objects that contain information about the scenes.</p>', ], ], 'SceneSummary' => [ 'base' => '<p>An object that contains information about a scene.</p>', 'refs' => [ 'SceneSummaries$member' => NULL, ], ], 'Scope' => [ 'base' => NULL, 'refs' => [ 'FunctionRequest$scope' => '<p>The scope of the function.</p>', 'FunctionResponse$scope' => '<p>The scope of the function.</p>', ], ], 'SelectedPropertyList' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueHistoryRequest$selectedProperties' => '<p>A list of properties whose value histories the request retrieves.</p>', 'GetPropertyValueRequest$selectedProperties' => '<p>The properties whose values the operation returns.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The service quota was exceeded.</p>', 'refs' => [], ], 'SiteWiseExternalId' => [ 'base' => NULL, 'refs' => [ 'FilterByAsset$assetExternalId' => '<p>The external-Id property of an asset. </p>', 'FilterByAssetModel$assetModelExternalId' => '<p>The external-Id property of an asset model.</p>', ], ], 'SourceConfiguration' => [ 'base' => '<p>The source configuration.</p>', 'refs' => [ 'SourceConfigurations$member' => NULL, ], ], 'SourceConfigurations' => [ 'base' => NULL, 'refs' => [ 'CreateMetadataTransferJobRequest$sources' => '<p>The metadata transfer job sources.</p>', 'GetMetadataTransferJobResponse$sources' => '<p>The metadata transfer job\'s sources.</p>', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'ListMetadataTransferJobsRequest$sourceType' => '<p>The metadata transfer job\'s source type.</p>', 'SourceConfiguration$type' => '<p>The source configuration type.</p>', ], ], 'State' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeResponse$state' => '<p>The current state of the component type.</p>', 'CreateEntityResponse$state' => '<p>The current state of the entity.</p>', 'DeleteComponentTypeResponse$state' => '<p>The current state of the component type to be deleted.</p>', 'DeleteEntityResponse$state' => '<p>The current state of the deleted entity.</p>', 'Status$state' => '<p>The current state of the entity, component, component type, or workspace.</p>', 'UpdateComponentTypeResponse$state' => '<p>The current state of the component type.</p>', 'UpdateEntityResponse$state' => '<p>The current state of the entity update.</p>', ], ], 'Status' => [ 'base' => '<p>An object that represents the status of an entity, component, component type, or workspace.</p>', 'refs' => [ 'ComponentResponse$status' => '<p>The status of the component type.</p>', 'ComponentSummary$status' => '<p>The status of the component type.</p>', 'ComponentTypeSummary$status' => '<p>The current status of the component type.</p>', 'EntitySummary$status' => '<p>The current status of the entity.</p>', 'GetComponentTypeResponse$status' => '<p>The current status of the component type.</p>', 'GetEntityResponse$status' => '<p>The current status of the entity.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BatchPutPropertyError$errorCode' => '<p>The error code.</p>', 'BatchPutPropertyError$errorMessage' => '<p>The error message.</p>', 'ComponentResponse$definedIn' => '<p>The name of the property definition set in the request.</p>', 'ComponentSummary$definedIn' => '<p>The name of the property definition set in the request.</p>', 'DataType$unitOfMeasure' => '<p>The unit of measure used in this data type.</p>', 'DataValue$stringValue' => '<p>A string value.</p>', 'DataValueMap$key' => NULL, 'ExternalIdProperty$key' => NULL, 'ExternalIdProperty$value' => NULL, 'GetMetadataTransferJobResponse$reportUrl' => '<p>The metadata transfer job\'s report URL.</p>', 'ListComponentTypesFilter$namespace' => '<p>The namespace to which the component types in the list belong.</p>', 'ListEntitiesFilter$externalId' => '<p>The external-Id property of a component. The external-Id property is the primary key of an external storage system.</p>', 'OrderBy$propertyName' => '<p>The property name.</p>', 'PropertyFilter$propertyName' => '<p>The property name associated with this property filter.</p>', 'PropertyFilter$operator' => '<p>The operator associated with this property filter.</p>', 'Relationship$relationshipType' => '<p>The type of the relationship.</p>', 'SelectedPropertyList$member' => NULL, ], ], 'SyncJobState' => [ 'base' => NULL, 'refs' => [ 'CreateSyncJobResponse$state' => '<p>The SyncJob response state.</p>', 'DeleteSyncJobResponse$state' => '<p>The SyncJob response state.</p>', 'SyncJobStatus$state' => '<p>The SyncJob status state.</p>', ], ], 'SyncJobStatus' => [ 'base' => '<p>The SyncJob status.</p>', 'refs' => [ 'GetSyncJobResponse$status' => '<p>The SyncJob response status.</p>', 'SyncJobSummary$status' => '<p>The SyncJob summaries status.</p>', ], ], 'SyncJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSyncJobsResponse$syncJobSummaries' => '<p>The listed SyncJob summaries.</p>', ], ], 'SyncJobSummary' => [ 'base' => '<p>The SyncJob summary.</p>', 'refs' => [ 'SyncJobSummaries$member' => NULL, ], ], 'SyncResourceFilter' => [ 'base' => '<p>The sync resource filter.</p>', 'refs' => [ 'SyncResourceFilters$member' => NULL, ], ], 'SyncResourceFilters' => [ 'base' => NULL, 'refs' => [ 'ListSyncResourcesRequest$filters' => '<p>A list of objects that filter the request.</p> <p>The following filter combinations are supported:</p> <ul> <li> <p>Filter with state</p> </li> <li> <p>Filter with ResourceType and ResourceId</p> </li> <li> <p>Filter with ResourceType and ExternalId</p> </li> </ul>', ], ], 'SyncResourceState' => [ 'base' => NULL, 'refs' => [ 'SyncResourceFilter$state' => '<p>The sync resource filter\'s state.</p>', 'SyncResourceStatus$state' => '<p>The sync resource status state.</p>', ], ], 'SyncResourceStatus' => [ 'base' => '<p>The sync resource status.</p>', 'refs' => [ 'SyncResourceSummary$status' => '<p>The sync resource summary status.</p>', ], ], 'SyncResourceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSyncResourcesResponse$syncResources' => '<p>The sync resources.</p>', ], ], 'SyncResourceSummary' => [ 'base' => '<p>The sync resource summary.</p>', 'refs' => [ 'SyncResourceSummaries$member' => NULL, ], ], 'SyncResourceType' => [ 'base' => NULL, 'refs' => [ 'SyncResourceFilter$resourceType' => '<p>The sync resource filter resource type</p>', 'SyncResourceSummary$resourceType' => '<p>The resource type.</p>', ], ], 'SyncSource' => [ 'base' => NULL, 'refs' => [ 'ComponentResponse$syncSource' => '<p>The syncSource of the sync job, if this entity was created by a sync job.</p>', 'ComponentSummary$syncSource' => '<p>The <code>syncSource</code> of the sync job, if this entity was created by a sync job.</p>', 'CreateSyncJobRequest$syncSource' => '<p>The sync source.</p> <note> <p>Currently the only supported syncSoource is <code>SITEWISE </code>.</p> </note>', 'DeleteSyncJobRequest$syncSource' => '<p>The sync source.</p> <note> <p>Currently the only supported syncSource is <code>SITEWISE </code>.</p> </note>', 'GetComponentTypeResponse$syncSource' => '<p>The syncSource of the SyncJob, if this entity was created by a SyncJob.</p>', 'GetEntityResponse$syncSource' => '<p>The syncSource of the sync job, if this entity was created by a sync job.</p>', 'GetSyncJobRequest$syncSource' => '<p>The sync source.</p> <note> <p>Currently the only supported syncSource is <code>SITEWISE </code>.</p> </note>', 'GetSyncJobResponse$syncSource' => '<p>The sync soucre.</p> <note> <p>Currently the only supported syncSource is <code>SITEWISE </code>.</p> </note>', 'ListSyncResourcesRequest$syncSource' => '<p>The sync source.</p> <note> <p>Currently the only supported syncSource is <code>SITEWISE </code>.</p> </note>', 'SyncJobSummary$syncSource' => '<p>The sync source.</p>', ], ], 'TabularConditions' => [ 'base' => '<p>The tabular conditions.</p>', 'refs' => [ 'GetPropertyValueRequest$tabularConditions' => '<p>The tabular conditions.</p>', ], ], 'TabularPropertyValue' => [ 'base' => NULL, 'refs' => [ 'TabularPropertyValues$member' => NULL, ], ], 'TabularPropertyValues' => [ 'base' => NULL, 'refs' => [ 'GetPropertyValueResponse$tabularPropertyValues' => '<p>A table of property values.</p>', ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of tag key names to remove from the resource. You don\'t specify the value. Both the key and its associated value are removed.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateComponentTypeRequest$tags' => '<p>Metadata that you can use to manage the component type.</p>', 'CreateEntityRequest$tags' => '<p>Metadata that you can use to manage the entity.</p>', 'CreateSceneRequest$tags' => '<p>Metadata that you can use to manage the scene.</p>', 'CreateSyncJobRequest$tags' => '<p>The SyncJob tags.</p>', 'CreateWorkspaceRequest$tags' => '<p>Metadata that you can use to manage the workspace</p>', 'ListTagsForResourceResponse$tags' => '<p>Metadata that you can use to manage a resource.</p>', 'TagResourceRequest$tags' => '<p>Metadata to add to this resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The rate exceeds the limit.</p>', 'refs' => [], ], 'Time' => [ 'base' => '<p>Timestamp represented in ISO 8601 format</p>', 'refs' => [ 'GetPropertyValueHistoryRequest$startTime' => '<p>The ISO8601 DateTime of the earliest property value to return.</p> <p>For more information about the ISO8601 DateTime format, see the data type <a href="https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_PropertyValue.html">PropertyValue</a>.</p>', 'GetPropertyValueHistoryRequest$endTime' => '<p>The ISO8601 DateTime of the latest property value to return.</p> <p>For more information about the ISO8601 DateTime format, see the data type <a href="https://docs.aws.amazon.com/iot-twinmaker/latest/apireference/API_PropertyValue.html">PropertyValue</a>.</p>', 'PropertyValue$time' => '<p>ISO8601 DateTime of a value for a time series property.</p> <p>The time for when the property value was recorded in ISO 8601 format: <i>YYYY-MM-DDThh:mm:ss[.SSSSSSSSS][Z/±HH:mm]</i>.</p> <ul> <li> <p> <i>[YYYY]</i>: year</p> </li> <li> <p> <i>[MM]</i>: month</p> </li> <li> <p> <i>[DD]</i>: day</p> </li> <li> <p> <i>[hh]</i>: hour</p> </li> <li> <p> <i>[mm]</i>: minute</p> </li> <li> <p> <i>[ss]</i>: seconds</p> </li> <li> <p> <i>[.SSSSSSSSS]</i>: additional precision, where precedence is maintained. For example: [.573123] is equal to 573123000 nanoseconds.</p> </li> <li> <p> <i>Z</i>: default timezone UTC</p> </li> <li> <p> <i>± HH:mm</i>: time zone offset in Hours and Minutes.</p> </li> </ul> <p> <i>Required sub-fields</i>: YYYY-MM-DDThh:mm:ss and [Z/±HH:mm]</p>', ], ], 'Timestamp' => [ 'base' => '<p>supports epoch seconds value</p>', 'refs' => [ 'CancelMetadataTransferJobResponse$updateDateTime' => '<p>Used to update the DateTime property.</p>', 'ComponentTypeSummary$creationDateTime' => '<p>The date and time when the component type was created.</p>', 'ComponentTypeSummary$updateDateTime' => '<p>The date and time when the component type was last updated.</p>', 'CreateComponentTypeResponse$creationDateTime' => '<p>The date and time when the entity was created.</p>', 'CreateEntityResponse$creationDateTime' => '<p>The date and time when the entity was created.</p>', 'CreateMetadataTransferJobResponse$creationDateTime' => '<p>The The metadata transfer job creation DateTime property.</p>', 'CreateSceneResponse$creationDateTime' => '<p>The date and time when the scene was created.</p>', 'CreateSyncJobResponse$creationDateTime' => '<p>The date and time for the SyncJob creation.</p>', 'CreateWorkspaceResponse$creationDateTime' => '<p>The date and time when the workspace was created.</p>', 'EntitySummary$creationDateTime' => '<p>The date and time when the entity was created.</p>', 'EntitySummary$updateDateTime' => '<p>The last date and time when the entity was updated.</p>', 'GetComponentTypeResponse$creationDateTime' => '<p>The date and time when the component type was created.</p>', 'GetComponentTypeResponse$updateDateTime' => '<p>The date and time when the component was last updated.</p>', 'GetEntityResponse$creationDateTime' => '<p>The date and time when the entity was created.</p>', 'GetEntityResponse$updateDateTime' => '<p>The date and time when the entity was last updated.</p>', 'GetMetadataTransferJobResponse$creationDateTime' => '<p>The metadata transfer job\'s creation DateTime property.</p>', 'GetMetadataTransferJobResponse$updateDateTime' => '<p>The metadata transfer job\'s update DateTime property.</p>', 'GetPropertyValueHistoryRequest$startDateTime' => '<p>The date and time of the earliest property value to return.</p>', 'GetPropertyValueHistoryRequest$endDateTime' => '<p>The date and time of the latest property value to return.</p>', 'GetSceneResponse$creationDateTime' => '<p>The date and time when the scene was created.</p>', 'GetSceneResponse$updateDateTime' => '<p>The date and time when the scene was last updated.</p>', 'GetSyncJobResponse$creationDateTime' => '<p>The creation date and time.</p>', 'GetSyncJobResponse$updateDateTime' => '<p>The update date and time.</p>', 'GetWorkspaceResponse$creationDateTime' => '<p>The date and time when the workspace was created.</p>', 'GetWorkspaceResponse$updateDateTime' => '<p>The date and time when the workspace was last updated.</p>', 'MetadataTransferJobSummary$creationDateTime' => '<p>The metadata transfer job summary creation DateTime object.</p>', 'MetadataTransferJobSummary$updateDateTime' => '<p>The metadata transfer job summary update DateTime object</p>', 'PricingPlan$effectiveDateTime' => '<p>The effective date and time of the pricing plan.</p>', 'PricingPlan$updateDateTime' => '<p>The set date and time for updating a pricing plan.</p>', 'PropertyValue$timestamp' => '<p>The timestamp of a value for a time series property.</p>', 'SceneSummary$creationDateTime' => '<p>The date and time when the scene was created.</p>', 'SceneSummary$updateDateTime' => '<p>The date and time when the scene was last updated.</p>', 'SyncJobSummary$creationDateTime' => '<p>The creation date and time.</p>', 'SyncJobSummary$updateDateTime' => '<p>The update date and time.</p>', 'SyncResourceSummary$updateDateTime' => '<p>The update date and time.</p>', 'UpdateEntityResponse$updateDateTime' => '<p>The date and time when the entity was last updated.</p>', 'UpdateSceneResponse$updateDateTime' => '<p>The date and time when the scene was last updated.</p>', 'UpdateWorkspaceResponse$updateDateTime' => '<p>The date and time of the current update.</p>', 'WorkspaceSummary$creationDateTime' => '<p>The date and time when the workspace was created.</p>', 'WorkspaceSummary$updateDateTime' => '<p>The date and time when the workspace was last updated.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>The number of tags exceeds the limit.</p>', 'refs' => [], ], 'TwinMakerArn' => [ 'base' => NULL, 'refs' => [ 'CancelMetadataTransferJobResponse$arn' => '<p>The metadata transfer job ARN.</p>', 'ComponentTypeSummary$arn' => '<p>The ARN of the component type.</p>', 'CreateComponentTypeResponse$arn' => '<p>The ARN of the component type.</p>', 'CreateEntityResponse$arn' => '<p>The ARN of the entity.</p>', 'CreateMetadataTransferJobResponse$arn' => '<p>The metadata transfer job ARN.</p>', 'CreateSceneResponse$arn' => '<p>The ARN of the scene.</p>', 'CreateSyncJobResponse$arn' => '<p>The SyncJob ARN.</p>', 'CreateWorkspaceResponse$arn' => '<p>The ARN of the workspace.</p>', 'EntitySummary$arn' => '<p>The ARN of the entity.</p>', 'GetComponentTypeResponse$arn' => '<p>The ARN of the component type.</p>', 'GetEntityResponse$arn' => '<p>The ARN of the entity.</p>', 'GetMetadataTransferJobResponse$arn' => '<p>The metadata transfer job ARN.</p>', 'GetSceneResponse$arn' => '<p>The ARN of the scene.</p>', 'GetSyncJobResponse$arn' => '<p>The sync job ARN.</p>', 'GetWorkspaceResponse$arn' => '<p>The ARN of the workspace.</p>', 'IotTwinMakerDestinationConfiguration$workspace' => '<p>The IoT TwinMaker workspace.</p>', 'IotTwinMakerSourceConfiguration$workspace' => '<p>The IoT TwinMaker workspace.</p>', 'ListTagsForResourceRequest$resourceARN' => '<p>The ARN of the resource.</p>', 'MetadataTransferJobSummary$arn' => '<p>The metadata transfer job summary ARN.</p>', 'SceneSummary$arn' => '<p>The ARN of the scene.</p>', 'SyncJobSummary$arn' => '<p>The SyncJob summary ARN.</p>', 'TagResourceRequest$resourceARN' => '<p>The ARN of the resource.</p>', 'UntagResourceRequest$resourceARN' => '<p>The ARN of the resource.</p>', 'UpdateComponentTypeResponse$arn' => '<p>The ARN of the component type.</p>', 'WorkspaceSummary$arn' => '<p>The ARN of the workspace.</p>', ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'DataType$type' => '<p>The underlying type of the data type.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComponentTypeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateComponentTypeResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEntityRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEntityResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePricingPlanRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePricingPlanResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateReason' => [ 'base' => NULL, 'refs' => [ 'PricingPlan$updateReason' => '<p>The update reason for changing a pricing plan.</p>', ], ], 'UpdateSceneRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSceneResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkspaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'Uuid' => [ 'base' => NULL, 'refs' => [ 'FilterByAsset$assetId' => '<p>Filter by asset Id.</p>', 'FilterByAssetModel$assetModelId' => '<p>The asset model Id.</p>', ], ], 'ValidationException' => [ 'base' => '<p>Failed</p>', 'refs' => [], ], 'Value' => [ 'base' => NULL, 'refs' => [ 'Configuration$value' => NULL, ], ], 'Values' => [ 'base' => NULL, 'refs' => [ 'PropertyValueHistory$values' => '<p>A list of objects that contain information about the values in the history of a time series property.</p>', ], ], 'WorkspaceDeleteMessage' => [ 'base' => NULL, 'refs' => [ 'DeleteWorkspaceResponse$message' => '<p>The string that specifies the delete result for the workspace.</p>', ], ], 'WorkspaceSummaries' => [ 'base' => NULL, 'refs' => [ 'ListWorkspacesResponse$workspaceSummaries' => '<p>A list of objects that contain information about the workspaces.</p>', ], ], 'WorkspaceSummary' => [ 'base' => '<p>An object that contains information about a workspace.</p>', 'refs' => [ 'WorkspaceSummaries$member' => NULL, ], ], ],];
