<?php
// This file was auto-generated from sdk-root/src/data/managedblockchain-query/2023-05-04/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Managed Blockchain (AMB) Query provides you with convenient access to multi-blockchain network data, which makes it easier for you to extract contextual data related to blockchain activity. You can use AMB Query to read data from public blockchain networks, such as Bitcoin Mainnet and Ethereum Mainnet. You can also get information such as the current and historical balances of addresses, or you can get a list of blockchain transactions for a given time period. Additionally, you can get details of a given transaction, such as transaction events, which you can further analyze or use in business logic for your applications.</p>', 'operations' => [ 'BatchGetTokenBalance' => '<p>Gets the token balance for a batch of tokens by using the <code>BatchGetTokenBalance</code> action for every token in the request.</p> <note> <p>Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.</p> </note>', 'GetAssetContract' => '<p>Gets the information about a specific contract deployed on the blockchain.</p> <note> <ul> <li> <p>The Bitcoin blockchain networks do not support this operation.</p> </li> <li> <p>Metadata is currently only available for some <code>ERC-20</code> contracts. Metadata will be available for additional contracts in the future.</p> </li> </ul> </note>', 'GetTokenBalance' => '<p>Gets the balance of a specific token, including native tokens, for a given address (wallet or contract) on the blockchain.</p> <note> <p>Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.</p> </note>', 'GetTransaction' => '<p>Gets the details of a transaction.</p> <note> <p>This action will return transaction details for all transactions that are <i>confirmed</i> on the blockchain, even if they have not reached <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">finality</a>. </p> </note>', 'ListAssetContracts' => '<p>Lists all the contracts for a given contract type deployed by an address (either a contract address or a wallet address).</p> <p>The Bitcoin blockchain networks do not support this operation.</p>', 'ListFilteredTransactionEvents' => '<p>Lists all the transaction events for an address on the blockchain.</p> <note> <p>This operation is only supported on the Bitcoin networks.</p> </note>', 'ListTokenBalances' => '<p>This action returns the following for a given blockchain network:</p> <ul> <li> <p>Lists all token balances owned by an address (either a contract address or a wallet address).</p> </li> <li> <p>Lists all token balances for all tokens created by a contract.</p> </li> <li> <p>Lists all token balances for a given token.</p> </li> </ul> <note> <p>You must always specify the network property of the <code>tokenFilter</code> when using this operation.</p> </note>', 'ListTransactionEvents' => '<p>Lists all the transaction events for a transaction </p> <note> <p>This action will return transaction details for all transactions that are <i>confirmed</i> on the blockchain, even if they have not reached <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">finality</a>. </p> </note>', 'ListTransactions' => '<p>Lists all the transaction events for a transaction.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>The Amazon Web Services account doesn’t have access to this resource. </p>', 'refs' => [], ], 'AddressIdentifierFilter' => [ 'base' => '<p>This is the container for the unique public address on the blockchain.</p>', 'refs' => [ 'ListFilteredTransactionEventsInput$addressIdentifierFilter' => '<p>This is the unique public address on the blockchain for which the transaction events are being requested.</p>', ], ], 'AddressIdentifierFilterTransactionEventToAddressList' => [ 'base' => NULL, 'refs' => [ 'AddressIdentifierFilter$transactionEventToAddress' => '<p>The container for the recipient address of the transaction. </p>', ], ], 'AssetContract' => [ 'base' => '<p>This container contains information about an contract.</p>', 'refs' => [ 'AssetContractList$member' => NULL, ], ], 'AssetContractList' => [ 'base' => NULL, 'refs' => [ 'ListAssetContractsOutput$contracts' => '<p>An array of contract objects that contain the properties for each contract.</p>', ], ], 'BatchGetTokenBalanceErrorItem' => [ 'base' => '<p>Error generated from a failed <code>BatchGetTokenBalance</code> request.</p>', 'refs' => [ 'BatchGetTokenBalanceErrors$member' => NULL, ], ], 'BatchGetTokenBalanceErrors' => [ 'base' => NULL, 'refs' => [ 'BatchGetTokenBalanceOutput$errors' => '<p>An array of <code>BatchGetTokenBalanceErrorItem</code> objects returned from the request.</p>', ], ], 'BatchGetTokenBalanceInput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetTokenBalanceInputItem' => [ 'base' => '<p>The container for the input for getting a token balance.</p>', 'refs' => [ 'GetTokenBalanceInputList$member' => NULL, ], ], 'BatchGetTokenBalanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetTokenBalanceOutputItem' => [ 'base' => '<p>The container for the properties of a token balance output.</p>', 'refs' => [ 'BatchGetTokenBalanceOutputList$member' => NULL, ], ], 'BatchGetTokenBalanceOutputList' => [ 'base' => NULL, 'refs' => [ 'BatchGetTokenBalanceOutput$tokenBalances' => '<p>An array of <code>BatchGetTokenBalanceOutputItem</code> objects returned by the response.</p>', ], ], 'BlockHash' => [ 'base' => NULL, 'refs' => [ 'Transaction$blockHash' => '<p>The block hash is a unique identifier for a block. It is a fixed-size string that is calculated by using the information in the block. The block hash is used to verify the integrity of the data in the block.</p>', ], ], 'BlockchainInstant' => [ 'base' => '<p>The container for time.</p>', 'refs' => [ 'BatchGetTokenBalanceErrorItem$atBlockchainInstant' => NULL, 'BatchGetTokenBalanceInputItem$atBlockchainInstant' => NULL, 'BatchGetTokenBalanceOutputItem$atBlockchainInstant' => NULL, 'BatchGetTokenBalanceOutputItem$lastUpdatedTime' => NULL, 'GetTokenBalanceInput$atBlockchainInstant' => '<p>The time for when the TokenBalance is requested or the current time if a time is not provided in the request.</p> <note> <p>This time will only be recorded up to the second.</p> </note>', 'GetTokenBalanceOutput$atBlockchainInstant' => NULL, 'GetTokenBalanceOutput$lastUpdatedTime' => NULL, 'ListTransactionsInput$fromBlockchainInstant' => NULL, 'ListTransactionsInput$toBlockchainInstant' => NULL, 'TimeFilter$from' => NULL, 'TimeFilter$to' => NULL, 'TokenBalance$atBlockchainInstant' => '<p>The time for when the TokenBalance is requested or the current time if a time is not provided in the request.</p> <note> <p>This time will only be recorded up to the second.</p> </note>', 'TokenBalance$lastUpdatedTime' => '<p>The <code>Timestamp</code> of the last transaction at which the balance for the token in the wallet was updated.</p>', 'TransactionEvent$blockchainInstant' => NULL, ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'TransactionEvent$voutSpent' => '<p>Specifies if the transaction output is spent or unspent. This is only returned for BITCOIN_VOUT event types.</p> <note> <p>This is only returned for <code>BITCOIN_VOUT</code> event types.</p> </note>', 'VoutFilter$voutSpent' => '<p>Specifies if the transaction output is spent or unspent.</p>', ], ], 'ChainAddress' => [ 'base' => NULL, 'refs' => [ 'AddressIdentifierFilterTransactionEventToAddressList$member' => NULL, 'AssetContract$deployerAddress' => '<p>The address of the contract deployer.</p>', 'ContractFilter$deployerAddress' => '<p>The network address of the deployer.</p>', 'ContractIdentifier$contractAddress' => '<p>Container for the blockchain address about a contract.</p>', 'GetAssetContractOutput$deployerAddress' => '<p>The address of the deployer of contract.</p>', 'ListTransactionsInput$address' => '<p>The address (either a contract or wallet), whose transactions are being requested.</p>', 'OwnerFilter$address' => '<p>The contract or wallet address.</p>', 'OwnerIdentifier$address' => '<p>The contract or wallet address for the owner.</p>', 'TokenFilter$contractAddress' => '<p>This is the address of the contract.</p>', 'TokenIdentifier$contractAddress' => '<p>This is the token\'s contract address.</p>', 'Transaction$to' => '<p>The identifier of the transaction. It is generated whenever a transaction is verified and added to the blockchain.</p>', 'Transaction$from' => '<p>The initiator of the transaction. It is either in the form a public key or a contract address.</p>', 'Transaction$contractAddress' => '<p>The blockchain address for the contract.</p>', 'TransactionEvent$from' => '<p>The wallet address initiating the transaction. It can either be a public key or a contract.</p>', 'TransactionEvent$to' => '<p>The wallet address receiving the transaction. It can either be a public key or a contract.</p>', 'TransactionEvent$contractAddress' => '<p>The blockchain address for the contract</p>', ], ], 'ConfirmationStatus' => [ 'base' => NULL, 'refs' => [ 'ConfirmationStatusIncludeList$member' => NULL, 'Transaction$confirmationStatus' => '<p>Specifies whether the transaction has reached Finality.</p>', 'TransactionEvent$confirmationStatus' => '<p>This container specifies whether the transaction has reached Finality.</p>', 'TransactionOutputItem$confirmationStatus' => '<p>Specifies whether to list transactions that have not reached Finality.</p>', ], ], 'ConfirmationStatusFilter' => [ 'base' => '<p>The container for the <code>ConfirmationStatusFilter</code> that filters for the <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality"> <i>finality</i> </a> of the results.</p>', 'refs' => [ 'ListFilteredTransactionEventsInput$confirmationStatusFilter' => NULL, 'ListTransactionsInput$confirmationStatusFilter' => '<p>This filter is used to include transactions in the response that haven\'t reached <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality"> <i>finality</i> </a>. Transactions that have reached finality are always part of the response.</p>', ], ], 'ConfirmationStatusIncludeList' => [ 'base' => NULL, 'refs' => [ 'ConfirmationStatusFilter$include' => '<p>The container to determine whether to list results that have only reached <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality"> <i>finality</i> </a>. Transactions that have reached finality are always part of the response.</p>', ], ], 'ContractFilter' => [ 'base' => '<p>The contract or wallet address by which to filter the request.</p>', 'refs' => [ 'ListAssetContractsInput$contractFilter' => '<p>Contains the filter parameter for the request.</p>', ], ], 'ContractIdentifier' => [ 'base' => '<p>Container for the blockchain address and network information about a contract.</p>', 'refs' => [ 'AssetContract$contractIdentifier' => '<p>The container for the contract identifier containing its blockchain network and address.</p>', 'GetAssetContractInput$contractIdentifier' => '<p>Contains the blockchain address and network information about the contract.</p>', 'GetAssetContractOutput$contractIdentifier' => '<p>Contains the blockchain address and network information about the contract.</p>', ], ], 'ContractMetadata' => [ 'base' => '<p>The metadata of the contract.</p>', 'refs' => [ 'GetAssetContractOutput$metadata' => NULL, ], ], 'ErrorType' => [ 'base' => NULL, 'refs' => [ 'BatchGetTokenBalanceErrorItem$errorType' => '<p>The type of error.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => '<p>The container for the exception message.</p>', 'InternalServerException$message' => '<p>The container for the exception message.</p>', 'ResourceNotFoundException$message' => '<p>The container for the exception message.</p>', 'ServiceQuotaExceededException$message' => '<p>The container for the exception message.</p>', 'ThrottlingException$message' => '<p>The container for the exception message.</p>', 'ValidationException$message' => '<p>The container for the exception message.</p>', ], ], 'ExecutionStatus' => [ 'base' => NULL, 'refs' => [ 'Transaction$executionStatus' => '<p>Identifies whether the transaction has succeeded or failed.</p>', ], ], 'GetAssetContractInput' => [ 'base' => NULL, 'refs' => [], ], 'GetAssetContractOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTokenBalanceInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTokenBalanceInputList' => [ 'base' => NULL, 'refs' => [ 'BatchGetTokenBalanceInput$getTokenBalanceInputs' => '<p>An array of <code>BatchGetTokenBalanceInputItem</code> objects whose balance is being requested.</p>', ], ], 'GetTokenBalanceOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetTransactionInput' => [ 'base' => NULL, 'refs' => [], ], 'GetTransactionOutput' => [ 'base' => NULL, 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ContractMetadata$decimals' => '<p>The decimals used by the token contract.</p>', 'InternalServerException$retryAfterSeconds' => '<p>Specifies the <code>retryAfterSeconds</code> value.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The container of the <code>retryAfterSeconds</code> value.</p>', 'Transaction$signatureV' => '<p>The signature of the transaction. The Z coordinate of a point V.</p>', 'TransactionEvent$voutIndex' => '<p>The position of the transaction output in the transaction output list.</p>', 'TransactionEvent$spentVoutIndex' => '<p>The position of the spent transaction output in the output list of the <i>creating transaction</i>.</p> <note> <p>This is only returned for <code>BITCOIN_VIN</code> event types.</p> </note>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an internal error in the service.</p>', 'refs' => [], ], 'ListAssetContractsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAssetContractsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListAssetContractsInput$maxResults' => '<p>The maximum number of contracts to list.</p> <p>Default: <code>100</code> </p> <note> <p>Even if additional results can be retrieved, the request can return less results than <code>maxResults</code> or an empty array of results.</p> <p>To retrieve the next set of results, make another request with the returned <code>nextToken</code> value. The value of <code>nextToken</code> is <code>null</code> when there are no more results to return</p> </note>', ], ], 'ListAssetContractsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListFilteredTransactionEventsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListFilteredTransactionEventsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListFilteredTransactionEventsInput$maxResults' => '<p>The maximum number of transaction events to list.</p> <p>Default: <code>100</code> </p> <note> <p>Even if additional results can be retrieved, the request can return less results than <code>maxResults</code> or an empty array of results.</p> <p>To retrieve the next set of results, make another request with the returned <code>nextToken</code> value. The value of <code>nextToken</code> is <code>null</code> when there are no more results to return</p> </note>', ], ], 'ListFilteredTransactionEventsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListFilteredTransactionEventsSort' => [ 'base' => '<p>Lists all the transaction events for an address on the blockchain.</p> <note> <p>This operation is only supported on the Bitcoin blockchain networks.</p> </note>', 'refs' => [ 'ListFilteredTransactionEventsInput$sort' => '<p>The order by which the results will be sorted.</p>', ], ], 'ListFilteredTransactionEventsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListFilteredTransactionEventsSort$sortBy' => '<p>Container on how the results will be sorted by?</p>', ], ], 'ListTokenBalancesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTokenBalancesInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListTokenBalancesInput$maxResults' => '<p>The maximum number of token balances to return.</p> <p>Default: <code>100</code> </p> <note> <p>Even if additional results can be retrieved, the request can return less results than <code>maxResults</code> or an empty array of results.</p> <p>To retrieve the next set of results, make another request with the returned <code>nextToken</code> value. The value of <code>nextToken</code> is <code>null</code> when there are no more results to return</p> </note>', ], ], 'ListTokenBalancesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTransactionEventsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTransactionEventsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListTransactionEventsInput$maxResults' => '<p>The maximum number of transaction events to list.</p> <p>Default: <code>100</code> </p> <note> <p>Even if additional results can be retrieved, the request can return less results than <code>maxResults</code> or an empty array of results.</p> <p>To retrieve the next set of results, make another request with the returned <code>nextToken</code> value. The value of <code>nextToken</code> is <code>null</code> when there are no more results to return</p> </note>', ], ], 'ListTransactionEventsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTransactionsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTransactionsInputMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListTransactionsInput$maxResults' => '<p>The maximum number of transactions to list.</p> <p>Default: <code>100</code> </p> <note> <p>Even if additional results can be retrieved, the request can return less results than <code>maxResults</code> or an empty array of results.</p> <p>To retrieve the next set of results, make another request with the returned <code>nextToken</code> value. The value of <code>nextToken</code> is <code>null</code> when there are no more results to return</p> </note>', ], ], 'ListTransactionsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTransactionsSort' => [ 'base' => '<p>The container for determining how the list transaction result will be sorted.</p>', 'refs' => [ 'ListTransactionsInput$sort' => '<p>The order by which the results will be sorted. </p>', ], ], 'ListTransactionsSortBy' => [ 'base' => NULL, 'refs' => [ 'ListTransactionsSort$sortBy' => '<p>Defaults to the value <code>TRANSACTION_TIMESTAMP</code>.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'Transaction$transactionIndex' => '<p>The index of the transaction within a blockchain.</p>', 'Transaction$numberOfTransactions' => '<p>The number of transactions in the block.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAssetContractsInput$nextToken' => '<p> The pagination token that indicates the next set of results to retrieve.</p>', 'ListAssetContractsOutput$nextToken' => '<p>The pagination token that indicates the next set of results to retrieve. </p>', 'ListFilteredTransactionEventsInput$nextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListFilteredTransactionEventsOutput$nextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListTokenBalancesInput$nextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListTokenBalancesOutput$nextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListTransactionEventsInput$nextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListTransactionEventsOutput$nextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListTransactionsInput$nextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListTransactionsOutput$nextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', ], ], 'OwnerFilter' => [ 'base' => '<p>The container for the owner information to filter by.</p>', 'refs' => [ 'ListTokenBalancesInput$ownerFilter' => '<p>The contract or wallet address on the blockchain network by which to filter the request. You must specify the <code>address</code> property of the <code>ownerFilter</code> when listing balances of tokens owned by the address.</p>', ], ], 'OwnerIdentifier' => [ 'base' => '<p>The container for the owner identifier.</p>', 'refs' => [ 'BatchGetTokenBalanceErrorItem$ownerIdentifier' => NULL, 'BatchGetTokenBalanceInputItem$ownerIdentifier' => NULL, 'BatchGetTokenBalanceOutputItem$ownerIdentifier' => NULL, 'GetTokenBalanceInput$ownerIdentifier' => '<p>The container for the identifier for the owner.</p>', 'GetTokenBalanceOutput$ownerIdentifier' => NULL, 'TokenBalance$ownerIdentifier' => '<p>The container for the identifier of the owner.</p>', ], ], 'QueryNetwork' => [ 'base' => NULL, 'refs' => [ 'ContractFilter$network' => '<p>The blockchain network of the contract.</p>', 'ContractIdentifier$network' => '<p>The blockchain network of the contract.</p>', 'GetTransactionInput$network' => '<p>The blockchain network where the transaction occurred.</p>', 'ListTransactionEventsInput$network' => '<p>The blockchain network where the transaction events occurred.</p>', 'ListTransactionsInput$network' => '<p>The blockchain network where the transactions occurred.</p>', 'TokenFilter$network' => '<p>The blockchain network of the token.</p>', 'TokenIdentifier$network' => '<p>The blockchain network of the token.</p>', 'Transaction$network' => '<p>The blockchain network where the transaction occurred.</p>', 'TransactionEvent$network' => '<p>The blockchain network where the transaction occurred.</p>', 'TransactionOutputItem$network' => '<p>The blockchain network where the transaction occurred.</p>', ], ], 'QueryTokenId' => [ 'base' => NULL, 'refs' => [ 'TokenFilter$tokenId' => '<p>The unique identifier of the token.</p>', 'TokenIdentifier$tokenId' => '<p>The unique identifier of the token.</p> <note> <p>For native tokens, use the 3 character abbreviation that best matches your token. For example, btc for Bitcoin, eth for Ether, etc. For all other token types you must specify the <code>tokenId</code> in the 64 character hexadecimal <code>tokenid</code> format.</p> </note>', 'TransactionEvent$tokenId' => '<p>The unique identifier for the token involved in the transaction.</p>', ], ], 'QueryTokenStandard' => [ 'base' => NULL, 'refs' => [ 'AssetContract$tokenStandard' => '<p>The token standard of the contract.</p>', 'ContractFilter$tokenStandard' => '<p>The container for the token standard.</p>', 'GetAssetContractOutput$tokenStandard' => '<p>The token standard of the contract requested.</p>', ], ], 'QueryTransactionEventType' => [ 'base' => NULL, 'refs' => [ 'TransactionEvent$eventType' => '<p>The type of transaction event.</p>', ], ], 'QueryTransactionHash' => [ 'base' => NULL, 'refs' => [ 'GetTransactionInput$transactionHash' => '<p>The hash of a transaction. It is generated when a transaction is created.</p>', 'ListTransactionEventsInput$transactionHash' => '<p>The hash of a transaction. It is generated when a transaction is created.</p>', 'Transaction$transactionHash' => '<p>The hash of a transaction. It is generated when a transaction is created.</p>', 'TransactionEvent$transactionHash' => '<p>The hash of a transaction. It is generated when a transaction is created.</p>', 'TransactionOutputItem$transactionHash' => '<p>The hash of a transaction. It is generated when a transaction is created.</p>', ], ], 'QueryTransactionId' => [ 'base' => NULL, 'refs' => [ 'GetTransactionInput$transactionId' => '<p>The identifier of a Bitcoin transaction. It is generated when a transaction is created.</p> <note> <p> <code>transactionId</code> is only supported on the Bitcoin networks.</p> </note>', 'ListTransactionEventsInput$transactionId' => '<p>The identifier of a Bitcoin transaction. It is generated when a transaction is created.</p> <note> <p> <code>transactionId</code> is only supported on the Bitcoin networks.</p> </note>', 'TransactionOutputItem$transactionId' => '<p>The identifier of a Bitcoin transaction. It is generated when a transaction is created.</p>', ], ], 'QuotaCode' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$quotaCode' => '<p>The container for the <code>quotaCode</code>.</p>', 'ThrottlingException$quotaCode' => '<p>The container for the <code>quotaCode</code>.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$resourceId' => '<p>The <code>resourceId</code> of the resource that caused the exception.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>The <code>resourceId</code> of the resource that caused the exception.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource was not found.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'ResourceNotFoundException$resourceType' => '<p>The <code>resourceType</code> of the resource that caused the exception.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The <code>resourceType</code> of the resource that caused the exception.</p>', ], ], 'ServiceCode' => [ 'base' => NULL, 'refs' => [ 'ServiceQuotaExceededException$serviceCode' => '<p>The container for the <code>serviceCode</code>.</p>', 'ThrottlingException$serviceCode' => '<p>The container for the <code>serviceCode</code>.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The service quota has been exceeded for this resource.</p>', 'refs' => [], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListFilteredTransactionEventsSort$sortOrder' => '<p>The container for the <i>sort order</i> for <code>ListFilteredTransactionEvents</code>. The <code>SortOrder</code> field only accepts the values <code>ASCENDING</code> and <code>DESCENDING</code>. Not providing <code>SortOrder</code> will default to <code>ASCENDING</code>.</p>', 'ListTransactionsSort$sortOrder' => '<p>The container for the <i>sort order</i> for <code>ListTransactions</code>. The <code>SortOrder</code> field only accepts the values <code>ASCENDING</code> and <code>DESCENDING</code>. Not providing <code>SortOrder</code> will default to <code>ASCENDING</code>.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BatchGetTokenBalanceErrorItem$errorCode' => '<p>The error code associated with the error.</p>', 'BatchGetTokenBalanceErrorItem$errorMessage' => '<p>The message associated with the error.</p>', 'BatchGetTokenBalanceOutputItem$balance' => '<p>The container for the token balance.</p>', 'ContractMetadata$name' => '<p>The name of the token contract.</p>', 'ContractMetadata$symbol' => '<p>The symbol of the token contract.</p>', 'GetTokenBalanceOutput$balance' => '<p>The container for the token balance.</p>', 'ListFilteredTransactionEventsInput$network' => '<p>The blockchain network where the transaction occurred.</p> <p>Valid Values: <code>BITCOIN_MAINNET</code> | <code>BITCOIN_TESTNET</code> </p>', 'TokenBalance$balance' => '<p>The container of the token balance.</p>', 'Transaction$blockNumber' => '<p>The block number in which the transaction is recorded.</p>', 'Transaction$gasUsed' => '<p>The amount of gas used for the transaction.</p>', 'Transaction$cumulativeGasUsed' => '<p>The amount of gas used up to the specified point in the block.</p>', 'Transaction$effectiveGasPrice' => '<p>The effective gas price.</p>', 'Transaction$signatureR' => '<p>The signature of the transaction. The X coordinate of a point R.</p>', 'Transaction$signatureS' => '<p>The signature of the transaction. The Y coordinate of a point S.</p>', 'Transaction$transactionFee' => '<p>The transaction fee.</p>', 'Transaction$transactionId' => '<p>The identifier of a Bitcoin transaction. It is generated when a transaction is created.</p>', 'TransactionEvent$value' => '<p>The value that was transacted.</p>', 'TransactionEvent$transactionId' => '<p>The identifier of a Bitcoin transaction. It is generated when a transaction is created.</p>', 'TransactionEvent$spentVoutTransactionId' => '<p>The transactionId that <i>created</i> the spent transaction output.</p> <note> <p>This is only returned for <code>BITCOIN_VIN</code> event types.</p> </note>', 'TransactionEvent$spentVoutTransactionHash' => '<p>The transactionHash that <i>created</i> the spent transaction output.</p> <note> <p>This is only returned for <code>BITCOIN_VIN</code> event types.</p> </note>', 'ValidationExceptionField$name' => '<p>The name of the field that triggered the <code>ValidationException</code>.</p>', 'ValidationExceptionField$message' => '<p>The <code>ValidationException</code> message.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request or operation couldn\'t be performed because a service is throttling requests. The most common source of throttling errors is when you create resources that exceed your service limit for this resource type. Request a limit increase or delete unused resources, if possible.</p>', 'refs' => [], ], 'TimeFilter' => [ 'base' => '<p>This container is used to specify a time frame.</p>', 'refs' => [ 'ListFilteredTransactionEventsInput$timeFilter' => '<p>This container specifies the time frame for the transaction events returned in the response.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'BlockchainInstant$time' => '<p>The container of the <code>Timestamp</code> of the blockchain instant.</p> <note> <p>This <code>timestamp</code> will only be recorded up to the second.</p> </note>', 'Transaction$transactionTimestamp' => '<p>The <code>Timestamp</code> of the transaction. </p>', 'TransactionOutputItem$transactionTimestamp' => '<p>The time when the transaction occurred.</p>', ], ], 'TokenBalance' => [ 'base' => '<p>The balance of the token.</p>', 'refs' => [ 'TokenBalanceList$member' => NULL, ], ], 'TokenBalanceList' => [ 'base' => NULL, 'refs' => [ 'ListTokenBalancesOutput$tokenBalances' => '<p>An array of <code>TokenBalance</code> objects. Each object contains details about the token balance.</p>', ], ], 'TokenFilter' => [ 'base' => '<p>The container of the token filter like the contract address on a given blockchain network or a unique token identifier on a given blockchain network.</p> <note> <p>You must always specify the network property of this container when using this operation.</p> </note>', 'refs' => [ 'ListTokenBalancesInput$tokenFilter' => '<p>The contract address or a token identifier on the blockchain network by which to filter the request. You must specify the <code>contractAddress</code> property of this container when listing tokens minted by a contract.</p> <note> <p>You must always specify the network property of this container when using this operation.</p> </note>', ], ], 'TokenIdentifier' => [ 'base' => '<p>The container for the identifier for the token including the unique token ID and its blockchain network.</p> <note> <p>Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.</p> </note>', 'refs' => [ 'BatchGetTokenBalanceErrorItem$tokenIdentifier' => NULL, 'BatchGetTokenBalanceInputItem$tokenIdentifier' => NULL, 'BatchGetTokenBalanceOutputItem$tokenIdentifier' => NULL, 'GetTokenBalanceInput$tokenIdentifier' => '<p>The container for the identifier for the token, including the unique token ID and its blockchain network.</p>', 'GetTokenBalanceOutput$tokenIdentifier' => NULL, 'TokenBalance$tokenIdentifier' => '<p>The identifier for the token, including the unique token ID and its blockchain network.</p>', ], ], 'Transaction' => [ 'base' => '<p>There are two possible types of transactions used for this data type:</p> <ul> <li> <p>A Bitcoin transaction is a movement of BTC from one address to another.</p> </li> <li> <p>An Ethereum transaction refers to an action initiated by an externally owned account, which is an account managed by a human, not a contract. For example, if Bob sends Alice 1 ETH, Bob\'s account must be debited and Alice\'s must be credited. This state-changing action occurs within a transaction.</p> </li> </ul>', 'refs' => [ 'GetTransactionOutput$transaction' => '<p>Contains the details of the transaction.</p>', ], ], 'TransactionEvent' => [ 'base' => '<p>The container for the properties of a transaction event.</p>', 'refs' => [ 'TransactionEventList$member' => NULL, ], ], 'TransactionEventList' => [ 'base' => NULL, 'refs' => [ 'ListFilteredTransactionEventsOutput$events' => '<p>The transaction events returned by the request.</p>', 'ListTransactionEventsOutput$events' => '<p>An array of <code>TransactionEvent</code> objects. Each object contains details about the transaction events.</p>', ], ], 'TransactionOutputItem' => [ 'base' => '<p>The container of the transaction output.</p>', 'refs' => [ 'TransactionOutputList$member' => NULL, ], ], 'TransactionOutputList' => [ 'base' => NULL, 'refs' => [ 'ListTransactionsOutput$transactions' => '<p>The array of transactions returned by the request.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The resource passed is invalid.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>The resource passed is invalid.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The container for the <code>fieldList</code> of the exception.</p>', ], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$reason' => '<p>The container for the reason for the exception</p>', ], ], 'VoutFilter' => [ 'base' => '<p>This container specifies filtering attributes related to <code>BITCOIN_VOUT</code> event types</p>', 'refs' => [ 'ListFilteredTransactionEventsInput$voutFilter' => '<p>This container specifies filtering attributes related to BITCOIN_VOUT event types</p>', ], ], ],];
