<?php
// This file was auto-generated from sdk-root/src/data/managedblockchain/2018-09-24/docs-2.json
return [ 'version' => '2.0', 'service' => '<p/> <p>Amazon Managed Blockchain is a fully managed service for creating and managing blockchain networks using open-source frameworks. Blockchain allows you to build applications where multiple parties can securely and transparently run transactions and share data without the need for a trusted, central authority.</p> <p>Managed Blockchain supports the Hyperledger Fabric and Ethereum open-source frameworks. Because of fundamental differences between the frameworks, some API actions or data types may only apply in the context of one framework and not the other. For example, actions related to Hyperledger Fabric network members such as <code>CreateMember</code> and <code>DeleteMember</code> don\'t apply to Ethereum.</p> <p>The description for each action indicates the framework or frameworks to which it applies. Data types and properties that apply only in the context of a particular framework are similarly indicated.</p>', 'operations' => [ 'CreateAccessor' => '<p>Creates a new accessor for use with Amazon Managed Blockchain service that supports token based access. The accessor contains information required for token based access.</p>', 'CreateMember' => '<p>Creates a member within a Managed Blockchain network.</p> <p>Applies only to Hyperledger Fabric.</p>', 'CreateNetwork' => '<p>Creates a new blockchain network using Amazon Managed Blockchain.</p> <p>Applies only to Hyperledger Fabric.</p>', 'CreateNode' => '<p>Creates a node on the specified blockchain network.</p> <p>Applies to Hyperledger Fabric and Ethereum.</p>', 'CreateProposal' => '<p>Creates a proposal for a change to the network that other members of the network can vote on, for example, a proposal to add a new member to the network. Any member can create a proposal.</p> <p>Applies only to Hyperledger Fabric.</p>', 'DeleteAccessor' => '<p>Deletes an accessor that your Amazon Web Services account owns. An accessor object is a container that has the information required for token based access to your Ethereum nodes including, the <code>BILLING_TOKEN</code>. After an accessor is deleted, the status of the accessor changes from <code>AVAILABLE</code> to <code>PENDING_DELETION</code>. An accessor in the <code>PENDING_DELETION</code> state can’t be used for new WebSocket requests or HTTP requests. However, WebSocket connections that were initiated while the accessor was in the <code>AVAILABLE</code> state remain open until they expire (up to 2 hours).</p>', 'DeleteMember' => '<p>Deletes a member. Deleting a member removes the member and all associated resources from the network. <code>DeleteMember</code> can only be called for a specified <code>MemberId</code> if the principal performing the action is associated with the Amazon Web Services account that owns the member. In all other cases, the <code>DeleteMember</code> action is carried out as the result of an approved proposal to remove a member. If <code>MemberId</code> is the last member in a network specified by the last Amazon Web Services account, the network is deleted also.</p> <p>Applies only to Hyperledger Fabric.</p>', 'DeleteNode' => '<p>Deletes a node that your Amazon Web Services account owns. All data on the node is lost and cannot be recovered.</p> <p>Applies to Hyperledger Fabric and Ethereum.</p>', 'GetAccessor' => '<p>Returns detailed information about an accessor. An accessor object is a container that has the information required for token based access to your Ethereum nodes.</p>', 'GetMember' => '<p>Returns detailed information about a member.</p> <p>Applies only to Hyperledger Fabric.</p>', 'GetNetwork' => '<p>Returns detailed information about a network.</p> <p>Applies to Hyperledger Fabric and Ethereum.</p>', 'GetNode' => '<p>Returns detailed information about a node.</p> <p>Applies to Hyperledger Fabric and Ethereum.</p>', 'GetProposal' => '<p>Returns detailed information about a proposal.</p> <p>Applies only to Hyperledger Fabric.</p>', 'ListAccessors' => '<p>Returns a list of the accessors and their properties. Accessor objects are containers that have the information required for token based access to your Ethereum nodes.</p>', 'ListInvitations' => '<p>Returns a list of all invitations for the current Amazon Web Services account.</p> <p>Applies only to Hyperledger Fabric.</p>', 'ListMembers' => '<p>Returns a list of the members in a network and properties of their configurations.</p> <p>Applies only to Hyperledger Fabric.</p>', 'ListNetworks' => '<p>Returns information about the networks in which the current Amazon Web Services account participates.</p> <p>Applies to Hyperledger Fabric and Ethereum.</p>', 'ListNodes' => '<p>Returns information about the nodes within a network.</p> <p>Applies to Hyperledger Fabric and Ethereum.</p>', 'ListProposalVotes' => '<p>Returns the list of votes for a specified proposal, including the value of each vote and the unique identifier of the member that cast the vote.</p> <p>Applies only to Hyperledger Fabric.</p>', 'ListProposals' => '<p>Returns a list of proposals for the network.</p> <p>Applies only to Hyperledger Fabric.</p>', 'ListTagsForResource' => '<p>Returns a list of tags for the specified resource. Each tag consists of a key and optional value.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'RejectInvitation' => '<p>Rejects an invitation to join a network. This action can be called by a principal in an Amazon Web Services account that has received an invitation to create a member and join a network.</p> <p>Applies only to Hyperledger Fabric.</p>', 'TagResource' => '<p>Adds or overwrites the specified tags for the specified Amazon Managed Blockchain resource. Each tag consists of a key and optional value.</p> <p>When you specify a tag key that already exists, the tag value is overwritten with the new value. Use <code>UntagResource</code> to remove tag keys.</p> <p>A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'UntagResource' => '<p>Removes the specified tags from the Amazon Managed Blockchain resource.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'UpdateMember' => '<p>Updates a member configuration with new parameters.</p> <p>Applies only to Hyperledger Fabric.</p>', 'UpdateNode' => '<p>Updates a node configuration with new parameters.</p> <p>Applies only to Hyperledger Fabric.</p>', 'VoteOnProposal' => '<p>Casts a vote for a specified <code>ProposalId</code> on behalf of a member. The member to vote as, specified by <code>VoterMemberId</code>, must be in the same Amazon Web Services account as the principal that calls the action.</p> <p>Applies only to Hyperledger Fabric.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You don\'t have sufficient access to perform this action.</p>', 'refs' => [], ], 'Accessor' => [ 'base' => '<p>The properties of the Accessor.</p>', 'refs' => [ 'GetAccessorOutput$Accessor' => '<p>The properties of the accessor.</p>', ], ], 'AccessorBillingTokenString' => [ 'base' => NULL, 'refs' => [ 'Accessor$BillingToken' => '<p>The billing token is a property of the Accessor. Use this token to when making calls to the blockchain network. The billing token is used to track your accessor token for billing requests.</p>', 'CreateAccessorOutput$BillingToken' => '<p>The billing token is a property of the Accessor. Use this token to when making calls to the blockchain network. The billing token is used to track your accessor token for billing requests.</p>', ], ], 'AccessorListMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAccessorsInput$MaxResults' => '<p> The maximum number of accessors to list.</p>', ], ], 'AccessorNetworkType' => [ 'base' => NULL, 'refs' => [ 'Accessor$NetworkType' => '<p>The blockchain network that the Accessor token is created for.</p>', 'AccessorSummary$NetworkType' => '<p>The blockchain network that the Accessor token is created for.</p>', 'CreateAccessorInput$NetworkType' => '<p>The blockchain network that the <code>Accessor</code> token is created for.</p> <note> <ul> <li> <p>Use the actual <code>networkType</code> value for the blockchain network that you are creating the <code>Accessor</code> token for.</p> </li> <li> <p>With the shut down of the <i>Ethereum Goerli</i> and <i>Polygon Mumbai Testnet</i> networks the following <code>networkType</code> values are no longer available for selection and use.</p> <ul> <li> <p> <code>ETHEREUM_MAINNET_AND_GOERLI</code> </p> </li> <li> <p> <code>ETHEREUM_GOERLI</code> </p> </li> <li> <p> <code>POLYGON_MUMBAI</code> </p> </li> </ul> <p>However, your existing <code>Accessor</code> tokens with these <code>networkType</code> values will remain unchanged.</p> </li> </ul> </note>', 'CreateAccessorOutput$NetworkType' => '<p>The blockchain network that the accessor token is created for.</p>', 'ListAccessorsInput$NetworkType' => '<p>The blockchain network that the <code>Accessor</code> token is created for.</p> <note> <p>Use the value <code>ETHEREUM_MAINNET_AND_GOERLI</code> for all existing <code>Accessors</code> tokens that were created before the <code>networkType</code> property was introduced.</p> </note>', ], ], 'AccessorStatus' => [ 'base' => NULL, 'refs' => [ 'Accessor$Status' => '<p>The current status of the accessor.</p>', 'AccessorSummary$Status' => '<p>The current status of the accessor.</p>', ], ], 'AccessorSummary' => [ 'base' => '<p>A summary of accessor properties.</p>', 'refs' => [ 'AccessorSummaryList$member' => NULL, ], ], 'AccessorSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAccessorsOutput$Accessors' => '<p>An array of AccessorSummary objects that contain configuration properties for each accessor.</p>', ], ], 'AccessorType' => [ 'base' => NULL, 'refs' => [ 'Accessor$Type' => '<p>The type of the accessor.</p> <note> <p>Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.</p> </note>', 'AccessorSummary$Type' => '<p>The type of the accessor.</p> <note> <p>Currently accessor type is restricted to <code>BILLING_TOKEN</code>.</p> </note>', 'CreateAccessorInput$AccessorType' => '<p>The type of accessor.</p> <note> <p>Currently, accessor type is restricted to <code>BILLING_TOKEN</code>.</p> </note>', ], ], 'ApprovalThresholdPolicy' => [ 'base' => '<p>A policy type that defines the voting rules for the network. The rules decide if a proposal is approved. Approval may be based on criteria such as the percentage of <code>YES</code> votes and the duration of the proposal. The policy applies to all proposals and is specified when the network is created.</p> <p>Applies only to Hyperledger Fabric.</p>', 'refs' => [ 'VotingPolicy$ApprovalThresholdPolicy' => '<p>Defines the rules for the network for voting on proposals, such as the percentage of <code>YES</code> votes required for the proposal to be approved and the duration of the proposal. The policy applies to all proposals and is specified when the network is created.</p>', ], ], 'ArnString' => [ 'base' => NULL, 'refs' => [ 'Accessor$Arn' => '<p>The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'AccessorSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the accessor. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'Invitation$Arn' => '<p>The Amazon Resource Name (ARN) of the invitation. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'Member$Arn' => '<p>The Amazon Resource Name (ARN) of the member. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'MemberConfiguration$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the customer managed key in Key Management Service (KMS) to use for encryption at rest in the member. This parameter is inherited by any nodes that this member creates. For more information, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/managed-blockchain-encryption-at-rest.html">Encryption at Rest</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p> <p>Use one of the following options to specify this parameter:</p> <ul> <li> <p> <b>Undefined or empty string</b> - By default, use an KMS key that is owned and managed by Amazon Web Services on your behalf.</p> </li> <li> <p> <b>A valid symmetric customer managed KMS key</b> - Use the specified KMS key in your account that you create, own, and manage.</p> <p>Amazon Managed Blockchain doesn\'t support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys</a> in the <i>Key Management Service Developer Guide</i>.</p> <p>The following is an example of a KMS key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> </p> </li> </ul>', 'MemberSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the member. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'Network$Arn' => '<p>The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'NetworkSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the network. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'Node$Arn' => '<p>The Amazon Resource Name (ARN) of the node. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'NodeSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the node. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'Proposal$Arn' => '<p>The Amazon Resource Name (ARN) of the proposal. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ProposalSummary$Arn' => '<p>The Amazon Resource Name (ARN) of the proposal. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'ResourceNotFoundException$ResourceName' => '<p>A requested resource doesn\'t exist. It may have been deleted or referenced inaccurately.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', 'TooManyTagsException$ResourceName' => '<p/>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource. For more information about ARNs and their format, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)</a> in the <i>Amazon Web Services General Reference</i>.</p>', ], ], 'AvailabilityZoneString' => [ 'base' => NULL, 'refs' => [ 'Node$AvailabilityZone' => '<p>The Availability Zone in which the node exists. Required for Ethereum nodes. </p>', 'NodeConfiguration$AvailabilityZone' => '<p>The Availability Zone in which the node exists. Required for Ethereum nodes. </p>', 'NodeSummary$AvailabilityZone' => '<p>The Availability Zone in which the node exists.</p>', ], ], 'ClientRequestTokenString' => [ 'base' => NULL, 'refs' => [ 'CreateAccessorInput$ClientRequestToken' => '<p>This is a unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than once. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the Amazon Web Services CLI.</p>', 'CreateMemberInput$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the CLI.</p>', 'CreateNetworkInput$ClientRequestToken' => '<p>This is a unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than once. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the Amazon Web Services CLI. </p>', 'CreateNodeInput$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the CLI.</p>', 'CreateProposalInput$ClientRequestToken' => '<p>A unique, case-sensitive identifier that you provide to ensure the idempotency of the operation. An idempotent operation completes no more than one time. This identifier is required only if you make a service request directly using an HTTP client. It is generated automatically if you use an Amazon Web Services SDK or the CLI.</p>', ], ], 'CreateAccessorInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessorOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMemberInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMemberOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNetworkOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNodeInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateNodeOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProposalInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProposalOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessorInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessorOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMemberInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMemberOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNodeInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNodeOutput' => [ 'base' => NULL, 'refs' => [], ], 'DescriptionString' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkInput$Description' => '<p>An optional description for the network.</p>', 'CreateProposalInput$Description' => '<p>A description for the proposal that is visible to voting members, for example, "Proposal to add Example Corp. as member."</p>', 'Member$Description' => '<p>An optional description for the member.</p>', 'MemberConfiguration$Description' => '<p>An optional description of the member.</p>', 'MemberSummary$Description' => '<p>An optional description of the member.</p>', 'Network$Description' => '<p>Attributes of the blockchain framework for the network.</p>', 'NetworkSummary$Description' => '<p>An optional description of the network.</p>', 'Proposal$Description' => '<p>The description of the proposal.</p>', 'ProposalSummary$Description' => '<p> The description of the proposal. </p>', ], ], 'Edition' => [ 'base' => NULL, 'refs' => [ 'NetworkFabricAttributes$Edition' => '<p>The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more information, see <a href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.</p>', 'NetworkFabricConfiguration$Edition' => '<p>The edition of Amazon Managed Blockchain that the network uses. For more information, see <a href="http://aws.amazon.com/managed-blockchain/pricing/">Amazon Managed Blockchain Pricing</a>.</p>', ], ], 'Enabled' => [ 'base' => NULL, 'refs' => [ 'LogConfiguration$Enabled' => '<p>Indicates whether logging is enabled.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'TooManyTagsException$Message' => NULL, ], ], 'Framework' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkInput$Framework' => '<p>The blockchain framework that the network uses.</p>', 'ListNetworksInput$Framework' => '<p>An optional framework specifier. If provided, only networks of this framework type are listed.</p>', 'Network$Framework' => '<p>The blockchain framework that the network uses.</p>', 'NetworkSummary$Framework' => '<p>The blockchain framework that the network uses.</p>', ], ], 'FrameworkVersionString' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkInput$FrameworkVersion' => '<p>The version of the blockchain framework that the network uses.</p>', 'Network$FrameworkVersion' => '<p>The version of the blockchain framework that the network uses.</p>', 'NetworkSummary$FrameworkVersion' => '<p>The version of the blockchain framework that the network uses.</p>', ], ], 'GetAccessorInput' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessorOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetMemberInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMemberOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkInput' => [ 'base' => NULL, 'refs' => [], ], 'GetNetworkOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetNodeInput' => [ 'base' => NULL, 'refs' => [], ], 'GetNodeOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetProposalInput' => [ 'base' => NULL, 'refs' => [], ], 'GetProposalOutput' => [ 'base' => NULL, 'refs' => [], ], 'IllegalActionException' => [ 'base' => '<p/>', 'refs' => [], ], 'InputTagMap' => [ 'base' => NULL, 'refs' => [ 'CreateAccessorInput$Tags' => '<p>Tags to assign to the Accessor.</p> <p> Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single request with an overall maximum of 50 tags allowed per resource.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'CreateNetworkInput$Tags' => '<p>Tags to assign to the network.</p> <p> Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single request with an overall maximum of 50 tags allowed per resource.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'CreateNodeInput$Tags' => '<p>Tags to assign to the node.</p> <p> Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single request with an overall maximum of 50 tags allowed per resource.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'CreateProposalInput$Tags' => '<p>Tags to assign to the proposal.</p> <p> Each tag consists of a key and an optional value. You can specify multiple key-value pairs in a single request with an overall maximum of 50 tags allowed per resource.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'MemberConfiguration$Tags' => '<p>Tags assigned to the member. Tags consist of a key and optional value. </p> <p>When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'TagResourceRequest$Tags' => '<p>The tags to assign to the specified resource. Tag values can be empty, for example, <code>"MyTagKey" : ""</code>. You can specify multiple key-value pairs in a single request, with an overall maximum of 50 tags added to each resource.</p>', ], ], 'InstanceTypeString' => [ 'base' => NULL, 'refs' => [ 'Node$InstanceType' => '<p>The instance type of the node.</p>', 'NodeConfiguration$InstanceType' => '<p>The Amazon Managed Blockchain instance type for the node.</p>', 'NodeSummary$InstanceType' => '<p>The EC2 instance type for the node.</p>', ], ], 'InternalServiceErrorException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure.</p>', 'refs' => [], ], 'InvalidRequestException' => [ 'base' => '<p>The action or operation requested is invalid. Verify that the action is typed correctly.</p>', 'refs' => [], ], 'Invitation' => [ 'base' => '<p>An invitation to an Amazon Web Services account to create a member and join the network.</p> <p>Applies only to Hyperledger Fabric.</p>', 'refs' => [ 'InvitationList$member' => NULL, ], ], 'InvitationList' => [ 'base' => NULL, 'refs' => [ 'ListInvitationsOutput$Invitations' => '<p>The invitations for the network.</p>', ], ], 'InvitationStatus' => [ 'base' => NULL, 'refs' => [ 'Invitation$Status' => '<p>The status of the invitation:</p> <ul> <li> <p> <code>PENDING</code> - The invitee hasn\'t created a member to join the network, and the invitation hasn\'t yet expired.</p> </li> <li> <p> <code>ACCEPTING</code> - The invitee has begun creating a member, and creation hasn\'t yet completed.</p> </li> <li> <p> <code>ACCEPTED</code> - The invitee created a member and joined the network using the <code>InvitationID</code>.</p> </li> <li> <p> <code>REJECTED</code> - The invitee rejected the invitation.</p> </li> <li> <p> <code>EXPIRED</code> - The invitee neither created a member nor rejected the invitation before the <code>ExpirationDate</code>.</p> </li> </ul>', ], ], 'InviteAction' => [ 'base' => '<p>An action to invite a specific Amazon Web Services account to create a member and join the network. The <code>InviteAction</code> is carried out when a <code>Proposal</code> is <code>APPROVED</code>.</p> <p>Applies only to Hyperledger Fabric.</p>', 'refs' => [ 'InviteActionList$member' => NULL, ], ], 'InviteActionList' => [ 'base' => NULL, 'refs' => [ 'ProposalActions$Invitations' => '<p> The actions to perform for an <code>APPROVED</code> proposal to invite an Amazon Web Services account to create a member and join the network. </p>', ], ], 'IsOwned' => [ 'base' => NULL, 'refs' => [ 'ListMembersInput$IsOwned' => '<p>An optional Boolean value. If provided, the request is limited either to members that the current Amazon Web Services account owns (<code>true</code>) or that other Amazon Web Services accountsn own (<code>false</code>). If omitted, all members are listed.</p>', 'MemberSummary$IsOwned' => '<p>An indicator of whether the member is owned by your Amazon Web Services account or a different Amazon Web Services account.</p>', ], ], 'ListAccessorsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessorsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListInvitationsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListInvitationsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMembersOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListNetworksInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNetworksOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListNodesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListNodesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListProposalVotesInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProposalVotesOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListProposalsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListProposalsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogConfiguration' => [ 'base' => '<p>A configuration for logging events.</p>', 'refs' => [ 'LogConfigurations$Cloudwatch' => '<p>Parameters for publishing logs to Amazon CloudWatch Logs.</p>', ], ], 'LogConfigurations' => [ 'base' => '<p>A collection of log configurations.</p>', 'refs' => [ 'MemberFabricLogPublishingConfiguration$CaLogs' => '<p>Configuration properties for logging events associated with a member\'s Certificate Authority (CA). CA logs help you determine when a member in your account joins the network, or when new peers register with a member CA.</p>', 'NodeFabricLogPublishingConfiguration$ChaincodeLogs' => '<p>Configuration properties for logging events associated with chaincode execution on a peer node. Chaincode logs contain the results of instantiating, invoking, and querying the chaincode. A peer can run multiple instances of chaincode. When enabled, a log stream is created for all chaincodes, with an individual log stream for each chaincode.</p>', 'NodeFabricLogPublishingConfiguration$PeerLogs' => '<p>Configuration properties for a peer node log. Peer node logs contain messages generated when your client submits transaction proposals to peer nodes, requests to join channels, enrolls an admin peer, and lists the chaincode instances on a peer node. </p>', ], ], 'Member' => [ 'base' => '<p>Member configuration properties.</p> <p>Applies only to Hyperledger Fabric.</p>', 'refs' => [ 'GetMemberOutput$Member' => '<p>The properties of a member.</p>', ], ], 'MemberConfiguration' => [ 'base' => '<p>Configuration properties of the member.</p> <p>Applies only to Hyperledger Fabric.</p>', 'refs' => [ 'CreateMemberInput$MemberConfiguration' => '<p>Member configuration parameters.</p>', 'CreateNetworkInput$MemberConfiguration' => '<p>Configuration properties for the first member within the network.</p>', ], ], 'MemberFabricAttributes' => [ 'base' => '<p>Attributes of Hyperledger Fabric for a member in a Managed Blockchain network using the Hyperledger Fabric framework.</p>', 'refs' => [ 'MemberFrameworkAttributes$Fabric' => '<p>Attributes of Hyperledger Fabric relevant to a member on a Managed Blockchain network that uses Hyperledger Fabric.</p>', ], ], 'MemberFabricConfiguration' => [ 'base' => '<p>Configuration properties for Hyperledger Fabric for a member in a Managed Blockchain network that is using the Hyperledger Fabric framework.</p>', 'refs' => [ 'MemberFrameworkConfiguration$Fabric' => '<p>Attributes of Hyperledger Fabric for a member on a Managed Blockchain network that uses Hyperledger Fabric.</p>', ], ], 'MemberFabricLogPublishingConfiguration' => [ 'base' => '<p>Configuration properties for logging events associated with a member of a Managed Blockchain network using the Hyperledger Fabric framework.</p>', 'refs' => [ 'MemberLogPublishingConfiguration$Fabric' => '<p>Configuration properties for logging events associated with a member of a Managed Blockchain network using the Hyperledger Fabric framework.</p>', ], ], 'MemberFrameworkAttributes' => [ 'base' => '<p>Attributes relevant to a member for the blockchain framework that the Managed Blockchain network uses.</p>', 'refs' => [ 'Member$FrameworkAttributes' => '<p>Attributes relevant to a member for the blockchain framework that the Managed Blockchain network uses.</p>', ], ], 'MemberFrameworkConfiguration' => [ 'base' => '<p>Configuration properties relevant to a member for the blockchain framework that the Managed Blockchain network uses.</p>', 'refs' => [ 'MemberConfiguration$FrameworkConfiguration' => '<p>Configuration properties of the blockchain framework relevant to the member.</p>', ], ], 'MemberListMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListMembersInput$MaxResults' => '<p>The maximum number of members to return in the request.</p>', ], ], 'MemberLogPublishingConfiguration' => [ 'base' => '<p>Configuration properties for logging events associated with a member of a Managed Blockchain network.</p>', 'refs' => [ 'Member$LogPublishingConfiguration' => '<p>Configuration properties for logging events associated with a member.</p>', 'MemberConfiguration$LogPublishingConfiguration' => '<p>Configuration properties for logging events associated with a member of a Managed Blockchain network.</p>', 'UpdateMemberInput$LogPublishingConfiguration' => '<p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>', ], ], 'MemberStatus' => [ 'base' => NULL, 'refs' => [ 'ListMembersInput$Status' => '<p>An optional status specifier. If provided, only members currently in this status are listed.</p>', 'Member$Status' => '<p>The status of a member.</p> <ul> <li> <p> <code>CREATING</code> - The Amazon Web Services account is in the process of creating a member.</p> </li> <li> <p> <code>AVAILABLE</code> - The member has been created and can participate in the network.</p> </li> <li> <p> <code>CREATE_FAILED</code> - The Amazon Web Services account attempted to create a member and creation failed.</p> </li> <li> <p> <code>UPDATING</code> - The member is in the process of being updated.</p> </li> <li> <p> <code>DELETING</code> - The member and all associated resources are in the process of being deleted. Either the Amazon Web Services account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.</p> </li> <li> <p> <code>DELETED</code> - The member can no longer participate on the network and all associated resources are deleted. Either the Amazon Web Services account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.</p> </li> <li> <p> <code>INACCESSIBLE_ENCRYPTION_KEY</code> - The member is impaired and might not function as expected because it cannot access the specified customer managed key in KMS for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.</p> <p>The effect of disabling or deleting a key or of revoking a grant isn\'t immediate. It might take some time for the member resource to discover that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.</p> </li> </ul>', 'MemberSummary$Status' => '<p>The status of the member.</p> <ul> <li> <p> <code>CREATING</code> - The Amazon Web Services account is in the process of creating a member.</p> </li> <li> <p> <code>AVAILABLE</code> - The member has been created and can participate in the network.</p> </li> <li> <p> <code>CREATE_FAILED</code> - The Amazon Web Services account attempted to create a member and creation failed.</p> </li> <li> <p> <code>UPDATING</code> - The member is in the process of being updated.</p> </li> <li> <p> <code>DELETING</code> - The member and all associated resources are in the process of being deleted. Either the Amazon Web Services account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.</p> </li> <li> <p> <code>DELETED</code> - The member can no longer participate on the network and all associated resources are deleted. Either the Amazon Web Services account that owns the member deleted it, or the member is being deleted as the result of an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.</p> </li> <li> <p> <code>INACCESSIBLE_ENCRYPTION_KEY</code> - The member is impaired and might not function as expected because it cannot access the specified customer managed key in Key Management Service (KMS) for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.</p> <p>The effect of disabling or deleting a key or of revoking a grant isn\'t immediate. It might take some time for the member resource to discover that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.</p> </li> </ul>', ], ], 'MemberSummary' => [ 'base' => '<p>A summary of configuration properties for a member.</p> <p>Applies only to Hyperledger Fabric.</p>', 'refs' => [ 'MemberSummaryList$member' => NULL, ], ], 'MemberSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListMembersOutput$Members' => '<p>An array of <code>MemberSummary</code> objects. Each object contains details about a network member.</p>', ], ], 'NameString' => [ 'base' => NULL, 'refs' => [ 'CreateNetworkInput$Name' => '<p>The name of the network.</p>', 'Network$Name' => '<p>The name of the network.</p>', 'NetworkSummary$Name' => '<p>The name of the network.</p>', ], ], 'Network' => [ 'base' => '<p>Network configuration properties.</p>', 'refs' => [ 'GetNetworkOutput$Network' => '<p>An object containing network configuration parameters.</p>', ], ], 'NetworkEthereumAttributes' => [ 'base' => '<p>Attributes of Ethereum for a network. </p>', 'refs' => [ 'NetworkFrameworkAttributes$Ethereum' => '<p>Attributes of an Ethereum network for Managed Blockchain resources participating in an Ethereum network. </p>', ], ], 'NetworkFabricAttributes' => [ 'base' => '<p>Attributes of Hyperledger Fabric for a network.</p>', 'refs' => [ 'NetworkFrameworkAttributes$Fabric' => '<p>Attributes of Hyperledger Fabric for a Managed Blockchain network that uses Hyperledger Fabric.</p>', ], ], 'NetworkFabricConfiguration' => [ 'base' => '<p>Hyperledger Fabric configuration properties for the network.</p>', 'refs' => [ 'NetworkFrameworkConfiguration$Fabric' => '<p> Hyperledger Fabric configuration properties for a Managed Blockchain network that uses Hyperledger Fabric. </p>', ], ], 'NetworkFrameworkAttributes' => [ 'base' => '<p>Attributes relevant to the network for the blockchain framework that the network uses.</p>', 'refs' => [ 'Network$FrameworkAttributes' => '<p>Attributes of the blockchain framework that the network uses.</p>', ], ], 'NetworkFrameworkConfiguration' => [ 'base' => '<p> Configuration properties relevant to the network for the blockchain framework that the network uses. </p>', 'refs' => [ 'CreateNetworkInput$FrameworkConfiguration' => '<p> Configuration properties of the blockchain framework relevant to the network configuration. </p>', ], ], 'NetworkListMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListNetworksInput$MaxResults' => '<p>The maximum number of networks to list.</p>', ], ], 'NetworkMemberNameString' => [ 'base' => NULL, 'refs' => [ 'Member$Name' => '<p>The name of the member.</p>', 'MemberConfiguration$Name' => '<p>The name of the member.</p>', 'MemberSummary$Name' => '<p>The name of the member.</p>', 'Proposal$ProposedByMemberName' => '<p>The name of the member that created the proposal.</p>', 'ProposalSummary$ProposedByMemberName' => '<p> The name of the member that created the proposal. </p>', 'VoteSummary$MemberName' => '<p> The name of the member that cast the vote. </p>', ], ], 'NetworkStatus' => [ 'base' => NULL, 'refs' => [ 'ListNetworksInput$Status' => '<p>An optional status specifier. If provided, only networks currently in this status are listed.</p> <p>Applies only to Hyperledger Fabric.</p>', 'Network$Status' => '<p>The current status of the network.</p>', 'NetworkSummary$Status' => '<p>The current status of the network.</p>', ], ], 'NetworkSummary' => [ 'base' => '<p>A summary of network configuration properties.</p>', 'refs' => [ 'Invitation$NetworkSummary' => NULL, 'NetworkSummaryList$member' => NULL, ], ], 'NetworkSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListNetworksOutput$Networks' => '<p>An array of <code>NetworkSummary</code> objects that contain configuration properties for each network.</p>', ], ], 'Node' => [ 'base' => '<p>Configuration properties of a node.</p>', 'refs' => [ 'GetNodeOutput$Node' => '<p>Properties of the node configuration.</p>', ], ], 'NodeConfiguration' => [ 'base' => '<p>Configuration properties of a node.</p>', 'refs' => [ 'CreateNodeInput$NodeConfiguration' => '<p>The properties of a node configuration.</p>', ], ], 'NodeEthereumAttributes' => [ 'base' => '<p>Attributes of an Ethereum node.</p>', 'refs' => [ 'NodeFrameworkAttributes$Ethereum' => '<p>Attributes of Ethereum for a node on a Managed Blockchain network that uses Ethereum. </p>', ], ], 'NodeFabricAttributes' => [ 'base' => '<p>Attributes of Hyperledger Fabric for a peer node on a Hyperledger Fabric network on Managed Blockchain.</p>', 'refs' => [ 'NodeFrameworkAttributes$Fabric' => '<p>Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain network that uses Hyperledger Fabric.</p>', ], ], 'NodeFabricLogPublishingConfiguration' => [ 'base' => '<p>Configuration properties for logging events associated with a peer node owned by a member in a Managed Blockchain network.</p>', 'refs' => [ 'NodeLogPublishingConfiguration$Fabric' => '<p>Configuration properties for logging events associated with a node that is owned by a member of a Managed Blockchain network using the Hyperledger Fabric framework.</p>', ], ], 'NodeFrameworkAttributes' => [ 'base' => '<p>Attributes relevant to a node on a Managed Blockchain network for the blockchain framework that the network uses.</p>', 'refs' => [ 'Node$FrameworkAttributes' => '<p>Attributes of the blockchain framework being used.</p>', ], ], 'NodeListMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListNodesInput$MaxResults' => '<p>The maximum number of nodes to list.</p>', ], ], 'NodeLogPublishingConfiguration' => [ 'base' => '<p>Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.</p>', 'refs' => [ 'Node$LogPublishingConfiguration' => '<p>Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain.</p>', 'NodeConfiguration$LogPublishingConfiguration' => '<p>Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on Managed Blockchain. </p>', 'UpdateNodeInput$LogPublishingConfiguration' => '<p>Configuration properties for publishing to Amazon CloudWatch Logs.</p>', ], ], 'NodeStatus' => [ 'base' => NULL, 'refs' => [ 'ListNodesInput$Status' => '<p>An optional status specifier. If provided, only nodes currently in this status are listed.</p>', 'Node$Status' => '<p>The status of the node.</p> <ul> <li> <p> <code>CREATING</code> - The Amazon Web Services account is in the process of creating a node.</p> </li> <li> <p> <code>AVAILABLE</code> - The node has been created and can participate in the network.</p> </li> <li> <p> <code>UNHEALTHY</code> - The node is impaired and might not function as expected. Amazon Managed Blockchain automatically finds nodes in this state and tries to recover them. If a node is recoverable, it returns to <code>AVAILABLE</code>. Otherwise, it moves to <code>FAILED</code> status.</p> </li> <li> <p> <code>CREATE_FAILED</code> - The Amazon Web Services account attempted to create a node and creation failed.</p> </li> <li> <p> <code>UPDATING</code> - The node is in the process of being updated.</p> </li> <li> <p> <code>DELETING</code> - The node is in the process of being deleted.</p> </li> <li> <p> <code>DELETED</code> - The node can no longer participate on the network.</p> </li> <li> <p> <code>FAILED</code> - The node is no longer functional, cannot be recovered, and must be deleted.</p> </li> <li> <p> <code>INACCESSIBLE_ENCRYPTION_KEY</code> - The node is impaired and might not function as expected because it cannot access the specified customer managed key in KMS for encryption at rest. Either the KMS key was disabled or deleted, or the grants on the key were revoked.</p> <p>The effect of disabling or deleting a key or of revoking a grant isn\'t immediate. It might take some time for the node resource to discover that the key is inaccessible. When a resource is in this state, we recommend deleting and recreating the resource.</p> </li> </ul>', 'NodeSummary$Status' => '<p>The status of the node.</p>', ], ], 'NodeSummary' => [ 'base' => '<p>A summary of configuration properties for a node.</p>', 'refs' => [ 'NodeSummaryList$member' => NULL, ], ], 'NodeSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListNodesOutput$Nodes' => '<p>An array of <code>NodeSummary</code> objects that contain configuration properties for each node.</p>', ], ], 'OutputTagMap' => [ 'base' => NULL, 'refs' => [ 'Accessor$Tags' => '<p>The tags assigned to the Accessor.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags assigned to the resource.</p>', 'Member$Tags' => '<p>Tags assigned to the member. Tags consist of a key and optional value.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'Network$Tags' => '<p>Tags assigned to the network. Each tag consists of a key and optional value.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'Node$Tags' => '<p>Tags assigned to the node. Each tag consists of a key and optional value.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'Proposal$Tags' => '<p>Tags assigned to the proposal. Each tag consists of a key and optional value.</p> <p>For more information about tags, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Ethereum Developer Guide</i>, or <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListAccessorsInput$NextToken' => '<p> The pagination token that indicates the next set of results to retrieve. </p>', 'ListAccessorsOutput$NextToken' => '<p> The pagination token that indicates the next set of results to retrieve. </p>', 'ListInvitationsInput$NextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListInvitationsOutput$NextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListMembersInput$NextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListMembersOutput$NextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListNetworksInput$NextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListNetworksOutput$NextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListNodesInput$NextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListNodesOutput$NextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', 'ListProposalVotesInput$NextToken' => '<p> The pagination token that indicates the next set of results to retrieve. </p>', 'ListProposalVotesOutput$NextToken' => '<p> The pagination token that indicates the next set of results to retrieve. </p>', 'ListProposalsInput$NextToken' => '<p> The pagination token that indicates the next set of results to retrieve. </p>', 'ListProposalsOutput$NextToken' => '<p>The pagination token that indicates the next set of results to retrieve.</p>', ], ], 'PasswordString' => [ 'base' => NULL, 'refs' => [ 'MemberFabricConfiguration$AdminPassword' => '<p>The password for the member\'s initial administrative user. The <code>AdminPassword</code> must be at least 8 characters long and no more than 32 characters. It must contain at least one uppercase letter, one lowercase letter, and one digit. It cannot have a single quotation mark (‘), a double quotation marks (“), a forward slash(/), a backward slash(\\), @, or a space.</p>', ], ], 'PrincipalString' => [ 'base' => NULL, 'refs' => [ 'InviteAction$Principal' => '<p>The Amazon Web Services account ID to invite.</p>', ], ], 'Proposal' => [ 'base' => '<p>Properties of a proposal on a Managed Blockchain network.</p> <p>Applies only to Hyperledger Fabric.</p>', 'refs' => [ 'GetProposalOutput$Proposal' => '<p>Information about a proposal.</p>', ], ], 'ProposalActions' => [ 'base' => '<p> The actions to carry out if a proposal is <code>APPROVED</code>. </p> <p>Applies only to Hyperledger Fabric.</p>', 'refs' => [ 'CreateProposalInput$Actions' => '<p>The type of actions proposed, such as inviting a member or removing a member. The types of <code>Actions</code> in a proposal are mutually exclusive. For example, a proposal with <code>Invitations</code> actions cannot also contain <code>Removals</code> actions.</p>', 'Proposal$Actions' => '<p>The actions to perform on the network if the proposal is <code>APPROVED</code>.</p>', ], ], 'ProposalDurationInt' => [ 'base' => NULL, 'refs' => [ 'ApprovalThresholdPolicy$ProposalDurationInHours' => '<p>The duration from the time that a proposal is created until it expires. If members cast neither the required number of <code>YES</code> votes to approve the proposal nor the number of <code>NO</code> votes required to reject it before the duration expires, the proposal is <code>EXPIRED</code> and <code>ProposalActions</code> aren\'t carried out.</p>', ], ], 'ProposalListMaxResults' => [ 'base' => NULL, 'refs' => [ 'ListInvitationsInput$MaxResults' => '<p>The maximum number of invitations to return.</p>', 'ListProposalVotesInput$MaxResults' => '<p> The maximum number of votes to return. </p>', 'ListProposalsInput$MaxResults' => '<p> The maximum number of proposals to return. </p>', ], ], 'ProposalStatus' => [ 'base' => NULL, 'refs' => [ 'Proposal$Status' => '<p>The status of the proposal. Values are as follows:</p> <ul> <li> <p> <code>IN_PROGRESS</code> - The proposal is active and open for member voting.</p> </li> <li> <p> <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal actions are carried out.</p> </li> <li> <p> <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified <code>ProposalActions</code> aren\'t carried out.</p> </li> <li> <p> <code>EXPIRED</code> - Members didn\'t cast the number of votes required to determine the proposal outcome before the proposal expired. The specified <code>ProposalActions</code> aren\'t carried out.</p> </li> <li> <p> <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that was approved couldn\'t be completed because of an error. The <code>ACTION_FAILED</code> status occurs even if only one ProposalAction fails and other actions are successful.</p> </li> </ul>', 'ProposalSummary$Status' => '<p>The status of the proposal. Values are as follows:</p> <ul> <li> <p> <code>IN_PROGRESS</code> - The proposal is active and open for member voting.</p> </li> <li> <p> <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal actions are carried out.</p> </li> <li> <p> <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified <code>ProposalActions</code> aren\'t carried out.</p> </li> <li> <p> <code>EXPIRED</code> - Members didn\'t cast the number of votes required to determine the proposal outcome before the proposal expired. The specified <code>ProposalActions</code> aren\'t carried out.</p> </li> <li> <p> <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that was approved couldn\'t be completed because of an error.</p> </li> </ul>', ], ], 'ProposalSummary' => [ 'base' => '<p>Properties of a proposal.</p> <p>Applies only to Hyperledger Fabric.</p>', 'refs' => [ 'ProposalSummaryList$member' => NULL, ], ], 'ProposalSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListProposalsOutput$Proposals' => '<p>The summary of each proposal made on the network.</p>', ], ], 'ProposalVoteList' => [ 'base' => NULL, 'refs' => [ 'ListProposalVotesOutput$ProposalVotes' => '<p> The list of votes. </p>', ], ], 'RejectInvitationInput' => [ 'base' => NULL, 'refs' => [], ], 'RejectInvitationOutput' => [ 'base' => NULL, 'refs' => [], ], 'RemoveAction' => [ 'base' => '<p>An action to remove a member from a Managed Blockchain network as the result of a removal proposal that is <code>APPROVED</code>. The member and all associated resources are deleted from the network.</p> <p>Applies only to Hyperledger Fabric.</p>', 'refs' => [ 'RemoveActionList$member' => NULL, ], ], 'RemoveActionList' => [ 'base' => NULL, 'refs' => [ 'ProposalActions$Removals' => '<p> The actions to perform for an <code>APPROVED</code> proposal to remove a member from the network, which deletes the member and all associated member resources from the network. </p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>A resource request is issued for a resource that already exists.</p>', 'refs' => [], ], 'ResourceIdString' => [ 'base' => NULL, 'refs' => [ 'Accessor$Id' => '<p>The unique identifier of the accessor.</p>', 'AccessorSummary$Id' => '<p>The unique identifier of the accessor.</p>', 'CreateAccessorOutput$AccessorId' => '<p>The unique identifier of the accessor.</p>', 'CreateMemberInput$InvitationId' => '<p>The unique identifier of the invitation that is sent to the member to join the network.</p>', 'CreateMemberInput$NetworkId' => '<p>The unique identifier of the network in which the member is created.</p>', 'CreateMemberOutput$MemberId' => '<p>The unique identifier of the member.</p>', 'CreateNetworkOutput$NetworkId' => '<p>The unique identifier for the network.</p>', 'CreateNetworkOutput$MemberId' => '<p>The unique identifier for the first member within the network.</p>', 'CreateNodeInput$NetworkId' => '<p>The unique identifier of the network for the node.</p> <p>Ethereum public networks have the following <code>NetworkId</code>s:</p> <ul> <li> <p> <code>n-ethereum-mainnet</code> </p> </li> </ul>', 'CreateNodeInput$MemberId' => '<p>The unique identifier of the member that owns this node.</p> <p>Applies only to Hyperledger Fabric.</p>', 'CreateNodeOutput$NodeId' => '<p>The unique identifier of the node.</p>', 'CreateProposalInput$NetworkId' => '<p> The unique identifier of the network for which the proposal is made.</p>', 'CreateProposalInput$MemberId' => '<p>The unique identifier of the member that is creating the proposal. This identifier is especially useful for identifying the member making the proposal when multiple members exist in a single Amazon Web Services account.</p>', 'CreateProposalOutput$ProposalId' => '<p>The unique identifier of the proposal.</p>', 'DeleteAccessorInput$AccessorId' => '<p>The unique identifier of the accessor.</p>', 'DeleteMemberInput$NetworkId' => '<p>The unique identifier of the network from which the member is removed.</p>', 'DeleteMemberInput$MemberId' => '<p>The unique identifier of the member to remove.</p>', 'DeleteNodeInput$NetworkId' => '<p>The unique identifier of the network that the node is on.</p> <p>Ethereum public networks have the following <code>NetworkId</code>s:</p> <ul> <li> <p> <code>n-ethereum-mainnet</code> </p> </li> </ul>', 'DeleteNodeInput$MemberId' => '<p>The unique identifier of the member that owns this node.</p> <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>', 'DeleteNodeInput$NodeId' => '<p>The unique identifier of the node.</p>', 'GetAccessorInput$AccessorId' => '<p>The unique identifier of the accessor.</p>', 'GetMemberInput$NetworkId' => '<p>The unique identifier of the network to which the member belongs.</p>', 'GetMemberInput$MemberId' => '<p>The unique identifier of the member.</p>', 'GetNetworkInput$NetworkId' => '<p>The unique identifier of the network to get information about.</p>', 'GetNodeInput$NetworkId' => '<p>The unique identifier of the network that the node is on.</p>', 'GetNodeInput$MemberId' => '<p>The unique identifier of the member that owns the node.</p> <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>', 'GetNodeInput$NodeId' => '<p>The unique identifier of the node.</p>', 'GetProposalInput$NetworkId' => '<p>The unique identifier of the network for which the proposal is made.</p>', 'GetProposalInput$ProposalId' => '<p>The unique identifier of the proposal.</p>', 'Invitation$InvitationId' => '<p>The unique identifier for the invitation.</p>', 'ListMembersInput$NetworkId' => '<p>The unique identifier of the network for which to list members.</p>', 'ListNodesInput$NetworkId' => '<p>The unique identifier of the network for which to list nodes.</p>', 'ListNodesInput$MemberId' => '<p>The unique identifier of the member who owns the nodes to list.</p> <p>Applies only to Hyperledger Fabric and is required for Hyperledger Fabric.</p>', 'ListProposalVotesInput$NetworkId' => '<p> The unique identifier of the network. </p>', 'ListProposalVotesInput$ProposalId' => '<p> The unique identifier of the proposal. </p>', 'ListProposalsInput$NetworkId' => '<p> The unique identifier of the network. </p>', 'Member$NetworkId' => '<p>The unique identifier of the network to which the member belongs.</p>', 'Member$Id' => '<p>The unique identifier of the member.</p>', 'MemberSummary$Id' => '<p>The unique identifier of the member.</p>', 'Network$Id' => '<p>The unique identifier of the network.</p>', 'NetworkSummary$Id' => '<p>The unique identifier of the network.</p>', 'Node$NetworkId' => '<p>The unique identifier of the network that the node is on.</p>', 'Node$MemberId' => '<p>The unique identifier of the member to which the node belongs.</p> <p>Applies only to Hyperledger Fabric.</p>', 'Node$Id' => '<p>The unique identifier of the node.</p>', 'NodeSummary$Id' => '<p>The unique identifier of the node.</p>', 'Proposal$ProposalId' => '<p>The unique identifier of the proposal.</p>', 'Proposal$NetworkId' => '<p>The unique identifier of the network for which the proposal is made.</p>', 'Proposal$ProposedByMemberId' => '<p>The unique identifier of the member that created the proposal.</p>', 'ProposalSummary$ProposalId' => '<p> The unique identifier of the proposal. </p>', 'ProposalSummary$ProposedByMemberId' => '<p> The unique identifier of the member that created the proposal. </p>', 'RejectInvitationInput$InvitationId' => '<p>The unique identifier of the invitation to reject.</p>', 'RemoveAction$MemberId' => '<p>The unique identifier of the member to remove.</p>', 'UpdateMemberInput$NetworkId' => '<p>The unique identifier of the Managed Blockchain network to which the member belongs.</p>', 'UpdateMemberInput$MemberId' => '<p>The unique identifier of the member.</p>', 'UpdateNodeInput$NetworkId' => '<p>The unique identifier of the network that the node is on.</p>', 'UpdateNodeInput$MemberId' => '<p>The unique identifier of the member that owns the node.</p> <p>Applies only to Hyperledger Fabric.</p>', 'UpdateNodeInput$NodeId' => '<p>The unique identifier of the node.</p>', 'VoteOnProposalInput$NetworkId' => '<p> The unique identifier of the network. </p>', 'VoteOnProposalInput$ProposalId' => '<p> The unique identifier of the proposal. </p>', 'VoteOnProposalInput$VoterMemberId' => '<p>The unique identifier of the member casting the vote. </p>', 'VoteSummary$MemberId' => '<p> The unique identifier of the member that cast the vote. </p>', ], ], 'ResourceLimitExceededException' => [ 'base' => '<p>The maximum number of resources of that type already exist. Ensure the resources requested are within the boundaries of the service edition and your account limits.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>A requested resource doesn\'t exist. It may have been deleted or referenced incorrectly.</p>', 'refs' => [], ], 'ResourceNotReadyException' => [ 'base' => '<p>The requested resource exists but isn\'t in a status that can complete the operation.</p>', 'refs' => [], ], 'StateDBType' => [ 'base' => NULL, 'refs' => [ 'Node$StateDB' => '<p>The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>.</p> <p>Applies only to Hyperledger Fabric.</p>', 'NodeConfiguration$StateDB' => '<p>The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>. When using an Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default is <code>CouchDB</code>.</p> <p>Applies only to Hyperledger Fabric.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'IllegalActionException$Message' => NULL, 'InvalidRequestException$Message' => NULL, 'ListMembersInput$Name' => '<p>The optional name of the member to list.</p>', 'ListNetworksInput$Name' => '<p>The name of the network.</p>', 'Member$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the customer managed key in Key Management Service (KMS) that the member uses for encryption at rest. If the value of this parameter is <code>"AWS Owned KMS Key"</code>, the member uses an Amazon Web Services owned KMS key for encryption. This parameter is inherited by the nodes that this member owns.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/managed-blockchain-encryption-at-rest.html">Encryption at Rest</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>', 'MemberFabricAttributes$CaEndpoint' => '<p>The endpoint used to access the member\'s certificate authority.</p>', 'Network$VpcEndpointServiceName' => '<p>The VPC endpoint service name of the VPC endpoint service of the network. Members use the VPC endpoint service name to create a VPC endpoint to access network resources.</p>', 'NetworkEthereumAttributes$ChainId' => '<p>The Ethereum <code>CHAIN_ID</code> associated with the Ethereum network. Chain IDs are as follows:</p> <ul> <li> <p>mainnet = <code>1</code> </p> </li> </ul>', 'NetworkFabricAttributes$OrderingServiceEndpoint' => '<p>The endpoint of the ordering service for the network.</p>', 'Node$KmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the customer managed key in Key Management Service (KMS) that the node uses for encryption at rest. If the value of this parameter is <code>"AWS Owned KMS Key"</code>, the node uses an Amazon Web Services owned KMS key for encryption. The node inherits this parameter from the member that it belongs to.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/managed-blockchain-encryption-at-rest.html">Encryption at Rest</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p> <p>Applies only to Hyperledger Fabric.</p>', 'NodeEthereumAttributes$HttpEndpoint' => '<p>The endpoint on which the Ethereum node listens to run Ethereum API methods over HTTP connections from a client. Use this endpoint in client code for smart contracts when using an HTTP connection. Connections to this endpoint are authenticated using <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>', 'NodeEthereumAttributes$WebSocketEndpoint' => '<p>The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC methods over WebSocket connections from a client. Use this endpoint in client code for smart contracts when using a WebSocket connection. Connections to this endpoint are authenticated using <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.</p>', 'NodeFabricAttributes$PeerEndpoint' => '<p>The endpoint that identifies the peer node for all services except peer channel-based event services.</p>', 'NodeFabricAttributes$PeerEventEndpoint' => '<p>The endpoint that identifies the peer node for peer channel-based event services.</p>', 'ResourceAlreadyExistsException$Message' => NULL, 'ResourceLimitExceededException$Message' => NULL, 'ResourceNotFoundException$Message' => NULL, 'ResourceNotReadyException$Message' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'InputTagMap$key' => NULL, 'OutputTagMap$key' => NULL, 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The tag keys.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'InputTagMap$value' => NULL, 'OutputTagMap$value' => NULL, ], ], 'ThresholdComparator' => [ 'base' => NULL, 'refs' => [ 'ApprovalThresholdPolicy$ThresholdComparator' => '<p>Determines whether the vote percentage must be greater than the <code>ThresholdPercentage</code> or must be greater than or equal to the <code>ThresholdPercentage</code> to be approved.</p>', ], ], 'ThresholdPercentageInt' => [ 'base' => NULL, 'refs' => [ 'ApprovalThresholdPolicy$ThresholdPercentage' => '<p>The percentage of votes among all members that must be <code>YES</code> for a proposal to be approved. For example, a <code>ThresholdPercentage</code> value of <code>50</code> indicates 50%. The <code>ThresholdComparator</code> determines the precise comparison. If a <code>ThresholdPercentage</code> value of <code>50</code> is specified on a network with 10 members, along with a <code>ThresholdComparator</code> value of <code>GREATER_THAN</code>, this indicates that 6 <code>YES</code> votes are required for the proposal to be approved.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The request or operation couldn\'t be performed because a service is throttling requests. The most common source of throttling errors is creating resources that exceed your service limit for this resource type. Request a limit increase or delete unused resources if possible.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'Accessor$CreationDate' => '<p>The creation date and time of the accessor.</p>', 'AccessorSummary$CreationDate' => '<p>The creation date and time of the accessor.</p>', 'Invitation$CreationDate' => '<p>The date and time that the invitation was created.</p>', 'Invitation$ExpirationDate' => '<p>The date and time that the invitation expires. This is the <code>CreationDate</code> plus the <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After this date and time, the invitee can no longer create a member and join the network using this <code>InvitationId</code>.</p>', 'Member$CreationDate' => '<p>The date and time that the member was created.</p>', 'MemberSummary$CreationDate' => '<p>The date and time that the member was created.</p>', 'Network$CreationDate' => '<p>The date and time that the network was created.</p>', 'NetworkSummary$CreationDate' => '<p>The date and time that the network was created.</p>', 'Node$CreationDate' => '<p>The date and time that the node was created.</p>', 'NodeSummary$CreationDate' => '<p>The date and time that the node was created.</p>', 'Proposal$CreationDate' => '<p> The date and time that the proposal was created. </p>', 'Proposal$ExpirationDate' => '<p> The date and time that the proposal expires. This is the <code>CreationDate</code> plus the <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After this date and time, if members haven\'t cast enough votes to determine the outcome according to the voting policy, the proposal is <code>EXPIRED</code> and <code>Actions</code> aren\'t carried out. </p>', 'ProposalSummary$CreationDate' => '<p> The date and time that the proposal was created. </p>', 'ProposalSummary$ExpirationDate' => '<p> The date and time that the proposal expires. This is the <code>CreationDate</code> plus the <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After this date and time, if members haven\'t cast enough votes to determine the outcome according to the voting policy, the proposal is <code>EXPIRED</code> and <code>Actions</code> aren\'t carried out. </p>', ], ], 'TooManyTagsException' => [ 'base' => '<p/>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMemberInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMemberOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNodeInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNodeOutput' => [ 'base' => NULL, 'refs' => [], ], 'UsernameString' => [ 'base' => NULL, 'refs' => [ 'MemberFabricAttributes$AdminUsername' => '<p>The user name for the initial administrator user for the member.</p>', 'MemberFabricConfiguration$AdminUsername' => '<p>The user name for the member\'s initial administrative user.</p>', ], ], 'VoteCount' => [ 'base' => NULL, 'refs' => [ 'Proposal$YesVoteCount' => '<p> The current total of <code>YES</code> votes cast on the proposal by members. </p>', 'Proposal$NoVoteCount' => '<p> The current total of <code>NO</code> votes cast on the proposal by members. </p>', 'Proposal$OutstandingVoteCount' => '<p> The number of votes remaining to be cast on the proposal by members. In other words, the number of members minus the sum of <code>YES</code> votes and <code>NO</code> votes. </p>', ], ], 'VoteOnProposalInput' => [ 'base' => NULL, 'refs' => [], ], 'VoteOnProposalOutput' => [ 'base' => NULL, 'refs' => [], ], 'VoteSummary' => [ 'base' => '<p> Properties of an individual vote that a member cast for a proposal. </p> <p>Applies only to Hyperledger Fabric.</p>', 'refs' => [ 'ProposalVoteList$member' => NULL, ], ], 'VoteValue' => [ 'base' => NULL, 'refs' => [ 'VoteOnProposalInput$Vote' => '<p> The value of the vote. </p>', 'VoteSummary$Vote' => '<p> The vote value, either <code>YES</code> or <code>NO</code>. </p>', ], ], 'VotingPolicy' => [ 'base' => '<p> The voting rules for the network to decide if a proposal is accepted </p> <p>Applies only to Hyperledger Fabric.</p>', 'refs' => [ 'CreateNetworkInput$VotingPolicy' => '<p> The voting rules used by the network to determine if a proposal is approved. </p>', 'Network$VotingPolicy' => '<p>The voting rules that the network uses to decide if a proposal is accepted.</p>', ], ], ],];
