<?php
// This file was auto-generated from sdk-root/src/data/memorydb/2021-01-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>MemoryDB is a fully managed, Redis OSS-compatible, in-memory database that delivers ultra-fast performance and Multi-AZ durability for modern applications built using microservices architectures. MemoryDB stores the entire database in-memory, enabling low latency and high throughput data access. It is compatible with Redis OSS, a popular open source data store, enabling you to leverage Redis OSS’ flexible and friendly data structures, APIs, and commands.</p>', 'operations' => [ 'BatchUpdateCluster' => '<p>Apply the service update to a list of clusters supplied. For more information on service updates and applying them, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/managing-updates.html#applying-updates">Applying the service updates</a>.</p>', 'CopySnapshot' => '<p>Makes a copy of an existing snapshot.</p>', 'CreateACL' => '<p>Creates an Access Control List. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access Contol Lists (ACLs)</a>.</p>', 'CreateCluster' => '<p>Creates a cluster. All nodes in the cluster run the same protocol-compliant engine software.</p>', 'CreateParameterGroup' => '<p>Creates a new MemoryDB parameter group. A parameter group is a collection of parameters and their values that are applied to all of the nodes in any cluster. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/parametergroups.html">Configuring engine parameters using parameter groups</a>. </p>', 'CreateSnapshot' => '<p>Creates a copy of an entire cluster at a specific moment in time.</p>', 'CreateSubnetGroup' => '<p>Creates a subnet group. A subnet group is a collection of subnets (typically private) that you can designate for your clusters running in an Amazon Virtual Private Cloud (VPC) environment. When you create a cluster in an Amazon VPC, you must specify a subnet group. MemoryDB uses that subnet group to choose a subnet and IP addresses within that subnet to associate with your nodes. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/subnetgroups.html">Subnets and subnet groups</a>.</p>', 'CreateUser' => '<p>Creates a MemoryDB user. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access Contol Lists (ACLs)</a>.</p>', 'DeleteACL' => '<p>Deletes an Access Control List. The ACL must first be disassociated from the cluster before it can be deleted. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/clusters.acls.html">Authenticating users with Access Contol Lists (ACLs)</a>.</p>', 'DeleteCluster' => '<p>Deletes a cluster. It also deletes all associated nodes and node endpoints</p> <note> <p> <code>CreateSnapshot</code> permission is required to create a final snapshot. Without this permission, the API call will fail with an <code>Access Denied</code> exception.</p> </note>', 'DeleteParameterGroup' => '<p>Deletes the specified parameter group. You cannot delete a parameter group if it is associated with any clusters. You cannot delete the default parameter groups in your account.</p>', 'DeleteSnapshot' => '<p>Deletes an existing snapshot. When you receive a successful response from this operation, MemoryDB immediately begins deleting the snapshot; you cannot cancel or revert this operation.</p>', 'DeleteSubnetGroup' => '<p>Deletes a subnet group. You cannot delete a default subnet group or one that is associated with any clusters.</p>', 'DeleteUser' => '<p>Deletes a user. The user will be removed from all ACLs and in turn removed from all clusters.</p>', 'DescribeACLs' => '<p>Returns a list of ACLs</p>', 'DescribeClusters' => '<p>Returns information about all provisioned clusters if no cluster identifier is specified, or about a specific cluster if a cluster name is supplied.</p>', 'DescribeEngineVersions' => '<p>Returns a list of the available Redis OSS engine versions.</p>', 'DescribeEvents' => '<p>Returns events related to clusters, security groups, and parameter groups. You can obtain events specific to a particular cluster, security group, or parameter group by providing the name as a parameter. By default, only the events occurring within the last hour are returned; however, you can retrieve up to 14 days\' worth of events if necessary.</p>', 'DescribeParameterGroups' => '<p>Returns a list of parameter group descriptions. If a parameter group name is specified, the list contains only the descriptions for that group.</p>', 'DescribeParameters' => '<p>Returns the detailed parameter list for a particular parameter group.</p>', 'DescribeReservedNodes' => '<p>Returns information about reserved nodes for this account, or about a specified reserved node.</p>', 'DescribeReservedNodesOfferings' => '<p>Lists available reserved node offerings.</p>', 'DescribeServiceUpdates' => '<p>Returns details of the service updates</p>', 'DescribeSnapshots' => '<p>Returns information about cluster snapshots. By default, DescribeSnapshots lists all of your snapshots; it can optionally describe a single snapshot, or just the snapshots associated with a particular cluster.</p>', 'DescribeSubnetGroups' => '<p>Returns a list of subnet group descriptions. If a subnet group name is specified, the list contains only the description of that group.</p>', 'DescribeUsers' => '<p>Returns a list of users.</p>', 'FailoverShard' => '<p>Used to failover a shard. This API is designed for testing the behavior of your application in case of MemoryDB failover. It is not designed to be used as a production-level tool for initiating a failover to overcome a problem you may have with the cluster. Moreover, in certain conditions such as large scale operational events, Amazon may block this API. </p>', 'ListAllowedNodeTypeUpdates' => '<p>Lists all available node types that you can scale to from your cluster\'s current node type. When you use the UpdateCluster operation to scale your cluster, the value of the NodeType parameter must be one of the node types returned by this operation.</p>', 'ListTags' => '<p>Lists all tags currently on a named resource. A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track your MemoryDB resources. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/Tagging-Resources.html">Tagging your MemoryDB resources</a> </p>', 'PurchaseReservedNodesOffering' => '<p>Allows you to purchase a reserved node offering. Reserved nodes are not eligible for cancellation and are non-refundable.</p>', 'ResetParameterGroup' => '<p>Modifies the parameters of a parameter group to the engine or system default value. You can reset specific parameters by submitting a list of parameter names. To reset the entire parameter group, specify the AllParameters and ParameterGroupName parameters.</p>', 'TagResource' => '<p>A tag is a key-value pair where the key and value are case-sensitive. You can use tags to categorize and track all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all nodes in the cluster. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/iam.resourcelevelpermissions.html">Resource-level permissions</a>.</p> <p>For example, you can use cost-allocation tags to your MemoryDB resources, Amazon generates a cost allocation report as a comma-separated value (CSV) file with your usage and costs aggregated by your tags. You can apply tags that represent business categories (such as cost centers, application names, or owners) to organize your costs across multiple services. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging.html">Using Cost Allocation Tags</a>.</p>', 'UntagResource' => '<p>Use this operation to remove tags on a resource</p>', 'UpdateACL' => '<p>Changes the list of users that belong to the Access Control List.</p>', 'UpdateCluster' => '<p>Modifies the settings for a cluster. You can use this operation to change one or more cluster configuration settings by specifying the settings and the new values.</p>', 'UpdateParameterGroup' => '<p>Updates the parameters of a parameter group. You can modify up to 20 parameters in a single request by submitting a list parameter name and value pairs.</p>', 'UpdateSubnetGroup' => '<p>Updates a subnet group. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/ubnetGroups.Modifying.html">Updating a subnet group</a> </p>', 'UpdateUser' => '<p>Changes user password(s) and/or access string.</p>', ], 'shapes' => [ 'ACL' => [ 'base' => '<p>An Access Control List. You can authenticate users with Access Contol Lists. ACLs enable you to control cluster access by grouping users. These Access control lists are designed as a way to organize access to clusters.</p>', 'refs' => [ 'ACLList$member' => NULL, 'CreateACLResponse$ACL' => '<p>The newly-created Access Control List.</p>', 'DeleteACLResponse$ACL' => '<p>The Access Control List object that has been deleted.</p>', 'UpdateACLResponse$ACL' => '<p>The updated Access Control List</p>', ], ], 'ACLAlreadyExistsFault' => [ 'base' => '<p/>', 'refs' => [], ], 'ACLClusterNameList' => [ 'base' => NULL, 'refs' => [ 'ACL$Clusters' => '<p>A list of clusters associated with the ACL.</p>', ], ], 'ACLList' => [ 'base' => NULL, 'refs' => [ 'DescribeACLsResponse$ACLs' => '<p>The list of ACLs</p>', ], ], 'ACLName' => [ 'base' => NULL, 'refs' => [ 'ACLNameList$member' => NULL, 'ACLsUpdateStatus$ACLToApply' => '<p>A list of ACLs pending to be applied.</p>', 'Cluster$ACLName' => '<p>The name of the Access Control List associated with this cluster.</p>', 'CreateClusterRequest$ACLName' => '<p>The name of the Access Control List to associate with the cluster.</p>', 'UpdateClusterRequest$ACLName' => '<p>The Access Control List that is associated with the cluster</p>', ], ], 'ACLNameList' => [ 'base' => NULL, 'refs' => [ 'User$ACLNames' => '<p>The names of the Access Control Lists to which the user belongs</p>', ], ], 'ACLNotFoundFault' => [ 'base' => '<p/>', 'refs' => [], ], 'ACLPendingChanges' => [ 'base' => '<p>Returns the updates being applied to the ACL.</p>', 'refs' => [ 'ACL$PendingChanges' => '<p>A list of updates being applied to the ACL.</p>', ], ], 'ACLQuotaExceededFault' => [ 'base' => '<p/>', 'refs' => [], ], 'ACLsUpdateStatus' => [ 'base' => '<p>The status of the ACL update</p>', 'refs' => [ 'ClusterPendingUpdates$ACLs' => '<p>A list of ACLs associated with the cluster that are being updated</p>', ], ], 'APICallRateForCustomerExceededFault' => [ 'base' => '<p/>', 'refs' => [], ], 'AZStatus' => [ 'base' => NULL, 'refs' => [ 'Cluster$AvailabilityMode' => '<p>Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).</p>', ], ], 'AccessString' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$AccessString' => '<p>Access permissions string used for this user.</p>', 'UpdateUserRequest$AccessString' => '<p>Access permissions string used for this user.</p>', ], ], 'Authentication' => [ 'base' => '<p>Denotes the user\'s authentication properties, such as whether it requires a password to authenticate. Used in output responses.</p>', 'refs' => [ 'User$Authentication' => '<p>Denotes whether the user requires a password to authenticate.</p>', ], ], 'AuthenticationMode' => [ 'base' => '<p>Denotes the user\'s authentication properties, such as whether it requires a password to authenticate. Used in output responses.</p>', 'refs' => [ 'CreateUserRequest$AuthenticationMode' => '<p>Denotes the user\'s authentication properties, such as whether it requires a password to authenticate.</p>', 'UpdateUserRequest$AuthenticationMode' => '<p>Denotes the user\'s authentication properties, such as whether it requires a password to authenticate.</p>', ], ], 'AuthenticationType' => [ 'base' => NULL, 'refs' => [ 'Authentication$Type' => '<p>Indicates whether the user requires a password to authenticate.</p>', ], ], 'AvailabilityZone' => [ 'base' => '<p>Indicates if the cluster has a Multi-AZ configuration (multiaz) or not (singleaz).</p>', 'refs' => [ 'Subnet$AvailabilityZone' => '<p>The Availability Zone where the subnet resides</p>', ], ], 'AwsQueryErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidParameterCombinationException$message' => NULL, 'InvalidParameterValueException$message' => NULL, ], ], 'BatchUpdateClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchUpdateClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'DescribeEngineVersionsRequest$DefaultOnly' => '<p>If true, specifies that only the default version of the specified engine or engine and major version combination is to be returned.</p>', 'ResetParameterGroupRequest$AllParameters' => '<p>If true, all parameters in the parameter group are reset to their default values. If false, only the parameters listed by ParameterNames are reset to their default values.</p>', ], ], 'BooleanOptional' => [ 'base' => NULL, 'refs' => [ 'Cluster$TLSEnabled' => '<p>A flag to indicate if In-transit encryption is enabled</p>', 'Cluster$AutoMinorVersionUpgrade' => '<p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>', 'CreateClusterRequest$TLSEnabled' => '<p>A flag to enable in-transit encryption on the cluster.</p>', 'CreateClusterRequest$AutoMinorVersionUpgrade' => '<p>When set to true, the cluster will automatically receive minor engine version upgrades after launch.</p>', 'CreateClusterRequest$DataTiering' => '<p>Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must be set when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.</p>', 'DescribeClustersRequest$ShowShardDetails' => '<p>An optional flag that can be included in the request to retrieve information about the individual shard(s).</p>', 'DescribeSnapshotsRequest$ShowDetail' => '<p>A Boolean value which if true, the shard configuration is included in the snapshot description.</p>', ], ], 'Cluster' => [ 'base' => '<p>Contains all of the attributes of a specific cluster.</p>', 'refs' => [ 'ClusterList$member' => NULL, 'CreateClusterResponse$Cluster' => '<p>The newly-created cluster.</p>', 'DeleteClusterResponse$Cluster' => '<p>The cluster object that has been deleted</p>', 'FailoverShardResponse$Cluster' => '<p>The cluster being failed over</p>', 'UpdateClusterResponse$Cluster' => '<p>The updated cluster</p>', ], ], 'ClusterAlreadyExistsFault' => [ 'base' => '<p/>', 'refs' => [], ], 'ClusterConfiguration' => [ 'base' => '<p>A list of cluster configuration options. </p>', 'refs' => [ 'Snapshot$ClusterConfiguration' => '<p>The configuration of the cluster from which the snapshot was taken</p>', ], ], 'ClusterList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateClusterResponse$ProcessedClusters' => '<p>The list of clusters that have been updated.</p>', 'DescribeClustersResponse$Clusters' => '<p>A list of clusters</p>', ], ], 'ClusterNameList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateClusterRequest$ClusterNames' => '<p>The cluster names to apply the updates.</p>', 'DescribeServiceUpdatesRequest$ClusterNames' => '<p>The list of cluster names to identify service updates to apply</p>', ], ], 'ClusterNotFoundFault' => [ 'base' => '<p/>', 'refs' => [], ], 'ClusterPendingUpdates' => [ 'base' => '<p>A list of updates being applied to the cluster</p>', 'refs' => [ 'Cluster$PendingUpdates' => '<p>A group of settings that are currently being applied.</p>', ], ], 'ClusterQuotaForCustomerExceededFault' => [ 'base' => '<p/>', 'refs' => [], ], 'CopySnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CopySnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateParameterGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateParameterGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubnetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSubnetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataTieringStatus' => [ 'base' => NULL, 'refs' => [ 'Cluster$DataTiering' => '<p>Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must be set when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.</p>', 'Snapshot$DataTiering' => '<p>Enables data tiering. Data tiering is only supported for clusters using the r6gd node type. This parameter must be set when using r6gd nodes. For more information, see <a href="https://docs.aws.amazon.com/memorydb/latest/devguide/data-tiering.html">Data tiering</a>.</p>', ], ], 'DefaultUserRequired' => [ 'base' => '<p/>', 'refs' => [], ], 'DeleteACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParameterGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteParameterGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubnetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSubnetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeACLsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeACLsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClustersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeClustersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEngineVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEngineVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeParameterGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeParameterGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeParametersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeParametersResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReservedNodesOfferingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReservedNodesOfferingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReservedNodesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeReservedNodesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServiceUpdatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeServiceUpdatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSnapshotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubnetGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSubnetGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUsersRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeUsersResponse' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'RecurringCharge$RecurringChargeAmount' => '<p>The amount of the recurring charge to run this reserved node.</p>', 'ReservedNode$FixedPrice' => '<p>The fixed price charged for this reserved node.</p>', 'ReservedNodesOffering$FixedPrice' => '<p>The fixed price charged for this reserved node.</p>', 'SlotMigration$ProgressPercentage' => '<p>The percentage of the slot migration that is complete.</p>', ], ], 'DuplicateUserNameFault' => [ 'base' => '<p/>', 'refs' => [], ], 'Endpoint' => [ 'base' => '<p>Represents the information required for client programs to connect to the cluster and its nodes.</p>', 'refs' => [ 'Cluster$ClusterEndpoint' => '<p>The cluster\'s configuration endpoint</p>', 'Node$Endpoint' => '<p>The hostname for connecting to this node.</p>', ], ], 'EngineVersionInfo' => [ 'base' => '<p>Provides details of the Redis OSS engine version</p>', 'refs' => [ 'EngineVersionInfoList$member' => NULL, ], ], 'EngineVersionInfoList' => [ 'base' => NULL, 'refs' => [ 'DescribeEngineVersionsResponse$EngineVersions' => '<p>A list of engine version details. Each element in the list contains detailed information about one engine version.</p>', ], ], 'Event' => [ 'base' => '<p>Represents a single occurrence of something interesting within the system. Some examples of events are creating a cluster or adding or removing a node.</p>', 'refs' => [ 'EventList$member' => NULL, ], ], 'EventList' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsResponse$Events' => '<p>A list of events. Each element in the list contains detailed information about one event.</p>', ], ], 'FailoverShardRequest' => [ 'base' => NULL, 'refs' => [], ], 'FailoverShardResponse' => [ 'base' => NULL, 'refs' => [], ], 'Filter' => [ 'base' => '<p>Used to streamline results of a search based on the property being filtered.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeUsersRequest$Filters' => '<p>Filter to determine the list of users to return.</p>', ], ], 'FilterName' => [ 'base' => NULL, 'refs' => [ 'Filter$Name' => '<p>The property being filtered. For example, UserName.</p>', ], ], 'FilterValue' => [ 'base' => NULL, 'refs' => [ 'FilterValueList$member' => NULL, ], ], 'FilterValueList' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>The property values to filter on. For example, "user-123".</p>', ], ], 'InputAuthenticationType' => [ 'base' => NULL, 'refs' => [ 'AuthenticationMode$Type' => '<p>Indicates whether the user requires a password to authenticate. All newly-created users require a password.</p>', ], ], 'InsufficientClusterCapacityFault' => [ 'base' => '<p/>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Endpoint$Port' => '<p>The port number that the engine is listening on.</p>', 'ReplicaConfigurationRequest$ReplicaCount' => '<p>The number of replicas to scale up or down to</p>', 'ReservedNode$Duration' => '<p>The duration of the reservation in seconds.</p>', 'ReservedNode$NodeCount' => '<p>The number of nodes that have been reserved.</p>', 'ReservedNodesOffering$Duration' => '<p>The duration of the reservation in seconds.</p>', 'ShardConfigurationRequest$ShardCount' => '<p>The number of shards in the cluster</p>', ], ], 'IntegerOptional' => [ 'base' => NULL, 'refs' => [ 'Authentication$PasswordCount' => '<p>The number of passwords belonging to the user. The maximum is two.</p>', 'Cluster$NumberOfShards' => '<p>The number of shards in the cluster</p>', 'Cluster$SnapshotRetentionLimit' => '<p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>', 'ClusterConfiguration$Port' => '<p>The port used by the cluster</p>', 'ClusterConfiguration$SnapshotRetentionLimit' => '<p>The snapshot retention limit set by the cluster</p>', 'ClusterConfiguration$NumShards' => '<p>The number of shards in the cluster</p>', 'CreateClusterRequest$NumShards' => '<p>The number of shards the cluster will contain. The default value is 1. </p>', 'CreateClusterRequest$NumReplicasPerShard' => '<p>The number of replicas to apply to each shard. The default value is 1. The maximum is 5. </p>', 'CreateClusterRequest$Port' => '<p>The port number on which each of the nodes accepts connections.</p>', 'CreateClusterRequest$SnapshotRetentionLimit' => '<p>The number of days for which MemoryDB retains automatic snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>', 'DescribeACLsRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'DescribeClustersRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'DescribeEngineVersionsRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'DescribeEventsRequest$Duration' => '<p>The number of minutes worth of events to retrieve.</p>', 'DescribeEventsRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'DescribeParameterGroupsRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'DescribeParametersRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'DescribeReservedNodesOfferingsRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved.</p>', 'DescribeReservedNodesRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved.</p>', 'DescribeServiceUpdatesRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'DescribeSnapshotsRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'DescribeSubnetGroupsRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'DescribeUsersRequest$MaxResults' => '<p>The maximum number of records to include in the response. If more records exist than the specified MaxResults value, a token is included in the response so that the remaining results can be retrieved.</p>', 'PurchaseReservedNodesOfferingRequest$NodeCount' => '<p>The number of node instances to reserve.</p>', 'Shard$NumberOfNodes' => '<p>The number of nodes in the shard</p>', 'ShardConfiguration$ReplicaCount' => '<p>The number of read replica nodes in this shard.</p>', 'UpdateClusterRequest$SnapshotRetentionLimit' => '<p>The number of days for which MemoryDB retains automatic cluster snapshots before deleting them. For example, if you set SnapshotRetentionLimit to 5, a snapshot that was taken today is retained for 5 days before being deleted.</p>', ], ], 'InvalidACLStateFault' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidARNFault' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidClusterStateFault' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidCredentialsException' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidKMSKeyFault' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidNodeStateFault' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidParameterCombinationException' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidParameterGroupStateFault' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidParameterValueException' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidSnapshotStateFault' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidSubnet' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidUserStateFault' => [ 'base' => '<p/>', 'refs' => [], ], 'InvalidVPCNetworkStateFault' => [ 'base' => '<p/>', 'refs' => [], ], 'KeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The list of keys of the tags that are to be removed</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CopySnapshotRequest$KmsKeyId' => '<p>The ID of the KMS key used to encrypt the target snapshot.</p>', ], ], 'ListAllowedNodeTypeUpdatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAllowedNodeTypeUpdatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsResponse' => [ 'base' => NULL, 'refs' => [], ], 'NoOperationFault' => [ 'base' => '<p/>', 'refs' => [], ], 'Node' => [ 'base' => '<p>Represents an individual node within a cluster. Each node runs its own instance of the cluster\'s protocol-compliant caching software.</p>', 'refs' => [ 'NodeList$member' => NULL, ], ], 'NodeList' => [ 'base' => NULL, 'refs' => [ 'Shard$Nodes' => '<p>A list containing information about individual nodes within the shard</p>', ], ], 'NodeQuotaForClusterExceededFault' => [ 'base' => '<p/>', 'refs' => [], ], 'NodeQuotaForCustomerExceededFault' => [ 'base' => '<p/>', 'refs' => [], ], 'NodeTypeList' => [ 'base' => NULL, 'refs' => [ 'ListAllowedNodeTypeUpdatesResponse$ScaleUpNodeTypes' => '<p>A list node types which you can use to scale up your cluster.</p>', 'ListAllowedNodeTypeUpdatesResponse$ScaleDownNodeTypes' => '<p>A list node types which you can use to scale down your cluster.</p>', ], ], 'Parameter' => [ 'base' => '<p>Describes an individual setting that controls some aspect of MemoryDB behavior.</p>', 'refs' => [ 'ParametersList$member' => NULL, ], ], 'ParameterGroup' => [ 'base' => '<p>Represents the output of a CreateParameterGroup operation. A parameter group represents a combination of specific values for the parameters that are passed to the engine software during startup.</p>', 'refs' => [ 'CreateParameterGroupResponse$ParameterGroup' => '<p>The newly-created parameter group.</p>', 'DeleteParameterGroupResponse$ParameterGroup' => '<p>The parameter group that has been deleted.</p>', 'ParameterGroupList$member' => NULL, 'ResetParameterGroupResponse$ParameterGroup' => '<p>The parameter group being reset.</p>', 'UpdateParameterGroupResponse$ParameterGroup' => '<p>The updated parameter group</p>', ], ], 'ParameterGroupAlreadyExistsFault' => [ 'base' => '<p/>', 'refs' => [], ], 'ParameterGroupList' => [ 'base' => NULL, 'refs' => [ 'DescribeParameterGroupsResponse$ParameterGroups' => '<p>A list of parameter groups. Each element in the list contains detailed information about one parameter group.</p>', ], ], 'ParameterGroupNotFoundFault' => [ 'base' => '<p/>', 'refs' => [], ], 'ParameterGroupQuotaExceededFault' => [ 'base' => '<p/>', 'refs' => [], ], 'ParameterNameList' => [ 'base' => NULL, 'refs' => [ 'ResetParameterGroupRequest$ParameterNames' => '<p>An array of parameter names to reset to their default values. If AllParameters is true, do not use ParameterNames. If AllParameters is false, you must specify the name of at least one parameter to reset.</p>', ], ], 'ParameterNameValue' => [ 'base' => '<p>Describes a name-value pair that is used to update the value of a parameter.</p>', 'refs' => [ 'ParameterNameValueList$member' => NULL, ], ], 'ParameterNameValueList' => [ 'base' => NULL, 'refs' => [ 'UpdateParameterGroupRequest$ParameterNameValues' => '<p>An array of parameter names and values for the parameter update. You must supply at least one parameter name and value; subsequent arguments are optional. A maximum of 20 parameters may be updated per request.</p>', ], ], 'ParametersList' => [ 'base' => NULL, 'refs' => [ 'DescribeParametersResponse$Parameters' => '<p>A list of parameters specific to a particular parameter group. Each element in the list contains detailed information about one parameter.</p>', ], ], 'PasswordListInput' => [ 'base' => NULL, 'refs' => [ 'AuthenticationMode$Passwords' => '<p>The password(s) used for authentication</p>', ], ], 'PendingModifiedServiceUpdate' => [ 'base' => '<p>Update action that has yet to be processed for the corresponding apply/stop request</p>', 'refs' => [ 'PendingModifiedServiceUpdateList$member' => NULL, ], ], 'PendingModifiedServiceUpdateList' => [ 'base' => NULL, 'refs' => [ 'ClusterPendingUpdates$ServiceUpdates' => '<p>A list of service updates being applied to the cluster</p>', ], ], 'PurchaseReservedNodesOfferingRequest' => [ 'base' => NULL, 'refs' => [], ], 'PurchaseReservedNodesOfferingResponse' => [ 'base' => NULL, 'refs' => [], ], 'RecurringCharge' => [ 'base' => '<p>The recurring charge to run this reserved node.</p>', 'refs' => [ 'RecurringChargeList$member' => NULL, ], ], 'RecurringChargeList' => [ 'base' => NULL, 'refs' => [ 'ReservedNode$RecurringCharges' => '<p>The recurring price charged to run this reserved node.</p>', 'ReservedNodesOffering$RecurringCharges' => '<p>The recurring price charged to run this reserved node.</p>', ], ], 'ReplicaConfigurationRequest' => [ 'base' => '<p>A request to configure the number of replicas in a shard</p>', 'refs' => [ 'UpdateClusterRequest$ReplicaConfiguration' => '<p>The number of replicas that will reside in each shard</p>', ], ], 'ReservedNode' => [ 'base' => '<p>Represents the output of a <code>PurchaseReservedNodesOffering</code> operation.</p>', 'refs' => [ 'PurchaseReservedNodesOfferingResponse$ReservedNode' => '<p>Represents the output of a <code>PurchaseReservedNodesOffering</code> operation.</p>', 'ReservedNodeList$member' => NULL, ], ], 'ReservedNodeAlreadyExistsFault' => [ 'base' => '<p>You already have a reservation with the given identifier.</p>', 'refs' => [], ], 'ReservedNodeList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedNodesResponse$ReservedNodes' => '<p>Returns information about reserved nodes for this account, or about a specified reserved node.</p>', ], ], 'ReservedNodeNotFoundFault' => [ 'base' => '<p>The requested node does not exist.</p>', 'refs' => [], ], 'ReservedNodeQuotaExceededFault' => [ 'base' => '<p>The request cannot be processed because it would exceed the user\'s node quota.</p>', 'refs' => [], ], 'ReservedNodesOffering' => [ 'base' => '<p>The offering type of this node.</p>', 'refs' => [ 'ReservedNodesOfferingList$member' => NULL, ], ], 'ReservedNodesOfferingList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedNodesOfferingsResponse$ReservedNodesOfferings' => '<p>Lists available reserved node offerings.</p>', ], ], 'ReservedNodesOfferingNotFoundFault' => [ 'base' => '<p>The requested node offering does not exist. </p>', 'refs' => [], ], 'ResetParameterGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetParameterGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'ReshardingStatus' => [ 'base' => '<p>The status of the online resharding</p>', 'refs' => [ 'ClusterPendingUpdates$Resharding' => '<p>The status of an online resharding operation.</p>', ], ], 'SecurityGroupIdsList' => [ 'base' => NULL, 'refs' => [ 'CreateClusterRequest$SecurityGroupIds' => '<p>A list of security group names to associate with this cluster.</p>', 'UpdateClusterRequest$SecurityGroupIds' => '<p>The SecurityGroupIds to update</p>', ], ], 'SecurityGroupMembership' => [ 'base' => '<p>Represents a single security group and its status.</p>', 'refs' => [ 'SecurityGroupMembershipList$member' => NULL, ], ], 'SecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'Cluster$SecurityGroups' => '<p>A list of security groups used by the cluster</p>', ], ], 'ServiceLinkedRoleNotFoundFault' => [ 'base' => '<p/>', 'refs' => [], ], 'ServiceUpdate' => [ 'base' => '<p>An update that you can apply to your MemoryDB clusters.</p>', 'refs' => [ 'ServiceUpdateList$member' => NULL, ], ], 'ServiceUpdateList' => [ 'base' => NULL, 'refs' => [ 'DescribeServiceUpdatesResponse$ServiceUpdates' => '<p>A list of service updates</p>', ], ], 'ServiceUpdateNotFoundFault' => [ 'base' => '<p/>', 'refs' => [], ], 'ServiceUpdateRequest' => [ 'base' => '<p>A request to apply a service update</p>', 'refs' => [ 'BatchUpdateClusterRequest$ServiceUpdate' => '<p>The unique ID of the service update</p>', ], ], 'ServiceUpdateStatus' => [ 'base' => NULL, 'refs' => [ 'PendingModifiedServiceUpdate$Status' => '<p>The status of the service update</p>', 'ServiceUpdate$Status' => '<p>The status of the service update</p>', 'ServiceUpdateStatusList$member' => NULL, ], ], 'ServiceUpdateStatusList' => [ 'base' => NULL, 'refs' => [ 'DescribeServiceUpdatesRequest$Status' => '<p>The status(es) of the service updates to filter on</p>', ], ], 'ServiceUpdateType' => [ 'base' => NULL, 'refs' => [ 'ServiceUpdate$Type' => '<p>Reflects the nature of the service update</p>', ], ], 'Shard' => [ 'base' => '<p>Represents a collection of nodes in a cluster. One node in the node group is the read/write primary node. All the other nodes are read-only Replica nodes.</p>', 'refs' => [ 'ShardList$member' => NULL, ], ], 'ShardConfiguration' => [ 'base' => '<p>Shard configuration options. Each shard configuration has the following: Slots and ReplicaCount.</p>', 'refs' => [ 'ShardDetail$Configuration' => '<p>The configuration details of the shard</p>', ], ], 'ShardConfigurationRequest' => [ 'base' => '<p>A request to configure the sharding properties of a cluster</p>', 'refs' => [ 'UpdateClusterRequest$ShardConfiguration' => '<p>The number of shards in the cluster</p>', ], ], 'ShardDetail' => [ 'base' => '<p>Provides details of a shard in a snapshot</p>', 'refs' => [ 'ShardDetails$member' => NULL, ], ], 'ShardDetails' => [ 'base' => NULL, 'refs' => [ 'ClusterConfiguration$Shards' => '<p>The list of shards in the cluster</p>', ], ], 'ShardList' => [ 'base' => NULL, 'refs' => [ 'Cluster$Shards' => '<p>A list of shards that are members of the cluster.</p>', ], ], 'ShardNotFoundFault' => [ 'base' => '<p/>', 'refs' => [], ], 'ShardsPerClusterQuotaExceededFault' => [ 'base' => '<p/>', 'refs' => [], ], 'SlotMigration' => [ 'base' => '<p>Represents the progress of an online resharding operation.</p>', 'refs' => [ 'ReshardingStatus$SlotMigration' => '<p>The status of the online resharding slot migration</p>', ], ], 'Snapshot' => [ 'base' => '<p>Represents a copy of an entire cluster as of the time when the snapshot was taken.</p>', 'refs' => [ 'CopySnapshotResponse$Snapshot' => '<p>Represents a copy of an entire cluster as of the time when the snapshot was taken.</p>', 'CreateSnapshotResponse$Snapshot' => '<p>The newly-created snapshot.</p>', 'DeleteSnapshotResponse$Snapshot' => '<p>The snapshot object that has been deleted.</p>', 'SnapshotList$member' => NULL, ], ], 'SnapshotAlreadyExistsFault' => [ 'base' => '<p/>', 'refs' => [], ], 'SnapshotArnsList' => [ 'base' => NULL, 'refs' => [ 'CreateClusterRequest$SnapshotArns' => '<p>A list of Amazon Resource Names (ARN) that uniquely identify the RDB snapshot files stored in Amazon S3. The snapshot files are used to populate the new cluster. The Amazon S3 object name in the ARN cannot contain any commas.</p>', ], ], 'SnapshotList' => [ 'base' => NULL, 'refs' => [ 'DescribeSnapshotsResponse$Snapshots' => '<p>A list of snapshots. Each item in the list contains detailed information about one snapshot.</p>', ], ], 'SnapshotNotFoundFault' => [ 'base' => '<p/>', 'refs' => [], ], 'SnapshotQuotaExceededFault' => [ 'base' => '<p/>', 'refs' => [], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsRequest$SourceType' => '<p>The event source to retrieve events for. If no value is specified, all events are returned.</p>', 'Event$SourceType' => '<p>Specifies the origin of this event - a cluster, a parameter group, a security group, etc.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'ACL$Name' => '<p>The name of the Access Control List</p>', 'ACL$Status' => '<p>Indicates ACL status. Can be "creating", "active", "modifying", "deleting".</p>', 'ACL$MinimumEngineVersion' => '<p>The minimum engine version supported for the ACL</p>', 'ACL$ARN' => '<p>The Amazon Resource Name (ARN) of the ACL</p>', 'ACLClusterNameList$member' => NULL, 'AvailabilityZone$Name' => '<p>The name of the Availability Zone.</p>', 'Cluster$Name' => '<p>The user-supplied name of the cluster. This identifier is a unique key that identifies a cluster.</p>', 'Cluster$Description' => '<p>A description of the cluster</p>', 'Cluster$Status' => '<p>The status of the cluster. For example, Available, Updating, Creating.</p>', 'Cluster$NodeType' => '<p>The cluster\'s node type</p>', 'Cluster$EngineVersion' => '<p>The Redis OSS engine version used by the cluster</p>', 'Cluster$EnginePatchVersion' => '<p>The Redis OSS engine patch version used by the cluster</p>', 'Cluster$ParameterGroupName' => '<p>The name of the parameter group used by the cluster</p>', 'Cluster$ParameterGroupStatus' => '<p>The status of the parameter group used by the cluster, for example \'active\' or \'applying\'.</p>', 'Cluster$SubnetGroupName' => '<p>The name of the subnet group used by the cluster</p>', 'Cluster$KmsKeyId' => '<p>The ID of the KMS key used to encrypt the cluster</p>', 'Cluster$ARN' => '<p>The Amazon Resource Name (ARN) of the cluster.</p>', 'Cluster$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) of the SNS notification topic</p>', 'Cluster$SnsTopicStatus' => '<p>The SNS topic must be in Active status to receive notifications</p>', 'Cluster$MaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. </p>', 'Cluster$SnapshotWindow' => '<p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard. Example: 05:00-09:00 If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>', 'ClusterConfiguration$Name' => '<p>The name of the cluster</p>', 'ClusterConfiguration$Description' => '<p>The description of the cluster configuration</p>', 'ClusterConfiguration$NodeType' => '<p>The node type used for the cluster</p>', 'ClusterConfiguration$EngineVersion' => '<p>The Redis OSS engine version used by the cluster</p>', 'ClusterConfiguration$MaintenanceWindow' => '<p>The specified maintenance window for the cluster</p>', 'ClusterConfiguration$TopicArn' => '<p>The Amazon Resource Name (ARN) of the SNS notification topic for the cluster</p>', 'ClusterConfiguration$ParameterGroupName' => '<p>The name of parameter group used by the cluster</p>', 'ClusterConfiguration$SubnetGroupName' => '<p>The name of the subnet group used by the cluster</p>', 'ClusterConfiguration$VpcId' => '<p>The ID of the VPC the cluster belongs to</p>', 'ClusterConfiguration$SnapshotWindow' => '<p>The snapshot window set by the cluster</p>', 'ClusterNameList$member' => NULL, 'CopySnapshotRequest$SourceSnapshotName' => '<p>The name of an existing snapshot from which to make a copy.</p>', 'CopySnapshotRequest$TargetSnapshotName' => '<p>A name for the snapshot copy. MemoryDB does not permit overwriting a snapshot, therefore this name must be unique within its context - MemoryDB or an Amazon S3 bucket if exporting.</p>', 'CreateACLRequest$ACLName' => '<p>The name of the Access Control List.</p>', 'CreateClusterRequest$ClusterName' => '<p>The name of the cluster. This value must be unique as it also serves as the cluster identifier.</p>', 'CreateClusterRequest$NodeType' => '<p>The compute and memory capacity of the nodes in the cluster.</p>', 'CreateClusterRequest$ParameterGroupName' => '<p>The name of the parameter group associated with the cluster.</p>', 'CreateClusterRequest$Description' => '<p>An optional description of the cluster.</p>', 'CreateClusterRequest$SubnetGroupName' => '<p>The name of the subnet group to be used for the cluster.</p>', 'CreateClusterRequest$MaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'CreateClusterRequest$SnsTopicArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.</p>', 'CreateClusterRequest$KmsKeyId' => '<p>The ID of the KMS key used to encrypt the cluster.</p>', 'CreateClusterRequest$SnapshotName' => '<p>The name of a snapshot from which to restore data into the new cluster. The snapshot status changes to restoring while the new cluster is being created.</p>', 'CreateClusterRequest$SnapshotWindow' => '<p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your shard.</p> <p> Example: 05:00-09:00</p> <p> If you do not specify this parameter, MemoryDB automatically chooses an appropriate time range.</p>', 'CreateClusterRequest$EngineVersion' => '<p>The version number of the Redis OSS engine to be used for the cluster.</p>', 'CreateParameterGroupRequest$ParameterGroupName' => '<p>The name of the parameter group.</p>', 'CreateParameterGroupRequest$Family' => '<p>The name of the parameter group family that the parameter group can be used with.</p>', 'CreateParameterGroupRequest$Description' => '<p>An optional description of the parameter group.</p>', 'CreateSnapshotRequest$ClusterName' => '<p>The snapshot is created from this cluster.</p>', 'CreateSnapshotRequest$SnapshotName' => '<p>A name for the snapshot being created.</p>', 'CreateSnapshotRequest$KmsKeyId' => '<p>The ID of the KMS key used to encrypt the snapshot.</p>', 'CreateSubnetGroupRequest$SubnetGroupName' => '<p>The name of the subnet group.</p>', 'CreateSubnetGroupRequest$Description' => '<p>A description for the subnet group.</p>', 'DeleteACLRequest$ACLName' => '<p>The name of the Access Control List to delete</p>', 'DeleteClusterRequest$ClusterName' => '<p>The name of the cluster to be deleted</p>', 'DeleteClusterRequest$FinalSnapshotName' => '<p>The user-supplied name of a final cluster snapshot. This is the unique name that identifies the snapshot. MemoryDB creates the snapshot, and then deletes the cluster immediately afterward.</p>', 'DeleteParameterGroupRequest$ParameterGroupName' => '<p>The name of the parameter group to delete.</p>', 'DeleteSnapshotRequest$SnapshotName' => '<p>The name of the snapshot to delete</p>', 'DeleteSubnetGroupRequest$SubnetGroupName' => '<p>The name of the subnet group to delete</p>', 'DescribeACLsRequest$ACLName' => '<p>The name of the ACL</p>', 'DescribeACLsRequest$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeACLsResponse$NextToken' => '<p>If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeClustersRequest$ClusterName' => '<p>The name of the cluster</p>', 'DescribeClustersRequest$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeClustersResponse$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeEngineVersionsRequest$EngineVersion' => '<p>The Redis OSS engine version</p>', 'DescribeEngineVersionsRequest$ParameterGroupFamily' => '<p>The name of a specific parameter group family to return details for.</p>', 'DescribeEngineVersionsRequest$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeEngineVersionsResponse$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeEventsRequest$SourceName' => '<p>The identifier of the event source for which events are returned. If not specified, all sources are included in the response.</p>', 'DescribeEventsRequest$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeEventsResponse$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeParameterGroupsRequest$ParameterGroupName' => '<p>The name of a specific parameter group to return details for.</p>', 'DescribeParameterGroupsRequest$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeParameterGroupsResponse$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeParametersRequest$ParameterGroupName' => '<p>he name of a specific parameter group to return details for.</p>', 'DescribeParametersRequest$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeParametersResponse$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeReservedNodesOfferingsRequest$ReservedNodesOfferingId' => '<p>The offering identifier filter value. Use this parameter to show only the available offering that matches the specified reservation identifier.</p>', 'DescribeReservedNodesOfferingsRequest$NodeType' => '<p>The node type for the reserved nodes. For more information, see <a href="https://docs.aws.amazon.com/memorydb/latest/devguide/nodes.reserved.html#reserved-nodes-supported">Supported node types</a>.</p>', 'DescribeReservedNodesOfferingsRequest$Duration' => '<p>Duration filter value, specified in years or seconds. Use this parameter to show only reservations for a given duration.</p>', 'DescribeReservedNodesOfferingsRequest$OfferingType' => '<p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type. Valid values: "All Upfront"|"Partial Upfront"| "No Upfront"</p>', 'DescribeReservedNodesOfferingsRequest$NextToken' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.</p>', 'DescribeReservedNodesOfferingsResponse$NextToken' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.</p>', 'DescribeReservedNodesRequest$ReservationId' => '<p>The reserved node identifier filter value. Use this parameter to show only the reservation that matches the specified reservation ID.</p>', 'DescribeReservedNodesRequest$ReservedNodesOfferingId' => '<p>The offering identifier filter value. Use this parameter to show only purchased reservations matching the specified offering identifier.</p>', 'DescribeReservedNodesRequest$NodeType' => '<p>The node type filter value. Use this parameter to show only those reservations matching the specified node type. For more information, see <a href="https://docs.aws.amazon.com/memorydb/latest/devguide/nodes.reserved.html#reserved-nodes-supported">Supported node types</a>.</p>', 'DescribeReservedNodesRequest$Duration' => '<p>The duration filter value, specified in years or seconds. Use this parameter to show only reservations for this duration.</p>', 'DescribeReservedNodesRequest$OfferingType' => '<p>The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type. Valid values: "All Upfront"|"Partial Upfront"| "No Upfront"</p>', 'DescribeReservedNodesRequest$NextToken' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.</p>', 'DescribeReservedNodesResponse$NextToken' => '<p>An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.</p>', 'DescribeServiceUpdatesRequest$ServiceUpdateName' => '<p>The unique ID of the service update to describe.</p>', 'DescribeServiceUpdatesRequest$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeServiceUpdatesResponse$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeSnapshotsRequest$ClusterName' => '<p>A user-supplied cluster identifier. If this parameter is specified, only snapshots associated with that specific cluster are described.</p>', 'DescribeSnapshotsRequest$SnapshotName' => '<p>A user-supplied name of the snapshot. If this parameter is specified, only this named snapshot is described.</p>', 'DescribeSnapshotsRequest$Source' => '<p>If set to system, the output shows snapshots that were automatically created by MemoryDB. If set to user the output shows snapshots that were manually created. If omitted, the output shows both automatically and manually created snapshots.</p>', 'DescribeSnapshotsRequest$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeSnapshotsResponse$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeSubnetGroupsRequest$SubnetGroupName' => '<p>The name of the subnet group to return details for.</p>', 'DescribeSubnetGroupsRequest$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeSubnetGroupsResponse$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeUsersRequest$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'DescribeUsersResponse$NextToken' => '<p>An optional argument to pass in case the total number of records exceeds the value of MaxResults. If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. </p>', 'Endpoint$Address' => '<p>The DNS hostname of the node.</p>', 'EngineVersionInfo$EngineVersion' => '<p>The engine version</p>', 'EngineVersionInfo$EnginePatchVersion' => '<p>The patched engine version</p>', 'EngineVersionInfo$ParameterGroupFamily' => '<p>Specifies the name of the parameter group family to which the engine default parameters apply.</p>', 'Event$SourceName' => '<p>The name for the source of the event. For example, if the event occurred at the cluster level, the identifier would be the name of the cluster.</p>', 'Event$Message' => '<p>The text of the event.</p>', 'FailoverShardRequest$ClusterName' => '<p>The cluster being failed over</p>', 'FailoverShardRequest$ShardName' => '<p>The name of the shard</p>', 'KeyList$member' => NULL, 'ListAllowedNodeTypeUpdatesRequest$ClusterName' => '<p>The name of the cluster you want to scale. MemoryDB uses the cluster name to identify the current node type being used by this cluster, and from that to create a list of node types you can scale up to.</p>', 'ListTagsRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource for which you want the list of tags</p>', 'Node$Name' => '<p>The node identifier. A node name is a numeric identifier (0001, 0002, etc.). The combination of cluster name, shard name and node name uniquely identifies every node used in a customer\'s Amazon account.</p>', 'Node$Status' => '<p>The status of the service update on the node</p>', 'Node$AvailabilityZone' => '<p>The Availability Zone in which the node resides</p>', 'NodeTypeList$member' => NULL, 'Parameter$Name' => '<p>The name of the parameter</p>', 'Parameter$Value' => '<p>The value of the parameter</p>', 'Parameter$Description' => '<p>A description of the parameter</p>', 'Parameter$DataType' => '<p>The parameter\'s data type</p>', 'Parameter$AllowedValues' => '<p>The valid range of values for the parameter.</p>', 'Parameter$MinimumEngineVersion' => '<p>The earliest engine version to which the parameter can apply.</p>', 'ParameterGroup$Name' => '<p>The name of the parameter group</p>', 'ParameterGroup$Family' => '<p>The name of the parameter group family that this parameter group is compatible with.</p>', 'ParameterGroup$Description' => '<p>A description of the parameter group</p>', 'ParameterGroup$ARN' => '<p>The Amazon Resource Name (ARN) of the parameter group</p>', 'ParameterNameList$member' => NULL, 'ParameterNameValue$ParameterName' => '<p>The name of the parameter</p>', 'ParameterNameValue$ParameterValue' => '<p>The value of the parameter</p>', 'PasswordListInput$member' => NULL, 'PendingModifiedServiceUpdate$ServiceUpdateName' => '<p>The unique ID of the service update</p>', 'PurchaseReservedNodesOfferingRequest$ReservedNodesOfferingId' => '<p>The ID of the reserved node offering to purchase.</p>', 'PurchaseReservedNodesOfferingRequest$ReservationId' => '<p>A customer-specified identifier to track this reservation.</p>', 'RecurringCharge$RecurringChargeFrequency' => '<p>The frequency of the recurring price charged to run this reserved node.</p>', 'ReservedNode$ReservationId' => '<p>A customer-specified identifier to track this reservation.</p>', 'ReservedNode$ReservedNodesOfferingId' => '<p>The ID of the reserved node offering to purchase.</p>', 'ReservedNode$NodeType' => '<p>The node type for the reserved nodes.</p>', 'ReservedNode$OfferingType' => '<p>The offering type of this reserved node.</p>', 'ReservedNode$State' => '<p>The state of the reserved node.</p>', 'ReservedNode$ARN' => '<p>The Amazon Resource Name (ARN) of the reserved node.</p>', 'ReservedNodesOffering$ReservedNodesOfferingId' => '<p>The offering identifier.</p>', 'ReservedNodesOffering$NodeType' => '<p>The node type for the reserved nodes. For more information, see <a href="https://docs.aws.amazon.com/memorydb/latest/devguide/nodes.reserved.html#reserved-nodes-supported">Supported node types</a>.</p>', 'ReservedNodesOffering$OfferingType' => '<p>The offering type of this reserved node.</p>', 'ResetParameterGroupRequest$ParameterGroupName' => '<p>The name of the parameter group to reset.</p>', 'SecurityGroupIdsList$member' => NULL, 'SecurityGroupMembership$SecurityGroupId' => '<p>The identifier of the security group.</p>', 'SecurityGroupMembership$Status' => '<p>The status of the security group membership. The status changes whenever a security group is modified, or when the security groups assigned to a cluster are modified.</p>', 'ServiceUpdate$ClusterName' => '<p>The name of the cluster to which the service update applies</p>', 'ServiceUpdate$ServiceUpdateName' => '<p>The unique ID of the service update</p>', 'ServiceUpdate$Description' => '<p>Provides details of the service update</p>', 'ServiceUpdate$NodesUpdated' => '<p>A list of nodes updated by the service update</p>', 'ServiceUpdateRequest$ServiceUpdateNameToApply' => '<p>The unique ID of the service update</p>', 'Shard$Name' => '<p>The name of the shard</p>', 'Shard$Status' => '<p>The current state of this replication group - creating, available, modifying, deleting.</p>', 'Shard$Slots' => '<p>The keyspace for this shard.</p>', 'ShardConfiguration$Slots' => '<p>A string that specifies the keyspace for a particular node group. Keyspaces range from 0 to 16,383. The string is in the format startkey-endkey.</p>', 'ShardDetail$Name' => '<p>The name of the shard</p>', 'ShardDetail$Size' => '<p>The size of the shard\'s snapshot</p>', 'Snapshot$Name' => '<p>The name of the snapshot</p>', 'Snapshot$Status' => '<p>The status of the snapshot. Valid values: creating | available | restoring | copying | deleting.</p>', 'Snapshot$Source' => '<p>Indicates whether the snapshot is from an automatic backup (automated) or was created manually (manual).</p>', 'Snapshot$KmsKeyId' => '<p>The ID of the KMS key used to encrypt the snapshot.</p>', 'Snapshot$ARN' => '<p>The ARN (Amazon Resource Name) of the snapshot.</p>', 'SnapshotArnsList$member' => NULL, 'Subnet$Identifier' => '<p>The unique identifier for the subnet.</p>', 'SubnetGroup$Name' => '<p>The name of the subnet group</p>', 'SubnetGroup$Description' => '<p>A description of the subnet group</p>', 'SubnetGroup$VpcId' => '<p>The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.</p>', 'SubnetGroup$ARN' => '<p>The ARN (Amazon Resource Name) of the subnet group.</p>', 'SubnetIdentifierList$member' => NULL, 'Tag$Key' => '<p>The key for the tag. May not be null.</p>', 'Tag$Value' => '<p>The tag\'s value. May be null.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to which the tags are to be added</p>', 'UnprocessedCluster$ClusterName' => '<p>The name of the cluster</p>', 'UnprocessedCluster$ErrorType' => '<p>The error type associated with the update failure</p>', 'UnprocessedCluster$ErrorMessage' => '<p>The error message associated with the update failure</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to which the tags are to be removed</p>', 'UpdateACLRequest$ACLName' => '<p>The name of the Access Control List</p>', 'UpdateClusterRequest$ClusterName' => '<p>The name of the cluster to update</p>', 'UpdateClusterRequest$Description' => '<p>The description of the cluster to update</p>', 'UpdateClusterRequest$MaintenanceWindow' => '<p>Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.</p> <p>Valid values for <code>ddd</code> are:</p> <ul> <li> <p> <code>sun</code> </p> </li> <li> <p> <code>mon</code> </p> </li> <li> <p> <code>tue</code> </p> </li> <li> <p> <code>wed</code> </p> </li> <li> <p> <code>thu</code> </p> </li> <li> <p> <code>fri</code> </p> </li> <li> <p> <code>sat</code> </p> </li> </ul> <p>Example: <code>sun:23:00-mon:01:30</code> </p>', 'UpdateClusterRequest$SnsTopicArn' => '<p>The SNS topic ARN to update</p>', 'UpdateClusterRequest$SnsTopicStatus' => '<p>The status of the Amazon SNS notification topic. Notifications are sent only if the status is active.</p>', 'UpdateClusterRequest$ParameterGroupName' => '<p>The name of the parameter group to update</p>', 'UpdateClusterRequest$SnapshotWindow' => '<p>The daily time range (in UTC) during which MemoryDB begins taking a daily snapshot of your cluster.</p>', 'UpdateClusterRequest$NodeType' => '<p>A valid node type that you want to scale this cluster up or down to.</p>', 'UpdateClusterRequest$EngineVersion' => '<p>The upgraded version of the engine to be run on the nodes. You can upgrade to a newer engine version, but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster and create it anew with the earlier engine version.</p>', 'UpdateParameterGroupRequest$ParameterGroupName' => '<p>The name of the parameter group to update.</p>', 'UpdateSubnetGroupRequest$SubnetGroupName' => '<p>The name of the subnet group</p>', 'UpdateSubnetGroupRequest$Description' => '<p>A description of the subnet group</p>', 'User$Name' => '<p>The name of the user</p>', 'User$Status' => '<p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>', 'User$AccessString' => '<p>Access permissions string used for this user.</p>', 'User$MinimumEngineVersion' => '<p>The minimum engine version supported for the user</p>', 'User$ARN' => '<p>The Amazon Resource Name (ARN) of the user. </p>', ], ], 'Subnet' => [ 'base' => '<p>Represents the subnet associated with a cluster. This parameter refers to subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used with MemoryDB.</p>', 'refs' => [ 'SubnetList$member' => NULL, ], ], 'SubnetGroup' => [ 'base' => '<p>Represents the output of one of the following operations:</p> <ul> <li> <p>CreateSubnetGroup</p> </li> <li> <p>UpdateSubnetGroup</p> </li> </ul> <p>A subnet group is a collection of subnets (typically private) that you can designate for your clusters running in an Amazon Virtual Private Cloud (VPC) environment.</p>', 'refs' => [ 'CreateSubnetGroupResponse$SubnetGroup' => '<p>The newly-created subnet group</p>', 'DeleteSubnetGroupResponse$SubnetGroup' => '<p>The subnet group object that has been deleted.</p>', 'SubnetGroupList$member' => NULL, 'UpdateSubnetGroupResponse$SubnetGroup' => '<p>The updated subnet group</p>', ], ], 'SubnetGroupAlreadyExistsFault' => [ 'base' => '<p/>', 'refs' => [], ], 'SubnetGroupInUseFault' => [ 'base' => '<p/>', 'refs' => [], ], 'SubnetGroupList' => [ 'base' => NULL, 'refs' => [ 'DescribeSubnetGroupsResponse$SubnetGroups' => '<p>A list of subnet groups. Each element in the list contains detailed information about one group.</p>', ], ], 'SubnetGroupNotFoundFault' => [ 'base' => '<p/>', 'refs' => [], ], 'SubnetGroupQuotaExceededFault' => [ 'base' => '<p/>', 'refs' => [], ], 'SubnetIdentifierList' => [ 'base' => NULL, 'refs' => [ 'CreateSubnetGroupRequest$SubnetIds' => '<p>A list of VPC subnet IDs for the subnet group.</p>', 'UpdateSubnetGroupRequest$SubnetIds' => '<p>The EC2 subnet IDs for the subnet group.</p>', ], ], 'SubnetInUse' => [ 'base' => '<p/>', 'refs' => [], ], 'SubnetList' => [ 'base' => NULL, 'refs' => [ 'SubnetGroup$Subnets' => '<p>A list of subnets associated with the subnet group.</p>', ], ], 'SubnetNotAllowedFault' => [ 'base' => '<p/>', 'refs' => [], ], 'SubnetQuotaExceededFault' => [ 'base' => '<p/>', 'refs' => [], ], 'TStamp' => [ 'base' => NULL, 'refs' => [ 'DescribeEventsRequest$StartTime' => '<p>The beginning of the time interval to retrieve events for, specified in ISO 8601 format. Example: 2017-03-30T07:03:49.555Z</p>', 'DescribeEventsRequest$EndTime' => '<p>The end of the time interval for which to retrieve events, specified in ISO 8601 format. Example: 2017-03-30T07:03:49.555Z</p>', 'Event$Date' => '<p>The date and time when the event occurred.</p>', 'Node$CreateTime' => '<p>The date and time when the node was created.</p>', 'ReservedNode$StartTime' => '<p>The time the reservation started.</p>', 'ServiceUpdate$ReleaseDate' => '<p>The date when the service update is initially available</p>', 'ServiceUpdate$AutoUpdateStartDate' => '<p>The date at which the service update will be automatically applied</p>', 'ShardDetail$SnapshotCreationTime' => '<p>The date and time that the shard\'s snapshot was created</p>', ], ], 'Tag' => [ 'base' => '<p>A tag that can be added to an MemoryDB resource. Tags are composed of a Key/Value pair. You can use tags to categorize and track all your MemoryDB resources. When you add or remove tags on clusters, those actions will be replicated to all nodes in the cluster. A tag with a null Value is permitted. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/tagging-resources.html">Tagging your MemoryDB resources</a> </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CopySnapshotRequest$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'CreateACLRequest$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'CreateClusterRequest$Tags' => '<p>A list of tags to be added to this resource. Tags are comma-separated key,value pairs (e.g. Key=myKey, Value=myKeyValue. You can include multiple tags as shown following: Key=myKey, Value=myKeyValue Key=mySecondKey, Value=mySecondKeyValue.</p>', 'CreateParameterGroupRequest$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'CreateSnapshotRequest$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'CreateSubnetGroupRequest$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'CreateUserRequest$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'ListTagsResponse$TagList' => '<p>A list of tags as key-value pairs.</p>', 'PurchaseReservedNodesOfferingRequest$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'TagResourceRequest$Tags' => '<p>A list of tags to be added to this resource. A tag is a key-value pair. A tag key must be accompanied by a tag value, although null is accepted.</p>', 'TagResourceResponse$TagList' => '<p>A list of tags as key-value pairs.</p>', 'UntagResourceResponse$TagList' => '<p>The list of tags removed</p>', ], ], 'TagNotFoundFault' => [ 'base' => '<p/>', 'refs' => [], ], 'TagQuotaPerResourceExceeded' => [ 'base' => '<p/>', 'refs' => [], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TargetBucket' => [ 'base' => NULL, 'refs' => [ 'CopySnapshotRequest$TargetBucket' => '<p>The Amazon S3 bucket to which the snapshot is exported. This parameter is used only when exporting a snapshot for external access. When using this parameter to export a snapshot, be sure MemoryDB has the needed permissions to this S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/MemoryDB/latest/devguide/snapshots-exporting.html">Step 2: Grant MemoryDB Access to Your Amazon S3 Bucket</a>. </p>', ], ], 'TestFailoverNotAvailableFault' => [ 'base' => '<p/>', 'refs' => [], ], 'UnprocessedCluster' => [ 'base' => '<p>A cluster whose updates have failed</p>', 'refs' => [ 'UnprocessedClusterList$member' => NULL, ], ], 'UnprocessedClusterList' => [ 'base' => NULL, 'refs' => [ 'BatchUpdateClusterResponse$UnprocessedClusters' => '<p>The list of clusters where updates have not been applied.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateACLRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateACLResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClusterRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateClusterResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateParameterGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateParameterGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubnetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSubnetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUserResponse' => [ 'base' => NULL, 'refs' => [], ], 'User' => [ 'base' => '<p>You create users and assign them specific permissions by using an access string. You assign the users to Access Control Lists aligned with a specific role (administrators, human resources) that are then deployed to one or more MemoryDB clusters.</p>', 'refs' => [ 'CreateUserResponse$User' => '<p>The newly-created user.</p>', 'DeleteUserResponse$User' => '<p>The user object that has been deleted.</p>', 'UpdateUserResponse$User' => '<p>The updated user</p>', 'UserList$member' => NULL, ], ], 'UserAlreadyExistsFault' => [ 'base' => '<p/>', 'refs' => [], ], 'UserList' => [ 'base' => NULL, 'refs' => [ 'DescribeUsersResponse$Users' => '<p>A list of users.</p>', ], ], 'UserName' => [ 'base' => NULL, 'refs' => [ 'CreateUserRequest$UserName' => '<p>The name of the user. This value must be unique as it also serves as the user identifier.</p>', 'DeleteUserRequest$UserName' => '<p>The name of the user to delete</p>', 'DescribeUsersRequest$UserName' => '<p>The name of the user</p>', 'UpdateUserRequest$UserName' => '<p>The name of the user</p>', 'UserNameList$member' => NULL, 'UserNameListInput$member' => NULL, ], ], 'UserNameList' => [ 'base' => NULL, 'refs' => [ 'ACL$UserNames' => '<p>The list of user names that belong to the ACL.</p>', 'ACLPendingChanges$UserNamesToRemove' => '<p>A list of user names being removed from the ACL</p>', 'ACLPendingChanges$UserNamesToAdd' => '<p>A list of users being added to the ACL</p>', ], ], 'UserNameListInput' => [ 'base' => NULL, 'refs' => [ 'CreateACLRequest$UserNames' => '<p>The list of users that belong to the Access Control List.</p>', 'UpdateACLRequest$UserNamesToAdd' => '<p>The list of users to add to the Access Control List</p>', 'UpdateACLRequest$UserNamesToRemove' => '<p>The list of users to remove from the Access Control List</p>', ], ], 'UserNotFoundFault' => [ 'base' => '<p/>', 'refs' => [], ], 'UserQuotaExceededFault' => [ 'base' => '<p/>', 'refs' => [], ], ],];
