<?php
// This file was auto-generated from sdk-root/src/data/migrationhubstrategy/2020-02-19/docs-2.json
return [ 'version' => '2.0', 'service' => '<p><fullname>Migration Hub Strategy Recommendations</fullname> <p>This API reference provides descriptions, syntax, and other details about each of the actions and data types for Migration Hub Strategy Recommendations (Strategy Recommendations). The topic for each action shows the API request parameters and the response. Alternatively, you can use one of the AWS SDKs to access an API that is tailored to the programming language or platform that you\'re using. For more information, see <a href="http://aws.amazon.com/tools/#SDKs">AWS SDKs</a>.</p></p>', 'operations' => [ 'GetApplicationComponentDetails' => '<p> Retrieves details about an application component. </p>', 'GetApplicationComponentStrategies' => '<p> Retrieves a list of all the recommended strategies and tools for an application component running on a server. </p>', 'GetAssessment' => '<p> Retrieves the status of an on-going assessment. </p>', 'GetImportFileTask' => '<p> Retrieves the details about a specific import task. </p>', 'GetLatestAssessmentId' => '<p>Retrieve the latest ID of a specific assessment task.</p>', 'GetPortfolioPreferences' => '<p> Retrieves your migration and modernization preferences. </p>', 'GetPortfolioSummary' => '<p> Retrieves overall summary including the number of servers to rehost and the overall number of anti-patterns. </p>', 'GetRecommendationReportDetails' => '<p> Retrieves detailed information about the specified recommendation report. </p>', 'GetServerDetails' => '<p> Retrieves detailed information about a specified server. </p>', 'GetServerStrategies' => '<p> Retrieves recommended strategies and tools for the specified server. </p>', 'ListAnalyzableServers' => '<p>Retrieves a list of all the servers fetched from customer vCenter using Strategy Recommendation Collector.</p>', 'ListApplicationComponents' => '<p> Retrieves a list of all the application components (processes). </p>', 'ListCollectors' => '<p> Retrieves a list of all the installed collectors. </p>', 'ListImportFileTask' => '<p> Retrieves a list of all the imports performed. </p>', 'ListServers' => '<p> Returns a list of all the servers. </p>', 'PutPortfolioPreferences' => '<p> Saves the specified migration and modernization preferences. </p>', 'StartAssessment' => '<p> Starts the assessment of an on-premises environment. </p>', 'StartImportFileTask' => '<p> Starts a file import. </p>', 'StartRecommendationReportGeneration' => '<p> Starts generating a recommendation report. </p>', 'StopAssessment' => '<p> Stops the assessment of an on-premises environment. </p>', 'UpdateApplicationComponentConfig' => '<p> Updates the configuration of an application component. </p>', 'UpdateServerConfig' => '<p> Updates the configuration of the specified server. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p> The user does not have permission to perform the action. Check the AWS Identity and Access Management (IAM) policy associated with this user.</p>', 'refs' => [], ], 'AnalysisStatusUnion' => [ 'base' => '<p>A combination of existing analysis statuses.</p>', 'refs' => [ 'Result$analysisStatus' => '<p>The error in server analysis.</p>', ], ], 'AnalysisType' => [ 'base' => NULL, 'refs' => [ 'Result$analysisType' => '<p>The error in server analysis.</p>', ], ], 'AnalyzableServerSummary' => [ 'base' => '<p>Summary information about an analyzable server.</p>', 'refs' => [ 'AnalyzableServerSummaryList$member' => NULL, ], ], 'AnalyzableServerSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListAnalyzableServersResponse$analyzableServers' => '<p>The list of analyzable servers with summary information about each server.</p>', ], ], 'AnalyzerNameUnion' => [ 'base' => '<p>The combination of the existing analyzers.</p>', 'refs' => [ 'AntipatternReportResult$analyzerName' => '<p>The analyzer name.</p>', ], ], 'AntipatternReportResult' => [ 'base' => '<p>The anti-pattern report result.</p>', 'refs' => [ 'AntipatternReportResultList$member' => NULL, ], ], 'AntipatternReportResultList' => [ 'base' => NULL, 'refs' => [ 'Result$antipatternReportResultList' => '<p>The error in server analysis.</p>', ], ], 'AntipatternReportStatus' => [ 'base' => NULL, 'refs' => [ 'AntipatternReportResult$antipatternReportStatus' => '<p>The status of the anti-pattern report generation.</p>', 'ApplicationComponentDetail$antipatternReportStatus' => '<p> The status of the anti-pattern report generation.</p>', 'AssessmentSummary$antipatternReportStatus' => '<p> The status of the anti-pattern report. </p>', 'ServerDetail$antipatternReportStatus' => '<p> The status of the anti-pattern report generation. </p>', ], ], 'AntipatternSeveritySummary' => [ 'base' => '<p> Contains the summary of anti-patterns and their severity. </p>', 'refs' => [ 'ListAntipatternSeveritySummary$member' => NULL, ], ], 'AppType' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponentDetail$appType' => '<p> The type of application component. </p>', 'ApplicationComponentSummary$appType' => '<p> Contains the name of application types. </p>', 'UpdateApplicationComponentConfigRequest$appType' => '<p>The type of known component.</p>', ], ], 'AppUnitError' => [ 'base' => '<p>Error in the analysis of the application unit.</p>', 'refs' => [ 'ApplicationComponentDetail$appUnitError' => '<p>The error in the analysis of the source code or database.</p>', ], ], 'AppUnitErrorCategory' => [ 'base' => NULL, 'refs' => [ 'AppUnitError$appUnitErrorCategory' => '<p>The category of the error.</p>', ], ], 'ApplicationComponentCriteria' => [ 'base' => NULL, 'refs' => [ 'ListApplicationComponentsRequest$applicationComponentCriteria' => '<p> Criteria for filtering the list of application components. </p>', ], ], 'ApplicationComponentDetail' => [ 'base' => '<p> Contains detailed information about an application component. </p>', 'refs' => [ 'ApplicationComponentDetails$member' => NULL, 'GetApplicationComponentDetailsResponse$applicationComponentDetail' => '<p> Detailed information about an application component. </p>', ], ], 'ApplicationComponentDetails' => [ 'base' => NULL, 'refs' => [ 'ListApplicationComponentsResponse$applicationComponentInfos' => '<p> The list of application components with detailed information about each component. </p>', ], ], 'ApplicationComponentId' => [ 'base' => NULL, 'refs' => [ 'GetApplicationComponentDetailsRequest$applicationComponentId' => '<p> The ID of the application component. The ID is unique within an AWS account.</p>', 'GetApplicationComponentStrategiesRequest$applicationComponentId' => '<p> The ID of the application component. The ID is unique within an AWS account.</p>', 'UpdateApplicationComponentConfigRequest$applicationComponentId' => '<p> The ID of the application component. The ID is unique within an AWS account. </p>', ], ], 'ApplicationComponentStatusSummary' => [ 'base' => '<p>Summary of the analysis status of the application component.</p>', 'refs' => [ 'ListApplicationComponentStatusSummary$member' => NULL, ], ], 'ApplicationComponentStrategies' => [ 'base' => NULL, 'refs' => [ 'GetApplicationComponentStrategiesResponse$applicationComponentStrategies' => '<p> A list of application component strategy recommendations. </p>', ], ], 'ApplicationComponentStrategy' => [ 'base' => '<p> Contains information about a strategy recommendation for an application component. </p>', 'refs' => [ 'ApplicationComponentStrategies$member' => NULL, ], ], 'ApplicationComponentSummary' => [ 'base' => '<p> Contains the summary of application components. </p>', 'refs' => [ 'ListApplicationComponentSummary$member' => NULL, ], ], 'ApplicationMode' => [ 'base' => NULL, 'refs' => [ 'GetPortfolioPreferencesResponse$applicationMode' => '<p>The classification for application component types.</p>', 'PutPortfolioPreferencesRequest$applicationMode' => '<p>The classification for application component types.</p>', ], ], 'ApplicationPreferences' => [ 'base' => '<p> Application preferences that you specify. </p>', 'refs' => [ 'GetPortfolioPreferencesResponse$applicationPreferences' => '<p> The transformation preferences for non-database applications. </p>', 'PutPortfolioPreferencesRequest$applicationPreferences' => '<p> The transformation preferences for non-database applications. </p>', ], ], 'AssessmentDataSourceType' => [ 'base' => NULL, 'refs' => [ 'StartAssessmentRequest$assessmentDataSourceType' => '<p>The data source type of an assessment to be started.</p>', ], ], 'AssessmentStatus' => [ 'base' => NULL, 'refs' => [ 'DataCollectionDetails$status' => '<p> The status of the assessment. </p>', ], ], 'AssessmentStatusMessage' => [ 'base' => NULL, 'refs' => [ 'DataCollectionDetails$statusMessage' => '<p>The status message of the assessment.</p>', ], ], 'AssessmentSummary' => [ 'base' => '<p> Contains the summary of the assessment results. </p>', 'refs' => [ 'GetPortfolioSummaryResponse$assessmentSummary' => '<p> An assessment summary for the portfolio including the number of servers to rehost and the overall number of anti-patterns. </p>', ], ], 'AssessmentTarget' => [ 'base' => '<p>Defines the criteria of assessment.</p>', 'refs' => [ 'AssessmentTargets$member' => NULL, ], ], 'AssessmentTargetValues' => [ 'base' => NULL, 'refs' => [ 'AssessmentTarget$values' => '<p>Values of an assessment.</p>', ], ], 'AssessmentTargets' => [ 'base' => NULL, 'refs' => [ 'GetAssessmentResponse$assessmentTargets' => '<p>List of criteria for assessment.</p>', 'StartAssessmentRequest$assessmentTargets' => '<p>List of criteria for assessment.</p>', ], ], 'AssociatedApplication' => [ 'base' => '<p> Object containing details about applications as defined in Application Discovery Service. </p>', 'refs' => [ 'AssociatedApplications$member' => NULL, ], ], 'AssociatedApplications' => [ 'base' => NULL, 'refs' => [ 'GetApplicationComponentDetailsResponse$associatedApplications' => '<p> The associated application group as defined in AWS Application Discovery Service. </p>', 'GetServerDetailsResponse$associatedApplications' => '<p> The associated application group the server belongs to, as defined in AWS Application Discovery Service. </p>', ], ], 'AssociatedServerIDs' => [ 'base' => NULL, 'refs' => [ 'GetApplicationComponentDetailsResponse$associatedServerIds' => '<p> A list of the IDs of the servers on which the application component is running. </p>', ], ], 'AsyncTaskId' => [ 'base' => NULL, 'refs' => [ 'GetAssessmentRequest$id' => '<p> The <code>assessmentid</code> returned by <a>StartAssessment</a>.</p>', 'GetAssessmentResponse$id' => '<p> The ID for the specific assessment task. </p>', 'GetLatestAssessmentIdResponse$id' => '<p>The latest ID for the specific assessment task.</p>', 'StartAssessmentResponse$assessmentId' => '<p> The ID of the assessment. </p>', 'StopAssessmentRequest$assessmentId' => '<p> The <code>assessmentId</code> returned by <a>StartAssessment</a>. </p>', ], ], 'AuthType' => [ 'base' => NULL, 'refs' => [ 'IPAddressBasedRemoteInfo$authType' => '<p>The type of authorization.</p>', ], ], 'AwsManagedResources' => [ 'base' => '<p> Object containing the choice of application destination that you specify. </p>', 'refs' => [ 'ManagementPreference$awsManagedResources' => '<p> Indicates interest in solutions that are managed by AWS. </p>', ], ], 'AwsManagedTargetDestination' => [ 'base' => NULL, 'refs' => [ 'AwsManagedTargetDestinations$member' => NULL, ], ], 'AwsManagedTargetDestinations' => [ 'base' => NULL, 'refs' => [ 'AwsManagedResources$targetDestination' => '<p> The choice of application destination that you specify. </p>', ], ], 'BinaryAnalyzerName' => [ 'base' => NULL, 'refs' => [ 'AnalyzerNameUnion$binaryAnalyzerName' => '<p>The binary analyzer names.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponentDetail$moreServerAssociationExists' => '<p> Set to true if the application component is running on multiple servers.</p>', 'ApplicationComponentStrategy$isPreferred' => '<p> Set to true if the recommendation is set as preferred. </p>', 'GetApplicationComponentDetailsResponse$moreApplicationResource' => '<p> Set to true if the application component belongs to more than one application group. </p>', 'ServerStrategy$isPreferred' => '<p> Set to true if the recommendation is set as preferred. </p>', 'StrategyOption$isPreferred' => '<p> Indicates if a specific strategy is preferred for the application component. </p>', 'UpdateApplicationComponentConfigRequest$configureOnly' => '<p>Update the configuration request of an application component. If it is set to true, the source code and/or database credentials are updated. If it is set to false, the source code and/or database credentials are updated and an analysis is initiated.</p>', ], ], 'BusinessGoals' => [ 'base' => '<p> Business goals that you specify. </p>', 'refs' => [ 'PrioritizeBusinessGoals$businessGoals' => '<p> Rank of business goals based on priority. </p>', ], ], 'BusinessGoalsInteger' => [ 'base' => NULL, 'refs' => [ 'BusinessGoals$licenseCostReduction' => '<p> Business goal to reduce license costs. </p>', 'BusinessGoals$modernizeInfrastructureWithCloudNativeTechnologies' => '<p> Business goal to modernize infrastructure by moving to cloud native technologies. </p>', 'BusinessGoals$reduceOperationalOverheadWithManagedServices' => '<p> Business goal to reduce the operational overhead on the team by moving into managed services. </p>', 'BusinessGoals$speedOfMigration' => '<p> Business goal to achieve migration at a fast pace. </p>', ], ], 'Collector' => [ 'base' => '<p> Process data collector that runs in the environment that you specify. </p>', 'refs' => [ 'Collectors$member' => NULL, ], ], 'CollectorHealth' => [ 'base' => NULL, 'refs' => [ 'Collector$collectorHealth' => '<p> Indicates the health of a collector. </p>', ], ], 'Collectors' => [ 'base' => NULL, 'refs' => [ 'ListCollectorsResponse$Collectors' => '<p> The list of all the installed collectors. </p>', ], ], 'Condition' => [ 'base' => NULL, 'refs' => [ 'AssessmentTarget$condition' => '<p>Condition of an assessment.</p>', ], ], 'ConfigurationSummary' => [ 'base' => '<p>Summary of the collector configuration.</p>', 'refs' => [ 'Collector$configurationSummary' => '<p>Summary of the collector configuration.</p>', ], ], 'ConflictException' => [ 'base' => '<p> Exception to indicate that there is an ongoing task when a new task is created. Return when once the existing tasks are complete. </p>', 'refs' => [], ], 'DataCollectionDetails' => [ 'base' => '<p> Detailed information about an assessment. </p>', 'refs' => [ 'GetAssessmentResponse$dataCollectionDetails' => '<p> Detailed information about the assessment. </p>', ], ], 'DataSourceType' => [ 'base' => NULL, 'refs' => [ 'StartImportFileTaskRequest$dataSourceType' => '<p>Specifies the source that the servers are coming from. By default, Strategy Recommendations assumes that the servers specified in the import file are available in AWS Application Discovery Service. </p>', ], ], 'DatabaseConfigDetail' => [ 'base' => '<p> Configuration information used for assessing databases. </p>', 'refs' => [ 'ApplicationComponentDetail$databaseConfigDetail' => '<p> Configuration details for the database associated with the application component. </p>', ], ], 'DatabaseManagementPreference' => [ 'base' => NULL, 'refs' => [ 'DatabasePreferences$databaseManagementPreference' => '<p> Specifies whether you\'re interested in self-managed databases or databases managed by AWS. </p>', ], ], 'DatabaseMigrationPreference' => [ 'base' => '<p> Preferences for migrating a database to AWS. </p>', 'refs' => [ 'DatabasePreferences$databaseMigrationPreference' => '<p> Specifies your preferred migration path. </p>', ], ], 'DatabasePreferences' => [ 'base' => '<p> Preferences on managing your databases on AWS. </p>', 'refs' => [ 'GetPortfolioPreferencesResponse$databasePreferences' => '<p> The transformation preferences for database applications. </p>', 'PutPortfolioPreferencesRequest$databasePreferences' => '<p> The transformation preferences for database applications. </p>', ], ], 'DependencyException' => [ 'base' => '<p>Dependency encountered an error.</p>', 'refs' => [], ], 'GetApplicationComponentDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationComponentDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationComponentStrategiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetApplicationComponentStrategiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAssessmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAssessmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetImportFileTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetImportFileTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetLatestAssessmentIdRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetLatestAssessmentIdResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPortfolioPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPortfolioPreferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPortfolioSummaryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPortfolioSummaryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationReportDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRecommendationReportDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServerDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServerDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServerStrategiesRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServerStrategiesResponse' => [ 'base' => NULL, 'refs' => [], ], 'Group' => [ 'base' => '<p> The object containing information about distinct imports or groups for Strategy Recommendations. </p>', 'refs' => [ 'GroupIds$member' => NULL, ], ], 'GroupIds' => [ 'base' => NULL, 'refs' => [ 'ListApplicationComponentsRequest$groupIdFilter' => '<p> The group ID specified in to filter on. </p>', 'ListServersRequest$groupIdFilter' => '<p> Specifies the group ID to filter on. </p>', 'StartImportFileTaskRequest$groupId' => '<p>Groups the resources in the import file together with a unique name. This ID can be as filter in <code>ListApplicationComponents</code> and <code>ListServers</code>. </p>', 'StartRecommendationReportGenerationRequest$groupIdFilter' => '<p> Groups the resources in the recommendation report with a unique name. </p>', ], ], 'GroupName' => [ 'base' => NULL, 'refs' => [ 'Group$name' => '<p> The key of the specific import group. </p>', ], ], 'Heterogeneous' => [ 'base' => '<p> The object containing details about heterogeneous database preferences. </p>', 'refs' => [ 'DatabaseMigrationPreference$heterogeneous' => '<p> Indicates whether you are interested in moving from one type of database to another. For example, from SQL Server to Amazon Aurora MySQL-Compatible Edition. </p>', ], ], 'HeterogeneousTargetDatabaseEngine' => [ 'base' => NULL, 'refs' => [ 'HeterogeneousTargetDatabaseEngines$member' => NULL, ], ], 'HeterogeneousTargetDatabaseEngines' => [ 'base' => NULL, 'refs' => [ 'Heterogeneous$targetDatabaseEngine' => '<p> The target database engine for heterogeneous database migration preference. </p>', ], ], 'Homogeneous' => [ 'base' => '<p> The object containing details about homogeneous database preferences. </p>', 'refs' => [ 'DatabaseMigrationPreference$homogeneous' => '<p> Indicates whether you are interested in moving to the same type of database into AWS. For example, from SQL Server in your environment to SQL Server on AWS. </p>', ], ], 'HomogeneousTargetDatabaseEngine' => [ 'base' => NULL, 'refs' => [ 'HomogeneousTargetDatabaseEngines$member' => NULL, ], ], 'HomogeneousTargetDatabaseEngines' => [ 'base' => NULL, 'refs' => [ 'Homogeneous$targetDatabaseEngine' => '<p> The target database engine for homogeneous database migration preferences. </p>', ], ], 'IPAddress' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$ipAddress' => '<p> Information about the IP address of the server for which the assessment was run. </p>', ], ], 'IPAddressBasedRemoteInfo' => [ 'base' => '<p>IP address based configurations.</p>', 'refs' => [ 'IPAddressBasedRemoteInfoList$member' => NULL, ], ], 'IPAddressBasedRemoteInfoList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSummary$ipAddressBasedRemoteInfoList' => '<p>IP address based configurations.</p>', ], ], 'ImportFileTaskInformation' => [ 'base' => '<p> Information about the import file tasks you request. </p>', 'refs' => [ 'ListImportFileTaskInformation$member' => NULL, ], ], 'ImportFileTaskStatus' => [ 'base' => NULL, 'refs' => [ 'GetImportFileTaskResponse$status' => '<p> Status of import file task. </p>', 'ImportFileTaskInformation$status' => '<p> Status of import file task. </p>', ], ], 'InclusionStatus' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponentDetail$inclusionStatus' => '<p> Indicates whether the application component has been included for server recommendation or not. </p>', 'UpdateApplicationComponentConfigRequest$inclusionStatus' => '<p> Indicates whether the application component has been included for server recommendation or not. </p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'AntipatternSeveritySummary$count' => '<p> Contains the count of anti-patterns. </p>', 'ApplicationComponentStatusSummary$count' => '<p>The number of application components successfully analyzed, partially successful or failed analysis.</p>', 'ApplicationComponentSummary$count' => '<p> Contains the count of application type. </p>', 'DataCollectionDetails$failed' => '<p> The number of failed servers in the assessment. </p>', 'DataCollectionDetails$inProgress' => '<p> The number of servers with the assessment status <code>IN_PROGESS</code>. </p>', 'DataCollectionDetails$servers' => '<p> The total number of servers in the assessment. </p>', 'DataCollectionDetails$success' => '<p> The number of successful servers in the assessment. </p>', 'GetImportFileTaskResponse$numberOfRecordsFailed' => '<p> The number of records that failed to be imported. </p>', 'GetImportFileTaskResponse$numberOfRecordsSuccess' => '<p> The number of records successfully imported. </p>', 'ImportFileTaskInformation$numberOfRecordsFailed' => '<p> The number of records that failed to be imported. </p>', 'ImportFileTaskInformation$numberOfRecordsSuccess' => '<p> The number of records successfully imported. </p>', 'ListImportFileTaskRequest$maxResults' => '<p> The total number of items to return. The maximum value is 100. </p>', 'ServerStatusSummary$count' => '<p>The number of servers successfully analyzed, partially successful or failed analysis.</p>', 'ServerStrategy$numberOfApplicationComponents' => '<p> The number of application components with this strategy recommendation running on the server. </p>', 'ServerSummary$count' => '<p> Number of servers. </p>', 'StrategySummary$count' => '<p> The count of recommendations per strategy. </p>', ], ], 'InterfaceName' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$interfaceName' => '<p> Information about the name of the interface of the server for which the assessment was run. </p>', ], ], 'InternalServerException' => [ 'base' => '<p> The server experienced an internal error. Try again. </p>', 'refs' => [], ], 'ListAnalyzableServersRequest' => [ 'base' => '<p>Represents input for ListAnalyzableServers operation.</p>', 'refs' => [], ], 'ListAnalyzableServersResponse' => [ 'base' => '<p>Represents output for ListAnalyzableServers operation.</p>', 'refs' => [], ], 'ListAntipatternSeveritySummary' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponentDetail$listAntipatternSeveritySummary' => '<p> A list of anti-pattern severity summaries. </p>', 'AssessmentSummary$listAntipatternSeveritySummary' => '<p> List of AntipatternSeveritySummary. </p>', 'ServerDetail$listAntipatternSeveritySummary' => '<p> A list of anti-pattern severity summaries. </p>', ], ], 'ListApplicationComponentStatusSummary' => [ 'base' => NULL, 'refs' => [ 'AssessmentSummary$listApplicationComponentStatusSummary' => '<p>List of status summaries of the analyzed application components.</p>', ], ], 'ListApplicationComponentSummary' => [ 'base' => NULL, 'refs' => [ 'AssessmentSummary$listApplicationComponentSummary' => '<p> List of ApplicationComponentSummary. </p>', ], ], 'ListApplicationComponentsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListApplicationComponentsRequestFilterValueString' => [ 'base' => NULL, 'refs' => [ 'ListApplicationComponentsRequest$filterValue' => '<p> Specify the value based on the application component criteria type. For example, if <code>applicationComponentCriteria</code> is set to <code>SERVER_ID</code> and <code>filterValue</code> is set to <code>server1</code>, then <a>ListApplicationComponents</a> returns all the application components running on server1. </p>', ], ], 'ListApplicationComponentsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCollectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCollectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListImportFileTaskInformation' => [ 'base' => NULL, 'refs' => [ 'ListImportFileTaskResponse$taskInfos' => '<p> Lists information about the files you import.</p>', ], ], 'ListImportFileTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListImportFileTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServerStatusSummary' => [ 'base' => NULL, 'refs' => [ 'AssessmentSummary$listServerStatusSummary' => '<p>List of status summaries of the analyzed servers.</p>', ], ], 'ListServerSummary' => [ 'base' => NULL, 'refs' => [ 'AssessmentSummary$listServerSummary' => '<p> List of ServerSummary. </p>', ], ], 'ListServersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListStrategySummary' => [ 'base' => NULL, 'refs' => [ 'AssessmentSummary$listApplicationComponentStrategySummary' => '<p> List of ApplicationComponentStrategySummary. </p>', 'AssessmentSummary$listServerStrategySummary' => '<p> List of ServerStrategySummary. </p>', 'ServerDetail$applicationComponentStrategySummary' => '<p> A list of strategy summaries. </p>', ], ], 'Location' => [ 'base' => NULL, 'refs' => [ 'SourceCode$location' => '<p> The repository name for the source code. </p>', ], ], 'MacAddress' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$macAddress' => '<p> Information about the MAC address of the server for which the assessment was run. </p>', ], ], 'ManagementPreference' => [ 'base' => '<p> Preferences for migrating an application to AWS. </p>', 'refs' => [ 'ApplicationPreferences$managementPreference' => '<p> Application preferences that you specify to prefer managed environment. </p>', ], ], 'MaxResult' => [ 'base' => NULL, 'refs' => [ 'GetServerDetailsRequest$maxResults' => '<p> The maximum number of items to include in the response. The maximum value is 100. </p>', 'ListAnalyzableServersRequest$maxResults' => '<p>The maximum number of items to include in the response. The maximum value is 100.</p>', 'ListApplicationComponentsRequest$maxResults' => '<p> The maximum number of items to include in the response. The maximum value is 100. </p>', 'ListCollectorsRequest$maxResults' => '<p> The maximum number of items to include in the response. The maximum value is 100. </p>', 'ListServersRequest$maxResults' => '<p> The maximum number of items to include in the response. The maximum value is 100. </p>', ], ], 'NetMask' => [ 'base' => NULL, 'refs' => [ 'NetworkInfo$netMask' => '<p> Information about the subnet mask of the server for which the assessment was run. </p>', ], ], 'NetworkInfo' => [ 'base' => '<p> Information about the server\'s network for which the assessment was run. </p>', 'refs' => [ 'NetworkInfoList$member' => NULL, ], ], 'NetworkInfoList' => [ 'base' => NULL, 'refs' => [ 'SystemInfo$networkInfoList' => '<p> Networking information related to a server. </p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'GetServerDetailsRequest$nextToken' => '<p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You\'ll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>', 'ListAnalyzableServersRequest$nextToken' => '<p>The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set maxResults to 10. You\'ll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10.</p>', 'ListAnalyzableServersResponse$nextToken' => '<p>The token you use to retrieve the next set of results, or null if there are no more results.</p>', 'ListApplicationComponentsRequest$nextToken' => '<p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You\'ll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>', 'ListApplicationComponentsResponse$nextToken' => '<p> The token you use to retrieve the next set of results, or null if there are no more results. </p>', 'ListCollectorsRequest$nextToken' => '<p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You\'ll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>', 'ListCollectorsResponse$nextToken' => '<p> The token you use to retrieve the next set of results, or null if there are no more results. </p>', 'ListServersRequest$nextToken' => '<p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You\'ll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>', 'ListServersResponse$nextToken' => '<p> The token you use to retrieve the next set of results, or null if there are no more results. </p>', ], ], 'NoDatabaseMigrationPreference' => [ 'base' => '<p> The object containing details about database migration preferences, when you have no particular preference. </p>', 'refs' => [ 'DatabaseMigrationPreference$noPreference' => '<p> Indicated that you do not prefer heterogeneous or homogeneous. </p>', ], ], 'NoManagementPreference' => [ 'base' => '<p> Object containing the choice of application destination that you specify. </p>', 'refs' => [ 'ManagementPreference$noPreference' => '<p> No specific preference. </p>', ], ], 'NoPreferenceTargetDestination' => [ 'base' => NULL, 'refs' => [ 'NoPreferenceTargetDestinations$member' => NULL, ], ], 'NoPreferenceTargetDestinations' => [ 'base' => NULL, 'refs' => [ 'NoManagementPreference$targetDestination' => '<p> The choice of application destination that you specify. </p>', ], ], 'OSInfo' => [ 'base' => '<p> Information about the operating system. </p>', 'refs' => [ 'SystemInfo$osInfo' => '<p> Operating system corresponding to a server. </p>', ], ], 'OSType' => [ 'base' => NULL, 'refs' => [ 'IPAddressBasedRemoteInfo$osType' => '<p>The type of the operating system.</p>', 'OSInfo$type' => '<p> Information about the type of operating system. </p>', 'VcenterBasedRemoteInfo$osType' => '<p>The type of the operating system.</p>', ], ], 'OSVersion' => [ 'base' => NULL, 'refs' => [ 'OSInfo$version' => '<p> Information about the version of operating system. </p>', ], ], 'OutputFormat' => [ 'base' => NULL, 'refs' => [ 'StartRecommendationReportGenerationRequest$outputFormat' => '<p> The output format for the recommendation report file. The default format is Microsoft Excel. </p>', ], ], 'PipelineInfo' => [ 'base' => '<p>Detailed information of the pipeline.</p>', 'refs' => [ 'PipelineInfoList$member' => NULL, ], ], 'PipelineInfoList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSummary$pipelineInfoList' => '<p>The list of pipeline info configurations.</p>', ], ], 'PipelineType' => [ 'base' => NULL, 'refs' => [ 'PipelineInfo$pipelineType' => '<p>The type of pipeline.</p>', ], ], 'PrioritizeBusinessGoals' => [ 'base' => '<p> Rank of business goals based on priority. </p>', 'refs' => [ 'GetPortfolioPreferencesResponse$prioritizeBusinessGoals' => '<p> The rank of business goals based on priority. </p>', 'PutPortfolioPreferencesRequest$prioritizeBusinessGoals' => '<p> The rank of the business goals based on priority. </p>', ], ], 'ProjectName' => [ 'base' => NULL, 'refs' => [ 'SourceCode$projectName' => '<p>The name of the project.</p>', ], ], 'PutPortfolioPreferencesRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutPortfolioPreferencesResponse' => [ 'base' => NULL, 'refs' => [], ], 'RecommendationReportDetails' => [ 'base' => '<p> Contains detailed information about a recommendation report. </p>', 'refs' => [ 'GetRecommendationReportDetailsResponse$recommendationReportDetails' => '<p> Detailed information about the recommendation report. </p>', ], ], 'RecommendationReportStatus' => [ 'base' => NULL, 'refs' => [ 'RecommendationReportDetails$status' => '<p> The status of the recommendation report generation task. </p>', ], ], 'RecommendationReportStatusMessage' => [ 'base' => NULL, 'refs' => [ 'RecommendationReportDetails$statusMessage' => '<p> The status message for recommendation report generation. </p>', ], ], 'RecommendationReportTimeStamp' => [ 'base' => NULL, 'refs' => [ 'RecommendationReportDetails$completionTime' => '<p> The time that the recommendation report generation task completes. </p>', 'RecommendationReportDetails$startTime' => '<p> The time that the recommendation report generation task starts. </p>', ], ], 'RecommendationSet' => [ 'base' => '<p> Contains a recommendation set. </p>', 'refs' => [ 'ApplicationComponentDetail$recommendationSet' => '<p> The top recommendation set for the application component. </p>', 'ApplicationComponentStrategy$recommendation' => '<p> Strategy recommendation for the application component. </p>', 'ServerDetail$recommendationSet' => '<p> A set of recommendations. </p>', 'ServerStrategy$recommendation' => '<p> Strategy recommendation for the server. </p>', ], ], 'RecommendationTaskId' => [ 'base' => NULL, 'refs' => [ 'GetRecommendationReportDetailsRequest$id' => '<p> The recommendation report generation task <code>id</code> returned by <a>StartRecommendationReportGeneration</a>. </p>', 'GetRecommendationReportDetailsResponse$id' => '<p> The ID of the recommendation report generation task. See the response of <a>StartRecommendationReportGeneration</a>. </p>', 'StartRecommendationReportGenerationResponse$id' => '<p> The ID of the recommendation report generation task. </p>', ], ], 'RemoteSourceCodeAnalysisServerInfo' => [ 'base' => '<p>Information about the server configured for source code analysis.</p>', 'refs' => [ 'ConfigurationSummary$remoteSourceCodeAnalysisServerInfo' => '<p>Info about the remote server source code configuration.</p>', ], ], 'ResourceId' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponentDetail$id' => '<p> The ID of the application component. </p>', 'ServerDetail$id' => '<p> The server ID. </p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponentDetail$name' => '<p> The name of application component. </p>', 'ServerDetail$name' => '<p> The name of the server. </p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p> The specified ID in the request is not found. </p>', 'refs' => [], ], 'ResourceSubType' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponentDetail$resourceSubType' => '<p> The application component subtype.</p>', ], ], 'Result' => [ 'base' => '<p>The error in server analysis.</p>', 'refs' => [ 'ResultList$member' => NULL, ], ], 'ResultList' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponentDetail$resultList' => '<p>A list of the analysis results.</p>', ], ], 'RunTimeAnalyzerName' => [ 'base' => NULL, 'refs' => [ 'AnalyzerNameUnion$runTimeAnalyzerName' => '<p>The assessment analyzer names.</p>', ], ], 'RunTimeAssessmentStatus' => [ 'base' => NULL, 'refs' => [ 'ServerDetail$dataCollectionStatus' => '<p> The status of assessment for the server. </p>', 'ServerStatusSummary$runTimeAssessmentStatus' => '<p>The status of the run time.</p>', ], ], 'RuntimeAnalysisStatus' => [ 'base' => NULL, 'refs' => [ 'AnalysisStatusUnion$runtimeAnalysisStatus' => '<p>The status of the analysis.</p>', 'ApplicationComponentDetail$runtimeStatus' => '<p>The status of the application unit.</p>', ], ], 'S3Bucket' => [ 'base' => NULL, 'refs' => [ 'S3Object$s3Bucket' => '<p> The S3 bucket name. </p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'S3Object$s3key' => '<p> The Amazon S3 key name. </p>', ], ], 'S3Keys' => [ 'base' => NULL, 'refs' => [ 'RecommendationReportDetails$s3Keys' => '<p> The Amazon S3 key name of the report file. </p>', ], ], 'S3Object' => [ 'base' => '<p> Contains the S3 bucket name and the Amazon S3 key name. </p>', 'refs' => [ 'AntipatternReportResult$antiPatternReportS3Object' => NULL, 'ApplicationComponentDetail$antipatternReportS3Object' => '<p> The S3 bucket name and the Amazon S3 key name for the anti-pattern report. </p>', 'AssessmentSummary$antipatternReportS3Object' => '<p> The Amazon S3 object containing the anti-pattern report. </p>', 'ServerDetail$antipatternReportS3Object' => '<p> The S3 bucket name and Amazon S3 key name for anti-pattern report. </p>', ], ], 'SecretsManagerKey' => [ 'base' => NULL, 'refs' => [ 'UpdateApplicationComponentConfigRequest$secretsManagerKey' => '<p> Database credentials. </p>', ], ], 'SelfManageResources' => [ 'base' => '<p> Self-managed resources. </p>', 'refs' => [ 'ManagementPreference$selfManageResources' => '<p> Indicates interest in managing your own resources on AWS. </p>', ], ], 'SelfManageTargetDestination' => [ 'base' => NULL, 'refs' => [ 'SelfManageTargetDestinations$member' => NULL, ], ], 'SelfManageTargetDestinations' => [ 'base' => NULL, 'refs' => [ 'SelfManageResources$targetDestination' => '<p> Self-managed resources target destination. </p>', ], ], 'ServerCriteria' => [ 'base' => NULL, 'refs' => [ 'ListServersRequest$serverCriteria' => '<p> Criteria for filtering servers. </p>', ], ], 'ServerDetail' => [ 'base' => '<p> Detailed information about a server. </p>', 'refs' => [ 'GetServerDetailsResponse$serverDetail' => '<p> Detailed information about the server. </p>', 'ServerDetails$member' => NULL, ], ], 'ServerDetails' => [ 'base' => NULL, 'refs' => [ 'ListServersResponse$serverInfos' => '<p> The list of servers with detailed information about each server. </p>', ], ], 'ServerError' => [ 'base' => '<p>The error in server analysis.</p>', 'refs' => [ 'ServerDetail$serverError' => '<p>The error in server analysis.</p>', ], ], 'ServerErrorCategory' => [ 'base' => NULL, 'refs' => [ 'ServerError$serverErrorCategory' => '<p>The error category of server analysis.</p>', ], ], 'ServerId' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponentDetail$associatedServerId' => '<p> The ID of the server that the application component is running on. </p>', 'GetServerDetailsRequest$serverId' => '<p> The ID of the server. </p>', 'GetServerStrategiesRequest$serverId' => '<p> The ID of the server. </p>', 'UpdateServerConfigRequest$serverId' => '<p> The ID of the server. </p>', ], ], 'ServerOsType' => [ 'base' => NULL, 'refs' => [ 'ServerSummary$ServerOsType' => '<p> Type of operating system for the servers. </p>', ], ], 'ServerStatusSummary' => [ 'base' => '<p>The status summary of the server analysis.</p>', 'refs' => [ 'ListServerStatusSummary$member' => NULL, ], ], 'ServerStrategies' => [ 'base' => NULL, 'refs' => [ 'GetServerStrategiesResponse$serverStrategies' => '<p> A list of strategy recommendations for the server. </p>', ], ], 'ServerStrategy' => [ 'base' => '<p> Contains information about a strategy recommendation for a server. </p>', 'refs' => [ 'ServerStrategies$member' => NULL, ], ], 'ServerSummary' => [ 'base' => '<p> Object containing details about the servers imported by Application Discovery Service </p>', 'refs' => [ 'ListServerSummary$member' => NULL, ], ], 'ServiceLinkedRoleLockClientException' => [ 'base' => '<p> Exception to indicate that the service-linked role (SLR) is locked. </p>', 'refs' => [], ], 'ServiceQuotaExceededException' => [ 'base' => '<p> The AWS account has reached its quota of imports. Contact AWS Support to increase the quota for this account. </p>', 'refs' => [], ], 'Severity' => [ 'base' => NULL, 'refs' => [ 'AntipatternSeveritySummary$severity' => '<p> Contains the severity of anti-patterns. </p>', ], ], 'SortOrder' => [ 'base' => NULL, 'refs' => [ 'ListAnalyzableServersRequest$sort' => '<p>Specifies whether to sort by ascending (ASC) or descending (DESC) order.</p>', 'ListApplicationComponentsRequest$sort' => '<p> Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order. </p>', 'ListServersRequest$sort' => '<p> Specifies whether to sort by ascending (<code>ASC</code>) or descending (<code>DESC</code>) order. </p>', ], ], 'SourceCode' => [ 'base' => '<p> Object containing source code information that is linked to an application component. </p>', 'refs' => [ 'SourceCodeList$member' => NULL, ], ], 'SourceCodeAnalyzerName' => [ 'base' => NULL, 'refs' => [ 'AnalyzerNameUnion$sourceCodeAnalyzerName' => '<p>The source code analyzer names.</p>', ], ], 'SourceCodeList' => [ 'base' => NULL, 'refs' => [ 'UpdateApplicationComponentConfigRequest$sourceCodeList' => '<p> The list of source code configurations to update for the application component. </p>', ], ], 'SourceCodeRepositories' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponentDetail$sourceCodeRepositories' => '<p> Details about the source code repository associated with the application component. </p>', ], ], 'SourceCodeRepository' => [ 'base' => '<p> Object containing source code information that is linked to an application component. </p>', 'refs' => [ 'SourceCodeRepositories$member' => NULL, ], ], 'SourceVersion' => [ 'base' => NULL, 'refs' => [ 'SourceCode$sourceVersion' => '<p> The branch of the source code. </p>', ], ], 'SrcCodeOrDbAnalysisStatus' => [ 'base' => NULL, 'refs' => [ 'AnalysisStatusUnion$srcCodeOrDbAnalysisStatus' => '<p>The status of the source code or database analysis.</p>', 'ApplicationComponentDetail$analysisStatus' => '<p> The status of analysis, if the application component has source code or an associated database. </p>', 'ApplicationComponentStatusSummary$srcCodeOrDbAnalysisStatus' => '<p>The status of database analysis.</p>', ], ], 'StartAssessmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartAssessmentRequestS3bucketForAnalysisDataString' => [ 'base' => NULL, 'refs' => [ 'StartAssessmentRequest$s3bucketForAnalysisData' => '<p> The S3 bucket used by the collectors to send analysis data to the service. The bucket name must begin with <code>migrationhub-strategy-</code>. </p>', ], ], 'StartAssessmentRequestS3bucketForReportDataString' => [ 'base' => NULL, 'refs' => [ 'StartAssessmentRequest$s3bucketForReportData' => '<p> The S3 bucket where all the reports generated by the service are stored. The bucket name must begin with <code>migrationhub-strategy-</code>. </p>', ], ], 'StartAssessmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartImportFileTaskRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartImportFileTaskRequestNameString' => [ 'base' => NULL, 'refs' => [ 'StartImportFileTaskRequest$name' => '<p> A descriptive name for the request. </p>', ], ], 'StartImportFileTaskRequestS3bucketForReportDataString' => [ 'base' => NULL, 'refs' => [ 'StartImportFileTaskRequest$s3bucketForReportData' => '<p> The S3 bucket where Strategy Recommendations uploads import results. The bucket name is required to begin with migrationhub-strategy-. </p>', ], ], 'StartImportFileTaskResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartRecommendationReportGenerationRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartRecommendationReportGenerationResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatusMessage' => [ 'base' => NULL, 'refs' => [ 'AntipatternReportResult$antipatternReportStatusMessage' => '<p>The status message for the anti-pattern.</p>', 'ApplicationComponentDetail$antipatternReportStatusMessage' => '<p> The status message for the anti-pattern. </p>', 'ApplicationComponentDetail$runtimeStatusMessage' => '<p>The status message for the application unit.</p>', 'ApplicationComponentDetail$statusMessage' => '<p> A detailed description of the analysis status and any failure message. </p>', 'AssessmentSummary$antipatternReportStatusMessage' => '<p> The status message of the anti-pattern report. </p>', 'Result$statusMessage' => '<p>The error in server analysis.</p>', 'ServerDetail$antipatternReportStatusMessage' => '<p> A message about the status of the anti-pattern report generation. </p>', 'ServerDetail$statusMessage' => '<p> A message about the status of data collection, which contains detailed descriptions of any error messages. </p>', ], ], 'StopAssessmentRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopAssessmentResponse' => [ 'base' => NULL, 'refs' => [], ], 'Strategy' => [ 'base' => NULL, 'refs' => [ 'RecommendationSet$strategy' => '<p> The recommended strategy. </p>', 'StrategyOption$strategy' => '<p> Type of transformation. For example, Rehost, Replatform, and so on. </p>', 'StrategySummary$strategy' => '<p> The name of recommended strategy. </p>', ], ], 'StrategyOption' => [ 'base' => '<p> Information about all the available strategy options for migrating and modernizing an application component. </p>', 'refs' => [ 'UpdateApplicationComponentConfigRequest$strategyOption' => '<p> The preferred strategy options for the application component. Use values from the <a>GetApplicationComponentStrategies</a> response. </p>', 'UpdateServerConfigRequest$strategyOption' => '<p> The preferred strategy options for the application component. See the response from <a>GetServerStrategies</a>.</p>', ], ], 'StrategyRecommendation' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponentStrategy$status' => '<p> The recommendation status of a strategy for an application component. </p>', 'ServerStrategy$status' => '<p> The recommendation status of the strategy for the server. </p>', ], ], 'StrategySummary' => [ 'base' => '<p> Object containing the summary of the strategy recommendations. </p>', 'refs' => [ 'ListStrategySummary$member' => NULL, ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'AnalyzableServerSummary$hostname' => '<p>The host name of the analyzable server.</p>', 'AnalyzableServerSummary$ipAddress' => '<p>The ip address of the analyzable server.</p>', 'AnalyzableServerSummary$source' => '<p>The data source of the analyzable server.</p>', 'AnalyzableServerSummary$vmId' => '<p>The virtual machine id of the analyzable server.</p>', 'ApplicationComponentDetail$osDriver' => '<p> OS driver. </p>', 'ApplicationComponentDetail$osVersion' => '<p> OS version. </p>', 'AssessmentTarget$name' => '<p>Name of an assessment.</p>', 'AssessmentTargetValues$member' => NULL, 'AssociatedApplication$id' => '<p> ID of the application as defined in Application Discovery Service. </p>', 'AssociatedApplication$name' => '<p> Name of the application as defined in Application Discovery Service. </p>', 'AssociatedServerIDs$member' => NULL, 'Collector$collectorId' => '<p> The ID of the collector. </p>', 'Collector$collectorVersion' => '<p> Current version of the collector that is running in the environment that you specify. </p>', 'Collector$hostName' => '<p> Hostname of the server that is hosting the collector. </p>', 'Collector$ipAddress' => '<p> IP address of the server that is hosting the collector. </p>', 'Collector$lastActivityTimeStamp' => '<p> Time when the collector last pinged the service. </p>', 'Collector$registeredTimeStamp' => '<p> Time when the collector registered with the service. </p>', 'ConflictException$message' => NULL, 'DatabaseConfigDetail$secretName' => '<p> AWS Secrets Manager key that holds the credentials that you use to connect to a database. </p>', 'GetImportFileTaskRequest$id' => '<p> The ID of the import file task. This ID is returned in the response of <a>StartImportFileTask</a>. </p>', 'GetImportFileTaskResponse$id' => '<p> The import file task <code>id</code> returned in the response of <a>StartImportFileTask</a>. </p>', 'GetImportFileTaskResponse$importName' => '<p> The name of the import task given in <a>StartImportFileTask</a>. </p>', 'GetServerDetailsResponse$nextToken' => '<p> The token you use to retrieve the next set of results, or null if there are no more results. </p>', 'Group$value' => '<p> The value of the specific import group. </p>', 'IPAddressBasedRemoteInfo$ipAddressConfigurationTimeStamp' => '<p>The time stamp of the configuration.</p>', 'ImportFileTaskInformation$id' => '<p> The ID of the import file task. </p>', 'ImportFileTaskInformation$importName' => '<p> The name of the import task given in <code>StartImportFileTask</code>. </p>', 'ListImportFileTaskRequest$nextToken' => '<p> The token from a previous call that you use to retrieve the next set of results. For example, if a previous call to this action returned 100 items, but you set <code>maxResults</code> to 10. You\'ll receive a set of 10 results along with a token. You then use the returned token to retrieve the next set of 10. </p>', 'ListImportFileTaskResponse$nextToken' => '<p> The token you use to retrieve the next set of results, or null if there are no more results. </p>', 'ListServersRequest$filterValue' => '<p> Specifies the filter value, which is based on the type of server criteria. For example, if <code>serverCriteria</code> is <code>OS_NAME</code>, and the <code>filterValue</code> is equal to <code>WindowsServer</code>, then <code>ListServers</code> returns all of the servers matching the OS name <code>WindowsServer</code>. </p>', 'PipelineInfo$pipelineConfigurationTimeStamp' => '<p>The time when the pipeline info was configured.</p>', 'RecommendationReportDetails$s3Bucket' => '<p> The S3 bucket where the report file is located. </p>', 'RemoteSourceCodeAnalysisServerInfo$remoteSourceCodeAnalysisServerConfigurationTimestamp' => '<p>The time when the remote source code server was configured.</p>', 'S3Keys$member' => NULL, 'ServerDetail$serverType' => '<p> The type of server. </p>', 'ServiceQuotaExceededException$message' => NULL, 'SourceCodeRepository$branch' => '<p> The branch of the source code. </p>', 'SourceCodeRepository$projectName' => '<p>The name of the project.</p>', 'SourceCodeRepository$repository' => '<p> The repository name for the source code. </p>', 'SourceCodeRepository$versionControlType' => '<p> The type of repository to use for the source code. </p>', 'StartImportFileTaskRequest$s3key' => '<p> The Amazon S3 key name of the import file. </p>', 'StartImportFileTaskResponse$id' => '<p> The ID for a specific import task. The ID is unique within an AWS account. </p>', 'SystemInfo$cpuArchitecture' => '<p> CPU architecture type for the server. </p>', 'SystemInfo$fileSystemType' => '<p> File system type for the server. </p>', 'VcenterBasedRemoteInfo$vcenterConfigurationTimeStamp' => '<p>The time when the remote server based on vCenter was last configured.</p>', 'VersionControlInfo$versionControlConfigurationTimeStamp' => '<p>The time when the version control system was last configured.</p>', ], ], 'SystemInfo' => [ 'base' => '<p> Information about the server that hosts application components. </p>', 'refs' => [ 'ServerDetail$systemInfo' => '<p> System information about the server. </p>', ], ], 'TargetDatabaseEngine' => [ 'base' => NULL, 'refs' => [ 'TargetDatabaseEngines$member' => NULL, ], ], 'TargetDatabaseEngines' => [ 'base' => NULL, 'refs' => [ 'NoDatabaseMigrationPreference$targetDatabaseEngine' => '<p> The target database engine for database migration preference that you specify. </p>', ], ], 'TargetDestination' => [ 'base' => NULL, 'refs' => [ 'RecommendationSet$targetDestination' => '<p> The recommended target destination. </p>', 'StrategyOption$targetDestination' => '<p> Destination information about where the application component can migrate to. For example, <code>EC2</code>, <code>ECS</code>, and so on. </p>', ], ], 'ThrottlingException' => [ 'base' => '<p> The request was denied due to request throttling. </p>', 'refs' => [], ], 'TimeStamp' => [ 'base' => NULL, 'refs' => [ 'ApplicationComponentDetail$lastAnalyzedTimestamp' => '<p> The timestamp of when the application component was assessed. </p>', 'AssessmentSummary$lastAnalyzedTimestamp' => '<p> The time the assessment was performed. </p>', 'DataCollectionDetails$completionTime' => '<p> The time the assessment completes. </p>', 'DataCollectionDetails$startTime' => '<p> The start time of assessment. </p>', 'GetImportFileTaskResponse$completionTime' => '<p> The time that the import task completed. </p>', 'GetImportFileTaskResponse$startTime' => '<p> Start time of the import task. </p>', 'ImportFileTaskInformation$completionTime' => '<p> The time that the import task completes. </p>', 'ImportFileTaskInformation$startTime' => '<p> Start time of the import task. </p>', 'ServerDetail$lastAnalyzedTimestamp' => '<p> The timestamp of when the server was assessed. </p>', ], ], 'TranformationToolDescription' => [ 'base' => NULL, 'refs' => [ 'TransformationTool$description' => '<p> Description of the tool. </p>', ], ], 'TranformationToolInstallationLink' => [ 'base' => NULL, 'refs' => [ 'TransformationTool$tranformationToolInstallationLink' => '<p> URL for installing the tool. </p>', ], ], 'TransformationTool' => [ 'base' => '<p> Information of the transformation tool that can be used to migrate and modernize the application. </p>', 'refs' => [ 'RecommendationSet$transformationTool' => '<p> The target destination for the recommendation set. </p>', ], ], 'TransformationToolName' => [ 'base' => NULL, 'refs' => [ 'StrategyOption$toolName' => '<p> The name of the tool that can be used to transform an application component using this strategy. </p>', 'TransformationTool$name' => '<p> Name of the tool. </p>', ], ], 'UpdateApplicationComponentConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateApplicationComponentConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServerConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateServerConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p> The request body isn\'t valid. </p>', 'refs' => [], ], 'VcenterBasedRemoteInfo' => [ 'base' => '<p>Details about the server in vCenter.</p>', 'refs' => [ 'VcenterBasedRemoteInfoList$member' => NULL, ], ], 'VcenterBasedRemoteInfoList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSummary$vcenterBasedRemoteInfoList' => '<p>The list of vCenter configurations.</p>', ], ], 'VersionControl' => [ 'base' => NULL, 'refs' => [ 'SourceCode$versionControl' => '<p> The type of repository to use for the source code. </p>', ], ], 'VersionControlInfo' => [ 'base' => '<p>Details about the version control configuration.</p>', 'refs' => [ 'VersionControlInfoList$member' => NULL, ], ], 'VersionControlInfoList' => [ 'base' => NULL, 'refs' => [ 'ConfigurationSummary$versionControlInfoList' => '<p>The list of the version control configurations.</p>', ], ], 'VersionControlType' => [ 'base' => NULL, 'refs' => [ 'VersionControlInfo$versionControlType' => '<p>The type of version control.</p>', ], ], 'errorMessage' => [ 'base' => NULL, 'refs' => [ 'DependencyException$message' => NULL, 'InternalServerException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'ServiceLinkedRoleLockClientException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'importS3Bucket' => [ 'base' => NULL, 'refs' => [ 'GetImportFileTaskResponse$inputS3Bucket' => '<p> The S3 bucket where import file is located. </p>', 'GetImportFileTaskResponse$statusReportS3Bucket' => '<p> The S3 bucket name for status report of import task. </p>', 'ImportFileTaskInformation$inputS3Bucket' => '<p> The S3 bucket where the import file is located. </p>', 'ImportFileTaskInformation$statusReportS3Bucket' => '<p> The S3 bucket name for status report of import task. </p>', 'StartImportFileTaskRequest$S3Bucket' => '<p> The S3 bucket where the import file is located. The bucket name is required to begin with <code>migrationhub-strategy-</code>.</p>', ], ], 'importS3Key' => [ 'base' => NULL, 'refs' => [ 'GetImportFileTaskResponse$inputS3Key' => '<p> The Amazon S3 key name of the import file. </p>', 'GetImportFileTaskResponse$statusReportS3Key' => '<p> The Amazon S3 key name for status report of import task. The report contains details about whether each record imported successfully or why it did not.</p>', 'ImportFileTaskInformation$inputS3Key' => '<p> The Amazon S3 key name of the import file. </p>', 'ImportFileTaskInformation$statusReportS3Key' => '<p> The Amazon S3 key name for status report of import task. The report contains details about whether each record imported successfully or why it did not. </p>', ], ], ],];
