<?php
// This file was auto-generated from sdk-root/src/data/networkmonitor/2023-08-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon CloudWatch Network Monitor is an Amazon Web Services active network monitoring service that identifies if a network issues exists within the Amazon Web Services network or your own company network. Within Network Monitor you\'ll choose the source VPCs and subnets from the Amazon Web Services network in which you operate and then you\'ll choose the destination IP addresses from your on-premises network. From these sources and destinations, Network Monitor creates a monitor containing all the possible source and destination combinations, each of which is called a probe, within a single monitor. These probes then monitor network traffic to help you identify where network issues might be affecting your traffic.</p> <p>Before you begin, ensure the Amazon Web Services CLI is configured in the Amazon Web Services Account where you will create the Network Monitor resource. Network Monitor doesn’t support creation on cross-account resources, but you can create a Network Monitor in any subnet belonging to a VPC owned by your Account.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/what-is-network-monitor.html">Using Amazon CloudWatch Network Monitor</a> in the <i>Amazon CloudWatch User Guide</i>.</p>', 'operations' => [ 'CreateMonitor' => '<p>Creates a monitor between a source subnet and destination IP address. Within a monitor you\'ll create one or more probes that monitor network traffic between your source Amazon Web Services VPC subnets and your destination IP addresses. Each probe then aggregates and sends metrics to Amazon CloudWatch.</p> <p>You can also create a monitor with probes using this command. For each probe, you define the following:</p> <ul> <li> <p> <code>source</code>—The subnet IDs where the probes will be created.</p> </li> <li> <p> <code>destination</code>— The target destination IP address for the probe.</p> </li> <li> <p> <code>destinationPort</code>—Required only if the protocol is <code>TCP</code>.</p> </li> <li> <p> <code>protocol</code>—The communication protocol between the source and destination. This will be either <code>TCP</code> or <code>ICMP</code>.</p> </li> <li> <p> <code>packetSize</code>—The size of the packets. This must be a number between <code>56</code> and <code>8500</code>.</p> </li> <li> <p>(Optional) <code>tags</code> —Key-value pairs created and assigned to the probe.</p> </li> </ul>', 'CreateProbe' => '<p>Create a probe within a monitor. Once you create a probe, and it begins monitoring your network traffic, you\'ll incur billing charges for that probe. This action requires the <code>monitorName</code> parameter. Run <code>ListMonitors</code> to get a list of monitor names. Note the name of the <code>monitorName</code> you want to create the probe for.</p>', 'DeleteMonitor' => '<p>Deletes a specified monitor.</p> <p>This action requires the <code>monitorName</code> parameter. Run <code>ListMonitors</code> to get a list of monitor names. </p>', 'DeleteProbe' => '<p>Deletes the specified probe. Once a probe is deleted you\'ll no longer incur any billing fees for that probe.</p> <p>This action requires both the <code>monitorName</code> and <code>probeId</code> parameters. Run <code>ListMonitors</code> to get a list of monitor names. Run <code>GetMonitor</code> to get a list of probes and probe IDs. You can only delete a single probe at a time using this action. </p>', 'GetMonitor' => '<p>Returns details about a specific monitor. </p> <p>This action requires the <code>monitorName</code> parameter. Run <code>ListMonitors</code> to get a list of monitor names. </p>', 'GetProbe' => '<p>Returns the details about a probe. This action requires both the <code>monitorName</code> and <code>probeId</code> parameters. Run <code>ListMonitors</code> to get a list of monitor names. Run <code>GetMonitor</code> to get a list of probes and probe IDs. </p>', 'ListMonitors' => '<p>Returns a list of all of your monitors.</p>', 'ListTagsForResource' => '<p>Lists the tags assigned to this resource.</p>', 'TagResource' => '<p>Adds key-value pairs to a monitor or probe.</p>', 'UntagResource' => '<p>Removes a key-value pair from a monitor or probe.</p>', 'UpdateMonitor' => '<p>Updates the <code>aggregationPeriod</code> for a monitor. Monitors support an <code>aggregationPeriod</code> of either <code>30</code> or <code>60</code> seconds. This action requires the <code>monitorName</code> and <code>probeId</code> parameter. Run <code>ListMonitors</code> to get a list of monitor names. </p>', 'UpdateProbe' => '<p>Updates a monitor probe. This action requires both the <code>monitorName</code> and <code>probeId</code> parameters. Run <code>ListMonitors</code> to get a list of monitor names. Run <code>GetMonitor</code> to get a list of probes and probe IDs. </p> <p>You can update the following para create a monitor with probes using this command. For each probe, you define the following:</p> <ul> <li> <p> <code>state</code>—The state of the probe.</p> </li> <li> <p> <code>destination</code>— The target destination IP address for the probe.</p> </li> <li> <p> <code>destinationPort</code>—Required only if the protocol is <code>TCP</code>.</p> </li> <li> <p> <code>protocol</code>—The communication protocol between the source and destination. This will be either <code>TCP</code> or <code>ICMP</code>.</p> </li> <li> <p> <code>packetSize</code>—The size of the packets. This must be a number between <code>56</code> and <code>8500</code>.</p> </li> <li> <p>(Optional) <code>tags</code> —Key-value pairs created and assigned to the probe.</p> </li> </ul>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AddressFamily' => [ 'base' => NULL, 'refs' => [ 'CreateProbeOutput$addressFamily' => '<p>Indicates whether the IP address is <code>IPV4</code> or <code>IPV6</code>.</p>', 'GetProbeOutput$addressFamily' => '<p>Indicates whether the IP address is <code>IPV4</code> or <code>IPV6</code>.</p>', 'Probe$addressFamily' => '<p>The IPv4 or IPv6 address for the probe.</p>', 'UpdateProbeOutput$addressFamily' => '<p>The updated IP address family. This must be either <code>IPV4</code> or <code>IPV6</code>.</p>', ], ], 'AggregationPeriod' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorInput$aggregationPeriod' => '<p>The time, in seconds, that metrics are aggregated and sent to Amazon CloudWatch. Valid values are either <code>30</code> or <code>60</code>. <code>60</code> is the default if no period is chosen.</p>', 'CreateMonitorOutput$aggregationPeriod' => '<p>The number of seconds that metrics are aggregated by and sent to Amazon CloudWatch. This will be either <code>30</code> or <code>60</code>. </p>', 'GetMonitorOutput$aggregationPeriod' => '<p>The aggregation period for the specified monitor.</p>', 'MonitorSummary$aggregationPeriod' => '<p>The time, in seconds, that metrics are collected and sent to Amazon CloudWatch. Valid values are either <code>30</code> or <code>60</code>.</p>', 'UpdateMonitorInput$aggregationPeriod' => '<p>The aggregation time, in seconds, to change to. This must be either <code>30</code> or <code>60</code>. </p>', 'UpdateMonitorOutput$aggregationPeriod' => '<p>The changed aggregation period.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorProbeInput$sourceArn' => '<p>The ARN of the subnet.</p>', 'CreateProbeOutput$probeArn' => '<p>The ARN of the probe.</p>', 'CreateProbeOutput$sourceArn' => '<p>The ARN of the probe.</p>', 'GetProbeOutput$probeArn' => '<p>The ARN of the probe.</p>', 'GetProbeOutput$sourceArn' => '<p>The ARN of the probe.</p>', 'ListTagsForResourceInput$resourceArn' => '<p>The </p>', 'Probe$probeArn' => '<p>The ARN of the probe.</p>', 'Probe$sourceArn' => '<p>The ARN of the probe source subnet.</p>', 'ProbeInput$sourceArn' => '<p>The ARN of the subnet.</p>', 'TagResourceInput$resourceArn' => '<p>The ARN of the monitor or probe to tag.</p>', 'UntagResourceInput$resourceArn' => '<p>The ARN of the monitor or probe that the tag should be removed from. </p>', 'UpdateProbeOutput$probeArn' => '<p>The updated ARN of the probe.</p>', 'UpdateProbeOutput$sourceArn' => '<p>The updated ARN of the source subnet.</p>', ], ], 'ConflictException' => [ 'base' => '<p>This operation attempted to create a resource that already exists.</p>', 'refs' => [], ], 'CreateMonitorInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitorOutput' => [ 'base' => NULL, 'refs' => [], ], 'CreateMonitorProbeInput' => [ 'base' => '<p>Creates a monitor probe.</p>', 'refs' => [ 'CreateMonitorProbeInputList$member' => NULL, ], ], 'CreateMonitorProbeInputList' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorInput$probes' => '<p>Displays a list of all of the probes created for a monitor.</p>', ], ], 'CreateProbeInput' => [ 'base' => NULL, 'refs' => [], ], 'CreateProbeOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMonitorInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMonitorOutput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProbeInput' => [ 'base' => NULL, 'refs' => [], ], 'DeleteProbeOutput' => [ 'base' => NULL, 'refs' => [], ], 'Destination' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorProbeInput$destination' => '<p>The destination IP address. This must be either <code>IPV4</code> or <code>IPV6</code>.</p>', 'CreateProbeOutput$destination' => '<p>The destination IP address for the monitor. This must be either an IPv4 or IPv6 address.</p>', 'GetProbeOutput$destination' => '<p>The destination IP address for the monitor. This must be either an IPv4 or IPv6 address.</p>', 'Probe$destination' => '<p>The destination for the probe. This should be either an <code>IPV4</code> or <code>IPV6</code>.</p>', 'ProbeInput$destination' => '<p>The destination IP address. This must be either <code>IPV4</code> or <code>IPV6</code>.</p>', 'UpdateProbeInput$destination' => '<p>The updated IP address for the probe destination. This must be either an IPv4 or IPv6 address.</p>', 'UpdateProbeOutput$destination' => '<p>The updated destination IP address for the probe.</p>', ], ], 'GetMonitorInput' => [ 'base' => NULL, 'refs' => [], ], 'GetMonitorOutput' => [ 'base' => NULL, 'refs' => [], ], 'GetProbeInput' => [ 'base' => NULL, 'refs' => [], ], 'GetProbeOutput' => [ 'base' => NULL, 'refs' => [], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure.</p>', 'refs' => [], ], 'Iso8601Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateProbeOutput$createdAt' => '<p>The time and date that the probe was created.</p>', 'CreateProbeOutput$modifiedAt' => '<p>The time and date when the probe was last modified. </p>', 'GetMonitorOutput$createdAt' => '<p>The time and date when the monitor was created.</p>', 'GetMonitorOutput$modifiedAt' => '<p>The time and date when the monitor was last modified.</p>', 'GetProbeOutput$createdAt' => '<p>The time and date that the probe was created.</p>', 'GetProbeOutput$modifiedAt' => '<p>The time and date that the probe was last modified.</p>', 'Probe$createdAt' => '<p>The time and date the probe was created.</p>', 'Probe$modifiedAt' => '<p>The time and date that the probe was last modified.</p>', 'UpdateProbeOutput$createdAt' => '<p>The time and date that the probe was created.</p>', 'UpdateProbeOutput$modifiedAt' => '<p>The time and date that the probe was last updated.</p>', ], ], 'ListMonitorsInput' => [ 'base' => NULL, 'refs' => [], ], 'ListMonitorsOutput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListMonitorsInput$maxResults' => '<p>The maximum number of results to return with a single call. To retrieve the remaining results, make another call with the returned <code>nextToken</code> value.</p> <p>If <code>MaxResults</code> is given a value larger than 100, only 100 results are returned.</p>', ], ], 'MonitorArn' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorOutput$monitorArn' => '<p>The ARN of the monitor.</p>', 'GetMonitorOutput$monitorArn' => '<p>The ARN of the selected monitor.</p>', 'MonitorSummary$monitorArn' => '<p>The ARN of the monitor.</p>', 'UpdateMonitorOutput$monitorArn' => '<p>The ARN of the monitor that was updated.</p>', ], ], 'MonitorList' => [ 'base' => NULL, 'refs' => [ 'ListMonitorsOutput$monitors' => '<p>Lists individual details about each of your monitors.</p>', ], ], 'MonitorState' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorOutput$state' => '<p>The state of the monitor.</p>', 'GetMonitorOutput$state' => '<p>Lists the status of the <code>state</code> of each monitor. </p>', 'MonitorSummary$state' => '<p>The state of the monitor.</p>', 'UpdateMonitorOutput$state' => '<p>The state of the updated monitor.</p>', ], ], 'MonitorSummary' => [ 'base' => '<p>Displays summary information about a monitor.</p>', 'refs' => [ 'MonitorList$member' => NULL, ], ], 'PacketSize' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorProbeInput$packetSize' => '<p>The size of the packets sent between the source and destination. This must be a number between <code>56</code> and <code>8500</code>.</p>', 'CreateProbeOutput$packetSize' => '<p>The size of the packets sent between the source and destination. This must be a number between <code>56</code> and <code>8500</code>.</p>', 'GetProbeOutput$packetSize' => '<p>The size of the packets sent between the source and destination. This must be a number between <code>56</code> and <code>8500</code>.</p>', 'Probe$packetSize' => '<p>The size of the packets traveling between the <code>source</code> and <code>destination</code>. This must be a number between <code>56</code> and </p>', 'ProbeInput$packetSize' => '<p>The size of the packets sent between the source and destination. This must be a number between <code>56</code> and <code>8500</code>.</p>', 'UpdateProbeInput$packetSize' => '<p>he updated packets size for network traffic between the source and destination. This must be a number between <code>56</code> and <code>8500</code>.</p>', 'UpdateProbeOutput$packetSize' => '<p>The updated packet size for the probe. </p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListMonitorsInput$nextToken' => '<p>The token for the next page of results.</p>', ], ], 'Port' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorProbeInput$destinationPort' => '<p>The port associated with the <code>destination</code>. This is required only if the <code>protocol</code> is <code>TCP</code> and must be a number between <code>1</code> and <code>65536</code>.</p>', 'CreateProbeOutput$destinationPort' => '<p>The port associated with the <code>destination</code>. This is required only if the <code>protocol</code> is <code>TCP</code> and must be a number between <code>1</code> and <code>65536</code>.</p>', 'GetProbeOutput$destinationPort' => '<p>The port associated with the <code>destination</code>. This is required only if the <code>protocol</code> is <code>TCP</code> and must be a number between <code>1</code> and <code>65536</code>.</p>', 'Probe$destinationPort' => '<p>The destination port for the probe. This is required only if the <code>protocol</code> is <code>TCP</code> and must be a number between <code>1</code> and <code>65536</code>.</p>', 'ProbeInput$destinationPort' => '<p>The port associated with the <code>destination</code>. This is required only if the <code>protocol</code> is <code>TCP</code> and must be a number between <code>1</code> and <code>65536</code>.</p>', 'UpdateProbeInput$destinationPort' => '<p>The updated port for the probe destination. This is required only if the <code>protocol</code> is <code>TCP</code> and must be a number between <code>1</code> and <code>65536</code>.</p>', 'UpdateProbeOutput$destinationPort' => '<p>The updated destination port. This must be a number between <code>1</code> and <code>65536</code>.</p>', ], ], 'Probe' => [ 'base' => '<p>Describes information about a network monitor probe.</p>', 'refs' => [ 'ProbeList$member' => NULL, ], ], 'ProbeId' => [ 'base' => NULL, 'refs' => [ 'CreateProbeOutput$probeId' => '<p>The ID of the probe for which details are returned.</p>', 'DeleteProbeInput$probeId' => '<p>The ID of the probe to delete. </p>', 'GetProbeInput$probeId' => '<p>The ID of the probe to get information about. Run <code>GetMonitor</code> action to get a list of probes and probe IDs for the monitor.</p>', 'GetProbeOutput$probeId' => '<p>The ID of the probe for which details are returned.</p>', 'Probe$probeId' => '<p>The ID of the probe.</p>', 'UpdateProbeInput$probeId' => '<p>The ID of the probe to update.</p>', 'UpdateProbeOutput$probeId' => '<p>The updated ID of the probe.</p>', ], ], 'ProbeInput' => [ 'base' => '<p>Defines a probe when creating a probe or monitor.</p>', 'refs' => [ 'CreateProbeInput$probe' => '<p>Describes the details of an individual probe for a monitor.</p>', ], ], 'ProbeList' => [ 'base' => NULL, 'refs' => [ 'GetMonitorOutput$probes' => '<p>The details about each probe associated with that monitor. </p>', ], ], 'ProbeState' => [ 'base' => NULL, 'refs' => [ 'CreateProbeOutput$state' => '<p>The state of the probe.</p>', 'GetProbeOutput$state' => '<p>The state of the probe.</p>', 'Probe$state' => '<p>The state of the probe.</p>', 'UpdateProbeInput$state' => '<p>The state of the probe update.</p>', 'UpdateProbeOutput$state' => '<p>The state of the updated probe.</p>', ], ], 'Protocol' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorProbeInput$protocol' => '<p>The protocol used for the network traffic between the <code>source</code> and <code>destination</code>. This must be either <code>TCP</code> or <code>ICMP</code>.</p>', 'CreateProbeOutput$protocol' => '<p>The protocol used for the network traffic between the <code>source</code> and <code>destination</code>. This must be either <code>TCP</code> or <code>ICMP</code>.</p>', 'GetProbeOutput$protocol' => '<p>The protocol used for the network traffic between the <code>source</code> and <code>destination</code>. This must be either <code>TCP</code> or <code>ICMP</code>.</p>', 'Probe$protocol' => '<p>The network protocol for the destination. This can be either <code>TCP</code> or <code>ICMP</code>. If the protocol is <code>TCP</code>, then <code>port</code> is also required.</p>', 'ProbeInput$protocol' => '<p>The protocol used for the network traffic between the <code>source</code> and <code>destination</code>. This must be either <code>TCP</code> or <code>ICMP</code>.</p>', 'UpdateProbeInput$protocol' => '<p>The updated network protocol for the destination. This can be either <code>TCP</code> or <code>ICMP</code>. If the protocol is <code>TCP</code>, then <code>port</code> is also required.</p>', 'UpdateProbeOutput$protocol' => '<p>The updated protocol for the probe.</p>', ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorInput$monitorName' => '<p>The name identifying the monitor. It can contain only letters, underscores (_), or dashes (-), and can be up to 200 characters.</p>', 'CreateMonitorOutput$monitorName' => '<p>The name of the monitor.</p>', 'CreateProbeInput$monitorName' => '<p>The name of the monitor to associated with the probe. </p>', 'DeleteMonitorInput$monitorName' => '<p>The name of the monitor to delete. </p>', 'DeleteProbeInput$monitorName' => '<p>The name of the monitor to delete. </p>', 'GetMonitorInput$monitorName' => '<p>The name of the monitor that details are returned for.</p>', 'GetMonitorOutput$monitorName' => '<p>The name of the monitor. </p>', 'GetProbeInput$monitorName' => '<p>The name of the monitor associated with the probe. Run <code>ListMonitors</code> to get a list of monitor names.</p>', 'MonitorSummary$monitorName' => '<p>The name of the monitor.</p>', 'UpdateMonitorInput$monitorName' => '<p>The name of the monitor to update. </p>', 'UpdateMonitorOutput$monitorName' => '<p>The name of the monitor that was updated.</p>', 'UpdateProbeInput$monitorName' => '<p>The name of the monitor that the probe was updated for.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The specified resource does not exist.</p>', 'refs' => [], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>This request exceeds a service quota.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'ConflictException$message' => NULL, 'CreateMonitorInput$clientToken' => '<p>Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token was provided in the request.</p>', 'CreateProbeInput$clientToken' => '<p>Unique, case-sensitive identifier to ensure the idempotency of the request. Only returned if a client token was provided in the request.</p>', 'InternalServerException$message' => NULL, 'ListMonitorsInput$state' => '<p>The list of all monitors and their states.</p>', 'ListMonitorsOutput$nextToken' => '<p>The token for the next page of results.</p>', 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => NULL, 'ThrottlingException$message' => NULL, 'ValidationException$message' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceInput$tagKeys' => '<p>The key-value pa</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreateMonitorInput$tags' => '<p>The list of key-value pairs created and assigned to the monitor.</p>', 'CreateMonitorOutput$tags' => '<p>The list of key-value pairs assigned to the monitor.</p>', 'CreateMonitorProbeInput$probeTags' => '<p>The list of key-value pairs created and assigned to the monitor.</p>', 'CreateProbeInput$tags' => '<p>The list of key-value pairs created and assigned to the probe.</p>', 'CreateProbeOutput$tags' => '<p>The list of key-value pairs assigned to the probe.</p>', 'GetMonitorOutput$tags' => '<p>The list of key-value pairs assigned to the monitor.</p>', 'GetProbeOutput$tags' => '<p>The list of key-value pairs assigned to the probe.</p>', 'ListTagsForResourceOutput$tags' => '<p>Lists the tags assigned to the resource.</p>', 'MonitorSummary$tags' => '<p>The list of key-value pairs assigned to the monitor.</p>', 'Probe$tags' => '<p>The list of key-value pairs created and assigned to the probe.</p>', 'ProbeInput$tags' => '<p>The list of key-value pairs created and assigned to the monitor.</p>', 'TagResourceInput$tags' => '<p>The list of key-value pairs assigned to the monitor or probe.</p>', 'UpdateMonitorOutput$tags' => '<p>The list of key-value pairs associated with the monitor.</p>', 'UpdateProbeOutput$tags' => '<p>Update tags for a probe.</p>', ], ], 'TagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling</p>', 'refs' => [], ], 'UntagResourceInput' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMonitorInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMonitorOutput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProbeInput' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProbeOutput' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>One of the parameters for the request is not valid.</p>', 'refs' => [], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'CreateProbeOutput$vpcId' => '<p>The ID of the source VPC or subnet.</p>', 'GetProbeOutput$vpcId' => '<p>The ID of the source VPC or subnet.</p>', 'Probe$vpcId' => '<p>The ID of the source VPC subnet.</p>', 'UpdateProbeOutput$vpcId' => '<p>The updated ID of the source VPC subnet ID.</p>', ], ], ],];
