<?php
// This file was auto-generated from sdk-root/src/data/opensearch/2021-01-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Use the Amazon OpenSearch Service configuration API to create, configure, and manage OpenSearch Service domains. The endpoint for configuration service requests is Region specific: es.<i>region</i>.amazonaws.com. For example, es.us-east-1.amazonaws.com. For a current list of supported Regions and endpoints, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#service-regions">Amazon Web Services service endpoints</a>.</p>', 'operations' => [ 'AcceptInboundConnection' => '<p>Allows the destination Amazon OpenSearch Service domain owner to accept an inbound cross-cluster search connection request. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html">Cross-cluster search for Amazon OpenSearch Service</a>.</p>', 'AddDataSource' => '<p>Creates a new direct-query data source to the specified domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html">Creating Amazon OpenSearch Service data source integrations with Amazon S3</a>.</p>', 'AddTags' => '<p>Attaches tags to an existing Amazon OpenSearch Service domain. Tags are a set of case-sensitive key-value pairs. A domain can have up to 10 tags. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html">Tagging Amazon OpenSearch Service domains</a>. </p>', 'AssociatePackage' => '<p>Associates a package with an Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages for Amazon OpenSearch Service</a>.</p>', 'AuthorizeVpcEndpointAccess' => '<p>Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.</p>', 'CancelDomainConfigChange' => '<p>Cancels a pending configuration change on an Amazon OpenSearch Service domain.</p>', 'CancelServiceSoftwareUpdate' => '<p>Cancels a scheduled service software update for an Amazon OpenSearch Service domain. You can only perform this operation before the <code>AutomatedUpdateDate</code> and when the domain\'s <code>UpdateStatus</code> is <code>PENDING_UPDATE</code>. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">Service software updates in Amazon OpenSearch Service</a>.</p>', 'CreateDomain' => '<p>Creates an Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html">Creating and managing Amazon OpenSearch Service domains</a>.</p>', 'CreateOutboundConnection' => '<p>Creates a new cross-cluster search connection from a source Amazon OpenSearch Service domain to a destination domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html">Cross-cluster search for Amazon OpenSearch Service</a>.</p>', 'CreatePackage' => '<p>Creates a package for use with Amazon OpenSearch Service domains. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages for Amazon OpenSearch Service</a>.</p>', 'CreateVpcEndpoint' => '<p>Creates an Amazon OpenSearch Service-managed VPC endpoint.</p>', 'DeleteDataSource' => '<p>Deletes a direct-query data source. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-delete.html">Deleting an Amazon OpenSearch Service data source with Amazon S3</a>.</p>', 'DeleteDomain' => '<p>Deletes an Amazon OpenSearch Service domain and all of its data. You can\'t recover a domain after you delete it.</p>', 'DeleteInboundConnection' => '<p>Allows the destination Amazon OpenSearch Service domain owner to delete an existing inbound cross-cluster search connection. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html">Cross-cluster search for Amazon OpenSearch Service</a>.</p>', 'DeleteOutboundConnection' => '<p>Allows the source Amazon OpenSearch Service domain owner to delete an existing outbound cross-cluster search connection. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html">Cross-cluster search for Amazon OpenSearch Service</a>.</p>', 'DeletePackage' => '<p>Deletes an Amazon OpenSearch Service package. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages for Amazon OpenSearch Service</a>.</p>', 'DeleteVpcEndpoint' => '<p>Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.</p>', 'DescribeDomain' => '<p>Describes the domain configuration for the specified Amazon OpenSearch Service domain, including the domain ID, domain service endpoint, and domain ARN.</p>', 'DescribeDomainAutoTunes' => '<p>Returns the list of optimizations that Auto-Tune has made to an Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon OpenSearch Service</a>.</p>', 'DescribeDomainChangeProgress' => '<p>Returns information about the current blue/green deployment happening on an Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes.html">Making configuration changes in Amazon OpenSearch Service</a>.</p>', 'DescribeDomainConfig' => '<p>Returns the configuration of an Amazon OpenSearch Service domain.</p>', 'DescribeDomainHealth' => '<p>Returns information about domain and node health, the standby Availability Zone, number of nodes per Availability Zone, and shard count per node.</p>', 'DescribeDomainNodes' => '<p>Returns information about domain and nodes, including data nodes, master nodes, ultrawarm nodes, Availability Zone(s), standby nodes, node configurations, and node states.</p>', 'DescribeDomains' => '<p>Returns domain configuration information about the specified Amazon OpenSearch Service domains.</p>', 'DescribeDryRunProgress' => '<p>Describes the progress of a pre-update dry run analysis on an Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes#dryrun">Determining whether a change will cause a blue/green deployment</a>.</p>', 'DescribeInboundConnections' => '<p>Lists all the inbound cross-cluster search connections for a destination (remote) Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html">Cross-cluster search for Amazon OpenSearch Service</a>.</p>', 'DescribeInstanceTypeLimits' => '<p>Describes the instance count, storage, and master node limits for a given OpenSearch or Elasticsearch version and instance type.</p>', 'DescribeOutboundConnections' => '<p>Lists all the outbound cross-cluster connections for a local (source) Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html">Cross-cluster search for Amazon OpenSearch Service</a>.</p>', 'DescribePackages' => '<p>Describes all packages available to OpenSearch Service. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages for Amazon OpenSearch Service</a>.</p>', 'DescribeReservedInstanceOfferings' => '<p>Describes the available Amazon OpenSearch Service Reserved Instance offerings for a given Region. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html">Reserved Instances in Amazon OpenSearch Service</a>.</p>', 'DescribeReservedInstances' => '<p>Describes the Amazon OpenSearch Service instances that you have reserved in a given Region. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ri.html">Reserved Instances in Amazon OpenSearch Service</a>.</p>', 'DescribeVpcEndpoints' => '<p>Describes one or more Amazon OpenSearch Service-managed VPC endpoints.</p>', 'DissociatePackage' => '<p>Removes a package from the specified Amazon OpenSearch Service domain. The package can\'t be in use with any OpenSearch index for the dissociation to succeed. The package is still available in OpenSearch Service for association later. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages for Amazon OpenSearch Service</a>.</p>', 'GetCompatibleVersions' => '<p>Returns a map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.</p>', 'GetDataSource' => '<p>Retrieves information about a direct query data source.</p>', 'GetDomainMaintenanceStatus' => '<p>The status of the maintenance action.</p>', 'GetPackageVersionHistory' => '<p>Returns a list of Amazon OpenSearch Service package versions, along with their creation time, commit message, and plugin properties (if the package is a zip plugin package). For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages for Amazon OpenSearch Service</a>.</p>', 'GetUpgradeHistory' => '<p>Retrieves the complete history of the last 10 upgrades performed on an Amazon OpenSearch Service domain.</p>', 'GetUpgradeStatus' => '<p>Returns the most recent status of the last upgrade or upgrade eligibility check performed on an Amazon OpenSearch Service domain.</p>', 'ListDataSources' => '<p>Lists direct-query data sources for a specific domain. For more information, see For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3.html">Working with Amazon OpenSearch Service direct queries with Amazon S3</a>.</p>', 'ListDomainMaintenances' => '<p>A list of maintenance actions for the domain.</p>', 'ListDomainNames' => '<p>Returns the names of all Amazon OpenSearch Service domains owned by the current user in the active Region.</p>', 'ListDomainsForPackage' => '<p>Lists all Amazon OpenSearch Service domains associated with a given package. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages for Amazon OpenSearch Service</a>.</p>', 'ListInstanceTypeDetails' => '<p>Lists all instance types and available features for a given OpenSearch or Elasticsearch version.</p>', 'ListPackagesForDomain' => '<p>Lists all packages associated with an Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages for Amazon OpenSearch Service</a>.</p>', 'ListScheduledActions' => '<p>Retrieves a list of configuration changes that are scheduled for a domain. These changes can be <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">service software updates</a> or <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types">blue/green Auto-Tune enhancements</a>.</p>', 'ListTags' => '<p>Returns all resource tags for an Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-awsresourcetagging.html">Tagging Amazon OpenSearch Service domains</a>.</p>', 'ListVersions' => '<p>Lists all versions of OpenSearch and Elasticsearch that Amazon OpenSearch Service supports.</p>', 'ListVpcEndpointAccess' => '<p>Retrieves information about each Amazon Web Services principal that is allowed to access a given Amazon OpenSearch Service domain through the use of an interface VPC endpoint.</p>', 'ListVpcEndpoints' => '<p>Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current Amazon Web Services account and Region.</p>', 'ListVpcEndpointsForDomain' => '<p>Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.</p>', 'PurchaseReservedInstanceOffering' => '<p>Allows you to purchase Amazon OpenSearch Service Reserved Instances.</p>', 'RejectInboundConnection' => '<p>Allows the remote Amazon OpenSearch Service domain owner to reject an inbound cross-cluster connection request.</p>', 'RemoveTags' => '<p>Removes the specified set of tags from an Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains.html#managedomains-awsresorcetagging"> Tagging Amazon OpenSearch Service domains</a>.</p>', 'RevokeVpcEndpointAccess' => '<p>Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.</p>', 'StartDomainMaintenance' => '<p>Starts the node maintenance process on the data node. These processes can include a node reboot, an Opensearch or Elasticsearch process restart, or a Dashboard or Kibana restart.</p>', 'StartServiceSoftwareUpdate' => '<p>Schedules a service software update for an Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">Service software updates in Amazon OpenSearch Service</a>.</p>', 'UpdateDataSource' => '<p>Updates a direct-query data source. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/direct-query-s3-creating.html">Working with Amazon OpenSearch Service data source integrations with Amazon S3</a>.</p>', 'UpdateDomainConfig' => '<p>Modifies the cluster configuration of the specified Amazon OpenSearch Service domain.</p>', 'UpdatePackage' => '<p>Updates a package for use with Amazon OpenSearch Service domains. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages for Amazon OpenSearch Service</a>.</p>', 'UpdateScheduledAction' => '<p>Reschedules a planned domain configuration change for a later time. This change can be a scheduled <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">service software update</a> or a <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types">blue/green Auto-Tune enhancement</a>.</p>', 'UpdateVpcEndpoint' => '<p>Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.</p>', 'UpgradeDomain' => '<p>Allows you to either upgrade your Amazon OpenSearch Service domain or perform an upgrade eligibility check to a compatible version of OpenSearch or Elasticsearch.</p>', ], 'shapes' => [ 'AIMLOptionsInput' => [ 'base' => '<p>Container for parameters required to enable all machine learning features.</p>', 'refs' => [ 'CreateDomainRequest$AIMLOptions' => '<p>Options for all machine learning features for the specified domain.</p>', 'UpdateDomainConfigRequest$AIMLOptions' => '<p>Options for all machine learning features for the specified domain.</p>', ], ], 'AIMLOptionsOutput' => [ 'base' => '<p>Container for parameters representing the state of machine learning features on the specified domain.</p>', 'refs' => [ 'AIMLOptionsStatus$Options' => '<p>Machine learning options on the specified domain.</p>', 'DomainStatus$AIMLOptions' => '<p>Container for parameters required to enable all machine learning features.</p>', ], ], 'AIMLOptionsStatus' => [ 'base' => '<p>The status of machine learning options on the specified domain.</p>', 'refs' => [ 'DomainConfig$AIMLOptions' => '<p>Container for parameters required to enable all machine learning features.</p>', ], ], 'ARN' => [ 'base' => '<p>The Amazon Resource Name (ARN) of the domain. See <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/index.html">Identifiers for IAM Entities </a> in <i>Using Amazon Web Services Identity and Access Management</i> for more information. </p>', 'refs' => [ 'AddTagsRequest$ARN' => '<p>Amazon Resource Name (ARN) for the OpenSearch Service domain to which you want to attach resource tags.</p>', 'DomainEndpointOptions$CustomEndpointCertificateArn' => '<p>The ARN for your security certificate, managed in Amazon Web Services Certificate Manager (ACM).</p>', 'DomainStatus$ARN' => '<p>The Amazon Resource Name (ARN) of the domain. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM identifiers </a> in the <i>AWS Identity and Access Management User Guide</i>.</p>', 'ListTagsRequest$ARN' => '<p>Amazon Resource Name (ARN) for the domain to view tags for.</p>', 'MasterUserOptions$MasterUserARN' => '<p>Amazon Resource Name (ARN) for the master user. Only specify if <code>InternalUserDatabaseEnabled</code> is <code>false</code>.</p>', 'RemoveTagsRequest$ARN' => '<p>The Amazon Resource Name (ARN) of the domain from which you want to delete the specified tags.</p>', ], ], 'AWSAccount' => [ 'base' => NULL, 'refs' => [ 'AuthorizeVpcEndpointAccessRequest$Account' => '<p>The Amazon Web Services account ID to grant access to.</p>', 'RevokeVpcEndpointAccessRequest$Account' => '<p>The account ID to revoke access from.</p>', 'VpcEndpoint$VpcEndpointOwner' => '<p>The creator of the endpoint.</p>', ], ], 'AWSDomainInformation' => [ 'base' => '<p>Information about an Amazon OpenSearch Service domain.</p>', 'refs' => [ 'DomainInformationContainer$AWSDomainInformation' => '<p>Information about an Amazon OpenSearch Service domain.</p>', ], ], 'AcceptInboundConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code>AcceptInboundConnection</code> operation.</p>', 'refs' => [], ], 'AcceptInboundConnectionResponse' => [ 'base' => '<p>Contains details about the accepted inbound connection.</p>', 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>An error occurred because you don\'t have permissions to access the resource.</p>', 'refs' => [], ], 'AccessPoliciesStatus' => [ 'base' => '<p>The configured access rules for the domain\'s search endpoint, and the current status of those rules.</p>', 'refs' => [ 'DomainConfig$AccessPolicies' => '<p>Specifies the access policies for the domain.</p>', ], ], 'ActionSeverity' => [ 'base' => NULL, 'refs' => [ 'ScheduledAction$Severity' => '<p>The severity of the action.</p>', ], ], 'ActionStatus' => [ 'base' => NULL, 'refs' => [ 'ScheduledAction$Status' => '<p>The current status of the scheduled action.</p>', ], ], 'ActionType' => [ 'base' => NULL, 'refs' => [ 'ScheduledAction$Type' => '<p>The type of action that will be taken on the domain.</p>', 'UpdateScheduledActionRequest$ActionType' => '<p>The type of action to reschedule. Can be one of <code>SERVICE_SOFTWARE_UPDATE</code>, <code>JVM_HEAP_SIZE_TUNING</code>, or <code>JVM_YOUNG_GEN_TUNING</code>. To retrieve this value, send a <a href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html">ListScheduledActions</a> request.</p>', ], ], 'AddDataSourceRequest' => [ 'base' => '<p>Container for the parameters to the <code>AddDataSource</code> operation.</p>', 'refs' => [], ], 'AddDataSourceResponse' => [ 'base' => '<p>The result of an <code>AddDataSource</code> operation.</p>', 'refs' => [], ], 'AddTagsRequest' => [ 'base' => '<p>Container for the parameters to the <code>AddTags</code> operation. Specifies the tags to attach to the domain.</p>', 'refs' => [], ], 'AdditionalLimit' => [ 'base' => '<p> List of limits that are specific to a given instance type.</p>', 'refs' => [ 'AdditionalLimitList$member' => NULL, ], ], 'AdditionalLimitList' => [ 'base' => NULL, 'refs' => [ 'Limits$AdditionalLimits' => '<p>List of additional limits that are specific to a given instance type for each of its instance roles.</p>', ], ], 'AdvancedOptions' => [ 'base' => '<p>Exposes native OpenSearch configuration values from <code>opensearch.yml</code>. The following advanced options are available: </p> <ul> <li> <p>Allows references to indexes in an HTTP request body. Must be <code>false</code> when configuring access to individual sub-resources. Default is <code>true</code>.</p> </li> <li> <p>Specifies the percentage of heap space allocated to field data. Default is unbounded.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">Advanced cluster parameters</a>.</p>', 'refs' => [ 'AdvancedOptionsStatus$Options' => '<p>The status of advanced options for the specified domain.</p>', 'CreateDomainRequest$AdvancedOptions' => '<p>Key-value pairs to specify advanced configuration options. The following key-value pairs are supported:</p> <ul> <li> <p> <code>"rest.action.multi.allow_explicit_index": "true" | "false"</code> - Note the use of a string rather than a boolean. Specifies whether explicit references to indexes are allowed inside the body of HTTP requests. If you want to configure access policies for domain sub-resources, such as specific indexes and domain APIs, you must disable this property. Default is true.</p> </li> <li> <p> <code>"indices.fielddata.cache.size": "80" </code> - Note the use of a string rather than a boolean. Specifies the percentage of heap space allocated to field data. Default is unbounded.</p> </li> <li> <p> <code>"indices.query.bool.max_clause_count": "1024"</code> - Note the use of a string rather than a boolean. Specifies the maximum number of clauses allowed in a Lucene boolean query. Default is 1,024. Queries with more than the permitted number of clauses result in a <code>TooManyClauses</code> error.</p> </li> <li> <p> <code>"override_main_response_version": "true" | "false"</code> - Note the use of a string rather than a boolean. Specifies whether the domain reports its version as 7.10 to allow Elasticsearch OSS clients and plugins to continue working with it. Default is false when creating a domain and true when upgrading a domain.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">Advanced cluster parameters</a>.</p>', 'DomainStatus$AdvancedOptions' => '<p>Key-value pairs that specify advanced configuration options.</p>', 'UpdateDomainConfigRequest$AdvancedOptions' => '<p>Key-value pairs to specify advanced configuration options. The following key-value pairs are supported:</p> <ul> <li> <p> <code>"rest.action.multi.allow_explicit_index": "true" | "false"</code> - Note the use of a string rather than a boolean. Specifies whether explicit references to indexes are allowed inside the body of HTTP requests. If you want to configure access policies for domain sub-resources, such as specific indexes and domain APIs, you must disable this property. Default is true.</p> </li> <li> <p> <code>"indices.fielddata.cache.size": "80" </code> - Note the use of a string rather than a boolean. Specifies the percentage of heap space allocated to field data. Default is unbounded.</p> </li> <li> <p> <code>"indices.query.bool.max_clause_count": "1024"</code> - Note the use of a string rather than a boolean. Specifies the maximum number of clauses allowed in a Lucene boolean query. Default is 1,024. Queries with more than the permitted number of clauses result in a <code>TooManyClauses</code> error.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">Advanced cluster parameters</a>.</p>', 'UpgradeDomainRequest$AdvancedOptions' => '<p>Only supports the <code>override_main_response_version</code> parameter and not other advanced options. You can only include this option when upgrading to an OpenSearch version. Specifies whether the domain reports its version as 7.10 so that it continues to work with Elasticsearch OSS clients and plugins.</p>', 'UpgradeDomainResponse$AdvancedOptions' => '<p>The advanced options configuration for the domain.</p>', ], ], 'AdvancedOptionsStatus' => [ 'base' => '<p>Status of the advanced options for the specified domain. The following options are available: </p> <ul> <li> <p> <code>"rest.action.multi.allow_explicit_index": "true" | "false"</code> - Note the use of a string rather than a boolean. Specifies whether explicit references to indexes are allowed inside the body of HTTP requests. If you want to configure access policies for domain sub-resources, such as specific indexes and domain APIs, you must disable this property. Default is true.</p> </li> <li> <p> <code>"indices.fielddata.cache.size": "80" </code> - Note the use of a string rather than a boolean. Specifies the percentage of heap space allocated to field data. Default is unbounded.</p> </li> <li> <p> <code>"indices.query.bool.max_clause_count": "1024"</code> - Note the use of a string rather than a boolean. Specifies the maximum number of clauses allowed in a Lucene boolean query. Default is 1,024. Queries with more than the permitted number of clauses result in a <code>TooManyClauses</code> error.</p> </li> <li> <p> <code>"override_main_response_version": "true" | "false"</code> - Note the use of a string rather than a boolean. Specifies whether the domain reports its version as 7.10 to allow Elasticsearch OSS clients and plugins to continue working with it. Default is false when creating a domain and true when upgrading a domain.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">Advanced cluster parameters</a>.</p>', 'refs' => [ 'DomainConfig$AdvancedOptions' => '<p>Key-value pairs to specify advanced configuration options. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-advanced-options">Advanced options</a>.</p>', ], ], 'AdvancedSecurityOptions' => [ 'base' => '<p>Container for fine-grained access control settings.</p>', 'refs' => [ 'AdvancedSecurityOptionsStatus$Options' => '<p>Container for fine-grained access control settings.</p>', 'DomainStatus$AdvancedSecurityOptions' => '<p>Settings for fine-grained access control.</p>', ], ], 'AdvancedSecurityOptionsInput' => [ 'base' => '<p>Options for enabling and configuring fine-grained access control. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html">Fine-grained access control in Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'CreateDomainRequest$AdvancedSecurityOptions' => '<p>Options for fine-grained access control.</p>', 'UpdateDomainConfigRequest$AdvancedSecurityOptions' => '<p>Options for fine-grained access control.</p>', ], ], 'AdvancedSecurityOptionsStatus' => [ 'base' => '<p>The status of fine-grained access control settings for a domain.</p>', 'refs' => [ 'DomainConfig$AdvancedSecurityOptions' => '<p>Container for fine-grained access control settings for the domain.</p>', ], ], 'AssociatePackageRequest' => [ 'base' => '<p>Container for the request parameters to the <code>AssociatePackage</code> operation.</p>', 'refs' => [], ], 'AssociatePackageResponse' => [ 'base' => '<p>Container for the response returned by the <code>AssociatePackage</code> operation.</p>', 'refs' => [], ], 'AuthorizeVpcEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizeVpcEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'AuthorizedPrincipal' => [ 'base' => '<p>Information about an Amazon Web Services account or service that has access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.</p>', 'refs' => [ 'AuthorizeVpcEndpointAccessResponse$AuthorizedPrincipal' => '<p>Information about the Amazon Web Services account or service that was provided access to the domain.</p>', 'AuthorizedPrincipalList$member' => NULL, ], ], 'AuthorizedPrincipalList' => [ 'base' => NULL, 'refs' => [ 'ListVpcEndpointAccessResponse$AuthorizedPrincipalList' => '<p>A list of <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM principals</a> that can currently access the domain.</p>', ], ], 'AutoTune' => [ 'base' => '<p>Information about an Auto-Tune action. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'AutoTuneList$member' => NULL, ], ], 'AutoTuneDate' => [ 'base' => '<p>The timestamp of the Auto-Tune action scheduled for the domain.</p>', 'refs' => [ 'ScheduledAutoTuneDetails$Date' => '<p>The date and time when the Auto-Tune action is scheduled for the domain.</p>', ], ], 'AutoTuneDesiredState' => [ 'base' => '<p>The Auto-Tune desired state. Valid values are ENABLED and DISABLED.</p>', 'refs' => [ 'AutoTuneOptions$DesiredState' => '<p>Whether Auto-Tune is enabled or disabled.</p>', 'AutoTuneOptionsInput$DesiredState' => '<p>Whether Auto-Tune is enabled or disabled.</p>', ], ], 'AutoTuneDetails' => [ 'base' => '<p>Specifies details about a scheduled Auto-Tune action. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'AutoTune$AutoTuneDetails' => '<p>Details about an Auto-Tune action.</p>', ], ], 'AutoTuneList' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainAutoTunesResponse$AutoTunes' => '<p>The list of setting adjustments that Auto-Tune has made to the domain.</p>', ], ], 'AutoTuneMaintenanceSchedule' => [ 'base' => '<note> <p>This object is deprecated. Use the domain\'s <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html">off-peak window</a> to schedule Auto-Tune optimizations. For migration instructions, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html#off-peak-migrate">Migrating from Auto-Tune maintenance windows</a>.</p> </note> <p>The Auto-Tune maintenance schedule. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'AutoTuneMaintenanceScheduleList$member' => NULL, ], ], 'AutoTuneMaintenanceScheduleList' => [ 'base' => NULL, 'refs' => [ 'AutoTuneOptions$MaintenanceSchedules' => '<p>DEPRECATED. Use <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html">off-peak window</a> instead.</p> <p>A list of maintenance schedules during which Auto-Tune can deploy changes.</p>', 'AutoTuneOptionsInput$MaintenanceSchedules' => '<p>A list of maintenance schedules during which Auto-Tune can deploy changes. Maintenance windows are deprecated and have been replaced with <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html">off-peak windows</a>.</p>', ], ], 'AutoTuneOptions' => [ 'base' => '<p>Auto-Tune settings when updating a domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'AutoTuneOptionsStatus$Options' => '<p>Auto-Tune settings for updating a domain.</p>', 'UpdateDomainConfigRequest$AutoTuneOptions' => '<p>Options for Auto-Tune.</p>', ], ], 'AutoTuneOptionsInput' => [ 'base' => '<p>Options for configuring Auto-Tune. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon OpenSearch Service</a> </p>', 'refs' => [ 'CreateDomainRequest$AutoTuneOptions' => '<p>Options for Auto-Tune.</p>', ], ], 'AutoTuneOptionsOutput' => [ 'base' => '<p>The Auto-Tune settings for a domain, displayed when enabling or disabling Auto-Tune.</p>', 'refs' => [ 'DomainStatus$AutoTuneOptions' => '<p>Auto-Tune settings for the domain.</p>', ], ], 'AutoTuneOptionsStatus' => [ 'base' => '<p>The Auto-Tune status for the domain.</p>', 'refs' => [ 'DomainConfig$AutoTuneOptions' => '<p>Container for Auto-Tune settings for the domain.</p>', ], ], 'AutoTuneState' => [ 'base' => '<p>The Auto-Tune state for the domain. For valid states see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon OpenSearch Service</a>. </p>', 'refs' => [ 'AutoTuneOptionsOutput$State' => '<p>The current state of Auto-Tune on the domain.</p>', 'AutoTuneStatus$State' => '<p>The current state of Auto-Tune on the domain.</p>', ], ], 'AutoTuneStatus' => [ 'base' => '<p>The current status of Auto-Tune for the domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'AutoTuneOptionsStatus$Status' => '<p>The current status of Auto-Tune for a domain.</p>', ], ], 'AutoTuneType' => [ 'base' => '<p>Specifies the Auto-Tune type. Valid value is SCHEDULED_ACTION.</p>', 'refs' => [ 'AutoTune$AutoTuneType' => '<p>The type of Auto-Tune action.</p>', ], ], 'AvailabilityZone' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZoneInfo$AvailabilityZoneName' => '<p>The name of the Availability Zone.</p>', 'AvailabilityZoneList$member' => NULL, 'DomainNodesStatus$AvailabilityZone' => '<p>The Availability Zone of the node.</p>', ], ], 'AvailabilityZoneInfo' => [ 'base' => '<p>Information about an Availability Zone on a domain.</p>', 'refs' => [ 'AvailabilityZoneInfoList$member' => NULL, ], ], 'AvailabilityZoneInfoList' => [ 'base' => NULL, 'refs' => [ 'EnvironmentInfo$AvailabilityZoneInformation' => '<p> A list of <code>AvailabilityZoneInfo</code> for the domain.</p>', ], ], 'AvailabilityZoneList' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeDetails$AvailabilityZones' => '<p>The supported Availability Zones for the instance type.</p>', ], ], 'BackendRole' => [ 'base' => NULL, 'refs' => [ 'SAMLOptionsInput$MasterBackendRole' => '<p>The backend role that the SAML master user is mapped to.</p>', ], ], 'BaseException' => [ 'base' => '<p>An error occurred while processing the request.</p>', 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'AdvancedSecurityOptions$Enabled' => '<p>True if fine-grained access control is enabled.</p>', 'AdvancedSecurityOptions$InternalUserDatabaseEnabled' => '<p>True if the internal user database is enabled.</p>', 'AdvancedSecurityOptions$AnonymousAuthEnabled' => '<p>True if a 30-day migration period is enabled, during which administrators can create role mappings. Only necessary when <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing">enabling fine-grained access control on an existing domain</a>.</p>', 'AdvancedSecurityOptionsInput$Enabled' => '<p>True to enable fine-grained access control.</p>', 'AdvancedSecurityOptionsInput$InternalUserDatabaseEnabled' => '<p>True to enable the internal user database.</p>', 'AdvancedSecurityOptionsInput$AnonymousAuthEnabled' => '<p>True to enable a 30-day migration period during which administrators can create role mappings. Only necessary when <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing">enabling fine-grained access control on an existing domain</a>.</p>', 'AutoTuneOptions$UseOffPeakWindow' => '<p>Whether to use the domain\'s <a href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html">off-peak window</a> to deploy configuration changes on the domain rather than a maintenance schedule.</p>', 'AutoTuneOptionsInput$UseOffPeakWindow' => '<p>Whether to schedule Auto-Tune optimizations that require blue/green deployments during the domain\'s configured daily off-peak window.</p>', 'AutoTuneOptionsOutput$UseOffPeakWindow' => '<p>Whether the domain\'s off-peak window will be used to deploy Auto-Tune changes rather than a maintenance schedule.</p>', 'AutoTuneStatus$PendingDeletion' => '<p>Indicates whether the domain is being deleted.</p>', 'ClusterConfig$DedicatedMasterEnabled' => '<p>Indicates whether dedicated master nodes are enabled for the cluster.<code>True</code> if the cluster will use a dedicated master node.<code>False</code> if the cluster will not.</p>', 'ClusterConfig$ZoneAwarenessEnabled' => '<p>Indicates whether multiple Availability Zones are enabled. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html">Configuring a multi-AZ domain in Amazon OpenSearch Service</a>.</p>', 'ClusterConfig$WarmEnabled' => '<p>Whether to enable warm storage for the cluster.</p>', 'ClusterConfig$MultiAZWithStandbyEnabled' => '<p>A boolean that indicates whether a multi-AZ domain is turned on with a standby AZ. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html">Configuring a multi-AZ domain in Amazon OpenSearch Service</a>. </p>', 'CognitoOptions$Enabled' => '<p>Whether to enable or disable Amazon Cognito authentication for OpenSearch Dashboards.</p>', 'ColdStorageOptions$Enabled' => '<p>Whether to enable or disable cold storage on the domain. You must enable UltraWarm storage to enable cold storage.</p>', 'DescribeDomainHealthResponse$DedicatedMaster' => '<p>A boolean that indicates if dedicated master nodes are activated for the domain.</p>', 'DescribeDryRunProgressRequest$LoadDryRunConfig' => '<p>Whether to include the configuration of the dry run in the response. The configuration specifies the updates that you\'re planning to make on the domain.</p>', 'DomainEndpointOptions$EnforceHTTPS' => '<p>True to require that all traffic to the domain arrive over HTTPS.</p>', 'DomainEndpointOptions$CustomEndpointEnabled' => '<p>Whether to enable a custom endpoint for the domain.</p>', 'DomainStatus$Created' => '<p>Creation status of an OpenSearch Service domain. True if domain creation is complete. False if domain creation is still in progress.</p>', 'DomainStatus$Deleted' => '<p>Deletion status of an OpenSearch Service domain. True if domain deletion is complete. False if domain deletion is still in progress. Once deletion is complete, the status of the domain is no longer returned.</p>', 'DomainStatus$Processing' => '<p>The status of the domain configuration. True if OpenSearch Service is processing configuration changes. False if the configuration is active.</p>', 'DomainStatus$UpgradeProcessing' => '<p>The status of a domain version upgrade to a new version of OpenSearch or Elasticsearch. True if OpenSearch Service is in the process of a version upgrade. False if the configuration is active.</p>', 'EBSOptions$EBSEnabled' => '<p>Indicates whether EBS volumes are attached to data nodes in an OpenSearch Service domain.</p>', 'EncryptionAtRestOptions$Enabled' => '<p>True to enable encryption at rest.</p>', 'InstanceTypeDetails$EncryptionEnabled' => '<p>Whether encryption at rest and node-to-node encryption are supported for the instance type.</p>', 'InstanceTypeDetails$CognitoEnabled' => '<p>Whether Amazon Cognito access is supported for the instance type.</p>', 'InstanceTypeDetails$AppLogsEnabled' => '<p>Whether logging is supported for the instance type.</p>', 'InstanceTypeDetails$AdvancedSecurityEnabled' => '<p>Whether fine-grained access control is supported for the instance type.</p>', 'InstanceTypeDetails$WarmEnabled' => '<p>Whether UltraWarm is supported for the instance type.</p>', 'JWTOptionsInput$Enabled' => '<p>True to enable JWT authentication and authorization for a domain.</p>', 'JWTOptionsOutput$Enabled' => '<p>True if JWT use is enabled.</p>', 'ListInstanceTypeDetailsRequest$RetrieveAZs' => '<p>An optional parameter that specifies the Availability Zones for the domain.</p>', 'LogPublishingOption$Enabled' => '<p>Whether the log should be published.</p>', 'NodeToNodeEncryptionOptions$Enabled' => '<p>True to enable node-to-node encryption.</p>', 'OffPeakWindowOptions$Enabled' => '<p>Whether to enable an off-peak window.</p> <p>This option is only available when modifying a domain created prior to February 16, 2023, not when creating a new domain. All domains created after this date have the off-peak window enabled by default. You can\'t disable the off-peak window after it\'s enabled for a domain.</p>', 'OptionStatus$PendingDeletion' => '<p>Indicates whether the entity is being deleted.</p>', 'SAMLOptionsInput$Enabled' => '<p>True to enable SAML authentication for a domain.</p>', 'SAMLOptionsOutput$Enabled' => '<p>True if SAML is enabled.</p>', 'ScheduledAction$Mandatory' => '<p>Whether the action is required or optional.</p>', 'ScheduledAction$Cancellable' => '<p>Whether or not the scheduled action is cancellable.</p>', 'ServiceSoftwareOptions$UpdateAvailable' => '<p>True if you\'re able to update your service software version. False if you can\'t update your service software version.</p>', 'ServiceSoftwareOptions$Cancellable' => '<p> True if you\'re able to cancel your service software version update. False if you can\'t cancel your service software update.</p>', 'ServiceSoftwareOptions$OptionalDeployment' => '<p>True if a service software is never automatically updated. False if a service software is automatically updated after the automated update date.</p>', 'SoftwareUpdateOptions$AutoSoftwareUpdateEnabled' => '<p>Whether automatic service software updates are enabled for the domain.</p>', 'UpgradeDomainRequest$PerformCheckOnly' => '<p>When true, indicates that an upgrade eligibility check needs to be performed. Does not actually perform the upgrade.</p>', 'UpgradeDomainResponse$PerformCheckOnly' => '<p>When true, indicates that an upgrade eligibility check was performed.</p>', ], ], 'CancelDomainConfigChangeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CancelDomainConfigChangeResponse' => [ 'base' => NULL, 'refs' => [], ], 'CancelServiceSoftwareUpdateRequest' => [ 'base' => '<p>Container for the request parameters to cancel a service software update.</p>', 'refs' => [], ], 'CancelServiceSoftwareUpdateResponse' => [ 'base' => '<p>Container for the response to a <code>CancelServiceSoftwareUpdate</code> operation. Contains the status of the update.</p>', 'refs' => [], ], 'CancelledChangeProperty' => [ 'base' => '<p>A property change that was cancelled for an Amazon OpenSearch Service domain.</p>', 'refs' => [ 'CancelledChangePropertyList$member' => NULL, ], ], 'CancelledChangePropertyList' => [ 'base' => NULL, 'refs' => [ 'CancelDomainConfigChangeResponse$CancelledChangeProperties' => '<p>The domain change properties that were cancelled.</p>', ], ], 'ChangeProgressDetails' => [ 'base' => '<p>Container for information about a configuration change happening on a domain.</p>', 'refs' => [ 'DomainConfig$ChangeProgressDetails' => '<p>Container for information about the progress of an existing configuration change.</p>', 'DomainStatus$ChangeProgressDetails' => '<p>Information about a configuration change happening on the domain.</p>', 'UpgradeDomainResponse$ChangeProgressDetails' => '<p>Container for information about a configuration change happening on a domain.</p>', ], ], 'ChangeProgressStage' => [ 'base' => '<p>Progress details for each stage of a domain update.</p>', 'refs' => [ 'ChangeProgressStageList$member' => NULL, ], ], 'ChangeProgressStageList' => [ 'base' => '<p>The list of progress stages of a specific domain configuration change.</p>', 'refs' => [ 'ChangeProgressStatusDetails$ChangeProgressStages' => '<p>The specific stages that the domain is going through to perform the configuration change.</p>', ], ], 'ChangeProgressStageName' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressStage$Name' => '<p>The name of the stage.</p>', ], ], 'ChangeProgressStageStatus' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressStage$Status' => '<p>The status of the stage.</p>', ], ], 'ChangeProgressStatusDetails' => [ 'base' => '<p>The progress details of a specific domain configuration change.</p>', 'refs' => [ 'DescribeDomainChangeProgressResponse$ChangeProgressStatus' => '<p>Container for information about the stages of a configuration change happening on a domain.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateVpcEndpointRequest$ClientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', ], ], 'CloudWatchLogsLogGroupArn' => [ 'base' => '<p>ARN of the Cloudwatch log group to publish logs to.</p>', 'refs' => [ 'LogPublishingOption$CloudWatchLogsLogGroupArn' => '<p>The Amazon Resource Name (ARN) of the CloudWatch Logs group to publish logs to.</p>', ], ], 'ClusterConfig' => [ 'base' => '<p>Container for the cluster configuration of an OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html">Creating and managing Amazon OpenSearch Service domains</a>.</p>', 'refs' => [ 'ClusterConfigStatus$Options' => '<p>Cluster configuration options for the specified domain.</p>', 'CreateDomainRequest$ClusterConfig' => '<p>Container for the cluster configuration of a domain.</p>', 'DomainStatus$ClusterConfig' => '<p>Container for the cluster configuration of the domain.</p>', 'UpdateDomainConfigRequest$ClusterConfig' => '<p>Changes that you want to make to the cluster configuration, such as the instance type and number of EC2 instances.</p>', ], ], 'ClusterConfigStatus' => [ 'base' => '<p>The cluster configuration status for a domain.</p>', 'refs' => [ 'DomainConfig$ClusterConfig' => '<p>Container for the cluster configuration of a the domain.</p>', ], ], 'CognitoOptions' => [ 'base' => '<p>Container for the parameters required to enable Cognito authentication for an OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.</p>', 'refs' => [ 'CognitoOptionsStatus$Options' => '<p>Cognito options for the specified domain.</p>', 'CreateDomainRequest$CognitoOptions' => '<p>Key-value pairs to configure Amazon Cognito authentication. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html">Configuring Amazon Cognito authentication for OpenSearch Dashboards</a>.</p>', 'DomainStatus$CognitoOptions' => '<p>Key-value pairs to configure Amazon Cognito authentication for OpenSearch Dashboards.</p>', 'UpdateDomainConfigRequest$CognitoOptions' => '<p>Key-value pairs to configure Amazon Cognito authentication for OpenSearch Dashboards.</p>', ], ], 'CognitoOptionsStatus' => [ 'base' => '<p>The status of the Cognito options for the specified domain.</p>', 'refs' => [ 'DomainConfig$CognitoOptions' => '<p>Container for Amazon Cognito options for the domain.</p>', ], ], 'ColdStorageOptions' => [ 'base' => '<p>Container for the parameters required to enable cold storage for an OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cold-storage.html">Cold storage for Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'ClusterConfig$ColdStorageOptions' => '<p>Container for cold storage configuration options.</p>', ], ], 'CommitMessage' => [ 'base' => NULL, 'refs' => [ 'PackageVersionHistory$CommitMessage' => '<p>A message associated with the package version when it was uploaded.</p>', 'UpdatePackageRequest$CommitMessage' => '<p>Commit message for the updated file, which is shown as part of <code>GetPackageVersionHistoryResponse</code>.</p>', ], ], 'CompatibleVersionsList' => [ 'base' => NULL, 'refs' => [ 'GetCompatibleVersionsResponse$CompatibleVersions' => '<p>A map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.</p>', ], ], 'CompatibleVersionsMap' => [ 'base' => '<p>A map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.</p>', 'refs' => [ 'CompatibleVersionsList$member' => NULL, ], ], 'ConfigChangeStatus' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressDetails$ConfigChangeStatus' => '<p>The current status of the configuration change.</p>', 'ChangeProgressStatusDetails$ConfigChangeStatus' => '<p>The current status of the configuration change.</p>', ], ], 'ConflictException' => [ 'base' => '<p>An error occurred because the client attempts to remove a resource that is currently in use.</p>', 'refs' => [], ], 'ConnectionAlias' => [ 'base' => NULL, 'refs' => [ 'CreateOutboundConnectionRequest$ConnectionAlias' => '<p>Name of the connection.</p>', 'CreateOutboundConnectionResponse$ConnectionAlias' => '<p>Name of the connection.</p>', 'OutboundConnection$ConnectionAlias' => '<p>Name of the connection.</p>', ], ], 'ConnectionId' => [ 'base' => NULL, 'refs' => [ 'AcceptInboundConnectionRequest$ConnectionId' => '<p>The ID of the inbound connection to accept.</p>', 'CreateOutboundConnectionResponse$ConnectionId' => '<p>The unique identifier for the created outbound connection, which is used for subsequent operations on the connection.</p>', 'DeleteInboundConnectionRequest$ConnectionId' => '<p>The ID of the inbound connection to permanently delete.</p>', 'DeleteOutboundConnectionRequest$ConnectionId' => '<p>The ID of the outbound connection you want to permanently delete.</p>', 'InboundConnection$ConnectionId' => '<p>The unique identifier of the connection.</p>', 'OutboundConnection$ConnectionId' => '<p>Unique identifier of the connection.</p>', 'RejectInboundConnectionRequest$ConnectionId' => '<p>The unique identifier of the inbound connection to reject.</p>', ], ], 'ConnectionMode' => [ 'base' => '<p>The connection mode for the cross-cluster connection.</p> <ul> <li> <p> <b>DIRECT</b> - Used for cross-cluster search or cross-cluster replication.</p> </li> <li> <p> <b>VPC_ENDPOINT</b> - Used for remote reindex between Amazon OpenSearch Service VPC domains.</p> </li> </ul>', 'refs' => [ 'CreateOutboundConnectionRequest$ConnectionMode' => '<p>The connection mode.</p>', 'CreateOutboundConnectionResponse$ConnectionMode' => '<p>The connection mode.</p>', 'InboundConnection$ConnectionMode' => '<p>The connection mode.</p>', 'OutboundConnection$ConnectionMode' => '<p>The connection mode.</p>', ], ], 'ConnectionProperties' => [ 'base' => '<p>The connection properties of an outbound connection.</p>', 'refs' => [ 'CreateOutboundConnectionRequest$ConnectionProperties' => '<p>The <code>ConnectionProperties</code> for the outbound connection.</p>', 'CreateOutboundConnectionResponse$ConnectionProperties' => '<p>The <code>ConnectionProperties</code> for the newly created connection.</p>', 'OutboundConnection$ConnectionProperties' => '<p>Properties for the outbound connection.</p>', ], ], 'ConnectionStatusMessage' => [ 'base' => NULL, 'refs' => [ 'InboundConnectionStatus$Message' => '<p>Information about the connection.</p>', 'OutboundConnectionStatus$Message' => '<p>Verbose information for the outbound connection.</p>', ], ], 'CreateDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDomainResponse' => [ 'base' => '<p>The result of a <code>CreateDomain</code> operation. Contains the status of the newly created domain.</p>', 'refs' => [], ], 'CreateOutboundConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code>CreateOutboundConnection</code> operation.</p>', 'refs' => [], ], 'CreateOutboundConnectionResponse' => [ 'base' => '<p>The result of a <code>CreateOutboundConnection</code> request. Contains details about the newly created cross-cluster connection.</p>', 'refs' => [], ], 'CreatePackageRequest' => [ 'base' => '<p>Container for request parameters to the <code>CreatePackage</code> operation.</p>', 'refs' => [], ], 'CreatePackageResponse' => [ 'base' => '<p>Container for the response returned by the <code>CreatePackage</code> operation.</p>', 'refs' => [], ], 'CreateVpcEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreatedAt' => [ 'base' => NULL, 'refs' => [ 'PackageDetails$CreatedAt' => '<p>The timestamp when the package was created.</p>', 'PackageVersionHistory$CreatedAt' => '<p>The date and time when the package was created.</p>', ], ], 'CrossClusterSearchConnectionProperties' => [ 'base' => '<p>Cross-cluster search specific connection properties.</p>', 'refs' => [ 'ConnectionProperties$CrossClusterSearch' => '<p>The connection properties for cross cluster search.</p>', ], ], 'DataSourceDescription' => [ 'base' => NULL, 'refs' => [ 'AddDataSourceRequest$Description' => '<p>A description of the data source.</p>', 'DataSourceDetails$Description' => '<p>A description of the data source.</p>', 'GetDataSourceResponse$Description' => '<p>A description of the data source.</p>', 'UpdateDataSourceRequest$Description' => '<p>A new description of the data source.</p>', ], ], 'DataSourceDetails' => [ 'base' => '<p>Details about a direct-query data source.</p>', 'refs' => [ 'DataSourceList$member' => NULL, ], ], 'DataSourceList' => [ 'base' => NULL, 'refs' => [ 'ListDataSourcesResponse$DataSources' => '<p>A list of data sources associated with specified domain.</p>', ], ], 'DataSourceName' => [ 'base' => NULL, 'refs' => [ 'AddDataSourceRequest$Name' => '<p>A name for the data source.</p>', 'DataSourceDetails$Name' => '<p>The name of the data source.</p>', 'DeleteDataSourceRequest$Name' => '<p>The name of the data source to delete.</p>', 'GetDataSourceRequest$Name' => '<p>The name of the data source to get information about.</p>', 'GetDataSourceResponse$Name' => '<p>The name of the data source.</p>', 'UpdateDataSourceRequest$Name' => '<p>The name of the data source to modify.</p>', ], ], 'DataSourceStatus' => [ 'base' => NULL, 'refs' => [ 'DataSourceDetails$Status' => '<p>The status of the data source.</p>', 'GetDataSourceResponse$Status' => '<p>The status of the data source.</p>', 'UpdateDataSourceRequest$Status' => '<p>The status of the data source update.</p>', ], ], 'DataSourceType' => [ 'base' => '<p>The type of data source.</p>', 'refs' => [ 'AddDataSourceRequest$DataSourceType' => '<p>The type of data source.</p>', 'DataSourceDetails$DataSourceType' => '<p>The type of data source.</p>', 'GetDataSourceResponse$DataSourceType' => '<p>The type of data source.</p>', 'UpdateDataSourceRequest$DataSourceType' => '<p>The type of data source.</p>', ], ], 'DeleteDataSourceRequest' => [ 'base' => '<p>Container for the parameters to the <code>DeleteDataSource</code> operation.</p>', 'refs' => [], ], 'DeleteDataSourceResponse' => [ 'base' => '<p>The result of a <code>GetDataSource</code> operation.</p>', 'refs' => [], ], 'DeleteDomainRequest' => [ 'base' => '<p>Container for the parameters to the <code>DeleteDomain</code> operation.</p>', 'refs' => [], ], 'DeleteDomainResponse' => [ 'base' => '<p>The results of a <code>DeleteDomain</code> request. Contains the status of the pending deletion, or a "domain not found" error if the domain and all of its resources have been deleted.</p>', 'refs' => [], ], 'DeleteInboundConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code>DeleteInboundConnection</code> operation.</p>', 'refs' => [], ], 'DeleteInboundConnectionResponse' => [ 'base' => '<p>The results of a <code>DeleteInboundConnection</code> operation. Contains details about the deleted inbound connection.</p>', 'refs' => [], ], 'DeleteOutboundConnectionRequest' => [ 'base' => '<p>Container for the parameters to the <code>DeleteOutboundConnection</code> operation.</p>', 'refs' => [], ], 'DeleteOutboundConnectionResponse' => [ 'base' => '<p>Details about the deleted outbound connection.</p>', 'refs' => [], ], 'DeletePackageRequest' => [ 'base' => '<p>Deletes a package from OpenSearch Service. The package can\'t be associated with any OpenSearch Service domain.</p>', 'refs' => [], ], 'DeletePackageResponse' => [ 'base' => '<p>Container for the response parameters to the <code>DeletePackage</code> operation.</p>', 'refs' => [], ], 'DeleteVpcEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DependencyFailureException' => [ 'base' => '<p>An exception for when a failure in one of the dependencies results in the service being unable to fetch details about the resource.</p>', 'refs' => [], ], 'DeploymentCloseDateTimeStamp' => [ 'base' => NULL, 'refs' => [ 'ServiceSoftwareOptions$AutomatedUpdateDate' => '<p>The timestamp, in Epoch time, until which you can manually request a service software update. After this date, we automatically update your service software.</p>', ], ], 'DeploymentStatus' => [ 'base' => NULL, 'refs' => [ 'ServiceSoftwareOptions$UpdateStatus' => '<p>The status of your service software update.</p>', ], ], 'DeploymentType' => [ 'base' => NULL, 'refs' => [ 'DryRunResults$DeploymentType' => '<p> Specifies the way in which OpenSearch Service will apply an update. Possible values are:</p> <ul> <li> <p> <b>Blue/Green</b> - The update requires a blue/green deployment.</p> </li> <li> <p> <b>DynamicUpdate</b> - No blue/green deployment required</p> </li> <li> <p> <b>Undetermined</b> - The domain is in the middle of an update and can\'t predict the deployment type. Try again after the update is complete.</p> </li> <li> <p> <b>None</b> - The request doesn\'t include any configuration changes.</p> </li> </ul>', ], ], 'DescribeDomainAutoTunesRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeDomainAutoTunes</code> operation.</p>', 'refs' => [], ], 'DescribeDomainAutoTunesResponse' => [ 'base' => '<p>The result of a <code>DescribeDomainAutoTunes</code> request.</p>', 'refs' => [], ], 'DescribeDomainChangeProgressRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeDomainChangeProgress</code> operation.</p>', 'refs' => [], ], 'DescribeDomainChangeProgressResponse' => [ 'base' => '<p>The result of a <code>DescribeDomainChangeProgress</code> request. Contains progress information for the requested domain change.</p>', 'refs' => [], ], 'DescribeDomainConfigRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeDomainConfig</code> operation.</p>', 'refs' => [], ], 'DescribeDomainConfigResponse' => [ 'base' => '<p>Contains the configuration information of the requested domain.</p>', 'refs' => [], ], 'DescribeDomainHealthRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeDomainHealth</code> operation.</p>', 'refs' => [], ], 'DescribeDomainHealthResponse' => [ 'base' => '<p>The result of a <code>DescribeDomainHealth</code> request. Contains health information for the requested domain.</p>', 'refs' => [], ], 'DescribeDomainNodesRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeDomainNodes</code> operation.</p>', 'refs' => [], ], 'DescribeDomainNodesResponse' => [ 'base' => '<p>The result of a <code>DescribeDomainNodes</code> request. Contains information about the nodes on the requested domain. </p>', 'refs' => [], ], 'DescribeDomainRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeDomain</code> operation.</p>', 'refs' => [], ], 'DescribeDomainResponse' => [ 'base' => '<p>Contains the status of the domain specified in the request.</p>', 'refs' => [], ], 'DescribeDomainsRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeDomains</code> operation.</p>', 'refs' => [], ], 'DescribeDomainsResponse' => [ 'base' => '<p>Contains the status of the specified domains or all domains owned by the account.</p>', 'refs' => [], ], 'DescribeDryRunProgressRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDryRunProgressResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeInboundConnectionsRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeInboundConnections</code> operation.</p>', 'refs' => [], ], 'DescribeInboundConnectionsResponse' => [ 'base' => '<p>Contains a list of connections matching the filter criteria.</p>', 'refs' => [], ], 'DescribeInstanceTypeLimitsRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeInstanceTypeLimits</code> operation.</p>', 'refs' => [], ], 'DescribeInstanceTypeLimitsResponse' => [ 'base' => '<p>Container for the parameters received from the <code>DescribeInstanceTypeLimits</code> operation.</p>', 'refs' => [], ], 'DescribeOutboundConnectionsRequest' => [ 'base' => '<p>Container for the parameters to the <code>DescribeOutboundConnections</code> operation.</p>', 'refs' => [], ], 'DescribeOutboundConnectionsResponse' => [ 'base' => '<p>Contains a list of connections matching the filter criteria.</p>', 'refs' => [], ], 'DescribePackagesFilter' => [ 'base' => '<p>A filter to apply to the <code>DescribePackage</code> response.</p>', 'refs' => [ 'DescribePackagesFilterList$member' => NULL, ], ], 'DescribePackagesFilterList' => [ 'base' => '<p>A list of <code>DescribePackagesFilter</code> to filter the packages included in a <code>DescribePackages</code> response.</p>', 'refs' => [ 'DescribePackagesRequest$Filters' => '<p>Only returns packages that match the <code>DescribePackagesFilterList</code> values.</p>', ], ], 'DescribePackagesFilterName' => [ 'base' => NULL, 'refs' => [ 'DescribePackagesFilter$Name' => '<p>Any field from <code>PackageDetails</code>.</p>', ], ], 'DescribePackagesFilterValue' => [ 'base' => NULL, 'refs' => [ 'DescribePackagesFilterValues$member' => NULL, ], ], 'DescribePackagesFilterValues' => [ 'base' => NULL, 'refs' => [ 'DescribePackagesFilter$Value' => '<p>A non-empty list of values for the specified filter field.</p>', ], ], 'DescribePackagesRequest' => [ 'base' => '<p>Container for the request parameters to the <code>DescribePackage</code> operation.</p>', 'refs' => [], ], 'DescribePackagesResponse' => [ 'base' => '<p>Container for the response returned by the <code>DescribePackages</code> operation.</p>', 'refs' => [], ], 'DescribeReservedInstanceOfferingsRequest' => [ 'base' => '<p>Container for the request parameters to a <code>DescribeReservedInstanceOfferings</code> operation.</p>', 'refs' => [], ], 'DescribeReservedInstanceOfferingsResponse' => [ 'base' => '<p>Container for results of a <code>DescribeReservedInstanceOfferings</code> request.</p>', 'refs' => [], ], 'DescribeReservedInstancesRequest' => [ 'base' => '<p>Container for the request parameters to the <code>DescribeReservedInstances</code> operation.</p>', 'refs' => [], ], 'DescribeReservedInstancesResponse' => [ 'base' => '<p>Container for results from <code>DescribeReservedInstances</code> </p>', 'refs' => [], ], 'DescribeVpcEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeVpcEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressStage$Description' => '<p>The description of the stage.</p>', ], ], 'DisableTimestamp' => [ 'base' => NULL, 'refs' => [ 'AdvancedSecurityOptions$AnonymousAuthDisableDate' => '<p>Date and time when the migration period will be disabled. Only necessary when <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing">enabling fine-grained access control on an existing domain</a>.</p>', ], ], 'DisabledOperationException' => [ 'base' => '<p>An error occured because the client wanted to access an unsupported operation.</p>', 'refs' => [], ], 'DissociatePackageRequest' => [ 'base' => '<p>Container for the request parameters to the <code>DissociatePackage</code> operation.</p>', 'refs' => [], ], 'DissociatePackageResponse' => [ 'base' => '<p>Container for the response returned by an <code>DissociatePackage</code> operation.</p>', 'refs' => [], ], 'DomainArn' => [ 'base' => NULL, 'refs' => [ 'CreateVpcEndpointRequest$DomainArn' => '<p>The Amazon Resource Name (ARN) of the domain to create the endpoint for.</p>', 'VpcEndpoint$DomainArn' => '<p>The Amazon Resource Name (ARN) of the domain associated with the endpoint.</p>', 'VpcEndpointSummary$DomainArn' => '<p>The Amazon Resource Name (ARN) of the domain associated with the endpoint.</p>', ], ], 'DomainConfig' => [ 'base' => '<p>Container for the configuration of an OpenSearch Service domain.</p>', 'refs' => [ 'DescribeDomainConfigResponse$DomainConfig' => '<p>Container for the configuration of the OpenSearch Service domain.</p>', 'UpdateDomainConfigResponse$DomainConfig' => '<p>The status of the updated domain.</p>', ], ], 'DomainEndpointOptions' => [ 'base' => '<p>Options to configure a custom endpoint for an OpenSearch Service domain.</p>', 'refs' => [ 'CreateDomainRequest$DomainEndpointOptions' => '<p>Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.</p>', 'DomainEndpointOptionsStatus$Options' => '<p>Options to configure the endpoint for a domain.</p>', 'DomainStatus$DomainEndpointOptions' => '<p>Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.</p>', 'UpdateDomainConfigRequest$DomainEndpointOptions' => '<p>Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.</p>', ], ], 'DomainEndpointOptionsStatus' => [ 'base' => '<p>The configured endpoint options for a domain and their current status.</p>', 'refs' => [ 'DomainConfig$DomainEndpointOptions' => '<p>Additional options for the domain endpoint, such as whether to require HTTPS for all traffic.</p>', ], ], 'DomainHealth' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainHealthResponse$ClusterHealth' => '<p>The current health status of your cluster.</p> <ul> <li> <p> <code>Red</code> - At least one primary shard is not allocated to any node.</p> </li> <li> <p> <code>Yellow</code> - All primary shards are allocated to nodes, but some replicas aren’t.</p> </li> <li> <p> <code>Green</code> - All primary shards and their replicas are allocated to nodes.</p> </li> <li> <p> <code>NotAvailable</code> - Unable to retrieve cluster health.</p> </li> </ul>', ], ], 'DomainId' => [ 'base' => '<p>Unique identifier for an OpenSearch Service domain.</p>', 'refs' => [ 'DomainStatus$DomainId' => '<p>Unique identifier for the domain.</p>', ], ], 'DomainInfo' => [ 'base' => '<p>Information about an OpenSearch Service domain.</p>', 'refs' => [ 'DomainInfoList$member' => NULL, ], ], 'DomainInfoList' => [ 'base' => '<p>Contains a list of information about a domain.</p>', 'refs' => [ 'ListDomainNamesResponse$DomainNames' => '<p>The names of all OpenSearch Service domains owned by the current user and their respective engine types.</p>', ], ], 'DomainInformationContainer' => [ 'base' => '<p>Container for information about an OpenSearch Service domain.</p>', 'refs' => [ 'CreateOutboundConnectionRequest$LocalDomainInfo' => '<p>Name and Region of the source (local) domain.</p>', 'CreateOutboundConnectionRequest$RemoteDomainInfo' => '<p>Name and Region of the destination (remote) domain.</p>', 'CreateOutboundConnectionResponse$LocalDomainInfo' => '<p>Information about the source (local) domain.</p>', 'CreateOutboundConnectionResponse$RemoteDomainInfo' => '<p>Information about the destination (remote) domain.</p>', 'InboundConnection$LocalDomainInfo' => '<p>Information about the source (local) domain.</p>', 'InboundConnection$RemoteDomainInfo' => '<p>Information about the destination (remote) domain.</p>', 'OutboundConnection$LocalDomainInfo' => '<p>Information about the source (local) domain.</p>', 'OutboundConnection$RemoteDomainInfo' => '<p>Information about the destination (remote) domain.</p>', ], ], 'DomainMaintenanceDetails' => [ 'base' => '<p>Container for the domain maintenance details.</p>', 'refs' => [ 'DomainMaintenanceList$member' => NULL, ], ], 'DomainMaintenanceList' => [ 'base' => NULL, 'refs' => [ 'ListDomainMaintenancesResponse$DomainMaintenances' => '<p>A list of the submitted maintenance actions.</p>', ], ], 'DomainName' => [ 'base' => '<p>The name of an OpenSearch Service domain. Domain names are unique across the domains owned by an account within an Amazon Web Services Region.</p>', 'refs' => [ 'AWSDomainInformation$DomainName' => '<p>Name of the domain.</p>', 'AddDataSourceRequest$DomainName' => '<p>The name of the domain to add the data source to.</p>', 'AssociatePackageRequest$DomainName' => '<p>Name of the domain to associate the package with.</p>', 'AuthorizeVpcEndpointAccessRequest$DomainName' => '<p>The name of the OpenSearch Service domain to provide access to.</p>', 'CancelDomainConfigChangeRequest$DomainName' => NULL, 'CancelServiceSoftwareUpdateRequest$DomainName' => '<p>Name of the OpenSearch Service domain that you want to cancel the service software update on.</p>', 'CreateDomainRequest$DomainName' => '<p>Name of the OpenSearch Service domain to create. Domain names are unique across the domains owned by an account within an Amazon Web Services Region.</p>', 'DeleteDataSourceRequest$DomainName' => '<p>The name of the domain.</p>', 'DeleteDomainRequest$DomainName' => '<p>The name of the domain you want to permanently delete.</p>', 'DescribeDomainAutoTunesRequest$DomainName' => '<p>Name of the domain that you want Auto-Tune details about.</p>', 'DescribeDomainChangeProgressRequest$DomainName' => '<p>The name of the domain to get progress information for.</p>', 'DescribeDomainConfigRequest$DomainName' => '<p>Name of the OpenSearch Service domain configuration that you want to describe.</p>', 'DescribeDomainHealthRequest$DomainName' => '<p>The name of the domain.</p>', 'DescribeDomainNodesRequest$DomainName' => '<p>The name of the domain.</p>', 'DescribeDomainRequest$DomainName' => '<p>The name of the domain that you want information about.</p>', 'DescribeDryRunProgressRequest$DomainName' => '<p>The name of the domain.</p>', 'DescribeInstanceTypeLimitsRequest$DomainName' => '<p>The name of the domain. Only specify if you need the limits for an existing domain.</p>', 'DissociatePackageRequest$DomainName' => '<p>Name of the domain to dissociate the package from.</p>', 'DomainInfo$DomainName' => '<p>Name of the domain.</p>', 'DomainMaintenanceDetails$DomainName' => '<p>The name of the domain.</p>', 'DomainNameList$member' => NULL, 'DomainPackageDetails$DomainName' => '<p>Name of the domain that the package is associated with.</p>', 'DomainStatus$DomainName' => '<p>Name of the domain. Domain names are unique across all domains owned by the same account within an Amazon Web Services Region.</p>', 'GetCompatibleVersionsRequest$DomainName' => '<p>The name of an existing domain. Provide this parameter to limit the results to a single domain.</p>', 'GetDataSourceRequest$DomainName' => '<p>The name of the domain.</p>', 'GetDomainMaintenanceStatusRequest$DomainName' => '<p>The name of the domain.</p>', 'GetUpgradeHistoryRequest$DomainName' => '<p>The name of an existing domain.</p>', 'GetUpgradeStatusRequest$DomainName' => '<p>The domain of the domain to get upgrade status information for.</p>', 'ListDataSourcesRequest$DomainName' => '<p>The name of the domain.</p>', 'ListDomainMaintenancesRequest$DomainName' => '<p>The name of the domain.</p>', 'ListInstanceTypeDetailsRequest$DomainName' => '<p>The name of the domain.</p>', 'ListPackagesForDomainRequest$DomainName' => '<p>The name of the domain for which you want to list associated packages.</p>', 'ListScheduledActionsRequest$DomainName' => '<p>The name of the domain.</p>', 'ListVpcEndpointAccessRequest$DomainName' => '<p>The name of the OpenSearch Service domain to retrieve access information for.</p>', 'ListVpcEndpointsForDomainRequest$DomainName' => '<p>The name of the domain to list associated VPC endpoints for.</p>', 'RevokeVpcEndpointAccessRequest$DomainName' => '<p>The name of the OpenSearch Service domain.</p>', 'StartDomainMaintenanceRequest$DomainName' => '<p>The name of the domain.</p>', 'StartServiceSoftwareUpdateRequest$DomainName' => '<p>The name of the domain that you want to update to the latest service software.</p>', 'UpdateDataSourceRequest$DomainName' => '<p>The name of the domain.</p>', 'UpdateDomainConfigRequest$DomainName' => '<p>The name of the domain that you\'re updating.</p>', 'UpdateScheduledActionRequest$DomainName' => '<p>The name of the domain to reschedule an action for.</p>', 'UpgradeDomainRequest$DomainName' => '<p>Name of the OpenSearch Service domain that you want to upgrade.</p>', 'UpgradeDomainResponse$DomainName' => '<p>The name of the domain that was upgraded.</p>', ], ], 'DomainNameFqdn' => [ 'base' => NULL, 'refs' => [ 'DomainEndpointOptions$CustomEndpoint' => '<p>The fully qualified URL for the custom endpoint.</p>', ], ], 'DomainNameList' => [ 'base' => '<p>A list of OpenSearch Service domain names.</p>', 'refs' => [ 'DescribeDomainsRequest$DomainNames' => '<p>Array of OpenSearch Service domain names that you want information about. You must specify at least one domain name.</p>', ], ], 'DomainNodesStatus' => [ 'base' => '<p>Container for information about nodes on the domain.</p>', 'refs' => [ 'DomainNodesStatusList$member' => NULL, ], ], 'DomainNodesStatusList' => [ 'base' => '<p>List of <code>DomainNodesStatus</code> with details about nodes on the requested domain.</p>', 'refs' => [ 'DescribeDomainNodesResponse$DomainNodesStatusList' => '<p>Contains nodes information list <code>DomainNodesStatusList</code> with details about the all nodes on the requested domain.</p>', ], ], 'DomainPackageDetails' => [ 'base' => '<p>Information about a package that is associated with a domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/custom-packages.html">Custom packages for Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'AssociatePackageResponse$DomainPackageDetails' => '<p>Information about a package that is associated with a domain.</p>', 'DissociatePackageResponse$DomainPackageDetails' => '<p> Information about a package that has been dissociated from the domain.</p>', 'DomainPackageDetailsList$member' => NULL, ], ], 'DomainPackageDetailsList' => [ 'base' => NULL, 'refs' => [ 'ListDomainsForPackageResponse$DomainPackageDetailsList' => '<p>Information about all domains associated with a package.</p>', 'ListPackagesForDomainResponse$DomainPackageDetailsList' => '<p>List of all packages associated with a domain.</p>', ], ], 'DomainPackageStatus' => [ 'base' => NULL, 'refs' => [ 'DomainPackageDetails$DomainPackageStatus' => '<p>State of the association.</p>', ], ], 'DomainProcessingStatusType' => [ 'base' => NULL, 'refs' => [ 'DomainStatus$DomainProcessingStatus' => '<p>The status of any changes that are currently in progress for the domain.</p>', ], ], 'DomainState' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainHealthResponse$DomainState' => '<p>The current state of the domain.</p> <ul> <li> <p> <code>Processing</code> - The domain has updates in progress.</p> </li> <li> <p> <code>Active</code> - Requested changes have been processed and deployed to the domain.</p> </li> </ul>', ], ], 'DomainStatus' => [ 'base' => '<p>The current status of an OpenSearch Service domain.</p>', 'refs' => [ 'CreateDomainResponse$DomainStatus' => '<p>The status of the newly created domain.</p>', 'DeleteDomainResponse$DomainStatus' => '<p>The status of the domain being deleted.</p>', 'DescribeDomainResponse$DomainStatus' => '<p>List that contains the status of each specified OpenSearch Service domain.</p>', 'DescribeDryRunProgressResponse$DryRunConfig' => '<p>Details about the changes you\'re planning to make on the domain.</p>', 'DomainStatusList$member' => NULL, ], ], 'DomainStatusList' => [ 'base' => '<p>List that contains the status of each specified OpenSearch Service domain.</p>', 'refs' => [ 'DescribeDomainsResponse$DomainStatusList' => '<p>The status of the requested domains.</p>', ], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'RecurringCharge$RecurringChargeAmount' => '<p>The monetary amount of the recurring charge.</p>', 'ReservedInstance$FixedPrice' => '<p>The upfront fixed charge you will paid to purchase the specific Reserved Instance offering.</p>', 'ReservedInstance$UsagePrice' => '<p>The hourly rate at which you\'re charged for the domain using this Reserved Instance.</p>', 'ReservedInstanceOffering$FixedPrice' => '<p>The upfront fixed charge you will pay to purchase the specific Reserved Instance offering.</p>', 'ReservedInstanceOffering$UsagePrice' => '<p>The hourly rate at which you\'re charged for the domain using this Reserved Instance.</p>', 'UpgradeStepItem$ProgressPercent' => '<p>The floating point value representing the progress percentage of a particular step.</p>', ], ], 'DryRun' => [ 'base' => NULL, 'refs' => [ 'CancelDomainConfigChangeRequest$DryRun' => '<p>When set to <code>True</code>, returns the list of change IDs and properties that will be cancelled without actually cancelling the change.</p>', 'CancelDomainConfigChangeResponse$DryRun' => '<p>Whether or not the request was a dry run. If <code>True</code>, the changes were not actually cancelled. </p>', 'UpdateDomainConfigRequest$DryRun' => '<p>This flag, when set to True, specifies whether the <code>UpdateDomain</code> request should return the results of a dry run analysis without actually applying the change. A dry run determines what type of deployment the update will cause.</p>', ], ], 'DryRunMode' => [ 'base' => NULL, 'refs' => [ 'UpdateDomainConfigRequest$DryRunMode' => '<p>The type of dry run to perform.</p> <ul> <li> <p> <code>Basic</code> only returns the type of deployment (blue/green or dynamic) that the update will cause.</p> </li> <li> <p> <code>Verbose</code> runs an additional check to validate the changes you\'re making. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-configuration-changes#validation-check">Validating a domain update</a>.</p> </li> </ul>', ], ], 'DryRunProgressStatus' => [ 'base' => '<p>Information about the progress of a pre-upgrade dry run analysis.</p>', 'refs' => [ 'DescribeDryRunProgressResponse$DryRunProgressStatus' => '<p>The current status of the dry run, including any validation errors.</p>', 'UpdateDomainConfigResponse$DryRunProgressStatus' => '<p>The status of the dry run being performed on the domain, if any.</p>', ], ], 'DryRunResults' => [ 'base' => '<p>Results of a dry run performed in an update domain request.</p>', 'refs' => [ 'DescribeDryRunProgressResponse$DryRunResults' => '<p>The results of the dry run. </p>', 'UpdateDomainConfigResponse$DryRunResults' => '<p>Results of the dry run performed in the update domain request.</p>', ], ], 'Duration' => [ 'base' => '<p>The duration of a maintenance schedule. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'AutoTuneMaintenanceSchedule$Duration' => '<p>The duration of the maintenance schedule. For example, <code>"Duration": {"Value": 2, "Unit": "HOURS"}</code>.</p>', ], ], 'DurationValue' => [ 'base' => '<p>Integer that specifies the value of a maintenance schedule duration.</p>', 'refs' => [ 'Duration$Value' => '<p>Integer to specify the value of a maintenance schedule duration.</p>', ], ], 'EBSOptions' => [ 'base' => '<p>Container for the parameters required to enable EBS-based storage for an OpenSearch Service domain.</p>', 'refs' => [ 'CreateDomainRequest$EBSOptions' => '<p>Container for the parameters required to enable EBS-based storage for an OpenSearch Service domain.</p>', 'DomainStatus$EBSOptions' => '<p>Container for EBS-based storage settings for the domain.</p>', 'EBSOptionsStatus$Options' => '<p>The configured EBS options for the specified domain.</p>', 'UpdateDomainConfigRequest$EBSOptions' => '<p>The type and size of the EBS volume to attach to instances in the domain.</p>', ], ], 'EBSOptionsStatus' => [ 'base' => '<p>The status of the EBS options for the specified OpenSearch Service domain.</p>', 'refs' => [ 'DomainConfig$EBSOptions' => '<p>Container for EBS options configured for the domain.</p>', ], ], 'EncryptionAtRestOptions' => [ 'base' => '<p>Specifies whether the domain should encrypt data at rest, and if so, the Key Management Service (KMS) key to use. Can only be used when creating a new domain or enabling encryption at rest for the first time on an existing domain. You can\'t modify this parameter after it\'s already been specified.</p>', 'refs' => [ 'CreateDomainRequest$EncryptionAtRestOptions' => '<p>Key-value pairs to enable encryption at rest.</p>', 'DomainStatus$EncryptionAtRestOptions' => '<p>Encryption at rest settings for the domain.</p>', 'EncryptionAtRestOptionsStatus$Options' => '<p>Encryption at rest options for the specified domain.</p>', 'UpdateDomainConfigRequest$EncryptionAtRestOptions' => '<p>Encryption at rest options for the domain.</p>', ], ], 'EncryptionAtRestOptionsStatus' => [ 'base' => '<p>Status of the encryption at rest options for the specified OpenSearch Service domain.</p>', 'refs' => [ 'DomainConfig$EncryptionAtRestOptions' => '<p>Key-value pairs to enable encryption at rest.</p>', ], ], 'Endpoint' => [ 'base' => NULL, 'refs' => [ 'ConnectionProperties$Endpoint' => '<important> <p>The Endpoint attribute cannot be modified. </p> </important> <p>The endpoint of the remote domain. Applicable for VPC_ENDPOINT connection mode.</p>', 'VpcEndpoint$Endpoint' => '<p>The connection endpoint ID for connecting to the domain.</p>', ], ], 'EndpointsMap' => [ 'base' => NULL, 'refs' => [ 'DomainStatus$Endpoints' => '<p>The key-value pair that exists if the OpenSearch Service domain uses VPC endpoints. For example:</p> <ul> <li> <p> <b>IPv4 IP addresses</b> - <code>\'vpc\',\'vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.us-east-1.es.amazonaws.com\'</code> </p> </li> <li> <p> <b>Dual stack IP addresses</b> - <code>\'vpcv2\':\'vpc-endpoint-h2dsd34efgyghrtguk5gt6j2foh4.aos.us-east-1.on.aws\'</code> </p> </li> </ul>', ], ], 'EngineType' => [ 'base' => NULL, 'refs' => [ 'DomainInfo$EngineType' => '<p>The type of search engine that the domain is running.<code>OpenSearch</code> for an OpenSearch engine, or <code>Elasticsearch</code> for a legacy Elasticsearch OSS engine.</p>', 'ListDomainNamesRequest$EngineType' => '<p>Filters the output by domain engine type.</p>', ], ], 'EngineVersion' => [ 'base' => NULL, 'refs' => [ 'PackageDetails$EngineVersion' => '<p>Version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or OpenSearch_X.Y. Defaults to the latest version of OpenSearch.</p>', ], ], 'EnvironmentInfo' => [ 'base' => '<p>Information about the active domain environment.</p>', 'refs' => [ 'EnvironmentInfoList$member' => NULL, ], ], 'EnvironmentInfoList' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainHealthResponse$EnvironmentInformation' => '<p>A list of <code>EnvironmentInfo</code> for the domain. </p>', ], ], 'ErrorDetails' => [ 'base' => '<p>Additional information if the package is in an error state. Null otherwise.</p>', 'refs' => [ 'DomainPackageDetails$ErrorDetails' => '<p>Additional information if the package is in an error state. Null otherwise.</p>', 'PackageDetails$ErrorDetails' => '<p>Additional information if the package is in an error state. Null otherwise.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'BaseException$message' => '<p>A description of the error.</p>', 'ErrorDetails$ErrorMessage' => '<p>A message describing the error.</p>', ], ], 'ErrorType' => [ 'base' => NULL, 'refs' => [ 'ErrorDetails$ErrorType' => '<p>The type of error that occurred.</p>', ], ], 'Filter' => [ 'base' => '<p>A filter used to limit results when describing inbound or outbound cross-cluster connections. You can specify multiple values per filter. A cross-cluster connection must match at least one of the specified values for it to be returned from an operation.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'DescribeInboundConnectionsRequest$Filters' => '<p> A list of filters used to match properties for inbound cross-cluster connections.</p>', 'DescribeOutboundConnectionsRequest$Filters' => '<p>List of filter names and values that you can use for requests.</p>', ], ], 'GUID' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressDetails$ChangeId' => '<p>The ID of the configuration change.</p>', 'ChangeProgressStatusDetails$ChangeId' => '<p>The unique change identifier associated with a specific domain configuration change.</p>', 'DescribeDomainChangeProgressRequest$ChangeId' => '<p>The specific change ID for which you want to get progress information. If omitted, the request returns information about the most recent configuration change.</p>', 'DescribeDryRunProgressRequest$DryRunId' => '<p>The unique identifier of the dry run.</p>', 'DescribeReservedInstanceOfferingsRequest$ReservedInstanceOfferingId' => '<p>The Reserved Instance identifier filter value. Use this parameter to show only the available instance types that match the specified reservation identifier.</p>', 'DescribeReservedInstancesRequest$ReservedInstanceId' => '<p>The reserved instance identifier filter value. Use this parameter to show only the reservation that matches the specified reserved OpenSearch instance ID.</p>', 'DryRunProgressStatus$DryRunId' => '<p>The unique identifier of the dry run.</p>', 'GUIDList$member' => NULL, 'PurchaseReservedInstanceOfferingRequest$ReservedInstanceOfferingId' => '<p>The ID of the Reserved Instance offering to purchase.</p>', 'PurchaseReservedInstanceOfferingResponse$ReservedInstanceId' => '<p>The ID of the Reserved Instance offering that was purchased.</p>', 'ReservedInstance$ReservedInstanceId' => '<p>The unique identifier for the reservation.</p>', 'ReservedInstanceOffering$ReservedInstanceOfferingId' => '<p>The unique identifier of the Reserved Instance offering.</p>', ], ], 'GUIDList' => [ 'base' => NULL, 'refs' => [ 'CancelDomainConfigChangeResponse$CancelledChangeIds' => '<p>The unique identifiers of the changes that were cancelled.</p>', ], ], 'GetCompatibleVersionsRequest' => [ 'base' => '<p>Container for the request parameters to <code>GetCompatibleVersions</code> operation.</p>', 'refs' => [], ], 'GetCompatibleVersionsResponse' => [ 'base' => '<p>Container for the response returned by the <code>GetCompatibleVersions</code> operation.</p>', 'refs' => [], ], 'GetDataSourceRequest' => [ 'base' => '<p>Container for the parameters to the <code>GetDataSource</code> operation.</p>', 'refs' => [], ], 'GetDataSourceResponse' => [ 'base' => '<p>The result of a <code>GetDataSource</code> operation.</p>', 'refs' => [], ], 'GetDomainMaintenanceStatusRequest' => [ 'base' => '<p>Container for the parameters to the <code>GetDomainMaintenanceStatus</code> operation.</p>', 'refs' => [], ], 'GetDomainMaintenanceStatusResponse' => [ 'base' => '<p>The result of a <code>GetDomainMaintenanceStatus</code> request that information about the requested action.</p>', 'refs' => [], ], 'GetPackageVersionHistoryRequest' => [ 'base' => '<p>Container for the request parameters to the <code>GetPackageVersionHistory</code> operation.</p>', 'refs' => [], ], 'GetPackageVersionHistoryResponse' => [ 'base' => '<p>Container for response returned by <code>GetPackageVersionHistory</code> operation.</p>', 'refs' => [], ], 'GetUpgradeHistoryRequest' => [ 'base' => '<p>Container for the request parameters to the <code>GetUpgradeHistory</code> operation.</p>', 'refs' => [], ], 'GetUpgradeHistoryResponse' => [ 'base' => '<p>Container for the response returned by the <code>GetUpgradeHistory</code> operation.</p>', 'refs' => [], ], 'GetUpgradeStatusRequest' => [ 'base' => '<p>Container for the request parameters to the <code>GetUpgradeStatus</code> operation.</p>', 'refs' => [], ], 'GetUpgradeStatusResponse' => [ 'base' => '<p>Container for the response returned by the <code>GetUpgradeStatus</code> operation.</p>', 'refs' => [], ], 'HostedZoneId' => [ 'base' => NULL, 'refs' => [ 'DomainStatus$DomainEndpointV2HostedZoneId' => '<p>The dual stack hosted zone ID for the domain. </p>', ], ], 'IPAddressType' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$IPAddressType' => '<p>Specify either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain resources across IPv4 and IPv6 address types, and is the recommended option. If you set your IP address type to dual stack, you can\'t change your address type later.</p>', 'DomainStatus$IPAddressType' => '<p>The type of IP addresses supported by the endpoint for the domain.</p>', 'IPAddressTypeStatus$Options' => '<p>The IP address options for the domain.</p>', 'UpdateDomainConfigRequest$IPAddressType' => '<p>Specify either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain resources across IPv4 and IPv6 address types, and is the recommended option. If your IP address type is currently set to dual stack, you can\'t change it. </p>', ], ], 'IPAddressTypeStatus' => [ 'base' => '<p>The IP address type status for the domain.</p>', 'refs' => [ 'DomainConfig$IPAddressType' => '<p>Choose either dual stack or IPv4 as your IP address type. Dual stack allows you to share domain resources across IPv4 and IPv6 address types, and is the recommended option. If you set your IP address type to dual stack, you can\'t change your address type later.</p>', ], ], 'IdentityPoolId' => [ 'base' => NULL, 'refs' => [ 'CognitoOptions$IdentityPoolId' => '<p>The Amazon Cognito identity pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.</p>', ], ], 'InboundConnection' => [ 'base' => '<p>Describes an inbound cross-cluster connection for Amazon OpenSearch Service. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cross-cluster-search.html">Cross-cluster search for Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'AcceptInboundConnectionResponse$Connection' => '<p>Information about the accepted inbound connection.</p>', 'DeleteInboundConnectionResponse$Connection' => '<p>The deleted inbound connection.</p>', 'InboundConnections$member' => NULL, 'RejectInboundConnectionResponse$Connection' => '<p>Contains details about the rejected inbound connection.</p>', ], ], 'InboundConnectionStatus' => [ 'base' => '<p>The status of an inbound cross-cluster connection for OpenSearch Service.</p>', 'refs' => [ 'InboundConnection$ConnectionStatus' => '<p>The current status of the connection.</p>', ], ], 'InboundConnectionStatusCode' => [ 'base' => NULL, 'refs' => [ 'InboundConnectionStatus$StatusCode' => '<p>The status code for the connection. Can be one of the following:</p> <ul> <li> <p> <b>PENDING_ACCEPTANCE</b> - Inbound connection is not yet accepted by the remote domain owner.</p> </li> <li> <p> <b>APPROVED</b>: Inbound connection is pending acceptance by the remote domain owner.</p> </li> <li> <p> <b>PROVISIONING</b>: Inbound connection is being provisioned.</p> </li> <li> <p> <b>ACTIVE</b>: Inbound connection is active and ready to use.</p> </li> <li> <p> <b>REJECTING</b>: Inbound connection rejection is in process.</p> </li> <li> <p> <b>REJECTED</b>: Inbound connection is rejected.</p> </li> <li> <p> <b>DELETING</b>: Inbound connection deletion is in progress.</p> </li> <li> <p> <b>DELETED</b>: Inbound connection is deleted and can no longer be used.</p> </li> </ul>', ], ], 'InboundConnections' => [ 'base' => NULL, 'refs' => [ 'DescribeInboundConnectionsResponse$Connections' => '<p>List of inbound connections.</p>', ], ], 'InitiatedBy' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressDetails$InitiatedBy' => '<p>The IAM principal who initiated the configuration change.</p>', 'ChangeProgressStatusDetails$InitiatedBy' => '<p>The IAM principal who initiated the configuration change.</p>', ], ], 'InstanceCount' => [ 'base' => '<p>Number of instances in an OpenSearch Service cluster.</p>', 'refs' => [ 'PurchaseReservedInstanceOfferingRequest$InstanceCount' => '<p>The number of OpenSearch instances to reserve.</p>', ], ], 'InstanceCountLimits' => [ 'base' => '<p>Limits on the number of instances that can be created in OpenSearch Service for a given instance type.</p>', 'refs' => [ 'InstanceLimits$InstanceCountLimits' => '<p>Limits on the number of instances that can be created for a given instance type.</p>', ], ], 'InstanceLimits' => [ 'base' => '<p>Instance-related attributes that are available for a given instance type.</p>', 'refs' => [ 'Limits$InstanceLimits' => '<p>The limits for a given instance type.</p>', ], ], 'InstanceRole' => [ 'base' => NULL, 'refs' => [ 'InstanceRoleList$member' => NULL, 'LimitsByRole$key' => NULL, ], ], 'InstanceRoleList' => [ 'base' => NULL, 'refs' => [ 'InstanceTypeDetails$InstanceRole' => '<p>Whether the instance acts as a data node, a dedicated master node, or an UltraWarm node.</p>', ], ], 'InstanceTypeDetails' => [ 'base' => '<p>Lists all instance types and available features for a given OpenSearch or Elasticsearch version.</p>', 'refs' => [ 'InstanceTypeDetailsList$member' => NULL, ], ], 'InstanceTypeDetailsList' => [ 'base' => NULL, 'refs' => [ 'ListInstanceTypeDetailsResponse$InstanceTypeDetails' => '<p>Lists all supported instance types and features for the given OpenSearch or Elasticsearch version.</p>', ], ], 'InstanceTypeString' => [ 'base' => NULL, 'refs' => [ 'ListInstanceTypeDetailsRequest$InstanceType' => '<p>An optional parameter that lists information for a given instance type.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ReservedInstance$Duration' => '<p>The duration, in seconds, for which the OpenSearch instance is reserved.</p>', 'ReservedInstance$InstanceCount' => '<p>The number of OpenSearch instances that have been reserved.</p>', 'ReservedInstanceOffering$Duration' => '<p>The duration, in seconds, for which the offering will reserve the OpenSearch instance.</p>', ], ], 'IntegerClass' => [ 'base' => NULL, 'refs' => [ 'ClusterConfig$InstanceCount' => '<p>Number of data nodes in the cluster. This number must be greater than 1, otherwise you receive a validation exception.</p>', 'ClusterConfig$DedicatedMasterCount' => '<p>Number of dedicated master nodes in the cluster. This number must be greater than 2 and not 4, otherwise you receive a validation exception.</p>', 'ClusterConfig$WarmCount' => '<p>The number of warm nodes in the cluster.</p>', 'EBSOptions$VolumeSize' => '<p>Specifies the size (in GiB) of EBS volumes attached to data nodes.</p>', 'EBSOptions$Iops' => '<p>Specifies the baseline input/output (I/O) performance of EBS volumes attached to data nodes. Applicable only for the <code>gp3</code> and provisioned IOPS EBS volume types.</p>', 'EBSOptions$Throughput' => '<p>Specifies the throughput (in MiB/s) of the EBS volumes attached to data nodes. Applicable only for the <code>gp3</code> volume type.</p>', 'SAMLOptionsInput$SessionTimeoutMinutes' => '<p>The duration, in minutes, after which a user session becomes inactive. Acceptable values are between 1 and 1440, and the default value is 60.</p>', 'SAMLOptionsOutput$SessionTimeoutMinutes' => '<p>The duration, in minutes, after which a user session becomes inactive.</p>', 'SnapshotOptions$AutomatedSnapshotStartHour' => '<p>The time, in UTC format, when OpenSearch Service takes a daily automated snapshot of the specified domain. Default is <code>0</code> hours.</p>', 'ZoneAwarenessConfig$AvailabilityZoneCount' => '<p>If you enabled multiple Availability Zones, this value is the number of zones that you want the domain to use. Valid values are <code>2</code> and <code>3</code>. If your domain is provisioned within a VPC, this value be equal to number of subnets.</p>', ], ], 'InternalException' => [ 'base' => '<p>Request processing failed because of an unknown error, exception, or internal failure.</p>', 'refs' => [], ], 'InvalidPaginationTokenException' => [ 'base' => '<p>Request processing failed because you provided an invalid pagination token.</p>', 'refs' => [], ], 'InvalidTypeException' => [ 'base' => '<p>An exception for trying to create or access a sub-resource that\'s either invalid or not supported.</p>', 'refs' => [], ], 'Issue' => [ 'base' => NULL, 'refs' => [ 'Issues$member' => NULL, ], ], 'Issues' => [ 'base' => NULL, 'refs' => [ 'UpgradeStepItem$Issues' => '<p>A list of strings containing detailed information about the errors encountered in a particular step.</p>', ], ], 'JWTOptionsInput' => [ 'base' => '<p>The JWT authentication and authorization configuration for an Amazon OpenSearch Service domain.</p>', 'refs' => [ 'AdvancedSecurityOptionsInput$JWTOptions' => '<p>Container for information about the JWT configuration of the Amazon OpenSearch Service. </p>', ], ], 'JWTOptionsOutput' => [ 'base' => '<p>Describes the JWT options configured for the domain.</p>', 'refs' => [ 'AdvancedSecurityOptions$JWTOptions' => '<p>Container for information about the JWT configuration of the Amazon OpenSearch Service.</p>', ], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'EncryptionAtRestOptions$KmsKeyId' => '<p>The KMS key ID. Takes the form <code>1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a</code>.</p>', ], ], 'LastUpdated' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressStage$LastUpdated' => '<p>The most recent updated timestamp of the stage.</p>', 'DomainPackageDetails$LastUpdated' => '<p>Timestamp of the most recent update to the package association status.</p>', 'PackageDetails$LastUpdatedAt' => '<p>Date and time when the package was last updated.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>An exception for trying to create more than the allowed number of resources or sub-resources.</p>', 'refs' => [], ], 'LimitName' => [ 'base' => NULL, 'refs' => [ 'AdditionalLimit$LimitName' => '<ul> <li> <p> <code>MaximumNumberOfDataNodesSupported</code> - This attribute only applies to master nodes and specifies the maximum number of data nodes of a given instance type a master node can support.</p> </li> <li> <p> <code>MaximumNumberOfDataNodesWithoutMasterNode</code> - This attribute only applies to data nodes and specifies the maximum number of data nodes of a given instance type can exist without a master node governing them.</p> </li> </ul>', 'StorageTypeLimit$LimitName' => '<p> Name of storage limits that are applicable for the given storage type. If <code>StorageType</code> is <code>ebs</code>, the following options are available:</p> <ul> <li> <p> <b>MinimumVolumeSize</b> - Minimum volume size that is available for the given storage type. Can be empty if not applicable.</p> </li> <li> <p> <b>MaximumVolumeSize</b> - Maximum volume size that is available for the given storage type. Can be empty if not applicable.</p> </li> <li> <p> <b>MaximumIops</b> - Maximum amount of IOPS that is available for the given the storage type. Can be empty if not applicable.</p> </li> <li> <p> <b>MinimumIops</b> - Minimum amount of IOPS that is available for the given the storage type. Can be empty if not applicable.</p> </li> <li> <p> <b>MaximumThroughput</b> - Maximum amount of throughput that is available for the given the storage type. Can be empty if not applicable.</p> </li> <li> <p> <b>MinimumThroughput</b> - Minimum amount of throughput that is available for the given the storage type. Can be empty if not applicable.</p> </li> </ul>', ], ], 'LimitValue' => [ 'base' => NULL, 'refs' => [ 'LimitValueList$member' => NULL, ], ], 'LimitValueList' => [ 'base' => NULL, 'refs' => [ 'AdditionalLimit$LimitValues' => '<p> The values of the additional instance type limits.</p>', 'StorageTypeLimit$LimitValues' => '<p>The limit values.</p>', ], ], 'Limits' => [ 'base' => '<p>Limits for a given instance type and for each of its roles.</p>', 'refs' => [ 'LimitsByRole$value' => NULL, ], ], 'LimitsByRole' => [ 'base' => '<p> The role of a given instance and all applicable limits. The role performed by a given OpenSearch instance can be one of the following: </p> <ul> <li> <p> <b>data</b> - A data node.</p> </li> <li> <p> <b>master</b> - A dedicated master node.</p> </li> <li> <p> <b>ultra_warm</b> - An UltraWarm node.</p> </li> </ul>', 'refs' => [ 'DescribeInstanceTypeLimitsResponse$LimitsByRole' => '<p>Map that contains all applicable instance type limits.<code>data</code> refers to data nodes.<code>master</code> refers to dedicated master nodes.</p>', ], ], 'ListDataSourcesRequest' => [ 'base' => '<p>Container for the parameters to the <code>ListDataSources</code> operation.</p>', 'refs' => [], ], 'ListDataSourcesResponse' => [ 'base' => '<p>The result of a <code>ListDataSources</code> operation.</p>', 'refs' => [], ], 'ListDomainMaintenancesRequest' => [ 'base' => '<p>Container for the parameters to the <code>ListDomainMaintenances</code> operation.</p>', 'refs' => [], ], 'ListDomainMaintenancesResponse' => [ 'base' => '<p>The result of a <code>ListDomainMaintenances</code> request that contains information about the requested actions. </p>', 'refs' => [], ], 'ListDomainNamesRequest' => [ 'base' => '<p>Container for the parameters to the <code>ListDomainNames</code> operation.</p>', 'refs' => [], ], 'ListDomainNamesResponse' => [ 'base' => '<p>The results of a <code>ListDomainNames</code> operation. Contains the names of all domains owned by this account and their respective engine types.</p>', 'refs' => [], ], 'ListDomainsForPackageRequest' => [ 'base' => '<p>Container for the request parameters to the <code>ListDomainsForPackage</code> operation.</p>', 'refs' => [], ], 'ListDomainsForPackageResponse' => [ 'base' => '<p>Container for the response parameters to the <code>ListDomainsForPackage</code> operation.</p>', 'refs' => [], ], 'ListInstanceTypeDetailsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListInstanceTypeDetailsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListPackagesForDomainRequest' => [ 'base' => '<p>Container for the request parameters to the <code>ListPackagesForDomain</code> operation.</p>', 'refs' => [], ], 'ListPackagesForDomainResponse' => [ 'base' => '<p>Container for the response parameters to the <code>ListPackagesForDomain</code> operation.</p>', 'refs' => [], ], 'ListScheduledActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListScheduledActionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsRequest' => [ 'base' => '<p>Container for the parameters to the <code>ListTags</code> operation.</p>', 'refs' => [], ], 'ListTagsResponse' => [ 'base' => '<p>The results of a <code>ListTags</code> operation.</p>', 'refs' => [], ], 'ListVersionsRequest' => [ 'base' => '<p>Container for the request parameters to the <code>ListVersions</code> operation.</p>', 'refs' => [], ], 'ListVersionsResponse' => [ 'base' => '<p>Container for the parameters for response received from the <code>ListVersions</code> operation.</p>', 'refs' => [], ], 'ListVpcEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVpcEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVpcEndpointsForDomainRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVpcEndpointsForDomainResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVpcEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVpcEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogPublishingOption' => [ 'base' => '<p>Specifies whether the Amazon OpenSearch Service domain publishes the OpenSearch application and slow logs to Amazon CloudWatch. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createdomain-configure-slow-logs.html">Monitoring OpenSearch logs with Amazon CloudWatch Logs</a>.</p> <note> <p>After you enable log publishing, you still have to enable the collection of slow logs using the OpenSearch REST API.</p> </note>', 'refs' => [ 'LogPublishingOptions$value' => NULL, ], ], 'LogPublishingOptions' => [ 'base' => NULL, 'refs' => [ 'CreateDomainRequest$LogPublishingOptions' => '<p>Key-value pairs to configure log publishing.</p>', 'DomainStatus$LogPublishingOptions' => '<p>Log publishing options for the domain.</p>', 'LogPublishingOptionsStatus$Options' => '<p>The log publishing options configured for the domain.</p>', 'UpdateDomainConfigRequest$LogPublishingOptions' => '<p>Options to publish OpenSearch logs to Amazon CloudWatch Logs.</p>', ], ], 'LogPublishingOptionsStatus' => [ 'base' => '<p>The configured log publishing options for the domain and their current status.</p>', 'refs' => [ 'DomainConfig$LogPublishingOptions' => '<p>Key-value pairs to configure log publishing.</p>', ], ], 'LogType' => [ 'base' => '<p>The type of log file. Can be one of the following:</p> <ul> <li> <p> <b>INDEX_SLOW_LOGS</b> - Index slow logs contain insert requests that took more time than the configured index query log threshold to execute.</p> </li> <li> <p> <b>SEARCH_SLOW_LOGS</b> - Search slow logs contain search queries that took more time than the configured search query log threshold to execute.</p> </li> <li> <p> <b>ES_APPLICATION_LOGS</b> - OpenSearch application logs contain information about errors and warnings raised during the operation of the service and can be useful for troubleshooting.</p> </li> <li> <p> <b>AUDIT_LOGS</b> - Audit logs contain records of user requests for access to the domain.</p> </li> </ul>', 'refs' => [ 'LogPublishingOptions$key' => NULL, ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'ReservedInstance$BillingSubscriptionId' => '<p>The unique identifier of the billing subscription.</p>', 'ScheduledAction$ScheduledTime' => '<p>The time when the change is scheduled to happen.</p>', 'SlotList$member' => NULL, 'StartServiceSoftwareUpdateRequest$DesiredStartTime' => '<p>The Epoch timestamp when you want the service software update to start. You only need to specify this parameter if you set <code>ScheduleAt</code> to <code>TIMESTAMP</code>.</p>', 'UpdateScheduledActionRequest$DesiredStartTime' => '<p>The time to implement the change, in Coordinated Universal Time (UTC). Only specify this parameter if you set <code>ScheduleAt</code> to <code>TIMESTAMP</code>.</p>', ], ], 'MaintenanceStatus' => [ 'base' => NULL, 'refs' => [ 'DomainMaintenanceDetails$Status' => '<p>The status of the action.</p>', 'GetDomainMaintenanceStatusResponse$Status' => '<p>The status of the maintenance action.</p>', 'ListDomainMaintenancesRequest$Status' => '<p>The status of the action.</p>', ], ], 'MaintenanceStatusMessage' => [ 'base' => NULL, 'refs' => [ 'DomainMaintenanceDetails$StatusMessage' => '<p>The status message for the action.</p>', 'GetDomainMaintenanceStatusResponse$StatusMessage' => '<p>The status message of the maintenance action.</p>', ], ], 'MaintenanceType' => [ 'base' => NULL, 'refs' => [ 'DomainMaintenanceDetails$Action' => '<p>The name of the action.</p>', 'GetDomainMaintenanceStatusResponse$Action' => '<p>The action name.</p>', 'ListDomainMaintenancesRequest$Action' => '<p>The name of the action.</p>', 'StartDomainMaintenanceRequest$Action' => '<p>The name of the action.</p>', ], ], 'MasterNodeStatus' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainHealthResponse$MasterNode' => '<p>Indicates whether the domain has an elected master node.</p> <ul> <li> <p> <b>Available</b> - The domain has an elected master node.</p> </li> <li> <p> <b>UnAvailable</b> - The master node hasn\'t yet been elected, and a quorum to elect a new master node hasn\'t been reached.</p> </li> </ul>', ], ], 'MasterUserOptions' => [ 'base' => '<p>Credentials for the master user for a domain.</p>', 'refs' => [ 'AdvancedSecurityOptionsInput$MasterUserOptions' => '<p>Container for information about the master user.</p>', ], ], 'MaxResults' => [ 'base' => '<p>An optional parameter that specifies the maximum number of results to return for a given request.</p>', 'refs' => [ 'DescribeDomainAutoTunesRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'DescribeInboundConnectionsRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'DescribeOutboundConnectionsRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'DescribePackagesRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'DescribeReservedInstanceOfferingsRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'DescribeReservedInstancesRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'GetPackageVersionHistoryRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'GetUpgradeHistoryRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'ListDomainMaintenancesRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'ListDomainsForPackageRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'ListInstanceTypeDetailsRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'ListPackagesForDomainRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'ListScheduledActionsRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', 'ListVersionsRequest$MaxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results.</p>', ], ], 'MaximumInstanceCount' => [ 'base' => '<p>Maximum number of instances that can be instantiated for a given instance type.</p>', 'refs' => [ 'InstanceCountLimits$MaximumInstanceCount' => '<p>The minimum allowed number of instances.</p>', ], ], 'Message' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressDetails$Message' => '<p>A message corresponding to the status of the configuration change.</p>', 'DryRunResults$Message' => '<p>A message corresponding to the deployment type.</p>', ], ], 'MinimumInstanceCount' => [ 'base' => '<p> Minimum number of instances that can be instantiated for a given instance type.</p>', 'refs' => [ 'InstanceCountLimits$MinimumInstanceCount' => '<p>The maximum allowed number of instances.</p>', ], ], 'ModifyingProperties' => [ 'base' => '<p>Information about the domain properties that are currently being modified.</p>', 'refs' => [ 'ModifyingPropertiesList$member' => NULL, ], ], 'ModifyingPropertiesList' => [ 'base' => NULL, 'refs' => [ 'DomainConfig$ModifyingProperties' => '<p>Information about the domain properties that are currently being modified.</p>', 'DomainStatus$ModifyingProperties' => '<p>Information about the domain properties that are currently being modified.</p>', ], ], 'NaturalLanguageQueryGenerationCurrentState' => [ 'base' => NULL, 'refs' => [ 'NaturalLanguageQueryGenerationOptionsOutput$CurrentState' => '<p>The current state of the natural language query generation feature, indicating completion, in progress, or failure.</p>', ], ], 'NaturalLanguageQueryGenerationDesiredState' => [ 'base' => NULL, 'refs' => [ 'NaturalLanguageQueryGenerationOptionsInput$DesiredState' => '<p>The desired state of the natural language query generation feature. Valid values are ENABLED and DISABLED.</p>', 'NaturalLanguageQueryGenerationOptionsOutput$DesiredState' => '<p>The desired state of the natural language query generation feature. Valid values are ENABLED and DISABLED.</p>', ], ], 'NaturalLanguageQueryGenerationOptionsInput' => [ 'base' => '<p>Container for parameters required to enable the natural language query generation feature.</p>', 'refs' => [ 'AIMLOptionsInput$NaturalLanguageQueryGenerationOptions' => '<p>Container for parameters required for natural language query generation on the specified domain.</p>', ], ], 'NaturalLanguageQueryGenerationOptionsOutput' => [ 'base' => '<p>Container for parameters representing the state of the natural language query generation feature on the specified domain.</p>', 'refs' => [ 'AIMLOptionsOutput$NaturalLanguageQueryGenerationOptions' => '<p>Container for parameters required for natural language query generation on the specified domain.</p>', ], ], 'NextToken' => [ 'base' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'refs' => [ 'DescribeDomainAutoTunesRequest$NextToken' => '<p>If your initial <code>DescribeDomainAutoTunes</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>DescribeDomainAutoTunes</code> operations, which returns results in the next page.</p>', 'DescribeDomainAutoTunesResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'DescribeInboundConnectionsRequest$NextToken' => '<p>If your initial <code>DescribeInboundConnections</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>DescribeInboundConnections</code> operations, which returns results in the next page.</p>', 'DescribeInboundConnectionsResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'DescribeOutboundConnectionsRequest$NextToken' => '<p>If your initial <code>DescribeOutboundConnections</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>DescribeOutboundConnections</code> operations, which returns results in the next page.</p>', 'DescribeOutboundConnectionsResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'DescribePackagesRequest$NextToken' => '<p>If your initial <code>DescribePackageFilters</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>DescribePackageFilters</code> operations, which returns results in the next page.</p>', 'DescribeReservedInstanceOfferingsRequest$NextToken' => '<p>If your initial <code>DescribeReservedInstanceOfferings</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>DescribeReservedInstanceOfferings</code> operations, which returns results in the next page.</p>', 'DescribeReservedInstanceOfferingsResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'DescribeReservedInstancesRequest$NextToken' => '<p>If your initial <code>DescribeReservedInstances</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>DescribeReservedInstances</code> operations, which returns results in the next page.</p>', 'GetPackageVersionHistoryRequest$NextToken' => '<p>If your initial <code>GetPackageVersionHistory</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>GetPackageVersionHistory</code> operations, which returns results in the next page. </p>', 'GetUpgradeHistoryRequest$NextToken' => '<p>If your initial <code>GetUpgradeHistory</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>GetUpgradeHistory</code> operations, which returns results in the next page.</p>', 'ListDomainMaintenancesRequest$NextToken' => '<p>If your initial <code>ListDomainMaintenances</code> operation returns a <code>nextToken</code>, include the returned <code>nextToken</code> in subsequent <code>ListDomainMaintenances</code> operations, which returns results in the next page.</p>', 'ListDomainMaintenancesResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'ListDomainsForPackageRequest$NextToken' => '<p>If your initial <code>ListDomainsForPackage</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListDomainsForPackage</code> operations, which returns results in the next page.</p>', 'ListInstanceTypeDetailsRequest$NextToken' => '<p>If your initial <code>ListInstanceTypeDetails</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListInstanceTypeDetails</code> operations, which returns results in the next page.</p>', 'ListInstanceTypeDetailsResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'ListPackagesForDomainRequest$NextToken' => '<p>If your initial <code>ListPackagesForDomain</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListPackagesForDomain</code> operations, which returns results in the next page.</p>', 'ListScheduledActionsRequest$NextToken' => '<p>If your initial <code>ListScheduledActions</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListScheduledActions</code> operations, which returns results in the next page.</p>', 'ListScheduledActionsResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'ListVersionsRequest$NextToken' => '<p>If your initial <code>ListVersions</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListVersions</code> operations, which returns results in the next page.</p>', 'ListVersionsResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'ListVpcEndpointAccessRequest$NextToken' => '<p>If your initial <code>ListVpcEndpointAccess</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListVpcEndpointAccess</code> operations, which returns results in the next page.</p>', 'ListVpcEndpointAccessResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'ListVpcEndpointsForDomainRequest$NextToken' => '<p>If your initial <code>ListEndpointsForDomain</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListEndpointsForDomain</code> operations, which returns results in the next page.</p>', 'ListVpcEndpointsForDomainResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'ListVpcEndpointsRequest$NextToken' => '<p>If your initial <code>ListVpcEndpoints</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListVpcEndpoints</code> operations, which returns results in the next page.</p>', 'ListVpcEndpointsResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', ], ], 'NodeId' => [ 'base' => NULL, 'refs' => [ 'DomainMaintenanceDetails$NodeId' => '<p>The ID of the data node.</p>', 'DomainNodesStatus$NodeId' => '<p>The ID of the node.</p>', 'GetDomainMaintenanceStatusResponse$NodeId' => '<p>The node ID of the maintenance action.</p>', 'StartDomainMaintenanceRequest$NodeId' => '<p>The ID of the data node.</p>', ], ], 'NodeStatus' => [ 'base' => NULL, 'refs' => [ 'DomainNodesStatus$NodeStatus' => '<p>Indicates if the node is active or in standby.</p>', ], ], 'NodeToNodeEncryptionOptions' => [ 'base' => '<p>Enables or disables node-to-node encryption. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html">Node-to-node encryption for Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'CreateDomainRequest$NodeToNodeEncryptionOptions' => '<p>Enables node-to-node encryption.</p>', 'DomainStatus$NodeToNodeEncryptionOptions' => '<p>Whether node-to-node encryption is enabled or disabled.</p>', 'NodeToNodeEncryptionOptionsStatus$Options' => '<p>The node-to-node encryption options for the specified domain.</p>', 'UpdateDomainConfigRequest$NodeToNodeEncryptionOptions' => '<p>Node-to-node encryption options for the domain.</p>', ], ], 'NodeToNodeEncryptionOptionsStatus' => [ 'base' => '<p>Status of the node-to-node encryption options for the specified domain.</p>', 'refs' => [ 'DomainConfig$NodeToNodeEncryptionOptions' => '<p>Whether node-to-node encryption is enabled or disabled.</p>', ], ], 'NodeType' => [ 'base' => NULL, 'refs' => [ 'DomainNodesStatus$NodeType' => '<p>Indicates whether the nodes is a data, master, or ultrawarm node.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'Filter$Name' => '<p>The name of the filter.</p>', 'ValueStringList$member' => NULL, ], ], 'NumberOfAZs' => [ 'base' => NULL, 'refs' => [ 'DescribeDomainHealthResponse$AvailabilityZoneCount' => '<p>The number of Availability Zones configured for the domain. If the service is unable to fetch this information, it will return <code>NotAvailable</code>.</p>', 'DescribeDomainHealthResponse$ActiveAvailabilityZoneCount' => '<p>The number of active Availability Zones configured for the domain. If the service is unable to fetch this information, it will return <code>NotAvailable</code>.</p>', 'DescribeDomainHealthResponse$StandByAvailabilityZoneCount' => '<p>The number of standby Availability Zones configured for the domain. If the service is unable to fetch this information, it will return <code>NotAvailable</code>.</p>', ], ], 'NumberOfNodes' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZoneInfo$ConfiguredDataNodeCount' => '<p>The total number of data nodes configured in the Availability Zone.</p>', 'AvailabilityZoneInfo$AvailableDataNodeCount' => '<p>The number of data nodes active in the Availability Zone.</p>', 'DescribeDomainHealthResponse$DataNodeCount' => '<p>The number of data nodes configured for the domain. If the service is unable to fetch this information, it will return <code>NotAvailable</code>.</p>', 'DescribeDomainHealthResponse$MasterEligibleNodeCount' => '<p>The number of nodes that can be elected as a master node. If dedicated master nodes is turned on, this value is the number of dedicated master nodes configured for the domain. If the service is unable to fetch this information, it will return <code>NotAvailable</code>.</p>', 'DescribeDomainHealthResponse$WarmNodeCount' => '<p>The number of warm nodes configured for the domain.</p>', ], ], 'NumberOfShards' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZoneInfo$TotalShards' => '<p>The total number of primary and replica shards in the Availability Zone.</p>', 'AvailabilityZoneInfo$TotalUnAssignedShards' => '<p>The total number of primary and replica shards that aren\'t allocated to any of the nodes in the Availability Zone.</p>', 'DescribeDomainHealthResponse$TotalShards' => '<p>The total number of primary and replica shards for the domain.</p>', 'DescribeDomainHealthResponse$TotalUnAssignedShards' => '<p>The total number of primary and replica shards not allocated to any of the nodes for the cluster.</p>', ], ], 'OffPeakWindow' => [ 'base' => '<p>A custom 10-hour, low-traffic window during which OpenSearch Service can perform mandatory configuration changes on the domain. These actions can include scheduled service software updates and blue/green Auto-Tune enhancements. OpenSearch Service will schedule these actions during the window that you specify.</p> <p>If you don\'t specify a window start time, it defaults to 10:00 P.M. local time.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/off-peak.html">Defining off-peak maintenance windows for Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'OffPeakWindowOptions$OffPeakWindow' => '<p>Off-peak window settings for the domain.</p>', ], ], 'OffPeakWindowOptions' => [ 'base' => '<p>Options for a domain\'s <a href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html">off-peak window</a>, during which OpenSearch Service can perform mandatory configuration changes on the domain.</p>', 'refs' => [ 'CreateDomainRequest$OffPeakWindowOptions' => '<p>Specifies a daily 10-hour time block during which OpenSearch Service can perform configuration changes on the domain, including service software updates and Auto-Tune enhancements that require a blue/green deployment. If no options are specified, the default start time of 10:00 P.M. local time (for the Region that the domain is created in) is used.</p>', 'DomainStatus$OffPeakWindowOptions' => '<p>Options that specify a custom 10-hour window during which OpenSearch Service can perform configuration changes on the domain.</p>', 'OffPeakWindowOptionsStatus$Options' => '<p>The domain\'s off-peak window configuration.</p>', 'UpdateDomainConfigRequest$OffPeakWindowOptions' => '<p>Off-peak window options for the domain.</p>', ], ], 'OffPeakWindowOptionsStatus' => [ 'base' => '<p>The status of <a href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html">off-peak window</a> options for a domain.</p>', 'refs' => [ 'DomainConfig$OffPeakWindowOptions' => '<p>Container for off-peak window options for the domain.</p>', ], ], 'OpenSearchPartitionInstanceType' => [ 'base' => NULL, 'refs' => [ 'ClusterConfig$InstanceType' => '<p>Instance type of data nodes in the cluster.</p>', 'ClusterConfig$DedicatedMasterType' => '<p>OpenSearch Service instance type of the dedicated master nodes in the cluster.</p>', 'DescribeInstanceTypeLimitsRequest$InstanceType' => '<p>The OpenSearch Service instance type for which you need limit information.</p>', 'DomainNodesStatus$InstanceType' => '<p>The instance type information of the node.</p>', 'InstanceTypeDetails$InstanceType' => '<p>The instance type.</p>', 'ReservedInstance$InstanceType' => '<p>The OpenSearch instance type offered by theReserved Instance offering.</p>', 'ReservedInstanceOffering$InstanceType' => '<p>The OpenSearch instance type offered by the Reserved Instance offering.</p>', ], ], 'OpenSearchWarmPartitionInstanceType' => [ 'base' => NULL, 'refs' => [ 'ClusterConfig$WarmType' => '<p>The instance type for the cluster\'s warm nodes.</p>', ], ], 'OptionState' => [ 'base' => '<p>The state of a requested domain configuration change. Can be one of the following:</p> <ul> <li> <p> <b>Processing</b> - The requested change is still in progress.</p> </li> <li> <p> <b>Active</b> - The requested change is processed and deployed to the domain.</p> </li> </ul>', 'refs' => [ 'OptionStatus$State' => '<p>The state of the entity.</p>', ], ], 'OptionStatus' => [ 'base' => '<p>Provides the current status of an entity.</p>', 'refs' => [ 'AIMLOptionsStatus$Status' => NULL, 'AccessPoliciesStatus$Status' => '<p>The status of the access policy for the domain.</p>', 'AdvancedOptionsStatus$Status' => '<p>The status of advanced options for the specified domain.</p>', 'AdvancedSecurityOptionsStatus$Status' => '<p>Status of the fine-grained access control settings for a domain.</p>', 'ClusterConfigStatus$Status' => '<p>The status of cluster configuration options for the specified domain.</p>', 'CognitoOptionsStatus$Status' => '<p>The status of the Cognito options for the specified domain.</p>', 'DomainEndpointOptionsStatus$Status' => '<p>The status of the endpoint options for a domain.</p>', 'EBSOptionsStatus$Status' => '<p>The status of the EBS options for the specified domain.</p>', 'EncryptionAtRestOptionsStatus$Status' => '<p>The status of the encryption at rest options for the specified domain.</p>', 'IPAddressTypeStatus$Status' => NULL, 'LogPublishingOptionsStatus$Status' => '<p>The status of the log publishing options for the domain.</p>', 'NodeToNodeEncryptionOptionsStatus$Status' => '<p>The status of the node-to-node encryption options for the specified domain.</p>', 'OffPeakWindowOptionsStatus$Status' => '<p>The current status of off-peak window options.</p>', 'SnapshotOptionsStatus$Status' => '<p>The status of a daily automated snapshot.</p>', 'SoftwareUpdateOptionsStatus$Status' => '<p>The status of service software update options, including creation date and last updated date.</p>', 'VPCDerivedInfoStatus$Status' => '<p>The status of the VPC options for the specified domain.</p>', 'VersionStatus$Status' => '<p>The status of the version options for the specified domain.</p>', ], ], 'OutboundConnection' => [ 'base' => '<p>Specifies details about an outbound cross-cluster connection.</p>', 'refs' => [ 'DeleteOutboundConnectionResponse$Connection' => '<p>The deleted inbound connection.</p>', 'OutboundConnections$member' => NULL, ], ], 'OutboundConnectionStatus' => [ 'base' => '<p>The status of an outbound cross-cluster connection.</p>', 'refs' => [ 'CreateOutboundConnectionResponse$ConnectionStatus' => '<p>The status of the connection.</p>', 'OutboundConnection$ConnectionStatus' => '<p>Status of the connection.</p>', ], ], 'OutboundConnectionStatusCode' => [ 'base' => NULL, 'refs' => [ 'OutboundConnectionStatus$StatusCode' => '<p>The status code for the outbound connection. Can be one of the following:</p> <ul> <li> <p> <b>VALIDATING</b> - The outbound connection request is being validated.</p> </li> <li> <p> <b>VALIDATION_FAILED</b> - Validation failed for the connection request.</p> </li> <li> <p> <b>PENDING_ACCEPTANCE</b>: Outbound connection request is validated and is not yet accepted by the remote domain owner.</p> </li> <li> <p> <b>APPROVED</b> - Outbound connection has been approved by the remote domain owner for getting provisioned.</p> </li> <li> <p> <b>PROVISIONING</b> - Outbound connection request is in process.</p> </li> <li> <p> <b>ACTIVE</b> - Outbound connection is active and ready to use.</p> </li> <li> <p> <b>REJECTING</b> - Outbound connection rejection by remote domain owner is in progress.</p> </li> <li> <p> <b>REJECTED</b> - Outbound connection request is rejected by remote domain owner.</p> </li> <li> <p> <b>DELETING</b> - Outbound connection deletion is in progress.</p> </li> <li> <p> <b>DELETED</b> - Outbound connection is deleted and can no longer be used.</p> </li> </ul>', ], ], 'OutboundConnections' => [ 'base' => NULL, 'refs' => [ 'DescribeOutboundConnectionsResponse$Connections' => '<p>List of outbound connections that match the filter criteria.</p>', ], ], 'OverallChangeStatus' => [ 'base' => '<p>The overall status value of the domain configuration change.</p>', 'refs' => [ 'ChangeProgressStatusDetails$Status' => '<p>The overall status of the domain configuration change.</p>', ], ], 'OwnerId' => [ 'base' => NULL, 'refs' => [ 'AWSDomainInformation$OwnerId' => '<p>The Amazon Web Services account ID of the domain owner.</p>', ], ], 'PackageDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePackageRequest$PackageDescription' => '<p>Description of the package.</p>', 'PackageDetails$PackageDescription' => '<p>User-specified description of the package.</p>', 'UpdatePackageRequest$PackageDescription' => '<p>A new description of the package.</p>', ], ], 'PackageDetails' => [ 'base' => '<p>Basic information about a package.</p>', 'refs' => [ 'CreatePackageResponse$PackageDetails' => '<p>Basic information about an OpenSearch Service package.</p>', 'DeletePackageResponse$PackageDetails' => '<p> Information about the deleted package.</p>', 'PackageDetailsList$member' => NULL, 'UpdatePackageResponse$PackageDetails' => '<p>Information about a package.</p>', ], ], 'PackageDetailsList' => [ 'base' => NULL, 'refs' => [ 'DescribePackagesResponse$PackageDetailsList' => '<p>Basic information about a package.</p>', ], ], 'PackageID' => [ 'base' => NULL, 'refs' => [ 'AssociatePackageRequest$PackageID' => '<p>Internal ID of the package to associate with a domain. Use <code>DescribePackages</code> to find this value. </p>', 'DeletePackageRequest$PackageID' => '<p>The internal ID of the package you want to delete. Use <code>DescribePackages</code> to find this value.</p>', 'DissociatePackageRequest$PackageID' => '<p>Internal ID of the package to dissociate from the domain. Use <code>ListPackagesForDomain</code> to find this value.</p>', 'DomainPackageDetails$PackageID' => '<p>Internal ID of the package.</p>', 'GetPackageVersionHistoryRequest$PackageID' => '<p>The unique identifier of the package.</p>', 'GetPackageVersionHistoryResponse$PackageID' => '<p>The unique identifier of the package.</p>', 'ListDomainsForPackageRequest$PackageID' => '<p>The unique identifier of the package for which to list associated domains.</p>', 'PackageDetails$PackageID' => '<p>The unique identifier of the package.</p>', 'UpdatePackageRequest$PackageID' => '<p>The unique identifier for the package.</p>', ], ], 'PackageName' => [ 'base' => NULL, 'refs' => [ 'CreatePackageRequest$PackageName' => '<p>Unique name for the package.</p>', 'DomainPackageDetails$PackageName' => '<p>User-specified name of the package.</p>', 'PackageDetails$PackageName' => '<p>The user-specified name of the package.</p>', ], ], 'PackageSource' => [ 'base' => '<p>The Amazon S3 location to import the package from.</p>', 'refs' => [ 'CreatePackageRequest$PackageSource' => '<p>The Amazon S3 location from which to import the package.</p>', 'UpdatePackageRequest$PackageSource' => '<p>Amazon S3 bucket and key for the package.</p>', ], ], 'PackageStatus' => [ 'base' => NULL, 'refs' => [ 'PackageDetails$PackageStatus' => '<p>The current status of the package. The available options are <code>AVAILABLE</code>, <code>COPYING</code>, <code>COPY_FAILED</code>, <code>VALIDATNG</code>, <code>VALIDATION_FAILED</code>, <code>DELETING</code>, and <code>DELETE_FAILED</code>.</p>', ], ], 'PackageType' => [ 'base' => NULL, 'refs' => [ 'CreatePackageRequest$PackageType' => '<p>The type of package.</p>', 'DomainPackageDetails$PackageType' => '<p>The type of package.</p>', 'PackageDetails$PackageType' => '<p>The type of package.</p>', ], ], 'PackageVersion' => [ 'base' => NULL, 'refs' => [ 'DomainPackageDetails$PackageVersion' => '<p>The current version of the package.</p>', 'PackageDetails$AvailablePackageVersion' => '<p>The package version.</p>', 'PackageVersionHistory$PackageVersion' => '<p>The package version.</p>', ], ], 'PackageVersionHistory' => [ 'base' => '<p>Details about a package version.</p>', 'refs' => [ 'PackageVersionHistoryList$member' => NULL, ], ], 'PackageVersionHistoryList' => [ 'base' => NULL, 'refs' => [ 'GetPackageVersionHistoryResponse$PackageVersionHistoryList' => '<p>A list of package versions, along with their creation time and commit message.</p>', ], ], 'Password' => [ 'base' => NULL, 'refs' => [ 'MasterUserOptions$MasterUserPassword' => '<p>Password for the master user. Only specify if <code>InternalUserDatabaseEnabled</code> is <code>true</code>.</p>', ], ], 'PluginClassName' => [ 'base' => NULL, 'refs' => [ 'PluginProperties$ClassName' => '<p>The name of the class to load.</p>', ], ], 'PluginDescription' => [ 'base' => NULL, 'refs' => [ 'PluginProperties$Description' => '<p>The description of the plugin.</p>', ], ], 'PluginName' => [ 'base' => NULL, 'refs' => [ 'PluginProperties$Name' => '<p>The name of the plugin.</p>', ], ], 'PluginProperties' => [ 'base' => '<p>Basic information about the plugin.</p>', 'refs' => [ 'PackageDetails$AvailablePluginProperties' => '<p>If the package is a <code>ZIP-PLUGIN</code> package, additional information about plugin properties.</p>', 'PackageVersionHistory$PluginProperties' => '<p>Additional information about plugin properties if the package is a <code>ZIP-PLUGIN</code> package.</p>', ], ], 'PluginVersion' => [ 'base' => NULL, 'refs' => [ 'PluginProperties$Version' => '<p>The version of the plugin.</p>', ], ], 'PolicyDocument' => [ 'base' => '<p>Access policy rules for an Amazon OpenSearch Service domain endpoint. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-access-policies">Configuring access policies</a>. The maximum size of a policy document is 100 KB.</p>', 'refs' => [ 'AccessPoliciesStatus$Options' => '<p>The access policy configured for the domain. Access policies can be resource-based, IP-based, or IAM-based. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomain-configure-access-policies">Configuring access policies</a>.</p>', 'CreateDomainRequest$AccessPolicies' => '<p>Identity and Access Management (IAM) policy document specifying the access policies for the new domain.</p>', 'DomainStatus$AccessPolicies' => '<p>Identity and Access Management (IAM) policy document specifying the access policies for the domain.</p>', 'UpdateDomainConfigRequest$AccessPolicies' => '<p>Identity and Access Management (IAM) access policy as a JSON-formatted string.</p>', ], ], 'PrincipalType' => [ 'base' => NULL, 'refs' => [ 'AuthorizedPrincipal$PrincipalType' => '<p>The type of principal.</p>', ], ], 'PropertyValueType' => [ 'base' => NULL, 'refs' => [ 'ModifyingProperties$ValueType' => '<p>The type of value that is currently being modified. Properties can have two types:</p> <ul> <li> <p> <code>PLAIN_TEXT</code>: Contain direct values such as "1", "True", or "c5.large.search".</p> </li> <li> <p> <code>STRINGIFIED_JSON</code>: Contain content in JSON format, such as {"Enabled":"True"}".</p> </li> </ul>', ], ], 'PurchaseReservedInstanceOfferingRequest' => [ 'base' => '<p>Container for request parameters to the <code>PurchaseReservedInstanceOffering</code> operation.</p>', 'refs' => [], ], 'PurchaseReservedInstanceOfferingResponse' => [ 'base' => '<p>Represents the output of a <code>PurchaseReservedInstanceOffering</code> operation.</p>', 'refs' => [], ], 'RecurringCharge' => [ 'base' => '<p>Contains the specific price and frequency of a recurring charges for an OpenSearch Reserved Instance, or for a Reserved Instance offering.</p>', 'refs' => [ 'RecurringChargeList$member' => NULL, ], ], 'RecurringChargeList' => [ 'base' => NULL, 'refs' => [ 'ReservedInstance$RecurringCharges' => '<p>The recurring charge to your account, regardless of whether you create any domains using the Reserved Instance offering.</p>', 'ReservedInstanceOffering$RecurringCharges' => '<p>The recurring charge to your account, regardless of whether you creates any domains using the offering.</p>', ], ], 'ReferencePath' => [ 'base' => NULL, 'refs' => [ 'DomainPackageDetails$ReferencePath' => '<p>The relative path of the package on the OpenSearch Service cluster nodes. This is <code>synonym_path</code> when the package is for synonym files.</p>', ], ], 'Region' => [ 'base' => NULL, 'refs' => [ 'AWSDomainInformation$Region' => '<p>The Amazon Web Services Region in which the domain is located.</p>', ], ], 'RejectInboundConnectionRequest' => [ 'base' => '<p>Container for the request parameters to the <code>RejectInboundConnection</code> operation.</p>', 'refs' => [], ], 'RejectInboundConnectionResponse' => [ 'base' => '<p>Represents the output of a <code>RejectInboundConnection</code> operation.</p>', 'refs' => [], ], 'RemoveTagsRequest' => [ 'base' => '<p>Container for the request parameters to the <code>RemoveTags</code> operation.</p>', 'refs' => [], ], 'RequestId' => [ 'base' => NULL, 'refs' => [ 'DomainMaintenanceDetails$MaintenanceId' => '<p>The ID of the requested action.</p>', 'GetDomainMaintenanceStatusRequest$MaintenanceId' => '<p>The request ID of the maintenance action.</p>', 'StartDomainMaintenanceResponse$MaintenanceId' => '<p>The request ID of requested action.</p>', ], ], 'ReservationToken' => [ 'base' => NULL, 'refs' => [ 'PurchaseReservedInstanceOfferingRequest$ReservationName' => '<p>A customer-specified identifier to track this reservation.</p>', 'PurchaseReservedInstanceOfferingResponse$ReservationName' => '<p>The customer-specified identifier used to track this reservation.</p>', 'ReservedInstance$ReservationName' => '<p>The customer-specified identifier to track this reservation.</p>', ], ], 'ReservedInstance' => [ 'base' => '<p>Details of an OpenSearch Reserved Instance.</p>', 'refs' => [ 'ReservedInstanceList$member' => NULL, ], ], 'ReservedInstanceList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstancesResponse$ReservedInstances' => '<p>List of Reserved Instances in the current Region.</p>', ], ], 'ReservedInstanceOffering' => [ 'base' => '<p>Details of an OpenSearch Reserved Instance offering.</p>', 'refs' => [ 'ReservedInstanceOfferingList$member' => NULL, ], ], 'ReservedInstanceOfferingList' => [ 'base' => NULL, 'refs' => [ 'DescribeReservedInstanceOfferingsResponse$ReservedInstanceOfferings' => '<p>List of Reserved Instance offerings.</p>', ], ], 'ReservedInstancePaymentOption' => [ 'base' => NULL, 'refs' => [ 'ReservedInstance$PaymentOption' => '<p>The payment option as defined in the Reserved Instance offering.</p>', 'ReservedInstanceOffering$PaymentOption' => '<p>Payment option for the Reserved Instance offering</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>An exception for creating a resource that already exists.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>An exception for accessing or deleting a resource that doesn\'t exist.</p>', 'refs' => [], ], 'RevokeVpcEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'RevokeVpcEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CognitoOptions$RoleArn' => '<p>The <code>AmazonOpenSearchServiceCognitoAccess</code> role that allows OpenSearch Service to configure your user pool and identity pool.</p>', 'S3GlueDataCatalog$RoleArn' => '<p>&gt;The Amazon Resource Name (ARN) for the S3 Glue Data Catalog.</p>', ], ], 'RolesKey' => [ 'base' => NULL, 'refs' => [ 'JWTOptionsInput$RolesKey' => '<p>Element of the JWT assertion to use for roles.</p>', ], ], 'RollbackOnDisable' => [ 'base' => '<p>The rollback state while disabling Auto-Tune for the domain.</p>', 'refs' => [ 'AutoTuneOptions$RollbackOnDisable' => '<p>When disabling Auto-Tune, specify <code>NO_ROLLBACK</code> to retain all prior Auto-Tune settings or <code>DEFAULT_ROLLBACK</code> to revert to the OpenSearch Service defaults. If you specify <code>DEFAULT_ROLLBACK</code>, you must include a <code>MaintenanceSchedule</code> in the request. Otherwise, OpenSearch Service is unable to perform the rollback.</p>', ], ], 'S3BucketName' => [ 'base' => NULL, 'refs' => [ 'PackageSource$S3BucketName' => '<p>The name of the Amazon S3 bucket containing the package.</p>', ], ], 'S3GlueDataCatalog' => [ 'base' => '<p>Information about the Amazon S3 Glue Data Catalog.</p>', 'refs' => [ 'DataSourceType$S3GlueDataCatalog' => '<p>An Amazon S3 data source.</p>', ], ], 'S3Key' => [ 'base' => NULL, 'refs' => [ 'PackageSource$S3Key' => '<p>Key (file name) of the package.</p>', ], ], 'SAMLEntityId' => [ 'base' => NULL, 'refs' => [ 'SAMLIdp$EntityId' => '<p>The unique entity ID of the application in the SAML identity provider.</p>', ], ], 'SAMLIdp' => [ 'base' => '<p>The SAML identity povider information.</p>', 'refs' => [ 'SAMLOptionsInput$Idp' => '<p>The SAML Identity Provider\'s information.</p>', 'SAMLOptionsOutput$Idp' => '<p>Describes the SAML identity provider\'s information.</p>', ], ], 'SAMLMetadata' => [ 'base' => NULL, 'refs' => [ 'SAMLIdp$MetadataContent' => '<p>The metadata of the SAML application, in XML format.</p>', ], ], 'SAMLOptionsInput' => [ 'base' => '<p>The SAML authentication configuration for an Amazon OpenSearch Service domain.</p>', 'refs' => [ 'AdvancedSecurityOptionsInput$SAMLOptions' => '<p>Container for information about the SAML configuration for OpenSearch Dashboards.</p>', ], ], 'SAMLOptionsOutput' => [ 'base' => '<p>Describes the SAML application configured for the domain.</p>', 'refs' => [ 'AdvancedSecurityOptions$SAMLOptions' => '<p>Container for information about the SAML configuration for OpenSearch Dashboards.</p>', ], ], 'ScheduleAt' => [ 'base' => NULL, 'refs' => [ 'StartServiceSoftwareUpdateRequest$ScheduleAt' => '<p>When to start the service software update.</p> <ul> <li> <p> <code>NOW</code> - Immediately schedules the update to happen in the current hour if there\'s capacity available.</p> </li> <li> <p> <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this value, you must also provide a value for <code>DesiredStartTime</code>.</p> </li> <li> <p> <code>OFF_PEAK_WINDOW</code> - Marks the update to be picked up during an upcoming off-peak window. There\'s no guarantee that the update will happen during the next immediate window. Depending on capacity, it might happen in subsequent days.</p> </li> </ul> <p>Default: <code>NOW</code> if you don\'t specify a value for <code>DesiredStartTime</code>, and <code>TIMESTAMP</code> if you do.</p>', 'UpdateScheduledActionRequest$ScheduleAt' => '<p>When to schedule the action.</p> <ul> <li> <p> <code>NOW</code> - Immediately schedules the update to happen in the current hour if there\'s capacity available.</p> </li> <li> <p> <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this value, you must also provide a value for <code>DesiredStartTime</code>.</p> </li> <li> <p> <code>OFF_PEAK_WINDOW</code> - Marks the action to be picked up during an upcoming off-peak window. There\'s no guarantee that the change will be implemented during the next immediate window. Depending on capacity, it might happen in subsequent days.</p> </li> </ul>', ], ], 'ScheduledAction' => [ 'base' => '<p>Information about a scheduled configuration change for an OpenSearch Service domain. This actions can be a <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">service software update</a> or a <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types">blue/green Auto-Tune enhancement</a>.</p>', 'refs' => [ 'ScheduledActionsList$member' => NULL, 'UpdateScheduledActionResponse$ScheduledAction' => '<p>Information about the rescheduled action.</p>', ], ], 'ScheduledActionsList' => [ 'base' => NULL, 'refs' => [ 'ListScheduledActionsResponse$ScheduledActions' => '<p>A list of actions that are scheduled for the domain.</p>', ], ], 'ScheduledAutoTuneActionType' => [ 'base' => '<p>The Auto-Tune action type.</p>', 'refs' => [ 'ScheduledAutoTuneDetails$ActionType' => '<p>The type of Auto-Tune action.</p>', ], ], 'ScheduledAutoTuneDescription' => [ 'base' => '<p>The description of an Auto-Tune maintenance action that occurs on a domain.</p>', 'refs' => [ 'ScheduledAutoTuneDetails$Action' => '<p>A description of the Auto-Tune action.</p>', ], ], 'ScheduledAutoTuneDetails' => [ 'base' => '<p>Specifies details about a scheduled Auto-Tune action. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html">Auto-Tune for Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'AutoTuneDetails$ScheduledAutoTuneDetails' => '<p>Container for details about a scheduled Auto-Tune action.</p>', ], ], 'ScheduledAutoTuneSeverityType' => [ 'base' => '<p>The Auto-Tune action severity.</p>', 'refs' => [ 'ScheduledAutoTuneDetails$Severity' => '<p>The severity of the Auto-Tune action. Valid values are <code>LOW</code>, <code>MEDIUM</code>, and <code>HIGH</code>.</p>', ], ], 'ScheduledBy' => [ 'base' => NULL, 'refs' => [ 'ScheduledAction$ScheduledBy' => '<p>Whether the action was scheduled manually (<code>CUSTOMER</code>, or by OpenSearch Service automatically (<code>SYSTEM</code>).</p>', ], ], 'ServiceSoftwareOptions' => [ 'base' => '<p>The current status of the service software for an Amazon OpenSearch Service domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">Service software updates in Amazon OpenSearch Service</a>.</p>', 'refs' => [ 'CancelServiceSoftwareUpdateResponse$ServiceSoftwareOptions' => '<p>Container for the state of your domain relative to the latest service software.</p>', 'DomainStatus$ServiceSoftwareOptions' => '<p>The current status of the domain\'s service software.</p>', 'StartServiceSoftwareUpdateResponse$ServiceSoftwareOptions' => '<p>The current status of the OpenSearch Service software update.</p>', ], ], 'ServiceUrl' => [ 'base' => '<p>The domain endpoint to which index and search requests are submitted. For example, <code>search-imdb-movies-oopcnjfn6ugo.eu-west-1.es.amazonaws.com</code> or <code>doc-imdb-movies-oopcnjfn6u.eu-west-1.es.amazonaws.com</code>.</p>', 'refs' => [ 'DomainStatus$Endpoint' => '<p>Domain-specific endpoint used to submit index, search, and data upload requests to the domain.</p>', 'DomainStatus$EndpointV2' => '<p>If <code>IPAddressType</code> to set to <code>dualstack</code>, a version 2 domain endpoint is provisioned. This endpoint functions like a normal endpoint, except that it works with both IPv4 and IPv6 IP addresses. Normal endpoints work only with IPv4 IP addresses. </p>', 'EndpointsMap$value' => NULL, ], ], 'SkipUnavailableStatus' => [ 'base' => '<p>The status of <code>SkipUnavailable</code> setting for the outbound connection.</p> <ul> <li> <p> <b>ENABLED</b> - The <code>SkipUnavailable</code> setting is enabled for the connection.</p> </li> <li> <p> <b>DISABLED</b> - The <code>SkipUnavailable</code> setting is disabled for the connection.</p> </li> </ul>', 'refs' => [ 'CrossClusterSearchConnectionProperties$SkipUnavailable' => '<p>The status of the <code>SkipUnavailable</code> setting for the outbound connection. This feature allows you to specify some clusters as optional and ensure that your cross-cluster queries return partial results despite failures on one or more remote clusters.</p>', ], ], 'SlotList' => [ 'base' => NULL, 'refs' => [ 'SlotNotAvailableException$SlotSuggestions' => '<p>Alternate time slots during which OpenSearch Service has available capacity to schedule a domain action.</p>', ], ], 'SlotNotAvailableException' => [ 'base' => '<p>An exception for attempting to schedule a domain action during an unavailable time slot.</p>', 'refs' => [], ], 'SnapshotOptions' => [ 'base' => '<p>The time, in UTC format, when OpenSearch Service takes a daily automated snapshot of the specified domain. Default is <code>0</code> hours.</p>', 'refs' => [ 'CreateDomainRequest$SnapshotOptions' => '<p>DEPRECATED. Container for the parameters required to configure automated snapshots of domain indexes.</p>', 'DomainStatus$SnapshotOptions' => '<p>DEPRECATED. Container for parameters required to configure automated snapshots of domain indexes.</p>', 'SnapshotOptionsStatus$Options' => '<p>The daily snapshot options specified for the domain.</p>', 'UpdateDomainConfigRequest$SnapshotOptions' => '<p>Option to set the time, in UTC format, for the daily automated snapshot. Default value is <code>0</code> hours. </p>', ], ], 'SnapshotOptionsStatus' => [ 'base' => '<p>Container for information about a daily automated snapshot for an OpenSearch Service domain.</p>', 'refs' => [ 'DomainConfig$SnapshotOptions' => '<p>DEPRECATED. Container for parameters required to configure automated snapshots of domain indexes.</p>', ], ], 'SoftwareUpdateOptions' => [ 'base' => '<p>Options for configuring service software updates for a domain.</p>', 'refs' => [ 'CreateDomainRequest$SoftwareUpdateOptions' => '<p>Software update options for the domain.</p>', 'DomainStatus$SoftwareUpdateOptions' => '<p>Service software update options for the domain.</p>', 'SoftwareUpdateOptionsStatus$Options' => '<p>The service software update options for a domain.</p>', 'UpdateDomainConfigRequest$SoftwareUpdateOptions' => '<p>Service software update options for the domain.</p>', ], ], 'SoftwareUpdateOptionsStatus' => [ 'base' => '<p>The status of the service software options for a domain.</p>', 'refs' => [ 'DomainConfig$SoftwareUpdateOptions' => '<p>Software update options for the domain.</p>', ], ], 'StartAt' => [ 'base' => NULL, 'refs' => [ 'AutoTuneMaintenanceSchedule$StartAt' => '<p>The Epoch timestamp at which the Auto-Tune maintenance schedule starts.</p>', ], ], 'StartDomainMaintenanceRequest' => [ 'base' => '<p>Container for the parameters to the <code>StartDomainMaintenance</code> operation.</p>', 'refs' => [], ], 'StartDomainMaintenanceResponse' => [ 'base' => '<p>The result of a <code>StartDomainMaintenance</code> request that information about the requested action. </p>', 'refs' => [], ], 'StartServiceSoftwareUpdateRequest' => [ 'base' => '<p>Container for the request parameters to the <code>StartServiceSoftwareUpdate</code> operation.</p>', 'refs' => [], ], 'StartServiceSoftwareUpdateResponse' => [ 'base' => '<p>Represents the output of a <code>StartServiceSoftwareUpdate</code> operation. Contains the status of the update.</p>', 'refs' => [], ], 'StartTimeHours' => [ 'base' => NULL, 'refs' => [ 'WindowStartTime$Hours' => '<p>The start hour of the window in Coordinated Universal Time (UTC), using 24-hour time. For example, <code>17</code> refers to 5:00 P.M. UTC.</p>', ], ], 'StartTimeMinutes' => [ 'base' => NULL, 'refs' => [ 'WindowStartTime$Minutes' => '<p>The start minute of the window, in UTC.</p>', ], ], 'StartTimestamp' => [ 'base' => NULL, 'refs' => [ 'UpgradeHistory$StartTimestamp' => '<p>UTC timestamp at which the upgrade API call was made, in the format <code>yyyy-MM-ddTHH:mm:ssZ</code>.</p>', ], ], 'StorageSubTypeName' => [ 'base' => '<p> Sub-type of the given EBS storage type. List of available sub-storage options. The <code>instance</code> storage type has no storage sub-type. The <code>ebs</code> storage type has the following valid sub-types: </p> <ul> <li> <p> <code>standard</code> </p> </li> <li> <p> <code>gp2</code> </p> </li> <li> <p> <code>gp3</code> </p> </li> <li> <p> <code>io1</code> </p> </li> </ul>', 'refs' => [ 'StorageType$StorageSubTypeName' => '<p>The storage sub-type, such as <code>gp3</code> or <code>io1</code>.</p>', ], ], 'StorageType' => [ 'base' => '<p>A list of storage types for an Amazon OpenSearch Service domain that are available for a given intance type.</p>', 'refs' => [ 'StorageTypeList$member' => NULL, ], ], 'StorageTypeLimit' => [ 'base' => '<p>Limits that are applicable for the given Amazon OpenSearch Service storage type.</p>', 'refs' => [ 'StorageTypeLimitList$member' => NULL, ], ], 'StorageTypeLimitList' => [ 'base' => NULL, 'refs' => [ 'StorageType$StorageTypeLimits' => '<p>Limits that are applicable for the given storage type.</p>', ], ], 'StorageTypeList' => [ 'base' => NULL, 'refs' => [ 'Limits$StorageTypes' => '<p>Storage-related attributes that are available for a given instance type.</p>', ], ], 'StorageTypeName' => [ 'base' => '<p>The type of storage that the domain uses. Can be one of the following:</p> <dl> <dt>instance</dt> <dd> <p>Built-in storage available for the instance.</p> </dd> <dt>ebs</dt> <dd> <p>Elastic Block Storage (EBS) attached to the instance.</p> </dd> </dl>', 'refs' => [ 'DomainNodesStatus$StorageType' => '<p>Indicates if the node has EBS or instance storage. </p>', 'StorageType$StorageTypeName' => '<p>The name of the storage type.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AddDataSourceResponse$Message' => '<p>A message associated with creation of the data source.</p>', 'AdvancedOptions$key' => NULL, 'AdvancedOptions$value' => NULL, 'AuthorizedPrincipal$Principal' => '<p>The <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_principal.html">IAM principal</a> that is allowed access to the domain.</p>', 'AutoTuneMaintenanceSchedule$CronExpressionForRecurrence' => '<p>A cron expression for a recurring maintenance schedule during which Auto-Tune can deploy changes.</p>', 'AutoTuneOptionsOutput$ErrorMessage' => '<p>Any errors that occurred while enabling or disabling Auto-Tune.</p>', 'AutoTuneStatus$ErrorMessage' => '<p>Any errors that occurred while enabling or disabling Auto-Tune.</p>', 'CancelledChangeProperty$PropertyName' => '<p>The name of the property whose change was cancelled.</p>', 'CancelledChangeProperty$CancelledValue' => '<p>The pending value of the property that was cancelled. This would have been the eventual value of the property if the chance had not been cancelled.</p>', 'CancelledChangeProperty$ActiveValue' => '<p>The current value of the property, after the change was cancelled.</p>', 'DeleteDataSourceResponse$Message' => '<p>A message associated with deletion of the data source.</p>', 'DescribePackagesResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'DescribeReservedInstancesResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'DryRunProgressStatus$DryRunStatus' => '<p>The current status of the dry run.</p>', 'DryRunProgressStatus$CreationDate' => '<p>The timestamp when the dry run was initiated.</p>', 'DryRunProgressStatus$UpdateDate' => '<p>The timestamp when the dry run was last updated.</p>', 'EndpointsMap$key' => NULL, 'GetPackageVersionHistoryResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'GetUpgradeHistoryResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'JWTOptionsInput$PublicKey' => '<p>Element of the JWT assertion used by the cluster to verify JWT signatures.</p>', 'JWTOptionsOutput$SubjectKey' => '<p>The key used for matching the JWT subject attribute.</p>', 'JWTOptionsOutput$RolesKey' => '<p>The key used for matching the JWT roles attribute.</p>', 'JWTOptionsOutput$PublicKey' => '<p>The key used to verify the signature of incoming JWT requests.</p>', 'ListDomainsForPackageResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'ListPackagesForDomainResponse$NextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned token to retrieve the next page.</p>', 'ModifyingProperties$Name' => '<p>The name of the property that is currently being modified.</p>', 'ModifyingProperties$ActiveValue' => '<p>The current value of the domain property that is being modified.</p>', 'ModifyingProperties$PendingValue' => '<p>The value that the property that is currently being modified will eventually have.</p>', 'RecurringCharge$RecurringChargeFrequency' => '<p>The frequency of the recurring charge.</p>', 'ReservedInstance$ReservedInstanceOfferingId' => '<p>The unique identifier of the Reserved Instance offering.</p>', 'ReservedInstance$CurrencyCode' => '<p>The currency code for the offering.</p>', 'ReservedInstance$State' => '<p>The state of the Reserved Instance.</p>', 'ReservedInstanceOffering$CurrencyCode' => '<p>The currency code for the Reserved Instance offering.</p>', 'SAMLOptionsInput$SubjectKey' => '<p>Element of the SAML assertion to use for the user name. Default is <code>NameID</code>.</p>', 'SAMLOptionsInput$RolesKey' => '<p>Element of the SAML assertion to use for backend roles. Default is <code>roles</code>.</p>', 'SAMLOptionsOutput$SubjectKey' => '<p>The key used for matching the SAML subject attribute.</p>', 'SAMLOptionsOutput$RolesKey' => '<p>The key used for matching the SAML roles attribute.</p>', 'ScheduledAction$Id' => '<p>The unique identifier of the scheduled action.</p>', 'ScheduledAction$Description' => '<p>A description of the action to be taken.</p>', 'ServiceSoftwareOptions$CurrentVersion' => '<p>The current service software version present on the domain.</p>', 'ServiceSoftwareOptions$NewVersion' => '<p>The new service software version, if one is available.</p>', 'ServiceSoftwareOptions$Description' => '<p>A description of the service software update status.</p>', 'StringList$member' => NULL, 'UpdateDataSourceResponse$Message' => '<p>A message associated with the updated data source.</p>', 'UpdateScheduledActionRequest$ActionID' => '<p>The unique identifier of the action to reschedule. To retrieve this ID, send a <a href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_ListScheduledActions.html">ListScheduledActions</a> request.</p>', 'UpgradeDomainResponse$UpgradeId' => '<p>The unique identifier of the domain upgrade.</p>', 'VPCDerivedInfo$VPCId' => '<p>The ID for your VPC. Amazon VPC generates this value when you create a VPC.</p>', 'ValidationFailure$Code' => '<p>The error code of the failure.</p>', 'ValidationFailure$Message' => '<p>A message corresponding to the failure.</p>', 'VpcEndpointError$ErrorMessage' => '<p>A message describing the error.</p>', 'VpcEndpointSummary$VpcEndpointOwner' => '<p>The creator of the endpoint.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressStatusDetails$PendingProperties' => '<p>The list of properties in the domain configuration change that are still pending.</p>', 'ChangeProgressStatusDetails$CompletedProperties' => '<p>The list of properties in the domain configuration change that have completed.</p>', 'RemoveTagsRequest$TagKeys' => '<p>The list of tag keys to remove from the domain.</p>', 'VPCDerivedInfo$SubnetIds' => '<p>A list of subnet IDs associated with the VPC endpoints for the domain.</p>', 'VPCDerivedInfo$AvailabilityZones' => '<p>The list of Availability Zones associated with the VPC subnets.</p>', 'VPCDerivedInfo$SecurityGroupIds' => '<p>The list of security group IDs associated with the VPC endpoints for the domain.</p>', 'VPCOptions$SubnetIds' => '<p>A list of subnet IDs associated with the VPC endpoints for the domain. If your domain uses multiple Availability Zones, you need to provide two subnet IDs, one per zone. Otherwise, provide only one.</p>', 'VPCOptions$SecurityGroupIds' => '<p>The list of security group IDs associated with the VPC endpoints for the domain. If you do not provide a security group ID, OpenSearch Service uses the default security group for the VPC.</p>', ], ], 'SubjectKey' => [ 'base' => NULL, 'refs' => [ 'JWTOptionsInput$SubjectKey' => '<p>Element of the JWT assertion to use for the user name.</p>', ], ], 'TLSSecurityPolicy' => [ 'base' => NULL, 'refs' => [ 'DomainEndpointOptions$TLSSecurityPolicy' => '<p>Specify the TLS security policy to apply to the HTTPS endpoint of the domain. The policy can be one of the following values:</p> <ul> <li> <p> <b>Policy-Min-TLS-1-0-2019-07:</b> TLS security policy that supports TLS version 1.0 to TLS version 1.2</p> </li> <li> <p> <b>Policy-Min-TLS-1-2-2019-07:</b> TLS security policy that supports only TLS version 1.2</p> </li> <li> <p> <b>Policy-Min-TLS-1-2-PFS-2023-10:</b> TLS security policy that supports TLS version 1.2 to TLS version 1.3 with perfect forward secrecy cipher suites</p> </li> </ul>', ], ], 'Tag' => [ 'base' => '<p>A tag (key-value pair) for an Amazon OpenSearch Service resource.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => '<p>A string between 1 to 128 characters that specifies the key for a tag. Tag keys must be unique for the domain to which they\'re attached.</p>', 'refs' => [ 'Tag$Key' => '<p>The tag key. Tag keys must be unique for the domain to which they are attached.</p>', ], ], 'TagList' => [ 'base' => '<p>A list of tags attached to a domain.</p>', 'refs' => [ 'AddTagsRequest$TagList' => '<p>List of resource tags.</p>', 'CreateDomainRequest$TagList' => '<p>List of tags to add to the domain upon creation.</p>', 'ListTagsResponse$TagList' => '<p>List of resource tags associated with the specified domain.</p>', ], ], 'TagValue' => [ 'base' => '<p>A string between 0 to 256 characters that specifies the value for a tag. Tag values can be null and don\'t have to be unique in a tag set.</p>', 'refs' => [ 'Tag$Value' => '<p>The value assigned to the corresponding tag key. Tag values can be null and don\'t have to be unique in a tag set. For example, you can have a key value pair in a tag set of <code>project : Trinity</code> and <code>cost-center : Trinity</code> </p>', ], ], 'TimeUnit' => [ 'base' => '<p>The unit of a maintenance schedule duration. Valid value is <code>HOUR</code>.</p>', 'refs' => [ 'Duration$Unit' => '<p>The unit of measurement for the duration of a maintenance schedule.</p>', ], ], 'TotalNumberOfStages' => [ 'base' => NULL, 'refs' => [ 'ChangeProgressStatusDetails$TotalNumberOfStages' => '<p>The total number of stages required for the configuration change.</p>', ], ], 'UIntValue' => [ 'base' => NULL, 'refs' => [ 'AutoTuneStatus$UpdateVersion' => '<p>The latest version of the Auto-Tune options.</p>', 'OptionStatus$UpdateVersion' => '<p>The latest version of the entity.</p>', ], ], 'UncompressedPluginSizeInBytes' => [ 'base' => NULL, 'refs' => [ 'PluginProperties$UncompressedSizeInBytes' => '<p>The uncompressed size of the plugin.</p>', ], ], 'UpdateDataSourceRequest' => [ 'base' => '<p>Container for the parameters to the <code>UpdateDataSource</code> operation.</p>', 'refs' => [], ], 'UpdateDataSourceResponse' => [ 'base' => '<p>The result of an <code>UpdateDataSource</code> operation.</p>', 'refs' => [], ], 'UpdateDomainConfigRequest' => [ 'base' => '<p>Container for the request parameters to the <code>UpdateDomain</code> operation.</p>', 'refs' => [], ], 'UpdateDomainConfigResponse' => [ 'base' => '<p>The results of an <code>UpdateDomain</code> request. Contains the status of the domain being updated.</p>', 'refs' => [], ], 'UpdatePackageRequest' => [ 'base' => '<p>Container for request parameters to the <code>UpdatePackage</code> operation.</p>', 'refs' => [], ], 'UpdatePackageResponse' => [ 'base' => '<p>Container for the response returned by the <code>UpdatePackage</code> operation.</p>', 'refs' => [], ], 'UpdateScheduledActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateScheduledActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTimestamp' => [ 'base' => NULL, 'refs' => [ 'AutoTuneStatus$CreationDate' => '<p>Date and time when Auto-Tune was enabled for the domain.</p>', 'AutoTuneStatus$UpdateDate' => '<p>Date and time when the Auto-Tune options were last updated for the domain.</p>', 'ChangeProgressDetails$StartTime' => '<p>The time that the configuration change was initiated, in Universal Coordinated Time (UTC).</p>', 'ChangeProgressDetails$LastUpdatedTime' => '<p>The last time that the configuration change was updated.</p>', 'ChangeProgressStatusDetails$StartTime' => '<p>The time at which the configuration change is made on the domain.</p>', 'ChangeProgressStatusDetails$LastUpdatedTime' => '<p>The last time that the status of the configuration change was updated.</p>', 'DomainMaintenanceDetails$CreatedAt' => '<p>The time at which the action was created.</p>', 'DomainMaintenanceDetails$UpdatedAt' => '<p>The time at which the action was updated.</p>', 'GetDomainMaintenanceStatusResponse$CreatedAt' => '<p>The time at which the action was created.</p>', 'GetDomainMaintenanceStatusResponse$UpdatedAt' => '<p>The time at which the action was updated.</p>', 'OptionStatus$CreationDate' => '<p>The timestamp when the entity was created.</p>', 'OptionStatus$UpdateDate' => '<p>The timestamp of the last time the entity was updated.</p>', 'ReservedInstance$StartTime' => '<p>The date and time when the reservation was purchased.</p>', ], ], 'UpdateVpcEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVpcEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpgradeDomainRequest' => [ 'base' => '<p>Container for the request parameters to the <code>UpgradeDomain</code> operation.</p>', 'refs' => [], ], 'UpgradeDomainResponse' => [ 'base' => '<p>Container for the response returned by <code>UpgradeDomain</code> operation.</p>', 'refs' => [], ], 'UpgradeHistory' => [ 'base' => '<p>History of the last 10 upgrades and upgrade eligibility checks for an Amazon OpenSearch Service domain.</p>', 'refs' => [ 'UpgradeHistoryList$member' => NULL, ], ], 'UpgradeHistoryList' => [ 'base' => NULL, 'refs' => [ 'GetUpgradeHistoryResponse$UpgradeHistories' => '<p>A list of objects corresponding to each upgrade or upgrade eligibility check performed on a domain.</p>', ], ], 'UpgradeName' => [ 'base' => NULL, 'refs' => [ 'GetUpgradeStatusResponse$UpgradeName' => '<p>A string that describes the update.</p>', 'UpgradeHistory$UpgradeName' => '<p>A string that describes the upgrade.</p>', ], ], 'UpgradeStatus' => [ 'base' => NULL, 'refs' => [ 'GetUpgradeStatusResponse$StepStatus' => '<p>The status of the current step that an upgrade is on.</p>', 'UpgradeHistory$UpgradeStatus' => '<p> The current status of the upgrade. The status can take one of the following values: </p> <ul> <li> <p>In Progress</p> </li> <li> <p>Succeeded</p> </li> <li> <p>Succeeded with Issues</p> </li> <li> <p>Failed</p> </li> </ul>', 'UpgradeStepItem$UpgradeStepStatus' => '<p> The current status of the upgrade. The status can take one of the following values: </p> <ul> <li> <p>In Progress</p> </li> <li> <p>Succeeded</p> </li> <li> <p>Succeeded with Issues</p> </li> <li> <p>Failed</p> </li> </ul>', ], ], 'UpgradeStep' => [ 'base' => NULL, 'refs' => [ 'GetUpgradeStatusResponse$UpgradeStep' => '<p>One of three steps that an upgrade or upgrade eligibility check goes through.</p>', 'UpgradeStepItem$UpgradeStep' => '<p> One of three steps that an upgrade or upgrade eligibility check goes through: </p> <ul> <li> <p>PreUpgradeCheck</p> </li> <li> <p>Snapshot</p> </li> <li> <p>Upgrade</p> </li> </ul>', ], ], 'UpgradeStepItem' => [ 'base' => '<p>Represents a single step of an upgrade or upgrade eligibility check workflow.</p>', 'refs' => [ 'UpgradeStepsList$member' => NULL, ], ], 'UpgradeStepsList' => [ 'base' => NULL, 'refs' => [ 'UpgradeHistory$StepsList' => '<p>A list of each step performed as part of a specific upgrade or upgrade eligibility check.</p>', ], ], 'UserPoolId' => [ 'base' => NULL, 'refs' => [ 'CognitoOptions$UserPoolId' => '<p>The Amazon Cognito user pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.</p>', ], ], 'Username' => [ 'base' => NULL, 'refs' => [ 'MasterUserOptions$MasterUserName' => '<p>User name for the master user. Only specify if <code>InternalUserDatabaseEnabled</code> is <code>true</code>.</p>', 'SAMLOptionsInput$MasterUserName' => '<p>The SAML master user name, which is stored in the domain\'s internal user database.</p>', ], ], 'VPCDerivedInfo' => [ 'base' => '<p>Information about the subnets and security groups for an Amazon OpenSearch Service domain provisioned within a virtual private cloud (VPC). For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains using a VPC</a>. This information only exists if the domain was created with <code>VPCOptions</code>.</p>', 'refs' => [ 'DomainStatus$VPCOptions' => '<p>The VPC configuration for the domain.</p>', 'VPCDerivedInfoStatus$Options' => '<p>The VPC options for the specified domain.</p>', 'VpcEndpoint$VpcOptions' => '<p>Options to specify the subnets and security groups for an Amazon OpenSearch Service VPC endpoint.</p>', ], ], 'VPCDerivedInfoStatus' => [ 'base' => '<p>Status of the VPC options for a specified domain.</p>', 'refs' => [ 'DomainConfig$VPCOptions' => '<p>The current VPC options for the domain and the status of any updates to their configuration.</p>', ], ], 'VPCOptions' => [ 'base' => '<p>Options to specify the subnets and security groups for an Amazon OpenSearch Service VPC endpoint. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains using a VPC</a>.</p>', 'refs' => [ 'CreateDomainRequest$VPCOptions' => '<p>Container for the values required to configure VPC access domains. If you don\'t specify these values, OpenSearch Service creates the domain with a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains using a VPC</a>.</p>', 'CreateVpcEndpointRequest$VpcOptions' => '<p>Options to specify the subnets and security groups for the endpoint.</p>', 'UpdateDomainConfigRequest$VPCOptions' => '<p>Options to specify the subnets and security groups for a VPC endpoint. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains using a VPC</a>.</p>', 'UpdateVpcEndpointRequest$VpcOptions' => '<p>The security groups and/or subnets to add, remove, or modify.</p>', ], ], 'ValidationException' => [ 'base' => '<p>An exception for accessing or deleting a resource that doesn\'t exist.</p>', 'refs' => [], ], 'ValidationFailure' => [ 'base' => '<p>A validation failure that occurred as the result of a pre-update validation check (verbose dry run) on a domain.</p>', 'refs' => [ 'ValidationFailures$member' => NULL, ], ], 'ValidationFailures' => [ 'base' => NULL, 'refs' => [ 'DryRunProgressStatus$ValidationFailures' => '<p>Any validation failures that occurred as a result of the dry run.</p>', ], ], 'ValueStringList' => [ 'base' => NULL, 'refs' => [ 'Filter$Values' => '<p>One or more values for the filter.</p>', ], ], 'VersionList' => [ 'base' => '<p>List of supported OpenSearch versions.</p>', 'refs' => [ 'CompatibleVersionsMap$TargetVersions' => '<p>The possible versions that you can upgrade the domain to.</p>', 'ListVersionsResponse$Versions' => '<p>A list of all versions of OpenSearch and Elasticsearch that Amazon OpenSearch Service supports.</p>', ], ], 'VersionStatus' => [ 'base' => '<p>The status of the the OpenSearch or Elasticsearch version options for the specified Amazon OpenSearch Service domain.</p>', 'refs' => [ 'DomainConfig$EngineVersion' => '<p>The OpenSearch or Elasticsearch version that the domain is running.</p>', ], ], 'VersionString' => [ 'base' => NULL, 'refs' => [ 'CompatibleVersionsMap$SourceVersion' => '<p>The current version that the OpenSearch Service domain is running.</p>', 'CreateDomainRequest$EngineVersion' => '<p>String of format Elasticsearch_X.Y or OpenSearch_X.Y to specify the engine version for the OpenSearch Service domain. For example, <code>OpenSearch_1.0</code> or <code>Elasticsearch_7.9</code>. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#createdomains">Creating and managing Amazon OpenSearch Service domains</a>.</p>', 'DescribeInstanceTypeLimitsRequest$EngineVersion' => '<p>Version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or OpenSearch_X.Y. Defaults to the latest version of OpenSearch.</p>', 'DomainStatus$EngineVersion' => '<p>Version of OpenSearch or Elasticsearch that the domain is running, in the format <code>Elasticsearch_X.Y</code> or <code>OpenSearch_X.Y</code>.</p>', 'ListInstanceTypeDetailsRequest$EngineVersion' => '<p>The version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or OpenSearch_X.Y. Defaults to the latest version of OpenSearch.</p>', 'UpgradeDomainRequest$TargetVersion' => '<p>OpenSearch or Elasticsearch version to which you want to upgrade, in the format Opensearch_X.Y or Elasticsearch_X.Y.</p>', 'UpgradeDomainResponse$TargetVersion' => '<p>OpenSearch or Elasticsearch version that the domain was upgraded to.</p>', 'VersionList$member' => NULL, 'VersionStatus$Options' => '<p>The OpenSearch or Elasticsearch version for the specified domain.</p>', ], ], 'VolumeSize' => [ 'base' => NULL, 'refs' => [ 'DomainNodesStatus$StorageSize' => '<p>The storage size of the node, in GiB.</p>', ], ], 'VolumeType' => [ 'base' => '<p>The type of EBS volume that a domain uses. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/opensearch-createupdatedomains.html#opensearch-createdomain-configure-ebs">Configuring EBS-based storage</a>.</p>', 'refs' => [ 'DomainNodesStatus$StorageVolumeType' => '<p>If the nodes has EBS storage, indicates if the volume type is GP2 or GP3. Only applicable for data nodes. </p>', 'EBSOptions$VolumeType' => '<p>Specifies the type of EBS volumes attached to data nodes.</p>', ], ], 'VpcEndpoint' => [ 'base' => '<p>The connection endpoint for connecting to an Amazon OpenSearch Service domain through a proxy.</p>', 'refs' => [ 'CreateVpcEndpointResponse$VpcEndpoint' => '<p>Information about the newly created VPC endpoint.</p>', 'UpdateVpcEndpointResponse$VpcEndpoint' => '<p>The endpoint to be updated.</p>', 'VpcEndpoints$member' => NULL, ], ], 'VpcEndpointError' => [ 'base' => '<p>Error information when attempting to describe an Amazon OpenSearch Service-managed VPC endpoint.</p>', 'refs' => [ 'VpcEndpointErrorList$member' => NULL, ], ], 'VpcEndpointErrorCode' => [ 'base' => NULL, 'refs' => [ 'VpcEndpointError$ErrorCode' => '<p>The code associated with the error.</p>', ], ], 'VpcEndpointErrorList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcEndpointsResponse$VpcEndpointErrors' => '<p>Any errors associated with the request.</p>', ], ], 'VpcEndpointId' => [ 'base' => NULL, 'refs' => [ 'DeleteVpcEndpointRequest$VpcEndpointId' => '<p>The unique identifier of the endpoint.</p>', 'UpdateVpcEndpointRequest$VpcEndpointId' => '<p>The unique identifier of the endpoint.</p>', 'VpcEndpoint$VpcEndpointId' => '<p>The unique identifier of the endpoint.</p>', 'VpcEndpointError$VpcEndpointId' => '<p>The unique identifier of the endpoint.</p>', 'VpcEndpointIdList$member' => NULL, 'VpcEndpointSummary$VpcEndpointId' => '<p>The unique identifier of the endpoint.</p>', ], ], 'VpcEndpointIdList' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcEndpointsRequest$VpcEndpointIds' => '<p>The unique identifiers of the endpoints to get information about.</p>', ], ], 'VpcEndpointStatus' => [ 'base' => NULL, 'refs' => [ 'VpcEndpoint$Status' => '<p>The current status of the endpoint.</p>', 'VpcEndpointSummary$Status' => '<p>The current status of the endpoint.</p>', ], ], 'VpcEndpointSummary' => [ 'base' => '<p>Summary information for an Amazon OpenSearch Service-managed VPC endpoint.</p>', 'refs' => [ 'DeleteVpcEndpointResponse$VpcEndpointSummary' => '<p>Information about the deleted endpoint, including its current status (<code>DELETING</code> or <code>DELETE_FAILED</code>).</p>', 'VpcEndpointSummaryList$member' => NULL, ], ], 'VpcEndpointSummaryList' => [ 'base' => NULL, 'refs' => [ 'ListVpcEndpointsForDomainResponse$VpcEndpointSummaryList' => '<p>Information about each endpoint associated with the domain.</p>', 'ListVpcEndpointsResponse$VpcEndpointSummaryList' => '<p>Information about each endpoint.</p>', ], ], 'VpcEndpoints' => [ 'base' => NULL, 'refs' => [ 'DescribeVpcEndpointsResponse$VpcEndpoints' => '<p>Information about each requested VPC endpoint.</p>', ], ], 'WindowStartTime' => [ 'base' => '<p>The desired start time for an <a href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_OffPeakWindow.html">off-peak maintenance window</a>.</p>', 'refs' => [ 'OffPeakWindow$WindowStartTime' => '<p>A custom start time for the off-peak window, in Coordinated Universal Time (UTC). The window length will always be 10 hours, so you can\'t specify an end time. For example, if you specify 11:00 P.M. UTC as a start time, the end time will automatically be set to 9:00 A.M.</p>', ], ], 'ZoneAwarenessConfig' => [ 'base' => '<p>The zone awareness configuration for an Amazon OpenSearch Service domain.</p>', 'refs' => [ 'ClusterConfig$ZoneAwarenessConfig' => '<p>Container for zone awareness configuration options. Only required if <code>ZoneAwarenessEnabled</code> is <code>true</code>.</p>', ], ], 'ZoneStatus' => [ 'base' => NULL, 'refs' => [ 'AvailabilityZoneInfo$ZoneStatus' => '<p>The current state of the Availability Zone. Current options are <code>Active</code> and <code>StandBy</code>.</p> <ul> <li> <p> <code>Active</code> - Data nodes in the Availability Zone are in use.</p> </li> <li> <p> <code>StandBy</code> - Data nodes in the Availability Zone are in a standby state.</p> </li> <li> <p> <code>NotAvailable</code> - Unable to retrieve information.</p> </li> </ul>', ], ], ],];
