<?php
// This file was auto-generated from sdk-root/src/data/opensearchserverless/2021-11-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Use the Amazon OpenSearch Serverless API to create, configure, and manage OpenSearch Serverless collections and security policies.</p> <p>OpenSearch Serverless is an on-demand, pre-provisioned serverless configuration for Amazon OpenSearch Service. OpenSearch Serverless removes the operational complexities of provisioning, configuring, and tuning your OpenSearch clusters. It enables you to easily search and analyze petabytes of data without having to worry about the underlying infrastructure and data management.</p> <p> To learn more about OpenSearch Serverless, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-overview.html">What is Amazon OpenSearch Serverless?</a> </p>', 'operations' => [ 'BatchGetCollection' => '<p>Returns attributes for one or more collections, including the collection endpoint and the OpenSearch Dashboards endpoint. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and managing Amazon OpenSearch Serverless collections</a>.</p>', 'BatchGetEffectiveLifecyclePolicy' => '<p>Returns a list of successful and failed retrievals for the OpenSearch Serverless indexes. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list">Viewing data lifecycle policies</a>.</p>', 'BatchGetLifecyclePolicy' => '<p>Returns one or more configured OpenSearch Serverless lifecycle policies. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list">Viewing data lifecycle policies</a>.</p>', 'BatchGetVpcEndpoint' => '<p>Returns attributes for one or more VPC endpoints associated with the current account. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon OpenSearch Serverless using an interface endpoint</a>.</p>', 'CreateAccessPolicy' => '<p>Creates a data access policy for OpenSearch Serverless. Access policies limit access to collections and the resources within them, and allow a user to access that data irrespective of the access mechanism or network source. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data access control for Amazon OpenSearch Serverless</a>.</p>', 'CreateCollection' => '<p>Creates a new OpenSearch Serverless collection. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and managing Amazon OpenSearch Serverless collections</a>.</p>', 'CreateLifecyclePolicy' => '<p>Creates a lifecyle policy to be applied to OpenSearch Serverless indexes. Lifecycle policies define the number of days or hours to retain the data on an OpenSearch Serverless index. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-create">Creating data lifecycle policies</a>.</p>', 'CreateSecurityConfig' => '<p>Specifies a security configuration for OpenSearch Serverless. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML authentication for Amazon OpenSearch Serverless</a>. </p>', 'CreateSecurityPolicy' => '<p>Creates a security policy to be used by one or more OpenSearch Serverless collections. Security policies provide access to a collection and its OpenSearch Dashboards endpoint from public networks or specific VPC endpoints. They also allow you to secure a collection with a KMS encryption key. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network access for Amazon OpenSearch Serverless</a> and <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption at rest for Amazon OpenSearch Serverless</a>.</p>', 'CreateVpcEndpoint' => '<p>Creates an OpenSearch Serverless-managed interface VPC endpoint. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon OpenSearch Serverless using an interface endpoint</a>.</p>', 'DeleteAccessPolicy' => '<p>Deletes an OpenSearch Serverless access policy. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data access control for Amazon OpenSearch Serverless</a>.</p>', 'DeleteCollection' => '<p>Deletes an OpenSearch Serverless collection. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and managing Amazon OpenSearch Serverless collections</a>.</p>', 'DeleteLifecyclePolicy' => '<p>Deletes an OpenSearch Serverless lifecycle policy. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-delete">Deleting data lifecycle policies</a>.</p>', 'DeleteSecurityConfig' => '<p>Deletes a security configuration for OpenSearch Serverless. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML authentication for Amazon OpenSearch Serverless</a>.</p>', 'DeleteSecurityPolicy' => '<p>Deletes an OpenSearch Serverless security policy.</p>', 'DeleteVpcEndpoint' => '<p>Deletes an OpenSearch Serverless-managed interface endpoint. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon OpenSearch Serverless using an interface endpoint</a>.</p>', 'GetAccessPolicy' => '<p>Returns an OpenSearch Serverless access policy. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data access control for Amazon OpenSearch Serverless</a>.</p>', 'GetAccountSettings' => '<p>Returns account-level settings related to OpenSearch Serverless.</p>', 'GetPoliciesStats' => '<p>Returns statistical information about your OpenSearch Serverless access policies, security configurations, and security policies.</p>', 'GetSecurityConfig' => '<p>Returns information about an OpenSearch Serverless security configuration. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML authentication for Amazon OpenSearch Serverless</a>.</p>', 'GetSecurityPolicy' => '<p>Returns information about a configured OpenSearch Serverless security policy. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network access for Amazon OpenSearch Serverless</a> and <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption at rest for Amazon OpenSearch Serverless</a>.</p>', 'ListAccessPolicies' => '<p>Returns information about a list of OpenSearch Serverless access policies.</p>', 'ListCollections' => '<p>Lists all OpenSearch Serverless collections. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and managing Amazon OpenSearch Serverless collections</a>.</p> <note> <p>Make sure to include an empty request body {} if you don\'t include any collection filters in the request.</p> </note>', 'ListLifecyclePolicies' => '<p>Returns a list of OpenSearch Serverless lifecycle policies. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list">Viewing data lifecycle policies</a>.</p>', 'ListSecurityConfigs' => '<p>Returns information about configured OpenSearch Serverless security configurations. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML authentication for Amazon OpenSearch Serverless</a>.</p>', 'ListSecurityPolicies' => '<p>Returns information about configured OpenSearch Serverless security policies.</p>', 'ListTagsForResource' => '<p>Returns the tags for an OpenSearch Serverless resource. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon OpenSearch Serverless collections</a>.</p>', 'ListVpcEndpoints' => '<p>Returns the OpenSearch Serverless-managed interface VPC endpoints associated with the current account. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon OpenSearch Serverless using an interface endpoint</a>.</p>', 'TagResource' => '<p>Associates tags with an OpenSearch Serverless resource. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon OpenSearch Serverless collections</a>.</p>', 'UntagResource' => '<p>Removes a tag or set of tags from an OpenSearch Serverless resource. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon OpenSearch Serverless collections</a>.</p>', 'UpdateAccessPolicy' => '<p>Updates an OpenSearch Serverless access policy. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data access control for Amazon OpenSearch Serverless</a>.</p>', 'UpdateAccountSettings' => '<p>Update the OpenSearch Serverless settings for the current Amazon Web Services account. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html">Managing capacity limits for Amazon OpenSearch Serverless</a>.</p>', 'UpdateCollection' => '<p>Updates an OpenSearch Serverless collection.</p>', 'UpdateLifecyclePolicy' => '<p>Updates an OpenSearch Serverless access policy. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-update">Updating data lifecycle policies</a>.</p>', 'UpdateSecurityConfig' => '<p>Updates a security configuration for OpenSearch Serverless. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML authentication for Amazon OpenSearch Serverless</a>.</p>', 'UpdateSecurityPolicy' => '<p>Updates an OpenSearch Serverless security policy. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network access for Amazon OpenSearch Serverless</a> and <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption at rest for Amazon OpenSearch Serverless</a>.</p>', 'UpdateVpcEndpoint' => '<p>Updates an OpenSearch Serverless-managed interface endpoint. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon OpenSearch Serverless using an interface endpoint</a>.</p>', ], 'shapes' => [ 'AccessPolicyDetail' => [ 'base' => '<p>Details about an OpenSearch Serverless access policy.</p>', 'refs' => [ 'CreateAccessPolicyResponse$accessPolicyDetail' => '<p>Details about the created access policy.</p>', 'GetAccessPolicyResponse$accessPolicyDetail' => '<p>Details about the requested access policy.</p>', 'UpdateAccessPolicyResponse$accessPolicyDetail' => '<p>Details about the updated access policy.</p>', ], ], 'AccessPolicyStats' => [ 'base' => '<p>Statistics for an OpenSearch Serverless access policy.</p>', 'refs' => [ 'GetPoliciesStatsResponse$AccessPolicyStats' => '<p>Information about the data access policies in your account.</p>', ], ], 'AccessPolicySummaries' => [ 'base' => NULL, 'refs' => [ 'ListAccessPoliciesResponse$accessPolicySummaries' => '<p>Details about the requested access policies.</p>', ], ], 'AccessPolicySummary' => [ 'base' => '<p>A summary of the data access policy.</p>', 'refs' => [ 'AccessPolicySummaries$member' => NULL, ], ], 'AccessPolicyType' => [ 'base' => NULL, 'refs' => [ 'AccessPolicyDetail$type' => '<p>The type of access policy.</p>', 'AccessPolicySummary$type' => '<p>The type of access policy. Currently, the only available type is <code>data</code>.</p>', 'CreateAccessPolicyRequest$type' => '<p>The type of policy.</p>', 'DeleteAccessPolicyRequest$type' => '<p>The type of policy.</p>', 'GetAccessPolicyRequest$type' => '<p>Tye type of policy. Currently, the only supported value is <code>data</code>.</p>', 'ListAccessPoliciesRequest$type' => '<p>The type of access policy.</p>', 'UpdateAccessPolicyRequest$type' => '<p>The type of policy.</p>', ], ], 'AccountSettingsDetail' => [ 'base' => '<p>OpenSearch Serverless-related information for the current account.</p>', 'refs' => [ 'GetAccountSettingsResponse$accountSettingsDetail' => '<p>OpenSearch Serverless-related details for the current account.</p>', 'UpdateAccountSettingsResponse$accountSettingsDetail' => '<p>OpenSearch Serverless-related settings for the current Amazon Web Services account. </p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource. The resource must be active (not in the <code>DELETING</code> state), and must be owned by the account ID included in the request.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource. The resource must be active (not in the <code>DELETING</code> state), and must be owned by the account ID included in the request.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to remove tags from. The resource must be active (not in the <code>DELETING</code> state), and must be owned by the account ID included in the request.</p>', ], ], 'BatchGetCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetEffectiveLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetEffectiveLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetVpcEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'BatchGetVpcEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'EffectiveLifecyclePolicyDetail$noMinRetentionPeriod' => '<p>The minimum number of index retention days set. That is an optional param that will return as <code>true</code> if the minimum number of days or hours is not set to a index resource.</p>', ], ], 'CapacityLimits' => [ 'base' => '<p>The maximum capacity limits for all OpenSearch Serverless collections, in OpenSearch Compute Units (OCUs). These limits are used to scale your collections based on the current workload. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html">Managing capacity limits for Amazon OpenSearch Serverless</a>.</p>', 'refs' => [ 'AccountSettingsDetail$capacityLimits' => NULL, 'UpdateAccountSettingsRequest$capacityLimits' => NULL, ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateAccessPolicyRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'CreateCollectionRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'CreateLifecyclePolicyRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'CreateSecurityConfigRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'CreateSecurityPolicyRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'CreateVpcEndpointRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'DeleteAccessPolicyRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'DeleteCollectionRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'DeleteLifecyclePolicyRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'DeleteSecurityConfigRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'DeleteSecurityPolicyRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'DeleteVpcEndpointRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'UpdateAccessPolicyRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'UpdateCollectionRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'UpdateLifecyclePolicyRequest$clientToken' => '<p>A unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'UpdateSecurityConfigRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'UpdateSecurityPolicyRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', 'UpdateVpcEndpointRequest$clientToken' => '<p>Unique, case-sensitive identifier to ensure idempotency of the request.</p>', ], ], 'CollectionDetail' => [ 'base' => '<p>Details about each OpenSearch Serverless collection, including the collection endpoint and the OpenSearch Dashboards endpoint.</p>', 'refs' => [ 'CollectionDetails$member' => NULL, ], ], 'CollectionDetails' => [ 'base' => NULL, 'refs' => [ 'BatchGetCollectionResponse$collectionDetails' => '<p>Details about each collection.</p>', ], ], 'CollectionErrorDetail' => [ 'base' => '<p>Error information for an OpenSearch Serverless request.</p>', 'refs' => [ 'CollectionErrorDetails$member' => NULL, ], ], 'CollectionErrorDetails' => [ 'base' => NULL, 'refs' => [ 'BatchGetCollectionResponse$collectionErrorDetails' => '<p>Error information for the request.</p>', ], ], 'CollectionFilters' => [ 'base' => '<p>A list of filter keys that you can use for LIST, UPDATE, and DELETE requests to OpenSearch Serverless collections.</p>', 'refs' => [ 'ListCollectionsRequest$collectionFilters' => '<p> A list of filter names and values that you can use for requests.</p>', ], ], 'CollectionId' => [ 'base' => NULL, 'refs' => [ 'CollectionDetail$id' => '<p>A unique identifier for the collection.</p>', 'CollectionErrorDetail$id' => '<p>If the request contains collection IDs, the response includes the IDs provided in the request.</p>', 'CollectionIds$member' => NULL, 'CollectionSummary$id' => '<p>The unique identifier of the collection.</p>', 'CreateCollectionDetail$id' => '<p>The unique identifier of the collection.</p>', 'DeleteCollectionDetail$id' => '<p>The unique identifier of the collection.</p>', 'DeleteCollectionRequest$id' => '<p>The unique identifier of the collection. For example, <code>1iu5usc406kd</code>. The ID is part of the collection endpoint. You can also retrieve it using the <a href="https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_ListCollections.html">ListCollections</a> API.</p>', 'UpdateCollectionDetail$id' => '<p>The unique identifier of the collection.</p>', 'UpdateCollectionRequest$id' => '<p>The unique identifier of the collection.</p>', ], ], 'CollectionIds' => [ 'base' => NULL, 'refs' => [ 'BatchGetCollectionRequest$ids' => '<p>A list of collection IDs. You can\'t provide names and IDs in the same request. The ID is part of the collection endpoint. You can also retrieve it using the <a href="https://docs.aws.amazon.com/opensearch-service/latest/ServerlessAPIReference/API_ListCollections.html">ListCollections</a> API.</p>', ], ], 'CollectionName' => [ 'base' => NULL, 'refs' => [ 'CollectionDetail$name' => '<p>The name of the collection.</p>', 'CollectionErrorDetail$name' => '<p>If the request contains collection names, the response includes the names provided in the request.</p>', 'CollectionFilters$name' => '<p>The name of the collection.</p>', 'CollectionNames$member' => NULL, 'CollectionSummary$name' => '<p>The name of the collection.</p>', 'CreateCollectionDetail$name' => '<p>The name of the collection.</p>', 'CreateCollectionRequest$name' => '<p>Name of the collection.</p>', 'DeleteCollectionDetail$name' => '<p>The name of the collection.</p>', 'UpdateCollectionDetail$name' => '<p>The name of the collection.</p>', ], ], 'CollectionNames' => [ 'base' => NULL, 'refs' => [ 'BatchGetCollectionRequest$names' => '<p>A list of collection names. You can\'t provide names and IDs in the same request.</p>', ], ], 'CollectionStatus' => [ 'base' => NULL, 'refs' => [ 'CollectionDetail$status' => '<p>The current status of the collection.</p>', 'CollectionFilters$status' => '<p>The current status of the collection.</p>', 'CollectionSummary$status' => '<p>The current status of the collection.</p>', 'CreateCollectionDetail$status' => '<p>The current status of the collection.</p>', 'DeleteCollectionDetail$status' => '<p>The current status of the collection.</p>', 'UpdateCollectionDetail$status' => '<p>The current status of the collection.</p>', ], ], 'CollectionSummaries' => [ 'base' => NULL, 'refs' => [ 'ListCollectionsResponse$collectionSummaries' => '<p>Details about each collection.</p>', ], ], 'CollectionSummary' => [ 'base' => '<p>Details about each OpenSearch Serverless collection.</p>', 'refs' => [ 'CollectionSummaries$member' => NULL, ], ], 'CollectionType' => [ 'base' => NULL, 'refs' => [ 'CollectionDetail$type' => '<p>The type of collection.</p>', 'CreateCollectionDetail$type' => '<p>The type of collection.</p>', 'CreateCollectionRequest$type' => '<p>The type of collection.</p>', 'UpdateCollectionDetail$type' => '<p>The collection type.</p>', ], ], 'ConfigDescription' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityConfigRequest$description' => '<p>A description of the security configuration.</p>', 'SecurityConfigDetail$description' => '<p>The description of the security configuration.</p>', 'SecurityConfigSummary$description' => '<p>The description of the security configuration.</p>', 'UpdateSecurityConfigRequest$description' => '<p>A description of the security configuration.</p>', ], ], 'ConfigName' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityConfigRequest$name' => '<p>The name of the security configuration.</p>', ], ], 'ConflictException' => [ 'base' => '<p>When creating a resource, thrown when a resource with the same name already exists or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.</p>', 'refs' => [], ], 'CreateAccessPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateAccessPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCollectionDetail' => [ 'base' => '<p>Details about the created OpenSearch Serverless collection.</p>', 'refs' => [ 'CreateCollectionResponse$createCollectionDetail' => '<p>Details about the collection.</p>', ], ], 'CreateCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCollectionRequestDescriptionString' => [ 'base' => NULL, 'refs' => [ 'CreateCollectionRequest$description' => '<p>Description of the collection.</p>', ], ], 'CreateCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSecurityPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointDetail' => [ 'base' => '<p>Creation details for an OpenSearch Serverless-managed interface endpoint. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon OpenSearch Serverless using an interface endpoint</a>.</p>', 'refs' => [ 'CreateVpcEndpointResponse$createVpcEndpointDetail' => '<p>Details about the created interface VPC endpoint.</p>', ], ], 'CreateVpcEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVpcEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAccessPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCollectionDetail' => [ 'base' => '<p>Details about a deleted OpenSearch Serverless collection.</p>', 'refs' => [ 'DeleteCollectionResponse$deleteCollectionDetail' => '<p>Details of the deleted collection.</p>', ], ], 'DeleteCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecurityConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecurityConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecurityPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSecurityPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointDetail' => [ 'base' => '<p>Deletion details for an OpenSearch Serverless-managed interface endpoint.</p>', 'refs' => [ 'DeleteVpcEndpointResponse$deleteVpcEndpointDetail' => '<p>Details about the deleted endpoint.</p>', ], ], 'DeleteVpcEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVpcEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'Document' => [ 'base' => NULL, 'refs' => [ 'AccessPolicyDetail$policy' => '<p>The JSON policy document without any whitespaces.</p>', 'LifecyclePolicyDetail$policy' => '<p>The JSON policy document without any whitespaces.</p>', 'SecurityPolicyDetail$policy' => '<p>The JSON policy document without any whitespaces.</p>', ], ], 'EffectiveLifecyclePolicyDetail' => [ 'base' => '<p>Error information for an OpenSearch Serverless request.</p>', 'refs' => [ 'EffectiveLifecyclePolicyDetails$member' => NULL, ], ], 'EffectiveLifecyclePolicyDetails' => [ 'base' => NULL, 'refs' => [ 'BatchGetEffectiveLifecyclePolicyResponse$effectiveLifecyclePolicyDetails' => '<p>A list of lifecycle policies applied to the OpenSearch Serverless indexes.</p>', ], ], 'EffectiveLifecyclePolicyErrorDetail' => [ 'base' => '<p>Error information for an OpenSearch Serverless request.</p>', 'refs' => [ 'EffectiveLifecyclePolicyErrorDetails$member' => NULL, ], ], 'EffectiveLifecyclePolicyErrorDetails' => [ 'base' => NULL, 'refs' => [ 'BatchGetEffectiveLifecyclePolicyResponse$effectiveLifecyclePolicyErrorDetails' => '<p>A list of resources for which retrieval failed.</p>', ], ], 'GetAccessPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccessPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAccountSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAccountSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetPoliciesStatsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetPoliciesStatsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSecurityConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSecurityConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSecurityPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSecurityPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'IndexingCapacityValue' => [ 'base' => NULL, 'refs' => [ 'CapacityLimits$maxIndexingCapacityInOCU' => '<p>The maximum indexing capacity for collections.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>Thrown when an error internal to the service occurs while processing a request.</p>', 'refs' => [], ], 'LifecyclePolicyDetail' => [ 'base' => '<p>Details about an OpenSearch Serverless lifecycle policy.</p>', 'refs' => [ 'CreateLifecyclePolicyResponse$lifecyclePolicyDetail' => '<p>Details about the created lifecycle policy.</p>', 'LifecyclePolicyDetails$member' => NULL, 'UpdateLifecyclePolicyResponse$lifecyclePolicyDetail' => '<p>Details about the updated lifecycle policy.</p>', ], ], 'LifecyclePolicyDetails' => [ 'base' => NULL, 'refs' => [ 'BatchGetLifecyclePolicyResponse$lifecyclePolicyDetails' => '<p>A list of lifecycle policies matched to the input policy name and policy type.</p>', ], ], 'LifecyclePolicyErrorDetail' => [ 'base' => '<p>Error information for an OpenSearch Serverless request.</p>', 'refs' => [ 'LifecyclePolicyErrorDetails$member' => NULL, ], ], 'LifecyclePolicyErrorDetails' => [ 'base' => NULL, 'refs' => [ 'BatchGetLifecyclePolicyResponse$lifecyclePolicyErrorDetails' => '<p>A list of lifecycle policy names and policy types for which retrieval failed.</p>', ], ], 'LifecyclePolicyIdentifier' => [ 'base' => '<p>The unique identifiers of policy types and policy names.</p>', 'refs' => [ 'LifecyclePolicyIdentifiers$member' => NULL, ], ], 'LifecyclePolicyIdentifiers' => [ 'base' => NULL, 'refs' => [ 'BatchGetLifecyclePolicyRequest$identifiers' => '<p>The unique identifiers of policy types and policy names.</p>', ], ], 'LifecyclePolicyResourceIdentifier' => [ 'base' => '<p>The unique identifiers of policy types and resource names.</p>', 'refs' => [ 'LifecyclePolicyResourceIdentifiers$member' => NULL, ], ], 'LifecyclePolicyResourceIdentifiers' => [ 'base' => NULL, 'refs' => [ 'BatchGetEffectiveLifecyclePolicyRequest$resourceIdentifiers' => '<p>The unique identifiers of policy types and resource names.</p>', ], ], 'LifecyclePolicyStats' => [ 'base' => '<p>Statistics for an OpenSearch Serverless lifecycle policy.</p>', 'refs' => [ 'GetPoliciesStatsResponse$LifecyclePolicyStats' => '<p>Information about the lifecycle policies in your account.</p>', ], ], 'LifecyclePolicySummaries' => [ 'base' => NULL, 'refs' => [ 'ListLifecyclePoliciesResponse$lifecyclePolicySummaries' => '<p>Details about the requested lifecycle policies.</p>', ], ], 'LifecyclePolicySummary' => [ 'base' => '<p>A summary of the lifecycle policy.</p>', 'refs' => [ 'LifecyclePolicySummaries$member' => NULL, ], ], 'LifecyclePolicyType' => [ 'base' => NULL, 'refs' => [ 'CreateLifecyclePolicyRequest$type' => '<p>The type of lifecycle policy.</p>', 'DeleteLifecyclePolicyRequest$type' => '<p>The type of lifecycle policy.</p>', 'EffectiveLifecyclePolicyDetail$type' => '<p>The type of lifecycle policy.</p>', 'EffectiveLifecyclePolicyErrorDetail$type' => '<p>The type of lifecycle policy.</p>', 'LifecyclePolicyDetail$type' => '<p>The type of lifecycle policy.</p>', 'LifecyclePolicyErrorDetail$type' => '<p>The type of lifecycle policy.</p>', 'LifecyclePolicyIdentifier$type' => '<p>The type of lifecycle policy.</p>', 'LifecyclePolicyResourceIdentifier$type' => '<p>The type of lifecycle policy.</p>', 'LifecyclePolicySummary$type' => '<p>The type of lifecycle policy.</p>', 'ListLifecyclePoliciesRequest$type' => '<p>The type of lifecycle policy.</p>', 'UpdateLifecyclePolicyRequest$type' => '<p> The type of lifecycle policy.</p>', ], ], 'LifecycleResource' => [ 'base' => NULL, 'refs' => [ 'ListLifecyclePoliciesRequestResourcesList$member' => NULL, ], ], 'ListAccessPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAccessPoliciesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListAccessPoliciesRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results. The default is 20.</p>', ], ], 'ListAccessPoliciesRequestResourceList' => [ 'base' => NULL, 'refs' => [ 'ListAccessPoliciesRequest$resource' => '<p>Resource filters (can be collections or indexes) that policies can apply to.</p>', ], ], 'ListAccessPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCollectionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCollectionsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListCollectionsRequest$maxResults' => '<p>The maximum number of results to return. Default is 20. You can use <code>nextToken</code> to get the next page of results.</p>', ], ], 'ListCollectionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLifecyclePoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLifecyclePoliciesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListLifecyclePoliciesRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use use <code>nextToken</code> to get the next page of results. The default is 10.</p>', ], ], 'ListLifecyclePoliciesRequestResourcesList' => [ 'base' => NULL, 'refs' => [ 'ListLifecyclePoliciesRequest$resources' => '<p>Resource filters that policies can apply to. Currently, the only supported resource type is <code>index</code>.</p>', ], ], 'ListLifecyclePoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityConfigsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityConfigsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSecurityConfigsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results. The default is 20.</p>', ], ], 'ListSecurityConfigsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityPoliciesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSecurityPoliciesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSecurityPoliciesRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results. The default is 20.</p>', ], ], 'ListSecurityPoliciesRequestResourceList' => [ 'base' => NULL, 'refs' => [ 'ListSecurityPoliciesRequest$resource' => '<p>Resource filters (can be collection or indexes) that policies can apply to. </p>', ], ], 'ListSecurityPoliciesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVpcEndpointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVpcEndpointsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListVpcEndpointsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results. The default is 20.</p>', ], ], 'ListVpcEndpointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'AccessPolicyDetail$createdDate' => '<p>The date the policy was created.</p>', 'AccessPolicyDetail$lastModifiedDate' => '<p>The timestamp of when the policy was last modified.</p>', 'AccessPolicyStats$DataPolicyCount' => '<p>The number of data access policies in the current account.</p>', 'AccessPolicySummary$createdDate' => '<p>The Epoch time when the access policy was created.</p>', 'AccessPolicySummary$lastModifiedDate' => '<p>The date and time when the collection was last modified.</p>', 'CollectionDetail$createdDate' => '<p>The Epoch time when the collection was created.</p>', 'CollectionDetail$lastModifiedDate' => '<p>The date and time when the collection was last modified.</p>', 'CreateCollectionDetail$createdDate' => '<p>The Epoch time when the collection was created.</p>', 'CreateCollectionDetail$lastModifiedDate' => '<p>The date and time when the collection was last modified.</p>', 'GetPoliciesStatsResponse$TotalPolicyCount' => '<p>The total number of OpenSearch Serverless security policies and configurations in your account.</p>', 'LifecyclePolicyDetail$createdDate' => '<p>The date the lifecycle policy was created.</p>', 'LifecyclePolicyDetail$lastModifiedDate' => '<p>The timestamp of when the lifecycle policy was last modified.</p>', 'LifecyclePolicyStats$RetentionPolicyCount' => '<p>The number of retention lifecycle policies in the current account.</p>', 'LifecyclePolicySummary$createdDate' => '<p>The Epoch time when the lifecycle policy was created.</p>', 'LifecyclePolicySummary$lastModifiedDate' => '<p>The date and time when the lifecycle policy was last modified.</p>', 'SecurityConfigDetail$createdDate' => '<p>The date the configuration was created.</p>', 'SecurityConfigDetail$lastModifiedDate' => '<p>The timestamp of when the configuration was last modified.</p>', 'SecurityConfigStats$SamlConfigCount' => '<p>The number of security configurations in the current account.</p>', 'SecurityConfigSummary$createdDate' => '<p>The Epoch time when the security configuration was created.</p>', 'SecurityConfigSummary$lastModifiedDate' => '<p>The timestamp of when the configuration was last modified.</p>', 'SecurityPolicyDetail$createdDate' => '<p>The date the policy was created.</p>', 'SecurityPolicyDetail$lastModifiedDate' => '<p>The timestamp of when the policy was last modified.</p>', 'SecurityPolicyStats$EncryptionPolicyCount' => '<p>The number of encryption policies in the current account.</p>', 'SecurityPolicyStats$NetworkPolicyCount' => '<p>The number of network policies in the current account.</p>', 'SecurityPolicySummary$createdDate' => '<p>The date the policy was created.</p>', 'SecurityPolicySummary$lastModifiedDate' => '<p>The timestamp of when the policy was last modified.</p>', 'UpdateCollectionDetail$createdDate' => '<p>The date and time when the collection was created.</p>', 'UpdateCollectionDetail$lastModifiedDate' => '<p>The date and time when the collection was last modified.</p>', 'UpdateVpcEndpointDetail$lastModifiedDate' => '<p>The timestamp of when the endpoint was last modified.</p>', 'VpcEndpointDetail$createdDate' => '<p>The date the endpoint was created.</p>', ], ], 'OcuLimitExceededException' => [ 'base' => '<p>Thrown when the collection you\'re attempting to create results in a number of search or indexing OCUs that exceeds the account limit. </p>', 'refs' => [], ], 'PolicyDescription' => [ 'base' => NULL, 'refs' => [ 'AccessPolicyDetail$description' => '<p>The description of the policy.</p>', 'AccessPolicySummary$description' => '<p>The description of the access policy.</p>', 'CreateAccessPolicyRequest$description' => '<p>A description of the policy. Typically used to store information about the permissions defined in the policy.</p>', 'CreateLifecyclePolicyRequest$description' => '<p>A description of the lifecycle policy.</p>', 'CreateSecurityPolicyRequest$description' => '<p>A description of the policy. Typically used to store information about the permissions defined in the policy.</p>', 'LifecyclePolicyDetail$description' => '<p>The description of the lifecycle policy.</p>', 'LifecyclePolicySummary$description' => '<p>The description of the lifecycle policy.</p>', 'SecurityPolicyDetail$description' => '<p>The description of the security policy.</p>', 'SecurityPolicySummary$description' => '<p>The description of the security policy.</p>', 'UpdateAccessPolicyRequest$description' => '<p>A description of the policy. Typically used to store information about the permissions defined in the policy.</p>', 'UpdateLifecyclePolicyRequest$description' => '<p>A description of the lifecycle policy.</p>', 'UpdateSecurityPolicyRequest$description' => '<p>A description of the policy. Typically used to store information about the permissions defined in the policy.</p>', ], ], 'PolicyDocument' => [ 'base' => NULL, 'refs' => [ 'CreateAccessPolicyRequest$policy' => '<p>The JSON policy document to use as the content for the policy.</p>', 'CreateLifecyclePolicyRequest$policy' => '<p>The JSON policy document to use as the content for the lifecycle policy.</p>', 'CreateSecurityPolicyRequest$policy' => '<p>The JSON policy document to use as the content for the new policy.</p>', 'UpdateAccessPolicyRequest$policy' => '<p>The JSON policy document to use as the content for the policy.</p>', 'UpdateLifecyclePolicyRequest$policy' => '<p>The JSON policy document to use as the content for the lifecycle policy.</p>', 'UpdateSecurityPolicyRequest$policy' => '<p>The JSON policy document to use as the content for the new policy.</p>', ], ], 'PolicyName' => [ 'base' => NULL, 'refs' => [ 'AccessPolicyDetail$name' => '<p>The name of the policy.</p>', 'AccessPolicySummary$name' => '<p>The name of the access policy.</p>', 'CreateAccessPolicyRequest$name' => '<p>The name of the policy.</p>', 'CreateLifecyclePolicyRequest$name' => '<p>The name of the lifecycle policy.</p>', 'CreateSecurityPolicyRequest$name' => '<p>The name of the policy.</p>', 'DeleteAccessPolicyRequest$name' => '<p>The name of the policy to delete.</p>', 'DeleteLifecyclePolicyRequest$name' => '<p>The name of the policy to delete.</p>', 'DeleteSecurityPolicyRequest$name' => '<p>The name of the policy to delete.</p>', 'EffectiveLifecyclePolicyDetail$policyName' => '<p>The name of the lifecycle policy.</p>', 'GetAccessPolicyRequest$name' => '<p>The name of the access policy.</p>', 'GetSecurityPolicyRequest$name' => '<p>The name of the security policy.</p>', 'LifecyclePolicyDetail$name' => '<p>The name of the lifecycle policy.</p>', 'LifecyclePolicyErrorDetail$name' => '<p>The name of the lifecycle policy.</p>', 'LifecyclePolicyIdentifier$name' => '<p>The name of the lifecycle policy.</p>', 'LifecyclePolicySummary$name' => '<p>The name of the lifecycle policy.</p>', 'SecurityPolicyDetail$name' => '<p>The name of the policy.</p>', 'SecurityPolicySummary$name' => '<p>The name of the policy.</p>', 'UpdateAccessPolicyRequest$name' => '<p>The name of the policy.</p>', 'UpdateLifecyclePolicyRequest$name' => '<p>The name of the policy.</p>', 'UpdateSecurityPolicyRequest$name' => '<p>The name of the policy.</p>', ], ], 'PolicyVersion' => [ 'base' => NULL, 'refs' => [ 'AccessPolicyDetail$policyVersion' => '<p>The version of the policy.</p>', 'AccessPolicySummary$policyVersion' => '<p>The version of the policy.</p>', 'LifecyclePolicyDetail$policyVersion' => '<p>The version of the lifecycle policy.</p>', 'LifecyclePolicySummary$policyVersion' => '<p>The version of the lifecycle policy.</p>', 'SecurityConfigDetail$configVersion' => '<p>The version of the security configuration.</p>', 'SecurityConfigSummary$configVersion' => '<p>The version of the security configuration.</p>', 'SecurityPolicyDetail$policyVersion' => '<p>The version of the policy.</p>', 'SecurityPolicySummary$policyVersion' => '<p>The version of the policy.</p>', 'UpdateAccessPolicyRequest$policyVersion' => '<p>The version of the policy being updated.</p>', 'UpdateLifecyclePolicyRequest$policyVersion' => '<p>The version of the policy being updated.</p>', 'UpdateSecurityConfigRequest$configVersion' => '<p>The version of the security configuration to be updated. You can find the most recent version of a security configuration using the <code>GetSecurityPolicy</code> command.</p>', 'UpdateSecurityPolicyRequest$policyVersion' => '<p>The version of the policy being updated.</p>', ], ], 'Resource' => [ 'base' => NULL, 'refs' => [ 'EffectiveLifecyclePolicyDetail$resource' => '<p>The name of the OpenSearch Serverless index resource.</p>', 'EffectiveLifecyclePolicyErrorDetail$resource' => '<p>The name of OpenSearch Serverless index resource.</p>', 'ListAccessPoliciesRequestResourceList$member' => NULL, 'ListSecurityPoliciesRequestResourceList$member' => NULL, ], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'LifecyclePolicyResourceIdentifier$resource' => '<p>The name of the OpenSearch Serverless ilndex resource.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>Thrown when accessing or deleting a resource that does not exist.</p>', 'refs' => [], ], 'ResourceType' => [ 'base' => NULL, 'refs' => [ 'EffectiveLifecyclePolicyDetail$resourceType' => '<p>The type of OpenSearch Serverless resource. Currently, the only supported resource is <code>index</code>.</p>', ], ], 'SamlConfigOptions' => [ 'base' => '<p>Describes SAML options for an OpenSearch Serverless security configuration in the form of a key-value map.</p>', 'refs' => [ 'CreateSecurityConfigRequest$samlOptions' => '<p>Describes SAML options in in the form of a key-value map. This field is required if you specify <code>saml</code> for the <code>type</code> parameter.</p>', 'SecurityConfigDetail$samlOptions' => '<p>SAML options for the security configuration in the form of a key-value map.</p>', 'UpdateSecurityConfigRequest$samlOptions' => '<p>SAML options in in the form of a key-value map.</p>', ], ], 'SamlConfigOptionsSessionTimeoutInteger' => [ 'base' => NULL, 'refs' => [ 'SamlConfigOptions$sessionTimeout' => '<p>The session timeout, in minutes. Default is 60 minutes (12 hours).</p>', ], ], 'SearchCapacityValue' => [ 'base' => NULL, 'refs' => [ 'CapacityLimits$maxSearchCapacityInOCU' => '<p>The maximum search capacity for collections.</p>', ], ], 'SecurityConfigDetail' => [ 'base' => '<p>Details about a security configuration for OpenSearch Serverless. </p>', 'refs' => [ 'CreateSecurityConfigResponse$securityConfigDetail' => '<p>Details about the created security configuration. </p>', 'GetSecurityConfigResponse$securityConfigDetail' => '<p>Details of the requested security configuration.</p>', 'UpdateSecurityConfigResponse$securityConfigDetail' => '<p>Details about the updated security configuration. </p>', ], ], 'SecurityConfigId' => [ 'base' => NULL, 'refs' => [ 'DeleteSecurityConfigRequest$id' => '<p>The security configuration identifier. For SAML the ID will be <code>saml/&lt;accountId&gt;/&lt;idpProviderName&gt;</code>. For example, <code>saml/123456789123/OKTADev</code>.</p>', 'GetSecurityConfigRequest$id' => '<p>The unique identifier of the security configuration.</p>', 'SecurityConfigDetail$id' => '<p>The unique identifier of the security configuration.</p>', 'SecurityConfigSummary$id' => '<p>The unique identifier of the security configuration.</p>', 'UpdateSecurityConfigRequest$id' => '<p>The security configuration identifier. For SAML the ID will be <code>saml/&lt;accountId&gt;/&lt;idpProviderName&gt;</code>. For example, <code>saml/123456789123/OKTADev</code>.</p>', ], ], 'SecurityConfigStats' => [ 'base' => '<p>Statistics for an OpenSearch Serverless security configuration.</p>', 'refs' => [ 'GetPoliciesStatsResponse$SecurityConfigStats' => '<p>Information about the security configurations in your account.</p>', ], ], 'SecurityConfigSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSecurityConfigsResponse$securityConfigSummaries' => '<p>Details about the security configurations in your account.</p>', ], ], 'SecurityConfigSummary' => [ 'base' => '<p>A summary of a security configuration for OpenSearch Serverless.</p>', 'refs' => [ 'SecurityConfigSummaries$member' => NULL, ], ], 'SecurityConfigType' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityConfigRequest$type' => '<p>The type of security configuration.</p>', 'ListSecurityConfigsRequest$type' => '<p>The type of security configuration.</p>', 'SecurityConfigDetail$type' => '<p>The type of security configuration.</p>', 'SecurityConfigSummary$type' => '<p>The type of security configuration.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => NULL, 'refs' => [ 'CreateVpcEndpointRequest$securityGroupIds' => '<p>The unique identifiers of the security groups that define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>', 'UpdateVpcEndpointDetail$securityGroupIds' => '<p>The unique identifiers of the security groups that define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>', 'UpdateVpcEndpointRequest$addSecurityGroupIds' => '<p>The unique identifiers of the security groups to add to the endpoint. Security groups define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>', 'UpdateVpcEndpointRequest$removeSecurityGroupIds' => '<p>The unique identifiers of the security groups to remove from the endpoint.</p>', 'VpcEndpointDetail$securityGroupIds' => '<p>The unique identifiers of the security groups that define the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>', ], ], 'SecurityPolicyDetail' => [ 'base' => '<p>Details about an OpenSearch Serverless security policy.</p>', 'refs' => [ 'CreateSecurityPolicyResponse$securityPolicyDetail' => '<p>Details about the created security policy.</p>', 'GetSecurityPolicyResponse$securityPolicyDetail' => '<p>Details about the requested security policy.</p>', 'UpdateSecurityPolicyResponse$securityPolicyDetail' => '<p>Details about the updated security policy.</p>', ], ], 'SecurityPolicyStats' => [ 'base' => '<p>Statistics for an OpenSearch Serverless security policy.</p>', 'refs' => [ 'GetPoliciesStatsResponse$SecurityPolicyStats' => '<p>Information about the security policies in your account.</p>', ], ], 'SecurityPolicySummaries' => [ 'base' => NULL, 'refs' => [ 'ListSecurityPoliciesResponse$securityPolicySummaries' => '<p>Details about the security policies in your account.</p>', ], ], 'SecurityPolicySummary' => [ 'base' => '<p>A summary of a security policy for OpenSearch Serverless.</p>', 'refs' => [ 'SecurityPolicySummaries$member' => NULL, ], ], 'SecurityPolicyType' => [ 'base' => NULL, 'refs' => [ 'CreateSecurityPolicyRequest$type' => '<p>The type of security policy.</p>', 'DeleteSecurityPolicyRequest$type' => '<p>The type of policy.</p>', 'GetSecurityPolicyRequest$type' => '<p>The type of security policy.</p>', 'ListSecurityPoliciesRequest$type' => '<p>The type of policy.</p>', 'SecurityPolicyDetail$type' => '<p>The type of security policy.</p>', 'SecurityPolicySummary$type' => '<p>The type of security policy.</p>', 'UpdateSecurityPolicyRequest$type' => '<p>The type of access policy.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Thrown when you attempt to create more resources than the service allows based on service quotas.</p>', 'refs' => [], ], 'StandbyReplicas' => [ 'base' => NULL, 'refs' => [ 'CollectionDetail$standbyReplicas' => '<p>Details about an OpenSearch Serverless collection.</p>', 'CreateCollectionDetail$standbyReplicas' => '<p>Creates details about an OpenSearch Serverless collection.</p>', 'CreateCollectionRequest$standbyReplicas' => '<p>Indicates whether standby replicas should be used for a collection.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'CollectionDetail$arn' => '<p>The Amazon Resource Name (ARN) of the collection.</p>', 'CollectionDetail$collectionEndpoint' => '<p>Collection-specific endpoint used to submit index, search, and data upload requests to an OpenSearch Serverless collection.</p>', 'CollectionDetail$dashboardEndpoint' => '<p>Collection-specific endpoint used to access OpenSearch Dashboards.</p>', 'CollectionDetail$description' => '<p>A description of the collection.</p>', 'CollectionDetail$failureCode' => '<p>A failure code associated with the request.</p>', 'CollectionDetail$failureMessage' => '<p>A message associated with the failure code.</p>', 'CollectionDetail$kmsKeyArn' => '<p>The ARN of the Amazon Web Services KMS key used to encrypt the collection.</p>', 'CollectionErrorDetail$errorCode' => '<p>The error code for the request. For example, <code>NOT_FOUND</code>.</p>', 'CollectionErrorDetail$errorMessage' => '<p>A description of the error. For example, <code>The specified Collection is not found.</code> </p>', 'CollectionSummary$arn' => '<p>The Amazon Resource Name (ARN) of the collection.</p>', 'ConflictException$message' => NULL, 'CreateCollectionDetail$arn' => '<p>The Amazon Resource Name (ARN) of the collection.</p>', 'CreateCollectionDetail$description' => '<p>A description of the collection.</p>', 'CreateCollectionDetail$kmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the KMS key with which to encrypt the collection.</p>', 'EffectiveLifecyclePolicyDetail$retentionPeriod' => '<p>The minimum number of index retention in days or hours. This is an optional parameter that will return only if it’s set.</p>', 'EffectiveLifecyclePolicyErrorDetail$errorCode' => '<p>The error code for the request.</p>', 'EffectiveLifecyclePolicyErrorDetail$errorMessage' => '<p>A description of the error. For example, <code>The specified Index resource is not found</code>.</p>', 'InternalServerException$message' => NULL, 'LifecyclePolicyErrorDetail$errorCode' => '<p>The error code for the request. For example, <code>NOT_FOUND</code>.</p>', 'LifecyclePolicyErrorDetail$errorMessage' => '<p>A description of the error. For example, <code>The specified Lifecycle Policy is not found</code>.</p>', 'ListAccessPoliciesRequest$nextToken' => '<p>If your initial <code>ListAccessPolicies</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListAccessPolicies</code> operations, which returns results in the next page. </p>', 'ListAccessPoliciesResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListCollectionsRequest$nextToken' => '<p>If your initial <code>ListCollections</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListCollections</code> operations, which returns results in the next page.</p>', 'ListCollectionsResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListLifecyclePoliciesRequest$nextToken' => '<p>If your initial <code>ListLifecyclePolicies</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListLifecyclePolicies</code> operations, which returns results in the next page.</p>', 'ListLifecyclePoliciesResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListSecurityConfigsRequest$nextToken' => '<p>If your initial <code>ListSecurityConfigs</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListSecurityConfigs</code> operations, which returns results in the next page. </p>', 'ListSecurityConfigsResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListSecurityPoliciesRequest$nextToken' => '<p>If your initial <code>ListSecurityPolicies</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListSecurityPolicies</code> operations, which returns results in the next page. </p>', 'ListSecurityPoliciesResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListVpcEndpointsRequest$nextToken' => '<p>If your initial <code>ListVpcEndpoints</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in subsequent <code>ListVpcEndpoints</code> operations, which returns results in the next page. </p>', 'ListVpcEndpointsResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'OcuLimitExceededException$message' => '<p>Description of the error.</p>', 'ResourceNotFoundException$message' => NULL, 'ServiceQuotaExceededException$message' => '<p>Description of the error.</p>', 'ServiceQuotaExceededException$quotaCode' => '<p>Service Quotas requirement to identify originating quota.</p>', 'ServiceQuotaExceededException$resourceId' => '<p>Identifier of the resource affected.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>Type of the resource affected.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>Service Quotas requirement to identify originating service.</p>', 'UpdateCollectionDetail$arn' => '<p>The Amazon Resource Name (ARN) of the collection.</p>', 'UpdateCollectionDetail$description' => '<p>The description of the collection.</p>', 'ValidationException$message' => NULL, 'VpcEndpointDetail$failureCode' => '<p>A failure code associated with the request.</p>', 'VpcEndpointDetail$failureMessage' => '<p>A message associated with the failure code.</p>', 'VpcEndpointErrorDetail$errorCode' => '<p>The error code for the failed request.</p>', 'VpcEndpointErrorDetail$errorMessage' => '<p>An error message describing the reason for the failure.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIds$member' => NULL, ], ], 'SubnetIds' => [ 'base' => NULL, 'refs' => [ 'CreateVpcEndpointRequest$subnetIds' => '<p>The ID of one or more subnets from which you\'ll access OpenSearch Serverless.</p>', 'UpdateVpcEndpointDetail$subnetIds' => '<p>The ID of the subnets from which you access OpenSearch Serverless.</p>', 'UpdateVpcEndpointRequest$addSubnetIds' => '<p>The ID of one or more subnets to add to the endpoint.</p>', 'UpdateVpcEndpointRequest$removeSubnetIds' => '<p>The unique identifiers of the subnets to remove from the endpoint.</p>', 'VpcEndpointDetail$subnetIds' => '<p>The ID of the subnets from which you access OpenSearch Serverless.</p>', ], ], 'Tag' => [ 'base' => '<p>A map of key-value pairs associated to an OpenSearch Serverless resource.</p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The key to use in the tag.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag or set of tags to remove from the resource. All tag keys in the request must be unique.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The value of the tag.</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateCollectionRequest$tags' => '<p>An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Serverless collection.</p>', 'ListTagsForResourceResponse$tags' => '<p>The tags associated with the resource.</p>', 'TagResourceRequest$tags' => '<p>A list of tags (key-value pairs) to add to the resource. All tag keys in the request must be unique.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccessPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateAccountSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCollectionDetail' => [ 'base' => '<p>Details about an updated OpenSearch Serverless collection.</p>', 'refs' => [ 'UpdateCollectionResponse$updateCollectionDetail' => '<p>Details about the updated collection.</p>', ], ], 'UpdateCollectionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCollectionRequestDescriptionString' => [ 'base' => NULL, 'refs' => [ 'UpdateCollectionRequest$description' => '<p>A description of the collection.</p>', ], ], 'UpdateCollectionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLifecyclePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateLifecyclePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityConfigRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityConfigResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityPolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSecurityPolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVpcEndpointDetail' => [ 'base' => '<p>Update details for an OpenSearch Serverless-managed interface endpoint.</p>', 'refs' => [ 'UpdateVpcEndpointResponse$UpdateVpcEndpointDetail' => '<p>Details about the updated VPC endpoint.</p>', ], ], 'UpdateVpcEndpointRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVpcEndpointResponse' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>Thrown when the HTTP request contains invalid input or is missing required input.</p>', 'refs' => [], ], 'VpcEndpointDetail' => [ 'base' => '<p>Details about an OpenSearch Serverless-managed interface endpoint.</p>', 'refs' => [ 'VpcEndpointDetails$member' => NULL, ], ], 'VpcEndpointDetails' => [ 'base' => NULL, 'refs' => [ 'BatchGetVpcEndpointResponse$vpcEndpointDetails' => '<p>Details about the specified VPC endpoint.</p>', ], ], 'VpcEndpointErrorDetail' => [ 'base' => '<p>Error information for a failed <code>BatchGetVpcEndpoint</code> request.</p>', 'refs' => [ 'VpcEndpointErrorDetails$member' => NULL, ], ], 'VpcEndpointErrorDetails' => [ 'base' => NULL, 'refs' => [ 'BatchGetVpcEndpointResponse$vpcEndpointErrorDetails' => '<p>Error information for a failed request.</p>', ], ], 'VpcEndpointFilters' => [ 'base' => '<p>Filter the results of a <code>ListVpcEndpoints</code> request.</p>', 'refs' => [ 'ListVpcEndpointsRequest$vpcEndpointFilters' => '<p>Filter the results according to the current status of the VPC endpoint. Possible statuses are <code>CREATING</code>, <code>DELETING</code>, <code>UPDATING</code>, <code>ACTIVE</code>, and <code>FAILED</code>.</p>', ], ], 'VpcEndpointId' => [ 'base' => NULL, 'refs' => [ 'CreateVpcEndpointDetail$id' => '<p>The unique identifier of the endpoint.</p>', 'DeleteVpcEndpointDetail$id' => '<p>The unique identifier of the endpoint.</p>', 'DeleteVpcEndpointRequest$id' => '<p>The VPC endpoint identifier.</p>', 'UpdateVpcEndpointDetail$id' => '<p>The unique identifier of the endpoint.</p>', 'UpdateVpcEndpointRequest$id' => '<p>The unique identifier of the interface endpoint to update.</p>', 'VpcEndpointDetail$id' => '<p>The unique identifier of the endpoint.</p>', 'VpcEndpointErrorDetail$id' => '<p>The unique identifier of the VPC endpoint.</p>', 'VpcEndpointIds$member' => NULL, 'VpcEndpointSummary$id' => '<p>The unique identifier of the endpoint.</p>', ], ], 'VpcEndpointIds' => [ 'base' => NULL, 'refs' => [ 'BatchGetVpcEndpointRequest$ids' => '<p>A list of VPC endpoint identifiers.</p>', ], ], 'VpcEndpointName' => [ 'base' => NULL, 'refs' => [ 'CreateVpcEndpointDetail$name' => '<p>The name of the endpoint.</p>', 'CreateVpcEndpointRequest$name' => '<p>The name of the interface endpoint.</p>', 'DeleteVpcEndpointDetail$name' => '<p>The name of the endpoint.</p>', 'UpdateVpcEndpointDetail$name' => '<p>The name of the endpoint.</p>', 'VpcEndpointDetail$name' => '<p>The name of the endpoint.</p>', 'VpcEndpointSummary$name' => '<p>The name of the endpoint.</p>', ], ], 'VpcEndpointStatus' => [ 'base' => NULL, 'refs' => [ 'CreateVpcEndpointDetail$status' => '<p>The current status in the endpoint creation process.</p>', 'DeleteVpcEndpointDetail$status' => '<p>The current status of the endpoint deletion process.</p>', 'UpdateVpcEndpointDetail$status' => '<p>The current status of the endpoint update process.</p>', 'VpcEndpointDetail$status' => '<p>The current status of the endpoint.</p>', 'VpcEndpointFilters$status' => '<p>The current status of the endpoint.</p>', 'VpcEndpointSummary$status' => '<p>The current status of the endpoint.</p>', ], ], 'VpcEndpointSummaries' => [ 'base' => NULL, 'refs' => [ 'ListVpcEndpointsResponse$vpcEndpointSummaries' => '<p>Details about each VPC endpoint, including the name and current status.</p>', ], ], 'VpcEndpointSummary' => [ 'base' => '<p>The VPC endpoint object.</p>', 'refs' => [ 'VpcEndpointSummaries$member' => NULL, ], ], 'VpcId' => [ 'base' => NULL, 'refs' => [ 'CreateVpcEndpointRequest$vpcId' => '<p>The ID of the VPC from which you\'ll access OpenSearch Serverless.</p>', 'VpcEndpointDetail$vpcId' => '<p>The ID of the VPC from which you access OpenSearch Serverless.</p>', ], ], 'samlGroupAttribute' => [ 'base' => NULL, 'refs' => [ 'SamlConfigOptions$groupAttribute' => '<p>The group attribute for this SAML integration.</p>', ], ], 'samlMetadata' => [ 'base' => NULL, 'refs' => [ 'SamlConfigOptions$metadata' => '<p>The XML IdP metadata file generated from your identity provider.</p>', ], ], 'samlUserAttribute' => [ 'base' => NULL, 'refs' => [ 'SamlConfigOptions$userAttribute' => '<p>A user attribute for this SAML integration.</p>', ], ], ],];
