<?php
// This file was auto-generated from sdk-root/src/data/pca-connector-ad/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Web Services Private CA Connector for Active Directory creates a connector between Amazon Web Services Private CA and Active Directory (AD) that enables you to provision security certificates for AD signed by a private CA that you own. For more information, see <a href="https://docs.aws.amazon.com/privateca/latest/userguide/ad-connector.html">Amazon Web Services Private CA Connector for Active Directory</a>.</p>', 'operations' => [ 'CreateConnector' => '<p>Creates a connector between Amazon Web Services Private CA and an Active Directory. You must specify the private CA, directory ID, and security groups.</p>', 'CreateDirectoryRegistration' => '<p>Creates a directory registration that authorizes communication between Amazon Web Services Private CA and an Active Directory</p>', 'CreateServicePrincipalName' => '<p>Creates a service principal name (SPN) for the service account in Active Directory. Kerberos authentication uses SPNs to associate a service instance with a service sign-in account.</p>', 'CreateTemplate' => '<p>Creates an Active Directory compatible certificate template. The connectors issues certificates using these templates based on the requester’s Active Directory group membership.</p>', 'CreateTemplateGroupAccessControlEntry' => '<p>Create a group access control entry. Allow or deny Active Directory groups from enrolling and/or autoenrolling with the template based on the group security identifiers (SIDs).</p>', 'DeleteConnector' => '<p>Deletes a connector for Active Directory. You must provide the Amazon Resource Name (ARN) of the connector that you want to delete. You can find the ARN by calling the <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListConnectors">https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_ListConnectors</a> action. Deleting a connector does not deregister your directory with Amazon Web Services Private CA. You can deregister your directory by calling the <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteDirectoryRegistration">https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_DeleteDirectoryRegistration</a> action.</p>', 'DeleteDirectoryRegistration' => '<p>Deletes a directory registration. Deleting a directory registration deauthorizes Amazon Web Services Private CA with the directory. </p>', 'DeleteServicePrincipalName' => '<p>Deletes the service principal name (SPN) used by a connector to authenticate with your Active Directory.</p>', 'DeleteTemplate' => '<p>Deletes a template. Certificates issued using the template are still valid until they are revoked or expired.</p>', 'DeleteTemplateGroupAccessControlEntry' => '<p>Deletes a group access control entry.</p>', 'GetConnector' => '<p>Lists information about your connector. You specify the connector on input by its ARN (Amazon Resource Name). </p>', 'GetDirectoryRegistration' => '<p>A structure that contains information about your directory registration.</p>', 'GetServicePrincipalName' => '<p>Lists the service principal name that the connector uses to authenticate with Active Directory.</p>', 'GetTemplate' => '<p>Retrieves a certificate template that the connector uses to issue certificates from a private CA.</p>', 'GetTemplateGroupAccessControlEntry' => '<p>Retrieves the group access control entries for a template.</p>', 'ListConnectors' => '<p>Lists the connectors that you created by using the <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector">https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector</a> action.</p>', 'ListDirectoryRegistrations' => '<p>Lists the directory registrations that you created by using the <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration">https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration</a> action.</p>', 'ListServicePrincipalNames' => '<p>Lists the service principal names that the connector uses to authenticate with Active Directory.</p>', 'ListTagsForResource' => '<p>Lists the tags, if any, that are associated with your resource. </p>', 'ListTemplateGroupAccessControlEntries' => '<p>Lists group access control entries you created. </p>', 'ListTemplates' => '<p>Lists the templates, if any, that are associated with a connector.</p>', 'TagResource' => '<p>Adds one or more tags to your resource.</p>', 'UntagResource' => '<p>Removes one or more tags from your resource.</p>', 'UpdateTemplate' => '<p>Update template configuration to define the information included in certificates.</p>', 'UpdateTemplateGroupAccessControlEntry' => '<p>Update a group access control entry you created using <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplateGroupAccessControlEntry.html">CreateTemplateGroupAccessControlEntry</a>. </p>', ], 'shapes' => [ 'AccessControlEntry' => [ 'base' => '<p> An access control entry allows or denies Active Directory groups based on their security identifiers (SIDs) from enrolling and/or autoenrolling with the template.</p>', 'refs' => [ 'GetTemplateGroupAccessControlEntryResponse$AccessControlEntry' => '<p>An access control entry allows or denies an Active Directory group from enrolling and/or autoenrolling with a template.</p>', ], ], 'AccessControlEntryList' => [ 'base' => NULL, 'refs' => [ 'ListTemplateGroupAccessControlEntriesResponse$AccessControlEntries' => '<p>An access control entry grants or denies permission to an Active Directory group to enroll certificates for a template.</p>', ], ], 'AccessControlEntrySummary' => [ 'base' => '<p>Summary of group access control entries that allow or deny Active Directory groups based on their security identifiers (SIDs) from enrolling and/or autofenrolling with the template.</p>', 'refs' => [ 'AccessControlEntryList$member' => NULL, ], ], 'AccessDeniedException' => [ 'base' => '<p>You can receive this error if you attempt to create a resource share when you don\'t have the required permissions. This can be caused by insufficient permissions in policies attached to your Amazon Web Services Identity and Access Management (IAM) principal. It can also happen because of restrictions in place from an Amazon Web Services Organizations service control policy (SCP) that affects your Amazon Web Services account. </p>', 'refs' => [], ], 'AccessRight' => [ 'base' => NULL, 'refs' => [ 'AccessRights$AutoEnroll' => '<p>Allow or deny an Active Directory group from autoenrolling certificates issued against a template. The Active Directory group must be allowed to enroll to allow autoenrollment</p>', 'AccessRights$Enroll' => '<p>Allow or deny an Active Directory group from enrolling certificates issued against a template.</p>', ], ], 'AccessRights' => [ 'base' => '<p> Allow or deny permissions for an Active Directory group to enroll or autoenroll certificates for a template.</p>', 'refs' => [ 'AccessControlEntry$AccessRights' => '<p>Permissions to allow or deny an Active Directory group to enroll or autoenroll certificates issued against a template.</p>', 'AccessControlEntrySummary$AccessRights' => '<p>Allow or deny an Active Directory group from enrolling and autoenrolling certificates issued against a template.</p>', 'CreateTemplateGroupAccessControlEntryRequest$AccessRights' => '<p> Allow or deny permissions for an Active Directory group to enroll or autoenroll certificates for a template.</p>', 'UpdateTemplateGroupAccessControlEntryRequest$AccessRights' => '<p>Allow or deny permissions for an Active Directory group to enroll or autoenroll certificates for a template.</p>', ], ], 'ApplicationPolicies' => [ 'base' => '<p>Application policies describe what the certificate can be used for.</p>', 'refs' => [ 'ExtensionsV2$ApplicationPolicies' => '<p>Application policies specify what the certificate is used for and its purpose. </p>', 'ExtensionsV3$ApplicationPolicies' => '<p>Application policies specify what the certificate is used for and its purpose.</p>', 'ExtensionsV4$ApplicationPolicies' => '<p>Application policies specify what the certificate is used for and its purpose.</p>', ], ], 'ApplicationPolicy' => [ 'base' => '<p>Application policies describe what the certificate can be used for.</p>', 'refs' => [ 'ApplicationPolicyList$member' => NULL, ], ], 'ApplicationPolicyList' => [ 'base' => NULL, 'refs' => [ 'ApplicationPolicies$Policies' => '<p>Application policies describe what the certificate can be used for.</p>', ], ], 'ApplicationPolicyType' => [ 'base' => NULL, 'refs' => [ 'ApplicationPolicy$PolicyType' => '<p>The type of application policy</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'ApplicationPolicies$Critical' => '<p>Marks the application policy extension as critical.</p>', 'EnrollmentFlagsV2$EnableKeyReuseOnNtTokenKeysetStorageFull' => '<p>Allow renewal using the same key.</p>', 'EnrollmentFlagsV2$IncludeSymmetricAlgorithms' => '<p>Include symmetric algorithms allowed by the subject.</p>', 'EnrollmentFlagsV2$NoSecurityExtension' => '<p>This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.</p>', 'EnrollmentFlagsV2$RemoveInvalidCertificateFromPersonalStore' => '<p>Delete expired or revoked certificates instead of archiving them.</p>', 'EnrollmentFlagsV2$UserInteractionRequired' => '<p>Require user interaction when the subject is enrolled and the private key associated with the certificate is used.</p>', 'EnrollmentFlagsV3$EnableKeyReuseOnNtTokenKeysetStorageFull' => '<p>Allow renewal using the same key.</p>', 'EnrollmentFlagsV3$IncludeSymmetricAlgorithms' => '<p>Include symmetric algorithms allowed by the subject.</p>', 'EnrollmentFlagsV3$NoSecurityExtension' => '<p>This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.</p>', 'EnrollmentFlagsV3$RemoveInvalidCertificateFromPersonalStore' => '<p>Delete expired or revoked certificates instead of archiving them.</p>', 'EnrollmentFlagsV3$UserInteractionRequired' => '<p>Require user interaction when the subject is enrolled and the private key associated with the certificate is used.</p>', 'EnrollmentFlagsV4$EnableKeyReuseOnNtTokenKeysetStorageFull' => '<p>Allow renewal using the same key.</p>', 'EnrollmentFlagsV4$IncludeSymmetricAlgorithms' => '<p>Include symmetric algorithms allowed by the subject.</p>', 'EnrollmentFlagsV4$NoSecurityExtension' => '<p>This flag instructs the CA to not include the security extension szOID_NTDS_CA_SECURITY_EXT (OID:1.3.6.1.4.1.311.25.2), as specified in [MS-WCCE] sections 2.2.2.7.7.4 and 3.2.2.6.2.1.4.5.9, in the issued certificate. This addresses a Windows Kerberos elevation-of-privilege vulnerability.</p>', 'EnrollmentFlagsV4$RemoveInvalidCertificateFromPersonalStore' => '<p>Delete expired or revoked certificates instead of archiving them.</p>', 'EnrollmentFlagsV4$UserInteractionRequired' => '<p>Require user interaction when the subject is enrolled and the private key associated with the certificate is used.</p>', 'GeneralFlagsV2$AutoEnrollment' => '<p>Allows certificate issuance using autoenrollment. Set to TRUE to allow autoenrollment.</p>', 'GeneralFlagsV2$MachineType' => '<p>Defines if the template is for machines or users. Set to TRUE if the template is for machines. Set to FALSE if the template is for users.</p>', 'GeneralFlagsV3$AutoEnrollment' => '<p>Allows certificate issuance using autoenrollment. Set to TRUE to allow autoenrollment.</p>', 'GeneralFlagsV3$MachineType' => '<p>Defines if the template is for machines or users. Set to TRUE if the template is for machines. Set to FALSE if the template is for users</p>', 'GeneralFlagsV4$AutoEnrollment' => '<p>Allows certificate issuance using autoenrollment. Set to TRUE to allow autoenrollment.</p>', 'GeneralFlagsV4$MachineType' => '<p>Defines if the template is for machines or users. Set to TRUE if the template is for machines. Set to FALSE if the template is for users</p>', 'KeyUsage$Critical' => '<p>Sets the key usage extension to critical.</p>', 'KeyUsageFlags$DataEncipherment' => '<p>DataEncipherment is asserted when the subject public key is used for directly enciphering raw user data without the use of an intermediate symmetric cipher.</p>', 'KeyUsageFlags$DigitalSignature' => '<p>The digitalSignature is asserted when the subject public key is used for verifying digital signatures.</p>', 'KeyUsageFlags$KeyAgreement' => '<p>KeyAgreement is asserted when the subject public key is used for key agreement.</p>', 'KeyUsageFlags$KeyEncipherment' => '<p>KeyEncipherment is asserted when the subject public key is used for enciphering private or secret keys, i.e., for key transport.</p>', 'KeyUsageFlags$NonRepudiation' => '<p>NonRepudiation is asserted when the subject public key is used to verify digital signatures.</p>', 'KeyUsagePropertyFlags$Decrypt' => '<p>Allows key for encryption and decryption.</p>', 'KeyUsagePropertyFlags$KeyAgreement' => '<p>Allows key exchange without encryption.</p>', 'KeyUsagePropertyFlags$Sign' => '<p>Allow key use for digital signature.</p>', 'PrivateKeyFlagsV2$ExportableKey' => '<p>Allows the private key to be exported.</p>', 'PrivateKeyFlagsV2$StrongKeyProtectionRequired' => '<p>Require user input when using the private key for enrollment.</p>', 'PrivateKeyFlagsV3$ExportableKey' => '<p>Allows the private key to be exported.</p>', 'PrivateKeyFlagsV3$RequireAlternateSignatureAlgorithm' => '<p>Reguires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and applications can accept this signature format.</p>', 'PrivateKeyFlagsV3$StrongKeyProtectionRequired' => '<p>Requirer user input when using the private key for enrollment.</p>', 'PrivateKeyFlagsV4$ExportableKey' => '<p>Allows the private key to be exported.</p>', 'PrivateKeyFlagsV4$RequireAlternateSignatureAlgorithm' => '<p>Requires the PKCS #1 v2.1 signature format for certificates. You should verify that your CA, objects, and applications can accept this signature format.</p>', 'PrivateKeyFlagsV4$RequireSameKeyRenewal' => '<p>Renew certificate using the same private key.</p>', 'PrivateKeyFlagsV4$StrongKeyProtectionRequired' => '<p>Require user input when using the private key for enrollment.</p>', 'PrivateKeyFlagsV4$UseLegacyProvider' => '<p>Specifies the cryptographic service provider category used to generate private keys. Set to TRUE to use Legacy Cryptographic Service Providers and FALSE to use Key Storage Providers.</p>', 'SubjectNameFlagsV2$RequireCommonName' => '<p>Include the common name in the subject name.</p>', 'SubjectNameFlagsV2$RequireDirectoryPath' => '<p>Include the directory path in the subject name.</p>', 'SubjectNameFlagsV2$RequireDnsAsCn' => '<p>Include the DNS as common name in the subject name.</p>', 'SubjectNameFlagsV2$RequireEmail' => '<p>Include the subject\'s email in the subject name.</p>', 'SubjectNameFlagsV2$SanRequireDirectoryGuid' => '<p>Include the globally unique identifier (GUID) in the subject alternate name.</p>', 'SubjectNameFlagsV2$SanRequireDns' => '<p>Include the DNS in the subject alternate name.</p>', 'SubjectNameFlagsV2$SanRequireDomainDns' => '<p>Include the domain DNS in the subject alternate name.</p>', 'SubjectNameFlagsV2$SanRequireEmail' => '<p>Include the subject\'s email in the subject alternate name.</p>', 'SubjectNameFlagsV2$SanRequireSpn' => '<p>Include the service principal name (SPN) in the subject alternate name.</p>', 'SubjectNameFlagsV2$SanRequireUpn' => '<p>Include the user principal name (UPN) in the subject alternate name.</p>', 'SubjectNameFlagsV3$RequireCommonName' => '<p>Include the common name in the subject name. </p>', 'SubjectNameFlagsV3$RequireDirectoryPath' => '<p>Include the directory path in the subject name.</p>', 'SubjectNameFlagsV3$RequireDnsAsCn' => '<p>Include the DNS as common name in the subject name.</p>', 'SubjectNameFlagsV3$RequireEmail' => '<p>Include the subject\'s email in the subject name.</p>', 'SubjectNameFlagsV3$SanRequireDirectoryGuid' => '<p>Include the globally unique identifier (GUID) in the subject alternate name.</p>', 'SubjectNameFlagsV3$SanRequireDns' => '<p>Include the DNS in the subject alternate name.</p>', 'SubjectNameFlagsV3$SanRequireDomainDns' => '<p>Include the domain DNS in the subject alternate name.</p>', 'SubjectNameFlagsV3$SanRequireEmail' => '<p>Include the subject\'s email in the subject alternate name.</p>', 'SubjectNameFlagsV3$SanRequireSpn' => '<p>Include the service principal name (SPN) in the subject alternate name.</p>', 'SubjectNameFlagsV3$SanRequireUpn' => '<p>Include the user principal name (UPN) in the subject alternate name.</p>', 'SubjectNameFlagsV4$RequireCommonName' => '<p>Include the common name in the subject name.</p>', 'SubjectNameFlagsV4$RequireDirectoryPath' => '<p>Include the directory path in the subject name.</p>', 'SubjectNameFlagsV4$RequireDnsAsCn' => '<p>Include the DNS as common name in the subject name.</p>', 'SubjectNameFlagsV4$RequireEmail' => '<p>Include the subject\'s email in the subject name.</p>', 'SubjectNameFlagsV4$SanRequireDirectoryGuid' => '<p>Include the globally unique identifier (GUID) in the subject alternate name.</p>', 'SubjectNameFlagsV4$SanRequireDns' => '<p>Include the DNS in the subject alternate name.</p>', 'SubjectNameFlagsV4$SanRequireDomainDns' => '<p>Include the domain DNS in the subject alternate name.</p>', 'SubjectNameFlagsV4$SanRequireEmail' => '<p>Include the subject\'s email in the subject alternate name.</p>', 'SubjectNameFlagsV4$SanRequireSpn' => '<p>Include the service principal name (SPN) in the subject alternate name.</p>', 'SubjectNameFlagsV4$SanRequireUpn' => '<p>Include the user principal name (UPN) in the subject alternate name.</p>', 'UpdateTemplateRequest$ReenrollAllCertificateHolders' => '<p>This setting allows the major version of a template to be increased automatically. All members of Active Directory groups that are allowed to enroll with a template will receive a new certificate issued using that template.</p>', ], ], 'CertificateAuthorityArn' => [ 'base' => NULL, 'refs' => [ 'Connector$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the certificate authority being used. </p>', 'ConnectorSummary$CertificateAuthorityArn' => '<p>The Amazon Resource Name (ARN) of the certificate authority being used.</p>', 'CreateConnectorRequest$CertificateAuthorityArn' => '<p> The Amazon Resource Name (ARN) of the certificate authority being used.</p>', ], ], 'CertificateValidity' => [ 'base' => '<p>Information describing the end of the validity period of the certificate. This parameter sets the “Not After” date for the certificate. Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see Validity in RFC 5280. This value is unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the ValidityNotBefore value.</p>', 'refs' => [ 'TemplateV2$CertificateValidity' => '<p>Certificate validity describes the validity and renewal periods of a certificate.</p>', 'TemplateV3$CertificateValidity' => '<p>Certificate validity describes the validity and renewal periods of a certificate.</p>', 'TemplateV4$CertificateValidity' => '<p>Certificate validity describes the validity and renewal periods of a certificate.</p>', ], ], 'ClientCompatibilityV2' => [ 'base' => NULL, 'refs' => [ 'PrivateKeyFlagsV2$ClientVersion' => '<p>Defines the minimum client compatibility.</p>', ], ], 'ClientCompatibilityV3' => [ 'base' => NULL, 'refs' => [ 'PrivateKeyFlagsV3$ClientVersion' => '<p>Defines the minimum client compatibility.</p>', ], ], 'ClientCompatibilityV4' => [ 'base' => NULL, 'refs' => [ 'PrivateKeyFlagsV4$ClientVersion' => '<p>Defines the minimum client compatibility.</p>', ], ], 'ClientToken' => [ 'base' => NULL, 'refs' => [ 'CreateConnectorRequest$ClientToken' => '<p>Idempotency token.</p>', 'CreateDirectoryRegistrationRequest$ClientToken' => '<p>Idempotency token.</p>', 'CreateServicePrincipalNameRequest$ClientToken' => '<p>Idempotency token.</p>', 'CreateTemplateGroupAccessControlEntryRequest$ClientToken' => '<p>Idempotency token.</p>', 'CreateTemplateRequest$ClientToken' => '<p>Idempotency token.</p>', ], ], 'ConflictException' => [ 'base' => '<p>This request cannot be completed for one of the following reasons because the requested resource was being concurrently modified by another request.</p>', 'refs' => [], ], 'Connector' => [ 'base' => '<p>Amazon Web Services Private CA Connector for Active Directory is a service that links your Active Directory with Amazon Web Services Private CA. The connector brokers the exchange of certificates from Amazon Web Services Private CA to domain-joined users and machines managed with Active Directory.</p>', 'refs' => [ 'GetConnectorResponse$Connector' => '<p>A structure that contains information about your connector.</p>', ], ], 'ConnectorArn' => [ 'base' => NULL, 'refs' => [ 'Connector$Arn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>. </p>', 'ConnectorSummary$Arn' => '<p> The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>.</p>', 'CreateConnectorResponse$ConnectorArn' => '<p>If successful, the Amazon Resource Name (ARN) of the connector for Active Directory.</p>', 'CreateServicePrincipalNameRequest$ConnectorArn' => '<p> The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>.</p>', 'CreateTemplateRequest$ConnectorArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>.</p>', 'DeleteConnectorRequest$ConnectorArn' => '<p> The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>.</p>', 'DeleteServicePrincipalNameRequest$ConnectorArn' => '<p> The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>.</p>', 'GetConnectorRequest$ConnectorArn' => '<p> The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>.</p>', 'GetServicePrincipalNameRequest$ConnectorArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>.</p>', 'ListTemplatesRequest$ConnectorArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>.</p>', 'ServicePrincipalName$ConnectorArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector.html</a>.</p>', 'ServicePrincipalNameSummary$ConnectorArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>.</p>', 'Template$ConnectorArn' => '<p> The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>.</p>', 'TemplateSummary$ConnectorArn' => '<p> The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateConnector.html">CreateConnector</a>.</p>', ], ], 'ConnectorList' => [ 'base' => NULL, 'refs' => [ 'ListConnectorsResponse$Connectors' => '<p>Summary information about each connector you have created.</p>', ], ], 'ConnectorStatus' => [ 'base' => NULL, 'refs' => [ 'Connector$Status' => '<p>Status of the connector. Status can be creating, active, deleting, or failed.</p>', 'ConnectorSummary$Status' => '<p>Status of the connector. Status can be creating, active, deleting, or failed.</p>', ], ], 'ConnectorStatusReason' => [ 'base' => NULL, 'refs' => [ 'Connector$StatusReason' => '<p>Additional information about the connector status if the status is failed.</p>', 'ConnectorSummary$StatusReason' => '<p>Additional information about the connector status if the status is failed.</p>', ], ], 'ConnectorSummary' => [ 'base' => '<p>Summary description of the Amazon Web Services Private CA AD connectors belonging to an Amazon Web Services account.</p>', 'refs' => [ 'ConnectorList$member' => NULL, ], ], 'CreateConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDirectoryRegistrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDirectoryRegistrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateServicePrincipalNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateGroupAccessControlEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'CryptoProvidersList' => [ 'base' => NULL, 'refs' => [ 'PrivateKeyAttributesV2$CryptoProviders' => '<p>Defines the cryptographic providers used to generate the private key.</p>', 'PrivateKeyAttributesV3$CryptoProviders' => '<p>Defines the cryptographic providers used to generate the private key.</p>', 'PrivateKeyAttributesV4$CryptoProviders' => '<p>Defines the cryptographic providers used to generate the private key.</p>', ], ], 'CryptoProvidersListMemberString' => [ 'base' => NULL, 'refs' => [ 'CryptoProvidersList$member' => NULL, ], ], 'CustomObjectIdentifier' => [ 'base' => NULL, 'refs' => [ 'ApplicationPolicy$PolicyObjectIdentifier' => '<p>The object identifier (OID) of an application policy.</p>', 'Template$ObjectIdentifier' => '<p>Object identifier of a template.</p>', 'TemplateSummary$ObjectIdentifier' => '<p>Object identifier of a template.</p>', ], ], 'DeleteConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDirectoryRegistrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServicePrincipalNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateGroupAccessControlEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DirectoryId' => [ 'base' => NULL, 'refs' => [ 'Connector$DirectoryId' => '<p>The identifier of the Active Directory.</p>', 'ConnectorSummary$DirectoryId' => '<p>The identifier of the Active Directory.</p>', 'CreateConnectorRequest$DirectoryId' => '<p>The identifier of the Active Directory.</p>', 'CreateDirectoryRegistrationRequest$DirectoryId' => '<p> The identifier of the Active Directory.</p>', 'DirectoryRegistration$DirectoryId' => '<p>The identifier of the Active Directory.</p>', 'DirectoryRegistrationSummary$DirectoryId' => '<p>The identifier of the Active Directory.</p>', ], ], 'DirectoryRegistration' => [ 'base' => '<p>The directory registration represents the authorization of the connector service with a directory.</p>', 'refs' => [ 'GetDirectoryRegistrationResponse$DirectoryRegistration' => '<p>The directory registration represents the authorization of the connector service with a directory.</p>', ], ], 'DirectoryRegistrationArn' => [ 'base' => NULL, 'refs' => [ 'CreateDirectoryRegistrationResponse$DirectoryRegistrationArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html">CreateDirectoryRegistration</a>.</p>', 'CreateServicePrincipalNameRequest$DirectoryRegistrationArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html">CreateDirectoryRegistration</a>.</p>', 'DeleteDirectoryRegistrationRequest$DirectoryRegistrationArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html">CreateDirectoryRegistration</a>.</p>', 'DeleteServicePrincipalNameRequest$DirectoryRegistrationArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html">CreateDirectoryRegistration</a>.</p>', 'DirectoryRegistration$Arn' => '<p>The Amazon Resource Name (ARN) that was returned when you called CreateDirectoryRegistration. </p>', 'DirectoryRegistrationSummary$Arn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html">CreateDirectoryRegistration</a>.</p>', 'GetDirectoryRegistrationRequest$DirectoryRegistrationArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html">CreateDirectoryRegistration</a>.</p>', 'GetServicePrincipalNameRequest$DirectoryRegistrationArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html">CreateDirectoryRegistration</a>.</p>', 'ListServicePrincipalNamesRequest$DirectoryRegistrationArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html">CreateDirectoryRegistration</a>.</p>', 'ServicePrincipalName$DirectoryRegistrationArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html">CreateDirectoryRegistration</a>.</p>', 'ServicePrincipalNameSummary$DirectoryRegistrationArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html">CreateDirectoryRegistration</a>.</p>', ], ], 'DirectoryRegistrationList' => [ 'base' => NULL, 'refs' => [ 'ListDirectoryRegistrationsResponse$DirectoryRegistrations' => '<p>Summary information about each directory registration you have created.</p>', ], ], 'DirectoryRegistrationStatus' => [ 'base' => NULL, 'refs' => [ 'DirectoryRegistration$Status' => '<p>Status of the directory registration.</p>', 'DirectoryRegistrationSummary$Status' => '<p>Status of the directory registration.</p>', ], ], 'DirectoryRegistrationStatusReason' => [ 'base' => NULL, 'refs' => [ 'DirectoryRegistration$StatusReason' => '<p>Additional information about the directory registration status if the status is failed.</p>', 'DirectoryRegistrationSummary$StatusReason' => '<p>Additional information about the directory registration status if the status is failed.</p>', ], ], 'DirectoryRegistrationSummary' => [ 'base' => '<p>The directory registration represents the authorization of the connector service with the Active Directory.</p>', 'refs' => [ 'DirectoryRegistrationList$member' => NULL, ], ], 'DisplayName' => [ 'base' => NULL, 'refs' => [ 'AccessControlEntry$GroupDisplayName' => '<p>Name of the Active Directory group. This name does not need to match the group name in Active Directory.</p>', 'AccessControlEntrySummary$GroupDisplayName' => '<p>Name of the Active Directory group. This name does not need to match the group name in Active Directory.</p>', 'CreateTemplateGroupAccessControlEntryRequest$GroupDisplayName' => '<p>Name of the Active Directory group. This name does not need to match the group name in Active Directory.</p>', 'UpdateTemplateGroupAccessControlEntryRequest$GroupDisplayName' => '<p>Name of the Active Directory group. This name does not need to match the group name in Active Directory.</p>', ], ], 'EnrollmentFlagsV2' => [ 'base' => '<p>Template configurations for v2 template schema.</p>', 'refs' => [ 'TemplateV2$EnrollmentFlags' => '<p>Enrollment flags describe the enrollment settings for certificates such as using the existing private key and deleting expired or revoked certificates.</p>', ], ], 'EnrollmentFlagsV3' => [ 'base' => '<p>Template configurations for v3 template schema.</p>', 'refs' => [ 'TemplateV3$EnrollmentFlags' => '<p>Enrollment flags describe the enrollment settings for certificates such as using the existing private key and deleting expired or revoked certificates.</p>', ], ], 'EnrollmentFlagsV4' => [ 'base' => '<p>Template configurations for v4 template schema.</p>', 'refs' => [ 'TemplateV4$EnrollmentFlags' => '<p>Enrollment flags describe the enrollment settings for certificates using the existing private key and deleting expired or revoked certificates.</p>', ], ], 'ExtensionsV2' => [ 'base' => '<p>Certificate extensions for v2 template schema</p>', 'refs' => [ 'TemplateV2$Extensions' => '<p>Extensions describe the key usage extensions and application policies for a template.</p>', ], ], 'ExtensionsV3' => [ 'base' => '<p>Certificate extensions for v3 template schema</p>', 'refs' => [ 'TemplateV3$Extensions' => '<p>Extensions describe the key usage extensions and application policies for a template.</p>', ], ], 'ExtensionsV4' => [ 'base' => '<p>Certificate extensions for v4 template schema</p>', 'refs' => [ 'TemplateV4$Extensions' => '<p>Extensions describe the key usage extensions and application policies for a template.</p>', ], ], 'GeneralFlagsV2' => [ 'base' => '<p>General flags for v2 template schema that defines if the template is for a machine or a user and if the template can be issued using autoenrollment.</p>', 'refs' => [ 'TemplateV2$GeneralFlags' => '<p>General flags describe whether the template is used for computers or users and if the template can be used with autoenrollment.</p>', ], ], 'GeneralFlagsV3' => [ 'base' => '<p>General flags for v3 template schema that defines if the template is for a machine or a user and if the template can be issued using autoenrollment.</p>', 'refs' => [ 'TemplateV3$GeneralFlags' => '<p>General flags describe whether the template is used for computers or users and if the template can be used with autoenrollment.</p>', ], ], 'GeneralFlagsV4' => [ 'base' => '<p>General flags for v4 template schema that defines if the template is for a machine or a user and if the template can be issued using autoenrollment.</p>', 'refs' => [ 'TemplateV4$GeneralFlags' => '<p>General flags describe whether the template is used for computers or users and if the template can be used with autoenrollment.</p>', ], ], 'GetConnectorRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetConnectorResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetDirectoryRegistrationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetDirectoryRegistrationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServicePrincipalNameRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServicePrincipalNameResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateGroupAccessControlEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateGroupAccessControlEntryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GroupSecurityIdentifier' => [ 'base' => NULL, 'refs' => [ 'AccessControlEntry$GroupSecurityIdentifier' => '<p>Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".</p>', 'AccessControlEntrySummary$GroupSecurityIdentifier' => '<p>Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".</p>', 'CreateTemplateGroupAccessControlEntryRequest$GroupSecurityIdentifier' => '<p>Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".</p>', 'DeleteTemplateGroupAccessControlEntryRequest$GroupSecurityIdentifier' => '<p>Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".</p>', 'GetTemplateGroupAccessControlEntryRequest$GroupSecurityIdentifier' => '<p>Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".</p>', 'UpdateTemplateGroupAccessControlEntryRequest$GroupSecurityIdentifier' => '<p>Security identifier (SID) of the group object from Active Directory. The SID starts with "S-".</p>', ], ], 'HashAlgorithm' => [ 'base' => NULL, 'refs' => [ 'TemplateV3$HashAlgorithm' => '<p>Specifies the hash algorithm used to hash the private key.</p>', 'TemplateV4$HashAlgorithm' => '<p>Specifies the hash algorithm used to hash the private key. Hash algorithm can only be specified when using Key Storage Providers.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'Template$PolicySchema' => '<p>The template schema version. Template schema versions can be v2, v3, or v4. The template configuration options change based on the template schema version.</p>', 'TemplateRevision$MajorRevision' => '<p>The revision version of the template. Re-enrolling all certificate holders will increment the major revision.</p>', 'TemplateRevision$MinorRevision' => '<p>The revision version of the template. Re-enrolling all certificate holders will increment the major revision.</p>', 'TemplateSummary$PolicySchema' => '<p>The template schema version. Template schema versions can be v2, v3, or v4. The template configuration options change based on the template schema version.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure with an internal server. </p>', 'refs' => [], ], 'KeySpec' => [ 'base' => NULL, 'refs' => [ 'PrivateKeyAttributesV2$KeySpec' => '<p>Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE" value.</p>', 'PrivateKeyAttributesV3$KeySpec' => '<p>Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE" value.</p>', 'PrivateKeyAttributesV4$KeySpec' => '<p>Defines the purpose of the private key. Set it to "KEY_EXCHANGE" or "SIGNATURE" value.</p>', ], ], 'KeyUsage' => [ 'base' => '<p>The key usage extension defines the purpose (e.g., encipherment, signature) of the key contained in the certificate.</p>', 'refs' => [ 'ExtensionsV2$KeyUsage' => '<p>The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of the key contained in the certificate.</p>', 'ExtensionsV3$KeyUsage' => '<p>The key usage extension defines the purpose (e.g., encipherment, signature, certificate signing) of the key contained in the certificate.</p>', 'ExtensionsV4$KeyUsage' => '<p>The key usage extension defines the purpose (e.g., encipherment, signature) of the key contained in the certificate.</p>', ], ], 'KeyUsageFlags' => [ 'base' => '<p>The key usage flags represent the purpose (e.g., encipherment, signature) of the key contained in the certificate.</p>', 'refs' => [ 'KeyUsage$UsageFlags' => '<p>The key usage flags represent the purpose (e.g., encipherment, signature) of the key contained in the certificate.</p>', ], ], 'KeyUsageProperty' => [ 'base' => '<p>The key usage property defines the purpose of the private key contained in the certificate. You can specify specific purposes using property flags or all by using property type ALL.</p>', 'refs' => [ 'PrivateKeyAttributesV3$KeyUsageProperty' => '<p>The key usage property defines the purpose of the private key contained in the certificate. You can specify specific purposes using property flags or all by using property type ALL.</p>', 'PrivateKeyAttributesV4$KeyUsageProperty' => '<p>The key usage property defines the purpose of the private key contained in the certificate. You can specify specific purposes using property flags or all by using property type ALL.</p>', ], ], 'KeyUsagePropertyFlags' => [ 'base' => '<p>Specifies key usage.</p>', 'refs' => [ 'KeyUsageProperty$PropertyFlags' => '<p>You can specify key usage for encryption, key agreement, and signature. You can use property flags or property type but not both. </p>', ], ], 'KeyUsagePropertyType' => [ 'base' => NULL, 'refs' => [ 'KeyUsageProperty$PropertyType' => '<p>You can specify all key usages using property type ALL. You can use property type or property flags but not both. </p>', ], ], 'ListConnectorsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListConnectorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDirectoryRegistrationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDirectoryRegistrationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServicePrincipalNamesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServicePrincipalNamesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateGroupAccessControlEntriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplateGroupAccessControlEntriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplatesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTemplatesResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListConnectorsRequest$MaxResults' => '<p>Use this parameter when paginating results to specify the maximum number of items to return in the response on each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.</p>', 'ListDirectoryRegistrationsRequest$MaxResults' => '<p>Use this parameter when paginating results to specify the maximum number of items to return in the response on each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.</p>', 'ListServicePrincipalNamesRequest$MaxResults' => '<p>Use this parameter when paginating results to specify the maximum number of items to return in the response on each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.</p>', 'ListTemplateGroupAccessControlEntriesRequest$MaxResults' => '<p>Use this parameter when paginating results to specify the maximum number of items to return in the response on each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.</p>', 'ListTemplatesRequest$MaxResults' => '<p>Use this parameter when paginating results to specify the maximum number of items to return in the response on each page. If additional items exist beyond the number you specify, the <code>NextToken</code> element is sent in the response. Use this <code>NextToken</code> value in a subsequent request to retrieve additional items.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListConnectorsRequest$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>', 'ListConnectorsResponse$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the NextToken parameter from the response you just received.</p>', 'ListDirectoryRegistrationsRequest$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>', 'ListDirectoryRegistrationsResponse$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>', 'ListServicePrincipalNamesRequest$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>', 'ListServicePrincipalNamesResponse$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>', 'ListTemplateGroupAccessControlEntriesRequest$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>', 'ListTemplateGroupAccessControlEntriesResponse$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>', 'ListTemplatesRequest$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>', 'ListTemplatesResponse$NextToken' => '<p>Use this parameter when paginating results in a subsequent request after you receive a response with truncated results. Set it to the value of the <code>NextToken</code> parameter from the response you just received.</p>', ], ], 'PrivateKeyAlgorithm' => [ 'base' => NULL, 'refs' => [ 'PrivateKeyAttributesV3$Algorithm' => '<p>Defines the algorithm used to generate the private key.</p>', 'PrivateKeyAttributesV4$Algorithm' => '<p>Defines the algorithm used to generate the private key.</p>', ], ], 'PrivateKeyAttributesV2' => [ 'base' => '<p>Defines the attributes of the private key.</p>', 'refs' => [ 'TemplateV2$PrivateKeyAttributes' => '<p>Private key attributes allow you to specify the minimal key length, key spec, and cryptographic providers for the private key of a certificate for v2 templates. V2 templates allow you to use Legacy Cryptographic Service Providers.</p>', ], ], 'PrivateKeyAttributesV2MinimalKeyLengthInteger' => [ 'base' => NULL, 'refs' => [ 'PrivateKeyAttributesV2$MinimalKeyLength' => '<p>Set the minimum key length of the private key.</p>', ], ], 'PrivateKeyAttributesV3' => [ 'base' => '<p>Defines the attributes of the private key.</p>', 'refs' => [ 'TemplateV3$PrivateKeyAttributes' => '<p>Private key attributes allow you to specify the algorithm, minimal key length, key spec, key usage, and cryptographic providers for the private key of a certificate for v3 templates. V3 templates allow you to use Key Storage Providers.</p>', ], ], 'PrivateKeyAttributesV3MinimalKeyLengthInteger' => [ 'base' => NULL, 'refs' => [ 'PrivateKeyAttributesV3$MinimalKeyLength' => '<p>Set the minimum key length of the private key.</p>', ], ], 'PrivateKeyAttributesV4' => [ 'base' => '<p>Defines the attributes of the private key.</p>', 'refs' => [ 'TemplateV4$PrivateKeyAttributes' => '<p>Private key attributes allow you to specify the minimal key length, key spec, key usage, and cryptographic providers for the private key of a certificate for v4 templates. V4 templates allow you to use either Key Storage Providers or Legacy Cryptographic Service Providers. You specify the cryptography provider category in private key flags.</p>', ], ], 'PrivateKeyAttributesV4MinimalKeyLengthInteger' => [ 'base' => NULL, 'refs' => [ 'PrivateKeyAttributesV4$MinimalKeyLength' => '<p>Set the minimum key length of the private key.</p>', ], ], 'PrivateKeyFlagsV2' => [ 'base' => '<p>Private key flags for v2 templates specify the client compatibility, if the private key can be exported, and if user input is required when using a private key.</p>', 'refs' => [ 'TemplateV2$PrivateKeyFlags' => '<p>Private key flags for v2 templates specify the client compatibility, if the private key can be exported, and if user input is required when using a private key. </p>', ], ], 'PrivateKeyFlagsV3' => [ 'base' => '<p>Private key flags for v3 templates specify the client compatibility, if the private key can be exported, if user input is required when using a private key, and if an alternate signature algorithm should be used.</p>', 'refs' => [ 'TemplateV3$PrivateKeyFlags' => '<p>Private key flags for v3 templates specify the client compatibility, if the private key can be exported, if user input is required when using a private key, and if an alternate signature algorithm should be used.</p>', ], ], 'PrivateKeyFlagsV4' => [ 'base' => '<p>Private key flags for v4 templates specify the client compatibility, if the private key can be exported, if user input is required when using a private key, if an alternate signature algorithm should be used, and if certificates are renewed using the same private key.</p>', 'refs' => [ 'TemplateV4$PrivateKeyFlags' => '<p>Private key flags for v4 templates specify the client compatibility, if the private key can be exported, if user input is required when using a private key, if an alternate signature algorithm should be used, and if certificates are renewed using the same private key.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The operation tried to access a nonexistent resource. The resource might not be specified correctly, or its status might not be ACTIVE.</p>', 'refs' => [], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIdList$member' => NULL, ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'VpcInformation$SecurityGroupIds' => '<p>The security groups used with the connector. You can use a maximum of 4 security groups with a connector.</p>', ], ], 'ServicePrincipalName' => [ 'base' => '<p>The service principal name that the connector uses to authenticate with Active Directory.</p>', 'refs' => [ 'GetServicePrincipalNameResponse$ServicePrincipalName' => '<p>The service principal name that the connector uses to authenticate with Active Directory.</p>', ], ], 'ServicePrincipalNameList' => [ 'base' => NULL, 'refs' => [ 'ListServicePrincipalNamesResponse$ServicePrincipalNames' => '<p>The service principal name, if any, that the connector uses to authenticate with Active Directory.</p>', ], ], 'ServicePrincipalNameStatus' => [ 'base' => NULL, 'refs' => [ 'ServicePrincipalName$Status' => '<p>The status of a service principal name.</p>', 'ServicePrincipalNameSummary$Status' => '<p>The status of a service principal name.</p>', ], ], 'ServicePrincipalNameStatusReason' => [ 'base' => NULL, 'refs' => [ 'ServicePrincipalName$StatusReason' => '<p>Additional information for the status of a service principal name if the status is failed.</p>', 'ServicePrincipalNameSummary$StatusReason' => '<p>Additional information for the status of a service principal name if the status is failed.</p>', ], ], 'ServicePrincipalNameSummary' => [ 'base' => '<p>The service principal name that the connector uses to authenticate with Active Directory.</p>', 'refs' => [ 'ServicePrincipalNameList$member' => NULL, ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>Request would cause a service quota to be exceeded.</p>', 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$Message' => NULL, 'ConflictException$Message' => NULL, 'ConflictException$ResourceId' => '<p>The identifier of the Amazon Web Services resource.</p>', 'ConflictException$ResourceType' => '<p>The resource type, which can be one of <code>Connector</code>, <code>Template</code>, <code>TemplateGroupAccessControlEntry</code>, <code>ServicePrincipalName</code>, or <code>DirectoryRegistration</code>.</p>', 'Connector$CertificateEnrollmentPolicyServerEndpoint' => '<p>Certificate enrollment endpoint for Active Directory domain-joined objects reach out to when requesting certificates.</p>', 'ConnectorSummary$CertificateEnrollmentPolicyServerEndpoint' => '<p>Certificate enrollment endpoint for Active Directory domain-joined objects to request certificates.</p>', 'InternalServerException$Message' => NULL, 'ListTagsForResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) that was returned when you created the resource. </p>', 'ResourceNotFoundException$Message' => NULL, 'ResourceNotFoundException$ResourceId' => '<p>The identifier of the Amazon Web Services resource.</p>', 'ResourceNotFoundException$ResourceType' => '<p>The resource type, which can be one of <code>Connector</code>, <code>Template</code>, <code>TemplateGroupAccessControlEntry</code>, <code>ServicePrincipalName</code>, or <code>DirectoryRegistration</code>.</p>', 'ServiceQuotaExceededException$Message' => NULL, 'ServiceQuotaExceededException$QuotaCode' => '<p>The code associated with the service quota.</p>', 'ServiceQuotaExceededException$ResourceId' => '<p>The identifier of the Amazon Web Services resource.</p>', 'ServiceQuotaExceededException$ResourceType' => '<p>The resource type, which can be one of <code>Connector</code>, <code>Template</code>, <code>TemplateGroupAccessControlEntry</code>, <code>ServicePrincipalName</code>, or <code>DirectoryRegistration</code>.</p>', 'ServiceQuotaExceededException$ServiceCode' => '<p>Identifies the originating service.</p>', 'TagKeyList$member' => NULL, 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) that was returned when you created the resource. </p>', 'Tags$key' => NULL, 'Tags$value' => NULL, 'ThrottlingException$Message' => NULL, 'ThrottlingException$QuotaCode' => '<p>The code associated with the quota.</p>', 'ThrottlingException$ServiceCode' => '<p>Identifies the originating service.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) that was returned when you created the resource.</p>', 'ValidationException$Message' => NULL, ], ], 'SubjectNameFlagsV2' => [ 'base' => '<p>Information to include in the subject name and alternate subject name of the certificate. The subject name can be common name, directory path, DNS as common name, or left blank. You can optionally include email to the subject name for user templates. If you leave the subject name blank then you must set a subject alternate name. The subject alternate name (SAN) can include globally unique identifier (GUID), DNS, domain DNS, email, service principal name (SPN), and user principal name (UPN). You can leave the SAN blank. If you leave the SAN blank, then you must set a subject name.</p>', 'refs' => [ 'TemplateV2$SubjectNameFlags' => '<p>Subject name flags describe the subject name and subject alternate name that is included in a certificate.</p>', ], ], 'SubjectNameFlagsV3' => [ 'base' => '<p>Information to include in the subject name and alternate subject name of the certificate. The subject name can be common name, directory path, DNS as common name, or left blank. You can optionally include email to the subject name for user templates. If you leave the subject name blank then you must set a subject alternate name. The subject alternate name (SAN) can include globally unique identifier (GUID), DNS, domain DNS, email, service principal name (SPN), and user principal name (UPN). You can leave the SAN blank. If you leave the SAN blank, then you must set a subject name.</p>', 'refs' => [ 'TemplateV3$SubjectNameFlags' => '<p>Subject name flags describe the subject name and subject alternate name that is included in a certificate.</p>', ], ], 'SubjectNameFlagsV4' => [ 'base' => '<p>Information to include in the subject name and alternate subject name of the certificate. The subject name can be common name, directory path, DNS as common name, or left blank. You can optionally include email to the subject name for user templates. If you leave the subject name blank then you must set a subject alternate name. The subject alternate name (SAN) can include globally unique identifier (GUID), DNS, domain DNS, email, service principal name (SPN), and user principal name (UPN). You can leave the SAN blank. If you leave the SAN blank, then you must set a subject name.</p>', 'refs' => [ 'TemplateV4$SubjectNameFlags' => '<p>Subject name flags describe the subject name and subject alternate name that is included in a certificate.</p>', ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>Specifies a list of tag keys that you want to remove from the specified resources.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateConnectorRequest$Tags' => '<p>Metadata assigned to a connector consisting of a key-value pair.</p>', 'CreateDirectoryRegistrationRequest$Tags' => '<p>Metadata assigned to a directory registration consisting of a key-value pair.</p>', 'CreateTemplateRequest$Tags' => '<p>Metadata assigned to a template consisting of a key-value pair.</p>', 'ListTagsForResourceResponse$Tags' => '<p>The tags, if any, that are associated with your resource.</p>', 'TagResourceRequest$Tags' => '<p>Metadata assigned to a directory registration consisting of a key-value pair.</p>', ], ], 'Template' => [ 'base' => '<p>An Active Directory compatible certificate template. Connectors issue certificates against these templates based on the requestor\'s Active Directory group membership. </p>', 'refs' => [ 'GetTemplateResponse$Template' => '<p>A certificate template that the connector uses to issue certificates from a private CA.</p>', ], ], 'TemplateArn' => [ 'base' => NULL, 'refs' => [ 'AccessControlEntry$TemplateArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a>.</p>', 'AccessControlEntrySummary$TemplateArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a>. </p>', 'CreateTemplateGroupAccessControlEntryRequest$TemplateArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a>.</p>', 'CreateTemplateResponse$TemplateArn' => '<p>If successful, the Amazon Resource Name (ARN) of the template.</p>', 'DeleteTemplateGroupAccessControlEntryRequest$TemplateArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a>.</p>', 'DeleteTemplateRequest$TemplateArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a>.</p>', 'GetTemplateGroupAccessControlEntryRequest$TemplateArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a>.</p>', 'GetTemplateRequest$TemplateArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a>.</p>', 'ListTemplateGroupAccessControlEntriesRequest$TemplateArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a>.</p>', 'Template$Arn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a>.</p>', 'TemplateSummary$Arn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a>.</p>', 'UpdateTemplateGroupAccessControlEntryRequest$TemplateArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a>.</p>', 'UpdateTemplateRequest$TemplateArn' => '<p>The Amazon Resource Name (ARN) that was returned when you called <a href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a>.</p>', ], ], 'TemplateDefinition' => [ 'base' => '<p>Template configuration to define the information included in certificates. Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.</p>', 'refs' => [ 'CreateTemplateRequest$Definition' => '<p>Template configuration to define the information included in certificates. Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.</p>', 'Template$Definition' => '<p>Template configuration to define the information included in certificates. Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.</p>', 'TemplateSummary$Definition' => '<p>Template configuration to define the information included in certificates. Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.</p>', 'UpdateTemplateRequest$Definition' => '<p>Template configuration to define the information included in certificates. Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.</p>', ], ], 'TemplateList' => [ 'base' => NULL, 'refs' => [ 'ListTemplatesResponse$Templates' => '<p>Custom configuration templates used when issuing a certificate. </p>', ], ], 'TemplateName' => [ 'base' => NULL, 'refs' => [ 'CreateTemplateRequest$Name' => '<p>Name of the template. The template name must be unique.</p>', 'Template$Name' => '<p>Name of the templates. Template names must be unique.</p>', 'TemplateNameList$member' => NULL, 'TemplateSummary$Name' => '<p>Name of the template. The template name must be unique.</p>', ], ], 'TemplateNameList' => [ 'base' => NULL, 'refs' => [ 'TemplateV2$SupersededTemplates' => '<p>List of templates in Active Directory that are superseded by this template.</p>', 'TemplateV3$SupersededTemplates' => '<p>List of templates in Active Directory that are superseded by this template.</p>', 'TemplateV4$SupersededTemplates' => '<p>List of templates in Active Directory that are superseded by this template.</p>', ], ], 'TemplateRevision' => [ 'base' => '<p>The revision version of the template. Template updates will increment the minor revision. Re-enrolling all certificate holders will increment the major revision.</p>', 'refs' => [ 'Template$Revision' => '<p>The version of the template. Template updates will increment the minor revision. Re-enrolling all certificate holders will increment the major revision.</p>', 'TemplateSummary$Revision' => '<p>The revision version of the template. Template updates will increment the minor revision. Re-enrolling all certificate holders will increment the major revision.</p>', ], ], 'TemplateStatus' => [ 'base' => NULL, 'refs' => [ 'Template$Status' => '<p>Status of the template. Status can be creating, active, deleting, or failed.</p>', 'TemplateSummary$Status' => '<p>Status of the template. Status can be creating, active, deleting, or failed.</p>', ], ], 'TemplateSummary' => [ 'base' => '<p>An Active Directory compatible certificate template. Connectors issue certificates against these templates based on the requestor\'s Active Directory group membership.</p>', 'refs' => [ 'TemplateList$member' => NULL, ], ], 'TemplateV2' => [ 'base' => '<p>v2 template schema that uses Legacy Cryptographic Providers.</p>', 'refs' => [ 'TemplateDefinition$TemplateV2' => '<p>Template configuration to define the information included in certificates. Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.</p>', ], ], 'TemplateV3' => [ 'base' => '<p>v3 template schema that uses Key Storage Providers.</p>', 'refs' => [ 'TemplateDefinition$TemplateV3' => '<p>Template configuration to define the information included in certificates. Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.</p>', ], ], 'TemplateV4' => [ 'base' => '<p>v4 template schema that can use either Legacy Cryptographic Providers or Key Storage Providers.</p>', 'refs' => [ 'TemplateDefinition$TemplateV4' => '<p>Template configuration to define the information included in certificates. Define certificate validity and renewal periods, certificate request handling and enrollment options, key usage extensions, application policies, and cryptography settings.</p>', ], ], 'ThrottlingException' => [ 'base' => '<p>The limit on the number of requests per second was exceeded. </p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'AccessControlEntry$CreatedAt' => '<p>The date and time that the Access Control Entry was created.</p>', 'AccessControlEntry$UpdatedAt' => '<p>The date and time that the Access Control Entry was updated.</p>', 'AccessControlEntrySummary$CreatedAt' => '<p>The date and time that the Access Control Entry was created.</p>', 'AccessControlEntrySummary$UpdatedAt' => '<p>The date and time that the Access Control Entry was updated.</p>', 'Connector$CreatedAt' => '<p>The date and time that the connector was created.</p>', 'Connector$UpdatedAt' => '<p>The date and time that the connector was updated.</p>', 'ConnectorSummary$CreatedAt' => '<p>The date and time that the connector was created.</p>', 'ConnectorSummary$UpdatedAt' => '<p>The date and time that the connector was updated.</p>', 'DirectoryRegistration$CreatedAt' => '<p>The date and time that the directory registration was created.</p>', 'DirectoryRegistration$UpdatedAt' => '<p>The date and time that the directory registration was updated.</p>', 'DirectoryRegistrationSummary$CreatedAt' => '<p>The date and time that the directory registration was created.</p>', 'DirectoryRegistrationSummary$UpdatedAt' => '<p>The date and time that the directory registration was updated.</p>', 'ServicePrincipalName$CreatedAt' => '<p>The date and time that the service principal name was created.</p>', 'ServicePrincipalName$UpdatedAt' => '<p>The date and time that the service principal name was updated.</p>', 'ServicePrincipalNameSummary$CreatedAt' => '<p>The date and time that the service principal name was created.</p>', 'ServicePrincipalNameSummary$UpdatedAt' => '<p>Time when the service principal name was updated.</p>', 'Template$CreatedAt' => '<p>The date and time that the template was created.</p>', 'Template$UpdatedAt' => '<p>The date and time that the template was updated.</p>', 'TemplateSummary$CreatedAt' => '<p>The date and time that the template was created.</p>', 'TemplateSummary$UpdatedAt' => '<p>The date and time that the template was updated.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateGroupAccessControlEntryRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'ValidationException' => [ 'base' => '<p>An input validation error occurred. For example, invalid characters in a template name, or if a pagination token is invalid. </p>', 'refs' => [], ], 'ValidationExceptionReason' => [ 'base' => NULL, 'refs' => [ 'ValidationException$Reason' => '<p>The reason for the validation error. This won\'t be return for every validation exception.</p>', ], ], 'ValidityPeriod' => [ 'base' => '<p>Information describing the end of the validity period of the certificate. This parameter sets the “Not After” date for the certificate. Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in hours, days, months, or years. For more information, see Validity in RFC 5280. This value is unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the ValidityNotBefore value. </p>', 'refs' => [ 'CertificateValidity$RenewalPeriod' => '<p>Renewal period is the period of time before certificate expiration when a new certificate will be requested.</p>', 'CertificateValidity$ValidityPeriod' => '<p>Information describing the end of the validity period of the certificate. This parameter sets the “Not After” date for the certificate. Certificate validity is the period of time during which a certificate is valid. Validity can be expressed as an explicit date and time when the certificate expires, or as a span of time after issuance, stated in days, months, or years. For more information, see Validity in RFC 5280. This value is unaffected when ValidityNotBefore is also specified. For example, if Validity is set to 20 days in the future, the certificate will expire 20 days from issuance time regardless of the ValidityNotBefore value.</p>', ], ], 'ValidityPeriodPeriodLong' => [ 'base' => NULL, 'refs' => [ 'ValidityPeriod$Period' => '<p>The numeric value for the validity period.</p>', ], ], 'ValidityPeriodType' => [ 'base' => NULL, 'refs' => [ 'ValidityPeriod$PeriodType' => '<p>The unit of time. You can select hours, days, weeks, months, and years.</p>', ], ], 'VpcInformation' => [ 'base' => '<p>Information about your VPC and security groups used with the connector.</p>', 'refs' => [ 'Connector$VpcInformation' => '<p>Information of the VPC and security group(s) used with the connector.</p>', 'ConnectorSummary$VpcInformation' => '<p>Information of the VPC and security group(s) used with the connector.</p>', 'CreateConnectorRequest$VpcInformation' => '<p>Security group IDs that describe the inbound and outbound rules.</p>', ], ], ],];
