<?php
// This file was auto-generated from sdk-root/src/data/personalize/2018-05-22/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Personalize is a machine learning service that makes it easy to add individualized recommendations to customers.</p>', 'operations' => [ 'CreateBatchInferenceJob' => '<p>Generates batch recommendations based on a list of items or users stored in Amazon S3 and exports the recommendations to an Amazon S3 bucket.</p> <p>To generate batch recommendations, specify the ARN of a solution version and an Amazon S3 URI for the input and output data. For user personalization, popular items, and personalized ranking solutions, the batch inference job generates a list of recommended items for each user ID in the input file. For related items solutions, the job generates a list of recommended items for each item ID in the input file.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/getting-batch-recommendations.html">Creating a batch inference job </a>.</p> <p> If you use the Similar-Items recipe, Amazon Personalize can add descriptive themes to batch recommendations. To generate themes, set the job\'s mode to <code>THEME_GENERATION</code> and specify the name of the field that contains item names in the input data.</p> <p> For more information about generating themes, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/themed-batch-recommendations.html">Batch recommendations with themes from Content Generator </a>. </p> <p>You can\'t get batch recommendations with the Trending-Now or Next-Best-Action recipes.</p>', 'CreateBatchSegmentJob' => '<p>Creates a batch segment job. The operation can handle up to 50 million records and the input file must be in JSON format. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/recommendations-batch.html">Getting batch recommendations and user segments</a>.</p>', 'CreateCampaign' => '<important> <p> You incur campaign costs while it is active. To avoid unnecessary costs, make sure to delete the campaign when you are finished. For information about campaign costs, see <a href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.</p> </important> <p>Creates a campaign that deploys a solution version. When a client calls the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a> and <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html">GetPersonalizedRanking</a> APIs, a campaign is specified in the request.</p> <p> <b>Minimum Provisioned TPS and Auto-Scaling</b> </p> <important> <p> A high <code>minProvisionedTPS</code> will increase your cost. We recommend starting with 1 for <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase the <code>minProvisionedTPS</code> as necessary.</p> </important> <p> When you create an Amazon Personalize campaign, you can specify the minimum provisioned transactions per second (<code>minProvisionedTPS</code>) for the campaign. This is the baseline transaction throughput for the campaign provisioned by Amazon Personalize. It sets the minimum billing charge for the campaign while it is active. A transaction is a single <code>GetRecommendations</code> or <code>GetPersonalizedRanking</code> request. The default <code>minProvisionedTPS</code> is 1.</p> <p> If your TPS increases beyond the <code>minProvisionedTPS</code>, Amazon Personalize auto-scales the provisioned capacity up and down, but never below <code>minProvisionedTPS</code>. There\'s a short time delay while the capacity is increased that might cause loss of transactions. When your traffic reduces, capacity returns to the <code>minProvisionedTPS</code>. </p> <p>You are charged for the the minimum provisioned TPS or, if your requests exceed the <code>minProvisionedTPS</code>, the actual TPS. The actual TPS is the total number of recommendation requests you make. We recommend starting with a low <code>minProvisionedTPS</code>, track your usage using Amazon CloudWatch metrics, and then increase the <code>minProvisionedTPS</code> as necessary.</p> <p>For more information about campaign costs, see <a href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.</p> <p> <b>Status</b> </p> <p>A campaign can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul> <p>To get the campaign status, call <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a>.</p> <note> <p>Wait until the <code>status</code> of the campaign is <code>ACTIVE</code> before asking the campaign for recommendations.</p> </note> <p class="title"> <b>Related APIs</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html">ListCampaigns</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateCampaign.html">UpdateCampaign</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteCampaign.html">DeleteCampaign</a> </p> </li> </ul>', 'CreateDataDeletionJob' => '<p>Creates a batch job that deletes all references to specific users from an Amazon Personalize dataset group in batches. You specify the users to delete in a CSV file of userIds in an Amazon S3 bucket. After a job completes, Amazon Personalize no longer trains on the users’ data and no longer considers the users when generating user segments. For more information about creating a data deletion job, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/delete-records.html">Deleting users</a>.</p> <ul> <li> <p>Your input file must be a CSV file with a single USER_ID column that lists the users IDs. For more information about preparing the CSV file, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/prepare-deletion-input-file.html">Preparing your data deletion file and uploading it to Amazon S3</a>.</p> </li> <li> <p>To give Amazon Personalize permission to access your input CSV file of userIds, you must specify an IAM service role that has permission to read from the data source. This role needs <code>GetObject</code> and <code>ListBucket</code> permissions for the bucket and its content. These permissions are the same as importing data. For information on granting access to your Amazon S3 bucket, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html">Giving Amazon Personalize Access to Amazon S3 Resources</a>. </p> </li> </ul> <p> After you create a job, it can take up to a day to delete all references to the users from datasets and models. Until the job completes, Amazon Personalize continues to use the data when training. And if you use a User Segmentation recipe, the users might appear in user segments. </p> <p> <b>Status</b> </p> <p>A data deletion job can have one of the following statuses:</p> <ul> <li> <p>PENDING &gt; IN_PROGRESS &gt; COMPLETED -or- FAILED</p> </li> </ul> <p>To get the status of the data deletion job, call <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataDeletionJob.html">DescribeDataDeletionJob</a> API operation and specify the Amazon Resource Name (ARN) of the job. If the status is FAILED, the response includes a <code>failureReason</code> key, which describes why the job failed.</p> <p class="title"> <b>Related APIs</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDataDeletionJobs.html">ListDataDeletionJobs</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataDeletionJob.html">DescribeDataDeletionJob</a> </p> </li> </ul>', 'CreateDataset' => '<p>Creates an empty dataset and adds it to the specified dataset group. Use <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a> to import your training data to a dataset.</p> <p>There are 5 types of datasets:</p> <ul> <li> <p>Item interactions</p> </li> <li> <p>Items</p> </li> <li> <p>Users</p> </li> <li> <p>Action interactions</p> </li> <li> <p>Actions</p> </li> </ul> <p>Each dataset type has an associated schema with required field types. Only the <code>Item interactions</code> dataset is required in order to train a model (also referred to as creating a solution).</p> <p>A dataset can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul> <p>To get the status of the dataset, call <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html">DescribeDataset</a>.</p> <p class="title"> <b>Related APIs</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasets.html">ListDatasets</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html">DescribeDataset</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDataset.html">DeleteDataset</a> </p> </li> </ul>', 'CreateDatasetExportJob' => '<p> Creates a job that exports data from your dataset to an Amazon S3 bucket. To allow Amazon Personalize to export the training data, you must specify an service-linked IAM role that gives Amazon Personalize <code>PutObject</code> permissions for your Amazon S3 bucket. For information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/export-data.html">Exporting a dataset</a> in the Amazon Personalize developer guide. </p> <p> <b>Status</b> </p> <p>A dataset export job can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> </ul> <p> To get the status of the export job, call <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html">DescribeDatasetExportJob</a>, and specify the Amazon Resource Name (ARN) of the dataset export job. The dataset export is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a <code>failureReason</code> key, which describes why the job failed. </p>', 'CreateDatasetGroup' => '<p>Creates an empty dataset group. A dataset group is a container for Amazon Personalize resources. A dataset group can contain at most three datasets, one for each type of dataset:</p> <ul> <li> <p>Item interactions</p> </li> <li> <p>Items</p> </li> <li> <p>Users</p> </li> <li> <p>Actions</p> </li> <li> <p>Action interactions</p> </li> </ul> <p> A dataset group can be a Domain dataset group, where you specify a domain and use pre-configured resources like recommenders, or a Custom dataset group, where you use custom resources, such as a solution with a solution version, that you deploy with a campaign. If you start with a Domain dataset group, you can still add custom resources such as solutions and solution versions trained with recipes for custom use cases and deployed with campaigns. </p> <p>A dataset group can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING</p> </li> </ul> <p>To get the status of the dataset group, call <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a>. If the status shows as CREATE FAILED, the response includes a <code>failureReason</code> key, which describes why the creation failed.</p> <note> <p>You must wait until the <code>status</code> of the dataset group is <code>ACTIVE</code> before adding a dataset to the group.</p> </note> <p>You can specify an Key Management Service (KMS) key to encrypt the datasets in the group. If you specify a KMS key, you must also include an Identity and Access Management (IAM) role that has permission to access the key.</p> <p class="title"> <b>APIs that require a dataset group ARN in the request</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> </p> </li> </ul> <p class="title"> <b>Related APIs</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetGroups.html">ListDatasetGroups</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteDatasetGroup.html">DeleteDatasetGroup</a> </p> </li> </ul>', 'CreateDatasetImportJob' => '<p>Creates a job that imports training data from your data source (an Amazon S3 bucket) to an Amazon Personalize dataset. To allow Amazon Personalize to import the training data, you must specify an IAM service role that has permission to read from the data source, as Amazon Personalize makes a copy of your data and processes it internally. For information on granting access to your Amazon S3 bucket, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/granting-personalize-s3-access.html">Giving Amazon Personalize Access to Amazon S3 Resources</a>. </p> <p>If you already created a recommender or deployed a custom solution version with a campaign, how new bulk records influence recommendations depends on the domain use case or recipe that you use. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/how-new-data-influences-recommendations.html">How new data influences real-time recommendations</a>.</p> <important> <p>By default, a dataset import job replaces any existing data in the dataset that you imported in bulk. To add new records without replacing existing data, specify INCREMENTAL for the import mode in the CreateDatasetImportJob operation.</p> </important> <p> <b>Status</b> </p> <p>A dataset import job can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> </ul> <p>To get the status of the import job, call <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html">DescribeDatasetImportJob</a>, providing the Amazon Resource Name (ARN) of the dataset import job. The dataset import is complete when the status shows as ACTIVE. If the status shows as CREATE FAILED, the response includes a <code>failureReason</code> key, which describes why the job failed.</p> <note> <p>Importing takes time. You must wait until the status shows as ACTIVE before training a model using the dataset.</p> </note> <p class="title"> <b>Related APIs</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListDatasetImportJobs.html">ListDatasetImportJobs</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html">DescribeDatasetImportJob</a> </p> </li> </ul>', 'CreateEventTracker' => '<p>Creates an event tracker that you use when adding event data to a specified dataset group using the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.</p> <note> <p>Only one event tracker can be associated with a dataset group. You will get an error if you call <code>CreateEventTracker</code> using the same dataset group as an existing event tracker.</p> </note> <p>When you create an event tracker, the response includes a tracking ID, which you pass as a parameter when you use the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> operation. Amazon Personalize then appends the event data to the Item interactions dataset of the dataset group you specify in your event tracker. </p> <p>The event tracker can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul> <p>To get the status of the event tracker, call <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html">DescribeEventTracker</a>.</p> <note> <p>The event tracker must be in the ACTIVE state before using the tracking ID.</p> </note> <p class="title"> <b>Related APIs</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListEventTrackers.html">ListEventTrackers</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html">DescribeEventTracker</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteEventTracker.html">DeleteEventTracker</a> </p> </li> </ul>', 'CreateFilter' => '<p>Creates a recommendation filter. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter.html">Filtering recommendations and user segments</a>.</p>', 'CreateMetricAttribution' => '<p>Creates a metric attribution. A metric attribution creates reports on the data that you import into Amazon Personalize. Depending on how you imported the data, you can view reports in Amazon CloudWatch or Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html">Measuring impact of recommendations</a>.</p>', 'CreateRecommender' => '<p>Creates a recommender with the recipe (a Domain dataset group use case) you specify. You create recommenders for a Domain dataset group and specify the recommender\'s Amazon Resource Name (ARN) when you make a <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a> request. </p> <p> <b>Minimum recommendation requests per second</b> </p> <important> <p>A high <code>minRecommendationRequestsPerSecond</code> will increase your bill. We recommend starting with 1 for <code>minRecommendationRequestsPerSecond</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase the <code>minRecommendationRequestsPerSecond</code> as necessary.</p> </important> <p>When you create a recommender, you can configure the recommender\'s minimum recommendation requests per second. The minimum recommendation requests per second (<code>minRecommendationRequestsPerSecond</code>) specifies the baseline recommendation request throughput provisioned by Amazon Personalize. The default minRecommendationRequestsPerSecond is <code>1</code>. A recommendation request is a single <code>GetRecommendations</code> operation. Request throughput is measured in requests per second and Amazon Personalize uses your requests per second to derive your requests per hour and the price of your recommender usage. </p> <p> If your requests per second increases beyond <code>minRecommendationRequestsPerSecond</code>, Amazon Personalize auto-scales the provisioned capacity up and down, but never below <code>minRecommendationRequestsPerSecond</code>. There\'s a short time delay while the capacity is increased that might cause loss of requests.</p> <p> Your bill is the greater of either the minimum requests per hour (based on minRecommendationRequestsPerSecond) or the actual number of requests. The actual request throughput used is calculated as the average requests/second within a one-hour window. We recommend starting with the default <code>minRecommendationRequestsPerSecond</code>, track your usage using Amazon CloudWatch metrics, and then increase the <code>minRecommendationRequestsPerSecond</code> as necessary. </p> <p> <b>Status</b> </p> <p>A recommender can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>STOP PENDING &gt; STOP IN_PROGRESS &gt; INACTIVE &gt; START PENDING &gt; START IN_PROGRESS &gt; ACTIVE</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul> <p>To get the recommender status, call <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html">DescribeRecommender</a>.</p> <note> <p>Wait until the <code>status</code> of the recommender is <code>ACTIVE</code> before asking the recommender for recommendations.</p> </note> <p class="title"> <b>Related APIs</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListRecommenders.html">ListRecommenders</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html">DescribeRecommender</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateRecommender.html">UpdateRecommender</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteRecommender.html">DeleteRecommender</a> </p> </li> </ul>', 'CreateSchema' => '<p>Creates an Amazon Personalize schema from the specified schema string. The schema you create must be in Avro JSON format.</p> <p>Amazon Personalize recognizes three schema variants. Each schema is associated with a dataset type and has a set of required field and keywords. If you are creating a schema for a dataset in a Domain dataset group, you provide the domain of the Domain dataset group. You specify a schema when you call <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.</p> <p class="title"> <b>Related APIs</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSchemas.html">ListSchemas</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html">DescribeSchema</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSchema.html">DeleteSchema</a> </p> </li> </ul>', 'CreateSolution' => '<important> <p>By default, all new solutions use automatic training. With automatic training, you incur training costs while your solution is active. To avoid unnecessary costs, when you are finished you can <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateSolution.html">update the solution</a> to turn off automatic training. For information about training costs, see <a href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.</p> </important> <p>Creates the configuration for training a model (creating a solution version). This configuration includes the recipe to use for model training and optional training configuration, such as columns to use in training and feature transformation parameters. For more information about configuring a solution, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/customizing-solution-config.html">Creating and configuring a solution</a>. </p> <p> By default, new solutions use automatic training to create solution versions every 7 days. You can change the training frequency. Automatic solution version creation starts within one hour after the solution is ACTIVE. If you manually create a solution version within the hour, the solution skips the first automatic training. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html">Configuring automatic training</a>.</p> <p> To turn off automatic training, set <code>performAutoTraining</code> to false. If you turn off automatic training, you must manually create a solution version by calling the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html">CreateSolutionVersion</a> operation.</p> <p>After training starts, you can get the solution version\'s Amazon Resource Name (ARN) with the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html">ListSolutionVersions</a> API operation. To get its status, use the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">DescribeSolutionVersion</a>. </p> <p>After training completes you can evaluate model accuracy by calling <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_GetSolutionMetrics.html">GetSolutionMetrics</a>. When you are satisfied with the solution version, you deploy it using <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>. The campaign provides recommendations to a client through the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a> API.</p> <note> <p>Amazon Personalize doesn\'t support configuring the <code>hpoObjective</code> for solution hyperparameter optimization at this time.</p> </note> <p> <b>Status</b> </p> <p>A solution can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul> <p>To get the status of the solution, call <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a>. If you use manual training, the status must be ACTIVE before you call <code>CreateSolutionVersion</code>.</p> <p class="title"> <b>Related APIs</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateSolution.html">UpdateSolution</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html">ListSolutions</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolutionVersion.html">CreateSolutionVersion</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html">DeleteSolution</a> </p> </li> </ul> <ul> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html">ListSolutionVersions</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">DescribeSolutionVersion</a> </p> </li> </ul>', 'CreateSolutionVersion' => '<p>Trains or retrains an active solution in a Custom dataset group. A solution is created using the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> operation and must be in the ACTIVE state before calling <code>CreateSolutionVersion</code>. A new version of the solution is created every time you call this operation.</p> <p> <b>Status</b> </p> <p>A solution version can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING</p> </li> <li> <p>CREATE IN_PROGRESS</p> </li> <li> <p>ACTIVE</p> </li> <li> <p>CREATE FAILED</p> </li> <li> <p>CREATE STOPPING</p> </li> <li> <p>CREATE STOPPED</p> </li> </ul> <p>To get the status of the version, call <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">DescribeSolutionVersion</a>. Wait until the status shows as ACTIVE before calling <code>CreateCampaign</code>.</p> <p>If the status shows as CREATE FAILED, the response includes a <code>failureReason</code> key, which describes why the job failed.</p> <p class="title"> <b>Related APIs</b> </p> <ul> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html">ListSolutionVersions</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">DescribeSolutionVersion</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutions.html">ListSolutions</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a> </p> </li> <li> <p> <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DeleteSolution.html">DeleteSolution</a> </p> </li> </ul>', 'DeleteCampaign' => '<p>Removes a campaign by deleting the solution deployment. The solution that the campaign is based on is not deleted and can be redeployed when needed. A deleted campaign can no longer be specified in a <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a> request. For information on creating campaigns, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.</p>', 'DeleteDataset' => '<p>Deletes a dataset. You can\'t delete a dataset if an associated <code>DatasetImportJob</code> or <code>SolutionVersion</code> is in the CREATE PENDING or IN PROGRESS state. For more information on datasets, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.</p>', 'DeleteDatasetGroup' => '<p>Deletes a dataset group. Before you delete a dataset group, you must delete the following:</p> <ul> <li> <p>All associated event trackers.</p> </li> <li> <p>All associated solutions.</p> </li> <li> <p>All datasets in the dataset group.</p> </li> </ul>', 'DeleteEventTracker' => '<p>Deletes the event tracker. Does not delete the dataset from the dataset group. For more information on event trackers, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.</p>', 'DeleteFilter' => '<p>Deletes a filter.</p>', 'DeleteMetricAttribution' => '<p>Deletes a metric attribution.</p>', 'DeleteRecommender' => '<p>Deactivates and removes a recommender. A deleted recommender can no longer be specified in a <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a> request.</p>', 'DeleteSchema' => '<p>Deletes a schema. Before deleting a schema, you must delete all datasets referencing the schema. For more information on schemas, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.</p>', 'DeleteSolution' => '<p>Deletes all versions of a solution and the <code>Solution</code> object itself. Before deleting a solution, you must delete all campaigns based on the solution. To determine what campaigns are using the solution, call <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html">ListCampaigns</a> and supply the Amazon Resource Name (ARN) of the solution. You can\'t delete a solution if an associated <code>SolutionVersion</code> is in the CREATE PENDING or IN PROGRESS state. For more information on solutions, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.</p>', 'DescribeAlgorithm' => '<p>Describes the given algorithm.</p>', 'DescribeBatchInferenceJob' => '<p>Gets the properties of a batch inference job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate the recommendations.</p>', 'DescribeBatchSegmentJob' => '<p>Gets the properties of a batch segment job including name, Amazon Resource Name (ARN), status, input and output configurations, and the ARN of the solution version used to generate segments.</p>', 'DescribeCampaign' => '<p>Describes the given campaign, including its status.</p> <p>A campaign can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul> <p>When the <code>status</code> is <code>CREATE FAILED</code>, the response includes the <code>failureReason</code> key, which describes why.</p> <p>For more information on campaigns, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.</p>', 'DescribeDataDeletionJob' => '<p>Describes the data deletion job created by <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataDeletionJob.html">CreateDataDeletionJob</a>, including the job status.</p>', 'DescribeDataset' => '<p>Describes the given dataset. For more information on datasets, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.</p>', 'DescribeDatasetExportJob' => '<p>Describes the dataset export job created by <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html">CreateDatasetExportJob</a>, including the export job status.</p>', 'DescribeDatasetGroup' => '<p>Describes the given dataset group. For more information on dataset groups, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>.</p>', 'DescribeDatasetImportJob' => '<p>Describes the dataset import job created by <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a>, including the import job status.</p>', 'DescribeEventTracker' => '<p>Describes an event tracker. The response includes the <code>trackingId</code> and <code>status</code> of the event tracker. For more information on event trackers, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.</p>', 'DescribeFeatureTransformation' => '<p>Describes the given feature transformation.</p>', 'DescribeFilter' => '<p>Describes a filter\'s properties.</p>', 'DescribeMetricAttribution' => '<p>Describes a metric attribution.</p>', 'DescribeRecipe' => '<p>Describes a recipe.</p> <p>A recipe contains three items:</p> <ul> <li> <p>An algorithm that trains a model.</p> </li> <li> <p>Hyperparameters that govern the training.</p> </li> <li> <p>Feature transformation information for modifying the input data before training.</p> </li> </ul> <p>Amazon Personalize provides a set of predefined recipes. You specify a recipe when you create a solution with the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> API. <code>CreateSolution</code> trains a model by using the algorithm in the specified recipe and a training dataset. The solution, when deployed as a campaign, can provide recommendations using the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a> API.</p>', 'DescribeRecommender' => '<p>Describes the given recommender, including its status.</p> <p>A recommender can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>STOP PENDING &gt; STOP IN_PROGRESS &gt; INACTIVE &gt; START PENDING &gt; START IN_PROGRESS &gt; ACTIVE</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul> <p>When the <code>status</code> is <code>CREATE FAILED</code>, the response includes the <code>failureReason</code> key, which describes why.</p> <p>The <code>modelMetrics</code> key is null when the recommender is being created or deleted.</p> <p>For more information on recommenders, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html">CreateRecommender</a>.</p>', 'DescribeSchema' => '<p>Describes a schema. For more information on schemas, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.</p>', 'DescribeSolution' => '<p>Describes a solution. For more information on solutions, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.</p>', 'DescribeSolutionVersion' => '<p>Describes a specific version of a solution. For more information on solutions, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> </p>', 'GetSolutionMetrics' => '<p>Gets the metrics for the specified solution version.</p>', 'ListBatchInferenceJobs' => '<p>Gets a list of the batch inference jobs that have been performed off of a solution version.</p>', 'ListBatchSegmentJobs' => '<p>Gets a list of the batch segment jobs that have been performed off of a solution version that you specify.</p>', 'ListCampaigns' => '<p>Returns a list of campaigns that use the given solution. When a solution is not specified, all the campaigns associated with the account are listed. The response provides the properties for each campaign, including the Amazon Resource Name (ARN). For more information on campaigns, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.</p>', 'ListDataDeletionJobs' => '<p>Returns a list of data deletion jobs for a dataset group ordered by creation time, with the most recent first. When a dataset group is not specified, all the data deletion jobs associated with the account are listed. The response provides the properties for each job, including the Amazon Resource Name (ARN). For more information on data deletion jobs, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/delete-records.html">Deleting users</a>.</p>', 'ListDatasetExportJobs' => '<p>Returns a list of dataset export jobs that use the given dataset. When a dataset is not specified, all the dataset export jobs associated with the account are listed. The response provides the properties for each dataset export job, including the Amazon Resource Name (ARN). For more information on dataset export jobs, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html">CreateDatasetExportJob</a>. For more information on datasets, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.</p>', 'ListDatasetGroups' => '<p>Returns a list of dataset groups. The response provides the properties for each dataset group, including the Amazon Resource Name (ARN). For more information on dataset groups, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>.</p>', 'ListDatasetImportJobs' => '<p>Returns a list of dataset import jobs that use the given dataset. When a dataset is not specified, all the dataset import jobs associated with the account are listed. The response provides the properties for each dataset import job, including the Amazon Resource Name (ARN). For more information on dataset import jobs, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a>. For more information on datasets, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.</p>', 'ListDatasets' => '<p>Returns the list of datasets contained in the given dataset group. The response provides the properties for each dataset, including the Amazon Resource Name (ARN). For more information on datasets, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>.</p>', 'ListEventTrackers' => '<p>Returns the list of event trackers associated with the account. The response provides the properties for each event tracker, including the Amazon Resource Name (ARN) and tracking ID. For more information on event trackers, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html">CreateEventTracker</a>.</p>', 'ListFilters' => '<p>Lists all filters that belong to a given dataset group.</p>', 'ListMetricAttributionMetrics' => '<p>Lists the metrics for the metric attribution.</p>', 'ListMetricAttributions' => '<p>Lists metric attributions.</p>', 'ListRecipes' => '<p>Returns a list of available recipes. The response provides the properties for each recipe, including the recipe\'s Amazon Resource Name (ARN).</p>', 'ListRecommenders' => '<p>Returns a list of recommenders in a given Domain dataset group. When a Domain dataset group is not specified, all the recommenders associated with the account are listed. The response provides the properties for each recommender, including the Amazon Resource Name (ARN). For more information on recommenders, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateRecommender.html">CreateRecommender</a>.</p>', 'ListSchemas' => '<p>Returns the list of schemas associated with the account. The response provides the properties for each schema, including the Amazon Resource Name (ARN). For more information on schemas, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.</p>', 'ListSolutionVersions' => '<p>Returns a list of solution versions for the given solution. When a solution is not specified, all the solution versions associated with the account are listed. The response provides the properties for each solution version, including the Amazon Resource Name (ARN).</p>', 'ListSolutions' => '<p>Returns a list of solutions in a given dataset group. When a dataset group is not specified, all the solutions associated with the account are listed. The response provides the properties for each solution, including the Amazon Resource Name (ARN). For more information on solutions, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>.</p>', 'ListTagsForResource' => '<p>Get a list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> attached to a resource.</p>', 'StartRecommender' => '<p>Starts a recommender that is INACTIVE. Starting a recommender does not create any new models, but resumes billing and automatic retraining for the recommender.</p>', 'StopRecommender' => '<p>Stops a recommender that is ACTIVE. Stopping a recommender halts billing and automatic retraining for the recommender.</p>', 'StopSolutionVersionCreation' => '<p>Stops creating a solution version that is in a state of CREATE_PENDING or CREATE IN_PROGRESS. </p> <p>Depending on the current state of the solution version, the solution version state changes as follows:</p> <ul> <li> <p>CREATE_PENDING &gt; CREATE_STOPPED</p> <p>or</p> </li> <li> <p>CREATE_IN_PROGRESS &gt; CREATE_STOPPING &gt; CREATE_STOPPED</p> </li> </ul> <p>You are billed for all of the training completed up until you stop the solution version creation. You cannot resume creating a solution version once it has been stopped.</p>', 'TagResource' => '<p>Add a list of tags to a resource.</p>', 'UntagResource' => '<p>Removes the specified tags that are attached to a resource. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/tags-remove.html">Removing tags from Amazon Personalize resources</a>.</p>', 'UpdateCampaign' => '<p> Updates a campaign to deploy a retrained solution version with an existing campaign, change your campaign\'s <code>minProvisionedTPS</code>, or modify your campaign\'s configuration. For example, you can set <code>enableMetadataWithRecommendations</code> to true for an existing campaign.</p> <p> To update a campaign to start automatically using the latest solution version, specify the following:</p> <ul> <li> <p>For the <code>SolutionVersionArn</code> parameter, specify the Amazon Resource Name (ARN) of your solution in <code>SolutionArn/$LATEST</code> format. </p> </li> <li> <p> In the <code>campaignConfig</code>, set <code>syncWithLatestSolutionVersion</code> to <code>true</code>. </p> </li> </ul> <p>To update a campaign, the campaign status must be ACTIVE or CREATE FAILED. Check the campaign status using the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a> operation.</p> <note> <p>You can still get recommendations from a campaign while an update is in progress. The campaign will use the previous solution version and campaign configuration to generate recommendations until the latest campaign update status is <code>Active</code>. </p> </note> <p>For more information about updating a campaign, including code samples, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/update-campaigns.html">Updating a campaign</a>. For more information about campaigns, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html">Creating a campaign</a>.</p>', 'UpdateDataset' => '<p>Update a dataset to replace its schema with a new or existing one. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/updating-dataset-schema.html">Replacing a dataset\'s schema</a>. </p>', 'UpdateMetricAttribution' => '<p>Updates a metric attribution.</p>', 'UpdateRecommender' => '<p>Updates the recommender to modify the recommender configuration. If you update the recommender to modify the columns used in training, Amazon Personalize automatically starts a full retraining of the models backing your recommender. While the update completes, you can still get recommendations from the recommender. The recommender uses the previous configuration until the update completes. To track the status of this update, use the <code>latestRecommenderUpdate</code> returned in the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html">DescribeRecommender</a> operation. </p>', 'UpdateSolution' => '<p>Updates an Amazon Personalize solution to use a different automatic training configuration. When you update a solution, you can change whether the solution uses automatic training, and you can change the training frequency. For more information about updating a solution, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/updating-solution.html">Updating a solution</a>.</p> <p>A solution update can be in one of the following states:</p> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> <p>To get the status of a solution update, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a> API operation and find the status in the <code>latestSolutionUpdate</code>. </p>', ], 'shapes' => [ 'AccountId' => [ 'base' => NULL, 'refs' => [ 'EventTracker$accountId' => '<p>The Amazon Web Services account that owns the event tracker.</p>', ], ], 'Algorithm' => [ 'base' => '<p>Describes a custom algorithm.</p>', 'refs' => [ 'DescribeAlgorithmResponse$algorithm' => '<p>A listing of the properties of the algorithm.</p>', ], ], 'AlgorithmImage' => [ 'base' => '<p>Describes an algorithm image.</p>', 'refs' => [ 'Algorithm$algorithmImage' => '<p>The URI of the Docker container for the algorithm image.</p>', ], ], 'Arn' => [ 'base' => NULL, 'refs' => [ 'Algorithm$algorithmArn' => '<p>The Amazon Resource Name (ARN) of the algorithm.</p>', 'Algorithm$roleArn' => '<p>The Amazon Resource Name (ARN) of the role.</p>', 'ArnList$member' => NULL, 'AutoMLResult$bestRecipeArn' => '<p>The Amazon Resource Name (ARN) of the best recipe.</p>', 'BatchInferenceJob$batchInferenceJobArn' => '<p>The Amazon Resource Name (ARN) of the batch inference job.</p>', 'BatchInferenceJob$filterArn' => '<p>The ARN of the filter used on the batch inference job.</p>', 'BatchInferenceJob$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the solution version from which the batch inference job was created.</p>', 'BatchInferenceJobSummary$batchInferenceJobArn' => '<p>The Amazon Resource Name (ARN) of the batch inference job.</p>', 'BatchInferenceJobSummary$solutionVersionArn' => '<p>The ARN of the solution version used by the batch inference job.</p>', 'BatchSegmentJob$batchSegmentJobArn' => '<p>The Amazon Resource Name (ARN) of the batch segment job.</p>', 'BatchSegmentJob$filterArn' => '<p>The ARN of the filter used on the batch segment job.</p>', 'BatchSegmentJob$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.</p>', 'BatchSegmentJobSummary$batchSegmentJobArn' => '<p>The Amazon Resource Name (ARN) of the batch segment job.</p>', 'BatchSegmentJobSummary$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the solution version used by the batch segment job to generate batch segments.</p>', 'Campaign$campaignArn' => '<p>The Amazon Resource Name (ARN) of the campaign. </p>', 'Campaign$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the solution version the campaign uses.</p>', 'CampaignSummary$campaignArn' => '<p>The Amazon Resource Name (ARN) of the campaign.</p>', 'CampaignUpdateSummary$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the deployed solution version.</p>', 'CreateBatchInferenceJobRequest$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the solution version that will be used to generate the batch inference recommendations.</p>', 'CreateBatchInferenceJobRequest$filterArn' => '<p>The ARN of the filter to apply to the batch inference job. For more information on using filters, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch recommendations</a>.</p>', 'CreateBatchInferenceJobResponse$batchInferenceJobArn' => '<p>The ARN of the batch inference job.</p>', 'CreateBatchSegmentJobRequest$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the solution version you want the batch segment job to use to generate batch segments.</p>', 'CreateBatchSegmentJobRequest$filterArn' => '<p>The ARN of the filter to apply to the batch segment job. For more information on using filters, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter-batch.html">Filtering batch recommendations</a>.</p>', 'CreateBatchSegmentJobResponse$batchSegmentJobArn' => '<p>The ARN of the batch segment job.</p>', 'CreateCampaignRequest$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the trained model to deploy with the campaign. To specify the latest solution version of your solution, specify the ARN of your <i>solution</i> in <code>SolutionArn/$LATEST</code> format. You must use this format if you set <code>syncWithLatestSolutionVersion</code> to <code>True</code> in the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CampaignConfig.html">CampaignConfig</a>. </p> <p> To deploy a model that isn\'t the latest solution version of your solution, specify the ARN of the solution version. </p> <p> For more information about automatic campaign updates, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update">Enabling automatic campaign updates</a>. </p>', 'CreateCampaignResponse$campaignArn' => '<p>The Amazon Resource Name (ARN) of the campaign.</p>', 'CreateDataDeletionJobRequest$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group that has the datasets you want to delete records from.</p>', 'CreateDataDeletionJobResponse$dataDeletionJobArn' => '<p>The Amazon Resource Name (ARN) of the data deletion job.</p>', 'CreateDatasetExportJobRequest$datasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset that contains the data to export.</p>', 'CreateDatasetExportJobResponse$datasetExportJobArn' => '<p>The Amazon Resource Name (ARN) of the dataset export job.</p>', 'CreateDatasetGroupResponse$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the new dataset group.</p>', 'CreateDatasetImportJobRequest$datasetArn' => '<p>The ARN of the dataset that receives the imported data.</p>', 'CreateDatasetImportJobResponse$datasetImportJobArn' => '<p>The ARN of the dataset import job.</p>', 'CreateDatasetRequest$schemaArn' => '<p>The ARN of the schema to associate with the dataset. The schema defines the dataset fields.</p>', 'CreateDatasetRequest$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group to add the dataset to.</p>', 'CreateDatasetResponse$datasetArn' => '<p>The ARN of the dataset.</p>', 'CreateEventTrackerRequest$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group that receives the event data.</p>', 'CreateEventTrackerResponse$eventTrackerArn' => '<p>The ARN of the event tracker.</p>', 'CreateFilterRequest$datasetGroupArn' => '<p>The ARN of the dataset group that the filter will belong to.</p>', 'CreateFilterResponse$filterArn' => '<p>The ARN of the new filter.</p>', 'CreateMetricAttributionRequest$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the destination dataset group for the metric attribution.</p>', 'CreateMetricAttributionResponse$metricAttributionArn' => '<p>The Amazon Resource Name (ARN) for the new metric attribution.</p>', 'CreateRecommenderRequest$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the destination domain dataset group for the recommender.</p>', 'CreateRecommenderRequest$recipeArn' => '<p>The Amazon Resource Name (ARN) of the recipe that the recommender will use. For a recommender, a recipe is a Domain dataset group use case. Only Domain dataset group use cases can be used to create a recommender. For information about use cases see <a href="https://docs.aws.amazon.com/personalize/latest/dg/domain-use-cases.html">Choosing recommender use cases</a>. </p>', 'CreateRecommenderResponse$recommenderArn' => '<p>The Amazon Resource Name (ARN) of the recommender.</p>', 'CreateSchemaResponse$schemaArn' => '<p>The Amazon Resource Name (ARN) of the created schema.</p>', 'CreateSolutionRequest$recipeArn' => '<p>The Amazon Resource Name (ARN) of the recipe to use for model training. This is required when <code>performAutoML</code> is false. For information about different Amazon Personalize recipes and their ARNs, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/working-with-predefined-recipes.html">Choosing a recipe</a>. </p>', 'CreateSolutionRequest$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group that provides the training data.</p>', 'CreateSolutionResponse$solutionArn' => '<p>The ARN of the solution.</p>', 'CreateSolutionVersionRequest$solutionArn' => '<p>The Amazon Resource Name (ARN) of the solution containing the training configuration information.</p>', 'CreateSolutionVersionResponse$solutionVersionArn' => '<p>The ARN of the new solution version.</p>', 'DataDeletionJob$dataDeletionJobArn' => '<p>The Amazon Resource Name (ARN) of the data deletion job.</p>', 'DataDeletionJob$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group the job deletes records from.</p>', 'DataDeletionJobSummary$dataDeletionJobArn' => '<p>The Amazon Resource Name (ARN) of the data deletion job.</p>', 'DataDeletionJobSummary$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group the job deleted records from.</p>', 'Dataset$datasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset that you want metadata for.</p>', 'Dataset$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group.</p>', 'Dataset$schemaArn' => '<p>The ARN of the associated schema.</p>', 'DatasetExportJob$datasetExportJobArn' => '<p>The Amazon Resource Name (ARN) of the dataset export job.</p>', 'DatasetExportJob$datasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset to export.</p>', 'DatasetExportJob$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket.</p>', 'DatasetExportJobSummary$datasetExportJobArn' => '<p>The Amazon Resource Name (ARN) of the dataset export job.</p>', 'DatasetGroup$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group.</p>', 'DatasetGroupSummary$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group.</p>', 'DatasetImportJob$datasetImportJobArn' => '<p>The ARN of the dataset import job.</p>', 'DatasetImportJob$datasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset that receives the imported data.</p>', 'DatasetImportJob$roleArn' => '<p>The ARN of the IAM role that has permissions to read from the Amazon S3 data source.</p>', 'DatasetImportJobSummary$datasetImportJobArn' => '<p>The Amazon Resource Name (ARN) of the dataset import job.</p>', 'DatasetSchema$schemaArn' => '<p>The Amazon Resource Name (ARN) of the schema.</p>', 'DatasetSchemaSummary$schemaArn' => '<p>The Amazon Resource Name (ARN) of the schema.</p>', 'DatasetSummary$datasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset.</p>', 'DatasetUpdateSummary$schemaArn' => '<p>The Amazon Resource Name (ARN) of the schema that replaced the previous schema of the dataset.</p>', 'DeleteCampaignRequest$campaignArn' => '<p>The Amazon Resource Name (ARN) of the campaign to delete.</p>', 'DeleteDatasetGroupRequest$datasetGroupArn' => '<p>The ARN of the dataset group to delete.</p>', 'DeleteDatasetRequest$datasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset to delete.</p>', 'DeleteEventTrackerRequest$eventTrackerArn' => '<p>The Amazon Resource Name (ARN) of the event tracker to delete.</p>', 'DeleteFilterRequest$filterArn' => '<p>The ARN of the filter to delete.</p>', 'DeleteMetricAttributionRequest$metricAttributionArn' => '<p>The metric attribution\'s Amazon Resource Name (ARN).</p>', 'DeleteRecommenderRequest$recommenderArn' => '<p>The Amazon Resource Name (ARN) of the recommender to delete.</p>', 'DeleteSchemaRequest$schemaArn' => '<p>The Amazon Resource Name (ARN) of the schema to delete.</p>', 'DeleteSolutionRequest$solutionArn' => '<p>The ARN of the solution to delete.</p>', 'DescribeAlgorithmRequest$algorithmArn' => '<p>The Amazon Resource Name (ARN) of the algorithm to describe.</p>', 'DescribeBatchInferenceJobRequest$batchInferenceJobArn' => '<p>The ARN of the batch inference job to describe.</p>', 'DescribeBatchSegmentJobRequest$batchSegmentJobArn' => '<p>The ARN of the batch segment job to describe.</p>', 'DescribeCampaignRequest$campaignArn' => '<p>The Amazon Resource Name (ARN) of the campaign.</p>', 'DescribeDataDeletionJobRequest$dataDeletionJobArn' => '<p>The Amazon Resource Name (ARN) of the data deletion job.</p>', 'DescribeDatasetExportJobRequest$datasetExportJobArn' => '<p>The Amazon Resource Name (ARN) of the dataset export job to describe.</p>', 'DescribeDatasetGroupRequest$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group to describe.</p>', 'DescribeDatasetImportJobRequest$datasetImportJobArn' => '<p>The Amazon Resource Name (ARN) of the dataset import job to describe.</p>', 'DescribeDatasetRequest$datasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset to describe.</p>', 'DescribeEventTrackerRequest$eventTrackerArn' => '<p>The Amazon Resource Name (ARN) of the event tracker to describe.</p>', 'DescribeFeatureTransformationRequest$featureTransformationArn' => '<p>The Amazon Resource Name (ARN) of the feature transformation to describe.</p>', 'DescribeFilterRequest$filterArn' => '<p>The ARN of the filter to describe.</p>', 'DescribeMetricAttributionRequest$metricAttributionArn' => '<p>The metric attribution\'s Amazon Resource Name (ARN).</p>', 'DescribeRecipeRequest$recipeArn' => '<p>The Amazon Resource Name (ARN) of the recipe to describe.</p>', 'DescribeRecommenderRequest$recommenderArn' => '<p>The Amazon Resource Name (ARN) of the recommender to describe.</p>', 'DescribeSchemaRequest$schemaArn' => '<p>The Amazon Resource Name (ARN) of the schema to retrieve.</p>', 'DescribeSolutionRequest$solutionArn' => '<p>The Amazon Resource Name (ARN) of the solution to describe.</p>', 'DescribeSolutionVersionRequest$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the solution version.</p>', 'EventTracker$eventTrackerArn' => '<p>The ARN of the event tracker.</p>', 'EventTracker$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group that receives the event data.</p>', 'EventTrackerSummary$eventTrackerArn' => '<p>The Amazon Resource Name (ARN) of the event tracker.</p>', 'FeatureTransformation$featureTransformationArn' => '<p>The Amazon Resource Name (ARN) of the FeatureTransformation object.</p>', 'Filter$filterArn' => '<p>The ARN of the filter.</p>', 'Filter$datasetGroupArn' => '<p>The ARN of the dataset group to which the filter belongs.</p>', 'FilterSummary$filterArn' => '<p>The ARN of the filter.</p>', 'FilterSummary$datasetGroupArn' => '<p>The ARN of the dataset group to which the filter belongs.</p>', 'GetSolutionMetricsRequest$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the solution version for which to get metrics.</p>', 'GetSolutionMetricsResponse$solutionVersionArn' => '<p>The same solution version ARN as specified in the request.</p>', 'ListBatchInferenceJobsRequest$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the solution version from which the batch inference jobs were created.</p>', 'ListBatchSegmentJobsRequest$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the solution version that the batch segment jobs used to generate batch segments.</p>', 'ListCampaignsRequest$solutionArn' => '<p>The Amazon Resource Name (ARN) of the solution to list the campaigns for. When a solution is not specified, all the campaigns associated with the account are listed.</p>', 'ListDataDeletionJobsRequest$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group to list data deletion jobs for.</p>', 'ListDatasetExportJobsRequest$datasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset to list the dataset export jobs for.</p>', 'ListDatasetImportJobsRequest$datasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset to list the dataset import jobs for.</p>', 'ListDatasetsRequest$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group that contains the datasets to list.</p>', 'ListEventTrackersRequest$datasetGroupArn' => '<p>The ARN of a dataset group used to filter the response.</p>', 'ListFiltersRequest$datasetGroupArn' => '<p>The ARN of the dataset group that contains the filters.</p>', 'ListMetricAttributionMetricsRequest$metricAttributionArn' => '<p>The Amazon Resource Name (ARN) of the metric attribution to retrieve attributes for.</p>', 'ListMetricAttributionsRequest$datasetGroupArn' => '<p>The metric attributions\' dataset group Amazon Resource Name (ARN).</p>', 'ListRecommendersRequest$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the Domain dataset group to list the recommenders for. When a Domain dataset group is not specified, all the recommenders associated with the account are listed.</p>', 'ListSolutionVersionsRequest$solutionArn' => '<p>The Amazon Resource Name (ARN) of the solution.</p>', 'ListSolutionsRequest$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The resource\'s Amazon Resource Name (ARN).</p>', 'MetricAttribution$metricAttributionArn' => '<p>The metric attribution\'s Amazon Resource Name (ARN).</p>', 'MetricAttribution$datasetGroupArn' => '<p>The metric attribution\'s dataset group Amazon Resource Name (ARN).</p>', 'MetricAttributionSummary$metricAttributionArn' => '<p>The metric attribution\'s Amazon Resource Name (ARN).</p>', 'Recipe$recipeArn' => '<p>The Amazon Resource Name (ARN) of the recipe.</p>', 'Recipe$algorithmArn' => '<p>The Amazon Resource Name (ARN) of the algorithm that Amazon Personalize uses to train the model.</p>', 'Recipe$featureTransformationArn' => '<p>The ARN of the FeatureTransformation object.</p>', 'RecipeSummary$recipeArn' => '<p>The Amazon Resource Name (ARN) of the recipe.</p>', 'Recommender$recommenderArn' => '<p>The Amazon Resource Name (ARN) of the recommender.</p>', 'Recommender$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.</p>', 'Recommender$recipeArn' => '<p>The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created for. </p>', 'RecommenderSummary$recommenderArn' => '<p>The Amazon Resource Name (ARN) of the recommender.</p>', 'RecommenderSummary$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the Domain dataset group that contains the recommender.</p>', 'RecommenderSummary$recipeArn' => '<p>The Amazon Resource Name (ARN) of the recipe (Domain dataset group use case) that the recommender was created for.</p>', 'Solution$solutionArn' => '<p>The ARN of the solution.</p>', 'Solution$recipeArn' => '<p>The ARN of the recipe used to create the solution. This is required when <code>performAutoML</code> is false.</p>', 'Solution$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group that provides the training data.</p>', 'SolutionSummary$solutionArn' => '<p>The Amazon Resource Name (ARN) of the solution.</p>', 'SolutionSummary$recipeArn' => '<p>The Amazon Resource Name (ARN) of the recipe used by the solution.</p>', 'SolutionVersion$solutionVersionArn' => '<p>The ARN of the solution version.</p>', 'SolutionVersion$solutionArn' => '<p>The ARN of the solution.</p>', 'SolutionVersion$recipeArn' => '<p>The ARN of the recipe used in the solution.</p>', 'SolutionVersion$datasetGroupArn' => '<p>The Amazon Resource Name (ARN) of the dataset group providing the training data.</p>', 'SolutionVersionSummary$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the solution version.</p>', 'StartRecommenderRequest$recommenderArn' => '<p>The Amazon Resource Name (ARN) of the recommender to start.</p>', 'StartRecommenderResponse$recommenderArn' => '<p>The Amazon Resource Name (ARN) of the recommender you started.</p>', 'StopRecommenderRequest$recommenderArn' => '<p>The Amazon Resource Name (ARN) of the recommender to stop.</p>', 'StopRecommenderResponse$recommenderArn' => '<p>The Amazon Resource Name (ARN) of the recommender you stopped.</p>', 'StopSolutionVersionCreationRequest$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of the solution version you want to stop creating.</p>', 'TagResourceRequest$resourceArn' => '<p>The resource\'s Amazon Resource Name (ARN).</p>', 'UntagResourceRequest$resourceArn' => '<p>The resource\'s Amazon Resource Name (ARN).</p>', 'UpdateCampaignRequest$campaignArn' => '<p>The Amazon Resource Name (ARN) of the campaign.</p>', 'UpdateCampaignRequest$solutionVersionArn' => '<p>The Amazon Resource Name (ARN) of a new model to deploy. To specify the latest solution version of your solution, specify the ARN of your <i>solution</i> in <code>SolutionArn/$LATEST</code> format. You must use this format if you set <code>syncWithLatestSolutionVersion</code> to <code>True</code> in the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CampaignConfig.html">CampaignConfig</a>. </p> <p> To deploy a model that isn\'t the latest solution version of your solution, specify the ARN of the solution version. </p> <p> For more information about automatic campaign updates, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update">Enabling automatic campaign updates</a>. </p>', 'UpdateCampaignResponse$campaignArn' => '<p>The same campaign ARN as given in the request.</p>', 'UpdateDatasetRequest$datasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset that you want to update.</p>', 'UpdateDatasetRequest$schemaArn' => '<p>The Amazon Resource Name (ARN) of the new schema you want use.</p>', 'UpdateDatasetResponse$datasetArn' => '<p>The Amazon Resource Name (ARN) of the dataset you updated.</p>', 'UpdateMetricAttributionRequest$metricAttributionArn' => '<p>The Amazon Resource Name (ARN) for the metric attribution to update.</p>', 'UpdateMetricAttributionResponse$metricAttributionArn' => '<p>The Amazon Resource Name (ARN) for the metric attribution that you updated.</p>', 'UpdateRecommenderRequest$recommenderArn' => '<p>The Amazon Resource Name (ARN) of the recommender to modify.</p>', 'UpdateRecommenderResponse$recommenderArn' => '<p>The same recommender Amazon Resource Name (ARN) as given in the request.</p>', 'UpdateSolutionRequest$solutionArn' => '<p>The Amazon Resource Name (ARN) of the solution to update.</p>', 'UpdateSolutionResponse$solutionArn' => '<p>The same solution Amazon Resource Name (ARN) as given in the request.</p>', ], ], 'ArnList' => [ 'base' => NULL, 'refs' => [ 'AutoMLConfig$recipeList' => '<p>The list of candidate recipes.</p>', ], ], 'AutoMLConfig' => [ 'base' => '<p>When the solution performs AutoML (<code>performAutoML</code> is true in <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>), Amazon Personalize determines which recipe, from the specified list, optimizes the given metric. Amazon Personalize then uses that recipe for the solution.</p>', 'refs' => [ 'SolutionConfig$autoMLConfig' => '<p>The <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_AutoMLConfig.html">AutoMLConfig</a> object containing a list of recipes to search when AutoML is performed.</p>', ], ], 'AutoMLResult' => [ 'base' => '<p>When the solution performs AutoML (<code>performAutoML</code> is true in <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>), specifies the recipe that best optimized the specified metric.</p>', 'refs' => [ 'Solution$autoMLResult' => '<p>When <code>performAutoML</code> is true, specifies the best recipe found.</p>', ], ], 'AutoTrainingConfig' => [ 'base' => '<p>The automatic training configuration to use when <code>performAutoTraining</code> is true.</p>', 'refs' => [ 'SolutionConfig$autoTrainingConfig' => '<p>Specifies the automatic training configuration to use.</p>', 'SolutionUpdateConfig$autoTrainingConfig' => NULL, ], ], 'AvroSchema' => [ 'base' => NULL, 'refs' => [ 'CreateSchemaRequest$schema' => '<p>A schema in Avro JSON format.</p>', 'DatasetSchema$schema' => '<p>The schema.</p>', ], ], 'BatchInferenceJob' => [ 'base' => '<p>Contains information on a batch inference job.</p>', 'refs' => [ 'DescribeBatchInferenceJobResponse$batchInferenceJob' => '<p>Information on the specified batch inference job.</p>', ], ], 'BatchInferenceJobConfig' => [ 'base' => '<p>The configuration details of a batch inference job.</p>', 'refs' => [ 'BatchInferenceJob$batchInferenceJobConfig' => '<p>A string to string map of the configuration details of a batch inference job.</p>', 'CreateBatchInferenceJobRequest$batchInferenceJobConfig' => '<p>The configuration details of a batch inference job.</p>', ], ], 'BatchInferenceJobInput' => [ 'base' => '<p>The input configuration of a batch inference job.</p>', 'refs' => [ 'BatchInferenceJob$jobInput' => '<p>The Amazon S3 path that leads to the input data used to generate the batch inference job.</p>', 'CreateBatchInferenceJobRequest$jobInput' => '<p>The Amazon S3 path that leads to the input file to base your recommendations on. The input material must be in JSON format.</p>', ], ], 'BatchInferenceJobMode' => [ 'base' => NULL, 'refs' => [ 'BatchInferenceJob$batchInferenceJobMode' => '<p>The job\'s mode.</p>', 'BatchInferenceJobSummary$batchInferenceJobMode' => '<p>The job\'s mode.</p>', 'CreateBatchInferenceJobRequest$batchInferenceJobMode' => '<p>The mode of the batch inference job. To generate descriptive themes for groups of similar items, set the job mode to <code>THEME_GENERATION</code>. If you don\'t want to generate themes, use the default <code>BATCH_INFERENCE</code>.</p> <p> When you get batch recommendations with themes, you will incur additional costs. For more information, see <a href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>. </p>', ], ], 'BatchInferenceJobOutput' => [ 'base' => '<p>The output configuration parameters of a batch inference job.</p>', 'refs' => [ 'BatchInferenceJob$jobOutput' => '<p>The Amazon S3 bucket that contains the output data generated by the batch inference job.</p>', 'CreateBatchInferenceJobRequest$jobOutput' => '<p>The path to the Amazon S3 bucket where the job\'s output will be stored.</p>', ], ], 'BatchInferenceJobSummary' => [ 'base' => '<p>A truncated version of the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_BatchInferenceJob.html">BatchInferenceJob</a>. The <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchInferenceJobs.html">ListBatchInferenceJobs</a> operation returns a list of batch inference job summaries.</p>', 'refs' => [ 'BatchInferenceJobs$member' => NULL, ], ], 'BatchInferenceJobs' => [ 'base' => NULL, 'refs' => [ 'ListBatchInferenceJobsResponse$batchInferenceJobs' => '<p>A list containing information on each job that is returned.</p>', ], ], 'BatchSegmentJob' => [ 'base' => '<p>Contains information on a batch segment job.</p>', 'refs' => [ 'DescribeBatchSegmentJobResponse$batchSegmentJob' => '<p>Information on the specified batch segment job.</p>', ], ], 'BatchSegmentJobInput' => [ 'base' => '<p>The input configuration of a batch segment job.</p>', 'refs' => [ 'BatchSegmentJob$jobInput' => '<p>The Amazon S3 path that leads to the input data used to generate the batch segment job.</p>', 'CreateBatchSegmentJobRequest$jobInput' => '<p>The Amazon S3 path for the input data used to generate the batch segment job.</p>', ], ], 'BatchSegmentJobOutput' => [ 'base' => '<p>The output configuration parameters of a batch segment job.</p>', 'refs' => [ 'BatchSegmentJob$jobOutput' => '<p>The Amazon S3 bucket that contains the output data generated by the batch segment job.</p>', 'CreateBatchSegmentJobRequest$jobOutput' => '<p>The Amazon S3 path for the bucket where the job\'s output will be stored.</p>', ], ], 'BatchSegmentJobSummary' => [ 'base' => '<p>A truncated version of the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_BatchSegmentJob.html">BatchSegmentJob</a> datatype. <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListBatchSegmentJobs.html">ListBatchSegmentJobs</a> operation returns a list of batch segment job summaries.</p>', 'refs' => [ 'BatchSegmentJobs$member' => NULL, ], ], 'BatchSegmentJobs' => [ 'base' => NULL, 'refs' => [ 'ListBatchSegmentJobsResponse$batchSegmentJobs' => '<p>A list containing information on each job that is returned.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CampaignConfig$enableMetadataWithRecommendations' => '<p>Whether metadata with recommendations is enabled for the campaign. If enabled, you can specify the columns from your Items dataset in your request for recommendations. Amazon Personalize returns this data for each item in the recommendation response. For information about enabling metadata for a campaign, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-return-metadata">Enabling metadata in recommendations for a campaign</a>.</p> <p> If you enable metadata in recommendations, you will incur additional costs. For more information, see <a href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>. </p>', 'CampaignConfig$syncWithLatestSolutionVersion' => '<p>Whether the campaign automatically updates to use the latest solution version (trained model) of a solution. If you specify <code>True</code>, you must specify the ARN of your <i>solution</i> for the <code>SolutionVersionArn</code> parameter. It must be in <code>SolutionArn/$LATEST</code> format. The default is <code>False</code> and you must manually update the campaign to deploy the latest solution version. </p> <p> For more information about automatic campaign updates, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/campaigns.html#create-campaign-automatic-latest-sv-update">Enabling automatic campaign updates</a>. </p>', 'CreateDatasetImportJobRequest$publishAttributionMetricsToS3' => '<p>If you created a metric attribution, specify whether to publish metrics for this import job to Amazon S3</p>', 'CreateSolutionRequest$performHPO' => '<p>Whether to perform hyperparameter optimization (HPO) on the specified or selected recipe. The default is <code>false</code>.</p> <p>When performing AutoML, this parameter is always <code>true</code> and you should not set it to <code>false</code>.</p>', 'DatasetImportJob$publishAttributionMetricsToS3' => '<p>Whether the job publishes metrics to Amazon S3 for a metric attribution.</p>', 'RecommenderConfig$enableMetadataWithRecommendations' => '<p>Whether metadata with recommendations is enabled for the recommender. If enabled, you can specify the columns from your Items dataset in your request for recommendations. Amazon Personalize returns this data for each item in the recommendation response. For information about enabling metadata for a recommender, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/creating-recommenders.html#create-recommender-return-metadata">Enabling metadata in recommendations for a recommender</a>.</p> <p> If you enable metadata in recommendations, you will incur additional costs. For more information, see <a href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>. </p>', ], ], 'Campaign' => [ 'base' => '<p>An object that describes the deployment of a solution version. For more information on campaigns, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateCampaign.html">CreateCampaign</a>.</p>', 'refs' => [ 'DescribeCampaignResponse$campaign' => '<p>The properties of the campaign.</p>', ], ], 'CampaignConfig' => [ 'base' => '<p>The configuration details of a campaign.</p>', 'refs' => [ 'Campaign$campaignConfig' => '<p>The configuration details of a campaign.</p>', 'CampaignUpdateSummary$campaignConfig' => NULL, 'CreateCampaignRequest$campaignConfig' => '<p>The configuration details of a campaign.</p>', 'UpdateCampaignRequest$campaignConfig' => '<p>The configuration details of a campaign.</p>', ], ], 'CampaignSummary' => [ 'base' => '<p>Provides a summary of the properties of a campaign. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a> API.</p>', 'refs' => [ 'Campaigns$member' => NULL, ], ], 'CampaignUpdateSummary' => [ 'base' => '<p>Provides a summary of the properties of a campaign update. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeCampaign.html">DescribeCampaign</a> API.</p>', 'refs' => [ 'Campaign$latestCampaignUpdate' => NULL, ], ], 'Campaigns' => [ 'base' => NULL, 'refs' => [ 'ListCampaignsResponse$campaigns' => '<p>A list of the campaigns.</p>', ], ], 'CategoricalHyperParameterRange' => [ 'base' => '<p>Provides the name and range of a categorical hyperparameter.</p>', 'refs' => [ 'CategoricalHyperParameterRanges$member' => NULL, ], ], 'CategoricalHyperParameterRanges' => [ 'base' => NULL, 'refs' => [ 'HyperParameterRanges$categoricalHyperParameterRanges' => '<p>The categorical hyperparameters and their ranges.</p>', ], ], 'CategoricalValue' => [ 'base' => NULL, 'refs' => [ 'CategoricalValues$member' => NULL, ], ], 'CategoricalValues' => [ 'base' => NULL, 'refs' => [ 'CategoricalHyperParameterRange$values' => '<p>A list of the categories for the hyperparameter.</p>', 'DefaultCategoricalHyperParameterRange$values' => '<p>A list of the categories for the hyperparameter.</p>', ], ], 'ColumnName' => [ 'base' => NULL, 'refs' => [ 'ColumnNamesList$member' => NULL, 'FieldsForThemeGeneration$itemName' => '<p>The name of the Items dataset column that stores the name of each item in the dataset.</p>', ], ], 'ColumnNamesList' => [ 'base' => NULL, 'refs' => [ 'ExcludedDatasetColumns$value' => NULL, ], ], 'ContinuousHyperParameterRange' => [ 'base' => '<p>Provides the name and range of a continuous hyperparameter.</p>', 'refs' => [ 'ContinuousHyperParameterRanges$member' => NULL, ], ], 'ContinuousHyperParameterRanges' => [ 'base' => NULL, 'refs' => [ 'HyperParameterRanges$continuousHyperParameterRanges' => '<p>The continuous hyperparameters and their ranges.</p>', ], ], 'ContinuousMaxValue' => [ 'base' => NULL, 'refs' => [ 'ContinuousHyperParameterRange$maxValue' => '<p>The maximum allowable value for the hyperparameter.</p>', 'DefaultContinuousHyperParameterRange$maxValue' => '<p>The maximum allowable value for the hyperparameter.</p>', ], ], 'ContinuousMinValue' => [ 'base' => NULL, 'refs' => [ 'ContinuousHyperParameterRange$minValue' => '<p>The minimum allowable value for the hyperparameter.</p>', 'DefaultContinuousHyperParameterRange$minValue' => '<p>The minimum allowable value for the hyperparameter.</p>', ], ], 'CreateBatchInferenceJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBatchInferenceJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateBatchSegmentJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateBatchSegmentJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCampaignRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCampaignResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataDeletionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDataDeletionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventTrackerRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEventTrackerResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMetricAttributionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMetricAttributionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateRecommenderRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateRecommenderResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSchemaRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSchemaResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSolutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSolutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSolutionVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSolutionVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataDeletionJob' => [ 'base' => '<p>Describes a job that deletes all references to specific users from an Amazon Personalize dataset group in batches. For information about creating a data deletion job, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/delete-records.html">Deleting users</a>.</p>', 'refs' => [ 'DescribeDataDeletionJobResponse$dataDeletionJob' => '<p>Information about the data deletion job, including the status.</p> <p>The status is one of the following values:</p> <ul> <li> <p>PENDING</p> </li> <li> <p>IN_PROGRESS</p> </li> <li> <p>COMPLETED</p> </li> <li> <p>FAILED</p> </li> </ul>', ], ], 'DataDeletionJobSummary' => [ 'base' => '<p>Provides a summary of the properties of a data deletion job. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataDeletionJob.html">DescribeDataDeletionJob</a> API operation.</p>', 'refs' => [ 'DataDeletionJobs$member' => NULL, ], ], 'DataDeletionJobs' => [ 'base' => NULL, 'refs' => [ 'ListDataDeletionJobsResponse$dataDeletionJobs' => '<p>The list of data deletion jobs.</p>', ], ], 'DataSource' => [ 'base' => '<p>Describes the data source that contains the data to upload to a dataset, or the list of records to delete from Amazon Personalize.</p>', 'refs' => [ 'CreateDataDeletionJobRequest$dataSource' => '<p>The Amazon S3 bucket that contains the list of userIds of the users to delete.</p>', 'CreateDatasetImportJobRequest$dataSource' => '<p>The Amazon S3 bucket that contains the training data to import.</p>', 'DataDeletionJob$dataSource' => NULL, 'DatasetImportJob$dataSource' => '<p>The Amazon S3 bucket that contains the training data to import.</p>', ], ], 'Dataset' => [ 'base' => '<p>Provides metadata for a dataset.</p>', 'refs' => [ 'DescribeDatasetResponse$dataset' => '<p>A listing of the dataset\'s properties.</p>', ], ], 'DatasetExportJob' => [ 'base' => '<p>Describes a job that exports a dataset to an Amazon S3 bucket. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetExportJob.html">CreateDatasetExportJob</a>.</p> <p>A dataset export job can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> </ul>', 'refs' => [ 'DescribeDatasetExportJobResponse$datasetExportJob' => '<p>Information about the dataset export job, including the status.</p> <p>The status is one of the following values:</p> <ul> <li> <p>CREATE PENDING</p> </li> <li> <p>CREATE IN_PROGRESS</p> </li> <li> <p>ACTIVE</p> </li> <li> <p>CREATE FAILED</p> </li> </ul>', ], ], 'DatasetExportJobOutput' => [ 'base' => '<p>The output configuration parameters of a dataset export job.</p>', 'refs' => [ 'CreateDatasetExportJobRequest$jobOutput' => '<p>The path to the Amazon S3 bucket where the job\'s output is stored.</p>', 'DatasetExportJob$jobOutput' => '<p>The path to the Amazon S3 bucket where the job\'s output is stored. For example:</p> <p> <code>s3://bucket-name/folder-name/</code> </p>', ], ], 'DatasetExportJobSummary' => [ 'base' => '<p>Provides a summary of the properties of a dataset export job. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetExportJob.html">DescribeDatasetExportJob</a> API.</p>', 'refs' => [ 'DatasetExportJobs$member' => NULL, ], ], 'DatasetExportJobs' => [ 'base' => NULL, 'refs' => [ 'ListDatasetExportJobsResponse$datasetExportJobs' => '<p>The list of dataset export jobs.</p>', ], ], 'DatasetGroup' => [ 'base' => '<p>A dataset group is a collection of related datasets (Item interactions, Users, Items, Actions, Action interactions). You create a dataset group by calling <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html">CreateDatasetGroup</a>. You then create a dataset and add it to a dataset group by calling <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDataset.html">CreateDataset</a>. The dataset group is used to create and train a solution by calling <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a>. A dataset group can contain only one of each type of dataset.</p> <p>You can specify an Key Management Service (KMS) key to encrypt the datasets in the group.</p>', 'refs' => [ 'DescribeDatasetGroupResponse$datasetGroup' => '<p>A listing of the dataset group\'s properties.</p>', ], ], 'DatasetGroupSummary' => [ 'base' => '<p>Provides a summary of the properties of a dataset group. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetGroup.html">DescribeDatasetGroup</a> API.</p>', 'refs' => [ 'DatasetGroups$member' => NULL, ], ], 'DatasetGroups' => [ 'base' => NULL, 'refs' => [ 'ListDatasetGroupsResponse$datasetGroups' => '<p>The list of your dataset groups.</p>', ], ], 'DatasetImportJob' => [ 'base' => '<p>Describes a job that imports training data from a data source (Amazon S3 bucket) to an Amazon Personalize dataset. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetImportJob.html">CreateDatasetImportJob</a>.</p> <p>A dataset import job can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> </ul>', 'refs' => [ 'DescribeDatasetImportJobResponse$datasetImportJob' => '<p>Information about the dataset import job, including the status.</p> <p>The status is one of the following values:</p> <ul> <li> <p>CREATE PENDING</p> </li> <li> <p>CREATE IN_PROGRESS</p> </li> <li> <p>ACTIVE</p> </li> <li> <p>CREATE FAILED</p> </li> </ul>', ], ], 'DatasetImportJobSummary' => [ 'base' => '<p>Provides a summary of the properties of a dataset import job. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDatasetImportJob.html">DescribeDatasetImportJob</a> API.</p>', 'refs' => [ 'DatasetImportJobs$member' => NULL, ], ], 'DatasetImportJobs' => [ 'base' => NULL, 'refs' => [ 'ListDatasetImportJobsResponse$datasetImportJobs' => '<p>The list of dataset import jobs.</p>', ], ], 'DatasetSchema' => [ 'base' => '<p>Describes the schema for a dataset. For more information on schemas, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSchema.html">CreateSchema</a>.</p>', 'refs' => [ 'DescribeSchemaResponse$schema' => '<p>The requested schema.</p>', ], ], 'DatasetSchemaSummary' => [ 'base' => '<p>Provides a summary of the properties of a dataset schema. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSchema.html">DescribeSchema</a> API.</p>', 'refs' => [ 'Schemas$member' => NULL, ], ], 'DatasetSummary' => [ 'base' => '<p>Provides a summary of the properties of a dataset. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeDataset.html">DescribeDataset</a> API.</p>', 'refs' => [ 'Datasets$member' => NULL, ], ], 'DatasetType' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetRequest$datasetType' => '<p>The type of dataset.</p> <p>One of the following (case insensitive) values:</p> <ul> <li> <p>Interactions</p> </li> <li> <p>Items</p> </li> <li> <p>Users</p> </li> <li> <p>Actions</p> </li> <li> <p>Action_Interactions</p> </li> </ul>', 'Dataset$datasetType' => '<p>One of the following values:</p> <ul> <li> <p>Interactions</p> </li> <li> <p>Items</p> </li> <li> <p>Users</p> </li> <li> <p>Actions</p> </li> <li> <p>Action_Interactions</p> </li> </ul>', 'DatasetSummary$datasetType' => '<p>The dataset type. One of the following values:</p> <ul> <li> <p>Interactions</p> </li> <li> <p>Items</p> </li> <li> <p>Users</p> </li> <li> <p>Event-Interactions</p> </li> </ul>', 'ExcludedDatasetColumns$key' => NULL, ], ], 'DatasetUpdateSummary' => [ 'base' => '<p>Describes an update to a dataset.</p>', 'refs' => [ 'Dataset$latestDatasetUpdate' => '<p>Describes the latest update to the dataset.</p>', ], ], 'Datasets' => [ 'base' => NULL, 'refs' => [ 'ListDatasetsResponse$datasets' => '<p>An array of <code>Dataset</code> objects. Each object provides metadata information.</p>', ], ], 'Date' => [ 'base' => NULL, 'refs' => [ 'Algorithm$creationDateTime' => '<p>The date and time (in Unix time) that the algorithm was created.</p>', 'Algorithm$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the algorithm was last updated.</p>', 'BatchInferenceJob$creationDateTime' => '<p>The time at which the batch inference job was created.</p>', 'BatchInferenceJob$lastUpdatedDateTime' => '<p>The time at which the batch inference job was last updated.</p>', 'BatchInferenceJobSummary$creationDateTime' => '<p>The time at which the batch inference job was created.</p>', 'BatchInferenceJobSummary$lastUpdatedDateTime' => '<p>The time at which the batch inference job was last updated.</p>', 'BatchSegmentJob$creationDateTime' => '<p>The time at which the batch segment job was created.</p>', 'BatchSegmentJob$lastUpdatedDateTime' => '<p>The time at which the batch segment job last updated.</p>', 'BatchSegmentJobSummary$creationDateTime' => '<p>The time at which the batch segment job was created.</p>', 'BatchSegmentJobSummary$lastUpdatedDateTime' => '<p>The time at which the batch segment job was last updated.</p>', 'Campaign$creationDateTime' => '<p>The date and time (in Unix format) that the campaign was created.</p>', 'Campaign$lastUpdatedDateTime' => '<p>The date and time (in Unix format) that the campaign was last updated.</p>', 'CampaignSummary$creationDateTime' => '<p>The date and time (in Unix time) that the campaign was created.</p>', 'CampaignSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the campaign was last updated.</p>', 'CampaignUpdateSummary$creationDateTime' => '<p>The date and time (in Unix time) that the campaign update was created.</p>', 'CampaignUpdateSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the campaign update was last updated.</p>', 'DataDeletionJob$creationDateTime' => '<p>The creation date and time (in Unix time) of the data deletion job.</p>', 'DataDeletionJob$lastUpdatedDateTime' => '<p>The date and time (in Unix time) the data deletion job was last updated.</p>', 'DataDeletionJobSummary$creationDateTime' => '<p>The creation date and time (in Unix time) of the data deletion job.</p>', 'DataDeletionJobSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) the data deletion job was last updated.</p>', 'Dataset$creationDateTime' => '<p>The creation date and time (in Unix time) of the dataset.</p>', 'Dataset$lastUpdatedDateTime' => '<p>A time stamp that shows when the dataset was updated.</p>', 'DatasetExportJob$creationDateTime' => '<p>The creation date and time (in Unix time) of the dataset export job.</p>', 'DatasetExportJob$lastUpdatedDateTime' => '<p>The date and time (in Unix time) the status of the dataset export job was last updated.</p>', 'DatasetExportJobSummary$creationDateTime' => '<p>The date and time (in Unix time) that the dataset export job was created.</p>', 'DatasetExportJobSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the dataset export job status was last updated.</p>', 'DatasetGroup$creationDateTime' => '<p>The creation date and time (in Unix time) of the dataset group.</p>', 'DatasetGroup$lastUpdatedDateTime' => '<p>The last update date and time (in Unix time) of the dataset group.</p>', 'DatasetGroupSummary$creationDateTime' => '<p>The date and time (in Unix time) that the dataset group was created.</p>', 'DatasetGroupSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the dataset group was last updated.</p>', 'DatasetImportJob$creationDateTime' => '<p>The creation date and time (in Unix time) of the dataset import job.</p>', 'DatasetImportJob$lastUpdatedDateTime' => '<p>The date and time (in Unix time) the dataset was last updated.</p>', 'DatasetImportJobSummary$creationDateTime' => '<p>The date and time (in Unix time) that the dataset import job was created.</p>', 'DatasetImportJobSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the dataset import job status was last updated.</p>', 'DatasetSchema$creationDateTime' => '<p>The date and time (in Unix time) that the schema was created.</p>', 'DatasetSchema$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the schema was last updated.</p>', 'DatasetSchemaSummary$creationDateTime' => '<p>The date and time (in Unix time) that the schema was created.</p>', 'DatasetSchemaSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the schema was last updated.</p>', 'DatasetSummary$creationDateTime' => '<p>The date and time (in Unix time) that the dataset was created.</p>', 'DatasetSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the dataset was last updated.</p>', 'DatasetUpdateSummary$creationDateTime' => '<p>The creation date and time (in Unix time) of the dataset update.</p>', 'DatasetUpdateSummary$lastUpdatedDateTime' => '<p>The last update date and time (in Unix time) of the dataset.</p>', 'EventTracker$creationDateTime' => '<p>The date and time (in Unix format) that the event tracker was created.</p>', 'EventTracker$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the event tracker was last updated.</p>', 'EventTrackerSummary$creationDateTime' => '<p>The date and time (in Unix time) that the event tracker was created.</p>', 'EventTrackerSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the event tracker was last updated.</p>', 'FeatureTransformation$creationDateTime' => '<p>The creation date and time (in Unix time) of the feature transformation.</p>', 'FeatureTransformation$lastUpdatedDateTime' => '<p>The last update date and time (in Unix time) of the feature transformation.</p>', 'Filter$creationDateTime' => '<p>The time at which the filter was created.</p>', 'Filter$lastUpdatedDateTime' => '<p>The time at which the filter was last updated.</p>', 'FilterSummary$creationDateTime' => '<p>The time at which the filter was created.</p>', 'FilterSummary$lastUpdatedDateTime' => '<p>The time at which the filter was last updated.</p>', 'MetricAttribution$creationDateTime' => '<p>The metric attribution\'s creation date time.</p>', 'MetricAttribution$lastUpdatedDateTime' => '<p>The metric attribution\'s last updated date time.</p>', 'MetricAttributionSummary$creationDateTime' => '<p>The metric attribution\'s creation date time.</p>', 'MetricAttributionSummary$lastUpdatedDateTime' => '<p>The metric attribution\'s last updated date time.</p>', 'Recipe$creationDateTime' => '<p>The date and time (in Unix format) that the recipe was created.</p>', 'Recipe$lastUpdatedDateTime' => '<p>The date and time (in Unix format) that the recipe was last updated.</p>', 'RecipeSummary$creationDateTime' => '<p>The date and time (in Unix time) that the recipe was created.</p>', 'RecipeSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the recipe was last updated.</p>', 'Recommender$creationDateTime' => '<p>The date and time (in Unix format) that the recommender was created.</p>', 'Recommender$lastUpdatedDateTime' => '<p>The date and time (in Unix format) that the recommender was last updated.</p>', 'RecommenderSummary$creationDateTime' => '<p>The date and time (in Unix format) that the recommender was created.</p>', 'RecommenderSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix format) that the recommender was last updated.</p>', 'RecommenderUpdateSummary$creationDateTime' => '<p>The date and time (in Unix format) that the recommender update was created.</p>', 'RecommenderUpdateSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the recommender update was last updated.</p>', 'Solution$creationDateTime' => '<p>The creation date and time (in Unix time) of the solution.</p>', 'Solution$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the solution was last updated.</p>', 'SolutionSummary$creationDateTime' => '<p>The date and time (in Unix time) that the solution was created.</p>', 'SolutionSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the solution was last updated.</p>', 'SolutionUpdateSummary$creationDateTime' => '<p>The date and time (in Unix format) that the solution update was created.</p>', 'SolutionUpdateSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the solution update was last updated.</p>', 'SolutionVersion$creationDateTime' => '<p>The date and time (in Unix time) that this version of the solution was created.</p>', 'SolutionVersion$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the solution was last updated.</p>', 'SolutionVersionSummary$creationDateTime' => '<p>The date and time (in Unix time) that this version of a solution was created.</p>', 'SolutionVersionSummary$lastUpdatedDateTime' => '<p>The date and time (in Unix time) that the solution version was last updated.</p>', ], ], 'DefaultCategoricalHyperParameterRange' => [ 'base' => '<p>Provides the name and default range of a categorical hyperparameter and whether the hyperparameter is tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).</p>', 'refs' => [ 'DefaultCategoricalHyperParameterRanges$member' => NULL, ], ], 'DefaultCategoricalHyperParameterRanges' => [ 'base' => NULL, 'refs' => [ 'DefaultHyperParameterRanges$categoricalHyperParameterRanges' => '<p>The categorical hyperparameters and their default ranges.</p>', ], ], 'DefaultContinuousHyperParameterRange' => [ 'base' => '<p>Provides the name and default range of a continuous hyperparameter and whether the hyperparameter is tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).</p>', 'refs' => [ 'DefaultContinuousHyperParameterRanges$member' => NULL, ], ], 'DefaultContinuousHyperParameterRanges' => [ 'base' => NULL, 'refs' => [ 'DefaultHyperParameterRanges$continuousHyperParameterRanges' => '<p>The continuous hyperparameters and their default ranges.</p>', ], ], 'DefaultHyperParameterRanges' => [ 'base' => '<p>Specifies the hyperparameters and their default ranges. Hyperparameters can be categorical, continuous, or integer-valued.</p>', 'refs' => [ 'Algorithm$defaultHyperParameterRanges' => '<p>Specifies the default hyperparameters, their ranges, and whether they are tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).</p>', ], ], 'DefaultIntegerHyperParameterRange' => [ 'base' => '<p>Provides the name and default range of a integer-valued hyperparameter and whether the hyperparameter is tunable. A tunable hyperparameter can have its value determined during hyperparameter optimization (HPO).</p>', 'refs' => [ 'DefaultIntegerHyperParameterRanges$member' => NULL, ], ], 'DefaultIntegerHyperParameterRanges' => [ 'base' => NULL, 'refs' => [ 'DefaultHyperParameterRanges$integerHyperParameterRanges' => '<p>The integer-valued hyperparameters and their default ranges.</p>', ], ], 'DeleteCampaignRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDatasetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEventTrackerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMetricAttributionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteRecommenderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSchemaRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSolutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlgorithmRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeAlgorithmResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBatchInferenceJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBatchInferenceJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBatchSegmentJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeBatchSegmentJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCampaignRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeCampaignResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataDeletionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDataDeletionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetExportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetExportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetGroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetGroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetImportJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetImportJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventTrackerRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeEventTrackerResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeatureTransformationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFeatureTransformationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMetricAttributionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeMetricAttributionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecommenderRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeRecommenderResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSchemaRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSchemaResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSolutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSolutionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSolutionVersionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeSolutionVersionResponse' => [ 'base' => NULL, 'refs' => [], ], 'Description' => [ 'base' => NULL, 'refs' => [ 'Recipe$description' => '<p>The description of the recipe.</p>', ], ], 'DockerURI' => [ 'base' => NULL, 'refs' => [ 'AlgorithmImage$dockerURI' => '<p>The URI of the Docker container for the algorithm image.</p>', ], ], 'Domain' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetGroupRequest$domain' => '<p>The domain of the dataset group. Specify a domain to create a Domain dataset group. The domain you specify determines the default schemas for datasets and the use cases available for recommenders. If you don\'t specify a domain, you create a Custom dataset group with solution versions that you deploy with a campaign. </p>', 'CreateDatasetGroupResponse$domain' => '<p>The domain for the new Domain dataset group.</p>', 'CreateSchemaRequest$domain' => '<p>The domain for the schema. If you are creating a schema for a dataset in a Domain dataset group, specify the domain you chose when you created the Domain dataset group.</p>', 'DatasetGroup$domain' => '<p>The domain of a Domain dataset group.</p>', 'DatasetGroupSummary$domain' => '<p>The domain of a Domain dataset group.</p>', 'DatasetSchema$domain' => '<p>The domain of a schema that you created for a dataset in a Domain dataset group.</p>', 'DatasetSchemaSummary$domain' => '<p>The domain of a schema that you created for a dataset in a Domain dataset group.</p>', 'ListRecipesRequest$domain' => '<p> Filters returned recipes by domain for a Domain dataset group. Only recipes (Domain dataset group use cases) for this domain are included in the response. If you don\'t specify a domain, all recipes are returned. </p>', 'RecipeSummary$domain' => '<p>The domain of the recipe (if the recipe is a Domain dataset group use case).</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'InvalidInputException$message' => NULL, 'InvalidNextTokenException$message' => NULL, 'LimitExceededException$message' => NULL, 'ResourceAlreadyExistsException$message' => NULL, 'ResourceInUseException$message' => NULL, 'ResourceNotFoundException$message' => NULL, 'TooManyTagKeysException$message' => NULL, 'TooManyTagsException$message' => NULL, ], ], 'EventTracker' => [ 'base' => '<p>Provides information about an event tracker.</p>', 'refs' => [ 'DescribeEventTrackerResponse$eventTracker' => '<p>An object that describes the event tracker.</p>', ], ], 'EventTrackerSummary' => [ 'base' => '<p>Provides a summary of the properties of an event tracker. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeEventTracker.html">DescribeEventTracker</a> API.</p>', 'refs' => [ 'EventTrackers$member' => NULL, ], ], 'EventTrackers' => [ 'base' => NULL, 'refs' => [ 'ListEventTrackersResponse$eventTrackers' => '<p>A list of event trackers.</p>', ], ], 'EventType' => [ 'base' => NULL, 'refs' => [ 'CreateSolutionRequest$eventType' => '<p>When your have multiple event types (using an <code>EVENT_TYPE</code> schema field), this parameter specifies which event type (for example, \'click\' or \'like\') is used for training the model.</p> <p>If you do not provide an <code>eventType</code>, Amazon Personalize will use all interactions for training with equal weight regardless of type.</p>', 'MetricAttribute$eventType' => '<p>The metric\'s event type.</p>', 'Solution$eventType' => '<p>The event type (for example, \'click\' or \'like\') that is used for training the model. If no <code>eventType</code> is provided, Amazon Personalize uses all interactions for training with equal weight regardless of type.</p>', 'SolutionVersion$eventType' => '<p>The event type (for example, \'click\' or \'like\') that is used for training the model.</p>', ], ], 'EventValueThreshold' => [ 'base' => NULL, 'refs' => [ 'SolutionConfig$eventValueThreshold' => '<p>Only events with a value greater than or equal to this threshold are used for training a model.</p>', ], ], 'ExcludedDatasetColumns' => [ 'base' => NULL, 'refs' => [ 'TrainingDataConfig$excludedDatasetColumns' => '<p>Specifies the columns to exclude from training. Each key is a dataset type, and each value is a list of columns. Exclude columns to control what data Amazon Personalize uses to generate recommendations.</p> <p> For example, you might have a column that you want to use only to filter recommendations. You can exclude this column from training and Amazon Personalize considers it only when filtering. </p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'BatchInferenceJob$failureReason' => '<p>If the batch inference job failed, the reason for the failure.</p>', 'BatchInferenceJobSummary$failureReason' => '<p>If the batch inference job failed, the reason for the failure.</p>', 'BatchSegmentJob$failureReason' => '<p>If the batch segment job failed, the reason for the failure.</p>', 'BatchSegmentJobSummary$failureReason' => '<p>If the batch segment job failed, the reason for the failure.</p>', 'Campaign$failureReason' => '<p>If a campaign fails, the reason behind the failure.</p>', 'CampaignSummary$failureReason' => '<p>If a campaign fails, the reason behind the failure.</p>', 'CampaignUpdateSummary$failureReason' => '<p>If a campaign update fails, the reason behind the failure.</p>', 'DataDeletionJob$failureReason' => '<p>If a data deletion job fails, provides the reason why.</p>', 'DataDeletionJobSummary$failureReason' => '<p>If a data deletion job fails, provides the reason why.</p>', 'DatasetExportJob$failureReason' => '<p>If a dataset export job fails, provides the reason why.</p>', 'DatasetExportJobSummary$failureReason' => '<p>If a dataset export job fails, the reason behind the failure.</p>', 'DatasetGroup$failureReason' => '<p>If creating a dataset group fails, provides the reason why.</p>', 'DatasetGroupSummary$failureReason' => '<p>If creating a dataset group fails, the reason behind the failure.</p>', 'DatasetImportJob$failureReason' => '<p>If a dataset import job fails, provides the reason why.</p>', 'DatasetImportJobSummary$failureReason' => '<p>If a dataset import job fails, the reason behind the failure.</p>', 'DatasetUpdateSummary$failureReason' => '<p>If updating a dataset fails, provides the reason why.</p>', 'Filter$failureReason' => '<p>If the filter failed, the reason for its failure.</p>', 'FilterSummary$failureReason' => '<p>If the filter failed, the reason for the failure.</p>', 'MetricAttribution$failureReason' => '<p>The metric attribution\'s failure reason.</p>', 'MetricAttributionSummary$failureReason' => '<p>The metric attribution\'s failure reason.</p>', 'Recommender$failureReason' => '<p>If a recommender fails, the reason behind the failure.</p>', 'RecommenderUpdateSummary$failureReason' => '<p>If a recommender update fails, the reason behind the failure.</p>', 'SolutionUpdateSummary$failureReason' => '<p>If a solution update fails, the reason behind the failure.</p>', 'SolutionVersion$failureReason' => '<p>If training a solution version fails, the reason for the failure.</p>', 'SolutionVersionSummary$failureReason' => '<p>If a solution version fails, the reason behind the failure.</p>', ], ], 'FeatureTransformation' => [ 'base' => '<p>Provides feature transformation information. Feature transformation is the process of modifying raw input data into a form more suitable for model training.</p>', 'refs' => [ 'DescribeFeatureTransformationResponse$featureTransformation' => '<p>A listing of the FeatureTransformation properties.</p>', ], ], 'FeatureTransformationParameters' => [ 'base' => NULL, 'refs' => [ 'SolutionConfig$featureTransformationParameters' => '<p>Lists the feature transformation parameters.</p>', ], ], 'FeaturizationParameters' => [ 'base' => NULL, 'refs' => [ 'FeatureTransformation$defaultParameters' => '<p>Provides the default parameters for feature transformation.</p>', ], ], 'FieldsForThemeGeneration' => [ 'base' => '<p>A string to string map of the configuration details for theme generation.</p>', 'refs' => [ 'ThemeGenerationConfig$fieldsForThemeGeneration' => '<p>Fields used to generate descriptive themes for a batch inference job.</p>', ], ], 'Filter' => [ 'base' => '<p>Contains information on a recommendation filter, including its ARN, status, and filter expression.</p>', 'refs' => [ 'DescribeFilterResponse$filter' => '<p>The filter\'s details.</p>', ], ], 'FilterExpression' => [ 'base' => NULL, 'refs' => [ 'CreateFilterRequest$filterExpression' => '<p>The filter expression defines which items are included or excluded from recommendations. Filter expression must follow specific format rules. For information about filter expression structure and syntax, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter-expressions.html">Filter expressions</a>.</p>', 'Filter$filterExpression' => '<p>Specifies the type of item interactions to filter out of recommendation results. The filter expression must follow specific format rules. For information about filter expression structure and syntax, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/filter-expressions.html">Filter expressions</a>.</p>', ], ], 'FilterSummary' => [ 'base' => '<p>A short summary of a filter\'s attributes.</p>', 'refs' => [ 'Filters$member' => NULL, ], ], 'Filters' => [ 'base' => NULL, 'refs' => [ 'ListFiltersResponse$Filters' => '<p>A list of returned filters.</p>', ], ], 'GetSolutionMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSolutionMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'HPOConfig' => [ 'base' => '<p>Describes the properties for hyperparameter optimization (HPO).</p>', 'refs' => [ 'SolutionConfig$hpoConfig' => '<p>Describes the properties for hyperparameter optimization (HPO).</p>', ], ], 'HPOObjective' => [ 'base' => '<p>The metric to optimize during hyperparameter optimization (HPO).</p> <note> <p>Amazon Personalize doesn\'t support configuring the <code>hpoObjective</code> at this time.</p> </note>', 'refs' => [ 'HPOConfig$hpoObjective' => '<p>The metric to optimize during HPO.</p> <note> <p>Amazon Personalize doesn\'t support configuring the <code>hpoObjective</code> at this time.</p> </note>', ], ], 'HPOObjectiveType' => [ 'base' => NULL, 'refs' => [ 'HPOObjective$type' => '<p>The type of the metric. Valid values are <code>Maximize</code> and <code>Minimize</code>.</p>', ], ], 'HPOResource' => [ 'base' => NULL, 'refs' => [ 'HPOResourceConfig$maxNumberOfTrainingJobs' => '<p>The maximum number of training jobs when you create a solution version. The maximum value for <code>maxNumberOfTrainingJobs</code> is <code>40</code>.</p>', 'HPOResourceConfig$maxParallelTrainingJobs' => '<p>The maximum number of parallel training jobs when you create a solution version. The maximum value for <code>maxParallelTrainingJobs</code> is <code>10</code>.</p>', ], ], 'HPOResourceConfig' => [ 'base' => '<p>Describes the resource configuration for hyperparameter optimization (HPO).</p>', 'refs' => [ 'HPOConfig$hpoResourceConfig' => '<p>Describes the resource configuration for HPO.</p>', ], ], 'HyperParameterRanges' => [ 'base' => '<p>Specifies the hyperparameters and their ranges. Hyperparameters can be categorical, continuous, or integer-valued.</p>', 'refs' => [ 'HPOConfig$algorithmHyperParameterRanges' => '<p>The hyperparameters and their allowable ranges.</p>', ], ], 'HyperParameters' => [ 'base' => NULL, 'refs' => [ 'Algorithm$defaultHyperParameters' => '<p>Specifies the default hyperparameters.</p>', 'BatchInferenceJobConfig$itemExplorationConfig' => '<p>A string to string map specifying the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. See <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a>.</p>', 'CampaignConfig$itemExplorationConfig' => '<p>Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your solution uses the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a> recipe.</p>', 'RecommenderConfig$itemExplorationConfig' => '<p>Specifies the exploration configuration hyperparameters, including <code>explorationWeight</code> and <code>explorationItemAgeCutOff</code>, you want to use to configure the amount of item exploration Amazon Personalize uses when recommending items. Provide <code>itemExplorationConfig</code> data only if your recommenders generate personalized recommendations for a user (not popular items or similar items).</p>', 'SolutionConfig$algorithmHyperParameters' => '<p>Lists the algorithm hyperparameters and their values.</p>', 'TunedHPOParams$algorithmHyperParameters' => '<p>A list of the hyperparameter values of the best performing model.</p>', ], ], 'ImportMode' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetImportJobRequest$importMode' => '<p>Specify how to add the new records to an existing dataset. The default import mode is <code>FULL</code>. If you haven\'t imported bulk records into the dataset previously, you can only specify <code>FULL</code>.</p> <ul> <li> <p>Specify <code>FULL</code> to overwrite all existing bulk data in your dataset. Data you imported individually is not replaced.</p> </li> <li> <p>Specify <code>INCREMENTAL</code> to append the new records to the existing data in your dataset. Amazon Personalize replaces any record with the same ID with the new one.</p> </li> </ul>', 'DatasetImportJob$importMode' => '<p>The import mode used by the dataset import job to import new records.</p>', 'DatasetImportJobSummary$importMode' => '<p>The import mode the dataset import job used to update the data in the dataset. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/updating-existing-bulk-data.html">Updating existing bulk data</a>. </p>', ], ], 'IngestionMode' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetExportJobRequest$ingestionMode' => '<p>The data to export, based on how you imported the data. You can choose to export only <code>BULK</code> data that you imported using a dataset import job, only <code>PUT</code> data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The default value is <code>PUT</code>. </p>', 'DatasetExportJob$ingestionMode' => '<p>The data to export, based on how you imported the data. You can choose to export <code>BULK</code> data that you imported using a dataset import job, <code>PUT</code> data that you imported incrementally (using the console, PutEvents, PutUsers and PutItems operations), or <code>ALL</code> for both types. The default value is <code>PUT</code>. </p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'DataDeletionJob$numDeleted' => '<p>The number of records deleted by a COMPLETED job.</p>', ], ], 'IntegerHyperParameterRange' => [ 'base' => '<p>Provides the name and range of an integer-valued hyperparameter.</p>', 'refs' => [ 'IntegerHyperParameterRanges$member' => NULL, ], ], 'IntegerHyperParameterRanges' => [ 'base' => NULL, 'refs' => [ 'HyperParameterRanges$integerHyperParameterRanges' => '<p>The integer-valued hyperparameters and their ranges.</p>', ], ], 'IntegerMaxValue' => [ 'base' => NULL, 'refs' => [ 'DefaultIntegerHyperParameterRange$maxValue' => '<p>The maximum allowable value for the hyperparameter.</p>', 'IntegerHyperParameterRange$maxValue' => '<p>The maximum allowable value for the hyperparameter.</p>', ], ], 'IntegerMinValue' => [ 'base' => NULL, 'refs' => [ 'DefaultIntegerHyperParameterRange$minValue' => '<p>The minimum allowable value for the hyperparameter.</p>', 'IntegerHyperParameterRange$minValue' => '<p>The minimum allowable value for the hyperparameter.</p>', ], ], 'InvalidInputException' => [ 'base' => '<p>Provide a valid value for the field or parameter.</p>', 'refs' => [], ], 'InvalidNextTokenException' => [ 'base' => '<p>The token is not valid.</p>', 'refs' => [], ], 'ItemAttribute' => [ 'base' => NULL, 'refs' => [ 'OptimizationObjective$itemAttribute' => '<p>The numerical metadata column in an Items dataset related to the optimization objective. For example, VIDEO_LENGTH (to maximize streaming minutes), or PRICE (to maximize revenue).</p>', ], ], 'KmsKeyArn' => [ 'base' => NULL, 'refs' => [ 'CreateDatasetGroupRequest$kmsKeyArn' => '<p>The Amazon Resource Name (ARN) of a Key Management Service (KMS) key used to encrypt the datasets.</p>', 'DatasetGroup$kmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key used to encrypt the datasets.</p>', 'S3DataConfig$kmsKeyArn' => '<p>The Amazon Resource Name (ARN) of the Key Management Service (KMS) key that Amazon Personalize uses to encrypt or decrypt the input and output files.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>The limit on the number of requests per second has been exceeded.</p>', 'refs' => [], ], 'ListBatchInferenceJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBatchInferenceJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListBatchSegmentJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListBatchSegmentJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCampaignsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCampaignsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDataDeletionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDataDeletionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetExportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetExportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetGroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetGroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetImportJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetImportJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListDatasetsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEventTrackersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEventTrackersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListFiltersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListFiltersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMetricAttributionMetricsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMetricAttributionMetricsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMetricAttributionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMetricAttributionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecipesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecipesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecommendersResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSchemasRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSchemasResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSolutionVersionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSolutionVersionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSolutionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSolutionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListBatchInferenceJobsRequest$maxResults' => '<p>The maximum number of batch inference job results to return in each page. The default value is 100.</p>', 'ListBatchSegmentJobsRequest$maxResults' => '<p>The maximum number of batch segment job results to return in each page. The default value is 100.</p>', 'ListCampaignsRequest$maxResults' => '<p>The maximum number of campaigns to return.</p>', 'ListDataDeletionJobsRequest$maxResults' => '<p>The maximum number of data deletion jobs to return.</p>', 'ListDatasetExportJobsRequest$maxResults' => '<p>The maximum number of dataset export jobs to return.</p>', 'ListDatasetGroupsRequest$maxResults' => '<p>The maximum number of dataset groups to return.</p>', 'ListDatasetImportJobsRequest$maxResults' => '<p>The maximum number of dataset import jobs to return.</p>', 'ListDatasetsRequest$maxResults' => '<p>The maximum number of datasets to return.</p>', 'ListEventTrackersRequest$maxResults' => '<p>The maximum number of event trackers to return.</p>', 'ListFiltersRequest$maxResults' => '<p>The maximum number of filters to return.</p>', 'ListMetricAttributionMetricsRequest$maxResults' => '<p>The maximum number of metrics to return in one page of results.</p>', 'ListMetricAttributionsRequest$maxResults' => '<p>The maximum number of metric attributions to return in one page of results.</p>', 'ListRecipesRequest$maxResults' => '<p>The maximum number of recipes to return.</p>', 'ListRecommendersRequest$maxResults' => '<p>The maximum number of recommenders to return.</p>', 'ListSchemasRequest$maxResults' => '<p>The maximum number of schemas to return.</p>', 'ListSolutionVersionsRequest$maxResults' => '<p>The maximum number of solution versions to return.</p>', 'ListSolutionsRequest$maxResults' => '<p>The maximum number of solutions to return.</p>', ], ], 'MetricAttribute' => [ 'base' => '<p>Contains information on a metric that a metric attribution reports on. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html">Measuring impact of recommendations</a>.</p>', 'refs' => [ 'MetricAttributes$member' => NULL, ], ], 'MetricAttributes' => [ 'base' => NULL, 'refs' => [ 'CreateMetricAttributionRequest$metrics' => '<p>A list of metric attributes for the metric attribution. Each metric attribute specifies an event type to track and a function. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>. For SUM() functions, provide the dataset type (either Interactions or Items) and column to sum as a parameter. For example SUM(Items.PRICE).</p>', 'ListMetricAttributionMetricsResponse$metrics' => '<p>The metrics for the specified metric attribution.</p>', 'UpdateMetricAttributionRequest$addMetrics' => '<p>Add new metric attributes to the metric attribution.</p>', ], ], 'MetricAttributesNamesList' => [ 'base' => NULL, 'refs' => [ 'UpdateMetricAttributionRequest$removeMetrics' => '<p>Remove metric attributes from the metric attribution.</p>', ], ], 'MetricAttribution' => [ 'base' => '<p>Contains information on a metric attribution. A metric attribution creates reports on the data that you import into Amazon Personalize. Depending on how you import the data, you can view reports in Amazon CloudWatch or Amazon S3. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html">Measuring impact of recommendations</a>.</p>', 'refs' => [ 'DescribeMetricAttributionResponse$metricAttribution' => '<p>The details of the metric attribution.</p>', ], ], 'MetricAttributionOutput' => [ 'base' => '<p>The output configuration details for a metric attribution.</p>', 'refs' => [ 'CreateMetricAttributionRequest$metricsOutputConfig' => '<p>The output configuration details for the metric attribution.</p>', 'MetricAttribution$metricsOutputConfig' => '<p>The metric attribution\'s output configuration.</p>', 'UpdateMetricAttributionRequest$metricsOutputConfig' => '<p>An output config for the metric attribution.</p>', ], ], 'MetricAttributionSummary' => [ 'base' => '<p>Provides a summary of the properties of a metric attribution. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeMetricAttribution.html">DescribeMetricAttribution</a>.</p>', 'refs' => [ 'MetricAttributions$member' => NULL, ], ], 'MetricAttributions' => [ 'base' => NULL, 'refs' => [ 'ListMetricAttributionsResponse$metricAttributions' => '<p>The list of metric attributions.</p>', ], ], 'MetricExpression' => [ 'base' => NULL, 'refs' => [ 'MetricAttribute$expression' => '<p>The attribute\'s expression. Available functions are <code>SUM()</code> or <code>SAMPLECOUNT()</code>. For SUM() functions, provide the dataset type (either Interactions or Items) and column to sum as a parameter. For example SUM(Items.PRICE).</p>', ], ], 'MetricName' => [ 'base' => NULL, 'refs' => [ 'AutoMLConfig$metricName' => '<p>The metric to optimize.</p>', 'HPOObjective$metricName' => '<p>The name of the metric.</p>', 'MetricAttribute$metricName' => '<p>The metric\'s name. The name helps you identify the metric in Amazon CloudWatch or Amazon S3.</p>', 'MetricAttributesNamesList$member' => NULL, 'Metrics$key' => NULL, ], ], 'MetricRegex' => [ 'base' => NULL, 'refs' => [ 'HPOObjective$metricRegex' => '<p>A regular expression for finding the metric in the training job logs.</p>', ], ], 'MetricValue' => [ 'base' => NULL, 'refs' => [ 'Metrics$value' => NULL, ], ], 'Metrics' => [ 'base' => NULL, 'refs' => [ 'GetSolutionMetricsResponse$metrics' => '<p>The metrics for the solution version. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/working-with-training-metrics.html"> Evaluating a solution version with metrics </a>.</p>', 'Recommender$modelMetrics' => '<p>Provides evaluation metrics that help you determine the performance of a recommender. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/evaluating-recommenders.html"> Evaluating a recommender</a>.</p>', ], ], 'Name' => [ 'base' => NULL, 'refs' => [ 'Algorithm$name' => '<p>The name of the algorithm.</p>', 'AlgorithmImage$name' => '<p>The name of the algorithm image.</p>', 'BatchInferenceJob$jobName' => '<p>The name of the batch inference job.</p>', 'BatchInferenceJobSummary$jobName' => '<p>The name of the batch inference job.</p>', 'BatchSegmentJob$jobName' => '<p>The name of the batch segment job.</p>', 'BatchSegmentJobSummary$jobName' => '<p>The name of the batch segment job.</p>', 'Campaign$name' => '<p>The name of the campaign.</p>', 'CampaignSummary$name' => '<p>The name of the campaign.</p>', 'CreateBatchInferenceJobRequest$jobName' => '<p>The name of the batch inference job to create.</p>', 'CreateBatchSegmentJobRequest$jobName' => '<p>The name of the batch segment job to create.</p>', 'CreateCampaignRequest$name' => '<p>A name for the new campaign. The campaign name must be unique within your account.</p>', 'CreateDataDeletionJobRequest$jobName' => '<p>The name for the data deletion job.</p>', 'CreateDatasetExportJobRequest$jobName' => '<p>The name for the dataset export job.</p>', 'CreateDatasetGroupRequest$name' => '<p>The name for the new dataset group.</p>', 'CreateDatasetImportJobRequest$jobName' => '<p>The name for the dataset import job.</p>', 'CreateDatasetRequest$name' => '<p>The name for the dataset.</p>', 'CreateEventTrackerRequest$name' => '<p>The name for the event tracker.</p>', 'CreateFilterRequest$name' => '<p>The name of the filter to create.</p>', 'CreateMetricAttributionRequest$name' => '<p>A name for the metric attribution.</p>', 'CreateRecommenderRequest$name' => '<p>The name of the recommender.</p>', 'CreateSchemaRequest$name' => '<p>The name for the schema.</p>', 'CreateSolutionRequest$name' => '<p>The name for the solution.</p>', 'CreateSolutionVersionRequest$name' => '<p>The name of the solution version.</p>', 'DataDeletionJob$jobName' => '<p>The name of the data deletion job.</p>', 'DataDeletionJobSummary$jobName' => '<p>The name of the data deletion job.</p>', 'Dataset$name' => '<p>The name of the dataset.</p>', 'DatasetExportJob$jobName' => '<p>The name of the export job.</p>', 'DatasetExportJobSummary$jobName' => '<p>The name of the dataset export job.</p>', 'DatasetGroup$name' => '<p>The name of the dataset group.</p>', 'DatasetGroupSummary$name' => '<p>The name of the dataset group.</p>', 'DatasetImportJob$jobName' => '<p>The name of the import job.</p>', 'DatasetImportJobSummary$jobName' => '<p>The name of the dataset import job.</p>', 'DatasetSchema$name' => '<p>The name of the schema.</p>', 'DatasetSchemaSummary$name' => '<p>The name of the schema.</p>', 'DatasetSummary$name' => '<p>The name of the dataset.</p>', 'EventTracker$name' => '<p>The name of the event tracker.</p>', 'EventTrackerSummary$name' => '<p>The name of the event tracker.</p>', 'FeatureTransformation$name' => '<p>The name of the feature transformation.</p>', 'Filter$name' => '<p>The name of the filter.</p>', 'FilterSummary$name' => '<p>The name of the filter.</p>', 'MetricAttribution$name' => '<p>The metric attribution\'s name.</p>', 'MetricAttributionSummary$name' => '<p>The name of the metric attribution.</p>', 'Recipe$name' => '<p>The name of the recipe.</p>', 'RecipeSummary$name' => '<p>The name of the recipe.</p>', 'Recommender$name' => '<p>The name of the recommender.</p>', 'RecommenderSummary$name' => '<p>The name of the recommender.</p>', 'Solution$name' => '<p>The name of the solution.</p>', 'SolutionSummary$name' => '<p>The name of the solution.</p>', 'SolutionVersion$name' => '<p>The name of the solution version.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListBatchInferenceJobsRequest$nextToken' => '<p>The token to request the next page of results.</p>', 'ListBatchInferenceJobsResponse$nextToken' => '<p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>', 'ListBatchSegmentJobsRequest$nextToken' => '<p>The token to request the next page of results.</p>', 'ListBatchSegmentJobsResponse$nextToken' => '<p>The token to use to retrieve the next page of results. The value is <code>null</code> when there are no more results to return.</p>', 'ListCampaignsRequest$nextToken' => '<p>A token returned from the previous call to <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListCampaigns.html">ListCampaigns</a> for getting the next set of campaigns (if they exist).</p>', 'ListCampaignsResponse$nextToken' => '<p>A token for getting the next set of campaigns (if they exist).</p>', 'ListDataDeletionJobsRequest$nextToken' => '<p>A token returned from the previous call to <code>ListDataDeletionJobs</code> for getting the next set of jobs (if they exist).</p>', 'ListDataDeletionJobsResponse$nextToken' => '<p>A token for getting the next set of data deletion jobs (if they exist).</p>', 'ListDatasetExportJobsRequest$nextToken' => '<p>A token returned from the previous call to <code>ListDatasetExportJobs</code> for getting the next set of dataset export jobs (if they exist).</p>', 'ListDatasetExportJobsResponse$nextToken' => '<p>A token for getting the next set of dataset export jobs (if they exist).</p>', 'ListDatasetGroupsRequest$nextToken' => '<p>A token returned from the previous call to <code>ListDatasetGroups</code> for getting the next set of dataset groups (if they exist).</p>', 'ListDatasetGroupsResponse$nextToken' => '<p>A token for getting the next set of dataset groups (if they exist).</p>', 'ListDatasetImportJobsRequest$nextToken' => '<p>A token returned from the previous call to <code>ListDatasetImportJobs</code> for getting the next set of dataset import jobs (if they exist).</p>', 'ListDatasetImportJobsResponse$nextToken' => '<p>A token for getting the next set of dataset import jobs (if they exist).</p>', 'ListDatasetsRequest$nextToken' => '<p>A token returned from the previous call to <code>ListDatasets</code> for getting the next set of dataset import jobs (if they exist).</p>', 'ListDatasetsResponse$nextToken' => '<p>A token for getting the next set of datasets (if they exist).</p>', 'ListEventTrackersRequest$nextToken' => '<p>A token returned from the previous call to <code>ListEventTrackers</code> for getting the next set of event trackers (if they exist).</p>', 'ListEventTrackersResponse$nextToken' => '<p>A token for getting the next set of event trackers (if they exist).</p>', 'ListFiltersRequest$nextToken' => '<p>A token returned from the previous call to <code>ListFilters</code> for getting the next set of filters (if they exist).</p>', 'ListFiltersResponse$nextToken' => '<p>A token for getting the next set of filters (if they exist).</p>', 'ListMetricAttributionMetricsRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListMetricAttributionMetricsResponse$nextToken' => '<p>Specify the pagination token from a previous <code>ListMetricAttributionMetricsResponse</code> request to retrieve the next page of results.</p>', 'ListMetricAttributionsRequest$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListMetricAttributionsResponse$nextToken' => '<p>Specify the pagination token from a previous request to retrieve the next page of results.</p>', 'ListRecipesRequest$nextToken' => '<p>A token returned from the previous call to <code>ListRecipes</code> for getting the next set of recipes (if they exist).</p>', 'ListRecipesResponse$nextToken' => '<p>A token for getting the next set of recipes.</p>', 'ListRecommendersRequest$nextToken' => '<p>A token returned from the previous call to <code>ListRecommenders</code> for getting the next set of recommenders (if they exist).</p>', 'ListRecommendersResponse$nextToken' => '<p>A token for getting the next set of recommenders (if they exist).</p>', 'ListSchemasRequest$nextToken' => '<p>A token returned from the previous call to <code>ListSchemas</code> for getting the next set of schemas (if they exist).</p>', 'ListSchemasResponse$nextToken' => '<p>A token used to get the next set of schemas (if they exist).</p>', 'ListSolutionVersionsRequest$nextToken' => '<p>A token returned from the previous call to <code>ListSolutionVersions</code> for getting the next set of solution versions (if they exist).</p>', 'ListSolutionVersionsResponse$nextToken' => '<p>A token for getting the next set of solution versions (if they exist).</p>', 'ListSolutionsRequest$nextToken' => '<p>A token returned from the previous call to <code>ListSolutions</code> for getting the next set of solutions (if they exist).</p>', 'ListSolutionsResponse$nextToken' => '<p>A token for getting the next set of solutions (if they exist).</p>', ], ], 'NumBatchResults' => [ 'base' => NULL, 'refs' => [ 'BatchInferenceJob$numResults' => '<p>The number of recommendations generated by the batch inference job. This number includes the error messages generated for failed input records.</p>', 'BatchSegmentJob$numResults' => '<p>The number of predicted users generated by the batch segment job for each line of input data. The maximum number of users per segment is 5 million.</p>', 'CreateBatchInferenceJobRequest$numResults' => '<p>The number of recommendations to retrieve.</p>', 'CreateBatchSegmentJobRequest$numResults' => '<p>The number of predicted users generated by the batch segment job for each line of input data. The maximum number of users per segment is 5 million.</p>', ], ], 'ObjectiveSensitivity' => [ 'base' => NULL, 'refs' => [ 'OptimizationObjective$objectiveSensitivity' => '<p>Specifies how Amazon Personalize balances the importance of your optimization objective versus relevance.</p>', ], ], 'OptimizationObjective' => [ 'base' => '<p>Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html">Optimizing a solution</a>.</p>', 'refs' => [ 'SolutionConfig$optimizationObjective' => '<p>Describes the additional objective for the solution, such as maximizing streaming minutes or increasing revenue. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/optimizing-solution-for-objective.html">Optimizing a solution</a>.</p>', ], ], 'ParameterName' => [ 'base' => NULL, 'refs' => [ 'CategoricalHyperParameterRange$name' => '<p>The name of the hyperparameter.</p>', 'ContinuousHyperParameterRange$name' => '<p>The name of the hyperparameter.</p>', 'DefaultCategoricalHyperParameterRange$name' => '<p>The name of the hyperparameter.</p>', 'DefaultContinuousHyperParameterRange$name' => '<p>The name of the hyperparameter.</p>', 'DefaultIntegerHyperParameterRange$name' => '<p>The name of the hyperparameter.</p>', 'FeatureTransformationParameters$key' => NULL, 'FeaturizationParameters$key' => NULL, 'HyperParameters$key' => NULL, 'IntegerHyperParameterRange$name' => '<p>The name of the hyperparameter.</p>', 'ResourceConfig$key' => NULL, ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'FeatureTransformationParameters$value' => NULL, 'FeaturizationParameters$value' => NULL, 'HyperParameters$value' => NULL, 'ResourceConfig$value' => NULL, ], ], 'PerformAutoML' => [ 'base' => NULL, 'refs' => [ 'CreateSolutionRequest$performAutoML' => '<important> <p>We don\'t recommend enabling automated machine learning. Instead, match your use case to the available Amazon Personalize recipes. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/working-with-predefined-recipes.html">Choosing a recipe</a>.</p> </important> <p>Whether to perform automated machine learning (AutoML). The default is <code>false</code>. For this case, you must specify <code>recipeArn</code>.</p> <p>When set to <code>true</code>, Amazon Personalize analyzes your training data and selects the optimal USER_PERSONALIZATION recipe and hyperparameters. In this case, you must omit <code>recipeArn</code>. Amazon Personalize determines the optimal recipe by running tests with different values for the hyperparameters. AutoML lengthens the training process as compared to selecting a specific recipe.</p>', 'Solution$performAutoML' => '<important> <p>We don\'t recommend enabling automated machine learning. Instead, match your use case to the available Amazon Personalize recipes. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/determining-use-case.html">Determining your use case.</a> </p> </important> <p>When true, Amazon Personalize performs a search for the best USER_PERSONALIZATION recipe from the list specified in the solution configuration (<code>recipeArn</code> must not be specified). When false (the default), Amazon Personalize uses <code>recipeArn</code> for training.</p>', 'SolutionVersion$performAutoML' => '<p>When true, Amazon Personalize searches for the most optimal recipe according to the solution configuration. When false (the default), Amazon Personalize uses <code>recipeArn</code>.</p>', ], ], 'PerformAutoTraining' => [ 'base' => NULL, 'refs' => [ 'CreateSolutionRequest$performAutoTraining' => '<p>Whether the solution uses automatic training to create new solution versions (trained models). The default is <code>True</code> and the solution automatically creates new solution versions every 7 days. You can change the training frequency by specifying a <code>schedulingExpression</code> in the <code>AutoTrainingConfig</code> as part of solution configuration. For more information about automatic training, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html">Configuring automatic training</a>.</p> <p> Automatic solution version creation starts within one hour after the solution is ACTIVE. If you manually create a solution version within the hour, the solution skips the first automatic training. </p> <p> After training starts, you can get the solution version\'s Amazon Resource Name (ARN) with the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html">ListSolutionVersions</a> API operation. To get its status, use the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">DescribeSolutionVersion</a>. </p>', 'Solution$performAutoTraining' => '<p>Specifies whether the solution automatically creates solution versions. The default is <code>True</code> and the solution automatically creates new solution versions every 7 days.</p> <p>For more information about auto training, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/customizing-solution-config.html">Creating and configuring a solution</a>.</p>', 'SolutionUpdateSummary$performAutoTraining' => '<p>Whether the solution automatically creates solution versions.</p>', 'UpdateSolutionRequest$performAutoTraining' => '<p>Whether the solution uses automatic training to create new solution versions (trained models). You can change the training frequency by specifying a <code>schedulingExpression</code> in the <code>AutoTrainingConfig</code> as part of solution configuration. </p> <p> If you turn on automatic training, the first automatic training starts within one hour after the solution update completes. If you manually create a solution version within the hour, the solution skips the first automatic training. For more information about automatic training, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/solution-config-auto-training.html">Configuring automatic training</a>. </p> <p> After training starts, you can get the solution version\'s Amazon Resource Name (ARN) with the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_ListSolutionVersions.html">ListSolutionVersions</a> API operation. To get its status, use the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">DescribeSolutionVersion</a>. </p>', ], ], 'PerformHPO' => [ 'base' => NULL, 'refs' => [ 'Solution$performHPO' => '<p>Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.</p>', 'SolutionVersion$performHPO' => '<p>Whether to perform hyperparameter optimization (HPO) on the chosen recipe. The default is <code>false</code>.</p>', ], ], 'Recipe' => [ 'base' => '<p>Provides information about a recipe. Each recipe provides an algorithm that Amazon Personalize uses in model training when you use the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_CreateSolution.html">CreateSolution</a> operation. </p>', 'refs' => [ 'DescribeRecipeResponse$recipe' => '<p>An object that describes the recipe.</p>', ], ], 'RecipeProvider' => [ 'base' => NULL, 'refs' => [ 'ListRecipesRequest$recipeProvider' => '<p>The default is <code>SERVICE</code>.</p>', ], ], 'RecipeSummary' => [ 'base' => '<p>Provides a summary of the properties of a recipe. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecipe.html">DescribeRecipe</a> API.</p>', 'refs' => [ 'Recipes$member' => NULL, ], ], 'RecipeType' => [ 'base' => NULL, 'refs' => [ 'Recipe$recipeType' => '<p>One of the following values:</p> <ul> <li> <p>PERSONALIZED_RANKING</p> </li> <li> <p>RELATED_ITEMS</p> </li> <li> <p>USER_PERSONALIZATION</p> </li> </ul>', ], ], 'Recipes' => [ 'base' => NULL, 'refs' => [ 'ListRecipesResponse$recipes' => '<p>The list of available recipes.</p>', ], ], 'Recommender' => [ 'base' => '<p>Describes a recommendation generator for a Domain dataset group. You create a recommender in a Domain dataset group for a specific domain use case (domain recipe), and specify the recommender in a <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html">GetRecommendations</a> request.</p>', 'refs' => [ 'DescribeRecommenderResponse$recommender' => '<p>The properties of the recommender.</p>', ], ], 'RecommenderConfig' => [ 'base' => '<p>The configuration details of the recommender.</p>', 'refs' => [ 'CreateRecommenderRequest$recommenderConfig' => '<p>The configuration details of the recommender.</p>', 'Recommender$recommenderConfig' => '<p>The configuration details of the recommender.</p>', 'RecommenderSummary$recommenderConfig' => '<p>The configuration details of the recommender.</p>', 'RecommenderUpdateSummary$recommenderConfig' => '<p>The configuration details of the recommender update.</p>', 'UpdateRecommenderRequest$recommenderConfig' => '<p>The configuration details of the recommender.</p>', ], ], 'RecommenderSummary' => [ 'base' => '<p>Provides a summary of the properties of the recommender.</p>', 'refs' => [ 'Recommenders$member' => NULL, ], ], 'RecommenderUpdateSummary' => [ 'base' => '<p>Provides a summary of the properties of a recommender update. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeRecommender.html">DescribeRecommender</a> API.</p>', 'refs' => [ 'Recommender$latestRecommenderUpdate' => '<p>Provides a summary of the latest updates to the recommender. </p>', ], ], 'Recommenders' => [ 'base' => NULL, 'refs' => [ 'ListRecommendersResponse$recommenders' => '<p>A list of the recommenders.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The specified resource already exists.</p>', 'refs' => [], ], 'ResourceConfig' => [ 'base' => NULL, 'refs' => [ 'Algorithm$defaultResourceConfig' => '<p>Specifies the default maximum number of training jobs and parallel training jobs.</p>', ], ], 'ResourceInUseException' => [ 'base' => '<p>The specified resource is in use.</p>', 'refs' => [], ], 'ResourceNotFoundException' => [ 'base' => '<p>Could not find the specified resource.</p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'BatchInferenceJob$roleArn' => '<p>The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch inference job.</p>', 'BatchSegmentJob$roleArn' => '<p>The ARN of the Amazon Identity and Access Management (IAM) role that requested the batch segment job.</p>', 'CreateBatchInferenceJobRequest$roleArn' => '<p>The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output Amazon S3 buckets respectively.</p>', 'CreateBatchSegmentJobRequest$roleArn' => '<p>The ARN of the Amazon Identity and Access Management role that has permissions to read and write to your input and output Amazon S3 buckets respectively.</p>', 'CreateDataDeletionJobRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that has permissions to read from the Amazon S3 data source.</p>', 'CreateDatasetExportJobRequest$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket.</p>', 'CreateDatasetGroupRequest$roleArn' => '<p>The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.</p>', 'CreateDatasetImportJobRequest$roleArn' => '<p>The ARN of the IAM role that has permissions to read from the Amazon S3 data source.</p>', 'DataDeletionJob$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that has permissions to read from the Amazon S3 data source.</p>', 'DatasetGroup$roleArn' => '<p>The ARN of the Identity and Access Management (IAM) role that has permissions to access the Key Management Service (KMS) key. Supplying an IAM role is only valid when also specifying a KMS key.</p>', 'MetricAttributionOutput$roleArn' => '<p>The Amazon Resource Name (ARN) of the IAM service role that has permissions to add data to your output Amazon S3 bucket and add metrics to Amazon CloudWatch. For more information, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/measuring-recommendation-impact.html">Measuring impact of recommendations</a>.</p>', ], ], 'S3DataConfig' => [ 'base' => '<p>The configuration details of an Amazon S3 input or output bucket.</p>', 'refs' => [ 'BatchInferenceJobInput$s3DataSource' => '<p>The URI of the Amazon S3 location that contains your input data. The Amazon S3 bucket must be in the same region as the API endpoint you are calling.</p>', 'BatchInferenceJobOutput$s3DataDestination' => '<p>Information on the Amazon S3 bucket in which the batch inference job\'s output is stored.</p>', 'BatchSegmentJobInput$s3DataSource' => NULL, 'BatchSegmentJobOutput$s3DataDestination' => NULL, 'DatasetExportJobOutput$s3DataDestination' => NULL, 'MetricAttributionOutput$s3DataDestination' => NULL, ], ], 'S3Location' => [ 'base' => NULL, 'refs' => [ 'DataSource$dataLocation' => '<p>For dataset import jobs, the path to the Amazon S3 bucket where the data that you want to upload to your dataset is stored. For data deletion jobs, the path to the Amazon S3 bucket that stores the list of records to delete. </p> <p> For example: </p> <p> <code>s3://bucket-name/folder-name/fileName.csv</code> </p> <p>If your CSV files are in a folder in your Amazon S3 bucket and you want your import job or data deletion job to consider multiple files, you can specify the path to the folder. With a data deletion job, Amazon Personalize uses all files in the folder and any sub folder. Use the following syntax with a <code>/</code> after the folder name:</p> <p> <code>s3://bucket-name/folder-name/</code> </p>', 'S3DataConfig$path' => '<p>The file path of the Amazon S3 bucket.</p>', ], ], 'SchedulingExpression' => [ 'base' => NULL, 'refs' => [ 'AutoTrainingConfig$schedulingExpression' => '<p>Specifies how often to automatically train new solution versions. Specify a rate expression in rate(<i>value</i> <i>unit</i>) format. For value, specify a number between 1 and 30. For unit, specify <code>day</code> or <code>days</code>. For example, to automatically create a new solution version every 5 days, specify <code>rate(5 days)</code>. The default is every 7 days.</p> <p>For more information about auto training, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/customizing-solution-config.html">Creating and configuring a solution</a>.</p>', ], ], 'Schemas' => [ 'base' => NULL, 'refs' => [ 'ListSchemasResponse$schemas' => '<p>A list of schemas.</p>', ], ], 'Solution' => [ 'base' => '<important> <p>By default, all new solutions use automatic training. With automatic training, you incur training costs while your solution is active. To avoid unnecessary costs, when you are finished you can <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UpdateSolution.html">update the solution</a> to turn off automatic training. For information about training costs, see <a href="https://aws.amazon.com/personalize/pricing/">Amazon Personalize pricing</a>.</p> </important> <p>An object that provides information about a solution. A solution includes the custom recipe, customized parameters, and trained models (Solution Versions) that Amazon Personalize uses to generate recommendations. </p> <p>After you create a solution, you can’t change its configuration. If you need to make changes, you can <a href="https://docs.aws.amazon.com/personalize/latest/dg/cloning-solution.html">clone the solution</a> with the Amazon Personalize console or create a new one.</p>', 'refs' => [ 'DescribeSolutionResponse$solution' => '<p>An object that describes the solution.</p>', ], ], 'SolutionConfig' => [ 'base' => '<p>Describes the configuration properties for the solution.</p>', 'refs' => [ 'CreateSolutionRequest$solutionConfig' => '<p>The configuration properties for the solution. When <code>performAutoML</code> is set to true, Amazon Personalize only evaluates the <code>autoMLConfig</code> section of the solution configuration.</p> <note> <p>Amazon Personalize doesn\'t support configuring the <code>hpoObjective</code> at this time.</p> </note>', 'Solution$solutionConfig' => '<p>Describes the configuration properties for the solution.</p>', 'SolutionVersion$solutionConfig' => '<p>Describes the configuration properties for the solution.</p>', ], ], 'SolutionSummary' => [ 'base' => '<p>Provides a summary of the properties of a solution. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a> API.</p>', 'refs' => [ 'Solutions$member' => NULL, ], ], 'SolutionUpdateConfig' => [ 'base' => '<p>The configuration details of the solution update.</p>', 'refs' => [ 'SolutionUpdateSummary$solutionUpdateConfig' => '<p>The configuration details of the solution.</p>', 'UpdateSolutionRequest$solutionUpdateConfig' => '<p>The new configuration details of the solution.</p>', ], ], 'SolutionUpdateSummary' => [ 'base' => '<p>Provides a summary of the properties of a solution update. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolution.html">DescribeSolution</a> API.</p>', 'refs' => [ 'Solution$latestSolutionUpdate' => '<p>Provides a summary of the latest updates to the solution.</p>', ], ], 'SolutionVersion' => [ 'base' => '<p>An object that provides information about a specific version of a <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_Solution.html">Solution</a> in a Custom dataset group.</p>', 'refs' => [ 'DescribeSolutionVersionResponse$solutionVersion' => '<p>The solution version.</p>', ], ], 'SolutionVersionSummary' => [ 'base' => '<p>Provides a summary of the properties of a solution version. For a complete listing, call the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_DescribeSolutionVersion.html">DescribeSolutionVersion</a> API.</p>', 'refs' => [ 'Solution$latestSolutionVersion' => '<p>Describes the latest version of the solution, including the status and the ARN.</p>', 'SolutionVersions$member' => NULL, ], ], 'SolutionVersions' => [ 'base' => NULL, 'refs' => [ 'ListSolutionVersionsResponse$solutionVersions' => '<p>A list of solution versions describing the version properties.</p>', ], ], 'Solutions' => [ 'base' => NULL, 'refs' => [ 'ListSolutionsResponse$solutions' => '<p>A list of the current solutions.</p>', ], ], 'StartRecommenderRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartRecommenderResponse' => [ 'base' => NULL, 'refs' => [], ], 'Status' => [ 'base' => NULL, 'refs' => [ 'BatchInferenceJob$status' => '<p>The status of the batch inference job. The status is one of the following values:</p> <ul> <li> <p>PENDING</p> </li> <li> <p>IN PROGRESS</p> </li> <li> <p>ACTIVE</p> </li> <li> <p>CREATE FAILED</p> </li> </ul>', 'BatchInferenceJobSummary$status' => '<p>The status of the batch inference job. The status is one of the following values:</p> <ul> <li> <p>PENDING</p> </li> <li> <p>IN PROGRESS</p> </li> <li> <p>ACTIVE</p> </li> <li> <p>CREATE FAILED</p> </li> </ul>', 'BatchSegmentJob$status' => '<p>The status of the batch segment job. The status is one of the following values:</p> <ul> <li> <p>PENDING</p> </li> <li> <p>IN PROGRESS</p> </li> <li> <p>ACTIVE</p> </li> <li> <p>CREATE FAILED</p> </li> </ul>', 'BatchSegmentJobSummary$status' => '<p>The status of the batch segment job. The status is one of the following values:</p> <ul> <li> <p>PENDING</p> </li> <li> <p>IN PROGRESS</p> </li> <li> <p>ACTIVE</p> </li> <li> <p>CREATE FAILED</p> </li> </ul>', 'Campaign$status' => '<p>The status of the campaign.</p> <p>A campaign can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul>', 'CampaignSummary$status' => '<p>The status of the campaign.</p> <p>A campaign can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul>', 'CampaignUpdateSummary$status' => '<p>The status of the campaign update.</p> <p>A campaign update can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul>', 'DataDeletionJob$status' => '<p>The status of the data deletion job.</p> <p>A data deletion job can have one of the following statuses:</p> <ul> <li> <p>PENDING &gt; IN_PROGRESS &gt; COMPLETED -or- FAILED</p> </li> </ul>', 'DataDeletionJobSummary$status' => '<p>The status of the data deletion job.</p> <p>A data deletion job can have one of the following statuses:</p> <ul> <li> <p>PENDING &gt; IN_PROGRESS &gt; COMPLETED -or- FAILED</p> </li> </ul>', 'Dataset$status' => '<p>The status of the dataset.</p> <p>A dataset can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul>', 'DatasetExportJob$status' => '<p>The status of the dataset export job.</p> <p>A dataset export job can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> </ul>', 'DatasetExportJobSummary$status' => '<p>The status of the dataset export job.</p> <p>A dataset export job can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> </ul>', 'DatasetGroup$status' => '<p>The current status of the dataset group.</p> <p>A dataset group can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING</p> </li> </ul>', 'DatasetGroupSummary$status' => '<p>The status of the dataset group.</p> <p>A dataset group can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING</p> </li> </ul>', 'DatasetImportJob$status' => '<p>The status of the dataset import job.</p> <p>A dataset import job can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> </ul>', 'DatasetImportJobSummary$status' => '<p>The status of the dataset import job.</p> <p>A dataset import job can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> </ul>', 'DatasetSummary$status' => '<p>The status of the dataset.</p> <p>A dataset can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul>', 'DatasetUpdateSummary$status' => '<p>The status of the dataset update. </p>', 'EventTracker$status' => '<p>The status of the event tracker.</p> <p>An event tracker can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul>', 'EventTrackerSummary$status' => '<p>The status of the event tracker.</p> <p>An event tracker can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul>', 'FeatureTransformation$status' => '<p>The status of the feature transformation.</p> <p>A feature transformation can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> </ul>', 'Filter$status' => '<p>The status of the filter.</p>', 'FilterSummary$status' => '<p>The status of the filter.</p>', 'MetricAttribution$status' => '<p>The metric attribution\'s status.</p>', 'MetricAttributionSummary$status' => '<p>The metric attribution\'s status.</p>', 'Recipe$status' => '<p>The status of the recipe.</p>', 'RecipeSummary$status' => '<p>The status of the recipe.</p>', 'Recommender$status' => '<p>The status of the recommender.</p> <p>A recommender can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>STOP PENDING &gt; STOP IN_PROGRESS &gt; INACTIVE &gt; START PENDING &gt; START IN_PROGRESS &gt; ACTIVE</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul>', 'RecommenderSummary$status' => '<p>The status of the recommender. A recommender can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>STOP PENDING &gt; STOP IN_PROGRESS &gt; INACTIVE &gt; START PENDING &gt; START IN_PROGRESS &gt; ACTIVE</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul>', 'RecommenderUpdateSummary$status' => '<p>The status of the recommender update. A recommender update can be in one of the following states:</p> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p>', 'Solution$status' => '<p>The status of the solution.</p> <p>A solution can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul>', 'SolutionSummary$status' => '<p>The status of the solution.</p> <p>A solution can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> <li> <p>DELETE PENDING &gt; DELETE IN_PROGRESS</p> </li> </ul>', 'SolutionUpdateSummary$status' => '<p>The status of the solution update. A solution update can be in one of the following states:</p> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p>', 'SolutionVersion$status' => '<p>The status of the solution version.</p> <p>A solution version can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING</p> </li> <li> <p>CREATE IN_PROGRESS</p> </li> <li> <p>ACTIVE</p> </li> <li> <p>CREATE FAILED</p> </li> <li> <p>CREATE STOPPING</p> </li> <li> <p>CREATE STOPPED</p> </li> </ul>', 'SolutionVersionSummary$status' => '<p>The status of the solution version.</p> <p>A solution version can be in one of the following states:</p> <ul> <li> <p>CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE FAILED</p> </li> </ul>', ], ], 'StopRecommenderRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopRecommenderResponse' => [ 'base' => NULL, 'refs' => [], ], 'StopSolutionVersionCreationRequest' => [ 'base' => NULL, 'refs' => [], ], 'Tag' => [ 'base' => '<p>The optional metadata that you apply to resources to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">Tagging Amazon Personalize resources</a>. </p>', 'refs' => [ 'Tags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$tagKey' => '<p>One part of a key-value pair that makes up a tag. A key is a general label that acts like a category for more specific tag values.</p>', 'TagKeys$member' => NULL, ], ], 'TagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The keys of the tags to be removed.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$tagValue' => '<p>The optional part of a key-value pair that makes up a tag. A value acts as a descriptor within a tag category (key).</p>', ], ], 'Tags' => [ 'base' => NULL, 'refs' => [ 'CreateBatchInferenceJobRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the batch inference job.</p>', 'CreateBatchSegmentJobRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the batch segment job.</p>', 'CreateCampaignRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the campaign.</p>', 'CreateDataDeletionJobRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the data deletion job.</p>', 'CreateDatasetExportJobRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the dataset export job.</p>', 'CreateDatasetGroupRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the dataset group.</p>', 'CreateDatasetImportJobRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the dataset import job.</p>', 'CreateDatasetRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the dataset.</p>', 'CreateEventTrackerRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the event tracker.</p>', 'CreateFilterRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the filter.</p>', 'CreateRecommenderRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the recommender.</p>', 'CreateSolutionRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the solution.</p>', 'CreateSolutionVersionRequest$tags' => '<p>A list of <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">tags</a> to apply to the solution version.</p>', 'ListTagsForResourceResponse$tags' => '<p>The resource\'s tags.</p>', 'TagResourceRequest$tags' => '<p>Tags to apply to the resource. For more information see <a href="https://docs.aws.amazon.com/personalize/latest/dg/tagging-resources.html">Tagging Amazon Personalize resources</a>.</p>', ], ], 'ThemeGenerationConfig' => [ 'base' => '<p>The configuration details for generating themes with a batch inference job.</p>', 'refs' => [ 'BatchInferenceJob$themeGenerationConfig' => '<p>The job\'s theme generation settings.</p>', 'CreateBatchInferenceJobRequest$themeGenerationConfig' => '<p>For theme generation jobs, specify the name of the column in your Items dataset that contains each item\'s name.</p>', ], ], 'TooManyTagKeysException' => [ 'base' => '<p>The request contains more tag keys than can be associated with a resource (50 tag keys per resource). </p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>You have exceeded the maximum number of tags you can apply to this resource. </p>', 'refs' => [], ], 'TrackingId' => [ 'base' => NULL, 'refs' => [ 'CreateEventTrackerResponse$trackingId' => '<p>The ID of the event tracker. Include this ID in requests to the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.</p>', 'Dataset$trackingId' => '<p>The ID of the event tracker for an Action interactions dataset. You specify the tracker\'s ID in the <code>PutActionInteractions</code> API operation. Amazon Personalize uses it to direct new data to the Action interactions dataset in your dataset group.</p>', 'EventTracker$trackingId' => '<p>The ID of the event tracker. Include this ID in requests to the <a href="https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html">PutEvents</a> API.</p>', ], ], 'TrainingDataConfig' => [ 'base' => '<p>The training data configuration to use when creating a domain recommender or custom solution version (trained model).</p>', 'refs' => [ 'RecommenderConfig$trainingDataConfig' => '<p> Specifies the training data configuration to use when creating a domain recommender. </p>', 'SolutionConfig$trainingDataConfig' => '<p> Specifies the training data configuration to use when creating a custom solution version (trained model). </p>', ], ], 'TrainingHours' => [ 'base' => NULL, 'refs' => [ 'SolutionVersion$trainingHours' => '<p>The time used to train the model. You are billed for the time it takes to train a model. This field is visible only after Amazon Personalize successfully trains a model.</p>', ], ], 'TrainingInputMode' => [ 'base' => NULL, 'refs' => [ 'Algorithm$trainingInputMode' => '<p>The training input mode.</p>', ], ], 'TrainingMode' => [ 'base' => NULL, 'refs' => [ 'CreateSolutionVersionRequest$trainingMode' => '<p>The scope of training to be performed when creating the solution version. The default is <code>FULL</code>. This creates a completely new model based on the entirety of the training data from the datasets in your dataset group. </p> <p>If you use <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a>, you can specify a training mode of <code>UPDATE</code>. This updates the model to consider new items for recommendations. It is not a full retraining. You should still complete a full retraining weekly. If you specify <code>UPDATE</code>, Amazon Personalize will stop automatic updates for the solution version. To resume updates, create a new solution with training mode set to <code>FULL</code> and deploy it in a campaign. For more information about automatic updates, see <a href="https://docs.aws.amazon.com/personalize/latest/dg/use-case-recipe-features.html#maintaining-with-automatic-updates">Automatic updates</a>. </p> <p>The <code>UPDATE</code> option can only be used when you already have an active solution version created from the input solution using the <code>FULL</code> option and the input solution was trained with the <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-new-item-USER_PERSONALIZATION.html">User-Personalization</a> recipe or the legacy <a href="https://docs.aws.amazon.com/personalize/latest/dg/native-recipe-hrnn-coldstart.html">HRNN-Coldstart</a> recipe.</p>', 'SolutionVersion$trainingMode' => '<p>The scope of training to be performed when creating the solution version. A <code>FULL</code> training considers all of the data in your dataset group. An <code>UPDATE</code> processes only the data that has changed since the latest training. Only solution versions created with the User-Personalization recipe can use <code>UPDATE</code>. </p>', 'SolutionVersionSummary$trainingMode' => '<p>The scope of training to be performed when creating the solution version. A <code>FULL</code> training considers all of the data in your dataset group. An <code>UPDATE</code> processes only the data that has changed since the latest training. Only solution versions created with the User-Personalization recipe can use <code>UPDATE</code>. </p>', ], ], 'TrainingType' => [ 'base' => NULL, 'refs' => [ 'SolutionVersion$trainingType' => '<p>Whether the solution version was created automatically or manually.</p>', 'SolutionVersionSummary$trainingType' => '<p>Whether the solution version was created automatically or manually.</p>', ], ], 'TransactionsPerSecond' => [ 'base' => NULL, 'refs' => [ 'Campaign$minProvisionedTPS' => '<p>Specifies the requested minimum provisioned transactions (recommendations) per second. A high <code>minProvisionedTPS</code> will increase your bill. We recommend starting with 1 for <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase the <code>minProvisionedTPS</code> as necessary.</p>', 'CampaignUpdateSummary$minProvisionedTPS' => '<p>Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support.</p>', 'CreateCampaignRequest$minProvisionedTPS' => '<p>Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend starting with 1 for <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase the <code>minProvisionedTPS</code> as necessary.</p>', 'RecommenderConfig$minRecommendationRequestsPerSecond' => '<p>Specifies the requested minimum provisioned recommendation requests per second that Amazon Personalize will support. A high <code>minRecommendationRequestsPerSecond</code> will increase your bill. We recommend starting with 1 for <code>minRecommendationRequestsPerSecond</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase the <code>minRecommendationRequestsPerSecond</code> as necessary.</p>', 'UpdateCampaignRequest$minProvisionedTPS' => '<p>Specifies the requested minimum provisioned transactions (recommendations) per second that Amazon Personalize will support. A high <code>minProvisionedTPS</code> will increase your bill. We recommend starting with 1 for <code>minProvisionedTPS</code> (the default). Track your usage using Amazon CloudWatch metrics, and increase the <code>minProvisionedTPS</code> as necessary.</p>', ], ], 'Tunable' => [ 'base' => NULL, 'refs' => [ 'DefaultCategoricalHyperParameterRange$isTunable' => '<p>Whether the hyperparameter is tunable.</p>', 'DefaultContinuousHyperParameterRange$isTunable' => '<p>Whether the hyperparameter is tunable.</p>', 'DefaultIntegerHyperParameterRange$isTunable' => '<p>Indicates whether the hyperparameter is tunable.</p>', ], ], 'TunedHPOParams' => [ 'base' => '<p>If hyperparameter optimization (HPO) was performed, contains the hyperparameter values of the best performing model.</p>', 'refs' => [ 'SolutionVersion$tunedHPOParams' => '<p>If hyperparameter optimization was performed, contains the hyperparameter values of the best performing model.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCampaignRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCampaignResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatasetRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateDatasetResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMetricAttributionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMetricAttributionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRecommenderRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateRecommenderResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSolutionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSolutionResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
