<?php
// This file was auto-generated from sdk-root/src/data/pinpoint/2016-12-01/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Doc Engage API - Amazon Pinpoint API</p>', 'operations' => [ 'CreateApp' => ' <p>Creates an application.</p>', 'CreateCampaign' => '<p>Creates a new campaign for an application or updates the settings of an existing campaign for an application.</p>', 'CreateEmailTemplate' => '<p>Creates a message template for messages that are sent through the email channel.</p>', 'CreateExportJob' => '<p>Creates an export job for an application.</p>', 'CreateImportJob' => '<p>Creates an import job for an application.</p>', 'CreateInAppTemplate' => '<p>Creates a new message template for messages using the in-app message channel.</p>', 'CreateJourney' => '<p>Creates a journey for an application.</p>', 'CreatePushTemplate' => '<p>Creates a message template for messages that are sent through a push notification channel.</p>', 'CreateRecommenderConfiguration' => '<p>Creates an Amazon Pinpoint configuration for a recommender model.</p>', 'CreateSegment' => '<p>Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that\'s associated with an application.</p>', 'CreateSmsTemplate' => '<p>Creates a message template for messages that are sent through the SMS channel.</p>', 'CreateVoiceTemplate' => '<p>Creates a message template for messages that are sent through the voice channel.</p>', 'DeleteAdmChannel' => '<p>Disables the ADM channel for an application and deletes any existing settings for the channel.</p>', 'DeleteApnsChannel' => '<p>Disables the APNs channel for an application and deletes any existing settings for the channel.</p>', 'DeleteApnsSandboxChannel' => '<p>Disables the APNs sandbox channel for an application and deletes any existing settings for the channel.</p>', 'DeleteApnsVoipChannel' => '<p>Disables the APNs VoIP channel for an application and deletes any existing settings for the channel.</p>', 'DeleteApnsVoipSandboxChannel' => '<p>Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel.</p>', 'DeleteApp' => '<p>Deletes an application.</p>', 'DeleteBaiduChannel' => '<p>Disables the Baidu channel for an application and deletes any existing settings for the channel.</p>', 'DeleteCampaign' => '<p>Deletes a campaign from an application.</p>', 'DeleteEmailChannel' => '<p>Disables the email channel for an application and deletes any existing settings for the channel.</p>', 'DeleteEmailTemplate' => '<p>Deletes a message template for messages that were sent through the email channel.</p>', 'DeleteEndpoint' => '<p>Deletes an endpoint from an application.</p>', 'DeleteEventStream' => '<p>Deletes the event stream for an application.</p>', 'DeleteGcmChannel' => '<p>Disables the GCM channel for an application and deletes any existing settings for the channel.</p>', 'DeleteInAppTemplate' => '<p>Deletes a message template for messages sent using the in-app message channel.</p>', 'DeleteJourney' => '<p>Deletes a journey from an application.</p>', 'DeletePushTemplate' => '<p>Deletes a message template for messages that were sent through a push notification channel.</p>', 'DeleteRecommenderConfiguration' => '<p>Deletes an Amazon Pinpoint configuration for a recommender model.</p>', 'DeleteSegment' => '<p>Deletes a segment from an application.</p>', 'DeleteSmsChannel' => '<p>Disables the SMS channel for an application and deletes any existing settings for the channel.</p>', 'DeleteSmsTemplate' => '<p>Deletes a message template for messages that were sent through the SMS channel.</p>', 'DeleteUserEndpoints' => '<p>Deletes all the endpoints that are associated with a specific user ID.</p>', 'DeleteVoiceChannel' => '<p>Disables the voice channel for an application and deletes any existing settings for the channel.</p>', 'DeleteVoiceTemplate' => '<p>Deletes a message template for messages that were sent through the voice channel.</p>', 'GetAdmChannel' => '<p>Retrieves information about the status and settings of the ADM channel for an application.</p>', 'GetApnsChannel' => '<p>Retrieves information about the status and settings of the APNs channel for an application.</p>', 'GetApnsSandboxChannel' => '<p>Retrieves information about the status and settings of the APNs sandbox channel for an application.</p>', 'GetApnsVoipChannel' => '<p>Retrieves information about the status and settings of the APNs VoIP channel for an application.</p>', 'GetApnsVoipSandboxChannel' => '<p>Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application.</p>', 'GetApp' => '<p>Retrieves information about an application.</p>', 'GetApplicationDateRangeKpi' => '<p>Retrieves (queries) pre-aggregated data for a standard metric that applies to an application.</p>', 'GetApplicationSettings' => '<p>Retrieves information about the settings for an application.</p>', 'GetApps' => '<p>Retrieves information about all the applications that are associated with your Amazon Pinpoint account.</p>', 'GetBaiduChannel' => '<p>Retrieves information about the status and settings of the Baidu channel for an application.</p>', 'GetCampaign' => '<p>Retrieves information about the status, configuration, and other settings for a campaign.</p>', 'GetCampaignActivities' => '<p>Retrieves information about all the activities for a campaign.</p>', 'GetCampaignDateRangeKpi' => '<p>Retrieves (queries) pre-aggregated data for a standard metric that applies to a campaign.</p>', 'GetCampaignVersion' => '<p>Retrieves information about the status, configuration, and other settings for a specific version of a campaign.</p>', 'GetCampaignVersions' => '<p>Retrieves information about the status, configuration, and other settings for all versions of a campaign.</p>', 'GetCampaigns' => '<p>Retrieves information about the status, configuration, and other settings for all the campaigns that are associated with an application.</p>', 'GetChannels' => '<p>Retrieves information about the history and status of each channel for an application.</p>', 'GetEmailChannel' => '<p>Retrieves information about the status and settings of the email channel for an application.</p>', 'GetEmailTemplate' => '<p>Retrieves the content and settings of a message template for messages that are sent through the email channel.</p>', 'GetEndpoint' => '<p>Retrieves information about the settings and attributes of a specific endpoint for an application.</p>', 'GetEventStream' => '<p>Retrieves information about the event stream settings for an application.</p>', 'GetExportJob' => '<p>Retrieves information about the status and settings of a specific export job for an application.</p>', 'GetExportJobs' => '<p>Retrieves information about the status and settings of all the export jobs for an application.</p>', 'GetGcmChannel' => '<p>Retrieves information about the status and settings of the GCM channel for an application.</p>', 'GetImportJob' => '<p>Retrieves information about the status and settings of a specific import job for an application.</p>', 'GetImportJobs' => '<p>Retrieves information about the status and settings of all the import jobs for an application.</p>', 'GetInAppMessages' => '<p>Retrieves the in-app messages targeted for the provided endpoint ID.</p>', 'GetInAppTemplate' => '<p>Retrieves the content and settings of a message template for messages sent through the in-app channel.</p>', 'GetJourney' => '<p>Retrieves information about the status, configuration, and other settings for a journey.</p>', 'GetJourneyDateRangeKpi' => '<p>Retrieves (queries) pre-aggregated data for a standard engagement metric that applies to a journey.</p>', 'GetJourneyExecutionActivityMetrics' => '<p>Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey activity.</p>', 'GetJourneyExecutionMetrics' => '<p>Retrieves (queries) pre-aggregated data for a standard execution metric that applies to a journey.</p>', 'GetJourneyRunExecutionActivityMetrics' => '<p>Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey activity.</p>', 'GetJourneyRunExecutionMetrics' => '<p>Retrieves (queries) pre-aggregated data for a standard run execution metric that applies to a journey.</p>', 'GetJourneyRuns' => '<p>Provides information about the runs of a journey.</p>', 'GetPushTemplate' => '<p>Retrieves the content and settings of a message template for messages that are sent through a push notification channel.</p>', 'GetRecommenderConfiguration' => '<p>Retrieves information about an Amazon Pinpoint configuration for a recommender model.</p>', 'GetRecommenderConfigurations' => '<p>Retrieves information about all the recommender model configurations that are associated with your Amazon Pinpoint account.</p>', 'GetSegment' => '<p>Retrieves information about the configuration, dimension, and other settings for a specific segment that\'s associated with an application.</p>', 'GetSegmentExportJobs' => '<p>Retrieves information about the status and settings of the export jobs for a segment.</p>', 'GetSegmentImportJobs' => '<p>Retrieves information about the status and settings of the import jobs for a segment.</p>', 'GetSegmentVersion' => '<p>Retrieves information about the configuration, dimension, and other settings for a specific version of a segment that\'s associated with an application.</p>', 'GetSegmentVersions' => '<p>Retrieves information about the configuration, dimension, and other settings for all the versions of a specific segment that\'s associated with an application.</p>', 'GetSegments' => '<p>Retrieves information about the configuration, dimension, and other settings for all the segments that are associated with an application.</p>', 'GetSmsChannel' => '<p>Retrieves information about the status and settings of the SMS channel for an application.</p>', 'GetSmsTemplate' => '<p>Retrieves the content and settings of a message template for messages that are sent through the SMS channel.</p>', 'GetUserEndpoints' => '<p>Retrieves information about all the endpoints that are associated with a specific user ID.</p>', 'GetVoiceChannel' => '<p>Retrieves information about the status and settings of the voice channel for an application.</p>', 'GetVoiceTemplate' => '<p>Retrieves the content and settings of a message template for messages that are sent through the voice channel.</p>', 'ListJourneys' => '<p>Retrieves information about the status, configuration, and other settings for all the journeys that are associated with an application.</p>', 'ListTagsForResource' => '<p>Retrieves all the tags (keys and values) that are associated with an application, campaign, message template, or segment.</p>', 'ListTemplateVersions' => '<p>Retrieves information about all the versions of a specific message template.</p>', 'ListTemplates' => '<p>Retrieves information about all the message templates that are associated with your Amazon Pinpoint account.</p>', 'PhoneNumberValidate' => '<p>Retrieves information about a phone number.</p>', 'PutEventStream' => '<p>Creates a new event stream for an application or updates the settings of an existing event stream for an application.</p>', 'PutEvents' => '<p>Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are associated with.</p>', 'RemoveAttributes' => '<p>Removes one or more custom attributes, of the same attribute type, from the application. Existing endpoints still have the attributes but Amazon Pinpoint will stop capturing new or changed values for these attributes.</p>', 'SendMessages' => '<p>Creates and sends a direct message.</p>', 'SendOTPMessage' => '<p>Send an OTP message</p>', 'SendUsersMessages' => '<p>Creates and sends a message to a list of users.</p>', 'TagResource' => '<p>Adds one or more tags (keys and values) to an application, campaign, message template, or segment.</p>', 'UntagResource' => '<p>Removes one or more tags (keys and values) from an application, campaign, message template, or segment.</p>', 'UpdateAdmChannel' => '<p>Enables the ADM channel for an application or updates the status and settings of the ADM channel for an application.</p>', 'UpdateApnsChannel' => '<p>Enables the APNs channel for an application or updates the status and settings of the APNs channel for an application.</p>', 'UpdateApnsSandboxChannel' => '<p>Enables the APNs sandbox channel for an application or updates the status and settings of the APNs sandbox channel for an application.</p>', 'UpdateApnsVoipChannel' => '<p>Enables the APNs VoIP channel for an application or updates the status and settings of the APNs VoIP channel for an application.</p>', 'UpdateApnsVoipSandboxChannel' => '<p>Enables the APNs VoIP sandbox channel for an application or updates the status and settings of the APNs VoIP sandbox channel for an application.</p>', 'UpdateApplicationSettings' => '<p>Updates the settings for an application.</p>', 'UpdateBaiduChannel' => '<p>Enables the Baidu channel for an application or updates the status and settings of the Baidu channel for an application.</p>', 'UpdateCampaign' => '<p>Updates the configuration and other settings for a campaign.</p>', 'UpdateEmailChannel' => '<p>Enables the email channel for an application or updates the status and settings of the email channel for an application.</p>', 'UpdateEmailTemplate' => '<p>Updates an existing message template for messages that are sent through the email channel.</p>', 'UpdateEndpoint' => '<p>Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an application. You can also use this operation to define custom attributes for an endpoint. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.</p>', 'UpdateEndpointsBatch' => '<p>Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing endpoints for an application. You can also use this operation to define custom attributes for a batch of endpoints. If an update includes one or more values for a custom attribute, Amazon Pinpoint replaces (overwrites) any existing values with the new values.</p>', 'UpdateGcmChannel' => '<p>Enables the GCM channel for an application or updates the status and settings of the GCM channel for an application.</p>', 'UpdateInAppTemplate' => '<p>Updates an existing message template for messages sent through the in-app message channel.</p>', 'UpdateJourney' => '<p>Updates the configuration and other settings for a journey.</p>', 'UpdateJourneyState' => '<p>Pause, resume or cancels (stops) a journey.</p>', 'UpdatePushTemplate' => '<p>Updates an existing message template for messages that are sent through a push notification channel.</p>', 'UpdateRecommenderConfiguration' => '<p>Updates an Amazon Pinpoint configuration for a recommender model.</p>', 'UpdateSegment' => '<p>Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that\'s associated with an application.</p>', 'UpdateSmsChannel' => '<p>Enables the SMS channel for an application or updates the status and settings of the SMS channel for an application.</p>', 'UpdateSmsTemplate' => '<p>Updates an existing message template for messages that are sent through the SMS channel.</p>', 'UpdateTemplateActiveVersion' => '<p>Changes the status of a specific version of a message template to <i>active</i>.</p>', 'UpdateVoiceChannel' => '<p>Enables the voice channel for an application or updates the status and settings of the voice channel for an application.</p>', 'UpdateVoiceTemplate' => '<p>Updates an existing message template for messages that are sent through the voice channel.</p>', 'VerifyOTPMessage' => '<p>Verify an OTP</p>', ], 'shapes' => [ 'ADMChannelRequest' => [ 'base' => '<p>Specifies the status and settings of the ADM (Amazon Device Messaging) channel for an application.</p>', 'refs' => [], ], 'ADMChannelResponse' => [ 'base' => '<p>Provides information about the status and settings of the ADM (Amazon Device Messaging) channel for an application.</p>', 'refs' => [], ], 'ADMMessage' => [ 'base' => '<p>Specifies the settings for a one-time message that\'s sent directly to an endpoint through the ADM (Amazon Device Messaging) channel.</p>', 'refs' => [ 'DirectMessageConfiguration$ADMMessage' => '<p>The default push notification message for the ADM (Amazon Device Messaging) channel. This message overrides the default push notification message (DefaultPushNotificationMessage).</p>', ], ], 'APNSChannelRequest' => [ 'base' => '<p>Specifies the status and settings of the APNs (Apple Push Notification service) channel for an application.</p>', 'refs' => [], ], 'APNSChannelResponse' => [ 'base' => '<p>Provides information about the status and settings of the APNs (Apple Push Notification service) channel for an application.</p>', 'refs' => [], ], 'APNSMessage' => [ 'base' => '<p>Specifies the settings for a one-time message that\'s sent directly to an endpoint through the APNs (Apple Push Notification service) channel.</p>', 'refs' => [ 'DirectMessageConfiguration$APNSMessage' => '<p>The default push notification message for the APNs (Apple Push Notification service) channel. This message overrides the default push notification message (DefaultPushNotificationMessage).</p>', ], ], 'APNSPushNotificationTemplate' => [ 'base' => '<p>Specifies channel-specific content and settings for a message template that can be used in push notifications that are sent through the APNs (Apple Push Notification service) channel.</p>', 'refs' => [ 'PushNotificationTemplateRequest$APNS' => '<p>The message template to use for the APNs (Apple Push Notification service) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>', 'PushNotificationTemplateResponse$APNS' => '<p>The message template that\'s used for the APNs (Apple Push Notification service) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>', ], ], 'APNSSandboxChannelRequest' => [ 'base' => '<p>Specifies the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>', 'refs' => [], ], 'APNSSandboxChannelResponse' => [ 'base' => '<p>Provides information about the status and settings of the APNs (Apple Push Notification service) sandbox channel for an application.</p>', 'refs' => [], ], 'APNSVoipChannelRequest' => [ 'base' => '<p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>', 'refs' => [], ], 'APNSVoipChannelResponse' => [ 'base' => '<p>Provides information about the status and settings of the APNs (Apple Push Notification service) VoIP channel for an application.</p>', 'refs' => [], ], 'APNSVoipSandboxChannelRequest' => [ 'base' => '<p>Specifies the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>', 'refs' => [], ], 'APNSVoipSandboxChannelResponse' => [ 'base' => '<p>Provides information about the status and settings of the APNs (Apple Push Notification service) VoIP sandbox channel for an application.</p>', 'refs' => [], ], 'Action' => [ 'base' => NULL, 'refs' => [ 'ADMMessage$Action' => '<p>The action to occur if the recipient taps the push notification. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the deep-linking features of the Android platform.</p></li> <li><p>URL - The default mobile browser on the recipient\'s device opens and loads the web page at a URL that you specify.</p></li></ul>', 'APNSMessage$Action' => '<p>The action to occur if the recipient taps the push notification. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS platform.</p></li> <li><p>URL - The default mobile browser on the recipient\'s device opens and loads the web page at a URL that you specify.</p></li></ul>', 'APNSPushNotificationTemplate$Action' => '<p>The action to occur if a recipient taps a push notification that\'s based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS platform.</p></li> <li><p>URL - The default mobile browser on the recipient\'s device opens and loads the web page at a URL that you specify.</p></li></ul>', 'AndroidPushNotificationTemplate$Action' => '<p>The action to occur if a recipient taps a push notification that\'s based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the deep-linking features of the Android platform.</p></li> <li><p>URL - The default mobile browser on the recipient\'s device opens and loads the web page at a URL that you specify.</p></li></ul>', 'BaiduMessage$Action' => '<p>The action to occur if the recipient taps the push notification. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the deep-linking features of the Android platform.</p></li> <li><p>URL - The default mobile browser on the recipient\'s device opens and loads the web page at a URL that you specify.</p></li></ul>', 'DefaultPushNotificationMessage$Action' => '<p>The default action to occur if a recipient taps the push notification. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS and Android platforms.</p></li> <li><p>URL - The default mobile browser on the recipient\'s device opens and loads the web page at a URL that you specify.</p></li></ul>', 'DefaultPushNotificationTemplate$Action' => '<p>The action to occur if a recipient taps a push notification that\'s based on the message template. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of the iOS and Android platforms.</p></li> <li><p>URL - The default mobile browser on the recipient\'s device opens and loads the web page at a URL that you specify.</p></li></ul>', 'GCMMessage$Action' => '<p>The action to occur if the recipient taps the push notification. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This action uses the deep-linking features of the Android platform.</p></li> <li><p>URL - The default mobile browser on the recipient\'s device opens and loads the web page at a URL that you specify.</p></li></ul>', 'Message$Action' => '<p>The action to occur if a recipient taps the push notification. Valid values are:</p> <ul><li><p>OPEN_APP - Your app opens or it becomes the foreground app if it was sent to the background. This is the default action.</p></li> <li><p>DEEP_LINK - Your app opens and displays a designated user interface in the app. This setting uses the deep-linking features of iOS and Android.</p></li> <li><p>URL - The default mobile browser on the recipient\'s device opens and loads the web page at a URL that you specify.</p></li></ul>', ], ], 'ActivitiesResponse' => [ 'base' => '<p>Provides information about the activities that were performed by a campaign.</p>', 'refs' => [], ], 'Activity' => [ 'base' => '<p>Specifies the configuration and other settings for an activity in a journey.</p>', 'refs' => [ 'MapOfActivity$member' => NULL, ], ], 'ActivityResponse' => [ 'base' => '<p>Provides information about an activity that was performed by a campaign.</p>', 'refs' => [ 'ListOfActivityResponse$member' => NULL, ], ], 'AddressConfiguration' => [ 'base' => '<p>Specifies address-based configuration settings for a message that\'s sent directly to an endpoint.</p>', 'refs' => [ 'MapOfAddressConfiguration$member' => NULL, ], ], 'Alignment' => [ 'base' => NULL, 'refs' => [ 'InAppMessageBodyConfig$Alignment' => '<p>The alignment of the text. Valid values: LEFT, CENTER, RIGHT.</p>', 'InAppMessageHeaderConfig$Alignment' => '<p>The alignment of the text. Valid values: LEFT, CENTER, RIGHT.</p>', ], ], 'AndroidPushNotificationTemplate' => [ 'base' => '<p>Specifies channel-specific content and settings for a message template that can be used in push notifications that are sent through the ADM (Amazon Device Messaging), Baidu (Baidu Cloud Push), or GCM (Firebase Cloud Messaging, formerly Google Cloud Messaging) channel.</p>', 'refs' => [ 'PushNotificationTemplateRequest$ADM' => '<p>The message template to use for the ADM (Amazon Device Messaging) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>', 'PushNotificationTemplateRequest$Baidu' => '<p>The message template to use for the Baidu (Baidu Cloud Push) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>', 'PushNotificationTemplateRequest$GCM' => '<p>The message template to use for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>', 'PushNotificationTemplateResponse$ADM' => '<p>The message template that\'s used for the ADM (Amazon Device Messaging) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>', 'PushNotificationTemplateResponse$Baidu' => '<p>The message template that\'s used for the Baidu (Baidu Cloud Push) channel. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>', 'PushNotificationTemplateResponse$GCM' => '<p>The message template that\'s used for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message template overrides the default template for push notification channels (DefaultPushNotificationTemplate).</p>', ], ], 'ApplicationDateRangeKpiResponse' => [ 'base' => '<p>Provides the results of a query that retrieved the data for a standard metric that applies to an application, and provides information about that query.</p>', 'refs' => [], ], 'ApplicationResponse' => [ 'base' => '<p>Provides information about an application.</p>', 'refs' => [ 'ListOfApplicationResponse$member' => NULL, ], ], 'ApplicationSettingsJourneyLimits' => [ 'base' => '<p>The default sending limits for journeys in the application. To override these limits and define custom limits for a specific journey, use the Journey resource.</p>', 'refs' => [ 'ApplicationSettingsResource$JourneyLimits' => '<p>The default sending limits for journeys in the application. These limits apply to each journey for the application but can be overridden, on a per journey basis, with the JourneyLimits resource.</p>', 'WriteApplicationSettingsRequest$JourneyLimits' => '<p>The default sending limits for journeys in the application. These limits apply to each journey for the application but can be overridden, on a per journey basis, with the JourneyLimits resource.</p>', ], ], 'ApplicationSettingsResource' => [ 'base' => '<p>Provides information about an application, including the default settings for an application.</p>', 'refs' => [], ], 'ApplicationsResponse' => [ 'base' => '<p>Provides information about all of your applications.</p>', 'refs' => [], ], 'AttributeDimension' => [ 'base' => '<p>Specifies attribute-based criteria for including or excluding endpoints from a segment.</p>', 'refs' => [ 'MapOfAttributeDimension$member' => NULL, ], ], 'AttributeType' => [ 'base' => NULL, 'refs' => [ 'AttributeDimension$AttributeType' => '<p><ul><li>INCLUSIVE - endpoints that have attributes matching the values are included in the segment.</li><li>EXCLUSIVE - endpoints that have attributes matching the values are excluded in the segment.</li><li>CONTAINS - endpoints that have attributes\' substrings match the values are included in the segment.</li><li>BEFORE - endpoints with attributes read as ISO_INSTANT datetimes before the value are included in the segment.</li><li>AFTER - endpoints with attributes read as ISO_INSTANT datetimes after the value are included in the segment.</li><li>ON - endpoints with attributes read as ISO_INSTANT dates on the value are included in the segment. Time is ignored in this comparison.</li><li>BETWEEN - endpoints with attributes read as ISO_INSTANT datetimes between the values are included in the segment.</li></p>', ], ], 'AttributesResource' => [ 'base' => '<p>Provides information about the type and the names of attributes that were removed from all the endpoints that are associated with an application.</p>', 'refs' => [], ], 'BadRequestException' => [ 'base' => '<p>Provides information about an API request or response.</p>', 'refs' => [], ], 'BaiduChannelRequest' => [ 'base' => '<p>Specifies the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>', 'refs' => [], ], 'BaiduChannelResponse' => [ 'base' => '<p>Provides information about the status and settings of the Baidu (Baidu Cloud Push) channel for an application.</p>', 'refs' => [], ], 'BaiduMessage' => [ 'base' => '<p>Specifies the settings for a one-time message that\'s sent directly to an endpoint through the Baidu (Baidu Cloud Push) channel.</p>', 'refs' => [ 'DirectMessageConfiguration$BaiduMessage' => '<p>The default push notification message for the Baidu (Baidu Cloud Push) channel. This message overrides the default push notification message (DefaultPushNotificationMessage).</p>', ], ], 'BaseKpiResult' => [ 'base' => '<p>Provides the results of a query that retrieved the data for a standard metric that applies to an application, campaign, or journey.</p>', 'refs' => [ 'ApplicationDateRangeKpiResponse$KpiResult' => '<p>An array of objects that contains the results of the query. Each object contains the value for the metric and metadata about that value.</p>', 'CampaignDateRangeKpiResponse$KpiResult' => '<p>An array of objects that contains the results of the query. Each object contains the value for the metric and metadata about that value.</p>', 'JourneyDateRangeKpiResponse$KpiResult' => '<p>An array of objects that contains the results of the query. Each object contains the value for the metric and metadata about that value.</p>', ], ], 'ButtonAction' => [ 'base' => NULL, 'refs' => [ 'DefaultButtonConfiguration$ButtonAction' => '<p>Action triggered by the button.</p>', 'OverrideButtonConfiguration$ButtonAction' => '<p>Action triggered by the button.</p>', ], ], 'CampaignCustomMessage' => [ 'base' => '<p>Specifies the contents of a message that\'s sent through a custom channel to recipients of a campaign.</p>', 'refs' => [ 'MessageConfiguration$CustomMessage' => '<p>The message that the campaign sends through a custom channel, as specified by the delivery configuration (CustomDeliveryConfiguration) settings for the campaign. If specified, this message overrides the default message.</p> ', ], ], 'CampaignDateRangeKpiResponse' => [ 'base' => '<p>Provides the results of a query that retrieved the data for a standard metric that applies to a campaign, and provides information about that query.</p>', 'refs' => [], ], 'CampaignEmailMessage' => [ 'base' => '<p>Specifies the content and "From" address for an email message that\'s sent to recipients of a campaign.</p>', 'refs' => [ 'MessageConfiguration$EmailMessage' => '<p>The message that the campaign sends through the email channel. If specified, this message overrides the default message.</p>', ], ], 'CampaignEventFilter' => [ 'base' => '<p>Specifies the settings for events that cause a campaign to be sent.</p>', 'refs' => [ 'InAppCampaignSchedule$EventFilter' => '<p>The event filter the SDK has to use to show the in-app message in the application.</p>', 'Schedule$EventFilter' => '<p>The type of event that causes the campaign to be sent, if the value of the Frequency property is EVENT.</p>', ], ], 'CampaignHook' => [ 'base' => '<p>Specifies settings for invoking an AWS Lambda function that customizes a segment for a campaign.</p>', 'refs' => [ 'ApplicationSettingsResource$CampaignHook' => '<p>The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.</p>', 'CampaignResponse$Hook' => '<p>The settings for the AWS Lambda function to use as a code hook for the campaign. You can use this hook to customize the segment that\'s used by the campaign.</p>', 'WriteApplicationSettingsRequest$CampaignHook' => '<p>The settings for the AWS Lambda function to invoke by default as a code hook for campaigns in the application. You can use this hook to customize segments that are used by campaigns in the application.</p> <p>To override these settings and define custom settings for a specific campaign, use the CampaignHook object of the <link linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource.</p>', 'WriteCampaignRequest$Hook' => '<p>The settings for the AWS Lambda function to invoke as a code hook for the campaign. You can use this hook to customize the segment that\'s used by the campaign.</p>', ], ], 'CampaignInAppMessage' => [ 'base' => '<p>In-app message configuration.</p>', 'refs' => [ 'MessageConfiguration$InAppMessage' => '<p>The in-app message configuration.</p>', ], ], 'CampaignLimits' => [ 'base' => '<p>For a campaign, specifies limits on the messages that the campaign can send. For an application, specifies the default limits for messages that campaigns in the application can send.</p>', 'refs' => [ 'ApplicationSettingsResource$Limits' => '<p>The default sending limits for campaigns in the application.</p>', 'CampaignResponse$Limits' => '<p>The messaging limits for the campaign.</p>', 'WriteApplicationSettingsRequest$Limits' => '<p>The default sending limits for campaigns in the application. To override these limits and define custom limits for a specific campaign or journey, use the <link linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link linkend="apps-application-id-journeys-journey-id">Journey</link> resource, respectively.</p>', 'WriteCampaignRequest$Limits' => '<p>The messaging limits for the campaign.</p>', ], ], 'CampaignResponse' => [ 'base' => '<p>Provides information about the status, configuration, and other settings for a campaign.</p>', 'refs' => [ 'ListOfCampaignResponse$member' => NULL, ], ], 'CampaignSmsMessage' => [ 'base' => '<p>Specifies the content and settings for an SMS message that\'s sent to recipients of a campaign.</p>', 'refs' => [ 'MessageConfiguration$SMSMessage' => '<p>The message that the campaign sends through the SMS channel. If specified, this message overrides the default message.</p>', ], ], 'CampaignState' => [ 'base' => '<p>Provides information about the status of a campaign.</p>', 'refs' => [ 'CampaignResponse$DefaultState' => '<p>The current status of the campaign\'s default treatment. This value exists only for campaigns that have more than one treatment.</p>', 'CampaignResponse$State' => '<p>The current status of the campaign.</p>', 'TreatmentResource$State' => '<p>The current status of the treatment.</p>', ], ], 'CampaignStatus' => [ 'base' => NULL, 'refs' => [ 'CampaignState$CampaignStatus' => '<p>The current status of the campaign, or the current status of a treatment that belongs to an A/B test campaign.</p> <p>If a campaign uses A/B testing, the campaign has a status of COMPLETED only if all campaign treatments have a status of COMPLETED. If you delete the segment that\'s associated with a campaign, the campaign fails and has a status of DELETED.</p>', ], ], 'CampaignsResponse' => [ 'base' => '<p>Provides information about the configuration and other settings for all the campaigns that are associated with an application.</p>', 'refs' => [], ], 'ChannelResponse' => [ 'base' => '<p>Provides information about the general settings and status of a channel for an application.</p>', 'refs' => [ 'MapOfChannelResponse$member' => NULL, ], ], 'ChannelType' => [ 'base' => NULL, 'refs' => [ 'AddressConfiguration$ChannelType' => '<p>The channel to use when sending the message.</p>', 'EndpointBatchItem$ChannelType' => '<p>The channel to use when sending messages or push notifications to the endpoint.</p>', 'EndpointRequest$ChannelType' => '<p>The channel to use when sending messages or push notifications to the endpoint.</p>', 'EndpointResponse$ChannelType' => '<p>The channel that\'s used when sending messages or push notifications to the endpoint.</p>', 'PublicEndpoint$ChannelType' => '<p>The channel that\'s used when sending messages or push notifications to the endpoint.</p>', ], ], 'ChannelsResponse' => [ 'base' => '<p>Provides information about the general settings and status of all channels for an application, including channels that aren\'t enabled for the application.</p>', 'refs' => [], ], 'Condition' => [ 'base' => '<p>Specifies the conditions to evaluate for an activity in a journey, and how to evaluate those conditions.</p>', 'refs' => [ 'ConditionalSplitActivity$Condition' => '<p>The conditions that define the paths for the activity, and the relationship between the conditions.</p>', ], ], 'ConditionalSplitActivity' => [ 'base' => '<p>Specifies the settings for a yes/no split activity in a journey. This type of activity sends participants down one of two paths in a journey, based on conditions that you specify.</p> <note><p>To create yes/no split activities that send participants down different paths based on push notification events (such as Open or Received events), your mobile app has to specify the User ID and Endpoint ID values. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/integrate.html">Integrating Amazon Pinpoint with your application</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p></note>', 'refs' => [ 'Activity$ConditionalSplit' => '<p>The settings for a yes/no split activity. This type of activity sends participants down one of two paths in a journey, based on conditions that you specify.</p>', ], ], 'ConflictException' => [ 'base' => '<p>Provides information about an API request or response.</p>', 'refs' => [], ], 'ContactCenterActivity' => [ 'base' => '<p>The settings for a connect activity. This type of activity initiates a contact center call to participants.</p>', 'refs' => [ 'Activity$ContactCenter' => '<p>The settings for a connect activity. This type of activity initiates a contact center call to participants.</p>', ], ], 'CreateApplicationRequest' => [ 'base' => '<p>Specifies the display name of an application and the tags to associate with the application.</p>', 'refs' => [], ], 'CreateRecommenderConfiguration' => [ 'base' => '<p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>', 'refs' => [], ], 'CreateTemplateMessageBody' => [ 'base' => '<p>Provides information about a request to create a message template.</p>', 'refs' => [], ], 'CustomDeliveryConfiguration' => [ 'base' => '<p>Specifies the delivery configuration settings for sending a campaign or campaign treatment through a custom channel. This object is required if you use the CampaignCustomMessage object to define the message to send for the campaign or campaign treatment.</p>', 'refs' => [ 'CampaignResponse$CustomDeliveryConfiguration' => '<p>The delivery configuration settings for sending the campaign through a custom channel.</p>', 'TreatmentResource$CustomDeliveryConfiguration' => '<p>The delivery configuration settings for sending the treatment through a custom channel. This object is required if the MessageConfiguration object for the treatment specifies a CustomMessage object.</p>', 'WriteCampaignRequest$CustomDeliveryConfiguration' => '<p>The delivery configuration settings for sending the campaign through a custom channel. This object is required if the MessageConfiguration object for the campaign specifies a CustomMessage object.</p>', 'WriteTreatmentResource$CustomDeliveryConfiguration' => '<p>The delivery configuration settings for sending the treatment through a custom channel. This object is required if the MessageConfiguration object for the treatment specifies a CustomMessage object.</p>', ], ], 'CustomMessageActivity' => [ 'base' => '<p>The settings for a custom message activity. This type of activity calls an AWS Lambda function or web hook that sends messages to participants.</p>', 'refs' => [ 'Activity$CUSTOM' => '<p>The settings for a custom message activity. This type of activity calls an AWS Lambda function or web hook that sends messages to participants.</p>', ], ], 'DefaultButtonConfiguration' => [ 'base' => '<p>Default button configuration.</p>', 'refs' => [ 'InAppMessageButton$DefaultConfig' => '<p>Default button content.</p>', ], ], 'DefaultMessage' => [ 'base' => '<p>Specifies the default message for all channels.</p>', 'refs' => [ 'DirectMessageConfiguration$DefaultMessage' => '<p>The default message for all channels.</p>', ], ], 'DefaultPushNotificationMessage' => [ 'base' => '<p>Specifies the default settings and content for a push notification that\'s sent directly to an endpoint.</p>', 'refs' => [ 'DirectMessageConfiguration$DefaultPushNotificationMessage' => '<p>The default push notification message for all push notification channels.</p>', ], ], 'DefaultPushNotificationTemplate' => [ 'base' => '<p>Specifies the default settings and content for a message template that can be used in messages that are sent through a push notification channel.</p>', 'refs' => [ 'PushNotificationTemplateRequest$Default' => '<p>The default message template to use for push notification channels.</p>', 'PushNotificationTemplateResponse$Default' => '<p>The default message template that\'s used for push notification channels.</p>', ], ], 'DeliveryStatus' => [ 'base' => NULL, 'refs' => [ 'EndpointMessageResult$DeliveryStatus' => '<p>The delivery status of the message. Possible values are:</p> <ul> <li><p>DUPLICATE - The endpoint address is a duplicate of another endpoint address. Amazon Pinpoint won\'t attempt to send the message again.</p></li> <li><p>OPT_OUT - The user who\'s associated with the endpoint has opted out of receiving messages from you. Amazon Pinpoint won\'t attempt to send the message again.</p></li> <li><p>PERMANENT_FAILURE - An error occurred when delivering the message to the endpoint. Amazon Pinpoint won\'t attempt to send the message again.</p></li> <li><p>SUCCESSFUL - The message was successfully delivered to the endpoint.</p></li> <li><p>TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won\'t attempt to send the message again.</p></li> <li><p>THROTTLED - Amazon Pinpoint throttled the operation to send the message to the endpoint.</p></li> <li><p>UNKNOWN_FAILURE - An unknown error occurred.</p></li></ul>', 'MessageResult$DeliveryStatus' => '<p>The delivery status of the message. Possible values are:</p> <ul> <li><p>DUPLICATE - The endpoint address is a duplicate of another endpoint address. Amazon Pinpoint won\'t attempt to send the message again.</p></li> <li><p>OPT_OUT - The user who\'s associated with the endpoint address has opted out of receiving messages from you. Amazon Pinpoint won\'t attempt to send the message again.</p></li> <li><p>PERMANENT_FAILURE - An error occurred when delivering the message to the endpoint address. Amazon Pinpoint won\'t attempt to send the message again.</p></li> <li><p>SUCCESSFUL - The message was successfully delivered to the endpoint address.</p></li> <li><p>TEMPORARY_FAILURE - A temporary error occurred. Amazon Pinpoint won\'t attempt to send the message again.</p></li> <li><p>THROTTLED - Amazon Pinpoint throttled the operation to send the message to the endpoint address.</p></li> <li><p>UNKNOWN_FAILURE - An unknown error occurred.</p></li></ul>', ], ], 'DimensionType' => [ 'base' => NULL, 'refs' => [ 'SetDimension$DimensionType' => '<p>The type of segment dimension to use. Valid values are: INCLUSIVE, endpoints that match the criteria are included in the segment; and, EXCLUSIVE, endpoints that match the criteria are excluded from the segment.</p>', ], ], 'DirectMessageConfiguration' => [ 'base' => '<p>Specifies the settings and content for the default message and any default messages that you tailored for specific channels.</p>', 'refs' => [ 'MessageRequest$MessageConfiguration' => '<p>The settings and content for the default message and any default messages that you defined for specific channels.</p>', 'SendUsersMessageRequest$MessageConfiguration' => '<p>The settings and content for the default message and any default messages that you defined for specific channels.</p>', ], ], 'Duration' => [ 'base' => NULL, 'refs' => [ 'RecencyDimension$Duration' => '<p>The duration to use when determining whether an endpoint is active or inactive.</p>', ], ], 'EmailChannelRequest' => [ 'base' => '<p>Specifies the status and settings of the email channel for an application.</p>', 'refs' => [], ], 'EmailChannelResponse' => [ 'base' => '<p>Provides information about the status and settings of the email channel for an application.</p>', 'refs' => [], ], 'EmailMessage' => [ 'base' => '<p>Specifies the default settings and content for a one-time email message that\'s sent directly to an endpoint.</p>', 'refs' => [ 'DirectMessageConfiguration$EmailMessage' => '<p>The default message for the email channel. This message overrides the default message (DefaultMessage).</p>', ], ], 'EmailMessageActivity' => [ 'base' => '<p>Specifies the settings for an email activity in a journey. This type of activity sends an email message to participants.</p>', 'refs' => [ 'Activity$EMAIL' => '<p>The settings for an email activity. This type of activity sends an email message to participants.</p>', ], ], 'EmailTemplateRequest' => [ 'base' => '<p>Specifies the content and settings for a message template that can be used in messages that are sent through the email channel.</p>', 'refs' => [], ], 'EmailTemplateResponse' => [ 'base' => '<p>Provides information about the content and settings for a message template that can be used in messages that are sent through the email channel.</p>', 'refs' => [], ], 'EndpointBatchItem' => [ 'base' => '<p>Specifies an endpoint to create or update and the settings and attributes to set or change for the endpoint.</p>', 'refs' => [ 'ListOfEndpointBatchItem$member' => NULL, ], ], 'EndpointBatchRequest' => [ 'base' => '<p>Specifies a batch of endpoints to create or update and the settings and attributes to set or change for each endpoint.</p>', 'refs' => [], ], 'EndpointDemographic' => [ 'base' => '<p>Specifies demographic information about an endpoint, such as the applicable time zone and platform.</p>', 'refs' => [ 'EndpointBatchItem$Demographic' => '<p>The demographic information for the endpoint, such as the time zone and platform.</p>', 'EndpointRequest$Demographic' => '<p>The demographic information for the endpoint, such as the time zone and platform.</p>', 'EndpointResponse$Demographic' => '<p>The demographic information for the endpoint, such as the time zone and platform.</p>', 'PublicEndpoint$Demographic' => '<p>The demographic information for the endpoint, such as the time zone and platform.</p>', ], ], 'EndpointItemResponse' => [ 'base' => '<p>Provides the status code and message that result from processing data for an endpoint.</p>', 'refs' => [ 'ItemResponse$EndpointItemResponse' => '<p>The response that was received after the endpoint data was accepted.</p>', ], ], 'EndpointLocation' => [ 'base' => '<p>Specifies geographic information about an endpoint.</p>', 'refs' => [ 'EndpointBatchItem$Location' => '<p>The geographic information for the endpoint.</p>', 'EndpointRequest$Location' => '<p>The geographic information for the endpoint.</p>', 'EndpointResponse$Location' => '<p>The geographic information for the endpoint.</p>', 'PublicEndpoint$Location' => '<p>The geographic information for the endpoint.</p>', ], ], 'EndpointMessageResult' => [ 'base' => '<p>Provides information about the delivery status and results of sending a message directly to an endpoint.</p>', 'refs' => [ 'MapOfEndpointMessageResult$member' => NULL, ], ], 'EndpointRequest' => [ 'base' => '<p>Specifies the channel type and other settings for an endpoint.</p>', 'refs' => [], ], 'EndpointResponse' => [ 'base' => '<p>Provides information about the channel type and other settings for an endpoint.</p>', 'refs' => [ 'ListOfEndpointResponse$member' => NULL, ], ], 'EndpointSendConfiguration' => [ 'base' => '<p>Specifies the content, including message variables and attributes, to use in a message that\'s sent directly to an endpoint.</p>', 'refs' => [ 'MapOfEndpointSendConfiguration$member' => NULL, ], ], 'EndpointUser' => [ 'base' => '<p>Specifies data for one or more attributes that describe the user who\'s associated with an endpoint.</p>', 'refs' => [ 'EndpointBatchItem$User' => '<p>One or more custom attributes that describe the user who\'s associated with the endpoint.</p>', 'EndpointRequest$User' => '<p>One or more custom attributes that describe the user who\'s associated with the endpoint.</p>', 'EndpointResponse$User' => '<p>One or more custom user attributes that your app reports to Amazon Pinpoint for the user who\'s associated with the endpoint.</p>', 'PublicEndpoint$User' => '<p>One or more custom user attributes that your app reports to Amazon Pinpoint for the user who\'s associated with the endpoint.</p>', ], ], 'EndpointsResponse' => [ 'base' => '<p>Provides information about all the endpoints that are associated with a user ID.</p>', 'refs' => [], ], 'Event' => [ 'base' => '<p>Specifies information about an event that reports data to Amazon Pinpoint.</p>', 'refs' => [ 'MapOfEvent$member' => NULL, ], ], 'EventCondition' => [ 'base' => '<p>Specifies the conditions to evaluate for an event that applies to an activity in a journey.</p>', 'refs' => [ 'SimpleCondition$EventCondition' => '<p>The dimension settings for the event that\'s associated with the activity.</p>', ], ], 'EventDimensions' => [ 'base' => '<p>Specifies the dimensions for an event filter that determines when a campaign is sent or a journey activity is performed.</p>', 'refs' => [ 'CampaignEventFilter$Dimensions' => '<p>The dimension settings of the event filter for the campaign.</p>', 'EventCondition$Dimensions' => '<p>The dimensions for the event filter to use for the activity.</p>', 'EventFilter$Dimensions' => '<p>The dimensions for the event filter to use for the campaign or the journey activity.</p>', ], ], 'EventFilter' => [ 'base' => '<p>Specifies the settings for an event that causes a campaign to be sent or a journey activity to be performed.</p>', 'refs' => [ 'EventStartCondition$EventFilter' => NULL, ], ], 'EventItemResponse' => [ 'base' => '<p>Provides the status code and message that result from processing an event.</p>', 'refs' => [ 'MapOfEventItemResponse$member' => NULL, ], ], 'EventStartCondition' => [ 'base' => '<p>Specifies the settings for an event that causes a journey activity to start.</p>', 'refs' => [ 'StartCondition$EventStartCondition' => NULL, ], ], 'EventStream' => [ 'base' => '<p>Specifies settings for publishing event data to an Amazon Kinesis data stream or an Amazon Kinesis Data Firehose delivery stream.</p>', 'refs' => [], ], 'EventsBatch' => [ 'base' => '<p>Specifies a batch of endpoints and events to process.</p>', 'refs' => [ 'MapOfEventsBatch$member' => NULL, ], ], 'EventsRequest' => [ 'base' => '<p>Specifies a batch of events to process.</p>', 'refs' => [], ], 'EventsResponse' => [ 'base' => '<p>Provides information about endpoints and the events that they\'re associated with.</p>', 'refs' => [], ], 'ExportJobRequest' => [ 'base' => '<p>Specifies the settings for a job that exports endpoint definitions to an Amazon Simple Storage Service (Amazon S3) bucket.</p>', 'refs' => [], ], 'ExportJobResource' => [ 'base' => '<p>Provides information about the resource settings for a job that exports endpoint definitions to a file. The file can be added directly to an Amazon Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API or downloaded directly to a computer by using the Amazon Pinpoint console.</p>', 'refs' => [ 'ExportJobResponse$Definition' => '<p>The resource settings that apply to the export job.</p>', ], ], 'ExportJobResponse' => [ 'base' => '<p>Provides information about the status and settings of a job that exports endpoint definitions to a file. The file can be added directly to an Amazon Simple Storage Service (Amazon S3) bucket by using the Amazon Pinpoint API or downloaded directly to a computer by using the Amazon Pinpoint console.</p>', 'refs' => [ 'ListOfExportJobResponse$member' => NULL, ], ], 'ExportJobsResponse' => [ 'base' => '<p>Provides information about all the export jobs that are associated with an application or segment. An export job is a job that exports endpoint definitions to a file.</p>', 'refs' => [], ], 'FilterType' => [ 'base' => NULL, 'refs' => [ 'CampaignEventFilter$FilterType' => '<p>The type of event that causes the campaign to be sent. Valid values are: SYSTEM, sends the campaign when a system event occurs; and, ENDPOINT, sends the campaign when an endpoint event (<link linkend="apps-application-id-events">Events</link> resource) occurs.</p>', 'EventFilter$FilterType' => '<p>The type of event that causes the campaign to be sent or the journey activity to be performed. Valid values are: SYSTEM, sends the campaign or performs the activity when a system event occurs; and, ENDPOINT, sends the campaign or performs the activity when an endpoint event (<link linkend="apps-application-id-events">Events resource</link>) occurs.</p>', ], ], 'ForbiddenException' => [ 'base' => '<p>Provides information about an API request or response.</p>', 'refs' => [], ], 'Format' => [ 'base' => NULL, 'refs' => [ 'ImportJobRequest$Format' => '<p>The format of the files that contain the endpoint definitions to import. Valid values are: CSV, for comma-separated values format; and, JSON, for newline-delimited JSON format. If the Amazon S3 location stores multiple files that use different formats, Amazon Pinpoint imports data only from the files that use the specified format.</p>', 'ImportJobResource$Format' => '<p>The format of the files that contain the endpoint definitions to import. Valid values are: CSV, for comma-separated values format; and, JSON, for newline-delimited JSON format.</p> <p>If the files are stored in an Amazon S3 location and that location contains multiple files that use different formats, Amazon Pinpoint imports data only from the files that use the specified format.</p>', 'SegmentImportResource$Format' => '<p>The format of the files that were imported to create the segment. Valid values are: CSV, for comma-separated values format; and, JSON, for newline-delimited JSON format.</p>', ], ], 'Frequency' => [ 'base' => NULL, 'refs' => [ 'Schedule$Frequency' => '<p>Specifies how often the campaign is sent or whether the campaign is sent in response to a specific event.</p>', ], ], 'GCMChannelRequest' => [ 'base' => '<p>Specifies the status and settings of the GCM channel for an application. This channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>', 'refs' => [], ], 'GCMChannelResponse' => [ 'base' => '<p>Provides information about the status and settings of the GCM channel for an application. The GCM channel enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>', 'refs' => [], ], 'GCMMessage' => [ 'base' => '<p>Specifies the settings for a one-time message that\'s sent directly to an endpoint through the GCM channel. The GCM channel enables Amazon Pinpoint to send messages to the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service.</p>', 'refs' => [ 'DirectMessageConfiguration$GCMMessage' => '<p>The default push notification message for the GCM channel, which is used to send notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. This message overrides the default push notification message (DefaultPushNotificationMessage).</p>', ], ], 'GPSCoordinates' => [ 'base' => '<p>Specifies the GPS coordinates of a location.</p>', 'refs' => [ 'GPSPointDimension$Coordinates' => '<p>The GPS coordinates to measure distance from.</p>', ], ], 'GPSPointDimension' => [ 'base' => '<p>Specifies GPS-based criteria for including or excluding endpoints from a segment.</p>', 'refs' => [ 'SegmentLocation$GPSPoint' => '<p>The GPS location and range for the segment.</p>', ], ], 'HoldoutActivity' => [ 'base' => '<p>Specifies the settings for a holdout activity in a journey. This type of activity stops a journey for a specified percentage of participants.</p>', 'refs' => [ 'Activity$Holdout' => '<p>The settings for a holdout activity. This type of activity stops a journey for a specified percentage of participants.</p>', ], ], 'ImportJobRequest' => [ 'base' => '<p>Specifies the settings for a job that imports endpoint definitions from an Amazon Simple Storage Service (Amazon S3) bucket.</p>', 'refs' => [], ], 'ImportJobResource' => [ 'base' => '<p>Provides information about the resource settings for a job that imports endpoint definitions from one or more files. The files can be stored in an Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from a computer by using the Amazon Pinpoint console.</p>', 'refs' => [ 'ImportJobResponse$Definition' => '<p>The resource settings that apply to the import job.</p>', ], ], 'ImportJobResponse' => [ 'base' => '<p>Provides information about the status and settings of a job that imports endpoint definitions from one or more files. The files can be stored in an Amazon Simple Storage Service (Amazon S3) bucket or uploaded directly from a computer by using the Amazon Pinpoint console.</p>', 'refs' => [ 'ListOfImportJobResponse$member' => NULL, ], ], 'ImportJobsResponse' => [ 'base' => '<p>Provides information about the status and settings of all the import jobs that are associated with an application or segment. An import job is a job that imports endpoint definitions from one or more files.</p>', 'refs' => [], ], 'InAppCampaignSchedule' => [ 'base' => NULL, 'refs' => [ 'InAppMessageCampaign$Schedule' => '<p>Schedule of the campaign.</p>', ], ], 'InAppMessage' => [ 'base' => '<p>Provides all fields required for building an in-app message.</p>', 'refs' => [ 'InAppMessageCampaign$InAppMessage' => '<p>In-app message content with all fields required for rendering an in-app message.</p>', ], ], 'InAppMessageBodyConfig' => [ 'base' => '<p>Text config for Message Body.</p>', 'refs' => [ 'InAppMessageContent$BodyConfig' => '<p>The configuration for the message body.</p>', ], ], 'InAppMessageButton' => [ 'base' => '<p>Button Config for an in-app message.</p>', 'refs' => [ 'InAppMessageContent$PrimaryBtn' => '<p>The first button inside the message.</p>', 'InAppMessageContent$SecondaryBtn' => '<p>The second button inside message.</p>', ], ], 'InAppMessageCampaign' => [ 'base' => NULL, 'refs' => [ 'ListOfInAppMessageCampaign$member' => NULL, ], ], 'InAppMessageContent' => [ 'base' => '<p>The configuration for the message content.</p>', 'refs' => [ 'ListOfInAppMessageContent$member' => NULL, ], ], 'InAppMessageHeaderConfig' => [ 'base' => '<p>Text config for Message Header.</p>', 'refs' => [ 'InAppMessageContent$HeaderConfig' => '<p>The configuration for the message header.</p>', ], ], 'InAppMessagesResponse' => [ 'base' => '<p>Get in-app messages response object.</p>', 'refs' => [], ], 'InAppTemplateRequest' => [ 'base' => '<p>In-App Template Request.</p>', 'refs' => [], ], 'InAppTemplateResponse' => [ 'base' => '<p>In-App Template Response.</p>', 'refs' => [], ], 'Include' => [ 'base' => NULL, 'refs' => [ 'SegmentGroupList$Include' => '<p>Specifies how to handle multiple segment groups for the segment. For example, if the segment includes three segment groups, whether the resulting segment includes endpoints that match all, any, or none of the segment groups.</p>', ], ], 'InternalServerErrorException' => [ 'base' => '<p>Provides information about an API request or response.</p>', 'refs' => [], ], 'ItemResponse' => [ 'base' => '<p>Provides information about the results of a request to create or update an endpoint that\'s associated with an event.</p>', 'refs' => [ 'MapOfItemResponse$member' => NULL, ], ], 'JobStatus' => [ 'base' => NULL, 'refs' => [ 'ExportJobResponse$JobStatus' => '<p>The status of the export job. The job status is FAILED if Amazon Pinpoint wasn\'t able to process one or more pieces in the job.</p>', 'ImportJobResponse$JobStatus' => '<p>The status of the import job. The job status is FAILED if Amazon Pinpoint wasn\'t able to process one or more pieces in the job.</p>', ], ], 'JourneyChannelSettings' => [ 'base' => '<p>The channel-specific configurations for the journey.</p>', 'refs' => [ 'JourneyResponse$JourneyChannelSettings' => '<p>Amazon Resource Name (ARN) of the Connect Campaign.</p>', 'WriteJourneyRequest$JourneyChannelSettings' => '<p>IAM role ARN to be assumed when invoking Connect campaign execution APIs for dialing.</p>', ], ], 'JourneyCustomMessage' => [ 'base' => '<p>Specifies the message content for a custom channel message that\'s sent to participants in a journey.</p>', 'refs' => [ 'CustomMessageActivity$MessageConfig' => '<p>Specifies the message data included in a custom channel message that\'s sent to participants in a journey.</p>', ], ], 'JourneyDateRangeKpiResponse' => [ 'base' => '<p>Provides the results of a query that retrieved the data for a standard engagement metric that applies to a journey, and provides information about that query.</p>', 'refs' => [], ], 'JourneyEmailMessage' => [ 'base' => '<p>Specifies the "From" address for an email message that\'s sent to participants in a journey.</p>', 'refs' => [ 'EmailMessageActivity$MessageConfig' => '<p>Specifies the sender address for an email message that\'s sent to participants in the journey.</p>', ], ], 'JourneyExecutionActivityMetricsResponse' => [ 'base' => '<p>Provides the results of a query that retrieved the data for a standard execution metric that applies to a journey activity, and provides information about that query.</p>', 'refs' => [], ], 'JourneyExecutionMetricsResponse' => [ 'base' => '<p>Provides the results of a query that retrieved the data for a standard execution metric that applies to a journey, and provides information about that query.</p>', 'refs' => [], ], 'JourneyLimits' => [ 'base' => '<p>Specifies limits on the messages that a journey can send and the number of times participants can enter a journey.</p>', 'refs' => [ 'JourneyResponse$Limits' => '<p>The messaging and entry limits for the journey.</p>', 'WriteJourneyRequest$Limits' => '<p>The messaging and entry limits for the journey.</p>', ], ], 'JourneyPushMessage' => [ 'base' => '<p>Specifies the message configuration for a push notification that\'s sent to participants in a journey.</p>', 'refs' => [ 'PushMessageActivity$MessageConfig' => '<p>Specifies the time to live (TTL) value for push notifications that are sent to participants in a journey.</p>', ], ], 'JourneyResponse' => [ 'base' => '<p>Provides information about the status, configuration, and other settings for a journey.</p>', 'refs' => [ 'ListOfJourneyResponse$member' => NULL, ], ], 'JourneyRunExecutionActivityMetricsResponse' => [ 'base' => '<p>Provides the results of a query that retrieved the data for a standard execution metric that applies to a journey activity for a particular journey run, and provides information about that query.</p>', 'refs' => [], ], 'JourneyRunExecutionMetricsResponse' => [ 'base' => '<p>Provides the results of a query that retrieved the data for a standard execution metric that applies to a journey run, and provides information about that query.</p>', 'refs' => [], ], 'JourneyRunResponse' => [ 'base' => '<p>Provides information from a specified run of a journey.</p>', 'refs' => [ 'ListOfJourneyRunResponse$member' => NULL, ], ], 'JourneyRunsResponse' => [ 'base' => '<p>Provides information from all runs of a journey.</p>', 'refs' => [], ], 'JourneyRunStatus' => [ 'base' => NULL, 'refs' => [ 'JourneyRunResponse$Status' => '<p>The current status of the journey run.</p>', ], ], 'JourneySMSMessage' => [ 'base' => '<p>Specifies the sender ID and message type for an SMS message that\'s sent to participants in a journey.</p>', 'refs' => [ 'SMSMessageActivity$MessageConfig' => '<p>Specifies the sender ID and message type for an SMS message that\'s sent to participants in a journey.</p>', ], ], 'JourneySchedule' => [ 'base' => '<p>Specifies the schedule settings for a journey.</p>', 'refs' => [ 'JourneyResponse$Schedule' => '<p>The schedule settings for the journey.</p>', 'WriteJourneyRequest$Schedule' => '<p>The schedule settings for the journey.</p>', ], ], 'JourneyStateRequest' => [ 'base' => '<p>Changes the status of a journey.</p>', 'refs' => [], ], 'JourneyTimeframeCap' => [ 'base' => '<p>The number of messages that can be sent to an endpoint during the specified timeframe for all journeys.</p>', 'refs' => [ 'ApplicationSettingsJourneyLimits$TimeframeCap' => '<p>The default maximum number of messages that can be sent to an endpoint during the specified timeframe for all journeys.</p>', 'JourneyLimits$TimeframeCap' => '<p>The number of messages that an endpoint can receive during the specified timeframe.</p>', ], ], 'JourneysResponse' => [ 'base' => '<p>Provides information about the status, configuration, and other settings for all the journeys that are associated with an application.</p>', 'refs' => [], ], 'Layout' => [ 'base' => NULL, 'refs' => [ 'CampaignInAppMessage$Layout' => '<p>In-app message layout.</p>', 'InAppMessage$Layout' => '<p>The layout of the message.</p>', 'InAppTemplateRequest$Layout' => '<p>The layout of the message.</p>', 'InAppTemplateResponse$Layout' => '<p>The layout of the message.</p>', ], ], 'ListRecommenderConfigurationsResponse' => [ 'base' => '<p>Provides information about all the recommender model configurations that are associated with your Amazon Pinpoint account.</p>', 'refs' => [], ], 'Message' => [ 'base' => '<p>Specifies the content and settings for a push notification that\'s sent to recipients of a campaign.</p>', 'refs' => [ 'MessageConfiguration$ADMMessage' => '<p>The message that the campaign sends through the ADM (Amazon Device Messaging) channel. If specified, this message overrides the default message.</p>', 'MessageConfiguration$APNSMessage' => '<p>The message that the campaign sends through the APNs (Apple Push Notification service) channel. If specified, this message overrides the default message.</p>', 'MessageConfiguration$BaiduMessage' => '<p>The message that the campaign sends through the Baidu (Baidu Cloud Push) channel. If specified, this message overrides the default message.</p>', 'MessageConfiguration$DefaultMessage' => '<p>The default message that the campaign sends through all the channels that are configured for the campaign.</p>', 'MessageConfiguration$GCMMessage' => '<p>The message that the campaign sends through the GCM channel, which enables Amazon Pinpoint to send push notifications through the Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), service. If specified, this message overrides the default message.</p>', ], ], 'MessageBody' => [ 'base' => '<p>Provides information about an API request or response.</p>', 'refs' => [], ], 'MessageConfiguration' => [ 'base' => '<p>Specifies the message configuration settings for a campaign.</p>', 'refs' => [ 'CampaignResponse$MessageConfiguration' => '<p>The message configuration settings for the campaign.</p>', 'TreatmentResource$MessageConfiguration' => '<p>The message configuration settings for the treatment.</p>', 'WriteCampaignRequest$MessageConfiguration' => '<p>The message configuration settings for the campaign.</p>', 'WriteTreatmentResource$MessageConfiguration' => '<p>The message configuration settings for the treatment.</p>', ], ], 'MessageHeader' => [ 'base' => '<p>Contains the name and value pair of an email header to add to your email. You can have up to 15 MessageHeaders. A header can contain information such as the sender, receiver, route, or timestamp.</p>', 'refs' => [ 'ListOfMessageHeader$member' => NULL, ], ], 'MessageRequest' => [ 'base' => '<p>Specifies the configuration and other settings for a message.</p>', 'refs' => [], ], 'MessageResponse' => [ 'base' => '<p>Provides information about the results of a request to send a message to an endpoint address.</p>', 'refs' => [], ], 'MessageResult' => [ 'base' => '<p>Provides information about the results of sending a message directly to an endpoint address.</p>', 'refs' => [ 'MapOfMessageResult$member' => NULL, ], ], 'MessageType' => [ 'base' => NULL, 'refs' => [ 'CampaignSmsMessage$MessageType' => '<p>The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren\'t critical or time-sensitive, such as marketing messages).</p>', 'JourneySMSMessage$MessageType' => '<p>The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren\'t critical or time-sensitive, such as marketing messages).</p>', 'SMSMessage$MessageType' => '<p>The SMS message type. Valid values are TRANSACTIONAL (for messages that are critical or time-sensitive, such as a one-time passwords) and PROMOTIONAL (for messsages that aren\'t critical or time-sensitive, such as marketing messages).</p>', ], ], 'MethodNotAllowedException' => [ 'base' => '<p>Provides information about an API request or response.</p>', 'refs' => [], ], 'MetricDimension' => [ 'base' => '<p>Specifies metric-based criteria for including or excluding endpoints from a segment. These criteria derive from custom metrics that you define for endpoints.</p>', 'refs' => [ 'MapOfMetricDimension$member' => NULL, ], ], 'Mode' => [ 'base' => NULL, 'refs' => [ 'CampaignHook$Mode' => '<p>The mode that Amazon Pinpoint uses to invoke the AWS Lambda function. Possible values are:</p> <ul><li><p>FILTER - Invoke the function to customize the segment that\'s used by a campaign.</p></li> <li><p>DELIVERY - (Deprecated) Previously, invoked the function to send a campaign through a custom channel. This functionality is not supported anymore. To send a campaign through a custom channel, use the CustomDeliveryConfiguration and CampaignCustomMessage objects of the campaign.</p></li></ul>', ], ], 'MultiConditionalBranch' => [ 'base' => '<p>Specifies a condition to evaluate for an activity path in a journey.</p>', 'refs' => [ 'ListOfMultiConditionalBranch$member' => NULL, ], ], 'MultiConditionalSplitActivity' => [ 'base' => '<p>Specifies the settings for a multivariate split activity in a journey. This type of activity sends participants down one of as many as five paths (including a default <i>Else</i> path) in a journey, based on conditions that you specify.</p> <note><p>To create multivariate split activities that send participants down different paths based on push notification events (such as Open or Received events), your mobile app has to specify the User ID and Endpoint ID values. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/integrate.html">Integrating Amazon Pinpoint with your application</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p></note>', 'refs' => [ 'Activity$MultiCondition' => '<p>The settings for a multivariate split activity. This type of activity sends participants down one of as many as five paths (including a default <i>Else</i> path) in a journey, based on conditions that you specify.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>Provides information about an API request or response.</p>', 'refs' => [], ], 'NumberValidateRequest' => [ 'base' => '<p>Specifies a phone number to validate and retrieve information about.</p>', 'refs' => [], ], 'NumberValidateResponse' => [ 'base' => '<p>Provides information about a phone number.</p>', 'refs' => [], ], 'Operator' => [ 'base' => NULL, 'refs' => [ 'Condition$Operator' => '<p>Specifies how to handle multiple conditions for the activity. For example, if you specify two conditions for an activity, whether both or only one of the conditions must be met for the activity to be performed.</p>', ], ], 'OverrideButtonConfiguration' => [ 'base' => '<p>Override button configuration.</p>', 'refs' => [ 'InAppMessageButton$Android' => '<p>Default button content.</p>', 'InAppMessageButton$IOS' => '<p>Default button content.</p>', 'InAppMessageButton$Web' => '<p>Default button content.</p>', ], ], 'PayloadTooLargeException' => [ 'base' => '<p>Provides information about an API request or response.</p>', 'refs' => [], ], 'PublicEndpoint' => [ 'base' => '<p>Specifies the properties and attributes of an endpoint that\'s associated with an event.</p>', 'refs' => [ 'EventsBatch$Endpoint' => '<p>A set of properties and attributes that are associated with the endpoint.</p>', ], ], 'PushMessageActivity' => [ 'base' => '<p>Specifies the settings for a push notification activity in a journey. This type of activity sends a push notification to participants.</p>', 'refs' => [ 'Activity$PUSH' => '<p>The settings for a push notification activity. This type of activity sends a push notification to participants.</p>', ], ], 'PushNotificationTemplateRequest' => [ 'base' => '<p>Specifies the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>', 'refs' => [], ], 'PushNotificationTemplateResponse' => [ 'base' => '<p>Provides information about the content and settings for a message template that can be used in messages that are sent through a push notification channel.</p>', 'refs' => [], ], 'QuietTime' => [ 'base' => '<p>Specifies the start and end times that define a time range when messages aren\'t sent to endpoints.</p>', 'refs' => [ 'ApplicationSettingsResource$QuietTime' => '<p>The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren\'t sent to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint\'s time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).</p></li> <li><p>The current time in the endpoint\'s time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).</p></li></ul> <p>If any of the preceding conditions isn\'t met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.</p>', 'InAppCampaignSchedule$QuietTime' => '<p>Time during which the in-app message should not be shown to the user.</p>', 'JourneyResponse$QuietTime' => '<p>The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn\'t send messages to participants, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.</p></li> <li><p>The current time in the participant\'s time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.</p></li> <li><p>The current time in the participant\'s time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.</p></li></ul> <p>If any of the preceding conditions isn\'t met, the participant will receive messages from the journey, even if quiet time is enabled.</p>', 'Schedule$QuietTime' => '<p>The default quiet time for the campaign. Quiet time is a specific time range when a campaign doesn\'t send messages to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint\'s time zone is later than or equal to the time specified by the QuietTime.Start property for the campaign.</p></li> <li><p>The current time in the endpoint\'s time zone is earlier than or equal to the time specified by the QuietTime.End property for the campaign.</p></li></ul> <p>If any of the preceding conditions isn\'t met, the endpoint will receive messages from the campaign, even if quiet time is enabled.</p>', 'WriteApplicationSettingsRequest$QuietTime' => '<p>The default quiet time for campaigns in the application. Quiet time is a specific time range when messages aren\'t sent to endpoints, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint is set to a valid value.</p></li> <li><p>The current time in the endpoint\'s time zone is later than or equal to the time specified by the QuietTime.Start property for the application (or a campaign or journey that has custom quiet time settings).</p></li> <li><p>The current time in the endpoint\'s time zone is earlier than or equal to the time specified by the QuietTime.End property for the application (or a campaign or journey that has custom quiet time settings).</p></li></ul> <p>If any of the preceding conditions isn\'t met, the endpoint will receive messages from a campaign or journey, even if quiet time is enabled.</p> <p>To override the default quiet time settings for a specific campaign or journey, use the <link linkend="apps-application-id-campaigns-campaign-id">Campaign</link> resource or the <link linkend="apps-application-id-journeys-journey-id">Journey</link> resource to define a custom quiet time for the campaign or journey.</p>', 'WriteJourneyRequest$QuietTime' => '<p>The quiet time settings for the journey. Quiet time is a specific time range when a journey doesn\'t send messages to participants, if all the following conditions are met:</p> <ul><li><p>The EndpointDemographic.Timezone property of the endpoint for the participant is set to a valid value.</p></li> <li><p>The current time in the participant\'s time zone is later than or equal to the time specified by the QuietTime.Start property for the journey.</p></li> <li><p>The current time in the participant\'s time zone is earlier than or equal to the time specified by the QuietTime.End property for the journey.</p></li></ul> <p>If any of the preceding conditions isn\'t met, the participant will receive messages from the journey, even if quiet time is enabled.</p>', ], ], 'RandomSplitActivity' => [ 'base' => '<p>Specifies the settings for a random split activity in a journey. This type of activity randomly sends specified percentages of participants down one of as many as five paths in a journey, based on conditions that you specify.</p>', 'refs' => [ 'Activity$RandomSplit' => '<p>The settings for a random split activity. This type of activity randomly sends specified percentages of participants down one of as many as five paths in a journey, based on conditions that you specify.</p>', ], ], 'RandomSplitEntry' => [ 'base' => '<p>Specifies the settings for a path in a random split activity in a journey.</p>', 'refs' => [ 'ListOfRandomSplitEntry$member' => NULL, ], ], 'RawEmail' => [ 'base' => '<p>Specifies the contents of an email message, represented as a raw MIME message.</p>', 'refs' => [ 'EmailMessage$RawEmail' => '<p>The email message, represented as a raw MIME message.</p>', ], ], 'RecencyDimension' => [ 'base' => '<p>Specifies criteria for including or excluding endpoints from a segment based on how recently an endpoint was active.</p>', 'refs' => [ 'SegmentBehaviors$Recency' => '<p>The dimension settings that are based on how recently an endpoint was active.</p>', ], ], 'RecencyType' => [ 'base' => NULL, 'refs' => [ 'RecencyDimension$RecencyType' => '<p>The type of recency dimension to use for the segment. Valid values are: ACTIVE, endpoints that were active within the specified duration are included in the segment; and, INACTIVE, endpoints that weren\'t active within the specified duration are included in the segment.</p>', ], ], 'RecommenderConfigurationResponse' => [ 'base' => '<p>Provides information about Amazon Pinpoint configuration settings for retrieving and processing data from a recommender model.</p>', 'refs' => [ 'ListOfRecommenderConfigurationResponse$member' => NULL, ], ], 'ResultRow' => [ 'base' => '<p>Provides the results of a query that retrieved the data for a standard metric that applies to an application, campaign, or journey.</p>', 'refs' => [ 'ListOfResultRow$member' => NULL, ], ], 'ResultRowValue' => [ 'base' => '<p>Provides a single value and metadata about that value as part of an array of query results for a standard metric that applies to an application, campaign, or journey.</p>', 'refs' => [ 'ListOfResultRowValue$member' => NULL, ], ], 'SMSChannelRequest' => [ 'base' => '<p>Specifies the status and settings of the SMS channel for an application.</p>', 'refs' => [], ], 'SMSChannelResponse' => [ 'base' => '<p>Provides information about the status and settings of the SMS channel for an application.</p>', 'refs' => [], ], 'SMSMessage' => [ 'base' => '<p>Specifies the default settings for a one-time SMS message that\'s sent directly to an endpoint.</p>', 'refs' => [ 'DirectMessageConfiguration$SMSMessage' => '<p>The default message for the SMS channel. This message overrides the default message (DefaultMessage).</p>', ], ], 'SMSMessageActivity' => [ 'base' => '<p>Specifies the settings for an SMS activity in a journey. This type of activity sends a text message to participants.</p>', 'refs' => [ 'Activity$SMS' => '<p>The settings for an SMS activity. This type of activity sends a text message to participants.</p>', ], ], 'SMSTemplateRequest' => [ 'base' => '<p>Specifies the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>', 'refs' => [], ], 'SMSTemplateResponse' => [ 'base' => '<p>Provides information about the content and settings for a message template that can be used in text messages that are sent through the SMS channel.</p>', 'refs' => [], ], 'Schedule' => [ 'base' => '<p>Specifies the schedule settings for a campaign.</p>', 'refs' => [ 'CampaignResponse$Schedule' => '<p>The schedule settings for the campaign.</p>', 'TreatmentResource$Schedule' => '<p>The schedule settings for the treatment.</p>', 'WriteCampaignRequest$Schedule' => '<p>The schedule settings for the campaign.</p>', 'WriteTreatmentResource$Schedule' => '<p>The schedule settings for the treatment.</p>', ], ], 'SegmentBehaviors' => [ 'base' => '<p>Specifies dimension settings for including or excluding endpoints from a segment based on how recently an endpoint was active.</p>', 'refs' => [ 'SegmentDimensions$Behavior' => '<p>The behavior-based criteria, such as how recently users have used your app, for the segment.</p>', ], ], 'SegmentCondition' => [ 'base' => '<p>Specifies a segment to associate with an activity in a journey.</p>', 'refs' => [ 'SimpleCondition$SegmentCondition' => '<p>The segment that\'s associated with the activity.</p>', 'StartCondition$SegmentStartCondition' => '<p>The segment that\'s associated with the first activity in the journey. This segment determines which users are participants in the journey.</p>', ], ], 'SegmentDemographics' => [ 'base' => '<p>Specifies demographic-based dimension settings for including or excluding endpoints from a segment. These settings derive from characteristics of endpoint devices, such as platform, make, and model.</p>', 'refs' => [ 'SegmentDimensions$Demographic' => '<p>The demographic-based criteria, such as device platform, for the segment.</p>', ], ], 'SegmentDimensions' => [ 'base' => '<p>Specifies the dimension settings for a segment.</p>', 'refs' => [ 'SegmentResponse$Dimensions' => '<p>The dimension settings for the segment.</p>', 'SimpleCondition$SegmentDimensions' => '<p>The dimension settings for the segment that\'s associated with the activity.</p>', 'WriteSegmentRequest$Dimensions' => '<p>The criteria that define the dimensions for the segment.</p>', 'ListOfSegmentDimensions$member' => NULL, ], ], 'SegmentGroup' => [ 'base' => '<p>Specifies the base segments and dimensions for a segment, and the relationships between these base segments and dimensions.</p>', 'refs' => [ 'ListOfSegmentGroup$member' => NULL, ], ], 'SegmentGroupList' => [ 'base' => '<p>Specifies the settings that define the relationships between segment groups for a segment.</p>', 'refs' => [ 'SegmentResponse$SegmentGroups' => '<p>A list of one or more segment groups that apply to the segment. Each segment group consists of zero or more base segments and the dimensions that are applied to those base segments.</p>', 'WriteSegmentRequest$SegmentGroups' => '<p>The segment group to use and the dimensions to apply to the group\'s base segments in order to build the segment. A segment group can consist of zero or more base segments. Your request can include only one segment group.</p>', ], ], 'SegmentImportResource' => [ 'base' => '<p>Provides information about the import job that created a segment. An import job is a job that creates a user segment by importing endpoint definitions.</p>', 'refs' => [ 'SegmentResponse$ImportDefinition' => '<p>The settings for the import job that\'s associated with the segment.</p>', ], ], 'SegmentLocation' => [ 'base' => '<p>Specifies geographical dimension settings for a segment.</p>', 'refs' => [ 'SegmentDimensions$Location' => '<p>The location-based criteria, such as region or GPS coordinates, for the segment.</p>', ], ], 'SegmentReference' => [ 'base' => '<p>Specifies the segment identifier and version of a segment.</p>', 'refs' => [ 'ListOfSegmentReference$member' => NULL, ], ], 'SegmentResponse' => [ 'base' => '<p>Provides information about the configuration, dimension, and other settings for a segment.</p>', 'refs' => [ 'ListOfSegmentResponse$member' => NULL, ], ], 'SegmentType' => [ 'base' => NULL, 'refs' => [ 'SegmentResponse$SegmentType' => '<p>The segment type. Valid values are:</p> <ul><li><p>DIMENSIONAL - A dynamic segment, which is a segment that uses selection criteria that you specify and is based on endpoint data that\'s reported by your app. Dynamic segments can change over time.</p></li> <li><p>IMPORT - A static segment, which is a segment that uses selection criteria that you specify and is based on endpoint definitions that you import from a file. Imported segments are static; they don\'t change over time.</p></li></ul>', ], ], 'SegmentsResponse' => [ 'base' => '<p>Provides information about all the segments that are associated with an application.</p>', 'refs' => [], ], 'SendOTPMessageRequestParameters' => [ 'base' => '<p>Send OTP message request parameters.</p>', 'refs' => [], ], 'SendUsersMessageRequest' => [ 'base' => '<p>Specifies the configuration and other settings for a message to send to all the endpoints that are associated with a list of users.</p>', 'refs' => [], ], 'SendUsersMessageResponse' => [ 'base' => '<p>Provides information about which users and endpoints a message was sent to.</p>', 'refs' => [], ], 'Session' => [ 'base' => '<p>Provides information about a session.</p>', 'refs' => [ 'Event$Session' => '<p>Information about the session in which the event occurred.</p>', ], ], 'SetDimension' => [ 'base' => '<p>Specifies the dimension type and values for a segment dimension.</p>', 'refs' => [ 'EventDimensions$EventType' => '<p>The name of the event that causes the campaign to be sent or the journey activity to be performed. This can be a standard event that Amazon Pinpoint generates, such as _email.delivered. For campaigns, this can also be a custom event that\'s specific to your application. For information about standard events, see <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/event-streams.html">Streaming Amazon Pinpoint Events</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>', 'SegmentDemographics$AppVersion' => '<p>The app version criteria for the segment.</p>', 'SegmentDemographics$Channel' => '<p>The channel criteria for the segment.</p>', 'SegmentDemographics$DeviceType' => '<p>The device type criteria for the segment.</p>', 'SegmentDemographics$Make' => '<p>The device make criteria for the segment.</p>', 'SegmentDemographics$Model' => '<p>The device model criteria for the segment.</p>', 'SegmentDemographics$Platform' => '<p>The device platform criteria for the segment.</p>', 'SegmentLocation$Country' => '<p>The country or region code, in ISO 3166-1 alpha-2 format, for the segment.</p>', ], ], 'SimpleCondition' => [ 'base' => '<p>Specifies a condition to evaluate for an activity in a journey.</p>', 'refs' => [ 'MultiConditionalBranch$Condition' => '<p>The condition to evaluate for the activity path.</p>', 'ListOfSimpleCondition$member' => NULL, ], ], 'SimpleEmail' => [ 'base' => '<p>Specifies the contents of an email message, composed of a subject, a text part, and an HTML part.</p>', 'refs' => [ 'EmailMessage$SimpleEmail' => '<p>The email message, composed of a subject, a text part, and an HTML part.</p>', ], ], 'SimpleEmailPart' => [ 'base' => '<p>Specifies the subject or body of an email message, represented as textual email data and the applicable character set.</p>', 'refs' => [ 'SimpleEmail$HtmlPart' => '<p>The body of the email message, in HTML format. We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.</p>', 'SimpleEmail$Subject' => '<p>The subject line, or title, of the email.</p>', 'SimpleEmail$TextPart' => '<p>The body of the email message, in plain text format. We recommend using plain text format for email clients that don\'t render HTML content and clients that are connected to high-latency networks, such as mobile devices.</p>', ], ], 'SourceType' => [ 'base' => NULL, 'refs' => [ 'SegmentGroup$SourceType' => '<p>Specifies how to handle multiple base segments for the segment. For example, if you specify three base segments for the segment, whether the resulting segment is based on all, any, or none of the base segments.</p>', ], ], 'StartCondition' => [ 'base' => '<p>Specifies the conditions for the first activity in a journey. This activity and its conditions determine which users are participants in a journey.</p>', 'refs' => [ 'JourneyResponse$StartCondition' => '<p>The segment that defines which users are participants in the journey.</p>', 'WriteJourneyRequest$StartCondition' => '<p>The segment that defines which users are participants in the journey.</p>', ], ], 'State' => [ 'base' => NULL, 'refs' => [ 'JourneyResponse$State' => '<p>The current status of the journey. Possible values are:</p> <ul><li><p>DRAFT - The journey is being developed and hasn\'t been published yet.</p></li> <li><p>ACTIVE - The journey has been developed and published. Depending on the journey\'s schedule, the journey may currently be running or scheduled to start running at a later time. If a journey\'s status is ACTIVE, you can\'t add, change, or remove activities from it.</p></li> <li><p>PAUSED - The journey has been paused. Amazon Pinpoint continues to perform activities that are currently in progress, until those activities are complete. </p></li> <li><p>COMPLETED - The journey has been published and has finished running. All participants have entered the journey and no participants are waiting to complete the journey or any activities in the journey.</p></li> <li><p>CANCELLED - The journey has been stopped. If a journey\'s status is CANCELLED, you can\'t add, change, or remove activities or segment settings from the journey.</p></li> <li><p>CLOSED - The journey has been published and has started running. It may have also passed its scheduled end time, or passed its scheduled start time and a refresh frequency hasn\'t been specified for it. If a journey\'s status is CLOSED, you can\'t add participants to it, and no existing participants can enter the journey for the first time. However, any existing participants who are currently waiting to start an activity may continue the journey.</p></li></ul>', 'JourneyStateRequest$State' => '<p>The status of the journey. Currently, Supported values are ACTIVE, PAUSED, and CANCELLED</p> <p>If you cancel a journey, Amazon Pinpoint continues to perform activities that are currently in progress, until those activities are complete. Amazon Pinpoint also continues to collect and aggregate analytics data for those activities, until they are complete, and any activities that were complete when you cancelled the journey.</p> <p>After you cancel a journey, you can\'t add, change, or remove any activities from the journey. In addition, Amazon Pinpoint stops evaluating the journey and doesn\'t perform any activities that haven\'t started.</p> <p>When the journey is paused, Amazon Pinpoint continues to perform activities that are currently in progress, until those activities are complete. Endpoints will stop entering journeys when the journey is paused and will resume entering the journey after the journey is resumed. For wait activities, wait time is paused when the journey is paused. Currently, PAUSED only supports journeys with a segment refresh interval.</p>', 'WriteJourneyRequest$State' => '<p>The status of the journey. Valid values are:</p> <ul><li><p>DRAFT - Saves the journey and doesn\'t publish it.</p></li> <li><p>ACTIVE - Saves and publishes the journey. Depending on the journey\'s schedule, the journey starts running immediately or at the scheduled start time. If a journey\'s status is ACTIVE, you can\'t add, change, or remove activities from it.</p></li></ul> <p>PAUSED, CANCELLED, COMPLETED, and CLOSED states are not supported in requests to create or update a journey. To cancel, pause, or resume a journey, use the <link linkend="apps-application-id-journeys-journey-id-state">Journey State</link> resource.</p>', ], ], 'TagsModel' => [ 'base' => '<p>Specifies the tags (keys and values) for an application, campaign, message template, or segment.</p>', 'refs' => [], ], 'Template' => [ 'base' => '<p>Specifies the name and version of the message template to use for the message.</p>', 'refs' => [ 'TemplateConfiguration$EmailTemplate' => '<p>The email template to use for the message.</p>', 'TemplateConfiguration$InAppTemplate' => '<p>The InApp template to use for the message. The InApp template object is not supported for SendMessages.</p>', 'TemplateConfiguration$PushTemplate' => '<p>The push notification template to use for the message.</p>', 'TemplateConfiguration$SMSTemplate' => '<p>The SMS template to use for the message.</p>', 'TemplateConfiguration$VoiceTemplate' => '<p>The voice template to use for the message. This object isn\'t supported for campaigns.</p>', ], ], 'TemplateActiveVersionRequest' => [ 'base' => '<p>Specifies which version of a message template to use as the active version of the template.</p>', 'refs' => [], ], 'TemplateConfiguration' => [ 'base' => '<p>Specifies the message template to use for the message, for each type of channel.</p>', 'refs' => [ 'CampaignResponse$TemplateConfiguration' => '<p>The message template that’s used for the campaign.</p>', 'MessageRequest$TemplateConfiguration' => '<p>The message template to use for the message.</p>', 'SendUsersMessageRequest$TemplateConfiguration' => '<p>The message template to use for the message.</p>', 'TreatmentResource$TemplateConfiguration' => '<p>The message template to use for the treatment.</p>', 'WriteCampaignRequest$TemplateConfiguration' => '<p>The message template to use for the campaign.</p>', 'WriteTreatmentResource$TemplateConfiguration' => '<p>The message template to use for the treatment.</p>', ], ], 'TemplateCreateMessageBody' => [ 'base' => '<p>Provides information about a request to create a message template.</p>', 'refs' => [], ], 'TemplateResponse' => [ 'base' => '<p>Provides information about a message template that\'s associated with your Amazon Pinpoint account.</p>', 'refs' => [ 'ListOfTemplateResponse$member' => NULL, ], ], 'TemplateType' => [ 'base' => NULL, 'refs' => [ 'EmailTemplateResponse$TemplateType' => '<p>The type of channel that the message template is designed for. For an email template, this value is EMAIL.</p>', 'InAppTemplateResponse$TemplateType' => '<p>The type of channel that the message template is designed for. For an in-app message template, this value is INAPP.</p>', 'PushNotificationTemplateResponse$TemplateType' => '<p>The type of channel that the message template is designed for. For a push notification template, this value is PUSH.</p>', 'SMSTemplateResponse$TemplateType' => '<p>The type of channel that the message template is designed for. For an SMS template, this value is SMS.</p>', 'TemplateResponse$TemplateType' => '<p>The type of channel that the message template is designed for. Possible values are: EMAIL, PUSH, SMS, INAPP, and VOICE.</p>', 'VoiceTemplateResponse$TemplateType' => '<p>The type of channel that the message template is designed for. For a voice template, this value is VOICE.</p>', ], ], 'TemplateVersionResponse' => [ 'base' => '<p>Provides information about a specific version of a message template.</p>', 'refs' => [ 'ListOfTemplateVersionResponse$member' => NULL, ], ], 'TemplateVersionsResponse' => [ 'base' => '<p>Provides information about all the versions of a specific message template.</p>', 'refs' => [], ], 'TemplatesResponse' => [ 'base' => '<p>Provides information about all the message templates that are associated with your Amazon Pinpoint account.</p>', 'refs' => [], ], 'TooManyRequestsException' => [ 'base' => '<p>Provides information about an API request or response.</p>', 'refs' => [], ], 'TreatmentResource' => [ 'base' => '<p>Specifies the settings for a campaign treatment. A <i>treatment</i> is a variation of a campaign that\'s used for A/B testing of a campaign.</p>', 'refs' => [ 'ListOfTreatmentResource$member' => NULL, ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'SegmentGroup$Type' => '<p>Specifies how to handle multiple dimensions for the segment. For example, if you specify three dimensions for the segment, whether the resulting segment includes endpoints that match all, any, or none of the dimensions.</p>', ], ], 'UpdateAttributesRequest' => [ 'base' => '<p>Specifies one or more attributes to remove from all the endpoints that are associated with an application.</p>', 'refs' => [], ], 'UpdateRecommenderConfiguration' => [ 'base' => '<p>Specifies Amazon Pinpoint configuration settings for retrieving and processing recommendation data from a recommender model.</p>', 'refs' => [], ], 'VerificationResponse' => [ 'base' => '<p>Verify OTP Message Response.</p>', 'refs' => [], ], 'VerifyOTPMessageRequestParameters' => [ 'base' => '<p>Verify OTP message request.</p>', 'refs' => [], ], 'VoiceChannelRequest' => [ 'base' => '<p>Specifies the status and settings of the voice channel for an application.</p>', 'refs' => [], ], 'VoiceChannelResponse' => [ 'base' => '<p>Provides information about the status and settings of the voice channel for an application.</p>', 'refs' => [], ], 'VoiceMessage' => [ 'base' => '<p>Specifies the settings for a one-time voice message that\'s sent directly to an endpoint through the voice channel.</p>', 'refs' => [ 'DirectMessageConfiguration$VoiceMessage' => '<p>The default message for the voice channel. This message overrides the default message (DefaultMessage).</p>', ], ], 'VoiceTemplateRequest' => [ 'base' => '<p>Specifies the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>', 'refs' => [], ], 'VoiceTemplateResponse' => [ 'base' => '<p>Provides information about the content and settings for a message template that can be used in messages that are sent through the voice channel.</p>', 'refs' => [], ], 'WaitActivity' => [ 'base' => '<p>Specifies the settings for a wait activity in a journey. This type of activity waits for a certain amount of time or until a specific date and time before moving participants to the next activity in a journey.</p>', 'refs' => [ 'Activity$Wait' => '<p>The settings for a wait activity. This type of activity waits for a certain amount of time or until a specific date and time before moving participants to the next activity in a journey.</p>', ], ], 'WaitTime' => [ 'base' => '<p>Specifies a duration or a date and time that indicates when Amazon Pinpoint determines whether an activity\'s conditions have been met or an activity moves participants to the next activity in a journey.</p>', 'refs' => [ 'ConditionalSplitActivity$EvaluationWaitTime' => '<p>The amount of time to wait before determining whether the conditions are met, or the date and time when Amazon Pinpoint determines whether the conditions are met.</p>', 'MultiConditionalSplitActivity$EvaluationWaitTime' => '<p>The amount of time to wait or the date and time when Amazon Pinpoint determines whether the conditions are met.</p>', 'WaitActivity$WaitTime' => '<p>The amount of time to wait or the date and time when the activity moves participants to the next activity in the journey.</p>', ], ], 'WriteApplicationSettingsRequest' => [ 'base' => '<p>Specifies the default settings for an application.</p>', 'refs' => [], ], 'WriteCampaignRequest' => [ 'base' => '<p>Specifies the configuration and other settings for a campaign.</p>', 'refs' => [], ], 'WriteEventStream' => [ 'base' => '<p>Specifies the Amazon Resource Name (ARN) of an event stream to publish events to and the AWS Identity and Access Management (IAM) role to use when publishing those events.</p>', 'refs' => [], ], 'WriteJourneyRequest' => [ 'base' => '<p>Specifies the configuration and other settings for a journey.</p>', 'refs' => [], ], 'WriteSegmentRequest' => [ 'base' => '<p>Specifies the configuration, dimension, and other settings for a segment. A WriteSegmentRequest object can include a Dimensions object or a SegmentGroups object, but not both.</p>', 'refs' => [], ], 'WriteTreatmentResource' => [ 'base' => '<p>Specifies the settings for a campaign treatment. A <i>treatment</i> is a variation of a campaign that\'s used for A/B testing of a campaign.</p>', 'refs' => [ 'ListOfWriteTreatmentResource$member' => NULL, ], ], '__EndpointTypesElement' => [ 'base' => NULL, 'refs' => [ 'ListOf__EndpointTypesElement$member' => NULL, ], ], '__TimezoneEstimationMethodsElement' => [ 'base' => NULL, 'refs' => [ 'ListOf__TimezoneEstimationMethodsElement$member' => NULL, ], ], '__boolean' => [ 'base' => NULL, 'refs' => [ 'ADMChannelRequest$Enabled' => '<p>Specifies whether to enable the ADM channel for the application.</p>', 'ADMChannelResponse$Enabled' => '<p>Specifies whether the ADM channel is enabled for the application.</p>', 'ADMChannelResponse$HasCredential' => '<p>(Not used) This property is retained only for backward compatibility.</p>', 'ADMChannelResponse$IsArchived' => '<p>Specifies whether the ADM channel is archived.</p>', 'ADMMessage$SilentPush' => '<p>Specifies whether the notification is a silent push notification, which is a push notification that doesn\'t display on a recipient\'s device. Silent push notifications can be used for cases such as updating an app\'s configuration or supporting phone home functionality.</p>', 'APNSChannelRequest$Enabled' => '<p>Specifies whether to enable the APNs channel for the application.</p>', 'APNSChannelResponse$Enabled' => '<p>Specifies whether the APNs channel is enabled for the application.</p>', 'APNSChannelResponse$HasCredential' => '<p>(Not used) This property is retained only for backward compatibility.</p>', 'APNSChannelResponse$HasTokenKey' => '<p>Specifies whether the APNs channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>', 'APNSChannelResponse$IsArchived' => '<p>Specifies whether the APNs channel is archived.</p>', 'APNSMessage$SilentPush' => '<p>Specifies whether the notification is a silent push notification. A silent (or background) push notification isn\'t displayed on recipients\' devices. You can use silent push notifications to make small updates to your app, or to display messages in an in-app message center.</p> <p>Amazon Pinpoint uses this property to determine the correct value for the apns-push-type request header when it sends the notification message to APNs. If you specify a value of true for this property, Amazon Pinpoint sets the value for the apns-push-type header field to background.</p> <note><p>If you specify the raw content of an APNs push notification, the message payload has to include the content-available key. For silent (background) notifications, set the value of content-available to 1. Additionally, the message payload for a silent notification can\'t include the alert, badge, or sound keys. For more information, see <a href="https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/generating_a_remote_notification">Generating a Remote Notification</a> and <a href="https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/pushing_background_updates_to_your_app">Pushing Background Updates to Your App</a> on the Apple Developer website.</p> <p>Apple has indicated that they will throttle "excessive" background notifications based on current traffic volumes. To prevent your notifications being throttled, Apple recommends that you send no more than 3 silent push notifications to each recipient per hour.</p></note>', 'APNSSandboxChannelRequest$Enabled' => '<p>Specifies whether to enable the APNs sandbox channel for the application.</p>', 'APNSSandboxChannelResponse$Enabled' => '<p>Specifies whether the APNs sandbox channel is enabled for the application.</p>', 'APNSSandboxChannelResponse$HasCredential' => '<p>(Not used) This property is retained only for backward compatibility.</p>', 'APNSSandboxChannelResponse$HasTokenKey' => '<p>Specifies whether the APNs sandbox channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>', 'APNSSandboxChannelResponse$IsArchived' => '<p>Specifies whether the APNs sandbox channel is archived.</p>', 'APNSVoipChannelRequest$Enabled' => '<p>Specifies whether to enable the APNs VoIP channel for the application.</p>', 'APNSVoipChannelResponse$Enabled' => '<p>Specifies whether the APNs VoIP channel is enabled for the application.</p>', 'APNSVoipChannelResponse$HasCredential' => '<p>(Not used) This property is retained only for backward compatibility.</p>', 'APNSVoipChannelResponse$HasTokenKey' => '<p>Specifies whether the APNs VoIP channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>', 'APNSVoipChannelResponse$IsArchived' => '<p>Specifies whether the APNs VoIP channel is archived.</p>', 'APNSVoipSandboxChannelRequest$Enabled' => '<p>Specifies whether the APNs VoIP sandbox channel is enabled for the application.</p>', 'APNSVoipSandboxChannelResponse$Enabled' => '<p>Specifies whether the APNs VoIP sandbox channel is enabled for the application.</p>', 'APNSVoipSandboxChannelResponse$HasCredential' => '<p>(Not used) This property is retained only for backward compatibility.</p>', 'APNSVoipSandboxChannelResponse$HasTokenKey' => '<p>Specifies whether the APNs VoIP sandbox channel is configured to communicate with APNs by using APNs tokens. To provide an authentication key for APNs tokens, set the TokenKey property of the channel.</p>', 'APNSVoipSandboxChannelResponse$IsArchived' => '<p>Specifies whether the APNs VoIP sandbox channel is archived.</p>', 'BaiduChannelRequest$Enabled' => '<p>Specifies whether to enable the Baidu channel for the application.</p>', 'BaiduChannelResponse$Enabled' => '<p>Specifies whether the Baidu channel is enabled for the application.</p>', 'BaiduChannelResponse$HasCredential' => '<p>(Not used) This property is retained only for backward compatibility.</p>', 'BaiduChannelResponse$IsArchived' => '<p>Specifies whether the Baidu channel is archived.</p>', 'BaiduMessage$SilentPush' => '<p>Specifies whether the notification is a silent push notification, which is a push notification that doesn\'t display on a recipient\'s device. Silent push notifications can be used for cases such as updating an app\'s configuration or supporting phone home functionality.</p>', 'CampaignResponse$IsPaused' => '<p>Specifies whether the campaign is paused. A paused campaign doesn\'t run unless you resume it by changing this value to false.</p>', 'ChannelResponse$Enabled' => '<p>Specifies whether the channel is enabled for the application.</p>', 'ChannelResponse$HasCredential' => '<p>(Not used) This property is retained only for backward compatibility.</p>', 'ChannelResponse$IsArchived' => '<p>Specifies whether the channel is archived.</p>', 'DefaultPushNotificationMessage$SilentPush' => '<p>Specifies whether the default notification is a silent push notification, which is a push notification that doesn\'t display on a recipient\'s device. Silent push notifications can be used for cases such as updating an app\'s configuration or delivering messages to an in-app notification center.</p>', 'EmailChannelRequest$Enabled' => '<p>Specifies whether to enable the email channel for the application.</p>', 'EmailChannelResponse$Enabled' => '<p>Specifies whether the email channel is enabled for the application.</p>', 'EmailChannelResponse$HasCredential' => '<p>(Not used) This property is retained only for backward compatibility.</p>', 'EmailChannelResponse$IsArchived' => '<p>Specifies whether the email channel is archived.</p>', 'GCMChannelRequest$Enabled' => '<p>Specifies whether to enable the GCM channel for the application.</p>', 'GCMChannelResponse$Enabled' => '<p>Specifies whether the GCM channel is enabled for the application.</p>', 'GCMChannelResponse$HasCredential' => '<p>(Not used) This property is retained only for backward compatibility.</p>', 'GCMChannelResponse$HasFcmServiceCredentials' => '<p>Returns true if the JSON file provided by Google during registration process was used in the <b>ServiceJson</b> field of the request.</p>', 'GCMChannelResponse$IsArchived' => '<p>Specifies whether the GCM channel is archived.</p>', 'GCMMessage$SilentPush' => '<p>Specifies whether the notification is a silent push notification, which is a push notification that doesn\'t display on a recipient\'s device. Silent push notifications can be used for cases such as updating an app\'s configuration or supporting phone home functionality.</p>', 'ImportJobRequest$DefineSegment' => '<p>Specifies whether to create a segment that contains the endpoints, when the endpoint definitions are imported.</p>', 'ImportJobRequest$RegisterEndpoints' => '<p>Specifies whether to register the endpoints with Amazon Pinpoint, when the endpoint definitions are imported.</p>', 'ImportJobResource$DefineSegment' => '<p>Specifies whether the import job creates a segment that contains the endpoints, when the endpoint definitions are imported.</p>', 'ImportJobResource$RegisterEndpoints' => '<p>Specifies whether the import job registers the endpoints with Amazon Pinpoint, when the endpoint definitions are imported.</p>', 'JourneyResponse$LocalTime' => '<p>Specifies whether the journey\'s scheduled start and end times use each participant\'s local time. If this value is true, the schedule uses each participant\'s local time.</p>', 'JourneyResponse$RefreshOnSegmentUpdate' => '<p>Indicates whether the journey participants should be refreshed when a segment is updated.</p>', 'JourneyResponse$SendingSchedule' => '<p>Indicates if journey has Advance Quiet Time enabled. This flag should be set to true in order to allow using OpenHours and ClosedDays.</p>', 'JourneyResponse$WaitForQuietTime' => '<p>Indicates whether endpoints in quiet hours should enter a wait activity until quiet hours have elapsed.</p>', 'Message$SilentPush' => '<p>Specifies whether the notification is a silent push notification, which is a push notification that doesn\'t display on a recipient\'s device. Silent push notifications can be used for cases such as updating an app\'s configuration, displaying messages in an in-app message center, or supporting phone home functionality.</p>', 'SMSChannelRequest$Enabled' => '<p>Specifies whether to enable the SMS channel for the application.</p>', 'SMSChannelResponse$Enabled' => '<p>Specifies whether the SMS channel is enabled for the application.</p>', 'SMSChannelResponse$HasCredential' => '<p>(Not used) This property is retained only for backward compatibility.</p>', 'SMSChannelResponse$IsArchived' => '<p>Specifies whether the SMS channel is archived.</p>', 'Schedule$IsLocalTime' => '<p>Specifies whether the start and end times for the campaign schedule use each recipient\'s local time. To base the schedule on each recipient\'s local time, set this value to true.</p>', 'VerificationResponse$Valid' => '<p>Specifies whether the OTP is valid or not.</p>', 'VoiceChannelRequest$Enabled' => '<p>Specifies whether to enable the voice channel for the application.</p>', 'VoiceChannelResponse$Enabled' => '<p>Specifies whether the voice channel is enabled for the application.</p>', 'VoiceChannelResponse$HasCredential' => '<p>(Not used) This property is retained only for backward compatibility.</p>', 'VoiceChannelResponse$IsArchived' => '<p>Specifies whether the voice channel is archived.</p>', 'WriteApplicationSettingsRequest$CloudWatchMetricsEnabled' => '<p>Specifies whether to enable application-related alarms in Amazon CloudWatch.</p>', 'WriteApplicationSettingsRequest$EventTaggingEnabled' => NULL, 'WriteCampaignRequest$IsPaused' => '<p>Specifies whether to pause the campaign. A paused campaign doesn\'t run unless you resume it by changing this value to false.</p>', 'WriteJourneyRequest$LocalTime' => '<p>Specifies whether the journey\'s scheduled start and end times use each participant\'s local time. To base the schedule on each participant\'s local time, set this value to true.</p>', 'WriteJourneyRequest$RefreshOnSegmentUpdate' => '<p>Indicates whether the journey participants should be refreshed when a segment is updated.</p>', 'WriteJourneyRequest$SendingSchedule' => '<p>Indicates if journey has Advance Quiet Time enabled. This flag should be set to true in order to allow using OpenHours and ClosedDays.</p>', 'WriteJourneyRequest$WaitForQuietTime' => '<p>Indicates whether endpoints in quiet hours should enter a wait activity until quiet hours have elapsed.</p>', ], ], '__double' => [ 'base' => NULL, 'refs' => [ 'EndpointLocation$Latitude' => '<p>The latitude coordinate of the endpoint location, rounded to one decimal place.</p>', 'EndpointLocation$Longitude' => '<p>The longitude coordinate of the endpoint location, rounded to one decimal place.</p>', 'GPSCoordinates$Latitude' => '<p>The latitude coordinate of the location.</p>', 'GPSCoordinates$Longitude' => '<p>The longitude coordinate of the location.</p>', 'GPSPointDimension$RangeInKilometers' => '<p>The range, in kilometers, from the GPS coordinates.</p>', 'MetricDimension$Value' => '<p>The value to compare.</p>', 'MapOf__double$member' => NULL, ], ], '__integer' => [ 'base' => NULL, 'refs' => [ 'ADMChannelResponse$Version' => '<p>The current version of the ADM channel.</p>', 'APNSChannelResponse$Version' => '<p>The current version of the APNs channel.</p>', 'APNSMessage$Badge' => '<p>The key that indicates whether and how to modify the badge of your app\'s icon when the recipient receives the push notification. If this key isn\'t included in the dictionary, the badge doesn\'t change. To remove the badge, set this value to 0.</p>', 'APNSMessage$TimeToLive' => '<p>The amount of time, in seconds, that APNs should store and attempt to deliver the push notification, if the service is unable to deliver the notification the first time. If this value is 0, APNs treats the notification as if it expires immediately and the service doesn\'t store or try to deliver the notification again.</p> <p>Amazon Pinpoint specifies this value in the apns-expiration request header when it sends the notification message to APNs.</p>', 'APNSSandboxChannelResponse$Version' => '<p>The current version of the APNs sandbox channel.</p>', 'APNSVoipChannelResponse$Version' => '<p>The current version of the APNs VoIP channel.</p>', 'APNSVoipSandboxChannelResponse$Version' => '<p>The current version of the APNs VoIP sandbox channel.</p>', 'ActivityResponse$SuccessfulEndpointCount' => '<p>The total number of endpoints that the campaign successfully delivered messages to.</p>', 'ActivityResponse$TimezonesCompletedCount' => '<p>The total number of time zones that were completed.</p>', 'ActivityResponse$TimezonesTotalCount' => '<p>The total number of unique time zones that are in the segment for the campaign.</p>', 'ActivityResponse$TotalEndpointCount' => '<p>The total number of endpoints that the campaign attempted to deliver messages to.</p>', 'ApplicationSettingsJourneyLimits$DailyCap' => '<p>The daily number of messages that an endpoint can receive from all journeys. The maximum value is 100. If set to 0, this limit will not apply.</p>', 'ApplicationSettingsJourneyLimits$TotalCap' => '<p>The default maximum number of messages that a single journey can sent to a single endpoint. The maximum value is 100. If set to 0, this limit will not apply.</p>', 'BaiduChannelResponse$Version' => '<p>The current version of the Baidu channel.</p>', 'BaiduMessage$TimeToLive' => '<p>The amount of time, in seconds, that the Baidu Cloud Push service should store the message if the recipient\'s device is offline. The default value and maximum supported time is 604,800 seconds (7 days).</p>', 'CampaignLimits$Daily' => '<p>The maximum number of messages that a campaign can send to a single endpoint during a 24-hour period. For an application, this value specifies the default limit for the number of messages that campaigns and journeys can send to a single endpoint during a 24-hour period. The maximum value is 100.</p>', 'CampaignLimits$MaximumDuration' => '<p>The maximum amount of time, in seconds, that a campaign can attempt to deliver a message after the scheduled start time for the campaign. The minimum value is 60 seconds.</p>', 'CampaignLimits$MessagesPerSecond' => '<p>The maximum number of messages that a campaign can send each second. For an application, this value specifies the default limit for the number of messages that campaigns can send each second. The minimum value is 1. The maximum value is 20,000.</p>', 'CampaignLimits$Session' => '<p>The maximum total number of messages that the campaign can send per user session.</p>', 'CampaignLimits$Total' => '<p>The maximum number of messages that a campaign can send to a single endpoint during the course of the campaign. If a campaign recurs, this setting applies to all runs of the campaign. The maximum value is 100.</p>', 'CampaignResponse$HoldoutPercent' => '<p>The allocated percentage of users (segment members) who shouldn\'t receive messages from the campaign.</p>', 'CampaignResponse$Priority' => '<p>Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment</p>', 'CampaignResponse$SegmentVersion' => '<p>The version number of the segment that\'s associated with the campaign.</p>', 'CampaignResponse$Version' => '<p>The version number of the campaign.</p>', 'ChannelResponse$Version' => '<p>The current version of the channel.</p>', 'CreateRecommenderConfiguration$RecommendationsPerMessage' => '<p>The number of recommended items to retrieve from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables. The minimum value is 1. The maximum value is 5. The default value is 5.</p> <p>To use multiple recommended items and custom attributes with message variables, you have to use an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>', 'DefaultButtonConfiguration$BorderRadius' => '<p>The border radius of the button.</p>', 'EmailChannelResponse$MessagesPerSecond' => '<p>The maximum number of emails that can be sent through the channel each second.</p>', 'EmailChannelResponse$Version' => '<p>The current version of the email channel.</p>', 'EndpointItemResponse$StatusCode' => '<p>The status code that\'s returned in the response as a result of processing the endpoint data.</p>', 'EndpointMessageResult$StatusCode' => '<p>The downstream service status code for delivering the message.</p>', 'EventItemResponse$StatusCode' => '<p>The status code that\'s returned in the response as a result of processing the event. Possible values are: 202, for events that were accepted; and, 400, for events that weren\'t valid.</p>', 'ExportJobRequest$SegmentVersion' => '<p>The version of the segment to export endpoint definitions from, if specified.</p>', 'ExportJobResource$SegmentVersion' => '<p>The version of the segment that the endpoint definitions were exported from.</p>', 'ExportJobResponse$CompletedPieces' => '<p>The number of pieces that were processed successfully (completed) by the export job, as of the time of the request.</p>', 'ExportJobResponse$FailedPieces' => '<p>The number of pieces that weren\'t processed successfully (failed) by the export job, as of the time of the request.</p>', 'ExportJobResponse$TotalFailures' => '<p>The total number of endpoint definitions that weren\'t processed successfully (failed) by the export job, typically because an error, such as a syntax error, occurred.</p>', 'ExportJobResponse$TotalPieces' => '<p>The total number of pieces that must be processed to complete the export job. Each piece consists of an approximately equal portion of the endpoint definitions that are part of the export job.</p>', 'ExportJobResponse$TotalProcessed' => '<p>The total number of endpoint definitions that were processed by the export job.</p>', 'GCMChannelResponse$Version' => '<p>The current version of the GCM channel.</p>', 'GCMMessage$TimeToLive' => '<p>The amount of time, in seconds, that FCM should store and attempt to deliver the push notification, if the service is unable to deliver the notification the first time. If you don\'t specify this value, FCM defaults to the maximum value, which is 2,419,200 seconds (28 days).</p> <p>Amazon Pinpoint specifies this value in the FCM time_to_live parameter when it sends the notification message to FCM.</p>', 'HoldoutActivity$Percentage' => '<p>The percentage of participants who shouldn\'t continue the journey.</p> <p>To determine which participants are held out, Amazon Pinpoint applies a probability-based algorithm to the percentage that you specify. Therefore, the actual percentage of participants who are held out may not be equal to the percentage that you specify.</p>', 'ImportJobResponse$CompletedPieces' => '<p>The number of pieces that were processed successfully (completed) by the import job, as of the time of the request.</p>', 'ImportJobResponse$FailedPieces' => '<p>The number of pieces that weren\'t processed successfully (failed) by the import job, as of the time of the request.</p>', 'ImportJobResponse$TotalFailures' => '<p>The total number of endpoint definitions that weren\'t processed successfully (failed) by the import job, typically because an error, such as a syntax error, occurred.</p>', 'ImportJobResponse$TotalPieces' => '<p>The total number of pieces that must be processed to complete the import job. Each piece consists of an approximately equal portion of the endpoint definitions that are part of the import job.</p>', 'ImportJobResponse$TotalProcessed' => '<p>The total number of endpoint definitions that were processed by the import job.</p>', 'InAppMessageCampaign$DailyCap' => '<p>Daily cap which controls the number of times any in-app messages can be shown to the endpoint during a day.</p>', 'InAppMessageCampaign$Priority' => '<p>Priority of the in-app message.</p>', 'InAppMessageCampaign$SessionCap' => '<p>Session cap which controls the number of times an in-app message can be shown to the endpoint during an application session.</p>', 'InAppMessageCampaign$TotalCap' => '<p>Total cap which controls the number of times an in-app message can be shown to the endpoint.</p>', 'JourneyLimits$DailyCap' => '<p>The maximum number of messages that the journey can send to a single participant during a 24-hour period. The maximum value is 100.</p>', 'JourneyLimits$EndpointReentryCap' => '<p>The maximum number of times that a participant can enter the journey. The maximum value is 100. To allow participants to enter the journey an unlimited number of times, set this value to 0.</p>', 'JourneyLimits$MessagesPerSecond' => '<p>The maximum number of messages that the journey can send each second.</p>', 'JourneyLimits$TotalCap' => '<p>The maximum number of messages a journey can sent to a single endpoint. The maximum value is 100. If set to 0, this limit will not apply.</p>', 'JourneyTimeframeCap$Cap' => '<p>The maximum number of messages that all journeys can send to an endpoint during the specified timeframe. The maximum value is 100. If set to 0, this limit will not apply.</p>', 'JourneyTimeframeCap$Days' => '<p>The length of the timeframe in days. The maximum value is 30. If set to 0, this limit will not apply.</p>', 'Message$TimeToLive' => '<p>The number of seconds that the push-notification service should keep the message, if the service is unable to deliver the notification the first time. This value is converted to an expiration value when it\'s sent to a push-notification service. If this value is 0, the service treats the notification as if it expires immediately and the service doesn\'t store or try to deliver the notification again.</p> <p>This value doesn\'t apply to messages that are sent through the Amazon Device Messaging (ADM) service.</p>', 'MessageResult$StatusCode' => '<p>The downstream service status code for delivering the message.</p>', 'NumberValidateResponse$PhoneTypeCode' => '<p>The phone type, represented by an integer. Valid values are: 0 (mobile), 1 (landline), 2 (VoIP), 3 (invalid), 4 (other), and 5 (prepaid).</p>', 'RandomSplitEntry$Percentage' => '<p>The percentage of participants to send down the activity path.</p> <p>To determine which participants are sent down each path, Amazon Pinpoint applies a probability-based algorithm to the percentages that you specify for the paths. Therefore, the actual percentage of participants who are sent down a path may not be equal to the percentage that you specify.</p>', 'RecommenderConfigurationResponse$RecommendationsPerMessage' => '<p>The number of recommended items that are retrieved from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables.</p>', 'SMSChannelResponse$PromotionalMessagesPerSecond' => '<p>The maximum number of promotional messages that you can send through the SMS channel each second.</p>', 'SMSChannelResponse$TransactionalMessagesPerSecond' => '<p>The maximum number of transactional messages that you can send through the SMS channel each second.</p>', 'SMSChannelResponse$Version' => '<p>The current version of the SMS channel.</p>', 'SegmentImportResource$Size' => '<p>The number of endpoint definitions that were imported successfully to create the segment.</p>', 'SegmentReference$Version' => '<p>The version number of the segment.</p>', 'SegmentResponse$Version' => '<p>The version number of the segment.</p>', 'SendOTPMessageRequestParameters$AllowedAttempts' => '<p>The attempts allowed to validate an OTP.</p>', 'SendOTPMessageRequestParameters$CodeLength' => '<p>The number of characters in the generated OTP.</p>', 'SendOTPMessageRequestParameters$ValidityPeriod' => '<p>The time in minutes before the OTP is no longer valid.</p>', 'Session$Duration' => '<p>The duration of the session, in milliseconds.</p>', 'TreatmentResource$SizePercent' => '<p>The allocated percentage of users (segment members) that the treatment is sent to.</p>', 'UpdateRecommenderConfiguration$RecommendationsPerMessage' => '<p>The number of recommended items to retrieve from the model for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This number determines how many recommended items are available for use in message variables. The minimum value is 1. The maximum value is 5. The default value is 5.</p> <p>To use multiple recommended items and custom attributes with message variables, you have to use an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>', 'VoiceChannelResponse$Version' => '<p>The current version of the voice channel.</p>', 'WriteCampaignRequest$HoldoutPercent' => '<p>The allocated percentage of users (segment members) who shouldn\'t receive messages from the campaign.</p>', 'WriteCampaignRequest$Priority' => '<p>Defines the priority of the campaign, used to decide the order of messages displayed to user if there are multiple messages scheduled to be displayed at the same moment.</p>', 'WriteCampaignRequest$SegmentVersion' => '<p>The version of the segment to associate with the campaign.</p>', 'WriteTreatmentResource$SizePercent' => '<p>The allocated percentage of users (segment members) to send the treatment to.</p>', 'MapOf__integer$member' => NULL, ], ], 'ListOfActivityResponse' => [ 'base' => NULL, 'refs' => [ 'ActivitiesResponse$Item' => '<p>An array of responses, one for each activity that was performed by the campaign.</p>', ], ], 'ListOfApplicationResponse' => [ 'base' => NULL, 'refs' => [ 'ApplicationsResponse$Item' => '<p>An array of responses, one for each application that was returned.</p>', ], ], 'ListOfCampaignResponse' => [ 'base' => NULL, 'refs' => [ 'CampaignsResponse$Item' => '<p>An array of responses, one for each campaign that\'s associated with the application.</p>', ], ], 'ListOfEndpointBatchItem' => [ 'base' => NULL, 'refs' => [ 'EndpointBatchRequest$Item' => '<p>An array that defines the endpoints to create or update and, for each endpoint, the property values to set or change. An array can contain a maximum of 100 items.</p>', ], ], 'ListOfEndpointResponse' => [ 'base' => NULL, 'refs' => [ 'EndpointsResponse$Item' => '<p>An array of responses, one for each endpoint that\'s associated with the user ID.</p>', ], ], 'ListOfExportJobResponse' => [ 'base' => NULL, 'refs' => [ 'ExportJobsResponse$Item' => '<p>An array of responses, one for each export job that\'s associated with the application (Export Jobs resource) or segment (Segment Export Jobs resource).</p>', ], ], 'ListOfImportJobResponse' => [ 'base' => NULL, 'refs' => [ 'ImportJobsResponse$Item' => '<p>An array of responses, one for each import job that\'s associated with the application (Import Jobs resource) or segment (Segment Import Jobs resource).</p>', ], ], 'ListOfInAppMessageCampaign' => [ 'base' => NULL, 'refs' => [ 'InAppMessagesResponse$InAppMessageCampaigns' => '<p>List of targeted in-app message campaigns.</p>', ], ], 'ListOfInAppMessageContent' => [ 'base' => NULL, 'refs' => [ 'CampaignInAppMessage$Content' => '<p>In-app message content.</p>', 'InAppMessage$Content' => '<p>In-app message content.</p>', 'InAppTemplateRequest$Content' => '<p>The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and background color. ImageUrl and buttons are optional.</p>', 'InAppTemplateResponse$Content' => '<p>The content of the message, can include up to 5 modals. Each modal must contain a message, a header, and background color. ImageUrl and buttons are optional.</p>', ], ], 'ListOfJourneyResponse' => [ 'base' => NULL, 'refs' => [ 'JourneysResponse$Item' => '<p>An array of responses, one for each journey that\'s associated with the application.</p>', ], ], 'ListOfJourneyRunResponse' => [ 'base' => NULL, 'refs' => [ 'JourneyRunsResponse$Item' => '<p>An array of responses, one for each run of the journey</p>', ], ], 'ListOfMessageHeader' => [ 'base' => NULL, 'refs' => [ 'EmailTemplateRequest$Headers' => '<p>The list of <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/templates-template-name-email.html#templates-template-name-email-model-messageheader">MessageHeaders</a> for the email. You can have up to 15 Headers.</p>', 'SimpleEmail$Headers' => '<p>List of Headers for the email.</p>', 'CampaignEmailMessage$Headers' => '<p>The list of <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-campaigns-campaign-id.html#apps-application-id-campaigns-campaign-id-model-messageheader">MessageHeaders</a> for the email. You can have up to 15 MessageHeaders for each email.</p>', ], ], 'ListOfMultiConditionalBranch' => [ 'base' => NULL, 'refs' => [ 'MultiConditionalSplitActivity$Branches' => '<p>The paths for the activity, including the conditions for entering each path and the activity to perform for each path.</p>', ], ], 'ListOfRandomSplitEntry' => [ 'base' => NULL, 'refs' => [ 'RandomSplitActivity$Branches' => '<p>The paths for the activity, including the percentage of participants to enter each path and the activity to perform for each path.</p>', ], ], 'ListOfRecommenderConfigurationResponse' => [ 'base' => NULL, 'refs' => [ 'ListRecommenderConfigurationsResponse$Item' => '<p>An array of responses, one for each recommender model configuration that\'s associated with your Amazon Pinpoint account.</p>', ], ], 'ListOfResultRow' => [ 'base' => NULL, 'refs' => [ 'BaseKpiResult$Rows' => '<p>An array of objects that provides the results of a query that retrieved the data for a standard metric that applies to an application, campaign, or journey.</p>', ], ], 'ListOfResultRowValue' => [ 'base' => NULL, 'refs' => [ 'ResultRow$GroupedBys' => '<p>An array of objects that defines the field and field values that were used to group data in a result set that contains multiple results. This value is null if the data in a result set isn’t grouped.</p>', 'ResultRow$Values' => '<p>An array of objects that provides pre-aggregated values for a standard metric that applies to an application, campaign, or journey.</p>', ], ], 'ListOfSegmentDimensions' => [ 'base' => NULL, 'refs' => [ 'SegmentGroup$Dimensions' => '<p>An array that defines the dimensions for the segment.</p>', ], ], 'ListOfSegmentGroup' => [ 'base' => NULL, 'refs' => [ 'SegmentGroupList$Groups' => '<p>An array that defines the set of segment criteria to evaluate when handling segment groups for the segment.</p>', ], ], 'ListOfSegmentReference' => [ 'base' => NULL, 'refs' => [ 'SegmentGroup$SourceSegments' => '<p>The base segment to build the segment on. A base segment, also referred to as a <i>source segment</i>, defines the initial population of endpoints for a segment. When you add dimensions to a segment, Amazon Pinpoint filters the base segment by using the dimensions that you specify.</p> <p>You can specify more than one dimensional segment or only one imported segment. If you specify an imported segment, the Amazon Pinpoint console displays a segment size estimate that indicates the size of the imported segment without any filters applied to it.</p>', ], ], 'ListOfSegmentResponse' => [ 'base' => NULL, 'refs' => [ 'SegmentsResponse$Item' => '<p>An array of responses, one for each segment that\'s associated with the application (Segments resource) or each version of a segment that\'s associated with the application (Segment Versions resource).</p>', ], ], 'ListOfSimpleCondition' => [ 'base' => NULL, 'refs' => [ 'Condition$Conditions' => '<p>The conditions to evaluate for the activity.</p>', ], ], 'ListOfTemplateResponse' => [ 'base' => NULL, 'refs' => [ 'TemplatesResponse$Item' => '<p>An array of responses, one for each message template that\'s associated with your Amazon Pinpoint account and meets any filter criteria that you specified in the request.</p>', ], ], 'ListOfTemplateVersionResponse' => [ 'base' => NULL, 'refs' => [ 'TemplateVersionsResponse$Item' => '<p>An array of responses, one for each version of the message template.</p>', ], ], 'ListOfTreatmentResource' => [ 'base' => NULL, 'refs' => [ 'CampaignResponse$AdditionalTreatments' => '<p>An array of responses, one for each treatment that you defined for the campaign, in addition to the default treatment.</p>', ], ], 'ListOfWriteTreatmentResource' => [ 'base' => NULL, 'refs' => [ 'WriteCampaignRequest$AdditionalTreatments' => '<p>An array of requests that defines additional treatments for the campaign, in addition to the default treatment for the campaign.</p>', ], ], 'ListOf__EndpointTypesElement' => [ 'base' => NULL, 'refs' => [ 'CustomDeliveryConfiguration$EndpointTypes' => '<p>The types of endpoints to send the campaign or treatment to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.</p>', 'CustomMessageActivity$EndpointTypes' => '<p>The types of endpoints to send the custom message to. Each valid value maps to a type of channel that you can associate with an endpoint by using the ChannelType property of an endpoint.</p>', ], ], 'ListOf__TimezoneEstimationMethodsElement' => [ 'base' => NULL, 'refs' => [ 'JourneyResponse$TimezoneEstimationMethods' => '<p>An array of time zone estimation methods, if any, to use for determining an <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html">Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone attribute.</p> <ul> <li><p>PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.</p></li> <li><p>POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and Endpoint.Location.Country.</p> <note><p>POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand, Canada, France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.</p></note></li> </ul>', 'WriteJourneyRequest$TimezoneEstimationMethods' => '<p>An array of time zone estimation methods, if any, to use for determining an <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-endpoints-endpoint-id.html">Endpoints</a> time zone if the Endpoint does not have a value for the Demographic.Timezone attribute.</p> <ul> <li><p>PHONE_NUMBER - A time zone is determined based on the Endpoint.Address and Endpoint.Location.Country.</p></li> <li><p>POSTAL_CODE - A time zone is determined based on the Endpoint.Location.PostalCode and Endpoint.Location.Country.</p> <note><p>POSTAL_CODE detection is only supported in the United States, United Kingdom, Australia, New Zealand, Canada, France, Italy, Spain, Germany and in regions where Amazon Pinpoint is available.</p></note></li> </ul>', ], ], 'ListOf__string' => [ 'base' => NULL, 'refs' => [ 'AttributeDimension$Values' => '<p>The criteria values to use for the segment dimension. Depending on the value of the AttributeType property, endpoints are included or excluded from the segment if their attribute values match the criteria values.</p>', 'AttributesResource$Attributes' => '<p>An array that specifies the names of the attributes that were removed from the endpoints.</p>', 'EmailMessage$ReplyToAddresses' => '<p>The reply-to email address(es) for the email message. If a recipient replies to the email, each reply-to address receives the reply.</p>', 'ExportJobResponse$Failures' => '<p>An array of entries, one for each of the first 100 entries that weren\'t processed successfully (failed) by the export job, if any.</p>', 'ImportJobResponse$Failures' => '<p>An array of entries, one for each of the first 100 entries that weren\'t processed successfully (failed) by the import job, if any.</p>', 'SetDimension$Values' => '<p>The criteria values to use for the segment dimension. Depending on the value of the DimensionType property, endpoints are included or excluded from the segment if their values match the criteria values.</p>', 'UpdateAttributesRequest$Blacklist' => '<p>An array of the attributes to remove from all the endpoints that are associated with the application. The array can specify the complete, exact name of each attribute to remove or it can specify a glob pattern that an attribute name must match in order for the attribute to be removed.</p>', 'MapOfListOf__string$member' => NULL, ], ], 'MapOfActivity' => [ 'base' => NULL, 'refs' => [ 'JourneyResponse$Activities' => '<p>A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity.</p>', 'WriteJourneyRequest$Activities' => '<p>A map that contains a set of Activity objects, one object for each activity in the journey. For each Activity object, the key is the unique identifier (string) for an activity and the value is the settings for the activity. An activity identifier can contain a maximum of 100 characters. The characters must be alphanumeric characters.</p>', ], ], 'MapOfAddressConfiguration' => [ 'base' => NULL, 'refs' => [ 'MessageRequest$Addresses' => '<p>A map of key-value pairs, where each key is an address and each value is an <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration">AddressConfiguration</a> object. An address can be a push notification token, a phone number, or an email address. You can use an <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-addressconfiguration">AddressConfiguration</a> object to tailor the message for an address by specifying settings such as content overrides and message variables.</p>', ], ], 'MapOfAttributeDimension' => [ 'base' => NULL, 'refs' => [ 'EventDimensions$Attributes' => '<p>One or more custom attributes that your application reports to Amazon Pinpoint. You can use these attributes as selection criteria when you create an event filter.</p>', 'SegmentDimensions$Attributes' => '<p>One or more custom attributes to use as criteria for the segment.</p>', 'SegmentDimensions$UserAttributes' => '<p>One or more custom user attributes to use as criteria for the segment.</p>', ], ], 'MapOfChannelResponse' => [ 'base' => NULL, 'refs' => [ 'ChannelsResponse$Channels' => '<p>A map that contains a multipart response for each channel. For each item in this object, the ChannelType is the key and the Channel is the value.</p>', ], ], 'MapOfEndpointMessageResult' => [ 'base' => NULL, 'refs' => [ 'MessageResponse$EndpointResult' => '<p>A map that contains a multipart response for each address that the message was sent to. In the map, the endpoint ID is the key and the result is the value.</p>', 'MapOfMapOfEndpointMessageResult$member' => NULL, ], ], 'MapOfEndpointSendConfiguration' => [ 'base' => NULL, 'refs' => [ 'MessageRequest$Endpoints' => '<p>A map of key-value pairs, where each key is an endpoint ID and each value is an <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration">EndpointSendConfiguration</a> object. You can use an <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration">EndpointSendConfiguration</a> object to tailor the message for an endpoint by specifying settings such as content overrides and message variables.</p>', 'SendUsersMessageRequest$Users' => '<p>A map that associates user IDs with <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration">EndpointSendConfiguration</a> objects. You can use an <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/apps-application-id-messages.html#apps-application-id-messages-model-endpointsendconfiguration">EndpointSendConfiguration</a> object to tailor the message for a user by specifying settings such as content overrides and message variables.</p>', ], ], 'MapOfEvent' => [ 'base' => NULL, 'refs' => [ 'EventsBatch$Events' => '<p>A set of properties that are associated with the event.</p>', ], ], 'MapOfEventItemResponse' => [ 'base' => NULL, 'refs' => [ 'ItemResponse$EventsItemResponse' => '<p>A multipart response object that contains a key and a value for each event in the request. In each object, the event ID is the key and an EventItemResponse object is the value.</p>', ], ], 'MapOfEventsBatch' => [ 'base' => NULL, 'refs' => [ 'EventsRequest$BatchItem' => '<p>The batch of events to process. For each item in a batch, the endpoint ID acts as a key that has an EventsBatch object as its value.</p>', ], ], 'MapOfItemResponse' => [ 'base' => NULL, 'refs' => [ 'EventsResponse$Results' => '<p>A map that contains a multipart response for each endpoint. For each item in this object, the endpoint ID is the key and the item response is the value. If no item response exists, the value can also be one of the following: 202, the request was processed successfully; or 400, the payload wasn\'t valid or required fields were missing.</p>', ], ], 'MapOfMessageResult' => [ 'base' => NULL, 'refs' => [ 'MessageResponse$Result' => '<p>A map that contains a multipart response for each address (email address, phone number, or push notification token) that the message was sent to. In the map, the address is the key and the result is the value.</p>', ], ], 'MapOfMetricDimension' => [ 'base' => NULL, 'refs' => [ 'EventDimensions$Metrics' => '<p>One or more custom metrics that your application reports to Amazon Pinpoint. You can use these metrics as selection criteria when you create an event filter.</p>', 'SegmentDimensions$Metrics' => '<p>One or more custom metrics to use as criteria for the segment.</p>', ], ], 'MapOf__double' => [ 'base' => NULL, 'refs' => [ 'EndpointBatchItem$Metrics' => '<p>One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.</p>', 'EndpointRequest$Metrics' => '<p>One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.</p>', 'EndpointResponse$Metrics' => '<p>One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.</p>', 'Event$Metrics' => '<p>One or more custom metrics that are associated with the event.</p>', 'PublicEndpoint$Metrics' => '<p>One or more custom metrics that your app reports to Amazon Pinpoint for the endpoint.</p>', ], ], 'MapOf__integer' => [ 'base' => NULL, 'refs' => [ 'SegmentImportResource$ChannelCounts' => '<p>The number of channel types in the endpoint definitions that were imported to create the segment.</p>', ], ], 'MapOfListOf__string' => [ 'base' => NULL, 'refs' => [ 'ADMMessage$Substitutions' => '<p>The default message variables to use in the notification message. You can override the default variables with individual address variables.</p>', 'APNSMessage$Substitutions' => '<p>The default message variables to use in the notification message. You can override these default variables with individual address variables.</p>', 'AddressConfiguration$Substitutions' => '<p>A map of the message variables to merge with the variables specified by properties of the DefaultMessage object. The variables specified in this map take precedence over all other variables.</p>', 'BaiduMessage$Substitutions' => '<p>The default message variables to use in the notification message. You can override the default variables with individual address variables.</p>', 'DefaultMessage$Substitutions' => '<p>The default message variables to use in the message. You can override these default variables with individual address variables.</p>', 'DefaultPushNotificationMessage$Substitutions' => '<p>The default message variables to use in the notification message. You can override the default variables with individual address variables.</p>', 'EmailMessage$Substitutions' => '<p>The default message variables to use in the email message. You can override the default variables with individual address variables.</p>', 'EndpointBatchItem$Attributes' => '<p>One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\\), and slash (/). The Amazon Pinpoint console can\'t display attribute names that contain these characters. This restriction doesn\'t apply to attribute values.</p>', 'EndpointRequest$Attributes' => '<p>One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\\), and slash (/). The Amazon Pinpoint console can\'t display attribute names that contain these characters. This restriction doesn\'t apply to attribute values.</p>', 'EndpointResponse$Attributes' => '<p>One or more custom attributes that describe the endpoint by associating a name with an array of values. For example, the value of a custom attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments.</p>', 'EndpointSendConfiguration$Substitutions' => '<p>A map of the message variables to merge with the variables specified for the default message (DefaultMessage.Substitutions). The variables specified in this map take precedence over all other variables.</p>', 'EndpointUser$UserAttributes' => '<p>One or more custom attributes that describe the user by associating a name with an array of values. For example, the value of an attribute named Interests might be: ["Science", "Music", "Travel"]. You can use these attributes as filter criteria when you create segments. Attribute names are case sensitive.</p> <p>An attribute name can contain up to 50 characters. An attribute value can contain up to 100 characters. When you define the name of a custom attribute, avoid using the following characters: number sign (#), colon (:), question mark (?), backslash (\\), and slash (/). The Amazon Pinpoint console can\'t display attribute names that contain these characters. This restriction doesn\'t apply to attribute values.</p>', 'GCMMessage$Substitutions' => '<p>The default message variables to use in the notification message. You can override the default variables with individual address variables.</p>', 'PublicEndpoint$Attributes' => '<p>One or more custom attributes that describe the endpoint by associating a name with an array of values. You can use these attributes as filter criteria when you create segments.</p>', 'SMSMessage$Substitutions' => '<p>The message variables to use in the SMS message. You can override the default variables with individual address variables.</p>', 'VoiceMessage$Substitutions' => '<p>The default message variables to use in the voice message. You can override the default variables with individual address variables.</p>', ], ], 'MapOfMapOfEndpointMessageResult' => [ 'base' => NULL, 'refs' => [ 'SendUsersMessageResponse$Result' => '<p>An object that indicates which endpoints the message was sent to, for each user. The object lists user IDs and, for each user ID, provides the endpoint IDs that the message was sent to. For each endpoint ID, it provides an EndpointMessageResult object.</p>', ], ], 'MapOf__string' => [ 'base' => NULL, 'refs' => [ 'ADMMessage$Data' => '<p>The JSON data payload to use for the push notification, if the notification is a silent push notification. This payload is added to the data.pinpoint.jsonBody object of the notification.</p>', 'APNSMessage$Data' => '<p>The JSON payload to use for a silent push notification. This payload is added to the data.pinpoint.jsonBody object of the notification.</p>', 'ActivityResponse$ExecutionMetrics' => '<p>A JSON object that contains metrics relating to the campaign execution for this campaign activity. For information about the structure and contents of the results, see <a href="https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html">Standard Amazon Pinpoint analytics metrics</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>', 'AddressConfiguration$Context' => '<p>An object that maps custom attributes to attributes for the address and is attached to the message. Attribute names are case sensitive.</p> <p>For a push notification, this payload is added to the data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery receipt event attributes.</p>', 'ApplicationResponse$tags' => '<p>A string-to-string map of key-value pairs that identifies the tags that are associated with the application. Each tag consists of a required tag key and an associated tag value.</p>', 'BaiduMessage$Data' => '<p>The JSON data payload to use for the push notification, if the notification is a silent push notification. This payload is added to the data.pinpoint.jsonBody object of the notification.</p>', 'CampaignInAppMessage$CustomConfig' => '<p>Custom config to be sent to client.</p>', 'CampaignResponse$tags' => '<p>A string-to-string map of key-value pairs that identifies the tags that are associated with the campaign. Each tag consists of a required tag key and an associated tag value.</p>', 'CreateApplicationRequest$tags' => '<p>A string-to-string map of key-value pairs that defines the tags to associate with the application. Each tag consists of a required tag key and an associated tag value.</p>', 'CreateRecommenderConfiguration$Attributes' => '<p>A map of key-value pairs that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that\'s retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.</p> <p>In the map, the key is the name of a custom attribute and the value is a custom display name for that attribute. The display name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The following restrictions apply to these names:</p> <ul><li><p>An attribute name must start with a letter or number and it can contain up to 50 characters. The characters can be letters, numbers, underscores (_), or hyphens (-). Attribute names are case sensitive and must be unique.</p></li> <li><p>An attribute display name must start with a letter or number and it can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).</p></li></ul> <p>This object is required if the configuration invokes an AWS Lambda function (RecommendationTransformerUri) to process recommendation data. Otherwise, don\'t include this object in your request.</p>', 'DefaultPushNotificationMessage$Data' => '<p>The JSON data payload to use for the default push notification, if the notification is a silent push notification. This payload is added to the data.pinpoint.jsonBody object of the notification.</p>', 'EmailTemplateRequest$tags' => '<note><p>As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API Reference for Amazon Pinpoint</i>, <a href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html">resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html">resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note> <p>(Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>', 'EmailTemplateResponse$tags' => '<p>A string-to-string map of key-value pairs that identifies the tags that are associated with the message template. Each tag consists of a required tag key and an associated tag value.</p>', 'EndpointSendConfiguration$Context' => '<p>A map of custom attributes to attach to the message for the address. Attribute names are case sensitive.</p> <p>For a push notification, this payload is added to the data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery receipt event attributes.</p>', 'Event$Attributes' => '<p>One or more custom attributes that are associated with the event.</p>', 'GCMMessage$Data' => '<p>The JSON data payload to use for the push notification, if the notification is a silent push notification. This payload is added to the data.pinpoint.jsonBody object of the notification.</p>', 'InAppMessage$CustomConfig' => '<p>Custom config to be sent to SDK.</p>', 'InAppTemplateRequest$CustomConfig' => '<p>Custom config to be sent to client.</p>', 'InAppTemplateRequest$tags' => '<note><p>As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API Reference for Amazon Pinpoint</i>, <a href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html">resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html">resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note> <p>(Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>', 'InAppTemplateResponse$CustomConfig' => '<p>Custom config to be sent to client.</p>', 'InAppTemplateResponse$tags' => '<p>Tags map that contains arn and InternalId for API GW.</p>', 'JourneyExecutionActivityMetricsResponse$Metrics' => '<p>A JSON object that contains the results of the query. The results vary depending on the type of activity (ActivityType). For information about the structure and contents of the results, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>', 'JourneyExecutionMetricsResponse$Metrics' => '<p>A JSON object that contains the results of the query. For information about the structure and contents of the results, see the <a href="https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>', 'JourneyResponse$tags' => '<p>This object is not used or supported.</p>', 'JourneyRunExecutionActivityMetricsResponse$Metrics' => '<p>A JSON object that contains the results of the query. For information about the structure and contents of the results, see see <a href="https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html">Standard Amazon Pinpoint analytics metrics</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>', 'JourneyRunExecutionMetricsResponse$Metrics' => '<p>A JSON object that contains the results of the query. For information about the structure and contents of the results, see the <a href="https://docs.aws.amazon.com//pinpoint/latest/developerguide/analytics-standard-metrics.html">Standard Amazon Pinpoint analytics metrics</a> in the <i>Amazon Pinpoint Developer Guide</i>.</p>', 'MessageRequest$Context' => '<p>A map of custom attributes to attach to the message. For a push notification, this payload is added to the data.pinpoint object. For an email or text message, this payload is added to email/SMS delivery receipt event attributes.</p>', 'PushNotificationTemplateRequest$tags' => '<note><p>As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API Reference for Amazon Pinpoint</i>, <a href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html">resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html">resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note> <p>(Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>', 'PushNotificationTemplateResponse$tags' => '<p>A string-to-string map of key-value pairs that identifies the tags that are associated with the message template. Each tag consists of a required tag key and an associated tag value.</p>', 'RecommenderConfigurationResponse$Attributes' => '<p>A map that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that\'s retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.</p> <p>This value is null if the configuration doesn\'t invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>', 'SMSTemplateRequest$tags' => '<note><p>As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API Reference for Amazon Pinpoint</i>, <a href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html">resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html">resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note> <p>(Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>', 'SMSTemplateResponse$tags' => '<p>A string-to-string map of key-value pairs that identifies the tags that are associated with the message template. Each tag consists of a required tag key and an associated tag value.</p>', 'SegmentResponse$tags' => '<p>A string-to-string map of key-value pairs that identifies the tags that are associated with the segment. Each tag consists of a required tag key and an associated tag value.</p>', 'SendUsersMessageRequest$Context' => '<p>A map of custom attribute-value pairs. For a push notification, Amazon Pinpoint adds these attributes to the data.pinpoint object in the body of the notification payload. Amazon Pinpoint also provides these attributes in the events that it generates for users-messages deliveries.</p>', 'TagsModel$tags' => '<p>A string-to-string map of key-value pairs that defines the tags for an application, campaign, message template, or segment. Each of these resources can have a maximum of 50 tags.</p> <p>Each tag consists of a required tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.</p>', 'TemplateResponse$tags' => '<p>A map of key-value pairs that identifies the tags that are associated with the message template. This object isn\'t included in a TemplateResponse object. To retrieve this object for a template, use the GetEmailTemplate, GetPushTemplate, GetSmsTemplate, or GetVoiceTemplate operation, depending on the type of template that you want to retrieve the object for.</p>', 'UpdateRecommenderConfiguration$Attributes' => '<p>A map of key-value pairs that defines 1-10 custom endpoint or user attributes, depending on the value for the RecommendationProviderIdType property. Each of these attributes temporarily stores a recommended item that\'s retrieved from the recommender model and sent to an AWS Lambda function for additional processing. Each attribute can be used as a message variable in a message template.</p> <p>In the map, the key is the name of a custom attribute and the value is a custom display name for that attribute. The display name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The following restrictions apply to these names:</p> <ul><li><p>An attribute name must start with a letter or number and it can contain up to 50 characters. The characters can be letters, numbers, underscores (_), or hyphens (-). Attribute names are case sensitive and must be unique.</p></li> <li><p>An attribute display name must start with a letter or number and it can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).</p></li></ul> <p>This object is required if the configuration invokes an AWS Lambda function (RecommendationTransformerUri) to process recommendation data. Otherwise, don\'t include this object in your request.</p>', 'VoiceTemplateRequest$tags' => '<note><p>As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API Reference for Amazon Pinpoint</i>, <a href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html">resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html">resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note> <p>(Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the message template. Each tag consists of a required tag key and an associated tag value.</p>', 'VoiceTemplateResponse$tags' => '<p>A string-to-string map of key-value pairs that identifies the tags that are associated with the message template. Each tag consists of a required tag key and an associated tag value.</p>', 'WriteCampaignRequest$tags' => '<note><p>As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API Reference for Amazon Pinpoint</i>, <a href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html">resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html">resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note> <p>(Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the campaign. Each tag consists of a required tag key and an associated tag value.</p>', 'WriteSegmentRequest$tags' => '<note><p>As of <b>22-05-2023</b> tags has been deprecated for update operations. After this date any value in tags is not processed and an error code is not returned. To manage tags we recommend using either <a href="https://docs.aws.amazon.com/pinpoint/latest/apireference/tags-resource-arn.html">Tags</a> in the <i>API Reference for Amazon Pinpoint</i>, <a href="https://docs.aws.amazon.com/cli/latest/reference/resourcegroupstaggingapi/index.html">resourcegroupstaggingapi</a> commands in the <i>AWS Command Line Interface Documentation</i> or <a href="https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/resourcegroupstaggingapi/package-summary.html">resourcegroupstaggingapi</a> in the <i>AWS SDK</i>.</p></note> <p>(Deprecated) A string-to-string map of key-value pairs that defines the tags to associate with the segment. Each tag consists of a required tag key and an associated tag value.</p>', ], ], '__string' => [ 'base' => NULL, 'refs' => [ 'ADMChannelRequest$ClientId' => '<p>The Client ID that you received from Amazon to send messages by using ADM.</p>', 'ADMChannelRequest$ClientSecret' => '<p>The Client Secret that you received from Amazon to send messages by using ADM.</p>', 'ADMChannelResponse$ApplicationId' => '<p>The unique identifier for the application that the ADM channel applies to.</p>', 'ADMChannelResponse$CreationDate' => '<p>The date and time when the ADM channel was enabled.</p>', 'ADMChannelResponse$Id' => '<p>(Deprecated) An identifier for the ADM channel. This property is retained only for backward compatibility.</p>', 'ADMChannelResponse$LastModifiedBy' => '<p>The user who last modified the ADM channel.</p>', 'ADMChannelResponse$LastModifiedDate' => '<p>The date and time when the ADM channel was last modified.</p>', 'ADMChannelResponse$Platform' => '<p>The type of messaging or notification platform for the channel. For the ADM channel, this value is ADM.</p>', 'ADMMessage$Body' => '<p>The body of the notification message.</p>', 'ADMMessage$ConsolidationKey' => '<p>An arbitrary string that indicates that multiple messages are logically the same and that Amazon Device Messaging (ADM) can drop previously enqueued messages in favor of this message.</p>', 'ADMMessage$ExpiresAfter' => '<p>The amount of time, in seconds, that ADM should store the message if the recipient\'s device is offline. Amazon Pinpoint specifies this value in the expiresAfter parameter when it sends the notification message to ADM.</p>', 'ADMMessage$IconReference' => '<p>The icon image name of the asset saved in your app.</p>', 'ADMMessage$ImageIconUrl' => '<p>The URL of the large icon image to display in the content view of the push notification.</p>', 'ADMMessage$ImageUrl' => '<p>The URL of an image to display in the push notification.</p>', 'ADMMessage$MD5' => '<p>The base64-encoded, MD5 checksum of the value specified by the Data property. ADM uses the MD5 value to verify the integrity of the data.</p>', 'ADMMessage$RawContent' => '<p>The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.</p>', 'ADMMessage$SmallImageIconUrl' => '<p>The URL of the small icon image to display in the status bar and the content view of the push notification.</p>', 'ADMMessage$Sound' => '<p>The sound to play when the recipient receives the push notification. You can use the default stream or specify the file name of a sound resource that\'s bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p>', 'ADMMessage$Title' => '<p>The title to display above the notification message on the recipient\'s device.</p>', 'ADMMessage$Url' => '<p>The URL to open in the recipient\'s default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.</p>', 'APNSChannelRequest$BundleId' => '<p>The bundle identifier that\'s assigned to your iOS app. This identifier is used for APNs tokens.</p>', 'APNSChannelRequest$Certificate' => '<p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with APNs by using an APNs certificate.</p>', 'APNSChannelRequest$DefaultAuthenticationMethod' => '<p>The default authentication method that you want Amazon Pinpoint to use when authenticating with APNs, key or certificate.</p>', 'APNSChannelRequest$PrivateKey' => '<p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with APNs.</p>', 'APNSChannelRequest$TeamId' => '<p>The identifier that\'s assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>', 'APNSChannelRequest$TokenKey' => '<p>The authentication key to use for APNs tokens.</p>', 'APNSChannelRequest$TokenKeyId' => '<p>The key identifier that\'s assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with APNs by using APNs tokens.</p>', 'APNSChannelResponse$ApplicationId' => '<p>The unique identifier for the application that the APNs channel applies to.</p>', 'APNSChannelResponse$CreationDate' => '<p>The date and time when the APNs channel was enabled.</p>', 'APNSChannelResponse$DefaultAuthenticationMethod' => '<p>The default authentication method that Amazon Pinpoint uses to authenticate with APNs for this channel, key or certificate.</p>', 'APNSChannelResponse$Id' => '<p>(Deprecated) An identifier for the APNs channel. This property is retained only for backward compatibility.</p>', 'APNSChannelResponse$LastModifiedBy' => '<p>The user who last modified the APNs channel.</p>', 'APNSChannelResponse$LastModifiedDate' => '<p>The date and time when the APNs channel was last modified.</p>', 'APNSChannelResponse$Platform' => ' <p>The type of messaging or notification platform for the channel. For the APNs channel, this value is APNS.</p>', 'APNSMessage$APNSPushType' => '<p>The type of push notification to send. Valid values are:</p> <ul><li><p>alert - For a standard notification that\'s displayed on recipients\' devices and prompts a recipient to interact with the notification.</p></li> <li><p>background - For a silent notification that delivers content in the background and isn\'t displayed on recipients\' devices.</p></li> <li><p>complication - For a notification that contains update information for an app’s complication timeline.</p></li> <li><p>fileprovider - For a notification that signals changes to a File Provider extension.</p></li> <li><p>mdm - For a notification that tells managed devices to contact the MDM server.</p></li> <li><p>voip - For a notification that provides information about an incoming VoIP call.</p></li></ul> <p>Amazon Pinpoint specifies this value in the apns-push-type request header when it sends the notification message to APNs. If you don\'t specify a value for this property, Amazon Pinpoint sets the value to alert or background automatically, based on the value that you specify for the SilentPush or RawContent property of the message.</p> <p>For more information about the apns-push-type request header, see <a href="https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/sending_notification_requests_to_apns">Sending Notification Requests to APNs</a> on the Apple Developer website.</p>', 'APNSMessage$Body' => '<p>The body of the notification message.</p>', 'APNSMessage$Category' => '<p>The key that indicates the notification type for the push notification. This key is a value that\'s defined by the identifier property of one of your app\'s registered categories.</p>', 'APNSMessage$CollapseId' => '<p>An arbitrary identifier that, if assigned to multiple messages, APNs uses to coalesce the messages into a single push notification instead of delivering each message individually. This value can\'t exceed 64 bytes.</p> <p>Amazon Pinpoint specifies this value in the apns-collapse-id request header when it sends the notification message to APNs.</p>', 'APNSMessage$MediaUrl' => '<p>The URL of an image or video to display in the push notification.</p>', 'APNSMessage$PreferredAuthenticationMethod' => '<p>The authentication method that you want Amazon Pinpoint to use when authenticating with APNs, CERTIFICATE or TOKEN.</p>', 'APNSMessage$Priority' => '<p>para>5 - Low priority, the notification might be delayed, delivered as part of a group, or throttled.</p>/listitem> <li><p>10 - High priority, the notification is sent immediately. This is the default value. A high priority notification should trigger an alert, play a sound, or badge your app\'s icon on the recipient\'s device.</p></li>/para> <p>Amazon Pinpoint specifies this value in the apns-priority request header when it sends the notification message to APNs.</p> <p>The equivalent values for Firebase Cloud Messaging (FCM), formerly Google Cloud Messaging (GCM), are normal, for 5, and high, for 10. If you specify an FCM value for this property, Amazon Pinpoint accepts and converts the value to the corresponding APNs value.</p>', 'APNSMessage$RawContent' => '<p>The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.</p> <note><p>If you specify the raw content of an APNs push notification, the message payload has to include the content-available key. The value of the content-available key has to be an integer, and can only be 0 or 1. If you\'re sending a standard notification, set the value of content-available to 0. If you\'re sending a silent (background) notification, set the value of content-available to 1. Additionally, silent notification payloads can\'t include the alert, badge, or sound keys. For more information, see <a href="https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/generating_a_remote_notification">Generating a Remote Notification</a> and <a href="https://developer.apple.com/documentation/usernotifications/setting_up_a_remote_notification_server/pushing_background_updates_to_your_app">Pushing Background Updates to Your App</a> on the Apple Developer website.</p></note>', 'APNSMessage$Sound' => '<p>The key for the sound to play when the recipient receives the push notification. The value for this key is the name of a sound file in your app\'s main bundle or the Library/Sounds folder in your app\'s data container. If the sound file can\'t be found or you specify default for the value, the system plays the default alert sound.</p>', 'APNSMessage$ThreadId' => '<p>The key that represents your app-specific identifier for grouping notifications. If you provide a Notification Content app extension, you can use this value to group your notifications together.</p>', 'APNSMessage$Title' => '<p>The title to display above the notification message on the recipient\'s device.</p>', 'APNSMessage$Url' => '<p>The URL to open in the recipient\'s default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.</p>', 'APNSPushNotificationTemplate$Body' => '<p>The message body to use in push notifications that are based on the message template.</p>', 'APNSPushNotificationTemplate$MediaUrl' => '<p>The URL of an image or video to display in push notifications that are based on the message template.</p>', 'APNSPushNotificationTemplate$RawContent' => '<p>The raw, JSON-formatted string to use as the payload for push notifications that are based on the message template. If specified, this value overrides all other content for the message template.</p>', 'APNSPushNotificationTemplate$Sound' => '<p>The key for the sound to play when the recipient receives a push notification that\'s based on the message template. The value for this key is the name of a sound file in your app\'s main bundle or the Library/Sounds folder in your app\'s data container. If the sound file can\'t be found or you specify default for the value, the system plays the default alert sound.</p>', 'APNSPushNotificationTemplate$Title' => '<p>The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient\'s device.</p>', 'APNSPushNotificationTemplate$Url' => '<p>The URL to open in the recipient\'s default mobile browser, if a recipient taps a push notification that\'s based on the message template and the value of the Action property is URL.</p>', 'APNSSandboxChannelRequest$BundleId' => '<p>The bundle identifier that\'s assigned to your iOS app. This identifier is used for APNs tokens.</p>', 'APNSSandboxChannelRequest$Certificate' => '<p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using an APNs certificate.</p>', 'APNSSandboxChannelRequest$DefaultAuthenticationMethod' => '<p>The default authentication method that you want Amazon Pinpoint to use when authenticating with the APNs sandbox environment, key or certificate.</p>', 'APNSSandboxChannelRequest$PrivateKey' => '<p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with the APNs sandbox environment.</p>', 'APNSSandboxChannelRequest$TeamId' => '<p>The identifier that\'s assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>', 'APNSSandboxChannelRequest$TokenKey' => '<p>The authentication key to use for APNs tokens.</p>', 'APNSSandboxChannelRequest$TokenKeyId' => '<p>The key identifier that\'s assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using APNs tokens.</p>', 'APNSSandboxChannelResponse$ApplicationId' => '<p>The unique identifier for the application that the APNs sandbox channel applies to.</p>', 'APNSSandboxChannelResponse$CreationDate' => '<p>The date and time when the APNs sandbox channel was enabled.</p>', 'APNSSandboxChannelResponse$DefaultAuthenticationMethod' => '<p>The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox environment for this channel, key or certificate.</p>', 'APNSSandboxChannelResponse$Id' => '<p>(Deprecated) An identifier for the APNs sandbox channel. This property is retained only for backward compatibility.</p>', 'APNSSandboxChannelResponse$LastModifiedBy' => '<p>The user who last modified the APNs sandbox channel.</p>', 'APNSSandboxChannelResponse$LastModifiedDate' => '<p>The date and time when the APNs sandbox channel was last modified.</p>', 'APNSSandboxChannelResponse$Platform' => '<p>The type of messaging or notification platform for the channel. For the APNs sandbox channel, this value is APNS_SANDBOX.</p>', 'APNSVoipChannelRequest$BundleId' => '<p>The bundle identifier that\'s assigned to your iOS app. This identifier is used for APNs tokens.</p>', 'APNSVoipChannelRequest$Certificate' => '<p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with APNs by using an APNs certificate.</p>', 'APNSVoipChannelRequest$DefaultAuthenticationMethod' => '<p>The default authentication method that you want Amazon Pinpoint to use when authenticating with APNs, key or certificate.</p>', 'APNSVoipChannelRequest$PrivateKey' => '<p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with APNs.</p>', 'APNSVoipChannelRequest$TeamId' => '<p>The identifier that\'s assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>', 'APNSVoipChannelRequest$TokenKey' => '<p>The authentication key to use for APNs tokens.</p>', 'APNSVoipChannelRequest$TokenKeyId' => '<p>The key identifier that\'s assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with APNs by using APNs tokens.</p>', 'APNSVoipChannelResponse$ApplicationId' => '<p>The unique identifier for the application that the APNs VoIP channel applies to.</p>', 'APNSVoipChannelResponse$CreationDate' => '<p>The date and time when the APNs VoIP channel was enabled.</p>', 'APNSVoipChannelResponse$DefaultAuthenticationMethod' => '<p>The default authentication method that Amazon Pinpoint uses to authenticate with APNs for this channel, key or certificate.</p>', 'APNSVoipChannelResponse$Id' => '<p>(Deprecated) An identifier for the APNs VoIP channel. This property is retained only for backward compatibility.</p>', 'APNSVoipChannelResponse$LastModifiedBy' => '<p>The user who last modified the APNs VoIP channel.</p>', 'APNSVoipChannelResponse$LastModifiedDate' => '<p>The date and time when the APNs VoIP channel was last modified.</p>', 'APNSVoipChannelResponse$Platform' => '<p>The type of messaging or notification platform for the channel. For the APNs VoIP channel, this value is APNS_VOIP.</p>', 'APNSVoipSandboxChannelRequest$BundleId' => '<p>The bundle identifier that\'s assigned to your iOS app. This identifier is used for APNs tokens.</p>', 'APNSVoipSandboxChannelRequest$Certificate' => '<p>The APNs client certificate that you received from Apple, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using an APNs certificate.</p>', 'APNSVoipSandboxChannelRequest$DefaultAuthenticationMethod' => '<p>The default authentication method that you want Amazon Pinpoint to use when authenticating with the APNs sandbox environment for this channel, key or certificate.</p>', 'APNSVoipSandboxChannelRequest$PrivateKey' => '<p>The private key for the APNs client certificate that you want Amazon Pinpoint to use to communicate with the APNs sandbox environment.</p>', 'APNSVoipSandboxChannelRequest$TeamId' => '<p>The identifier that\'s assigned to your Apple developer account team. This identifier is used for APNs tokens.</p>', 'APNSVoipSandboxChannelRequest$TokenKey' => '<p>The authentication key to use for APNs tokens.</p>', 'APNSVoipSandboxChannelRequest$TokenKeyId' => '<p>The key identifier that\'s assigned to your APNs signing key, if you want Amazon Pinpoint to communicate with the APNs sandbox environment by using APNs tokens.</p>', 'APNSVoipSandboxChannelResponse$ApplicationId' => '<p>The unique identifier for the application that the APNs VoIP sandbox channel applies to.</p>', 'APNSVoipSandboxChannelResponse$CreationDate' => '<p>The date and time when the APNs VoIP sandbox channel was enabled.</p>', 'APNSVoipSandboxChannelResponse$DefaultAuthenticationMethod' => '<p>The default authentication method that Amazon Pinpoint uses to authenticate with the APNs sandbox environment for this channel, key or certificate.</p>', 'APNSVoipSandboxChannelResponse$Id' => '<p>(Deprecated) An identifier for the APNs VoIP sandbox channel. This property is retained only for backward compatibility.</p>', 'APNSVoipSandboxChannelResponse$LastModifiedBy' => '<p>The user who last modified the APNs VoIP sandbox channel.</p>', 'APNSVoipSandboxChannelResponse$LastModifiedDate' => '<p>The date and time when the APNs VoIP sandbox channel was last modified.</p>', 'APNSVoipSandboxChannelResponse$Platform' => '<p>The type of messaging or notification platform for the channel. For the APNs VoIP sandbox channel, this value is APNS_VOIP_SANDBOX.</p>', 'ActivitiesResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'Activity$Description' => '<p>The custom description of the activity.</p>', 'ActivityResponse$ApplicationId' => '<p>The unique identifier for the application that the campaign applies to.</p>', 'ActivityResponse$CampaignId' => '<p>The unique identifier for the campaign that the activity applies to.</p>', 'ActivityResponse$End' => '<p>The actual time, in ISO 8601 format, when the activity was marked CANCELLED or COMPLETED.</p>', 'ActivityResponse$Id' => '<p>The unique identifier for the activity.</p>', 'ActivityResponse$Result' => '<p>Specifies whether the activity succeeded. Possible values are SUCCESS and FAIL.</p>', 'ActivityResponse$ScheduledStart' => '<p>The scheduled start time, in ISO 8601 format, for the activity.</p>', 'ActivityResponse$Start' => '<p>The actual start time, in ISO 8601 format, of the activity.</p>', 'ActivityResponse$State' => '<p>The current status of the activity. Possible values are: PENDING, INITIALIZING, RUNNING, PAUSED, CANCELLED, and COMPLETED.</p>', 'ActivityResponse$TreatmentId' => '<p>The unique identifier for the campaign treatment that the activity applies to. A treatment is a variation of a campaign that\'s used for A/B testing of a campaign.</p>', 'AddressConfiguration$BodyOverride' => '<p>The message body to use instead of the default message body. This value overrides the default message body.</p>', 'AddressConfiguration$RawContent' => '<p>The raw, JSON-formatted string to use as the payload for the message. If specified, this value overrides all other values for the message.</p>', 'AddressConfiguration$TitleOverride' => '<p>The message title to use instead of the default message title. This value overrides the default message title.</p>', 'AndroidPushNotificationTemplate$Body' => '<p>The message body to use in a push notification that\'s based on the message template.</p>', 'AndroidPushNotificationTemplate$ImageIconUrl' => '<p>The URL of the large icon image to display in the content view of a push notification that\'s based on the message template.</p>', 'AndroidPushNotificationTemplate$ImageUrl' => '<p>The URL of an image to display in a push notification that\'s based on the message template.</p>', 'AndroidPushNotificationTemplate$RawContent' => '<p>The raw, JSON-formatted string to use as the payload for a push notification that\'s based on the message template. If specified, this value overrides all other content for the message template.</p>', 'AndroidPushNotificationTemplate$SmallImageIconUrl' => '<p>The URL of the small icon image to display in the status bar and the content view of a push notification that\'s based on the message template.</p>', 'AndroidPushNotificationTemplate$Sound' => '<p>The sound to play when a recipient receives a push notification that\'s based on the message template. You can use the default stream or specify the file name of a sound resource that\'s bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p>', 'AndroidPushNotificationTemplate$Title' => '<p>The title to use in a push notification that\'s based on the message template. This title appears above the notification message on a recipient\'s device.</p>', 'AndroidPushNotificationTemplate$Url' => '<p>The URL to open in a recipient\'s default mobile browser, if a recipient taps a push notification that\'s based on the message template and the value of the Action property is URL.</p>', 'ApplicationDateRangeKpiResponse$ApplicationId' => '<p>The unique identifier for the application that the metric applies to.</p>', 'ApplicationDateRangeKpiResponse$EndTime' => '<p>The last date and time of the date range that was used to filter the query results, in extended ISO 8601 format. The date range is inclusive.</p>', 'ApplicationDateRangeKpiResponse$KpiName' => '<p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, that the data was retrieved for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. For a list of possible values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>', 'ApplicationDateRangeKpiResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null for the Application Metrics resource because the resource returns all results in a single page.</p>', 'ApplicationDateRangeKpiResponse$StartTime' => '<p>The first date and time of the date range that was used to filter the query results, in extended ISO 8601 format. The date range is inclusive.</p>', 'ApplicationResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the application.</p>', 'ApplicationResponse$Id' => '<p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>', 'ApplicationResponse$Name' => '<p>The display name of the application. This name is displayed as the <b>Project name</b> on the Amazon Pinpoint console.</p>', 'ApplicationResponse$CreationDate' => '<p>The date and time when the Application was created.</p>', 'ApplicationSettingsResource$ApplicationId' => '<p>The unique identifier for the application. This identifier is displayed as the <b>Project ID</b> on the Amazon Pinpoint console.</p>', 'ApplicationSettingsResource$LastModifiedDate' => '<p>The date and time, in ISO 8601 format, when the application\'s settings were last modified.</p>', 'ApplicationsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'AttributesResource$ApplicationId' => '<p>The unique identifier for the application.</p>', 'AttributesResource$AttributeType' => '<p>The type of attribute or attributes that were removed from the endpoints. Valid values are:</p> <ul><li><p>endpoint-custom-attributes - Custom attributes that describe endpoints.</p></li> <li><p>endpoint-metric-attributes - Custom metrics that your app reports to Amazon Pinpoint for endpoints.</p></li> <li><p>endpoint-user-attributes - Custom attributes that describe users.</p></li></ul>', 'BaiduChannelRequest$ApiKey' => '<p>The API key that you received from the Baidu Cloud Push service to communicate with the service.</p>', 'BaiduChannelRequest$SecretKey' => '<p>The secret key that you received from the Baidu Cloud Push service to communicate with the service.</p>', 'BaiduChannelResponse$ApplicationId' => '<p>The unique identifier for the application that the Baidu channel applies to.</p>', 'BaiduChannelResponse$CreationDate' => '<p>The date and time when the Baidu channel was enabled.</p>', 'BaiduChannelResponse$Credential' => '<p>The API key that you received from the Baidu Cloud Push service to communicate with the service.</p>', 'BaiduChannelResponse$Id' => '<p>(Deprecated) An identifier for the Baidu channel. This property is retained only for backward compatibility.</p>', 'BaiduChannelResponse$LastModifiedBy' => '<p>The user who last modified the Baidu channel.</p>', 'BaiduChannelResponse$LastModifiedDate' => '<p>The date and time when the Baidu channel was last modified.</p>', 'BaiduChannelResponse$Platform' => '<p>The type of messaging or notification platform for the channel. For the Baidu channel, this value is BAIDU.</p>', 'BaiduMessage$Body' => '<p>The body of the notification message.</p>', 'BaiduMessage$IconReference' => '<p>The icon image name of the asset saved in your app.</p>', 'BaiduMessage$ImageIconUrl' => '<p>The URL of the large icon image to display in the content view of the push notification.</p>', 'BaiduMessage$ImageUrl' => '<p>The URL of an image to display in the push notification.</p>', 'BaiduMessage$RawContent' => '<p>The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.</p>', 'BaiduMessage$SmallImageIconUrl' => '<p>The URL of the small icon image to display in the status bar and the content view of the push notification.</p>', 'BaiduMessage$Sound' => '<p>The sound to play when the recipient receives the push notification. You can use the default stream or specify the file name of a sound resource that\'s bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p>', 'BaiduMessage$Title' => '<p>The title to display above the notification message on the recipient\'s device.</p>', 'BaiduMessage$Url' => '<p>The URL to open in the recipient\'s default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.</p>', 'CampaignCustomMessage$Data' => '<p>The raw, JSON-formatted string to use as the payload for the message. The maximum size is 5 KB.</p>', 'CampaignDateRangeKpiResponse$ApplicationId' => '<p>The unique identifier for the application that the metric applies to.</p>', 'CampaignDateRangeKpiResponse$CampaignId' => '<p>The unique identifier for the campaign that the metric applies to.</p>', 'CampaignDateRangeKpiResponse$EndTime' => '<p>The last date and time of the date range that was used to filter the query results, in extended ISO 8601 format. The date range is inclusive.</p>', 'CampaignDateRangeKpiResponse$KpiName' => '<p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, that the data was retrieved for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. For a list of possible values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>', 'CampaignDateRangeKpiResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null for the Campaign Metrics resource because the resource returns all results in a single page.</p>', 'CampaignDateRangeKpiResponse$StartTime' => '<p>The first date and time of the date range that was used to filter the query results, in extended ISO 8601 format. The date range is inclusive.</p>', 'CampaignEmailMessage$Body' => '<p>The body of the email for recipients whose email clients don\'t render HTML content.</p>', 'CampaignEmailMessage$FromAddress' => '<p>The verified email address to send the email from. The default address is the FromAddress specified for the email channel for the application.</p>', 'CampaignEmailMessage$HtmlBody' => '<p>The body of the email, in HTML format, for recipients whose email clients render HTML content.</p>', 'CampaignEmailMessage$Title' => '<p>The subject line, or title, of the email.</p>', 'CampaignHook$LambdaFunctionName' => '<p>The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to customize a segment for a campaign.</p>', 'CampaignHook$WebUrl' => ' <p>The web URL that Amazon Pinpoint calls to invoke the AWS Lambda function over HTTPS.</p>', 'CampaignInAppMessage$Body' => '<p>The message body of the notification, the email body or the text message.</p>', 'CampaignResponse$ApplicationId' => '<p>The unique identifier for the application that the campaign applies to.</p>', 'CampaignResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the campaign.</p>', 'CampaignResponse$CreationDate' => '<p>The date, in ISO 8601 format, when the campaign was created.</p>', 'CampaignResponse$Description' => '<p>The custom description of the campaign.</p>', 'CampaignResponse$Id' => '<p>The unique identifier for the campaign.</p>', 'CampaignResponse$LastModifiedDate' => '<p>The date, in ISO 8601 format, when the campaign was last modified.</p>', 'CampaignResponse$Name' => '<p>The name of the campaign.</p>', 'CampaignResponse$SegmentId' => '<p>The unique identifier for the segment that\'s associated with the campaign.</p>', 'CampaignResponse$TreatmentDescription' => '<p>The custom description of the default treatment for the campaign.</p>', 'CampaignResponse$TreatmentName' => '<p>The custom name of the default treatment for the campaign, if the campaign has multiple treatments. A <i>treatment</i> is a variation of a campaign that\'s used for A/B testing.</p>', 'CampaignSmsMessage$Body' => '<p>The body of the SMS message.</p>', 'CampaignSmsMessage$OriginationNumber' => '<p>The long code to send the SMS message from. This value should be one of the dedicated long codes that\'s assigned to your AWS account. Although it isn\'t required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.</p>', 'CampaignSmsMessage$SenderId' => '<p>The sender ID to display on recipients\' devices when they receive the SMS message.</p>', 'CampaignSmsMessage$EntityId' => '<p>The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.</p>', 'CampaignSmsMessage$TemplateId' => '<p>The template ID received from the regulatory body for sending SMS in your country.</p>', 'CampaignsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ChannelResponse$ApplicationId' => '<p>The unique identifier for the application.</p>', 'ChannelResponse$CreationDate' => '<p>The date and time, in ISO 8601 format, when the channel was enabled.</p>', 'ChannelResponse$Id' => '<p>(Deprecated) An identifier for the channel. This property is retained only for backward compatibility.</p>', 'ChannelResponse$LastModifiedBy' => '<p>The user who last modified the channel.</p>', 'ChannelResponse$LastModifiedDate' => '<p>The date and time, in ISO 8601 format, when the channel was last modified.</p>', 'ConditionalSplitActivity$FalseActivity' => '<p>The unique identifier for the activity to perform if the conditions aren\'t met.</p>', 'ConditionalSplitActivity$TrueActivity' => '<p>The unique identifier for the activity to perform if the conditions are met.</p>', 'ContactCenterActivity$NextActivity' => '<p>The unique identifier for the next activity to perform after the this activity.</p>', 'CreateApplicationRequest$Name' => '<p>The display name of the application. This name is displayed as the <b>Project name</b> on the Amazon Pinpoint console.</p>', 'CreateRecommenderConfiguration$Description' => '<p>A custom description of the configuration for the recommender model. The description can contain up to 128 characters. The characters can be letters, numbers, spaces, or the following symbols: _ ; () , ‐.</p>', 'CreateRecommenderConfiguration$Name' => '<p>A custom name of the configuration for the recommender model. The name must start with a letter or number and it can contain up to 128 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).</p>', 'CreateRecommenderConfiguration$RecommendationProviderIdType' => '<p>The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Valid values are:</p> <ul><li><p>PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.</p></li> <li><p>PINPOINT_USER_ID - Associate each user in the model with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If you specify this value, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user\'s endpoint.</p></li></ul>', 'CreateRecommenderConfiguration$RecommendationProviderRoleArn' => '<p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.</p>', 'CreateRecommenderConfiguration$RecommendationProviderUri' => '<p>The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation data from. This value must match the ARN of an Amazon Personalize campaign.</p>', 'CreateRecommenderConfiguration$RecommendationTransformerUri' => '<p>The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke for additional processing of recommendation data that\'s retrieved from the recommender model.</p>', 'CreateRecommenderConfiguration$RecommendationsDisplayName' => '<p>A custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This value is required if the configuration doesn\'t invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p> <p>This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The name can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-). These restrictions don\'t apply to attribute values.</p>', 'CreateTemplateMessageBody$Arn' => '<p>The Amazon Resource Name (ARN) of the message template that was created.</p>', 'CreateTemplateMessageBody$Message' => '<p>The message that\'s returned from the API for the request to create the message template.</p>', 'CreateTemplateMessageBody$RequestID' => '<p>The unique identifier for the request to create the message template.</p>', 'CustomDeliveryConfiguration$DeliveryUri' => '<p>The destination to send the campaign or treatment to. This value can be one of the following:</p> <ul><li><p>The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.</p></li> <li><p>The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.</p></li></ul> ', 'CustomMessageActivity$DeliveryUri' => '<p>The destination to send the campaign or treatment to. This value can be one of the following:</p> <ul><li><p>The name or Amazon Resource Name (ARN) of an AWS Lambda function to invoke to handle delivery of the campaign or treatment.</p></li> <li><p>The URL for a web application or service that supports HTTPS and can receive the message. The URL has to be a full URL, including the HTTPS protocol.</p></li></ul>', 'CustomMessageActivity$NextActivity' => '<p>The unique identifier for the next activity to perform, after Amazon Pinpoint calls the AWS Lambda function or web hook.</p>', 'CustomMessageActivity$TemplateName' => '<p>The name of the custom message template to use for the message. If specified, this value must match the name of an existing message template.</p>', 'CustomMessageActivity$TemplateVersion' => '<p>The unique identifier for the version of the message template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don\'t specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that\'s been most recently reviewed and approved for use, depending on your workflow. It isn\'t necessarily the latest version of a template.</p>', 'DefaultButtonConfiguration$BackgroundColor' => '<p>The background color of the button.</p>', 'DefaultButtonConfiguration$Link' => '<p>Button destination.</p>', 'DefaultButtonConfiguration$Text' => '<p>Button text.</p>', 'DefaultButtonConfiguration$TextColor' => '<p>The text color of the button.</p>', 'DefaultMessage$Body' => '<p>The default body of the message.</p>', 'DefaultPushNotificationMessage$Body' => '<p>The default body of the notification message.</p>', 'DefaultPushNotificationMessage$Title' => '<p>The default title to display above the notification message on a recipient\'s device.</p>', 'DefaultPushNotificationMessage$Url' => '<p>The default URL to open in a recipient\'s default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.</p>', 'DefaultPushNotificationTemplate$Body' => '<p>The message body to use in push notifications that are based on the message template.</p>', 'DefaultPushNotificationTemplate$Sound' => '<p>The sound to play when a recipient receives a push notification that\'s based on the message template. You can use the default stream or specify the file name of a sound resource that\'s bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p> <p>For an iOS platform, this value is the key for the name of a sound file in your app\'s main bundle or the Library/Sounds folder in your app\'s data container. If the sound file can\'t be found or you specify default for the value, the system plays the default alert sound.</p>', 'DefaultPushNotificationTemplate$Title' => '<p>The title to use in push notifications that are based on the message template. This title appears above the notification message on a recipient\'s device.</p>', 'DefaultPushNotificationTemplate$Url' => '<p>The URL to open in a recipient\'s default mobile browser, if a recipient taps a push notification that\'s based on the message template and the value of the Action property is URL.</p>', 'EmailChannelRequest$ConfigurationSet' => '<p>The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES configuration set</a> that you want to apply to messages that you send through the channel.</p>', 'EmailChannelRequest$FromAddress' => ' <p>The verified email address that you want to send email from when you send email through the channel.</p>', 'EmailChannelRequest$Identity' => ' <p>The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that you want to use when you send email through the channel.</p>', 'EmailChannelRequest$RoleArn' => ' <p>The ARN of the AWS Identity and Access Management (IAM) role that you want Amazon Pinpoint to use when it submits email-related event data for the channel.</p>', 'EmailChannelRequest$OrchestrationSendingRoleArn' => '<p>The ARN of an IAM role for Amazon Pinpoint to use to send email from your campaigns or journeys through Amazon SES.</p>', 'EmailChannelResponse$ApplicationId' => '<p>The unique identifier for the application that the email channel applies to.</p>', 'EmailChannelResponse$ConfigurationSet' => '<p>The <a href="https://docs.aws.amazon.com/ses/latest/APIReference/API_ConfigurationSet.html">Amazon SES configuration set</a> that\'s applied to messages that are sent through the channel.</p>', 'EmailChannelResponse$CreationDate' => '<p>The date and time, in ISO 8601 format, when the email channel was enabled.</p>', 'EmailChannelResponse$FromAddress' => '<p>The verified email address that email is sent from when you send email through the channel.</p>', 'EmailChannelResponse$Id' => '<p>(Deprecated) An identifier for the email channel. This property is retained only for backward compatibility.</p>', 'EmailChannelResponse$Identity' => ' <p>The Amazon Resource Name (ARN) of the identity, verified with Amazon Simple Email Service (Amazon SES), that\'s used when you send email through the channel.</p>', 'EmailChannelResponse$LastModifiedBy' => '<p>The user who last modified the email channel.</p>', 'EmailChannelResponse$LastModifiedDate' => '<p>The date and time, in ISO 8601 format, when the email channel was last modified.</p>', 'EmailChannelResponse$Platform' => '<p>The type of messaging or notification platform for the channel. For the email channel, this value is EMAIL.</p>', 'EmailChannelResponse$RoleArn' => ' <p>The ARN of the AWS Identity and Access Management (IAM) role that Amazon Pinpoint uses to submit email-related event data for the channel.</p>', 'EmailChannelResponse$OrchestrationSendingRoleArn' => '<p>The ARN of an IAM role for Amazon Pinpoint to use to send email from your campaigns or journeys through Amazon SES.</p>', 'EmailMessage$Body' => '<p>The body of the email message.</p>', 'EmailMessage$FeedbackForwardingAddress' => '<p>The email address to forward bounces and complaints to, if feedback forwarding is enabled.</p>', 'EmailMessage$FromAddress' => '<p>The verified email address to send the email message from. The default value is the FromAddress specified for the email channel.</p>', 'EmailMessageActivity$NextActivity' => '<p>The unique identifier for the next activity to perform, after the message is sent.</p>', 'EmailMessageActivity$TemplateName' => '<p>The name of the email message template to use for the message. If specified, this value must match the name of an existing message template.</p>', 'EmailMessageActivity$TemplateVersion' => '<p>The unique identifier for the version of the email template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don\'t specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that\'s been most recently reviewed and approved for use, depending on your workflow. It isn\'t necessarily the latest version of a template.</p>', 'EmailTemplateRequest$DefaultSubstitutions' => '<p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that\'s based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>', 'EmailTemplateRequest$HtmlPart' => '<p>The message body, in HTML format, to use in email messages that are based on the message template. We recommend using HTML format for email clients that render HTML content. You can include links, formatted text, and more in an HTML message.</p>', 'EmailTemplateRequest$RecommenderId' => '<p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>', 'EmailTemplateRequest$Subject' => '<p>The subject line, or title, to use in email messages that are based on the message template.</p>', 'EmailTemplateRequest$TemplateDescription' => '<p>A custom description of the message template.</p>', 'EmailTemplateRequest$TextPart' => '<p>The message body, in plain text format, to use in email messages that are based on the message template. We recommend using plain text format for email clients that don\'t render HTML content and clients that are connected to high-latency networks, such as mobile devices.</p>', 'EmailTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the message template.</p>', 'EmailTemplateResponse$CreationDate' => '<p>The date, in ISO 8601 format, when the message template was created.</p>', 'EmailTemplateResponse$DefaultSubstitutions' => '<p>The JSON object that specifies the default values that are used for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable.</p>', 'EmailTemplateResponse$HtmlPart' => '<p>The message body, in HTML format, that\'s used in email messages that are based on the message template.</p>', 'EmailTemplateResponse$LastModifiedDate' => '<p>The date, in ISO 8601 format, when the message template was last modified.</p>', 'EmailTemplateResponse$RecommenderId' => '<p>The unique identifier for the recommender model that\'s used by the message template.</p>', 'EmailTemplateResponse$Subject' => '<p>The subject line, or title, that\'s used in email messages that are based on the message template.</p>', 'EmailTemplateResponse$TemplateDescription' => '<p>The custom description of the message template.</p>', 'EmailTemplateResponse$TemplateName' => '<p>The name of the message template.</p>', 'EmailTemplateResponse$TextPart' => '<p>The message body, in plain text format, that\'s used in email messages that are based on the message template.</p>', 'EmailTemplateResponse$Version' => '<p>The unique identifier, as an integer, for the active version of the message template, or the version of the template that you specified by using the version parameter in your request.</p>', 'EndpointBatchItem$Address' => '<p>The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For a push-notification channel, use the token provided by the push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. For the SMS channel, use a phone number in E.164 format, such as +12065550100. For the email channel, use an email address.</p>', 'EndpointBatchItem$EffectiveDate' => '<p>The date and time, in ISO 8601 format, when the endpoint was created or updated.</p>', 'EndpointBatchItem$EndpointStatus' => '<p>Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p> <p>Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.</p>', 'EndpointBatchItem$Id' => '<p>The case insensitive unique identifier for the endpoint in the context of the batch. The identifier can\'t contain <code>$</code>, <code>{</code> or <code>}</code>.</p>', 'EndpointBatchItem$OptOut' => '<p>Specifies whether the user who\'s associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn\'t want to receive any messages or push notifications; and, NONE, the user hasn\'t opted out and wants to receive all messages and push notifications.</p>', 'EndpointBatchItem$RequestId' => '<p>The unique identifier for the request to create or update the endpoint.</p>', 'EndpointDemographic$AppVersion' => '<p>The version of the app that\'s associated with the endpoint.</p>', 'EndpointDemographic$Locale' => '<p>The locale of the endpoint, in the following format: the ISO 639-1 alpha-2 code, followed by an underscore (_), followed by an ISO 3166-1 alpha-2 value.</p>', 'EndpointDemographic$Make' => '<p>The manufacturer of the endpoint device, such as apple or samsung.</p>', 'EndpointDemographic$Model' => '<p>The model name or number of the endpoint device, such as iPhone or SM-G900F.</p>', 'EndpointDemographic$ModelVersion' => '<p>The model version of the endpoint device.</p>', 'EndpointDemographic$Platform' => '<p>The platform of the endpoint device, such as ios.</p>', 'EndpointDemographic$PlatformVersion' => '<p>The platform version of the endpoint device.</p>', 'EndpointDemographic$Timezone' => '<p>The time zone of the endpoint, specified as a tz database name value, such as America/Los_Angeles.</p>', 'EndpointItemResponse$Message' => '<p>The custom message that\'s returned in the response as a result of processing the endpoint data.</p>', 'EndpointLocation$City' => '<p>The name of the city where the endpoint is located.</p>', 'EndpointLocation$Country' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the endpoint is located. For example, US for the United States.</p>', 'EndpointLocation$PostalCode' => '<p>The postal or ZIP code for the area where the endpoint is located.</p>', 'EndpointLocation$Region' => '<p>The name of the region where the endpoint is located. For locations in the United States, this value is the name of a state.</p>', 'EndpointMessageResult$Address' => '<p>The endpoint address that the message was delivered to.</p>', 'EndpointMessageResult$MessageId' => '<p>The unique identifier for the message that was sent.</p>', 'EndpointMessageResult$StatusMessage' => '<p>The status message for delivering the message.</p>', 'EndpointMessageResult$UpdatedToken' => '<p>For push notifications that are sent through the GCM channel, specifies whether the endpoint\'s device registration token was updated as part of delivering the message.</p>', 'EndpointRequest$Address' => '<p>The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For a push-notification channel, use the token provided by the push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. For the SMS channel, use a phone number in E.164 format, such as +12065550100. For the email channel, use an email address.</p>', 'EndpointRequest$EffectiveDate' => '<p>The date and time, in ISO 8601 format, when the endpoint is updated.</p>', 'EndpointRequest$EndpointStatus' => '<p>Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p> <p>Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.</p>', 'EndpointRequest$OptOut' => '<p>Specifies whether the user who\'s associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn\'t want to receive any messages or push notifications; and, NONE, the user hasn\'t opted out and wants to receive all messages and push notifications.</p>', 'EndpointRequest$RequestId' => '<p>The unique identifier for the most recent request to update the endpoint.</p>', 'EndpointResponse$Address' => '<p>The destination address for messages or push notifications that you send to the endpoint. The address varies by channel. For example, the address for a push-notification channel is typically the token provided by a push notification service, such as an Apple Push Notification service (APNs) device token or a Firebase Cloud Messaging (FCM) registration token. The address for the SMS channel is a phone number in E.164 format, such as +12065550100. The address for the email channel is an email address.</p>', 'EndpointResponse$ApplicationId' => '<p>The unique identifier for the application that\'s associated with the endpoint.</p>', 'EndpointResponse$CohortId' => '<p>A number from 0-99 that represents the cohort that the endpoint is assigned to. Endpoints are grouped into cohorts randomly, and each cohort contains approximately 1 percent of the endpoints for an application. Amazon Pinpoint assigns cohorts to the holdout or treatment allocations for campaigns.</p>', 'EndpointResponse$CreationDate' => '<p>The date and time, in ISO 8601 format, when the endpoint was created.</p>', 'EndpointResponse$EffectiveDate' => '<p>The date and time, in ISO 8601 format, when the endpoint was last updated.</p>', 'EndpointResponse$EndpointStatus' => '<p>Specifies whether messages or push notifications are sent to the endpoint. Possible values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p> <p>Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.</p>', 'EndpointResponse$Id' => '<p>The unique identifier that you assigned to the endpoint. The identifier should be a globally unique identifier (GUID) to ensure that it doesn\'t conflict with other endpoint identifiers that are associated with the application.</p>', 'EndpointResponse$OptOut' => '<p>Specifies whether the user who\'s associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn\'t want to receive any messages or push notifications; and, NONE, the user hasn\'t opted out and wants to receive all messages and push notifications.</p>', 'EndpointResponse$RequestId' => '<p>The unique identifier for the most recent request to update the endpoint.</p>', 'EndpointSendConfiguration$BodyOverride' => '<p>The body of the message. If specified, this value overrides the default message body.</p>', 'EndpointSendConfiguration$RawContent' => '<p>The raw, JSON-formatted string to use as the payload for the message. If specified, this value overrides all other values for the message.</p>', 'EndpointSendConfiguration$TitleOverride' => '<p>The title or subject line of the message. If specified, this value overrides the default message title or subject line.</p>', 'EndpointUser$UserId' => '<p>The unique identifier for the user.</p>', 'Event$AppPackageName' => '<p>The package name of the app that\'s recording the event.</p>', 'Event$AppTitle' => '<p>The title of the app that\'s recording the event.</p>', 'Event$AppVersionCode' => '<p>The version number of the app that\'s recording the event.</p>', 'Event$ClientSdkVersion' => '<p>The version of the SDK that\'s running on the client device.</p>', 'Event$EventType' => '<p>The name of the event.</p>', 'Event$SdkName' => '<p>The name of the SDK that\'s being used to record the event.</p>', 'Event$Timestamp' => '<p>The date and time, in ISO 8601 format, when the event occurred.</p>', 'EventCondition$MessageActivity' => '<p>The message identifier (message_id) for the message to use when determining whether message events meet the condition.</p>', 'EventItemResponse$Message' => '<p>A custom message that\'s returned in the response as a result of processing the event.</p>', 'EventStartCondition$SegmentId' => NULL, 'EventStream$ApplicationId' => '<p>The unique identifier for the application to publish event data for.</p>', 'EventStream$DestinationStreamArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon Kinesis Data Firehose delivery stream to publish event data to.</p> <p>For a Kinesis data stream, the ARN format is: arn:aws:kinesis:<replaceable>region</replaceable>:<replaceable>account-id</replaceable>:stream/<replaceable>stream_name</replaceable> </p> <p>For a Kinesis Data Firehose delivery stream, the ARN format is: arn:aws:firehose:<replaceable>region</replaceable>:<replaceable>account-id</replaceable>:deliverystream/<replaceable>stream_name</replaceable> </p>', 'EventStream$ExternalId' => '<p>(Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when publishing event data, but we removed this requirement. We don\'t recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.</p>', 'EventStream$LastModifiedDate' => '<p>The date, in ISO 8601 format, when the event stream was last modified.</p>', 'EventStream$LastUpdatedBy' => '<p>The IAM user who last modified the event stream.</p>', 'EventStream$RoleArn' => '<p>The AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to publish event data to the stream in your AWS account.</p>', 'ExportJobRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location where you want to export endpoint definitions to.</p>', 'ExportJobRequest$S3UrlPrefix' => '<p>The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where you want to export endpoint definitions to. This location is typically a folder that contains multiple files. The URL should be in the following format: s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable>/.</p>', 'ExportJobRequest$SegmentId' => '<p>The identifier for the segment to export endpoint definitions from. If you don\'t specify this value, Amazon Pinpoint exports definitions for all the endpoints that are associated with the application.</p>', 'ExportJobResource$RoleArn' => '<p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location where the endpoint definitions were exported to.</p>', 'ExportJobResource$S3UrlPrefix' => '<p>The URL of the location in an Amazon Simple Storage Service (Amazon S3) bucket where the endpoint definitions were exported to. This location is typically a folder that contains multiple files. The URL should be in the following format: s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable>/.</p>', 'ExportJobResource$SegmentId' => '<p>The identifier for the segment that the endpoint definitions were exported from. If this value isn\'t present, Amazon Pinpoint exported definitions for all the endpoints that are associated with the application.</p>', 'ExportJobResponse$ApplicationId' => '<p>The unique identifier for the application that\'s associated with the export job.</p>', 'ExportJobResponse$CompletionDate' => '<p>The date, in ISO 8601 format, when the export job was completed.</p>', 'ExportJobResponse$CreationDate' => '<p>The date, in ISO 8601 format, when the export job was created.</p>', 'ExportJobResponse$Id' => '<p>The unique identifier for the export job.</p>', 'ExportJobResponse$Type' => '<p>The job type. This value is EXPORT for export jobs.</p>', 'ExportJobsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'GCMChannelRequest$ApiKey' => '<p>The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from Google to communicate with Google services.</p>', 'GCMChannelRequest$DefaultAuthenticationMethod' => '<p>The default authentication method used for GCM. Values are either "TOKEN" or "KEY". Defaults to "KEY".</p>', 'GCMChannelRequest$ServiceJson' => '<p>The contents of the JSON file provided by Google during registration in order to generate an access token for authentication. For more information see <a href="https://firebase.google.com/docs/cloud-messaging/migrate-v1">Migrate from legacy FCM APIs to HTTP v1</a>.</p>', 'GCMChannelResponse$ApplicationId' => '<p>The unique identifier for the application that the GCM channel applies to.</p>', 'GCMChannelResponse$CreationDate' => '<p>The date and time when the GCM channel was enabled.</p>', 'GCMChannelResponse$Credential' => '<p>The Web API Key, also referred to as an <i>API_KEY</i> or <i>server key</i>, that you received from Google to communicate with Google services.</p>', 'GCMChannelResponse$DefaultAuthenticationMethod' => '<p>The default authentication method used for GCM. Values are either "TOKEN" or "KEY". Defaults to "KEY".</p>', 'GCMChannelResponse$Id' => '<p>(Deprecated) An identifier for the GCM channel. This property is retained only for backward compatibility.</p>', 'GCMChannelResponse$LastModifiedBy' => '<p>The user who last modified the GCM channel.</p>', 'GCMChannelResponse$LastModifiedDate' => '<p>The date and time when the GCM channel was last modified.</p>', 'GCMChannelResponse$Platform' => '<p>The type of messaging or notification platform for the channel. For the GCM channel, this value is GCM.</p>', 'GCMMessage$Body' => '<p>The body of the notification message.</p>', 'GCMMessage$CollapseKey' => '<p>An arbitrary string that identifies a group of messages that can be collapsed to ensure that only the last message is sent when delivery can resume. This helps avoid sending too many instances of the same messages when the recipient\'s device comes online again or becomes active.</p> <p>Amazon Pinpoint specifies this value in the Firebase Cloud Messaging (FCM) collapse_key parameter when it sends the notification message to FCM.</p>', 'GCMMessage$IconReference' => '<p>The icon image name of the asset saved in your app.</p>', 'GCMMessage$ImageIconUrl' => '<p>The URL of the large icon image to display in the content view of the push notification.</p>', 'GCMMessage$ImageUrl' => '<p>The URL of an image to display in the push notification.</p>', 'GCMMessage$PreferredAuthenticationMethod' => '<p>The preferred authentication method, with valid values "KEY" or "TOKEN". If a value isn\'t provided then the <b>DefaultAuthenticationMethod</b> is used.</p>', 'GCMMessage$Priority' => '<p>para>normal - The notification might be delayed. Delivery is optimized for battery usage on the recipient\'s device. Use this value unless immediate delivery is required.</p>/listitem> <li><p>high - The notification is sent immediately and might wake a sleeping device.</p></li>/para> <p>Amazon Pinpoint specifies this value in the FCM priority parameter when it sends the notification message to FCM.</p> <p>The equivalent values for Apple Push Notification service (APNs) are 5, for normal, and 10, for high. If you specify an APNs value for this property, Amazon Pinpoint accepts and converts the value to the corresponding FCM value.</p>', 'GCMMessage$RawContent' => '<p>The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.</p>', 'GCMMessage$RestrictedPackageName' => '<p>The package name of the application where registration tokens must match in order for the recipient to receive the message.</p>', 'GCMMessage$SmallImageIconUrl' => '<p>The URL of the small icon image to display in the status bar and the content view of the push notification.</p>', 'GCMMessage$Sound' => '<p>The sound to play when the recipient receives the push notification. You can use the default stream or specify the file name of a sound resource that\'s bundled in your app. On an Android platform, the sound file must reside in /res/raw/.</p>', 'GCMMessage$Title' => '<p>The title to display above the notification message on the recipient\'s device.</p>', 'GCMMessage$Url' => '<p>The URL to open in the recipient\'s default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.</p>', 'HoldoutActivity$NextActivity' => '<p>The unique identifier for the next activity to perform, after performing the holdout activity.</p>', 'ImportJobRequest$ExternalId' => '<p>(Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed this requirement. We don\'t recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.</p>', 'ImportJobRequest$RoleArn' => '<p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.</p>', 'ImportJobRequest$S3Url' => '<p>The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains the endpoint definitions to import. This location can be a folder or a single file. If the location is a folder, Amazon Pinpoint imports endpoint definitions from the files in this location, including any subfolders that the folder contains.</p> <p>The URL should be in the following format: s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable>/<replaceable>file-name</replaceable>. The location can end with the key for an individual object or a prefix that qualifies multiple objects.</p>', 'ImportJobRequest$SegmentId' => '<p>The identifier for the segment to update or add the imported endpoint definitions to, if the import job is meant to update an existing segment.</p>', 'ImportJobRequest$SegmentName' => '<p>A custom name for the segment that\'s created by the import job, if the value of the DefineSegment property is true.</p>', 'ImportJobResource$ExternalId' => '<p>(Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed this requirement. We don\'t recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.</p>', 'ImportJobResource$RoleArn' => '<p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.</p>', 'ImportJobResource$S3Url' => '<p>The URL of the Amazon Simple Storage Service (Amazon S3) bucket that contains the endpoint definitions to import. This location can be a folder or a single file. If the location is a folder, Amazon Pinpoint imports endpoint definitions from the files in this location, including any subfolders that the folder contains.</p> <p>The URL should be in the following format: s3://<replaceable>bucket-name</replaceable>/<replaceable>folder-name</replaceable>/<replaceable>file-name</replaceable>. The location can end with the key for an individual object or a prefix that qualifies multiple objects.</p>', 'ImportJobResource$SegmentId' => '<p>The identifier for the segment that the import job updates or adds endpoint definitions to, if the import job updates an existing segment.</p>', 'ImportJobResource$SegmentName' => '<p>The custom name for the segment that\'s created by the import job, if the value of the DefineSegment property is true.</p>', 'ImportJobResponse$ApplicationId' => '<p>The unique identifier for the application that\'s associated with the import job.</p>', 'ImportJobResponse$CompletionDate' => '<p>The date, in ISO 8601 format, when the import job was completed.</p>', 'ImportJobResponse$CreationDate' => '<p>The date, in ISO 8601 format, when the import job was created.</p>', 'ImportJobResponse$Id' => '<p>The unique identifier for the import job.</p>', 'ImportJobResponse$Type' => '<p>The job type. This value is IMPORT for import jobs.</p>', 'ImportJobsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'InAppCampaignSchedule$EndDate' => '<p>The scheduled time after which the in-app message should not be shown. Timestamp is in ISO 8601 format.</p>', 'InAppMessageBodyConfig$Body' => '<p>Message Body.</p>', 'InAppMessageBodyConfig$TextColor' => '<p>The text color.</p>', 'InAppMessageCampaign$CampaignId' => '<p>Campaign id of the corresponding campaign.</p>', 'InAppMessageCampaign$TreatmentId' => '<p>Treatment id of the campaign.</p>', 'InAppMessageContent$BackgroundColor' => '<p>The background color for the message.</p>', 'InAppMessageContent$ImageUrl' => '<p>The image url for the background of message.</p>', 'InAppMessageHeaderConfig$Header' => '<p>Message Header.</p>', 'InAppMessageHeaderConfig$TextColor' => '<p>The text color.</p>', 'InAppTemplateRequest$TemplateDescription' => '<p>The description of the template.</p>', 'InAppTemplateResponse$Arn' => '<p>The resource arn of the template.</p>', 'InAppTemplateResponse$CreationDate' => '<p>The creation date of the template.</p>', 'InAppTemplateResponse$LastModifiedDate' => '<p>The last modified date of the template.</p>', 'InAppTemplateResponse$TemplateDescription' => '<p>The description of the template.</p>', 'InAppTemplateResponse$TemplateName' => '<p>The name of the template.</p>', 'InAppTemplateResponse$Version' => '<p>The version id of the template.</p>', 'JourneyChannelSettings$ConnectCampaignArn' => '<p>Amazon Resource Name (ARN) of the Connect Campaign.</p>', 'JourneyChannelSettings$ConnectCampaignExecutionRoleArn' => '<p>IAM role ARN to be assumed when invoking Connect campaign execution APIs for dialing.</p>', 'JourneyCustomMessage$Data' => '<p>The message content that\'s passed to an AWS Lambda function or to a web hook.</p>', 'JourneyDateRangeKpiResponse$ApplicationId' => '<p>The unique identifier for the application that the metric applies to.</p>', 'JourneyDateRangeKpiResponse$EndTime' => '<p>The last date and time of the date range that was used to filter the query results, in extended ISO 8601 format. The date range is inclusive.</p>', 'JourneyDateRangeKpiResponse$JourneyId' => '<p>The unique identifier for the journey that the metric applies to.</p>', 'JourneyDateRangeKpiResponse$KpiName' => '<p>The name of the metric, also referred to as a <i>key performance indicator (KPI)</i>, that the data was retrieved for. This value describes the associated metric and consists of two or more terms, which are comprised of lowercase alphanumeric characters, separated by a hyphen. For a list of possible values, see the <a href="https://docs.aws.amazon.com/pinpoint/latest/developerguide/analytics-standard-metrics.html">Amazon Pinpoint Developer Guide</a>.</p>', 'JourneyDateRangeKpiResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null for the Journey Engagement Metrics resource because the resource returns all results in a single page.</p>', 'JourneyDateRangeKpiResponse$StartTime' => '<p>The first date and time of the date range that was used to filter the query results, in extended ISO 8601 format. The date range is inclusive.</p>', 'JourneyEmailMessage$FromAddress' => '<p>The verified email address to send the email message from. The default address is the FromAddress specified for the email channel for the application.</p>', 'JourneyExecutionActivityMetricsResponse$ActivityType' => '<p>The type of activity that the metric applies to. Possible values are:</p> <ul><li><p>CONDITIONAL_SPLIT – For a yes/no split activity, which is an activity that sends participants down one of two paths in a journey.</p></li> <li><p>HOLDOUT – For a holdout activity, which is an activity that stops a journey for a specified percentage of participants.</p></li> <li><p>MESSAGE – For an email activity, which is an activity that sends an email message to participants.</p></li> <li><p>MULTI_CONDITIONAL_SPLIT – For a multivariate split activity, which is an activity that sends participants down one of as many as five paths in a journey.</p></li> <li><p>RANDOM_SPLIT – For a random split activity, which is an activity that sends specified percentages of participants down one of as many as five paths in a journey.</p></li> <li><p>WAIT – For a wait activity, which is an activity that waits for a certain amount of time or until a specific date and time before moving participants to the next activity in a journey.</p></li></ul>', 'JourneyExecutionActivityMetricsResponse$ApplicationId' => '<p>The unique identifier for the application that the metric applies to.</p>', 'JourneyExecutionActivityMetricsResponse$JourneyActivityId' => '<p>The unique identifier for the activity that the metric applies to.</p>', 'JourneyExecutionActivityMetricsResponse$JourneyId' => '<p>The unique identifier for the journey that the metric applies to.</p>', 'JourneyExecutionActivityMetricsResponse$LastEvaluatedTime' => '<p>The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the execution status of the activity and updated the data for the metric.</p>', 'JourneyExecutionMetricsResponse$ApplicationId' => '<p>The unique identifier for the application that the metric applies to.</p>', 'JourneyExecutionMetricsResponse$JourneyId' => '<p>The unique identifier for the journey that the metric applies to.</p>', 'JourneyExecutionMetricsResponse$LastEvaluatedTime' => '<p>The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the journey and updated the data for the metric.</p>', 'JourneyLimits$EndpointReentryInterval' => '<p>Minimum time that must pass before an endpoint can re-enter a given journey.</p>', 'JourneyPushMessage$TimeToLive' => '<p>The number of seconds that the push notification service should keep the message, if the service is unable to deliver the notification the first time. This value is converted to an expiration value when it\'s sent to a push notification service. If this value is 0, the service treats the notification as if it expires immediately and the service doesn\'t store or try to deliver the notification again.</p> <p>This value doesn\'t apply to messages that are sent through the Amazon Device Messaging (ADM) service.</p>', 'JourneyResponse$ApplicationId' => '<p>The unique identifier for the application that the journey applies to.</p>', 'JourneyResponse$CreationDate' => '<p>The date, in ISO 8601 format, when the journey was created.</p>', 'JourneyResponse$Id' => '<p>The unique identifier for the journey.</p>', 'JourneyResponse$LastModifiedDate' => '<p>The date, in ISO 8601 format, when the journey was last modified.</p>', 'JourneyResponse$Name' => '<p>The name of the journey.</p>', 'JourneyResponse$RefreshFrequency' => '<p>The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.</p>', 'JourneyResponse$StartActivity' => '<p>The unique identifier for the first activity in the journey.</p>', 'JourneyRunExecutionActivityMetricsResponse$ActivityType' => '<p>The type of activity that the metric applies to. Possible values are:</p> <ul><li><p>CONDITIONAL_SPLIT – For a yes/no split activity, which is an activity that sends participants down one of two paths in a journey.</p></li> <li><p>HOLDOUT – For a holdout activity, which is an activity that stops a journey for a specified percentage of participants.</p></li> <li><p>MESSAGE – For an email activity, which is an activity that sends an email message to participants.</p></li> <li><p>MULTI_CONDITIONAL_SPLIT – For a multivariate split activity, which is an activity that sends participants down one of as many as five paths in a journey.</p></li> <li><p>RANDOM_SPLIT – For a random split activity, which is an activity that sends specified percentages of participants down one of as many as five paths in a journey.</p></li> <li><p>WAIT – For a wait activity, which is an activity that waits for a certain amount of time or until a specific date and time before moving participants to the next activity in a journey.</p></li></ul>', 'JourneyRunExecutionActivityMetricsResponse$ApplicationId' => '<p>The unique identifier for the application that the metric applies to.</p>', 'JourneyRunExecutionActivityMetricsResponse$JourneyActivityId' => '<p>The unique identifier for the activity that the metric applies to.</p>', 'JourneyRunExecutionActivityMetricsResponse$JourneyId' => '<p>The unique identifier for the journey that the metric applies to.</p>', 'JourneyRunExecutionActivityMetricsResponse$LastEvaluatedTime' => '<p>The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the execution status of the activity for this journey run and updated the data for the metric.</p>', 'JourneyRunExecutionActivityMetricsResponse$RunId' => '<p>The unique identifier for the journey run that the metric applies to.</p>', 'JourneyRunExecutionMetricsResponse$ApplicationId' => '<p>The unique identifier for the application that the metric applies to.</p>', 'JourneyRunExecutionMetricsResponse$JourneyId' => '<p>The unique identifier for the journey that the metric applies to.</p>', 'JourneyRunExecutionMetricsResponse$LastEvaluatedTime' => '<p>The date and time, in ISO 8601 format, when Amazon Pinpoint last evaluated the journey run and updated the data for the metric.</p>', 'JourneyRunExecutionMetricsResponse$RunId' => '<p>The unique identifier for the journey run that the metric applies to.</p>', 'JourneyRunResponse$CreationTime' => '<p>The time when the journey run was created or scheduled, in ISO 8601 format.</p>', 'JourneyRunResponse$LastUpdateTime' => '<p>The last time the journey run was updated, in ISO 8601 format..</p>', 'JourneyRunResponse$RunId' => '<p>The unique identifier for the run.</p>', 'JourneyRunsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'JourneySMSMessage$OriginationNumber' => '<p>The long code to send the SMS message from. This value should be one of the dedicated long codes that\'s assigned to your AWS account. Although it isn\'t required, we recommend that you specify the long code using an E.164 format to ensure prompt and accurate delivery of the message. For example, +12065550100.</p>', 'JourneySMSMessage$SenderId' => '<p>The sender ID to display as the sender of the message on a recipient\'s device. Support for sender IDs varies by country or region. For more information, see <a href="https://docs.aws.amazon.com/pinpoint/latest/userguide/channels-sms-countries.html">Supported Countries and Regions</a> in the Amazon Pinpoint User Guide.</p>', 'JourneySMSMessage$EntityId' => '<p>The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.</p>', 'JourneySMSMessage$TemplateId' => '<p>The template ID received from the regulatory body for sending SMS in your country.</p>', 'JourneySchedule$EndTime' => '<p>The scheduled time, in ISO 8601 format, when the journey ended or will end.</p>', 'JourneySchedule$StartTime' => '<p>The scheduled time, in ISO 8601 format, when the journey began or will begin.</p>', 'JourneySchedule$Timezone' => '<p>The starting UTC offset for the journey schedule, if the value of the journey\'s LocalTime property is true. Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+08:45, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+12:45, UTC+13, UTC+13:45, UTC-02, UTC-02:30, UTC-03, UTC-03:30, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-09:30, UTC-10, and UTC-11.</p>', 'JourneysResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'ListRecommenderConfigurationsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'Message$Body' => '<p>The body of the notification message. The maximum number of characters is 200.</p>', 'Message$ImageIconUrl' => '<p>The URL of the image to display as the push-notification icon, such as the icon for the app.</p>', 'Message$ImageSmallIconUrl' => '<p>The URL of the image to display as the small, push-notification icon, such as a small version of the icon for the app.</p>', 'Message$ImageUrl' => '<p>The URL of an image to display in the push notification.</p>', 'Message$JsonBody' => '<p>The JSON payload to use for a silent push notification.</p>', 'Message$MediaUrl' => '<p>The URL of the image or video to display in the push notification.</p>', 'Message$RawContent' => '<p>The raw, JSON-formatted string to use as the payload for the notification message. If specified, this value overrides all other content for the message.</p>', 'Message$Title' => '<p>The title to display above the notification message on a recipient\'s device.</p>', 'Message$Url' => '<p>The URL to open in a recipient\'s default mobile browser, if a recipient taps the push notification and the value of the Action property is URL.</p>', 'MessageBody$Message' => '<p>The message that\'s returned from the API.</p>', 'MessageBody$RequestID' => '<p>The unique identifier for the request or response.</p>', 'MessageRequest$TraceId' => '<p>The unique identifier for tracing the message. This identifier is visible to message recipients.</p>', 'MessageHeader$Name' => '<p>The name of the message header. The header name can contain up to 126 characters.</p>', 'MessageHeader$Value' => '<p>The value of the message header. The header value can contain up to 870 characters, including the length of any rendered attributes. For example if you add the {CreationDate} attribute, it renders as YYYY-MM-DDTHH:MM:SS.SSSZ and is 24 characters in length.</p>', 'MessageResponse$ApplicationId' => '<p>The unique identifier for the application that was used to send the message.</p>', 'MessageResponse$RequestId' => '<p>The identifier for the original request that the message was delivered for.</p>', 'MessageResult$MessageId' => '<p>The unique identifier for the message that was sent.</p>', 'MessageResult$StatusMessage' => '<p>The status message for delivering the message.</p>', 'MessageResult$UpdatedToken' => '<p>For push notifications that are sent through the GCM channel, specifies whether the endpoint\'s device registration token was updated as part of delivering the message.</p>', 'MetricDimension$ComparisonOperator' => '<p>The operator to use when comparing metric values. Valid values are: GREATER_THAN, LESS_THAN, GREATER_THAN_OR_EQUAL, LESS_THAN_OR_EQUAL, and EQUAL.</p>', 'MultiConditionalBranch$NextActivity' => '<p>The unique identifier for the next activity to perform, after completing the activity for the path.</p>', 'MultiConditionalSplitActivity$DefaultActivity' => '<p>The unique identifier for the activity to perform for participants who don\'t meet any of the conditions specified for other paths in the activity.</p>', 'NumberValidateRequest$IsoCountryCode' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the phone number was originally registered.</p>', 'NumberValidateRequest$PhoneNumber' => '<p>The phone number to retrieve information about. The phone number that you provide should include a valid numeric country code. Otherwise, the operation might result in an error.</p>', 'NumberValidateResponse$Carrier' => '<p>The carrier or service provider that the phone number is currently registered with. In some countries and regions, this value may be the carrier or service provider that the phone number was originally registered with.</p>', 'NumberValidateResponse$City' => '<p>The name of the city where the phone number was originally registered.</p>', 'NumberValidateResponse$CleansedPhoneNumberE164' => '<p>The cleansed phone number, in E.164 format, for the location where the phone number was originally registered.</p>', 'NumberValidateResponse$CleansedPhoneNumberNational' => '<p>The cleansed phone number, in the format for the location where the phone number was originally registered.</p>', 'NumberValidateResponse$Country' => '<p>The name of the country or region where the phone number was originally registered.</p>', 'NumberValidateResponse$CountryCodeIso2' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or region where the phone number was originally registered.</p>', 'NumberValidateResponse$CountryCodeNumeric' => '<p>The numeric code for the country or region where the phone number was originally registered.</p>', 'NumberValidateResponse$County' => '<p>The name of the county where the phone number was originally registered.</p>', 'NumberValidateResponse$OriginalCountryCodeIso2' => '<p>The two-character code, in ISO 3166-1 alpha-2 format, that was sent in the request body.</p>', 'NumberValidateResponse$OriginalPhoneNumber' => '<p>The phone number that was sent in the request body.</p>', 'NumberValidateResponse$PhoneType' => '<p>The description of the phone type. Valid values are: MOBILE, LANDLINE, VOIP, INVALID, PREPAID, and OTHER.</p>', 'NumberValidateResponse$Timezone' => '<p>The time zone for the location where the phone number was originally registered.</p>', 'NumberValidateResponse$ZipCode' => '<p>The postal or ZIP code for the location where the phone number was originally registered.</p>', 'OverrideButtonConfiguration$Link' => '<p>Button destination.</p>', 'PublicEndpoint$Address' => '<p>The unique identifier for the recipient, such as a device token, email address, or mobile phone number.</p>', 'PublicEndpoint$EffectiveDate' => '<p>The date and time, in ISO 8601 format, when the endpoint was last updated.</p>', 'PublicEndpoint$EndpointStatus' => '<p>Specifies whether to send messages or push notifications to the endpoint. Valid values are: ACTIVE, messages are sent to the endpoint; and, INACTIVE, messages aren’t sent to the endpoint.</p> <p>Amazon Pinpoint automatically sets this value to ACTIVE when you create an endpoint or update an existing endpoint. Amazon Pinpoint automatically sets this value to INACTIVE if you update another endpoint that has the same address specified by the Address property.</p>', 'PublicEndpoint$OptOut' => '<p>Specifies whether the user who\'s associated with the endpoint has opted out of receiving messages and push notifications from you. Possible values are: ALL, the user has opted out and doesn\'t want to receive any messages or push notifications; and, NONE, the user hasn\'t opted out and wants to receive all messages and push notifications.</p>', 'PublicEndpoint$RequestId' => '<p>A unique identifier that\'s generated each time the endpoint is updated.</p>', 'PushMessageActivity$NextActivity' => '<p>The unique identifier for the next activity to perform, after the message is sent.</p>', 'PushMessageActivity$TemplateName' => '<p>The name of the push notification template to use for the message. If specified, this value must match the name of an existing message template.</p>', 'PushMessageActivity$TemplateVersion' => '<p>The unique identifier for the version of the push notification template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don\'t specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that\'s been most recently reviewed and approved for use, depending on your workflow. It isn\'t necessarily the latest version of a template.</p>', 'PushNotificationTemplateRequest$DefaultSubstitutions' => '<p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that\'s based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>', 'PushNotificationTemplateRequest$RecommenderId' => '<p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>', 'PushNotificationTemplateRequest$TemplateDescription' => '<p>A custom description of the message template.</p>', 'PushNotificationTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the message template.</p>', 'PushNotificationTemplateResponse$CreationDate' => '<p>The date, in ISO 8601 format, when the message template was created.</p>', 'PushNotificationTemplateResponse$DefaultSubstitutions' => '<p>The JSON object that specifies the default values that are used for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable.</p>', 'PushNotificationTemplateResponse$LastModifiedDate' => '<p>The date, in ISO 8601 format, when the message template was last modified.</p>', 'PushNotificationTemplateResponse$RecommenderId' => '<p>The unique identifier for the recommender model that\'s used by the message template.</p>', 'PushNotificationTemplateResponse$TemplateDescription' => '<p>The custom description of the message template.</p>', 'PushNotificationTemplateResponse$TemplateName' => '<p>The name of the message template.</p>', 'PushNotificationTemplateResponse$Version' => '<p>The unique identifier, as an integer, for the active version of the message template, or the version of the template that you specified by using the version parameter in your request.</p>', 'QuietTime$End' => '<p>The specific time when quiet time ends. This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.</p>', 'QuietTime$Start' => '<p>The specific time when quiet time begins. This value has to use 24-hour notation and be in HH:MM format, where HH is the hour (with a leading zero, if applicable) and MM is the minutes. For example, use 02:30 to represent 2:30 AM, or 14:30 to represent 2:30 PM.</p>', 'RandomSplitEntry$NextActivity' => '<p>The unique identifier for the next activity to perform, after completing the activity for the path.</p>', 'RawEmail$Data' => '<p>The email message, represented as a raw MIME message. The entire message must be base64 encoded.</p>', 'RecommenderConfigurationResponse$CreationDate' => '<p>The date, in extended ISO 8601 format, when the configuration was created for the recommender model.</p>', 'RecommenderConfigurationResponse$Description' => '<p>The custom description of the configuration for the recommender model.</p>', 'RecommenderConfigurationResponse$Id' => '<p>The unique identifier for the recommender model configuration.</p>', 'RecommenderConfigurationResponse$LastModifiedDate' => '<p>The date, in extended ISO 8601 format, when the configuration for the recommender model was last modified.</p>', 'RecommenderConfigurationResponse$Name' => '<p>The custom name of the configuration for the recommender model.</p>', 'RecommenderConfigurationResponse$RecommendationProviderIdType' => '<p>The type of Amazon Pinpoint ID that\'s associated with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Possible values are:</p> <ul><li><p>PINPOINT_ENDPOINT_ID - Each user in the model is associated with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.</p></li> <li><p>PINPOINT_USER_ID - Each user in the model is associated with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If this value is specified, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user\'s endpoint.</p></li></ul>', 'RecommenderConfigurationResponse$RecommendationProviderRoleArn' => '<p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.</p>', 'RecommenderConfigurationResponse$RecommendationProviderUri' => '<p>The Amazon Resource Name (ARN) of the recommender model that Amazon Pinpoint retrieves the recommendation data from. This value is the ARN of an Amazon Personalize campaign.</p>', 'RecommenderConfigurationResponse$RecommendationTransformerUri' => '<p>The name or Amazon Resource Name (ARN) of the AWS Lambda function that Amazon Pinpoint invokes to perform additional processing of recommendation data that it retrieves from the recommender model.</p>', 'RecommenderConfigurationResponse$RecommendationsDisplayName' => '<p>The custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console.</p> <p>This value is null if the configuration doesn\'t invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p>', 'ResultRowValue$Key' => '<p>The friendly name of the metric whose value is specified by the Value property.</p>', 'ResultRowValue$Type' => '<p>The data type of the value specified by the Value property.</p>', 'ResultRowValue$Value' => '<p>In a Values object, the value for the metric that the query retrieved data for. In a GroupedBys object, the value for the field that was used to group data in a result set that contains multiple results (Values objects).</p>', 'SMSChannelRequest$SenderId' => '<p>The identity that you want to display on recipients\' devices when they receive messages from the SMS channel.</p>', 'SMSChannelRequest$ShortCode' => '<p>The registered short code that you want to use when you send messages through the SMS channel.</p>', 'SMSChannelResponse$ApplicationId' => '<p>The unique identifier for the application that the SMS channel applies to.</p>', 'SMSChannelResponse$CreationDate' => '<p>The date and time, in ISO 8601 format, when the SMS channel was enabled.</p>', 'SMSChannelResponse$Id' => '<p>(Deprecated) An identifier for the SMS channel. This property is retained only for backward compatibility.</p>', 'SMSChannelResponse$LastModifiedBy' => '<p>The user who last modified the SMS channel.</p>', 'SMSChannelResponse$LastModifiedDate' => '<p>The date and time, in ISO 8601 format, when the SMS channel was last modified.</p>', 'SMSChannelResponse$Platform' => '<p>The type of messaging or notification platform for the channel. For the SMS channel, this value is SMS.</p>', 'SMSChannelResponse$SenderId' => '<p>The identity that displays on recipients\' devices when they receive messages from the SMS channel.</p>', 'SMSChannelResponse$ShortCode' => '<p>The registered short code to use when you send messages through the SMS channel.</p>', 'SMSMessage$Body' => '<p>The body of the SMS message.</p>', 'SMSMessage$Keyword' => '<p>The SMS program name that you provided to AWS Support when you requested your dedicated number.</p>', 'SMSMessage$MediaUrl' => '<p>This field is reserved for future use.</p>', 'SMSMessage$OriginationNumber' => '<p>The number to send the SMS message from. This value should be one of the dedicated long or short codes that\'s assigned to your AWS account. If you don\'t specify a long or short code, Amazon Pinpoint assigns a random long code to the SMS message and sends the message from that code.</p>', 'SMSMessage$SenderId' => '<p>The sender ID to display as the sender of the message on a recipient\'s device. Support for sender IDs varies by country or region.</p>', 'SMSMessage$EntityId' => '<p>The entity ID or Principal Entity (PE) id received from the regulatory body for sending SMS in your country.</p>', 'SMSMessage$TemplateId' => '<p>The template ID received from the regulatory body for sending SMS in your country.</p>', 'SMSMessageActivity$NextActivity' => '<p>The unique identifier for the next activity to perform, after the message is sent.</p>', 'SMSMessageActivity$TemplateName' => '<p>The name of the SMS message template to use for the message. If specified, this value must match the name of an existing message template.</p>', 'SMSMessageActivity$TemplateVersion' => '<p>The unique identifier for the version of the SMS template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don\'t specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that\'s been most recently reviewed and approved for use, depending on your workflow. It isn\'t necessarily the latest version of a template.</p>', 'SMSTemplateRequest$Body' => '<p>The message body to use in text messages that are based on the message template.</p>', 'SMSTemplateRequest$DefaultSubstitutions' => '<p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that\'s based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>', 'SMSTemplateRequest$RecommenderId' => '<p>The unique identifier for the recommender model to use for the message template. Amazon Pinpoint uses this value to determine how to retrieve and process data from a recommender model when it sends messages that use the template, if the template contains message variables for recommendation data.</p>', 'SMSTemplateRequest$TemplateDescription' => '<p>A custom description of the message template.</p>', 'SMSTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the message template.</p>', 'SMSTemplateResponse$Body' => '<p>The message body that\'s used in text messages that are based on the message template.</p>', 'SMSTemplateResponse$CreationDate' => '<p>The date, in ISO 8601 format, when the message template was created.</p>', 'SMSTemplateResponse$DefaultSubstitutions' => '<p>The JSON object that specifies the default values that are used for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable.</p>', 'SMSTemplateResponse$LastModifiedDate' => '<p>The date, in ISO 8601 format, when the message template was last modified.</p>', 'SMSTemplateResponse$RecommenderId' => '<p>The unique identifier for the recommender model that\'s used by the message template.</p>', 'SMSTemplateResponse$TemplateDescription' => '<p>The custom description of the message template.</p>', 'SMSTemplateResponse$TemplateName' => '<p>The name of the message template.</p>', 'SMSTemplateResponse$Version' => '<p>The unique identifier, as an integer, for the active version of the message template, or the version of the template that you specified by using the version parameter in your request.</p>', 'Schedule$EndTime' => '<p>The scheduled time, in ISO 8601 format, when the campaign ended or will end.</p>', 'Schedule$StartTime' => '<p>The scheduled time when the campaign began or will begin. Valid values are: IMMEDIATE, to start the campaign immediately; or, a specific time in ISO 8601 format.</p>', 'Schedule$Timezone' => '<p>The starting UTC offset for the campaign schedule, if the value of the IsLocalTime property is true. Valid values are: UTC, UTC+01, UTC+02, UTC+03, UTC+03:30, UTC+04, UTC+04:30, UTC+05, UTC+05:30, UTC+05:45, UTC+06, UTC+06:30, UTC+07, UTC+08, UTC+09, UTC+09:30, UTC+10, UTC+10:30, UTC+11, UTC+12, UTC+13, UTC-02, UTC-03, UTC-04, UTC-05, UTC-06, UTC-07, UTC-08, UTC-09, UTC-10, and UTC-11.</p>', 'SegmentCondition$SegmentId' => '<p>The unique identifier for the segment to associate with the activity.</p>', 'SegmentImportResource$ExternalId' => '<p>(Deprecated) Your AWS account ID, which you assigned to an external ID key in an IAM trust policy. Amazon Pinpoint previously used this value to assume an IAM role when importing endpoint definitions, but we removed this requirement. We don\'t recommend use of external IDs for IAM roles that are assumed by Amazon Pinpoint.</p>', 'SegmentImportResource$RoleArn' => '<p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorized Amazon Pinpoint to access the Amazon S3 location to import endpoint definitions from.</p>', 'SegmentImportResource$S3Url' => '<p>The URL of the Amazon Simple Storage Service (Amazon S3) bucket that the endpoint definitions were imported from to create the segment.</p>', 'SegmentReference$Id' => '<p>The unique identifier for the segment.</p>', 'SegmentResponse$ApplicationId' => '<p>The unique identifier for the application that the segment is associated with.</p>', 'SegmentResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the segment.</p>', 'SegmentResponse$CreationDate' => '<p>The date and time when the segment was created.</p>', 'SegmentResponse$Id' => '<p>The unique identifier for the segment.</p>', 'SegmentResponse$LastModifiedDate' => '<p>The date and time when the segment was last modified.</p>', 'SegmentResponse$Name' => '<p>The name of the segment.</p>', 'SegmentsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'SendOTPMessageRequestParameters$BrandName' => '<p>The brand name that will be substituted into the OTP message body. Should be owned by calling AWS account.</p>', 'SendOTPMessageRequestParameters$Channel' => '<p>Channel type for the OTP message. Supported values: [SMS].</p>', 'SendOTPMessageRequestParameters$DestinationIdentity' => '<p>The destination identity to send OTP to.</p>', 'SendOTPMessageRequestParameters$EntityId' => '<p>A unique Entity ID received from DLT after entity registration is approved.</p>', 'SendOTPMessageRequestParameters$Language' => '<p>The language to be used for the outgoing message body containing the OTP.</p>', 'SendOTPMessageRequestParameters$OriginationIdentity' => '<p>The origination identity used to send OTP from.</p>', 'SendOTPMessageRequestParameters$ReferenceId' => '<p>Developer-specified reference identifier. Required to match during OTP verification.</p>', 'SendOTPMessageRequestParameters$TemplateId' => '<p>A unique Template ID received from DLT after entity registration is approved.</p>', 'SendUsersMessageRequest$TraceId' => '<p>The unique identifier for tracing the message. This identifier is visible to message recipients.</p>', 'SendUsersMessageResponse$ApplicationId' => '<p>The unique identifier for the application that was used to send the message.</p>', 'SendUsersMessageResponse$RequestId' => '<p>The unique identifier that was assigned to the message request.</p>', 'Session$Id' => '<p>The unique identifier for the session.</p>', 'Session$StartTimestamp' => '<p>The date and time when the session began.</p>', 'Session$StopTimestamp' => '<p>The date and time when the session ended.</p>', 'SimpleEmailPart$Charset' => '<p>The applicable character set for the message content.</p>', 'SimpleEmailPart$Data' => '<p>The textual data of the message content.</p>', 'StartCondition$Description' => '<p>The custom description of the condition.</p>', 'Template$Name' => '<p>The name of the message template to use for the message. If specified, this value must match the name of an existing message template.</p>', 'Template$Version' => '<p>The unique identifier for the version of the message template to use for the message. If specified, this value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p> <p>If you don\'t specify a value for this property, Amazon Pinpoint uses the <i>active version</i> of the template. The <i>active version</i> is typically the version of a template that\'s been most recently reviewed and approved for use, depending on your workflow. It isn\'t necessarily the latest version of a template.</p>', 'TemplateActiveVersionRequest$Version' => '<p>The version of the message template to use as the active version of the template. Valid values are: latest, for the most recent version of the template; or, the unique identifier for any existing version of the template. If you specify an identifier, the value must match the identifier for an existing template version. To retrieve a list of versions and version identifiers for a template, use the <link linkend="templates-template-name-template-type-versions">Template Versions</link> resource.</p>', 'TemplateCreateMessageBody$Arn' => '<p>The Amazon Resource Name (ARN) of the message template that was created.</p>', 'TemplateCreateMessageBody$Message' => '<p>The message that\'s returned from the API for the request to create the message template.</p>', 'TemplateCreateMessageBody$RequestID' => '<p>The unique identifier for the request to create the message template.</p>', 'TemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the message template. This value isn\'t included in a TemplateResponse object. To retrieve the ARN of a template, use the GetEmailTemplate, GetPushTemplate, GetSmsTemplate, or GetVoiceTemplate operation, depending on the type of template that you want to retrieve the ARN for.</p>', 'TemplateResponse$CreationDate' => '<p>The date, in ISO 8601 format, when the message template was created.</p>', 'TemplateResponse$DefaultSubstitutions' => '<p>The JSON object that specifies the default values that are used for message variables in the message template. This object isn\'t included in a TemplateResponse object. To retrieve this object for a template, use the GetEmailTemplate, GetPushTemplate, GetSmsTemplate, or GetVoiceTemplate operation, depending on the type of template that you want to retrieve the object for.</p>', 'TemplateResponse$LastModifiedDate' => '<p>The date, in ISO 8601 format, when the message template was last modified.</p>', 'TemplateResponse$TemplateDescription' => '<p>The custom description of the message template. This value isn\'t included in a TemplateResponse object. To retrieve the description of a template, use the GetEmailTemplate, GetPushTemplate, GetSmsTemplate, or GetVoiceTemplate operation, depending on the type of template that you want to retrieve the description for.</p>', 'TemplateResponse$TemplateName' => '<p>The name of the message template.</p>', 'TemplateResponse$Version' => '<p>The unique identifier, as an integer, for the active version of the message template.</p>', 'TemplateVersionResponse$CreationDate' => '<p>The date, in ISO 8601 format, when the version of the message template was created.</p>', 'TemplateVersionResponse$DefaultSubstitutions' => '<p>A JSON object that specifies the default values that are used for message variables in the version of the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable.</p>', 'TemplateVersionResponse$LastModifiedDate' => '<p>The date, in ISO 8601 format, when the version of the message template was last modified.</p>', 'TemplateVersionResponse$TemplateDescription' => '<p>The custom description of the version of the message template.</p>', 'TemplateVersionResponse$TemplateName' => '<p>The name of the message template.</p>', 'TemplateVersionResponse$TemplateType' => '<p>The type of channel that the message template is designed for. Possible values are: EMAIL, PUSH, SMS, INAPP, and VOICE.</p>', 'TemplateVersionResponse$Version' => '<p>The unique identifier for the version of the message template. This value is an integer that Amazon Pinpoint automatically increments and assigns to each new version of a template.</p>', 'TemplateVersionsResponse$Message' => '<p>The message that\'s returned from the API for the request to retrieve information about all the versions of the message template.</p>', 'TemplateVersionsResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'TemplateVersionsResponse$RequestID' => '<p>The unique identifier for the request to retrieve information about all the versions of the message template.</p>', 'TemplatesResponse$NextToken' => '<p>The string to use in a subsequent request to get the next page of results in a paginated response. This value is null if there are no additional pages.</p>', 'TreatmentResource$Id' => '<p>The unique identifier for the treatment.</p>', 'TreatmentResource$TreatmentDescription' => '<p>The custom description of the treatment.</p>', 'TreatmentResource$TreatmentName' => '<p>The custom name of the treatment.</p>', 'UpdateRecommenderConfiguration$Description' => '<p>A custom description of the configuration for the recommender model. The description can contain up to 128 characters. The characters can be letters, numbers, spaces, or the following symbols: _ ; () , ‐.</p>', 'UpdateRecommenderConfiguration$Name' => '<p>A custom name of the configuration for the recommender model. The name must start with a letter or number and it can contain up to 128 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-).</p>', 'UpdateRecommenderConfiguration$RecommendationProviderIdType' => '<p>The type of Amazon Pinpoint ID to associate with unique user IDs in the recommender model. This value enables the model to use attribute and event data that’s specific to a particular endpoint or user in an Amazon Pinpoint application. Valid values are:</p> <ul><li><p>PINPOINT_ENDPOINT_ID - Associate each user in the model with a particular endpoint in Amazon Pinpoint. The data is correlated based on endpoint IDs in Amazon Pinpoint. This is the default value.</p></li> <li><p>PINPOINT_USER_ID - Associate each user in the model with a particular user and endpoint in Amazon Pinpoint. The data is correlated based on user IDs in Amazon Pinpoint. If you specify this value, an endpoint definition in Amazon Pinpoint has to specify both a user ID (UserId) and an endpoint ID. Otherwise, messages won’t be sent to the user\'s endpoint.</p></li></ul>', 'UpdateRecommenderConfiguration$RecommendationProviderRoleArn' => '<p>The Amazon Resource Name (ARN) of the AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to retrieve recommendation data from the recommender model.</p>', 'UpdateRecommenderConfiguration$RecommendationProviderUri' => '<p>The Amazon Resource Name (ARN) of the recommender model to retrieve recommendation data from. This value must match the ARN of an Amazon Personalize campaign.</p>', 'UpdateRecommenderConfiguration$RecommendationTransformerUri' => '<p>The name or Amazon Resource Name (ARN) of the AWS Lambda function to invoke for additional processing of recommendation data that\'s retrieved from the recommender model.</p>', 'UpdateRecommenderConfiguration$RecommendationsDisplayName' => '<p>A custom display name for the standard endpoint or user attribute (RecommendationItems) that temporarily stores recommended items for each endpoint or user, depending on the value for the RecommendationProviderIdType property. This value is required if the configuration doesn\'t invoke an AWS Lambda function (RecommendationTransformerUri) to perform additional processing of recommendation data.</p> <p>This name appears in the <b>Attribute finder</b> of the template editor on the Amazon Pinpoint console. The name can contain up to 25 characters. The characters can be letters, numbers, spaces, underscores (_), or hyphens (-). These restrictions don\'t apply to attribute values.</p>', 'VerifyOTPMessageRequestParameters$DestinationIdentity' => '<p>The destination identity to send OTP to.</p>', 'VerifyOTPMessageRequestParameters$Otp' => '<p>The OTP the end user provided for verification.</p>', 'VerifyOTPMessageRequestParameters$ReferenceId' => '<p>The reference identifier provided when the OTP was previously sent.</p>', 'VoiceChannelResponse$ApplicationId' => '<p>The unique identifier for the application that the voice channel applies to.</p>', 'VoiceChannelResponse$CreationDate' => '<p>The date and time, in ISO 8601 format, when the voice channel was enabled.</p>', 'VoiceChannelResponse$Id' => '<p>(Deprecated) An identifier for the voice channel. This property is retained only for backward compatibility.</p>', 'VoiceChannelResponse$LastModifiedBy' => '<p>The user who last modified the voice channel.</p>', 'VoiceChannelResponse$LastModifiedDate' => '<p>The date and time, in ISO 8601 format, when the voice channel was last modified.</p>', 'VoiceChannelResponse$Platform' => '<p>The type of messaging or notification platform for the channel. For the voice channel, this value is VOICE.</p>', 'VoiceMessage$Body' => '<p>The text of the script to use for the voice message.</p>', 'VoiceMessage$LanguageCode' => '<p>The code for the language to use when synthesizing the text of the message script. For a list of supported languages and the code for each one, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>', 'VoiceMessage$OriginationNumber' => '<p>The long code to send the voice message from. This value should be one of the dedicated long codes that\'s assigned to your AWS account. Although it isn\'t required, we recommend that you specify the long code in E.164 format, for example +12065550100, to ensure prompt and accurate delivery of the message.</p>', 'VoiceMessage$VoiceId' => '<p>The name of the voice to use when delivering the message. For a list of supported voices, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>', 'VoiceTemplateRequest$Body' => '<p>The text of the script to use in messages that are based on the message template, in plain text format.</p>', 'VoiceTemplateRequest$DefaultSubstitutions' => '<p>A JSON object that specifies the default values to use for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable. When you create a message that\'s based on the template, you can override these defaults with message-specific and address-specific variables and values.</p>', 'VoiceTemplateRequest$LanguageCode' => '<p>The code for the language to use when synthesizing the text of the script in messages that are based on the message template. For a list of supported languages and the code for each one, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>', 'VoiceTemplateRequest$TemplateDescription' => '<p>A custom description of the message template.</p>', 'VoiceTemplateRequest$VoiceId' => '<p>The name of the voice to use when delivering messages that are based on the message template. For a list of supported voices, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>', 'VoiceTemplateResponse$Arn' => '<p>The Amazon Resource Name (ARN) of the message template.</p>', 'VoiceTemplateResponse$Body' => '<p>The text of the script that\'s used in messages that are based on the message template, in plain text format.</p>', 'VoiceTemplateResponse$CreationDate' => '<p>The date, in ISO 8601 format, when the message template was created.</p>', 'VoiceTemplateResponse$DefaultSubstitutions' => '<p>The JSON object that specifies the default values that are used for message variables in the message template. This object is a set of key-value pairs. Each key defines a message variable in the template. The corresponding value defines the default value for that variable.</p>', 'VoiceTemplateResponse$LanguageCode' => '<p>The code for the language that\'s used when synthesizing the text of the script in messages that are based on the message template. For a list of supported languages and the code for each one, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>', 'VoiceTemplateResponse$LastModifiedDate' => '<p>The date, in ISO 8601 format, when the message template was last modified.</p>', 'VoiceTemplateResponse$TemplateDescription' => '<p>The custom description of the message template.</p>', 'VoiceTemplateResponse$TemplateName' => '<p>The name of the message template.</p>', 'VoiceTemplateResponse$Version' => '<p>The unique identifier, as an integer, for the active version of the message template, or the version of the template that you specified by using the version parameter in your request.</p>', 'VoiceTemplateResponse$VoiceId' => '<p>The name of the voice that\'s used when delivering messages that are based on the message template. For a list of supported voices, see the <a href="https://docs.aws.amazon.com/polly/latest/dg/what-is.html">Amazon Polly Developer Guide</a>.</p>', 'WaitActivity$NextActivity' => '<p>The unique identifier for the next activity to perform, after performing the wait activity.</p>', 'WaitTime$WaitFor' => '<p>The amount of time to wait, as a duration in ISO 8601 format, before determining whether the activity\'s conditions have been met or moving participants to the next activity in the journey.</p>', 'WaitTime$WaitUntil' => '<p>The date and time, in ISO 8601 format, when Amazon Pinpoint determines whether the activity\'s conditions have been met or the activity moves participants to the next activity in the journey.</p>', 'WriteCampaignRequest$Description' => '<p>A custom description of the campaign.</p>', 'WriteCampaignRequest$Name' => '<p>A custom name for the campaign.</p>', 'WriteCampaignRequest$SegmentId' => '<p>The unique identifier for the segment to associate with the campaign.</p>', 'WriteCampaignRequest$TreatmentDescription' => '<p>A custom description of the default treatment for the campaign.</p>', 'WriteCampaignRequest$TreatmentName' => '<p>A custom name of the default treatment for the campaign, if the campaign has multiple treatments. A <i>treatment</i> is a variation of a campaign that\'s used for A/B testing.</p>', 'WriteEventStream$DestinationStreamArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Kinesis data stream or Amazon Kinesis Data Firehose delivery stream that you want to publish event data to.</p> <p>For a Kinesis data stream, the ARN format is: arn:aws:kinesis:<replaceable>region</replaceable>:<replaceable>account-id</replaceable>:stream/<replaceable>stream_name</replaceable> </p> <p>For a Kinesis Data Firehose delivery stream, the ARN format is: arn:aws:firehose:<replaceable>region</replaceable>:<replaceable>account-id</replaceable>:deliverystream/<replaceable>stream_name</replaceable> </p>', 'WriteEventStream$RoleArn' => '<p>The AWS Identity and Access Management (IAM) role that authorizes Amazon Pinpoint to publish event data to the stream in your AWS account.</p>', 'WriteJourneyRequest$CreationDate' => '<p>The date, in ISO 8601 format, when the journey was created.</p>', 'WriteJourneyRequest$LastModifiedDate' => '<p>The date, in ISO 8601 format, when the journey was last modified.</p>', 'WriteJourneyRequest$Name' => '<p>The name of the journey. A journey name can contain a maximum of 150 characters. The characters can be alphanumeric characters or symbols, such as underscores (_) or hyphens (-). A journey name can\'t contain any spaces.</p>', 'WriteJourneyRequest$RefreshFrequency' => '<p>The frequency with which Amazon Pinpoint evaluates segment and event data for the journey, as a duration in ISO 8601 format.</p>', 'WriteJourneyRequest$StartActivity' => '<p>The unique identifier for the first activity in the journey. The identifier for this activity can contain a maximum of 128 characters. The characters must be alphanumeric characters.</p>', 'WriteSegmentRequest$Name' => '<p>The name of the segment.</p>', 'WriteTreatmentResource$TreatmentDescription' => '<p>A custom description of the treatment.</p>', 'WriteTreatmentResource$TreatmentName' => '<p>A custom name for the treatment.</p>', 'ListOf__string$member' => NULL, 'MapOf__string$member' => NULL, 'OpenHoursRule$StartTime' => '<p>The start of the scheduled time, in ISO 8601 format, when the channel can send messages.</p>', 'OpenHoursRule$EndTime' => '<p>The end of the scheduled time, in ISO 8601 format, when the channel can\'t send messages.</p>', 'ClosedDaysRule$Name' => '<p>The name of the closed day rule.</p>', 'ClosedDaysRule$StartDateTime' => '<p>Start DateTime ISO 8601 format</p>', 'ClosedDaysRule$EndDateTime' => '<p>End DateTime ISO 8601 format</p>', ], ], 'DayOfWeek' => [ 'base' => '<p>Day of a week.</p>', 'refs' => [ 'MapOfOpenHoursRules$key' => '<p>Day of a week when the rule will be applied. Valid values are [MONDAY, TUESDAY, WEDNESDAY, THURSDAY, FRIDAY, SATURDAY, SUNDAY]</p>', ], ], 'ListOfOpenHoursRules' => [ 'base' => '<p>List of OpenHours Rules.</p>', 'refs' => [ 'MapOfOpenHoursRules$value' => '<p>Open Hour Rules.</p>', ], ], 'OpenHoursRule' => [ 'base' => '<p>Specifies the start and end time for OpenHours.</p>', 'refs' => [ 'ListOfOpenHoursRules$member' => '<p>Open Hour Rule Details.</p>', ], ], 'MapOfListOfOpenHoursRules' => [ 'base' => '<p>OpenHours Rules for a channel</p>', 'refs' => [ 'OpenHours$EMAIL' => '<p>Specifies the schedule settings for the email channel.</p>', 'OpenHours$SMS' => '<p>Specifies the schedule settings for the SMS channel.</p>', 'OpenHours$PUSH' => '<p>Specifies the schedule settings for the push channel.</p>', 'OpenHours$VOICE' => '<p>Specifies the schedule settings for the voice channel.</p>', 'OpenHours$CUSTOM' => '<p>Specifies the schedule settings for the custom channel.</p>', ], ], 'OpenHours' => [ 'base' => '<p>Specifies the times when message are allowed to be sent to endpoints.</p>', 'refs' => [ 'WriteJourneyRequest$OpenHours' => '<p>The time when journey allow to send messages. QuietTime should be configured first and SendingSchedule should be set to true.</p>', 'JourneyResponse$OpenHours' => '<p>The time when a journey can send messages. QuietTime should be configured first and SendingSchedule should be set to true.</p>', ], ], 'ClosedDaysRule' => [ 'base' => '<p>Specifies the rule settings for when messages can\'t be sent.</p>', 'refs' => [ 'ListOfClosedDaysRules$member' => '<p>Closed Days Rule. Part of Journey sending schedule.</p>', ], ], 'ListOfClosedDaysRules' => [ 'base' => '<p>Rules for a Channel.</p>', 'refs' => [ 'OpenHours$EMAIL' => '<p>Rules for Email Channel.</p>', 'OpenHours$SMS' => '<p>Rules for SMS Channel.</p>', 'OpenHours$PUSH' => '<p>Rules for Push Channel.</p>', 'OpenHours$VOICE' => '<p>Rules for Email Channel.</p>', 'OpenHours$CUSTOM' => '<p>Rules for Custom Channel.</p>', ], ], 'ClosedDays' => [ 'base' => '<p>The time when a journey will not send messages. QuietTime should be configured first and SendingSchedule should be set to true.</p>', 'refs' => [ 'WriteJourneyRequest$ClosedDays' => '<p>The time when journey will stop sending messages. QuietTime should be configured first and SendingSchedule should be set to true.</p>', 'JourneyResponse$ClosedDays' => '<p>The time when a journey will not send messages. QuietTime should be configured first and SendingSchedule should be set to true.</p>', ], ], ],];
