<?php
// This file was auto-generated from sdk-root/src/data/pipes/2015-10-07/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon EventBridge Pipes connects event sources to targets. Pipes reduces the need for specialized knowledge and integration code when developing event driven architectures. This helps ensures consistency across your company’s applications. With Pipes, the target can be any available EventBridge target. To set up a pipe, you select the event source, add optional event filtering, define optional enrichment, and select the target for the event data. </p>', 'operations' => [ 'CreatePipe' => '<p>Create a pipe. Amazon EventBridge Pipes connect event sources to targets and reduces the need for specialized knowledge and integration code.</p>', 'DeletePipe' => '<p>Delete an existing pipe. For more information about pipes, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html">Amazon EventBridge Pipes</a> in the Amazon EventBridge User Guide.</p>', 'DescribePipe' => '<p>Get the information about an existing pipe. For more information about pipes, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html">Amazon EventBridge Pipes</a> in the Amazon EventBridge User Guide.</p>', 'ListPipes' => '<p>Get the pipes associated with this account. For more information about pipes, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html">Amazon EventBridge Pipes</a> in the Amazon EventBridge User Guide.</p>', 'ListTagsForResource' => '<p>Displays the tags associated with a pipe.</p>', 'StartPipe' => '<p>Start an existing pipe.</p>', 'StopPipe' => '<p>Stop an existing pipe.</p>', 'TagResource' => '<p>Assigns one or more tags (key-value pairs) to the specified pipe. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.</p> <p>Tags don\'t have any semantic meaning to Amazon Web Services and are interpreted strictly as strings of characters.</p> <p>You can use the <code>TagResource</code> action with a pipe that already has tags. If you specify a new tag key, this tag is appended to the list of tags associated with the pipe. If you specify a tag key that is already associated with the pipe, the new tag value that you specify replaces the previous value for that tag.</p> <p>You can associate as many as 50 tags with a pipe.</p>', 'UntagResource' => '<p>Removes one or more tags from the specified pipes.</p>', 'UpdatePipe' => '<p>Update an existing pipe. When you call <code>UpdatePipe</code>, EventBridge only the updates fields you have specified in the request; the rest remain unchanged. The exception to this is if you modify any Amazon Web Services-service specific fields in the <code>SourceParameters</code>, <code>EnrichmentParameters</code>, or <code>TargetParameters</code> objects. For example, <code>DynamoDBStreamParameters</code> or <code>EventBridgeEventBusParameters</code>. EventBridge updates the fields in these objects atomically as one and overrides existing values. This is by design, and means that if you don\'t specify an optional field in one of these <code>Parameters</code> objects, EventBridge sets that field to its system-default value during the update.</p> <p>For more information about pipes, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html"> Amazon EventBridge Pipes</a> in the Amazon EventBridge User Guide.</p>', ], 'shapes' => [ 'Arn' => [ 'base' => NULL, 'refs' => [ 'CreatePipeRequest$Target' => '<p>The ARN of the target resource.</p>', 'DeadLetterConfig$Arn' => '<p>The ARN of the specified target for the dead-letter queue. </p> <p>For Amazon Kinesis stream and Amazon DynamoDB stream sources, specify either an Amazon SNS topic or Amazon SQS queue ARN.</p>', 'DescribePipeResponse$Target' => '<p>The ARN of the target resource.</p>', 'Pipe$Target' => '<p>The ARN of the target resource.</p>', 'UpdatePipeRequest$Target' => '<p>The ARN of the target resource.</p>', ], ], 'ArnOrJsonPath' => [ 'base' => NULL, 'refs' => [ 'EcsTaskOverride$ExecutionRoleArn' => '<p>The Amazon Resource Name (ARN) of the task execution IAM role override for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html">Amazon ECS task execution IAM role</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>', 'EcsTaskOverride$TaskRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role that containers in this task can assume. All containers in this task are granted the permissions that are specified in this role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">IAM Role for Tasks</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>', 'EventBridgeEventResourceList$member' => NULL, 'PipeTargetEcsTaskParameters$TaskDefinitionArn' => '<p>The ARN of the task definition to use if the event target is an Amazon ECS task. </p>', ], ], 'ArnOrUrl' => [ 'base' => NULL, 'refs' => [ 'CreatePipeRequest$Source' => '<p>The ARN of the source resource.</p>', 'DescribePipeResponse$Source' => '<p>The ARN of the source resource.</p>', 'Pipe$Source' => '<p>The ARN of the source resource.</p>', ], ], 'AssignPublicIp' => [ 'base' => NULL, 'refs' => [ 'AwsVpcConfiguration$AssignPublicIp' => '<p>Specifies whether the task\'s elastic network interface receives a public IP address. You can specify <code>ENABLED</code> only when <code>LaunchType</code> in <code>EcsParameters</code> is set to <code>FARGATE</code>.</p>', ], ], 'AwsVpcConfiguration' => [ 'base' => '<p>This structure specifies the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.</p>', 'refs' => [ 'NetworkConfiguration$awsvpcConfiguration' => '<p>Use this structure to specify the VPC subnets and security groups for the task, and whether a public IP address is to be used. This structure is relevant only for ECS tasks that use the <code>awsvpc</code> network mode.</p>', ], ], 'BatchArrayProperties' => [ 'base' => '<p>The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an Batch job.</p>', 'refs' => [ 'PipeTargetBatchJobParameters$ArrayProperties' => '<p>The array properties for the submitted job, such as the size of the array. The array size can be between 2 and 10,000. If you specify array properties for a job, it becomes an array job. This parameter is used only if the target is an Batch job.</p>', ], ], 'BatchArraySize' => [ 'base' => NULL, 'refs' => [ 'BatchArrayProperties$Size' => '<p>The size of the array, if this is an array batch job.</p>', ], ], 'BatchContainerOverrides' => [ 'base' => '<p>The overrides that are sent to a container.</p>', 'refs' => [ 'PipeTargetBatchJobParameters$ContainerOverrides' => '<p>The overrides that are sent to a container.</p>', ], ], 'BatchDependsOn' => [ 'base' => NULL, 'refs' => [ 'PipeTargetBatchJobParameters$DependsOn' => '<p>A list of dependencies for the job. A job can depend upon a maximum of 20 jobs. You can specify a <code>SEQUENTIAL</code> type dependency without specifying a job ID for array jobs so that each child array job completes sequentially, starting at index 0. You can also specify an <code>N_TO_N</code> type dependency with a job ID for array jobs. In that case, each index child of this job must wait for the corresponding index child of each dependency to complete before it can begin.</p>', ], ], 'BatchEnvironmentVariable' => [ 'base' => '<p>The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition.</p> <note> <p>Environment variables cannot start with "<code>Batch</code>". This naming convention is reserved for variables that Batch sets.</p> </note>', 'refs' => [ 'BatchEnvironmentVariableList$member' => NULL, ], ], 'BatchEnvironmentVariableList' => [ 'base' => NULL, 'refs' => [ 'BatchContainerOverrides$Environment' => '<p>The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition.</p> <note> <p>Environment variables cannot start with "<code>Batch</code>". This naming convention is reserved for variables that Batch sets.</p> </note>', ], ], 'BatchJobDependency' => [ 'base' => '<p>An object that represents an Batch job dependency.</p>', 'refs' => [ 'BatchDependsOn$member' => NULL, ], ], 'BatchJobDependencyType' => [ 'base' => NULL, 'refs' => [ 'BatchJobDependency$Type' => '<p>The type of the job dependency.</p>', ], ], 'BatchParametersMap' => [ 'base' => NULL, 'refs' => [ 'PipeTargetBatchJobParameters$Parameters' => '<p>Additional parameters passed to the job that replace parameter substitution placeholders that are set in the job definition. Parameters are specified as a key and value pair mapping. Parameters included here override any corresponding parameter defaults from the job definition.</p>', ], ], 'BatchResourceRequirement' => [ 'base' => '<p>The type and amount of a resource to assign to a container. The supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.</p>', 'refs' => [ 'BatchResourceRequirementsList$member' => NULL, ], ], 'BatchResourceRequirementType' => [ 'base' => NULL, 'refs' => [ 'BatchResourceRequirement$Type' => '<p>The type of resource to assign to a container. The supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.</p>', ], ], 'BatchResourceRequirementsList' => [ 'base' => NULL, 'refs' => [ 'BatchContainerOverrides$ResourceRequirements' => '<p>The type and amount of resources to assign to a container. This overrides the settings in the job definition. The supported resources include <code>GPU</code>, <code>MEMORY</code>, and <code>VCPU</code>.</p>', ], ], 'BatchRetryAttempts' => [ 'base' => NULL, 'refs' => [ 'BatchRetryStrategy$Attempts' => '<p>The number of times to move a job to the <code>RUNNABLE</code> status. If the value of <code>attempts</code> is greater than one, the job is retried on failure the same number of attempts as the value.</p>', ], ], 'BatchRetryStrategy' => [ 'base' => '<p>The retry strategy that\'s associated with a job. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_retries.html"> Automated job retries</a> in the <i>Batch User Guide</i>.</p>', 'refs' => [ 'PipeTargetBatchJobParameters$RetryStrategy' => '<p>The retry strategy to use for failed jobs. When a retry strategy is specified here, it overrides the retry strategy defined in the job definition.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEcsTaskParameters$EnableECSManagedTags' => '<p>Specifies whether to enable Amazon ECS managed tags for the task. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a> in the Amazon Elastic Container Service Developer Guide. </p>', 'PipeTargetEcsTaskParameters$EnableExecuteCommand' => '<p>Whether or not to enable the execute command functionality for the containers in this task. If true, this enables execute command functionality on all containers in the task.</p>', 'PipeTargetRedshiftDataParameters$WithEvent' => '<p>Indicates whether to send an event back to EventBridge after the SQL statement runs.</p>', ], ], 'CapacityProvider' => [ 'base' => NULL, 'refs' => [ 'CapacityProviderStrategyItem$capacityProvider' => '<p>The short name of the capacity provider.</p>', ], ], 'CapacityProviderStrategy' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEcsTaskParameters$CapacityProviderStrategy' => '<p>The capacity provider strategy to use for the task.</p> <p>If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or launchType is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used. </p>', ], ], 'CapacityProviderStrategyItem' => [ 'base' => '<p>The details of a capacity provider strategy. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CapacityProviderStrategyItem.html">CapacityProviderStrategyItem</a> in the Amazon ECS API Reference.</p>', 'refs' => [ 'CapacityProviderStrategy$member' => NULL, ], ], 'CapacityProviderStrategyItemBase' => [ 'base' => NULL, 'refs' => [ 'CapacityProviderStrategyItem$base' => '<p>The base value designates how many tasks, at a minimum, to run on the specified capacity provider. Only one capacity provider in a capacity provider strategy can have a base defined. If no value is specified, the default value of 0 is used. </p>', ], ], 'CapacityProviderStrategyItemWeight' => [ 'base' => NULL, 'refs' => [ 'CapacityProviderStrategyItem$weight' => '<p>The weight value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider. The weight value is taken into consideration after the base value, if defined, is satisfied.</p>', ], ], 'CloudwatchLogGroupArn' => [ 'base' => NULL, 'refs' => [ 'CloudwatchLogsLogDestination$LogGroupArn' => '<p>The Amazon Web Services Resource Name (ARN) for the CloudWatch log group to which EventBridge sends the log records.</p>', 'CloudwatchLogsLogDestinationParameters$LogGroupArn' => '<p>The Amazon Web Services Resource Name (ARN) for the CloudWatch log group to which EventBridge sends the log records.</p>', ], ], 'CloudwatchLogsLogDestination' => [ 'base' => '<p>The Amazon CloudWatch Logs logging configuration settings for the pipe.</p>', 'refs' => [ 'PipeLogConfiguration$CloudwatchLogsLogDestination' => '<p>The Amazon CloudWatch Logs logging configuration settings for the pipe.</p>', ], ], 'CloudwatchLogsLogDestinationParameters' => [ 'base' => '<p>The Amazon CloudWatch Logs logging configuration settings for the pipe.</p>', 'refs' => [ 'PipeLogConfigurationParameters$CloudwatchLogsLogDestination' => '<p>The Amazon CloudWatch Logs logging configuration settings for the pipe.</p>', ], ], 'ConflictException' => [ 'base' => '<p>An action you attempted resulted in an exception.</p>', 'refs' => [], ], 'CreatePipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreatePipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'Database' => [ 'base' => '<p>// Redshift Database</p>', 'refs' => [ 'PipeTargetRedshiftDataParameters$Database' => '<p>The name of the database. Required when authenticating using temporary credentials.</p>', ], ], 'DbUser' => [ 'base' => '<p>// Database user name</p>', 'refs' => [ 'PipeTargetRedshiftDataParameters$DbUser' => '<p>The database user name. Required when authenticating using temporary credentials.</p>', ], ], 'DeadLetterConfig' => [ 'base' => '<p>A <code>DeadLetterConfig</code> object that contains information about a dead-letter queue configuration.</p>', 'refs' => [ 'PipeSourceDynamoDBStreamParameters$DeadLetterConfig' => '<p>Define the target queue to send dead-letter queue events to.</p>', 'PipeSourceKinesisStreamParameters$DeadLetterConfig' => '<p>Define the target queue to send dead-letter queue events to.</p>', 'UpdatePipeSourceDynamoDBStreamParameters$DeadLetterConfig' => '<p>Define the target queue to send dead-letter queue events to.</p>', 'UpdatePipeSourceKinesisStreamParameters$DeadLetterConfig' => '<p>Define the target queue to send dead-letter queue events to.</p>', ], ], 'DeletePipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeletePipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribePipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'DimensionMapping' => [ 'base' => '<p>Maps source data to a dimension in the target Timestream for LiveAnalytics table.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon Timestream for LiveAnalytics concepts</a> </p>', 'refs' => [ 'DimensionMappings$member' => NULL, ], ], 'DimensionMappings' => [ 'base' => NULL, 'refs' => [ 'PipeTargetTimestreamParameters$DimensionMappings' => '<p>Map source data to dimensions in the target Timestream for LiveAnalytics table.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon Timestream for LiveAnalytics concepts</a> </p>', ], ], 'DimensionName' => [ 'base' => NULL, 'refs' => [ 'DimensionMapping$DimensionName' => '<p>The metadata attributes of the time series. For example, the name and Availability Zone of an Amazon EC2 instance or the name of the manufacturer of a wind turbine are dimensions.</p>', ], ], 'DimensionValue' => [ 'base' => NULL, 'refs' => [ 'DimensionMapping$DimensionValue' => '<p>Dynamic path to the dimension value in the source event.</p>', ], ], 'DimensionValueType' => [ 'base' => NULL, 'refs' => [ 'DimensionMapping$DimensionValueType' => '<p>The data type of the dimension for the time-series data.</p>', ], ], 'DynamoDBStreamStartPosition' => [ 'base' => NULL, 'refs' => [ 'PipeSourceDynamoDBStreamParameters$StartingPosition' => '<p>(Streams only) The position in a stream from which to start reading.</p>', ], ], 'EcsContainerOverride' => [ 'base' => '<p>The overrides that are sent to a container. An empty container override can be passed in. An example of an empty container override is <code>{"containerOverrides": [ ] }</code>. If a non-empty container override is specified, the <code>name</code> parameter must be included.</p>', 'refs' => [ 'EcsContainerOverrideList$member' => NULL, ], ], 'EcsContainerOverrideList' => [ 'base' => NULL, 'refs' => [ 'EcsTaskOverride$ContainerOverrides' => '<p>One or more container overrides that are sent to a task.</p>', ], ], 'EcsEnvironmentFile' => [ 'base' => '<p>A list of files containing the environment variables to pass to a container. You can specify up to ten environment files. The file must have a <code>.env</code> file extension. Each line in an environment file should contain an environment variable in <code>VARIABLE=VALUE</code> format. Lines beginning with <code>#</code> are treated as comments and are ignored. For more information about the environment variable file syntax, see <a href="https://docs.docker.com/compose/env-file/">Declare default environment variables in file</a>.</p> <p>If there are environment variables specified using the <code>environment</code> parameter in a container definition, they take precedence over the variables contained within an environment file. If multiple environment files are specified that contain the same variable, they\'re processed from the top down. We recommend that you use unique variable names. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html">Specifying environment variables</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p> <p>This parameter is only supported for tasks hosted on Fargate using the following platform versions:</p> <ul> <li> <p>Linux platform version <code>1.4.0</code> or later.</p> </li> <li> <p>Windows platform version <code>1.0.0</code> or later.</p> </li> </ul>', 'refs' => [ 'EcsEnvironmentFileList$member' => NULL, ], ], 'EcsEnvironmentFileList' => [ 'base' => NULL, 'refs' => [ 'EcsContainerOverride$EnvironmentFiles' => '<p>A list of files containing the environment variables to pass to a container, instead of the value from the container definition.</p>', ], ], 'EcsEnvironmentFileType' => [ 'base' => NULL, 'refs' => [ 'EcsEnvironmentFile$type' => '<p>The file type to use. The only supported value is <code>s3</code>.</p>', ], ], 'EcsEnvironmentVariable' => [ 'base' => '<p>The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name.</p>', 'refs' => [ 'EcsEnvironmentVariableList$member' => NULL, ], ], 'EcsEnvironmentVariableList' => [ 'base' => NULL, 'refs' => [ 'EcsContainerOverride$Environment' => '<p>The environment variables to send to the container. You can add new environment variables, which are added to the container at launch, or you can override the existing environment variables from the Docker image or the task definition. You must also specify a container name.</p>', ], ], 'EcsEphemeralStorage' => [ 'base' => '<p>The amount of ephemeral storage to allocate for the task. This parameter is used to expand the total amount of ephemeral storage available, beyond the default amount, for tasks hosted on Fargate. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html">Fargate task storage</a> in the <i>Amazon ECS User Guide for Fargate</i>.</p> <note> <p>This parameter is only supported for tasks hosted on Fargate using Linux platform version <code>1.4.0</code> or later. This parameter is not supported for Windows containers on Fargate.</p> </note>', 'refs' => [ 'EcsTaskOverride$EphemeralStorage' => '<p>The ephemeral storage setting override for the task.</p> <note> <p>This parameter is only supported for tasks hosted on Fargate that use the following platform versions:</p> <ul> <li> <p>Linux platform version <code>1.4.0</code> or later.</p> </li> <li> <p>Windows platform version <code>1.0.0</code> or later.</p> </li> </ul> </note>', ], ], 'EcsInferenceAcceleratorOverride' => [ 'base' => '<p>Details on an Elastic Inference accelerator task override. This parameter is used to override the Elastic Inference accelerator specified in the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/ecs-inference.html">Working with Amazon Elastic Inference on Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>', 'refs' => [ 'EcsInferenceAcceleratorOverrideList$member' => NULL, ], ], 'EcsInferenceAcceleratorOverrideList' => [ 'base' => NULL, 'refs' => [ 'EcsTaskOverride$InferenceAcceleratorOverrides' => '<p>The Elastic Inference accelerator override for the task.</p>', ], ], 'EcsResourceRequirement' => [ 'base' => '<p>The type and amount of a resource to assign to a container. The supported resource types are GPUs and Elastic Inference accelerators. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-gpu.html">Working with GPUs on Amazon ECS</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html">Working with Amazon Elastic Inference on Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i> </p>', 'refs' => [ 'EcsResourceRequirementsList$member' => NULL, ], ], 'EcsResourceRequirementType' => [ 'base' => NULL, 'refs' => [ 'EcsResourceRequirement$type' => '<p>The type of resource to assign to a container. The supported values are <code>GPU</code> or <code>InferenceAccelerator</code>.</p>', ], ], 'EcsResourceRequirementsList' => [ 'base' => NULL, 'refs' => [ 'EcsContainerOverride$ResourceRequirements' => '<p>The type and amount of a resource to assign to a container, instead of the default value from the task definition. The only supported resource is a GPU.</p>', ], ], 'EcsTaskOverride' => [ 'base' => '<p>The overrides that are associated with a task.</p>', 'refs' => [ 'PipeTargetEcsTaskParameters$Overrides' => '<p>The overrides that are associated with a task.</p>', ], ], 'EndpointString' => [ 'base' => NULL, 'refs' => [ 'KafkaBootstrapServers$member' => NULL, ], ], 'EphemeralStorageSize' => [ 'base' => NULL, 'refs' => [ 'EcsEphemeralStorage$sizeInGiB' => '<p>The total amount, in GiB, of ephemeral storage to set for the task. The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.</p>', ], ], 'EpochTimeUnit' => [ 'base' => NULL, 'refs' => [ 'PipeTargetTimestreamParameters$EpochTimeUnit' => '<p>The granularity of the time units used. Default is <code>MILLISECONDS</code>.</p> <p>Required if <code>TimeFieldType</code> is specified as <code>EPOCH</code>.</p>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'NotFoundException$message' => NULL, 'ValidationException$message' => NULL, 'ValidationExceptionField$message' => '<p>The message of the exception.</p>', ], ], 'EventBridgeDetailType' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEventBridgeEventBusParameters$DetailType' => '<p>A free-form string, with a maximum of 128 characters, used to decide what fields to expect in the event detail.</p>', ], ], 'EventBridgeEndpointId' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEventBridgeEventBusParameters$EndpointId' => '<p>The URL subdomain of the endpoint. For example, if the URL for Endpoint is https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is <code>abcde.veo</code>.</p>', ], ], 'EventBridgeEventResourceList' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEventBridgeEventBusParameters$Resources' => '<p>Amazon Web Services resources, identified by Amazon Resource Name (ARN), which the event primarily concerns. Any number, including zero, may be present.</p>', ], ], 'EventBridgeEventSource' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEventBridgeEventBusParameters$Source' => '<p>The source of the event.</p>', ], ], 'EventPattern' => [ 'base' => NULL, 'refs' => [ 'Filter$Pattern' => '<p>The event pattern.</p>', ], ], 'Filter' => [ 'base' => '<p>Filter events using an event pattern. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'refs' => [ 'FilterList$member' => NULL, ], ], 'FilterCriteria' => [ 'base' => '<p>The collection of event patterns used to filter events.</p> <p>To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of <code>Filter</code> objects.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'refs' => [ 'PipeSourceParameters$FilterCriteria' => '<p>The collection of event patterns used to filter events.</p> <p>To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of <code>Filter</code> objects.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'UpdatePipeSourceParameters$FilterCriteria' => '<p>The collection of event patterns used to filter events.</p> <p>To remove a filter, specify a <code>FilterCriteria</code> object with an empty array of <code>Filter</code> objects.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html">Events and Event Patterns</a> in the <i>Amazon EventBridge User Guide</i>.</p>', ], ], 'FilterList' => [ 'base' => NULL, 'refs' => [ 'FilterCriteria$Filters' => '<p>The event patterns.</p>', ], ], 'FirehoseArn' => [ 'base' => NULL, 'refs' => [ 'FirehoseLogDestination$DeliveryStreamArn' => '<p>The Amazon Resource Name (ARN) of the Firehose delivery stream to which EventBridge delivers the pipe log records.</p>', 'FirehoseLogDestinationParameters$DeliveryStreamArn' => '<p>Specifies the Amazon Resource Name (ARN) of the Firehose delivery stream to which EventBridge delivers the pipe log records.</p>', ], ], 'FirehoseLogDestination' => [ 'base' => '<p>The Amazon Data Firehose logging configuration settings for the pipe.</p>', 'refs' => [ 'PipeLogConfiguration$FirehoseLogDestination' => '<p>The Amazon Data Firehose logging configuration settings for the pipe.</p>', ], ], 'FirehoseLogDestinationParameters' => [ 'base' => '<p>The Amazon Data Firehose logging configuration settings for the pipe.</p>', 'refs' => [ 'PipeLogConfigurationParameters$FirehoseLogDestination' => '<p>The Amazon Data Firehose logging configuration settings for the pipe.</p>', ], ], 'HeaderKey' => [ 'base' => NULL, 'refs' => [ 'HeaderParametersMap$key' => NULL, ], ], 'HeaderParametersMap' => [ 'base' => NULL, 'refs' => [ 'PipeEnrichmentHttpParameters$HeaderParameters' => '<p>The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.</p>', 'PipeTargetHttpParameters$HeaderParameters' => '<p>The headers that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.</p>', ], ], 'HeaderValue' => [ 'base' => NULL, 'refs' => [ 'HeaderParametersMap$value' => NULL, ], ], 'IncludeExecutionData' => [ 'base' => NULL, 'refs' => [ 'PipeLogConfiguration$IncludeExecutionData' => '<p>Whether the execution data (specifically, the <code>payload</code>, <code>awsRequest</code>, and <code>awsResponse</code> fields) is included in the log messages for this pipe.</p> <p>This applies to all log destinations for the pipe.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-logs.html#eb-pipes-logs-execution-data">Including execution data in logs</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'PipeLogConfigurationParameters$IncludeExecutionData' => '<p>Specify <code>ALL</code> to include the execution data (specifically, the <code>payload</code>, <code>awsRequest</code>, and <code>awsResponse</code> fields) in the log messages for this pipe.</p> <p>This applies to all log destinations for the pipe.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-logs.html#eb-pipes-logs-execution-data">Including execution data in logs</a> in the <i>Amazon EventBridge User Guide</i>.</p> <p>By default, execution data is not included.</p>', ], ], 'IncludeExecutionDataOption' => [ 'base' => NULL, 'refs' => [ 'IncludeExecutionData$member' => NULL, ], ], 'InputTemplate' => [ 'base' => NULL, 'refs' => [ 'PipeEnrichmentParameters$InputTemplate' => '<p>Valid JSON text passed to the enrichment. In this case, nothing from the event itself is passed to the enrichment. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data Interchange Format</a>.</p> <p>To remove an input template, specify an empty string.</p>', 'PipeTargetParameters$InputTemplate' => '<p>Valid JSON text passed to the target. In this case, nothing from the event itself is passed to the target. For more information, see <a href="http://www.rfc-editor.org/rfc/rfc7159.txt">The JavaScript Object Notation (JSON) Data Interchange Format</a>.</p> <p>To remove an input template, specify an empty string.</p>', ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'EcsContainerOverride$Cpu' => '<p>The number of <code>cpu</code> units reserved for the container, instead of the default value from the task definition. You must also specify a container name.</p>', 'EcsContainerOverride$Memory' => '<p>The hard limit (in MiB) of memory to present to the container, instead of the default value from the task definition. If your container attempts to exceed the memory specified here, the container is killed. You must also specify a container name.</p>', 'EcsContainerOverride$MemoryReservation' => '<p>The soft limit (in MiB) of memory to reserve for the container, instead of the default value from the task definition. You must also specify a container name.</p>', 'InternalException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying the action that caused the exception.</p>', 'ThrottlingException$retryAfterSeconds' => '<p>The number of seconds to wait before retrying the action that caused the exception.</p>', ], ], 'InternalException' => [ 'base' => '<p>This exception occurs due to unexpected causes.</p>', 'refs' => [], ], 'JsonPath' => [ 'base' => NULL, 'refs' => [ 'PipeTargetCloudWatchLogsParameters$Timestamp' => '<p>The time the event occurred, expressed as the number of milliseconds after Jan 1, 1970 00:00:00 UTC.</p>', 'PipeTargetEventBridgeEventBusParameters$Time' => '<p>The time stamp of the event, per <a href="https://www.rfc-editor.org/rfc/rfc3339.txt">RFC3339</a>. If no time stamp is provided, the time stamp of the <a href="https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html">PutEvents</a> call is used.</p>', ], ], 'KafkaBootstrapServers' => [ 'base' => NULL, 'refs' => [ 'PipeSourceSelfManagedKafkaParameters$AdditionalBootstrapServers' => '<p>An array of server URLs.</p>', ], ], 'KafkaTopicName' => [ 'base' => NULL, 'refs' => [ 'PipeSourceManagedStreamingKafkaParameters$TopicName' => '<p>The name of the topic that the pipe will read from.</p>', 'PipeSourceSelfManagedKafkaParameters$TopicName' => '<p>The name of the topic that the pipe will read from.</p>', ], ], 'KinesisPartitionKey' => [ 'base' => NULL, 'refs' => [ 'PipeTargetKinesisStreamParameters$PartitionKey' => '<p>Determines which shard in the stream the data record is assigned to. Partition keys are Unicode strings with a maximum length limit of 256 characters for each key. Amazon Kinesis Data Streams uses the partition key as input to a hash function that maps the partition key and associated data to a specific shard. Specifically, an MD5 hash function is used to map partition keys to 128-bit integer values and to map associated data records to shards. As a result of this hashing mechanism, all data records with the same partition key map to the same shard within the stream.</p>', ], ], 'KinesisStreamStartPosition' => [ 'base' => NULL, 'refs' => [ 'PipeSourceKinesisStreamParameters$StartingPosition' => '<p>(Streams only) The position in a stream from which to start reading.</p>', ], ], 'LaunchType' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEcsTaskParameters$LaunchType' => '<p>Specifies the launch type on which your task is running. The launch type that you specify here must match one of the launch type (compatibilities) of the target task. The <code>FARGATE</code> value is supported only in the Regions where Fargate with Amazon ECS is supported. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html">Fargate on Amazon ECS</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>', ], ], 'LimitMax10' => [ 'base' => NULL, 'refs' => [ 'PipeSourceDynamoDBStreamParameters$ParallelizationFactor' => '<p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>', 'PipeSourceKinesisStreamParameters$ParallelizationFactor' => '<p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>', 'UpdatePipeSourceDynamoDBStreamParameters$ParallelizationFactor' => '<p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>', 'UpdatePipeSourceKinesisStreamParameters$ParallelizationFactor' => '<p>(Streams only) The number of batches to process concurrently from each shard. The default value is 1.</p>', ], ], 'LimitMax100' => [ 'base' => NULL, 'refs' => [ 'ListPipesRequest$Limit' => '<p>The maximum number of pipes to include in the response.</p>', ], ], 'LimitMax10000' => [ 'base' => NULL, 'refs' => [ 'PipeSourceActiveMQBrokerParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'PipeSourceDynamoDBStreamParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'PipeSourceKinesisStreamParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'PipeSourceManagedStreamingKafkaParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'PipeSourceRabbitMQBrokerParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'PipeSourceSelfManagedKafkaParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'PipeSourceSqsQueueParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'UpdatePipeSourceActiveMQBrokerParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'UpdatePipeSourceDynamoDBStreamParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'UpdatePipeSourceKinesisStreamParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'UpdatePipeSourceManagedStreamingKafkaParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'UpdatePipeSourceRabbitMQBrokerParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'UpdatePipeSourceSelfManagedKafkaParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', 'UpdatePipeSourceSqsQueueParameters$BatchSize' => '<p>The maximum number of records to include in each batch.</p>', ], ], 'LimitMin1' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEcsTaskParameters$TaskCount' => '<p>The number of tasks to create based on <code>TaskDefinition</code>. The default is 1.</p>', ], ], 'ListPipesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListPipesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogLevel' => [ 'base' => NULL, 'refs' => [ 'PipeLogConfiguration$Level' => '<p>The level of logging detail to include. This applies to all log destinations for the pipe.</p>', 'PipeLogConfigurationParameters$Level' => '<p>The level of logging detail to include. This applies to all log destinations for the pipe.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-logs.html#eb-pipes-logs-level">Specifying EventBridge Pipes log level</a> in the <i>Amazon EventBridge User Guide</i>.</p>', ], ], 'LogStreamName' => [ 'base' => NULL, 'refs' => [ 'PipeTargetCloudWatchLogsParameters$LogStreamName' => '<p>The name of the log stream.</p>', ], ], 'MQBrokerAccessCredentials' => [ 'base' => '<p>The Secrets Manager secret that stores your broker credentials.</p>', 'refs' => [ 'PipeSourceActiveMQBrokerParameters$Credentials' => '<p>The credentials needed to access the resource.</p>', 'PipeSourceRabbitMQBrokerParameters$Credentials' => '<p>The credentials needed to access the resource.</p>', 'UpdatePipeSourceActiveMQBrokerParameters$Credentials' => '<p>The credentials needed to access the resource.</p>', 'UpdatePipeSourceRabbitMQBrokerParameters$Credentials' => '<p>The credentials needed to access the resource.</p>', ], ], 'MQBrokerQueueName' => [ 'base' => NULL, 'refs' => [ 'PipeSourceActiveMQBrokerParameters$QueueName' => '<p>The name of the destination queue to consume.</p>', 'PipeSourceRabbitMQBrokerParameters$QueueName' => '<p>The name of the destination queue to consume.</p>', ], ], 'MSKAccessCredentials' => [ 'base' => '<p>The Secrets Manager secret that stores your stream credentials.</p>', 'refs' => [ 'PipeSourceManagedStreamingKafkaParameters$Credentials' => '<p>The credentials needed to access the resource.</p>', 'UpdatePipeSourceManagedStreamingKafkaParameters$Credentials' => '<p>The credentials needed to access the resource.</p>', ], ], 'MSKStartPosition' => [ 'base' => NULL, 'refs' => [ 'PipeSourceManagedStreamingKafkaParameters$StartingPosition' => '<p>(Streams only) The position in a stream from which to start reading.</p>', ], ], 'MaximumBatchingWindowInSeconds' => [ 'base' => NULL, 'refs' => [ 'PipeSourceActiveMQBrokerParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'PipeSourceDynamoDBStreamParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'PipeSourceKinesisStreamParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'PipeSourceManagedStreamingKafkaParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'PipeSourceRabbitMQBrokerParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'PipeSourceSelfManagedKafkaParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'PipeSourceSqsQueueParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'UpdatePipeSourceActiveMQBrokerParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'UpdatePipeSourceDynamoDBStreamParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'UpdatePipeSourceKinesisStreamParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'UpdatePipeSourceManagedStreamingKafkaParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'UpdatePipeSourceRabbitMQBrokerParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'UpdatePipeSourceSelfManagedKafkaParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', 'UpdatePipeSourceSqsQueueParameters$MaximumBatchingWindowInSeconds' => '<p>The maximum length of a time to wait for events.</p>', ], ], 'MaximumRecordAgeInSeconds' => [ 'base' => NULL, 'refs' => [ 'PipeSourceDynamoDBStreamParameters$MaximumRecordAgeInSeconds' => '<p>(Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records. </p>', 'PipeSourceKinesisStreamParameters$MaximumRecordAgeInSeconds' => '<p>(Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records. </p>', 'UpdatePipeSourceDynamoDBStreamParameters$MaximumRecordAgeInSeconds' => '<p>(Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records. </p>', 'UpdatePipeSourceKinesisStreamParameters$MaximumRecordAgeInSeconds' => '<p>(Streams only) Discard records older than the specified age. The default value is -1, which sets the maximum age to infinite. When the value is set to infinite, EventBridge never discards old records. </p>', ], ], 'MaximumRetryAttemptsESM' => [ 'base' => NULL, 'refs' => [ 'PipeSourceDynamoDBStreamParameters$MaximumRetryAttempts' => '<p>(Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source.</p>', 'PipeSourceKinesisStreamParameters$MaximumRetryAttempts' => '<p>(Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source.</p>', 'UpdatePipeSourceDynamoDBStreamParameters$MaximumRetryAttempts' => '<p>(Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source.</p>', 'UpdatePipeSourceKinesisStreamParameters$MaximumRetryAttempts' => '<p>(Streams only) Discard records after the specified number of retries. The default value is -1, which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, EventBridge retries failed records until the record expires in the event source.</p>', ], ], 'MeasureName' => [ 'base' => NULL, 'refs' => [ 'SingleMeasureMapping$MeasureName' => '<p>Target measure name for the measurement attribute in the Timestream table.</p>', ], ], 'MeasureValue' => [ 'base' => NULL, 'refs' => [ 'MultiMeasureAttributeMapping$MeasureValue' => '<p>Dynamic path to the measurement attribute in the source event.</p>', 'SingleMeasureMapping$MeasureValue' => '<p>Dynamic path of the source field to map to the measure in the record.</p>', ], ], 'MeasureValueType' => [ 'base' => NULL, 'refs' => [ 'MultiMeasureAttributeMapping$MeasureValueType' => '<p>Data type of the measurement attribute in the source event.</p>', 'SingleMeasureMapping$MeasureValueType' => '<p>Data type of the source field.</p>', ], ], 'MessageDeduplicationId' => [ 'base' => NULL, 'refs' => [ 'PipeTargetSqsQueueParameters$MessageDeduplicationId' => '<p>This parameter applies only to FIFO (first-in-first-out) queues.</p> <p>The token used for deduplication of sent messages.</p>', ], ], 'MessageGroupId' => [ 'base' => NULL, 'refs' => [ 'PipeTargetSqsQueueParameters$MessageGroupId' => '<p>The FIFO message group ID to use as the target.</p>', ], ], 'MultiMeasureAttributeMapping' => [ 'base' => '<p>A mapping of a source event data field to a measure in a Timestream for LiveAnalytics record.</p>', 'refs' => [ 'MultiMeasureAttributeMappings$member' => NULL, ], ], 'MultiMeasureAttributeMappings' => [ 'base' => NULL, 'refs' => [ 'MultiMeasureMapping$MultiMeasureAttributeMappings' => '<p>Mappings that represent multiple source event fields mapped to measures in the same Timestream for LiveAnalytics record.</p>', ], ], 'MultiMeasureAttributeName' => [ 'base' => NULL, 'refs' => [ 'MultiMeasureAttributeMapping$MultiMeasureAttributeName' => '<p>Target measure name to be used.</p>', ], ], 'MultiMeasureMapping' => [ 'base' => '<p>Maps multiple measures from the source event to the same Timestream for LiveAnalytics record.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon Timestream for LiveAnalytics concepts</a> </p>', 'refs' => [ 'MultiMeasureMappings$member' => NULL, ], ], 'MultiMeasureMappings' => [ 'base' => NULL, 'refs' => [ 'PipeTargetTimestreamParameters$MultiMeasureMappings' => '<p>Maps multiple measures from the source event to the same record in the specified Timestream for LiveAnalytics table.</p>', ], ], 'MultiMeasureName' => [ 'base' => NULL, 'refs' => [ 'MultiMeasureMapping$MultiMeasureName' => '<p>The name of the multiple measurements per record (multi-measure).</p>', ], ], 'NetworkConfiguration' => [ 'base' => '<p>This structure specifies the network configuration for an Amazon ECS task.</p>', 'refs' => [ 'PipeTargetEcsTaskParameters$NetworkConfiguration' => '<p>Use this structure if the Amazon ECS task uses the <code>awsvpc</code> network mode. This structure specifies the VPC subnets and security groups associated with the task, and whether a public IP address is to be used. This structure is required if <code>LaunchType</code> is <code>FARGATE</code> because the <code>awsvpc</code> mode is required for Fargate tasks.</p> <p>If you specify <code>NetworkConfiguration</code> when the target ECS task does not use the <code>awsvpc</code> network mode, the task fails.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListPipesRequest$NextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.</p>', 'ListPipesResponse$NextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an HTTP 400 InvalidToken error.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>An entity that you specified does not exist.</p>', 'refs' => [], ], 'OnPartialBatchItemFailureStreams' => [ 'base' => NULL, 'refs' => [ 'PipeSourceDynamoDBStreamParameters$OnPartialBatchItemFailure' => '<p>(Streams only) Define how to handle item process failures. <code>AUTOMATIC_BISECT</code> halves each batch and retry each half until all the records are processed or there is one failed message left in the batch.</p>', 'PipeSourceKinesisStreamParameters$OnPartialBatchItemFailure' => '<p>(Streams only) Define how to handle item process failures. <code>AUTOMATIC_BISECT</code> halves each batch and retry each half until all the records are processed or there is one failed message left in the batch.</p>', 'UpdatePipeSourceDynamoDBStreamParameters$OnPartialBatchItemFailure' => '<p>(Streams only) Define how to handle item process failures. <code>AUTOMATIC_BISECT</code> halves each batch and retry each half until all the records are processed or there is one failed message left in the batch.</p>', 'UpdatePipeSourceKinesisStreamParameters$OnPartialBatchItemFailure' => '<p>(Streams only) Define how to handle item process failures. <code>AUTOMATIC_BISECT</code> halves each batch and retry each half until all the records are processed or there is one failed message left in the batch.</p>', ], ], 'OptionalArn' => [ 'base' => NULL, 'refs' => [ 'CreatePipeRequest$Enrichment' => '<p>The ARN of the enrichment resource.</p>', 'DescribePipeResponse$Enrichment' => '<p>The ARN of the enrichment resource.</p>', 'Pipe$Enrichment' => '<p>The ARN of the enrichment resource.</p>', 'UpdatePipeRequest$Enrichment' => '<p>The ARN of the enrichment resource.</p>', ], ], 'PathParameter' => [ 'base' => NULL, 'refs' => [ 'PathParameterList$member' => NULL, ], ], 'PathParameterList' => [ 'base' => NULL, 'refs' => [ 'PipeEnrichmentHttpParameters$PathParameterValues' => '<p>The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").</p>', 'PipeTargetHttpParameters$PathParameterValues' => '<p>The path parameter values to be used to populate API Gateway REST API or EventBridge ApiDestination path wildcards ("*").</p>', ], ], 'Pipe' => [ 'base' => '<p>An object that represents a pipe. Amazon EventBridgePipes connect event sources to targets and reduces the need for specialized knowledge and integration code.</p>', 'refs' => [ 'PipeList$member' => NULL, ], ], 'PipeArn' => [ 'base' => NULL, 'refs' => [ 'CreatePipeResponse$Arn' => '<p>The ARN of the pipe.</p>', 'DeletePipeResponse$Arn' => '<p>The ARN of the pipe.</p>', 'DescribePipeResponse$Arn' => '<p>The ARN of the pipe.</p>', 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the pipe for which you want to view tags.</p>', 'Pipe$Arn' => '<p>The ARN of the pipe.</p>', 'StartPipeResponse$Arn' => '<p>The ARN of the pipe.</p>', 'StopPipeResponse$Arn' => '<p>The ARN of the pipe.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the pipe.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the pipe.</p>', 'UpdatePipeResponse$Arn' => '<p>The ARN of the pipe.</p>', ], ], 'PipeDescription' => [ 'base' => NULL, 'refs' => [ 'CreatePipeRequest$Description' => '<p>A description of the pipe.</p>', 'DescribePipeResponse$Description' => '<p>A description of the pipe.</p>', 'UpdatePipeRequest$Description' => '<p>A description of the pipe.</p>', ], ], 'PipeEnrichmentHttpParameters' => [ 'base' => '<p>These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations. In the latter case, these are merged with any InvocationParameters specified on the Connection, with any values from the Connection taking precedence.</p>', 'refs' => [ 'PipeEnrichmentParameters$HttpParameters' => '<p>Contains the HTTP parameters to use when the target is a API Gateway REST endpoint or EventBridge ApiDestination.</p> <p>If you specify an API Gateway REST API or EventBridge ApiDestination as a target, you can use this parameter to specify headers, path parameters, and query string keys/values as part of your target invoking request. If you\'re using ApiDestinations, the corresponding Connection can also have these values configured. In case of any conflicting keys, values from the Connection take precedence.</p>', ], ], 'PipeEnrichmentParameters' => [ 'base' => '<p>The parameters required to set up enrichment on your pipe.</p>', 'refs' => [ 'CreatePipeRequest$EnrichmentParameters' => '<p>The parameters required to set up enrichment on your pipe.</p>', 'DescribePipeResponse$EnrichmentParameters' => '<p>The parameters required to set up enrichment on your pipe.</p>', 'UpdatePipeRequest$EnrichmentParameters' => '<p>The parameters required to set up enrichment on your pipe.</p>', ], ], 'PipeList' => [ 'base' => NULL, 'refs' => [ 'ListPipesResponse$Pipes' => '<p>The pipes returned by the call.</p>', ], ], 'PipeLogConfiguration' => [ 'base' => '<p>The logging configuration settings for the pipe.</p>', 'refs' => [ 'DescribePipeResponse$LogConfiguration' => '<p>The logging configuration settings for the pipe.</p>', ], ], 'PipeLogConfigurationParameters' => [ 'base' => '<p>Specifies the logging configuration settings for the pipe.</p> <p>When you call <code>UpdatePipe</code>, EventBridge updates the fields in the <code>PipeLogConfigurationParameters</code> object atomically as one and overrides existing values. This is by design. If you don\'t specify an optional field in any of the Amazon Web Services service parameters objects (<code>CloudwatchLogsLogDestinationParameters</code>, <code>FirehoseLogDestinationParameters</code>, or <code>S3LogDestinationParameters</code>), EventBridge sets that field to its system-default value during the update. </p> <p>For example, suppose when you created the pipe you specified a Firehose stream log destination. You then update the pipe to add an Amazon S3 log destination. In addition to specifying the <code>S3LogDestinationParameters</code> for the new log destination, you must also specify the fields in the <code>FirehoseLogDestinationParameters</code> object in order to retain the Firehose stream log destination. </p> <p>For more information on generating pipe log records, see <a href="eventbridge/latest/userguide/eb-pipes-logs.html">Log EventBridge Pipes</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'refs' => [ 'CreatePipeRequest$LogConfiguration' => '<p>The logging configuration settings for the pipe.</p>', 'UpdatePipeRequest$LogConfiguration' => '<p>The logging configuration settings for the pipe.</p>', ], ], 'PipeName' => [ 'base' => NULL, 'refs' => [ 'CreatePipeRequest$Name' => '<p>The name of the pipe.</p>', 'CreatePipeResponse$Name' => '<p>The name of the pipe.</p>', 'DeletePipeRequest$Name' => '<p>The name of the pipe.</p>', 'DeletePipeResponse$Name' => '<p>The name of the pipe.</p>', 'DescribePipeRequest$Name' => '<p>The name of the pipe.</p>', 'DescribePipeResponse$Name' => '<p>The name of the pipe.</p>', 'ListPipesRequest$NamePrefix' => '<p>A value that will return a subset of the pipes associated with this account. For example, <code>"NamePrefix": "ABC"</code> will return all endpoints with "ABC" in the name.</p>', 'Pipe$Name' => '<p>The name of the pipe.</p>', 'StartPipeRequest$Name' => '<p>The name of the pipe.</p>', 'StartPipeResponse$Name' => '<p>The name of the pipe.</p>', 'StopPipeRequest$Name' => '<p>The name of the pipe.</p>', 'StopPipeResponse$Name' => '<p>The name of the pipe.</p>', 'UpdatePipeRequest$Name' => '<p>The name of the pipe.</p>', 'UpdatePipeResponse$Name' => '<p>The name of the pipe.</p>', ], ], 'PipeSourceActiveMQBrokerParameters' => [ 'base' => '<p>The parameters for using an Active MQ broker as a source.</p>', 'refs' => [ 'PipeSourceParameters$ActiveMQBrokerParameters' => '<p>The parameters for using an Active MQ broker as a source.</p>', ], ], 'PipeSourceDynamoDBStreamParameters' => [ 'base' => '<p>The parameters for using a DynamoDB stream as a source.</p>', 'refs' => [ 'PipeSourceParameters$DynamoDBStreamParameters' => '<p>The parameters for using a DynamoDB stream as a source.</p>', ], ], 'PipeSourceKinesisStreamParameters' => [ 'base' => '<p>The parameters for using a Kinesis stream as a source.</p>', 'refs' => [ 'PipeSourceParameters$KinesisStreamParameters' => '<p>The parameters for using a Kinesis stream as a source.</p>', ], ], 'PipeSourceManagedStreamingKafkaParameters' => [ 'base' => '<p>The parameters for using an MSK stream as a source.</p>', 'refs' => [ 'PipeSourceParameters$ManagedStreamingKafkaParameters' => '<p>The parameters for using an MSK stream as a source.</p>', ], ], 'PipeSourceParameters' => [ 'base' => '<p>The parameters required to set up a source for your pipe.</p>', 'refs' => [ 'CreatePipeRequest$SourceParameters' => '<p>The parameters required to set up a source for your pipe.</p>', 'DescribePipeResponse$SourceParameters' => '<p>The parameters required to set up a source for your pipe.</p>', ], ], 'PipeSourceRabbitMQBrokerParameters' => [ 'base' => '<p>The parameters for using a Rabbit MQ broker as a source.</p>', 'refs' => [ 'PipeSourceParameters$RabbitMQBrokerParameters' => '<p>The parameters for using a Rabbit MQ broker as a source.</p>', ], ], 'PipeSourceSelfManagedKafkaParameters' => [ 'base' => '<p>The parameters for using a self-managed Apache Kafka stream as a source.</p> <p>A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services. This includes both clusters you manage yourself, as well as those hosted by a third-party provider, such as <a href="https://www.confluent.io/">Confluent Cloud</a>, <a href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a href="https://redpanda.com/">Redpanda</a>. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka streams as a source</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'refs' => [ 'PipeSourceParameters$SelfManagedKafkaParameters' => '<p>The parameters for using a self-managed Apache Kafka stream as a source.</p> <p>A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services. This includes both clusters you manage yourself, as well as those hosted by a third-party provider, such as <a href="https://www.confluent.io/">Confluent Cloud</a>, <a href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a href="https://redpanda.com/">Redpanda</a>. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka streams as a source</a> in the <i>Amazon EventBridge User Guide</i>.</p>', ], ], 'PipeSourceSqsQueueParameters' => [ 'base' => '<p>The parameters for using a Amazon SQS stream as a source.</p>', 'refs' => [ 'PipeSourceParameters$SqsQueueParameters' => '<p>The parameters for using a Amazon SQS stream as a source.</p>', ], ], 'PipeState' => [ 'base' => NULL, 'refs' => [ 'CreatePipeResponse$CurrentState' => '<p>The state the pipe is in.</p>', 'DeletePipeResponse$CurrentState' => '<p>The state the pipe is in.</p>', 'DescribePipeResponse$CurrentState' => '<p>The state the pipe is in.</p>', 'ListPipesRequest$CurrentState' => '<p>The state the pipe is in.</p>', 'Pipe$CurrentState' => '<p>The state the pipe is in.</p>', 'StartPipeResponse$CurrentState' => '<p>The state the pipe is in.</p>', 'StopPipeResponse$CurrentState' => '<p>The state the pipe is in.</p>', 'UpdatePipeResponse$CurrentState' => '<p>The state the pipe is in.</p>', ], ], 'PipeStateReason' => [ 'base' => NULL, 'refs' => [ 'DescribePipeResponse$StateReason' => '<p>The reason the pipe is in its current state.</p>', 'Pipe$StateReason' => '<p>The reason the pipe is in its current state.</p>', ], ], 'PipeTargetBatchJobParameters' => [ 'base' => '<p>The parameters for using an Batch job as a target.</p>', 'refs' => [ 'PipeTargetParameters$BatchJobParameters' => '<p>The parameters for using an Batch job as a target.</p>', ], ], 'PipeTargetCloudWatchLogsParameters' => [ 'base' => '<p>The parameters for using an CloudWatch Logs log stream as a target.</p>', 'refs' => [ 'PipeTargetParameters$CloudWatchLogsParameters' => '<p>The parameters for using an CloudWatch Logs log stream as a target.</p>', ], ], 'PipeTargetEcsTaskParameters' => [ 'base' => '<p>The parameters for using an Amazon ECS task as a target.</p>', 'refs' => [ 'PipeTargetParameters$EcsTaskParameters' => '<p>The parameters for using an Amazon ECS task as a target.</p>', ], ], 'PipeTargetEventBridgeEventBusParameters' => [ 'base' => '<p>The parameters for using an EventBridge event bus as a target.</p>', 'refs' => [ 'PipeTargetParameters$EventBridgeEventBusParameters' => '<p>The parameters for using an EventBridge event bus as a target.</p>', ], ], 'PipeTargetHttpParameters' => [ 'base' => '<p>These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations.</p>', 'refs' => [ 'PipeTargetParameters$HttpParameters' => '<p>These are custom parameter to be used when the target is an API Gateway REST APIs or EventBridge ApiDestinations.</p>', ], ], 'PipeTargetInvocationType' => [ 'base' => NULL, 'refs' => [ 'PipeTargetLambdaFunctionParameters$InvocationType' => '<p>Specify whether to invoke the function synchronously or asynchronously.</p> <ul> <li> <p> <code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. This corresponds to the <code>RequestResponse</code> option in the <code>InvocationType</code> parameter for the Lambda <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.</p> </li> <li> <p> <code>FIRE_AND_FORGET</code> - Invoke asynchronously. This corresponds to the <code>Event</code> option in the <code>InvocationType</code> parameter for the Lambda <a href="https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax">Invoke</a> API.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation">Invocation types</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'PipeTargetStateMachineParameters$InvocationType' => '<p>Specify whether to invoke the Step Functions state machine synchronously or asynchronously.</p> <ul> <li> <p> <code>REQUEST_RESPONSE</code> (default) - Invoke synchronously. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartSyncExecution.html">StartSyncExecution</a> in the <i>Step Functions API Reference</i>.</p> <note> <p> <code>REQUEST_RESPONSE</code> is not supported for <code>STANDARD</code> state machine workflows.</p> </note> </li> <li> <p> <code>FIRE_AND_FORGET</code> - Invoke asynchronously. For more information, see <a href="https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html">StartExecution</a> in the <i>Step Functions API Reference</i>.</p> </li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation">Invocation types</a> in the <i>Amazon EventBridge User Guide</i>.</p>', ], ], 'PipeTargetKinesisStreamParameters' => [ 'base' => '<p>The parameters for using a Kinesis stream as a target.</p>', 'refs' => [ 'PipeTargetParameters$KinesisStreamParameters' => '<p>The parameters for using a Kinesis stream as a target.</p>', ], ], 'PipeTargetLambdaFunctionParameters' => [ 'base' => '<p>The parameters for using a Lambda function as a target.</p>', 'refs' => [ 'PipeTargetParameters$LambdaFunctionParameters' => '<p>The parameters for using a Lambda function as a target.</p>', ], ], 'PipeTargetParameters' => [ 'base' => '<p>The parameters required to set up a target for your pipe.</p> <p>For more information about pipe target parameters, including how to use dynamic path parameters, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target parameters</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'refs' => [ 'CreatePipeRequest$TargetParameters' => '<p>The parameters required to set up a target for your pipe.</p> <p>For more information about pipe target parameters, including how to use dynamic path parameters, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target parameters</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'DescribePipeResponse$TargetParameters' => '<p>The parameters required to set up a target for your pipe.</p> <p>For more information about pipe target parameters, including how to use dynamic path parameters, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target parameters</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'UpdatePipeRequest$TargetParameters' => '<p>The parameters required to set up a target for your pipe.</p> <p>For more information about pipe target parameters, including how to use dynamic path parameters, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html">Target parameters</a> in the <i>Amazon EventBridge User Guide</i>.</p>', ], ], 'PipeTargetRedshiftDataParameters' => [ 'base' => '<p>These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement.</p>', 'refs' => [ 'PipeTargetParameters$RedshiftDataParameters' => '<p>These are custom parameters to be used when the target is a Amazon Redshift cluster to invoke the Amazon Redshift Data API BatchExecuteStatement.</p>', ], ], 'PipeTargetSageMakerPipelineParameters' => [ 'base' => '<p>The parameters for using a SageMaker pipeline as a target.</p>', 'refs' => [ 'PipeTargetParameters$SageMakerPipelineParameters' => '<p>The parameters for using a SageMaker pipeline as a target.</p>', ], ], 'PipeTargetSqsQueueParameters' => [ 'base' => '<p>The parameters for using a Amazon SQS stream as a target.</p>', 'refs' => [ 'PipeTargetParameters$SqsQueueParameters' => '<p>The parameters for using a Amazon SQS stream as a target.</p>', ], ], 'PipeTargetStateMachineParameters' => [ 'base' => '<p>The parameters for using a Step Functions state machine as a target.</p>', 'refs' => [ 'PipeTargetParameters$StepFunctionStateMachineParameters' => '<p>The parameters for using a Step Functions state machine as a target.</p>', ], ], 'PipeTargetTimestreamParameters' => [ 'base' => '<p>The parameters for using a Timestream for LiveAnalytics table as a target.</p>', 'refs' => [ 'PipeTargetParameters$TimestreamParameters' => '<p>The parameters for using a Timestream for LiveAnalytics table as a target.</p>', ], ], 'PlacementConstraint' => [ 'base' => '<p>An object representing a constraint on task placement. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Task Placement Constraints</a> in the Amazon Elastic Container Service Developer Guide.</p>', 'refs' => [ 'PlacementConstraints$member' => NULL, ], ], 'PlacementConstraintExpression' => [ 'base' => NULL, 'refs' => [ 'PlacementConstraint$expression' => '<p>A cluster query language expression to apply to the constraint. You cannot specify an expression if the constraint type is <code>distinctInstance</code>. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster Query Language</a> in the Amazon Elastic Container Service Developer Guide. </p>', ], ], 'PlacementConstraintType' => [ 'base' => NULL, 'refs' => [ 'PlacementConstraint$type' => '<p>The type of constraint. Use distinctInstance to ensure that each task in a particular group is running on a different container instance. Use memberOf to restrict the selection to a group of valid candidates. </p>', ], ], 'PlacementConstraints' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEcsTaskParameters$PlacementConstraints' => '<p>An array of placement constraint objects to use for the task. You can specify up to 10 constraints per task (including constraints in the task definition and those specified at runtime).</p>', ], ], 'PlacementStrategies' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEcsTaskParameters$PlacementStrategy' => '<p>The placement strategy objects to use for the task. You can specify a maximum of five strategy rules per task. </p>', ], ], 'PlacementStrategy' => [ 'base' => '<p>The task placement strategy for a task or service. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task Placement Strategies</a> in the Amazon Elastic Container Service Service Developer Guide.</p>', 'refs' => [ 'PlacementStrategies$member' => NULL, ], ], 'PlacementStrategyField' => [ 'base' => NULL, 'refs' => [ 'PlacementStrategy$field' => '<p>The field to apply the placement strategy against. For the spread placement strategy, valid values are instanceId (or host, which has the same effect), or any platform or custom attribute that is applied to a container instance, such as attribute:ecs.availability-zone. For the binpack placement strategy, valid values are cpu and memory. For the random placement strategy, this field is not used. </p>', ], ], 'PlacementStrategyType' => [ 'base' => NULL, 'refs' => [ 'PlacementStrategy$type' => '<p>The type of placement strategy. The random placement strategy randomly places tasks on available candidates. The spread placement strategy spreads placement across available candidates evenly based on the field parameter. The binpack strategy places tasks on available candidates that have the least available amount of the resource that is specified with the field parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory (but still enough to run the task). </p>', ], ], 'PropagateTags' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEcsTaskParameters$PropagateTags' => '<p>Specifies whether to propagate the tags from the task definition to the task. If no value is specified, the tags are not propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the <code>TagResource</code> API action. </p>', ], ], 'QueryStringKey' => [ 'base' => NULL, 'refs' => [ 'QueryStringParametersMap$key' => NULL, ], ], 'QueryStringParametersMap' => [ 'base' => NULL, 'refs' => [ 'PipeEnrichmentHttpParameters$QueryStringParameters' => '<p>The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.</p>', 'PipeTargetHttpParameters$QueryStringParameters' => '<p>The query string keys/values that need to be sent as part of request invoking the API Gateway REST API or EventBridge ApiDestination.</p>', ], ], 'QueryStringValue' => [ 'base' => NULL, 'refs' => [ 'QueryStringParametersMap$value' => NULL, ], ], 'ReferenceId' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEcsTaskParameters$ReferenceId' => '<p>The reference ID to use for the task.</p>', ], ], 'RequestedPipeState' => [ 'base' => NULL, 'refs' => [ 'CreatePipeRequest$DesiredState' => '<p>The state the pipe should be in.</p>', 'CreatePipeResponse$DesiredState' => '<p>The state the pipe should be in.</p>', 'ListPipesRequest$DesiredState' => '<p>The state the pipe should be in.</p>', 'Pipe$DesiredState' => '<p>The state the pipe should be in.</p>', 'StartPipeResponse$DesiredState' => '<p>The state the pipe should be in.</p>', 'StopPipeResponse$DesiredState' => '<p>The state the pipe should be in.</p>', 'UpdatePipeRequest$DesiredState' => '<p>The state the pipe should be in.</p>', 'UpdatePipeResponse$DesiredState' => '<p>The state the pipe should be in.</p>', ], ], 'RequestedPipeStateDescribeResponse' => [ 'base' => NULL, 'refs' => [ 'DeletePipeResponse$DesiredState' => '<p>The state the pipe should be in.</p>', 'DescribePipeResponse$DesiredState' => '<p>The state the pipe should be in.</p>', ], ], 'ResourceArn' => [ 'base' => NULL, 'refs' => [ 'ListPipesRequest$SourcePrefix' => '<p>The prefix matching the pipe source.</p>', 'ListPipesRequest$TargetPrefix' => '<p>The prefix matching the pipe target.</p>', ], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'CreatePipeRequest$RoleArn' => '<p>The ARN of the role that allows the pipe to send data to the target.</p>', 'DescribePipeResponse$RoleArn' => '<p>The ARN of the role that allows the pipe to send data to the target.</p>', 'UpdatePipeRequest$RoleArn' => '<p>The ARN of the role that allows the pipe to send data to the target.</p>', ], ], 'S3LogDestination' => [ 'base' => '<p>The Amazon S3 logging configuration settings for the pipe.</p>', 'refs' => [ 'PipeLogConfiguration$S3LogDestination' => '<p>The Amazon S3 logging configuration settings for the pipe.</p>', ], ], 'S3LogDestinationParameters' => [ 'base' => '<p>The Amazon S3 logging configuration settings for the pipe.</p>', 'refs' => [ 'PipeLogConfigurationParameters$S3LogDestination' => '<p>The Amazon S3 logging configuration settings for the pipe.</p>', ], ], 'S3LogDestinationParametersBucketNameString' => [ 'base' => NULL, 'refs' => [ 'S3LogDestinationParameters$BucketName' => '<p>Specifies the name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.</p>', ], ], 'S3LogDestinationParametersBucketOwnerString' => [ 'base' => NULL, 'refs' => [ 'S3LogDestinationParameters$BucketOwner' => '<p>Specifies the Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.</p>', ], ], 'S3LogDestinationParametersPrefixString' => [ 'base' => NULL, 'refs' => [ 'S3LogDestinationParameters$Prefix' => '<p>Specifies any prefix text with which to begin Amazon S3 log object names.</p> <p>You can use prefixes to organize the data that you store in Amazon S3 buckets. A prefix is a string of characters at the beginning of the object key name. A prefix can be any length, subject to the maximum length of the object key name (1,024 bytes). For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using prefixes</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', ], ], 'S3OutputFormat' => [ 'base' => NULL, 'refs' => [ 'S3LogDestination$OutputFormat' => '<p>The format EventBridge uses for the log records.</p> <ul> <li> <p> <code>json</code>: JSON </p> </li> <li> <p> <code>plain</code>: Plain text</p> </li> <li> <p> <code>w3c</code>: <a href="https://www.w3.org/TR/WD-logfile">W3C extended logging file format</a> </p> </li> </ul>', 'S3LogDestinationParameters$OutputFormat' => '<p>How EventBridge should format the log records.</p> <ul> <li> <p> <code>json</code>: JSON </p> </li> <li> <p> <code>plain</code>: Plain text</p> </li> <li> <p> <code>w3c</code>: <a href="https://www.w3.org/TR/WD-logfile">W3C extended logging file format</a> </p> </li> </ul>', ], ], 'SageMakerPipelineParameter' => [ 'base' => '<p>Name/Value pair of a parameter to start execution of a SageMaker Model Building Pipeline.</p>', 'refs' => [ 'SageMakerPipelineParameterList$member' => NULL, ], ], 'SageMakerPipelineParameterList' => [ 'base' => NULL, 'refs' => [ 'PipeTargetSageMakerPipelineParameters$PipelineParameterList' => '<p>List of Parameter names and values for SageMaker Model Building Pipeline execution.</p>', ], ], 'SageMakerPipelineParameterName' => [ 'base' => NULL, 'refs' => [ 'SageMakerPipelineParameter$Name' => '<p>Name of parameter to start execution of a SageMaker Model Building Pipeline.</p>', ], ], 'SageMakerPipelineParameterValue' => [ 'base' => NULL, 'refs' => [ 'SageMakerPipelineParameter$Value' => '<p>Value of parameter to start execution of a SageMaker Model Building Pipeline.</p>', ], ], 'SecretManagerArn' => [ 'base' => '<p>// Optional SecretManager ARN which stores the database credentials</p>', 'refs' => [ 'MQBrokerAccessCredentials$BasicAuth' => '<p>The ARN of the Secrets Manager secret.</p>', 'MSKAccessCredentials$SaslScram512Auth' => '<p>The ARN of the Secrets Manager secret.</p>', 'MSKAccessCredentials$ClientCertificateTlsAuth' => '<p>The ARN of the Secrets Manager secret.</p>', 'PipeSourceSelfManagedKafkaParameters$ServerRootCaCertificate' => '<p>The ARN of the Secrets Manager secret used for certification.</p>', 'SelfManagedKafkaAccessConfigurationCredentials$BasicAuth' => '<p>The ARN of the Secrets Manager secret.</p>', 'SelfManagedKafkaAccessConfigurationCredentials$SaslScram512Auth' => '<p>The ARN of the Secrets Manager secret.</p>', 'SelfManagedKafkaAccessConfigurationCredentials$SaslScram256Auth' => '<p>The ARN of the Secrets Manager secret.</p>', 'SelfManagedKafkaAccessConfigurationCredentials$ClientCertificateTlsAuth' => '<p>The ARN of the Secrets Manager secret.</p>', 'UpdatePipeSourceSelfManagedKafkaParameters$ServerRootCaCertificate' => '<p>The ARN of the Secrets Manager secret used for certification.</p>', ], ], 'SecretManagerArnOrJsonPath' => [ 'base' => '<p>// For targets, can either specify an ARN or a jsonpath pointing to the ARN.</p>', 'refs' => [ 'PipeTargetRedshiftDataParameters$SecretManagerArn' => '<p>The name or ARN of the secret that enables access to the database. Required when authenticating using Secrets Manager.</p>', ], ], 'SecurityGroup' => [ 'base' => NULL, 'refs' => [ 'SecurityGroups$member' => NULL, ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIds$member' => NULL, ], ], 'SecurityGroupIds' => [ 'base' => '<p>List of SecurityGroupId.</p>', 'refs' => [ 'SelfManagedKafkaAccessConfigurationVpc$SecurityGroup' => '<p>Specifies the security groups associated with the stream. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.</p>', ], ], 'SecurityGroups' => [ 'base' => NULL, 'refs' => [ 'AwsVpcConfiguration$SecurityGroups' => '<p>Specifies the security groups associated with the task. These security groups must all be in the same VPC. You can specify as many as five security groups. If you do not specify a security group, the default security group for the VPC is used.</p>', ], ], 'SelfManagedKafkaAccessConfigurationCredentials' => [ 'base' => '<p>The Secrets Manager secret that stores your stream credentials.</p>', 'refs' => [ 'PipeSourceSelfManagedKafkaParameters$Credentials' => '<p>The credentials needed to access the resource.</p>', 'UpdatePipeSourceSelfManagedKafkaParameters$Credentials' => '<p>The credentials needed to access the resource.</p>', ], ], 'SelfManagedKafkaAccessConfigurationVpc' => [ 'base' => '<p>This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used.</p>', 'refs' => [ 'PipeSourceSelfManagedKafkaParameters$Vpc' => '<p>This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used.</p>', 'UpdatePipeSourceSelfManagedKafkaParameters$Vpc' => '<p>This structure specifies the VPC subnets and security groups for the stream, and whether a public IP address is to be used.</p>', ], ], 'SelfManagedKafkaStartPosition' => [ 'base' => NULL, 'refs' => [ 'PipeSourceSelfManagedKafkaParameters$StartingPosition' => '<p>(Streams only) The position in a stream from which to start reading.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>A quota has been exceeded.</p>', 'refs' => [], ], 'SingleMeasureMapping' => [ 'base' => '<p>Maps a single source data field to a single record in the specified Timestream for LiveAnalytics table.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html">Amazon Timestream for LiveAnalytics concepts</a> </p>', 'refs' => [ 'SingleMeasureMappings$member' => NULL, ], ], 'SingleMeasureMappings' => [ 'base' => NULL, 'refs' => [ 'PipeTargetTimestreamParameters$SingleMeasureMappings' => '<p>Mappings of single source data fields to individual records in the specified Timestream for LiveAnalytics table.</p>', ], ], 'Sql' => [ 'base' => '<p>// A single Redshift SQL</p>', 'refs' => [ 'Sqls$member' => NULL, ], ], 'Sqls' => [ 'base' => '<p>// A list of SQLs.</p>', 'refs' => [ 'PipeTargetRedshiftDataParameters$Sqls' => '<p>The SQL statement text to run.</p>', ], ], 'StartPipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartPipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'StatementName' => [ 'base' => '<p>// A name for Redshift DataAPI statement which can be used as filter of // ListStatement.</p>', 'refs' => [ 'PipeTargetRedshiftDataParameters$StatementName' => '<p>The name of the SQL statement. You can name the SQL statement when you create it to identify the query.</p>', ], ], 'StopPipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'StopPipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'BatchContainerOverrides$InstanceType' => '<p>The instance type to use for a multi-node parallel job.</p> <note> <p>This parameter isn\'t applicable to single-node container jobs or jobs that run on Fargate resources, and shouldn\'t be provided.</p> </note>', 'BatchEnvironmentVariable$Name' => '<p>The name of the key-value pair. For environment variables, this is the name of the environment variable.</p>', 'BatchEnvironmentVariable$Value' => '<p>The value of the key-value pair. For environment variables, this is the value of the environment variable.</p>', 'BatchJobDependency$JobId' => '<p>The job ID of the Batch job that\'s associated with this dependency.</p>', 'BatchParametersMap$key' => NULL, 'BatchParametersMap$value' => NULL, 'BatchResourceRequirement$Value' => '<p>The quantity of the specified resource to reserve for the container. The values vary based on the <code>type</code> specified.</p> <dl> <dt>type="GPU"</dt> <dd> <p>The number of physical GPUs to reserve for the container. Make sure that the number of GPUs reserved for all containers in a job doesn\'t exceed the number of available GPUs on the compute resource that the job is launched on.</p> <note> <p>GPUs aren\'t available for jobs that are running on Fargate resources.</p> </note> </dd> <dt>type="MEMORY"</dt> <dd> <p>The memory hard limit (in MiB) present to the container. This parameter is supported for jobs that are running on EC2 resources. If your container attempts to exceed the memory specified, the container is terminated. This parameter maps to <code>Memory</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container"> Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. You must specify at least 4 MiB of memory for a job. This is required but can be specified in several places for multi-node parallel (MNP) jobs. It must be specified for each node at least once. This parameter maps to <code>Memory</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container"> Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--memory</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>.</p> <note> <p>If you\'re trying to maximize your resource utilization by providing your jobs as much memory as possible for a particular instance type, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html">Memory management</a> in the <i>Batch User Guide</i>.</p> </note> <p>For jobs that are running on Fargate resources, then <code>value</code> is the hard limit (in MiB), and must match one of the supported values and the <code>VCPU</code> values must be one of the values supported for that memory value.</p> <dl> <dt>value = 512</dt> <dd> <p> <code>VCPU</code> = 0.25</p> </dd> <dt>value = 1024</dt> <dd> <p> <code>VCPU</code> = 0.25 or 0.5</p> </dd> <dt>value = 2048</dt> <dd> <p> <code>VCPU</code> = 0.25, 0.5, or 1</p> </dd> <dt>value = 3072</dt> <dd> <p> <code>VCPU</code> = 0.5, or 1</p> </dd> <dt>value = 4096</dt> <dd> <p> <code>VCPU</code> = 0.5, 1, or 2</p> </dd> <dt>value = 5120, 6144, or 7168</dt> <dd> <p> <code>VCPU</code> = 1 or 2</p> </dd> <dt>value = 8192</dt> <dd> <p> <code>VCPU</code> = 1, 2, 4, or 8</p> </dd> <dt>value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360</dt> <dd> <p> <code>VCPU</code> = 2 or 4</p> </dd> <dt>value = 16384</dt> <dd> <p> <code>VCPU</code> = 2, 4, or 8</p> </dd> <dt>value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696, or 30720</dt> <dd> <p> <code>VCPU</code> = 4</p> </dd> <dt>value = 20480, 24576, or 28672</dt> <dd> <p> <code>VCPU</code> = 4 or 8</p> </dd> <dt>value = 36864, 45056, 53248, or 61440</dt> <dd> <p> <code>VCPU</code> = 8</p> </dd> <dt>value = 32768, 40960, 49152, or 57344</dt> <dd> <p> <code>VCPU</code> = 8 or 16</p> </dd> <dt>value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880</dt> <dd> <p> <code>VCPU</code> = 16</p> </dd> </dl> </dd> <dt>type="VCPU"</dt> <dd> <p>The number of vCPUs reserved for the container. This parameter maps to <code>CpuShares</code> in the <a href="https://docs.docker.com/engine/api/v1.23/#create-a-container"> Create a container</a> section of the <a href="https://docs.docker.com/engine/api/v1.23/">Docker Remote API</a> and the <code>--cpu-shares</code> option to <a href="https://docs.docker.com/engine/reference/run/">docker run</a>. Each vCPU is equivalent to 1,024 CPU shares. For EC2 resources, you must specify at least one vCPU. This is required but can be specified in several places; it must be specified for each node at least once.</p> <p>The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs. For more information about Fargate quotas, see <a href="https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate">Fargate quotas</a> in the <i>Amazon Web Services General Reference</i>.</p> <p>For jobs that are running on Fargate resources, then <code>value</code> must match one of the supported values and the <code>MEMORY</code> values must be one of the values supported for that <code>VCPU</code> value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and 16</p> <dl> <dt>value = 0.25</dt> <dd> <p> <code>MEMORY</code> = 512, 1024, or 2048</p> </dd> <dt>value = 0.5</dt> <dd> <p> <code>MEMORY</code> = 1024, 2048, 3072, or 4096</p> </dd> <dt>value = 1</dt> <dd> <p> <code>MEMORY</code> = 2048, 3072, 4096, 5120, 6144, 7168, or 8192</p> </dd> <dt>value = 2</dt> <dd> <p> <code>MEMORY</code> = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, or 16384</p> </dd> <dt>value = 4</dt> <dd> <p> <code>MEMORY</code> = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408, 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672, 29696, or 30720</p> </dd> <dt>value = 8</dt> <dd> <p> <code>MEMORY</code> = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248, 57344, or 61440 </p> </dd> <dt>value = 16</dt> <dd> <p> <code>MEMORY</code> = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880 </p> </dd> </dl> </dd> </dl>', 'ConflictException$message' => NULL, 'ConflictException$resourceId' => '<p>The ID of the resource that caused the exception.</p>', 'ConflictException$resourceType' => '<p>The type of resource that caused the exception.</p>', 'EcsContainerOverride$Name' => '<p>The name of the container that receives the override. This parameter is required if any override is specified.</p>', 'EcsEnvironmentFile$value' => '<p>The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment variable file.</p>', 'EcsEnvironmentVariable$name' => '<p>The name of the key-value pair. For environment variables, this is the name of the environment variable.</p>', 'EcsEnvironmentVariable$value' => '<p>The value of the key-value pair. For environment variables, this is the value of the environment variable.</p>', 'EcsInferenceAcceleratorOverride$deviceName' => '<p>The Elastic Inference accelerator device name to override for the task. This parameter must match a <code>deviceName</code> specified in the task definition.</p>', 'EcsInferenceAcceleratorOverride$deviceType' => '<p>The Elastic Inference accelerator type to use.</p>', 'EcsResourceRequirement$value' => '<p>The value for the specified resource type.</p> <p>If the <code>GPU</code> type is used, the value is the number of physical <code>GPUs</code> the Amazon ECS container agent reserves for the container. The number of GPUs that\'s reserved for all containers in a task can\'t exceed the number of available GPUs on the container instance that the task is launched on.</p> <p>If the <code>InferenceAccelerator</code> type is used, the <code>value</code> matches the <code>deviceName</code> for an InferenceAccelerator specified in a task definition.</p>', 'EcsTaskOverride$Cpu' => '<p>The cpu override for the task.</p>', 'EcsTaskOverride$Memory' => '<p>The memory override for the task.</p>', 'InternalException$message' => NULL, 'PipeTargetBatchJobParameters$JobDefinition' => '<p>The job definition used by this job. This value can be one of <code>name</code>, <code>name:revision</code>, or the Amazon Resource Name (ARN) for the job definition. If name is specified without a revision then the latest active revision is used.</p>', 'PipeTargetBatchJobParameters$JobName' => '<p>The name of the job. It can be up to 128 letters long. The first character must be alphanumeric, can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).</p>', 'PipeTargetEcsTaskParameters$PlatformVersion' => '<p>Specifies the platform version for the task. Specify only the numeric portion of the platform version, such as <code>1.1.0</code>.</p> <p>This structure is used only if <code>LaunchType</code> is <code>FARGATE</code>. For more information about valid platform versions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">Fargate Platform Versions</a> in the <i>Amazon Elastic Container Service Developer Guide</i>.</p>', 'PipeTargetEcsTaskParameters$Group' => '<p>Specifies an Amazon ECS task group for the task. The maximum length is 255 characters.</p>', 'S3LogDestination$BucketName' => '<p>The name of the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.</p>', 'S3LogDestination$Prefix' => '<p>The prefix text with which to begin Amazon S3 log object names.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html">Organizing objects using prefixes</a> in the <i>Amazon Simple Storage Service User Guide</i>.</p>', 'S3LogDestination$BucketOwner' => '<p>The Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge delivers the log records for the pipe.</p>', 'ServiceQuotaExceededException$message' => NULL, 'ServiceQuotaExceededException$resourceId' => '<p>The ID of the resource that caused the exception.</p>', 'ServiceQuotaExceededException$resourceType' => '<p>The type of resource that caused the exception.</p>', 'ServiceQuotaExceededException$serviceCode' => '<p>The identifier of the service that caused the exception.</p>', 'ServiceQuotaExceededException$quotaCode' => '<p>The identifier of the quota that caused the exception.</p>', 'StringList$member' => NULL, 'ThrottlingException$message' => NULL, 'ThrottlingException$serviceCode' => '<p>The identifier of the service that caused the exception.</p>', 'ThrottlingException$quotaCode' => '<p>The identifier of the quota that caused the exception.</p>', 'ValidationExceptionField$name' => '<p>The name of the exception.</p>', ], ], 'StringList' => [ 'base' => NULL, 'refs' => [ 'BatchContainerOverrides$Command' => '<p>The command to send to the container that overrides the default command from the Docker image or the task definition.</p>', 'EcsContainerOverride$Command' => '<p>The command to send to the container that overrides the default command from the Docker image or the task definition. You must also specify a container name.</p>', ], ], 'Subnet' => [ 'base' => NULL, 'refs' => [ 'Subnets$member' => NULL, ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIds$member' => NULL, ], ], 'SubnetIds' => [ 'base' => '<p>List of SubnetId.</p>', 'refs' => [ 'SelfManagedKafkaAccessConfigurationVpc$Subnets' => '<p>Specifies the subnets associated with the stream. These subnets must all be in the same VPC. You can specify as many as 16 subnets.</p>', ], ], 'Subnets' => [ 'base' => NULL, 'refs' => [ 'AwsVpcConfiguration$Subnets' => '<p>Specifies the subnets associated with the task. These subnets must all be in the same VPC. You can specify as many as 16 subnets.</p>', ], ], 'Tag' => [ 'base' => '<p>A key-value pair associated with an Amazon Web Services resource. In EventBridge, rules and event buses support tagging.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>A string you can use to assign a value. The combination of tag keys and values can help you organize and categorize your resources.</p>', 'TagKeyList$member' => NULL, 'TagMap$key' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The list of tag keys to remove from the pipe.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'PipeTargetEcsTaskParameters$Tags' => '<p>The metadata that you apply to the task to help you categorize and organize them. Each tag consists of a key and an optional value, both of which you define. To learn more, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags">RunTask</a> in the Amazon ECS API Reference.</p>', ], ], 'TagMap' => [ 'base' => NULL, 'refs' => [ 'CreatePipeRequest$Tags' => '<p>The list of key-value pairs to associate with the pipe.</p>', 'DescribePipeResponse$Tags' => '<p>The list of key-value pairs to associate with the pipe.</p>', 'ListTagsForResourceResponse$tags' => '<p>The list of key-value pairs to associate with the pipe.</p>', 'TagResourceRequest$tags' => '<p>The list of key-value pairs associated with the pipe.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The value for the specified tag key.</p>', 'TagMap$value' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>An action was throttled.</p>', 'refs' => [], ], 'TimeFieldType' => [ 'base' => NULL, 'refs' => [ 'PipeTargetTimestreamParameters$TimeFieldType' => '<p>The type of time value used.</p> <p>The default is <code>EPOCH</code>.</p>', ], ], 'TimeValue' => [ 'base' => NULL, 'refs' => [ 'PipeTargetTimestreamParameters$TimeValue' => '<p>Dynamic path to the source data field that represents the time value for your data.</p>', ], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreatePipeResponse$CreationTime' => '<p>The time the pipe was created.</p>', 'CreatePipeResponse$LastModifiedTime' => '<p>When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'DeletePipeResponse$CreationTime' => '<p>The time the pipe was created.</p>', 'DeletePipeResponse$LastModifiedTime' => '<p>When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'DescribePipeResponse$CreationTime' => '<p>The time the pipe was created.</p>', 'DescribePipeResponse$LastModifiedTime' => '<p>When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'Pipe$CreationTime' => '<p>The time the pipe was created.</p>', 'Pipe$LastModifiedTime' => '<p>When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'PipeSourceKinesisStreamParameters$StartingPositionTimestamp' => '<p>With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code>, the time from which to start reading, in Unix time seconds.</p>', 'StartPipeResponse$CreationTime' => '<p>The time the pipe was created.</p>', 'StartPipeResponse$LastModifiedTime' => '<p>When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'StopPipeResponse$CreationTime' => '<p>The time the pipe was created.</p>', 'StopPipeResponse$LastModifiedTime' => '<p>When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', 'UpdatePipeResponse$CreationTime' => '<p>The time the pipe was created.</p>', 'UpdatePipeResponse$LastModifiedTime' => '<p>When the pipe was last updated, in <a href="https://www.w3.org/TR/NOTE-datetime">ISO-8601 format</a> (YYYY-MM-DDThh:mm:ss.sTZD).</p>', ], ], 'TimestampFormat' => [ 'base' => NULL, 'refs' => [ 'PipeTargetTimestreamParameters$TimestampFormat' => '<p>How to format the timestamps. For example, <code>YYYY-MM-DDThh:mm:ss.sssTZD</code>.</p> <p>Required if <code>TimeFieldType</code> is specified as <code>TIMESTAMP_FORMAT</code>.</p>', ], ], 'URI' => [ 'base' => NULL, 'refs' => [ 'PipeSourceManagedStreamingKafkaParameters$ConsumerGroupID' => '<p>The name of the destination queue to consume.</p>', 'PipeSourceRabbitMQBrokerParameters$VirtualHost' => '<p>The name of the virtual host associated with the source broker.</p>', 'PipeSourceSelfManagedKafkaParameters$ConsumerGroupID' => '<p>The name of the destination queue to consume.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePipeRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePipeResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdatePipeSourceActiveMQBrokerParameters' => [ 'base' => '<p>The parameters for using an Active MQ broker as a source.</p>', 'refs' => [ 'UpdatePipeSourceParameters$ActiveMQBrokerParameters' => '<p>The parameters for using an Active MQ broker as a source.</p>', ], ], 'UpdatePipeSourceDynamoDBStreamParameters' => [ 'base' => '<p>The parameters for using a DynamoDB stream as a source.</p>', 'refs' => [ 'UpdatePipeSourceParameters$DynamoDBStreamParameters' => '<p>The parameters for using a DynamoDB stream as a source.</p>', ], ], 'UpdatePipeSourceKinesisStreamParameters' => [ 'base' => '<p>The parameters for using a Kinesis stream as a source.</p>', 'refs' => [ 'UpdatePipeSourceParameters$KinesisStreamParameters' => '<p>The parameters for using a Kinesis stream as a source.</p>', ], ], 'UpdatePipeSourceManagedStreamingKafkaParameters' => [ 'base' => '<p>The parameters for using an MSK stream as a source.</p>', 'refs' => [ 'UpdatePipeSourceParameters$ManagedStreamingKafkaParameters' => '<p>The parameters for using an MSK stream as a source.</p>', ], ], 'UpdatePipeSourceParameters' => [ 'base' => '<p>The parameters required to set up a source for your pipe.</p>', 'refs' => [ 'UpdatePipeRequest$SourceParameters' => '<p>The parameters required to set up a source for your pipe.</p>', ], ], 'UpdatePipeSourceRabbitMQBrokerParameters' => [ 'base' => '<p>The parameters for using a Rabbit MQ broker as a source.</p>', 'refs' => [ 'UpdatePipeSourceParameters$RabbitMQBrokerParameters' => '<p>The parameters for using a Rabbit MQ broker as a source.</p>', ], ], 'UpdatePipeSourceSelfManagedKafkaParameters' => [ 'base' => '<p>The parameters for using a self-managed Apache Kafka stream as a source.</p> <p>A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services. This includes both clusters you manage yourself, as well as those hosted by a third-party provider, such as <a href="https://www.confluent.io/">Confluent Cloud</a>, <a href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a href="https://redpanda.com/">Redpanda</a>. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka streams as a source</a> in the <i>Amazon EventBridge User Guide</i>.</p>', 'refs' => [ 'UpdatePipeSourceParameters$SelfManagedKafkaParameters' => '<p>The parameters for using a self-managed Apache Kafka stream as a source.</p> <p>A <i>self managed</i> cluster refers to any Apache Kafka cluster not hosted by Amazon Web Services. This includes both clusters you manage yourself, as well as those hosted by a third-party provider, such as <a href="https://www.confluent.io/">Confluent Cloud</a>, <a href="https://www.cloudkarafka.com/">CloudKarafka</a>, or <a href="https://redpanda.com/">Redpanda</a>. For more information, see <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html">Apache Kafka streams as a source</a> in the <i>Amazon EventBridge User Guide</i>.</p>', ], ], 'UpdatePipeSourceSqsQueueParameters' => [ 'base' => '<p>The parameters for using a Amazon SQS stream as a source.</p>', 'refs' => [ 'UpdatePipeSourceParameters$SqsQueueParameters' => '<p>The parameters for using a Amazon SQS stream as a source.</p>', ], ], 'ValidationException' => [ 'base' => '<p>Indicates that an error has occurred while performing a validate operation.</p>', 'refs' => [], ], 'ValidationExceptionField' => [ 'base' => '<p>Indicates that an error has occurred while performing a validate operation.</p>', 'refs' => [ 'ValidationExceptionFieldList$member' => NULL, ], ], 'ValidationExceptionFieldList' => [ 'base' => NULL, 'refs' => [ 'ValidationException$fieldList' => '<p>The list of fields for which validation failed and the corresponding failure messages.</p>', ], ], 'VersionValue' => [ 'base' => NULL, 'refs' => [ 'PipeTargetTimestreamParameters$VersionValue' => '<p>64 bit version value or source data field that represents the version value for your data.</p> <p>Write requests with a higher version number will update the existing measure values of the record and version. In cases where the measure value is the same, the version will still be updated. </p> <p>Default value is 1. </p> <p>Timestream for LiveAnalytics does not support updating partial measure values in a record.</p> <p>Write requests for duplicate data with a higher version number will update the existing measure value and version. In cases where the measure value is the same, <code>Version</code> will still be updated. Default value is <code>1</code>.</p> <note> <p> <code>Version</code> must be <code>1</code> or greater, or you will receive a <code>ValidationException</code> error.</p> </note>', ], ], ],];
