<?php
// This file was auto-generated from sdk-root/src/data/rds/2014-10-31/examples-1.json
return [ 'version' => '1.0', 'examples' => [ 'AddRoleToDBCluster' => [ [ 'input' => [ 'DBClusterIdentifier' => 'mydbcluster', 'RoleArn' => 'arn:aws:iam::123456789012:role/RDSLoadFromS3', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example associates a role with a DB cluster.', 'id' => 'to-associate-an-aws-identity-and-access-management-iam-role-with-a-db-cluster-1679691203006', 'title' => 'To associate an AWS Identity and Access Management (IAM) role with a DB cluster', ], ], 'AddRoleToDBInstance' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'test-instance', 'FeatureName' => 'S3_INTEGRATION', 'RoleArn' => 'arn:aws:iam::111122223333:role/rds-s3-integration-role', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example adds the role to a DB instance named test-instance.', 'id' => 'to-associate-an-aws-identity-and-access-management-iam-role-with-a-db-instance-1679691512295', 'title' => 'To associate an AWS Identity and Access Management (IAM) role with a DB instance', ], ], 'AddSourceIdentifierToSubscription' => [ [ 'input' => [ 'SourceIdentifier' => 'test-instance-repl', 'SubscriptionName' => 'my-instance-events', ], 'output' => [ 'EventSubscription' => [ 'CustSubscriptionId' => 'my-instance-events', 'CustomerAwsId' => '123456789012', 'Enabled' => false, 'EventCategoriesList' => [ 'backup', 'recovery', ], 'EventSubscriptionArn' => 'arn:aws:rds:us-east-1:123456789012:es:my-instance-events', 'SnsTopicArn' => 'arn:aws:sns:us-east-1:123456789012:interesting-events', 'SourceIdsList' => [ 'test-instance', 'test-instance-repl', ], 'SourceType' => 'db-instance', 'Status' => 'modifying', 'SubscriptionCreationTime' => 'Tue Jul 31 23:22:01 UTC 2018', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example adds another source identifier to an existing subscription.', 'id' => 'to-add-a-source-identifier-to-a-subscription-1679691771786', 'title' => 'To add a source identifier to a subscription', ], ], 'AddTagsToResource' => [ [ 'input' => [ 'ResourceName' => 'arn:aws:rds:us-east-1:992648334831:og:mymysqloptiongroup', 'Tags' => [ [ 'Key' => 'Staging', 'Value' => 'LocationDB', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'This example adds a tag to an option group.', 'id' => 'add-tags-to-resource-fa99ef50-228b-449d-b893-ca4d4e9768ab', 'title' => 'To add tags to a resource', ], ], 'ApplyPendingMaintenanceAction' => [ [ 'input' => [ 'ApplyAction' => 'system-update', 'OptInType' => 'immediate', 'ResourceIdentifier' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-db-cluster', ], 'output' => [ 'ResourcePendingMaintenanceActions' => [ 'PendingMaintenanceActionDetails' => [ [ 'Action' => 'system-update', 'CurrentApplyDate' => '2021-01-23T01:07:36.100Z', 'Description' => 'Upgrade to Aurora PostgreSQL 3.3.2', 'OptInStatus' => 'immediate', ], ], 'ResourceIdentifier' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-db-cluster', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example applies the pending maintenance actions for a DB cluster.', 'id' => 'to-apply-pending-maintenance-actions-1679692228896', 'title' => 'To apply pending maintenance actions', ], ], 'AuthorizeDBSecurityGroupIngress' => [ [ 'input' => [ 'CIDRIP' => '203.0.113.5/32', 'DBSecurityGroupName' => 'mydbsecuritygroup', ], 'output' => [ 'DBSecurityGroup' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'This example authorizes access to the specified security group by the specified CIDR block.', 'id' => 'authorize-db-security-group-ingress-ebf9ab91-8912-4b07-a32e-ca150668164f', 'title' => 'To authorize DB security group integress', ], ], 'CancelExportTask' => [ [ 'input' => [ 'ExportTaskIdentifier' => 'my-s3-export-1', ], 'output' => [ 'ExportTaskIdentifier' => 'my-s3-export-1', 'IamRoleArn' => 'arn:aws:iam::123456789012:role/service-role/export-snap-S3-role', 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/abcd0000-7bfd-4594-af38-aabbccddeeff', 'PercentProgress' => 0, 'S3Bucket' => 'mybucket', 'S3Prefix' => '', 'SnapshotTime' => '2019-03-24T20:01:09.815Z', 'SourceArn' => 'arn:aws:rds:us-east-1:123456789012:snapshot:publisher-final-snapshot', 'Status' => 'CANCELING', 'TotalExtractedDataInGB' => 0, ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example cancels an export task in progress that is exporting a snapshot to Amazon S3.', 'id' => 'to-cancel-a-snapshot-export-to-amazon-s3-1679694286587', 'title' => 'To cancel a snapshot export to Amazon S3', ], ], 'CopyDBClusterParameterGroup' => [ [ 'input' => [ 'SourceDBClusterParameterGroupIdentifier' => 'mydbclusterparametergroup', 'TargetDBClusterParameterGroupDescription' => 'My DB cluster parameter group copy', 'TargetDBClusterParameterGroupIdentifier' => 'mydbclusterparametergroup-copy', ], 'output' => [ 'DBClusterParameterGroup' => [ 'DBClusterParameterGroupArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-pg:mydbclusterparametergroup-copy', 'DBClusterParameterGroupName' => 'mydbclusterparametergroup-copy', 'DBParameterGroupFamily' => 'aurora-mysql5.7', 'Description' => 'My DB cluster parameter group copy', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'This example copies a DB cluster parameter group.', 'id' => 'copy-db-cluster-parameter-group-6fefaffe-cde9-4dba-9f0b-d3f593572fe4', 'title' => 'To copy a DB cluster parameter group', ], ], 'CopyDBClusterSnapshot' => [ [ 'input' => [ 'CopyTags' => true, 'SourceDBClusterSnapshotIdentifier' => 'arn:aws:rds:us-east-1:123456789012:cluster-snapshot:rds:myaurora-2019-06-04-09-16', 'TargetDBClusterSnapshotIdentifier' => 'myclustersnapshotcopy', ], 'output' => [ 'DBClusterSnapshot' => [ 'AllocatedStorage' => 0, 'AvailabilityZones' => [ 'us-east-1a', 'us-east-1b', 'us-east-1e', ], 'ClusterCreateTime' => '2019-04-15T14:18:42.785Z', 'DBClusterIdentifier' => 'myaurora', 'DBClusterSnapshotArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-snapshot:myclustersnapshotcopy', 'DBClusterSnapshotIdentifier' => 'myclustersnapshotcopy', 'Engine' => 'aurora-mysql', 'EngineVersion' => '5.7.mysql_aurora.2.04.2', 'IAMDatabaseAuthenticationEnabled' => false, 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE', 'LicenseModel' => 'aurora-mysql', 'MasterUsername' => 'myadmin', 'PercentProgress' => 100, 'Port' => 0, 'SnapshotCreateTime' => '2019-06-04T09:16:42.649Z', 'SnapshotType' => 'manual', 'Status' => 'available', 'StorageEncrypted' => true, 'VpcId' => 'vpc-123example', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a copy of a DB cluster snapshot, including its tags.', 'id' => 'to-copy-a-db-cluster-snapshot-1679695109979', 'title' => 'To copy a DB cluster snapshot', ], ], 'CopyDBParameterGroup' => [ [ 'input' => [ 'SourceDBParameterGroupIdentifier' => 'mydbpg', 'TargetDBParameterGroupDescription' => 'Copy of mydbpg parameter group', 'TargetDBParameterGroupIdentifier' => 'mydbpgcopy', ], 'output' => [ 'DBParameterGroup' => [ 'DBParameterGroupArn' => 'arn:aws:rds:us-east-1:814387698303:pg:mydbpgcopy', 'DBParameterGroupFamily' => 'mysql5.7', 'DBParameterGroupName' => 'mydbpgcopy', 'Description' => 'Copy of mydbpg parameter group', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example makes a copy of a DB parameter group.', 'id' => 'to-copy-a-db-parameter-group-1679695426993', 'title' => 'To copy a DB parameter group', ], ], 'CopyDBSnapshot' => [ [ 'input' => [ 'SourceDBSnapshotIdentifier' => 'rds:database-mysql-2019-06-06-08-38', 'TargetDBSnapshotIdentifier' => 'mydbsnapshotcopy', ], 'output' => [ 'DBSnapshot' => [ 'AllocatedStorage' => 100, 'AvailabilityZone' => 'us-east-1f', 'DBInstanceIdentifier' => 'database-mysql', 'DBSnapshotArn' => 'arn:aws:rds:us-east-1:123456789012:snapshot:mydbsnapshotcopy', 'DBSnapshotIdentifier' => 'mydbsnapshotcopy', 'DbiResourceId' => 'db-ZI7UJ5BLKMBYFGX7FDENCKADC4', 'Encrypted' => true, 'Engine' => 'mysql', 'EngineVersion' => '5.6.40', 'IAMDatabaseAuthenticationEnabled' => false, 'InstanceCreateTime' => '2019-04-30T15:45:53.663Z', 'Iops' => 1000, 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE', 'LicenseModel' => 'general-public-license', 'MasterUsername' => 'admin', 'OptionGroupName' => 'default:mysql-5-6', 'PercentProgress' => 0, 'Port' => 3306, 'ProcessorFeatures' => [], 'SnapshotType' => 'manual', 'SourceDBSnapshotIdentifier' => 'arn:aws:rds:us-east-1:123456789012:snapshot:rds:database-mysql-2019-06-06-08-38', 'SourceRegion' => 'us-east-1', 'Status' => 'creating', 'StorageType' => 'io1', 'VpcId' => 'vpc-6594f31c', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a copy of a DB snapshot.', 'id' => 'to-copy-a-db-snapshot-1679695661487', 'title' => 'To copy a DB snapshot', ], ], 'CopyOptionGroup' => [ [ 'input' => [ 'SourceOptionGroupIdentifier' => 'myoptiongroup', 'TargetOptionGroupDescription' => 'My option group copy', 'TargetOptionGroupIdentifier' => 'new-option-group', ], 'output' => [ 'OptionGroup' => [ 'AllowsVpcAndNonVpcInstanceMemberships' => true, 'EngineName' => 'oracle-ee', 'MajorEngineVersion' => '11.2', 'OptionGroupArn' => 'arn:aws:rds:us-east-1:123456789012:og:new-option-group', 'OptionGroupDescription' => 'My option group copy', 'OptionGroupName' => 'new-option-group', 'Options' => [], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example makes a copy of an option group.', 'id' => 'to-copy-an-option-group-1679695800102', 'title' => 'To copy an option group', ], ], 'CreateBlueGreenDeployment' => [ [ 'input' => [ 'BlueGreenDeploymentName' => 'bgd-test-instance', 'Source' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance', 'TargetDBParameterGroupName' => 'mysql-80-group', 'TargetEngineVersion' => '8.0', ], 'output' => [ 'BlueGreenDeployment' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-v53303651eexfake', 'BlueGreenDeploymentName' => 'bgd-cli-test-instance', 'CreateTime' => '2022-02-25T21:18:51.183000+00:00', 'Source' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance', 'Status' => 'PROVISIONING', 'SwitchoverDetails' => [ [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-1', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-2', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-3', ], ], 'Tasks' => [ [ 'Name' => 'CREATING_READ_REPLICA_OF_SOURCE', 'Status' => 'PENDING', ], [ 'Name' => 'DB_ENGINE_VERSION_UPGRADE', 'Status' => 'PENDING', ], [ 'Name' => 'CONFIGURE_BACKUPS', 'Status' => 'PENDING', ], [ 'Name' => 'CREATING_TOPOLOGY_OF_SOURCE', 'Status' => 'PENDING', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a blue/green deployment for a MySQL DB instance.', 'id' => 'to-create-a-bluegreen-deployment-for-an-rds-for-mysql-db-instance-1679688377231', 'title' => 'To create a blue/green deployment for an RDS for MySQL DB instance', ], [ 'input' => [ 'BlueGreenDeploymentName' => 'my-blue-green-deployment', 'Source' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster', 'TargetDBClusterParameterGroupName' => 'mysql-80-cluster-group', 'TargetDBParameterGroupName' => 'ams-80-binlog-enabled', 'TargetEngineVersion' => '8.0', ], 'output' => [ 'BlueGreenDeployment' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-wi89nwzglccsfake', 'BlueGreenDeploymentName' => 'my-blue-green-deployment', 'CreateTime' => '2022-02-25T21:12:00.288000+00:00', 'Source' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster', 'Status' => 'PROVISIONING', 'SwitchoverDetails' => [ [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster', 'Status' => 'PROVISIONING', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1', 'Status' => 'PROVISIONING', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2', 'Status' => 'PROVISIONING', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3', 'Status' => 'PROVISIONING', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint', 'Status' => 'PROVISIONING', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint', 'Status' => 'PROVISIONING', ], ], 'Tasks' => [ [ 'Name' => 'CREATING_READ_REPLICA_OF_SOURCE', 'Status' => 'PENDING', ], [ 'Name' => 'DB_ENGINE_VERSION_UPGRADE', 'Status' => 'PENDING', ], [ 'Name' => 'CREATE_DB_INSTANCES_FOR_CLUSTER', 'Status' => 'PENDING', ], [ 'Name' => 'CREATE_CUSTOM_ENDPOINTS', 'Status' => 'PENDING', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a blue/green deployment for an Aurora MySQL DB cluster.', 'id' => 'to-create-a-bluegreen-deployment-for-an-aurora-mysql-db-cluster-1679703605487', 'title' => 'To create a blue/green deployment for an Aurora MySQL DB cluster', ], ], 'CreateDBCluster' => [ [ 'input' => [ 'DBClusterIdentifier' => 'sample-cluster', 'DBSubnetGroupName' => 'default', 'Engine' => 'aurora-mysql', 'EngineVersion' => '5.7.12', 'MasterUserPassword' => 'mypassword', 'MasterUsername' => 'admin', 'VpcSecurityGroupIds' => [ 'sg-0b91305example', ], ], 'output' => [ 'DBCluster' => [ 'AllocatedStorage' => 1, 'AssociatedRoles' => [], 'AvailabilityZones' => [ 'us-east-1a', 'us-east-1b', 'us-east-1e', ], 'BackupRetentionPeriod' => 1, 'ClusterCreateTime' => '2019-06-07T23:21:33.048Z', 'CopyTagsToSnapshot' => false, 'DBClusterArn' => 'arn:aws:rds:us-east-1:123456789012:cluster:sample-cluster', 'DBClusterIdentifier' => 'sample-cluster', 'DBClusterMembers' => [], 'DBClusterParameterGroup' => 'default.aurora-mysql5.7', 'DBSubnetGroup' => 'default', 'DbClusterResourceId' => 'cluster-ANPAJ4AE5446DAEXAMPLE', 'DeletionProtection' => false, 'Endpoint' => 'sample-cluster.cluster-cnpexample.us-east-1.rds.amazonaws.com', 'Engine' => 'aurora-mysql', 'EngineMode' => 'provisioned', 'EngineVersion' => '5.7.12', 'HostedZoneId' => 'Z2R2ITUGPM61AM', 'HttpEndpointEnabled' => false, 'IAMDatabaseAuthenticationEnabled' => false, 'MasterUsername' => 'master', 'MultiAZ' => false, 'Port' => 3306, 'PreferredBackupWindow' => '09:12-09:42', 'PreferredMaintenanceWindow' => 'mon:04:31-mon:05:01', 'ReadReplicaIdentifiers' => [], 'ReaderEndpoint' => 'sample-cluster.cluster-ro-cnpexample.us-east-1.rds.amazonaws.com', 'Status' => 'creating', 'StorageEncrypted' => false, 'VpcSecurityGroups' => [ [ 'Status' => 'active', 'VpcSecurityGroupId' => 'sg-0b91305example', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a MySQL 5.7-compatible Aurora DB cluster.', 'id' => 'to-create-a-mysql-57-compatible-db-cluster-1679699416154', 'title' => 'To create a MySQL 5.7-compatible DB cluster', ], [ 'input' => [ 'DBClusterIdentifier' => 'sample-pg-cluster', 'DBSubnetGroupName' => 'default', 'Engine' => 'aurora-postgresql', 'MasterUserPassword' => 'mypassword', 'MasterUsername' => 'admin', 'VpcSecurityGroupIds' => [ 'sg-0b91305example', ], ], 'output' => [ 'DBCluster' => [ 'AllocatedStorage' => 1, 'AssociatedRoles' => [], 'AvailabilityZones' => [ 'us-east-1a', 'us-east-1b', 'us-east-1c', ], 'BackupRetentionPeriod' => 1, 'ClusterCreateTime' => '2019-06-07T23:26:08.371Z', 'CopyTagsToSnapshot' => false, 'DBClusterArn' => 'arn:aws:rds:us-east-1:123456789012:cluster:sample-pg-cluster', 'DBClusterIdentifier' => 'sample-pg-cluster', 'DBClusterMembers' => [], 'DBClusterParameterGroup' => 'default.aurora-postgresql9.6', 'DBSubnetGroup' => 'default', 'DbClusterResourceId' => 'cluster-ANPAJ4AE5446DAEXAMPLE', 'DeletionProtection' => false, 'Endpoint' => 'sample-pg-cluster.cluster-cnpexample.us-east-1.rds.amazonaws.com', 'Engine' => 'aurora-postgresql', 'EngineMode' => 'provisioned', 'EngineVersion' => '9.6.9', 'HostedZoneId' => 'Z2R2ITUGPM61AM', 'HttpEndpointEnabled' => false, 'IAMDatabaseAuthenticationEnabled' => false, 'MasterUsername' => 'master', 'MultiAZ' => false, 'Port' => 5432, 'PreferredBackupWindow' => '09:56-10:26', 'PreferredMaintenanceWindow' => 'wed:03:33-wed:04:03', 'ReadReplicaIdentifiers' => [], 'ReaderEndpoint' => 'sample-pg-cluster.cluster-ro-cnpexample.us-east-1.rds.amazonaws.com', 'Status' => 'creating', 'StorageEncrypted' => false, 'VpcSecurityGroups' => [ [ 'Status' => 'active', 'VpcSecurityGroupId' => 'sg-0b91305example', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a PostgreSQL-compatible Aurora DB cluster.', 'id' => 'to-create-a-postgresql-compatible-db-cluster-1679700161087', 'title' => 'To create a PostgreSQL-compatible DB cluster', ], ], 'CreateDBClusterEndpoint' => [ [ 'input' => [ 'DBClusterEndpointIdentifier' => 'mycustomendpoint', 'DBClusterIdentifier' => 'mydbcluster', 'EndpointType' => 'reader', 'StaticMembers' => [ 'dbinstance1', 'dbinstance2', ], ], 'output' => [ 'CustomEndpointType' => 'READER', 'DBClusterEndpointArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:mycustomendpoint', 'DBClusterEndpointIdentifier' => 'mycustomendpoint', 'DBClusterEndpointResourceIdentifier' => 'cluster-endpoint-ANPAJ4AE5446DAEXAMPLE', 'DBClusterIdentifier' => 'mydbcluster', 'Endpoint' => 'mycustomendpoint.cluster-custom-cnpexample.us-east-1.rds.amazonaws.com', 'EndpointType' => 'CUSTOM', 'ExcludedMembers' => [], 'StaticMembers' => [ 'dbinstance1', 'dbinstance2', ], 'Status' => 'creating', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a custom DB cluster endpoint and associate it with the specified Aurora DB cluster.', 'id' => 'to-create-a-custom-db-cluster-endpoint-1679701608522', 'title' => 'To create a custom DB cluster endpoint', ], ], 'CreateDBClusterParameterGroup' => [ [ 'input' => [ 'DBClusterParameterGroupName' => 'mydbclusterparametergroup', 'DBParameterGroupFamily' => 'aurora5.6', 'Description' => 'My new cluster parameter group', ], 'output' => [ 'DBClusterParameterGroup' => [ 'DBClusterParameterGroupArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-pg:mydbclusterparametergroup', 'DBClusterParameterGroupName' => 'mydbclusterparametergroup', 'DBParameterGroupFamily' => 'aurora5.6', 'Description' => 'My new cluster parameter group', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a DB cluster parameter group.', 'id' => 'to-create-a-db-cluster-parameter-group-1679702915771', 'title' => 'To create a DB cluster parameter group', ], ], 'CreateDBClusterSnapshot' => [ [ 'input' => [ 'DBClusterIdentifier' => 'mydbclustersnapshot', 'DBClusterSnapshotIdentifier' => 'mydbcluster', ], 'output' => [ 'DBClusterSnapshot' => [ 'AllocatedStorage' => 1, 'AvailabilityZones' => [ 'us-east-1a', 'us-east-1b', 'us-east-1e', ], 'ClusterCreateTime' => '2019-04-15T14:18:42.785Z', 'DBClusterIdentifier' => 'mydbcluster', 'DBClusterSnapshotArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-snapshot:mydbclustersnapshot', 'DBClusterSnapshotIdentifier' => 'mydbclustersnapshot', 'Engine' => 'aurora-mysql', 'EngineVersion' => '5.7.mysql_aurora.2.04.2', 'IAMDatabaseAuthenticationEnabled' => false, 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE', 'LicenseModel' => 'aurora-mysql', 'MasterUsername' => 'myadmin', 'PercentProgress' => 0, 'Port' => 0, 'SnapshotCreateTime' => '2019-06-18T21:21:00.469Z', 'SnapshotType' => 'manual', 'Status' => 'creating', 'StorageEncrypted' => true, 'VpcId' => 'vpc-6594f31c', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a DB cluster snapshot.', 'id' => 'to-create-a-db-cluster-snapshot-1679703154423', 'title' => 'To create a DB cluster snapshot', ], ], 'CreateDBInstance' => [ [ 'input' => [ 'AllocatedStorage' => 20, 'DBInstanceClass' => 'db.t3.micro', 'DBInstanceIdentifier' => 'test-mysql-instance', 'Engine' => 'mysql', 'MasterUserPassword' => 'secret99', 'MasterUsername' => 'admin', ], 'output' => [ 'DBInstance' => [ 'AllocatedStorage' => 20, 'AssociatedRoles' => [], 'AutoMinorVersionUpgrade' => true, 'BackupRetentionPeriod' => 1, 'CACertificateIdentifier' => 'rds-ca-2019', 'CopyTagsToSnapshot' => false, 'DBInstanceArn' => 'arn:aws:rds:us-west-2:123456789012:db:test-mysql-instance', 'DBInstanceClass' => 'db.t3.micro', 'DBInstanceIdentifier' => 'test-mysql-instance', 'DBInstanceStatus' => 'creating', 'DBParameterGroups' => [ [ 'DBParameterGroupName' => 'default.mysql5.7', 'ParameterApplyStatus' => 'in-sync', ], ], 'DBSecurityGroups' => [], 'DBSubnetGroup' => [ 'DBSubnetGroupDescription' => 'default', 'DBSubnetGroupName' => 'default', 'SubnetGroupStatus' => 'Complete', 'Subnets' => [ [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2c', ], 'SubnetIdentifier' => 'subnet-########', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2d', ], 'SubnetIdentifier' => 'subnet-########', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2a', ], 'SubnetIdentifier' => 'subnet-########', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2b', ], 'SubnetIdentifier' => 'subnet-########', 'SubnetStatus' => 'Active', ], ], 'VpcId' => 'vpc-2ff2ff2f', ], 'DbInstancePort' => 0, 'DbiResourceId' => 'db-5555EXAMPLE44444444EXAMPLE', 'DeletionProtection' => false, 'DomainMemberships' => [], 'Engine' => 'mysql', 'EngineVersion' => '5.7.22', 'IAMDatabaseAuthenticationEnabled' => false, 'LicenseModel' => 'general-public-license', 'MasterUsername' => 'admin', 'MonitoringInterval' => 0, 'MultiAZ' => false, 'OptionGroupMemberships' => [ [ 'OptionGroupName' => 'default:mysql-5-7', 'Status' => 'in-sync', ], ], 'PendingModifiedValues' => [ 'MasterUserPassword' => '****', ], 'PerformanceInsightsEnabled' => false, 'PreferredBackupWindow' => '12:55-13:25', 'PreferredMaintenanceWindow' => 'sun:08:07-sun:08:37', 'PubliclyAccessible' => true, 'ReadReplicaDBInstanceIdentifiers' => [], 'StorageEncrypted' => false, 'StorageType' => 'gp2', 'VpcSecurityGroups' => [ [ 'Status' => 'active', 'VpcSecurityGroupId' => 'sg-12345abc', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example uses the required options to launch a new DB instance.', 'id' => 'to-create-a-db-instance-1679703299533', 'title' => 'To create a DB instance', ], ], 'CreateDBInstanceReadReplica' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'test-instance-repl', 'SourceDBInstanceIdentifier' => 'test-instance', ], 'output' => [ 'DBInstance' => [ 'DBInstanceArn' => 'arn:aws:rds:us-east-1:123456789012:db:test-instance-repl', 'DBInstanceIdentifier' => 'test-instance-repl', 'IAMDatabaseAuthenticationEnabled' => false, 'MonitoringInterval' => 0, 'ReadReplicaSourceDBInstanceIdentifier' => 'test-instance', ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBInstance' => 'Some output ommitted.', ], ], 'description' => 'This example creates a read replica of an existing DB instance named test-instance. The read replica is named test-instance-repl.', 'id' => 'to-create-a-db-instance-read-replica-1680129486105', 'title' => 'To create a DB instance read replica', ], ], 'CreateDBParameterGroup' => [ [ 'input' => [ 'DBParameterGroupFamily' => 'MySQL8.0', 'DBParameterGroupName' => 'mydbparametergroup', 'Description' => 'My new parameter group', ], 'output' => [ 'DBParameterGroup' => [ 'DBParameterGroupArn' => 'arn:aws:rds:us-east-1:123456789012:pg:mydbparametergroup', 'DBParameterGroupFamily' => 'mysql8.0', 'DBParameterGroupName' => 'mydbparametergroup', 'Description' => 'My new parameter group', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a DB parameter group.', 'id' => 'to-create-a-db-parameter-group-1679939227970', 'title' => 'To create a DB parameter group', ], ], 'CreateDBSecurityGroup' => [ [ 'input' => [ 'DBSecurityGroupDescription' => 'My DB security group', 'DBSecurityGroupName' => 'mydbsecuritygroup', ], 'output' => [ 'DBSecurityGroup' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'This example creates a DB security group.', 'id' => 'create-db-security-group-41b6786a-539e-42a5-a645-a8bc3cf99353', 'title' => 'To create a DB security group.', ], ], 'CreateDBSnapshot' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'mydbsnapshot', 'DBSnapshotIdentifier' => 'database-mysql', ], 'output' => [ 'DBSnapshot' => [ 'AllocatedStorage' => 100, 'AvailabilityZone' => 'us-east-1b', 'DBInstanceIdentifier' => 'database-mysql', 'DBSnapshotArn' => 'arn:aws:rds:us-east-1:123456789012:snapshot:mydbsnapshot', 'DBSnapshotIdentifier' => 'mydbsnapshot', 'DbiResourceId' => 'db-AKIAIOSFODNN7EXAMPLE', 'Encrypted' => true, 'Engine' => 'mysql', 'EngineVersion' => '8.0.32', 'IAMDatabaseAuthenticationEnabled' => false, 'InstanceCreateTime' => '2019-04-30T15:45:53.663Z', 'Iops' => 1000, 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE', 'LicenseModel' => 'general-public-license', 'MasterUsername' => 'admin', 'OptionGroupName' => 'default:mysql-8-0', 'PercentProgress' => 0, 'Port' => 3306, 'ProcessorFeatures' => [], 'SnapshotType' => 'manual', 'Status' => 'creating', 'StorageType' => 'io1', 'VpcId' => 'vpc-6594f31c', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a DB snapshot.', 'id' => 'to-create-a-db-snapshot-1679939585361', 'title' => 'To create a DB snapshot', ], ], 'CreateDBSubnetGroup' => [ [ 'input' => [ 'DBSubnetGroupDescription' => 'test DB subnet group', 'DBSubnetGroupName' => 'mysubnetgroup', 'SubnetIds' => [ 'subnet-0a1dc4e1a6f123456', 'subnet-070dd7ecb3aaaaaaa', 'subnet-00f5b198bc0abcdef', ], ], 'output' => [ 'DBSubnetGroup' => [ 'DBSubnetGroupArn' => 'arn:aws:rds:us-west-2:0123456789012:subgrp:mysubnetgroup', 'DBSubnetGroupDescription' => 'test DB subnet group', 'DBSubnetGroupName' => 'mysubnetgroup', 'SubnetGroupStatus' => 'Complete', 'Subnets' => [ [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2b', ], 'SubnetIdentifier' => 'subnet-070dd7ecb3aaaaaaa', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2d', ], 'SubnetIdentifier' => 'subnet-00f5b198bc0abcdef', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2b', ], 'SubnetIdentifier' => 'subnet-0a1dc4e1a6f123456', 'SubnetStatus' => 'Active', ], ], 'VpcId' => 'vpc-0f08e7610a1b2c3d4', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a DB subnet group called mysubnetgroup using existing subnets.', 'id' => 'to-create-a-db-subnet-group-1679942682822', 'title' => 'To create a DB subnet group', ], ], 'CreateEventSubscription' => [ [ 'input' => [ 'EventCategories' => [ 'backup', 'recovery', ], 'SnsTopicArn' => 'arn:aws:sns:us-east-1:123456789012:interesting-events', 'SourceType' => 'db-instance', 'SubscriptionName' => 'my-instance-events', ], 'output' => [ 'EventSubscription' => [ 'CustSubscriptionId' => 'my-instance-events', 'CustomerAwsId' => '123456789012', 'Enabled' => true, 'EventCategoriesList' => [ 'backup', 'recovery', ], 'EventSubscriptionArn' => 'arn:aws:rds:us-east-1:123456789012:es:my-instance-events', 'SnsTopicArn' => 'arn:aws:sns:us-east-1:123456789012:interesting-events', 'SourceType' => 'db-instance', 'Status' => 'creating', 'SubscriptionCreationTime' => 'Tue Jul 31 23:22:01 UTC 2018', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a subscription for backup and recovery events for DB instances in the current AWS account. Notifications are sent to an Amazon Simple Notification Service topic.', 'id' => 'to-create-an-event-subscription-1679956709288', 'title' => 'To create an event subscription', ], ], 'CreateGlobalCluster' => [ [ 'input' => [ 'Engine' => 'aurora-mysql', 'GlobalClusterIdentifier' => 'myglobalcluster', ], 'output' => [ 'GlobalCluster' => [ 'DeletionProtection' => false, 'Engine' => 'aurora-mysql', 'EngineVersion' => '5.7.mysql_aurora.2.07.2', 'GlobalClusterArn' => 'arn:aws:rds::123456789012:global-cluster:myglobalcluster', 'GlobalClusterIdentifier' => 'myglobalcluster', 'GlobalClusterMembers' => [], 'GlobalClusterResourceId' => 'cluster-f0e523bfe07aabb', 'Status' => 'available', 'StorageEncrypted' => false, ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a new Aurora MySQL-compatible global DB cluster.', 'id' => 'to-create-a-global-db-cluster-1679957040413', 'title' => 'To create a global DB cluster', ], ], 'CreateIntegration' => [ [ 'input' => [ 'IntegrationName' => 'my-integration', 'SourceArn' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-cluster', 'TargetArn' => 'arn:aws:redshift-serverless:us-east-1:123456789012:namespace/62c70612-0302-4db7-8414-b5e3e049f0d8', ], 'output' => [ 'CreateTime' => '2023-12-28T17:20:20.629Z', 'IntegrationArn' => 'arn:aws:rds:us-east-1:123456789012:integration:5b9f3d79-7392-4a3e-896c-58eaa1b53231', 'IntegrationName' => 'my-integration', 'KMSKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/a1b2c3d4-5678-90ab-cdef-EXAMPLEaaaaa', 'SourceArn' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-cluster', 'Status' => 'creating', 'Tags' => [], 'TargetArn' => 'arn:aws:redshift-serverless:us-east-1:123456789012:namespace/62c70612-0302-4db7-8414-b5e3e049f0d8', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a zero-ETL integration with Amazon Redshift.', 'id' => 'to-create-a-zero-etl-integration-1679688377231', 'title' => 'To create a zero-ETL integration', ], ], 'CreateOptionGroup' => [ [ 'input' => [ 'EngineName' => 'mysql', 'MajorEngineVersion' => '8.0', 'OptionGroupDescription' => 'MySQL 8.0 option group', 'OptionGroupName' => 'MyOptionGroup', ], 'output' => [ 'OptionGroup' => [ 'AllowsVpcAndNonVpcInstanceMemberships' => true, 'EngineName' => 'mysql', 'MajorEngineVersion' => '8.0', 'OptionGroupArn' => 'arn:aws:rds:us-east-1:123456789012:og:myoptiongroup', 'OptionGroupDescription' => 'MySQL 8.0 option group', 'OptionGroupName' => 'myoptiongroup', 'Options' => [], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example creates a new Amazon RDS option group for Oracle MySQL version 8,0 named MyOptionGroup.', 'id' => 'to-create-an-amazon-rds-option-group-1679958217590', 'title' => 'To Create an Amazon RDS option group', ], ], 'DeleteBlueGreenDeployment' => [ [ 'input' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-v53303651eexfake', 'DeleteTarget' => true, ], 'output' => [ 'BlueGreenDeployment' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-v53303651eexfake', 'BlueGreenDeploymentName' => 'bgd-cli-test-instance', 'CreateTime' => '2022-02-25T21:18:51.183000+00:00', 'DeleteTime' => '2022-02-25T22:25:31.331000+00:00', 'Source' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance', 'Status' => 'DELETING', 'SwitchoverDetails' => [ [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-green-rkfbpe', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-1', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-1-green-j382ha', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-2', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-2-green-ejv4ao', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-3', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-3-green-vlpz3t', ], ], 'Target' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-green-rkfbpe', 'Tasks' => [ [ 'Name' => 'CREATING_READ_REPLICA_OF_SOURCE', 'Status' => 'COMPLETED', ], [ 'Name' => 'DB_ENGINE_VERSION_UPGRADE', 'Status' => 'COMPLETED', ], [ 'Name' => 'CONFIGURE_BACKUPS', 'Status' => 'COMPLETED', ], [ 'Name' => 'CREATING_TOPOLOGY_OF_SOURCE', 'Status' => 'COMPLETED', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes the resources in a green environment for an RDS for MySQL DB instance.', 'id' => 'to-delete-resources-in-green-environment-for-an-rds-for-mysql-db-instance-1679959961651', 'title' => 'To delete resources in green environment for an RDS for MySQL DB instance', ], [ 'input' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-wi89nwzglccsfake', 'DeleteTarget' => true, ], 'output' => [ 'BlueGreenDeployment' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-wi89nwzglccsfake', 'BlueGreenDeploymentName' => 'my-blue-green-deployment', 'CreateTime' => '2022-02-25T21:12:00.288000+00:00', 'DeleteTime' => '2022-02-25T22:29:11.336000+00:00', 'Source' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster', 'Status' => 'DELETING', 'SwitchoverDetails' => [ [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-green-3rnukl', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1-green-gpmaxf', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2-green-j2oajq', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3-green-mkxies', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint-green-4sqjrq', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint-green-gwwzlg', ], ], 'Target' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-green-3rnukl', 'Tasks' => [ [ 'Name' => 'CREATING_READ_REPLICA_OF_SOURCE', 'Status' => 'COMPLETED', ], [ 'Name' => 'DB_ENGINE_VERSION_UPGRADE', 'Status' => 'COMPLETED', ], [ 'Name' => 'CREATE_DB_INSTANCES_FOR_CLUSTER', 'Status' => 'COMPLETED', ], [ 'Name' => 'CREATE_CUSTOM_ENDPOINTS', 'Status' => 'COMPLETED', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes the resources in a green environment for an Aurora MySQL DB cluster.', 'id' => 'to-delete-resources-in-green-environment-for-an-aurora-mysql-db-cluster-1679960123935', 'title' => 'To delete resources in green environment for an Aurora MySQL DB cluster', ], ], 'DeleteDBCluster' => [ [ 'input' => [ 'DBClusterIdentifier' => 'mycluster', 'FinalDBSnapshotIdentifier' => 'mycluster-final-snapshot', 'SkipFinalSnapshot' => false, ], 'output' => [ 'DBCluster' => [ 'AllocatedStorage' => 20, 'AvailabilityZones' => [ 'eu-central-1b', 'eu-central-1c', 'eu-central-1a', ], 'BackupRetentionPeriod' => 7, 'DBClusterIdentifier' => 'mycluster', 'DBClusterParameterGroup' => 'default.aurora-postgresql10', 'DBSubnetGroup' => 'default-vpc-aa11bb22', 'Status' => 'available', ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBCluster' => 'Some output ommitted.', ], ], 'description' => 'The following example deletes the DB cluster named mycluster and takes a final snapshot named mycluster-final-snapshot. The status of the DB cluster is available while the snapshot is being taken. ', 'id' => 'to-delete-a-db-cluster-1680197141906', 'title' => 'To delete a DB cluster', ], ], 'DeleteDBClusterEndpoint' => [ [ 'input' => [ 'DBClusterEndpointIdentifier' => 'mycustomendpoint', ], 'output' => [ 'CustomEndpointType' => 'READER', 'DBClusterEndpointArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:mycustomendpoint', 'DBClusterEndpointIdentifier' => 'mycustomendpoint', 'DBClusterEndpointResourceIdentifier' => 'cluster-endpoint-ANPAJ4AE5446DAEXAMPLE', 'DBClusterIdentifier' => 'mydbcluster', 'Endpoint' => 'mycustomendpoint.cluster-custom-cnpexample.us-east-1.rds.amazonaws.com', 'EndpointType' => 'CUSTOM', 'ExcludedMembers' => [], 'StaticMembers' => [ 'dbinstance1', 'dbinstance2', 'dbinstance3', ], 'Status' => 'deleting', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes the specified custom DB cluster endpoint.', 'id' => 'to-delete-a-custom-db-cluster-endpoint-1679960663390', 'title' => 'To delete a custom DB cluster endpoint', ], ], 'DeleteDBClusterParameterGroup' => [ [ 'input' => [ 'DBClusterParameterGroupName' => 'mydbclusterparametergroup', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes the specified DB cluster parameter group.', 'id' => 'to-delete-a-db-cluster-parameter-group-1679962185718', 'title' => 'To delete a DB cluster parameter group', ], ], 'DeleteDBClusterSnapshot' => [ [ 'input' => [ 'DBClusterSnapshotIdentifier' => 'mydbclustersnapshot', ], 'output' => [ 'DBClusterSnapshot' => [ 'AllocatedStorage' => 0, 'AvailabilityZones' => [ 'us-east-1a', 'us-east-1b', 'us-east-1e', ], 'ClusterCreateTime' => '2019-04-15T14:18:42.785Z', 'DBClusterIdentifier' => 'mydbcluster', 'DBClusterSnapshotArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-snapshot:mydbclustersnapshot', 'DBClusterSnapshotIdentifier' => 'mydbclustersnapshot', 'Engine' => 'aurora-mysql', 'EngineVersion' => '5.7.mysql_aurora.2.04.2', 'IAMDatabaseAuthenticationEnabled' => false, 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE', 'LicenseModel' => 'aurora-mysql', 'MasterUsername' => 'myadmin', 'PercentProgress' => 100, 'Port' => 0, 'SnapshotCreateTime' => '2019-06-18T21:21:00.469Z', 'SnapshotType' => 'manual', 'Status' => 'available', 'StorageEncrypted' => true, 'VpcId' => 'vpc-6594f31c', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => '', 'id' => 'to-delete-a-db-cluster-snapshot-1679962808509', 'title' => 'To delete a DB cluster snapshot', ], ], 'DeleteDBInstance' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'test-instance', 'FinalDBSnapshotIdentifier' => 'test-instance-final-snap', 'SkipFinalSnapshot' => false, ], 'output' => [ 'DBInstance' => [ 'DBInstanceIdentifier' => 'test-instance', 'DBInstanceStatus' => 'deleting', ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBInstance' => 'Some output ommitted.', ], ], 'description' => 'The following example deletes the specified DB instance after creating a final DB snapshot named test-instance-final-snap.', 'id' => 'to-delete-a-db-instance-1680197458232', 'title' => 'To delete a DB instance', ], ], 'DeleteDBInstanceAutomatedBackup' => [ [ 'input' => [ 'DBInstanceAutomatedBackupsArn' => 'arn:aws:rds:us-west-2:123456789012:auto-backup:ab-jkib2gfq5rv7replzadausbrktni2bn4example', ], 'output' => [ 'DBInstanceAutomatedBackup' => [ 'AllocatedStorage' => 20, 'AvailabilityZone' => 'us-east-1b', 'BackupRetentionPeriod' => 7, 'DBInstanceArn' => 'arn:aws:rds:us-east-1:123456789012:db:new-orcl-db', 'DBInstanceAutomatedBackupsArn' => 'arn:aws:rds:us-west-2:123456789012:auto-backup:ab-jkib2gfq5rv7replzadausbrktni2bn4example', 'DBInstanceIdentifier' => 'new-orcl-db', 'DbiResourceId' => 'db-JKIB2GFQ5RV7REPLZA4EXAMPLE', 'Encrypted' => false, 'Engine' => 'oracle-se2', 'EngineVersion' => '12.1.0.2.v21', 'IAMDatabaseAuthenticationEnabled' => false, 'InstanceCreateTime' => '2020-12-04T15:28:31Z', 'LicenseModel' => 'bring-your-own-license', 'MasterUsername' => 'admin', 'OptionGroupName' => 'default:oracle-se2-12-1', 'Port' => 1521, 'Region' => 'us-east-1', 'RestoreWindow' => [], 'Status' => 'deleting', 'StorageType' => 'gp2', 'VpcId' => 'vpc-########', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes the automated backup with the specified Amazon Resource Name (ARN).', 'id' => 'to-delete-a-replicated-automated-backup-from-a-region-1679963187406', 'title' => 'To delete a replicated automated backup from a Region', ], ], 'DeleteDBParameterGroup' => [ [ 'input' => [ 'DBParameterGroupName' => 'mydbparametergroup', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes a DB parameter group.', 'id' => 'to-delete-a-db-parameter-group-1679963369020', 'title' => 'To delete a DB parameter group', ], ], 'DeleteDBSecurityGroup' => [ [ 'input' => [ 'DBSecurityGroupName' => 'mysecgroup', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes a DB security group.', 'id' => 'to-delete-a-db-security-group-1473960141889', 'title' => 'To delete a DB security group', ], ], 'DeleteDBSnapshot' => [ [ 'input' => [ 'DBSnapshotIdentifier' => 'mydbsnapshot', ], 'output' => [ 'DBSnapshot' => [ 'AllocatedStorage' => 100, 'AvailabilityZone' => 'us-east-1b', 'DBInstanceIdentifier' => 'database-mysql', 'DBSnapshotArn' => 'arn:aws:rds:us-east-1:123456789012:snapshot:mydbsnapshot', 'DBSnapshotIdentifier' => 'mydbsnapshot', 'DbiResourceId' => 'db-AKIAIOSFODNN7EXAMPLE', 'Encrypted' => true, 'Engine' => 'mysql', 'EngineVersion' => '5.6.40', 'IAMDatabaseAuthenticationEnabled' => false, 'InstanceCreateTime' => '2019-04-30T15:45:53.663Z', 'Iops' => 1000, 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE', 'LicenseModel' => 'general-public-license', 'MasterUsername' => 'admin', 'OptionGroupName' => 'default:mysql-5-6', 'PercentProgress' => 100, 'Port' => 3306, 'ProcessorFeatures' => [], 'SnapshotCreateTime' => '2019-06-18T22:08:40.702Z', 'SnapshotType' => 'manual', 'Status' => 'deleted', 'StorageType' => 'io1', 'VpcId' => 'vpc-6594f31c', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes the specified DB snapshot.', 'id' => 'to-delete-a-db-snapshot-1680111103708', 'title' => 'To delete a DB snapshot', ], ], 'DeleteDBSubnetGroup' => [ [ 'input' => [ 'DBSubnetGroupName' => 'mysubnetgroup', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes the DB subnet group called mysubnetgroup.', 'id' => 'to-delete-a-db-subnet-group-1680127744982', 'title' => 'To delete a DB subnet group', ], ], 'DeleteEventSubscription' => [ [ 'input' => [ 'SubscriptionName' => 'my-instance-events', ], 'output' => [ 'EventSubscription' => [ 'CustSubscriptionId' => 'my-instance-events', 'CustomerAwsId' => '123456789012', 'Enabled' => false, 'EventCategoriesList' => [ 'backup', 'recovery', ], 'EventSubscriptionArn' => 'arn:aws:rds:us-east-1:123456789012:es:my-instance-events', 'SnsTopicArn' => 'arn:aws:sns:us-east-1:123456789012:interesting-events', 'SourceIdsList' => [ 'test-instance', ], 'SourceType' => 'db-instance', 'Status' => 'deleting', 'SubscriptionCreationTime' => '2018-07-31 23:22:01.893', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes the specified event subscription.', 'id' => 'to-delete-an-event-subscription-1680128383147', 'title' => 'To delete an event subscription', ], ], 'DeleteGlobalCluster' => [ [ 'input' => [ 'GlobalClusterIdentifier' => 'myglobalcluster', ], 'output' => [ 'GlobalCluster' => [ 'DeletionProtection' => false, 'Engine' => 'aurora-mysql', 'EngineVersion' => '5.7.mysql_aurora.2.07.2', 'GlobalClusterArn' => 'arn:aws:rds::123456789012:global-cluster:myglobalcluster', 'GlobalClusterIdentifier' => 'myglobalcluster', 'GlobalClusterMembers' => [], 'GlobalClusterResourceId' => 'cluster-f0e523bfe07aabb', 'Status' => 'available', 'StorageEncrypted' => false, ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes an Aurora MySQL-compatible global DB cluster.', 'id' => 'to-delete-a-global-db-cluster-1680128523630', 'title' => 'To delete a global DB cluster', ], ], 'DeleteIntegration' => [ [ 'input' => [ 'IntegrationIdentifier' => '5b9f3d79-7392-4a3e-896c-58eaa1b53231', ], 'output' => [ 'CreateTime' => '2023-12-28T17:20:20.629Z', 'IntegrationArn' => 'arn:aws:rds:us-east-1:123456789012:integration:5b9f3d79-7392-4a3e-896c-58eaa1b53231', 'IntegrationName' => 'my-integration', 'KMSKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/a1b2c3d4-5678-90ab-cdef-EXAMPLEaaaaa', 'SourceArn' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-cluster', 'Status' => 'deleting', 'Tags' => [], 'TargetArn' => 'arn:aws:redshift-serverless:us-east-1:123456789012:namespace/62c70612-0302-4db7-8414-b5e3e049f0d8', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes a zero-ETL integration with Amazon Redshift.', 'id' => 'to-delete-a-zero-etl-integration-1679688377231', 'title' => 'To delete a zero-ETL integration', ], ], 'DeleteOptionGroup' => [ [ 'input' => [ 'OptionGroupName' => 'myoptiongroup', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example deletes the specified option group.', 'id' => 'to-delete-an-option-group-1680128894360', 'title' => 'To delete an option group', ], ], 'DescribeAccountAttributes' => [ [ 'input' => [], 'output' => [ 'AccountQuotas' => [ [ 'AccountQuotaName' => 'DBInstances', 'Max' => 40, 'Used' => 4, ], [ 'AccountQuotaName' => 'ReservedDBInstances', 'Max' => 40, 'Used' => 0, ], [ 'AccountQuotaName' => 'AllocatedStorage', 'Max' => 100000, 'Used' => 40, ], [ 'AccountQuotaName' => 'DBSecurityGroups', 'Max' => 25, 'Used' => 0, ], [ 'AccountQuotaName' => 'AuthorizationsPerDBSecurityGroup', 'Max' => 20, 'Used' => 0, ], [ 'AccountQuotaName' => 'DBParameterGroups', 'Max' => 50, 'Used' => 1, ], [ 'AccountQuotaName' => 'ManualSnapshots', 'Max' => 100, 'Used' => 3, ], [ 'AccountQuotaName' => 'EventSubscriptions', 'Max' => 20, 'Used' => 0, ], [ 'AccountQuotaName' => 'DBSubnetGroups', 'Max' => 50, 'Used' => 1, ], [ 'AccountQuotaName' => 'OptionGroups', 'Max' => 20, 'Used' => 1, ], [ 'AccountQuotaName' => 'SubnetsPerDBSubnetGroup', 'Max' => 20, 'Used' => 6, ], [ 'AccountQuotaName' => 'ReadReplicasPerMaster', 'Max' => 5, 'Used' => 0, ], [ 'AccountQuotaName' => 'DBClusters', 'Max' => 40, 'Used' => 1, ], [ 'AccountQuotaName' => 'DBClusterParameterGroups', 'Max' => 50, 'Used' => 0, ], [ 'AccountQuotaName' => 'DBClusterRoles', 'Max' => 5, 'Used' => 0, ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves the attributes for the current AWS account.', 'id' => 'to-describe-account-attributes-1680210466935', 'title' => 'To describe account attributes', ], ], 'DescribeBlueGreenDeployments' => [ [ 'input' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-v53303651eexfake', ], 'output' => [ 'BlueGreenDeployments' => [ [ 'BlueGreenDeploymentIdentifier' => 'bgd-v53303651eexfake', 'BlueGreenDeploymentName' => 'bgd-cli-test-instance', 'CreateTime' => '2022-02-25T21:18:51.183000+00:00', 'Source' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance', 'Status' => 'AVAILABLE', 'SwitchoverDetails' => [ [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-green-rkfbpe', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-1', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-1-green-j382ha', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-2', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-2-green-ejv4ao', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-3', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-3-green-vlpz3t', ], ], 'Target' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-green-rkfbpe', 'Tasks' => [ [ 'Name' => 'CREATING_READ_REPLICA_OF_SOURCE', 'Status' => 'COMPLETED', ], [ 'Name' => 'DB_ENGINE_VERSION_UPGRADE', 'Status' => 'COMPLETED', ], [ 'Name' => 'CONFIGURE_BACKUPS', 'Status' => 'COMPLETED', ], [ 'Name' => 'CREATING_TOPOLOGY_OF_SOURCE', 'Status' => 'COMPLETED', ], ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves the details of a blue/green deployment after creation completes.', 'id' => 'to-describe-a-bluegreen-deployment-of-an-rds-db-instance-after-creation-completes-1680211143527', 'title' => 'To describe a blue/green deployment of an RDS DB instance after creation completes', ], [ 'input' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-wi89nwzglccsfake', ], 'output' => [ 'BlueGreenDeployments' => [ [ 'BlueGreenDeploymentIdentifier' => 'bgd-wi89nwzglccsfake', 'BlueGreenDeploymentName' => 'my-blue-green-deployment', 'CreateTime' => '2022-02-25T21:12:00.288000+00:00', 'Source' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster', 'Status' => 'AVAILABLE', 'SwitchoverDetails' => [ [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-green-3rnukl', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1-green-gpmaxf', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2-green-j2oajq', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3-green-mkxies', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint-green-4sqjrq', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint-green-gwwzlg', ], ], 'Target' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-green-3rnukl', 'Tasks' => [ [ 'Name' => 'CREATING_READ_REPLICA_OF_SOURCE', 'Status' => 'COMPLETED', ], [ 'Name' => 'DB_ENGINE_VERSION_UPGRADE', 'Status' => 'COMPLETED', ], [ 'Name' => 'CREATE_DB_INSTANCES_FOR_CLUSTER', 'Status' => 'COMPLETED', ], [ 'Name' => 'CREATE_CUSTOM_ENDPOINTS', 'Status' => 'COMPLETED', ], ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves the details of a blue/green deployment.', 'id' => 'to-describe-a-bluegreen-deployment-for-an-aurora-mysql-db-cluster-1680211228214', 'title' => 'To describe a blue/green deployment for an Aurora MySQL DB cluster', ], [ 'input' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-wi89nwzglccsfake', ], 'output' => [ 'BlueGreenDeployments' => [ [ 'BlueGreenDeploymentIdentifier' => 'bgd-wi89nwzglccsfake', 'BlueGreenDeploymentName' => 'my-blue-green-deployment', 'CreateTime' => '2022-02-25T22:38:49.522000+00:00', 'Source' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-old1', 'Status' => 'SWITCHOVER_COMPLETED', 'SwitchoverDetails' => [ [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-old1', 'Status' => 'SWITCHOVER_COMPLETED', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1-old1', 'Status' => 'SWITCHOVER_COMPLETED', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2-old1', 'Status' => 'SWITCHOVER_COMPLETED', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3-old1', 'Status' => 'SWITCHOVER_COMPLETED', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint-old1', 'Status' => 'SWITCHOVER_COMPLETED', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint-old1', 'Status' => 'SWITCHOVER_COMPLETED', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint', ], ], 'Target' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster', 'Tasks' => [ [ 'Name' => 'CREATING_READ_REPLICA_OF_SOURCE', 'Status' => 'COMPLETED', ], [ 'Name' => 'DB_ENGINE_VERSION_UPGRADE', 'Status' => 'COMPLETED', ], [ 'Name' => 'CREATE_DB_INSTANCES_FOR_CLUSTER', 'Status' => 'COMPLETED', ], [ 'Name' => 'CREATE_CUSTOM_ENDPOINTS', 'Status' => 'COMPLETED', ], ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves the details about a blue/green deployment after the green environment is promoted to be the production environment.', 'id' => 'to-describe-a-bluegreen-deployment-for-an-aurora-mysql-cluster-after-switchover-1680211583831', 'title' => 'To describe a blue/green deployment for an Aurora MySQL cluster after switchover', ], ], 'DescribeCertificates' => [ [ 'input' => [], 'output' => [ 'Certificates' => [ [ 'CertificateArn' => 'arn:aws:rds:us-east-1::cert:rds-ca-ecc384-g1', 'CertificateIdentifier' => 'rds-ca-ecc384-g1', 'CertificateType' => 'CA', 'CustomerOverride' => false, 'Thumbprint' => '24a97b91cbe86911190576c35c36aab4fEXAMPLE', 'ValidFrom' => '2021-05-25T22:41:55+00:00', 'ValidTill' => '2121-05-25T23:41:55+00:00', ], [ 'CertificateArn' => 'arn:aws:rds:us-east-1::cert:rds-ca-rsa4096-g1', 'CertificateIdentifier' => 'rds-ca-rsa4096-g1', 'CertificateType' => 'CA', 'CustomerOverride' => false, 'Thumbprint' => '9da6fa7fd2ec09c569a400d876b01b0c1EXAMPLE', 'ValidFrom' => '2021-05-25T22:38:35+00:00', 'ValidTill' => '2121-05-25T23:38:35+00:00', ], [ 'CertificateArn' => 'arn:aws:rds:us-east-1::cert:rds-ca-rsa2048-g1', 'CertificateIdentifier' => 'rds-ca-rsa2048-g1', 'CertificateType' => 'CA', 'CustomerOverride' => true, 'CustomerOverrideValidTill' => '2061-05-25T23:34:57+00:00', 'Thumbprint' => '2fa77ef894d983ba9d37ad699c84ab0f6EXAMPLE', 'ValidFrom' => '2021-05-25T22:34:57+00:00', 'ValidTill' => '2061-05-25T23:34:57+00:00', ], [ 'CertificateArn' => 'arn:aws:rds:us-east-1::cert:rds-ca-2019', 'CertificateIdentifier' => 'rds-ca-2019', 'CertificateType' => 'CA', 'CustomerOverride' => false, 'Thumbprint' => 'f0ed823ed14447bab557fdf3e49274669EXAMPLE', 'ValidFrom' => '2019-09-19T18:16:53+00:00', 'ValidTill' => '2024-08-22T17:08:50+00:00', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves the details of the certificate associated with the user\'s default region.', 'id' => 'to-describe-certificates-1680211777663', 'title' => 'To describe certificates', ], ], 'DescribeDBClusterBacktracks' => [ [ 'input' => [ 'DBClusterIdentifier' => 'mydbcluster', ], 'output' => [ 'DBClusterBacktracks' => [ [ 'BacktrackIdentifier' => '2f5f5294-0dd2-44c9-9f50-EXAMPLE', 'BacktrackRequestCreationTime' => '2021-02-12T14:36:18.819Z', 'BacktrackTo' => '2021-02-12T04:59:22Z', 'BacktrackedFrom' => '2021-02-12T14:37:31.640Z', 'DBClusterIdentifier' => 'mydbcluster', 'Status' => 'COMPLETED', ], [ 'BacktrackIdentifier' => '3c7a6421-af2a-4ea3-ae95-EXAMPLE', 'BacktrackRequestCreationTime' => '2021-02-12T00:07:53.487Z', 'BacktrackTo' => '2021-02-11T22:53:46Z', 'BacktrackedFrom' => '2021-02-12T00:09:27.006Z', 'DBClusterIdentifier' => 'mydbcluster', 'Status' => 'COMPLETED', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves details about the specified DB cluster.', 'id' => 'to-describe-backtracks-for-a-db-cluster-1680212191454', 'title' => 'To describe backtracks for a DB cluster', ], ], 'DescribeDBClusterEndpoints' => [ [ 'input' => [], 'output' => [ 'DBClusterEndpoints' => [ [ 'DBClusterIdentifier' => 'my-database-1', 'Endpoint' => 'my-database-1.cluster-cnpexample.us-east-1.rds.amazonaws.com', 'EndpointType' => 'WRITER', 'Status' => 'creating', ], [ 'DBClusterIdentifier' => 'my-database-1', 'Endpoint' => 'my-database-1.cluster-ro-cnpexample.us-east-1.rds.amazonaws.com', 'EndpointType' => 'READER', 'Status' => 'creating', ], [ 'DBClusterIdentifier' => 'mydbcluster', 'Endpoint' => 'mydbcluster.cluster-cnpexamle.us-east-1.rds.amazonaws.com', 'EndpointType' => 'WRITER', 'Status' => 'available', ], [ 'DBClusterIdentifier' => 'mydbcluster', 'Endpoint' => 'mydbcluster.cluster-ro-cnpexample.us-east-1.rds.amazonaws.com', 'EndpointType' => 'READER', 'Status' => 'available', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves details for your DB cluster endpoints. The most common kinds of Aurora clusters have two endpoints. One endpoint has type WRITER. You can use this endpoint for all SQL statements. The other endpoint has type READER. You can use this endpoint only for SELECT and other read-only SQL statements.', 'id' => 'to-describe-db-cluster-endpoints-1680212701970', 'title' => 'To describe DB cluster endpoints', ], [ 'input' => [ 'DBClusterIdentifier' => 'serverless-cluster', ], 'output' => [ 'DBClusterEndpoints' => [ [ 'DBClusterIdentifier' => 'serverless-cluster', 'Endpoint' => 'serverless-cluster.cluster-cnpexample.us-east-1.rds.amazonaws.com', 'EndpointType' => 'WRITER', 'Status' => 'available', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves details for the DB cluster endpoints of a single specified DB cluster. Aurora Serverless clusters have only a single endpoint with a type of WRITER.', 'id' => 'to-describe-db-cluster-endpoints-of-a-single-db-cluster-1680212863842', 'title' => 'To describe DB cluster endpoints of a single DB cluster', ], ], 'DescribeDBClusterParameterGroups' => [ [ 'input' => [], 'output' => [ 'DBClusterParameterGroups' => [ [ 'DBClusterParameterGroupArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-pg:default.aurora-mysql5.7', 'DBClusterParameterGroupName' => 'default.aurora-mysql5.7', 'DBParameterGroupFamily' => 'aurora-mysql5.7', 'Description' => 'Default cluster parameter group for aurora-mysql5.7', ], [ 'DBClusterParameterGroupArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-pg:default.aurora-postgresql9.6', 'DBClusterParameterGroupName' => 'default.aurora-postgresql9.6', 'DBParameterGroupFamily' => 'aurora-postgresql9.6', 'Description' => 'Default cluster parameter group for aurora-postgresql9.6', ], [ 'DBClusterParameterGroupArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-pg:default.aurora5.6', 'DBClusterParameterGroupName' => 'default.aurora5.6', 'DBParameterGroupFamily' => 'aurora5.6', 'Description' => 'Default cluster parameter group for aurora5.6', ], [ 'DBClusterParameterGroupArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-pg:mydbclusterpg', 'DBClusterParameterGroupName' => 'mydbclusterpg', 'DBParameterGroupFamily' => 'aurora-mysql5.7', 'Description' => 'My DB cluster parameter group', ], [ 'DBClusterParameterGroupArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-pg:mydbclusterpgcopy', 'DBClusterParameterGroupName' => 'mydbclusterpgcopy', 'DBParameterGroupFamily' => 'aurora-mysql5.7', 'Description' => 'Copy of mydbclusterpg parameter group', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves details for your DB cluster parameter groups.', 'id' => 'to-describe-db-cluster-parameter-groups-1680213090883', 'title' => 'To describe DB cluster parameter groups', ], ], 'DescribeDBClusterParameters' => [ [ 'input' => [ 'DBClusterParameterGroupName' => 'mydbclusterpg', ], 'output' => [ 'Parameters' => [ [ 'AllowedValues' => '0,1', 'ApplyMethod' => 'pending-reboot', 'ApplyType' => 'static', 'DataType' => 'boolean', 'Description' => 'Controls whether user-defined functions that have only an xxx symbol for the main function can be loaded', 'IsModifiable' => false, 'ParameterName' => 'allow-suspicious-udfs', 'Source' => 'engine-default', 'SupportedEngineModes' => [ 'provisioned', ], ], [ 'AllowedValues' => '0,1', 'ApplyMethod' => 'pending-reboot', 'ApplyType' => 'static', 'DataType' => 'boolean', 'Description' => 'Enables new features in the Aurora engine.', 'IsModifiable' => true, 'ParameterName' => 'aurora_lab_mode', 'ParameterValue' => '0', 'Source' => 'engine-default', 'SupportedEngineModes' => [ 'provisioned', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [ 'Parameters' => 'Some output ommitted.', ], ], 'description' => 'The following example retrieves details about the parameters in a DB cluster parameter group.', 'id' => 'to-describe-the-parameters-in-a-db-cluster-parameter-group-1680213275624', 'title' => 'To describe the parameters in a DB cluster parameter group', ], ], 'DescribeDBClusterSnapshotAttributes' => [ [ 'input' => [ 'DBClusterSnapshotIdentifier' => 'myclustersnapshot', ], 'output' => [ 'DBClusterSnapshotAttributesResult' => [ 'DBClusterSnapshotAttributes' => [ [ 'AttributeName' => 'restore', 'AttributeValues' => [ '123456789012', ], ], ], 'DBClusterSnapshotIdentifier' => 'myclustersnapshot', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves details of the attribute names and values for the specified DB cluster snapshot.', 'id' => 'to-describe-the-attribute-names-and-values-for-a-db-cluster-snapshot-1680216238905', 'title' => 'To describe the attribute names and values for a DB cluster snapshot', ], ], 'DescribeDBClusterSnapshots' => [ [ 'input' => [ 'DBClusterIdentifier' => 'mydbcluster', ], 'output' => [ 'DBClusterSnapshots' => [ [ 'AllocatedStorage' => 0, 'AvailabilityZones' => [ 'us-east-1a', 'us-east-1b', 'us-east-1e', ], 'ClusterCreateTime' => '2019-04-15T14:18:42.785Z', 'DBClusterIdentifier' => 'mydbcluster', 'DBClusterSnapshotArn' => 'arn:aws:rds:us-east-1:814387698303:cluster-snapshot:myclustersnapshotcopy', 'DBClusterSnapshotIdentifier' => 'myclustersnapshotcopy', 'Engine' => 'aurora-mysql', 'EngineVersion' => '5.7.mysql_aurora.2.04.2', 'IAMDatabaseAuthenticationEnabled' => false, 'KmsKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE', 'LicenseModel' => 'aurora-mysql', 'MasterUsername' => 'myadmin', 'PercentProgress' => 100, 'Port' => 0, 'SnapshotCreateTime' => '2019-06-04T09:16:42.649Z', 'SnapshotType' => 'manual', 'Status' => 'available', 'StorageEncrypted' => true, 'VpcId' => 'vpc-6594f31c', ], [ 'AllocatedStorage' => 0, 'AvailabilityZones' => [ 'us-east-1a', 'us-east-1b', 'us-east-1e', ], 'ClusterCreateTime' => '2019-04-15T14:18:42.785Z', 'DBClusterIdentifier' => 'mydbcluster', 'DBClusterSnapshotArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-snapshot:rds:mydbcluster-2019-06-20-09-16', 'DBClusterSnapshotIdentifier' => 'rds:mydbcluster-2019-06-20-09-16', 'Engine' => 'aurora-mysql', 'EngineVersion' => '5.7.mysql_aurora.2.04.2', 'IAMDatabaseAuthenticationEnabled' => false, 'KmsKeyId' => 'arn:aws:kms:us-east-1:814387698303:key/AKIAIOSFODNN7EXAMPLE', 'LicenseModel' => 'aurora-mysql', 'MasterUsername' => 'myadmin', 'PercentProgress' => 100, 'Port' => 0, 'SnapshotCreateTime' => '2019-06-20T09:16:26.569Z', 'SnapshotType' => 'automated', 'Status' => 'available', 'StorageEncrypted' => true, 'VpcId' => 'vpc-6594f31c', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves the details for the DB cluster snapshots for the specified DB cluster.', 'id' => 'to-describe-a-db-cluster-snapshot-for-a-db-cluster-1680216426182', 'title' => 'To describe a DB cluster snapshot for a DB cluster', ], ], 'DescribeDBClusters' => [ [ 'input' => [ 'DBClusterIdentifier' => 'mydbcluster', ], 'output' => [ 'DBClusters' => [ [ 'AllocatedStorage' => 1, 'AssociatedRoles' => [], 'AvailabilityZones' => [ 'us-east-1a', 'us-east-1b', 'us-east-1e', ], 'BackupRetentionPeriod' => 1, 'ClusterCreateTime' => '2019-04-15T14:18:42.785Z', 'DBClusterArn' => 'arn:aws:rds:us-east-1:123456789012:cluster:mydbcluster', 'DBClusterIdentifier' => 'mydbcluster', 'DBClusterMembers' => [ [ 'DBClusterParameterGroupStatus' => 'in-sync', 'DBInstanceIdentifier' => 'dbinstance3', 'IsClusterWriter' => false, 'PromotionTier' => 1, ], [ 'DBClusterParameterGroupStatus' => 'in-sync', 'DBInstanceIdentifier' => 'dbinstance1', 'IsClusterWriter' => false, 'PromotionTier' => 1, ], [ 'DBClusterParameterGroupStatus' => 'in-sync', 'DBInstanceIdentifier' => 'dbinstance2', 'IsClusterWriter' => false, 'PromotionTier' => 1, ], [ 'DBClusterParameterGroupStatus' => 'in-sync', 'DBInstanceIdentifier' => 'mydbcluster', 'IsClusterWriter' => false, 'PromotionTier' => 1, ], [ 'DBClusterParameterGroupStatus' => 'in-sync', 'DBInstanceIdentifier' => 'mydbcluster-us-east-1b', 'IsClusterWriter' => false, 'PromotionTier' => 1, ], [ 'DBClusterParameterGroupStatus' => 'in-sync', 'DBInstanceIdentifier' => 'mydbcluster', 'IsClusterWriter' => true, 'PromotionTier' => 1, ], ], 'DBClusterParameterGroup' => 'default.aurora-mysql5.7', 'DBSubnetGroup' => 'default', 'DatabaseName' => 'mydbcluster', 'DbClusterResourceId' => 'cluster-AKIAIOSFODNN7EXAMPLE', 'DeletionProtection' => false, 'EarliestRestorableTime' => '2019-06-19T09:16:28.210Z', 'Endpoint' => 'mydbcluster.cluster-cnpexample.us-east-1.rds.amazonaws.com', 'Engine' => 'aurora-mysql', 'EngineMode' => 'provisioned', 'EngineVersion' => '5.7.mysql_aurora.2.04.2', 'HostedZoneId' => 'Z2R2ITUGPM61AM', 'HttpEndpointEnabled' => false, 'IAMDatabaseAuthenticationEnabled' => false, 'KmsKeyId' => 'arn:aws:kms:us-east-1:814387698303:key/AKIAIOSFODNN7EXAMPLE', 'LatestRestorableTime' => '2019-06-20T22:38:14.908Z', 'MasterUsername' => 'myadmin', 'MultiAZ' => true, 'Port' => 3306, 'PreferredBackupWindow' => '09:09-09:39', 'PreferredMaintenanceWindow' => 'sat:04:09-sat:04:39', 'ReadReplicaIdentifiers' => [], 'ReaderEndpoint' => 'mydbcluster.cluster-ro-cnpexample.us-east-1.rds.amazonaws.com', 'Status' => 'available', 'StorageEncrypted' => true, 'VpcSecurityGroups' => [ [ 'Status' => 'active', 'VpcSecurityGroupId' => 'sg-0b9130572daf3dc16', ], ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves the details of the specified DB cluster.', 'id' => 'to-describe-a-db-cluster-1680215000529', 'title' => 'To describe a DB cluster', ], ], 'DescribeDBEngineVersions' => [ [ 'input' => [ 'Engine' => 'mysql', ], 'output' => [ 'DBEngineVersions' => [ [ 'DBEngineDescription' => 'MySQL Community Edition', 'DBEngineVersionDescription' => 'MySQL 5.7.33', 'DBParameterGroupFamily' => 'mysql5.7', 'Engine' => 'mysql', 'EngineVersion' => '5.7.33', 'ValidUpgradeTarget' => [ [ 'AutoUpgrade' => false, 'Description' => 'MySQL 5.7.34', 'Engine' => 'mysql', 'EngineVersion' => '5.7.34', 'IsMajorVersionUpgrade' => false, ], [ 'AutoUpgrade' => false, 'Description' => 'MySQL 5.7.36', 'Engine' => 'mysql', 'EngineVersion' => '5.7.36', 'IsMajorVersionUpgrade' => false, ], ], ], ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBEngineVersions' => 'Some output ommitted.', ], ], 'description' => 'The following example displays details about each of the DB engine versions for the specified DB engine.', 'id' => 'to-describe-the-db-engine-versions-for-the-mysql-db-engine-1680216738909', 'title' => 'To describe the DB engine versions for the MySQL DB engine', ], ], 'DescribeDBInstanceAutomatedBackups' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'new-orcl-db', ], 'output' => [ 'DBInstanceAutomatedBackups' => [ [ 'AllocatedStorage' => 20, 'BackupRetentionPeriod' => 14, 'DBInstanceArn' => 'arn:aws:rds:us-east-1:123456789012:db:new-orcl-db', 'DBInstanceAutomatedBackupsArn' => 'arn:aws:rds:us-west-2:123456789012:auto-backup:ab-jkib2gfq5rv7replzadausbrktni2bn4example', 'DBInstanceIdentifier' => 'new-orcl-db', 'DbiResourceId' => 'db-JKIB2GFQ5RV7REPLZA4EXAMPLE', 'Encrypted' => false, 'Engine' => 'oracle-se2', 'EngineVersion' => '12.1.0.2.v21', 'IAMDatabaseAuthenticationEnabled' => false, 'InstanceCreateTime' => '2020-12-04T15:28:31Z', 'LicenseModel' => 'bring-your-own-license', 'MasterUsername' => 'admin', 'OptionGroupName' => 'default:oracle-se2-12-1', 'Port' => 1521, 'Region' => 'us-east-1', 'RestoreWindow' => [ 'EarliestTime' => '2020-12-07T21:05:20.939Z', 'LatestTime' => '2020-12-07T21:05:20.939Z', ], 'Status' => 'replicating', 'StorageType' => 'gp2', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example displays details about the automated backups for the specified DB instance. The details include replicated automated backups in other AWS Regions.', 'id' => 'to-describe-the-automated-backups-for-a-db-instance-1680217198750', 'title' => 'To describe the automated backups for a DB instance', ], ], 'DescribeDBInstances' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'mydbinstancecf', ], 'output' => [ 'DBInstances' => [ [ 'DBInstanceClass' => 'db.t3.small', 'DBInstanceIdentifier' => 'mydbinstancecf', 'DBInstanceStatus' => 'available', 'Endpoint' => [ 'Address' => 'mydbinstancecf.abcexample.us-east-1.rds.amazonaws.com', 'HostedZoneId' => 'Z2R2ITUGPM61AM', 'Port' => 3306, ], 'Engine' => 'mysql', 'MasterUsername' => 'admin', ], ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBInstances' => 'Some output ommitted.', ], ], 'description' => 'The following example retrieves details about the specified DB instance.', 'id' => 'to-describe-a-db-instance-1680217544524', 'title' => 'To describe a DB instance', ], ], 'DescribeDBLogFiles' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'test-instance', ], 'output' => [ 'DescribeDBLogFiles' => [ [ 'LastWritten' => 1533060000000, 'LogFileName' => 'error/mysql-error-running.log', 'Size' => 0, ], [ 'LastWritten' => 1532994300000, 'LogFileName' => 'error/mysql-error-running.log.0', 'Size' => 2683, ], [ 'LastWritten' => 1533057300000, 'LogFileName' => 'error/mysql-error-running.log.18', 'Size' => 107, ], [ 'LastWritten' => 1532991000000, 'LogFileName' => 'error/mysql-error-running.log.23', 'Size' => 13105, ], [ 'LastWritten' => 1533061200000, 'LogFileName' => 'error/mysql-error.log', 'Size' => 0, ], [ 'LastWritten' => 1532989252000, 'LogFileName' => 'mysqlUpgrade', 'Size' => 3519, ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves details about the log files for the specified DB instance.', 'id' => 'to-describe-the-log-files-for-a-db-instance-1680217710149', 'title' => 'To describe the log files for a DB instance', ], ], 'DescribeDBParameterGroups' => [ [ 'input' => [], 'output' => [ 'DBParameterGroups' => [ [ 'DBParameterGroupArn' => 'arn:aws:rds:us-east-1:123456789012:pg:default.aurora-mysql5.7', 'DBParameterGroupFamily' => 'aurora-mysql5.7', 'DBParameterGroupName' => 'default.aurora-mysql5.7', 'Description' => 'Default parameter group for aurora-mysql5.7', ], [ 'DBParameterGroupArn' => 'arn:aws:rds:us-east-1:123456789012:pg:default.aurora-postgresql9.6', 'DBParameterGroupFamily' => 'aurora-postgresql9.6', 'DBParameterGroupName' => 'default.aurora-postgresql9.6', 'Description' => 'Default parameter group for aurora-postgresql9.6', ], [ 'DBParameterGroupArn' => 'arn:aws:rds:us-east-1:123456789012:pg:default.aurora5.6', 'DBParameterGroupFamily' => 'aurora5.6', 'DBParameterGroupName' => 'default.aurora5.6', 'Description' => 'Default parameter group for aurora5.6', ], [ 'DBParameterGroupArn' => 'arn:aws:rds:us-east-1:123456789012:pg:default.mariadb10.1', 'DBParameterGroupFamily' => 'mariadb10.1', 'DBParameterGroupName' => 'default.mariadb10.1', 'Description' => 'Default parameter group for mariadb10.1', ], ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBParameterGroups' => 'Some output ommitted.', ], ], 'description' => 'The following example retrieves details about your DB parameter groups.', 'id' => 'to-describe-your-db-parameter-groups-1680279250598', 'title' => 'To describe your DB parameter groups', ], ], 'DescribeDBParameters' => [ [ 'input' => [ 'DBParameterGroupName' => 'mydbpg', ], 'output' => [ 'Parameters' => [ [ 'AllowedValues' => '0,1', 'ApplyMethod' => 'pending-reboot', 'ApplyType' => 'static', 'DataType' => 'boolean', 'Description' => 'Controls whether user-defined functions that have only an xxx symbol for the main function can be loaded', 'IsModifiable' => false, 'ParameterName' => 'allow-suspicious-udfs', 'Source' => 'engine-default', ], [ 'AllowedValues' => '0,1', 'ApplyMethod' => 'pending-reboot', 'ApplyType' => 'static', 'DataType' => 'boolean', 'Description' => 'Controls whether the server autogenerates SSL key and certificate files in the data directory, if they do not already exist.', 'IsModifiable' => false, 'ParameterName' => 'auto_generate_certs', 'Source' => 'engine-default', ], ], ], 'comments' => [ 'input' => [], 'output' => [ 'Parameters' => 'Some output omitted.', ], ], 'description' => 'The following example retrieves the details of the specified DB parameter group.', 'id' => 'to-describe-the-parameters-in-a-db-parameter-group-1680279500600', 'title' => 'To describe the parameters in a DB parameter group', ], ], 'DescribeDBSecurityGroups' => [ [ 'input' => [ 'DBSecurityGroupName' => 'mydbsecuritygroup', ], 'output' => [], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'This example lists settings for the specified security group.', 'id' => 'describe-db-security-groups-66fe9ea1-17dd-4275-b82e-f771cee0c849', 'title' => 'To list DB security group settings', ], ], 'DescribeDBSnapshotAttributes' => [ [ 'input' => [ 'DBSnapshotIdentifier' => 'mydbsnapshot', ], 'output' => [ 'DBSnapshotAttributesResult' => [ 'DBSnapshotAttributes' => [ [ 'AttributeName' => 'restore', 'AttributeValues' => [ '123456789012', '210987654321', ], ], ], 'DBSnapshotIdentifier' => 'mydbsnapshot', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example describes the attribute names and values for a DB snapshot.', 'id' => 'to-describe-the-attribute-names-and-values-for-a-db-snapshot-1680280194370', 'title' => 'To describe the attribute names and values for a DB snapshot', ], ], 'DescribeDBSnapshots' => [ [ 'input' => [ 'DBSnapshotIdentifier' => 'mydbsnapshot', ], 'output' => [ 'DBSnapshots' => [ [ 'AllocatedStorage' => 20, 'AvailabilityZone' => 'us-east-1f', 'DBInstanceIdentifier' => 'mysqldb', 'DBSnapshotArn' => 'arn:aws:rds:us-east-1:123456789012:snapshot:mydbsnapshot', 'DBSnapshotIdentifier' => 'mydbsnapshot', 'DbiResourceId' => 'db-AKIAIOSFODNN7EXAMPLE', 'Encrypted' => false, 'Engine' => 'mysql', 'EngineVersion' => '5.6.37', 'IAMDatabaseAuthenticationEnabled' => false, 'InstanceCreateTime' => '2018-02-08T22:24:55.973Z', 'LicenseModel' => 'general-public-license', 'MasterUsername' => 'mysqladmin', 'OptionGroupName' => 'default:mysql-5-6', 'PercentProgress' => 100, 'Port' => 3306, 'ProcessorFeatures' => [], 'SnapshotCreateTime' => '2018-02-08T22:28:08.598Z', 'SnapshotType' => 'manual', 'Status' => 'available', 'StorageType' => 'gp2', 'VpcId' => 'vpc-6594f31c', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves the details of a DB snapshot for a DB instance.', 'id' => 'to-describe-a-db-snapshot-for-a-db-instance-1680280423239', 'title' => 'To describe a DB snapshot for a DB instance', ], ], 'DescribeDBSubnetGroups' => [ [ 'input' => [], 'output' => [ 'DBSubnetGroups' => [ [ 'DBSubnetGroupArn' => 'arn:aws:rds:us-east-1:123456789012:subgrp:mydbsubnetgroup', 'DBSubnetGroupDescription' => 'My DB Subnet Group', 'DBSubnetGroupName' => 'mydbsubnetgroup', 'SubnetGroupStatus' => 'Complete', 'Subnets' => [ [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1a', ], 'SubnetIdentifier' => 'subnet-d8c8e7f4', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1f', ], 'SubnetIdentifier' => 'subnet-718fdc7d', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1a', ], 'SubnetIdentifier' => 'subnet-cbc8e7e7', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-east-1a', ], 'SubnetIdentifier' => 'subnet-0ccde220', 'SubnetStatus' => 'Active', ], ], 'VpcId' => 'vpc-971c12ee', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves the details of the specified DB subnet group.', 'id' => 'to-describe-a-db-subnet-group-1680280764611', 'title' => 'To describe a DB subnet group', ], ], 'DescribeEngineDefaultClusterParameters' => [ [ 'input' => [ 'DBParameterGroupFamily' => 'aurora-mysql5.7', ], 'output' => [ 'EngineDefaults' => [ 'Parameters' => [ [ 'ApplyType' => 'dynamic', 'DataType' => 'string', 'Description' => 'IAM role ARN used to load data from AWS S3', 'IsModifiable' => true, 'ParameterName' => 'aurora_load_from_s3_role', 'Source' => 'engine-default', 'SupportedEngineModes' => [ 'provisioned', ], ], ], ], ], 'comments' => [ 'input' => [], 'output' => [ 'EngineDefaults' => 'Some output omitted.', ], ], 'description' => 'The following example retrieves the details of the default engine and system parameter information for Aurora DB clusters with MySQL 5.7 compatibility.', 'id' => 'to-describe-the-default-engine-and-system-parameter-information-for-the-aurora-database-engine-1680280902332', 'title' => 'To describe the default engine and system parameter information for the Aurora database engine', ], ], 'DescribeEngineDefaultParameters' => [ [ 'input' => [ 'DBParameterGroupFamily' => 'mysql5.7', ], 'output' => [ 'EngineDefaults' => [ 'Parameters' => [ [ 'AllowedValues' => '0,1', 'ApplyType' => 'static', 'DataType' => 'boolean', 'Description' => 'Controls whether user-defined functions that have only an xxx symbol for the main function can be loaded', 'IsModifiable' => false, 'ParameterName' => 'allow-suspicious-udfs', 'Source' => 'engine-default', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [ 'EngineDefaults' => 'Some output omitted.', ], ], 'description' => 'The following example retrieves details for the default engine and system parameter information for MySQL 5.7 DB instances.', 'id' => 'to-describe-the-default-engine-and-system-parameter-information-for-the-database-engine-1680281248217', 'title' => 'To describe the default engine and system parameter information for the database engine', ], ], 'DescribeEventCategories' => [ [ 'input' => [ 'Filters' => [], 'SourceType' => '', ], 'output' => [ 'EventCategoriesMapList' => [ [ 'EventCategories' => [ 'deletion', 'read replica', 'failover', 'restoration', 'maintenance', 'low storage', 'configuration change', 'backup', 'creation', 'availability', 'recovery', 'failure', 'backtrack', 'notification', ], 'SourceType' => 'db-instance', ], [ 'EventCategories' => [ 'configuration change', 'failure', ], 'SourceType' => 'db-security-group', ], [ 'EventCategories' => [ 'configuration change', ], 'SourceType' => 'db-parameter-group', ], [ 'EventCategories' => [ 'deletion', 'creation', 'restoration', 'notification', ], 'SourceType' => 'db-snapshot', ], [ 'EventCategories' => [ 'failover', 'failure', 'notification', ], 'SourceType' => 'db-cluster', ], [ 'EventCategories' => [ 'backup', ], 'SourceType' => 'db-cluster-snapshot', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves details about the event categories for all available event sources.', 'id' => 'to-describe-event-categories-1680281431508', 'title' => 'To describe event categories', ], ], 'DescribeEventSubscriptions' => [ [ 'input' => [], 'output' => [ 'EventSubscriptionsList' => [ [ 'CustSubscriptionId' => 'my-instance-events', 'CustomerAwsId' => '123456789012', 'Enabled' => true, 'EventCategoriesList' => [ 'backup', 'recovery', ], 'EventSubscriptionArn' => 'arn:aws:rds:us-east-1:123456789012:es:my-instance-events', 'SnsTopicArn' => 'arn:aws:sns:us-east-1:123456789012:interesting-events', 'SourceType' => 'db-instance', 'Status' => 'creating', 'SubscriptionCreationTime' => '2018-07-31 23:22:01.893', ], ], ], 'comments' => [ 'input' => [], 'output' => [ 'EventSubscriptionsList' => 'Some output omitted.', ], ], 'description' => 'This example describes all of the Amazon RDS event subscriptions for the current AWS account.', 'id' => 'to-describe-event-subscriptions-1680281683538', 'title' => 'To describe event subscriptions', ], ], 'DescribeEvents' => [ [ 'input' => [ 'SourceIdentifier' => 'test-instance', 'SourceType' => 'db-instance', ], 'output' => [ 'Events' => [ [ 'Date' => '2018-07-31T23:09:23.983Z', 'EventCategories' => [ 'backup', ], 'Message' => 'Backing up DB instance', 'SourceArn' => 'arn:aws:rds:us-east-1:123456789012:db:test-instance', 'SourceIdentifier' => 'test-instance', 'SourceType' => 'db-instance', ], [ 'Date' => '2018-07-31T23:15:13.049Z', 'EventCategories' => [ 'backup', ], 'Message' => 'Finished DB Instance backup', 'SourceArn' => 'arn:aws:rds:us-east-1:123456789012:db:test-instance', 'SourceIdentifier' => 'test-instance', 'SourceType' => 'db-instance', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following retrieves details for the events that have occurred for the specified DB instance.', 'id' => 'to-describe-events-1680281559411', 'title' => 'To describe events', ], ], 'DescribeExportTasks' => [ [ 'input' => [], 'output' => [ 'ExportTasks' => [ [ 'ExportTaskIdentifier' => 'test-snapshot-export', 'IamRoleArn' => 'arn:aws:iam::123456789012:role/service-role/ExportRole', 'KmsKeyId' => 'arn:aws:kms:us-west-2:123456789012:key/abcd0000-7fca-4128-82f2-aabbccddeeff', 'PercentProgress' => 100, 'S3Bucket' => 'mybucket', 'S3Prefix' => '', 'SnapshotTime' => '2020-03-02T18:26:28.163Z', 'SourceArn' => 'arn:aws:rds:us-west-2:123456789012:snapshot:test-snapshot', 'Status' => 'COMPLETE', 'TaskEndTime' => '2020-03-02T19:10:31.985Z', 'TaskStartTime' => '2020-03-02T18:57:56.896Z', 'TotalExtractedDataInGB' => 0, ], [ 'ExportTaskIdentifier' => 'my-s3-export', 'IamRoleArn' => 'arn:aws:iam::123456789012:role/service-role/ExportRole', 'KmsKeyId' => 'arn:aws:kms:us-west-2:123456789012:key/abcd0000-7fca-4128-82f2-aabbccddeeff', 'PercentProgress' => 0, 'S3Bucket' => 'mybucket', 'S3Prefix' => '', 'SnapshotTime' => '2020-03-27T20:48:42.023Z', 'SourceArn' => 'arn:aws:rds:us-west-2:123456789012:snapshot:db5-snapshot-test', 'Status' => 'STARTING', 'TotalExtractedDataInGB' => 0, ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example returns information about snapshot exports to Amazon S3.', 'id' => 'to-describe-snapshot-export-tasks-1680282299489', 'title' => 'To describe snapshot export tasks', ], ], 'DescribeGlobalClusters' => [ [ 'input' => [], 'output' => [ 'GlobalClusters' => [ [ 'DeletionProtection' => false, 'Engine' => 'aurora-mysql', 'EngineVersion' => '5.7.mysql_aurora.2.07.2', 'GlobalClusterArn' => 'arn:aws:rds::123456789012:global-cluster:myglobalcluster', 'GlobalClusterIdentifier' => 'myglobalcluster', 'GlobalClusterMembers' => [], 'GlobalClusterResourceId' => 'cluster-f5982077e3b5aabb', 'Status' => 'available', 'StorageEncrypted' => false, ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example lists Aurora global DB clusters in the current AWS Region.', 'id' => 'to-describe-global-db-clusters-1680282459184', 'title' => 'To describe global DB clusters', ], ], 'DescribeIntegrations' => [ [ 'input' => [ 'IntegrationIdentifier' => '5b9f3d79-7392-4a3e-896c-58eaa1b53231', ], 'output' => [ 'Integrations' => [ [ 'CreateTime' => '2023-12-28T17:20:20.629Z', 'IntegrationArn' => 'arn:aws:rds:us-east-1:123456789012:integration:5b9f3d79-7392-4a3e-896c-58eaa1b53231', 'IntegrationName' => 'my-integration', 'KMSKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/a1b2c3d4-5678-90ab-cdef-EXAMPLEaaaaa', 'SourceArn' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-cluster', 'Status' => 'active', 'Tags' => [], 'TargetArn' => 'arn:aws:redshift-serverless:us-east-1:123456789012:namespace/62c70612-0302-4db7-8414-b5e3e049f0d8', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves information about a zero-ETL integration with Amazon Redshift.', 'id' => 'to-describe-a-zero-etl-integration-1679688377231', 'title' => 'To describe a zero-ETL integration', ], ], 'DescribeOptionGroupOptions' => [ [ 'input' => [ 'EngineName' => 'mysql', 'MajorEngineVersion' => '8.0', ], 'output' => [ 'OptionGroupOptions' => [ [ 'Description' => 'MariaDB Audit Plugin', 'EngineName' => 'mysql', 'MajorEngineVersion' => '8.0', 'MinimumRequiredMinorEngineVersion' => '25', 'Name' => 'MARIADB_AUDIT_PLUGIN', 'OptionGroupOptionSettings' => [ [ 'ApplyType' => 'DYNAMIC', 'IsModifiable' => true, 'IsRequired' => false, 'MinimumEngineVersionPerAllowedValue' => [], 'SettingDescription' => 'Include specified users', 'SettingName' => 'SERVER_AUDIT_INCL_USERS', ], [ 'ApplyType' => 'DYNAMIC', 'IsModifiable' => true, 'IsRequired' => false, 'MinimumEngineVersionPerAllowedValue' => [], 'SettingDescription' => 'Exclude specified users', 'SettingName' => 'SERVER_AUDIT_EXCL_USERS', ], ], 'OptionsConflictsWith' => [], 'OptionsDependedOn' => [], 'Permanent' => false, 'Persistent' => false, 'PortRequired' => false, 'RequiresAutoMinorEngineVersionUpgrade' => false, 'VpcOnly' => false, ], ], ], 'comments' => [ 'input' => [], 'output' => [ 'OptionGroupOptions' => 'Some output omitted.', ], ], 'description' => 'The following example lists the options for an RDS for MySQL version 8.0 DB instance.', 'id' => 'to-describe-all-available-options-1680286049492', 'title' => 'To describe all available options', ], ], 'DescribeOptionGroups' => [ [ 'input' => [ 'EngineName' => 'oracle-ee', 'MajorEngineVersion' => '19', ], 'output' => [ 'OptionGroupsList' => [ [ 'AllowsVpcAndNonVpcInstanceMemberships' => true, 'EngineName' => 'oracle-ee', 'MajorEngineVersion' => '19', 'OptionGroupArn' => 'arn:aws:rds:us-west-1:111122223333:og:default:oracle-ee-19', 'OptionGroupDescription' => 'Default option group for oracle-ee 19', 'OptionGroupName' => 'default:oracle-ee-19', 'Options' => [], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example lists the options groups for an Oracle Database 19c instance.', 'id' => 'to-describe-the-available-option-groups-1680283066000', 'title' => 'To describe the available option groups', ], ], 'DescribeOrderableDBInstanceOptions' => [ [ 'input' => [ 'Engine' => 'mysql', ], 'output' => [ 'OrderableDBInstanceOptions' => [ [ 'AvailabilityZones' => [ [ 'Name' => 'us-east-1a', ], [ 'Name' => 'us-east-1b', ], [ 'Name' => 'us-east-1c', ], [ 'Name' => 'us-east-1d', ], [ 'Name' => 'us-east-1e', ], [ 'Name' => 'us-east-1f', ], ], 'DBInstanceClass' => 'db.m4.10xlarge', 'Engine' => 'mysql', 'EngineVersion' => '5.7.33', 'LicenseModel' => 'general-public-license', 'MultiAZCapable' => true, 'ReadReplicaCapable' => true, 'StorageType' => 'gp2', 'SupportsStorageEncryption' => true, 'Vpc' => true, ], ], ], 'comments' => [ 'input' => [], 'output' => [ 'OrderableDBInstanceOptions' => 'Some output omitted.', ], ], 'description' => 'The following example retrieves details about the orderable options for a DB instances running the MySQL DB engine.', 'id' => 'to-describe-orderable-db-instance-options-1680283253165', 'title' => 'To describe orderable DB instance options', ], ], 'DescribePendingMaintenanceActions' => [ [ 'input' => [], 'output' => [ 'PendingMaintenanceActions' => [ [ 'PendingMaintenanceActionDetails' => [ [ 'Action' => 'system-update', 'Description' => 'Upgrade to Aurora PostgreSQL 2.4.2', ], ], 'ResourceIdentifier' => 'arn:aws:rds:us-west-2:123456789012:cluster:global-db1-cl1', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example lists the pending maintenace action for a DB instance.', 'id' => 'to-list-resources-with-at-least-one-pending-maintenance-action-1680283544475', 'title' => 'To list resources with at least one pending maintenance action', ], ], 'DescribeReservedDBInstances' => [ [ 'input' => [], 'output' => [ 'ReservedDBInstances' => [ [ 'CurrencyCode' => 'USD', 'DBInstanceClass' => 'db.t3.micro', 'DBInstanceCount' => 1, 'Duration' => 31536000, 'FixedPrice' => 0, 'LeaseId' => 'a1b2c3d4-6b69-4a59-be89-5e11aa446666', 'MultiAZ' => false, 'OfferingType' => 'No Upfront', 'ProductDescription' => 'sqlserver-ex(li)', 'RecurringCharges' => [ [ 'RecurringChargeAmount' => 0.014, 'RecurringChargeFrequency' => 'Hourly', ], ], 'ReservedDBInstanceArn' => 'arn:aws:rds:us-west-2:123456789012:ri:myreservedinstance', 'ReservedDBInstanceId' => 'myreservedinstance', 'ReservedDBInstancesOfferingId' => '12ab34cd-59af-4b2c-a660-1abcdef23456', 'StartTime' => '2020-06-01T13:44:21.436Z', 'State' => 'payment-pending', 'UsagePrice' => 0, ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves details about any reserved DB instances in the current AWS account.', 'id' => 'to-describe-reserved-db-instances-1680283668105', 'title' => 'To describe reserved DB instances', ], ], 'DescribeReservedDBInstancesOfferings' => [ [ 'input' => [ 'ProductDescription' => 'oracle', ], 'output' => [ 'ReservedDBInstancesOfferings' => [ [ 'CurrencyCode' => 'USD', 'DBInstanceClass' => 'db.m4.xlarge', 'Duration' => 31536000, 'FixedPrice' => 4089, 'MultiAZ' => true, 'OfferingType' => 'Partial Upfront', 'ProductDescription' => 'oracle-se2(li)', 'RecurringCharges' => [ [ 'RecurringChargeAmount' => 0.594, 'RecurringChargeFrequency' => 'Hourly', ], ], 'ReservedDBInstancesOfferingId' => '005bdee3-9ef4-4182-aa0c-58ef7cb6c2f8', 'UsagePrice' => 0, ], ], ], 'comments' => [ 'input' => [], 'output' => [ 'ReservedDBInstancesOfferings' => 'Some output omitted.', ], ], 'description' => 'The following example retrieves details about reserved DB instance options for RDS for Oracle.', 'id' => 'to-describe-reserved-db-instance-offerings-1680283755054', 'title' => 'To describe reserved DB instance offerings', ], ], 'DescribeSourceRegions' => [ [ 'input' => [ 'RegionName' => 'us-east-1', ], 'output' => [ 'SourceRegions' => [ [ 'Endpoint' => 'https://rds.af-south-1.amazonaws.com', 'RegionName' => 'af-south-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => false, ], [ 'Endpoint' => 'https://rds.ap-east-1.amazonaws.com', 'RegionName' => 'ap-east-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => false, ], [ 'Endpoint' => 'https://rds.ap-northeast-1.amazonaws.com', 'RegionName' => 'ap-northeast-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.ap-northeast-2.amazonaws.com', 'RegionName' => 'ap-northeast-2', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.ap-northeast-3.amazonaws.com', 'RegionName' => 'ap-northeast-3', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => false, ], [ 'Endpoint' => 'https://rds.ap-south-1.amazonaws.com', 'RegionName' => 'ap-south-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.ap-southeast-1.amazonaws.com', 'RegionName' => 'ap-southeast-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.ap-southeast-2.amazonaws.com', 'RegionName' => 'ap-southeast-2', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.ap-southeast-3.amazonaws.com', 'RegionName' => 'ap-southeast-3', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => false, ], [ 'Endpoint' => 'https://rds.ca-central-1.amazonaws.com', 'RegionName' => 'ca-central-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.eu-north-1.amazonaws.com', 'RegionName' => 'eu-north-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.eu-south-1.amazonaws.com', 'RegionName' => 'eu-south-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => false, ], [ 'Endpoint' => 'https://rds.eu-west-1.amazonaws.com', 'RegionName' => 'eu-west-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.eu-west-2.amazonaws.com', 'RegionName' => 'eu-west-2', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.eu-west-3.amazonaws.com', 'RegionName' => 'eu-west-3', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.me-central-1.amazonaws.com', 'RegionName' => 'me-central-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => false, ], [ 'Endpoint' => 'https://rds.me-south-1.amazonaws.com', 'RegionName' => 'me-south-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => false, ], [ 'Endpoint' => 'https://rds.sa-east-1.amazonaws.com', 'RegionName' => 'sa-east-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.us-east-2.amazonaws.com', 'RegionName' => 'us-east-2', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.us-west-1.amazonaws.com', 'RegionName' => 'us-west-1', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], [ 'Endpoint' => 'https://rds.us-west-2.amazonaws.com', 'RegionName' => 'us-west-2', 'Status' => 'available', 'SupportsDBInstanceAutomatedBackupsReplication' => true, ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example retrieves details about all source AWS Regions where the current AWS Region can create a read replica, copy a DB snapshot from, or replicate automated backups from. It also shows that automated backups can be replicated only from US West (Oregon) to the destination AWS Region, US East (N. Virginia).', 'id' => 'to-describe-source-regions-1680283924227', 'title' => 'To describe source Regions', ], ], 'DescribeValidDBInstanceModifications' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'database-test1', ], 'output' => [ 'ValidDBInstanceModificationsMessage' => [ 'Storage' => [ [ 'StorageSize' => [ [ 'From' => 20, 'Step' => 1, 'To' => 20, ], [ 'From' => 22, 'Step' => 1, 'To' => 6144, ], ], 'StorageType' => 'gp2', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [ 'ValidDBInstanceModificationsMessage' => 'Some output omitted.', ], ], 'description' => 'The following example retrieves details about the valid modifications for the specified DB instance.', 'id' => 'to-describe-valid-modifications-for-a-db-instance-1680284230997', 'title' => 'To describe valid modifications for a DB instance', ], ], 'DownloadDBLogFilePortion' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'test-instance', 'LogFileName' => 'log.txt', ], 'output' => [], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example downloads only the latest part of your log file.', 'id' => 'to-download-a-db-log-file-1680284895898', 'title' => 'To download a DB log file', ], ], 'FailoverDBCluster' => [ [ 'input' => [ 'DBClusterIdentifier' => 'myaurorainstance-cluster', 'TargetDBInstanceIdentifier' => 'myaurorareplica', ], 'output' => [ 'DBCluster' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'This example performs a failover for the specified DB cluster to the specified DB instance.', 'id' => 'failover-db-cluster-9e7f2f93-d98c-42c7-bb0e-d6c485c096d6', 'title' => 'To perform a failover for a DB cluster', ], ], 'ListTagsForResource' => [ [ 'input' => [ 'ResourceName' => 'arn:aws:rds:us-east-1:123456789012:db:orcl1', ], 'output' => [ 'TagList' => [ [ 'Key' => 'Environment', 'Value' => 'test', ], [ 'Key' => 'Name', 'Value' => 'MyDatabase', ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example lists all tags on a DB instance.', 'id' => 'to-list-tags-on-an-amazon-rds-resource-1680285113240', 'title' => 'To list tags on an Amazon RDS resource', ], ], 'ModifyCertificates' => [ [ 'input' => [ 'CertificateIdentifier' => 'rds-ca-2019', ], 'output' => [ 'Certificate' => [ 'CertificateArn' => 'arn:aws:rds:us-east-1::cert:rds-ca-2019', 'CertificateIdentifier' => 'rds-ca-2019', 'CertificateType' => 'CA', 'CustomerOverride' => true, 'CustomerOverrideValidTill' => '2024-08-22T17:08:50Z', 'Thumbprint' => 'EXAMPLE123456789012', 'ValidFrom' => '2019-09-19T18:16:53Z', 'ValidTill' => '2024-08-22T17:08:50Z', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example temporarily overrides the system-default SSL/TLS certificate for new DB instances.', 'id' => 'to-temporarily-override-the-system-default-ssltls-certificate-for-new-db-instances-1680306491984', 'title' => 'To temporarily override the system-default SSL/TLS certificate for new DB instances', ], ], 'ModifyCurrentDBClusterCapacity' => [ [ 'input' => [ 'Capacity' => 8, 'DBClusterIdentifier' => 'mydbcluster', ], 'output' => [ 'CurrentCapacity' => 1, 'DBClusterIdentifier' => 'mydbcluster', 'PendingCapacity' => 8, 'SecondsBeforeTimeout' => 300, 'TimeoutAction' => 'ForceApplyCapacityChange', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example scales the capacity of an Aurora Serverless DB cluster to 8.', 'id' => 'to-scale-the-capacity-of-an-aurora-serverless-db-cluster-1680307179599', 'title' => 'To scale the capacity of an Aurora Serverless DB cluster', ], ], 'ModifyDBCluster' => [ [ 'input' => [ 'ApplyImmediately' => true, 'BackupRetentionPeriod' => 14, 'DBClusterIdentifier' => 'cluster-2', 'MasterUserPassword' => 'newpassword99', ], 'output' => [ 'DBCluster' => [ 'AllocatedStorage' => 1, 'AssociatedRoles' => [], 'AvailabilityZones' => [ 'eu-central-1b', 'eu-central-1c', 'eu-central-1a', ], 'BackupRetentionPeriod' => 14, 'ClusterCreateTime' => '2020-04-03T14:44:02.764Z', 'CopyTagsToSnapshot' => true, 'CrossAccountClone' => false, 'DBClusterArn' => 'arn:aws:rds:eu-central-1:123456789012:cluster:cluster-2', 'DBClusterIdentifier' => 'cluster-2', 'DBClusterMembers' => [ [ 'DBClusterParameterGroupStatus' => 'in-sync', 'DBInstanceIdentifier' => 'cluster-2-instance-1', 'IsClusterWriter' => true, 'PromotionTier' => 1, ], ], 'DBClusterParameterGroup' => 'default.aurora5.6', 'DBSubnetGroup' => 'default-vpc-2305ca49', 'DatabaseName' => '', 'DbClusterResourceId' => 'cluster-AGJ7XI77XVIS6FUXHU1EXAMPLE', 'DeletionProtection' => false, 'DomainMemberships' => [], 'EarliestRestorableTime' => '2020-06-03T02:07:29.637Z', 'Endpoint' => 'cluster-2.cluster-############.eu-central-1.rds.amazonaws.com', 'Engine' => 'aurora', 'EngineMode' => 'provisioned', 'EngineVersion' => '5.6.10a', 'HostedZoneId' => 'Z1RLNU0EXAMPLE', 'HttpEndpointEnabled' => false, 'IAMDatabaseAuthenticationEnabled' => false, 'KmsKeyId' => 'arn:aws:kms:eu-central-1:123456789012:key/d1bd7c8f-5cdb-49ca-8a62-a1b2c3d4e5f6', 'LatestRestorableTime' => '2020-06-04T15:11:25.748Z', 'MasterUsername' => 'admin', 'MultiAZ' => false, 'Port' => 3306, 'PreferredBackupWindow' => '01:55-02:25', 'PreferredMaintenanceWindow' => 'thu:21:14-thu:21:44', 'ReadReplicaIdentifiers' => [], 'ReaderEndpoint' => 'cluster-2.cluster-ro-############.eu-central-1.rds.amazonaws.com', 'Status' => 'available', 'StorageEncrypted' => true, 'VpcSecurityGroups' => [ [ 'Status' => 'active', 'VpcSecurityGroupId' => 'sg-20a5c047', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example changes the master user password for the DB cluster named cluster-2 and sets the backup retention period to 14 days. The ApplyImmediately parameter causes the changes to be made immediately, instead of waiting until the next maintenance window.', 'id' => 'to-modify-a-db-cluster-1680310823999', 'title' => 'To modify a DB cluster', ], ], 'ModifyDBClusterEndpoint' => [ [ 'input' => [ 'DBClusterEndpointIdentifier' => 'mycustomendpoint', 'StaticMembers' => [ 'dbinstance1', 'dbinstance2', 'dbinstance3', ], ], 'output' => [ 'CustomEndpointType' => 'READER', 'DBClusterEndpointArn' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:mycustomendpoint', 'DBClusterEndpointIdentifier' => 'mycustomendpoint', 'DBClusterEndpointResourceIdentifier' => 'cluster-endpoint-ANPAJ4AE5446DAEXAMPLE', 'DBClusterIdentifier' => 'mydbcluster', 'Endpoint' => 'mycustomendpoint.cluster-custom-cnpexample.us-east-1.rds.amazonaws.com', 'EndpointType' => 'CUSTOM', 'ExcludedMembers' => [], 'StaticMembers' => [ 'dbinstance1', 'dbinstance2', 'dbinstance3', ], 'Status' => 'modifying', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example modifies the specified custom DB cluster endpoint.', 'id' => 'to-modify-a-custom-db-cluster-endpoint-1680307652958', 'title' => 'To modify a custom DB cluster endpoint', ], ], 'ModifyDBClusterParameterGroup' => [ [ 'input' => [ 'DBClusterParameterGroupName' => 'mydbclusterpg', 'Parameters' => [ [ 'ApplyMethod' => 'immediate', 'ParameterName' => 'server_audit_logging', 'ParameterValue' => '1', ], [ 'ApplyMethod' => 'immediate', 'ParameterName' => 'server_audit_logs_upload', 'ParameterValue' => '1', ], ], ], 'output' => [ 'DBClusterParameterGroupName' => 'mydbclusterpg', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example modifies the values of parameters in a DB cluster parameter group.', 'id' => 'to-modify-parameters-in-a-db-cluster-parameter-group-1680377584537', 'title' => 'To modify parameters in a DB cluster parameter group', ], ], 'ModifyDBClusterSnapshotAttribute' => [ [ 'input' => [ 'AttributeName' => 'restore', 'DBClusterSnapshotIdentifier' => 'myclustersnapshot', 'ValuesToAdd' => [ '123456789012', ], ], 'output' => [ 'DBClusterSnapshotAttributesResult' => [ 'DBClusterSnapshotAttributes' => [ [ 'AttributeName' => 'restore', 'AttributeValues' => [ '123456789012', ], ], ], 'DBClusterSnapshotIdentifier' => 'myclustersnapshot', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example makes changes to the specified DB cluster snapshot attribute.', 'id' => 'to-modify-a-db-cluster-snapshot-attribute-1680310358770', 'title' => 'To modify a DB cluster snapshot attribute', ], ], 'ModifyDBInstance' => [ [ 'input' => [ 'ApplyImmediately' => true, 'DBInstanceIdentifier' => 'database-2', 'DBParameterGroupName' => 'test-sqlserver-se-2017', 'OptionGroupName' => 'test-se-2017', ], 'output' => [ 'DBInstance' => [ 'AssociatedRoles' => [], 'AutoMinorVersionUpgrade' => false, 'AvailabilityZone' => 'us-west-2d', 'CharacterSetName' => 'SQL_Latin1_General_CP1_CI_AS', 'DBInstanceClass' => 'db.r4.large', 'DBInstanceIdentifier' => 'database-2', 'DBInstanceStatus' => 'available', 'DBParameterGroups' => [ [ 'DBParameterGroupName' => 'test-sqlserver-se-2017', 'ParameterApplyStatus' => 'applying', ], ], 'DeletionProtection' => false, 'Engine' => 'sqlserver-se', 'EngineVersion' => '14.00.3281.6.v1', 'LicenseModel' => 'license-included', 'MaxAllocatedStorage' => 1000, 'MultiAZ' => true, 'OptionGroupMemberships' => [ [ 'OptionGroupName' => 'test-se-2017', 'Status' => 'pending-apply', ], ], 'PubliclyAccessible' => true, 'ReadReplicaDBInstanceIdentifiers' => [], 'SecondaryAvailabilityZone' => 'us-west-2c', 'StorageType' => 'gp2', ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBInstance' => 'Some output ommitted.', ], ], 'description' => 'The following example associates an option group and a parameter group with a compatible Microsoft SQL Server DB instance. The ApplyImmediately parameter causes the option and parameter groups to be associated immediately, instead of waiting until the next maintenance window.', 'id' => 'to-modify-a-db-instance-1680377584537', 'title' => 'To modify a DB instance', ], ], 'ModifyDBParameterGroup' => [ [ 'input' => [ 'DBParameterGroupName' => 'test-sqlserver-se-2017', 'Parameters' => [ [ 'ApplyMethod' => 'immediate', 'ParameterName' => 'clr enabled', 'ParameterValue' => '1', ], ], ], 'output' => [ 'DBParameterGroupName' => 'test-sqlserver-se-2017', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example changes the value of the clr enabled parameter in a DB parameter group. The value of the ApplyMethod parameter causes the DB parameter group to be modified immediately, instead of waiting until the next maintenance window.', 'id' => 'to-modify-a-db-parameter-group-1680382937235', 'title' => 'To modify a DB parameter group', ], ], 'ModifyDBSnapshot' => [ [ 'input' => [ 'DBSnapshotIdentifier' => 'db5-snapshot-upg-test', 'EngineVersion' => '11.7', ], 'output' => [ 'DBSnapshot' => [ 'AllocatedStorage' => 20, 'AvailabilityZone' => 'us-west-2a', 'DBInstanceIdentifier' => 'database-5', 'DBSnapshotArn' => 'arn:aws:rds:us-west-2:123456789012:snapshot:db5-snapshot-upg-test', 'DBSnapshotIdentifier' => 'db5-snapshot-upg-test', 'DbiResourceId' => 'db-GJMF75LM42IL6BTFRE4UZJ5YM4', 'Encrypted' => false, 'Engine' => 'postgres', 'EngineVersion' => '10.6', 'IAMDatabaseAuthenticationEnabled' => false, 'InstanceCreateTime' => '2020-03-27T19:59:04.735Z', 'LicenseModel' => 'postgresql-license', 'MasterUsername' => 'postgres', 'OptionGroupName' => 'default:postgres-11', 'PercentProgress' => 100, 'Port' => 5432, 'ProcessorFeatures' => [], 'SnapshotCreateTime' => '2020-03-27T20:49:17.092Z', 'SnapshotType' => 'manual', 'Status' => 'upgrading', 'StorageType' => 'gp2', 'VpcId' => 'vpc-2ff27557', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example upgrades a PostgeSQL 10.6 snapshot named db5-snapshot-upg-test to PostgreSQL 11.7. The new DB engine version is shown after the snapshot has finished upgrading and its status is available.', 'id' => 'to-modify-a-db-snapshot-1680381968028', 'title' => 'To modify a DB snapshot', ], ], 'ModifyDBSnapshotAttribute' => [ [ 'input' => [ 'AttributeName' => 'restore', 'DBSnapshotIdentifier' => 'mydbsnapshot', 'ValuesToAdd' => [ '111122223333', '444455556666', ], ], 'output' => [ 'DBSnapshotAttributesResult' => [ 'DBSnapshotAttributes' => [ [ 'AttributeName' => 'restore', 'AttributeValues' => [ '111122223333', '444455556666', ], ], ], 'DBSnapshotIdentifier' => 'mydbsnapshot', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example grants permission to two AWS accounts, with the identifiers 111122223333 and 444455556666, to restore the DB snapshot named mydbsnapshot.', 'id' => 'to-allow-two-aws-accounts-to-restore-a-db-snapshot-1680389647513', 'title' => 'To allow two AWS accounts to restore a DB snapshot', ], [ 'input' => [ 'AttributeName' => 'restore', 'DBSnapshotIdentifier' => 'mydbsnapshot', 'ValuesToRemove' => [ '444455556666', ], ], 'output' => [ 'DBSnapshotAttributesResult' => [ 'DBSnapshotAttributes' => [ [ 'AttributeName' => 'restore', 'AttributeValues' => [ '111122223333', ], ], ], 'DBSnapshotIdentifier' => 'mydbsnapshot', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example removes permission from the AWS account with the identifier 444455556666 to restore the DB snapshot named mydbsnapshot.', 'id' => 'to-prevent-an-aws-account-from-restoring-a-db-snapshot-1680389850879', 'title' => 'To prevent an AWS account from restoring a DB snapshot', ], ], 'ModifyDBSubnetGroup' => [ [ 'input' => [ 'DBSubnetGroupDescription' => '', 'DBSubnetGroupName' => 'mysubnetgroup', 'SubnetIds' => [ 'subnet-0a1dc4e1a6f123456', 'subnet-070dd7ecb3aaaaaaa', 'subnet-00f5b198bc0abcdef', 'subnet-08e41f9e230222222', ], ], 'output' => [ 'DBSubnetGroup' => [ 'DBSubnetGroupArn' => 'arn:aws:rds:us-west-2:123456789012:subgrp:mysubnetgroup', 'DBSubnetGroupDescription' => 'test DB subnet group', 'DBSubnetGroupName' => 'mysubnetgroup', 'SubnetGroupStatus' => 'Complete', 'Subnets' => [ [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2a', ], 'SubnetIdentifier' => 'subnet-08e41f9e230222222', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2b', ], 'SubnetIdentifier' => 'subnet-070dd7ecb3aaaaaaa', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2d', ], 'SubnetIdentifier' => 'subnet-00f5b198bc0abcdef', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2b', ], 'SubnetIdentifier' => 'subnet-0a1dc4e1a6f123456', 'SubnetStatus' => 'Active', ], ], 'VpcId' => 'vpc-0f08e7610a1b2c3d4', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example adds a subnet with the ID subnet-08e41f9e230222222 to the DB subnet group named mysubnetgroup. To keep the existing subnets in the subnet group, include their IDs as values in the --subnet-ids option. Make sure to have subnets with at least two different Availability Zones in the DB subnet group.', 'id' => 'to-modify-a-db-subnet-group-1680383300785', 'title' => 'To modify a DB subnet group', ], ], 'ModifyEventSubscription' => [ [ 'input' => [ 'Enabled' => false, 'SubscriptionName' => 'my-instance-events', ], 'output' => [ 'EventSubscription' => [ 'CustSubscriptionId' => 'my-instance-events', 'CustomerAwsId' => '123456789012', 'Enabled' => false, 'EventCategoriesList' => [ 'backup', 'recovery', ], 'EventSubscriptionArn' => 'arn:aws:rds:us-east-1:123456789012:es:my-instance-events', 'SnsTopicArn' => 'arn:aws:sns:us-east-1:123456789012:interesting-events', 'SourceType' => 'db-instance', 'Status' => 'modifying', 'SubscriptionCreationTime' => 'Tue Jul 31 23:22:01 UTC 2018', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example turns off the specified event subscription, so that it no longer publishes notifications to the specified Amazon Simple Notification Service topic.', 'id' => 'to-modify-an-event-subscription-1680383930434', 'title' => 'To modify an event subscription', ], ], 'ModifyGlobalCluster' => [ [ 'input' => [ 'DeletionProtection' => true, 'GlobalClusterIdentifier' => 'myglobalcluster', ], 'output' => [ 'GlobalCluster' => [ 'DeletionProtection' => true, 'Engine' => 'aurora-mysql', 'EngineVersion' => '5.7.mysql_aurora.2.07.2', 'GlobalClusterArn' => 'arn:aws:rds::123456789012:global-cluster:myglobalcluster', 'GlobalClusterIdentifier' => 'myglobalcluster', 'GlobalClusterMembers' => [], 'GlobalClusterResourceId' => 'cluster-f0e523bfe07aabb', 'Status' => 'available', 'StorageEncrypted' => false, ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example enables deletion protection for an Aurora MySQL-based global database cluster.', 'id' => 'to-modify-a-global-database-cluster-1680385137511', 'title' => 'To modify a global database cluster', ], ], 'ModifyIntegration' => [ [ 'input' => [ 'IntegrationIdentifier' => 'a1b2c3d4-5678-90ab-cdef-EXAMPLE11111', 'IntegrationName' => 'my-renamed-integration', ], 'output' => [ 'CreateTime' => '2023-12-28T17:20:20.629Z', 'DataFilter' => 'include: *.*', 'IntegrationArn' => 'arn:aws:rds:us-east-1:123456789012:integration:5b9f3d79-7392-4a3e-896c-58eaa1b53231', 'IntegrationName' => 'my-renamed-integration', 'KMSKeyId' => 'arn:aws:kms:us-east-1:123456789012:key/a1b2c3d4-5678-90ab-cdef-EXAMPLEaaaaa', 'SourceArn' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-cluster', 'Status' => 'active', 'Tags' => [], 'TargetArn' => 'arn:aws:redshift-serverless:us-east-1:123456789012:namespace/62c70612-0302-4db7-8414-b5e3e049f0d8', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example modifies the name of an existing zero-ETL integration.', 'id' => 'to-modify-a-zero-etl-integration-1680407173998', 'title' => 'To modify a zero-ETL integration', ], ], 'ModifyOptionGroup' => [ [ 'input' => [ 'ApplyImmediately' => true, 'OptionGroupName' => 'myawsuser-og02', 'OptionsToInclude' => [ [ 'DBSecurityGroupMemberships' => [ 'default', ], 'OptionName' => 'MEMCACHED', ], ], ], 'output' => [ 'OptionGroup' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example adds an option to an option group.', 'id' => 'to-modify-an-option-group-1473890247875', 'title' => 'To modify an option group', ], ], 'PromoteReadReplica' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'test-instance-repl', ], 'output' => [ 'DBInstance' => [ 'DBInstanceArn' => 'arn:aws:rds:us-east-1:123456789012:db:test-instance-repl', 'DBInstanceStatus' => 'modifying', 'ReadReplicaSourceDBInstanceIdentifier' => 'test-instance', 'StorageType' => 'standard', ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBInstance' => 'Some output ommitted.', ], ], 'description' => 'The following example promotes the specified read replica to become a standalone DB instance.', 'id' => 'to-promote-a-read-replica-1680263877808', 'title' => 'To promote a read replica', ], ], 'PurchaseReservedDBInstancesOffering' => [ [ 'input' => [ 'ReservedDBInstanceId' => '8ba30be1-b9ec-447f-8f23-6114e3f4c7b4', 'ReservedDBInstancesOfferingId' => '', ], 'output' => [ 'ReservedDBInstance' => [ 'CurrencyCode' => 'USD', 'DBInstanceClass' => 'db.t2.micro', 'DBInstanceCount' => 1, 'Duration' => 31536000, 'FixedPrice' => 51, 'MultiAZ' => false, 'OfferingType' => 'Partial Upfront', 'ProductDescription' => 'mysql', 'RecurringCharges' => [ [ 'RecurringChargeAmount' => 0.006, 'RecurringChargeFrequency' => 'Hourly', ], ], 'ReservedDBInstanceArn' => 'arn:aws:rds:us-west-2:123456789012:ri:ri-2020-06-29-16-54-57-670', 'ReservedDBInstanceId' => 'ri-2020-06-29-16-54-57-670', 'ReservedDBInstancesOfferingId' => '8ba30be1-b9ec-447f-8f23-6114e3f4c7b4', 'StartTime' => '2020-06-29T16:54:57.670Z', 'State' => 'payment-pending', 'UsagePrice' => 0, ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example shows how to buy the reserved DB instance offering from the previous example.', 'id' => 'to-purchase-a-reserved-db-instance-1680263732858', 'title' => 'To purchase a reserved DB instance', ], ], 'RebootDBInstance' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'test-mysql-instance', ], 'output' => [ 'DBInstance' => [ 'DBInstanceClass' => 'db.t3.micro', 'DBInstanceIdentifier' => 'test-mysql-instance', 'DBInstanceStatus' => 'rebooting', 'Endpoint' => [ 'Address' => 'test-mysql-instance.############.us-west-2.rds.amazonaws.com', 'HostedZoneId' => 'Z1PVIF0EXAMPLE', 'Port' => 3306, ], 'Engine' => 'mysql', 'MasterUsername' => 'admin', ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBInstance' => 'Some output ommitted.', ], ], 'description' => 'The following example starts a reboot of the specified DB instance.', 'id' => 'to-reboot-a-db-instance-1680072870190', 'title' => 'To reboot a DB instance', ], ], 'RemoveFromGlobalCluster' => [ [ 'input' => [ 'DbClusterIdentifier' => 'arn:aws:rds:us-west-2:123456789012:cluster:DB-1', 'GlobalClusterIdentifier' => 'myglobalcluster', ], 'output' => [ 'GlobalCluster' => [ 'DeletionProtection' => false, 'Engine' => 'aurora-postgresql', 'EngineVersion' => '10.11', 'GlobalClusterArn' => 'arn:aws:rds::123456789012:global-cluster:myglobalcluster', 'GlobalClusterIdentifier' => 'myglobalcluster', 'GlobalClusterMembers' => [ [ 'DBClusterArn' => 'arn:aws:rds:us-east-1:123456789012:cluster:js-global-cluster', 'IsWriter' => true, 'Readers' => [ 'arn:aws:rds:us-west-2:123456789012:cluster:DB-1', ], ], [ 'DBClusterArn' => 'arn:aws:rds:us-west-2:123456789012:cluster:DB-1', 'GlobalWriteForwardingStatus' => 'disabled', 'IsWriter' => false, 'Readers' => [], ], ], 'GlobalClusterResourceId' => 'cluster-abc123def456gh', 'Status' => 'available', 'StorageEncrypted' => true, ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example detaches an Aurora secondary cluster from an Aurora global database cluster. The cluster changes from being read-only to a standalone cluster with read-write capability.', 'id' => 'to-detach-an-aurora-secondary-cluster-from-an-aurora-global-database-cluster-1680072605847', 'title' => 'To detach an Aurora secondary cluster from an Aurora global database cluster', ], ], 'RemoveRoleFromDBCluster' => [ [ 'input' => [ 'DBClusterIdentifier' => 'mydbcluster', 'RoleArn' => 'arn:aws:iam::123456789012:role/RDSLoadFromS3', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example removes a role from a DB cluster.', 'id' => 'to-disassociate-an-identity-and-access-management-iam-role-from-a-db-cluster-1680072359521', 'title' => 'To disassociate an Identity and Access Management (IAM) role from a DB cluster', ], ], 'RemoveSourceIdentifierFromSubscription' => [ [ 'input' => [ 'SourceIdentifier' => 'test-instance-repl', 'SubscriptionName' => 'my-instance-events', ], 'output' => [ 'EventSubscription' => [ 'CustSubscriptionId' => 'my-instance-events', 'CustomerAwsId' => '123456789012', 'Enabled' => false, 'EventCategoriesList' => [ 'backup', 'recovery', ], 'EventSubscriptionArn' => 'arn:aws:rds:us-east-1:123456789012:es:my-instance-events', 'SnsTopicArn' => 'arn:aws:sns:us-east-1:123456789012:interesting-events', 'SourceIdsList' => [ 'test-instance', ], 'SourceType' => 'db-instance', 'Status' => 'modifying', 'SubscriptionCreationTime' => 'Tue Jul 31 23:22:01 UTC 2018', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example removes the specified source identifier from an existing subscription.', 'id' => 'to-remove-a-source-identifier-from-a-subscription-1680072062459', 'title' => 'To remove a source identifier from a subscription', ], ], 'RemoveTagsFromResource' => [ [ 'input' => [ 'ResourceName' => 'arn:aws:rds:us-east-1:123456789012:db:mydbinstance', 'TagKeys' => [ 'Name', 'Environment', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example removes tags from a resource.', 'id' => 'to-remove-tags-from-a-resource-1680070522922', 'title' => 'To remove tags from a resource', ], ], 'ResetDBClusterParameterGroup' => [ [ 'input' => [ 'DBClusterParameterGroupName' => 'mydbclpg', 'ResetAllParameters' => true, ], 'output' => [ 'DBClusterParameterGroupName' => 'mydbclpg', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example resets all parameter values in a customer-created DB cluster parameter group to their default values.', 'id' => 'to-reset-all-parameters-to-their-default-values-1680070254216', 'title' => 'To reset all parameters to their default values', ], ], 'ResetDBParameterGroup' => [ [ 'input' => [ 'DBParameterGroupName' => 'mypg', 'ResetAllParameters' => true, ], 'output' => [ 'DBParameterGroupName' => 'mypg', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example resets all parameter values in a customer-created DB parameter group to their default values.', 'id' => 'to-reset-all-parameters-to-their-default-values-1680069721142', 'title' => 'To reset all parameters to their default values', ], ], 'RestoreDBClusterFromS3' => [ [ 'input' => [ 'DBClusterIdentifier' => 'cluster-s3-restore', 'Engine' => 'aurora-mysql', 'MasterUserPassword' => 'mypassword', 'MasterUsername' => 'admin', 'S3BucketName' => 'mybucket', 'S3IngestionRoleArn' => 'arn:aws:iam::123456789012:role/service-role/TestBackup', 'S3Prefix' => 'test-backup', 'SourceEngine' => 'mysql', 'SourceEngineVersion' => '5.7.28', ], 'output' => [ 'DBCluster' => [ 'AllocatedStorage' => 1, 'AssociatedRoles' => [], 'AvailabilityZones' => [ 'us-west-2c', 'us-west-2a', 'us-west-2b', ], 'BackupRetentionPeriod' => 1, 'ClusterCreateTime' => '2020-07-27T14:22:08.095Z', 'CopyTagsToSnapshot' => false, 'CrossAccountClone' => false, 'DBClusterArn' => 'arn:aws:rds:us-west-2:123456789012:cluster:cluster-s3-restore', 'DBClusterIdentifier' => 'cluster-s3-restore', 'DBClusterMembers' => [], 'DBClusterParameterGroup' => 'default.aurora-mysql5.7', 'DBSubnetGroup' => 'default', 'DbClusterResourceId' => 'cluster-SU5THYQQHOWCXZZDGXREXAMPLE', 'DeletionProtection' => false, 'DomainMemberships' => [], 'Endpoint' => 'cluster-s3-restore.cluster-co3xyzabc123.us-west-2.rds.amazonaws.com', 'Engine' => 'aurora-mysql', 'EngineMode' => 'provisioned', 'EngineVersion' => '5.7.12', 'HostedZoneId' => 'Z1PVIF0EXAMPLE', 'HttpEndpointEnabled' => false, 'IAMDatabaseAuthenticationEnabled' => false, 'MasterUsername' => 'admin', 'MultiAZ' => false, 'Port' => 3306, 'PreferredBackupWindow' => '11:15-11:45', 'PreferredMaintenanceWindow' => 'thu:12:19-thu:12:49', 'ReadReplicaIdentifiers' => [], 'ReaderEndpoint' => 'cluster-s3-restore.cluster-ro-co3xyzabc123.us-west-2.rds.amazonaws.com', 'Status' => 'creating', 'StorageEncrypted' => false, 'VpcSecurityGroups' => [ [ 'Status' => 'active', 'VpcSecurityGroupId' => 'sg-########', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example restores an Amazon Aurora MySQL version 5.7-compatible DB cluster from a MySQL 5.7 DB backup file in Amazon S3.', 'id' => 'to-restore-an-amazon-aurora-db-cluster-from-amazon-s3-1680069516445', 'title' => 'To restore an Amazon Aurora DB cluster from Amazon S3', ], ], 'RestoreDBClusterFromSnapshot' => [ [ 'input' => [ 'DBClusterIdentifier' => 'newdbcluster', 'Engine' => 'aurora-postgresql', 'EngineVersion' => '10.7', 'SnapshotIdentifier' => 'test-instance-snapshot', ], 'output' => [ 'DBCluster' => [ 'AllocatedStorage' => 1, 'AssociatedRoles' => [], 'AvailabilityZones' => [ 'us-west-2c', 'us-west-2a', 'us-west-2b', ], 'BackupRetentionPeriod' => 7, 'ClusterCreateTime' => '2020-06-05T15:06:58.634Z', 'CopyTagsToSnapshot' => false, 'CrossAccountClone' => false, 'DBClusterArn' => 'arn:aws:rds:us-west-2:123456789012:cluster:newdbcluster', 'DBClusterIdentifier' => 'newdbcluster', 'DBClusterMembers' => [], 'DBClusterParameterGroup' => 'default.aurora-postgresql10', 'DBSubnetGroup' => 'default', 'DatabaseName' => '', 'DbClusterResourceId' => 'cluster-5DSB5IFQDDUVAWOUWM1EXAMPLE', 'DeletionProtection' => false, 'DomainMemberships' => [], 'Endpoint' => 'newdbcluster.cluster-############.us-west-2.rds.amazonaws.com', 'Engine' => 'aurora-postgresql', 'EngineMode' => 'provisioned', 'EngineVersion' => '10.7', 'HostedZoneId' => 'Z1PVIF0EXAMPLE', 'HttpEndpointEnabled' => false, 'IAMDatabaseAuthenticationEnabled' => false, 'KmsKeyId' => 'arn:aws:kms:us-west-2:123456789012:key/287364e4-33e3-4755-a3b0-a1b2c3d4e5f6', 'MasterUsername' => 'postgres', 'MultiAZ' => false, 'Port' => 5432, 'PreferredBackupWindow' => '09:33-10:03', 'PreferredMaintenanceWindow' => 'sun:12:22-sun:12:52', 'ReadReplicaIdentifiers' => [], 'ReaderEndpoint' => 'newdbcluster.cluster-ro-############.us-west-2.rds.amazonaws.com', 'Status' => 'creating', 'StorageEncrypted' => true, 'VpcSecurityGroups' => [ [ 'Status' => 'active', 'VpcSecurityGroupId' => 'sg-########', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example restores an Aurora PostgreSQL DB cluster compatible with PostgreSQL version 10.7 from a DB cluster snapshot named test-instance-snapshot.', 'id' => 'to-restore-a-db-cluster-from-a-snapshot-1680069287853', 'title' => 'To restore a DB cluster from a snapshot', ], ], 'RestoreDBClusterToPointInTime' => [ [ 'input' => [ 'DBClusterIdentifier' => 'sample-cluster-clone', 'RestoreType' => 'copy-on-write', 'SourceDBClusterIdentifier' => 'database-4', 'UseLatestRestorableTime' => true, ], 'output' => [ 'DBCluster' => [ 'AllocatedStorage' => 1, 'AssociatedRoles' => [], 'AvailabilityZones' => [ 'us-west-2c', 'us-west-2a', 'us-west-2b', ], 'BackupRetentionPeriod' => 7, 'CloneGroupId' => '8d19331a-099a-45a4-b4aa-11aa22bb33cc44dd', 'ClusterCreateTime' => '2020-03-10T19:57:38.967Z', 'CopyTagsToSnapshot' => false, 'CrossAccountClone' => false, 'DBClusterArn' => 'arn:aws:rds:us-west-2:123456789012:cluster:sample-cluster-clone', 'DBClusterIdentifier' => 'sample-cluster-clone', 'DBClusterMembers' => [], 'DBClusterParameterGroup' => 'default.aurora-postgresql10', 'DBSubnetGroup' => 'default', 'DatabaseName' => '', 'DbClusterResourceId' => 'cluster-BIZ77GDSA2XBSTNPFW1EXAMPLE', 'DeletionProtection' => false, 'Endpoint' => 'sample-cluster-clone.cluster-############.us-west-2.rds.amazonaws.com', 'Engine' => 'aurora-postgresql', 'EngineMode' => 'provisioned', 'EngineVersion' => '10.7', 'HostedZoneId' => 'Z1PVIF0EXAMPLE', 'HttpEndpointEnabled' => false, 'IAMDatabaseAuthenticationEnabled' => false, 'KmsKeyId' => 'arn:aws:kms:us-west-2:123456789012:key/287364e4-33e3-4755-a3b0-a1b2c3d4e5f6', 'MasterUsername' => 'postgres', 'MultiAZ' => false, 'Port' => 5432, 'PreferredBackupWindow' => '09:33-10:03', 'PreferredMaintenanceWindow' => 'sun:12:22-sun:12:52', 'ReadReplicaIdentifiers' => [], 'ReaderEndpoint' => 'sample-cluster-clone.cluster-ro-############.us-west-2.rds.amazonaws.com', 'Status' => 'creating', 'StorageEncrypted' => true, 'VpcSecurityGroups' => [ [ 'Status' => 'active', 'VpcSecurityGroupId' => 'sg-########', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example restores the DB cluster named database-4 to the latest possible time. Using copy-on-write as the restore type restores the new DB cluster as a clone of the source DB cluster.', 'id' => 'to-restore-a-db-cluster-to-a-specified-time-1680069105508', 'title' => 'To restore a DB cluster to a specified time', ], ], 'RestoreDBInstanceFromDBSnapshot' => [ [ 'input' => [ 'DBInstanceClass' => 'db.t3.small', 'DBInstanceIdentifier' => 'db7-new-instance', 'DBSnapshotIdentifier' => 'db7-test-snapshot', ], 'output' => [ 'DBInstance' => [ 'AssociatedRoles' => [], 'AutoMinorVersionUpgrade' => true, 'DBInstanceArn' => 'arn:aws:rds:us-west-2:123456789012:db:db7-new-instance', 'DBInstanceClass' => 'db.t3.small', 'DBInstanceIdentifier' => 'db7-new-instance', 'DBInstanceStatus' => 'creating', 'DeletionProtection' => false, 'Engine' => 'mysql', 'EngineVersion' => '5.7.22', 'IAMDatabaseAuthenticationEnabled' => false, 'LicenseModel' => 'general-public-license', 'MultiAZ' => false, 'PendingModifiedValues' => [], 'PerformanceInsightsEnabled' => false, 'PreferredMaintenanceWindow' => 'mon:07:37-mon:08:07', 'ReadReplicaDBInstanceIdentifiers' => [], ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBInstance' => 'Some output ommitted.', ], ], 'description' => 'The following example creates a new DB instance named db7-new-instance with the db.t3.small DB instance class from the specified DB snapshot. The source DB instance from which the snapshot was taken uses a deprecated DB instance class, so you can\'t upgrade it.', 'id' => 'to-restore-a-db-instance-from-a-db-snapshot-1680093236214', 'title' => 'To restore a DB instance from a DB snapshot', ], ], 'RestoreDBInstanceToPointInTime' => [ [ 'input' => [ 'RestoreTime' => '2018-07-30T23:45:00.000Z', 'SourceDBInstanceIdentifier' => 'test-instance', 'TargetDBInstanceIdentifier' => 'restored-test-instance', ], 'output' => [ 'DBInstance' => [ 'AllocatedStorage' => 200, 'AutoMinorVersionUpgrade' => true, 'AvailabilityZone' => 'us-west-2b', 'BackupRetentionPeriod' => 7, 'CACertificateIdentifier' => 'rds-ca-2015', 'CopyTagsToSnapshot' => false, 'DBInstanceArn' => 'arn:aws:rds:us-west-2:123456789012:db:restored-test-instance', 'DBInstanceClass' => 'db.t2.small', 'DBInstanceIdentifier' => 'restored-test-instance', 'DBInstanceStatus' => 'available', 'DBName' => 'sample', 'DBParameterGroups' => [ [ 'DBParameterGroupName' => 'default.mysql5.6', 'ParameterApplyStatus' => 'in-sync', ], ], 'DBSecurityGroups' => [], 'DBSubnetGroup' => [ 'DBSubnetGroupDescription' => 'default', 'DBSubnetGroupName' => 'default', 'SubnetGroupStatus' => 'Complete', 'Subnets' => [ [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2a', ], 'SubnetIdentifier' => 'subnet-77e8db03', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2b', ], 'SubnetIdentifier' => 'subnet-c39989a1', 'SubnetStatus' => 'Active', ], [ 'SubnetAvailabilityZone' => [ 'Name' => 'us-west-2c', ], 'SubnetIdentifier' => 'subnet-4b267b0d', 'SubnetStatus' => 'Active', ], ], 'VpcId' => 'vpc-c1c5b3a3', ], 'DbInstancePort' => 0, 'DbiResourceId' => 'db-VNZUCCBTEDC4WR7THXNJO72HVQ', 'DomainMemberships' => [], 'Engine' => 'mysql', 'EngineVersion' => '5.6.27', 'LicenseModel' => 'general-public-license', 'MasterUsername' => 'mymasteruser', 'MonitoringInterval' => 0, 'MultiAZ' => false, 'OptionGroupMemberships' => [ [ 'OptionGroupName' => 'default:mysql-5-6', 'Status' => 'in-sync', ], ], 'PendingModifiedValues' => [], 'PreferredBackupWindow' => '12:58-13:28', 'PreferredMaintenanceWindow' => 'tue:10:16-tue:10:46', 'PubliclyAccessible' => true, 'ReadReplicaDBInstanceIdentifiers' => [], 'StorageEncrypted' => false, 'StorageType' => 'gp2', 'VpcSecurityGroups' => [ [ 'Status' => 'active', 'VpcSecurityGroupId' => 'sg-e5e5b0d2', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example restores test-instance to a new DB instance named restored-test-instance, as of the specified time.', 'id' => 'to-restore-a-db-instance-to-a-point-in-time-1680036021951', 'title' => 'To restore a DB instance to a point in time', ], ], 'RevokeDBSecurityGroupIngress' => [ [ 'input' => [ 'CIDRIP' => '203.0.113.5/32', 'DBSecurityGroupName' => 'mydbsecuritygroup', ], 'output' => [ 'DBSecurityGroup' => [], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'This example revokes ingress for the specified CIDR block associated with the specified DB security group.', 'id' => 'revoke-db-security-group-ingress-ce5b2c1c-bd4e-4809-b04a-6d78ec448813', 'title' => 'To revoke ingress for a DB security group', ], ], 'StartActivityStream' => [ [ 'input' => [ 'ApplyImmediately' => true, 'KmsKeyId' => 'arn:aws:kms:us-east-1:1234567890123:key/a12c345d-6ef7-890g-h123-456i789jk0l1', 'Mode' => 'async', 'ResourceArn' => 'arn:aws:rds:us-east-1:1234567890123:cluster:my-pg-cluster', ], 'output' => [ 'ApplyImmediately' => true, 'KinesisStreamName' => 'aws-rds-das-cluster-0ABCDEFGHI1JKLM2NOPQ3R4S', 'KmsKeyId' => 'arn:aws:kms:us-east-1:1234567890123:key/a12c345d-6ef7-890g-h123-456i789jk0l1', 'Mode' => 'async', 'Status' => 'starting', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example starts an asynchronous activity stream to monitor an Aurora cluster named my-pg-cluster.', 'id' => 'to-start-a-database-activity-stream-1680035656463', 'title' => 'To start a database activity stream', ], ], 'StartDBCluster' => [ [ 'input' => [ 'DBClusterIdentifier' => 'mydbcluster', ], 'output' => [ 'DBCluster' => [ 'AllocatedStorage' => 1, 'AvailabilityZones' => [ 'us-east-1a', 'us-east-1e', 'us-east-1b', ], 'BackupRetentionPeriod' => 1, 'DBClusterIdentifier' => 'mydbcluster', 'DatabaseName' => 'mydb', ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBCluster' => 'Some output ommitted.', ], ], 'description' => 'The following example starts a DB cluster and its DB instances.', 'id' => 'to-start-a-db-cluster-1680035521632', 'title' => 'To start a DB cluster', ], ], 'StartDBInstance' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'test-instance', ], 'output' => [ 'DBInstance' => [ 'DBInstanceStatus' => 'starting', ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBInstance' => 'Some output ommitted.', ], ], 'description' => 'The following example starts the specified DB instance.', 'id' => 'to-start-a-db-instance-1679951967681', 'title' => 'To start a DB instance', ], ], 'StartDBInstanceAutomatedBackupsReplication' => [ [ 'input' => [ 'BackupRetentionPeriod' => 14, 'SourceDBInstanceArn' => 'arn:aws:rds:us-east-1:123456789012:db:new-orcl-db', ], 'output' => [ 'DBInstanceAutomatedBackup' => [ 'AllocatedStorage' => 20, 'BackupRetentionPeriod' => 14, 'DBInstanceArn' => 'arn:aws:rds:us-east-1:123456789012:db:new-orcl-db', 'DBInstanceAutomatedBackupsArn' => 'arn:aws:rds:us-west-2:123456789012:auto-backup:ab-jkib2gfq5rv7replzadausbrktni2bn4example', 'DBInstanceIdentifier' => 'new-orcl-db', 'DbiResourceId' => 'db-JKIB2GFQ5RV7REPLZA4EXAMPLE', 'Encrypted' => false, 'Engine' => 'oracle-se2', 'EngineVersion' => '12.1.0.2.v21', 'IAMDatabaseAuthenticationEnabled' => false, 'InstanceCreateTime' => '2020-12-04T15:28:31Z', 'LicenseModel' => 'bring-your-own-license', 'MasterUsername' => 'admin', 'OptionGroupName' => 'default:oracle-se2-12-1', 'Port' => 1521, 'Region' => 'us-east-1', 'RestoreWindow' => [], 'Status' => 'pending', 'StorageType' => 'gp2', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example replicates automated backups from a DB instance in the US East (N. Virginia) Region. The backup retention period is 14 days.', 'id' => 'to-enable-cross-region-automated-backups-1680033438352', 'title' => 'To enable cross-Region automated backups', ], ], 'StartExportTask' => [ [ 'input' => [ 'ExportTaskIdentifier' => 'my-s3-export', 'IamRoleArn' => 'arn:aws:iam::123456789012:role/service-role/ExportRole', 'KmsKeyId' => 'arn:aws:kms:us-west-2:123456789012:key/abcd0000-7fca-4128-82f2-aabbccddeeff', 'S3BucketName' => 'mybucket', 'SourceArn' => 'arn:aws:rds:us-west-2:123456789012:snapshot:db5-snapshot-test', ], 'output' => [ 'ExportTaskIdentifier' => 'my-s3-export', 'IamRoleArn' => 'arn:aws:iam::123456789012:role/service-role/ExportRole', 'KmsKeyId' => 'arn:aws:kms:us-west-2:123456789012:key/abcd0000-7fca-4128-82f2-aabbccddeeff', 'PercentProgress' => 0, 'S3Bucket' => 'mybucket', 'SnapshotTime' => '2020-03-27T20:48:42.023Z', 'SourceArn' => 'arn:aws:rds:us-west-2:123456789012:snapshot:db5-snapshot-test', 'Status' => 'STARTING', 'TotalExtractedDataInGB' => 0, ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example exports a DB snapshot named db5-snapshot-test to the Amazon S3 bucket named mybucket.', 'id' => 'to-export-a-snapshot-to-amazon-s3-1679950669718', 'title' => 'To export a snapshot to Amazon S3', ], ], 'StopActivityStream' => [ [ 'input' => [ 'ApplyImmediately' => true, 'ResourceArn' => 'arn:aws:rds:us-east-1:1234567890123:cluster:my-pg-cluster', ], 'output' => [ 'KinesisStreamName' => 'aws-rds-das-cluster-0ABCDEFGHI1JKLM2NOPQ3R4S', 'KmsKeyId' => 'arn:aws:kms:us-east-1:1234567890123:key/a12c345d-6ef7-890g-h123-456i789jk0l1', 'Status' => 'stopping', ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example stops an activity stream in an Aurora cluster named my-pg-cluster.', 'id' => 'to-stop-a-database-activity-stream-1679945843823', 'title' => 'To stop a database activity stream', ], ], 'StopDBCluster' => [ [ 'input' => [ 'DBClusterIdentifier' => 'mydbcluster', ], 'output' => [ 'DBCluster' => [ 'AllocatedStorage' => 1, 'AvailabilityZones' => [ 'us-east-1a', 'us-east-1e', 'us-east-1b', ], 'BackupRetentionPeriod' => 1, 'DBClusterIdentifier' => 'mydbcluster', 'DatabaseName' => 'mydb', ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBCluster' => 'Some output ommitted.', ], ], 'description' => 'The following example stops a DB cluster and its DB instances.', 'id' => 'to-stop-a-db-cluster-1679701988603', 'title' => 'To stop a DB cluster', ], ], 'StopDBInstance' => [ [ 'input' => [ 'DBInstanceIdentifier' => 'test-instance', ], 'output' => [ 'DBInstance' => [ 'DBInstanceStatus' => 'stopping', ], ], 'comments' => [ 'input' => [], 'output' => [ 'DBInstance' => 'Some output ommitted.', ], ], 'description' => 'The following example stops the specified DB instance.', 'id' => 'to-stop-a-db-instance-1679701630959', 'title' => 'To stop a DB instance', ], ], 'StopDBInstanceAutomatedBackupsReplication' => [ [ 'input' => [ 'SourceDBInstanceArn' => 'arn:aws:rds:us-east-1:123456789012:db:new-orcl-db', ], 'output' => [ 'DBInstanceAutomatedBackup' => [ 'AllocatedStorage' => 20, 'BackupRetentionPeriod' => 7, 'DBInstanceArn' => 'arn:aws:rds:us-east-1:123456789012:db:new-orcl-db', 'DBInstanceAutomatedBackupsArn' => 'arn:aws:rds:us-west-2:123456789012:auto-backup:ab-jkib2gfq5rv7replzadausbrktni2bn4example', 'DBInstanceIdentifier' => 'new-orcl-db', 'DbiResourceId' => 'db-JKIB2GFQ5RV7REPLZA4EXAMPLE', 'Encrypted' => false, 'Engine' => 'oracle-se2', 'EngineVersion' => '12.1.0.2.v21', 'IAMDatabaseAuthenticationEnabled' => false, 'InstanceCreateTime' => '2020-12-04T15:28:31Z', 'LicenseModel' => 'bring-your-own-license', 'MasterUsername' => 'admin', 'OptionGroupName' => 'default:oracle-se2-12-1', 'Port' => 1521, 'Region' => 'us-east-1', 'RestoreWindow' => [ 'EarliestTime' => '2020-12-04T23:13:21.030Z', 'LatestTime' => '2020-12-07T19:59:57Z', ], 'Status' => 'replicating', 'StorageType' => 'gp2', ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example ends replication of automated backups. Replicated backups are retained according to the set backup retention period.', 'id' => 'to-stop-replicating-automated-backups-1679701787115', 'title' => 'To stop replicating automated backups', ], ], 'SwitchoverBlueGreenDeployment' => [ [ 'input' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-wi89nwzglccsfake', 'SwitchoverTimeout' => 300, ], 'output' => [ 'BlueGreenDeployment' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-v53303651eexfake', 'BlueGreenDeploymentName' => 'bgd-cli-test-instance', 'CreateTime' => '2022-02-25T22:33:22.225000+00:00', 'Source' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance', 'Status' => 'SWITCHOVER_IN_PROGRESS', 'SwitchoverDetails' => [ [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-green-blhi1e', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-1', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-1-green-k5fv7u', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-2', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-2-green-ggsh8m', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-3', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-replica-3-green-o2vwm0', ], ], 'Target' => 'arn:aws:rds:us-east-1:123456789012:db:my-db-instance-green-blhi1e', 'Tasks' => [ [ 'Name' => 'CREATING_READ_REPLICA_OF_SOURCE', 'Status' => 'COMPLETED', ], [ 'Name' => 'DB_ENGINE_VERSION_UPGRADE', 'Status' => 'COMPLETED', ], [ 'Name' => 'CONFIGURE_BACKUPS', 'Status' => 'COMPLETED', ], [ 'Name' => 'CREATING_TOPOLOGY_OF_SOURCE', 'Status' => 'COMPLETED', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example promotes the specified green environment as the new production environment.', 'id' => 'to-switch-a-bluegreen-deployment-for-an-rds-db-instance-1679699425237', 'title' => 'To switch a blue/green deployment for an RDS DB instance', ], [ 'input' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-wi89nwzglccsfake', 'SwitchoverTimeout' => 300, ], 'output' => [ 'BlueGreenDeployment' => [ 'BlueGreenDeploymentIdentifier' => 'bgd-wi89nwzglccsfake', 'BlueGreenDeploymentName' => 'my-blue-green-deployment', 'CreateTime' => '2022-02-25T22:38:49.522000+00:00', 'Source' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster', 'Status' => 'SWITCHOVER_IN_PROGRESS', 'SwitchoverDetails' => [ [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-green-3ud8z6', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-1-green-bvxc73', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-2-green-7wc4ie', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:db:my-aurora-mysql-cluster-3-green-p4xxkz', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-excluded-member-endpoint-green-np1ikl', ], [ 'SourceMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint', 'Status' => 'AVAILABLE', 'TargetMember' => 'arn:aws:rds:us-east-1:123456789012:cluster-endpoint:my-reader-endpoint-green-miszlf', ], ], 'Target' => 'arn:aws:rds:us-east-1:123456789012:cluster:my-aurora-mysql-cluster-green-3ud8z6', 'Tasks' => [ [ 'Name' => 'CREATING_READ_REPLICA_OF_SOURCE', 'Status' => 'COMPLETED', ], [ 'Name' => 'DB_ENGINE_VERSION_UPGRADE', 'Status' => 'COMPLETED', ], [ 'Name' => 'CREATE_DB_INSTANCES_FOR_CLUSTER', 'Status' => 'COMPLETED', ], [ 'Name' => 'CREATE_CUSTOM_ENDPOINTS', 'Status' => 'COMPLETED', ], ], ], ], 'comments' => [ 'input' => [], 'output' => [], ], 'description' => 'The following example promotes the specified green environment as the new production environment.', 'id' => 'to-promote-a-bluegreen-deployment-for-an-aurora-mysql-db-cluster-1679700197409', 'title' => 'To promote a blue/green deployment for an Aurora MySQL DB cluster', ], ], ],];
