<?php
// This file was auto-generated from sdk-root/src/data/redshift-serverless/2021-04-21/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>This is an interface reference for Amazon Redshift Serverless. It contains documentation for one of the programming or command line interfaces you can use to manage Amazon Redshift Serverless. </p> <p>Amazon Redshift Serverless automatically provisions data warehouse capacity and intelligently scales the underlying resources based on workload demands. Amazon Redshift Serverless adjusts capacity in seconds to deliver consistently high performance and simplified operations for even the most demanding and volatile workloads. Amazon Redshift Serverless lets you focus on using your data to acquire new insights for your business and customers. </p> <p> To learn more about Amazon Redshift Serverless, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-whatis.html">What is Amazon Redshift Serverless</a>. </p>', 'operations' => [ 'ConvertRecoveryPointToSnapshot' => '<p>Converts a recovery point to a snapshot. For more information about recovery points and snapshots, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html">Working with snapshots and recovery points</a>.</p>', 'CreateCustomDomainAssociation' => '<p>Creates a custom domain association for Amazon Redshift Serverless.</p>', 'CreateEndpointAccess' => '<p>Creates an Amazon Redshift Serverless managed VPC endpoint.</p>', 'CreateNamespace' => '<p>Creates a namespace in Amazon Redshift Serverless.</p>', 'CreateScheduledAction' => '<p>Creates a scheduled action. A scheduled action contains a schedule and an Amazon Redshift API action. For example, you can create a schedule of when to run the <code>CreateSnapshot</code> API operation.</p>', 'CreateSnapshot' => '<p>Creates a snapshot of all databases in a namespace. For more information about snapshots, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html"> Working with snapshots and recovery points</a>.</p>', 'CreateSnapshotCopyConfiguration' => '<p>Creates a snapshot copy configuration that lets you copy snapshots to another Amazon Web Services Region.</p>', 'CreateUsageLimit' => '<p>Creates a usage limit for a specified Amazon Redshift Serverless usage type. The usage limit is identified by the returned usage limit identifier. </p>', 'CreateWorkgroup' => '<p>Creates an workgroup in Amazon Redshift Serverless.</p>', 'DeleteCustomDomainAssociation' => '<p>Deletes a custom domain association for Amazon Redshift Serverless.</p>', 'DeleteEndpointAccess' => '<p>Deletes an Amazon Redshift Serverless managed VPC endpoint.</p>', 'DeleteNamespace' => '<p>Deletes a namespace from Amazon Redshift Serverless. Before you delete the namespace, you can create a final snapshot that has all of the data within the namespace.</p>', 'DeleteResourcePolicy' => '<p>Deletes the specified resource policy.</p>', 'DeleteScheduledAction' => '<p>Deletes a scheduled action.</p>', 'DeleteSnapshot' => '<p>Deletes a snapshot from Amazon Redshift Serverless.</p>', 'DeleteSnapshotCopyConfiguration' => '<p>Deletes a snapshot copy configuration</p>', 'DeleteUsageLimit' => '<p>Deletes a usage limit from Amazon Redshift Serverless.</p>', 'DeleteWorkgroup' => '<p>Deletes a workgroup.</p>', 'GetCredentials' => '<p>Returns a database user name and temporary password with temporary authorization to log in to Amazon Redshift Serverless.</p> <p>By default, the temporary credentials expire in 900 seconds. You can optionally specify a duration between 900 seconds (15 minutes) and 3600 seconds (60 minutes).</p> <pre><code> &lt;p&gt;The Identity and Access Management (IAM) user or role that runs GetCredentials must have an IAM policy attached that allows access to all necessary actions and resources.&lt;/p&gt; &lt;p&gt;If the &lt;code&gt;DbName&lt;/code&gt; parameter is specified, the IAM policy must allow access to the resource dbname for the specified database name.&lt;/p&gt; </code></pre>', 'GetCustomDomainAssociation' => '<p>Gets information about a specific custom domain association.</p>', 'GetEndpointAccess' => '<p>Returns information, such as the name, about a VPC endpoint.</p>', 'GetNamespace' => '<p>Returns information about a namespace in Amazon Redshift Serverless.</p>', 'GetRecoveryPoint' => '<p>Returns information about a recovery point.</p>', 'GetResourcePolicy' => '<p>Returns a resource policy.</p>', 'GetScheduledAction' => '<p>Returns information about a scheduled action.</p>', 'GetSnapshot' => '<p>Returns information about a specific snapshot.</p>', 'GetTableRestoreStatus' => '<p>Returns information about a <code>TableRestoreStatus</code> object.</p>', 'GetUsageLimit' => '<p>Returns information about a usage limit.</p>', 'GetWorkgroup' => '<p>Returns information about a specific workgroup.</p>', 'ListCustomDomainAssociations' => '<p> Lists custom domain associations for Amazon Redshift Serverless.</p>', 'ListEndpointAccess' => '<p>Returns an array of <code>EndpointAccess</code> objects and relevant information.</p>', 'ListNamespaces' => '<p>Returns information about a list of specified namespaces.</p>', 'ListRecoveryPoints' => '<p>Returns an array of recovery points.</p>', 'ListScheduledActions' => '<p>Returns a list of scheduled actions. You can use the flags to filter the list of returned scheduled actions.</p>', 'ListSnapshotCopyConfigurations' => '<p>Returns a list of snapshot copy configurations.</p>', 'ListSnapshots' => '<p>Returns a list of snapshots.</p>', 'ListTableRestoreStatus' => '<p>Returns information about an array of <code>TableRestoreStatus</code> objects.</p>', 'ListTagsForResource' => '<p>Lists the tags assigned to a resource.</p>', 'ListUsageLimits' => '<p>Lists all usage limits within Amazon Redshift Serverless.</p>', 'ListWorkgroups' => '<p>Returns information about a list of specified workgroups.</p>', 'PutResourcePolicy' => '<p>Creates or updates a resource policy. Currently, you can use policies to share snapshots across Amazon Web Services accounts.</p>', 'RestoreFromRecoveryPoint' => '<p>Restore the data from a recovery point.</p>', 'RestoreFromSnapshot' => '<p>Restores a namespace from a snapshot.</p>', 'RestoreTableFromRecoveryPoint' => '<p>Restores a table from a recovery point to your Amazon Redshift Serverless instance. You can\'t use this operation to restore tables with interleaved sort keys.</p>', 'RestoreTableFromSnapshot' => '<p>Restores a table from a snapshot to your Amazon Redshift Serverless instance. You can\'t use this operation to restore tables with <a href="https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved">interleaved sort keys</a>.</p>', 'TagResource' => '<p>Assigns one or more tags to a resource.</p>', 'UntagResource' => '<p>Removes a tag or set of tags from a resource.</p>', 'UpdateCustomDomainAssociation' => '<p>Updates an Amazon Redshift Serverless certificate associated with a custom domain.</p>', 'UpdateEndpointAccess' => '<p>Updates an Amazon Redshift Serverless managed endpoint.</p>', 'UpdateNamespace' => '<p>Updates a namespace with the specified settings. Unless required, you can\'t update multiple parameters in one request. For example, you must specify both <code>adminUsername</code> and <code>adminUserPassword</code> to update either field, but you can\'t update both <code>kmsKeyId</code> and <code>logExports</code> in a single request.</p>', 'UpdateScheduledAction' => '<p>Updates a scheduled action.</p>', 'UpdateSnapshot' => '<p>Updates a snapshot.</p>', 'UpdateSnapshotCopyConfiguration' => '<p>Updates a snapshot copy configuration.</p>', 'UpdateUsageLimit' => '<p>Update a usage limit in Amazon Redshift Serverless. You can\'t update the usage type or period of a usage limit.</p>', 'UpdateWorkgroup' => '<p>Updates a workgroup with the specified configuration settings. You can\'t update multiple parameters in one request. For example, you can update <code>baseCapacity</code> or <code>port</code> in a single request, but you can\'t update both in the same request.</p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AccountIdList' => [ 'base' => NULL, 'refs' => [ 'Snapshot$accountsWithProvisionedRestoreAccess' => '<p>All of the Amazon Web Services accounts that have access to restore a snapshot to a provisioned cluster.</p>', 'Snapshot$accountsWithRestoreAccess' => '<p>All of the Amazon Web Services accounts that have access to restore a snapshot to a namespace.</p>', ], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to list tags for.</p>', 'ResourceNotFoundException$resourceName' => '<p>The name of the resource that could not be found.</p>', 'TagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to tag.</p>', 'TooManyTagsException$resourceName' => '<p>The name of the resource that exceeded the number of tags allowed for a resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to remove tags from.</p>', ], ], 'Association' => [ 'base' => '<p>An object that represents the custom domain name association.</p>', 'refs' => [ 'AssociationList$member' => NULL, ], ], 'AssociationList' => [ 'base' => NULL, 'refs' => [ 'ListCustomDomainAssociationsResponse$associations' => '<p>A list of Association objects.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$manageAdminPassword' => '<p>If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the namespace\'s admin credentials. You can\'t use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. If <code>manageAdminPassword</code> is false or not set, Amazon Redshift uses <code>adminUserPassword</code> for the admin user account\'s password. </p>', 'CreateScheduledActionRequest$enabled' => '<p>Indicates whether the schedule is enabled. If false, the scheduled action does not trigger. For more information about <code>state</code> of the scheduled action, see <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ScheduledAction.html">ScheduledAction</a>.</p>', 'CreateWorkgroupRequest$enhancedVpcRouting' => '<p>The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC instead of over the internet.</p>', 'CreateWorkgroupRequest$publiclyAccessible' => '<p>A value that specifies whether the workgroup can be accessed from a public network.</p>', 'RestoreFromSnapshotRequest$manageAdminPassword' => '<p>If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the restored snapshot\'s admin credentials. If <code>MmanageAdminPassword</code> is false or not set, Amazon Redshift uses the admin credentials that the namespace or cluster had at the time the snapshot was taken.</p>', 'RestoreTableFromRecoveryPointRequest$activateCaseSensitiveIdentifier' => '<p>Indicates whether name identifiers for database, schema, and table are case sensitive. If true, the names are case sensitive. If false, the names are not case sensitive. The default is false.</p>', 'RestoreTableFromSnapshotRequest$activateCaseSensitiveIdentifier' => '<p>Indicates whether name identifiers for database, schema, and table are case sensitive. If true, the names are case sensitive. If false, the names are not case sensitive. The default is false.</p>', 'UpdateNamespaceRequest$manageAdminPassword' => '<p>If <code>true</code>, Amazon Redshift uses Secrets Manager to manage the namespace\'s admin credentials. You can\'t use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. If <code>manageAdminPassword</code> is false or not set, Amazon Redshift uses <code>adminUserPassword</code> for the admin user account\'s password. </p>', 'UpdateScheduledActionRequest$enabled' => '<p>Specifies whether to enable the scheduled action.</p>', 'UpdateWorkgroupRequest$enhancedVpcRouting' => '<p>The value that specifies whether to turn on enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.</p>', 'UpdateWorkgroupRequest$publiclyAccessible' => '<p>A value that specifies whether the workgroup can be accessible from a public network.</p>', 'Workgroup$enhancedVpcRouting' => '<p>The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.</p>', 'Workgroup$publiclyAccessible' => '<p>A value that specifies whether the workgroup can be accessible from a public network.</p>', ], ], 'ConfigParameter' => [ 'base' => '<p>An array of key-value pairs to set for advanced control over Amazon Redshift Serverless.</p>', 'refs' => [ 'ConfigParameterList$member' => NULL, ], ], 'ConfigParameterList' => [ 'base' => NULL, 'refs' => [ 'CreateWorkgroupRequest$configParameters' => '<p>An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>, <code>datestyle</code>, <code>enable_case_sensitive_identifier</code>, <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>, <code>require_ssl</code>, <code>use_fips_ssl</code>, and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"> Query monitoring metrics for Amazon Redshift Serverless</a>.</p>', 'UpdateWorkgroupRequest$configParameters' => '<p>An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>, <code>datestyle</code>, <code>enable_case_sensitive_identifier</code>, <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>, <code>require_ssl</code>, <code>use_fips_ssl</code>, and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"> Query monitoring metrics for Amazon Redshift Serverless</a>.</p>', 'Workgroup$configParameters' => '<p>An array of parameters to set for advanced control over a database. The options are <code>auto_mv</code>, <code>datestyle</code>, <code>enable_case_sensitive_identifier</code>, <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>, <code>require_ssl</code>, <code>use_fips_ssl</code>, and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless"> Query monitoring metrics for Amazon Redshift Serverless</a>.</p>', ], ], 'ConflictException' => [ 'base' => '<p>The submitted action has conflicts.</p>', 'refs' => [], ], 'ConvertRecoveryPointToSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'ConvertRecoveryPointToSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomDomainAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCustomDomainAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateScheduledActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateScheduledActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotCopyConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotCopyConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateSnapshotScheduleActionParameters' => [ 'base' => '<p>The parameters that you can use to configure a <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html">scheduled action</a> to create a snapshot. For more information about creating a scheduled action, see <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html">CreateScheduledAction</a>.</p>', 'refs' => [ 'TargetAction$createSnapshot' => NULL, ], ], 'CreateUsageLimitRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateUsageLimitResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkgroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateWorkgroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'CustomDomainCertificateArnString' => [ 'base' => NULL, 'refs' => [ 'Association$customDomainCertificateArn' => '<p>The custom domain name’s certificate Amazon resource name (ARN).</p>', 'CreateCustomDomainAssociationRequest$customDomainCertificateArn' => '<p>The custom domain name’s certificate Amazon resource name (ARN).</p>', 'CreateCustomDomainAssociationResponse$customDomainCertificateArn' => '<p>The custom domain name’s certificate Amazon resource name (ARN).</p>', 'GetCustomDomainAssociationResponse$customDomainCertificateArn' => '<p>The custom domain name’s certificate Amazon resource name (ARN).</p>', 'ListCustomDomainAssociationsRequest$customDomainCertificateArn' => '<p>The custom domain name’s certificate Amazon resource name (ARN).</p>', 'UpdateCustomDomainAssociationRequest$customDomainCertificateArn' => '<p>The custom domain name’s certificate Amazon resource name (ARN). This is optional.</p>', 'UpdateCustomDomainAssociationResponse$customDomainCertificateArn' => '<p>The custom domain name’s certificate Amazon resource name (ARN).</p>', 'Workgroup$customDomainCertificateArn' => '<p>The custom domain name’s certificate Amazon resource name (ARN).</p>', ], ], 'CustomDomainName' => [ 'base' => NULL, 'refs' => [ 'Association$customDomainName' => '<p>The custom domain name associated with the workgroup.</p>', 'CreateCustomDomainAssociationRequest$customDomainName' => '<p>The custom domain name to associate with the workgroup.</p>', 'CreateCustomDomainAssociationResponse$customDomainName' => '<p>The custom domain name to associate with the workgroup.</p>', 'DeleteCustomDomainAssociationRequest$customDomainName' => '<p>The custom domain name associated with the workgroup.</p>', 'GetCredentialsRequest$customDomainName' => '<p>The custom domain name associated with the workgroup. The custom domain name or the workgroup name must be included in the request.</p>', 'GetCustomDomainAssociationRequest$customDomainName' => '<p>The custom domain name associated with the workgroup.</p>', 'GetCustomDomainAssociationResponse$customDomainName' => '<p>The custom domain name associated with the workgroup.</p>', 'ListCustomDomainAssociationsRequest$customDomainName' => '<p>The custom domain name associated with the workgroup.</p>', 'UpdateCustomDomainAssociationRequest$customDomainName' => '<p>The custom domain name associated with the workgroup.</p>', 'UpdateCustomDomainAssociationResponse$customDomainName' => '<p>The custom domain name associated with the workgroup.</p>', 'Workgroup$customDomainName' => '<p>The custom domain name associated with the workgroup.</p>', ], ], 'DbName' => [ 'base' => NULL, 'refs' => [ 'GetCredentialsRequest$dbName' => '<p>The name of the database to get temporary authorization to log on to.</p> <p>Constraints:</p> <ul> <li> <p>Must be 1 to 64 alphanumeric characters or hyphens.</p> </li> <li> <p>Must contain only uppercase or lowercase letters, numbers, underscore, plus sign, period (dot), at symbol (@), or hyphen.</p> </li> <li> <p>The first character must be a letter.</p> </li> <li> <p>Must not contain a colon ( : ) or slash ( / ).</p> </li> <li> <p>Cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words </a> in the Amazon Redshift Database Developer Guide</p> </li> </ul>', ], ], 'DbPassword' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$adminUserPassword' => '<p>The password of the administrator for the first database created in the namespace.</p> <p>You can\'t use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. </p>', 'GetCredentialsResponse$dbPassword' => '<p>A temporary password that authorizes the user name returned by <code>DbUser</code> to log on to the database <code>DbName</code>.</p>', 'UpdateNamespaceRequest$adminUserPassword' => '<p>The password of the administrator for the first database created in the namespace. This parameter must be updated together with <code>adminUsername</code>.</p> <p>You can\'t use <code>adminUserPassword</code> if <code>manageAdminPassword</code> is true. </p>', ], ], 'DbUser' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$adminUsername' => '<p>The username of the administrator for the first database created in the namespace.</p>', 'GetCredentialsResponse$dbUser' => '<p>A database user name that is authorized to log on to the database <code>DbName</code> using the password <code>DbPassword</code>. If the specified <code>DbUser</code> exists in the database, the new user name has the same database privileges as the the user named in <code>DbUser</code>. By default, the user is added to PUBLIC.</p>', 'Namespace$adminUsername' => '<p>The username of the administrator for the first database created in the namespace.</p>', 'UpdateNamespaceRequest$adminUsername' => '<p>The username of the administrator for the first database created in the namespace. This parameter must be updated together with <code>adminUserPassword</code>.</p>', ], ], 'DeleteCustomDomainAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCustomDomainAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteScheduledActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteScheduledActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotCopyConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotCopyConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUsageLimitRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteUsageLimitResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkgroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteWorkgroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'Double' => [ 'base' => NULL, 'refs' => [ 'RecoveryPoint$totalSizeInMegaBytes' => '<p>The total size of the data in the recovery point in megabytes.</p>', 'Snapshot$actualIncrementalBackupSizeInMegaBytes' => '<p>The size of the incremental backup in megabytes.</p>', 'Snapshot$backupProgressInMegaBytes' => '<p>The size in megabytes of the data that has been backed up to a snapshot.</p>', 'Snapshot$currentBackupRateInMegaBytesPerSecond' => '<p>The rate at which data is backed up into a snapshot in megabytes per second.</p>', 'Snapshot$totalBackupSizeInMegaBytes' => '<p>The total size, in megabytes, of how big the snapshot is.</p>', ], ], 'Endpoint' => [ 'base' => '<p>The VPC endpoint object.</p>', 'refs' => [ 'Workgroup$endpoint' => '<p>The endpoint that is created from the workgroup.</p>', ], ], 'EndpointAccess' => [ 'base' => '<p>Information about an Amazon Redshift Serverless VPC endpoint.</p>', 'refs' => [ 'CreateEndpointAccessResponse$endpoint' => '<p>The created VPC endpoint.</p>', 'DeleteEndpointAccessResponse$endpoint' => '<p>The deleted VPC endpoint.</p>', 'EndpointAccessList$member' => NULL, 'GetEndpointAccessResponse$endpoint' => '<p>The returned VPC endpoint.</p>', 'UpdateEndpointAccessResponse$endpoint' => '<p>The updated VPC endpoint.</p>', ], ], 'EndpointAccessList' => [ 'base' => NULL, 'refs' => [ 'ListEndpointAccessResponse$endpoints' => '<p>The returned VPC endpoints.</p>', ], ], 'GetCredentialsRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCredentialsResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCustomDomainAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCustomDomainAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRecoveryPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRecoveryPointResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetScheduledActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetScheduledActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTableRestoreStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTableRestoreStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetUsageLimitRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetUsageLimitResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkgroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetWorkgroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'IamRoleArn' => [ 'base' => NULL, 'refs' => [ 'CreateScheduledActionRequest$roleArn' => '<p>The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the Amazon Redshift Management Guide</p>', 'IamRoleArnList$member' => NULL, 'ScheduledActionResponse$roleArn' => '<p>The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the Amazon Redshift Management Guide</p>', 'UpdateScheduledActionRequest$roleArn' => '<p>The ARN of the IAM role to assume to run the scheduled action. This IAM role must have permission to run the Amazon Redshift Serverless API operation in the scheduled action. This IAM role must allow the Amazon Redshift scheduler to schedule creating snapshots (Principal scheduler.redshift.amazonaws.com) to assume permissions on your behalf. For more information about the IAM role to use with the Amazon Redshift scheduler, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html">Using Identity-Based Policies for Amazon Redshift</a> in the Amazon Redshift Management Guide</p>', ], ], 'IamRoleArnList' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$iamRoles' => '<p>A list of IAM roles to associate with the namespace.</p>', 'Namespace$iamRoles' => '<p>A list of IAM roles to associate with the namespace.</p>', 'UpdateNamespaceRequest$iamRoles' => '<p>A list of IAM roles to associate with the namespace. This parameter must be updated together with <code>defaultIamRoleArn</code>.</p>', ], ], 'InsufficientCapacityException' => [ 'base' => '<p>There is an insufficient capacity to perform the action.</p>', 'refs' => [], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ConvertRecoveryPointToSnapshotRequest$retentionPeriod' => '<p>How long to retain the snapshot.</p>', 'CreateSnapshotCopyConfigurationRequest$snapshotRetentionPeriod' => '<p>The retention period of the snapshots that you copy to the destination Amazon Web Services Region.</p>', 'CreateSnapshotRequest$retentionPeriod' => '<p>How long to retain the created snapshot.</p>', 'CreateSnapshotScheduleActionParameters$retentionPeriod' => '<p>The retention period of the snapshot created by the scheduled action.</p>', 'CreateWorkgroupRequest$baseCapacity' => '<p>The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).</p>', 'CreateWorkgroupRequest$maxCapacity' => '<p>The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is specified in RPUs.</p>', 'CreateWorkgroupRequest$port' => '<p>The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.</p>', 'DeleteNamespaceRequest$finalSnapshotRetentionPeriod' => '<p>How long to retain the final snapshot.</p>', 'Endpoint$port' => '<p>The port that Amazon Redshift Serverless listens on.</p>', 'EndpointAccess$port' => '<p>The port number on which Amazon Redshift Serverless accepts incoming connections.</p>', 'GetCredentialsRequest$durationSeconds' => '<p>The number of seconds until the returned temporary password expires. The minimum is 900 seconds, and the maximum is 3600 seconds.</p>', 'Snapshot$snapshotRemainingDays' => '<p>The amount of days until the snapshot is deleted.</p>', 'Snapshot$snapshotRetentionPeriod' => '<p>The period of time, in days, of how long the snapshot is retained.</p>', 'SnapshotCopyConfiguration$snapshotRetentionPeriod' => '<p>The retention period of snapshots that are copied to the destination Amazon Web Services Region.</p>', 'UpdateSnapshotCopyConfigurationRequest$snapshotRetentionPeriod' => '<p>The new retention period of how long to keep a snapshot in the destination Amazon Web Services Region.</p>', 'UpdateSnapshotRequest$retentionPeriod' => '<p>The new retention period of the snapshot.</p>', 'UpdateWorkgroupRequest$baseCapacity' => '<p>The new base data warehouse capacity in Redshift Processing Units (RPUs).</p>', 'UpdateWorkgroupRequest$maxCapacity' => '<p>The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is specified in RPUs.</p>', 'UpdateWorkgroupRequest$port' => '<p>The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.</p>', 'Workgroup$baseCapacity' => '<p>The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).</p>', 'Workgroup$maxCapacity' => '<p>The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. The max capacity is specified in RPUs.</p>', 'Workgroup$port' => '<p>The custom port to use when connecting to a workgroup. Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.</p>', ], ], 'InternalServerException' => [ 'base' => '<p>The request processing has failed because of an unknown error, exception or failure.</p>', 'refs' => [], ], 'InvalidPaginationException' => [ 'base' => '<p>The provided pagination token is invalid.</p>', 'refs' => [], ], 'IpAddressType' => [ 'base' => NULL, 'refs' => [ 'CreateWorkgroupRequest$ipAddressType' => '<p>The IP address type that the workgroup supports. Possible values are <code>ipv4</code> and <code>dualstack</code>.</p>', 'UpdateWorkgroupRequest$ipAddressType' => '<p>The IP address type that the workgroup supports. Possible values are <code>ipv4</code> and <code>dualstack</code>.</p>', 'Workgroup$ipAddressType' => '<p>The IP address type that the workgroup supports. Possible values are <code>ipv4</code> and <code>dualstack</code>.</p>', ], ], 'Ipv6CidrBlockNotFoundException' => [ 'base' => '<p>There are no subnets in your VPC with associated IPv6 CIDR blocks. To use dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.</p>', 'refs' => [], ], 'KmsKeyId' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$adminPasswordSecretKmsKeyId' => '<p>The ID of the Key Management Service (KMS) key used to encrypt and store the namespace\'s admin credentials secret. You can only use this parameter if <code>manageAdminPassword</code> is true.</p>', 'CreateSnapshotCopyConfigurationRequest$destinationKmsKeyId' => '<p>The KMS key to use to encrypt your snapshots in the destination Amazon Web Services Region.</p>', 'Namespace$adminPasswordSecretKmsKeyId' => '<p>The ID of the Key Management Service (KMS) key used to encrypt and store the namespace\'s admin credentials secret.</p>', 'RestoreFromSnapshotRequest$adminPasswordSecretKmsKeyId' => '<p>The ID of the Key Management Service (KMS) key used to encrypt and store the namespace\'s admin credentials secret.</p>', 'Snapshot$adminPasswordSecretKmsKeyId' => '<p>The ID of the Key Management Service (KMS) key used to encrypt and store the namespace\'s admin credentials secret.</p>', 'Snapshot$kmsKeyId' => '<p>The unique identifier of the KMS key used to encrypt the snapshot.</p>', 'SnapshotCopyConfiguration$destinationKmsKeyId' => '<p>The ID of the KMS key to use to encrypt your snapshots in the destination Amazon Web Services Region.</p>', 'UpdateNamespaceRequest$adminPasswordSecretKmsKeyId' => '<p>The ID of the Key Management Service (KMS) key used to encrypt and store the namespace\'s admin credentials secret. You can only use this parameter if <code>manageAdminPassword</code> is true.</p>', ], ], 'ListCustomDomainAssociationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCustomDomainAssociationsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListCustomDomainAssociationsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to display the next page of results.</p>', ], ], 'ListCustomDomainAssociationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListEndpointAccessRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListEndpointAccessRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to display the next page of results.</p>', ], ], 'ListEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListNamespacesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListNamespacesRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListNamespacesRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to display the next page of results.</p>', ], ], 'ListNamespacesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRecoveryPointsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListRecoveryPointsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to display the next page of results.</p>', ], ], 'ListRecoveryPointsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListScheduledActionsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListScheduledActionsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListScheduledActionsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. Use <code>nextToken</code> to display the next page of results.</p>', ], ], 'ListScheduledActionsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSnapshotCopyConfigurationsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSnapshotCopyConfigurationsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSnapshotCopyConfigurationsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to display the next page of results.</p>', ], ], 'ListSnapshotCopyConfigurationsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListSnapshotsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListSnapshotsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListSnapshotsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to display the next page of results.</p>', ], ], 'ListSnapshotsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTableRestoreStatusRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTableRestoreStatusRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListTableRestoreStatusRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use nextToken to display the next page of results.</p>', ], ], 'ListTableRestoreStatusResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListUsageLimitsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListUsageLimitsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListUsageLimitsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to get the next page of results. The default is 100.</p>', ], ], 'ListUsageLimitsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkgroupsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListWorkgroupsRequestMaxResultsInteger' => [ 'base' => NULL, 'refs' => [ 'ListWorkgroupsRequest$maxResults' => '<p>An optional parameter that specifies the maximum number of results to return. You can use <code>nextToken</code> to display the next page of results.</p>', ], ], 'ListWorkgroupsResponse' => [ 'base' => NULL, 'refs' => [], ], 'LogExport' => [ 'base' => NULL, 'refs' => [ 'LogExportList$member' => NULL, ], ], 'LogExportList' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$logExports' => '<p>The types of logs the namespace can export. Available export types are <code>userlog</code>, <code>connectionlog</code>, and <code>useractivitylog</code>.</p>', 'Namespace$logExports' => '<p>The types of logs the namespace can export. Available export types are User log, Connection log, and User activity log.</p>', 'UpdateNamespaceRequest$logExports' => '<p>The types of logs the namespace can export. The export types are <code>userlog</code>, <code>connectionlog</code>, and <code>useractivitylog</code>.</p>', ], ], 'Long' => [ 'base' => NULL, 'refs' => [ 'CreateUsageLimitRequest$amount' => '<p>The limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.</p>', 'Snapshot$elapsedTimeInSeconds' => '<p>The amount of time it took to back up data into a snapshot.</p>', 'Snapshot$estimatedSecondsToCompletion' => '<p>The estimated amount of seconds until the snapshot completes backup.</p>', 'TableRestoreStatus$progressInMegaBytes' => '<p>The amount of data restored to the new table so far, in megabytes (MB).</p>', 'TableRestoreStatus$totalDataInMegaBytes' => '<p>The total amount of data to restore to the new table, in megabytes (MB).</p>', 'UpdateUsageLimitRequest$amount' => '<p>The new limit amount. If time-based, this amount is in Redshift Processing Units (RPU) consumed per hour. If data-based, this amount is in terabytes (TB) of data transferred between Regions in cross-account sharing. The value must be a positive number.</p>', 'UsageLimit$amount' => '<p>The limit amount. If time-based, this amount is in RPUs consumed per hour. If data-based, this amount is in terabytes (TB). The value must be a positive number.</p>', ], ], 'Namespace' => [ 'base' => '<p>A collection of database objects and users.</p>', 'refs' => [ 'CreateNamespaceResponse$namespace' => '<p>The created namespace object.</p>', 'DeleteNamespaceResponse$namespace' => '<p>The deleted namespace object.</p>', 'GetNamespaceResponse$namespace' => '<p>The returned namespace object.</p>', 'NamespaceList$member' => NULL, 'RestoreFromRecoveryPointResponse$namespace' => '<p>The namespace that data was restored into.</p>', 'RestoreFromSnapshotResponse$namespace' => NULL, 'UpdateNamespaceResponse$namespace' => '<p>A list of tag instances.</p>', ], ], 'NamespaceList' => [ 'base' => NULL, 'refs' => [ 'ListNamespacesResponse$namespaces' => '<p>The list of returned namespaces.</p>', ], ], 'NamespaceName' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$namespaceName' => '<p>The name of the namespace.</p>', 'CreateScheduledActionRequest$namespaceName' => '<p>The name of the namespace for which to create a scheduled action.</p>', 'CreateSnapshotCopyConfigurationRequest$namespaceName' => '<p>The name of the namespace to copy snapshots from.</p>', 'CreateSnapshotScheduleActionParameters$namespaceName' => '<p>The name of the namespace for which you want to configure a scheduled action to create a snapshot.</p>', 'CreateWorkgroupRequest$namespaceName' => '<p>The name of the namespace to associate with the workgroup.</p>', 'DeleteNamespaceRequest$namespaceName' => '<p>The name of the namespace to delete.</p>', 'GetNamespaceRequest$namespaceName' => '<p>The name of the namespace to retrieve information for.</p>', 'ListRecoveryPointsRequest$namespaceName' => '<p>The name of the namespace to list recovery points for.</p>', 'ListScheduledActionsRequest$namespaceName' => '<p>The name of namespace associated with the scheduled action to retrieve.</p>', 'ListSnapshotCopyConfigurationsRequest$namespaceName' => '<p>The namespace from which to list all snapshot copy configurations.</p>', 'Namespace$namespaceName' => '<p>The name of the namespace. Must be between 3-64 alphanumeric characters in lowercase, and it cannot be a reserved word. A list of reserved words can be found in <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html">Reserved Words</a> in the Amazon Redshift Database Developer Guide.</p>', 'RecoveryPoint$namespaceName' => '<p>The name of the namespace the recovery point is associated with.</p>', 'RestoreFromRecoveryPointRequest$namespaceName' => '<p>The name of the namespace to restore data into.</p>', 'RestoreFromSnapshotRequest$namespaceName' => '<p>The name of the namespace to restore the snapshot to.</p>', 'ScheduledActionAssociation$namespaceName' => '<p>Name of associated Amazon Redshift Serverless namespace.</p>', 'ScheduledActionResponse$namespaceName' => '<p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger.</p>', 'SnapshotCopyConfiguration$namespaceName' => '<p>The name of the namespace to copy snapshots from in the source Amazon Web Services Region.</p>', 'UpdateNamespaceRequest$namespaceName' => '<p>The name of the namespace to update. You can\'t update the name of a namespace once it is created.</p>', ], ], 'NamespaceStatus' => [ 'base' => NULL, 'refs' => [ 'Namespace$status' => '<p>The status of the namespace.</p>', ], ], 'NetworkInterface' => [ 'base' => '<p>Contains information about a network interface in an Amazon Redshift Serverless managed VPC endpoint. </p>', 'refs' => [ 'NetworkInterfaceList$member' => NULL, ], ], 'NetworkInterfaceList' => [ 'base' => NULL, 'refs' => [ 'VpcEndpoint$networkInterfaces' => '<p>One or more network interfaces of the endpoint. Also known as an interface endpoint.</p>', ], ], 'NextInvocationsList' => [ 'base' => NULL, 'refs' => [ 'ScheduledActionResponse$nextInvocations' => '<p>An array of timestamps of when the next scheduled actions will trigger.</p>', ], ], 'OwnerAccount' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointAccessRequest$ownerAccount' => '<p>The owner Amazon Web Services account for the Amazon Redshift Serverless workgroup.</p>', 'ListEndpointAccessRequest$ownerAccount' => '<p>The owner Amazon Web Services account for the Amazon Redshift Serverless workgroup.</p>', 'ListWorkgroupsRequest$ownerAccount' => '<p>The owner Amazon Web Services account for the Amazon Redshift Serverless workgroup.</p>', ], ], 'PaginationToken' => [ 'base' => NULL, 'refs' => [ 'ListCustomDomainAssociationsRequest$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListCustomDomainAssociationsResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListScheduledActionsRequest$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListScheduledActionsResponse$nextToken' => '<p>If nextToken is returned, there are more results available. The value of nextToken is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListSnapshotCopyConfigurationsRequest$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListSnapshotCopyConfigurationsResponse$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListTableRestoreStatusRequest$nextToken' => '<p>If your initial <code>ListTableRestoreStatus</code> operation returns a nextToken, you can include the returned <code>nextToken</code> in following <code>ListTableRestoreStatus</code> operations. This will return results on the next page.</p>', 'ListTableRestoreStatusResponse$nextToken' => '<p>If your initial <code>ListTableRestoreStatus</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in following <code>ListTableRestoreStatus</code> operations. This will returns results on the next page.</p>', 'ListUsageLimitsRequest$nextToken' => '<p>If your initial <code>ListUsageLimits</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in following <code>ListUsageLimits</code> operations, which returns results in the next page. </p>', 'ListUsageLimitsResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', ], ], 'ParameterKey' => [ 'base' => NULL, 'refs' => [ 'ConfigParameter$parameterKey' => '<p>The key of the parameter. The options are <code>auto_mv</code>, <code>datestyle</code>, <code>enable_case_sensitive_identifier</code>, <code>enable_user_activity_logging</code>, <code>query_group</code>, <code>search_path</code>, <code>require_ssl</code>, <code>use_fips_ssl</code>, and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless">Query monitoring metrics for Amazon Redshift Serverless</a>.</p>', ], ], 'ParameterValue' => [ 'base' => NULL, 'refs' => [ 'ConfigParameter$parameterValue' => '<p>The value of the parameter to set.</p>', ], ], 'PutResourcePolicyRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutResourcePolicyResponse' => [ 'base' => NULL, 'refs' => [], ], 'RecoveryPoint' => [ 'base' => '<p>The automatically created recovery point of a namespace. Recovery points are created every 30 minutes and kept for 24 hours.</p>', 'refs' => [ 'GetRecoveryPointResponse$recoveryPoint' => '<p>The returned recovery point object.</p>', 'RecoveryPointList$member' => NULL, ], ], 'RecoveryPointList' => [ 'base' => NULL, 'refs' => [ 'ListRecoveryPointsResponse$recoveryPoints' => '<p>The returned recovery point objects.</p>', ], ], 'RedshiftIdcApplicationArn' => [ 'base' => NULL, 'refs' => [ 'CreateNamespaceRequest$redshiftIdcApplicationArn' => '<p>The ARN for the Redshift application that integrates with IAM Identity Center.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource could not be found.</p>', 'refs' => [], ], 'ResourcePolicy' => [ 'base' => '<p>The resource policy object. Currently, you can use policies to share snapshots across Amazon Web Services accounts.</p>', 'refs' => [ 'GetResourcePolicyResponse$resourcePolicy' => '<p>The returned resource policy.</p>', 'PutResourcePolicyResponse$resourcePolicy' => '<p>The policy that was created or updated.</p>', ], ], 'RestoreFromRecoveryPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreFromRecoveryPointResponse' => [ 'base' => NULL, 'refs' => [], ], 'RestoreFromSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreFromSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'RestoreTableFromRecoveryPointRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreTableFromRecoveryPointResponse' => [ 'base' => NULL, 'refs' => [], ], 'RestoreTableFromSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'RestoreTableFromSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'Schedule' => [ 'base' => '<p>The schedule of when Amazon Redshift Serverless should run the scheduled action.</p>', 'refs' => [ 'CreateScheduledActionRequest$schedule' => '<p>The schedule for a one-time (at timestamp format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour. Times are in UTC.</p> <ul> <li> <p>Format of at timestamp is <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2016-03-04T17:27:00</code>.</p> </li> <li> <p>Format of cron expression is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For example, <code>"(0 10 ? * MON *)"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p> </li> </ul>', 'ScheduledActionResponse$schedule' => '<p>The schedule for a one-time (at timestamp format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour. Times are in UTC.</p> <ul> <li> <p>Format of at timestamp is <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2016-03-04T17:27:00</code>.</p> </li> <li> <p>Format of cron expression is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For example, <code>"(0 10 ? * MON *)"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p> </li> </ul>', 'UpdateScheduledActionRequest$schedule' => '<p>The schedule for a one-time (at timestamp format) or recurring (cron format) scheduled action. Schedule invocations must be separated by at least one hour. Times are in UTC.</p> <ul> <li> <p>Format of at timestamp is <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2016-03-04T17:27:00</code>.</p> </li> <li> <p>Format of cron expression is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For example, <code>"(0 10 ? * MON *)"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p> </li> </ul>', ], ], 'ScheduledActionAssociation' => [ 'base' => '<p>Contains names of objects associated with a scheduled action.</p>', 'refs' => [ 'ScheduledActionsList$member' => NULL, ], ], 'ScheduledActionName' => [ 'base' => NULL, 'refs' => [ 'CreateScheduledActionRequest$scheduledActionName' => '<p>The name of the scheduled action.</p>', 'DeleteScheduledActionRequest$scheduledActionName' => '<p>The name of the scheduled action to delete.</p>', 'GetScheduledActionRequest$scheduledActionName' => '<p>The name of the scheduled action.</p>', 'ScheduledActionAssociation$scheduledActionName' => '<p>Name of associated scheduled action.</p>', 'ScheduledActionResponse$scheduledActionName' => '<p>The name of the scheduled action.</p>', 'UpdateScheduledActionRequest$scheduledActionName' => '<p>The name of the scheduled action to update to.</p>', ], ], 'ScheduledActionResponse' => [ 'base' => '<p>The returned scheduled action object.</p>', 'refs' => [ 'CreateScheduledActionResponse$scheduledAction' => '<p>The returned <code>ScheduledAction</code> object that describes the properties of a scheduled action.</p>', 'DeleteScheduledActionResponse$scheduledAction' => '<p>The deleted scheduled action object.</p>', 'GetScheduledActionResponse$scheduledAction' => '<p>The returned scheduled action object.</p>', 'UpdateScheduledActionResponse$scheduledAction' => '<p>The ScheduledAction object that was updated.</p>', ], ], 'ScheduledActionsList' => [ 'base' => NULL, 'refs' => [ 'ListScheduledActionsResponse$scheduledActions' => '<p>All of the returned scheduled action association objects.</p>', ], ], 'SecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'SecurityGroupIdList$member' => NULL, ], ], 'SecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateWorkgroupRequest$securityGroupIds' => '<p>An array of security group IDs to associate with the workgroup.</p>', 'UpdateWorkgroupRequest$securityGroupIds' => '<p>An array of security group IDs to associate with the workgroup.</p>', 'Workgroup$securityGroupIds' => '<p>An array of security group IDs to associate with the workgroup.</p>', ], ], 'ServiceQuotaExceededException' => [ 'base' => '<p>The service limit was exceeded.</p>', 'refs' => [], ], 'Snapshot' => [ 'base' => '<p>A snapshot object that contains databases.</p>', 'refs' => [ 'ConvertRecoveryPointToSnapshotResponse$snapshot' => '<p>The snapshot converted from the recovery point.</p>', 'CreateSnapshotResponse$snapshot' => '<p>The created snapshot object.</p>', 'DeleteSnapshotResponse$snapshot' => '<p>The deleted snapshot object.</p>', 'GetSnapshotResponse$snapshot' => '<p>The returned snapshot object.</p>', 'SnapshotList$member' => NULL, 'UpdateSnapshotResponse$snapshot' => '<p>The updated snapshot object.</p>', ], ], 'SnapshotCopyConfiguration' => [ 'base' => '<p>The object that you configure to copy snapshots from one namespace to a namespace in another Amazon Web Services Region.</p>', 'refs' => [ 'CreateSnapshotCopyConfigurationResponse$snapshotCopyConfiguration' => '<p>The snapshot copy configuration object that is returned.</p>', 'DeleteSnapshotCopyConfigurationResponse$snapshotCopyConfiguration' => '<p>The deleted snapshot copy configuration object.</p>', 'SnapshotCopyConfigurations$member' => NULL, 'UpdateSnapshotCopyConfigurationResponse$snapshotCopyConfiguration' => '<p>The updated snapshot copy configuration object.</p>', ], ], 'SnapshotCopyConfigurations' => [ 'base' => NULL, 'refs' => [ 'ListSnapshotCopyConfigurationsResponse$snapshotCopyConfigurations' => '<p>All of the returned snapshot copy configurations.</p>', ], ], 'SnapshotList' => [ 'base' => NULL, 'refs' => [ 'ListSnapshotsResponse$snapshots' => '<p>All of the returned snapshot objects.</p>', ], ], 'SnapshotNamePrefix' => [ 'base' => NULL, 'refs' => [ 'CreateSnapshotScheduleActionParameters$snapshotNamePrefix' => '<p>A string prefix that is attached to the name of the snapshot created by the scheduled action. The final name of the snapshot is the string prefix appended by the date and time of when the snapshot was created.</p>', ], ], 'SnapshotStatus' => [ 'base' => NULL, 'refs' => [ 'Snapshot$status' => '<p>The status of the snapshot.</p>', ], ], 'State' => [ 'base' => NULL, 'refs' => [ 'ScheduledActionResponse$state' => '<p>The state of the scheduled action.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$code' => NULL, 'AccessDeniedException$message' => NULL, 'AccountIdList$member' => NULL, 'ConflictException$message' => NULL, 'ConvertRecoveryPointToSnapshotRequest$recoveryPointId' => '<p>The unique identifier of the recovery point.</p>', 'ConvertRecoveryPointToSnapshotRequest$snapshotName' => '<p>The name of the snapshot.</p>', 'CreateEndpointAccessRequest$endpointName' => '<p>The name of the VPC endpoint. An endpoint name must contain 1-30 characters. Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character must be a letter. The name can\'t contain two consecutive hyphens or end with a hyphen.</p>', 'CreateEndpointAccessRequest$workgroupName' => '<p>The name of the workgroup to associate with the VPC endpoint.</p>', 'CreateNamespaceRequest$dbName' => '<p>The name of the first database created in the namespace.</p>', 'CreateNamespaceRequest$defaultIamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.</p>', 'CreateNamespaceRequest$kmsKeyId' => '<p>The ID of the Amazon Web Services Key Management Service key used to encrypt your data.</p>', 'CreateScheduledActionRequest$scheduledActionDescription' => '<p>The description of the scheduled action.</p>', 'CreateSnapshotCopyConfigurationRequest$destinationRegion' => '<p>The destination Amazon Web Services Region that you want to copy snapshots to.</p>', 'CreateSnapshotRequest$namespaceName' => '<p>The namespace to create a snapshot for.</p>', 'CreateSnapshotRequest$snapshotName' => '<p>The name of the snapshot.</p>', 'CreateUsageLimitRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource to create the usage limit for.</p>', 'DeleteEndpointAccessRequest$endpointName' => '<p>The name of the VPC endpoint to delete.</p>', 'DeleteNamespaceRequest$finalSnapshotName' => '<p>The name of the snapshot to be created before the namespace is deleted.</p>', 'DeleteResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the policy to delete.</p>', 'DeleteSnapshotCopyConfigurationRequest$snapshotCopyConfigurationId' => '<p>The ID of the snapshot copy configuration to delete.</p>', 'DeleteSnapshotRequest$snapshotName' => '<p>The name of the snapshot to be deleted.</p>', 'DeleteUsageLimitRequest$usageLimitId' => '<p>The unique identifier of the usage limit to delete.</p>', 'Endpoint$address' => '<p>The DNS address of the VPC endpoint.</p>', 'EndpointAccess$address' => '<p>The DNS address of the endpoint.</p>', 'EndpointAccess$endpointArn' => '<p>The Amazon Resource Name (ARN) of the VPC endpoint.</p>', 'EndpointAccess$endpointName' => '<p>The name of the VPC endpoint.</p>', 'EndpointAccess$endpointStatus' => '<p>The status of the VPC endpoint.</p>', 'EndpointAccess$workgroupName' => '<p>The name of the workgroup associated with the endpoint.</p>', 'GetEndpointAccessRequest$endpointName' => '<p>The name of the VPC endpoint to return information for.</p>', 'GetRecoveryPointRequest$recoveryPointId' => '<p>The unique identifier of the recovery point to return information for.</p>', 'GetResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the resource to return.</p>', 'GetSnapshotRequest$ownerAccount' => '<p>The owner Amazon Web Services account of a snapshot shared with another user.</p>', 'GetSnapshotRequest$snapshotArn' => '<p>The Amazon Resource Name (ARN) of the snapshot to return.</p>', 'GetSnapshotRequest$snapshotName' => '<p>The name of the snapshot to return.</p>', 'GetTableRestoreStatusRequest$tableRestoreRequestId' => '<p>The ID of the <code>RestoreTableFromSnapshot</code> request to return status for.</p>', 'GetUsageLimitRequest$usageLimitId' => '<p>The unique identifier of the usage limit to return information for.</p>', 'InsufficientCapacityException$message' => NULL, 'InternalServerException$message' => NULL, 'InvalidPaginationException$message' => NULL, 'Ipv6CidrBlockNotFoundException$message' => NULL, 'ListEndpointAccessRequest$nextToken' => '<p>If your initial <code>ListEndpointAccess</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in following <code>ListEndpointAccess</code> operations, which returns results in the next page.</p>', 'ListEndpointAccessRequest$vpcId' => '<p>The unique identifier of the virtual private cloud with access to Amazon Redshift Serverless.</p>', 'ListEndpointAccessRequest$workgroupName' => '<p>The name of the workgroup associated with the VPC endpoint to return.</p>', 'ListEndpointAccessResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListNamespacesRequest$nextToken' => '<p>If your initial <code>ListNamespaces</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in following <code>ListNamespaces</code> operations, which returns results in the next page.</p>', 'ListNamespacesResponse$nextToken' => '<p>When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListRecoveryPointsRequest$namespaceArn' => '<p>The Amazon Resource Name (ARN) of the namespace from which to list recovery points.</p>', 'ListRecoveryPointsRequest$nextToken' => '<p>If your initial <code>ListRecoveryPoints</code> operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in following <code>ListRecoveryPoints</code> operations, which returns results in the next page.</p>', 'ListRecoveryPointsResponse$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListSnapshotsRequest$namespaceArn' => '<p>The Amazon Resource Name (ARN) of the namespace from which to list all snapshots.</p>', 'ListSnapshotsRequest$namespaceName' => '<p>The namespace from which to list all snapshots.</p>', 'ListSnapshotsRequest$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListSnapshotsRequest$ownerAccount' => '<p>The owner Amazon Web Services account of the snapshot.</p>', 'ListSnapshotsResponse$nextToken' => '<p>If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.</p>', 'ListTableRestoreStatusRequest$namespaceName' => '<p>The namespace from which to list all of the statuses of <code>RestoreTableFromSnapshot</code> operations .</p>', 'ListTableRestoreStatusRequest$workgroupName' => '<p>The workgroup from which to list all of the statuses of <code>RestoreTableFromSnapshot</code> operations.</p>', 'ListUsageLimitsRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) associated with the resource whose usage limits you want to list.</p>', 'ListWorkgroupsRequest$nextToken' => '<p>If your initial ListWorkgroups operation returns a <code>nextToken</code>, you can include the returned <code>nextToken</code> in following ListNamespaces operations, which returns results in the next page.</p>', 'ListWorkgroupsResponse$nextToken' => '<p> If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, make the call again using the returned token.</p>', 'Namespace$adminPasswordSecretArn' => '<p>The Amazon Resource Name (ARN) for the namespace\'s admin user credentials secret.</p>', 'Namespace$dbName' => '<p>The name of the first database created in the namespace.</p>', 'Namespace$defaultIamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace.</p>', 'Namespace$kmsKeyId' => '<p>The ID of the Amazon Web Services Key Management Service key used to encrypt your data.</p>', 'Namespace$namespaceArn' => '<p>The Amazon Resource Name (ARN) associated with a namespace.</p>', 'Namespace$namespaceId' => '<p>The unique identifier of a namespace.</p>', 'NetworkInterface$availabilityZone' => '<p>The availability Zone.</p>', 'NetworkInterface$ipv6Address' => '<p>The IPv6 address of the network interface within the subnet.</p>', 'NetworkInterface$networkInterfaceId' => '<p>The unique identifier of the network interface.</p>', 'NetworkInterface$privateIpAddress' => '<p>The IPv4 address of the network interface within the subnet.</p>', 'NetworkInterface$subnetId' => '<p>The unique identifier of the subnet.</p>', 'PutResourcePolicyRequest$policy' => '<p>The policy to create or update. For example, the following policy grants a user authorization to restore a snapshot.</p> <p> <code>"{\\"Version\\": \\"2012-10-17\\", \\"Statement\\" : [{ \\"Sid\\": \\"AllowUserRestoreFromSnapshot\\", \\"Principal\\":{\\"AWS\\": [\\"739247239426\\"]}, \\"Action\\": [\\"redshift-serverless:RestoreFromSnapshot\\"] , \\"Effect\\": \\"Allow\\" }]}"</code> </p>', 'PutResourcePolicyRequest$resourceArn' => '<p>The Amazon Resource Name (ARN) of the account to create or update a resource policy for.</p>', 'RecoveryPoint$namespaceArn' => '<p>The Amazon Resource Name (ARN) of the namespace the recovery point is associated with.</p>', 'RecoveryPoint$recoveryPointId' => '<p>The unique identifier of the recovery point.</p>', 'ResourceNotFoundException$message' => NULL, 'ResourcePolicy$policy' => '<p>The resource policy.</p>', 'ResourcePolicy$resourceArn' => '<p>The Amazon Resource Name (ARN) of the policy.</p>', 'RestoreFromRecoveryPointRequest$recoveryPointId' => '<p>The unique identifier of the recovery point to restore from.</p>', 'RestoreFromRecoveryPointResponse$recoveryPointId' => '<p>The unique identifier of the recovery point used for the restore.</p>', 'RestoreFromSnapshotRequest$ownerAccount' => '<p>The Amazon Web Services account that owns the snapshot.</p>', 'RestoreFromSnapshotRequest$snapshotArn' => '<p>The Amazon Resource Name (ARN) of the snapshot to restore from. Required if restoring from Amazon Redshift Serverless to a provisioned cluster. Must not be specified at the same time as <code>snapshotName</code>.</p> <p>The format of the ARN is arn:aws:redshift:&lt;region&gt;:&lt;account_id&gt;:snapshot:&lt;cluster_identifier&gt;/&lt;snapshot_identifier&gt;.</p>', 'RestoreFromSnapshotRequest$snapshotName' => '<p>The name of the snapshot to restore from. Must not be specified at the same time as <code>snapshotArn</code>.</p>', 'RestoreFromSnapshotResponse$ownerAccount' => '<p>The owner Amazon Web Services; account of the snapshot that was restored.</p>', 'RestoreFromSnapshotResponse$snapshotName' => '<p>The name of the snapshot used to restore the namespace.</p>', 'RestoreTableFromRecoveryPointRequest$namespaceName' => '<p>Namespace of the recovery point to restore from.</p>', 'RestoreTableFromRecoveryPointRequest$newTableName' => '<p>The name of the table to create from the restore operation.</p>', 'RestoreTableFromRecoveryPointRequest$recoveryPointId' => '<p>The ID of the recovery point to restore the table from.</p>', 'RestoreTableFromRecoveryPointRequest$sourceDatabaseName' => '<p>The name of the source database that contains the table being restored.</p>', 'RestoreTableFromRecoveryPointRequest$sourceSchemaName' => '<p>The name of the source schema that contains the table being restored.</p>', 'RestoreTableFromRecoveryPointRequest$sourceTableName' => '<p>The name of the source table being restored.</p>', 'RestoreTableFromRecoveryPointRequest$targetDatabaseName' => '<p>The name of the database to restore the table to.</p>', 'RestoreTableFromRecoveryPointRequest$targetSchemaName' => '<p>The name of the schema to restore the table to.</p>', 'RestoreTableFromRecoveryPointRequest$workgroupName' => '<p>The workgroup to restore the table to.</p>', 'RestoreTableFromSnapshotRequest$namespaceName' => '<p>The namespace of the snapshot to restore from.</p>', 'RestoreTableFromSnapshotRequest$newTableName' => '<p>The name of the table to create from the restore operation.</p>', 'RestoreTableFromSnapshotRequest$snapshotName' => '<p>The name of the snapshot to restore the table from.</p>', 'RestoreTableFromSnapshotRequest$sourceDatabaseName' => '<p>The name of the source database that contains the table being restored.</p>', 'RestoreTableFromSnapshotRequest$sourceSchemaName' => '<p>The name of the source schema that contains the table being restored.</p>', 'RestoreTableFromSnapshotRequest$sourceTableName' => '<p>The name of the source table being restored.</p>', 'RestoreTableFromSnapshotRequest$targetDatabaseName' => '<p>The name of the database to restore the table to.</p>', 'RestoreTableFromSnapshotRequest$targetSchemaName' => '<p>The name of the schema to restore the table to.</p>', 'RestoreTableFromSnapshotRequest$workgroupName' => '<p>The workgroup to restore the table to.</p>', 'Schedule$cron' => '<p>The cron expression to use to schedule a recurring scheduled action. Schedule invocations must be separated by at least one hour. Times are in UTC.</p> <p>Format of cron expressions is <code>(Minutes Hours Day-of-month Month Day-of-week Year)</code>. For example, <code>"(0 10 ? * MON *)"</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions">Cron Expressions</a> in the <i>Amazon CloudWatch Events User Guide</i>.</p>', 'ScheduledActionResponse$scheduledActionDescription' => '<p>The description of the scheduled action.</p>', 'ScheduledActionResponse$scheduledActionUuid' => '<p>The uuid of the scheduled action.</p>', 'ServiceQuotaExceededException$message' => NULL, 'Snapshot$adminPasswordSecretArn' => '<p>The Amazon Resource Name (ARN) for the namespace\'s admin user credentials secret.</p>', 'Snapshot$adminUsername' => '<p>The username of the database within a snapshot.</p>', 'Snapshot$namespaceArn' => '<p>The Amazon Resource Name (ARN) of the namespace the snapshot was created from.</p>', 'Snapshot$namespaceName' => '<p>The name of the namepsace.</p>', 'Snapshot$ownerAccount' => '<p>The owner Amazon Web Services; account of the snapshot.</p>', 'Snapshot$snapshotArn' => '<p>The Amazon Resource Name (ARN) of the snapshot.</p>', 'Snapshot$snapshotName' => '<p>The name of the snapshot.</p>', 'SnapshotCopyConfiguration$destinationRegion' => '<p>The destination Amazon Web Services Region to copy snapshots to.</p>', 'SnapshotCopyConfiguration$snapshotCopyConfigurationArn' => '<p>The ARN of the snapshot copy configuration object.</p>', 'SnapshotCopyConfiguration$snapshotCopyConfigurationId' => '<p>The ID of the snapshot copy configuration object.</p>', 'TableRestoreStatus$message' => '<p>A message that explains the returned status. For example, if the status of the operation is <code>FAILED</code>, the message explains why the operation failed.</p>', 'TableRestoreStatus$namespaceName' => '<p>The namespace of the table being restored from.</p>', 'TableRestoreStatus$newTableName' => '<p>The name of the table to create from the restore operation.</p>', 'TableRestoreStatus$recoveryPointId' => '<p>The ID of the recovery point being restored from.</p>', 'TableRestoreStatus$snapshotName' => '<p>The name of the snapshot being restored from.</p>', 'TableRestoreStatus$sourceDatabaseName' => '<p>The name of the source database being restored from.</p>', 'TableRestoreStatus$sourceSchemaName' => '<p>The name of the source schema being restored from.</p>', 'TableRestoreStatus$sourceTableName' => '<p>The name of the source table being restored from.</p>', 'TableRestoreStatus$status' => '<p>A value that describes the current state of the table restore request. Possible values are <code>SUCCEEDED</code>, <code>FAILED</code>, <code>CANCELED</code>, <code>PENDING</code>, and <code>IN_PROGRESS</code>.</p>', 'TableRestoreStatus$tableRestoreRequestId' => '<p>The ID of the RestoreTableFromSnapshot request.</p>', 'TableRestoreStatus$targetDatabaseName' => '<p>The name of the database to restore to.</p>', 'TableRestoreStatus$targetSchemaName' => '<p>The name of the schema to restore to.</p>', 'TableRestoreStatus$workgroupName' => '<p>The name of the workgroup being restored from.</p>', 'ThrottlingException$code' => NULL, 'ThrottlingException$message' => NULL, 'TooManyTagsException$message' => NULL, 'UpdateEndpointAccessRequest$endpointName' => '<p>The name of the VPC endpoint to update.</p>', 'UpdateNamespaceRequest$defaultIamRoleArn' => '<p>The Amazon Resource Name (ARN) of the IAM role to set as a default in the namespace. This parameter must be updated together with <code>iamRoles</code>.</p>', 'UpdateNamespaceRequest$kmsKeyId' => '<p>The ID of the Amazon Web Services Key Management Service key used to encrypt your data.</p>', 'UpdateScheduledActionRequest$scheduledActionDescription' => '<p>The descripion of the scheduled action to update to.</p>', 'UpdateSnapshotCopyConfigurationRequest$snapshotCopyConfigurationId' => '<p>The ID of the snapshot copy configuration to update.</p>', 'UpdateSnapshotRequest$snapshotName' => '<p>The name of the snapshot.</p>', 'UpdateUsageLimitRequest$usageLimitId' => '<p>The identifier of the usage limit to update.</p>', 'UsageLimit$resourceArn' => '<p>The Amazon Resource Name (ARN) that identifies the Amazon Redshift Serverless resource.</p>', 'UsageLimit$usageLimitArn' => '<p>The Amazon Resource Name (ARN) of the resource associated with the usage limit.</p>', 'UsageLimit$usageLimitId' => '<p>The identifier of the usage limit.</p>', 'ValidationException$message' => NULL, 'VpcEndpoint$vpcEndpointId' => '<p>The connection endpoint ID for connecting to Amazon Redshift Serverless.</p>', 'VpcEndpoint$vpcId' => '<p>The VPC identifier that the endpoint is associated with.</p>', 'VpcIds$member' => NULL, 'VpcSecurityGroupMembership$status' => '<p>The status of the VPC security group.</p>', 'Workgroup$namespaceName' => '<p>The namespace the workgroup is associated with.</p>', 'Workgroup$patchVersion' => '<p>The patch version of your Amazon Redshift Serverless workgroup. For more information about patch versions, see <a href="https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html">Cluster versions for Amazon Redshift</a>.</p>', 'Workgroup$workgroupArn' => '<p>The Amazon Resource Name (ARN) that links to the workgroup.</p>', 'Workgroup$workgroupId' => '<p>The unique identifier of the workgroup.</p>', 'Workgroup$workgroupVersion' => '<p>The Amazon Redshift Serverless version of your workgroup. For more information about Amazon Redshift Serverless versions, see<a href="https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html">Cluster versions for Amazon Redshift</a>.</p>', ], ], 'SubnetId' => [ 'base' => NULL, 'refs' => [ 'SubnetIdList$member' => NULL, ], ], 'SubnetIdList' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointAccessRequest$subnetIds' => '<p>The unique identifers of subnets from which Amazon Redshift Serverless chooses one to deploy a VPC endpoint.</p>', 'CreateWorkgroupRequest$subnetIds' => '<p>An array of VPC subnet IDs to associate with the workgroup.</p>', 'EndpointAccess$subnetIds' => '<p>The unique identifier of subnets where Amazon Redshift Serverless choose to deploy the VPC endpoint.</p>', 'UpdateWorkgroupRequest$subnetIds' => '<p>An array of VPC subnet IDs to associate with the workgroup.</p>', 'Workgroup$subnetIds' => '<p>An array of subnet IDs the workgroup is associated with.</p>', ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'Association$customDomainCertificateExpiryTime' => '<p>The expiration time for the certificate.</p>', 'CreateCustomDomainAssociationResponse$customDomainCertificateExpiryTime' => '<p>The expiration time for the certificate.</p>', 'EndpointAccess$endpointCreateTime' => '<p>The time that the endpoint was created.</p>', 'GetCustomDomainAssociationResponse$customDomainCertificateExpiryTime' => '<p>The expiration time for the certificate.</p>', 'Namespace$creationDate' => '<p>The date of when the namespace was created.</p>', 'RecoveryPoint$recoveryPointCreateTime' => '<p>The time the recovery point is created.</p>', 'Snapshot$snapshotCreateTime' => '<p>The timestamp of when the snapshot was created.</p>', 'Snapshot$snapshotRetentionStartTime' => '<p>The timestamp of when data within the snapshot started getting retained.</p>', 'UpdateCustomDomainAssociationResponse$customDomainCertificateExpiryTime' => '<p>The expiration time for the certificate.</p>', 'Workgroup$creationDate' => '<p>The creation date of the workgroup.</p>', 'Workgroup$customDomainCertificateExpiryTime' => '<p>The expiration time for the certificate.</p>', ], ], 'TableRestoreStatus' => [ 'base' => '<p>Contains information about a table restore request.</p>', 'refs' => [ 'GetTableRestoreStatusResponse$tableRestoreStatus' => '<p>The returned <code>TableRestoreStatus</code> object that contains information about the status of your <code>RestoreTableFromSnapshot</code> request.</p>', 'RestoreTableFromRecoveryPointResponse$tableRestoreStatus' => NULL, 'RestoreTableFromSnapshotResponse$tableRestoreStatus' => '<p>The TableRestoreStatus object that contains the status of the restore operation.</p>', 'TableRestoreStatusList$member' => NULL, ], ], 'TableRestoreStatusList' => [ 'base' => NULL, 'refs' => [ 'ListTableRestoreStatusResponse$tableRestoreStatuses' => '<p>The array of returned <code>TableRestoreStatus</code> objects.</p>', ], ], 'Tag' => [ 'base' => '<p>A map of key-value pairs.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The key to use in the tag.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>The tag or set of tags to remove from the resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'ConvertRecoveryPointToSnapshotRequest$tags' => '<p>An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag objects</a> to associate with the created snapshot.</p>', 'CreateNamespaceRequest$tags' => '<p>A list of tag instances.</p>', 'CreateSnapshotRequest$tags' => '<p>An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag objects</a> to associate with the snapshot.</p>', 'CreateSnapshotScheduleActionParameters$tags' => '<p>An array of <a href="https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html">Tag objects</a> to associate with the snapshot.</p>', 'CreateWorkgroupRequest$tags' => '<p>A array of tag instances.</p>', 'ListTagsForResourceResponse$tags' => '<p>A map of the key-value pairs assigned to the resource.</p>', 'TagResourceRequest$tags' => '<p>The map of the key-value pairs used to tag the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The value of the tag.</p>', ], ], 'TargetAction' => [ 'base' => '<p>A JSON format string of the Amazon Redshift Serverless API operation with input parameters. The following is an example of a target action.</p> <p> <code>"{"CreateSnapshot": {"NamespaceName": "sampleNamespace","SnapshotName": "sampleSnapshot", "retentionPeriod": "1"}}"</code> </p>', 'refs' => [ 'CreateScheduledActionRequest$targetAction' => NULL, 'ScheduledActionResponse$targetAction' => NULL, 'UpdateScheduledActionRequest$targetAction' => NULL, ], ], 'ThrottlingException' => [ 'base' => '<p>The request was denied due to request throttling.</p>', 'refs' => [], ], 'Timestamp' => [ 'base' => NULL, 'refs' => [ 'CreateScheduledActionRequest$endTime' => '<p>The end time in UTC when the schedule is no longer active. After this time, the scheduled action does not trigger.</p>', 'CreateScheduledActionRequest$startTime' => '<p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.</p>', 'GetCredentialsResponse$expiration' => '<p>The date and time the password in <code>DbPassword</code> expires.</p>', 'GetCredentialsResponse$nextRefreshTime' => '<p>The date and time of when the <code>DbUser</code> and <code>DbPassword</code> authorization refreshes.</p>', 'ListRecoveryPointsRequest$endTime' => '<p>The time when creation of the recovery point finished.</p>', 'ListRecoveryPointsRequest$startTime' => '<p>The time when the recovery point\'s creation was initiated.</p>', 'ListSnapshotsRequest$endTime' => '<p>The timestamp showing when the snapshot creation finished.</p>', 'ListSnapshotsRequest$startTime' => '<p>The time when the creation of the snapshot was initiated.</p>', 'NextInvocationsList$member' => NULL, 'Schedule$at' => '<p>The timestamp of when Amazon Redshift Serverless should run the scheduled action. Timestamp is in UTC. Format of at expression is <code>yyyy-mm-ddThh:mm:ss</code>. For example, <code>2016-03-04T17:27:00</code>.</p>', 'ScheduledActionResponse$endTime' => '<p>The end time of </p>', 'ScheduledActionResponse$startTime' => '<p>The start time in UTC when the schedule is active. Before this time, the scheduled action does not trigger.</p>', 'TableRestoreStatus$requestTime' => '<p>The time that the table restore request was made, in Universal Coordinated Time (UTC).</p>', 'UpdateScheduledActionRequest$endTime' => '<p>The end time in UTC of the scheduled action to update.</p>', 'UpdateScheduledActionRequest$startTime' => '<p>The start time in UTC of the scheduled action to update to.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>The request exceeded the number of tags allowed for a resource.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCustomDomainAssociationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCustomDomainAssociationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointAccessRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateEndpointAccessResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNamespaceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateNamespaceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateScheduledActionRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateScheduledActionResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSnapshotCopyConfigurationRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSnapshotCopyConfigurationResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSnapshotRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateSnapshotResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUsageLimitRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateUsageLimitResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkgroupRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateWorkgroupResponse' => [ 'base' => NULL, 'refs' => [], ], 'UsageLimit' => [ 'base' => '<p>The usage limit object.</p>', 'refs' => [ 'CreateUsageLimitResponse$usageLimit' => '<p>The returned usage limit object.</p>', 'DeleteUsageLimitResponse$usageLimit' => '<p>The deleted usage limit object.</p>', 'GetUsageLimitResponse$usageLimit' => '<p>The returned usage limit object.</p>', 'UpdateUsageLimitResponse$usageLimit' => '<p>The updated usage limit object.</p>', 'UsageLimits$member' => NULL, ], ], 'UsageLimitBreachAction' => [ 'base' => NULL, 'refs' => [ 'CreateUsageLimitRequest$breachAction' => '<p>The action that Amazon Redshift Serverless takes when the limit is reached. The default is log.</p>', 'UpdateUsageLimitRequest$breachAction' => '<p>The new action that Amazon Redshift Serverless takes when the limit is reached.</p>', 'UsageLimit$breachAction' => '<p>The action that Amazon Redshift Serverless takes when the limit is reached.</p>', ], ], 'UsageLimitPeriod' => [ 'base' => NULL, 'refs' => [ 'CreateUsageLimitRequest$period' => '<p>The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.</p>', 'UsageLimit$period' => '<p>The time period that the amount applies to. A weekly period begins on Sunday. The default is monthly.</p>', ], ], 'UsageLimitUsageType' => [ 'base' => NULL, 'refs' => [ 'CreateUsageLimitRequest$usageType' => '<p>The type of Amazon Redshift Serverless usage to create a usage limit for.</p>', 'ListUsageLimitsRequest$usageType' => '<p>The Amazon Redshift Serverless feature whose limits you want to see.</p>', 'UsageLimit$usageType' => '<p>The Amazon Redshift Serverless feature to limit.</p>', ], ], 'UsageLimits' => [ 'base' => NULL, 'refs' => [ 'ListUsageLimitsResponse$usageLimits' => '<p>An array of returned usage limit objects.</p>', ], ], 'ValidationException' => [ 'base' => '<p>The input failed to satisfy the constraints specified by an AWS service.</p>', 'refs' => [], ], 'VpcEndpoint' => [ 'base' => '<p>The connection endpoint for connecting to Amazon Redshift Serverless through the proxy.</p>', 'refs' => [ 'EndpointAccess$vpcEndpoint' => '<p>The connection endpoint for connecting to Amazon Redshift Serverless.</p>', 'VpcEndpointList$member' => NULL, ], ], 'VpcEndpointList' => [ 'base' => NULL, 'refs' => [ 'Endpoint$vpcEndpoints' => '<p>An array of <code>VpcEndpoint</code> objects.</p>', ], ], 'VpcIds' => [ 'base' => NULL, 'refs' => [ 'Workgroup$crossAccountVpcs' => '<p>A list of VPCs. Each entry is the unique identifier of a virtual private cloud with access to Amazon Redshift Serverless. If all of the VPCs for the grantee are allowed, it shows an asterisk.</p>', ], ], 'VpcSecurityGroupId' => [ 'base' => NULL, 'refs' => [ 'VpcSecurityGroupIdList$member' => NULL, 'VpcSecurityGroupMembership$vpcSecurityGroupId' => '<p>The unique identifier of the VPC security group.</p>', ], ], 'VpcSecurityGroupIdList' => [ 'base' => NULL, 'refs' => [ 'CreateEndpointAccessRequest$vpcSecurityGroupIds' => '<p>The unique identifiers of the security group that defines the ports, protocols, and sources for inbound traffic that you are authorizing into your endpoint.</p>', 'UpdateEndpointAccessRequest$vpcSecurityGroupIds' => '<p>The list of VPC security groups associated with the endpoint after the endpoint is modified.</p>', ], ], 'VpcSecurityGroupMembership' => [ 'base' => '<p>Describes the members of a VPC security group.</p>', 'refs' => [ 'VpcSecurityGroupMembershipList$member' => NULL, ], ], 'VpcSecurityGroupMembershipList' => [ 'base' => NULL, 'refs' => [ 'EndpointAccess$vpcSecurityGroups' => '<p>The security groups associated with the endpoint.</p>', ], ], 'Workgroup' => [ 'base' => '<p>The collection of computing resources from which an endpoint is created.</p>', 'refs' => [ 'CreateWorkgroupResponse$workgroup' => '<p>The created workgroup object.</p>', 'DeleteWorkgroupResponse$workgroup' => '<p>The deleted workgroup object.</p>', 'GetWorkgroupResponse$workgroup' => '<p>The returned workgroup object.</p>', 'UpdateWorkgroupResponse$workgroup' => '<p>The updated workgroup object.</p>', 'WorkgroupList$member' => NULL, ], ], 'WorkgroupList' => [ 'base' => NULL, 'refs' => [ 'ListWorkgroupsResponse$workgroups' => '<p>The returned array of workgroups.</p>', ], ], 'WorkgroupName' => [ 'base' => NULL, 'refs' => [ 'Association$workgroupName' => '<p>The name of the workgroup associated with the database.</p>', 'CreateCustomDomainAssociationRequest$workgroupName' => '<p>The name of the workgroup associated with the database.</p>', 'CreateCustomDomainAssociationResponse$workgroupName' => '<p>The name of the workgroup associated with the database.</p>', 'CreateWorkgroupRequest$workgroupName' => '<p>The name of the created workgroup.</p>', 'DeleteCustomDomainAssociationRequest$workgroupName' => '<p>The name of the workgroup associated with the database.</p>', 'DeleteWorkgroupRequest$workgroupName' => '<p>The name of the workgroup to be deleted.</p>', 'GetCredentialsRequest$workgroupName' => '<p>The name of the workgroup associated with the database.</p>', 'GetCustomDomainAssociationRequest$workgroupName' => '<p>The name of the workgroup associated with the database.</p>', 'GetCustomDomainAssociationResponse$workgroupName' => '<p>The name of the workgroup associated with the database.</p>', 'GetWorkgroupRequest$workgroupName' => '<p>The name of the workgroup to return information for.</p>', 'RecoveryPoint$workgroupName' => '<p>The name of the workgroup the recovery point is associated with.</p>', 'RestoreFromRecoveryPointRequest$workgroupName' => '<p>The name of the workgroup used to restore data.</p>', 'RestoreFromSnapshotRequest$workgroupName' => '<p>The name of the workgroup used to restore the snapshot.</p>', 'UpdateCustomDomainAssociationRequest$workgroupName' => '<p>The name of the workgroup associated with the database.</p>', 'UpdateCustomDomainAssociationResponse$workgroupName' => '<p>The name of the workgroup associated with the database.</p>', 'UpdateWorkgroupRequest$workgroupName' => '<p>The name of the workgroup to update. You can\'t update the name of a workgroup once it is created.</p>', 'Workgroup$workgroupName' => '<p>The name of the workgroup.</p>', ], ], 'WorkgroupStatus' => [ 'base' => NULL, 'refs' => [ 'Workgroup$status' => '<p>The status of the workgroup.</p>', ], ], ],];
