<?php
// This file was auto-generated from sdk-root/src/data/rolesanywhere/2018-05-10/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Identity and Access Management Roles Anywhere provides a secure way for your workloads such as servers, containers, and applications that run outside of Amazon Web Services to obtain temporary Amazon Web Services credentials. Your workloads can use the same IAM policies and roles you have for native Amazon Web Services applications to access Amazon Web Services resources. Using IAM Roles Anywhere eliminates the need to manage long-term credentials for workloads running outside of Amazon Web Services.</p> <p> To use IAM Roles Anywhere, your workloads must use X.509 certificates issued by their certificate authority (CA). You register the CA with IAM Roles Anywhere as a trust anchor to establish trust between your public key infrastructure (PKI) and IAM Roles Anywhere. If you don\'t manage your own PKI system, you can use Private Certificate Authority to create a CA and then use that to establish trust with IAM Roles Anywhere. </p> <p>This guide describes the IAM Roles Anywhere operations that you can call programmatically. For more information about IAM Roles Anywhere, see the <a href="https://docs.aws.amazon.com/rolesanywhere/latest/userguide/introduction.html">IAM Roles Anywhere User Guide</a>.</p>', 'operations' => [ 'CreateProfile' => '<p>Creates a <i>profile</i>, a list of the roles that Roles Anywhere service is trusted to assume. You use profiles to intersect permissions with IAM managed policies.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:CreateProfile</code>. </p>', 'CreateTrustAnchor' => '<p>Creates a trust anchor to establish trust between IAM Roles Anywhere and your certificate authority (CA). You can define a trust anchor as a reference to an Private Certificate Authority (Private CA) or by uploading a CA certificate. Your Amazon Web Services workloads can authenticate with the trust anchor using certificates issued by the CA in exchange for temporary Amazon Web Services credentials.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:CreateTrustAnchor</code>. </p>', 'DeleteAttributeMapping' => '<p>Delete an entry from the attribute mapping rules enforced by a given profile.</p>', 'DeleteCrl' => '<p>Deletes a certificate revocation list (CRL).</p> <p> <b>Required permissions: </b> <code>rolesanywhere:DeleteCrl</code>. </p>', 'DeleteProfile' => '<p>Deletes a profile.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:DeleteProfile</code>. </p>', 'DeleteTrustAnchor' => '<p>Deletes a trust anchor.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:DeleteTrustAnchor</code>. </p>', 'DisableCrl' => '<p>Disables a certificate revocation list (CRL).</p> <p> <b>Required permissions: </b> <code>rolesanywhere:DisableCrl</code>. </p>', 'DisableProfile' => '<p>Disables a profile. When disabled, temporary credential requests with this profile fail.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:DisableProfile</code>. </p>', 'DisableTrustAnchor' => '<p>Disables a trust anchor. When disabled, temporary credential requests specifying this trust anchor are unauthorized.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:DisableTrustAnchor</code>. </p>', 'EnableCrl' => '<p>Enables a certificate revocation list (CRL). When enabled, certificates stored in the CRL are unauthorized to receive session credentials.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:EnableCrl</code>. </p>', 'EnableProfile' => '<p>Enables temporary credential requests for a profile. </p> <p> <b>Required permissions: </b> <code>rolesanywhere:EnableProfile</code>. </p>', 'EnableTrustAnchor' => '<p>Enables a trust anchor. When enabled, certificates in the trust anchor chain are authorized for trust validation. </p> <p> <b>Required permissions: </b> <code>rolesanywhere:EnableTrustAnchor</code>. </p>', 'GetCrl' => '<p>Gets a certificate revocation list (CRL).</p> <p> <b>Required permissions: </b> <code>rolesanywhere:GetCrl</code>. </p>', 'GetProfile' => '<p>Gets a profile.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:GetProfile</code>. </p>', 'GetSubject' => '<p>Gets a <i>subject</i>, which associates a certificate identity with authentication attempts. The subject stores auditing information such as the status of the last authentication attempt, the certificate data used in the attempt, and the last time the associated identity attempted authentication. </p> <p> <b>Required permissions: </b> <code>rolesanywhere:GetSubject</code>. </p>', 'GetTrustAnchor' => '<p>Gets a trust anchor.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:GetTrustAnchor</code>. </p>', 'ImportCrl' => '<p>Imports the certificate revocation list (CRL). A CRL is a list of certificates that have been revoked by the issuing certificate Authority (CA).In order to be properly imported, a CRL must be in PEM format. IAM Roles Anywhere validates against the CRL before issuing credentials. </p> <p> <b>Required permissions: </b> <code>rolesanywhere:ImportCrl</code>. </p>', 'ListCrls' => '<p>Lists all certificate revocation lists (CRL) in the authenticated account and Amazon Web Services Region.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:ListCrls</code>. </p>', 'ListProfiles' => '<p>Lists all profiles in the authenticated account and Amazon Web Services Region.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:ListProfiles</code>. </p>', 'ListSubjects' => '<p>Lists the subjects in the authenticated account and Amazon Web Services Region.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:ListSubjects</code>. </p>', 'ListTagsForResource' => '<p>Lists the tags attached to the resource.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:ListTagsForResource</code>. </p>', 'ListTrustAnchors' => '<p>Lists the trust anchors in the authenticated account and Amazon Web Services Region.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:ListTrustAnchors</code>. </p>', 'PutAttributeMapping' => '<p>Put an entry in the attribute mapping rules that will be enforced by a given profile. A mapping specifies a certificate field and one or more specifiers that have contextual meanings.</p>', 'PutNotificationSettings' => '<p>Attaches a list of <i>notification settings</i> to a trust anchor.</p> <p>A notification setting includes information such as event name, threshold, status of the notification setting, and the channel to notify.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:PutNotificationSettings</code>. </p>', 'ResetNotificationSettings' => '<p>Resets the <i>custom notification setting</i> to IAM Roles Anywhere default setting. </p> <p> <b>Required permissions: </b> <code>rolesanywhere:ResetNotificationSettings</code>. </p>', 'TagResource' => '<p>Attaches tags to a resource.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:TagResource</code>. </p>', 'UntagResource' => '<p>Removes tags from the resource.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:UntagResource</code>. </p>', 'UpdateCrl' => '<p>Updates the certificate revocation list (CRL). A CRL is a list of certificates that have been revoked by the issuing certificate authority (CA). IAM Roles Anywhere validates against the CRL before issuing credentials.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:UpdateCrl</code>. </p>', 'UpdateProfile' => '<p>Updates a <i>profile</i>, a list of the roles that IAM Roles Anywhere service is trusted to assume. You use profiles to intersect permissions with IAM managed policies.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:UpdateProfile</code>. </p>', 'UpdateTrustAnchor' => '<p>Updates a trust anchor. You establish trust between IAM Roles Anywhere and your certificate authority (CA) by configuring a trust anchor. You can define a trust anchor as a reference to an Private Certificate Authority (Private CA) or by uploading a CA certificate. Your Amazon Web Services workloads can authenticate with the trust anchor using certificates issued by the CA in exchange for temporary Amazon Web Services credentials.</p> <p> <b>Required permissions: </b> <code>rolesanywhere:UpdateTrustAnchor</code>. </p>', ], 'shapes' => [ 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient access to perform this action.</p>', 'refs' => [], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', 'TagResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', 'UntagResourceRequest$resourceArn' => '<p>The ARN of the resource.</p>', ], ], 'AttributeMapping' => [ 'base' => '<p>A mapping applied to the authenticating end-entity certificate.</p>', 'refs' => [ 'AttributeMappings$member' => NULL, ], ], 'AttributeMappings' => [ 'base' => NULL, 'refs' => [ 'ProfileDetail$attributeMappings' => '<p>A mapping applied to the authenticating end-entity certificate.</p>', ], ], 'Blob' => [ 'base' => NULL, 'refs' => [ 'CrlDetail$crlData' => '<p>The state of the certificate revocation list (CRL) after a read or write operation.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$acceptRoleSessionName' => '<p>Used to determine if a custom role session name will be accepted in a temporary credential request.</p>', 'CreateProfileRequest$enabled' => '<p>Specifies whether the profile is enabled.</p>', 'CreateProfileRequest$requireInstanceProperties' => '<p>Specifies whether instance properties are required in temporary credential requests with this profile. </p>', 'CreateTrustAnchorRequest$enabled' => '<p>Specifies whether the trust anchor is enabled.</p>', 'CredentialSummary$enabled' => '<p>Indicates whether the credential is enabled.</p>', 'CredentialSummary$failed' => '<p>Indicates whether the temporary credential request was successful. </p>', 'CrlDetail$enabled' => '<p>Indicates whether the certificate revocation list (CRL) is enabled.</p>', 'ImportCrlRequest$enabled' => '<p>Specifies whether the certificate revocation list (CRL) is enabled.</p>', 'InstanceProperty$failed' => '<p>Indicates whether the temporary credential request was successful. </p>', 'NotificationSetting$enabled' => '<p>Indicates whether the notification setting is enabled.</p>', 'NotificationSettingDetail$enabled' => '<p>Indicates whether the notification setting is enabled.</p>', 'ProfileDetail$acceptRoleSessionName' => '<p>Used to determine if a custom role session name will be accepted in a temporary credential request.</p>', 'ProfileDetail$enabled' => '<p>Indicates whether the profile is enabled.</p>', 'ProfileDetail$requireInstanceProperties' => '<p>Specifies whether instance properties are required in temporary credential requests with this profile. </p>', 'SubjectDetail$enabled' => '<p>The enabled status of the subject.</p>', 'SubjectSummary$enabled' => '<p>The enabled status of the subject. </p>', 'TrustAnchorDetail$enabled' => '<p>Indicates whether the trust anchor is enabled.</p>', 'UpdateProfileRequest$acceptRoleSessionName' => '<p>Used to determine if a custom role session name will be accepted in a temporary credential request.</p>', ], ], 'CertificateField' => [ 'base' => NULL, 'refs' => [ 'AttributeMapping$certificateField' => '<p>Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.</p>', 'DeleteAttributeMappingRequest$certificateField' => '<p>Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.</p>', 'PutAttributeMappingRequest$certificateField' => '<p>Fields (x509Subject, x509Issuer and x509SAN) within X.509 certificates.</p>', ], ], 'CreateProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateProfileRequestDurationSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$durationSeconds' => '<p> Used to determine how long sessions vended using this profile are valid for. See the <code>Expiration</code> section of the <a href="https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object">CreateSession API documentation</a> page for more details. In requests, if this value is not provided, the default value will be 3600. </p>', ], ], 'CreateTrustAnchorRequest' => [ 'base' => NULL, 'refs' => [], ], 'CredentialSummaries' => [ 'base' => NULL, 'refs' => [ 'SubjectDetail$credentials' => '<p>The temporary session credentials vended at the last authenticating call with this subject.</p>', ], ], 'CredentialSummary' => [ 'base' => '<p>A record of a presented X509 credential from a temporary credential request. </p>', 'refs' => [ 'CredentialSummaries$member' => NULL, ], ], 'CrlDetail' => [ 'base' => '<p>The state of the certificate revocation list (CRL) after a read or write operation.</p>', 'refs' => [ 'CrlDetailResponse$crl' => '<p>The state of the certificate revocation list (CRL) after a read or write operation.</p>', 'CrlDetails$member' => NULL, ], ], 'CrlDetailResponse' => [ 'base' => NULL, 'refs' => [], ], 'CrlDetails' => [ 'base' => NULL, 'refs' => [ 'ListCrlsResponse$crls' => '<p>A list of certificate revocation lists (CRL). </p>', ], ], 'DeleteAttributeMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteAttributeMappingResponse' => [ 'base' => NULL, 'refs' => [], ], 'ImportCrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'ImportCrlRequestCrlDataBlob' => [ 'base' => NULL, 'refs' => [ 'ImportCrlRequest$crlData' => '<p>The x509 v3 specified certificate revocation list (CRL).</p>', ], ], 'InstanceProperties' => [ 'base' => NULL, 'refs' => [ 'SubjectDetail$instanceProperties' => '<p>The specified instance properties associated with the request.</p>', ], ], 'InstanceProperty' => [ 'base' => '<p>A key-value pair you set that identifies a property of the authenticating instance.</p>', 'refs' => [ 'InstanceProperties$member' => NULL, ], ], 'InstancePropertyMap' => [ 'base' => NULL, 'refs' => [ 'InstanceProperty$properties' => '<p>A list of instanceProperty objects. </p>', ], ], 'InstancePropertyMapKeyString' => [ 'base' => NULL, 'refs' => [ 'InstancePropertyMap$key' => NULL, ], ], 'InstancePropertyMapValueString' => [ 'base' => NULL, 'refs' => [ 'InstancePropertyMap$value' => NULL, ], ], 'Integer' => [ 'base' => NULL, 'refs' => [ 'ListRequest$pageSize' => '<p>The number of resources in the paginated list. </p>', 'ProfileDetail$durationSeconds' => '<p> Used to determine how long sessions vended using this profile are valid for. See the <code>Expiration</code> section of the <a href="https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object">CreateSession API documentation</a> page for more details. In requests, if this value is not provided, the default value will be 3600. </p>', ], ], 'ListCrlsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListProfilesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRequestNextTokenString' => [ 'base' => NULL, 'refs' => [ 'ListRequest$nextToken' => '<p>A token that indicates where the output should continue from, if a previous request did not show all results. To get the next results, make the request again with this value.</p>', ], ], 'ListSubjectsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTrustAnchorsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ManagedPolicyList' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$managedPolicyArns' => '<p>A list of managed policy ARNs that apply to the vended session credentials. </p>', 'ProfileDetail$managedPolicyArns' => '<p>A list of managed policy ARNs that apply to the vended session credentials. </p>', 'UpdateProfileRequest$managedPolicyArns' => '<p>A list of managed policy ARNs that apply to the vended session credentials. </p>', ], ], 'ManagedPolicyListMemberString' => [ 'base' => NULL, 'refs' => [ 'ManagedPolicyList$member' => NULL, ], ], 'MappingRule' => [ 'base' => '<p>A single mapping entry for each supported specifier or sub-field.</p>', 'refs' => [ 'MappingRules$member' => NULL, ], ], 'MappingRuleSpecifierString' => [ 'base' => NULL, 'refs' => [ 'MappingRule$specifier' => '<p>Specifier within a certificate field, such as CN, OU, or UID from the Subject field.</p>', ], ], 'MappingRules' => [ 'base' => NULL, 'refs' => [ 'AttributeMapping$mappingRules' => '<p>A list of mapping entries for every supported specifier or sub-field.</p>', 'PutAttributeMappingRequest$mappingRules' => '<p>A list of mapping entries for every supported specifier or sub-field.</p>', ], ], 'NotificationChannel' => [ 'base' => NULL, 'refs' => [ 'NotificationSetting$channel' => '<p>The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and Health Dashboard to notify for an event.</p> <note> <p>In the absence of a specific channel, IAM Roles Anywhere applies this setting to \'ALL\' channels.</p> </note>', 'NotificationSettingDetail$channel' => '<p>The specified channel of notification. IAM Roles Anywhere uses CloudWatch metrics, EventBridge, and Health Dashboard to notify for an event.</p> <note> <p>In the absence of a specific channel, IAM Roles Anywhere applies this setting to \'ALL\' channels.</p> </note>', 'NotificationSettingKey$channel' => '<p>The specified channel of notification.</p>', ], ], 'NotificationEvent' => [ 'base' => NULL, 'refs' => [ 'NotificationSetting$event' => '<p>The event to which this notification setting is applied.</p>', 'NotificationSettingDetail$event' => '<p>The event to which this notification setting is applied.</p>', 'NotificationSettingKey$event' => '<p>The notification setting event to reset.</p>', ], ], 'NotificationSetting' => [ 'base' => '<p> Customizable notification settings that will be applied to notification events. IAM Roles Anywhere consumes these settings while notifying across multiple channels - CloudWatch metrics, EventBridge, and Health Dashboard. </p>', 'refs' => [ 'NotificationSettings$member' => NULL, ], ], 'NotificationSettingDetail' => [ 'base' => '<p>The state of a notification setting.</p> <p>A notification setting includes information such as event name, threshold, status of the notification setting, and the channel to notify.</p>', 'refs' => [ 'NotificationSettingDetails$member' => NULL, ], ], 'NotificationSettingDetailConfiguredByString' => [ 'base' => NULL, 'refs' => [ 'NotificationSettingDetail$configuredBy' => '<p>The principal that configured the notification setting. For default settings configured by IAM Roles Anywhere, the value is <code>rolesanywhere.amazonaws.com</code>, and for customized notifications settings, it is the respective account ID. </p>', ], ], 'NotificationSettingDetailThresholdInteger' => [ 'base' => NULL, 'refs' => [ 'NotificationSettingDetail$threshold' => '<p>The number of days before a notification event.</p>', ], ], 'NotificationSettingDetails' => [ 'base' => NULL, 'refs' => [ 'TrustAnchorDetail$notificationSettings' => '<p>A list of notification settings to be associated to the trust anchor.</p>', ], ], 'NotificationSettingKey' => [ 'base' => '<p>A notification setting key to reset. A notification setting key includes the event and the channel. </p>', 'refs' => [ 'NotificationSettingKeys$member' => NULL, ], ], 'NotificationSettingKeys' => [ 'base' => NULL, 'refs' => [ 'ResetNotificationSettingsRequest$notificationSettingKeys' => '<p>A list of notification setting keys to reset. A notification setting key includes the event and the channel. </p>', ], ], 'NotificationSettingThresholdInteger' => [ 'base' => NULL, 'refs' => [ 'NotificationSetting$threshold' => '<p>The number of days before a notification event. This value is required for a notification setting that is enabled.</p>', ], ], 'NotificationSettings' => [ 'base' => NULL, 'refs' => [ 'CreateTrustAnchorRequest$notificationSettings' => '<p>A list of notification settings to be associated to the trust anchor.</p>', 'PutNotificationSettingsRequest$notificationSettings' => '<p>A list of notification settings to be associated to the trust anchor.</p>', ], ], 'ProfileArn' => [ 'base' => NULL, 'refs' => [ 'ProfileDetail$profileArn' => '<p>The ARN of the profile.</p>', ], ], 'ProfileDetail' => [ 'base' => '<p>The state of the profile after a read or write operation.</p>', 'refs' => [ 'DeleteAttributeMappingResponse$profile' => '<p>The state of the profile after a read or write operation.</p>', 'ProfileDetailResponse$profile' => '<p>The state of the profile after a read or write operation.</p>', 'ProfileDetails$member' => NULL, 'PutAttributeMappingResponse$profile' => '<p>The state of the profile after a read or write operation.</p>', ], ], 'ProfileDetailResponse' => [ 'base' => NULL, 'refs' => [], ], 'ProfileDetails' => [ 'base' => NULL, 'refs' => [ 'ListProfilesResponse$profiles' => '<p>A list of profiles.</p>', ], ], 'PutAttributeMappingRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutAttributeMappingResponse' => [ 'base' => NULL, 'refs' => [], ], 'PutNotificationSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutNotificationSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResetNotificationSettingsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ResetNotificationSettingsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ResourceName' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$name' => '<p>The name of the profile.</p>', 'CreateTrustAnchorRequest$name' => '<p>The name of the trust anchor.</p>', 'ImportCrlRequest$name' => '<p>The name of the certificate revocation list (CRL).</p>', 'ProfileDetail$name' => '<p>The name of the profile.</p>', 'TrustAnchorDetail$name' => '<p>The name of the trust anchor.</p>', 'UpdateCrlRequest$name' => '<p>The name of the Crl.</p>', 'UpdateProfileRequest$name' => '<p>The name of the profile.</p>', 'UpdateTrustAnchorRequest$name' => '<p>The name of the trust anchor.</p>', ], ], 'ResourceNotFoundException' => [ 'base' => '<p>The resource could not be found.</p>', 'refs' => [], ], 'RoleArn' => [ 'base' => NULL, 'refs' => [ 'RoleArnList$member' => NULL, ], ], 'RoleArnList' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$roleArns' => '<p>A list of IAM roles that this profile can assume in a temporary credential request.</p>', 'ProfileDetail$roleArns' => '<p>A list of IAM roles that this profile can assume in a temporary credential request.</p>', 'UpdateProfileRequest$roleArns' => '<p>A list of IAM roles that this profile can assume in a temporary credential request.</p>', ], ], 'ScalarCrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'ScalarProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'ScalarSubjectRequest' => [ 'base' => NULL, 'refs' => [], ], 'ScalarTrustAnchorRequest' => [ 'base' => NULL, 'refs' => [], ], 'Source' => [ 'base' => '<p>The trust anchor type and its related certificate data.</p>', 'refs' => [ 'CreateTrustAnchorRequest$source' => '<p>The trust anchor type and its related certificate data.</p>', 'TrustAnchorDetail$source' => '<p>The trust anchor type and its related certificate data.</p>', 'UpdateTrustAnchorRequest$source' => '<p>The trust anchor type and its related certificate data.</p>', ], ], 'SourceData' => [ 'base' => '<p>The data field of the trust anchor depending on its type. </p>', 'refs' => [ 'Source$sourceData' => '<p>The data field of the trust anchor depending on its type. </p>', ], ], 'SourceDataX509CertificateDataString' => [ 'base' => NULL, 'refs' => [ 'SourceData$x509CertificateData' => '<p>The PEM-encoded data for the certificate anchor. Included for trust anchors of type <code>CERTIFICATE_BUNDLE</code>. </p>', ], ], 'SpecifierList' => [ 'base' => NULL, 'refs' => [ 'DeleteAttributeMappingRequest$specifiers' => '<p>A list of specifiers of a certificate field; for example, CN, OU, UID from a Subject.</p>', ], ], 'String' => [ 'base' => NULL, 'refs' => [ 'AccessDeniedException$message' => NULL, 'CreateProfileRequest$sessionPolicy' => '<p>A session policy that applies to the trust boundary of the vended session credentials. </p>', 'CredentialSummary$issuer' => '<p>The fully qualified domain name of the issuing certificate for the presented end-entity certificate.</p>', 'CredentialSummary$serialNumber' => '<p>The serial number of the certificate.</p>', 'CredentialSummary$x509CertificateData' => '<p>The PEM-encoded data of the certificate.</p>', 'CrlDetail$crlArn' => '<p>The ARN of the certificate revocation list (CRL).</p>', 'CrlDetail$name' => '<p>The name of the certificate revocation list (CRL).</p>', 'CrlDetail$trustAnchorArn' => '<p>The ARN of the TrustAnchor the certificate revocation list (CRL) will provide revocation for. </p>', 'ListCrlsResponse$nextToken' => '<p>A token that indicates where the output should continue from, if a previous request did not show all results. To get the next results, make the request again with this value.</p>', 'ListProfilesResponse$nextToken' => '<p>A token that indicates where the output should continue from, if a previous request did not show all results. To get the next results, make the request again with this value.</p>', 'ListSubjectsResponse$nextToken' => '<p>A token that indicates where the output should continue from, if a previous request did not show all results. To get the next results, make the request again with this value.</p>', 'ListTrustAnchorsResponse$nextToken' => '<p>A token that indicates where the output should continue from, if a previous request did not show all results. To get the next results, make the request again with this value.</p>', 'ProfileDetail$createdBy' => '<p>The Amazon Web Services account that created the profile.</p>', 'ProfileDetail$sessionPolicy' => '<p>A session policy that applies to the trust boundary of the vended session credentials. </p>', 'ResourceNotFoundException$message' => NULL, 'SourceData$acmPcaArn' => '<p> The root certificate of the Private Certificate Authority specified by this ARN is used in trust validation for temporary credential requests. Included for trust anchors of type <code>AWS_ACM_PCA</code>. </p>', 'SpecifierList$member' => NULL, 'SubjectDetail$subjectArn' => '<p>The ARN of the resource.</p>', 'SubjectDetail$x509Subject' => '<p>The x509 principal identifier of the authenticating certificate.</p>', 'SubjectSummary$subjectArn' => '<p>The ARN of the resource.</p>', 'SubjectSummary$x509Subject' => '<p>The x509 principal identifier of the authenticating certificate.</p>', 'TooManyTagsException$message' => NULL, 'TrustAnchorDetail$trustAnchorArn' => '<p>The ARN of the trust anchor.</p>', 'ValidationException$message' => NULL, ], ], 'SubjectDetail' => [ 'base' => '<p>The state of the subject after a read or write operation.</p>', 'refs' => [ 'SubjectDetailResponse$subject' => '<p>The state of the subject after a read or write operation.</p>', ], ], 'SubjectDetailResponse' => [ 'base' => NULL, 'refs' => [], ], 'SubjectSummaries' => [ 'base' => NULL, 'refs' => [ 'ListSubjectsResponse$subjects' => '<p>A list of subjects.</p>', ], ], 'SubjectSummary' => [ 'base' => '<p>A summary representation of subjects.</p>', 'refs' => [ 'SubjectSummaries$member' => NULL, ], ], 'SyntheticTimestamp_date_time' => [ 'base' => NULL, 'refs' => [ 'CredentialSummary$seenAt' => '<p>The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.</p>', 'CrlDetail$createdAt' => '<p>The ISO-8601 timestamp when the certificate revocation list (CRL) was created. </p>', 'CrlDetail$updatedAt' => '<p>The ISO-8601 timestamp when the certificate revocation list (CRL) was last updated. </p>', 'InstanceProperty$seenAt' => '<p>The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.</p>', 'ProfileDetail$createdAt' => '<p>The ISO-8601 timestamp when the profile was created. </p>', 'ProfileDetail$updatedAt' => '<p>The ISO-8601 timestamp when the profile was last updated. </p>', 'SubjectDetail$createdAt' => '<p>The ISO-8601 timestamp when the subject was created. </p>', 'SubjectDetail$lastSeenAt' => '<p>The ISO-8601 timestamp of the last time this subject requested temporary session credentials.</p>', 'SubjectDetail$updatedAt' => '<p>The ISO-8601 timestamp when the subject was last updated.</p>', 'SubjectSummary$createdAt' => '<p>The ISO-8601 time stamp of when the certificate was first used in a temporary credential request.</p>', 'SubjectSummary$lastSeenAt' => '<p>The ISO-8601 time stamp of when the certificate was last used in a temporary credential request.</p>', 'SubjectSummary$updatedAt' => '<p>The ISO-8601 timestamp when the subject was last updated. </p>', 'TrustAnchorDetail$createdAt' => '<p>The ISO-8601 timestamp when the trust anchor was created. </p>', 'TrustAnchorDetail$updatedAt' => '<p>The ISO-8601 timestamp when the trust anchor was last updated. </p>', ], ], 'Tag' => [ 'base' => '<p>A label that consists of a key and value you define. </p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$key' => '<p>The tag key.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$tagKeys' => '<p>A list of keys. Tag keys are the unique identifiers of tags. </p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateProfileRequest$tags' => '<p>The tags to attach to the profile.</p>', 'CreateTrustAnchorRequest$tags' => '<p>The tags to attach to the trust anchor.</p>', 'ImportCrlRequest$tags' => '<p>A list of tags to attach to the certificate revocation list (CRL).</p>', 'ListTagsForResourceResponse$tags' => '<p>A list of tags attached to the resource.</p>', 'TagResourceRequest$tags' => '<p>The tags to attach to the resource.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$value' => '<p>The tag value.</p>', ], ], 'TooManyTagsException' => [ 'base' => '<p>Too many tags.</p>', 'refs' => [], ], 'TrustAnchorArn' => [ 'base' => NULL, 'refs' => [ 'ImportCrlRequest$trustAnchorArn' => '<p>The ARN of the TrustAnchor the certificate revocation list (CRL) will provide revocation for.</p>', ], ], 'TrustAnchorDetail' => [ 'base' => '<p>The state of the trust anchor after a read or write operation. </p>', 'refs' => [ 'PutNotificationSettingsResponse$trustAnchor' => NULL, 'ResetNotificationSettingsResponse$trustAnchor' => NULL, 'TrustAnchorDetailResponse$trustAnchor' => '<p>The state of the trust anchor after a read or write operation. </p>', 'TrustAnchorDetails$member' => NULL, ], ], 'TrustAnchorDetailResponse' => [ 'base' => NULL, 'refs' => [], ], 'TrustAnchorDetails' => [ 'base' => NULL, 'refs' => [ 'ListTrustAnchorsResponse$trustAnchors' => '<p>A list of trust anchors.</p>', ], ], 'TrustAnchorType' => [ 'base' => NULL, 'refs' => [ 'Source$sourceType' => '<p>The type of the trust anchor. </p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCrlRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCrlRequestCrlDataBlob' => [ 'base' => NULL, 'refs' => [ 'UpdateCrlRequest$crlData' => '<p>The x509 v3 specified certificate revocation list (CRL).</p>', ], ], 'UpdateProfileRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateProfileRequestDurationSecondsInteger' => [ 'base' => NULL, 'refs' => [ 'UpdateProfileRequest$durationSeconds' => '<p> Used to determine how long sessions vended using this profile are valid for. See the <code>Expiration</code> section of the <a href="https://docs.aws.amazon.com/rolesanywhere/latest/userguide/authentication-create-session.html#credentials-object">CreateSession API documentation</a> page for more details. In requests, if this value is not provided, the default value will be 3600. </p>', ], ], 'UpdateProfileRequestSessionPolicyString' => [ 'base' => NULL, 'refs' => [ 'UpdateProfileRequest$sessionPolicy' => '<p>A session policy that applies to the trust boundary of the vended session credentials. </p>', ], ], 'UpdateTrustAnchorRequest' => [ 'base' => NULL, 'refs' => [], ], 'Uuid' => [ 'base' => NULL, 'refs' => [ 'CrlDetail$crlId' => '<p>The unique identifier of the certificate revocation list (CRL).</p>', 'DeleteAttributeMappingRequest$profileId' => '<p>The unique identifier of the profile.</p>', 'ProfileDetail$profileId' => '<p>The unique identifier of the profile.</p>', 'PutAttributeMappingRequest$profileId' => '<p>The unique identifier of the profile.</p>', 'PutNotificationSettingsRequest$trustAnchorId' => '<p>The unique identifier of the trust anchor.</p>', 'ResetNotificationSettingsRequest$trustAnchorId' => '<p>The unique identifier of the trust anchor.</p>', 'ScalarCrlRequest$crlId' => '<p>The unique identifier of the certificate revocation list (CRL).</p>', 'ScalarProfileRequest$profileId' => '<p>The unique identifier of the profile.</p>', 'ScalarSubjectRequest$subjectId' => '<p>The unique identifier of the subject. </p>', 'ScalarTrustAnchorRequest$trustAnchorId' => '<p>The unique identifier of the trust anchor.</p>', 'SubjectDetail$subjectId' => '<p>The id of the resource</p>', 'SubjectSummary$subjectId' => '<p>The id of the resource.</p>', 'TrustAnchorDetail$trustAnchorId' => '<p>The unique identifier of the trust anchor.</p>', 'UpdateCrlRequest$crlId' => '<p>The unique identifier of the certificate revocation list (CRL).</p>', 'UpdateProfileRequest$profileId' => '<p>The unique identifier of the profile.</p>', 'UpdateTrustAnchorRequest$trustAnchorId' => '<p>The unique identifier of the trust anchor.</p>', ], ], 'ValidationException' => [ 'base' => '<p>Validation exception error.</p>', 'refs' => [], ], ],];
