<?php
// This file was auto-generated from sdk-root/src/data/service-quotas/2019-06-24/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>With Service Quotas, you can view and manage your quotas easily as your Amazon Web Services workloads grow. Quotas, also referred to as limits, are the maximum number of resources that you can create in your Amazon Web Services account. For more information, see the <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/">Service Quotas User Guide</a>.</p>', 'operations' => [ 'AssociateServiceQuotaTemplate' => '<p>Associates your quota request template with your organization. When a new Amazon Web Services account is created in your organization, the quota increase requests in the template are automatically applied to the account. You can add a quota increase request for any adjustable quota to your template.</p>', 'DeleteServiceQuotaIncreaseRequestFromTemplate' => '<p>Deletes the quota increase request for the specified quota from your quota request template.</p>', 'DisassociateServiceQuotaTemplate' => '<p>Disables your quota request template. After a template is disabled, the quota increase requests in the template are not applied to new Amazon Web Services accounts in your organization. Disabling a quota request template does not apply its quota increase requests.</p>', 'GetAWSDefaultServiceQuota' => '<p>Retrieves the default value for the specified quota. The default value does not reflect any quota increases.</p>', 'GetAssociationForServiceQuotaTemplate' => '<p>Retrieves the status of the association for the quota request template.</p>', 'GetRequestedServiceQuotaChange' => '<p>Retrieves information about the specified quota increase request.</p>', 'GetServiceQuota' => '<p>Retrieves the applied quota value for the specified quota. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.</p>', 'GetServiceQuotaIncreaseRequestFromTemplate' => '<p>Retrieves information about the specified quota increase request in your quota request template.</p>', 'ListAWSDefaultServiceQuotas' => '<p>Lists the default values for the quotas for the specified Amazon Web Service. A default value does not reflect any quota increases.</p>', 'ListRequestedServiceQuotaChangeHistory' => '<p>Retrieves the quota increase requests for the specified Amazon Web Service.</p>', 'ListRequestedServiceQuotaChangeHistoryByQuota' => '<p>Retrieves the quota increase requests for the specified quota.</p>', 'ListServiceQuotaIncreaseRequestsInTemplate' => '<p>Lists the quota increase requests in the specified quota request template.</p>', 'ListServiceQuotas' => '<p>Lists the applied quota values for the specified Amazon Web Service. For some quotas, only the default values are available. If the applied quota value is not available for a quota, the quota is not retrieved.</p>', 'ListServices' => '<p>Lists the names and codes for the Amazon Web Services integrated with Service Quotas.</p>', 'ListTagsForResource' => '<p>Returns a list of the tags assigned to the specified applied quota.</p>', 'PutServiceQuotaIncreaseRequestIntoTemplate' => '<p>Adds a quota increase request to your quota request template.</p>', 'RequestServiceQuotaIncrease' => '<p>Submits a quota increase request for the specified quota.</p>', 'TagResource' => '<p>Adds tags to the specified applied quota. You can include one or more tags to add to the quota.</p>', 'UntagResource' => '<p>Removes tags from the specified applied quota. You can specify one or more tags to remove.</p>', ], 'shapes' => [ 'AWSServiceAccessNotEnabledException' => [ 'base' => '<p>The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your organization.</p>', 'refs' => [], ], 'AccessDeniedException' => [ 'base' => '<p>You do not have sufficient permission to perform this action.</p>', 'refs' => [], ], 'AmazonResourceName' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) for the applied quota for which you want to list tags. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> Amazon Web Services API operation.</p>', 'TagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) for the applied quota. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> Amazon Web Services API operation.</p>', 'UntagResourceRequest$ResourceARN' => '<p>The Amazon Resource Name (ARN) for the applied quota that you want to untag. You can get this information by using the Service Quotas console, or by listing the quotas using the <a href="https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html">list-service-quotas</a> CLI command or the <a href="https://docs.aws.amazon.com/servicequotas/2019-06-24/apireference/API_ListServiceQuotas.html">ListServiceQuotas</a> Amazon Web Services API operation.</p>', ], ], 'AppliedLevelEnum' => [ 'base' => NULL, 'refs' => [ 'ListRequestedServiceQuotaChangeHistoryByQuotaRequest$QuotaRequestedAtLevel' => '<p>Specifies at which level within the Amazon Web Services account the quota request applies to.</p>', 'ListRequestedServiceQuotaChangeHistoryRequest$QuotaRequestedAtLevel' => '<p>Specifies at which level within the Amazon Web Services account the quota request applies to.</p>', 'ListServiceQuotasRequest$QuotaAppliedAtLevel' => '<p>Specifies at which level of granularity that the quota value is applied.</p>', 'RequestedServiceQuotaChange$QuotaRequestedAtLevel' => '<p>Specifies at which level within the Amazon Web Services account the quota request applies to.</p>', 'ServiceQuota$QuotaAppliedAtLevel' => '<p>Specifies at which level of granularity that the quota value is applied.</p>', ], ], 'AssociateServiceQuotaTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'AssociateServiceQuotaTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'AwsRegion' => [ 'base' => NULL, 'refs' => [ 'DeleteServiceQuotaIncreaseRequestFromTemplateRequest$AwsRegion' => '<p>Specifies the Amazon Web Services Region for which the request was made.</p>', 'GetServiceQuotaIncreaseRequestFromTemplateRequest$AwsRegion' => '<p>Specifies the Amazon Web Services Region for which you made the request.</p>', 'ListServiceQuotaIncreaseRequestsInTemplateRequest$AwsRegion' => '<p>Specifies the Amazon Web Services Region for which you made the request.</p>', 'PutServiceQuotaIncreaseRequestIntoTemplateRequest$AwsRegion' => '<p>Specifies the Amazon Web Services Region to which the template applies.</p>', 'ServiceQuotaIncreaseRequestInTemplate$AwsRegion' => '<p>The Amazon Web Services Region.</p>', ], ], 'CustomerServiceEngagementId' => [ 'base' => NULL, 'refs' => [ 'RequestedServiceQuotaChange$CaseId' => '<p>The case ID.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'RequestedServiceQuotaChange$Created' => '<p>The date and time when the quota increase request was received and the case ID was created.</p>', 'RequestedServiceQuotaChange$LastUpdated' => '<p>The date and time of the most recent change.</p>', ], ], 'DeleteServiceQuotaIncreaseRequestFromTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteServiceQuotaIncreaseRequestFromTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'DependencyAccessDeniedException' => [ 'base' => '<p>You can\'t perform this action because a dependency does not have access.</p>', 'refs' => [], ], 'DisassociateServiceQuotaTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'DisassociateServiceQuotaTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'ErrorCode' => [ 'base' => NULL, 'refs' => [ 'ErrorReason$ErrorCode' => '<p>Service Quotas returns the following error values:</p> <ul> <li> <p> <code>DEPENDENCY_ACCESS_DENIED_ERROR</code> - The caller does not have the required permissions to complete the action. To resolve the error, you must have permission to access the Amazon Web Service or quota.</p> </li> <li> <p> <code>DEPENDENCY_THROTTLING_ERROR</code> - The Amazon Web Service is throttling Service Quotas. </p> </li> <li> <p> <code>DEPENDENCY_SERVICE_ERROR</code> - The Amazon Web Service is not available.</p> </li> <li> <p> <code>SERVICE_QUOTA_NOT_AVAILABLE_ERROR</code> - There was an error in Service Quotas.</p> </li> </ul>', ], ], 'ErrorMessage' => [ 'base' => NULL, 'refs' => [ 'ErrorReason$ErrorMessage' => '<p>The error message.</p>', ], ], 'ErrorReason' => [ 'base' => '<p>An error that explains why an action did not succeed.</p>', 'refs' => [ 'ServiceQuota$ErrorReason' => '<p>The error code and error reason.</p>', ], ], 'ExceptionMessage' => [ 'base' => NULL, 'refs' => [ 'AWSServiceAccessNotEnabledException$Message' => NULL, 'AccessDeniedException$Message' => NULL, 'DependencyAccessDeniedException$Message' => NULL, 'IllegalArgumentException$Message' => NULL, 'InvalidPaginationTokenException$Message' => NULL, 'InvalidResourceStateException$Message' => NULL, 'NoAvailableOrganizationException$Message' => NULL, 'NoSuchResourceException$Message' => NULL, 'OrganizationNotInAllFeaturesModeException$Message' => NULL, 'QuotaExceededException$Message' => NULL, 'ResourceAlreadyExistsException$Message' => NULL, 'ServiceException$Message' => NULL, 'ServiceQuotaTemplateNotInUseException$Message' => NULL, 'TagPolicyViolationException$Message' => NULL, 'TemplatesNotAvailableInRegionException$Message' => NULL, 'TooManyRequestsException$Message' => NULL, 'TooManyTagsException$Message' => NULL, ], ], 'GetAWSDefaultServiceQuotaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAWSDefaultServiceQuotaResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetAssociationForServiceQuotaTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetAssociationForServiceQuotaTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetRequestedServiceQuotaChangeRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetRequestedServiceQuotaChangeResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceQuotaIncreaseRequestFromTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceQuotaIncreaseRequestFromTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceQuotaRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetServiceQuotaResponse' => [ 'base' => NULL, 'refs' => [], ], 'GlobalQuota' => [ 'base' => NULL, 'refs' => [ 'RequestedServiceQuotaChange$GlobalQuota' => '<p>Indicates whether the quota is global.</p>', 'ServiceQuota$GlobalQuota' => '<p>Indicates whether the quota is global.</p>', 'ServiceQuotaIncreaseRequestInTemplate$GlobalQuota' => '<p>Indicates whether the quota is global.</p>', ], ], 'IllegalArgumentException' => [ 'base' => '<p>Invalid input was provided.</p>', 'refs' => [], ], 'InputTagKeys' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>The keys of the tags that you want to remove from the resource.</p>', ], ], 'InputTags' => [ 'base' => NULL, 'refs' => [ 'TagResourceRequest$Tags' => '<p>The tags that you want to add to the resource.</p>', ], ], 'InvalidPaginationTokenException' => [ 'base' => '<p>Invalid input was provided.</p>', 'refs' => [], ], 'InvalidResourceStateException' => [ 'base' => '<p>The resource is in an invalid state.</p>', 'refs' => [], ], 'ListAWSDefaultServiceQuotasRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListAWSDefaultServiceQuotasResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRequestedServiceQuotaChangeHistoryByQuotaRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRequestedServiceQuotaChangeHistoryByQuotaResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListRequestedServiceQuotaChangeHistoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListRequestedServiceQuotaChangeHistoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceQuotaIncreaseRequestsInTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceQuotaIncreaseRequestsInTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceQuotasRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServiceQuotasResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListServicesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListServicesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListAWSDefaultServiceQuotasRequest$MaxResults' => '<p>Specifies the maximum number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value appropriate to the operation. If additional items exist beyond those included in the current response, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results.</p> <note> <p>An API operation can return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p> </note>', 'ListRequestedServiceQuotaChangeHistoryByQuotaRequest$MaxResults' => '<p>Specifies the maximum number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value appropriate to the operation. If additional items exist beyond those included in the current response, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results.</p> <note> <p>An API operation can return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p> </note>', 'ListRequestedServiceQuotaChangeHistoryRequest$MaxResults' => '<p>Specifies the maximum number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value appropriate to the operation. If additional items exist beyond those included in the current response, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results.</p> <note> <p>An API operation can return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p> </note>', 'ListServiceQuotaIncreaseRequestsInTemplateRequest$MaxResults' => '<p>Specifies the maximum number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value appropriate to the operation. If additional items exist beyond those included in the current response, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results.</p> <note> <p>An API operation can return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p> </note>', 'ListServiceQuotasRequest$MaxResults' => '<p>Specifies the maximum number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value appropriate to the operation. If additional items exist beyond those included in the current response, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results.</p> <note> <p>An API operation can return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p> </note>', 'ListServicesRequest$MaxResults' => '<p>Specifies the maximum number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value appropriate to the operation. If additional items exist beyond those included in the current response, the <code>NextToken</code> response element is present and has a value (is not null). Include that value as the <code>NextToken</code> request parameter in the next call to the operation to get the next part of the results.</p> <note> <p>An API operation can return fewer results than the maximum even when there are more results available. You should check <code>NextToken</code> after every operation to ensure that you receive all of the results.</p> </note>', ], ], 'MetricDimensionName' => [ 'base' => NULL, 'refs' => [ 'MetricDimensionsMapDefinition$key' => NULL, ], ], 'MetricDimensionValue' => [ 'base' => NULL, 'refs' => [ 'MetricDimensionsMapDefinition$value' => NULL, ], ], 'MetricDimensionsMapDefinition' => [ 'base' => NULL, 'refs' => [ 'MetricInfo$MetricDimensions' => '<p>The metric dimension. This is a name/value pair that is part of the identity of a metric.</p>', ], ], 'MetricInfo' => [ 'base' => '<p>Information about the CloudWatch metric that reflects quota usage.</p>', 'refs' => [ 'ServiceQuota$UsageMetric' => '<p>Information about the measurement.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListAWSDefaultServiceQuotasRequest$NextToken' => '<p>Specifies a value for receiving additional results after you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListAWSDefaultServiceQuotasResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListRequestedServiceQuotaChangeHistoryByQuotaRequest$NextToken' => '<p>Specifies a value for receiving additional results after you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListRequestedServiceQuotaChangeHistoryByQuotaResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListRequestedServiceQuotaChangeHistoryRequest$NextToken' => '<p>Specifies a value for receiving additional results after you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListRequestedServiceQuotaChangeHistoryResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListServiceQuotaIncreaseRequestsInTemplateRequest$NextToken' => '<p>Specifies a value for receiving additional results after you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListServiceQuotaIncreaseRequestsInTemplateResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListServiceQuotasRequest$NextToken' => '<p>Specifies a value for receiving additional results after you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListServiceQuotasResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', 'ListServicesRequest$NextToken' => '<p>Specifies a value for receiving additional results after you receive a <code>NextToken</code> response in a previous request. A <code>NextToken</code> response indicates that more output is available. Set this parameter to the value of the previous call\'s <code>NextToken</code> response to indicate where the output should continue from.</p>', 'ListServicesResponse$NextToken' => '<p>If present, indicates that more output is available than is included in the current response. Use this value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.</p>', ], ], 'NoAvailableOrganizationException' => [ 'base' => '<p>The Amazon Web Services account making this call is not a member of an organization.</p>', 'refs' => [], ], 'NoSuchResourceException' => [ 'base' => '<p>The specified resource does not exist.</p>', 'refs' => [], ], 'OrganizationNotInAllFeaturesModeException' => [ 'base' => '<p>The organization that your Amazon Web Services account belongs to is not in All Features mode.</p>', 'refs' => [], ], 'OutputTags' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceResponse$Tags' => '<p>A complex data type that contains zero or more tag elements.</p>', ], ], 'PeriodUnit' => [ 'base' => NULL, 'refs' => [ 'QuotaPeriod$PeriodUnit' => '<p>The time unit.</p>', ], ], 'PeriodValue' => [ 'base' => NULL, 'refs' => [ 'QuotaPeriod$PeriodValue' => '<p>The value associated with the reported <code>PeriodUnit</code>.</p>', ], ], 'PutServiceQuotaIncreaseRequestIntoTemplateRequest' => [ 'base' => NULL, 'refs' => [], ], 'PutServiceQuotaIncreaseRequestIntoTemplateResponse' => [ 'base' => NULL, 'refs' => [], ], 'QuotaAdjustable' => [ 'base' => NULL, 'refs' => [ 'ServiceQuota$Adjustable' => '<p>Indicates whether the quota value can be increased.</p>', ], ], 'QuotaArn' => [ 'base' => NULL, 'refs' => [ 'RequestedServiceQuotaChange$QuotaArn' => '<p>The Amazon Resource Name (ARN) of the quota.</p>', 'ServiceQuota$QuotaArn' => '<p>The Amazon Resource Name (ARN) of the quota.</p>', ], ], 'QuotaCode' => [ 'base' => NULL, 'refs' => [ 'DeleteServiceQuotaIncreaseRequestFromTemplateRequest$QuotaCode' => '<p>Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.</p>', 'GetAWSDefaultServiceQuotaRequest$QuotaCode' => '<p>Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.</p>', 'GetServiceQuotaIncreaseRequestFromTemplateRequest$QuotaCode' => '<p>Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.</p>', 'GetServiceQuotaRequest$QuotaCode' => '<p>Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.</p>', 'ListRequestedServiceQuotaChangeHistoryByQuotaRequest$QuotaCode' => '<p>Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.</p>', 'ListServiceQuotasRequest$QuotaCode' => '<p>Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.</p>', 'PutServiceQuotaIncreaseRequestIntoTemplateRequest$QuotaCode' => '<p>Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.</p>', 'RequestServiceQuotaIncreaseRequest$QuotaCode' => '<p>Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.</p>', 'RequestedServiceQuotaChange$QuotaCode' => '<p>Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.</p>', 'ServiceQuota$QuotaCode' => '<p>Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.</p>', 'ServiceQuotaIncreaseRequestInTemplate$QuotaCode' => '<p>Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.</p>', ], ], 'QuotaContextId' => [ 'base' => NULL, 'refs' => [ 'GetServiceQuotaRequest$ContextId' => '<p>Specifies the Amazon Web Services account or resource to which the quota applies. The value in this field depends on the context scope associated with the specified service quota.</p>', 'QuotaContextInfo$ContextId' => '<p>Specifies the Amazon Web Services account or resource to which the quota applies. The value in this field depends on the context scope associated with the specified service quota.</p>', 'RequestServiceQuotaIncreaseRequest$ContextId' => '<p>Specifies the Amazon Web Services account or resource to which the quota applies. The value in this field depends on the context scope associated with the specified service quota.</p>', ], ], 'QuotaContextInfo' => [ 'base' => '<p>A structure that describes the context for a service quota. The context identifies what the quota applies to.</p>', 'refs' => [ 'RequestedServiceQuotaChange$QuotaContext' => '<p>The context for this service quota.</p>', 'ServiceQuota$QuotaContext' => '<p>The context for this service quota.</p>', ], ], 'QuotaContextScope' => [ 'base' => NULL, 'refs' => [ 'QuotaContextInfo$ContextScope' => '<p>Specifies whether the quota applies to an Amazon Web Services account, or to a resource.</p>', ], ], 'QuotaContextScopeType' => [ 'base' => NULL, 'refs' => [ 'QuotaContextInfo$ContextScopeType' => '<p>When the <code>ContextScope</code> is <code>RESOURCE</code>, then this specifies the resource type of the specified resource.</p>', ], ], 'QuotaExceededException' => [ 'base' => '<p>You have exceeded your service quota. To perform the requested action, remove some of the relevant resources, or use Service Quotas to request a service quota increase.</p>', 'refs' => [], ], 'QuotaMetricName' => [ 'base' => NULL, 'refs' => [ 'MetricInfo$MetricName' => '<p>The name of the metric.</p>', ], ], 'QuotaMetricNamespace' => [ 'base' => NULL, 'refs' => [ 'MetricInfo$MetricNamespace' => '<p>The namespace of the metric.</p>', ], ], 'QuotaName' => [ 'base' => NULL, 'refs' => [ 'RequestedServiceQuotaChange$QuotaName' => '<p>Specifies the quota name.</p>', 'ServiceQuota$QuotaName' => '<p>Specifies the quota name.</p>', 'ServiceQuotaIncreaseRequestInTemplate$QuotaName' => '<p>Specifies the quota name.</p>', ], ], 'QuotaPeriod' => [ 'base' => '<p>Information about the quota period.</p>', 'refs' => [ 'ServiceQuota$Period' => '<p>The period of time.</p>', ], ], 'QuotaUnit' => [ 'base' => NULL, 'refs' => [ 'RequestedServiceQuotaChange$Unit' => '<p>The unit of measurement.</p>', 'ServiceQuota$Unit' => '<p>The unit of measurement.</p>', 'ServiceQuotaIncreaseRequestInTemplate$Unit' => '<p>The unit of measurement.</p>', ], ], 'QuotaValue' => [ 'base' => NULL, 'refs' => [ 'PutServiceQuotaIncreaseRequestIntoTemplateRequest$DesiredValue' => '<p>Specifies the new, increased value for the quota.</p>', 'RequestServiceQuotaIncreaseRequest$DesiredValue' => '<p>Specifies the new, increased value for the quota.</p>', 'RequestedServiceQuotaChange$DesiredValue' => '<p>The new, increased value for the quota.</p>', 'ServiceQuota$Value' => '<p>The quota value.</p>', 'ServiceQuotaIncreaseRequestInTemplate$DesiredValue' => '<p>The new, increased value of the quota.</p>', ], ], 'RequestId' => [ 'base' => NULL, 'refs' => [ 'GetRequestedServiceQuotaChangeRequest$RequestId' => '<p>Specifies the ID of the quota increase request.</p>', 'RequestedServiceQuotaChange$Id' => '<p>The unique identifier.</p>', ], ], 'RequestServiceQuotaIncreaseRequest' => [ 'base' => NULL, 'refs' => [], ], 'RequestServiceQuotaIncreaseResponse' => [ 'base' => NULL, 'refs' => [], ], 'RequestStatus' => [ 'base' => NULL, 'refs' => [ 'ListRequestedServiceQuotaChangeHistoryByQuotaRequest$Status' => '<p>Specifies that you want to filter the results to only the requests with the matching status.</p>', 'ListRequestedServiceQuotaChangeHistoryRequest$Status' => '<p>Specifies that you want to filter the results to only the requests with the matching status.</p>', 'RequestedServiceQuotaChange$Status' => '<p>The state of the quota increase request.</p>', ], ], 'RequestedServiceQuotaChange' => [ 'base' => '<p>Information about a quota increase request.</p>', 'refs' => [ 'GetRequestedServiceQuotaChangeResponse$RequestedQuota' => '<p>Information about the quota increase request.</p>', 'RequestServiceQuotaIncreaseResponse$RequestedQuota' => '<p>Information about the quota increase request.</p>', 'RequestedServiceQuotaChangeHistoryListDefinition$member' => NULL, ], ], 'RequestedServiceQuotaChangeHistoryListDefinition' => [ 'base' => NULL, 'refs' => [ 'ListRequestedServiceQuotaChangeHistoryByQuotaResponse$RequestedQuotas' => '<p>Information about the quota increase requests.</p>', 'ListRequestedServiceQuotaChangeHistoryResponse$RequestedQuotas' => '<p>Information about the quota increase requests.</p>', ], ], 'Requester' => [ 'base' => NULL, 'refs' => [ 'RequestedServiceQuotaChange$Requester' => '<p>The IAM identity of the requester.</p>', ], ], 'ResourceAlreadyExistsException' => [ 'base' => '<p>The specified resource already exists.</p>', 'refs' => [], ], 'ServiceCode' => [ 'base' => NULL, 'refs' => [ 'DeleteServiceQuotaIncreaseRequestFromTemplateRequest$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'GetAWSDefaultServiceQuotaRequest$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'GetServiceQuotaIncreaseRequestFromTemplateRequest$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'GetServiceQuotaRequest$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'ListAWSDefaultServiceQuotasRequest$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'ListRequestedServiceQuotaChangeHistoryByQuotaRequest$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'ListRequestedServiceQuotaChangeHistoryRequest$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'ListServiceQuotaIncreaseRequestsInTemplateRequest$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'ListServiceQuotasRequest$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'PutServiceQuotaIncreaseRequestIntoTemplateRequest$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'RequestServiceQuotaIncreaseRequest$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'RequestedServiceQuotaChange$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'ServiceInfo$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'ServiceQuota$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', 'ServiceQuotaIncreaseRequestInTemplate$ServiceCode' => '<p>Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the <a>ListServices</a> operation.</p>', ], ], 'ServiceException' => [ 'base' => '<p>Something went wrong.</p>', 'refs' => [], ], 'ServiceInfo' => [ 'base' => '<p>Information about an Amazon Web Service.</p>', 'refs' => [ 'ServiceInfoListDefinition$member' => NULL, ], ], 'ServiceInfoListDefinition' => [ 'base' => NULL, 'refs' => [ 'ListServicesResponse$Services' => '<p>The list of the Amazon Web Service names and service codes.</p>', ], ], 'ServiceName' => [ 'base' => NULL, 'refs' => [ 'RequestedServiceQuotaChange$ServiceName' => '<p>Specifies the service name.</p>', 'ServiceInfo$ServiceName' => '<p>Specifies the service name.</p>', 'ServiceQuota$ServiceName' => '<p>Specifies the service name.</p>', 'ServiceQuotaIncreaseRequestInTemplate$ServiceName' => '<p>Specifies the service name.</p>', ], ], 'ServiceQuota' => [ 'base' => '<p>Information about a quota.</p>', 'refs' => [ 'GetAWSDefaultServiceQuotaResponse$Quota' => '<p>Information about the quota.</p>', 'GetServiceQuotaResponse$Quota' => '<p>Information about the quota.</p>', 'ServiceQuotaListDefinition$member' => NULL, ], ], 'ServiceQuotaIncreaseRequestInTemplate' => [ 'base' => '<p>Information about a quota increase request.</p>', 'refs' => [ 'GetServiceQuotaIncreaseRequestFromTemplateResponse$ServiceQuotaIncreaseRequestInTemplate' => '<p>Information about the quota increase request.</p>', 'PutServiceQuotaIncreaseRequestIntoTemplateResponse$ServiceQuotaIncreaseRequestInTemplate' => '<p>Information about the quota increase request.</p>', 'ServiceQuotaIncreaseRequestInTemplateList$member' => NULL, ], ], 'ServiceQuotaIncreaseRequestInTemplateList' => [ 'base' => NULL, 'refs' => [ 'ListServiceQuotaIncreaseRequestsInTemplateResponse$ServiceQuotaIncreaseRequestInTemplateList' => '<p>Information about the quota increase requests.</p>', ], ], 'ServiceQuotaListDefinition' => [ 'base' => NULL, 'refs' => [ 'ListAWSDefaultServiceQuotasResponse$Quotas' => '<p>Information about the quotas.</p>', 'ListServiceQuotasResponse$Quotas' => '<p>Information about the quotas.</p>', ], ], 'ServiceQuotaTemplateAssociationStatus' => [ 'base' => NULL, 'refs' => [ 'GetAssociationForServiceQuotaTemplateResponse$ServiceQuotaTemplateAssociationStatus' => '<p>The association status. If the status is <code>ASSOCIATED</code>, the quota increase requests in the template are automatically applied to new Amazon Web Services accounts in your organization.</p>', ], ], 'ServiceQuotaTemplateNotInUseException' => [ 'base' => '<p>The quota request template is not associated with your organization.</p>', 'refs' => [], ], 'Statistic' => [ 'base' => NULL, 'refs' => [ 'MetricInfo$MetricStatisticRecommendation' => '<p>The metric statistic that we recommend you use when determining quota usage.</p>', ], ], 'Tag' => [ 'base' => '<p>A complex data type that contains a tag key and tag value.</p>', 'refs' => [ 'InputTags$member' => NULL, 'OutputTags$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'InputTagKeys$member' => NULL, 'Tag$Key' => '<p>A string that contains a tag key. The string length should be between 1 and 128 characters. Valid characters include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.</p>', ], ], 'TagPolicyViolationException' => [ 'base' => '<p>The specified tag is a reserved word and cannot be used.</p>', 'refs' => [], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>A string that contains an optional tag value. The string length should be between 0 and 256 characters. Valid characters include a-z, A-Z, 0-9, space, and the special characters _ - . : / = + @.</p>', ], ], 'TemplatesNotAvailableInRegionException' => [ 'base' => '<p>The Service Quotas template is not available in this Amazon Web Services Region.</p>', 'refs' => [], ], 'TooManyRequestsException' => [ 'base' => '<p>Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase for this quota.</p>', 'refs' => [], ], 'TooManyTagsException' => [ 'base' => '<p>You\'ve exceeded the number of tags allowed for a resource. For more information, see <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/sq-tagging.html#sq-tagging-restrictions">Tag restrictions</a> in the <i>Service Quotas User Guide</i>.</p>', 'refs' => [], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], ],];
