<?php
// This file was auto-generated from sdk-root/src/data/transcribe/2017-10-26/docs-2.json
return [ 'version' => '2.0', 'service' => '<p>Amazon Transcribe offers three main types of batch transcription: <b>Standard</b>, <b>Medical</b>, and <b>Call Analytics</b>.</p> <ul> <li> <p> <b>Standard transcriptions</b> are the most common option. Refer to for details.</p> </li> <li> <p> <b>Medical transcriptions</b> are tailored to medical professionals and incorporate medical terms. A common use case for this service is transcribing doctor-patient dialogue into after-visit notes. Refer to for details.</p> </li> <li> <p> <b>Call Analytics transcriptions</b> are designed for use with call center audio on two different channels; if you\'re looking for insight into customer service calls, use this option. Refer to for details.</p> </li> </ul>', 'operations' => [ 'CreateCallAnalyticsCategory' => '<p>Creates a new Call Analytics category.</p> <p>All categories are automatically applied to your Call Analytics transcriptions. Note that in order to apply categories to your transcriptions, you must create them before submitting your transcription request, as categories cannot be applied retroactively.</p> <p>When creating a new category, you can use the <code>InputType</code> parameter to label the category as a <code>POST_CALL</code> or a <code>REAL_TIME</code> category. <code>POST_CALL</code> categories can only be applied to post-call transcriptions and <code>REAL_TIME</code> categories can only be applied to real-time transcriptions. If you do not include <code>InputType</code>, your category is created as a <code>POST_CALL</code> category by default.</p> <p>Call Analytics categories are composed of rules. For each category, you must create between 1 and 20 rules. Rules can include these parameters: , , , and .</p> <p>To update an existing category, see .</p> <p>To learn more about Call Analytics categories, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html">Creating categories for post-call transcriptions</a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html">Creating categories for real-time transcriptions</a>.</p>', 'CreateLanguageModel' => '<p>Creates a new custom language model.</p> <p>When creating a new custom language model, you must specify:</p> <ul> <li> <p>If you want a Wideband (audio sample rates over 16,000 Hz) or Narrowband (audio sample rates under 16,000 Hz) base model</p> </li> <li> <p>The location of your training and tuning files (this must be an Amazon S3 URI)</p> </li> <li> <p>The language of your model</p> </li> <li> <p>A unique name for your model</p> </li> </ul>', 'CreateMedicalVocabulary' => '<p>Creates a new custom medical vocabulary.</p> <p>Before creating a new custom medical vocabulary, you must first upload a text file that contains your vocabulary table into an Amazon S3 bucket. Note that this differs from , where you can include a list of terms within your request using the <code>Phrases</code> flag; <code>CreateMedicalVocabulary</code> does not support the <code>Phrases</code> flag and only accepts vocabularies in table format.</p> <p>Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary request fails. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a> to get the character set for your language.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p>', 'CreateVocabulary' => '<p>Creates a new custom vocabulary.</p> <p>When creating a new custom vocabulary, you can either upload a text file that contains your new entries, phrases, and terms into an Amazon S3 bucket and include the URI in your request. Or you can include a list of terms directly in your request using the <code>Phrases</code> flag.</p> <p>Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary request fails. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a> to get the character set for your language.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p>', 'CreateVocabularyFilter' => '<p>Creates a new custom vocabulary filter.</p> <p>You can use custom vocabulary filters to mask, delete, or flag specific words from your transcript. Custom vocabulary filters are commonly used to mask profanity in transcripts.</p> <p>Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary filter request fails. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a> to get the character set for your language.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Vocabulary filtering</a>.</p>', 'DeleteCallAnalyticsCategory' => '<p>Deletes a Call Analytics category. To use this operation, specify the name of the category you want to delete using <code>CategoryName</code>. Category names are case sensitive.</p>', 'DeleteCallAnalyticsJob' => '<p>Deletes a Call Analytics job. To use this operation, specify the name of the job you want to delete using <code>CallAnalyticsJobName</code>. Job names are case sensitive.</p>', 'DeleteLanguageModel' => '<p>Deletes a custom language model. To use this operation, specify the name of the language model you want to delete using <code>ModelName</code>. custom language model names are case sensitive.</p>', 'DeleteMedicalScribeJob' => '<p>Deletes a Medical Scribe job. To use this operation, specify the name of the job you want to delete using <code>MedicalScribeJobName</code>. Job names are case sensitive.</p>', 'DeleteMedicalTranscriptionJob' => '<p>Deletes a medical transcription job. To use this operation, specify the name of the job you want to delete using <code>MedicalTranscriptionJobName</code>. Job names are case sensitive.</p>', 'DeleteMedicalVocabulary' => '<p>Deletes a custom medical vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete using <code>VocabularyName</code>. Custom vocabulary names are case sensitive.</p>', 'DeleteTranscriptionJob' => '<p>Deletes a transcription job. To use this operation, specify the name of the job you want to delete using <code>TranscriptionJobName</code>. Job names are case sensitive.</p>', 'DeleteVocabulary' => '<p>Deletes a custom vocabulary. To use this operation, specify the name of the custom vocabulary you want to delete using <code>VocabularyName</code>. Custom vocabulary names are case sensitive.</p>', 'DeleteVocabularyFilter' => '<p>Deletes a custom vocabulary filter. To use this operation, specify the name of the custom vocabulary filter you want to delete using <code>VocabularyFilterName</code>. Custom vocabulary filter names are case sensitive.</p>', 'DescribeLanguageModel' => '<p>Provides information about the specified custom language model.</p> <p>This operation also shows if the base language model that you used to create your custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the updated base model.</p> <p>If you tried to create a new custom language model and the request wasn\'t successful, you can use <code>DescribeLanguageModel</code> to help identify the reason for this failure.</p>', 'GetCallAnalyticsCategory' => '<p>Provides information about the specified Call Analytics category.</p> <p>To get a list of your Call Analytics categories, use the operation.</p>', 'GetCallAnalyticsJob' => '<p>Provides information about the specified Call Analytics job.</p> <p>To view the job\'s status, refer to <code>CallAnalyticsJobStatus</code>. If the status is <code>COMPLETED</code>, the job is finished. You can find your completed transcript at the URI specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your transcription job failed.</p> <p>If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the location specified in <code>RedactedTranscriptFileUri</code>.</p> <p>If you chose to redact the audio in your media file, you can find your redacted media file at the location specified in <code>RedactedMediaFileUri</code>.</p> <p>To get a list of your Call Analytics jobs, use the operation.</p>', 'GetMedicalScribeJob' => '<p>Provides information about the specified Medical Scribe job.</p> <p>To view the status of the specified medical transcription job, check the <code>MedicalScribeJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished. You can find the results at the location specified in <code>MedicalScribeOutput</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your Medical Scribe job failed.</p> <p>To get a list of your Medical Scribe jobs, use the operation.</p>', 'GetMedicalTranscriptionJob' => '<p>Provides information about the specified medical transcription job.</p> <p>To view the status of the specified medical transcription job, check the <code>TranscriptionJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished. You can find the results at the location specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your transcription job failed.</p> <p>To get a list of your medical transcription jobs, use the operation.</p>', 'GetMedicalVocabulary' => '<p>Provides information about the specified custom medical vocabulary.</p> <p>To view the status of the specified custom medical vocabulary, check the <code>VocabularyState</code> field. If the status is <code>READY</code>, your custom vocabulary is available to use. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your vocabulary failed.</p> <p>To get a list of your custom medical vocabularies, use the operation.</p>', 'GetTranscriptionJob' => '<p>Provides information about the specified transcription job.</p> <p>To view the status of the specified transcription job, check the <code>TranscriptionJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished. You can find the results at the location specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your transcription job failed.</p> <p>If you enabled content redaction, the redacted transcript can be found at the location specified in <code>RedactedTranscriptFileUri</code>.</p> <p>To get a list of your transcription jobs, use the operation.</p>', 'GetVocabulary' => '<p>Provides information about the specified custom vocabulary.</p> <p>To view the status of the specified custom vocabulary, check the <code>VocabularyState</code> field. If the status is <code>READY</code>, your custom vocabulary is available to use. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your custom vocabulary failed.</p> <p>To get a list of your custom vocabularies, use the operation.</p>', 'GetVocabularyFilter' => '<p>Provides information about the specified custom vocabulary filter.</p> <p>To get a list of your custom vocabulary filters, use the operation.</p>', 'ListCallAnalyticsCategories' => '<p>Provides a list of Call Analytics categories, including all rules that make up each category.</p> <p>To get detailed information about a specific Call Analytics category, use the operation.</p>', 'ListCallAnalyticsJobs' => '<p>Provides a list of Call Analytics jobs that match the specified criteria. If no criteria are specified, all Call Analytics jobs are returned.</p> <p>To get detailed information about a specific Call Analytics job, use the operation.</p>', 'ListLanguageModels' => '<p>Provides a list of custom language models that match the specified criteria. If no criteria are specified, all custom language models are returned.</p> <p>To get detailed information about a specific custom language model, use the operation.</p>', 'ListMedicalScribeJobs' => '<p>Provides a list of Medical Scribe jobs that match the specified criteria. If no criteria are specified, all Medical Scribe jobs are returned.</p> <p>To get detailed information about a specific Medical Scribe job, use the operation.</p>', 'ListMedicalTranscriptionJobs' => '<p>Provides a list of medical transcription jobs that match the specified criteria. If no criteria are specified, all medical transcription jobs are returned.</p> <p>To get detailed information about a specific medical transcription job, use the operation.</p>', 'ListMedicalVocabularies' => '<p>Provides a list of custom medical vocabularies that match the specified criteria. If no criteria are specified, all custom medical vocabularies are returned.</p> <p>To get detailed information about a specific custom medical vocabulary, use the operation.</p>', 'ListTagsForResource' => '<p>Lists all tags associated with the specified transcription job, vocabulary, model, or resource.</p> <p>To learn more about using tags with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.</p>', 'ListTranscriptionJobs' => '<p>Provides a list of transcription jobs that match the specified criteria. If no criteria are specified, all transcription jobs are returned.</p> <p>To get detailed information about a specific transcription job, use the operation.</p>', 'ListVocabularies' => '<p>Provides a list of custom vocabularies that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.</p> <p>To get detailed information about a specific custom vocabulary, use the operation.</p>', 'ListVocabularyFilters' => '<p>Provides a list of custom vocabulary filters that match the specified criteria. If no criteria are specified, all custom vocabularies are returned.</p> <p>To get detailed information about a specific custom vocabulary filter, use the operation.</p>', 'StartCallAnalyticsJob' => '<p>Transcribes the audio from a customer service call and applies any additional Request Parameters you choose to include in your request.</p> <p>In addition to many standard transcription features, Call Analytics provides you with call characteristics, call summarization, speaker sentiment, and optional redaction of your text transcript and your audio file. You can also apply custom categories to flag specified conditions. To learn more about these features and insights, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html">Analyzing call center audio with Call Analytics</a>.</p> <p>If you want to apply categories to your Call Analytics job, you must create them before submitting your job request. Categories cannot be retroactively applied to a job. To create a new category, use the operation. To learn more about Call Analytics categories, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html">Creating categories for post-call transcriptions</a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html">Creating categories for real-time transcriptions</a>.</p> <p>To make a <code>StartCallAnalyticsJob</code> request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the <code>Media</code> parameter.</p> <p>Note that job queuing is enabled by default for Call Analytics jobs.</p> <p>You must include the following parameters in your <code>StartCallAnalyticsJob</code> request:</p> <ul> <li> <p> <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.</p> </li> <li> <p> <code>CallAnalyticsJobName</code>: A custom name that you create for your transcription job that\'s unique within your Amazon Web Services account.</p> </li> <li> <p> <code>DataAccessRoleArn</code>: The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files.</p> </li> <li> <p> <code>Media</code> (<code>MediaFileUri</code> or <code>RedactedMediaFileUri</code>): The Amazon S3 location of your media file.</p> </li> </ul> <note> <p>With Call Analytics, you can redact the audio contained in your media file by including <code>RedactedMediaFileUri</code>, instead of <code>MediaFileUri</code>, to specify the location of your input audio. If you choose to redact your audio, you can find your redacted media at the location specified in the <code>RedactedMediaFileUri</code> field of your response.</p> </note>', 'StartMedicalScribeJob' => '<p>Transcribes patient-clinician conversations and generates clinical notes. </p> <p>Amazon Web Services HealthScribe automatically provides rich conversation transcripts, identifies speaker roles, classifies dialogues, extracts medical terms, and generates preliminary clinical notes. To learn more about these features, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/health-scribe.html">Amazon Web Services HealthScribe</a>.</p> <p>To make a <code>StartMedicalScribeJob</code> request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the <code>Media</code> parameter.</p> <p>You must include the following parameters in your <code>StartMedicalTranscriptionJob</code> request:</p> <ul> <li> <p> <code>DataAccessRoleArn</code>: The ARN of an IAM role with the these minimum permissions: read permission on input file Amazon S3 bucket specified in <code>Media</code>, write permission on the Amazon S3 bucket specified in <code>OutputBucketName</code>, and full permissions on the KMS key specified in <code>OutputEncryptionKMSKeyId</code> (if set). The role should also allow <code>transcribe.amazonaws.com</code> to assume it. </p> </li> <li> <p> <code>Media</code> (<code>MediaFileUri</code>): The Amazon S3 location of your media file.</p> </li> <li> <p> <code>MedicalScribeJobName</code>: A custom name you create for your MedicalScribe job that is unique within your Amazon Web Services account.</p> </li> <li> <p> <code>OutputBucketName</code>: The Amazon S3 bucket where you want your output files stored.</p> </li> <li> <p> <code>Settings</code>: A <code>MedicalScribeSettings</code> obect that must set exactly one of <code>ShowSpeakerLabels</code> or <code>ChannelIdentification</code> to true. If <code>ShowSpeakerLabels</code> is true, <code>MaxSpeakerLabels</code> must also be set. </p> </li> <li> <p> <code>ChannelDefinitions</code>: A <code>MedicalScribeChannelDefinitions</code> array should be set if and only if the <code>ChannelIdentification</code> value of <code>Settings</code> is set to true. </p> </li> </ul>', 'StartMedicalTranscriptionJob' => '<p>Transcribes the audio from a medical dictation or conversation and applies any additional Request Parameters you choose to include in your request.</p> <p>In addition to many standard transcription features, Amazon Transcribe Medical provides you with a robust medical vocabulary and, optionally, content identification, which adds flags to personal health information (PHI). To learn more about these features, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works-med.html">How Amazon Transcribe Medical works</a>.</p> <p>To make a <code>StartMedicalTranscriptionJob</code> request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the <code>Media</code> parameter.</p> <p>You must include the following parameters in your <code>StartMedicalTranscriptionJob</code> request:</p> <ul> <li> <p> <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.</p> </li> <li> <p> <code>MedicalTranscriptionJobName</code>: A custom name you create for your transcription job that is unique within your Amazon Web Services account.</p> </li> <li> <p> <code>Media</code> (<code>MediaFileUri</code>): The Amazon S3 location of your media file.</p> </li> <li> <p> <code>LanguageCode</code>: This must be <code>en-US</code>.</p> </li> <li> <p> <code>OutputBucketName</code>: The Amazon S3 bucket where you want your transcript stored. If you want your output stored in a sub-folder of this bucket, you must also include <code>OutputKey</code>.</p> </li> <li> <p> <code>Specialty</code>: This must be <code>PRIMARYCARE</code>.</p> </li> <li> <p> <code>Type</code>: Choose whether your audio is a conversation or a dictation.</p> </li> </ul>', 'StartTranscriptionJob' => '<p>Transcribes the audio from a media file and applies any additional Request Parameters you choose to include in your request.</p> <p>To make a <code>StartTranscriptionJob</code> request, you must first upload your media file into an Amazon S3 bucket; you can then specify the Amazon S3 location of the file using the <code>Media</code> parameter.</p> <p>You must include the following parameters in your <code>StartTranscriptionJob</code> request:</p> <ul> <li> <p> <code>region</code>: The Amazon Web Services Region where you are making your request. For a list of Amazon Web Services Regions supported with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html">Amazon Transcribe endpoints and quotas</a>.</p> </li> <li> <p> <code>TranscriptionJobName</code>: A custom name you create for your transcription job that is unique within your Amazon Web Services account.</p> </li> <li> <p> <code>Media</code> (<code>MediaFileUri</code>): The Amazon S3 location of your media file.</p> </li> <li> <p>One of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code>: If you know the language of your media file, specify it using the <code>LanguageCode</code> parameter; you can find all valid language codes in the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table. If you do not know the languages spoken in your media, use either <code>IdentifyLanguage</code> or <code>IdentifyMultipleLanguages</code> and let Amazon Transcribe identify the languages for you.</p> </li> </ul>', 'TagResource' => '<p>Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.</p> <p>To learn more about using tags with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.</p>', 'UntagResource' => '<p>Removes the specified tags from the specified Amazon Transcribe resource.</p> <p>If you include <code>UntagResource</code> in your request, you must also include <code>ResourceArn</code> and <code>TagKeys</code>.</p>', 'UpdateCallAnalyticsCategory' => '<p>Updates the specified Call Analytics category with new rules. Note that the <code>UpdateCallAnalyticsCategory</code> operation overwrites all existing rules contained in the specified category. You cannot append additional rules onto an existing category.</p> <p>To create a new category, see .</p>', 'UpdateMedicalVocabulary' => '<p>Updates an existing custom medical vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing custom vocabulary.</p>', 'UpdateVocabulary' => '<p>Updates an existing custom vocabulary with new values. This operation overwrites all existing information with your new values; you cannot append new terms onto an existing custom vocabulary.</p>', 'UpdateVocabularyFilter' => '<p>Updates an existing custom vocabulary filter with a new list of words. The new list you provide overwrites all previous entries; you cannot append new terms onto an existing custom vocabulary filter.</p>', ], 'shapes' => [ 'AbsoluteTimeRange' => [ 'base' => '<p>A time range, in milliseconds, between two points in your media file.</p> <p>You can use <code>StartTime</code> and <code>EndTime</code> to search a custom segment. For example, setting <code>StartTime</code> to 10000 and <code>EndTime</code> to 50000 only searches for your specified criteria in the audio contained between the 10,000 millisecond mark and the 50,000 millisecond mark of your media file. You must use <code>StartTime</code> and <code>EndTime</code> as a set; that is, if you include one, you must include both.</p> <p>You can use also <code>First</code> to search from the start of the audio until the time that you specify, or <code>Last</code> to search from the time that you specify until the end of the audio. For example, setting <code>First</code> to 50000 only searches for your specified criteria in the audio contained between the start of the media file to the 50,000 millisecond mark. You can use <code>First</code> and <code>Last</code> independently of each other.</p> <p>If you prefer to use percentage instead of milliseconds, see .</p>', 'refs' => [ 'InterruptionFilter$AbsoluteTimeRange' => '<p>Makes it possible to specify a time range (in milliseconds) in your audio, during which you want to search for an interruption. See for more detail.</p>', 'NonTalkTimeFilter$AbsoluteTimeRange' => '<p>Makes it possible to specify a time range (in milliseconds) in your audio, during which you want to search for a period of silence. See for more detail.</p>', 'SentimentFilter$AbsoluteTimeRange' => '<p>Makes it possible to specify a time range (in milliseconds) in your audio, during which you want to search for the specified sentiments. See for more detail.</p>', 'TranscriptFilter$AbsoluteTimeRange' => '<p>Makes it possible to specify a time range (in milliseconds) in your audio, during which you want to search for the specified key words or phrases. See for more detail.</p>', ], ], 'BadRequestException' => [ 'base' => '<p>Your request didn\'t pass one or more validation tests. This can occur when the entity you\'re trying to delete doesn\'t exist or if it\'s in a non-terminal state (such as <code>IN PROGRESS</code>). See the exception message field for more information.</p>', 'refs' => [], ], 'BaseModelName' => [ 'base' => NULL, 'refs' => [ 'CreateLanguageModelRequest$BaseModelName' => '<p>The Amazon Transcribe standard language model, or base model, used to create your custom language model. Amazon Transcribe offers two options for base models: Wideband and Narrowband.</p> <p>If the audio you want to transcribe has a sample rate of 16,000 Hz or greater, choose <code>WideBand</code>. To transcribe audio with a sample rate less than 16,000 Hz, choose <code>NarrowBand</code>.</p>', 'CreateLanguageModelResponse$BaseModelName' => '<p>The Amazon Transcribe standard language model, or base model, you specified when creating your custom language model.</p>', 'LanguageModel$BaseModelName' => '<p>The Amazon Transcribe standard language model, or base model, used to create your custom language model.</p>', ], ], 'Boolean' => [ 'base' => NULL, 'refs' => [ 'InterruptionFilter$Negate' => '<p>Set to <code>TRUE</code> to flag speech that does not contain interruptions. Set to <code>FALSE</code> to flag speech that contains interruptions.</p>', 'JobExecutionSettings$AllowDeferredExecution' => '<p>Makes it possible to enable job queuing when your concurrent request limit is exceeded. When <code>AllowDeferredExecution</code> is set to <code>true</code>, transcription job requests are placed in a queue until the number of jobs falls below the concurrent request limit. If <code>AllowDeferredExecution</code> is set to <code>false</code> and the number of transcription job requests exceed the concurrent request limit, you get a <code>LimitExceededException</code> error.</p> <p>If you include <code>AllowDeferredExecution</code> in your request, you must also include <code>DataAccessRoleArn</code>.</p>', 'LanguageModel$UpgradeAvailability' => '<p>Shows if a more current base model is available for use with the specified custom language model.</p> <p>If <code>false</code>, your custom language model is using the most up-to-date base model.</p> <p>If <code>true</code>, there is a newer base model available than the one your language model is using.</p> <p>Note that to update a base model, you must recreate the custom language model using the new base model. Base model upgrades for existing custom language models are not supported.</p>', 'MedicalScribeSettings$ShowSpeakerLabels' => '<p>Enables speaker partitioning (diarization) in your Medical Scribe output. Speaker partitioning labels the speech from individual speakers in your media file.</p> <p>If you enable <code>ShowSpeakerLabels</code> in your request, you must also include <code>MaxSpeakerLabels</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.</p>', 'MedicalScribeSettings$ChannelIdentification' => '<p>Enables channel identification in multi-channel audio.</p> <p>Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.</p>', 'MedicalTranscriptionSetting$ShowSpeakerLabels' => '<p>Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.</p> <p>If you enable <code>ShowSpeakerLabels</code> in your request, you must also include <code>MaxSpeakerLabels</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.</p>', 'MedicalTranscriptionSetting$ChannelIdentification' => '<p>Enables channel identification in multi-channel audio.</p> <p>Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.</p> <p>If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript does not separate the speech by channel.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.</p>', 'MedicalTranscriptionSetting$ShowAlternatives' => '<p>To include alternative transcriptions within your transcription output, include <code>ShowAlternatives</code> in your transcription request.</p> <p>If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is the maximum number of alternative transcriptions you want Amazon Transcribe Medical to generate.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.</p>', 'NonTalkTimeFilter$Negate' => '<p>Set to <code>TRUE</code> to flag periods of speech. Set to <code>FALSE</code> to flag periods of silence</p>', 'SentimentFilter$Negate' => '<p>Set to <code>TRUE</code> to flag the sentiments that you didn\'t include in your request. Set to <code>FALSE</code> to flag the sentiments that you specified in your request.</p>', 'Settings$ShowSpeakerLabels' => '<p>Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.</p> <p>If you enable <code>ShowSpeakerLabels</code> in your request, you must also include <code>MaxSpeakerLabels</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.</p>', 'Settings$ChannelIdentification' => '<p>Enables channel identification in multi-channel audio.</p> <p>Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.</p>', 'Settings$ShowAlternatives' => '<p>To include alternative transcriptions within your transcription output, include <code>ShowAlternatives</code> in your transcription request.</p> <p>If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript does not separate the speech by channel.</p> <p>If you include <code>ShowAlternatives</code>, you must also include <code>MaxAlternatives</code>, which is the maximum number of alternative transcriptions you want Amazon Transcribe to generate.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.</p>', 'StartTranscriptionJobRequest$IdentifyLanguage' => '<p>Enables automatic language identification in your transcription job request. Use this parameter if your media file contains only one language. If your media contains multiple languages, use <code>IdentifyMultipleLanguages</code> instead.</p> <p>If you include <code>IdentifyLanguage</code>, you can optionally include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your media file. Including <code>LanguageOptions</code> restricts <code>IdentifyLanguage</code> to only the language options that you specify, which can improve transcription accuracy.</p> <p>If you want to apply a custom language model, a custom vocabulary, or a custom vocabulary filter to your automatic language identification request, include <code>LanguageIdSettings</code> with the relevant sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and <code>VocabularyFilterName</code>). If you include <code>LanguageIdSettings</code>, also include <code>LanguageOptions</code>.</p> <p>Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p>', 'StartTranscriptionJobRequest$IdentifyMultipleLanguages' => '<p>Enables automatic multi-language identification in your transcription job request. Use this parameter if your media file contains more than one language. If your media contains only one language, use <code>IdentifyLanguage</code> instead.</p> <p>If you include <code>IdentifyMultipleLanguages</code>, you can optionally include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your media file. Including <code>LanguageOptions</code> restricts <code>IdentifyLanguage</code> to only the language options that you specify, which can improve transcription accuracy.</p> <p>If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic language identification request, include <code>LanguageIdSettings</code> with the relevant sub-parameters (<code>VocabularyName</code> and <code>VocabularyFilterName</code>). If you include <code>LanguageIdSettings</code>, also include <code>LanguageOptions</code>.</p> <p>Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p>', 'Summarization$GenerateAbstractiveSummary' => '<p>Enables Generative call summarization in your Call Analytics request</p> <p>Generative call summarization provides a summary of the transcript including important components discussed in the conversation.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-enable-summarization.html">Enabling generative call summarization</a>.</p>', 'TranscriptFilter$Negate' => '<p>Set to <code>TRUE</code> to flag the absence of the phrase that you specified in your request. Set to <code>FALSE</code> to flag the presence of the phrase that you specified in your request.</p>', 'TranscriptionJob$IdentifyLanguage' => '<p>Indicates whether automatic language identification was enabled (<code>TRUE</code>) for the specified transcription job.</p>', 'TranscriptionJob$IdentifyMultipleLanguages' => '<p>Indicates whether automatic multi-language identification was enabled (<code>TRUE</code>) for the specified transcription job.</p>', 'TranscriptionJobSummary$IdentifyLanguage' => '<p>Indicates whether automatic language identification was enabled (<code>TRUE</code>) for the specified transcription job.</p>', 'TranscriptionJobSummary$IdentifyMultipleLanguages' => '<p>Indicates whether automatic multi-language identification was enabled (<code>TRUE</code>) for the specified transcription job.</p>', ], ], 'CLMLanguageCode' => [ 'base' => NULL, 'refs' => [ 'CreateLanguageModelRequest$LanguageCode' => '<p>The language code that represents the language of your model. Each custom language model must contain terms in only one language, and the language you select for your custom language model must match the language of your training and tuning data.</p> <p>For a list of supported languages and their associated language codes, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table. Note that US English (<code>en-US</code>) is the only language supported with Amazon Transcribe Medical.</p> <p>A custom language model can only be used to transcribe files in the same language as the model. For example, if you create a custom language model using US English (<code>en-US</code>), you can only apply this model to files that contain English audio.</p>', 'CreateLanguageModelResponse$LanguageCode' => '<p>The language code you selected for your custom language model.</p>', 'LanguageModel$LanguageCode' => '<p>The language code used to create your custom language model. Each custom language model must contain terms in only one language, and the language you select for your custom language model must match the language of your training and tuning data.</p> <p>For a list of supported languages and their associated language codes, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table. Note that US English (<code>en-US</code>) is the only language supported with Amazon Transcribe Medical.</p>', ], ], 'CallAnalyticsFeature' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsSkippedFeature$Feature' => '<p>Indicates the type of analytics feature that was skipped during the analysis of a call analytics job.</p>', ], ], 'CallAnalyticsJob' => [ 'base' => '<p>Provides detailed information about a Call Analytics job.</p> <p>To view the job\'s status, refer to <code>CallAnalyticsJobStatus</code>. If the status is <code>COMPLETED</code>, the job is finished. You can find your completed transcript at the URI specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your transcription job failed.</p> <p>If you enabled personally identifiable information (PII) redaction, the redacted transcript appears at the location specified in <code>RedactedTranscriptFileUri</code>.</p> <p>If you chose to redact the audio in your media file, you can find your redacted media file at the location specified in the <code>RedactedMediaFileUri</code> field of your response.</p>', 'refs' => [ 'GetCallAnalyticsJobResponse$CallAnalyticsJob' => '<p>Provides detailed information about the specified Call Analytics job, including job status and, if applicable, failure reason.</p>', 'StartCallAnalyticsJobResponse$CallAnalyticsJob' => '<p>Provides detailed information about the current Call Analytics job, including job status and, if applicable, failure reason.</p>', ], ], 'CallAnalyticsJobDetails' => [ 'base' => '<p>Contains details about a call analytics job, including information about skipped analytics features.</p>', 'refs' => [ 'CallAnalyticsJob$CallAnalyticsJobDetails' => '<p>Provides detailed information about a call analytics job, including information about skipped analytics features.</p>', 'CallAnalyticsJobSummary$CallAnalyticsJobDetails' => '<p>Provides detailed information about a call analytics job, including information about skipped analytics features.</p>', ], ], 'CallAnalyticsJobName' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$CallAnalyticsJobName' => '<p>The name of the Call Analytics job. Job names are case sensitive and must be unique within an Amazon Web Services account.</p>', 'CallAnalyticsJobSummary$CallAnalyticsJobName' => '<p>The name of the Call Analytics job. Job names are case sensitive and must be unique within an Amazon Web Services account.</p>', 'DeleteCallAnalyticsJobRequest$CallAnalyticsJobName' => '<p>The name of the Call Analytics job you want to delete. Job names are case sensitive.</p>', 'GetCallAnalyticsJobRequest$CallAnalyticsJobName' => '<p>The name of the Call Analytics job you want information about. Job names are case sensitive.</p>', 'ListCallAnalyticsJobsRequest$JobNameContains' => '<p>Returns only the Call Analytics jobs that contain the specified string. The search is not case sensitive.</p>', 'StartCallAnalyticsJobRequest$CallAnalyticsJobName' => '<p>A unique name, chosen by you, for your Call Analytics job.</p> <p>This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new job with the same name as an existing job, you get a <code>ConflictException</code> error.</p>', ], ], 'CallAnalyticsJobSettings' => [ 'base' => '<p>Provides additional optional settings for your request, including content redaction, automatic language identification; allows you to apply custom language models, custom vocabulary filters, and custom vocabularies.</p>', 'refs' => [ 'CallAnalyticsJob$Settings' => '<p>Provides information on any additional settings that were included in your request. Additional settings include content redaction and language identification settings.</p>', 'StartCallAnalyticsJobRequest$Settings' => '<p>Specify additional optional settings in your request, including content redaction; allows you to apply custom language models, vocabulary filters, and custom vocabularies to your Call Analytics job.</p>', ], ], 'CallAnalyticsJobStatus' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$CallAnalyticsJobStatus' => '<p>Provides the status of the specified Call Analytics job.</p> <p>If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in <code>TranscriptFileUri</code> (or <code>RedactedTranscriptFileUri</code>, if you requested transcript redaction). If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your transcription job failed.</p>', 'CallAnalyticsJobSummary$CallAnalyticsJobStatus' => '<p>Provides the status of your Call Analytics job.</p> <p>If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in <code>TranscriptFileUri</code> (or <code>RedactedTranscriptFileUri</code>, if you requested transcript redaction). If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your transcription job failed.</p>', 'ListCallAnalyticsJobsRequest$Status' => '<p>Returns only Call Analytics jobs with the specified status. Jobs are ordered by creation date, with the newest job first. If you do not include <code>Status</code>, all Call Analytics jobs are returned.</p>', 'ListCallAnalyticsJobsResponse$Status' => '<p>Lists all Call Analytics jobs that have the status specified in your request. Jobs are ordered by creation date, with the newest job first.</p>', ], ], 'CallAnalyticsJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListCallAnalyticsJobsResponse$CallAnalyticsJobSummaries' => '<p>Provides a summary of information about each result.</p>', ], ], 'CallAnalyticsJobSummary' => [ 'base' => '<p>Provides detailed information about a specific Call Analytics job.</p>', 'refs' => [ 'CallAnalyticsJobSummaries$member' => NULL, ], ], 'CallAnalyticsSkippedFeature' => [ 'base' => '<p>Represents a skipped analytics feature during the analysis of a call analytics job.</p> <p>The <code>Feature</code> field indicates the type of analytics feature that was skipped.</p> <p>The <code>Message</code> field contains additional information or a message explaining why the analytics feature was skipped.</p> <p>The <code>ReasonCode</code> field provides a code indicating the reason why the analytics feature was skipped.</p>', 'refs' => [ 'CallAnalyticsSkippedFeatureList$member' => NULL, ], ], 'CallAnalyticsSkippedFeatureList' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJobDetails$Skipped' => '<p>Contains information about any skipped analytics features during the analysis of a call analytics job.</p> <p>This array lists all the analytics features that were skipped, along with their corresponding reason code and message.</p>', ], ], 'CallAnalyticsSkippedReasonCode' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsSkippedFeature$ReasonCode' => '<p>Provides a code indicating the reason why a specific analytics feature was skipped during the analysis of a call analytics job.</p>', ], ], 'CategoryName' => [ 'base' => NULL, 'refs' => [ 'CategoryProperties$CategoryName' => '<p>The name of the Call Analytics category. Category names are case sensitive and must be unique within an Amazon Web Services account.</p>', 'CreateCallAnalyticsCategoryRequest$CategoryName' => '<p>A unique name, chosen by you, for your Call Analytics category. It\'s helpful to use a detailed naming system that will make sense to you in the future. For example, it\'s better to use <code>sentiment-positive-last30seconds</code> for a category over a generic name like <code>test-category</code>.</p> <p>Category names are case sensitive.</p>', 'DeleteCallAnalyticsCategoryRequest$CategoryName' => '<p>The name of the Call Analytics category you want to delete. Category names are case sensitive.</p>', 'GetCallAnalyticsCategoryRequest$CategoryName' => '<p>The name of the Call Analytics category you want information about. Category names are case sensitive.</p>', 'UpdateCallAnalyticsCategoryRequest$CategoryName' => '<p>The name of the Call Analytics category you want to update. Category names are case sensitive.</p>', ], ], 'CategoryProperties' => [ 'base' => '<p>Provides you with the properties of the Call Analytics category you specified in your request. This includes the list of rules that define the specified category.</p>', 'refs' => [ 'CategoryPropertiesList$member' => NULL, 'CreateCallAnalyticsCategoryResponse$CategoryProperties' => '<p>Provides you with the properties of your new category, including its associated rules.</p>', 'GetCallAnalyticsCategoryResponse$CategoryProperties' => '<p>Provides you with the properties of the Call Analytics category you specified in your <code>GetCallAnalyticsCategory</code> request.</p>', 'UpdateCallAnalyticsCategoryResponse$CategoryProperties' => '<p>Provides you with the properties of the Call Analytics category you specified in your <code>UpdateCallAnalyticsCategory</code> request.</p>', ], ], 'CategoryPropertiesList' => [ 'base' => NULL, 'refs' => [ 'ListCallAnalyticsCategoriesResponse$Categories' => '<p>Provides detailed information about your Call Analytics categories, including all the rules associated with each category.</p>', ], ], 'ChannelDefinition' => [ 'base' => '<p>Makes it possible to specify which speaker is on which channel. For example, if your agent is the first participant to speak, you would set <code>ChannelId</code> to <code>0</code> (to indicate the first channel) and <code>ParticipantRole</code> to <code>AGENT</code> (to indicate that it\'s the agent speaking).</p>', 'refs' => [ 'ChannelDefinitions$member' => NULL, ], ], 'ChannelDefinitions' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$ChannelDefinitions' => '<p>Indicates which speaker is on which channel.</p>', 'StartCallAnalyticsJobRequest$ChannelDefinitions' => '<p>Makes it possible to specify which speaker is on which channel. For example, if your agent is the first participant to speak, you would set <code>ChannelId</code> to <code>0</code> (to indicate the first channel) and <code>ParticipantRole</code> to <code>AGENT</code> (to indicate that it\'s the agent speaking).</p>', ], ], 'ChannelId' => [ 'base' => NULL, 'refs' => [ 'ChannelDefinition$ChannelId' => '<p>Specify the audio channel you want to define.</p>', ], ], 'ConflictException' => [ 'base' => '<p>A resource already exists with this name. Resource names must be unique within an Amazon Web Services account.</p>', 'refs' => [], ], 'ContentRedaction' => [ 'base' => '<p>Makes it possible to redact or flag specified personally identifiable information (PII) in your transcript. If you use <code>ContentRedaction</code>, you must also include the sub-parameters: <code>RedactionOutput</code> and <code>RedactionType</code>. You can optionally include <code>PiiEntityTypes</code> to choose which types of PII you want to redact.</p>', 'refs' => [ 'CallAnalyticsJobSettings$ContentRedaction' => NULL, 'StartTranscriptionJobRequest$ContentRedaction' => '<p>Makes it possible to redact or flag specified personally identifiable information (PII) in your transcript. If you use <code>ContentRedaction</code>, you must also include the sub-parameters: <code>RedactionOutput</code> and <code>RedactionType</code>. You can optionally include <code>PiiEntityTypes</code> to choose which types of PII you want to redact. If you do not include <code>PiiEntityTypes</code> in your request, all PII is redacted.</p>', 'TranscriptionJob$ContentRedaction' => '<p>Indicates whether redaction was enabled in your transcript.</p>', 'TranscriptionJobSummary$ContentRedaction' => '<p>The content redaction settings of the transcription job.</p>', ], ], 'CreateCallAnalyticsCategoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateCallAnalyticsCategoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateLanguageModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateLanguageModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateMedicalVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateMedicalVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'CreateVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'DataAccessRoleArn' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) you included in your request.</p>', 'CreateVocabularyFilterRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files (in this case, your custom vocabulary filter). If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.</p> <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>', 'CreateVocabularyRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files (in this case, your custom vocabulary). If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.</p> <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>', 'InputDataConfig$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.</p> <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>', 'JobExecutionSettings$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.</p> <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p> <p>Note that if you include <code>DataAccessRoleArn</code> in your request, you must also include <code>AllowDeferredExecution</code>.</p>', 'MedicalScribeJob$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files, write to the output bucket, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate permissions your request fails.</p> <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>', 'StartCallAnalyticsJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files. If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.</p> <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>', 'StartMedicalScribeJobRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files, write to the output bucket, and use your KMS key if supplied. If the role that you specify doesn’t have the appropriate permissions your request fails.</p> <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>', 'UpdateVocabularyFilterRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files (in this case, your custom vocabulary filter). If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.</p> <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>', 'UpdateVocabularyRequest$DataAccessRoleArn' => '<p>The Amazon Resource Name (ARN) of an IAM role that has permissions to access the Amazon S3 bucket that contains your input files (in this case, your custom vocabulary). If the role that you specify doesn’t have the appropriate permissions to access the specified Amazon S3 location, your request fails.</p> <p>IAM role ARNs have the format <code>arn:partition:iam::account:role/role-name-with-path</code>. For example: <code>arn:aws:iam::111122223333:role/Admin</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-arns">IAM ARNs</a>.</p>', ], ], 'DateTime' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$StartTime' => '<p>The date and time the specified Call Analytics job began processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'CallAnalyticsJob$CreationTime' => '<p>The date and time the specified Call Analytics job request was made.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'CallAnalyticsJob$CompletionTime' => '<p>The date and time the specified Call Analytics job finished processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.</p>', 'CallAnalyticsJobSummary$CreationTime' => '<p>The date and time the specified Call Analytics job request was made.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'CallAnalyticsJobSummary$StartTime' => '<p>The date and time your Call Analytics job began processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'CallAnalyticsJobSummary$CompletionTime' => '<p>The date and time the specified Call Analytics job finished processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.</p>', 'CategoryProperties$CreateTime' => '<p>The date and time the specified Call Analytics category was created.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'CategoryProperties$LastUpdateTime' => '<p>The date and time the specified Call Analytics category was last updated.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-05T12:45:32.691000-07:00</code> represents 12:45 PM UTC-7 on May 5, 2022.</p>', 'CreateMedicalVocabularyResponse$LastModifiedTime' => '<p>The date and time you created your custom medical vocabulary.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'CreateVocabularyFilterResponse$LastModifiedTime' => '<p>The date and time you created your custom vocabulary filter.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'CreateVocabularyResponse$LastModifiedTime' => '<p>The date and time you created your custom vocabulary.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'GetMedicalVocabularyResponse$LastModifiedTime' => '<p>The date and time the specified custom medical vocabulary was last modified.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'GetVocabularyFilterResponse$LastModifiedTime' => '<p>The date and time the specified custom vocabulary filter was last modified.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'GetVocabularyResponse$LastModifiedTime' => '<p>The date and time the specified custom vocabulary was last modified.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'LanguageModel$CreateTime' => '<p>The date and time the specified custom language model was created.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'LanguageModel$LastModifiedTime' => '<p>The date and time the specified custom language model was last modified.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'MedicalScribeJob$StartTime' => '<p>The date and time your Medical Scribe job began processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.789000-07:00</code> represents a Medical Scribe job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'MedicalScribeJob$CreationTime' => '<p>The date and time the specified Medical Scribe job request was made.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents a Medical Scribe job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'MedicalScribeJob$CompletionTime' => '<p>The date and time the specified Medical Scribe job finished processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents a Medical Scribe job that finished processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'MedicalScribeJobSummary$CreationTime' => '<p>The date and time the specified Medical Scribe job request was made.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents a Medical Scribe job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'MedicalScribeJobSummary$StartTime' => '<p>The date and time your Medical Scribe job began processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.789000-07:00</code> represents a Medical Scribe job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'MedicalScribeJobSummary$CompletionTime' => '<p>The date and time the specified Medical Scribe job finished processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents a Medical Scribe job that finished processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'MedicalTranscriptionJob$StartTime' => '<p>The date and time the specified medical transcription job began processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'MedicalTranscriptionJob$CreationTime' => '<p>The date and time the specified medical transcription job request was made.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'MedicalTranscriptionJob$CompletionTime' => '<p>The date and time the specified medical transcription job finished processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.</p>', 'MedicalTranscriptionJobSummary$CreationTime' => '<p>The date and time the specified medical transcription job request was made.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'MedicalTranscriptionJobSummary$StartTime' => '<p>The date and time your medical transcription job began processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'MedicalTranscriptionJobSummary$CompletionTime' => '<p>The date and time the specified medical transcription job finished processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.</p>', 'TranscriptionJob$StartTime' => '<p>The date and time the specified transcription job began processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'TranscriptionJob$CreationTime' => '<p>The date and time the specified transcription job request was made.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'TranscriptionJob$CompletionTime' => '<p>The date and time the specified transcription job finished processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.</p>', 'TranscriptionJobSummary$CreationTime' => '<p>The date and time the specified transcription job request was made.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'TranscriptionJobSummary$StartTime' => '<p>The date and time your transcription job began processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.789000-07:00</code> represents a transcription job that started processing at 12:32 PM UTC-7 on May 4, 2022.</p>', 'TranscriptionJobSummary$CompletionTime' => '<p>The date and time the specified transcription job finished processing.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:33:13.922000-07:00</code> represents a transcription job that started processing at 12:33 PM UTC-7 on May 4, 2022.</p>', 'UpdateMedicalVocabularyResponse$LastModifiedTime' => '<p>The date and time the specified custom medical vocabulary was last updated.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'UpdateVocabularyFilterResponse$LastModifiedTime' => '<p>The date and time the specified custom vocabulary filter was last updated.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'UpdateVocabularyResponse$LastModifiedTime' => '<p>The date and time the specified custom vocabulary was last updated.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'VocabularyFilterInfo$LastModifiedTime' => '<p>The date and time the specified custom vocabulary filter was last modified.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', 'VocabularyInfo$LastModifiedTime' => '<p>The date and time the specified custom vocabulary was last modified.</p> <p>Timestamps are in the format <code>YYYY-MM-DD\'T\'HH:MM:SS.SSSSSS-UTC</code>. For example, <code>2022-05-04T12:32:58.761000-07:00</code> represents 12:32 PM UTC-7 on May 4, 2022.</p>', ], ], 'DeleteCallAnalyticsCategoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCallAnalyticsCategoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCallAnalyticsJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteCallAnalyticsJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'DeleteLanguageModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMedicalScribeJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMedicalTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteMedicalVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVocabularyFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'DeleteVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLanguageModelRequest' => [ 'base' => NULL, 'refs' => [], ], 'DescribeLanguageModelResponse' => [ 'base' => NULL, 'refs' => [], ], 'DurationInSeconds' => [ 'base' => NULL, 'refs' => [ 'LanguageCodeItem$DurationInSeconds' => '<p>Provides the total time, in seconds, each identified language is spoken in your media.</p>', ], ], 'FailureReason' => [ 'base' => NULL, 'refs' => [ 'BadRequestException$Message' => NULL, 'CallAnalyticsJob$FailureReason' => '<p>If <code>CallAnalyticsJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the Call Analytics job request failed.</p> <p>The <code>FailureReason</code> field contains one of the following values:</p> <ul> <li> <p> <code>Unsupported media format</code>.</p> <p>The media format specified in <code>MediaFormat</code> isn\'t valid. Refer to refer to the <code>MediaFormat</code> parameter for a list of supported formats.</p> </li> <li> <p> <code>The media format provided does not match the detected media format</code>.</p> <p>The media format specified in <code>MediaFormat</code> doesn\'t match the format of the input file. Check the media format of your media file and correct the specified value.</p> </li> <li> <p> <code>Invalid sample rate for audio file</code>.</p> <p>The sample rate specified in <code>MediaSampleRateHertz</code> isn\'t valid. The sample rate must be between 8,000 and 48,000 hertz.</p> </li> <li> <p> <code>The sample rate provided does not match the detected sample rate</code>.</p> <p>The sample rate specified in <code>MediaSampleRateHertz</code> doesn\'t match the sample rate detected in your input media file. Check the sample rate of your media file and correct the specified value.</p> </li> <li> <p> <code>Invalid file size: file size too large</code>.</p> <p>The size of your media file is larger than what Amazon Transcribe can process. For more information, refer to <a href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html#limits-amazon-transcribe">Service quotas</a>.</p> </li> <li> <p> <code>Invalid number of channels: number of channels too large</code>.</p> <p>Your audio contains more channels than Amazon Transcribe is able to process. For more information, refer to <a href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html#limits-amazon-transcribe">Service quotas</a>.</p> </li> </ul>', 'CallAnalyticsJobSummary$FailureReason' => '<p>If <code>CallAnalyticsJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the Call Analytics job failed. See also: <a href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.</p>', 'CreateMedicalVocabularyResponse$FailureReason' => '<p>If <code>VocabularyState</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the medical transcription job request failed. See also: <a href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.</p>', 'CreateVocabularyResponse$FailureReason' => '<p>If <code>VocabularyState</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the custom vocabulary request failed. See also: <a href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.</p>', 'GetMedicalVocabularyResponse$FailureReason' => '<p>If <code>VocabularyState</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the custom medical vocabulary request failed. See also: <a href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.</p>', 'GetVocabularyResponse$FailureReason' => '<p>If <code>VocabularyState</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the custom vocabulary request failed. See also: <a href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.</p>', 'LanguageModel$FailureReason' => '<p>If <code>ModelStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the custom language model request failed. See also: <a href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.</p>', 'MedicalScribeJob$FailureReason' => '<p>If <code>MedicalScribeJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the transcription job failed. See also: <a href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.</p>', 'MedicalScribeJobSummary$FailureReason' => '<p>If <code>MedicalScribeJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the transcription job failed. See also: <a href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.</p>', 'MedicalTranscriptionJob$FailureReason' => '<p>If <code>TranscriptionJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the transcription job request failed.</p> <p>The <code>FailureReason</code> field contains one of the following values:</p> <ul> <li> <p> <code>Unsupported media format</code>.</p> <p>The media format specified in <code>MediaFormat</code> isn\'t valid. Refer to refer to the <code>MediaFormat</code> parameter for a list of supported formats.</p> </li> <li> <p> <code>The media format provided does not match the detected media format</code>.</p> <p>The media format specified in <code>MediaFormat</code> doesn\'t match the format of the input file. Check the media format of your media file and correct the specified value.</p> </li> <li> <p> <code>Invalid sample rate for audio file</code>.</p> <p>The sample rate specified in <code>MediaSampleRateHertz</code> isn\'t valid. The sample rate must be between 16,000 and 48,000 hertz.</p> </li> <li> <p> <code>The sample rate provided does not match the detected sample rate</code>.</p> <p>The sample rate specified in <code>MediaSampleRateHertz</code> doesn\'t match the sample rate detected in your input media file. Check the sample rate of your media file and correct the specified value.</p> </li> <li> <p> <code>Invalid file size: file size too large</code>.</p> <p>The size of your media file is larger than what Amazon Transcribe can process. For more information, refer to <a href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html#limits-amazon-transcribe">Service quotas</a>.</p> </li> <li> <p> <code>Invalid number of channels: number of channels too large</code>.</p> <p>Your audio contains more channels than Amazon Transcribe is able to process. For more information, refer to <a href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html#limits-amazon-transcribe">Service quotas</a>.</p> </li> </ul>', 'MedicalTranscriptionJobSummary$FailureReason' => '<p>If <code>TranscriptionJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the transcription job failed. See also: <a href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.</p>', 'TranscriptionJob$FailureReason' => '<p>If <code>TranscriptionJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the transcription job request failed.</p> <p>The <code>FailureReason</code> field contains one of the following values:</p> <ul> <li> <p> <code>Unsupported media format</code>.</p> <p>The media format specified in <code>MediaFormat</code> isn\'t valid. Refer to refer to the <code>MediaFormat</code> parameter for a list of supported formats.</p> </li> <li> <p> <code>The media format provided does not match the detected media format</code>.</p> <p>The media format specified in <code>MediaFormat</code> doesn\'t match the format of the input file. Check the media format of your media file and correct the specified value.</p> </li> <li> <p> <code>Invalid sample rate for audio file</code>.</p> <p>The sample rate specified in <code>MediaSampleRateHertz</code> isn\'t valid. The sample rate must be between 8,000 and 48,000 hertz.</p> </li> <li> <p> <code>The sample rate provided does not match the detected sample rate</code>.</p> <p>The sample rate specified in <code>MediaSampleRateHertz</code> doesn\'t match the sample rate detected in your input media file. Check the sample rate of your media file and correct the specified value.</p> </li> <li> <p> <code>Invalid file size: file size too large</code>.</p> <p>The size of your media file is larger than what Amazon Transcribe can process. For more information, refer to <a href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html#limits-amazon-transcribe">Service quotas</a>.</p> </li> <li> <p> <code>Invalid number of channels: number of channels too large</code>.</p> <p>Your audio contains more channels than Amazon Transcribe is able to process. For more information, refer to <a href="https://docs.aws.amazon.com/general/latest/gr/transcribe.html#limits-amazon-transcribe">Service quotas</a>.</p> </li> </ul>', 'TranscriptionJobSummary$FailureReason' => '<p>If <code>TranscriptionJobStatus</code> is <code>FAILED</code>, <code>FailureReason</code> contains information about why the transcription job failed. See also: <a href="https://docs.aws.amazon.com/transcribe/latest/APIReference/CommonErrors.html">Common Errors</a>.</p>', ], ], 'GetCallAnalyticsCategoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCallAnalyticsCategoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetCallAnalyticsJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetCallAnalyticsJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalScribeJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalScribeJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalTranscriptionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetMedicalVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetTranscriptionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVocabularyFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVocabularyFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'GetVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'GetVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'IdentifiedLanguageScore' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$IdentifiedLanguageScore' => '<p>The confidence score associated with the language identified in your media file.</p> <p>Confidence scores are values between 0 and 1; a larger value indicates a higher probability that the identified language correctly matches the language spoken in your media.</p>', 'TranscriptionJob$IdentifiedLanguageScore' => '<p>The confidence score associated with the language identified in your media file.</p> <p>Confidence scores are values between 0 and 1; a larger value indicates a higher probability that the identified language correctly matches the language spoken in your media.</p>', 'TranscriptionJobSummary$IdentifiedLanguageScore' => '<p>The confidence score associated with the language identified in your media file.</p> <p>Confidence scores are values between 0 and 1; a larger value indicates a higher probability that the identified language correctly matches the language spoken in your media.</p>', ], ], 'InputDataConfig' => [ 'base' => '<p>Contains the Amazon S3 location of the training data you want to use to create a new custom language model, and permissions to access this location.</p> <p>When using <code>InputDataConfig</code>, you must include these sub-parameters: <code>S3Uri</code> and <code>DataAccessRoleArn</code>. You can optionally include <code>TuningDataS3Uri</code>.</p>', 'refs' => [ 'CreateLanguageModelRequest$InputDataConfig' => '<p>Contains the Amazon S3 location of the training data you want to use to create a new custom language model, and permissions to access this location.</p> <p>When using <code>InputDataConfig</code>, you must include these sub-parameters: <code>S3Uri</code>, which is the Amazon S3 location of your training data, and <code>DataAccessRoleArn</code>, which is the Amazon Resource Name (ARN) of the role that has permission to access your specified Amazon S3 location. You can optionally include <code>TuningDataS3Uri</code>, which is the Amazon S3 location of your tuning data. If you specify different Amazon S3 locations for training and tuning data, the ARN you use must have permissions to access both locations.</p>', 'CreateLanguageModelResponse$InputDataConfig' => '<p>Lists your data access role ARN (Amazon Resource Name) and the Amazon S3 locations you provided for your training (<code>S3Uri</code>) and tuning (<code>TuningDataS3Uri</code>) data.</p>', 'LanguageModel$InputDataConfig' => '<p>The Amazon S3 location of the input files used to train and tune your custom language model, in addition to the data access role ARN (Amazon Resource Name) that has permissions to access these data.</p>', ], ], 'InputType' => [ 'base' => NULL, 'refs' => [ 'CategoryProperties$InputType' => '<p>The input type associated with the specified category. <code>POST_CALL</code> refers to a category that is applied to batch transcriptions; <code>REAL_TIME</code> refers to a category that is applied to streaming transcriptions.</p>', 'CreateCallAnalyticsCategoryRequest$InputType' => '<p>Choose whether you want to create a real-time or a post-call category for your Call Analytics transcription.</p> <p>Specifying <code>POST_CALL</code> assigns your category to post-call transcriptions; categories with this input type cannot be applied to streaming (real-time) transcriptions.</p> <p>Specifying <code>REAL_TIME</code> assigns your category to streaming transcriptions; categories with this input type cannot be applied to post-call transcriptions.</p> <p>If you do not include <code>InputType</code>, your category is created as a post-call category by default.</p>', 'UpdateCallAnalyticsCategoryRequest$InputType' => '<p>Choose whether you want to update a real-time or a post-call category. The input type you specify must match the input type specified when the category was created. For example, if you created a category with the <code>POST_CALL</code> input type, you must use <code>POST_CALL</code> as the input type when updating this category.</p>', ], ], 'InternalFailureException' => [ 'base' => '<p>There was an internal error. Check the error message, correct the issue, and try your request again.</p>', 'refs' => [], ], 'InterruptionFilter' => [ 'base' => '<p>Flag the presence or absence of interruptions in your Call Analytics transcription output.</p> <p>Rules using <code>InterruptionFilter</code> are designed to match:</p> <ul> <li> <p>Instances where an agent interrupts a customer</p> </li> <li> <p>Instances where a customer interrupts an agent</p> </li> <li> <p>Either participant interrupting the other</p> </li> <li> <p>A lack of interruptions</p> </li> </ul> <p>See <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html#tca-rules-batch">Rule criteria for post-call categories</a> for usage examples.</p>', 'refs' => [ 'Rule$InterruptionFilter' => '<p>Flag the presence or absence of interruptions in your Call Analytics transcription output. Refer to for more detail.</p>', ], ], 'JobExecutionSettings' => [ 'base' => '<p>Makes it possible to control how your transcription job is processed. Currently, the only <code>JobExecutionSettings</code> modification you can choose is enabling job queueing using the <code>AllowDeferredExecution</code> sub-parameter.</p> <p>If you include <code>JobExecutionSettings</code> in your request, you must also include the sub-parameters: <code>AllowDeferredExecution</code> and <code>DataAccessRoleArn</code>.</p>', 'refs' => [ 'StartTranscriptionJobRequest$JobExecutionSettings' => '<p>Makes it possible to control how your transcription job is processed. Currently, the only <code>JobExecutionSettings</code> modification you can choose is enabling job queueing using the <code>AllowDeferredExecution</code> sub-parameter.</p> <p>If you include <code>JobExecutionSettings</code> in your request, you must also include the sub-parameters: <code>AllowDeferredExecution</code> and <code>DataAccessRoleArn</code>.</p>', 'TranscriptionJob$JobExecutionSettings' => '<p>Provides information about how your transcription job was processed. This parameter shows if your request was queued and what data access role was used.</p>', ], ], 'KMSEncryptionContextMap' => [ 'base' => NULL, 'refs' => [ 'StartMedicalScribeJobRequest$KMSEncryptionContext' => '<p>A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption context</a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in KMS</a>.</p>', 'StartMedicalTranscriptionJobRequest$KMSEncryptionContext' => '<p>A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption context</a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in KMS</a>.</p>', 'StartTranscriptionJobRequest$KMSEncryptionContext' => '<p>A map of plain text, non-secret key:value pairs, known as encryption context pairs, that provide an added layer of security for your data. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/key-management.html#kms-context">KMS encryption context</a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/symmetric-asymmetric.html">Asymmetric keys in KMS</a>.</p>', ], ], 'KMSKeyId' => [ 'base' => NULL, 'refs' => [ 'StartCallAnalyticsJobRequest$OutputEncryptionKMSKeyId' => '<p>The KMS key you want to use to encrypt your Call Analytics output.</p> <p>If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of four ways:</p> <ol> <li> <p>Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li> <li> <p>Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.</p> </li> <li> <p>Use the Amazon Resource Name (ARN) for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li> <li> <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p> </li> </ol> <p>If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:</p> <ol> <li> <p>Use the ARN for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li> <li> <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p> </li> </ol> <p>If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).</p> <p>If you specify a KMS key to encrypt your output, you must also specify an output location using the <code>OutputLocation</code> parameter.</p> <p>Note that the role making the request must have permission to use the specified KMS key.</p>', 'StartMedicalScribeJobRequest$OutputEncryptionKMSKeyId' => '<p>The KMS key you want to use to encrypt your Medical Scribe output.</p> <p>If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of four ways:</p> <ol> <li> <p>Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li> <li> <p>Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.</p> </li> <li> <p>Use the Amazon Resource Name (ARN) for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li> <li> <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p> </li> </ol> <p>If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:</p> <ol> <li> <p>Use the ARN for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li> <li> <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p> </li> </ol> <p>If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).</p> <p>Note that the role specified in the <code>DataAccessRoleArn</code> request parameter must have permission to use the specified KMS key.</p>', 'StartMedicalTranscriptionJobRequest$OutputEncryptionKMSKeyId' => '<p>The KMS key you want to use to encrypt your medical transcription output.</p> <p>If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of four ways:</p> <ol> <li> <p>Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li> <li> <p>Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.</p> </li> <li> <p>Use the Amazon Resource Name (ARN) for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li> <li> <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p> </li> </ol> <p>If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:</p> <ol> <li> <p>Use the ARN for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li> <li> <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p> </li> </ol> <p>If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).</p> <p>If you specify a KMS key to encrypt your output, you must also specify an output location using the <code>OutputLocation</code> parameter.</p> <p>Note that the role making the request must have permission to use the specified KMS key.</p>', 'StartTranscriptionJobRequest$OutputEncryptionKMSKeyId' => '<p>The KMS key you want to use to encrypt your transcription output.</p> <p>If using a key located in the <b>current</b> Amazon Web Services account, you can specify your KMS key in one of four ways:</p> <ol> <li> <p>Use the KMS key ID itself. For example, <code>1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li> <li> <p>Use an alias for the KMS key ID. For example, <code>alias/ExampleAlias</code>.</p> </li> <li> <p>Use the Amazon Resource Name (ARN) for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li> <li> <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p> </li> </ol> <p>If using a key located in a <b>different</b> Amazon Web Services account than the current Amazon Web Services account, you can specify your KMS key in one of two ways:</p> <ol> <li> <p>Use the ARN for the KMS key ID. For example, <code>arn:aws:kms:region:account-ID:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.</p> </li> <li> <p>Use the ARN for the KMS key alias. For example, <code>arn:aws:kms:region:account-ID:alias/ExampleAlias</code>.</p> </li> </ol> <p>If you do not specify an encryption key, your output is encrypted with the default Amazon S3 key (SSE-S3).</p> <p>If you specify a KMS key to encrypt your output, you must also specify an output location using the <code>OutputLocation</code> parameter.</p> <p>Note that the role making the request must have permission to use the specified KMS key.</p>', ], ], 'LanguageCode' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$LanguageCode' => '<p>The language code used to create your Call Analytics job. For a list of supported languages and their associated language codes, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p> <p>If you do not know the language spoken in your media file, you can omit this field and let Amazon Transcribe automatically identify the language of your media. To improve the accuracy of language identification, you can include several language codes and Amazon Transcribe chooses the closest match for your transcription.</p>', 'CallAnalyticsJobSummary$LanguageCode' => '<p>The language code used to create your Call Analytics transcription.</p>', 'CreateMedicalVocabularyRequest$LanguageCode' => '<p>The language code that represents the language of the entries in your custom vocabulary. US English (<code>en-US</code>) is the only language supported with Amazon Transcribe Medical.</p>', 'CreateMedicalVocabularyResponse$LanguageCode' => '<p>The language code you selected for your custom medical vocabulary. US English (<code>en-US</code>) is the only language supported with Amazon Transcribe Medical.</p>', 'CreateVocabularyFilterRequest$LanguageCode' => '<p>The language code that represents the language of the entries in your vocabulary filter. Each custom vocabulary filter must contain terms in only one language.</p> <p>A custom vocabulary filter can only be used to transcribe files in the same language as the filter. For example, if you create a custom vocabulary filter using US English (<code>en-US</code>), you can only apply this filter to files that contain English audio.</p> <p>For a list of supported languages and their associated language codes, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p>', 'CreateVocabularyFilterResponse$LanguageCode' => '<p>The language code you selected for your custom vocabulary filter.</p>', 'CreateVocabularyRequest$LanguageCode' => '<p>The language code that represents the language of the entries in your custom vocabulary. Each custom vocabulary must contain terms in only one language.</p> <p>A custom vocabulary can only be used to transcribe files in the same language as the custom vocabulary. For example, if you create a custom vocabulary using US English (<code>en-US</code>), you can only apply this custom vocabulary to files that contain English audio.</p> <p>For a list of supported languages and their associated language codes, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p>', 'CreateVocabularyResponse$LanguageCode' => '<p>The language code you selected for your custom vocabulary.</p>', 'GetMedicalVocabularyResponse$LanguageCode' => '<p>The language code you selected for your custom medical vocabulary. US English (<code>en-US</code>) is the only language supported with Amazon Transcribe Medical.</p>', 'GetVocabularyFilterResponse$LanguageCode' => '<p>The language code you selected for your custom vocabulary filter.</p>', 'GetVocabularyResponse$LanguageCode' => '<p>The language code you selected for your custom vocabulary.</p>', 'LanguageCodeItem$LanguageCode' => '<p>Provides the language code for each language identified in your media.</p>', 'LanguageIdSettingsMap$key' => NULL, 'LanguageOptions$member' => NULL, 'MedicalTranscriptionJob$LanguageCode' => '<p>The language code used to create your medical transcription job. US English (<code>en-US</code>) is the only supported language for medical transcriptions.</p>', 'MedicalTranscriptionJobSummary$LanguageCode' => '<p>The language code used to create your medical transcription. US English (<code>en-US</code>) is the only supported language for medical transcriptions.</p>', 'StartMedicalTranscriptionJobRequest$LanguageCode' => '<p>The language code that represents the language spoken in the input media file. US English (<code>en-US</code>) is the only valid value for medical transcription jobs. Any other value you enter for language code results in a <code>BadRequestException</code> error.</p>', 'StartTranscriptionJobRequest$LanguageCode' => '<p>The language code that represents the language spoken in the input media file.</p> <p>If you\'re unsure of the language spoken in your media file, consider using <code>IdentifyLanguage</code> or <code>IdentifyMultipleLanguages</code> to enable automatic language identification.</p> <p>Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p> <p>For a list of supported languages and their associated language codes, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p> <note> <p>To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>), your media file must be encoded at a sample rate of 16,000 Hz or higher.</p> </note>', 'TranscriptionJob$LanguageCode' => '<p>The language code used to create your transcription job. This parameter is used with single-language identification. For multi-language identification requests, refer to the plural version of this parameter, <code>LanguageCodes</code>.</p>', 'TranscriptionJobSummary$LanguageCode' => '<p>The language code used to create your transcription.</p>', 'UpdateMedicalVocabularyRequest$LanguageCode' => '<p>The language code that represents the language of the entries in the custom vocabulary you want to update. US English (<code>en-US</code>) is the only language supported with Amazon Transcribe Medical.</p>', 'UpdateMedicalVocabularyResponse$LanguageCode' => '<p>The language code you selected for your custom medical vocabulary. US English (<code>en-US</code>) is the only language supported with Amazon Transcribe Medical.</p>', 'UpdateVocabularyFilterResponse$LanguageCode' => '<p>The language code you selected for your custom vocabulary filter.</p>', 'UpdateVocabularyRequest$LanguageCode' => '<p>The language code that represents the language of the entries in the custom vocabulary you want to update. Each custom vocabulary must contain terms in only one language.</p> <p>A custom vocabulary can only be used to transcribe files in the same language as the custom vocabulary. For example, if you create a custom vocabulary using US English (<code>en-US</code>), you can only apply this custom vocabulary to files that contain English audio.</p> <p>For a list of supported languages and their associated language codes, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p>', 'UpdateVocabularyResponse$LanguageCode' => '<p>The language code you selected for your custom vocabulary.</p>', 'VocabularyFilterInfo$LanguageCode' => '<p>The language code that represents the language of the entries in your vocabulary filter. Each custom vocabulary filter must contain terms in only one language.</p> <p>A custom vocabulary filter can only be used to transcribe files in the same language as the filter. For example, if you create a custom vocabulary filter using US English (<code>en-US</code>), you can only apply this filter to files that contain English audio.</p> <p>For a list of supported languages and their associated language codes, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p>', 'VocabularyInfo$LanguageCode' => '<p>The language code used to create your custom vocabulary. Each custom vocabulary must contain terms in only one language.</p> <p>A custom vocabulary can only be used to transcribe files in the same language as the custom vocabulary. For example, if you create a custom vocabulary using US English (<code>en-US</code>), you can only apply this custom vocabulary to files that contain English audio.</p>', ], ], 'LanguageCodeItem' => [ 'base' => '<p>Provides information on the speech contained in a discreet utterance when multi-language identification is enabled in your request. This utterance represents a block of speech consisting of one language, preceded or followed by a block of speech in a different language.</p>', 'refs' => [ 'LanguageCodeList$member' => NULL, ], ], 'LanguageCodeList' => [ 'base' => NULL, 'refs' => [ 'TranscriptionJob$LanguageCodes' => '<p>The language codes used to create your transcription job. This parameter is used with multi-language identification. For single-language identification requests, refer to the singular version of this parameter, <code>LanguageCode</code>.</p>', 'TranscriptionJobSummary$LanguageCodes' => '<p>The language codes used to create your transcription job. This parameter is used with multi-language identification. For single-language identification, the singular version of this parameter, <code>LanguageCode</code>, is present.</p>', ], ], 'LanguageIdSettings' => [ 'base' => '<p>If using automatic language identification in your request and you want to apply a custom language model, a custom vocabulary, or a custom vocabulary filter, include <code>LanguageIdSettings</code> with the relevant sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and <code>VocabularyFilterName</code>). Note that multi-language identification (<code>IdentifyMultipleLanguages</code>) doesn\'t support custom language models.</p> <p> <code>LanguageIdSettings</code> supports two to five language codes. Each language code you include can have an associated custom language model, custom vocabulary, and custom vocabulary filter. The language codes that you specify must match the languages of the associated custom language models, custom vocabularies, and custom vocabulary filters.</p> <p>It\'s recommended that you include <code>LanguageOptions</code> when using <code>LanguageIdSettings</code> to ensure that the correct language dialect is identified. For example, if you specify a custom vocabulary that is in <code>en-US</code> but Amazon Transcribe determines that the language spoken in your media is <code>en-AU</code>, your custom vocabulary <i>is not</i> applied to your transcription. If you include <code>LanguageOptions</code> and include <code>en-US</code> as the only English language dialect, your custom vocabulary <i>is</i> applied to your transcription.</p> <p>If you want to include a custom language model with your request but <b>do not</b> want to use automatic language identification, use instead the <code/> parameter with the <code>LanguageModelName</code> sub-parameter. If you want to include a custom vocabulary or a custom vocabulary filter (or both) with your request but <b>do not</b> want to use automatic language identification, use instead the <code/> parameter with the <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both) sub-parameter.</p>', 'refs' => [ 'LanguageIdSettingsMap$value' => NULL, ], ], 'LanguageIdSettingsMap' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJobSettings$LanguageIdSettings' => '<p>If using automatic language identification in your request and you want to apply a custom language model, a custom vocabulary, or a custom vocabulary filter, include <code>LanguageIdSettings</code> with the relevant sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and <code>VocabularyFilterName</code>).</p> <p> <code>LanguageIdSettings</code> supports two to five language codes. Each language code you include can have an associated custom language model, custom vocabulary, and custom vocabulary filter. The language codes that you specify must match the languages of the associated custom language models, custom vocabularies, and custom vocabulary filters.</p> <p>It\'s recommended that you include <code>LanguageOptions</code> when using <code>LanguageIdSettings</code> to ensure that the correct language dialect is identified. For example, if you specify a custom vocabulary that is in <code>en-US</code> but Amazon Transcribe determines that the language spoken in your media is <code>en-AU</code>, your custom vocabulary <i>is not</i> applied to your transcription. If you include <code>LanguageOptions</code> and include <code>en-US</code> as the only English language dialect, your custom vocabulary <i>is</i> applied to your transcription.</p> <p>If you want to include a custom language model, custom vocabulary, or custom vocabulary filter with your request but <b>do not</b> want to use automatic language identification, use instead the <code/> parameter with the <code>LanguageModelName</code>, <code>VocabularyName</code>, or <code>VocabularyFilterName</code> sub-parameters.</p> <p>For a list of languages supported with Call Analytics, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages and language-specific features</a>.</p>', 'StartTranscriptionJobRequest$LanguageIdSettings' => '<p>If using automatic language identification in your request and you want to apply a custom language model, a custom vocabulary, or a custom vocabulary filter, include <code>LanguageIdSettings</code> with the relevant sub-parameters (<code>VocabularyName</code>, <code>LanguageModelName</code>, and <code>VocabularyFilterName</code>). Note that multi-language identification (<code>IdentifyMultipleLanguages</code>) doesn\'t support custom language models.</p> <p> <code>LanguageIdSettings</code> supports two to five language codes. Each language code you include can have an associated custom language model, custom vocabulary, and custom vocabulary filter. The language codes that you specify must match the languages of the associated custom language models, custom vocabularies, and custom vocabulary filters.</p> <p>It\'s recommended that you include <code>LanguageOptions</code> when using <code>LanguageIdSettings</code> to ensure that the correct language dialect is identified. For example, if you specify a custom vocabulary that is in <code>en-US</code> but Amazon Transcribe determines that the language spoken in your media is <code>en-AU</code>, your custom vocabulary <i>is not</i> applied to your transcription. If you include <code>LanguageOptions</code> and include <code>en-US</code> as the only English language dialect, your custom vocabulary <i>is</i> applied to your transcription.</p> <p>If you want to include a custom language model with your request but <b>do not</b> want to use automatic language identification, use instead the <code/> parameter with the <code>LanguageModelName</code> sub-parameter. If you want to include a custom vocabulary or a custom vocabulary filter (or both) with your request but <b>do not</b> want to use automatic language identification, use instead the <code/> parameter with the <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both) sub-parameter.</p>', 'TranscriptionJob$LanguageIdSettings' => '<p>Provides the name and language of all custom language models, custom vocabularies, and custom vocabulary filters that you included in your request.</p>', ], ], 'LanguageModel' => [ 'base' => '<p>Provides information about a custom language model, including:</p> <ul> <li> <p>The base model name</p> </li> <li> <p>When the model was created</p> </li> <li> <p>The location of the files used to train the model</p> </li> <li> <p>When the model was last modified</p> </li> <li> <p>The name you chose for the model</p> </li> <li> <p>The model\'s language</p> </li> <li> <p>The model\'s processing state</p> </li> <li> <p>Any available upgrades for the base model</p> </li> </ul>', 'refs' => [ 'DescribeLanguageModelResponse$LanguageModel' => '<p>Provides information about the specified custom language model.</p> <p>This parameter also shows if the base language model you used to create your custom language model has been updated. If Amazon Transcribe has updated the base model, you can create a new custom language model using the updated base model.</p> <p>If you tried to create a new custom language model and the request wasn\'t successful, you can use this <code>DescribeLanguageModel</code> to help identify the reason for this failure.</p>', 'Models$member' => NULL, ], ], 'LanguageOptions' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJobSettings$LanguageOptions' => '<p>You can specify two or more language codes that represent the languages you think may be present in your media. Including more than five is not recommended. If you\'re unsure what languages are present, do not include this parameter.</p> <p>Including language options can improve the accuracy of language identification.</p> <p>For a list of languages supported with Call Analytics, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p> <p>To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>), your media file must be encoded at a sample rate of 16,000 Hz or higher.</p>', 'StartTranscriptionJobRequest$LanguageOptions' => '<p>You can specify two or more language codes that represent the languages you think may be present in your media. Including more than five is not recommended. If you\'re unsure what languages are present, do not include this parameter.</p> <p>If you include <code>LanguageOptions</code> in your request, you must also include <code>IdentifyLanguage</code>.</p> <p>For more information, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a>.</p> <p>To transcribe speech in Modern Standard Arabic (<code>ar-SA</code>), your media file must be encoded at a sample rate of 16,000 Hz or higher.</p>', 'TranscriptionJob$LanguageOptions' => '<p>Provides the language codes you specified in your request.</p>', ], ], 'LimitExceededException' => [ 'base' => '<p>You\'ve either sent too many requests or your input file is too long. Wait before retrying your request, or use a smaller file and try your request again.</p>', 'refs' => [], ], 'ListCallAnalyticsCategoriesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCallAnalyticsCategoriesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListCallAnalyticsJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListCallAnalyticsJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListLanguageModelsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListLanguageModelsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalScribeJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalScribeJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalTranscriptionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalTranscriptionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalVocabulariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListMedicalVocabulariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTagsForResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListTranscriptionJobsRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListTranscriptionJobsResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVocabulariesRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVocabulariesResponse' => [ 'base' => NULL, 'refs' => [], ], 'ListVocabularyFiltersRequest' => [ 'base' => NULL, 'refs' => [], ], 'ListVocabularyFiltersResponse' => [ 'base' => NULL, 'refs' => [], ], 'MaxAlternatives' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionSetting$MaxAlternatives' => '<p>Indicate the maximum number of alternative transcriptions you want Amazon Transcribe Medical to include in your transcript.</p> <p>If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe Medical, only the actual number of alternative transcriptions are included.</p> <p>If you include <code>MaxAlternatives</code> in your request, you must also include <code>ShowAlternatives</code> with a value of <code>true</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.</p>', 'Settings$MaxAlternatives' => '<p>Indicate the maximum number of alternative transcriptions you want Amazon Transcribe to include in your transcript.</p> <p>If you select a number greater than the number of alternative transcriptions generated by Amazon Transcribe, only the actual number of alternative transcriptions are included.</p> <p>If you include <code>MaxAlternatives</code> in your request, you must also include <code>ShowAlternatives</code> with a value of <code>true</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-alternatives.html">Alternative transcriptions</a>.</p>', ], ], 'MaxResults' => [ 'base' => NULL, 'refs' => [ 'ListCallAnalyticsCategoriesRequest$MaxResults' => '<p>The maximum number of Call Analytics categories to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.</p>', 'ListCallAnalyticsJobsRequest$MaxResults' => '<p>The maximum number of Call Analytics jobs to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.</p>', 'ListLanguageModelsRequest$MaxResults' => '<p>The maximum number of custom language models to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.</p>', 'ListMedicalScribeJobsRequest$MaxResults' => '<p>The maximum number of Medical Scribe jobs to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.</p>', 'ListMedicalTranscriptionJobsRequest$MaxResults' => '<p>The maximum number of medical transcription jobs to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.</p>', 'ListMedicalVocabulariesRequest$MaxResults' => '<p>The maximum number of custom medical vocabularies to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.</p>', 'ListTranscriptionJobsRequest$MaxResults' => '<p>The maximum number of transcription jobs to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.</p>', 'ListVocabulariesRequest$MaxResults' => '<p>The maximum number of custom vocabularies to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.</p>', 'ListVocabularyFiltersRequest$MaxResults' => '<p>The maximum number of custom vocabulary filters to return in each page of results. If there are fewer results than the value that you specify, only the actual results are returned. If you do not specify a value, a default of 5 is used.</p>', ], ], 'MaxSpeakers' => [ 'base' => NULL, 'refs' => [ 'MedicalScribeSettings$MaxSpeakerLabels' => '<p>Specify the maximum number of speakers you want to partition in your media.</p> <p>Note that if your media contains more speakers than the specified number, multiple speakers are treated as a single speaker.</p> <p>If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.</p>', 'MedicalTranscriptionSetting$MaxSpeakerLabels' => '<p>Specify the maximum number of speakers you want to partition in your media.</p> <p>Note that if your media contains more speakers than the specified number, multiple speakers are treated as a single speaker.</p> <p>If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.</p>', 'Settings$MaxSpeakerLabels' => '<p>Specify the maximum number of speakers you want to partition in your media.</p> <p>Note that if your media contains more speakers than the specified number, multiple speakers are treated as a single speaker.</p> <p>If you specify the <code>MaxSpeakerLabels</code> field, you must set the <code>ShowSpeakerLabels</code> field to true.</p>', ], ], 'Media' => [ 'base' => '<p>Describes the Amazon S3 location of the media file you want to use in your request.</p> <p>For information on supported media formats, refer to the <code>MediaFormat</code> parameter or the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a> section in the Amazon S3 Developer Guide.</p>', 'refs' => [ 'CallAnalyticsJob$Media' => '<p>Provides the Amazon S3 location of the media file you used in your Call Analytics request.</p>', 'MedicalScribeJob$Media' => NULL, 'MedicalTranscriptionJob$Media' => NULL, 'StartCallAnalyticsJobRequest$Media' => '<p>Describes the Amazon S3 location of the media file you want to use in your Call Analytics request.</p>', 'StartMedicalScribeJobRequest$Media' => NULL, 'StartMedicalTranscriptionJobRequest$Media' => NULL, 'StartTranscriptionJobRequest$Media' => '<p>Describes the Amazon S3 location of the media file you want to use in your request.</p>', 'TranscriptionJob$Media' => '<p>Provides the Amazon S3 location of the media file you used in your request.</p>', ], ], 'MediaFormat' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$MediaFormat' => '<p>The format of the input media file.</p>', 'MedicalTranscriptionJob$MediaFormat' => '<p>The format of the input media file.</p>', 'StartMedicalTranscriptionJobRequest$MediaFormat' => '<p>Specify the format of your input media file.</p>', 'StartTranscriptionJobRequest$MediaFormat' => '<p>Specify the format of your input media file.</p>', 'TranscriptionJob$MediaFormat' => '<p>The format of the input media file.</p>', ], ], 'MediaSampleRateHertz' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJob$MediaSampleRateHertz' => '<p>The sample rate, in hertz, of the audio track in your input media file.</p>', 'StartTranscriptionJobRequest$MediaSampleRateHertz' => '<p>The sample rate, in hertz, of the audio track in your input media file.</p> <p>If you do not specify the media sample rate, Amazon Transcribe determines it for you. If you specify the sample rate, it must match the rate detected by Amazon Transcribe. If there\'s a mismatch between the value that you specify and the value detected, your job fails. In most cases, you can omit <code>MediaSampleRateHertz</code> and let Amazon Transcribe determine the sample rate.</p>', 'TranscriptionJob$MediaSampleRateHertz' => '<p>The sample rate, in hertz, of the audio track in your input media file.</p>', ], ], 'MedicalContentIdentificationType' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJob$ContentIdentificationType' => '<p>Indicates whether content identification was enabled for your transcription request.</p>', 'MedicalTranscriptionJobSummary$ContentIdentificationType' => '<p>Labels all personal health information (PHI) identified in your transcript. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health information (PHI) in a transcription</a>.</p>', 'StartMedicalTranscriptionJobRequest$ContentIdentificationType' => '<p>Labels all personal health information (PHI) identified in your transcript. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/phi-id.html">Identifying personal health information (PHI) in a transcription</a>.</p>', ], ], 'MedicalMediaSampleRateHertz' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJob$MediaSampleRateHertz' => '<p>The sample rate, in hertz, of the audio track in your input media file.</p>', 'StartMedicalTranscriptionJobRequest$MediaSampleRateHertz' => '<p>The sample rate, in hertz, of the audio track in your input media file.</p> <p>If you do not specify the media sample rate, Amazon Transcribe Medical determines it for you. If you specify the sample rate, it must match the rate detected by Amazon Transcribe Medical; if there\'s a mismatch between the value that you specify and the value detected, your job fails. Therefore, in most cases, it\'s advised to omit <code>MediaSampleRateHertz</code> and let Amazon Transcribe Medical determine the sample rate.</p>', ], ], 'MedicalScribeChannelDefinition' => [ 'base' => '<p>Indicates which speaker is on which channel. The options are <code>CLINICIAN</code> and <code>PATIENT</code> </p>', 'refs' => [ 'MedicalScribeChannelDefinitions$member' => NULL, ], ], 'MedicalScribeChannelDefinitions' => [ 'base' => NULL, 'refs' => [ 'MedicalScribeJob$ChannelDefinitions' => '<p>Makes it possible to specify which speaker is on which channel. For example, if the clinician is the first participant to speak, you would set <code>ChannelId</code> of the first <code>ChannelDefinition</code> in the list to <code>0</code> (to indicate the first channel) and <code>ParticipantRole</code> to <code>CLINICIAN</code> (to indicate that it\'s the clinician speaking). Then you would set the <code>ChannelId</code> of the second <code>ChannelDefinition</code> in the list to <code>1</code> (to indicate the second channel) and <code>ParticipantRole</code> to <code>PATIENT</code> (to indicate that it\'s the patient speaking). </p>', 'StartMedicalScribeJobRequest$ChannelDefinitions' => '<p>Makes it possible to specify which speaker is on which channel. For example, if the clinician is the first participant to speak, you would set <code>ChannelId</code> of the first <code>ChannelDefinition</code> in the list to <code>0</code> (to indicate the first channel) and <code>ParticipantRole</code> to <code>CLINICIAN</code> (to indicate that it\'s the clinician speaking). Then you would set the <code>ChannelId</code> of the second <code>ChannelDefinition</code> in the list to <code>1</code> (to indicate the second channel) and <code>ParticipantRole</code> to <code>PATIENT</code> (to indicate that it\'s the patient speaking). </p>', ], ], 'MedicalScribeChannelId' => [ 'base' => NULL, 'refs' => [ 'MedicalScribeChannelDefinition$ChannelId' => '<p>Specify the audio channel you want to define.</p>', ], ], 'MedicalScribeJob' => [ 'base' => '<p>Provides detailed information about a Medical Scribe job.</p> <p>To view the status of the specified Medical Scribe job, check the <code>MedicalScribeJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the locations specified in <code>MedicalScribeOutput</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your Medical Scribe job failed.</p>', 'refs' => [ 'GetMedicalScribeJobResponse$MedicalScribeJob' => '<p>Provides detailed information about the specified Medical Scribe job, including job status and, if applicable, failure reason</p>', 'StartMedicalScribeJobResponse$MedicalScribeJob' => '<p>Provides detailed information about the current Medical Scribe job, including job status and, if applicable, failure reason.</p>', ], ], 'MedicalScribeJobStatus' => [ 'base' => NULL, 'refs' => [ 'ListMedicalScribeJobsRequest$Status' => '<p>Returns only Medical Scribe jobs with the specified status. Jobs are ordered by creation date, with the newest job first. If you do not include <code>Status</code>, all Medical Scribe jobs are returned.</p>', 'ListMedicalScribeJobsResponse$Status' => '<p>Lists all Medical Scribe jobs that have the status specified in your request. Jobs are ordered by creation date, with the newest job first.</p>', 'MedicalScribeJob$MedicalScribeJobStatus' => '<p>Provides the status of the specified Medical Scribe job.</p> <p>If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in <code>MedicalScribeOutput</code> If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your Medical Scribe job failed.</p>', 'MedicalScribeJobSummary$MedicalScribeJobStatus' => '<p>Provides the status of the specified Medical Scribe job.</p> <p>If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in <code>MedicalScribeOutput</code> If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your Medical Scribe job failed.</p>', ], ], 'MedicalScribeJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListMedicalScribeJobsResponse$MedicalScribeJobSummaries' => '<p>Provides a summary of information about each result.</p>', ], ], 'MedicalScribeJobSummary' => [ 'base' => '<p>Provides detailed information about a specific Medical Scribe job.</p>', 'refs' => [ 'MedicalScribeJobSummaries$member' => NULL, ], ], 'MedicalScribeLanguageCode' => [ 'base' => NULL, 'refs' => [ 'MedicalScribeJob$LanguageCode' => '<p>The language code used to create your Medical Scribe job. US English (<code>en-US</code>) is the only supported language for Medical Scribe jobs. </p>', 'MedicalScribeJobSummary$LanguageCode' => '<p>The language code used to create your Medical Scribe job. US English (<code>en-US</code>) is the only supported language for Medical Scribe jobs. </p>', ], ], 'MedicalScribeOutput' => [ 'base' => '<p>The location of the output of your Medical Scribe job. <code>ClinicalDocumentUri</code> holds the Amazon S3 URI for the Clinical Document and <code>TranscriptFileUri</code> holds the Amazon S3 URI for the Transcript.</p>', 'refs' => [ 'MedicalScribeJob$MedicalScribeOutput' => '<p>The location of the output of your Medical Scribe job. <code>ClinicalDocumentUri</code> holds the Amazon S3 URI for the Clinical Document and <code>TranscriptFileUri</code> holds the Amazon S3 URI for the Transcript.</p>', ], ], 'MedicalScribeParticipantRole' => [ 'base' => NULL, 'refs' => [ 'MedicalScribeChannelDefinition$ParticipantRole' => '<p>Specify the participant that you want to flag. The options are <code>CLINICIAN</code> and <code>PATIENT</code> </p>', ], ], 'MedicalScribeSettings' => [ 'base' => '<p>Makes it possible to control how your Medical Scribe job is processed using a <code>MedicalScribeSettings</code> object. Specify <code>ChannelIdentification</code> if <code>ChannelDefinitions</code> are set. Enabled <code>ShowSpeakerLabels</code> if <code>ChannelIdentification</code> and <code>ChannelDefinitions</code> are not set. One and only one of <code>ChannelIdentification</code> and <code>ShowSpeakerLabels</code> must be set. If <code>ShowSpeakerLabels</code> is set, <code>MaxSpeakerLabels</code> must also be set. Use <code>Settings</code> to specify a vocabulary or vocabulary filter or both using <code>VocabularyName</code>, <code>VocabularyFilterName</code>. <code>VocabularyFilterMethod</code> must be specified if <code>VocabularyFilterName</code> is set. </p>', 'refs' => [ 'MedicalScribeJob$Settings' => '<p>Makes it possible to control how your Medical Scribe job is processed using a <code>MedicalScribeSettings</code> object. Specify <code>ChannelIdentification</code> if <code>ChannelDefinitions</code> are set. Enabled <code>ShowSpeakerLabels</code> if <code>ChannelIdentification</code> and <code>ChannelDefinitions</code> are not set. One and only one of <code>ChannelIdentification</code> and <code>ShowSpeakerLabels</code> must be set. If <code>ShowSpeakerLabels</code> is set, <code>MaxSpeakerLabels</code> must also be set. Use <code>Settings</code> to specify a vocabulary or vocabulary filter or both using <code>VocabularyName</code>, <code>VocabularyFilterName</code>. <code>VocabularyFilterMethod</code> must be specified if <code>VocabularyFilterName</code> is set. </p>', 'StartMedicalScribeJobRequest$Settings' => '<p>Makes it possible to control how your Medical Scribe job is processed using a <code>MedicalScribeSettings</code> object. Specify <code>ChannelIdentification</code> if <code>ChannelDefinitions</code> are set. Enabled <code>ShowSpeakerLabels</code> if <code>ChannelIdentification</code> and <code>ChannelDefinitions</code> are not set. One and only one of <code>ChannelIdentification</code> and <code>ShowSpeakerLabels</code> must be set. If <code>ShowSpeakerLabels</code> is set, <code>MaxSpeakerLabels</code> must also be set. Use <code>Settings</code> to specify a vocabulary or vocabulary filter or both using <code>VocabularyName</code>, <code>VocabularyFilterName</code>. <code>VocabularyFilterMethod</code> must be specified if <code>VocabularyFilterName</code> is set. </p>', ], ], 'MedicalTranscript' => [ 'base' => '<p>Provides you with the Amazon S3 URI you can use to access your transcript.</p>', 'refs' => [ 'MedicalTranscriptionJob$Transcript' => '<p>Provides you with the Amazon S3 URI you can use to access your transcript.</p>', ], ], 'MedicalTranscriptionJob' => [ 'base' => '<p>Provides detailed information about a medical transcription job.</p> <p>To view the status of the specified medical transcription job, check the <code>TranscriptionJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your transcription job failed.</p>', 'refs' => [ 'GetMedicalTranscriptionJobResponse$MedicalTranscriptionJob' => '<p>Provides detailed information about the specified medical transcription job, including job status and, if applicable, failure reason.</p>', 'StartMedicalTranscriptionJobResponse$MedicalTranscriptionJob' => '<p>Provides detailed information about the current medical transcription job, including job status and, if applicable, failure reason.</p>', ], ], 'MedicalTranscriptionJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListMedicalTranscriptionJobsResponse$MedicalTranscriptionJobSummaries' => '<p>Provides a summary of information about each result.</p>', ], ], 'MedicalTranscriptionJobSummary' => [ 'base' => '<p>Provides detailed information about a specific medical transcription job.</p>', 'refs' => [ 'MedicalTranscriptionJobSummaries$member' => NULL, ], ], 'MedicalTranscriptionSetting' => [ 'base' => '<p>Allows additional optional settings in your request, including channel identification, alternative transcriptions, and speaker partitioning. You can use that to apply custom vocabularies to your medical transcription job.</p>', 'refs' => [ 'MedicalTranscriptionJob$Settings' => '<p>Provides information on any additional settings that were included in your request. Additional settings include channel identification, alternative transcriptions, speaker partitioning, custom vocabularies, and custom vocabulary filters.</p>', 'StartMedicalTranscriptionJobRequest$Settings' => '<p>Specify additional optional settings in your request, including channel identification, alternative transcriptions, and speaker partitioning. You can use that to apply custom vocabularies to your transcription job.</p>', ], ], 'ModelName' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJobSettings$LanguageModelName' => '<p>The name of the custom language model you want to use when processing your Call Analytics job. Note that custom language model names are case sensitive.</p> <p>The language of the specified custom language model must match the language code that you specify in your transcription request. If the languages do not match, the custom language model isn\'t applied. There are no errors or warnings associated with a language mismatch.</p>', 'CreateLanguageModelRequest$ModelName' => '<p>A unique name, chosen by you, for your custom language model.</p> <p>This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new custom language model with the same name as an existing custom language model, you get a <code>ConflictException</code> error.</p>', 'CreateLanguageModelResponse$ModelName' => '<p>The name of your custom language model.</p>', 'DeleteLanguageModelRequest$ModelName' => '<p>The name of the custom language model you want to delete. Model names are case sensitive.</p>', 'DescribeLanguageModelRequest$ModelName' => '<p>The name of the custom language model you want information about. Model names are case sensitive.</p>', 'LanguageIdSettings$LanguageModelName' => '<p>The name of the custom language model you want to use when processing your transcription job. Note that custom language model names are case sensitive.</p> <p>The language of the specified custom language model must match the language code that you specify in your transcription request. If the languages do not match, the custom language model isn\'t applied. There are no errors or warnings associated with a language mismatch.</p>', 'LanguageModel$ModelName' => '<p>A unique name, chosen by you, for your custom language model.</p> <p>This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.</p>', 'ListLanguageModelsRequest$NameContains' => '<p>Returns only the custom language models that contain the specified string. The search is not case sensitive.</p>', 'ModelSettings$LanguageModelName' => '<p>The name of the custom language model you want to use when processing your transcription job. Note that custom language model names are case sensitive.</p> <p>The language of the specified custom language model must match the language code that you specify in your transcription request. If the languages do not match, the custom language model isn\'t applied. There are no errors or warnings associated with a language mismatch.</p>', ], ], 'ModelSettings' => [ 'base' => '<p>Provides the name of the custom language model that was included in the specified transcription job.</p> <p>Only use <code>ModelSettings</code> with the <code>LanguageModelName</code> sub-parameter if you\'re <b>not</b> using automatic language identification (<code/>). If using <code>LanguageIdSettings</code> in your request, this parameter contains a <code>LanguageModelName</code> sub-parameter.</p>', 'refs' => [ 'StartTranscriptionJobRequest$ModelSettings' => '<p>Specify the custom language model you want to include with your transcription job. If you include <code>ModelSettings</code> in your request, you must include the <code>LanguageModelName</code> sub-parameter.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a>.</p>', 'TranscriptionJob$ModelSettings' => '<p>Provides information on the custom language model you included in your request.</p>', 'TranscriptionJobSummary$ModelSettings' => NULL, ], ], 'ModelStatus' => [ 'base' => NULL, 'refs' => [ 'CreateLanguageModelResponse$ModelStatus' => '<p>The status of your custom language model. When the status displays as <code>COMPLETED</code>, your model is ready to use.</p>', 'LanguageModel$ModelStatus' => '<p>The status of the specified custom language model. When the status displays as <code>COMPLETED</code> the model is ready for use.</p>', 'ListLanguageModelsRequest$StatusEquals' => '<p>Returns only custom language models with the specified status. Language models are ordered by creation date, with the newest model first. If you do not include <code>StatusEquals</code>, all custom language models are returned.</p>', ], ], 'Models' => [ 'base' => NULL, 'refs' => [ 'ListLanguageModelsResponse$Models' => '<p>Provides information about the custom language models that match the criteria specified in your request.</p>', ], ], 'NextToken' => [ 'base' => NULL, 'refs' => [ 'ListCallAnalyticsCategoriesRequest$NextToken' => '<p>If your <code>ListCallAnalyticsCategories</code> request returns more results than can be displayed, <code>NextToken</code> is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListCallAnalyticsCategoriesResponse$NextToken' => '<p>If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To view the next set of results, copy the string associated with the <code>NextToken</code> parameter in your results output, then run your request again including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListCallAnalyticsJobsRequest$NextToken' => '<p>If your <code>ListCallAnalyticsJobs</code> request returns more results than can be displayed, <code>NextToken</code> is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListCallAnalyticsJobsResponse$NextToken' => '<p>If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To view the next set of results, copy the string associated with the <code>NextToken</code> parameter in your results output, then run your request again including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListLanguageModelsRequest$NextToken' => '<p>If your <code>ListLanguageModels</code> request returns more results than can be displayed, <code>NextToken</code> is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListLanguageModelsResponse$NextToken' => '<p>If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To view the next set of results, copy the string associated with the <code>NextToken</code> parameter in your results output, then run your request again including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListMedicalScribeJobsRequest$NextToken' => '<p>If your <code>ListMedicalScribeJobs</code> request returns more results than can be displayed, <code>NextToken</code> is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListMedicalScribeJobsResponse$NextToken' => '<p>If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To view the next set of results, copy the string associated with the <code>NextToken</code> parameter in your results output, then run your request again including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListMedicalTranscriptionJobsRequest$NextToken' => '<p>If your <code>ListMedicalTranscriptionJobs</code> request returns more results than can be displayed, <code>NextToken</code> is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListMedicalTranscriptionJobsResponse$NextToken' => '<p>If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To view the next set of results, copy the string associated with the <code>NextToken</code> parameter in your results output, then run your request again including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListMedicalVocabulariesRequest$NextToken' => '<p>If your <code>ListMedicalVocabularies</code> request returns more results than can be displayed, <code>NextToken</code> is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListMedicalVocabulariesResponse$NextToken' => '<p>If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To view the next set of results, copy the string associated with the <code>NextToken</code> parameter in your results output, then run your request again including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListTranscriptionJobsRequest$NextToken' => '<p>If your <code>ListTranscriptionJobs</code> request returns more results than can be displayed, <code>NextToken</code> is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListTranscriptionJobsResponse$NextToken' => '<p>If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To view the next set of results, copy the string associated with the <code>NextToken</code> parameter in your results output, then run your request again including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListVocabulariesRequest$NextToken' => '<p>If your <code>ListVocabularies</code> request returns more results than can be displayed, <code>NextToken</code> is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListVocabulariesResponse$NextToken' => '<p>If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To view the next set of results, copy the string associated with the <code>NextToken</code> parameter in your results output, then run your request again including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListVocabularyFiltersRequest$NextToken' => '<p>If your <code>ListVocabularyFilters</code> request returns more results than can be displayed, <code>NextToken</code> is displayed in the response with an associated string. To get the next page of results, copy this string and repeat your request, including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', 'ListVocabularyFiltersResponse$NextToken' => '<p>If <code>NextToken</code> is present in your response, it indicates that not all results are displayed. To view the next set of results, copy the string associated with the <code>NextToken</code> parameter in your results output, then run your request again including <code>NextToken</code> with the value of the copied string. Repeat as needed to view all your results.</p>', ], ], 'NonEmptyString' => [ 'base' => NULL, 'refs' => [ 'KMSEncryptionContextMap$key' => NULL, 'KMSEncryptionContextMap$value' => NULL, 'StringTargetList$member' => NULL, ], ], 'NonTalkTimeFilter' => [ 'base' => '<p>Flag the presence or absence of periods of silence in your Call Analytics transcription output.</p> <p>Rules using <code>NonTalkTimeFilter</code> are designed to match:</p> <ul> <li> <p>The presence of silence at specified periods throughout the call</p> </li> <li> <p>The presence of speech at specified periods throughout the call</p> </li> </ul> <p>See <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html#tca-rules-batch">Rule criteria for post-call categories</a> for usage examples.</p>', 'refs' => [ 'Rule$NonTalkTimeFilter' => '<p>Flag the presence or absence of periods of silence in your Call Analytics transcription output. Refer to for more detail.</p>', ], ], 'NotFoundException' => [ 'base' => '<p>We can\'t find the requested resource. Check that the specified name is correct and try your request again.</p>', 'refs' => [], ], 'OutputBucketName' => [ 'base' => NULL, 'refs' => [ 'StartMedicalScribeJobRequest$OutputBucketName' => '<p>The name of the Amazon S3 bucket where you want your Medical Scribe output stored. Do not include the <code>S3://</code> prefix of the specified bucket.</p> <p>Note that the role specified in the <code>DataAccessRoleArn</code> request parameter must have permission to use the specified location. You can change Amazon S3 permissions using the <a href="https://console.aws.amazon.com/s3">Amazon Web Services Management Console</a>. See also <a href="https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user">Permissions Required for IAM User Roles</a>.</p>', 'StartMedicalTranscriptionJobRequest$OutputBucketName' => '<p>The name of the Amazon S3 bucket where you want your medical transcription output stored. Do not include the <code>S3://</code> prefix of the specified bucket.</p> <p>If you want your output to go to a sub-folder of this bucket, specify it using the <code>OutputKey</code> parameter; <code>OutputBucketName</code> only accepts the name of a bucket.</p> <p>For example, if you want your output stored in <code>S3://DOC-EXAMPLE-BUCKET</code>, set <code>OutputBucketName</code> to <code>DOC-EXAMPLE-BUCKET</code>. However, if you want your output stored in <code>S3://DOC-EXAMPLE-BUCKET/test-files/</code>, set <code>OutputBucketName</code> to <code>DOC-EXAMPLE-BUCKET</code> and <code>OutputKey</code> to <code>test-files/</code>.</p> <p>Note that Amazon Transcribe must have permission to use the specified location. You can change Amazon S3 permissions using the <a href="https://console.aws.amazon.com/s3">Amazon Web Services Management Console</a>. See also <a href="https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user">Permissions Required for IAM User Roles</a>.</p>', 'StartTranscriptionJobRequest$OutputBucketName' => '<p>The name of the Amazon S3 bucket where you want your transcription output stored. Do not include the <code>S3://</code> prefix of the specified bucket.</p> <p>If you want your output to go to a sub-folder of this bucket, specify it using the <code>OutputKey</code> parameter; <code>OutputBucketName</code> only accepts the name of a bucket.</p> <p>For example, if you want your output stored in <code>S3://DOC-EXAMPLE-BUCKET</code>, set <code>OutputBucketName</code> to <code>DOC-EXAMPLE-BUCKET</code>. However, if you want your output stored in <code>S3://DOC-EXAMPLE-BUCKET/test-files/</code>, set <code>OutputBucketName</code> to <code>DOC-EXAMPLE-BUCKET</code> and <code>OutputKey</code> to <code>test-files/</code>.</p> <p>Note that Amazon Transcribe must have permission to use the specified location. You can change Amazon S3 permissions using the <a href="https://console.aws.amazon.com/s3">Amazon Web Services Management Console</a>. See also <a href="https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user">Permissions Required for IAM User Roles</a>.</p> <p>If you do not specify <code>OutputBucketName</code>, your transcript is placed in a service-managed Amazon S3 bucket and you are provided with a URI to access your transcript.</p>', ], ], 'OutputKey' => [ 'base' => NULL, 'refs' => [ 'StartMedicalTranscriptionJobRequest$OutputKey' => '<p>Use in combination with <code>OutputBucketName</code> to specify the output location of your transcript and, optionally, a unique name for your output file. The default name for your transcription output is the same as the name you specified for your medical transcription job (<code>MedicalTranscriptionJobName</code>).</p> <p>Here are some examples of how you can use <code>OutputKey</code>:</p> <ul> <li> <p>If you specify \'DOC-EXAMPLE-BUCKET\' as the <code>OutputBucketName</code> and \'my-transcript.json\' as the <code>OutputKey</code>, your transcription output path is <code>s3://DOC-EXAMPLE-BUCKET/my-transcript.json</code>.</p> </li> <li> <p>If you specify \'my-first-transcription\' as the <code>MedicalTranscriptionJobName</code>, \'DOC-EXAMPLE-BUCKET\' as the <code>OutputBucketName</code>, and \'my-transcript\' as the <code>OutputKey</code>, your transcription output path is <code>s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json</code>.</p> </li> <li> <p>If you specify \'DOC-EXAMPLE-BUCKET\' as the <code>OutputBucketName</code> and \'test-files/my-transcript.json\' as the <code>OutputKey</code>, your transcription output path is <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json</code>.</p> </li> <li> <p>If you specify \'my-first-transcription\' as the <code>MedicalTranscriptionJobName</code>, \'DOC-EXAMPLE-BUCKET\' as the <code>OutputBucketName</code>, and \'test-files/my-transcript\' as the <code>OutputKey</code>, your transcription output path is <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json</code>.</p> </li> </ul> <p>If you specify the name of an Amazon S3 bucket sub-folder that doesn\'t exist, one is created for you.</p>', 'StartTranscriptionJobRequest$OutputKey' => '<p>Use in combination with <code>OutputBucketName</code> to specify the output location of your transcript and, optionally, a unique name for your output file. The default name for your transcription output is the same as the name you specified for your transcription job (<code>TranscriptionJobName</code>).</p> <p>Here are some examples of how you can use <code>OutputKey</code>:</p> <ul> <li> <p>If you specify \'DOC-EXAMPLE-BUCKET\' as the <code>OutputBucketName</code> and \'my-transcript.json\' as the <code>OutputKey</code>, your transcription output path is <code>s3://DOC-EXAMPLE-BUCKET/my-transcript.json</code>.</p> </li> <li> <p>If you specify \'my-first-transcription\' as the <code>TranscriptionJobName</code>, \'DOC-EXAMPLE-BUCKET\' as the <code>OutputBucketName</code>, and \'my-transcript\' as the <code>OutputKey</code>, your transcription output path is <code>s3://DOC-EXAMPLE-BUCKET/my-transcript/my-first-transcription.json</code>.</p> </li> <li> <p>If you specify \'DOC-EXAMPLE-BUCKET\' as the <code>OutputBucketName</code> and \'test-files/my-transcript.json\' as the <code>OutputKey</code>, your transcription output path is <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript.json</code>.</p> </li> <li> <p>If you specify \'my-first-transcription\' as the <code>TranscriptionJobName</code>, \'DOC-EXAMPLE-BUCKET\' as the <code>OutputBucketName</code>, and \'test-files/my-transcript\' as the <code>OutputKey</code>, your transcription output path is <code>s3://DOC-EXAMPLE-BUCKET/test-files/my-transcript/my-first-transcription.json</code>.</p> </li> </ul> <p>If you specify the name of an Amazon S3 bucket sub-folder that doesn\'t exist, one is created for you.</p>', ], ], 'OutputLocationType' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJobSummary$OutputLocationType' => '<p>Indicates where the specified medical transcription output is stored.</p> <p>If the value is <code>CUSTOMER_BUCKET</code>, the location is the Amazon S3 bucket you specified using the <code>OutputBucketName</code> parameter in your request. If you also included <code>OutputKey</code> in your request, your output is located in the path you specified in your request.</p> <p>If the value is <code>SERVICE_BUCKET</code>, the location is a service-managed Amazon S3 bucket. To access a transcript stored in a service-managed bucket, use the URI shown in the <code>TranscriptFileUri</code> field.</p>', 'TranscriptionJobSummary$OutputLocationType' => '<p>Indicates where the specified transcription output is stored.</p> <p>If the value is <code>CUSTOMER_BUCKET</code>, the location is the Amazon S3 bucket you specified using the <code>OutputBucketName</code> parameter in your request. If you also included <code>OutputKey</code> in your request, your output is located in the path you specified in your request.</p> <p>If the value is <code>SERVICE_BUCKET</code>, the location is a service-managed Amazon S3 bucket. To access a transcript stored in a service-managed bucket, use the URI shown in the <code>TranscriptFileUri</code> or <code>RedactedTranscriptFileUri</code> field.</p>', ], ], 'ParticipantRole' => [ 'base' => NULL, 'refs' => [ 'ChannelDefinition$ParticipantRole' => '<p>Specify the speaker you want to define. Omitting this parameter is equivalent to specifying both participants.</p>', 'InterruptionFilter$ParticipantRole' => '<p>Specify the interrupter that you want to flag. Omitting this parameter is equivalent to specifying both participants.</p>', 'SentimentFilter$ParticipantRole' => '<p>Specify the participant that you want to flag. Omitting this parameter is equivalent to specifying both participants.</p>', 'TranscriptFilter$ParticipantRole' => '<p>Specify the participant that you want to flag. Omitting this parameter is equivalent to specifying both participants.</p>', ], ], 'Percentage' => [ 'base' => NULL, 'refs' => [ 'RelativeTimeRange$StartPercentage' => '<p>The time, in percentage, when Amazon Transcribe starts searching for the specified criteria in your media file. If you include <code>StartPercentage</code> in your request, you must also include <code>EndPercentage</code>.</p>', 'RelativeTimeRange$EndPercentage' => '<p>The time, in percentage, when Amazon Transcribe stops searching for the specified criteria in your media file. If you include <code>EndPercentage</code> in your request, you must also include <code>StartPercentage</code>.</p>', 'RelativeTimeRange$First' => '<p>The time, in percentage, from the start of your media file until the specified value. Amazon Transcribe searches for your specified criteria in this time segment.</p>', 'RelativeTimeRange$Last' => '<p>The time, in percentage, from the specified value until the end of your media file. Amazon Transcribe searches for your specified criteria in this time segment.</p>', ], ], 'Phrase' => [ 'base' => NULL, 'refs' => [ 'Phrases$member' => NULL, ], ], 'Phrases' => [ 'base' => NULL, 'refs' => [ 'CreateVocabularyRequest$Phrases' => '<p>Use this parameter if you want to create your custom vocabulary by including all desired terms, as comma-separated values, within your request. The other option for creating your custom vocabulary is to save your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file using the <code>VocabularyFileUri</code> parameter.</p> <p>Note that if you include <code>Phrases</code> in your request, you cannot use <code>VocabularyFileUri</code>; you must choose one or the other.</p> <p>Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary filter request fails. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a> to get the character set for your language.</p>', 'UpdateVocabularyRequest$Phrases' => '<p>Use this parameter if you want to update your custom vocabulary by including all desired terms, as comma-separated values, within your request. The other option for updating your custom vocabulary is to save your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file using the <code>VocabularyFileUri</code> parameter.</p> <p>Note that if you include <code>Phrases</code> in your request, you cannot use <code>VocabularyFileUri</code>; you must choose one or the other.</p> <p>Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary filter request fails. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a> to get the character set for your language.</p>', ], ], 'PiiEntityType' => [ 'base' => NULL, 'refs' => [ 'PiiEntityTypes$member' => NULL, ], ], 'PiiEntityTypes' => [ 'base' => NULL, 'refs' => [ 'ContentRedaction$PiiEntityTypes' => '<p>Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you\'d like, or you can select <code>ALL</code>. If you do not include <code>PiiEntityTypes</code> in your request, all PII is redacted.</p>', ], ], 'RedactionOutput' => [ 'base' => NULL, 'refs' => [ 'ContentRedaction$RedactionOutput' => '<p>Specify if you want only a redacted transcript, or if you want a redacted and an unredacted transcript.</p> <p>When you choose <code>redacted</code> Amazon Transcribe creates only a redacted transcript.</p> <p>When you choose <code>redacted_and_unredacted</code> Amazon Transcribe creates a redacted and an unredacted transcript (as two separate files).</p>', ], ], 'RedactionType' => [ 'base' => NULL, 'refs' => [ 'ContentRedaction$RedactionType' => '<p>Specify the category of information you want to redact; <code>PII</code> (personally identifiable information) is the only valid value. You can use <code>PiiEntityTypes</code> to choose which types of PII you want to redact. If you do not include <code>PiiEntityTypes</code> in your request, all PII is redacted.</p>', ], ], 'RelativeTimeRange' => [ 'base' => '<p>A time range, in percentage, between two points in your media file.</p> <p>You can use <code>StartPercentage</code> and <code>EndPercentage</code> to search a custom segment. For example, setting <code>StartPercentage</code> to 10 and <code>EndPercentage</code> to 50 only searches for your specified criteria in the audio contained between the 10 percent mark and the 50 percent mark of your media file.</p> <p>You can use also <code>First</code> to search from the start of the media file until the time that you specify. Or use <code>Last</code> to search from the time that you specify until the end of the media file. For example, setting <code>First</code> to 10 only searches for your specified criteria in the audio contained in the first 10 percent of the media file.</p> <p>If you prefer to use milliseconds instead of percentage, see .</p>', 'refs' => [ 'InterruptionFilter$RelativeTimeRange' => '<p>Makes it possible to specify a time range (in percentage) in your media file, during which you want to search for an interruption. See for more detail.</p>', 'NonTalkTimeFilter$RelativeTimeRange' => '<p>Makes it possible to specify a time range (in percentage) in your media file, during which you want to search for a period of silence. See for more detail.</p>', 'SentimentFilter$RelativeTimeRange' => '<p>Makes it possible to specify a time range (in percentage) in your media file, during which you want to search for the specified sentiments. See for more detail.</p>', 'TranscriptFilter$RelativeTimeRange' => '<p>Makes it possible to specify a time range (in percentage) in your media file, during which you want to search for the specified key words or phrases. See for more detail.</p>', ], ], 'Rule' => [ 'base' => '<p>A rule is a set of criteria that you can specify to flag an attribute in your Call Analytics output. Rules define a Call Analytics category.</p> <p>Rules can include these parameters: , , , and .</p> <p>To learn more about Call Analytics rules and categories, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html">Creating categories for post-call transcriptions</a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html">Creating categories for real-time transcriptions</a>.</p> <p>To learn more about Call Analytics, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/call-analytics.html">Analyzing call center audio with Call Analytics</a>.</p>', 'refs' => [ 'RuleList$member' => NULL, ], ], 'RuleList' => [ 'base' => NULL, 'refs' => [ 'CategoryProperties$Rules' => '<p>The rules used to define a Call Analytics category. Each category can have between 1 and 20 rules.</p>', 'CreateCallAnalyticsCategoryRequest$Rules' => '<p>Rules define a Call Analytics category. When creating a new category, you must create between 1 and 20 rules for that category. For each rule, you specify a filter you want applied to the attributes of a call. For example, you can choose a sentiment filter that detects if a customer\'s sentiment was positive during the last 30 seconds of the call.</p>', 'UpdateCallAnalyticsCategoryRequest$Rules' => '<p>The rules used for the updated Call Analytics category. The rules you provide in this field replace the ones that are currently being used in the specified category.</p>', ], ], 'SentimentFilter' => [ 'base' => '<p>Flag the presence or absence of specific sentiments detected in your Call Analytics transcription output.</p> <p>Rules using <code>SentimentFilter</code> are designed to match:</p> <ul> <li> <p>The presence or absence of a positive sentiment felt by the customer, agent, or both at specified points in the call</p> </li> <li> <p>The presence or absence of a negative sentiment felt by the customer, agent, or both at specified points in the call</p> </li> <li> <p>The presence or absence of a neutral sentiment felt by the customer, agent, or both at specified points in the call</p> </li> <li> <p>The presence or absence of a mixed sentiment felt by the customer, the agent, or both at specified points in the call</p> </li> </ul> <p>See <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html#tca-rules-batch">Rule criteria for post-call categories</a> for usage examples.</p>', 'refs' => [ 'Rule$SentimentFilter' => '<p>Flag the presence or absence of specific sentiments in your Call Analytics transcription output. Refer to for more detail.</p>', ], ], 'SentimentValue' => [ 'base' => NULL, 'refs' => [ 'SentimentValueList$member' => NULL, ], ], 'SentimentValueList' => [ 'base' => NULL, 'refs' => [ 'SentimentFilter$Sentiments' => '<p>Specify the sentiments that you want to flag.</p>', ], ], 'Settings' => [ 'base' => '<p>Allows additional optional settings in your request, including channel identification, alternative transcriptions, and speaker partitioning. You can use that to apply custom vocabularies to your transcription job.</p>', 'refs' => [ 'StartTranscriptionJobRequest$Settings' => '<p>Specify additional optional settings in your request, including channel identification, alternative transcriptions, speaker partitioning. You can use that to apply custom vocabularies and vocabulary filters.</p> <p>If you want to include a custom vocabulary or a custom vocabulary filter (or both) with your request but <b>do not</b> want to use automatic language identification, use <code>Settings</code> with the <code>VocabularyName</code> or <code>VocabularyFilterName</code> (or both) sub-parameter.</p> <p>If you\'re using automatic language identification with your request and want to include a custom language model, a custom vocabulary, or a custom vocabulary filter, use instead the <code/> parameter with the <code>LanguageModelName</code>, <code>VocabularyName</code> or <code>VocabularyFilterName</code> sub-parameters.</p>', 'TranscriptionJob$Settings' => '<p>Provides information on any additional settings that were included in your request. Additional settings include channel identification, alternative transcriptions, speaker partitioning, custom vocabularies, and custom vocabulary filters.</p>', ], ], 'Specialty' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJob$Specialty' => '<p>Describes the medical specialty represented in your media.</p>', 'MedicalTranscriptionJobSummary$Specialty' => '<p>Provides the medical specialty represented in your media.</p>', 'StartMedicalTranscriptionJobRequest$Specialty' => '<p>Specify the predominant medical specialty represented in your media. For batch transcriptions, <code>PRIMARYCARE</code> is the only valid value. If you require additional specialties, refer to .</p>', ], ], 'StartCallAnalyticsJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartCallAnalyticsJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartMedicalScribeJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMedicalScribeJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartMedicalTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartMedicalTranscriptionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'StartTranscriptionJobRequest' => [ 'base' => NULL, 'refs' => [], ], 'StartTranscriptionJobResponse' => [ 'base' => NULL, 'refs' => [], ], 'String' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsSkippedFeature$Message' => '<p>Contains additional information or a message explaining why a specific analytics feature was skipped during the analysis of a call analytics job.</p>', 'ConflictException$Message' => NULL, 'InternalFailureException$Message' => NULL, 'LimitExceededException$Message' => NULL, 'NotFoundException$Message' => NULL, ], ], 'StringTargetList' => [ 'base' => NULL, 'refs' => [ 'TranscriptFilter$Targets' => '<p>Specify the phrases that you want to flag.</p>', ], ], 'SubtitleFileUris' => [ 'base' => NULL, 'refs' => [ 'SubtitlesOutput$SubtitleFileUris' => '<p>The Amazon S3 location of your transcript. You can use this URI to access or download your subtitle file. Your subtitle file is stored in the same location as your transcript. If you specified both WebVTT and SubRip subtitle formats, two URIs are provided.</p> <p>If you included <code>OutputBucketName</code> in your transcription job request, this is the URI of that bucket. If you also included <code>OutputKey</code> in your request, your output is located in the path you specified in your request.</p> <p>If you didn\'t include <code>OutputBucketName</code> in your transcription job request, your subtitle file is stored in a service-managed bucket, and <code>TranscriptFileUri</code> provides you with a temporary URI you can use for secure access to your subtitle file.</p> <note> <p>Temporary URIs for service-managed Amazon S3 buckets are only valid for 15 minutes. If you get an <code>AccesDenied</code> error, you can get a new temporary URI by running a <code>GetTranscriptionJob</code> or <code>ListTranscriptionJob</code> request.</p> </note>', ], ], 'SubtitleFormat' => [ 'base' => NULL, 'refs' => [ 'SubtitleFormats$member' => NULL, ], ], 'SubtitleFormats' => [ 'base' => NULL, 'refs' => [ 'Subtitles$Formats' => '<p>Specify the output format for your subtitle file; if you select both WebVTT (<code>vtt</code>) and SubRip (<code>srt</code>) formats, two output files are generated.</p>', 'SubtitlesOutput$Formats' => '<p>Provides the format of your subtitle files. If your request included both WebVTT (<code>vtt</code>) and SubRip (<code>srt</code>) formats, both formats are shown.</p>', ], ], 'SubtitleOutputStartIndex' => [ 'base' => NULL, 'refs' => [ 'Subtitles$OutputStartIndex' => '<p>Specify the starting value that is assigned to the first subtitle segment.</p> <p>The default start index for Amazon Transcribe is <code>0</code>, which differs from the more widely used standard of <code>1</code>. If you\'re uncertain which value to use, we recommend choosing <code>1</code>, as this may improve compatibility with other services.</p>', 'SubtitlesOutput$OutputStartIndex' => '<p>Provides the start index value for your subtitle files. If you did not specify a value in your request, the default value of <code>0</code> is used.</p>', ], ], 'Subtitles' => [ 'base' => '<p>Generate subtitles for your media file with your transcription request.</p> <p>You can choose a start index of 0 or 1, and you can specify either WebVTT or SubRip (or both) as your output format.</p> <p>Note that your subtitle files are placed in the same location as your transcription output.</p>', 'refs' => [ 'StartTranscriptionJobRequest$Subtitles' => '<p>Produces subtitle files for your input media. You can specify WebVTT (*.vtt) and SubRip (*.srt) formats.</p>', ], ], 'SubtitlesOutput' => [ 'base' => '<p>Provides information about your subtitle file, including format, start index, and Amazon S3 location.</p>', 'refs' => [ 'TranscriptionJob$Subtitles' => '<p>Indicates whether subtitles were generated with your transcription.</p>', ], ], 'Summarization' => [ 'base' => '<p>Contains <code>GenerateAbstractiveSummary</code>, which is a required parameter if you want to enable Generative call summarization in your Call Analytics request.</p>', 'refs' => [ 'CallAnalyticsJobSettings$Summarization' => '<p>Contains <code>GenerateAbstractiveSummary</code>, which is a required parameter if you want to enable Generative call summarization in your Call Analytics request.</p>', ], ], 'Tag' => [ 'base' => '<p>Adds metadata, in the form of a key:value pair, to the specified resource.</p> <p>For example, you could add the tag <code>Department:Sales</code> to a resource to indicate that it pertains to your organization\'s sales department. You can also use tags for tag-based access control.</p> <p>To learn more about tagging, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.</p>', 'refs' => [ 'TagList$member' => NULL, ], ], 'TagKey' => [ 'base' => NULL, 'refs' => [ 'Tag$Key' => '<p>The first part of a key:value pair that forms a tag associated with a given resource. For example, in the tag <code>Department:Sales</code>, the key is \'Department\'.</p>', 'TagKeyList$member' => NULL, ], ], 'TagKeyList' => [ 'base' => NULL, 'refs' => [ 'UntagResourceRequest$TagKeys' => '<p>Removes the specified tag keys from the specified Amazon Transcribe resource.</p>', ], ], 'TagList' => [ 'base' => NULL, 'refs' => [ 'CreateLanguageModelRequest$Tags' => '<p>Adds one or more custom tags, each in the form of a key:value pair, to a new custom language model at the time you create this new model.</p> <p>To learn more about using tags with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.</p>', 'CreateMedicalVocabularyRequest$Tags' => '<p>Adds one or more custom tags, each in the form of a key:value pair, to a new custom medical vocabulary at the time you create this new custom vocabulary.</p> <p>To learn more about using tags with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.</p>', 'CreateVocabularyFilterRequest$Tags' => '<p>Adds one or more custom tags, each in the form of a key:value pair, to a new custom vocabulary filter at the time you create this new vocabulary filter.</p> <p>To learn more about using tags with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.</p>', 'CreateVocabularyRequest$Tags' => '<p>Adds one or more custom tags, each in the form of a key:value pair, to a new custom vocabulary at the time you create this new custom vocabulary.</p> <p>To learn more about using tags with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.</p>', 'ListTagsForResourceResponse$Tags' => '<p>Lists all tags associated with the given transcription job, vocabulary, model, or resource.</p>', 'MedicalScribeJob$Tags' => '<p>Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.</p> <p>To learn more about using tags with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.</p>', 'MedicalTranscriptionJob$Tags' => '<p>The tags, each in the form of a key:value pair, assigned to the specified medical transcription job.</p>', 'StartMedicalScribeJobRequest$Tags' => '<p>Adds one or more custom tags, each in the form of a key:value pair, to the Medica Scribe job.</p> <p>To learn more about using tags with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.</p>', 'StartMedicalTranscriptionJobRequest$Tags' => '<p>Adds one or more custom tags, each in the form of a key:value pair, to a new medical transcription job at the time you start this new job.</p> <p>To learn more about using tags with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.</p>', 'StartTranscriptionJobRequest$Tags' => '<p>Adds one or more custom tags, each in the form of a key:value pair, to a new transcription job at the time you start this new job.</p> <p>To learn more about using tags with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.</p>', 'TagResourceRequest$Tags' => '<p>Adds one or more custom tags, each in the form of a key:value pair, to the specified resource.</p> <p>To learn more about using tags with Amazon Transcribe, refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html">Tagging resources</a>.</p>', 'TranscriptionJob$Tags' => '<p>The tags, each in the form of a key:value pair, assigned to the specified transcription job.</p>', ], ], 'TagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'TagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'TagValue' => [ 'base' => NULL, 'refs' => [ 'Tag$Value' => '<p>The second part of a key:value pair that forms a tag associated with a given resource. For example, in the tag <code>Department:Sales</code>, the value is \'Sales\'.</p> <p>Note that you can set the value of a tag to an empty string, but you can\'t set the value of a tag to null. Omitting the tag value is the same as using an empty string.</p>', ], ], 'TimestampMilliseconds' => [ 'base' => NULL, 'refs' => [ 'AbsoluteTimeRange$StartTime' => '<p>The time, in milliseconds, when Amazon Transcribe starts searching for the specified criteria in your audio. If you include <code>StartTime</code> in your request, you must also include <code>EndTime</code>.</p>', 'AbsoluteTimeRange$EndTime' => '<p>The time, in milliseconds, when Amazon Transcribe stops searching for the specified criteria in your audio. If you include <code>EndTime</code> in your request, you must also include <code>StartTime</code>.</p>', 'AbsoluteTimeRange$First' => '<p>The time, in milliseconds, from the start of your media file until the specified value. Amazon Transcribe searches for your specified criteria in this time segment.</p>', 'AbsoluteTimeRange$Last' => '<p>The time, in milliseconds, from the specified value until the end of your media file. Amazon Transcribe searches for your specified criteria in this time segment.</p>', 'InterruptionFilter$Threshold' => '<p>Specify the duration of the interruptions in milliseconds. For example, you can flag speech that contains more than 10,000 milliseconds of interruptions.</p>', 'NonTalkTimeFilter$Threshold' => '<p>Specify the duration, in milliseconds, of the period of silence that you want to flag. For example, you can flag a silent period that lasts 30,000 milliseconds.</p>', ], ], 'ToxicityCategories' => [ 'base' => NULL, 'refs' => [ 'ToxicityDetectionSettings$ToxicityCategories' => '<p> If you include <code>ToxicityDetection</code> in your transcription request, you must also include <code>ToxicityCategories</code>. The only accepted value for this parameter is <code>ALL</code>.</p>', ], ], 'ToxicityCategory' => [ 'base' => NULL, 'refs' => [ 'ToxicityCategories$member' => NULL, ], ], 'ToxicityDetection' => [ 'base' => NULL, 'refs' => [ 'StartTranscriptionJobRequest$ToxicityDetection' => '<p>Enables toxic speech detection in your transcript. If you include <code>ToxicityDetection</code> in your request, you must also include <code>ToxicityCategories</code>.</p> <p>For information on the types of toxic speech Amazon Transcribe can detect, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/toxic-language.html">Detecting toxic speech</a>.</p>', 'TranscriptionJob$ToxicityDetection' => '<p>Provides information about the toxicity detection settings applied to your transcription.</p>', 'TranscriptionJobSummary$ToxicityDetection' => '<p>Indicates whether toxicity detection was enabled for the specified transcription job.</p>', ], ], 'ToxicityDetectionSettings' => [ 'base' => '<p>Contains <code>ToxicityCategories</code>, which is a required parameter if you want to enable toxicity detection (<code>ToxicityDetection</code>) in your transcription request.</p>', 'refs' => [ 'ToxicityDetection$member' => NULL, ], ], 'TranscribeArn' => [ 'base' => NULL, 'refs' => [ 'ListTagsForResourceRequest$ResourceArn' => '<p>Returns a list of all tags associated with the specified Amazon Resource Name (ARN). ARNs have the format <code>arn:partition:service:region:account-id:resource-type/resource-id</code>.</p> <p>For example, <code>arn:aws:transcribe:us-west-2:111122223333:transcription-job/transcription-job-name</code>.</p> <p>Valid values for <code>resource-type</code> are: <code>transcription-job</code>, <code>medical-transcription-job</code>, <code>vocabulary</code>, <code>medical-vocabulary</code>, <code>vocabulary-filter</code>, and <code>language-model</code>.</p>', 'ListTagsForResourceResponse$ResourceArn' => '<p>The Amazon Resource Name (ARN) specified in your request.</p>', 'TagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the resource you want to tag. ARNs have the format <code>arn:partition:service:region:account-id:resource-type/resource-id</code>.</p> <p>For example, <code>arn:aws:transcribe:us-west-2:111122223333:transcription-job/transcription-job-name</code>.</p> <p>Valid values for <code>resource-type</code> are: <code>transcription-job</code>, <code>medical-transcription-job</code>, <code>vocabulary</code>, <code>medical-vocabulary</code>, <code>vocabulary-filter</code>, and <code>language-model</code>.</p>', 'UntagResourceRequest$ResourceArn' => '<p>The Amazon Resource Name (ARN) of the Amazon Transcribe resource you want to remove tags from. ARNs have the format <code>arn:partition:service:region:account-id:resource-type/resource-id</code>.</p> <p>For example, <code>arn:aws:transcribe:us-west-2:111122223333:transcription-job/transcription-job-name</code>.</p> <p>Valid values for <code>resource-type</code> are: <code>transcription-job</code>, <code>medical-transcription-job</code>, <code>vocabulary</code>, <code>medical-vocabulary</code>, <code>vocabulary-filter</code>, and <code>language-model</code>.</p>', ], ], 'Transcript' => [ 'base' => '<p>Provides you with the Amazon S3 URI you can use to access your transcript.</p>', 'refs' => [ 'CallAnalyticsJob$Transcript' => NULL, 'TranscriptionJob$Transcript' => '<p>Provides you with the Amazon S3 URI you can use to access your transcript.</p>', ], ], 'TranscriptFilter' => [ 'base' => '<p>Flag the presence or absence of specific words or phrases detected in your Call Analytics transcription output.</p> <p>Rules using <code>TranscriptFilter</code> are designed to match:</p> <ul> <li> <p>Custom words or phrases spoken by the agent, the customer, or both</p> </li> <li> <p>Custom words or phrases <b>not</b> spoken by the agent, the customer, or either</p> </li> <li> <p>Custom words or phrases that occur at a specific time frame</p> </li> </ul> <p>See <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-batch.html#tca-rules-batch">Rule criteria for post-call categories</a> and <a href="https://docs.aws.amazon.com/transcribe/latest/dg/tca-categories-stream.html#tca-rules-stream">Rule criteria for streaming categories</a> for usage examples.</p>', 'refs' => [ 'Rule$TranscriptFilter' => '<p>Flag the presence or absence of specific words or phrases in your Call Analytics transcription output. Refer to for more detail.</p>', ], ], 'TranscriptFilterType' => [ 'base' => NULL, 'refs' => [ 'TranscriptFilter$TranscriptFilterType' => '<p>Flag the presence or absence of an exact match to the phrases that you specify. For example, if you specify the phrase "speak to a manager" as your <code>Targets</code> value, only that exact phrase is flagged.</p> <p>Note that semantic matching is not supported. For example, if your customer says "speak to <i>the</i> manager", instead of "speak to <i>a</i> manager", your content is not flagged.</p>', ], ], 'TranscriptionJob' => [ 'base' => '<p>Provides detailed information about a transcription job.</p> <p>To view the status of the specified transcription job, check the <code>TranscriptionJobStatus</code> field. If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your transcription job failed.</p> <p>If you enabled content redaction, the redacted transcript can be found at the location specified in <code>RedactedTranscriptFileUri</code>.</p>', 'refs' => [ 'GetTranscriptionJobResponse$TranscriptionJob' => '<p>Provides detailed information about the specified transcription job, including job status and, if applicable, failure reason.</p>', 'StartTranscriptionJobResponse$TranscriptionJob' => '<p>Provides detailed information about the current transcription job, including job status and, if applicable, failure reason.</p>', ], ], 'TranscriptionJobName' => [ 'base' => NULL, 'refs' => [ 'DeleteMedicalScribeJobRequest$MedicalScribeJobName' => '<p>The name of the Medical Scribe job you want to delete. Job names are case sensitive.</p>', 'DeleteMedicalTranscriptionJobRequest$MedicalTranscriptionJobName' => '<p>The name of the medical transcription job you want to delete. Job names are case sensitive.</p>', 'DeleteTranscriptionJobRequest$TranscriptionJobName' => '<p>The name of the transcription job you want to delete. Job names are case sensitive.</p>', 'GetMedicalScribeJobRequest$MedicalScribeJobName' => '<p>The name of the Medical Scribe job you want information about. Job names are case sensitive.</p>', 'GetMedicalTranscriptionJobRequest$MedicalTranscriptionJobName' => '<p>The name of the medical transcription job you want information about. Job names are case sensitive.</p>', 'GetTranscriptionJobRequest$TranscriptionJobName' => '<p>The name of the transcription job you want information about. Job names are case sensitive.</p>', 'ListMedicalScribeJobsRequest$JobNameContains' => '<p>Returns only the Medical Scribe jobs that contain the specified string. The search is not case sensitive.</p>', 'ListMedicalTranscriptionJobsRequest$JobNameContains' => '<p>Returns only the medical transcription jobs that contain the specified string. The search is not case sensitive.</p>', 'ListTranscriptionJobsRequest$JobNameContains' => '<p>Returns only the transcription jobs that contain the specified string. The search is not case sensitive.</p>', 'MedicalScribeJob$MedicalScribeJobName' => '<p>The name of the Medical Scribe job. Job names are case sensitive and must be unique within an Amazon Web Services account.</p>', 'MedicalScribeJobSummary$MedicalScribeJobName' => '<p>The name of the Medical Scribe job. Job names are case sensitive and must be unique within an Amazon Web Services account.</p>', 'MedicalTranscriptionJob$MedicalTranscriptionJobName' => '<p>The name of the medical transcription job. Job names are case sensitive and must be unique within an Amazon Web Services account.</p>', 'MedicalTranscriptionJobSummary$MedicalTranscriptionJobName' => '<p>The name of the medical transcription job. Job names are case sensitive and must be unique within an Amazon Web Services account.</p>', 'StartMedicalScribeJobRequest$MedicalScribeJobName' => '<p>A unique name, chosen by you, for your Medical Scribe job.</p> <p>This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new job with the same name as an existing job, you get a <code>ConflictException</code> error.</p>', 'StartMedicalTranscriptionJobRequest$MedicalTranscriptionJobName' => '<p>A unique name, chosen by you, for your medical transcription job. The name that you specify is also used as the default name of your transcription output file. If you want to specify a different name for your transcription output, use the <code>OutputKey</code> parameter.</p> <p>This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new job with the same name as an existing job, you get a <code>ConflictException</code> error.</p>', 'StartTranscriptionJobRequest$TranscriptionJobName' => '<p>A unique name, chosen by you, for your transcription job. The name that you specify is also used as the default name of your transcription output file. If you want to specify a different name for your transcription output, use the <code>OutputKey</code> parameter.</p> <p>This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new job with the same name as an existing job, you get a <code>ConflictException</code> error.</p>', 'TranscriptionJob$TranscriptionJobName' => '<p>The name of the transcription job. Job names are case sensitive and must be unique within an Amazon Web Services account.</p>', 'TranscriptionJobSummary$TranscriptionJobName' => '<p>The name of the transcription job. Job names are case sensitive and must be unique within an Amazon Web Services account.</p>', ], ], 'TranscriptionJobStatus' => [ 'base' => NULL, 'refs' => [ 'ListMedicalTranscriptionJobsRequest$Status' => '<p>Returns only medical transcription jobs with the specified status. Jobs are ordered by creation date, with the newest job first. If you do not include <code>Status</code>, all medical transcription jobs are returned.</p>', 'ListMedicalTranscriptionJobsResponse$Status' => '<p>Lists all medical transcription jobs that have the status specified in your request. Jobs are ordered by creation date, with the newest job first.</p>', 'ListTranscriptionJobsRequest$Status' => '<p>Returns only transcription jobs with the specified status. Jobs are ordered by creation date, with the newest job first. If you do not include <code>Status</code>, all transcription jobs are returned.</p>', 'ListTranscriptionJobsResponse$Status' => '<p>Lists all transcription jobs that have the status specified in your request. Jobs are ordered by creation date, with the newest job first.</p>', 'MedicalTranscriptionJob$TranscriptionJobStatus' => '<p>Provides the status of the specified medical transcription job.</p> <p>If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your transcription job failed.</p>', 'MedicalTranscriptionJobSummary$TranscriptionJobStatus' => '<p>Provides the status of your medical transcription job.</p> <p>If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in <code>TranscriptFileUri</code>. If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your transcription job failed.</p>', 'TranscriptionJob$TranscriptionJobStatus' => '<p>Provides the status of the specified transcription job.</p> <p>If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in <code>TranscriptFileUri</code> (or <code>RedactedTranscriptFileUri</code>, if you requested transcript redaction). If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your transcription job failed.</p>', 'TranscriptionJobSummary$TranscriptionJobStatus' => '<p>Provides the status of your transcription job.</p> <p>If the status is <code>COMPLETED</code>, the job is finished and you can find the results at the location specified in <code>TranscriptFileUri</code> (or <code>RedactedTranscriptFileUri</code>, if you requested transcript redaction). If the status is <code>FAILED</code>, <code>FailureReason</code> provides details on why your transcription job failed.</p>', ], ], 'TranscriptionJobSummaries' => [ 'base' => NULL, 'refs' => [ 'ListTranscriptionJobsResponse$TranscriptionJobSummaries' => '<p>Provides a summary of information about each result.</p>', ], ], 'TranscriptionJobSummary' => [ 'base' => '<p>Provides detailed information about a specific transcription job.</p>', 'refs' => [ 'TranscriptionJobSummaries$member' => NULL, ], ], 'Type' => [ 'base' => NULL, 'refs' => [ 'MedicalTranscriptionJob$Type' => '<p>Indicates whether the input media is a dictation or a conversation, as specified in the <code>StartMedicalTranscriptionJob</code> request.</p>', 'MedicalTranscriptionJobSummary$Type' => '<p>Indicates whether the input media is a dictation or a conversation, as specified in the <code>StartMedicalTranscriptionJob</code> request.</p>', 'StartMedicalTranscriptionJobRequest$Type' => '<p>Specify whether your input media contains only one person (<code>DICTATION</code>) or contains a conversation between two people (<code>CONVERSATION</code>).</p> <p>For example, <code>DICTATION</code> could be used for a medical professional wanting to transcribe voice memos; <code>CONVERSATION</code> could be used for transcribing the doctor-patient dialogue during the patient\'s office visit.</p>', ], ], 'UntagResourceRequest' => [ 'base' => NULL, 'refs' => [], ], 'UntagResourceResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCallAnalyticsCategoryRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateCallAnalyticsCategoryResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMedicalVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateMedicalVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVocabularyFilterRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVocabularyFilterResponse' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVocabularyRequest' => [ 'base' => NULL, 'refs' => [], ], 'UpdateVocabularyResponse' => [ 'base' => NULL, 'refs' => [], ], 'Uri' => [ 'base' => NULL, 'refs' => [ 'CreateMedicalVocabularyRequest$VocabularyFileUri' => '<p>The Amazon S3 location (URI) of the text file that contains your custom medical vocabulary. The URI must be in the same Amazon Web Services Region as the resource you\'re calling.</p> <p>Here\'s an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt</code> </p>', 'CreateVocabularyFilterRequest$VocabularyFilterFileUri' => '<p>The Amazon S3 location of the text file that contains your custom vocabulary filter terms. The URI must be located in the same Amazon Web Services Region as the resource you\'re calling.</p> <p>Here\'s an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt</code> </p> <p>Note that if you include <code>VocabularyFilterFileUri</code> in your request, you cannot use <code>Words</code>; you must choose one or the other.</p>', 'CreateVocabularyRequest$VocabularyFileUri' => '<p>The Amazon S3 location of the text file that contains your custom vocabulary. The URI must be located in the same Amazon Web Services Region as the resource you\'re calling.</p> <p>Here\'s an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt</code> </p> <p>Note that if you include <code>VocabularyFileUri</code> in your request, you cannot use the <code>Phrases</code> flag; you must choose one or the other.</p>', 'GetMedicalVocabularyResponse$DownloadUri' => '<p>The Amazon S3 location where the specified custom medical vocabulary is stored; use this URI to view or download the custom vocabulary.</p>', 'GetVocabularyFilterResponse$DownloadUri' => '<p>The Amazon S3 location where the custom vocabulary filter is stored; use this URI to view or download the custom vocabulary filter.</p>', 'GetVocabularyResponse$DownloadUri' => '<p>The Amazon S3 location where the custom vocabulary is stored; use this URI to view or download the custom vocabulary.</p>', 'InputDataConfig$S3Uri' => '<p>The Amazon S3 location (URI) of the text files you want to use to train your custom language model.</p> <p>Here\'s an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-model-training-data/</code> </p>', 'InputDataConfig$TuningDataS3Uri' => '<p>The Amazon S3 location (URI) of the text files you want to use to tune your custom language model.</p> <p>Here\'s an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-model-tuning-data/</code> </p>', 'Media$MediaFileUri' => '<p>The Amazon S3 location of the media file you want to transcribe. For example:</p> <ul> <li> <p> <code>s3://DOC-EXAMPLE-BUCKET/my-media-file.flac</code> </p> </li> <li> <p> <code>s3://DOC-EXAMPLE-BUCKET/media-files/my-media-file.flac</code> </p> </li> </ul> <p>Note that the Amazon S3 bucket that contains your input media must be located in the same Amazon Web Services Region where you\'re making your transcription request.</p>', 'Media$RedactedMediaFileUri' => '<p>The Amazon S3 location of the media file you want to redact. For example:</p> <ul> <li> <p> <code>s3://DOC-EXAMPLE-BUCKET/my-media-file.flac</code> </p> </li> <li> <p> <code>s3://DOC-EXAMPLE-BUCKET/media-files/my-media-file.flac</code> </p> </li> </ul> <p>Note that the Amazon S3 bucket that contains your input media must be located in the same Amazon Web Services Region where you\'re making your transcription request.</p> <important> <p> <code>RedactedMediaFileUri</code> produces a redacted audio file in addition to a redacted transcript. It is only supported for Call Analytics (<code>StartCallAnalyticsJob</code>) transcription requests.</p> </important>', 'MedicalScribeOutput$TranscriptFileUri' => '<p>Holds the Amazon S3 URI for the Transcript.</p>', 'MedicalScribeOutput$ClinicalDocumentUri' => '<p>Holds the Amazon S3 URI for the Clinical Document.</p>', 'MedicalTranscript$TranscriptFileUri' => '<p>The Amazon S3 location of your transcript. You can use this URI to access or download your transcript.</p> <p>Note that this is the Amazon S3 location you specified in your request using the <code>OutputBucketName</code> parameter.</p>', 'StartCallAnalyticsJobRequest$OutputLocation' => '<p>The Amazon S3 location where you want your Call Analytics transcription output stored. You can use any of the following formats to specify the output location:</p> <ol> <li> <p>s3://DOC-EXAMPLE-BUCKET</p> </li> <li> <p>s3://DOC-EXAMPLE-BUCKET/my-output-folder/</p> </li> <li> <p>s3://DOC-EXAMPLE-BUCKET/my-output-folder/my-call-analytics-job.json</p> </li> </ol> <p>Unless you specify a file name (option 3), the name of your output file has a default value that matches the name you specified for your transcription job using the <code>CallAnalyticsJobName</code> parameter.</p> <p>You can specify a KMS key to encrypt your output using the <code>OutputEncryptionKMSKeyId</code> parameter. If you do not specify a KMS key, Amazon Transcribe uses the default Amazon S3 key for server-side encryption.</p> <p>If you do not specify <code>OutputLocation</code>, your transcript is placed in a service-managed Amazon S3 bucket and you are provided with a URI to access your transcript.</p>', 'SubtitleFileUris$member' => NULL, 'Transcript$TranscriptFileUri' => '<p>The Amazon S3 location of your transcript. You can use this URI to access or download your transcript.</p> <p>If you included <code>OutputBucketName</code> in your transcription job request, this is the URI of that bucket. If you also included <code>OutputKey</code> in your request, your output is located in the path you specified in your request.</p> <p>If you didn\'t include <code>OutputBucketName</code> in your transcription job request, your transcript is stored in a service-managed bucket, and <code>TranscriptFileUri</code> provides you with a temporary URI you can use for secure access to your transcript.</p> <note> <p>Temporary URIs for service-managed Amazon S3 buckets are only valid for 15 minutes. If you get an <code>AccesDenied</code> error, you can get a new temporary URI by running a <code>GetTranscriptionJob</code> or <code>ListTranscriptionJob</code> request.</p> </note>', 'Transcript$RedactedTranscriptFileUri' => '<p>The Amazon S3 location of your redacted transcript. You can use this URI to access or download your transcript.</p> <p>If you included <code>OutputBucketName</code> in your transcription job request, this is the URI of that bucket. If you also included <code>OutputKey</code> in your request, your output is located in the path you specified in your request.</p> <p>If you didn\'t include <code>OutputBucketName</code> in your transcription job request, your transcript is stored in a service-managed bucket, and <code>RedactedTranscriptFileUri</code> provides you with a temporary URI you can use for secure access to your transcript.</p> <note> <p>Temporary URIs for service-managed Amazon S3 buckets are only valid for 15 minutes. If you get an <code>AccesDenied</code> error, you can get a new temporary URI by running a <code>GetTranscriptionJob</code> or <code>ListTranscriptionJob</code> request.</p> </note>', 'UpdateMedicalVocabularyRequest$VocabularyFileUri' => '<p>The Amazon S3 location of the text file that contains your custom medical vocabulary. The URI must be located in the same Amazon Web Services Region as the resource you\'re calling.</p> <p>Here\'s an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt</code> </p>', 'UpdateVocabularyFilterRequest$VocabularyFilterFileUri' => '<p>The Amazon S3 location of the text file that contains your custom vocabulary filter terms. The URI must be located in the same Amazon Web Services Region as the resource you\'re calling.</p> <p>Here\'s an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-vocab-filter-file.txt</code> </p> <p>Note that if you include <code>VocabularyFilterFileUri</code> in your request, you cannot use <code>Words</code>; you must choose one or the other.</p>', 'UpdateVocabularyRequest$VocabularyFileUri' => '<p>The Amazon S3 location of the text file that contains your custom vocabulary. The URI must be located in the same Amazon Web Services Region as the resource you\'re calling.</p> <p>Here\'s an example URI path: <code>s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt</code> </p> <p>Note that if you include <code>VocabularyFileUri</code> in your request, you cannot use the <code>Phrases</code> flag; you must choose one or the other.</p>', ], ], 'Vocabularies' => [ 'base' => NULL, 'refs' => [ 'ListMedicalVocabulariesResponse$Vocabularies' => '<p>Provides information about the custom medical vocabularies that match the criteria specified in your request.</p>', 'ListVocabulariesResponse$Vocabularies' => '<p>Provides information about the custom vocabularies that match the criteria specified in your request.</p>', ], ], 'VocabularyFilterInfo' => [ 'base' => '<p>Provides information about a custom vocabulary filter, including the language of the filter, when it was last modified, and its name.</p>', 'refs' => [ 'VocabularyFilters$member' => NULL, ], ], 'VocabularyFilterMethod' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJobSettings$VocabularyFilterMethod' => '<p>Specify how you want your custom vocabulary filter applied to your transcript.</p> <p>To replace words with <code>***</code>, choose <code>mask</code>.</p> <p>To delete words, choose <code>remove</code>.</p> <p>To flag words without changing them, choose <code>tag</code>.</p>', 'MedicalScribeSettings$VocabularyFilterMethod' => '<p>Specify how you want your custom vocabulary filter applied to your transcript.</p> <p>To replace words with <code>***</code>, choose <code>mask</code>.</p> <p>To delete words, choose <code>remove</code>.</p> <p>To flag words without changing them, choose <code>tag</code>.</p>', 'Settings$VocabularyFilterMethod' => '<p>Specify how you want your custom vocabulary filter applied to your transcript.</p> <p>To replace words with <code>***</code>, choose <code>mask</code>.</p> <p>To delete words, choose <code>remove</code>.</p> <p>To flag words without changing them, choose <code>tag</code>.</p>', ], ], 'VocabularyFilterName' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJobSettings$VocabularyFilterName' => '<p>The name of the custom vocabulary filter you want to include in your Call Analytics transcription request. Custom vocabulary filter names are case sensitive.</p> <p>Note that if you include <code>VocabularyFilterName</code> in your request, you must also include <code>VocabularyFilterMethod</code>.</p>', 'CreateVocabularyFilterRequest$VocabularyFilterName' => '<p>A unique name, chosen by you, for your new custom vocabulary filter.</p> <p>This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new custom vocabulary filter with the same name as an existing custom vocabulary filter, you get a <code>ConflictException</code> error.</p>', 'CreateVocabularyFilterResponse$VocabularyFilterName' => '<p>The name you chose for your custom vocabulary filter.</p>', 'DeleteVocabularyFilterRequest$VocabularyFilterName' => '<p>The name of the custom vocabulary filter you want to delete. Custom vocabulary filter names are case sensitive.</p>', 'GetVocabularyFilterRequest$VocabularyFilterName' => '<p>The name of the custom vocabulary filter you want information about. Custom vocabulary filter names are case sensitive.</p>', 'GetVocabularyFilterResponse$VocabularyFilterName' => '<p>The name of the custom vocabulary filter you requested information about.</p>', 'LanguageIdSettings$VocabularyFilterName' => '<p>The name of the custom vocabulary filter you want to use when processing your transcription job. Custom vocabulary filter names are case sensitive.</p> <p>The language of the specified custom vocabulary filter must match the language code that you specify in your transcription request. If the languages do not match, the custom vocabulary filter isn\'t applied. There are no errors or warnings associated with a language mismatch.</p> <p>Note that if you include <code>VocabularyFilterName</code> in your request, you must also include <code>VocabularyFilterMethod</code>.</p>', 'ListVocabularyFiltersRequest$NameContains' => '<p>Returns only the custom vocabulary filters that contain the specified string. The search is not case sensitive.</p>', 'MedicalScribeSettings$VocabularyFilterName' => '<p>The name of the custom vocabulary filter you want to include in your Medical Scribe request. Custom vocabulary filter names are case sensitive.</p> <p>Note that if you include <code>VocabularyFilterName</code> in your request, you must also include <code>VocabularyFilterMethod</code>.</p>', 'Settings$VocabularyFilterName' => '<p>The name of the custom vocabulary filter you want to use in your transcription job request. This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.</p> <p>Note that if you include <code>VocabularyFilterName</code> in your request, you must also include <code>VocabularyFilterMethod</code>.</p>', 'UpdateVocabularyFilterRequest$VocabularyFilterName' => '<p>The name of the custom vocabulary filter you want to update. Custom vocabulary filter names are case sensitive.</p>', 'UpdateVocabularyFilterResponse$VocabularyFilterName' => '<p>The name of the updated custom vocabulary filter.</p>', 'VocabularyFilterInfo$VocabularyFilterName' => '<p>A unique name, chosen by you, for your custom vocabulary filter. This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.</p>', ], ], 'VocabularyFilters' => [ 'base' => NULL, 'refs' => [ 'ListVocabularyFiltersResponse$VocabularyFilters' => '<p>Provides information about the custom vocabulary filters that match the criteria specified in your request.</p>', ], ], 'VocabularyInfo' => [ 'base' => '<p>Provides information about a custom vocabulary, including the language of the custom vocabulary, when it was last modified, its name, and the processing state.</p>', 'refs' => [ 'Vocabularies$member' => NULL, ], ], 'VocabularyName' => [ 'base' => NULL, 'refs' => [ 'CallAnalyticsJobSettings$VocabularyName' => '<p>The name of the custom vocabulary you want to include in your Call Analytics transcription request. Custom vocabulary names are case sensitive.</p>', 'CreateMedicalVocabularyRequest$VocabularyName' => '<p>A unique name, chosen by you, for your new custom medical vocabulary.</p> <p>This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new custom medical vocabulary with the same name as an existing custom medical vocabulary, you get a <code>ConflictException</code> error.</p>', 'CreateMedicalVocabularyResponse$VocabularyName' => '<p>The name you chose for your custom medical vocabulary.</p>', 'CreateVocabularyRequest$VocabularyName' => '<p>A unique name, chosen by you, for your new custom vocabulary.</p> <p>This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account. If you try to create a new custom vocabulary with the same name as an existing custom vocabulary, you get a <code>ConflictException</code> error.</p>', 'CreateVocabularyResponse$VocabularyName' => '<p>The name you chose for your custom vocabulary.</p>', 'DeleteMedicalVocabularyRequest$VocabularyName' => '<p>The name of the custom medical vocabulary you want to delete. Custom medical vocabulary names are case sensitive.</p>', 'DeleteVocabularyRequest$VocabularyName' => '<p>The name of the custom vocabulary you want to delete. Custom vocabulary names are case sensitive.</p>', 'GetMedicalVocabularyRequest$VocabularyName' => '<p>The name of the custom medical vocabulary you want information about. Custom medical vocabulary names are case sensitive.</p>', 'GetMedicalVocabularyResponse$VocabularyName' => '<p>The name of the custom medical vocabulary you requested information about.</p>', 'GetVocabularyRequest$VocabularyName' => '<p>The name of the custom vocabulary you want information about. Custom vocabulary names are case sensitive.</p>', 'GetVocabularyResponse$VocabularyName' => '<p>The name of the custom vocabulary you requested information about.</p>', 'LanguageIdSettings$VocabularyName' => '<p>The name of the custom vocabulary you want to use when processing your transcription job. Custom vocabulary names are case sensitive.</p> <p>The language of the specified custom vocabulary must match the language code that you specify in your transcription request. If the languages do not match, the custom vocabulary isn\'t applied. There are no errors or warnings associated with a language mismatch.</p>', 'ListMedicalVocabulariesRequest$NameContains' => '<p>Returns only the custom medical vocabularies that contain the specified string. The search is not case sensitive.</p>', 'ListVocabulariesRequest$NameContains' => '<p>Returns only the custom vocabularies that contain the specified string. The search is not case sensitive.</p>', 'MedicalScribeSettings$VocabularyName' => '<p>The name of the custom vocabulary you want to include in your Medical Scribe request. Custom vocabulary names are case sensitive.</p>', 'MedicalTranscriptionSetting$VocabularyName' => '<p>The name of the custom vocabulary you want to use when processing your medical transcription job. Custom vocabulary names are case sensitive.</p> <p>The language of the specified custom vocabulary must match the language code that you specify in your transcription request. If the languages do not match, the custom vocabulary isn\'t applied. There are no errors or warnings associated with a language mismatch. US English (<code>en-US</code>) is the only valid language for Amazon Transcribe Medical.</p>', 'Settings$VocabularyName' => '<p>The name of the custom vocabulary you want to use in your transcription job request. This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.</p>', 'UpdateMedicalVocabularyRequest$VocabularyName' => '<p>The name of the custom medical vocabulary you want to update. Custom medical vocabulary names are case sensitive.</p>', 'UpdateMedicalVocabularyResponse$VocabularyName' => '<p>The name of the updated custom medical vocabulary.</p>', 'UpdateVocabularyRequest$VocabularyName' => '<p>The name of the custom vocabulary you want to update. Custom vocabulary names are case sensitive.</p>', 'UpdateVocabularyResponse$VocabularyName' => '<p>The name of the updated custom vocabulary.</p>', 'VocabularyInfo$VocabularyName' => '<p>A unique name, chosen by you, for your custom vocabulary. This name is case sensitive, cannot contain spaces, and must be unique within an Amazon Web Services account.</p>', ], ], 'VocabularyState' => [ 'base' => NULL, 'refs' => [ 'CreateMedicalVocabularyResponse$VocabularyState' => '<p>The processing state of your custom medical vocabulary. If the state is <code>READY</code>, you can use the custom vocabulary in a <code>StartMedicalTranscriptionJob</code> request.</p>', 'CreateVocabularyResponse$VocabularyState' => '<p>The processing state of your custom vocabulary. If the state is <code>READY</code>, you can use the custom vocabulary in a <code>StartTranscriptionJob</code> request.</p>', 'GetMedicalVocabularyResponse$VocabularyState' => '<p>The processing state of your custom medical vocabulary. If the state is <code>READY</code>, you can use the custom vocabulary in a <code>StartMedicalTranscriptionJob</code> request.</p>', 'GetVocabularyResponse$VocabularyState' => '<p>The processing state of your custom vocabulary. If the state is <code>READY</code>, you can use the custom vocabulary in a <code>StartTranscriptionJob</code> request.</p>', 'ListMedicalVocabulariesRequest$StateEquals' => '<p>Returns only custom medical vocabularies with the specified state. Custom vocabularies are ordered by creation date, with the newest vocabulary first. If you do not include <code>StateEquals</code>, all custom medical vocabularies are returned.</p>', 'ListMedicalVocabulariesResponse$Status' => '<p>Lists all custom medical vocabularies that have the status specified in your request. Custom vocabularies are ordered by creation date, with the newest vocabulary first.</p>', 'ListVocabulariesRequest$StateEquals' => '<p>Returns only custom vocabularies with the specified state. Vocabularies are ordered by creation date, with the newest vocabulary first. If you do not include <code>StateEquals</code>, all custom medical vocabularies are returned.</p>', 'ListVocabulariesResponse$Status' => '<p>Lists all custom vocabularies that have the status specified in your request. Vocabularies are ordered by creation date, with the newest vocabulary first.</p>', 'UpdateMedicalVocabularyResponse$VocabularyState' => '<p>The processing state of your custom medical vocabulary. If the state is <code>READY</code>, you can use the custom vocabulary in a <code>StartMedicalTranscriptionJob</code> request.</p>', 'UpdateVocabularyResponse$VocabularyState' => '<p>The processing state of your custom vocabulary. If the state is <code>READY</code>, you can use the custom vocabulary in a <code>StartTranscriptionJob</code> request.</p>', 'VocabularyInfo$VocabularyState' => '<p>The processing state of your custom vocabulary. If the state is <code>READY</code>, you can use the custom vocabulary in a <code>StartTranscriptionJob</code> request.</p>', ], ], 'Word' => [ 'base' => NULL, 'refs' => [ 'Words$member' => NULL, ], ], 'Words' => [ 'base' => NULL, 'refs' => [ 'CreateVocabularyFilterRequest$Words' => '<p>Use this parameter if you want to create your custom vocabulary filter by including all desired terms, as comma-separated values, within your request. The other option for creating your vocabulary filter is to save your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file using the <code>VocabularyFilterFileUri</code> parameter.</p> <p>Note that if you include <code>Words</code> in your request, you cannot use <code>VocabularyFilterFileUri</code>; you must choose one or the other.</p> <p>Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary filter request fails. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a> to get the character set for your language.</p>', 'UpdateVocabularyFilterRequest$Words' => '<p>Use this parameter if you want to update your custom vocabulary filter by including all desired terms, as comma-separated values, within your request. The other option for updating your vocabulary filter is to save your entries in a text file and upload them to an Amazon S3 bucket, then specify the location of your file using the <code>VocabularyFilterFileUri</code> parameter.</p> <p>Note that if you include <code>Words</code> in your request, you cannot use <code>VocabularyFilterFileUri</code>; you must choose one or the other.</p> <p>Each language has a character set that contains all allowed characters for that specific language. If you use unsupported characters, your custom vocabulary filter request fails. Refer to <a href="https://docs.aws.amazon.com/transcribe/latest/dg/charsets.html">Character Sets for Custom Vocabularies</a> to get the character set for your language.</p>', ], ], ],];
